(*                            -*- Mode: Modula-3 -*- 
 * 
 * For information about this program, contact Blair MacIntyre            
 * (bm@cs.columbia.edu) or Steven Feiner (feiner@cs.columbia.edu)         
 * at the Computer Science Dept., Columbia University,                    
 * 1214 Amsterdam Ave. Mailstop 0401, New York, NY, 10027.                
 *                                                                        
 * Copyright (C) 1995, 1996 by The Trustees of Columbia University in the 
 * City of New York.  Blair MacIntyre, Computer Science Department.       
 * See file COPYRIGHT-COLUMBIA for details.
 * 
 * Author          : Tobias Hoellerer (htobias)
 * Created On      : Fri Nov 10 17:37:04 EST 1995
 * Last Modified By: Blair MacIntyre
 * Last Modified On: Thu Sep 25 09:12:54 1997
 * Update Count    : 18
 * 
 * $Source: /usr/cvs/cm3/m3-comm/sharedobjgen/src/SOxCodeUtils.m3,v $
 * $Date: 2001/12/03 17:23:37 $
 * $Author: wagner $
 * $Revision: 1.2 $
 * 
 * $Log: SOxCodeUtils.m3,v $
 * Revision 1.2  2001/12/03 17:23:37  wagner
 * add copyright notes and overrides
 *
 * added: sharedobjgen/COPYRIGHT
 * added: sharedobjgen/COPYRIGHT-COLUMBIA
 * added: sharedobjgen/src/COPYRIGHT-COLUMBIA
 * added: sharedobjgen/src/m3overrides
 * modified: sharedobjgen/src/SOxCodeFiles.i3
 * modified: sharedobjgen/src/SOxCodeFiles.m3
 * modified: sharedobjgen/src/SOxCodeGenError.i3
 * modified: sharedobjgen/src/SOxCodeGenError.m3
 * modified: sharedobjgen/src/SOxCodeUtils.i3
 * modified: sharedobjgen/src/SOxCodeUtils.m3
 * modified: sharedobjgen/src/SOxCoder.i3
 * modified: sharedobjgen/src/SOxDummyCode.i3
 * modified: sharedobjgen/src/SOxDummyCode.m3
 * modified: sharedobjgen/src/SOxIntfCBCode.i3
 * modified: sharedobjgen/src/SOxIntfCBCode.m3
 * modified: sharedobjgen/src/SOxIntfCBProxyCode.i3
 * modified: sharedobjgen/src/SOxIntfCBProxyCode.m3
 * modified: sharedobjgen/src/SOxIntfPklCode.i3
 * modified: sharedobjgen/src/SOxIntfPklCode.m3
 * modified: sharedobjgen/src/SOxIntfProxyCode.i3
 * modified: sharedobjgen/src/SOxIntfProxyCode.m3
 * modified: sharedobjgen/src/SOxModuleCBCode.i3
 * modified: sharedobjgen/src/SOxModuleCBCode.m3
 * modified: sharedobjgen/src/SOxModuleProxyCode.i3
 * modified: sharedobjgen/src/SOxModuleProxyCode.m3
 * modified: sharedobjgen/src/SOxModuleSOCode.i3
 * modified: sharedobjgen/src/SOxModuleSOCode.m3
 * modified: sharedobjgen/src/StubGenTool.i3
 * modified: sharedobjgen/src/StubGenTool.m3
 *
 * Revision 1.1.1.1  2001/12/02 13:15:54  wagner
 * Blair MacIntyre's sharedobjgen package
 *
 * Revision 1.5  1997/10/22 14:45:10  bm
 * Bug fix.  Naming conflicts.
 *
 * Revision 1.4  1997/08/11 20:36:30  bm
 * Various fixes
 *
 * 
 * HISTORY
 *)

(* Based on GenTypeCode.m3 from the stablegen package       *)
(*                                                          *)
(* Copyright (C) 1989, Digital Equipment Corporation         *)
(* All rights reserved.                                      *)
(* See the file COPYRIGHT for a full description.            *)
(* Created by Susan Owicki                                   *)
(* Last modified on Wed Sep 28 12:03:12 PDT 1994 by weich    *)

(* The module provides code producing procedures for the stub
   generator. *)

MODULE SOxCodeUtils;

IMPORT Atom, Wr, Formatter, Type, SOxCodeFiles, Time, FmtTime,
       Stdio, Params;

<*FATAL Wr.Failure*>

VAR stubchatter: Wr.T;

(* ====== *)

PROCEDURE SetPerfMon(flag: BOOLEAN) =
  BEGIN
    perfMon := flag;
  END SetPerfMon;

PROCEDURE SetObliqCode(flag: BOOLEAN) =
  BEGIN
    genObliqCode := flag;
  END SetObliqCode; 

PROCEDURE SetProxyCode(flag: BOOLEAN) =
  BEGIN
    genProxyCode := flag;
  END SetProxyCode; 

(* ====== *)

PROCEDURE Message(text: TEXT) =
  BEGIN
    Wr.PutText(stubchatter, Params.Get(0) & ": " & text & "\n")
  END Message;

(* ====== *)

PROCEDURE HeaderComment(writer: Formatter.T; fileName: TEXT) =
  BEGIN
    Formatter.PutText(writer,"(***************************************" &
      "******************************\n");
    Formatter.PutText(writer," * " & fileName & "\n");
    Formatter.PutText(writer," * DO NOT EDIT --> generated by " & 
      Params.Get(0) & "\n");
    Formatter.PutText(writer," *                 " & FmtTime.Long(Time.Now()) & "\n");   
    Formatter.PutText(writer," ***************************************" &
      "******************************)\n\n");
  END HeaderComment;

(* ====== *)

PROCEDURE FileName(baseName: TEXT; filetype: SOxCodeFiles.T): TEXT =
  VAR typ : TEXT;
  BEGIN

    CASE filetype OF
    | SOxCodeFiles.T.CB_I3, SOxCodeFiles.T.CB_M3 => 
      typ := "CB";
    | SOxCodeFiles.T.PRX_I3 => 
      typ := "Proxy";
    | SOxCodeFiles.T.CBPRX_I3 => 
      typ := "CBProxy";
    | SOxCodeFiles.T.SO_M3 =>
      typ := "SO";
    | SOxCodeFiles.T.PKL_I3 =>
      typ := "Pickle";
    | SOxCodeFiles.T.OB_I3, SOxCodeFiles.T.OB_M3 =>
      baseName := "Ob" & baseName; typ := "";
    | SOxCodeFiles.T.OBCB_I3, SOxCodeFiles.T.OBCB_M3 =>
      baseName := "Ob" & baseName; typ := "CB";
    | SOxCodeFiles.T.OB_OBL, SOxCodeFiles.T.OB_HLP =>
      typ := "";
    | SOxCodeFiles.T.OBCB_OBL, SOxCodeFiles.T.OBCB_HLP =>
      typ := "CB";
    ELSE
      typ := ""; 
    END;

    RETURN baseName & typ;
  END FileName;

(* ====== *)

PROCEDURE FileExtension(filetype: SOxCodeFiles.T): TEXT =
  BEGIN
    CASE filetype OF
    | SOxCodeFiles.T.CB_I3, SOxCodeFiles.T.OB_I3, 
      SOxCodeFiles.T.OBCB_I3, SOxCodeFiles.T.PRX_I3,
      SOxCodeFiles.T.CBPRX_I3, SOxCodeFiles.T.PKL_I3 => RETURN ".i3";
    | SOxCodeFiles.T.CB_M3, SOxCodeFiles.T.SO_M3, SOxCodeFiles.T.OB_M3, 
      SOxCodeFiles.T.OBCB_M3  => RETURN ".m3";
    | SOxCodeFiles.T.OB_OBL, SOxCodeFiles.T.OBCB_OBL =>  RETURN ".obl";
    | SOxCodeFiles.T.OB_HLP, SOxCodeFiles.T.OBCB_HLP => RETURN ".hlp";
    ELSE
      RETURN "";
    END;
  END FileExtension;

(* ====== *)

PROCEDURE DoFile(filetype: SOxCodeFiles.T): BOOLEAN =
  BEGIN
    CASE filetype OF
    | SOxCodeFiles.T.CB_I3, SOxCodeFiles.T.CBPRX_I3, SOxCodeFiles.T.CB_M3, 
      SOxCodeFiles.T.SO_M3, SOxCodeFiles.T.PKL_I3  => RETURN TRUE;
    | SOxCodeFiles.T.PRX_I3 => RETURN genProxyCode;
    | SOxCodeFiles.T.OB_I3, SOxCodeFiles.T.OBCB_I3,
      SOxCodeFiles.T.OB_OBL, SOxCodeFiles.T.OBCB_OBL,
      SOxCodeFiles.T.OB_HLP, SOxCodeFiles.T.OBCB_HLP,
      SOxCodeFiles.T.OB_M3, SOxCodeFiles.T.OBCB_M3 => RETURN genObliqCode;
    ELSE
      RETURN FALSE;
    END;
  END DoFile; 

(* ====== *)

PROCEDURE BaseName(type: Type.Qid): TEXT =
  BEGIN
    RETURN  Atom.ToText(type.intf);
    (* & "_v" & Fmt.Int(Protocol.Version); *)
  END BaseName;

BEGIN
  stubchatter := Stdio.stderr;
END SOxCodeUtils.
