# Copyright (C) 2004 Scott W. Dunlop <sdunlop at users.sourceforge.net>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

from urllib import quote_plus as uriquote
from urllib import unquote_plus as uriunquote
from weakref import WeakValueDictionary
from sets import Set
from difflib import Differ
from cStringIO import StringIO

from errors import *
from html import parse_hazeml, normalize, htmlquote

import time

def changes_between( v1, v2 ):
    index = 0

    for line in Differ( ).compare(  # We would supply a junker, but it isn't
        v1.splitlines(), v2.splitlines() # used. The API lies, as of py2.3
    ):
        index += 1
        op = line[0]
        
        if op in '+-' : yield ( op, index, line[2:] )

class Node( object ):
    __slots__ = ( 
        'wiki', 
        'key', 'content', 'creation', 'modification', 'creator', 'modifier',
        'contentHtml', 'contentLinks'
    )
    
    DefaultContent = "This node has not been written, yet."
    
    def __init__( 
        self, wiki, key, content = None, 
        creation = None, creator = '',  
        modification = None, modifier = '', 
    ):
        self.wiki = wiki
        self.key = key
        
        self.content = content
        self.contentHtml = None
        self.contentLinks = None

        self.creation = creation
        self.creator = creator
        
        self.modification = modification
        self.modifier = modifier
    
    def getCreation( self ):
        return self.creation
        
    def getModification( self ):
        return self.modification
        
    def getCreator( self ):
        return self.creator
        
    def getModifier( self ):
        return self.modifier
             
    def getReferences( self ):
        return self.getDatabase().fetchReferencesTo( self.getKey() )
        
    def getKey( self ):
        return self.key
    
    def getWiki( self ):
        return self.wiki
        
    def getDatabase( self ):
        return self.getWiki().getDatabase()
        
    def getContent( self ):
        return self.content
    
    def setContent( self, content, user = '' ):
        if self.content is None:
            if content is not None:
                self.contentCreated( content, user )
        else:
            self.contentChanged( content, user )
        
        self.contentHtml = None
        self.contentLinks = None
    
    def contentCreated( self, newContent, user = '' ):
        db = self.getDatabase()

        self.creator = user
        self.creation = db.getServerTime()
        
        self.content = newContent
        db.nodeContentCreated( self )
        
    def contentChanged( self, newContent, user = '' ):
        db = self.getDatabase()
        time = db.getServerTime()

        self.modifier = user
        self.modification = time
        
        for op, index, line in changes_between( 
            self.content, newContent 
        ):
            db.addChange( self.getKey(), index, op, line, time, user)
            
        self.content = newContent
        db.nodeContentChanged( self )
                
    def parseContent( self, content = None ):
        content = self.content  #TODO: Why is this here?
        if content:    
            self.contentHtml, self.contentLinks = parse_hazeml( 
                self.getWiki(), content 
            )    
        
            self.getDatabase().storeHtml( 
                self.getKey(), self.contentHtml 
            )
        else:
            self.contentHtml = "<i>This node has no content.</i>"
            self.contentLinks = []
    
    def setModification( self, modification, modifier = '' ):
        self.modification = modification
        self.modifier = modifier
        
    def getContentHtml( self ):
        if self.contentHtml is None: 
            if self.getContent() is not None:
                self.contentHtml = self.getDatabase().fetchHtml( 
                    self.getKey() 
                )
            
            if self.contentHtml is None:
                self.parseContent( )
                
        return self.contentHtml
        
    def getContentLinks( self ):
        if self.contentLinks is None: self.parseContent()
        return self.contentLinks
    
    def getChanges( self, cutoff = 259200 ): # Defaults to 72 hours.
        return self.getDatabase().getChanges( self.getKey(), cutoff )
        
