# Copyright (C) 2004 Scott W. Dunlop <swdunlop at users.sourceforge.net>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

from exceptions import KeyError, Exception

class CloudError( Exception ):
    StrTemplate = (
        "An inexplicable error has occurred while processing your request."
    )
    
    HtmlTemplate = (
        "<HTML><HEAD><STYLE>" +
        "H4 {color: red;}" +
        "</STYLE><HEAD><BODY><H4>" +
        "An inexplicable error has occurred while processing your "
        "request." + 
        "</H4></BODY></HTML>"
    )
    
    httpCode = 500
    
    def __init__( self, **kwargs ):
        self.context = kwargs
        
        Exception.__init__( self, self.StrTemplate % kwargs )

    def asHtml( self ):
        return self.HtmlTemplate % self.context

class UnauthorizedAccess( CloudError ):
    TextTemplate = ( "You are not permitted access to %(action)s %(query)s." )
    
    HtmlTemplate = (
        "<HTML><HEAD><STYLE>" +
        "H4 {color: red;}" +
        "</STYLE><HEAD><BODY><H4>" +
        "You are not permitted access to %(action)s %(query)s." + 
        "</H4><P>" +
        "This wiki employs user authentication. You must login to perform " +
        "certain operations on this wiki." +
        "</P></BODY></HTML>"
    )

    httpCode = 403

class InvalidRequestError( CloudError ):
    TextTemplate = (
        "The following URI is an invalid request for this server: %(request)s"
    )
    
    HtmlTemplate = (
        "<HTML><HEAD><STYLE>" +
        "H4 {color: red;}" +
        "</STYLE><HEAD><BODY><H4>" +
        "'%(request)s' is an invalid request for this server." + 
        "</H4><P>" +
        "Generally, this error is the result of an outdated link referring " +
        "this server, especially after the server has had a significant " +
        "software revision." +
        "</P></BODY></HTML>"
    )
    
    httpCode = 400
    
class PostWithoutLengthError( CloudError ):
    TextTemplate = (
        "The following POST URI was not accompanied by a content length header: %(request)s" 
    )
    
    HtmlTemplate = (
        "<HTML><HEAD><STYLE>" +
        "H4 {color: red;}" +
        "</STYLE><HEAD><BODY><H4>" +
        "%(request)s was not accompanied by a content-length when posted " + 
        "to this server." +
        "</H4><P>" +
        "This normally indicates a badly formed request by your HTTP "
        "client." +
        "</P></BODY></HTML>"
    )        
    
    httpCode = 400 

class MissingContent( CloudError ):
    TextTemplate = (
        "The following POST URI was missing its content payload: %(request)s" 
    )
    
    HtmlTemplate = (
        "<HTML><HEAD><STYLE>" +
        "H4 {color: red;}" +
        "</STYLE><HEAD><BODY><H4>" +
        "The following POST URI was missing its content payload: "
        "%(request)s." +
        "</H4><P>" +
        "This normally indicates a badly formed request by your HTTP "
        "client." +
        "</P></BODY></HTML>"
    )        
    
    httpCode = 400 

class IHateFavicons( CloudError ):
    httpCode = 404
        
