#define _CFFI_USE_EMBEDDING
#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

#define _CFFI_MODULE_NAME  "_clingo"
static const char _CFFI_PYTHON_STARTUP_CODE[] = {
// # NB. this is not a string because of a size limit in MSVC
// 'import os\n
105,109,112,111,114,116,32,111,115,10,
// 'import sys\n
105,109,112,111,114,116,32,115,121,115,10,
// 'import clingo.script\n
105,109,112,111,114,116,32,99,108,105,110,103,111,46,115,99,114,105,112,116,
10,
// '\n
10,
// 'sys.path.insert(0, os.getcwd())\n
115,121,115,46,112,97,116,104,46,105,110,115,101,114,116,40,48,44,32,111,115,
46,103,101,116,99,119,100,40,41,41,10,
0 };
#ifdef PYPY_VERSION
# define _CFFI_PYTHON_STARTUP_FUNC  _cffi_pypyinit__clingo
#elif PY_MAJOR_VERSION >= 3
# define _CFFI_PYTHON_STARTUP_FUNC  PyInit__clingo
#else
# define _CFFI_PYTHON_STARTUP_FUNC  init_clingo
#endif

/***** Support code for embedding *****/

#ifdef __cplusplus
extern "C" {
#endif


#if defined(_WIN32)
#  define CFFI_DLLEXPORT  __declspec(dllexport)
#elif defined(__GNUC__)
#  define CFFI_DLLEXPORT  __attribute__((visibility("default")))
#else
#  define CFFI_DLLEXPORT  /* nothing */
#endif


/* There are two global variables of type _cffi_call_python_fnptr:

   * _cffi_call_python, which we declare just below, is the one called
     by ``extern "Python"`` implementations.

   * _cffi_call_python_org, which on CPython is actually part of the
     _cffi_exports[] array, is the function pointer copied from
     _cffi_backend.

   After initialization is complete, both are equal.  However, the
   first one remains equal to &_cffi_start_and_call_python until the
   very end of initialization, when we are (or should be) sure that
   concurrent threads also see a completely initialized world, and
   only then is it changed.
*/
#undef _cffi_call_python
typedef void (*_cffi_call_python_fnptr)(struct _cffi_externpy_s *, char *);
static void _cffi_start_and_call_python(struct _cffi_externpy_s *, char *);
static _cffi_call_python_fnptr _cffi_call_python = &_cffi_start_and_call_python;


#ifndef _MSC_VER
   /* --- Assuming a GCC not infinitely old --- */
# define cffi_compare_and_swap(l,o,n)  __sync_bool_compare_and_swap(l,o,n)
# define cffi_write_barrier()          __sync_synchronize()
# if !defined(__amd64__) && !defined(__x86_64__) &&   \
     !defined(__i386__) && !defined(__i386)
#   define cffi_read_barrier()         __sync_synchronize()
# else
#   define cffi_read_barrier()         (void)0
# endif
#else
   /* --- Windows threads version --- */
# include <Windows.h>
# define cffi_compare_and_swap(l,o,n) \
                               (InterlockedCompareExchangePointer(l,n,o) == (o))
# define cffi_write_barrier()       InterlockedCompareExchange(&_cffi_dummy,0,0)
# define cffi_read_barrier()           (void)0
static volatile LONG _cffi_dummy;
#endif

#ifdef WITH_THREAD
# ifndef _MSC_VER
#  include <pthread.h>
   static pthread_mutex_t _cffi_embed_startup_lock;
# else
   static CRITICAL_SECTION _cffi_embed_startup_lock;
# endif
  static char _cffi_embed_startup_lock_ready = 0;
#endif

static void _cffi_acquire_reentrant_mutex(void)
{
    static void *volatile lock = NULL;

    while (!cffi_compare_and_swap(&lock, NULL, (void *)1)) {
        /* should ideally do a spin loop instruction here, but
           hard to do it portably and doesn't really matter I
           think: pthread_mutex_init() should be very fast, and
           this is only run at start-up anyway. */
    }

#ifdef WITH_THREAD
    if (!_cffi_embed_startup_lock_ready) {
# ifndef _MSC_VER
        pthread_mutexattr_t attr;
        pthread_mutexattr_init(&attr);
        pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
        pthread_mutex_init(&_cffi_embed_startup_lock, &attr);
# else
        InitializeCriticalSection(&_cffi_embed_startup_lock);
# endif
        _cffi_embed_startup_lock_ready = 1;
    }
#endif

    while (!cffi_compare_and_swap(&lock, (void *)1, NULL))
        ;

#ifndef _MSC_VER
    pthread_mutex_lock(&_cffi_embed_startup_lock);
#else
    EnterCriticalSection(&_cffi_embed_startup_lock);
#endif
}

static void _cffi_release_reentrant_mutex(void)
{
#ifndef _MSC_VER
    pthread_mutex_unlock(&_cffi_embed_startup_lock);
#else
    LeaveCriticalSection(&_cffi_embed_startup_lock);
#endif
}


/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION

#ifndef CFFI_MESSAGEBOX
# ifdef _MSC_VER
#  define CFFI_MESSAGEBOX  1
# else
#  define CFFI_MESSAGEBOX  0
# endif
#endif


#if CFFI_MESSAGEBOX
/* Windows only: logic to take the Python-CFFI embedding logic
   initialization errors and display them in a background thread
   with MessageBox.  The idea is that if the whole program closes
   as a result of this problem, then likely it is already a console
   program and you can read the stderr output in the console too.
   If it is not a console program, then it will likely show its own
   dialog to complain, or generally not abruptly close, and for this
   case the background thread should stay alive.
*/
static void *volatile _cffi_bootstrap_text;

static PyObject *_cffi_start_error_capture(void)
{
    PyObject *result = NULL;
    PyObject *x, *m, *bi;

    if (InterlockedCompareExchangePointer(&_cffi_bootstrap_text,
            (void *)1, NULL) != NULL)
        return (PyObject *)1;

    m = PyImport_AddModule("_cffi_error_capture");
    if (m == NULL)
        goto error;

    result = PyModule_GetDict(m);
    if (result == NULL)
        goto error;

#if PY_MAJOR_VERSION >= 3
    bi = PyImport_ImportModule("builtins");
#else
    bi = PyImport_ImportModule("__builtin__");
#endif
    if (bi == NULL)
        goto error;
    PyDict_SetItemString(result, "__builtins__", bi);
    Py_DECREF(bi);

    x = PyRun_String(
        "import sys\n"
        "class FileLike:\n"
        "  def write(self, x):\n"
        "    try:\n"
        "      of.write(x)\n"
        "    except: pass\n"
        "    self.buf += x\n"
        "  def flush(self):\n"
        "    pass\n"
        "fl = FileLike()\n"
        "fl.buf = ''\n"
        "of = sys.stderr\n"
        "sys.stderr = fl\n"
        "def done():\n"
        "  sys.stderr = of\n"
        "  return fl.buf\n",   /* make sure the returned value stays alive */
        Py_file_input,
        result, result);
    Py_XDECREF(x);

 error:
    if (PyErr_Occurred())
    {
        PyErr_WriteUnraisable(Py_None);
        PyErr_Clear();
    }
    return result;
}

#pragma comment(lib, "user32.lib")

static DWORD WINAPI _cffi_bootstrap_dialog(LPVOID ignored)
{
    Sleep(666);    /* may be interrupted if the whole process is closing */
#if PY_MAJOR_VERSION >= 3
    MessageBoxW(NULL, (wchar_t *)_cffi_bootstrap_text,
                L"Python-CFFI error",
                MB_OK | MB_ICONERROR);
#else
    MessageBoxA(NULL, (char *)_cffi_bootstrap_text,
                "Python-CFFI error",
                MB_OK | MB_ICONERROR);
#endif
    _cffi_bootstrap_text = NULL;
    return 0;
}

static void _cffi_stop_error_capture(PyObject *ecap)
{
    PyObject *s;
    void *text;

    if (ecap == (PyObject *)1)
        return;

    if (ecap == NULL)
        goto error;

    s = PyRun_String("done()", Py_eval_input, ecap, ecap);
    if (s == NULL)
        goto error;

    /* Show a dialog box, but in a background thread, and
       never show multiple dialog boxes at once. */
#if PY_MAJOR_VERSION >= 3
    text = PyUnicode_AsWideCharString(s, NULL);
#else
    text = PyString_AsString(s);
#endif

    _cffi_bootstrap_text = text;

    if (text != NULL)
    {
        HANDLE h;
        h = CreateThread(NULL, 0, _cffi_bootstrap_dialog,
                         NULL, 0, NULL);
        if (h != NULL)
            CloseHandle(h);
    }
    /* decref the string, but it should stay alive as 'fl.buf'
       in the small module above.  It will really be freed only if
       we later get another similar error.  So it's a leak of at
       most one copy of the small module.  That's fine for this
       situation which is usually a "fatal error" anyway. */
    Py_DECREF(s);
    PyErr_Clear();
    return;

  error:
    _cffi_bootstrap_text = NULL;
    PyErr_Clear();
}

#else

static PyObject *_cffi_start_error_capture(void) { return NULL; }
static void _cffi_stop_error_capture(PyObject *ecap) { }

#endif


#define _cffi_call_python_org  _cffi_exports[_CFFI_CPIDX]

PyMODINIT_FUNC _CFFI_PYTHON_STARTUP_FUNC(void);   /* forward */

static void _cffi_py_initialize(void)
{
    /* XXX use initsigs=0, which "skips initialization registration of
       signal handlers, which might be useful when Python is
       embedded" according to the Python docs.  But review and think
       if it should be a user-controllable setting.

       XXX we should also give a way to write errors to a buffer
       instead of to stderr.

       XXX if importing 'site' fails, CPython (any version) calls
       exit().  Should we try to work around this behavior here?
    */
    Py_InitializeEx(0);
}

static int _cffi_initialize_python(void)
{
    /* This initializes Python, imports _cffi_backend, and then the
       present .dll/.so is set up as a CPython C extension module.
    */
    int result;
    PyGILState_STATE state;
    PyObject *pycode=NULL, *global_dict=NULL, *x;
    PyObject *builtins;

    state = PyGILState_Ensure();

    /* Call the initxxx() function from the present module.  It will
       create and initialize us as a CPython extension module, instead
       of letting the startup Python code do it---it might reimport
       the same .dll/.so and get maybe confused on some platforms.
       It might also have troubles locating the .dll/.so again for all
       I know.
    */
    (void)_CFFI_PYTHON_STARTUP_FUNC();
    if (PyErr_Occurred())
        goto error;

    /* Now run the Python code provided to ffi.embedding_init_code().
     */
    pycode = Py_CompileString(_CFFI_PYTHON_STARTUP_CODE,
                              "<init code for '" _CFFI_MODULE_NAME "'>",
                              Py_file_input);
    if (pycode == NULL)
        goto error;
    global_dict = PyDict_New();
    if (global_dict == NULL)
        goto error;
    builtins = PyEval_GetBuiltins();
    if (builtins == NULL)
        goto error;
    if (PyDict_SetItemString(global_dict, "__builtins__", builtins) < 0)
        goto error;
    x = PyEval_EvalCode(
#if PY_MAJOR_VERSION < 3
                        (PyCodeObject *)
#endif
                        pycode, global_dict, global_dict);
    if (x == NULL)
        goto error;
    Py_DECREF(x);

    /* Done!  Now if we've been called from
       _cffi_start_and_call_python() in an ``extern "Python"``, we can
       only hope that the Python code did correctly set up the
       corresponding @ffi.def_extern() function.  Otherwise, the
       general logic of ``extern "Python"`` functions (inside the
       _cffi_backend module) will find that the reference is still
       missing and print an error.
     */
    result = 0;
 done:
    Py_XDECREF(pycode);
    Py_XDECREF(global_dict);
    PyGILState_Release(state);
    return result;

 error:;
    {
        /* Print as much information as potentially useful.
           Debugging load-time failures with embedding is not fun
        */
        PyObject *ecap;
        PyObject *exception, *v, *tb, *f, *modules, *mod;
        PyErr_Fetch(&exception, &v, &tb);
        ecap = _cffi_start_error_capture();
        f = PySys_GetObject((char *)"stderr");
        if (f != NULL && f != Py_None) {
            PyFile_WriteString(
                "Failed to initialize the Python-CFFI embedding logic:\n\n", f);
        }

        if (exception != NULL) {
            PyErr_NormalizeException(&exception, &v, &tb);
            PyErr_Display(exception, v, tb);
        }
        Py_XDECREF(exception);
        Py_XDECREF(v);
        Py_XDECREF(tb);

        if (f != NULL && f != Py_None) {
            PyFile_WriteString("\nFrom: " _CFFI_MODULE_NAME
                               "\ncompiled with cffi version: 1.15.0"
                               "\n_cffi_backend module: ", f);
            modules = PyImport_GetModuleDict();
            mod = PyDict_GetItemString(modules, "_cffi_backend");
            if (mod == NULL) {
                PyFile_WriteString("not loaded", f);
            }
            else {
                v = PyObject_GetAttrString(mod, "__file__");
                PyFile_WriteObject(v, f, 0);
                Py_XDECREF(v);
            }
            PyFile_WriteString("\nsys.path: ", f);
            PyFile_WriteObject(PySys_GetObject((char *)"path"), f, 0);
            PyFile_WriteString("\n\n", f);
        }
        _cffi_stop_error_capture(ecap);
    }
    result = -1;
    goto done;
}

#if PY_VERSION_HEX < 0x03080000
PyAPI_DATA(char *) _PyParser_TokenNames[];  /* from CPython */
#endif

static int _cffi_carefully_make_gil(void)
{
    /* This does the basic initialization of Python.  It can be called
       completely concurrently from unrelated threads.  It assumes
       that we don't hold the GIL before (if it exists), and we don't
       hold it afterwards.

       (What it really does used to be completely different in Python 2
       and Python 3, with the Python 2 solution avoiding the spin-lock
       around the Py_InitializeEx() call.  However, after recent changes
       to CPython 2.7 (issue #358) it no longer works.  So we use the
       Python 3 solution everywhere.)

       This initializes Python by calling Py_InitializeEx().
       Important: this must not be called concurrently at all.
       So we use a global variable as a simple spin lock.  This global
       variable must be from 'libpythonX.Y.so', not from this
       cffi-based extension module, because it must be shared from
       different cffi-based extension modules.

       In Python < 3.8, we choose
       _PyParser_TokenNames[0] as a completely arbitrary pointer value
       that is never written to.  The default is to point to the
       string "ENDMARKER".  We change it temporarily to point to the
       next character in that string.  (Yes, I know it's REALLY
       obscure.)

       In Python >= 3.8, this string array is no longer writable, so
       instead we pick PyCapsuleType.tp_version_tag.  We can't change
       Python < 3.8 because someone might use a mixture of cffi
       embedded modules, some of which were compiled before this file
       changed.
    */

#ifdef WITH_THREAD
# if PY_VERSION_HEX < 0x03080000
    char *volatile *lock = (char *volatile *)_PyParser_TokenNames;
    char *old_value, *locked_value;

    while (1) {    /* spin loop */
        old_value = *lock;
        locked_value = old_value + 1;
        if (old_value[0] == 'E') {
            assert(old_value[1] == 'N');
            if (cffi_compare_and_swap(lock, old_value, locked_value))
                break;
        }
        else {
            assert(old_value[0] == 'N');
            /* should ideally do a spin loop instruction here, but
               hard to do it portably and doesn't really matter I
               think: PyEval_InitThreads() should be very fast, and
               this is only run at start-up anyway. */
        }
    }
# else
    int volatile *lock = (int volatile *)&PyCapsule_Type.tp_version_tag;
    int old_value, locked_value;
    assert(!(PyCapsule_Type.tp_flags & Py_TPFLAGS_HAVE_VERSION_TAG));

    while (1) {    /* spin loop */
        old_value = *lock;
        locked_value = -42;
        if (old_value == 0) {
            if (cffi_compare_and_swap(lock, old_value, locked_value))
                break;
        }
        else {
            assert(old_value == locked_value);
            /* should ideally do a spin loop instruction here, but
               hard to do it portably and doesn't really matter I
               think: PyEval_InitThreads() should be very fast, and
               this is only run at start-up anyway. */
        }
    }
# endif
#endif

    /* call Py_InitializeEx() */
    if (!Py_IsInitialized()) {
        _cffi_py_initialize();
#if PY_VERSION_HEX < 0x03070000
        PyEval_InitThreads();
#endif
        PyEval_SaveThread();  /* release the GIL */
        /* the returned tstate must be the one that has been stored into the
           autoTLSkey by _PyGILState_Init() called from Py_Initialize(). */
    }
    else {
#if PY_VERSION_HEX < 0x03070000
        /* PyEval_InitThreads() is always a no-op from CPython 3.7 */
        PyGILState_STATE state = PyGILState_Ensure();
        PyEval_InitThreads();
        PyGILState_Release(state);
#endif
    }

#ifdef WITH_THREAD
    /* release the lock */
    while (!cffi_compare_and_swap(lock, locked_value, old_value))
        ;
#endif

    return 0;
}

/**********  end CPython-specific section  **********/


#else


/**********  PyPy-specific section  **********/

PyMODINIT_FUNC _CFFI_PYTHON_STARTUP_FUNC(const void *[]);   /* forward */

static struct _cffi_pypy_init_s {
    const char *name;
    void *func;    /* function pointer */
    const char *code;
} _cffi_pypy_init = {
    _CFFI_MODULE_NAME,
    _CFFI_PYTHON_STARTUP_FUNC,
    _CFFI_PYTHON_STARTUP_CODE,
};

extern int pypy_carefully_make_gil(const char *);
extern int pypy_init_embedded_cffi_module(int, struct _cffi_pypy_init_s *);

static int _cffi_carefully_make_gil(void)
{
    return pypy_carefully_make_gil(_CFFI_MODULE_NAME);
}

static int _cffi_initialize_python(void)
{
    return pypy_init_embedded_cffi_module(0xB011, &_cffi_pypy_init);
}

/**********  end PyPy-specific section  **********/


#endif


#ifdef __GNUC__
__attribute__((noinline))
#endif
static _cffi_call_python_fnptr _cffi_start_python(void)
{
    /* Delicate logic to initialize Python.  This function can be
       called multiple times concurrently, e.g. when the process calls
       its first ``extern "Python"`` functions in multiple threads at
       once.  It can also be called recursively, in which case we must
       ignore it.  We also have to consider what occurs if several
       different cffi-based extensions reach this code in parallel
       threads---it is a different copy of the code, then, and we
       can't have any shared global variable unless it comes from
       'libpythonX.Y.so'.

       Idea:

       * _cffi_carefully_make_gil(): "carefully" call
         PyEval_InitThreads() (possibly with Py_InitializeEx() first).

       * then we use a (local) custom lock to make sure that a call to this
         cffi-based extension will wait if another call to the *same*
         extension is running the initialization in another thread.
         It is reentrant, so that a recursive call will not block, but
         only one from a different thread.

       * then we grab the GIL and (Python 2) we call Py_InitializeEx().
         At this point, concurrent calls to Py_InitializeEx() are not
         possible: we have the GIL.

       * do the rest of the specific initialization, which may
         temporarily release the GIL but not the custom lock.
         Only release the custom lock when we are done.
    */
    static char called = 0;

    if (_cffi_carefully_make_gil() != 0)
        return NULL;

    _cffi_acquire_reentrant_mutex();

    /* Here the GIL exists, but we don't have it.  We're only protected
       from concurrency by the reentrant mutex. */

    /* This file only initializes the embedded module once, the first
       time this is called, even if there are subinterpreters. */
    if (!called) {
        called = 1;  /* invoke _cffi_initialize_python() only once,
                        but don't set '_cffi_call_python' right now,
                        otherwise concurrent threads won't call
                        this function at all (we need them to wait) */
        if (_cffi_initialize_python() == 0) {
            /* now initialization is finished.  Switch to the fast-path. */

            /* We would like nobody to see the new value of
               '_cffi_call_python' without also seeing the rest of the
               data initialized.  However, this is not possible.  But
               the new value of '_cffi_call_python' is the function
               'cffi_call_python()' from _cffi_backend.  So:  */
            cffi_write_barrier();
            /* ^^^ we put a write barrier here, and a corresponding
               read barrier at the start of cffi_call_python().  This
               ensures that after that read barrier, we see everything
               done here before the write barrier.
            */

            assert(_cffi_call_python_org != NULL);
            _cffi_call_python = (_cffi_call_python_fnptr)_cffi_call_python_org;
        }
        else {
            /* initialization failed.  Reset this to NULL, even if it was
               already set to some other value.  Future calls to
               _cffi_start_python() are still forced to occur, and will
               always return NULL from now on. */
            _cffi_call_python_org = NULL;
        }
    }

    _cffi_release_reentrant_mutex();

    return (_cffi_call_python_fnptr)_cffi_call_python_org;
}

static
void _cffi_start_and_call_python(struct _cffi_externpy_s *externpy, char *args)
{
    _cffi_call_python_fnptr fnptr;
    int current_err = errno;
#ifdef _MSC_VER
    int current_lasterr = GetLastError();
#endif
    fnptr = _cffi_start_python();
    if (fnptr == NULL) {
        fprintf(stderr, "function %s() called, but initialization code "
                        "failed.  Returning 0.\n", externpy->name);
        memset(args, 0, externpy->size_of_result);
    }
#ifdef _MSC_VER
    SetLastError(current_lasterr);
#endif
    errno = current_err;

    if (fnptr != NULL)
        fnptr(externpy, args);
}


/* The cffi_start_python() function makes sure Python is initialized
   and our cffi module is set up.  It can be called manually from the
   user C code.  The same effect is obtained automatically from any
   dll-exported ``extern "Python"`` function.  This function returns
   -1 if initialization failed, 0 if all is OK.  */
_CFFI_UNUSED_FN
static int cffi_start_python(void)
{
    if (_cffi_call_python == &_cffi_start_and_call_python) {
        if (_cffi_start_python() == NULL)
            return -1;
    }
    cffi_read_barrier();
    return 0;
}

#undef cffi_compare_and_swap
#undef cffi_write_barrier
#undef cffi_read_barrier

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <clingo.h>
#ifdef CFFI_DLLEXPORT
#undef CFFI_DLLEXPORT
#define CFFI_DLLEXPORT
#endif
#ifdef PYPY_VERSION
void pyclingo_finalize() { }
#else
void pyclingo_finalize() {
    if (Py_IsInitialized()) {
        PyGILState_Ensure();
        Py_Finalize();
    }
}
#endif



/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(_Bool, uint32_t const *, size_t, int32_t const *, size_t, void *)
/*  1 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/*  2 */ _CFFI_OP(_CFFI_OP_POINTER, 69), // uint32_t const *
/*  3 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 12), // int32_t const *
/*  5 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 1316), // void *
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(_Bool, uint32_t const *, size_t, int32_t, clingo_weighted_literal_t const *, size_t, void *)
/*  9 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 11 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 12 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 1278), // clingo_weighted_literal_t const *
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(_Bool, void *)
/* 18 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const * const *, size_t, _Bool(*)(clingo_ast_t *, void *), void *, clingo_control_t *, void(*)(int, char const *, void *), void *, unsigned int)
/* 22 */ _CFFI_OP(_CFFI_OP_POINTER, 40), // char const * const *
/* 23 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 24 */ _CFFI_OP(_CFFI_OP_POINTER, 252), // _Bool(*)(clingo_ast_t *, void *)
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 26 */ _CFFI_OP(_CFFI_OP_POINTER, 1262), // clingo_control_t *
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 1200), // void(*)(int, char const *, void *)
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const * const *, size_t, void(*)(int, char const *, void *), void *, unsigned int, clingo_control_t * *)
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 33 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 37 */ _CFFI_OP(_CFFI_OP_POINTER, 26), // clingo_control_t * *
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, _Bool *, void *)
/* 40 */ _CFFI_OP(_CFFI_OP_POINTER, 1250), // char const *
/* 41 */ _CFFI_OP(_CFFI_OP_POINTER, 1), // _Bool *
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, _Bool(*)(clingo_ast_t *, void *), void *, clingo_control_t *, void(*)(int, char const *, void *), void *, unsigned int)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 51 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, _Bool, uint64_t *)
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 55 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 56 */ _CFFI_OP(_CFFI_OP_POINTER, 246), // uint64_t *
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, char const * *)
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 60 */ _CFFI_OP(_CFFI_OP_POINTER, 40), // char const * *
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, clingo_script_t const *, void *)
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 64 */ _CFFI_OP(_CFFI_OP_POINTER, 1272), // clingo_script_t const *
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, uint32_t, _Bool, uint64_t *)
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 71 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, uint64_t *)
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, uint64_t const *, size_t, _Bool, uint64_t *)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 79 */ _CFFI_OP(_CFFI_OP_POINTER, 246), // uint64_t const *
/* 80 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, void *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(char const *, void(*)(int, char const *, void *), void *, unsigned int, uint64_t *)
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *)
/* 96 */ _CFFI_OP(_CFFI_OP_POINTER, 1252), // clingo_assignment_t const *
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, int32_t)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 100 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, int32_t, _Bool *)
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, int32_t, int *)
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 110 */ _CFFI_OP(_CFFI_OP_POINTER, 155), // int *
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, int32_t, uint32_t *)
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 114 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 115 */ _CFFI_OP(_CFFI_OP_POINTER, 69), // uint32_t *
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, size_t, int32_t *)
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 119 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 120 */ _CFFI_OP(_CFFI_OP_POINTER, 12), // int32_t *
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, uint32_t *)
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, uint32_t, int32_t *)
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 128 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_assignment_t const *, uint32_t, uint32_t *)
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 133 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, char *, size_t)
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 1259), // clingo_ast_t *
/* 138 */ _CFFI_OP(_CFFI_OP_POINTER, 1250), // char *
/* 139 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, clingo_ast_t * *)
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 143 */ _CFFI_OP(_CFFI_OP_POINTER, 137), // clingo_ast_t * *
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, clingo_ast_t *)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int *)
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, _Bool *)
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 155 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, _Bool(*)(clingo_ast_t *, void *), void *)
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 160 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, char const * *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, char const *)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 171 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, clingo_ast_t * *)
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 176 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 143),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, clingo_ast_t *)
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 181 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, clingo_location_t *)
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 186 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 187 */ _CFFI_OP(_CFFI_OP_POINTER, 1264), // clingo_location_t *
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, clingo_location_t const *)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 191 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 192 */ _CFFI_OP(_CFFI_OP_POINTER, 1264), // clingo_location_t const *
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, int *)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 196 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, int)
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 201 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 202 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, size_t *)
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 206 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 207 */ _CFFI_OP(_CFFI_OP_POINTER, 3), // size_t *
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, size_t)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 211 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, size_t, char const * *)
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 216 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 217 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, size_t, char const *)
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 222 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 223 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, size_t, clingo_ast_t * *)
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 229 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 230 */ _CFFI_OP(_CFFI_OP_NOOP, 143),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, size_t, clingo_ast_t *)
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 234 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 235 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, uint64_t *)
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 240 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, int, uint64_t)
/* 244 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 245 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 246 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, size_t *)
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t *, void *)
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_ast_t const *, void *)
/* 257 */ _CFFI_OP(_CFFI_OP_POINTER, 1259), // clingo_ast_t const *
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *)
/* 261 */ _CFFI_OP(_CFFI_OP_POINTER, 1260), // clingo_backend_t *
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, _Bool, uint32_t const *, size_t, int32_t const *, size_t)
/* 264 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 265 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 268 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 269 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, _Bool, uint32_t const *, size_t, int32_t, clingo_weighted_literal_t const *, size_t)
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 273 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 275 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 277 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 279 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, char const *, uint32_t *)
/* 281 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, char const *, uint32_t const *, size_t, uint32_t *)
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 287 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 288 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 289 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, int, int, int32_t const *, size_t)
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 294 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 295 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 296 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 297 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, int, uint32_t *)
/* 300 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 301 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 303 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, int, uint32_t const *, size_t, uint32_t *)
/* 305 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 306 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 307 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 308 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, int32_t const *, size_t)
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 313 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 316 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, int32_t, clingo_weighted_literal_t const *, size_t)
/* 317 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 318 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 320 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint32_t const *, size_t)
/* 323 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 324 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 325 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 327 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint32_t const *, size_t, int32_t const *, size_t, uint32_t *)
/* 328 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 329 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 330 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 331 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 332 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 333 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 334 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint32_t, int)
/* 336 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 338 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 340 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint32_t, int, int, unsigned int, int32_t const *, size_t)
/* 341 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 342 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 343 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 344 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 345 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 346 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 347 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 349 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint32_t, uint32_t, uint32_t const *, size_t, char const *, uint32_t, uint32_t *)
/* 350 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 351 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 352 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 354 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 355 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 357 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 359 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint32_t, uint32_t, uint32_t const *, size_t, uint32_t *)
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 361 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 362 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 364 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 365 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 366 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 367 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint64_t *, uint32_t *)
/* 368 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 369 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 370 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_backend_t *, uint64_t, uint32_t *)
/* 373 */ _CFFI_OP(_CFFI_OP_NOOP, 261),
/* 374 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 375 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 376 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t *, uint32_t, char const *)
/* 378 */ _CFFI_OP(_CFFI_OP_POINTER, 1261), // clingo_configuration_t *
/* 379 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 380 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 381 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 382 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t *)
/* 383 */ _CFFI_OP(_CFFI_OP_POINTER, 1261), // clingo_configuration_t const *
/* 384 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 385 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, _Bool *)
/* 387 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 388 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 389 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 390 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 391 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, char *, size_t)
/* 392 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 393 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 394 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 395 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 396 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 397 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, char const * *)
/* 398 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 399 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 400 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 401 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 402 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, char const *, _Bool *)
/* 403 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 404 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 405 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 407 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 408 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, char const *, uint32_t *)
/* 409 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 410 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 411 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 412 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 413 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 414 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, size_t *)
/* 415 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 416 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 417 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 418 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 419 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, size_t, char const * *)
/* 420 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 421 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 422 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 423 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 424 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 425 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, size_t, uint32_t *)
/* 426 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 428 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 429 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 430 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 431 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_configuration_t const *, uint32_t, unsigned int *)
/* 432 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 433 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 434 */ _CFFI_OP(_CFFI_OP_POINTER, 29), // unsigned int *
/* 435 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 436 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *)
/* 437 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 438 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 439 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, _Bool)
/* 440 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 441 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 442 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 443 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, char const * const *, size_t, void *)
/* 444 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 445 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 446 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 447 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 448 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 449 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, char const *)
/* 450 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 451 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 452 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 453 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, char const *, char const * const *, size_t, char const *)
/* 454 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 455 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 456 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 457 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 458 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 460 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, clingo_backend_t * *)
/* 461 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 462 */ _CFFI_OP(_CFFI_OP_POINTER, 261), // clingo_backend_t * *
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 464 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, clingo_configuration_t * *)
/* 465 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 466 */ _CFFI_OP(_CFFI_OP_POINTER, 378), // clingo_configuration_t * *
/* 467 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 468 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, clingo_ground_program_observer_t const *, _Bool, void *)
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 470 */ _CFFI_OP(_CFFI_OP_POINTER, 1263), // clingo_ground_program_observer_t const *
/* 471 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 472 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 473 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, clingo_part_t const *, size_t, _Bool(*)(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *), void *)
/* 475 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 476 */ _CFFI_OP(_CFFI_OP_POINTER, 1267), // clingo_part_t const *
/* 477 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 478 */ _CFFI_OP(_CFFI_OP_POINTER, 565), // _Bool(*)(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *)
/* 479 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 480 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 481 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, clingo_program_builder_t * *)
/* 482 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 483 */ _CFFI_OP(_CFFI_OP_POINTER, 672), // clingo_program_builder_t * *
/* 484 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 485 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, clingo_propagator_t const *, void *, _Bool)
/* 486 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 487 */ _CFFI_OP(_CFFI_OP_POINTER, 1271), // clingo_propagator_t const *
/* 488 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 489 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 490 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 491 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, int32_t)
/* 492 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 493 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 494 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 495 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, int32_t, int)
/* 496 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 497 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 498 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 499 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 500 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, unsigned int, int32_t const *, size_t, _Bool(*)(unsigned int, void *, void *, _Bool *), void *, clingo_solve_handle_t * *)
/* 501 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 502 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 503 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 504 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 505 */ _CFFI_OP(_CFFI_OP_POINTER, 1084), // _Bool(*)(unsigned int, void *, void *, _Bool *)
/* 506 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 507 */ _CFFI_OP(_CFFI_OP_POINTER, 778), // clingo_solve_handle_t * *
/* 508 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 509 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, void * *)
/* 510 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 511 */ _CFFI_OP(_CFFI_OP_POINTER, 6), // void * *
/* 512 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 513 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t *, void *)
/* 514 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 515 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 516 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 517 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t const *)
/* 518 */ _CFFI_OP(_CFFI_OP_POINTER, 1262), // clingo_control_t const *
/* 519 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 520 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t const *, char const *, _Bool *)
/* 521 */ _CFFI_OP(_CFFI_OP_NOOP, 518),
/* 522 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 523 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 524 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t const *, char const *, uint64_t *)
/* 526 */ _CFFI_OP(_CFFI_OP_NOOP, 518),
/* 527 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 528 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 529 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 530 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t const *, clingo_statistics_t const * *)
/* 531 */ _CFFI_OP(_CFFI_OP_NOOP, 518),
/* 532 */ _CFFI_OP(_CFFI_OP_POINTER, 812), // clingo_statistics_t const * *
/* 533 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 534 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t const *, clingo_symbolic_atoms_t const * *)
/* 535 */ _CFFI_OP(_CFFI_OP_NOOP, 518),
/* 536 */ _CFFI_OP(_CFFI_OP_POINTER, 855), // clingo_symbolic_atoms_t const * *
/* 537 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 538 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_control_t const *, clingo_theory_atoms_t const * *)
/* 539 */ _CFFI_OP(_CFFI_OP_NOOP, 518),
/* 540 */ _CFFI_OP(_CFFI_OP_POINTER, 894), // clingo_theory_atoms_t const * *
/* 541 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 542 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_location_t *, char const *, void *)
/* 543 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 544 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 545 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 546 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 547 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_location_t *, char const *, void *, size_t, void *, void *, void *)
/* 548 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 549 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 550 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 551 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 552 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 553 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 554 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 555 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 556 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_location_t const *, char const *, uint64_t const *, size_t, _Bool(*)(uint64_t const *, size_t, void *), void *, void *)
/* 557 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 558 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 559 */ _CFFI_OP(_CFFI_OP_NOOP, 79),
/* 560 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 561 */ _CFFI_OP(_CFFI_OP_POINTER, 1035), // _Bool(*)(uint64_t const *, size_t, void *)
/* 562 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 563 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 564 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 565 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *)
/* 566 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 568 */ _CFFI_OP(_CFFI_OP_NOOP, 79),
/* 569 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 571 */ _CFFI_OP(_CFFI_OP_NOOP, 561),
/* 572 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 573 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 574 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_location_t const *, char const *, void *)
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 576 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 577 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 579 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t *, uint64_t const *, size_t)
/* 580 */ _CFFI_OP(_CFFI_OP_POINTER, 1265), // clingo_model_t *
/* 581 */ _CFFI_OP(_CFFI_OP_NOOP, 79),
/* 582 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 583 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 584 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, _Bool *)
/* 585 */ _CFFI_OP(_CFFI_OP_POINTER, 1265), // clingo_model_t const *
/* 586 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 587 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 588 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, _Bool(*)(void *), void *, void *)
/* 589 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 590 */ _CFFI_OP(_CFFI_OP_POINTER, 1090), // _Bool(*)(void *)
/* 591 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 592 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 593 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 594 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, clingo_solve_control_t * *)
/* 595 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 596 */ _CFFI_OP(_CFFI_OP_POINTER, 769), // clingo_solve_control_t * *
/* 597 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 598 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, int *)
/* 599 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 600 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 601 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 602 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, int32_t *, size_t)
/* 603 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 604 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 605 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 606 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 607 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, int32_t, _Bool *)
/* 608 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 609 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 610 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 611 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 612 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, int32_t, int *)
/* 613 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 614 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 615 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 616 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 617 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, int64_t *, size_t)
/* 618 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 619 */ _CFFI_OP(_CFFI_OP_POINTER, 1312), // int64_t *
/* 620 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 621 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 622 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, size_t *)
/* 623 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 624 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 625 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 626 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, uint32_t *)
/* 627 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 628 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 629 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 630 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, uint64_t *)
/* 631 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 632 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 633 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 634 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, uint64_t, _Bool *)
/* 635 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 636 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 637 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 638 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 639 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, unsigned int, size_t *)
/* 640 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 641 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 642 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 643 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 644 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_model_t const *, unsigned int, uint64_t *, size_t)
/* 645 */ _CFFI_OP(_CFFI_OP_NOOP, 585),
/* 646 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 647 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 648 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 649 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 650 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_options_t *, char const *, char const *, char const *, _Bool *)
/* 651 */ _CFFI_OP(_CFFI_OP_POINTER, 1266), // clingo_options_t *
/* 652 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 653 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 654 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 655 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 656 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 657 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_options_t *, char const *, char const *, char const *, _Bool(*)(char const *, void *), void *, _Bool, char const *)
/* 658 */ _CFFI_OP(_CFFI_OP_NOOP, 651),
/* 659 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 660 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 661 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 662 */ _CFFI_OP(_CFFI_OP_POINTER, 84), // _Bool(*)(char const *, void *)
/* 663 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 664 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 665 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 666 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 667 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_options_t *, void *)
/* 668 */ _CFFI_OP(_CFFI_OP_NOOP, 651),
/* 669 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 670 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 671 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_program_builder_t *)
/* 672 */ _CFFI_OP(_CFFI_OP_POINTER, 1268), // clingo_program_builder_t *
/* 673 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 674 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_program_builder_t *, clingo_ast_t *)
/* 675 */ _CFFI_OP(_CFFI_OP_NOOP, 672),
/* 676 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 677 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 678 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t *, _Bool *)
/* 679 */ _CFFI_OP(_CFFI_OP_POINTER, 1269), // clingo_propagate_control_t *
/* 680 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 681 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 682 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t *, int32_t *)
/* 683 */ _CFFI_OP(_CFFI_OP_NOOP, 679),
/* 684 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 685 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 686 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t *, int32_t const *, size_t, int, _Bool *)
/* 687 */ _CFFI_OP(_CFFI_OP_NOOP, 679),
/* 688 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 689 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 690 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 691 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 692 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 693 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t *, int32_t const *, size_t, void *)
/* 694 */ _CFFI_OP(_CFFI_OP_NOOP, 679),
/* 695 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 696 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 697 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 698 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 699 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t *, int32_t)
/* 700 */ _CFFI_OP(_CFFI_OP_NOOP, 679),
/* 701 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 702 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 703 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t *, void *)
/* 704 */ _CFFI_OP(_CFFI_OP_NOOP, 679),
/* 705 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 706 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 707 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_control_t const *, int32_t)
/* 708 */ _CFFI_OP(_CFFI_OP_POINTER, 1269), // clingo_propagate_control_t const *
/* 709 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 710 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 711 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, _Bool *)
/* 712 */ _CFFI_OP(_CFFI_OP_POINTER, 1270), // clingo_propagate_init_t *
/* 713 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 714 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 715 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, _Bool, int32_t *)
/* 716 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 717 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 718 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 719 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 720 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, int32_t const *, size_t, _Bool *)
/* 721 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 722 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 723 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 724 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 725 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 726 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, int32_t)
/* 727 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 728 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 729 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 730 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, int32_t, clingo_weighted_literal_t const *, size_t, int32_t, int, _Bool, _Bool *)
/* 731 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 732 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 733 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 734 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 735 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 736 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 737 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 738 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 739 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 740 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, int32_t, int32_t, int32_t)
/* 741 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 742 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 743 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 744 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 745 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 746 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, int32_t, uint32_t)
/* 747 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 748 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 749 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 750 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 751 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t *, void *)
/* 752 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 753 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 754 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 755 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t const *, clingo_symbolic_atoms_t const * *)
/* 756 */ _CFFI_OP(_CFFI_OP_POINTER, 1270), // clingo_propagate_init_t const *
/* 757 */ _CFFI_OP(_CFFI_OP_NOOP, 536),
/* 758 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 759 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t const *, clingo_theory_atoms_t const * *)
/* 760 */ _CFFI_OP(_CFFI_OP_NOOP, 756),
/* 761 */ _CFFI_OP(_CFFI_OP_NOOP, 540),
/* 762 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 763 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_propagate_init_t const *, int32_t, int32_t *)
/* 764 */ _CFFI_OP(_CFFI_OP_NOOP, 756),
/* 765 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 766 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 767 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 768 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_solve_control_t *, int32_t const *, size_t)
/* 769 */ _CFFI_OP(_CFFI_OP_POINTER, 1273), // clingo_solve_control_t *
/* 770 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 771 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 772 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 773 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_solve_control_t const *, clingo_symbolic_atoms_t const * *)
/* 774 */ _CFFI_OP(_CFFI_OP_POINTER, 1273), // clingo_solve_control_t const *
/* 775 */ _CFFI_OP(_CFFI_OP_NOOP, 536),
/* 776 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 777 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_solve_handle_t *)
/* 778 */ _CFFI_OP(_CFFI_OP_POINTER, 1274), // clingo_solve_handle_t *
/* 779 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 780 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_solve_handle_t *, clingo_model_t const * *)
/* 781 */ _CFFI_OP(_CFFI_OP_NOOP, 778),
/* 782 */ _CFFI_OP(_CFFI_OP_POINTER, 585), // clingo_model_t const * *
/* 783 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 784 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_solve_handle_t *, int32_t const * *, size_t *)
/* 785 */ _CFFI_OP(_CFFI_OP_NOOP, 778),
/* 786 */ _CFFI_OP(_CFFI_OP_POINTER, 4), // int32_t const * *
/* 787 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 788 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 789 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_solve_handle_t *, unsigned int *)
/* 790 */ _CFFI_OP(_CFFI_OP_NOOP, 778),
/* 791 */ _CFFI_OP(_CFFI_OP_NOOP, 434),
/* 792 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 793 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t *, uint64_t, char const *, int, uint64_t *)
/* 794 */ _CFFI_OP(_CFFI_OP_POINTER, 1275), // clingo_statistics_t *
/* 795 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 796 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 797 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 798 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 799 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 800 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t *, uint64_t, double)
/* 801 */ _CFFI_OP(_CFFI_OP_NOOP, 794),
/* 802 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 803 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 804 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 805 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t *, uint64_t, int, uint64_t *)
/* 806 */ _CFFI_OP(_CFFI_OP_NOOP, 794),
/* 807 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 808 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 809 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 810 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 811 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t *)
/* 812 */ _CFFI_OP(_CFFI_OP_POINTER, 1275), // clingo_statistics_t const *
/* 813 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 814 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 815 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, char const *, _Bool *)
/* 816 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 817 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 818 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 819 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 820 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 821 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, char const *, uint64_t *)
/* 822 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 823 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 824 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 825 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 826 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 827 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, double *)
/* 828 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 829 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 830 */ _CFFI_OP(_CFFI_OP_POINTER, 803), // double *
/* 831 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 832 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, int *)
/* 833 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 834 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 835 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 836 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 837 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, size_t *)
/* 838 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 839 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 840 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 841 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 842 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, size_t, char const * *)
/* 843 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 844 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 845 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 846 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 847 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 848 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_statistics_t const *, uint64_t, size_t, uint64_t *)
/* 849 */ _CFFI_OP(_CFFI_OP_NOOP, 812),
/* 850 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 851 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 852 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 853 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 854 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, size_t *)
/* 855 */ _CFFI_OP(_CFFI_OP_POINTER, 1276), // clingo_symbolic_atoms_t const *
/* 856 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 857 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 858 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t *)
/* 859 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 860 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 861 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 862 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t *, size_t)
/* 863 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 864 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 865 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 866 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 867 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t const *, uint64_t *)
/* 868 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 869 */ _CFFI_OP(_CFFI_OP_NOOP, 79),
/* 870 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 871 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 872 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t, _Bool *)
/* 873 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 874 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 875 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 876 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 877 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t, int32_t *)
/* 878 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 879 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 880 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 881 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 882 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t, uint64_t *)
/* 883 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 884 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 885 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 886 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 887 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_symbolic_atoms_t const *, uint64_t, uint64_t, _Bool *)
/* 888 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 889 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 890 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 891 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 892 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 893 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, size_t *)
/* 894 */ _CFFI_OP(_CFFI_OP_POINTER, 1277), // clingo_theory_atoms_t const *
/* 895 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 896 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 897 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, _Bool *)
/* 898 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 899 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 900 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 901 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 902 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, char *, size_t)
/* 903 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 904 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 905 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 906 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 907 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 908 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, char const * *)
/* 909 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 910 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 911 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 912 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 913 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, char const * *, uint32_t *)
/* 914 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 915 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 916 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 917 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 918 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 919 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, int *)
/* 920 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 921 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 922 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 923 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 924 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, int32_t *)
/* 925 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 926 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 927 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 928 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 929 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, int32_t const * *, size_t *)
/* 930 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 931 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 932 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 933 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 934 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 935 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, size_t *)
/* 936 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 937 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 938 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 939 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 940 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, uint32_t *)
/* 941 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 942 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 943 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 944 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 945 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(clingo_theory_atoms_t const *, uint32_t, uint32_t const * *, size_t *)
/* 946 */ _CFFI_OP(_CFFI_OP_NOOP, 894),
/* 947 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 948 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // uint32_t const * *
/* 949 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 950 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 951 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(int, clingo_ast_t * *, ...)
/* 952 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 953 */ _CFFI_OP(_CFFI_OP_NOOP, 143),
/* 954 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 955 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(int, int, int32_t const *, size_t, void *)
/* 956 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 957 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 958 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 959 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 960 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 961 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 962 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(int32_t const *, size_t, void *)
/* 963 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 964 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 965 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 966 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 967 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(int32_t, clingo_weighted_literal_t const *, size_t, void *)
/* 968 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 969 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 970 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 971 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 972 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 973 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t const *, size_t, void *)
/* 974 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 975 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 976 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 977 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 978 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, char const *, void *)
/* 979 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 980 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 981 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 982 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 983 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, clingo_assignment_t const *, int32_t, void *, int32_t *)
/* 984 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 985 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 986 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 987 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 988 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 989 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 990 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, int, int, unsigned int, int32_t const *, size_t, void *)
/* 991 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 992 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 993 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 994 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 995 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 996 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 997 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 998 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 999 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, int, uint32_t const *, size_t, void *)
/* 1000 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1001 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1002 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 1003 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1004 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1005 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1006 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, int, void *)
/* 1007 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1008 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1009 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1010 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1011 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, uint32_t const *, size_t, int32_t const *, size_t, void *)
/* 1012 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1013 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 1014 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1015 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1016 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1017 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1018 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1019 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, uint32_t, uint32_t const *, size_t, uint32_t, uint32_t, void *)
/* 1020 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1021 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1022 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 1023 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1024 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1025 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1026 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1027 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1028 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint32_t, uint32_t, uint32_t const *, size_t, void *)
/* 1029 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1030 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1031 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 1032 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1033 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1034 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1035 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t const *, size_t, void *)
/* 1036 */ _CFFI_OP(_CFFI_OP_NOOP, 79),
/* 1037 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1038 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1039 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1040 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t)
/* 1041 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1042 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1043 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, _Bool *)
/* 1044 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1045 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 1046 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1047 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, char *, size_t)
/* 1048 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1049 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 1050 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1051 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1052 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, char const * *)
/* 1053 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1054 */ _CFFI_OP(_CFFI_OP_NOOP, 60),
/* 1055 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1056 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, int *)
/* 1057 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1058 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1059 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1060 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, int32_t const *, size_t, void *)
/* 1061 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1062 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1063 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1064 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1065 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1066 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, size_t *)
/* 1067 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1068 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 1069 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1070 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, uint32_t, void *)
/* 1071 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1072 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1073 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1074 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1075 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, uint64_t const * *, size_t *)
/* 1076 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1077 */ _CFFI_OP(_CFFI_OP_POINTER, 79), // uint64_t const * *
/* 1078 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 1079 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1080 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(uint64_t, uint64_t)
/* 1081 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1082 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1083 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1084 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(unsigned int, void *, void *, _Bool *)
/* 1085 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1086 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1087 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1088 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 1089 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1090 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(void *)
/* 1091 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1092 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1093 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(void *, char const *, void *)
/* 1094 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1095 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 1096 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1097 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1098 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(void *, char const *, void *, size_t, void *, void *, void *)
/* 1099 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1100 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 1101 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1102 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1103 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1104 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1105 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // _Bool()(void *, void *)
/* 1108 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1109 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // char const *()(char const *)
/* 1112 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 1113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // char const *()(int)
/* 1115 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1116 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1117 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // char const *()(uint64_t)
/* 1118 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // char const *()(void *)
/* 1121 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // char const *()(void)
/* 1124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 96), // clingo_assignment_t const *()(clingo_propagate_control_t const *)
/* 1126 */ _CFFI_OP(_CFFI_OP_NOOP, 708),
/* 1127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 96), // clingo_assignment_t const *()(clingo_propagate_init_t const *)
/* 1129 */ _CFFI_OP(_CFFI_OP_NOOP, 756),
/* 1130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 155), // int()(clingo_application_t *, char const * const *, size_t, void *)
/* 1132 */ _CFFI_OP(_CFFI_OP_POINTER, 1251), // clingo_application_t *
/* 1133 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 1134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1135 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 155), // int()(clingo_propagate_init_t const *)
/* 1138 */ _CFFI_OP(_CFFI_OP_NOOP, 756),
/* 1139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 155), // int()(uint64_t)
/* 1141 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1142 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1143 */ _CFFI_OP(_CFFI_OP_FUNCTION, 155), // int()(void)
/* 1144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // size_t()(clingo_assignment_t const *)
/* 1146 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 1147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // size_t()(clingo_ast_t *)
/* 1149 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 1150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // size_t()(uint64_t)
/* 1152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // uint32_t()(clingo_assignment_t const *)
/* 1155 */ _CFFI_OP(_CFFI_OP_NOOP, 96),
/* 1156 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1157 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // uint32_t()(clingo_propagate_control_t const *)
/* 1158 */ _CFFI_OP(_CFFI_OP_NOOP, 708),
/* 1159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // uint32_t()(uint64_t)
/* 1161 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1162 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1163 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // unsigned int()(void *)
/* 1164 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1165 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1166 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(clingo_ast_t *)
/* 1167 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 1168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(clingo_control_t *)
/* 1170 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 1171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(clingo_propagate_control_t *, int32_t)
/* 1173 */ _CFFI_OP(_CFFI_OP_NOOP, 679),
/* 1174 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(clingo_propagate_control_t const *, int32_t const *, size_t, void *)
/* 1177 */ _CFFI_OP(_CFFI_OP_NOOP, 708),
/* 1178 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1180 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(clingo_propagate_init_t *, int)
/* 1183 */ _CFFI_OP(_CFFI_OP_NOOP, 712),
/* 1184 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(clingo_solve_handle_t *, double, _Bool *)
/* 1187 */ _CFFI_OP(_CFFI_OP_NOOP, 778),
/* 1188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1189 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 1190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(int *, int *, int *)
/* 1192 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1193 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1194 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1195 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1196 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(int, char const *)
/* 1197 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1198 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 1199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(int, char const *, void *)
/* 1201 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1202 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 1203 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(int, uint64_t *)
/* 1206 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1207 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 1208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(uint64_t *)
/* 1210 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 1211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1316), // void()(void *)
/* 1213 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 1214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1215 */ _CFFI_OP(_CFFI_OP_POINTER, 0), // _Bool(*)(_Bool, uint32_t const *, size_t, int32_t const *, size_t, void *)
/* 1216 */ _CFFI_OP(_CFFI_OP_POINTER, 8), // _Bool(*)(_Bool, uint32_t const *, size_t, int32_t, clingo_weighted_literal_t const *, size_t, void *)
/* 1217 */ _CFFI_OP(_CFFI_OP_POINTER, 17), // _Bool(*)(_Bool, void *)
/* 1218 */ _CFFI_OP(_CFFI_OP_POINTER, 39), // _Bool(*)(char const *, _Bool *, void *)
/* 1219 */ _CFFI_OP(_CFFI_OP_POINTER, 256), // _Bool(*)(clingo_ast_t const *, void *)
/* 1220 */ _CFFI_OP(_CFFI_OP_POINTER, 443), // _Bool(*)(clingo_control_t *, char const * const *, size_t, void *)
/* 1221 */ _CFFI_OP(_CFFI_OP_POINTER, 513), // _Bool(*)(clingo_control_t *, void *)
/* 1222 */ _CFFI_OP(_CFFI_OP_POINTER, 542), // _Bool(*)(clingo_location_t *, char const *, void *)
/* 1223 */ _CFFI_OP(_CFFI_OP_POINTER, 547), // _Bool(*)(clingo_location_t *, char const *, void *, size_t, void *, void *, void *)
/* 1224 */ _CFFI_OP(_CFFI_OP_POINTER, 556), // _Bool(*)(clingo_location_t const *, char const *, uint64_t const *, size_t, _Bool(*)(uint64_t const *, size_t, void *), void *, void *)
/* 1225 */ _CFFI_OP(_CFFI_OP_POINTER, 574), // _Bool(*)(clingo_location_t const *, char const *, void *)
/* 1226 */ _CFFI_OP(_CFFI_OP_POINTER, 588), // _Bool(*)(clingo_model_t const *, _Bool(*)(void *), void *, void *)
/* 1227 */ _CFFI_OP(_CFFI_OP_POINTER, 667), // _Bool(*)(clingo_options_t *, void *)
/* 1228 */ _CFFI_OP(_CFFI_OP_POINTER, 693), // _Bool(*)(clingo_propagate_control_t *, int32_t const *, size_t, void *)
/* 1229 */ _CFFI_OP(_CFFI_OP_POINTER, 703), // _Bool(*)(clingo_propagate_control_t *, void *)
/* 1230 */ _CFFI_OP(_CFFI_OP_POINTER, 751), // _Bool(*)(clingo_propagate_init_t *, void *)
/* 1231 */ _CFFI_OP(_CFFI_OP_POINTER, 951), // _Bool(*)(int, clingo_ast_t * *, ...)
/* 1232 */ _CFFI_OP(_CFFI_OP_POINTER, 955), // _Bool(*)(int, int, int32_t const *, size_t, void *)
/* 1233 */ _CFFI_OP(_CFFI_OP_POINTER, 962), // _Bool(*)(int32_t const *, size_t, void *)
/* 1234 */ _CFFI_OP(_CFFI_OP_POINTER, 967), // _Bool(*)(int32_t, clingo_weighted_literal_t const *, size_t, void *)
/* 1235 */ _CFFI_OP(_CFFI_OP_POINTER, 973), // _Bool(*)(uint32_t const *, size_t, void *)
/* 1236 */ _CFFI_OP(_CFFI_OP_POINTER, 978), // _Bool(*)(uint32_t, char const *, void *)
/* 1237 */ _CFFI_OP(_CFFI_OP_POINTER, 983), // _Bool(*)(uint32_t, clingo_assignment_t const *, int32_t, void *, int32_t *)
/* 1238 */ _CFFI_OP(_CFFI_OP_POINTER, 990), // _Bool(*)(uint32_t, int, int, unsigned int, int32_t const *, size_t, void *)
/* 1239 */ _CFFI_OP(_CFFI_OP_POINTER, 999), // _Bool(*)(uint32_t, int, uint32_t const *, size_t, void *)
/* 1240 */ _CFFI_OP(_CFFI_OP_POINTER, 1006), // _Bool(*)(uint32_t, int, void *)
/* 1241 */ _CFFI_OP(_CFFI_OP_POINTER, 1011), // _Bool(*)(uint32_t, uint32_t const *, size_t, int32_t const *, size_t, void *)
/* 1242 */ _CFFI_OP(_CFFI_OP_POINTER, 1019), // _Bool(*)(uint32_t, uint32_t, uint32_t const *, size_t, uint32_t, uint32_t, void *)
/* 1243 */ _CFFI_OP(_CFFI_OP_POINTER, 1028), // _Bool(*)(uint32_t, uint32_t, uint32_t const *, size_t, void *)
/* 1244 */ _CFFI_OP(_CFFI_OP_POINTER, 1060), // _Bool(*)(uint64_t, int32_t const *, size_t, void *)
/* 1245 */ _CFFI_OP(_CFFI_OP_POINTER, 1070), // _Bool(*)(uint64_t, uint32_t, void *)
/* 1246 */ _CFFI_OP(_CFFI_OP_POINTER, 1093), // _Bool(*)(void *, char const *, void *)
/* 1247 */ _CFFI_OP(_CFFI_OP_POINTER, 1098), // _Bool(*)(void *, char const *, void *, size_t, void *, void *, void *)
/* 1248 */ _CFFI_OP(_CFFI_OP_POINTER, 1107), // _Bool(*)(void *, void *)
/* 1249 */ _CFFI_OP(_CFFI_OP_POINTER, 1120), // char const *(*)(void *)
/* 1250 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 1251 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // clingo_application_t
/* 1252 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // clingo_assignment_t
/* 1253 */ _CFFI_OP(_CFFI_OP_POINTER, 1254), // clingo_ast_argument_t const *
/* 1254 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // clingo_ast_argument_t
/* 1255 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // clingo_ast_attribute_names_t
/* 1256 */ _CFFI_OP(_CFFI_OP_POINTER, 1257), // clingo_ast_constructor_t const *
/* 1257 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // clingo_ast_constructor_t
/* 1258 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // clingo_ast_constructors_t
/* 1259 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // clingo_ast_t
/* 1260 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // clingo_backend_t
/* 1261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // clingo_configuration_t
/* 1262 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // clingo_control_t
/* 1263 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // clingo_ground_program_observer_t
/* 1264 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // clingo_location_t
/* 1265 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // clingo_model_t
/* 1266 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // clingo_options_t
/* 1267 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // clingo_part_t
/* 1268 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // clingo_program_builder_t
/* 1269 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // clingo_propagate_control_t
/* 1270 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // clingo_propagate_init_t
/* 1271 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // clingo_propagator_t
/* 1272 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // clingo_script_t
/* 1273 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // clingo_solve_control_t
/* 1274 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // clingo_solve_handle_t
/* 1275 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // clingo_statistics_t
/* 1276 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // clingo_symbolic_atoms_t
/* 1277 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // clingo_theory_atoms_t
/* 1278 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // clingo_weighted_literal_t
/* 1279 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum clingo_ast_aggregate_function_e
/* 1280 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum clingo_ast_attribute_e
/* 1281 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum clingo_ast_attribute_type_e
/* 1282 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum clingo_ast_binary_operator_e
/* 1283 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum clingo_ast_comparison_operator_e
/* 1284 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // enum clingo_ast_sign_e
/* 1285 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // enum clingo_ast_theory_atom_definition_type_e
/* 1286 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // enum clingo_ast_theory_operator_type_e
/* 1287 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // enum clingo_ast_theory_sequence_type_e
/* 1288 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // enum clingo_ast_type_e
/* 1289 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // enum clingo_ast_unary_operator_e
/* 1290 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // enum clingo_ast_unpool_type_e
/* 1291 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // enum clingo_clause_type_e
/* 1292 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // enum clingo_comment_type_e
/* 1293 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // enum clingo_configuration_type_e
/* 1294 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // enum clingo_consequence_e
/* 1295 */ _CFFI_OP(_CFFI_OP_ENUM, 16), // enum clingo_error_e
/* 1296 */ _CFFI_OP(_CFFI_OP_ENUM, 17), // enum clingo_external_type_e
/* 1297 */ _CFFI_OP(_CFFI_OP_ENUM, 18), // enum clingo_heuristic_type_e
/* 1298 */ _CFFI_OP(_CFFI_OP_ENUM, 19), // enum clingo_model_type_e
/* 1299 */ _CFFI_OP(_CFFI_OP_ENUM, 20), // enum clingo_propagator_check_mode_e
/* 1300 */ _CFFI_OP(_CFFI_OP_ENUM, 21), // enum clingo_propagator_undo_mode_e
/* 1301 */ _CFFI_OP(_CFFI_OP_ENUM, 22), // enum clingo_show_type_e
/* 1302 */ _CFFI_OP(_CFFI_OP_ENUM, 23), // enum clingo_solve_event_type_e
/* 1303 */ _CFFI_OP(_CFFI_OP_ENUM, 24), // enum clingo_solve_mode_e
/* 1304 */ _CFFI_OP(_CFFI_OP_ENUM, 25), // enum clingo_solve_result_e
/* 1305 */ _CFFI_OP(_CFFI_OP_ENUM, 26), // enum clingo_statistics_type_e
/* 1306 */ _CFFI_OP(_CFFI_OP_ENUM, 27), // enum clingo_symbol_type_e
/* 1307 */ _CFFI_OP(_CFFI_OP_ENUM, 28), // enum clingo_theory_sequence_type_e
/* 1308 */ _CFFI_OP(_CFFI_OP_ENUM, 29), // enum clingo_theory_term_type_e
/* 1309 */ _CFFI_OP(_CFFI_OP_ENUM, 30), // enum clingo_truth_value_e
/* 1310 */ _CFFI_OP(_CFFI_OP_ENUM, 31), // enum clingo_warning_e
/* 1311 */ _CFFI_OP(_CFFI_OP_ENUM, 32), // enum clingo_weight_constraint_type_e
/* 1312 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 1313 */ _CFFI_OP(_CFFI_OP_POINTER, 1163), // unsigned int(*)(void *)
/* 1314 */ _CFFI_OP(_CFFI_OP_POINTER, 1176), // void(*)(clingo_propagate_control_t const *, int32_t const *, size_t, void *)
/* 1315 */ _CFFI_OP(_CFFI_OP_POINTER, 1212), // void(*)(void *)
/* 1316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static struct _cffi_externpy_s _cffi_externpy__pyclingo_call =
  { "_clingo.pyclingo_call", (int)sizeof(_Bool), 0, 0 };

CFFI_DLLEXPORT _Bool pyclingo_call(void * a0, char const * a1, void * a2, size_t a3, void * a4, void * a5, void * a6)
{
  char a[56];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  *(void * *)(p + 48) = a6;
  _cffi_call_python(&_cffi_externpy__pyclingo_call, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_callable =
  { "_clingo.pyclingo_callable", (int)sizeof(_Bool), 0, 0 };

CFFI_DLLEXPORT _Bool pyclingo_callable(char const * a0, _Bool * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(_Bool * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_callable, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_execute =
  { "_clingo.pyclingo_execute", (int)sizeof(_Bool), 0, 0 };

CFFI_DLLEXPORT _Bool pyclingo_execute(void * a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_execute, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_main =
  { "_clingo.pyclingo_main", (int)sizeof(_Bool), 0, 0 };

CFFI_DLLEXPORT _Bool pyclingo_main(void * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_main, p);
  return *(_Bool *)p;
}

static int _cffi_const_clingo_ast_aggregate_function_count(unsigned long long *o)
{
  int n = (clingo_ast_aggregate_function_count) <= 0;
  *o = (unsigned long long)((clingo_ast_aggregate_function_count) | 0);  /* check that clingo_ast_aggregate_function_count is an integer */
  return n;
}

static int _cffi_const_clingo_ast_aggregate_function_sum(unsigned long long *o)
{
  int n = (clingo_ast_aggregate_function_sum) <= 0;
  *o = (unsigned long long)((clingo_ast_aggregate_function_sum) | 0);  /* check that clingo_ast_aggregate_function_sum is an integer */
  return n;
}

static int _cffi_const_clingo_ast_aggregate_function_sump(unsigned long long *o)
{
  int n = (clingo_ast_aggregate_function_sump) <= 0;
  *o = (unsigned long long)((clingo_ast_aggregate_function_sump) | 0);  /* check that clingo_ast_aggregate_function_sump is an integer */
  return n;
}

static int _cffi_const_clingo_ast_aggregate_function_min(unsigned long long *o)
{
  int n = (clingo_ast_aggregate_function_min) <= 0;
  *o = (unsigned long long)((clingo_ast_aggregate_function_min) | 0);  /* check that clingo_ast_aggregate_function_min is an integer */
  return n;
}

static int _cffi_const_clingo_ast_aggregate_function_max(unsigned long long *o)
{
  int n = (clingo_ast_aggregate_function_max) <= 0;
  *o = (unsigned long long)((clingo_ast_aggregate_function_max) | 0);  /* check that clingo_ast_aggregate_function_max is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_argument(unsigned long long *o)
{
  int n = (clingo_ast_attribute_argument) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_argument) | 0);  /* check that clingo_ast_attribute_argument is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_arguments(unsigned long long *o)
{
  int n = (clingo_ast_attribute_arguments) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_arguments) | 0);  /* check that clingo_ast_attribute_arguments is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_arity(unsigned long long *o)
{
  int n = (clingo_ast_attribute_arity) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_arity) | 0);  /* check that clingo_ast_attribute_arity is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_atom(unsigned long long *o)
{
  int n = (clingo_ast_attribute_atom) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_atom) | 0);  /* check that clingo_ast_attribute_atom is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_atoms(unsigned long long *o)
{
  int n = (clingo_ast_attribute_atoms) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_atoms) | 0);  /* check that clingo_ast_attribute_atoms is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_atom_type(unsigned long long *o)
{
  int n = (clingo_ast_attribute_atom_type) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_atom_type) | 0);  /* check that clingo_ast_attribute_atom_type is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_bias(unsigned long long *o)
{
  int n = (clingo_ast_attribute_bias) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_bias) | 0);  /* check that clingo_ast_attribute_bias is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_body(unsigned long long *o)
{
  int n = (clingo_ast_attribute_body) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_body) | 0);  /* check that clingo_ast_attribute_body is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_code(unsigned long long *o)
{
  int n = (clingo_ast_attribute_code) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_code) | 0);  /* check that clingo_ast_attribute_code is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_coefficient(unsigned long long *o)
{
  int n = (clingo_ast_attribute_coefficient) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_coefficient) | 0);  /* check that clingo_ast_attribute_coefficient is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_comparison(unsigned long long *o)
{
  int n = (clingo_ast_attribute_comparison) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_comparison) | 0);  /* check that clingo_ast_attribute_comparison is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_condition(unsigned long long *o)
{
  int n = (clingo_ast_attribute_condition) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_condition) | 0);  /* check that clingo_ast_attribute_condition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_elements(unsigned long long *o)
{
  int n = (clingo_ast_attribute_elements) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_elements) | 0);  /* check that clingo_ast_attribute_elements is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_external(unsigned long long *o)
{
  int n = (clingo_ast_attribute_external) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_external) | 0);  /* check that clingo_ast_attribute_external is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_external_type(unsigned long long *o)
{
  int n = (clingo_ast_attribute_external_type) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_external_type) | 0);  /* check that clingo_ast_attribute_external_type is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_function(unsigned long long *o)
{
  int n = (clingo_ast_attribute_function) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_function) | 0);  /* check that clingo_ast_attribute_function is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_guard(unsigned long long *o)
{
  int n = (clingo_ast_attribute_guard) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_guard) | 0);  /* check that clingo_ast_attribute_guard is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_guards(unsigned long long *o)
{
  int n = (clingo_ast_attribute_guards) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_guards) | 0);  /* check that clingo_ast_attribute_guards is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_head(unsigned long long *o)
{
  int n = (clingo_ast_attribute_head) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_head) | 0);  /* check that clingo_ast_attribute_head is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_is_default(unsigned long long *o)
{
  int n = (clingo_ast_attribute_is_default) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_is_default) | 0);  /* check that clingo_ast_attribute_is_default is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_left(unsigned long long *o)
{
  int n = (clingo_ast_attribute_left) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_left) | 0);  /* check that clingo_ast_attribute_left is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_left_guard(unsigned long long *o)
{
  int n = (clingo_ast_attribute_left_guard) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_left_guard) | 0);  /* check that clingo_ast_attribute_left_guard is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_literal(unsigned long long *o)
{
  int n = (clingo_ast_attribute_literal) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_literal) | 0);  /* check that clingo_ast_attribute_literal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_location(unsigned long long *o)
{
  int n = (clingo_ast_attribute_location) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_location) | 0);  /* check that clingo_ast_attribute_location is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_modifier(unsigned long long *o)
{
  int n = (clingo_ast_attribute_modifier) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_modifier) | 0);  /* check that clingo_ast_attribute_modifier is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_name(unsigned long long *o)
{
  int n = (clingo_ast_attribute_name) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_name) | 0);  /* check that clingo_ast_attribute_name is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_node_u(unsigned long long *o)
{
  int n = (clingo_ast_attribute_node_u) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_node_u) | 0);  /* check that clingo_ast_attribute_node_u is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_node_v(unsigned long long *o)
{
  int n = (clingo_ast_attribute_node_v) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_node_v) | 0);  /* check that clingo_ast_attribute_node_v is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_operator_name(unsigned long long *o)
{
  int n = (clingo_ast_attribute_operator_name) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_operator_name) | 0);  /* check that clingo_ast_attribute_operator_name is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_operator_type(unsigned long long *o)
{
  int n = (clingo_ast_attribute_operator_type) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_operator_type) | 0);  /* check that clingo_ast_attribute_operator_type is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_operators(unsigned long long *o)
{
  int n = (clingo_ast_attribute_operators) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_operators) | 0);  /* check that clingo_ast_attribute_operators is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_parameters(unsigned long long *o)
{
  int n = (clingo_ast_attribute_parameters) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_parameters) | 0);  /* check that clingo_ast_attribute_parameters is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_positive(unsigned long long *o)
{
  int n = (clingo_ast_attribute_positive) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_positive) | 0);  /* check that clingo_ast_attribute_positive is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_priority(unsigned long long *o)
{
  int n = (clingo_ast_attribute_priority) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_priority) | 0);  /* check that clingo_ast_attribute_priority is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_right(unsigned long long *o)
{
  int n = (clingo_ast_attribute_right) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_right) | 0);  /* check that clingo_ast_attribute_right is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_right_guard(unsigned long long *o)
{
  int n = (clingo_ast_attribute_right_guard) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_right_guard) | 0);  /* check that clingo_ast_attribute_right_guard is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_sequence_type(unsigned long long *o)
{
  int n = (clingo_ast_attribute_sequence_type) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_sequence_type) | 0);  /* check that clingo_ast_attribute_sequence_type is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_sign(unsigned long long *o)
{
  int n = (clingo_ast_attribute_sign) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_sign) | 0);  /* check that clingo_ast_attribute_sign is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_symbol(unsigned long long *o)
{
  int n = (clingo_ast_attribute_symbol) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_symbol) | 0);  /* check that clingo_ast_attribute_symbol is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_term(unsigned long long *o)
{
  int n = (clingo_ast_attribute_term) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_term) | 0);  /* check that clingo_ast_attribute_term is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_terms(unsigned long long *o)
{
  int n = (clingo_ast_attribute_terms) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_terms) | 0);  /* check that clingo_ast_attribute_terms is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_value(unsigned long long *o)
{
  int n = (clingo_ast_attribute_value) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_value) | 0);  /* check that clingo_ast_attribute_value is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_variable(unsigned long long *o)
{
  int n = (clingo_ast_attribute_variable) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_variable) | 0);  /* check that clingo_ast_attribute_variable is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_weight(unsigned long long *o)
{
  int n = (clingo_ast_attribute_weight) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_weight) | 0);  /* check that clingo_ast_attribute_weight is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_comment_type(unsigned long long *o)
{
  int n = (clingo_ast_attribute_comment_type) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_comment_type) | 0);  /* check that clingo_ast_attribute_comment_type is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_number(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_number) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_number) | 0);  /* check that clingo_ast_attribute_type_number is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_symbol(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_symbol) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_symbol) | 0);  /* check that clingo_ast_attribute_type_symbol is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_location(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_location) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_location) | 0);  /* check that clingo_ast_attribute_type_location is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_string(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_string) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_string) | 0);  /* check that clingo_ast_attribute_type_string is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_ast(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_ast) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_ast) | 0);  /* check that clingo_ast_attribute_type_ast is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_optional_ast(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_optional_ast) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_optional_ast) | 0);  /* check that clingo_ast_attribute_type_optional_ast is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_string_array(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_string_array) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_string_array) | 0);  /* check that clingo_ast_attribute_type_string_array is an integer */
  return n;
}

static int _cffi_const_clingo_ast_attribute_type_ast_array(unsigned long long *o)
{
  int n = (clingo_ast_attribute_type_ast_array) <= 0;
  *o = (unsigned long long)((clingo_ast_attribute_type_ast_array) | 0);  /* check that clingo_ast_attribute_type_ast_array is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_xor(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_xor) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_xor) | 0);  /* check that clingo_ast_binary_operator_xor is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_or(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_or) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_or) | 0);  /* check that clingo_ast_binary_operator_or is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_and(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_and) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_and) | 0);  /* check that clingo_ast_binary_operator_and is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_plus(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_plus) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_plus) | 0);  /* check that clingo_ast_binary_operator_plus is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_minus(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_minus) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_minus) | 0);  /* check that clingo_ast_binary_operator_minus is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_multiplication(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_multiplication) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_multiplication) | 0);  /* check that clingo_ast_binary_operator_multiplication is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_division(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_division) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_division) | 0);  /* check that clingo_ast_binary_operator_division is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_modulo(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_modulo) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_modulo) | 0);  /* check that clingo_ast_binary_operator_modulo is an integer */
  return n;
}

static int _cffi_const_clingo_ast_binary_operator_power(unsigned long long *o)
{
  int n = (clingo_ast_binary_operator_power) <= 0;
  *o = (unsigned long long)((clingo_ast_binary_operator_power) | 0);  /* check that clingo_ast_binary_operator_power is an integer */
  return n;
}

static int _cffi_const_clingo_ast_comparison_operator_greater_than(unsigned long long *o)
{
  int n = (clingo_ast_comparison_operator_greater_than) <= 0;
  *o = (unsigned long long)((clingo_ast_comparison_operator_greater_than) | 0);  /* check that clingo_ast_comparison_operator_greater_than is an integer */
  return n;
}

static int _cffi_const_clingo_ast_comparison_operator_less_than(unsigned long long *o)
{
  int n = (clingo_ast_comparison_operator_less_than) <= 0;
  *o = (unsigned long long)((clingo_ast_comparison_operator_less_than) | 0);  /* check that clingo_ast_comparison_operator_less_than is an integer */
  return n;
}

static int _cffi_const_clingo_ast_comparison_operator_less_equal(unsigned long long *o)
{
  int n = (clingo_ast_comparison_operator_less_equal) <= 0;
  *o = (unsigned long long)((clingo_ast_comparison_operator_less_equal) | 0);  /* check that clingo_ast_comparison_operator_less_equal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_comparison_operator_greater_equal(unsigned long long *o)
{
  int n = (clingo_ast_comparison_operator_greater_equal) <= 0;
  *o = (unsigned long long)((clingo_ast_comparison_operator_greater_equal) | 0);  /* check that clingo_ast_comparison_operator_greater_equal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_comparison_operator_not_equal(unsigned long long *o)
{
  int n = (clingo_ast_comparison_operator_not_equal) <= 0;
  *o = (unsigned long long)((clingo_ast_comparison_operator_not_equal) | 0);  /* check that clingo_ast_comparison_operator_not_equal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_comparison_operator_equal(unsigned long long *o)
{
  int n = (clingo_ast_comparison_operator_equal) <= 0;
  *o = (unsigned long long)((clingo_ast_comparison_operator_equal) | 0);  /* check that clingo_ast_comparison_operator_equal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_sign_no_sign(unsigned long long *o)
{
  int n = (clingo_ast_sign_no_sign) <= 0;
  *o = (unsigned long long)((clingo_ast_sign_no_sign) | 0);  /* check that clingo_ast_sign_no_sign is an integer */
  return n;
}

static int _cffi_const_clingo_ast_sign_negation(unsigned long long *o)
{
  int n = (clingo_ast_sign_negation) <= 0;
  *o = (unsigned long long)((clingo_ast_sign_negation) | 0);  /* check that clingo_ast_sign_negation is an integer */
  return n;
}

static int _cffi_const_clingo_ast_sign_double_negation(unsigned long long *o)
{
  int n = (clingo_ast_sign_double_negation) <= 0;
  *o = (unsigned long long)((clingo_ast_sign_double_negation) | 0);  /* check that clingo_ast_sign_double_negation is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_atom_definition_type_head(unsigned long long *o)
{
  int n = (clingo_ast_theory_atom_definition_type_head) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_atom_definition_type_head) | 0);  /* check that clingo_ast_theory_atom_definition_type_head is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_atom_definition_type_body(unsigned long long *o)
{
  int n = (clingo_ast_theory_atom_definition_type_body) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_atom_definition_type_body) | 0);  /* check that clingo_ast_theory_atom_definition_type_body is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_atom_definition_type_any(unsigned long long *o)
{
  int n = (clingo_ast_theory_atom_definition_type_any) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_atom_definition_type_any) | 0);  /* check that clingo_ast_theory_atom_definition_type_any is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_atom_definition_type_directive(unsigned long long *o)
{
  int n = (clingo_ast_theory_atom_definition_type_directive) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_atom_definition_type_directive) | 0);  /* check that clingo_ast_theory_atom_definition_type_directive is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_operator_type_unary(unsigned long long *o)
{
  int n = (clingo_ast_theory_operator_type_unary) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_operator_type_unary) | 0);  /* check that clingo_ast_theory_operator_type_unary is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_operator_type_binary_left(unsigned long long *o)
{
  int n = (clingo_ast_theory_operator_type_binary_left) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_operator_type_binary_left) | 0);  /* check that clingo_ast_theory_operator_type_binary_left is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_operator_type_binary_right(unsigned long long *o)
{
  int n = (clingo_ast_theory_operator_type_binary_right) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_operator_type_binary_right) | 0);  /* check that clingo_ast_theory_operator_type_binary_right is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_sequence_type_tuple(unsigned long long *o)
{
  int n = (clingo_ast_theory_sequence_type_tuple) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_sequence_type_tuple) | 0);  /* check that clingo_ast_theory_sequence_type_tuple is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_sequence_type_list(unsigned long long *o)
{
  int n = (clingo_ast_theory_sequence_type_list) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_sequence_type_list) | 0);  /* check that clingo_ast_theory_sequence_type_list is an integer */
  return n;
}

static int _cffi_const_clingo_ast_theory_sequence_type_set(unsigned long long *o)
{
  int n = (clingo_ast_theory_sequence_type_set) <= 0;
  *o = (unsigned long long)((clingo_ast_theory_sequence_type_set) | 0);  /* check that clingo_ast_theory_sequence_type_set is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_id(unsigned long long *o)
{
  int n = (clingo_ast_type_id) <= 0;
  *o = (unsigned long long)((clingo_ast_type_id) | 0);  /* check that clingo_ast_type_id is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_variable(unsigned long long *o)
{
  int n = (clingo_ast_type_variable) <= 0;
  *o = (unsigned long long)((clingo_ast_type_variable) | 0);  /* check that clingo_ast_type_variable is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_symbolic_term(unsigned long long *o)
{
  int n = (clingo_ast_type_symbolic_term) <= 0;
  *o = (unsigned long long)((clingo_ast_type_symbolic_term) | 0);  /* check that clingo_ast_type_symbolic_term is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_unary_operation(unsigned long long *o)
{
  int n = (clingo_ast_type_unary_operation) <= 0;
  *o = (unsigned long long)((clingo_ast_type_unary_operation) | 0);  /* check that clingo_ast_type_unary_operation is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_binary_operation(unsigned long long *o)
{
  int n = (clingo_ast_type_binary_operation) <= 0;
  *o = (unsigned long long)((clingo_ast_type_binary_operation) | 0);  /* check that clingo_ast_type_binary_operation is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_interval(unsigned long long *o)
{
  int n = (clingo_ast_type_interval) <= 0;
  *o = (unsigned long long)((clingo_ast_type_interval) | 0);  /* check that clingo_ast_type_interval is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_function(unsigned long long *o)
{
  int n = (clingo_ast_type_function) <= 0;
  *o = (unsigned long long)((clingo_ast_type_function) | 0);  /* check that clingo_ast_type_function is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_pool(unsigned long long *o)
{
  int n = (clingo_ast_type_pool) <= 0;
  *o = (unsigned long long)((clingo_ast_type_pool) | 0);  /* check that clingo_ast_type_pool is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_boolean_constant(unsigned long long *o)
{
  int n = (clingo_ast_type_boolean_constant) <= 0;
  *o = (unsigned long long)((clingo_ast_type_boolean_constant) | 0);  /* check that clingo_ast_type_boolean_constant is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_symbolic_atom(unsigned long long *o)
{
  int n = (clingo_ast_type_symbolic_atom) <= 0;
  *o = (unsigned long long)((clingo_ast_type_symbolic_atom) | 0);  /* check that clingo_ast_type_symbolic_atom is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_comparison(unsigned long long *o)
{
  int n = (clingo_ast_type_comparison) <= 0;
  *o = (unsigned long long)((clingo_ast_type_comparison) | 0);  /* check that clingo_ast_type_comparison is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_guard(unsigned long long *o)
{
  int n = (clingo_ast_type_guard) <= 0;
  *o = (unsigned long long)((clingo_ast_type_guard) | 0);  /* check that clingo_ast_type_guard is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_conditional_literal(unsigned long long *o)
{
  int n = (clingo_ast_type_conditional_literal) <= 0;
  *o = (unsigned long long)((clingo_ast_type_conditional_literal) | 0);  /* check that clingo_ast_type_conditional_literal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_aggregate(unsigned long long *o)
{
  int n = (clingo_ast_type_aggregate) <= 0;
  *o = (unsigned long long)((clingo_ast_type_aggregate) | 0);  /* check that clingo_ast_type_aggregate is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_body_aggregate_element(unsigned long long *o)
{
  int n = (clingo_ast_type_body_aggregate_element) <= 0;
  *o = (unsigned long long)((clingo_ast_type_body_aggregate_element) | 0);  /* check that clingo_ast_type_body_aggregate_element is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_body_aggregate(unsigned long long *o)
{
  int n = (clingo_ast_type_body_aggregate) <= 0;
  *o = (unsigned long long)((clingo_ast_type_body_aggregate) | 0);  /* check that clingo_ast_type_body_aggregate is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_head_aggregate_element(unsigned long long *o)
{
  int n = (clingo_ast_type_head_aggregate_element) <= 0;
  *o = (unsigned long long)((clingo_ast_type_head_aggregate_element) | 0);  /* check that clingo_ast_type_head_aggregate_element is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_head_aggregate(unsigned long long *o)
{
  int n = (clingo_ast_type_head_aggregate) <= 0;
  *o = (unsigned long long)((clingo_ast_type_head_aggregate) | 0);  /* check that clingo_ast_type_head_aggregate is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_disjunction(unsigned long long *o)
{
  int n = (clingo_ast_type_disjunction) <= 0;
  *o = (unsigned long long)((clingo_ast_type_disjunction) | 0);  /* check that clingo_ast_type_disjunction is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_sequence(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_sequence) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_sequence) | 0);  /* check that clingo_ast_type_theory_sequence is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_function(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_function) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_function) | 0);  /* check that clingo_ast_type_theory_function is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_unparsed_term_element(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_unparsed_term_element) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_unparsed_term_element) | 0);  /* check that clingo_ast_type_theory_unparsed_term_element is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_unparsed_term(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_unparsed_term) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_unparsed_term) | 0);  /* check that clingo_ast_type_theory_unparsed_term is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_guard(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_guard) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_guard) | 0);  /* check that clingo_ast_type_theory_guard is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_atom_element(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_atom_element) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_atom_element) | 0);  /* check that clingo_ast_type_theory_atom_element is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_atom(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_atom) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_atom) | 0);  /* check that clingo_ast_type_theory_atom is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_literal(unsigned long long *o)
{
  int n = (clingo_ast_type_literal) <= 0;
  *o = (unsigned long long)((clingo_ast_type_literal) | 0);  /* check that clingo_ast_type_literal is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_operator_definition(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_operator_definition) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_operator_definition) | 0);  /* check that clingo_ast_type_theory_operator_definition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_term_definition(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_term_definition) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_term_definition) | 0);  /* check that clingo_ast_type_theory_term_definition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_guard_definition(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_guard_definition) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_guard_definition) | 0);  /* check that clingo_ast_type_theory_guard_definition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_atom_definition(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_atom_definition) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_atom_definition) | 0);  /* check that clingo_ast_type_theory_atom_definition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_rule(unsigned long long *o)
{
  int n = (clingo_ast_type_rule) <= 0;
  *o = (unsigned long long)((clingo_ast_type_rule) | 0);  /* check that clingo_ast_type_rule is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_definition(unsigned long long *o)
{
  int n = (clingo_ast_type_definition) <= 0;
  *o = (unsigned long long)((clingo_ast_type_definition) | 0);  /* check that clingo_ast_type_definition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_show_signature(unsigned long long *o)
{
  int n = (clingo_ast_type_show_signature) <= 0;
  *o = (unsigned long long)((clingo_ast_type_show_signature) | 0);  /* check that clingo_ast_type_show_signature is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_show_term(unsigned long long *o)
{
  int n = (clingo_ast_type_show_term) <= 0;
  *o = (unsigned long long)((clingo_ast_type_show_term) | 0);  /* check that clingo_ast_type_show_term is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_minimize(unsigned long long *o)
{
  int n = (clingo_ast_type_minimize) <= 0;
  *o = (unsigned long long)((clingo_ast_type_minimize) | 0);  /* check that clingo_ast_type_minimize is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_script(unsigned long long *o)
{
  int n = (clingo_ast_type_script) <= 0;
  *o = (unsigned long long)((clingo_ast_type_script) | 0);  /* check that clingo_ast_type_script is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_program(unsigned long long *o)
{
  int n = (clingo_ast_type_program) <= 0;
  *o = (unsigned long long)((clingo_ast_type_program) | 0);  /* check that clingo_ast_type_program is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_external(unsigned long long *o)
{
  int n = (clingo_ast_type_external) <= 0;
  *o = (unsigned long long)((clingo_ast_type_external) | 0);  /* check that clingo_ast_type_external is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_edge(unsigned long long *o)
{
  int n = (clingo_ast_type_edge) <= 0;
  *o = (unsigned long long)((clingo_ast_type_edge) | 0);  /* check that clingo_ast_type_edge is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_heuristic(unsigned long long *o)
{
  int n = (clingo_ast_type_heuristic) <= 0;
  *o = (unsigned long long)((clingo_ast_type_heuristic) | 0);  /* check that clingo_ast_type_heuristic is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_project_atom(unsigned long long *o)
{
  int n = (clingo_ast_type_project_atom) <= 0;
  *o = (unsigned long long)((clingo_ast_type_project_atom) | 0);  /* check that clingo_ast_type_project_atom is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_project_signature(unsigned long long *o)
{
  int n = (clingo_ast_type_project_signature) <= 0;
  *o = (unsigned long long)((clingo_ast_type_project_signature) | 0);  /* check that clingo_ast_type_project_signature is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_defined(unsigned long long *o)
{
  int n = (clingo_ast_type_defined) <= 0;
  *o = (unsigned long long)((clingo_ast_type_defined) | 0);  /* check that clingo_ast_type_defined is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_theory_definition(unsigned long long *o)
{
  int n = (clingo_ast_type_theory_definition) <= 0;
  *o = (unsigned long long)((clingo_ast_type_theory_definition) | 0);  /* check that clingo_ast_type_theory_definition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_type_comment(unsigned long long *o)
{
  int n = (clingo_ast_type_comment) <= 0;
  *o = (unsigned long long)((clingo_ast_type_comment) | 0);  /* check that clingo_ast_type_comment is an integer */
  return n;
}

static int _cffi_const_clingo_ast_unary_operator_minus(unsigned long long *o)
{
  int n = (clingo_ast_unary_operator_minus) <= 0;
  *o = (unsigned long long)((clingo_ast_unary_operator_minus) | 0);  /* check that clingo_ast_unary_operator_minus is an integer */
  return n;
}

static int _cffi_const_clingo_ast_unary_operator_negation(unsigned long long *o)
{
  int n = (clingo_ast_unary_operator_negation) <= 0;
  *o = (unsigned long long)((clingo_ast_unary_operator_negation) | 0);  /* check that clingo_ast_unary_operator_negation is an integer */
  return n;
}

static int _cffi_const_clingo_ast_unary_operator_absolute(unsigned long long *o)
{
  int n = (clingo_ast_unary_operator_absolute) <= 0;
  *o = (unsigned long long)((clingo_ast_unary_operator_absolute) | 0);  /* check that clingo_ast_unary_operator_absolute is an integer */
  return n;
}

static int _cffi_const_clingo_ast_unpool_type_condition(unsigned long long *o)
{
  int n = (clingo_ast_unpool_type_condition) <= 0;
  *o = (unsigned long long)((clingo_ast_unpool_type_condition) | 0);  /* check that clingo_ast_unpool_type_condition is an integer */
  return n;
}

static int _cffi_const_clingo_ast_unpool_type_other(unsigned long long *o)
{
  int n = (clingo_ast_unpool_type_other) <= 0;
  *o = (unsigned long long)((clingo_ast_unpool_type_other) | 0);  /* check that clingo_ast_unpool_type_other is an integer */
  return n;
}

static int _cffi_const_clingo_ast_unpool_type_all(unsigned long long *o)
{
  int n = (clingo_ast_unpool_type_all) <= 0;
  *o = (unsigned long long)((clingo_ast_unpool_type_all) | 0);  /* check that clingo_ast_unpool_type_all is an integer */
  return n;
}

static int _cffi_const_clingo_clause_type_learnt(unsigned long long *o)
{
  int n = (clingo_clause_type_learnt) <= 0;
  *o = (unsigned long long)((clingo_clause_type_learnt) | 0);  /* check that clingo_clause_type_learnt is an integer */
  return n;
}

static int _cffi_const_clingo_clause_type_static(unsigned long long *o)
{
  int n = (clingo_clause_type_static) <= 0;
  *o = (unsigned long long)((clingo_clause_type_static) | 0);  /* check that clingo_clause_type_static is an integer */
  return n;
}

static int _cffi_const_clingo_clause_type_volatile(unsigned long long *o)
{
  int n = (clingo_clause_type_volatile) <= 0;
  *o = (unsigned long long)((clingo_clause_type_volatile) | 0);  /* check that clingo_clause_type_volatile is an integer */
  return n;
}

static int _cffi_const_clingo_clause_type_volatile_static(unsigned long long *o)
{
  int n = (clingo_clause_type_volatile_static) <= 0;
  *o = (unsigned long long)((clingo_clause_type_volatile_static) | 0);  /* check that clingo_clause_type_volatile_static is an integer */
  return n;
}

static int _cffi_const_clingo_comment_type_line(unsigned long long *o)
{
  int n = (clingo_comment_type_line) <= 0;
  *o = (unsigned long long)((clingo_comment_type_line) | 0);  /* check that clingo_comment_type_line is an integer */
  return n;
}

static int _cffi_const_clingo_comment_type_block(unsigned long long *o)
{
  int n = (clingo_comment_type_block) <= 0;
  *o = (unsigned long long)((clingo_comment_type_block) | 0);  /* check that clingo_comment_type_block is an integer */
  return n;
}

static int _cffi_const_clingo_configuration_type_value(unsigned long long *o)
{
  int n = (clingo_configuration_type_value) <= 0;
  *o = (unsigned long long)((clingo_configuration_type_value) | 0);  /* check that clingo_configuration_type_value is an integer */
  return n;
}

static int _cffi_const_clingo_configuration_type_array(unsigned long long *o)
{
  int n = (clingo_configuration_type_array) <= 0;
  *o = (unsigned long long)((clingo_configuration_type_array) | 0);  /* check that clingo_configuration_type_array is an integer */
  return n;
}

static int _cffi_const_clingo_configuration_type_map(unsigned long long *o)
{
  int n = (clingo_configuration_type_map) <= 0;
  *o = (unsigned long long)((clingo_configuration_type_map) | 0);  /* check that clingo_configuration_type_map is an integer */
  return n;
}

static int _cffi_const_clingo_consequence_false(unsigned long long *o)
{
  int n = (clingo_consequence_false) <= 0;
  *o = (unsigned long long)((clingo_consequence_false) | 0);  /* check that clingo_consequence_false is an integer */
  return n;
}

static int _cffi_const_clingo_consequence_true(unsigned long long *o)
{
  int n = (clingo_consequence_true) <= 0;
  *o = (unsigned long long)((clingo_consequence_true) | 0);  /* check that clingo_consequence_true is an integer */
  return n;
}

static int _cffi_const_clingo_consequence_unknown(unsigned long long *o)
{
  int n = (clingo_consequence_unknown) <= 0;
  *o = (unsigned long long)((clingo_consequence_unknown) | 0);  /* check that clingo_consequence_unknown is an integer */
  return n;
}

static int _cffi_const_clingo_error_success(unsigned long long *o)
{
  int n = (clingo_error_success) <= 0;
  *o = (unsigned long long)((clingo_error_success) | 0);  /* check that clingo_error_success is an integer */
  return n;
}

static int _cffi_const_clingo_error_runtime(unsigned long long *o)
{
  int n = (clingo_error_runtime) <= 0;
  *o = (unsigned long long)((clingo_error_runtime) | 0);  /* check that clingo_error_runtime is an integer */
  return n;
}

static int _cffi_const_clingo_error_logic(unsigned long long *o)
{
  int n = (clingo_error_logic) <= 0;
  *o = (unsigned long long)((clingo_error_logic) | 0);  /* check that clingo_error_logic is an integer */
  return n;
}

static int _cffi_const_clingo_error_bad_alloc(unsigned long long *o)
{
  int n = (clingo_error_bad_alloc) <= 0;
  *o = (unsigned long long)((clingo_error_bad_alloc) | 0);  /* check that clingo_error_bad_alloc is an integer */
  return n;
}

static int _cffi_const_clingo_error_unknown(unsigned long long *o)
{
  int n = (clingo_error_unknown) <= 0;
  *o = (unsigned long long)((clingo_error_unknown) | 0);  /* check that clingo_error_unknown is an integer */
  return n;
}

static int _cffi_const_clingo_external_type_free(unsigned long long *o)
{
  int n = (clingo_external_type_free) <= 0;
  *o = (unsigned long long)((clingo_external_type_free) | 0);  /* check that clingo_external_type_free is an integer */
  return n;
}

static int _cffi_const_clingo_external_type_true(unsigned long long *o)
{
  int n = (clingo_external_type_true) <= 0;
  *o = (unsigned long long)((clingo_external_type_true) | 0);  /* check that clingo_external_type_true is an integer */
  return n;
}

static int _cffi_const_clingo_external_type_false(unsigned long long *o)
{
  int n = (clingo_external_type_false) <= 0;
  *o = (unsigned long long)((clingo_external_type_false) | 0);  /* check that clingo_external_type_false is an integer */
  return n;
}

static int _cffi_const_clingo_external_type_release(unsigned long long *o)
{
  int n = (clingo_external_type_release) <= 0;
  *o = (unsigned long long)((clingo_external_type_release) | 0);  /* check that clingo_external_type_release is an integer */
  return n;
}

static int _cffi_const_clingo_heuristic_type_level(unsigned long long *o)
{
  int n = (clingo_heuristic_type_level) <= 0;
  *o = (unsigned long long)((clingo_heuristic_type_level) | 0);  /* check that clingo_heuristic_type_level is an integer */
  return n;
}

static int _cffi_const_clingo_heuristic_type_sign(unsigned long long *o)
{
  int n = (clingo_heuristic_type_sign) <= 0;
  *o = (unsigned long long)((clingo_heuristic_type_sign) | 0);  /* check that clingo_heuristic_type_sign is an integer */
  return n;
}

static int _cffi_const_clingo_heuristic_type_factor(unsigned long long *o)
{
  int n = (clingo_heuristic_type_factor) <= 0;
  *o = (unsigned long long)((clingo_heuristic_type_factor) | 0);  /* check that clingo_heuristic_type_factor is an integer */
  return n;
}

static int _cffi_const_clingo_heuristic_type_init(unsigned long long *o)
{
  int n = (clingo_heuristic_type_init) <= 0;
  *o = (unsigned long long)((clingo_heuristic_type_init) | 0);  /* check that clingo_heuristic_type_init is an integer */
  return n;
}

static int _cffi_const_clingo_heuristic_type_true(unsigned long long *o)
{
  int n = (clingo_heuristic_type_true) <= 0;
  *o = (unsigned long long)((clingo_heuristic_type_true) | 0);  /* check that clingo_heuristic_type_true is an integer */
  return n;
}

static int _cffi_const_clingo_heuristic_type_false(unsigned long long *o)
{
  int n = (clingo_heuristic_type_false) <= 0;
  *o = (unsigned long long)((clingo_heuristic_type_false) | 0);  /* check that clingo_heuristic_type_false is an integer */
  return n;
}

static int _cffi_const_clingo_model_type_stable_model(unsigned long long *o)
{
  int n = (clingo_model_type_stable_model) <= 0;
  *o = (unsigned long long)((clingo_model_type_stable_model) | 0);  /* check that clingo_model_type_stable_model is an integer */
  return n;
}

static int _cffi_const_clingo_model_type_brave_consequences(unsigned long long *o)
{
  int n = (clingo_model_type_brave_consequences) <= 0;
  *o = (unsigned long long)((clingo_model_type_brave_consequences) | 0);  /* check that clingo_model_type_brave_consequences is an integer */
  return n;
}

static int _cffi_const_clingo_model_type_cautious_consequences(unsigned long long *o)
{
  int n = (clingo_model_type_cautious_consequences) <= 0;
  *o = (unsigned long long)((clingo_model_type_cautious_consequences) | 0);  /* check that clingo_model_type_cautious_consequences is an integer */
  return n;
}

static int _cffi_const_clingo_propagator_check_mode_none(unsigned long long *o)
{
  int n = (clingo_propagator_check_mode_none) <= 0;
  *o = (unsigned long long)((clingo_propagator_check_mode_none) | 0);  /* check that clingo_propagator_check_mode_none is an integer */
  return n;
}

static int _cffi_const_clingo_propagator_check_mode_total(unsigned long long *o)
{
  int n = (clingo_propagator_check_mode_total) <= 0;
  *o = (unsigned long long)((clingo_propagator_check_mode_total) | 0);  /* check that clingo_propagator_check_mode_total is an integer */
  return n;
}

static int _cffi_const_clingo_propagator_check_mode_fixpoint(unsigned long long *o)
{
  int n = (clingo_propagator_check_mode_fixpoint) <= 0;
  *o = (unsigned long long)((clingo_propagator_check_mode_fixpoint) | 0);  /* check that clingo_propagator_check_mode_fixpoint is an integer */
  return n;
}

static int _cffi_const_clingo_propagator_check_mode_both(unsigned long long *o)
{
  int n = (clingo_propagator_check_mode_both) <= 0;
  *o = (unsigned long long)((clingo_propagator_check_mode_both) | 0);  /* check that clingo_propagator_check_mode_both is an integer */
  return n;
}

static int _cffi_const_clingo_propagator_undo_mode_default(unsigned long long *o)
{
  int n = (clingo_propagator_undo_mode_default) <= 0;
  *o = (unsigned long long)((clingo_propagator_undo_mode_default) | 0);  /* check that clingo_propagator_undo_mode_default is an integer */
  return n;
}

static int _cffi_const_clingo_propagator_undo_mode_always(unsigned long long *o)
{
  int n = (clingo_propagator_undo_mode_always) <= 0;
  *o = (unsigned long long)((clingo_propagator_undo_mode_always) | 0);  /* check that clingo_propagator_undo_mode_always is an integer */
  return n;
}

static int _cffi_const_clingo_show_type_shown(unsigned long long *o)
{
  int n = (clingo_show_type_shown) <= 0;
  *o = (unsigned long long)((clingo_show_type_shown) | 0);  /* check that clingo_show_type_shown is an integer */
  return n;
}

static int _cffi_const_clingo_show_type_atoms(unsigned long long *o)
{
  int n = (clingo_show_type_atoms) <= 0;
  *o = (unsigned long long)((clingo_show_type_atoms) | 0);  /* check that clingo_show_type_atoms is an integer */
  return n;
}

static int _cffi_const_clingo_show_type_terms(unsigned long long *o)
{
  int n = (clingo_show_type_terms) <= 0;
  *o = (unsigned long long)((clingo_show_type_terms) | 0);  /* check that clingo_show_type_terms is an integer */
  return n;
}

static int _cffi_const_clingo_show_type_theory(unsigned long long *o)
{
  int n = (clingo_show_type_theory) <= 0;
  *o = (unsigned long long)((clingo_show_type_theory) | 0);  /* check that clingo_show_type_theory is an integer */
  return n;
}

static int _cffi_const_clingo_show_type_all(unsigned long long *o)
{
  int n = (clingo_show_type_all) <= 0;
  *o = (unsigned long long)((clingo_show_type_all) | 0);  /* check that clingo_show_type_all is an integer */
  return n;
}

static int _cffi_const_clingo_show_type_complement(unsigned long long *o)
{
  int n = (clingo_show_type_complement) <= 0;
  *o = (unsigned long long)((clingo_show_type_complement) | 0);  /* check that clingo_show_type_complement is an integer */
  return n;
}

static int _cffi_const_clingo_solve_event_type_model(unsigned long long *o)
{
  int n = (clingo_solve_event_type_model) <= 0;
  *o = (unsigned long long)((clingo_solve_event_type_model) | 0);  /* check that clingo_solve_event_type_model is an integer */
  return n;
}

static int _cffi_const_clingo_solve_event_type_unsat(unsigned long long *o)
{
  int n = (clingo_solve_event_type_unsat) <= 0;
  *o = (unsigned long long)((clingo_solve_event_type_unsat) | 0);  /* check that clingo_solve_event_type_unsat is an integer */
  return n;
}

static int _cffi_const_clingo_solve_event_type_statistics(unsigned long long *o)
{
  int n = (clingo_solve_event_type_statistics) <= 0;
  *o = (unsigned long long)((clingo_solve_event_type_statistics) | 0);  /* check that clingo_solve_event_type_statistics is an integer */
  return n;
}

static int _cffi_const_clingo_solve_event_type_finish(unsigned long long *o)
{
  int n = (clingo_solve_event_type_finish) <= 0;
  *o = (unsigned long long)((clingo_solve_event_type_finish) | 0);  /* check that clingo_solve_event_type_finish is an integer */
  return n;
}

static int _cffi_const_clingo_solve_mode_async(unsigned long long *o)
{
  int n = (clingo_solve_mode_async) <= 0;
  *o = (unsigned long long)((clingo_solve_mode_async) | 0);  /* check that clingo_solve_mode_async is an integer */
  return n;
}

static int _cffi_const_clingo_solve_mode_yield(unsigned long long *o)
{
  int n = (clingo_solve_mode_yield) <= 0;
  *o = (unsigned long long)((clingo_solve_mode_yield) | 0);  /* check that clingo_solve_mode_yield is an integer */
  return n;
}

static int _cffi_const_clingo_solve_result_satisfiable(unsigned long long *o)
{
  int n = (clingo_solve_result_satisfiable) <= 0;
  *o = (unsigned long long)((clingo_solve_result_satisfiable) | 0);  /* check that clingo_solve_result_satisfiable is an integer */
  return n;
}

static int _cffi_const_clingo_solve_result_unsatisfiable(unsigned long long *o)
{
  int n = (clingo_solve_result_unsatisfiable) <= 0;
  *o = (unsigned long long)((clingo_solve_result_unsatisfiable) | 0);  /* check that clingo_solve_result_unsatisfiable is an integer */
  return n;
}

static int _cffi_const_clingo_solve_result_exhausted(unsigned long long *o)
{
  int n = (clingo_solve_result_exhausted) <= 0;
  *o = (unsigned long long)((clingo_solve_result_exhausted) | 0);  /* check that clingo_solve_result_exhausted is an integer */
  return n;
}

static int _cffi_const_clingo_solve_result_interrupted(unsigned long long *o)
{
  int n = (clingo_solve_result_interrupted) <= 0;
  *o = (unsigned long long)((clingo_solve_result_interrupted) | 0);  /* check that clingo_solve_result_interrupted is an integer */
  return n;
}

static int _cffi_const_clingo_statistics_type_empty(unsigned long long *o)
{
  int n = (clingo_statistics_type_empty) <= 0;
  *o = (unsigned long long)((clingo_statistics_type_empty) | 0);  /* check that clingo_statistics_type_empty is an integer */
  return n;
}

static int _cffi_const_clingo_statistics_type_value(unsigned long long *o)
{
  int n = (clingo_statistics_type_value) <= 0;
  *o = (unsigned long long)((clingo_statistics_type_value) | 0);  /* check that clingo_statistics_type_value is an integer */
  return n;
}

static int _cffi_const_clingo_statistics_type_array(unsigned long long *o)
{
  int n = (clingo_statistics_type_array) <= 0;
  *o = (unsigned long long)((clingo_statistics_type_array) | 0);  /* check that clingo_statistics_type_array is an integer */
  return n;
}

static int _cffi_const_clingo_statistics_type_map(unsigned long long *o)
{
  int n = (clingo_statistics_type_map) <= 0;
  *o = (unsigned long long)((clingo_statistics_type_map) | 0);  /* check that clingo_statistics_type_map is an integer */
  return n;
}

static int _cffi_const_clingo_symbol_type_infimum(unsigned long long *o)
{
  int n = (clingo_symbol_type_infimum) <= 0;
  *o = (unsigned long long)((clingo_symbol_type_infimum) | 0);  /* check that clingo_symbol_type_infimum is an integer */
  return n;
}

static int _cffi_const_clingo_symbol_type_number(unsigned long long *o)
{
  int n = (clingo_symbol_type_number) <= 0;
  *o = (unsigned long long)((clingo_symbol_type_number) | 0);  /* check that clingo_symbol_type_number is an integer */
  return n;
}

static int _cffi_const_clingo_symbol_type_string(unsigned long long *o)
{
  int n = (clingo_symbol_type_string) <= 0;
  *o = (unsigned long long)((clingo_symbol_type_string) | 0);  /* check that clingo_symbol_type_string is an integer */
  return n;
}

static int _cffi_const_clingo_symbol_type_function(unsigned long long *o)
{
  int n = (clingo_symbol_type_function) <= 0;
  *o = (unsigned long long)((clingo_symbol_type_function) | 0);  /* check that clingo_symbol_type_function is an integer */
  return n;
}

static int _cffi_const_clingo_symbol_type_supremum(unsigned long long *o)
{
  int n = (clingo_symbol_type_supremum) <= 0;
  *o = (unsigned long long)((clingo_symbol_type_supremum) | 0);  /* check that clingo_symbol_type_supremum is an integer */
  return n;
}

static int _cffi_const_clingo_theory_sequence_type_tuple(unsigned long long *o)
{
  int n = (clingo_theory_sequence_type_tuple) <= 0;
  *o = (unsigned long long)((clingo_theory_sequence_type_tuple) | 0);  /* check that clingo_theory_sequence_type_tuple is an integer */
  return n;
}

static int _cffi_const_clingo_theory_sequence_type_set(unsigned long long *o)
{
  int n = (clingo_theory_sequence_type_set) <= 0;
  *o = (unsigned long long)((clingo_theory_sequence_type_set) | 0);  /* check that clingo_theory_sequence_type_set is an integer */
  return n;
}

static int _cffi_const_clingo_theory_sequence_type_list(unsigned long long *o)
{
  int n = (clingo_theory_sequence_type_list) <= 0;
  *o = (unsigned long long)((clingo_theory_sequence_type_list) | 0);  /* check that clingo_theory_sequence_type_list is an integer */
  return n;
}

static int _cffi_const_clingo_theory_term_type_tuple(unsigned long long *o)
{
  int n = (clingo_theory_term_type_tuple) <= 0;
  *o = (unsigned long long)((clingo_theory_term_type_tuple) | 0);  /* check that clingo_theory_term_type_tuple is an integer */
  return n;
}

static int _cffi_const_clingo_theory_term_type_list(unsigned long long *o)
{
  int n = (clingo_theory_term_type_list) <= 0;
  *o = (unsigned long long)((clingo_theory_term_type_list) | 0);  /* check that clingo_theory_term_type_list is an integer */
  return n;
}

static int _cffi_const_clingo_theory_term_type_set(unsigned long long *o)
{
  int n = (clingo_theory_term_type_set) <= 0;
  *o = (unsigned long long)((clingo_theory_term_type_set) | 0);  /* check that clingo_theory_term_type_set is an integer */
  return n;
}

static int _cffi_const_clingo_theory_term_type_function(unsigned long long *o)
{
  int n = (clingo_theory_term_type_function) <= 0;
  *o = (unsigned long long)((clingo_theory_term_type_function) | 0);  /* check that clingo_theory_term_type_function is an integer */
  return n;
}

static int _cffi_const_clingo_theory_term_type_number(unsigned long long *o)
{
  int n = (clingo_theory_term_type_number) <= 0;
  *o = (unsigned long long)((clingo_theory_term_type_number) | 0);  /* check that clingo_theory_term_type_number is an integer */
  return n;
}

static int _cffi_const_clingo_theory_term_type_symbol(unsigned long long *o)
{
  int n = (clingo_theory_term_type_symbol) <= 0;
  *o = (unsigned long long)((clingo_theory_term_type_symbol) | 0);  /* check that clingo_theory_term_type_symbol is an integer */
  return n;
}

static int _cffi_const_clingo_truth_value_free(unsigned long long *o)
{
  int n = (clingo_truth_value_free) <= 0;
  *o = (unsigned long long)((clingo_truth_value_free) | 0);  /* check that clingo_truth_value_free is an integer */
  return n;
}

static int _cffi_const_clingo_truth_value_true(unsigned long long *o)
{
  int n = (clingo_truth_value_true) <= 0;
  *o = (unsigned long long)((clingo_truth_value_true) | 0);  /* check that clingo_truth_value_true is an integer */
  return n;
}

static int _cffi_const_clingo_truth_value_false(unsigned long long *o)
{
  int n = (clingo_truth_value_false) <= 0;
  *o = (unsigned long long)((clingo_truth_value_false) | 0);  /* check that clingo_truth_value_false is an integer */
  return n;
}

static int _cffi_const_clingo_warning_operation_undefined(unsigned long long *o)
{
  int n = (clingo_warning_operation_undefined) <= 0;
  *o = (unsigned long long)((clingo_warning_operation_undefined) | 0);  /* check that clingo_warning_operation_undefined is an integer */
  return n;
}

static int _cffi_const_clingo_warning_runtime_error(unsigned long long *o)
{
  int n = (clingo_warning_runtime_error) <= 0;
  *o = (unsigned long long)((clingo_warning_runtime_error) | 0);  /* check that clingo_warning_runtime_error is an integer */
  return n;
}

static int _cffi_const_clingo_warning_atom_undefined(unsigned long long *o)
{
  int n = (clingo_warning_atom_undefined) <= 0;
  *o = (unsigned long long)((clingo_warning_atom_undefined) | 0);  /* check that clingo_warning_atom_undefined is an integer */
  return n;
}

static int _cffi_const_clingo_warning_file_included(unsigned long long *o)
{
  int n = (clingo_warning_file_included) <= 0;
  *o = (unsigned long long)((clingo_warning_file_included) | 0);  /* check that clingo_warning_file_included is an integer */
  return n;
}

static int _cffi_const_clingo_warning_variable_unbounded(unsigned long long *o)
{
  int n = (clingo_warning_variable_unbounded) <= 0;
  *o = (unsigned long long)((clingo_warning_variable_unbounded) | 0);  /* check that clingo_warning_variable_unbounded is an integer */
  return n;
}

static int _cffi_const_clingo_warning_global_variable(unsigned long long *o)
{
  int n = (clingo_warning_global_variable) <= 0;
  *o = (unsigned long long)((clingo_warning_global_variable) | 0);  /* check that clingo_warning_global_variable is an integer */
  return n;
}

static int _cffi_const_clingo_warning_other(unsigned long long *o)
{
  int n = (clingo_warning_other) <= 0;
  *o = (unsigned long long)((clingo_warning_other) | 0);  /* check that clingo_warning_other is an integer */
  return n;
}

static int _cffi_const_clingo_weight_constraint_type_implication_left(unsigned long long *o)
{
  int n = (clingo_weight_constraint_type_implication_left) <= 0;
  *o = (unsigned long long)((clingo_weight_constraint_type_implication_left) | 0);  /* check that clingo_weight_constraint_type_implication_left is an integer */
  return n;
}

static int _cffi_const_clingo_weight_constraint_type_implication_right(unsigned long long *o)
{
  int n = (clingo_weight_constraint_type_implication_right) <= 0;
  *o = (unsigned long long)((clingo_weight_constraint_type_implication_right) | 0);  /* check that clingo_weight_constraint_type_implication_right is an integer */
  return n;
}

static int _cffi_const_clingo_weight_constraint_type_equivalence(unsigned long long *o)
{
  int n = (clingo_weight_constraint_type_equivalence) <= 0;
  *o = (unsigned long long)((clingo_weight_constraint_type_equivalence) | 0);  /* check that clingo_weight_constraint_type_equivalence is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_logger =
  { "_clingo.pyclingo_application_logger", 0, 0, 0 };

static void pyclingo_application_logger(int a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_logger, p);
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_main =
  { "_clingo.pyclingo_application_main", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_application_main(clingo_control_t * a0, char const * const * a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(clingo_control_t * *)(p + 0) = a0;
  *(char const * const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_main, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_message_limit =
  { "_clingo.pyclingo_application_message_limit", (int)sizeof(unsigned int), 0, 0 };

static unsigned int pyclingo_application_message_limit(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_message_limit, p);
  return *(unsigned int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_options_parse =
  { "_clingo.pyclingo_application_options_parse", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_application_options_parse(char const * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_options_parse, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_print_model =
  { "_clingo.pyclingo_application_print_model", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_application_print_model(clingo_model_t const * a0, _Bool(* a1)(void *), void * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(clingo_model_t const * *)(p + 0) = a0;
  *(_Bool(* *)(void *))(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_print_model, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_program_name =
  { "_clingo.pyclingo_application_program_name", (int)sizeof(char const *), 0, 0 };

static char const * pyclingo_application_program_name(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_program_name, p);
  return *(char const * *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_register_options =
  { "_clingo.pyclingo_application_register_options", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_application_register_options(clingo_options_t * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(clingo_options_t * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_register_options, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_validate_options =
  { "_clingo.pyclingo_application_validate_options", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_application_validate_options(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_validate_options, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_application_version =
  { "_clingo.pyclingo_application_version", (int)sizeof(char const *), 0, 0 };

static char const * pyclingo_application_version(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__pyclingo_application_version, p);
  return *(char const * *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_ast_callback =
  { "_clingo.pyclingo_ast_callback", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_ast_callback(clingo_ast_t const * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(clingo_ast_t const * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_ast_callback, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_ground_callback =
  { "_clingo.pyclingo_ground_callback", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_ground_callback(clingo_location_t const * a0, char const * a1, uint64_t const * a2, size_t a3, void * a4, _Bool(* a5)(uint64_t const *, size_t, void *), void * a6)
{
  char a[56];
  char *p = a;
  *(clingo_location_t const * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(uint64_t const * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  *(_Bool(* *)(uint64_t const *, size_t, void *))(p + 40) = a5;
  *(void * *)(p + 48) = a6;
  _cffi_call_python(&_cffi_externpy__pyclingo_ground_callback, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_logger_callback =
  { "_clingo.pyclingo_logger_callback", 0, 0, 0 };

static void pyclingo_logger_callback(int a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_logger_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_acyc_edge =
  { "_clingo.pyclingo_observer_acyc_edge", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_acyc_edge(int a0, int a1, int32_t const * a2, size_t a3, void * a4)
{
  char a[40];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int32_t const * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_acyc_edge, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_assume =
  { "_clingo.pyclingo_observer_assume", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_assume(int32_t const * a0, size_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(int32_t const * *)(p + 0) = a0;
  *(size_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_assume, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_begin_step =
  { "_clingo.pyclingo_observer_begin_step", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_begin_step(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_begin_step, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_end_step =
  { "_clingo.pyclingo_observer_end_step", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_end_step(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_end_step, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_external =
  { "_clingo.pyclingo_observer_external", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_external(uint32_t a0, int a1, void * a2)
{
  char a[24];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_external, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_heuristic =
  { "_clingo.pyclingo_observer_heuristic", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_heuristic(uint32_t a0, int a1, int a2, unsigned int a3, int32_t const * a4, size_t a5, void * a6)
{
  char a[56];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(unsigned int *)(p + 24) = a3;
  *(int32_t const * *)(p + 32) = a4;
  *(size_t *)(p + 40) = a5;
  *(void * *)(p + 48) = a6;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_heuristic, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_init_program =
  { "_clingo.pyclingo_observer_init_program", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_init_program(_Bool a0, void * a1)
{
  char a[16];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_init_program, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_minimize =
  { "_clingo.pyclingo_observer_minimize", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_minimize(int32_t a0, clingo_weighted_literal_t const * a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(int32_t *)(p + 0) = a0;
  *(clingo_weighted_literal_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_minimize, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_output_atom =
  { "_clingo.pyclingo_observer_output_atom", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_output_atom(uint64_t a0, uint32_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(uint64_t *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_output_atom, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_output_term =
  { "_clingo.pyclingo_observer_output_term", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_output_term(uint64_t a0, int32_t const * a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(uint64_t *)(p + 0) = a0;
  *(int32_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_output_term, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_project =
  { "_clingo.pyclingo_observer_project", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_project(uint32_t const * a0, size_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(uint32_t const * *)(p + 0) = a0;
  *(size_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_project, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_rule =
  { "_clingo.pyclingo_observer_rule", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_rule(_Bool a0, uint32_t const * a1, size_t a2, int32_t const * a3, size_t a4, void * a5)
{
  char a[48];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(uint32_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(int32_t const * *)(p + 24) = a3;
  *(size_t *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_rule, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_theory_atom =
  { "_clingo.pyclingo_observer_theory_atom", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_theory_atom(uint32_t a0, uint32_t a1, uint32_t const * a2, size_t a3, void * a4)
{
  char a[40];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(uint32_t const * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_theory_atom, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_theory_atom_with_guard =
  { "_clingo.pyclingo_observer_theory_atom_with_guard", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_theory_atom_with_guard(uint32_t a0, uint32_t a1, uint32_t const * a2, size_t a3, uint32_t a4, uint32_t a5, void * a6)
{
  char a[56];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(uint32_t const * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(uint32_t *)(p + 32) = a4;
  *(uint32_t *)(p + 40) = a5;
  *(void * *)(p + 48) = a6;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_theory_atom_with_guard, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_theory_element =
  { "_clingo.pyclingo_observer_theory_element", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_theory_element(uint32_t a0, uint32_t const * a1, size_t a2, int32_t const * a3, size_t a4, void * a5)
{
  char a[48];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(uint32_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(int32_t const * *)(p + 24) = a3;
  *(size_t *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_theory_element, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_theory_term_compound =
  { "_clingo.pyclingo_observer_theory_term_compound", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_theory_term_compound(uint32_t a0, int a1, uint32_t const * a2, size_t a3, void * a4)
{
  char a[40];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(uint32_t const * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_theory_term_compound, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_theory_term_number =
  { "_clingo.pyclingo_observer_theory_term_number", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_theory_term_number(uint32_t a0, int a1, void * a2)
{
  char a[24];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_theory_term_number, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_theory_term_string =
  { "_clingo.pyclingo_observer_theory_term_string", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_theory_term_string(uint32_t a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_theory_term_string, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_observer_weight_rule =
  { "_clingo.pyclingo_observer_weight_rule", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_observer_weight_rule(_Bool a0, uint32_t const * a1, size_t a2, int32_t a3, clingo_weighted_literal_t const * a4, size_t a5, void * a6)
{
  char a[56];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(uint32_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(int32_t *)(p + 24) = a3;
  *(clingo_weighted_literal_t const * *)(p + 32) = a4;
  *(size_t *)(p + 40) = a5;
  *(void * *)(p + 48) = a6;
  _cffi_call_python(&_cffi_externpy__pyclingo_observer_weight_rule, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_propagator_check =
  { "_clingo.pyclingo_propagator_check", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_propagator_check(clingo_propagate_control_t * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(clingo_propagate_control_t * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_propagator_check, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_propagator_decide =
  { "_clingo.pyclingo_propagator_decide", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_propagator_decide(uint32_t a0, clingo_assignment_t const * a1, int32_t a2, void * a3, int32_t * a4)
{
  char a[40];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(clingo_assignment_t const * *)(p + 8) = a1;
  *(int32_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  *(int32_t * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy__pyclingo_propagator_decide, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_propagator_init =
  { "_clingo.pyclingo_propagator_init", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_propagator_init(clingo_propagate_init_t * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(clingo_propagate_init_t * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_propagator_init, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_propagator_propagate =
  { "_clingo.pyclingo_propagator_propagate", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_propagator_propagate(clingo_propagate_control_t * a0, int32_t const * a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(clingo_propagate_control_t * *)(p + 0) = a0;
  *(int32_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_propagator_propagate, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_propagator_undo =
  { "_clingo.pyclingo_propagator_undo", 0, 0, 0 };

static void pyclingo_propagator_undo(clingo_propagate_control_t const * a0, int32_t const * a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(clingo_propagate_control_t const * *)(p + 0) = a0;
  *(int32_t const * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_propagator_undo, p);
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_script_call =
  { "_clingo.pyclingo_script_call", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_script_call(clingo_location_t * a0, char const * a1, void * a2, size_t a3, void * a4, void * a5, void * a6)
{
  char a[56];
  char *p = a;
  *(clingo_location_t * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  *(void * *)(p + 48) = a6;
  _cffi_call_python(&_cffi_externpy__pyclingo_script_call, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_script_callable =
  { "_clingo.pyclingo_script_callable", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_script_callable(char const * a0, _Bool * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(_Bool * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_script_callable, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_script_execute =
  { "_clingo.pyclingo_script_execute", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_script_execute(clingo_location_t * a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(clingo_location_t * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__pyclingo_script_execute, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_script_main =
  { "_clingo.pyclingo_script_main", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_script_main(clingo_control_t * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(clingo_control_t * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__pyclingo_script_main, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__pyclingo_solve_event_callback =
  { "_clingo.pyclingo_solve_event_callback", (int)sizeof(_Bool), 0, 0 };

static _Bool pyclingo_solve_event_callback(unsigned int a0, void * a1, void * a2, _Bool * a3)
{
  char a[32];
  char *p = a;
  *(unsigned int *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  *(_Bool * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__pyclingo_solve_event_callback, p);
  return *(_Bool *)p;
}

static _Bool _cffi_d_clingo_add_string(char const * x0, char const * * x1)
{
  return clingo_add_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_add_string(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_add_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_add_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_add_string _cffi_d_clingo_add_string
#endif

static _Bool _cffi_d_clingo_assignment_at(clingo_assignment_t const * x0, size_t x1, int32_t * x2)
{
  return clingo_assignment_at(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_at(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  size_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_at", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_at(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_at _cffi_d_clingo_assignment_at
#endif

static _Bool _cffi_d_clingo_assignment_decision(clingo_assignment_t const * x0, uint32_t x1, int32_t * x2)
{
  return clingo_assignment_decision(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_decision(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  uint32_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_decision", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_decision(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_decision _cffi_d_clingo_assignment_decision
#endif

static uint32_t _cffi_d_clingo_assignment_decision_level(clingo_assignment_t const * x0)
{
  return clingo_assignment_decision_level(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_decision_level(PyObject *self, PyObject *arg0)
{
  clingo_assignment_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_decision_level(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_decision_level _cffi_d_clingo_assignment_decision_level
#endif

static _Bool _cffi_d_clingo_assignment_has_conflict(clingo_assignment_t const * x0)
{
  return clingo_assignment_has_conflict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_has_conflict(PyObject *self, PyObject *arg0)
{
  clingo_assignment_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_has_conflict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_has_conflict _cffi_d_clingo_assignment_has_conflict
#endif

static _Bool _cffi_d_clingo_assignment_has_literal(clingo_assignment_t const * x0, int32_t x1)
{
  return clingo_assignment_has_literal(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_has_literal(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_has_literal", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_has_literal(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_has_literal _cffi_d_clingo_assignment_has_literal
#endif

static _Bool _cffi_d_clingo_assignment_is_false(clingo_assignment_t const * x0, int32_t x1, _Bool * x2)
{
  return clingo_assignment_is_false(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_is_false(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  int32_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_is_false", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_is_false(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_is_false _cffi_d_clingo_assignment_is_false
#endif

static _Bool _cffi_d_clingo_assignment_is_fixed(clingo_assignment_t const * x0, int32_t x1, _Bool * x2)
{
  return clingo_assignment_is_fixed(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_is_fixed(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  int32_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_is_fixed", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_is_fixed(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_is_fixed _cffi_d_clingo_assignment_is_fixed
#endif

static _Bool _cffi_d_clingo_assignment_is_total(clingo_assignment_t const * x0)
{
  return clingo_assignment_is_total(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_is_total(PyObject *self, PyObject *arg0)
{
  clingo_assignment_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_is_total(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_is_total _cffi_d_clingo_assignment_is_total
#endif

static _Bool _cffi_d_clingo_assignment_is_true(clingo_assignment_t const * x0, int32_t x1, _Bool * x2)
{
  return clingo_assignment_is_true(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_is_true(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  int32_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_is_true", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_is_true(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_is_true _cffi_d_clingo_assignment_is_true
#endif

static _Bool _cffi_d_clingo_assignment_level(clingo_assignment_t const * x0, int32_t x1, uint32_t * x2)
{
  return clingo_assignment_level(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_level(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  int32_t x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_level", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_level(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_level _cffi_d_clingo_assignment_level
#endif

static uint32_t _cffi_d_clingo_assignment_root_level(clingo_assignment_t const * x0)
{
  return clingo_assignment_root_level(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_root_level(PyObject *self, PyObject *arg0)
{
  clingo_assignment_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_root_level(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_root_level _cffi_d_clingo_assignment_root_level
#endif

static size_t _cffi_d_clingo_assignment_size(clingo_assignment_t const * x0)
{
  return clingo_assignment_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_size(PyObject *self, PyObject *arg0)
{
  clingo_assignment_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_size _cffi_d_clingo_assignment_size
#endif

static _Bool _cffi_d_clingo_assignment_trail_at(clingo_assignment_t const * x0, uint32_t x1, int32_t * x2)
{
  return clingo_assignment_trail_at(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_trail_at(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  uint32_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_trail_at", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_trail_at(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_trail_at _cffi_d_clingo_assignment_trail_at
#endif

static _Bool _cffi_d_clingo_assignment_trail_begin(clingo_assignment_t const * x0, uint32_t x1, uint32_t * x2)
{
  return clingo_assignment_trail_begin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_trail_begin(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  uint32_t x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_trail_begin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_trail_begin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_trail_begin _cffi_d_clingo_assignment_trail_begin
#endif

static _Bool _cffi_d_clingo_assignment_trail_end(clingo_assignment_t const * x0, uint32_t x1, uint32_t * x2)
{
  return clingo_assignment_trail_end(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_trail_end(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  uint32_t x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_trail_end", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_trail_end(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_trail_end _cffi_d_clingo_assignment_trail_end
#endif

static _Bool _cffi_d_clingo_assignment_trail_size(clingo_assignment_t const * x0, uint32_t * x1)
{
  return clingo_assignment_trail_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_trail_size(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_trail_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_trail_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_trail_size _cffi_d_clingo_assignment_trail_size
#endif

static _Bool _cffi_d_clingo_assignment_truth_value(clingo_assignment_t const * x0, int32_t x1, int * x2)
{
  return clingo_assignment_truth_value(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_assignment_truth_value(PyObject *self, PyObject *args)
{
  clingo_assignment_t const * x0;
  int32_t x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_assignment_truth_value", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_assignment_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_assignment_truth_value(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_assignment_truth_value _cffi_d_clingo_assignment_truth_value
#endif

static void _cffi_d_clingo_ast_acquire(clingo_ast_t * x0)
{
  clingo_ast_acquire(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_acquire(PyObject *self, PyObject *arg0)
{
  clingo_ast_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_ast_acquire(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_ast_acquire _cffi_d_clingo_ast_acquire
#endif

static _Bool _cffi_d_clingo_ast_attribute_delete_ast_at(clingo_ast_t * x0, int x1, size_t x2)
{
  return clingo_ast_attribute_delete_ast_at(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_delete_ast_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_delete_ast_at", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_delete_ast_at(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_delete_ast_at _cffi_d_clingo_ast_attribute_delete_ast_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_delete_string_at(clingo_ast_t * x0, int x1, size_t x2)
{
  return clingo_ast_attribute_delete_string_at(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_delete_string_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_delete_string_at", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_delete_string_at(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_delete_string_at _cffi_d_clingo_ast_attribute_delete_string_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_ast(clingo_ast_t * x0, int x1, clingo_ast_t * * x2)
{
  return clingo_ast_attribute_get_ast(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_ast(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  clingo_ast_t * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_ast", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(143), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_ast_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(143), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_ast(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_ast _cffi_d_clingo_ast_attribute_get_ast
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_ast_at(clingo_ast_t * x0, int x1, size_t x2, clingo_ast_t * * x3)
{
  return clingo_ast_attribute_get_ast_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_ast_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  clingo_ast_t * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_ast_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(143), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (clingo_ast_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(143), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_ast_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_ast_at _cffi_d_clingo_ast_attribute_get_ast_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_location(clingo_ast_t * x0, int x1, clingo_location_t * x2)
{
  return clingo_ast_attribute_get_location(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_location(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  clingo_location_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_location", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_location_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_location(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_location _cffi_d_clingo_ast_attribute_get_location
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_number(clingo_ast_t * x0, int x1, int * x2)
{
  return clingo_ast_attribute_get_number(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_number(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_number", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_number(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_number _cffi_d_clingo_ast_attribute_get_number
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_optional_ast(clingo_ast_t * x0, int x1, clingo_ast_t * * x2)
{
  return clingo_ast_attribute_get_optional_ast(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_optional_ast(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  clingo_ast_t * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_optional_ast", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(143), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_ast_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(143), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_optional_ast(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_optional_ast _cffi_d_clingo_ast_attribute_get_optional_ast
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_string(clingo_ast_t * x0, int x1, char const * * x2)
{
  return clingo_ast_attribute_get_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_string(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  char const * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_string _cffi_d_clingo_ast_attribute_get_string
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_string_at(clingo_ast_t * x0, int x1, size_t x2, char const * * x3)
{
  return clingo_ast_attribute_get_string_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_string_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  char const * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_string_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_string_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_string_at _cffi_d_clingo_ast_attribute_get_string_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_get_symbol(clingo_ast_t * x0, int x1, uint64_t * x2)
{
  return clingo_ast_attribute_get_symbol(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_get_symbol(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_get_symbol", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_get_symbol(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_get_symbol _cffi_d_clingo_ast_attribute_get_symbol
#endif

static _Bool _cffi_d_clingo_ast_attribute_insert_ast_at(clingo_ast_t * x0, int x1, size_t x2, clingo_ast_t * x3)
{
  return clingo_ast_attribute_insert_ast_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_insert_ast_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  clingo_ast_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_insert_ast_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_insert_ast_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_insert_ast_at _cffi_d_clingo_ast_attribute_insert_ast_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_insert_string_at(clingo_ast_t * x0, int x1, size_t x2, char const * x3)
{
  return clingo_ast_attribute_insert_string_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_insert_string_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_insert_string_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_insert_string_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_insert_string_at _cffi_d_clingo_ast_attribute_insert_string_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_ast(clingo_ast_t * x0, int x1, clingo_ast_t * x2)
{
  return clingo_ast_attribute_set_ast(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_ast(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  clingo_ast_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_ast", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_ast(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_ast _cffi_d_clingo_ast_attribute_set_ast
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_ast_at(clingo_ast_t * x0, int x1, size_t x2, clingo_ast_t * x3)
{
  return clingo_ast_attribute_set_ast_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_ast_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  clingo_ast_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_ast_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_ast_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_ast_at _cffi_d_clingo_ast_attribute_set_ast_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_location(clingo_ast_t * x0, int x1, clingo_location_t const * x2)
{
  return clingo_ast_attribute_set_location(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_location(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  clingo_location_t const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_location", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_location_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_location(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_location _cffi_d_clingo_ast_attribute_set_location
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_number(clingo_ast_t * x0, int x1, int x2)
{
  return clingo_ast_attribute_set_number(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_number(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_number", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_number(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_number _cffi_d_clingo_ast_attribute_set_number
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_optional_ast(clingo_ast_t * x0, int x1, clingo_ast_t * x2)
{
  return clingo_ast_attribute_set_optional_ast(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_optional_ast(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  clingo_ast_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_optional_ast", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_optional_ast(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_optional_ast _cffi_d_clingo_ast_attribute_set_optional_ast
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_string(clingo_ast_t * x0, int x1, char const * x2)
{
  return clingo_ast_attribute_set_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_string(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_string _cffi_d_clingo_ast_attribute_set_string
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_string_at(clingo_ast_t * x0, int x1, size_t x2, char const * x3)
{
  return clingo_ast_attribute_set_string_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_string_at(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_string_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_string_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_string_at _cffi_d_clingo_ast_attribute_set_string_at
#endif

static _Bool _cffi_d_clingo_ast_attribute_set_symbol(clingo_ast_t * x0, int x1, uint64_t x2)
{
  return clingo_ast_attribute_set_symbol(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_set_symbol(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  uint64_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_set_symbol", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_set_symbol(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_set_symbol _cffi_d_clingo_ast_attribute_set_symbol
#endif

static _Bool _cffi_d_clingo_ast_attribute_size_ast_array(clingo_ast_t * x0, int x1, size_t * x2)
{
  return clingo_ast_attribute_size_ast_array(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_size_ast_array(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_size_ast_array", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_size_ast_array(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_size_ast_array _cffi_d_clingo_ast_attribute_size_ast_array
#endif

static _Bool _cffi_d_clingo_ast_attribute_size_string_array(clingo_ast_t * x0, int x1, size_t * x2)
{
  return clingo_ast_attribute_size_string_array(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_size_string_array(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_size_string_array", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_size_string_array(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_size_string_array _cffi_d_clingo_ast_attribute_size_string_array
#endif

static _Bool _cffi_d_clingo_ast_attribute_type(clingo_ast_t * x0, int x1, int * x2)
{
  return clingo_ast_attribute_type(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_attribute_type(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_attribute_type", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_attribute_type(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_attribute_type _cffi_d_clingo_ast_attribute_type
#endif

static void _cffi_const_clingo_ast_build(char *o)
{
  *(_Bool(* *)(int, clingo_ast_t * *, ...))o = clingo_ast_build;
}

static _Bool _cffi_d_clingo_ast_copy(clingo_ast_t * x0, clingo_ast_t * * x1)
{
  return clingo_ast_copy(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_copy(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  clingo_ast_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_ast_copy", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(143), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_ast_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(143), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_copy _cffi_d_clingo_ast_copy
#endif

static _Bool _cffi_d_clingo_ast_deep_copy(clingo_ast_t * x0, clingo_ast_t * * x1)
{
  return clingo_ast_deep_copy(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_deep_copy(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  clingo_ast_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_ast_deep_copy", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(143), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_ast_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(143), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_deep_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_deep_copy _cffi_d_clingo_ast_deep_copy
#endif

static _Bool _cffi_d_clingo_ast_equal(clingo_ast_t * x0, clingo_ast_t * x1)
{
  return clingo_ast_equal(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_equal(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  clingo_ast_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_ast_equal", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_equal(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_equal _cffi_d_clingo_ast_equal
#endif

static _Bool _cffi_d_clingo_ast_get_type(clingo_ast_t * x0, int * x1)
{
  return clingo_ast_get_type(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_get_type(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_ast_get_type", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_get_type(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_get_type _cffi_d_clingo_ast_get_type
#endif

static _Bool _cffi_d_clingo_ast_has_attribute(clingo_ast_t * x0, int x1, _Bool * x2)
{
  return clingo_ast_has_attribute(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_has_attribute(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_has_attribute", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_has_attribute(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_has_attribute _cffi_d_clingo_ast_has_attribute
#endif

static size_t _cffi_d_clingo_ast_hash(clingo_ast_t * x0)
{
  return clingo_ast_hash(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_hash(PyObject *self, PyObject *arg0)
{
  clingo_ast_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_hash(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_hash _cffi_d_clingo_ast_hash
#endif

static _Bool _cffi_d_clingo_ast_less_than(clingo_ast_t * x0, clingo_ast_t * x1)
{
  return clingo_ast_less_than(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_less_than(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  clingo_ast_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_ast_less_than", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_less_than(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_less_than _cffi_d_clingo_ast_less_than
#endif

static _Bool _cffi_d_clingo_ast_parse_files(char const * const * x0, size_t x1, _Bool(* x2)(clingo_ast_t *, void *), void * x3, clingo_control_t * x4, void(* x5)(int, char const *, void *), void * x6, unsigned int x7)
{
  return clingo_ast_parse_files(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_parse_files(PyObject *self, PyObject *args)
{
  char const * const * x0;
  size_t x1;
  _Bool(* x2)(clingo_ast_t *, void *);
  void * x3;
  clingo_control_t * x4;
  void(* x5)(int, char const *, void *);
  void * x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "clingo_ast_parse_files", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (_Bool(*)(clingo_ast_t *, void *))_cffi_to_c_pointer(arg2, _cffi_type(24));
  if (x2 == (_Bool(*)(clingo_ast_t *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (void(*)(int, char const *, void *))_cffi_to_c_pointer(arg5, _cffi_type(27));
  if (x5 == (void(*)(int, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_parse_files(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_parse_files _cffi_d_clingo_ast_parse_files
#endif

static _Bool _cffi_d_clingo_ast_parse_string(char const * x0, _Bool(* x1)(clingo_ast_t *, void *), void * x2, clingo_control_t * x3, void(* x4)(int, char const *, void *), void * x5, unsigned int x6)
{
  return clingo_ast_parse_string(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_parse_string(PyObject *self, PyObject *args)
{
  char const * x0;
  _Bool(* x1)(clingo_ast_t *, void *);
  void * x2;
  clingo_control_t * x3;
  void(* x4)(int, char const *, void *);
  void * x5;
  unsigned int x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "clingo_ast_parse_string", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool(*)(clingo_ast_t *, void *))_cffi_to_c_pointer(arg1, _cffi_type(24));
  if (x1 == (_Bool(*)(clingo_ast_t *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(int, char const *, void *))_cffi_to_c_pointer(arg4, _cffi_type(27));
  if (x4 == (void(*)(int, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_parse_string(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_parse_string _cffi_d_clingo_ast_parse_string
#endif

static void _cffi_d_clingo_ast_release(clingo_ast_t * x0)
{
  clingo_ast_release(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_release(PyObject *self, PyObject *arg0)
{
  clingo_ast_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_ast_release(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_ast_release _cffi_d_clingo_ast_release
#endif

static _Bool _cffi_d_clingo_ast_to_string(clingo_ast_t * x0, char * x1, size_t x2)
{
  return clingo_ast_to_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_to_string(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_ast_to_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_to_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_to_string _cffi_d_clingo_ast_to_string
#endif

static _Bool _cffi_d_clingo_ast_to_string_size(clingo_ast_t * x0, size_t * x1)
{
  return clingo_ast_to_string_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_to_string_size(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_ast_to_string_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_to_string_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_to_string_size _cffi_d_clingo_ast_to_string_size
#endif

static _Bool _cffi_d_clingo_ast_unpool(clingo_ast_t * x0, int x1, _Bool(* x2)(clingo_ast_t *, void *), void * x3)
{
  return clingo_ast_unpool(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_ast_unpool(PyObject *self, PyObject *args)
{
  clingo_ast_t * x0;
  int x1;
  _Bool(* x2)(clingo_ast_t *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_ast_unpool", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (_Bool(*)(clingo_ast_t *, void *))_cffi_to_c_pointer(arg2, _cffi_type(24));
  if (x2 == (_Bool(*)(clingo_ast_t *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_ast_unpool(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_ast_unpool _cffi_d_clingo_ast_unpool
#endif

static _Bool _cffi_d_clingo_backend_acyc_edge(clingo_backend_t * x0, int x1, int x2, int32_t const * x3, size_t x4)
{
  return clingo_backend_acyc_edge(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_acyc_edge(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  int x1;
  int x2;
  int32_t const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_backend_acyc_edge", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_acyc_edge(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_acyc_edge _cffi_d_clingo_backend_acyc_edge
#endif

static _Bool _cffi_d_clingo_backend_add_atom(clingo_backend_t * x0, uint64_t * x1, uint32_t * x2)
{
  return clingo_backend_add_atom(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_add_atom(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint64_t * x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_add_atom", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_add_atom(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_add_atom _cffi_d_clingo_backend_add_atom
#endif

static _Bool _cffi_d_clingo_backend_assume(clingo_backend_t * x0, int32_t const * x1, size_t x2)
{
  return clingo_backend_assume(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_assume(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  int32_t const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_assume", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_assume(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_assume _cffi_d_clingo_backend_assume
#endif

static _Bool _cffi_d_clingo_backend_begin(clingo_backend_t * x0)
{
  return clingo_backend_begin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_begin(PyObject *self, PyObject *arg0)
{
  clingo_backend_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_begin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_begin _cffi_d_clingo_backend_begin
#endif

static _Bool _cffi_d_clingo_backend_end(clingo_backend_t * x0)
{
  return clingo_backend_end(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_end(PyObject *self, PyObject *arg0)
{
  clingo_backend_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_end(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_end _cffi_d_clingo_backend_end
#endif

static _Bool _cffi_d_clingo_backend_external(clingo_backend_t * x0, uint32_t x1, int x2)
{
  return clingo_backend_external(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_external(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint32_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_external", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_external(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_external _cffi_d_clingo_backend_external
#endif

static _Bool _cffi_d_clingo_backend_heuristic(clingo_backend_t * x0, uint32_t x1, int x2, int x3, unsigned int x4, int32_t const * x5, size_t x6)
{
  return clingo_backend_heuristic(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_heuristic(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint32_t x1;
  int x2;
  int x3;
  unsigned int x4;
  int32_t const * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "clingo_backend_heuristic", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_heuristic(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_heuristic _cffi_d_clingo_backend_heuristic
#endif

static _Bool _cffi_d_clingo_backend_minimize(clingo_backend_t * x0, int32_t x1, clingo_weighted_literal_t const * x2, size_t x3)
{
  return clingo_backend_minimize(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_minimize(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  int32_t x1;
  clingo_weighted_literal_t const * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_backend_minimize", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_weighted_literal_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_minimize(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_minimize _cffi_d_clingo_backend_minimize
#endif

static _Bool _cffi_d_clingo_backend_project(clingo_backend_t * x0, uint32_t const * x1, size_t x2)
{
  return clingo_backend_project(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_project(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint32_t const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_project", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_project(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_project _cffi_d_clingo_backend_project
#endif

static _Bool _cffi_d_clingo_backend_rule(clingo_backend_t * x0, _Bool x1, uint32_t const * x2, size_t x3, int32_t const * x4, size_t x5)
{
  return clingo_backend_rule(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_rule(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  _Bool x1;
  uint32_t const * x2;
  size_t x3;
  int32_t const * x4;
  size_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "clingo_backend_rule", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_rule(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_rule _cffi_d_clingo_backend_rule
#endif

static _Bool _cffi_d_clingo_backend_theory_atom(clingo_backend_t * x0, uint32_t x1, uint32_t x2, uint32_t const * x3, size_t x4, uint32_t * x5)
{
  return clingo_backend_theory_atom(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_atom(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t const * x3;
  size_t x4;
  uint32_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_atom", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_atom(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_atom _cffi_d_clingo_backend_theory_atom
#endif

static _Bool _cffi_d_clingo_backend_theory_atom_with_guard(clingo_backend_t * x0, uint32_t x1, uint32_t x2, uint32_t const * x3, size_t x4, char const * x5, uint32_t x6, uint32_t * x7)
{
  return clingo_backend_theory_atom_with_guard(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_atom_with_guard(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t const * x3;
  size_t x4;
  char const * x5;
  uint32_t x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_atom_with_guard", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_atom_with_guard(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_atom_with_guard _cffi_d_clingo_backend_theory_atom_with_guard
#endif

static _Bool _cffi_d_clingo_backend_theory_element(clingo_backend_t * x0, uint32_t const * x1, size_t x2, int32_t const * x3, size_t x4, uint32_t * x5)
{
  return clingo_backend_theory_element(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_element(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint32_t const * x1;
  size_t x2;
  int32_t const * x3;
  size_t x4;
  uint32_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_element", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_element(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_element _cffi_d_clingo_backend_theory_element
#endif

static _Bool _cffi_d_clingo_backend_theory_term_function(clingo_backend_t * x0, char const * x1, uint32_t const * x2, size_t x3, uint32_t * x4)
{
  return clingo_backend_theory_term_function(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_term_function(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  char const * x1;
  uint32_t const * x2;
  size_t x3;
  uint32_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_term_function", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_term_function(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_term_function _cffi_d_clingo_backend_theory_term_function
#endif

static _Bool _cffi_d_clingo_backend_theory_term_number(clingo_backend_t * x0, int x1, uint32_t * x2)
{
  return clingo_backend_theory_term_number(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_term_number(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  int x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_term_number", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_term_number(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_term_number _cffi_d_clingo_backend_theory_term_number
#endif

static _Bool _cffi_d_clingo_backend_theory_term_sequence(clingo_backend_t * x0, int x1, uint32_t const * x2, size_t x3, uint32_t * x4)
{
  return clingo_backend_theory_term_sequence(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_term_sequence(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  int x1;
  uint32_t const * x2;
  size_t x3;
  uint32_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_term_sequence", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_term_sequence(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_term_sequence _cffi_d_clingo_backend_theory_term_sequence
#endif

static _Bool _cffi_d_clingo_backend_theory_term_string(clingo_backend_t * x0, char const * x1, uint32_t * x2)
{
  return clingo_backend_theory_term_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_term_string(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  char const * x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_term_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_term_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_term_string _cffi_d_clingo_backend_theory_term_string
#endif

static _Bool _cffi_d_clingo_backend_theory_term_symbol(clingo_backend_t * x0, uint64_t x1, uint32_t * x2)
{
  return clingo_backend_theory_term_symbol(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_theory_term_symbol(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  uint64_t x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_backend_theory_term_symbol", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_theory_term_symbol(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_theory_term_symbol _cffi_d_clingo_backend_theory_term_symbol
#endif

static _Bool _cffi_d_clingo_backend_weight_rule(clingo_backend_t * x0, _Bool x1, uint32_t const * x2, size_t x3, int32_t x4, clingo_weighted_literal_t const * x5, size_t x6)
{
  return clingo_backend_weight_rule(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_backend_weight_rule(PyObject *self, PyObject *args)
{
  clingo_backend_t * x0;
  _Bool x1;
  uint32_t const * x2;
  size_t x3;
  int32_t x4;
  clingo_weighted_literal_t const * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "clingo_backend_weight_rule", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(261), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_backend_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(261), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int32_t);
  if (x4 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (clingo_weighted_literal_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_backend_weight_rule(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_backend_weight_rule _cffi_d_clingo_backend_weight_rule
#endif

static _Bool _cffi_d_clingo_configuration_array_at(clingo_configuration_t const * x0, uint32_t x1, size_t x2, uint32_t * x3)
{
  return clingo_configuration_array_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_array_at(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  size_t x2;
  uint32_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_array_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_array_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_array_at _cffi_d_clingo_configuration_array_at
#endif

static _Bool _cffi_d_clingo_configuration_array_size(clingo_configuration_t const * x0, uint32_t x1, size_t * x2)
{
  return clingo_configuration_array_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_array_size(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_array_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_array_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_array_size _cffi_d_clingo_configuration_array_size
#endif

static _Bool _cffi_d_clingo_configuration_description(clingo_configuration_t const * x0, uint32_t x1, char const * * x2)
{
  return clingo_configuration_description(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_description(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  char const * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_description", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_description(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_description _cffi_d_clingo_configuration_description
#endif

static _Bool _cffi_d_clingo_configuration_map_at(clingo_configuration_t const * x0, uint32_t x1, char const * x2, uint32_t * x3)
{
  return clingo_configuration_map_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_map_at(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  char const * x2;
  uint32_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_map_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_map_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_map_at _cffi_d_clingo_configuration_map_at
#endif

static _Bool _cffi_d_clingo_configuration_map_has_subkey(clingo_configuration_t const * x0, uint32_t x1, char const * x2, _Bool * x3)
{
  return clingo_configuration_map_has_subkey(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_map_has_subkey(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  char const * x2;
  _Bool * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_map_has_subkey", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_map_has_subkey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_map_has_subkey _cffi_d_clingo_configuration_map_has_subkey
#endif

static _Bool _cffi_d_clingo_configuration_map_size(clingo_configuration_t const * x0, uint32_t x1, size_t * x2)
{
  return clingo_configuration_map_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_map_size(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_map_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_map_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_map_size _cffi_d_clingo_configuration_map_size
#endif

static _Bool _cffi_d_clingo_configuration_map_subkey_name(clingo_configuration_t const * x0, uint32_t x1, size_t x2, char const * * x3)
{
  return clingo_configuration_map_subkey_name(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_map_subkey_name(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  size_t x2;
  char const * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_map_subkey_name", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_map_subkey_name(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_map_subkey_name _cffi_d_clingo_configuration_map_subkey_name
#endif

static _Bool _cffi_d_clingo_configuration_root(clingo_configuration_t const * x0, uint32_t * x1)
{
  return clingo_configuration_root(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_root(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_root", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_root(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_root _cffi_d_clingo_configuration_root
#endif

static _Bool _cffi_d_clingo_configuration_type(clingo_configuration_t const * x0, uint32_t x1, unsigned int * x2)
{
  return clingo_configuration_type(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_type(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_type", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(434), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(434), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_type(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_type _cffi_d_clingo_configuration_type
#endif

static _Bool _cffi_d_clingo_configuration_value_get(clingo_configuration_t const * x0, uint32_t x1, char * x2, size_t x3)
{
  return clingo_configuration_value_get(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_value_get(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  char * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_value_get", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_value_get(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_value_get _cffi_d_clingo_configuration_value_get
#endif

static _Bool _cffi_d_clingo_configuration_value_get_size(clingo_configuration_t const * x0, uint32_t x1, size_t * x2)
{
  return clingo_configuration_value_get_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_value_get_size(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_value_get_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_value_get_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_value_get_size _cffi_d_clingo_configuration_value_get_size
#endif

static _Bool _cffi_d_clingo_configuration_value_is_assigned(clingo_configuration_t const * x0, uint32_t x1, _Bool * x2)
{
  return clingo_configuration_value_is_assigned(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_value_is_assigned(PyObject *self, PyObject *args)
{
  clingo_configuration_t const * x0;
  uint32_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_value_is_assigned", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_value_is_assigned(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_value_is_assigned _cffi_d_clingo_configuration_value_is_assigned
#endif

static _Bool _cffi_d_clingo_configuration_value_set(clingo_configuration_t * x0, uint32_t x1, char const * x2)
{
  return clingo_configuration_value_set(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_configuration_value_set(PyObject *self, PyObject *args)
{
  clingo_configuration_t * x0;
  uint32_t x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_configuration_value_set", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_configuration_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_configuration_value_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_configuration_value_set _cffi_d_clingo_configuration_value_set
#endif

static _Bool _cffi_d_clingo_control_add(clingo_control_t * x0, char const * x1, char const * const * x2, size_t x3, char const * x4)
{
  return clingo_control_add(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_add(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  char const * x1;
  char const * const * x2;
  size_t x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_control_add", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_add(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_add _cffi_d_clingo_control_add
#endif

static _Bool _cffi_d_clingo_control_assign_external(clingo_control_t * x0, int32_t x1, int x2)
{
  return clingo_control_assign_external(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_assign_external(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  int32_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_control_assign_external", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_assign_external(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_assign_external _cffi_d_clingo_control_assign_external
#endif

static _Bool _cffi_d_clingo_control_backend(clingo_control_t * x0, clingo_backend_t * * x1)
{
  return clingo_control_backend(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_backend(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  clingo_backend_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_backend", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(462), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_backend_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(462), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_backend(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_backend _cffi_d_clingo_control_backend
#endif

static _Bool _cffi_d_clingo_control_clasp_facade(clingo_control_t * x0, void * * x1)
{
  return clingo_control_clasp_facade(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_clasp_facade(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  void * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_clasp_facade", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(511), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(511), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_clasp_facade(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_clasp_facade _cffi_d_clingo_control_clasp_facade
#endif

static _Bool _cffi_d_clingo_control_cleanup(clingo_control_t * x0)
{
  return clingo_control_cleanup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_cleanup(PyObject *self, PyObject *arg0)
{
  clingo_control_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_cleanup _cffi_d_clingo_control_cleanup
#endif

static _Bool _cffi_d_clingo_control_configuration(clingo_control_t * x0, clingo_configuration_t * * x1)
{
  return clingo_control_configuration(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_configuration(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  clingo_configuration_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_configuration", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(466), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_configuration_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(466), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_configuration(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_configuration _cffi_d_clingo_control_configuration
#endif

static void _cffi_d_clingo_control_free(clingo_control_t * x0)
{
  clingo_control_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_free(PyObject *self, PyObject *arg0)
{
  clingo_control_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_control_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_control_free _cffi_d_clingo_control_free
#endif

static _Bool _cffi_d_clingo_control_get_const(clingo_control_t const * x0, char const * x1, uint64_t * x2)
{
  return clingo_control_get_const(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_get_const(PyObject *self, PyObject *args)
{
  clingo_control_t const * x0;
  char const * x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_control_get_const", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_get_const(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_get_const _cffi_d_clingo_control_get_const
#endif

static _Bool _cffi_d_clingo_control_get_enable_cleanup(clingo_control_t * x0)
{
  return clingo_control_get_enable_cleanup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_get_enable_cleanup(PyObject *self, PyObject *arg0)
{
  clingo_control_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_get_enable_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_get_enable_cleanup _cffi_d_clingo_control_get_enable_cleanup
#endif

static _Bool _cffi_d_clingo_control_get_enable_enumeration_assumption(clingo_control_t * x0)
{
  return clingo_control_get_enable_enumeration_assumption(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_get_enable_enumeration_assumption(PyObject *self, PyObject *arg0)
{
  clingo_control_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_get_enable_enumeration_assumption(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_get_enable_enumeration_assumption _cffi_d_clingo_control_get_enable_enumeration_assumption
#endif

static _Bool _cffi_d_clingo_control_ground(clingo_control_t * x0, clingo_part_t const * x1, size_t x2, _Bool(* x3)(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *), void * x4)
{
  return clingo_control_ground(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_ground(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  clingo_part_t const * x1;
  size_t x2;
  _Bool(* x3)(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_control_ground", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(476), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_part_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(476), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (_Bool(*)(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *))_cffi_to_c_pointer(arg3, _cffi_type(478));
  if (x3 == (_Bool(*)(clingo_location_t const *, char const *, uint64_t const *, size_t, void *, _Bool(*)(uint64_t const *, size_t, void *), void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_ground(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_ground _cffi_d_clingo_control_ground
#endif

static _Bool _cffi_d_clingo_control_has_const(clingo_control_t const * x0, char const * x1, _Bool * x2)
{
  return clingo_control_has_const(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_has_const(PyObject *self, PyObject *args)
{
  clingo_control_t const * x0;
  char const * x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_control_has_const", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_has_const(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_has_const _cffi_d_clingo_control_has_const
#endif

static void _cffi_d_clingo_control_interrupt(clingo_control_t * x0)
{
  clingo_control_interrupt(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_interrupt(PyObject *self, PyObject *arg0)
{
  clingo_control_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_control_interrupt(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_control_interrupt _cffi_d_clingo_control_interrupt
#endif

static _Bool _cffi_d_clingo_control_is_conflicting(clingo_control_t const * x0)
{
  return clingo_control_is_conflicting(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_is_conflicting(PyObject *self, PyObject *arg0)
{
  clingo_control_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_is_conflicting(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_is_conflicting _cffi_d_clingo_control_is_conflicting
#endif

static _Bool _cffi_d_clingo_control_load(clingo_control_t * x0, char const * x1)
{
  return clingo_control_load(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_load(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_load", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_load(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_load _cffi_d_clingo_control_load
#endif

static _Bool _cffi_d_clingo_control_new(char const * const * x0, size_t x1, void(* x2)(int, char const *, void *), void * x3, unsigned int x4, clingo_control_t * * x5)
{
  return clingo_control_new(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_new(PyObject *self, PyObject *args)
{
  char const * const * x0;
  size_t x1;
  void(* x2)(int, char const *, void *);
  void * x3;
  unsigned int x4;
  clingo_control_t * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "clingo_control_new", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(int, char const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(27));
  if (x2 == (void(*)(int, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (clingo_control_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_new(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_new _cffi_d_clingo_control_new
#endif

static _Bool _cffi_d_clingo_control_register_observer(clingo_control_t * x0, clingo_ground_program_observer_t const * x1, _Bool x2, void * x3)
{
  return clingo_control_register_observer(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_register_observer(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  clingo_ground_program_observer_t const * x1;
  _Bool x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_control_register_observer", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(470), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_ground_program_observer_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(470), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (_Bool)_cffi_to_c__Bool(arg2);
  if (x2 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_register_observer(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_register_observer _cffi_d_clingo_control_register_observer
#endif

static _Bool _cffi_d_clingo_control_register_propagator(clingo_control_t * x0, clingo_propagator_t const * x1, void * x2, _Bool x3)
{
  return clingo_control_register_propagator(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_register_propagator(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  clingo_propagator_t const * x1;
  void * x2;
  _Bool x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_control_register_propagator", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(487), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_propagator_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(487), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_register_propagator(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_register_propagator _cffi_d_clingo_control_register_propagator
#endif

static _Bool _cffi_d_clingo_control_release_external(clingo_control_t * x0, int32_t x1)
{
  return clingo_control_release_external(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_release_external(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_release_external", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_release_external(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_release_external _cffi_d_clingo_control_release_external
#endif

static _Bool _cffi_d_clingo_control_set_enable_cleanup(clingo_control_t * x0, _Bool x1)
{
  return clingo_control_set_enable_cleanup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_set_enable_cleanup(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_set_enable_cleanup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_set_enable_cleanup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_set_enable_cleanup _cffi_d_clingo_control_set_enable_cleanup
#endif

static _Bool _cffi_d_clingo_control_set_enable_enumeration_assumption(clingo_control_t * x0, _Bool x1)
{
  return clingo_control_set_enable_enumeration_assumption(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_set_enable_enumeration_assumption(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_set_enable_enumeration_assumption", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_set_enable_enumeration_assumption(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_set_enable_enumeration_assumption _cffi_d_clingo_control_set_enable_enumeration_assumption
#endif

static _Bool _cffi_d_clingo_control_solve(clingo_control_t * x0, unsigned int x1, int32_t const * x2, size_t x3, _Bool(* x4)(unsigned int, void *, void *, _Bool *), void * x5, clingo_solve_handle_t * * x6)
{
  return clingo_control_solve(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_solve(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  unsigned int x1;
  int32_t const * x2;
  size_t x3;
  _Bool(* x4)(unsigned int, void *, void *, _Bool *);
  void * x5;
  clingo_solve_handle_t * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "clingo_control_solve", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = (_Bool(*)(unsigned int, void *, void *, _Bool *))_cffi_to_c_pointer(arg4, _cffi_type(505));
  if (x4 == (_Bool(*)(unsigned int, void *, void *, _Bool *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(507), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(507), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_solve(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_solve _cffi_d_clingo_control_solve
#endif

static _Bool _cffi_d_clingo_control_statistics(clingo_control_t const * x0, clingo_statistics_t const * * x1)
{
  return clingo_control_statistics(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_statistics(PyObject *self, PyObject *args)
{
  clingo_control_t const * x0;
  clingo_statistics_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_statistics", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(532), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(532), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_statistics(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_statistics _cffi_d_clingo_control_statistics
#endif

static _Bool _cffi_d_clingo_control_symbolic_atoms(clingo_control_t const * x0, clingo_symbolic_atoms_t const * * x1)
{
  return clingo_control_symbolic_atoms(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_symbolic_atoms(PyObject *self, PyObject *args)
{
  clingo_control_t const * x0;
  clingo_symbolic_atoms_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_symbolic_atoms", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(536), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(536), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_symbolic_atoms(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_symbolic_atoms _cffi_d_clingo_control_symbolic_atoms
#endif

static _Bool _cffi_d_clingo_control_theory_atoms(clingo_control_t const * x0, clingo_theory_atoms_t const * * x1)
{
  return clingo_control_theory_atoms(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_control_theory_atoms(PyObject *self, PyObject *args)
{
  clingo_control_t const * x0;
  clingo_theory_atoms_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_control_theory_atoms", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(540), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(540), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_control_theory_atoms(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_control_theory_atoms _cffi_d_clingo_control_theory_atoms
#endif

static int _cffi_d_clingo_error_code(void)
{
  return clingo_error_code();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_error_code(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_error_code(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_clingo_error_code _cffi_d_clingo_error_code
#endif

static char const * _cffi_d_clingo_error_message(void)
{
  return clingo_error_message();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_error_message(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_error_message(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  return pyresult;
}
#else
#  define _cffi_f_clingo_error_message _cffi_d_clingo_error_message
#endif

static char const * _cffi_d_clingo_error_string(int x0)
{
  return clingo_error_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_error_string(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  return pyresult;
}
#else
#  define _cffi_f_clingo_error_string _cffi_d_clingo_error_string
#endif

static int _cffi_d_clingo_main(clingo_application_t * x0, char const * const * x1, size_t x2, void * x3)
{
  return clingo_main(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_main(PyObject *self, PyObject *args)
{
  clingo_application_t * x0;
  char const * const * x1;
  size_t x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_main", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1132), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_application_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1132), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_main(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_main _cffi_d_clingo_main
#endif

static _Bool _cffi_d_clingo_model_contains(clingo_model_t const * x0, uint64_t x1, _Bool * x2)
{
  return clingo_model_contains(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_contains(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  uint64_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_contains", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_contains(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_contains _cffi_d_clingo_model_contains
#endif

static _Bool _cffi_d_clingo_model_context(clingo_model_t const * x0, clingo_solve_control_t * * x1)
{
  return clingo_model_context(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_context(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  clingo_solve_control_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_model_context", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(596), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_solve_control_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(596), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_context(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_context _cffi_d_clingo_model_context
#endif

static _Bool _cffi_d_clingo_model_cost(clingo_model_t const * x0, int64_t * x1, size_t x2)
{
  return clingo_model_cost(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_cost(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  int64_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_cost", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(619), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(619), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_cost(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_cost _cffi_d_clingo_model_cost
#endif

static _Bool _cffi_d_clingo_model_cost_size(clingo_model_t const * x0, size_t * x1)
{
  return clingo_model_cost_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_cost_size(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_model_cost_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_cost_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_cost_size _cffi_d_clingo_model_cost_size
#endif

static _Bool _cffi_d_clingo_model_extend(clingo_model_t * x0, uint64_t const * x1, size_t x2)
{
  return clingo_model_extend(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_extend(PyObject *self, PyObject *args)
{
  clingo_model_t * x0;
  uint64_t const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_extend", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(580), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(580), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(79), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_extend(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_extend _cffi_d_clingo_model_extend
#endif

static _Bool _cffi_d_clingo_model_is_consequence(clingo_model_t const * x0, int32_t x1, int * x2)
{
  return clingo_model_is_consequence(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_is_consequence(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  int32_t x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_is_consequence", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_is_consequence(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_is_consequence _cffi_d_clingo_model_is_consequence
#endif

static _Bool _cffi_d_clingo_model_is_true(clingo_model_t const * x0, int32_t x1, _Bool * x2)
{
  return clingo_model_is_true(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_is_true(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  int32_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_is_true", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_is_true(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_is_true _cffi_d_clingo_model_is_true
#endif

static _Bool _cffi_d_clingo_model_number(clingo_model_t const * x0, uint64_t * x1)
{
  return clingo_model_number(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_number(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  uint64_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_model_number", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_number(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_number _cffi_d_clingo_model_number
#endif

static _Bool _cffi_d_clingo_model_optimality_proven(clingo_model_t const * x0, _Bool * x1)
{
  return clingo_model_optimality_proven(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_optimality_proven(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  _Bool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_model_optimality_proven", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_optimality_proven(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_optimality_proven _cffi_d_clingo_model_optimality_proven
#endif

static _Bool _cffi_d_clingo_model_priority(clingo_model_t const * x0, int32_t * x1, size_t x2)
{
  return clingo_model_priority(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_priority(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  int32_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_priority", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_priority(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_priority _cffi_d_clingo_model_priority
#endif

static _Bool _cffi_d_clingo_model_symbols(clingo_model_t const * x0, unsigned int x1, uint64_t * x2, size_t x3)
{
  return clingo_model_symbols(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_symbols(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  unsigned int x1;
  uint64_t * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_model_symbols", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_symbols(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_symbols _cffi_d_clingo_model_symbols
#endif

static _Bool _cffi_d_clingo_model_symbols_size(clingo_model_t const * x0, unsigned int x1, size_t * x2)
{
  return clingo_model_symbols_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_symbols_size(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  unsigned int x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_model_symbols_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_symbols_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_symbols_size _cffi_d_clingo_model_symbols_size
#endif

static _Bool _cffi_d_clingo_model_thread_id(clingo_model_t const * x0, uint32_t * x1)
{
  return clingo_model_thread_id(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_thread_id(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_model_thread_id", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_thread_id(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_thread_id _cffi_d_clingo_model_thread_id
#endif

static _Bool _cffi_d_clingo_model_type(clingo_model_t const * x0, int * x1)
{
  return clingo_model_type(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_model_type(PyObject *self, PyObject *args)
{
  clingo_model_t const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_model_type", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(585), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_model_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(585), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_model_type(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_model_type _cffi_d_clingo_model_type
#endif

static _Bool _cffi_d_clingo_options_add(clingo_options_t * x0, char const * x1, char const * x2, char const * x3, _Bool(* x4)(char const *, void *), void * x5, _Bool x6, char const * x7)
{
  return clingo_options_add(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_options_add(PyObject *self, PyObject *args)
{
  clingo_options_t * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  _Bool(* x4)(char const *, void *);
  void * x5;
  _Bool x6;
  char const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "clingo_options_add", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_options_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (_Bool(*)(char const *, void *))_cffi_to_c_pointer(arg4, _cffi_type(662));
  if (x4 == (_Bool(*)(char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = (_Bool)_cffi_to_c__Bool(arg6);
  if (x6 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_options_add(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_options_add _cffi_d_clingo_options_add
#endif

static _Bool _cffi_d_clingo_options_add_flag(clingo_options_t * x0, char const * x1, char const * x2, char const * x3, _Bool * x4)
{
  return clingo_options_add_flag(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_options_add_flag(PyObject *self, PyObject *args)
{
  clingo_options_t * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  _Bool * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_options_add_flag", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_options_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_options_add_flag(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_options_add_flag _cffi_d_clingo_options_add_flag
#endif

static _Bool _cffi_d_clingo_parse_term(char const * x0, void(* x1)(int, char const *, void *), void * x2, unsigned int x3, uint64_t * x4)
{
  return clingo_parse_term(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_parse_term(PyObject *self, PyObject *args)
{
  char const * x0;
  void(* x1)(int, char const *, void *);
  void * x2;
  unsigned int x3;
  uint64_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_parse_term", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(int, char const *, void *))_cffi_to_c_pointer(arg1, _cffi_type(27));
  if (x1 == (void(*)(int, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_parse_term(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_parse_term _cffi_d_clingo_parse_term
#endif

static _Bool _cffi_d_clingo_program_builder_add(clingo_program_builder_t * x0, clingo_ast_t * x1)
{
  return clingo_program_builder_add(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_program_builder_add(PyObject *self, PyObject *args)
{
  clingo_program_builder_t * x0;
  clingo_ast_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_program_builder_add", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(672), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_program_builder_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(672), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_ast_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_program_builder_add(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_program_builder_add _cffi_d_clingo_program_builder_add
#endif

static _Bool _cffi_d_clingo_program_builder_begin(clingo_program_builder_t * x0)
{
  return clingo_program_builder_begin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_program_builder_begin(PyObject *self, PyObject *arg0)
{
  clingo_program_builder_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(672), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_program_builder_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(672), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_program_builder_begin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_program_builder_begin _cffi_d_clingo_program_builder_begin
#endif

static _Bool _cffi_d_clingo_program_builder_end(clingo_program_builder_t * x0)
{
  return clingo_program_builder_end(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_program_builder_end(PyObject *self, PyObject *arg0)
{
  clingo_program_builder_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(672), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_program_builder_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(672), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_program_builder_end(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_program_builder_end _cffi_d_clingo_program_builder_end
#endif

static _Bool _cffi_d_clingo_program_builder_init(clingo_control_t * x0, clingo_program_builder_t * * x1)
{
  return clingo_program_builder_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_program_builder_init(PyObject *self, PyObject *args)
{
  clingo_control_t * x0;
  clingo_program_builder_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_program_builder_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(483), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_program_builder_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(483), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_program_builder_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_program_builder_init _cffi_d_clingo_program_builder_init
#endif

static _Bool _cffi_d_clingo_propagate_control_add_clause(clingo_propagate_control_t * x0, int32_t const * x1, size_t x2, int x3, _Bool * x4)
{
  return clingo_propagate_control_add_clause(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_add_clause(PyObject *self, PyObject *args)
{
  clingo_propagate_control_t * x0;
  int32_t const * x1;
  size_t x2;
  int x3;
  _Bool * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_control_add_clause", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(679), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(679), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_add_clause(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_add_clause _cffi_d_clingo_propagate_control_add_clause
#endif

static _Bool _cffi_d_clingo_propagate_control_add_literal(clingo_propagate_control_t * x0, int32_t * x1)
{
  return clingo_propagate_control_add_literal(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_add_literal(PyObject *self, PyObject *args)
{
  clingo_propagate_control_t * x0;
  int32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_control_add_literal", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(679), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(679), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_add_literal(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_add_literal _cffi_d_clingo_propagate_control_add_literal
#endif

static _Bool _cffi_d_clingo_propagate_control_add_watch(clingo_propagate_control_t * x0, int32_t x1)
{
  return clingo_propagate_control_add_watch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_add_watch(PyObject *self, PyObject *args)
{
  clingo_propagate_control_t * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_control_add_watch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(679), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(679), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_add_watch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_add_watch _cffi_d_clingo_propagate_control_add_watch
#endif

static clingo_assignment_t const * _cffi_d_clingo_propagate_control_assignment(clingo_propagate_control_t const * x0)
{
  return clingo_propagate_control_assignment(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_assignment(PyObject *self, PyObject *arg0)
{
  clingo_propagate_control_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  clingo_assignment_t const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(708), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(708), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_assignment(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(96));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_assignment _cffi_d_clingo_propagate_control_assignment
#endif

static _Bool _cffi_d_clingo_propagate_control_has_watch(clingo_propagate_control_t const * x0, int32_t x1)
{
  return clingo_propagate_control_has_watch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_has_watch(PyObject *self, PyObject *args)
{
  clingo_propagate_control_t const * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_control_has_watch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(708), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(708), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_has_watch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_has_watch _cffi_d_clingo_propagate_control_has_watch
#endif

static _Bool _cffi_d_clingo_propagate_control_propagate(clingo_propagate_control_t * x0, _Bool * x1)
{
  return clingo_propagate_control_propagate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_propagate(PyObject *self, PyObject *args)
{
  clingo_propagate_control_t * x0;
  _Bool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_control_propagate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(679), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(679), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_propagate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_propagate _cffi_d_clingo_propagate_control_propagate
#endif

static void _cffi_d_clingo_propagate_control_remove_watch(clingo_propagate_control_t * x0, int32_t x1)
{
  clingo_propagate_control_remove_watch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_remove_watch(PyObject *self, PyObject *args)
{
  clingo_propagate_control_t * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_control_remove_watch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(679), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(679), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_propagate_control_remove_watch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_propagate_control_remove_watch _cffi_d_clingo_propagate_control_remove_watch
#endif

static uint32_t _cffi_d_clingo_propagate_control_thread_id(clingo_propagate_control_t const * x0)
{
  return clingo_propagate_control_thread_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_control_thread_id(PyObject *self, PyObject *arg0)
{
  clingo_propagate_control_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(708), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(708), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_control_thread_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_control_thread_id _cffi_d_clingo_propagate_control_thread_id
#endif

static _Bool _cffi_d_clingo_propagate_init_add_clause(clingo_propagate_init_t * x0, int32_t const * x1, size_t x2, _Bool * x3)
{
  return clingo_propagate_init_add_clause(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_add_clause(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t const * x1;
  size_t x2;
  _Bool * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_add_clause", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_add_clause(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_add_clause _cffi_d_clingo_propagate_init_add_clause
#endif

static _Bool _cffi_d_clingo_propagate_init_add_literal(clingo_propagate_init_t * x0, _Bool x1, int32_t * x2)
{
  return clingo_propagate_init_add_literal(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_add_literal(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  _Bool x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_add_literal", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_add_literal(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_add_literal _cffi_d_clingo_propagate_init_add_literal
#endif

static _Bool _cffi_d_clingo_propagate_init_add_minimize(clingo_propagate_init_t * x0, int32_t x1, int32_t x2, int32_t x3)
{
  return clingo_propagate_init_add_minimize(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_add_minimize(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  int32_t x2;
  int32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_add_minimize", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_add_minimize(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_add_minimize _cffi_d_clingo_propagate_init_add_minimize
#endif

static _Bool _cffi_d_clingo_propagate_init_add_watch(clingo_propagate_init_t * x0, int32_t x1)
{
  return clingo_propagate_init_add_watch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_add_watch(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_add_watch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_add_watch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_add_watch _cffi_d_clingo_propagate_init_add_watch
#endif

static _Bool _cffi_d_clingo_propagate_init_add_watch_to_thread(clingo_propagate_init_t * x0, int32_t x1, uint32_t x2)
{
  return clingo_propagate_init_add_watch_to_thread(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_add_watch_to_thread(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_add_watch_to_thread", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_add_watch_to_thread(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_add_watch_to_thread _cffi_d_clingo_propagate_init_add_watch_to_thread
#endif

static _Bool _cffi_d_clingo_propagate_init_add_weight_constraint(clingo_propagate_init_t * x0, int32_t x1, clingo_weighted_literal_t const * x2, size_t x3, int32_t x4, int x5, _Bool x6, _Bool * x7)
{
  return clingo_propagate_init_add_weight_constraint(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_add_weight_constraint(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  clingo_weighted_literal_t const * x2;
  size_t x3;
  int32_t x4;
  int x5;
  _Bool x6;
  _Bool * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_add_weight_constraint", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (clingo_weighted_literal_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int32_t);
  if (x4 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = (_Bool)_cffi_to_c__Bool(arg6);
  if (x6 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_add_weight_constraint(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_add_weight_constraint _cffi_d_clingo_propagate_init_add_weight_constraint
#endif

static clingo_assignment_t const * _cffi_d_clingo_propagate_init_assignment(clingo_propagate_init_t const * x0)
{
  return clingo_propagate_init_assignment(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_assignment(PyObject *self, PyObject *arg0)
{
  clingo_propagate_init_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  clingo_assignment_t const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_assignment(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(96));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_assignment _cffi_d_clingo_propagate_init_assignment
#endif

static _Bool _cffi_d_clingo_propagate_init_freeze_literal(clingo_propagate_init_t * x0, int32_t x1)
{
  return clingo_propagate_init_freeze_literal(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_freeze_literal(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_freeze_literal", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_freeze_literal(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_freeze_literal _cffi_d_clingo_propagate_init_freeze_literal
#endif

static int _cffi_d_clingo_propagate_init_get_check_mode(clingo_propagate_init_t const * x0)
{
  return clingo_propagate_init_get_check_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_get_check_mode(PyObject *self, PyObject *arg0)
{
  clingo_propagate_init_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_get_check_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_get_check_mode _cffi_d_clingo_propagate_init_get_check_mode
#endif

static int _cffi_d_clingo_propagate_init_get_undo_mode(clingo_propagate_init_t const * x0)
{
  return clingo_propagate_init_get_undo_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_get_undo_mode(PyObject *self, PyObject *arg0)
{
  clingo_propagate_init_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_get_undo_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_get_undo_mode _cffi_d_clingo_propagate_init_get_undo_mode
#endif

static int _cffi_d_clingo_propagate_init_number_of_threads(clingo_propagate_init_t const * x0)
{
  return clingo_propagate_init_number_of_threads(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_number_of_threads(PyObject *self, PyObject *arg0)
{
  clingo_propagate_init_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_number_of_threads(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_number_of_threads _cffi_d_clingo_propagate_init_number_of_threads
#endif

static _Bool _cffi_d_clingo_propagate_init_propagate(clingo_propagate_init_t * x0, _Bool * x1)
{
  return clingo_propagate_init_propagate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_propagate(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  _Bool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_propagate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_propagate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_propagate _cffi_d_clingo_propagate_init_propagate
#endif

static _Bool _cffi_d_clingo_propagate_init_remove_watch(clingo_propagate_init_t * x0, int32_t x1)
{
  return clingo_propagate_init_remove_watch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_remove_watch(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_remove_watch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_remove_watch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_remove_watch _cffi_d_clingo_propagate_init_remove_watch
#endif

static _Bool _cffi_d_clingo_propagate_init_remove_watch_from_thread(clingo_propagate_init_t * x0, int32_t x1, uint32_t x2)
{
  return clingo_propagate_init_remove_watch_from_thread(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_remove_watch_from_thread(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_remove_watch_from_thread", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_remove_watch_from_thread(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_remove_watch_from_thread _cffi_d_clingo_propagate_init_remove_watch_from_thread
#endif

static void _cffi_d_clingo_propagate_init_set_check_mode(clingo_propagate_init_t * x0, int x1)
{
  clingo_propagate_init_set_check_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_set_check_mode(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_set_check_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_propagate_init_set_check_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_propagate_init_set_check_mode _cffi_d_clingo_propagate_init_set_check_mode
#endif

static void _cffi_d_clingo_propagate_init_set_undo_mode(clingo_propagate_init_t * x0, int x1)
{
  clingo_propagate_init_set_undo_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_set_undo_mode(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_set_undo_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(712), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(712), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_propagate_init_set_undo_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_propagate_init_set_undo_mode _cffi_d_clingo_propagate_init_set_undo_mode
#endif

static _Bool _cffi_d_clingo_propagate_init_solver_literal(clingo_propagate_init_t const * x0, int32_t x1, int32_t * x2)
{
  return clingo_propagate_init_solver_literal(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_solver_literal(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t const * x0;
  int32_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_solver_literal", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_solver_literal(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_solver_literal _cffi_d_clingo_propagate_init_solver_literal
#endif

static _Bool _cffi_d_clingo_propagate_init_symbolic_atoms(clingo_propagate_init_t const * x0, clingo_symbolic_atoms_t const * * x1)
{
  return clingo_propagate_init_symbolic_atoms(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_symbolic_atoms(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t const * x0;
  clingo_symbolic_atoms_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_symbolic_atoms", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(536), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(536), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_symbolic_atoms(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_symbolic_atoms _cffi_d_clingo_propagate_init_symbolic_atoms
#endif

static _Bool _cffi_d_clingo_propagate_init_theory_atoms(clingo_propagate_init_t const * x0, clingo_theory_atoms_t const * * x1)
{
  return clingo_propagate_init_theory_atoms(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_propagate_init_theory_atoms(PyObject *self, PyObject *args)
{
  clingo_propagate_init_t const * x0;
  clingo_theory_atoms_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_propagate_init_theory_atoms", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_propagate_init_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(540), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(540), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_propagate_init_theory_atoms(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_propagate_init_theory_atoms _cffi_d_clingo_propagate_init_theory_atoms
#endif

static _Bool _cffi_d_clingo_register_script(char const * x0, clingo_script_t const * x1, void * x2)
{
  return clingo_register_script(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_register_script(PyObject *self, PyObject *args)
{
  char const * x0;
  clingo_script_t const * x1;
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_register_script", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(64), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_script_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(64), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_register_script(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_register_script _cffi_d_clingo_register_script
#endif

static char const * _cffi_d_clingo_script_version(char const * x0)
{
  return clingo_script_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_script_version(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_script_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_script_version _cffi_d_clingo_script_version
#endif

static void _cffi_d_clingo_set_error(int x0, char const * x1)
{
  clingo_set_error(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_set_error(PyObject *self, PyObject *args)
{
  int x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_set_error", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_set_error(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_set_error _cffi_d_clingo_set_error
#endif

static uint32_t _cffi_d_clingo_signature_arity(uint64_t x0)
{
  return clingo_signature_arity(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_arity(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_arity(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_arity _cffi_d_clingo_signature_arity
#endif

static _Bool _cffi_d_clingo_signature_create(char const * x0, uint32_t x1, _Bool x2, uint64_t * x3)
{
  return clingo_signature_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_create(PyObject *self, PyObject *args)
{
  char const * x0;
  uint32_t x1;
  _Bool x2;
  uint64_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_signature_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (_Bool)_cffi_to_c__Bool(arg2);
  if (x2 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_create _cffi_d_clingo_signature_create
#endif

static size_t _cffi_d_clingo_signature_hash(uint64_t x0)
{
  return clingo_signature_hash(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_hash(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_hash(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_hash _cffi_d_clingo_signature_hash
#endif

static _Bool _cffi_d_clingo_signature_is_equal_to(uint64_t x0, uint64_t x1)
{
  return clingo_signature_is_equal_to(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_is_equal_to(PyObject *self, PyObject *args)
{
  uint64_t x0;
  uint64_t x1;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_signature_is_equal_to", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_is_equal_to(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_is_equal_to _cffi_d_clingo_signature_is_equal_to
#endif

static _Bool _cffi_d_clingo_signature_is_less_than(uint64_t x0, uint64_t x1)
{
  return clingo_signature_is_less_than(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_is_less_than(PyObject *self, PyObject *args)
{
  uint64_t x0;
  uint64_t x1;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_signature_is_less_than", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_is_less_than(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_is_less_than _cffi_d_clingo_signature_is_less_than
#endif

static _Bool _cffi_d_clingo_signature_is_negative(uint64_t x0)
{
  return clingo_signature_is_negative(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_is_negative(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_is_negative(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_is_negative _cffi_d_clingo_signature_is_negative
#endif

static _Bool _cffi_d_clingo_signature_is_positive(uint64_t x0)
{
  return clingo_signature_is_positive(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_is_positive(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_is_positive(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_is_positive _cffi_d_clingo_signature_is_positive
#endif

static char const * _cffi_d_clingo_signature_name(uint64_t x0)
{
  return clingo_signature_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_signature_name(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_signature_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  return pyresult;
}
#else
#  define _cffi_f_clingo_signature_name _cffi_d_clingo_signature_name
#endif

static _Bool _cffi_d_clingo_solve_control_add_clause(clingo_solve_control_t * x0, int32_t const * x1, size_t x2)
{
  return clingo_solve_control_add_clause(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_control_add_clause(PyObject *self, PyObject *args)
{
  clingo_solve_control_t * x0;
  int32_t const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_solve_control_add_clause", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(769), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_control_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(769), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_control_add_clause(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_control_add_clause _cffi_d_clingo_solve_control_add_clause
#endif

static _Bool _cffi_d_clingo_solve_control_symbolic_atoms(clingo_solve_control_t const * x0, clingo_symbolic_atoms_t const * * x1)
{
  return clingo_solve_control_symbolic_atoms(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_control_symbolic_atoms(PyObject *self, PyObject *args)
{
  clingo_solve_control_t const * x0;
  clingo_symbolic_atoms_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_solve_control_symbolic_atoms", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(774), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_control_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(774), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(536), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(536), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_control_symbolic_atoms(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_control_symbolic_atoms _cffi_d_clingo_solve_control_symbolic_atoms
#endif

static _Bool _cffi_d_clingo_solve_handle_cancel(clingo_solve_handle_t * x0)
{
  return clingo_solve_handle_cancel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_cancel(PyObject *self, PyObject *arg0)
{
  clingo_solve_handle_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_handle_cancel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_handle_cancel _cffi_d_clingo_solve_handle_cancel
#endif

static _Bool _cffi_d_clingo_solve_handle_close(clingo_solve_handle_t * x0)
{
  return clingo_solve_handle_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_close(PyObject *self, PyObject *arg0)
{
  clingo_solve_handle_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_handle_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_handle_close _cffi_d_clingo_solve_handle_close
#endif

static _Bool _cffi_d_clingo_solve_handle_core(clingo_solve_handle_t * x0, int32_t const * * x1, size_t * x2)
{
  return clingo_solve_handle_core(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_core(PyObject *self, PyObject *args)
{
  clingo_solve_handle_t * x0;
  int32_t const * * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_solve_handle_core", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_handle_core(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_handle_core _cffi_d_clingo_solve_handle_core
#endif

static _Bool _cffi_d_clingo_solve_handle_get(clingo_solve_handle_t * x0, unsigned int * x1)
{
  return clingo_solve_handle_get(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_get(PyObject *self, PyObject *args)
{
  clingo_solve_handle_t * x0;
  unsigned int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_solve_handle_get", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(434), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(434), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_handle_get(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_handle_get _cffi_d_clingo_solve_handle_get
#endif

static _Bool _cffi_d_clingo_solve_handle_model(clingo_solve_handle_t * x0, clingo_model_t const * * x1)
{
  return clingo_solve_handle_model(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_model(PyObject *self, PyObject *args)
{
  clingo_solve_handle_t * x0;
  clingo_model_t const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_solve_handle_model", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(782), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (clingo_model_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(782), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_handle_model(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_handle_model _cffi_d_clingo_solve_handle_model
#endif

static _Bool _cffi_d_clingo_solve_handle_resume(clingo_solve_handle_t * x0)
{
  return clingo_solve_handle_resume(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_resume(PyObject *self, PyObject *arg0)
{
  clingo_solve_handle_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_solve_handle_resume(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_solve_handle_resume _cffi_d_clingo_solve_handle_resume
#endif

static void _cffi_d_clingo_solve_handle_wait(clingo_solve_handle_t * x0, double x1, _Bool * x2)
{
  clingo_solve_handle_wait(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_solve_handle_wait(PyObject *self, PyObject *args)
{
  clingo_solve_handle_t * x0;
  double x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_solve_handle_wait", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(778), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_solve_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(778), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_solve_handle_wait(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_solve_handle_wait _cffi_d_clingo_solve_handle_wait
#endif

static _Bool _cffi_d_clingo_statistics_array_at(clingo_statistics_t const * x0, uint64_t x1, size_t x2, uint64_t * x3)
{
  return clingo_statistics_array_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_array_at(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  size_t x2;
  uint64_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_array_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_array_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_array_at _cffi_d_clingo_statistics_array_at
#endif

static _Bool _cffi_d_clingo_statistics_array_push(clingo_statistics_t * x0, uint64_t x1, int x2, uint64_t * x3)
{
  return clingo_statistics_array_push(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_array_push(PyObject *self, PyObject *args)
{
  clingo_statistics_t * x0;
  uint64_t x1;
  int x2;
  uint64_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_array_push", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(794), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(794), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_array_push(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_array_push _cffi_d_clingo_statistics_array_push
#endif

static _Bool _cffi_d_clingo_statistics_array_size(clingo_statistics_t const * x0, uint64_t x1, size_t * x2)
{
  return clingo_statistics_array_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_array_size(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_array_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_array_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_array_size _cffi_d_clingo_statistics_array_size
#endif

static _Bool _cffi_d_clingo_statistics_map_add_subkey(clingo_statistics_t * x0, uint64_t x1, char const * x2, int x3, uint64_t * x4)
{
  return clingo_statistics_map_add_subkey(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_map_add_subkey(PyObject *self, PyObject *args)
{
  clingo_statistics_t * x0;
  uint64_t x1;
  char const * x2;
  int x3;
  uint64_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_map_add_subkey", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(794), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(794), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_map_add_subkey(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_map_add_subkey _cffi_d_clingo_statistics_map_add_subkey
#endif

static _Bool _cffi_d_clingo_statistics_map_at(clingo_statistics_t const * x0, uint64_t x1, char const * x2, uint64_t * x3)
{
  return clingo_statistics_map_at(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_map_at(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  char const * x2;
  uint64_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_map_at", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_map_at(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_map_at _cffi_d_clingo_statistics_map_at
#endif

static _Bool _cffi_d_clingo_statistics_map_has_subkey(clingo_statistics_t const * x0, uint64_t x1, char const * x2, _Bool * x3)
{
  return clingo_statistics_map_has_subkey(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_map_has_subkey(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  char const * x2;
  _Bool * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_map_has_subkey", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_map_has_subkey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_map_has_subkey _cffi_d_clingo_statistics_map_has_subkey
#endif

static _Bool _cffi_d_clingo_statistics_map_size(clingo_statistics_t const * x0, uint64_t x1, size_t * x2)
{
  return clingo_statistics_map_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_map_size(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_map_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_map_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_map_size _cffi_d_clingo_statistics_map_size
#endif

static _Bool _cffi_d_clingo_statistics_map_subkey_name(clingo_statistics_t const * x0, uint64_t x1, size_t x2, char const * * x3)
{
  return clingo_statistics_map_subkey_name(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_map_subkey_name(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  size_t x2;
  char const * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_map_subkey_name", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_map_subkey_name(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_map_subkey_name _cffi_d_clingo_statistics_map_subkey_name
#endif

static _Bool _cffi_d_clingo_statistics_root(clingo_statistics_t const * x0, uint64_t * x1)
{
  return clingo_statistics_root(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_root(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_root", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_root(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_root _cffi_d_clingo_statistics_root
#endif

static _Bool _cffi_d_clingo_statistics_type(clingo_statistics_t const * x0, uint64_t x1, int * x2)
{
  return clingo_statistics_type(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_type(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_type", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_type(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_type _cffi_d_clingo_statistics_type
#endif

static _Bool _cffi_d_clingo_statistics_value_get(clingo_statistics_t const * x0, uint64_t x1, double * x2)
{
  return clingo_statistics_value_get(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_value_get(PyObject *self, PyObject *args)
{
  clingo_statistics_t const * x0;
  uint64_t x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_value_get", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(812), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(812), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(830), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(830), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_value_get(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_value_get _cffi_d_clingo_statistics_value_get
#endif

static _Bool _cffi_d_clingo_statistics_value_set(clingo_statistics_t * x0, uint64_t x1, double x2)
{
  return clingo_statistics_value_set(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_statistics_value_set(PyObject *self, PyObject *args)
{
  clingo_statistics_t * x0;
  uint64_t x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_statistics_value_set", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(794), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_statistics_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(794), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_statistics_value_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_statistics_value_set _cffi_d_clingo_statistics_value_set
#endif

static _Bool _cffi_d_clingo_symbol_arguments(uint64_t x0, uint64_t const * * x1, size_t * x2)
{
  return clingo_symbol_arguments(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_arguments(PyObject *self, PyObject *args)
{
  uint64_t x0;
  uint64_t const * * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_arguments", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1077), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1077), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_arguments(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_arguments _cffi_d_clingo_symbol_arguments
#endif

static _Bool _cffi_d_clingo_symbol_create_function(char const * x0, uint64_t const * x1, size_t x2, _Bool x3, uint64_t * x4)
{
  return clingo_symbol_create_function(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_create_function(PyObject *self, PyObject *args)
{
  char const * x0;
  uint64_t const * x1;
  size_t x2;
  _Bool x3;
  uint64_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_create_function", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(79), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_create_function(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_create_function _cffi_d_clingo_symbol_create_function
#endif

static _Bool _cffi_d_clingo_symbol_create_id(char const * x0, _Bool x1, uint64_t * x2)
{
  return clingo_symbol_create_id(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_create_id(PyObject *self, PyObject *args)
{
  char const * x0;
  _Bool x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_create_id", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_create_id(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_create_id _cffi_d_clingo_symbol_create_id
#endif

static void _cffi_d_clingo_symbol_create_infimum(uint64_t * x0)
{
  clingo_symbol_create_infimum(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_create_infimum(PyObject *self, PyObject *arg0)
{
  uint64_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_symbol_create_infimum(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_symbol_create_infimum _cffi_d_clingo_symbol_create_infimum
#endif

static void _cffi_d_clingo_symbol_create_number(int x0, uint64_t * x1)
{
  clingo_symbol_create_number(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_create_number(PyObject *self, PyObject *args)
{
  int x0;
  uint64_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_create_number", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_symbol_create_number(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_symbol_create_number _cffi_d_clingo_symbol_create_number
#endif

static _Bool _cffi_d_clingo_symbol_create_string(char const * x0, uint64_t * x1)
{
  return clingo_symbol_create_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_create_string(PyObject *self, PyObject *args)
{
  char const * x0;
  uint64_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_create_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_create_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_create_string _cffi_d_clingo_symbol_create_string
#endif

static void _cffi_d_clingo_symbol_create_supremum(uint64_t * x0)
{
  clingo_symbol_create_supremum(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_create_supremum(PyObject *self, PyObject *arg0)
{
  uint64_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_symbol_create_supremum(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_symbol_create_supremum _cffi_d_clingo_symbol_create_supremum
#endif

static size_t _cffi_d_clingo_symbol_hash(uint64_t x0)
{
  return clingo_symbol_hash(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_hash(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_hash(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_hash _cffi_d_clingo_symbol_hash
#endif

static _Bool _cffi_d_clingo_symbol_is_equal_to(uint64_t x0, uint64_t x1)
{
  return clingo_symbol_is_equal_to(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_is_equal_to(PyObject *self, PyObject *args)
{
  uint64_t x0;
  uint64_t x1;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_is_equal_to", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_is_equal_to(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_is_equal_to _cffi_d_clingo_symbol_is_equal_to
#endif

static _Bool _cffi_d_clingo_symbol_is_less_than(uint64_t x0, uint64_t x1)
{
  return clingo_symbol_is_less_than(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_is_less_than(PyObject *self, PyObject *args)
{
  uint64_t x0;
  uint64_t x1;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_is_less_than", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_is_less_than(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_is_less_than _cffi_d_clingo_symbol_is_less_than
#endif

static _Bool _cffi_d_clingo_symbol_is_negative(uint64_t x0, _Bool * x1)
{
  return clingo_symbol_is_negative(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_is_negative(PyObject *self, PyObject *args)
{
  uint64_t x0;
  _Bool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_is_negative", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_is_negative(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_is_negative _cffi_d_clingo_symbol_is_negative
#endif

static _Bool _cffi_d_clingo_symbol_is_positive(uint64_t x0, _Bool * x1)
{
  return clingo_symbol_is_positive(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_is_positive(PyObject *self, PyObject *args)
{
  uint64_t x0;
  _Bool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_is_positive", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_is_positive(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_is_positive _cffi_d_clingo_symbol_is_positive
#endif

static _Bool _cffi_d_clingo_symbol_name(uint64_t x0, char const * * x1)
{
  return clingo_symbol_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_name(PyObject *self, PyObject *args)
{
  uint64_t x0;
  char const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_name", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_name _cffi_d_clingo_symbol_name
#endif

static _Bool _cffi_d_clingo_symbol_number(uint64_t x0, int * x1)
{
  return clingo_symbol_number(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_number(PyObject *self, PyObject *args)
{
  uint64_t x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_number", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_number(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_number _cffi_d_clingo_symbol_number
#endif

static _Bool _cffi_d_clingo_symbol_string(uint64_t x0, char const * * x1)
{
  return clingo_symbol_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_string(PyObject *self, PyObject *args)
{
  uint64_t x0;
  char const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_string", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_string _cffi_d_clingo_symbol_string
#endif

static _Bool _cffi_d_clingo_symbol_to_string(uint64_t x0, char * x1, size_t x2)
{
  return clingo_symbol_to_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_to_string(PyObject *self, PyObject *args)
{
  uint64_t x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_to_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_to_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_to_string _cffi_d_clingo_symbol_to_string
#endif

static _Bool _cffi_d_clingo_symbol_to_string_size(uint64_t x0, size_t * x1)
{
  return clingo_symbol_to_string_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_to_string_size(PyObject *self, PyObject *args)
{
  uint64_t x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbol_to_string_size", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_to_string_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_to_string_size _cffi_d_clingo_symbol_to_string_size
#endif

static int _cffi_d_clingo_symbol_type(uint64_t x0)
{
  return clingo_symbol_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbol_type(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbol_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbol_type _cffi_d_clingo_symbol_type
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_begin(clingo_symbolic_atoms_t const * x0, uint64_t const * x1, uint64_t * x2)
{
  return clingo_symbolic_atoms_begin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_begin(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t const * x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_begin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(79), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_begin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_begin _cffi_d_clingo_symbolic_atoms_begin
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_end(clingo_symbolic_atoms_t const * x0, uint64_t * x1)
{
  return clingo_symbolic_atoms_end(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_end(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_end", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_end(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_end _cffi_d_clingo_symbolic_atoms_end
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_find(clingo_symbolic_atoms_t const * x0, uint64_t x1, uint64_t * x2)
{
  return clingo_symbolic_atoms_find(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_find(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_find", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_find(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_find _cffi_d_clingo_symbolic_atoms_find
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_is_external(clingo_symbolic_atoms_t const * x0, uint64_t x1, _Bool * x2)
{
  return clingo_symbolic_atoms_is_external(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_is_external(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_is_external", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_is_external(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_is_external _cffi_d_clingo_symbolic_atoms_is_external
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_is_fact(clingo_symbolic_atoms_t const * x0, uint64_t x1, _Bool * x2)
{
  return clingo_symbolic_atoms_is_fact(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_is_fact(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_is_fact", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_is_fact(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_is_fact _cffi_d_clingo_symbolic_atoms_is_fact
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_is_valid(clingo_symbolic_atoms_t const * x0, uint64_t x1, _Bool * x2)
{
  return clingo_symbolic_atoms_is_valid(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_is_valid(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_is_valid", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_is_valid(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_is_valid _cffi_d_clingo_symbolic_atoms_is_valid
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_iterator_is_equal_to(clingo_symbolic_atoms_t const * x0, uint64_t x1, uint64_t x2, _Bool * x3)
{
  return clingo_symbolic_atoms_iterator_is_equal_to(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_iterator_is_equal_to(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  uint64_t x2;
  _Bool * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_iterator_is_equal_to", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_iterator_is_equal_to(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_iterator_is_equal_to _cffi_d_clingo_symbolic_atoms_iterator_is_equal_to
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_literal(clingo_symbolic_atoms_t const * x0, uint64_t x1, int32_t * x2)
{
  return clingo_symbolic_atoms_literal(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_literal(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_literal", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_literal(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_literal _cffi_d_clingo_symbolic_atoms_literal
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_next(clingo_symbolic_atoms_t const * x0, uint64_t x1, uint64_t * x2)
{
  return clingo_symbolic_atoms_next(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_next(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_next", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_next(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_next _cffi_d_clingo_symbolic_atoms_next
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_signatures(clingo_symbolic_atoms_t const * x0, uint64_t * x1, size_t x2)
{
  return clingo_symbolic_atoms_signatures(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_signatures(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_signatures", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_signatures(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_signatures _cffi_d_clingo_symbolic_atoms_signatures
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_signatures_size(clingo_symbolic_atoms_t const * x0, size_t * x1)
{
  return clingo_symbolic_atoms_signatures_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_signatures_size(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_signatures_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_signatures_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_signatures_size _cffi_d_clingo_symbolic_atoms_signatures_size
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_size(clingo_symbolic_atoms_t const * x0, size_t * x1)
{
  return clingo_symbolic_atoms_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_size(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_size _cffi_d_clingo_symbolic_atoms_size
#endif

static _Bool _cffi_d_clingo_symbolic_atoms_symbol(clingo_symbolic_atoms_t const * x0, uint64_t x1, uint64_t * x2)
{
  return clingo_symbolic_atoms_symbol(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_symbolic_atoms_symbol(PyObject *self, PyObject *args)
{
  clingo_symbolic_atoms_t const * x0;
  uint64_t x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_symbolic_atoms_symbol", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_symbolic_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_symbolic_atoms_symbol(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_symbolic_atoms_symbol _cffi_d_clingo_symbolic_atoms_symbol
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_elements(clingo_theory_atoms_t const * x0, uint32_t x1, uint32_t const * * x2, size_t * x3)
{
  return clingo_theory_atoms_atom_elements(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_elements(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  uint32_t const * * x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_elements", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(948), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(948), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_elements(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_elements _cffi_d_clingo_theory_atoms_atom_elements
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_guard(clingo_theory_atoms_t const * x0, uint32_t x1, char const * * x2, uint32_t * x3)
{
  return clingo_theory_atoms_atom_guard(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_guard(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  char const * * x2;
  uint32_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_guard", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_guard(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_guard _cffi_d_clingo_theory_atoms_atom_guard
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_has_guard(clingo_theory_atoms_t const * x0, uint32_t x1, _Bool * x2)
{
  return clingo_theory_atoms_atom_has_guard(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_has_guard(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_has_guard", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_has_guard(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_has_guard _cffi_d_clingo_theory_atoms_atom_has_guard
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_literal(clingo_theory_atoms_t const * x0, uint32_t x1, int32_t * x2)
{
  return clingo_theory_atoms_atom_literal(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_literal(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_literal", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_literal(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_literal _cffi_d_clingo_theory_atoms_atom_literal
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_term(clingo_theory_atoms_t const * x0, uint32_t x1, uint32_t * x2)
{
  return clingo_theory_atoms_atom_term(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_term(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_term", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_term(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_term _cffi_d_clingo_theory_atoms_atom_term
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_to_string(clingo_theory_atoms_t const * x0, uint32_t x1, char * x2, size_t x3)
{
  return clingo_theory_atoms_atom_to_string(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_to_string(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  char * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_to_string", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_to_string(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_to_string _cffi_d_clingo_theory_atoms_atom_to_string
#endif

static _Bool _cffi_d_clingo_theory_atoms_atom_to_string_size(clingo_theory_atoms_t const * x0, uint32_t x1, size_t * x2)
{
  return clingo_theory_atoms_atom_to_string_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_atom_to_string_size(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_atom_to_string_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_atom_to_string_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_atom_to_string_size _cffi_d_clingo_theory_atoms_atom_to_string_size
#endif

static _Bool _cffi_d_clingo_theory_atoms_element_condition(clingo_theory_atoms_t const * x0, uint32_t x1, int32_t const * * x2, size_t * x3)
{
  return clingo_theory_atoms_element_condition(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_element_condition(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  int32_t const * * x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_element_condition", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_element_condition(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_element_condition _cffi_d_clingo_theory_atoms_element_condition
#endif

static _Bool _cffi_d_clingo_theory_atoms_element_condition_id(clingo_theory_atoms_t const * x0, uint32_t x1, int32_t * x2)
{
  return clingo_theory_atoms_element_condition_id(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_element_condition_id(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  int32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_element_condition_id", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_element_condition_id(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_element_condition_id _cffi_d_clingo_theory_atoms_element_condition_id
#endif

static _Bool _cffi_d_clingo_theory_atoms_element_to_string(clingo_theory_atoms_t const * x0, uint32_t x1, char * x2, size_t x3)
{
  return clingo_theory_atoms_element_to_string(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_element_to_string(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  char * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_element_to_string", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_element_to_string(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_element_to_string _cffi_d_clingo_theory_atoms_element_to_string
#endif

static _Bool _cffi_d_clingo_theory_atoms_element_to_string_size(clingo_theory_atoms_t const * x0, uint32_t x1, size_t * x2)
{
  return clingo_theory_atoms_element_to_string_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_element_to_string_size(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_element_to_string_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_element_to_string_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_element_to_string_size _cffi_d_clingo_theory_atoms_element_to_string_size
#endif

static _Bool _cffi_d_clingo_theory_atoms_element_tuple(clingo_theory_atoms_t const * x0, uint32_t x1, uint32_t const * * x2, size_t * x3)
{
  return clingo_theory_atoms_element_tuple(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_element_tuple(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  uint32_t const * * x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_element_tuple", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(948), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(948), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_element_tuple(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_element_tuple _cffi_d_clingo_theory_atoms_element_tuple
#endif

static _Bool _cffi_d_clingo_theory_atoms_size(clingo_theory_atoms_t const * x0, size_t * x1)
{
  return clingo_theory_atoms_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_size(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_size _cffi_d_clingo_theory_atoms_size
#endif

static _Bool _cffi_d_clingo_theory_atoms_term_arguments(clingo_theory_atoms_t const * x0, uint32_t x1, uint32_t const * * x2, size_t * x3)
{
  return clingo_theory_atoms_term_arguments(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_term_arguments(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  uint32_t const * * x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_term_arguments", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(948), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(948), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_term_arguments(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_term_arguments _cffi_d_clingo_theory_atoms_term_arguments
#endif

static _Bool _cffi_d_clingo_theory_atoms_term_name(clingo_theory_atoms_t const * x0, uint32_t x1, char const * * x2)
{
  return clingo_theory_atoms_term_name(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_term_name(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  char const * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_term_name", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_term_name(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_term_name _cffi_d_clingo_theory_atoms_term_name
#endif

static _Bool _cffi_d_clingo_theory_atoms_term_number(clingo_theory_atoms_t const * x0, uint32_t x1, int * x2)
{
  return clingo_theory_atoms_term_number(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_term_number(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_term_number", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_term_number(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_term_number _cffi_d_clingo_theory_atoms_term_number
#endif

static _Bool _cffi_d_clingo_theory_atoms_term_to_string(clingo_theory_atoms_t const * x0, uint32_t x1, char * x2, size_t x3)
{
  return clingo_theory_atoms_term_to_string(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_term_to_string(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  char * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_term_to_string", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_term_to_string(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_term_to_string _cffi_d_clingo_theory_atoms_term_to_string
#endif

static _Bool _cffi_d_clingo_theory_atoms_term_to_string_size(clingo_theory_atoms_t const * x0, uint32_t x1, size_t * x2)
{
  return clingo_theory_atoms_term_to_string_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_term_to_string_size(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_term_to_string_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_term_to_string_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_term_to_string_size _cffi_d_clingo_theory_atoms_term_to_string_size
#endif

static _Bool _cffi_d_clingo_theory_atoms_term_type(clingo_theory_atoms_t const * x0, uint32_t x1, int * x2)
{
  return clingo_theory_atoms_term_type(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_theory_atoms_term_type(PyObject *self, PyObject *args)
{
  clingo_theory_atoms_t const * x0;
  uint32_t x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_theory_atoms_term_type", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(894), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (clingo_theory_atoms_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(894), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_theory_atoms_term_type(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clingo_theory_atoms_term_type _cffi_d_clingo_theory_atoms_term_type
#endif

static void _cffi_d_clingo_version(int * x0, int * x1, int * x2)
{
  clingo_version(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_version(PyObject *self, PyObject *args)
{
  int * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "clingo_version", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clingo_version(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_clingo_version _cffi_d_clingo_version
#endif

static char const * _cffi_d_clingo_warning_string(int x0)
{
  return clingo_warning_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clingo_warning_string(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clingo_warning_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  return pyresult;
}
#else
#  define _cffi_f_clingo_warning_string _cffi_d_clingo_warning_string
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_application_t(clingo_application_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const *(* *tmp)(void *) = &p->program_name; (void)tmp; }
  { char const *(* *tmp)(void *) = &p->version; (void)tmp; }
  { unsigned int(* *tmp)(void *) = &p->message_limit; (void)tmp; }
  { _Bool(* *tmp)(clingo_control_t *, char const * const *, size_t, void *) = &p->main; (void)tmp; }
  { void(* *tmp)(int, char const *, void *) = &p->logger; (void)tmp; }
  { _Bool(* *tmp)(clingo_model_t const *, _Bool(*)(void *), void *, void *) = &p->printer; (void)tmp; }
  { _Bool(* *tmp)(clingo_options_t *, void *) = &p->register_options; (void)tmp; }
  { _Bool(* *tmp)(void *) = &p->validate_options; (void)tmp; }
}
struct _cffi_align__clingo_application_t { char x; clingo_application_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_ast_argument_t(clingo_ast_argument_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->attribute) | 0);  /* check that 'clingo_ast_argument_t.attribute' is an integer */
  (void)((p->type) | 0);  /* check that 'clingo_ast_argument_t.type' is an integer */
}
struct _cffi_align__clingo_ast_argument_t { char x; clingo_ast_argument_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_ast_attribute_names_t(clingo_ast_attribute_names_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * const * *tmp = &p->names; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'clingo_ast_attribute_names_t.size' is an integer */
}
struct _cffi_align__clingo_ast_attribute_names_t { char x; clingo_ast_attribute_names_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_ast_constructor_t(clingo_ast_constructor_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { clingo_ast_argument_t const * *tmp = &p->arguments; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'clingo_ast_constructor_t.size' is an integer */
}
struct _cffi_align__clingo_ast_constructor_t { char x; clingo_ast_constructor_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_ast_constructors_t(clingo_ast_constructors_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { clingo_ast_constructor_t const * *tmp = &p->constructors; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'clingo_ast_constructors_t.size' is an integer */
}
struct _cffi_align__clingo_ast_constructors_t { char x; clingo_ast_constructors_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_ground_program_observer_t(clingo_ground_program_observer_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { _Bool(* *tmp)(_Bool, void *) = &p->init_program; (void)tmp; }
  { _Bool(* *tmp)(void *) = &p->begin_step; (void)tmp; }
  { _Bool(* *tmp)(void *) = &p->end_step; (void)tmp; }
  { _Bool(* *tmp)(_Bool, uint32_t const *, size_t, int32_t const *, size_t, void *) = &p->rule; (void)tmp; }
  { _Bool(* *tmp)(_Bool, uint32_t const *, size_t, int32_t, clingo_weighted_literal_t const *, size_t, void *) = &p->weight_rule; (void)tmp; }
  { _Bool(* *tmp)(int32_t, clingo_weighted_literal_t const *, size_t, void *) = &p->minimize; (void)tmp; }
  { _Bool(* *tmp)(uint32_t const *, size_t, void *) = &p->project; (void)tmp; }
  { _Bool(* *tmp)(uint64_t, uint32_t, void *) = &p->output_atom; (void)tmp; }
  { _Bool(* *tmp)(uint64_t, int32_t const *, size_t, void *) = &p->output_term; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, int, void *) = &p->external; (void)tmp; }
  { _Bool(* *tmp)(int32_t const *, size_t, void *) = &p->assume; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, int, int, unsigned int, int32_t const *, size_t, void *) = &p->heuristic; (void)tmp; }
  { _Bool(* *tmp)(int, int, int32_t const *, size_t, void *) = &p->acyc_edge; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, int, void *) = &p->theory_term_number; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, char const *, void *) = &p->theory_term_string; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, int, uint32_t const *, size_t, void *) = &p->theory_term_compound; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, uint32_t const *, size_t, int32_t const *, size_t, void *) = &p->theory_element; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, uint32_t, uint32_t const *, size_t, void *) = &p->theory_atom; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, uint32_t, uint32_t const *, size_t, uint32_t, uint32_t, void *) = &p->theory_atom_with_guard; (void)tmp; }
}
struct _cffi_align__clingo_ground_program_observer_t { char x; clingo_ground_program_observer_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_location_t(clingo_location_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->begin_file; (void)tmp; }
  { char const * *tmp = &p->end_file; (void)tmp; }
  (void)((p->begin_line) | 0);  /* check that 'clingo_location_t.begin_line' is an integer */
  (void)((p->end_line) | 0);  /* check that 'clingo_location_t.end_line' is an integer */
  (void)((p->begin_column) | 0);  /* check that 'clingo_location_t.begin_column' is an integer */
  (void)((p->end_column) | 0);  /* check that 'clingo_location_t.end_column' is an integer */
}
struct _cffi_align__clingo_location_t { char x; clingo_location_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_part_t(clingo_part_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { uint64_t const * *tmp = &p->params; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'clingo_part_t.size' is an integer */
}
struct _cffi_align__clingo_part_t { char x; clingo_part_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_propagator_t(clingo_propagator_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { _Bool(* *tmp)(clingo_propagate_init_t *, void *) = &p->init; (void)tmp; }
  { _Bool(* *tmp)(clingo_propagate_control_t *, int32_t const *, size_t, void *) = &p->propagate; (void)tmp; }
  { void(* *tmp)(clingo_propagate_control_t const *, int32_t const *, size_t, void *) = &p->undo; (void)tmp; }
  { _Bool(* *tmp)(clingo_propagate_control_t *, void *) = &p->check; (void)tmp; }
  { _Bool(* *tmp)(uint32_t, clingo_assignment_t const *, int32_t, void *, int32_t *) = &p->decide; (void)tmp; }
}
struct _cffi_align__clingo_propagator_t { char x; clingo_propagator_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_script_t(clingo_script_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { _Bool(* *tmp)(clingo_location_t const *, char const *, void *) = &p->execute; (void)tmp; }
  { _Bool(* *tmp)(clingo_location_t const *, char const *, uint64_t const *, size_t, _Bool(*)(uint64_t const *, size_t, void *), void *, void *) = &p->call; (void)tmp; }
  { _Bool(* *tmp)(char const *, _Bool *, void *) = &p->callable; (void)tmp; }
  { _Bool(* *tmp)(clingo_control_t *, void *) = &p->main; (void)tmp; }
  { void(* *tmp)(void *) = &p->free; (void)tmp; }
  { char const * *tmp = &p->version; (void)tmp; }
}
struct _cffi_align__clingo_script_t { char x; clingo_script_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__clingo_weighted_literal_t(clingo_weighted_literal_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->literal) | 0);  /* check that 'clingo_weighted_literal_t.literal' is an integer */
  (void)((p->weight) | 0);  /* check that 'clingo_weighted_literal_t.weight' is an integer */
}
struct _cffi_align__clingo_weighted_literal_t { char x; clingo_weighted_literal_t y; };

static clingo_ast_attribute_names_t *_cffi_var_g_clingo_ast_attribute_names(void)
{
  return &(g_clingo_ast_attribute_names);
}

static clingo_ast_constructors_t *_cffi_var_g_clingo_ast_constructors(void)
{
  return &(g_clingo_ast_constructors);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "clingo_add_string", (void *)_cffi_f_clingo_add_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 58), (void *)_cffi_d_clingo_add_string },
  { "clingo_assignment_at", (void *)_cffi_f_clingo_assignment_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 117), (void *)_cffi_d_clingo_assignment_at },
  { "clingo_assignment_decision", (void *)_cffi_f_clingo_assignment_decision, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 126), (void *)_cffi_d_clingo_assignment_decision },
  { "clingo_assignment_decision_level", (void *)_cffi_f_clingo_assignment_decision_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1154), (void *)_cffi_d_clingo_assignment_decision_level },
  { "clingo_assignment_has_conflict", (void *)_cffi_f_clingo_assignment_has_conflict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 95), (void *)_cffi_d_clingo_assignment_has_conflict },
  { "clingo_assignment_has_literal", (void *)_cffi_f_clingo_assignment_has_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 98), (void *)_cffi_d_clingo_assignment_has_literal },
  { "clingo_assignment_is_false", (void *)_cffi_f_clingo_assignment_is_false, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 102), (void *)_cffi_d_clingo_assignment_is_false },
  { "clingo_assignment_is_fixed", (void *)_cffi_f_clingo_assignment_is_fixed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 102), (void *)_cffi_d_clingo_assignment_is_fixed },
  { "clingo_assignment_is_total", (void *)_cffi_f_clingo_assignment_is_total, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 95), (void *)_cffi_d_clingo_assignment_is_total },
  { "clingo_assignment_is_true", (void *)_cffi_f_clingo_assignment_is_true, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 102), (void *)_cffi_d_clingo_assignment_is_true },
  { "clingo_assignment_level", (void *)_cffi_f_clingo_assignment_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 112), (void *)_cffi_d_clingo_assignment_level },
  { "clingo_assignment_root_level", (void *)_cffi_f_clingo_assignment_root_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1154), (void *)_cffi_d_clingo_assignment_root_level },
  { "clingo_assignment_size", (void *)_cffi_f_clingo_assignment_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1145), (void *)_cffi_d_clingo_assignment_size },
  { "clingo_assignment_trail_at", (void *)_cffi_f_clingo_assignment_trail_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 126), (void *)_cffi_d_clingo_assignment_trail_at },
  { "clingo_assignment_trail_begin", (void *)_cffi_f_clingo_assignment_trail_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_clingo_assignment_trail_begin },
  { "clingo_assignment_trail_end", (void *)_cffi_f_clingo_assignment_trail_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_clingo_assignment_trail_end },
  { "clingo_assignment_trail_size", (void *)_cffi_f_clingo_assignment_trail_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_clingo_assignment_trail_size },
  { "clingo_assignment_truth_value", (void *)_cffi_f_clingo_assignment_truth_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 107), (void *)_cffi_d_clingo_assignment_truth_value },
  { "clingo_ast_acquire", (void *)_cffi_f_clingo_ast_acquire, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1166), (void *)_cffi_d_clingo_ast_acquire },
  { "clingo_ast_aggregate_function_count", (void *)_cffi_const_clingo_ast_aggregate_function_count, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_aggregate_function_max", (void *)_cffi_const_clingo_ast_aggregate_function_max, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_aggregate_function_min", (void *)_cffi_const_clingo_ast_aggregate_function_min, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_aggregate_function_sum", (void *)_cffi_const_clingo_ast_aggregate_function_sum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_aggregate_function_sump", (void *)_cffi_const_clingo_ast_aggregate_function_sump, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_argument", (void *)_cffi_const_clingo_ast_attribute_argument, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_arguments", (void *)_cffi_const_clingo_ast_attribute_arguments, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_arity", (void *)_cffi_const_clingo_ast_attribute_arity, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_atom", (void *)_cffi_const_clingo_ast_attribute_atom, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_atom_type", (void *)_cffi_const_clingo_ast_attribute_atom_type, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_atoms", (void *)_cffi_const_clingo_ast_attribute_atoms, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_bias", (void *)_cffi_const_clingo_ast_attribute_bias, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_body", (void *)_cffi_const_clingo_ast_attribute_body, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_code", (void *)_cffi_const_clingo_ast_attribute_code, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_coefficient", (void *)_cffi_const_clingo_ast_attribute_coefficient, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_comment_type", (void *)_cffi_const_clingo_ast_attribute_comment_type, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_comparison", (void *)_cffi_const_clingo_ast_attribute_comparison, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_condition", (void *)_cffi_const_clingo_ast_attribute_condition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_delete_ast_at", (void *)_cffi_f_clingo_ast_attribute_delete_ast_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 209), (void *)_cffi_d_clingo_ast_attribute_delete_ast_at },
  { "clingo_ast_attribute_delete_string_at", (void *)_cffi_f_clingo_ast_attribute_delete_string_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 209), (void *)_cffi_d_clingo_ast_attribute_delete_string_at },
  { "clingo_ast_attribute_elements", (void *)_cffi_const_clingo_ast_attribute_elements, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_external", (void *)_cffi_const_clingo_ast_attribute_external, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_external_type", (void *)_cffi_const_clingo_ast_attribute_external_type, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_function", (void *)_cffi_const_clingo_ast_attribute_function, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_get_ast", (void *)_cffi_f_clingo_ast_attribute_get_ast, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 174), (void *)_cffi_d_clingo_ast_attribute_get_ast },
  { "clingo_ast_attribute_get_ast_at", (void *)_cffi_f_clingo_ast_attribute_get_ast_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 226), (void *)_cffi_d_clingo_ast_attribute_get_ast_at },
  { "clingo_ast_attribute_get_location", (void *)_cffi_f_clingo_ast_attribute_get_location, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 184), (void *)_cffi_d_clingo_ast_attribute_get_location },
  { "clingo_ast_attribute_get_number", (void *)_cffi_f_clingo_ast_attribute_get_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_clingo_ast_attribute_get_number },
  { "clingo_ast_attribute_get_optional_ast", (void *)_cffi_f_clingo_ast_attribute_get_optional_ast, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 174), (void *)_cffi_d_clingo_ast_attribute_get_optional_ast },
  { "clingo_ast_attribute_get_string", (void *)_cffi_f_clingo_ast_attribute_get_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_clingo_ast_attribute_get_string },
  { "clingo_ast_attribute_get_string_at", (void *)_cffi_f_clingo_ast_attribute_get_string_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 214), (void *)_cffi_d_clingo_ast_attribute_get_string_at },
  { "clingo_ast_attribute_get_symbol", (void *)_cffi_f_clingo_ast_attribute_get_symbol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 238), (void *)_cffi_d_clingo_ast_attribute_get_symbol },
  { "clingo_ast_attribute_guard", (void *)_cffi_const_clingo_ast_attribute_guard, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_guards", (void *)_cffi_const_clingo_ast_attribute_guards, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_head", (void *)_cffi_const_clingo_ast_attribute_head, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_insert_ast_at", (void *)_cffi_f_clingo_ast_attribute_insert_ast_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 232), (void *)_cffi_d_clingo_ast_attribute_insert_ast_at },
  { "clingo_ast_attribute_insert_string_at", (void *)_cffi_f_clingo_ast_attribute_insert_string_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 220), (void *)_cffi_d_clingo_ast_attribute_insert_string_at },
  { "clingo_ast_attribute_is_default", (void *)_cffi_const_clingo_ast_attribute_is_default, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_left", (void *)_cffi_const_clingo_ast_attribute_left, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_left_guard", (void *)_cffi_const_clingo_ast_attribute_left_guard, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_literal", (void *)_cffi_const_clingo_ast_attribute_literal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_location", (void *)_cffi_const_clingo_ast_attribute_location, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_modifier", (void *)_cffi_const_clingo_ast_attribute_modifier, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_name", (void *)_cffi_const_clingo_ast_attribute_name, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_node_u", (void *)_cffi_const_clingo_ast_attribute_node_u, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_node_v", (void *)_cffi_const_clingo_ast_attribute_node_v, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_operator_name", (void *)_cffi_const_clingo_ast_attribute_operator_name, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_operator_type", (void *)_cffi_const_clingo_ast_attribute_operator_type, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_operators", (void *)_cffi_const_clingo_ast_attribute_operators, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_parameters", (void *)_cffi_const_clingo_ast_attribute_parameters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_positive", (void *)_cffi_const_clingo_ast_attribute_positive, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_priority", (void *)_cffi_const_clingo_ast_attribute_priority, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_right", (void *)_cffi_const_clingo_ast_attribute_right, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_right_guard", (void *)_cffi_const_clingo_ast_attribute_right_guard, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_sequence_type", (void *)_cffi_const_clingo_ast_attribute_sequence_type, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_set_ast", (void *)_cffi_f_clingo_ast_attribute_set_ast, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 179), (void *)_cffi_d_clingo_ast_attribute_set_ast },
  { "clingo_ast_attribute_set_ast_at", (void *)_cffi_f_clingo_ast_attribute_set_ast_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 232), (void *)_cffi_d_clingo_ast_attribute_set_ast_at },
  { "clingo_ast_attribute_set_location", (void *)_cffi_f_clingo_ast_attribute_set_location, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_clingo_ast_attribute_set_location },
  { "clingo_ast_attribute_set_number", (void *)_cffi_f_clingo_ast_attribute_set_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 199), (void *)_cffi_d_clingo_ast_attribute_set_number },
  { "clingo_ast_attribute_set_optional_ast", (void *)_cffi_f_clingo_ast_attribute_set_optional_ast, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 179), (void *)_cffi_d_clingo_ast_attribute_set_optional_ast },
  { "clingo_ast_attribute_set_string", (void *)_cffi_f_clingo_ast_attribute_set_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_clingo_ast_attribute_set_string },
  { "clingo_ast_attribute_set_string_at", (void *)_cffi_f_clingo_ast_attribute_set_string_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 220), (void *)_cffi_d_clingo_ast_attribute_set_string_at },
  { "clingo_ast_attribute_set_symbol", (void *)_cffi_f_clingo_ast_attribute_set_symbol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 243), (void *)_cffi_d_clingo_ast_attribute_set_symbol },
  { "clingo_ast_attribute_sign", (void *)_cffi_const_clingo_ast_attribute_sign, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_size_ast_array", (void *)_cffi_f_clingo_ast_attribute_size_ast_array, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 204), (void *)_cffi_d_clingo_ast_attribute_size_ast_array },
  { "clingo_ast_attribute_size_string_array", (void *)_cffi_f_clingo_ast_attribute_size_string_array, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 204), (void *)_cffi_d_clingo_ast_attribute_size_string_array },
  { "clingo_ast_attribute_symbol", (void *)_cffi_const_clingo_ast_attribute_symbol, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_term", (void *)_cffi_const_clingo_ast_attribute_term, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_terms", (void *)_cffi_const_clingo_ast_attribute_terms, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type", (void *)_cffi_f_clingo_ast_attribute_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_clingo_ast_attribute_type },
  { "clingo_ast_attribute_type_ast", (void *)_cffi_const_clingo_ast_attribute_type_ast, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_ast_array", (void *)_cffi_const_clingo_ast_attribute_type_ast_array, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_location", (void *)_cffi_const_clingo_ast_attribute_type_location, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_number", (void *)_cffi_const_clingo_ast_attribute_type_number, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_optional_ast", (void *)_cffi_const_clingo_ast_attribute_type_optional_ast, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_string", (void *)_cffi_const_clingo_ast_attribute_type_string, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_string_array", (void *)_cffi_const_clingo_ast_attribute_type_string_array, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_type_symbol", (void *)_cffi_const_clingo_ast_attribute_type_symbol, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_value", (void *)_cffi_const_clingo_ast_attribute_value, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_variable", (void *)_cffi_const_clingo_ast_attribute_variable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_attribute_weight", (void *)_cffi_const_clingo_ast_attribute_weight, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_and", (void *)_cffi_const_clingo_ast_binary_operator_and, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_division", (void *)_cffi_const_clingo_ast_binary_operator_division, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_minus", (void *)_cffi_const_clingo_ast_binary_operator_minus, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_modulo", (void *)_cffi_const_clingo_ast_binary_operator_modulo, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_multiplication", (void *)_cffi_const_clingo_ast_binary_operator_multiplication, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_or", (void *)_cffi_const_clingo_ast_binary_operator_or, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_plus", (void *)_cffi_const_clingo_ast_binary_operator_plus, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_power", (void *)_cffi_const_clingo_ast_binary_operator_power, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_binary_operator_xor", (void *)_cffi_const_clingo_ast_binary_operator_xor, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_build", (void *)_cffi_const_clingo_ast_build, _CFFI_OP(_CFFI_OP_CONSTANT, 1231), (void *)0 },
  { "clingo_ast_comparison_operator_equal", (void *)_cffi_const_clingo_ast_comparison_operator_equal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_comparison_operator_greater_equal", (void *)_cffi_const_clingo_ast_comparison_operator_greater_equal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_comparison_operator_greater_than", (void *)_cffi_const_clingo_ast_comparison_operator_greater_than, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_comparison_operator_less_equal", (void *)_cffi_const_clingo_ast_comparison_operator_less_equal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_comparison_operator_less_than", (void *)_cffi_const_clingo_ast_comparison_operator_less_than, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_comparison_operator_not_equal", (void *)_cffi_const_clingo_ast_comparison_operator_not_equal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_copy", (void *)_cffi_f_clingo_ast_copy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_clingo_ast_copy },
  { "clingo_ast_deep_copy", (void *)_cffi_f_clingo_ast_deep_copy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_clingo_ast_deep_copy },
  { "clingo_ast_equal", (void *)_cffi_f_clingo_ast_equal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_clingo_ast_equal },
  { "clingo_ast_get_type", (void *)_cffi_f_clingo_ast_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 149), (void *)_cffi_d_clingo_ast_get_type },
  { "clingo_ast_has_attribute", (void *)_cffi_f_clingo_ast_has_attribute, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 153), (void *)_cffi_d_clingo_ast_has_attribute },
  { "clingo_ast_hash", (void *)_cffi_f_clingo_ast_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1148), (void *)_cffi_d_clingo_ast_hash },
  { "clingo_ast_less_than", (void *)_cffi_f_clingo_ast_less_than, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_clingo_ast_less_than },
  { "clingo_ast_parse_files", (void *)_cffi_f_clingo_ast_parse_files, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 21), (void *)_cffi_d_clingo_ast_parse_files },
  { "clingo_ast_parse_string", (void *)_cffi_f_clingo_ast_parse_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_clingo_ast_parse_string },
  { "clingo_ast_release", (void *)_cffi_f_clingo_ast_release, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1166), (void *)_cffi_d_clingo_ast_release },
  { "clingo_ast_sign_double_negation", (void *)_cffi_const_clingo_ast_sign_double_negation, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_sign_negation", (void *)_cffi_const_clingo_ast_sign_negation, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_sign_no_sign", (void *)_cffi_const_clingo_ast_sign_no_sign, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_atom_definition_type_any", (void *)_cffi_const_clingo_ast_theory_atom_definition_type_any, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_atom_definition_type_body", (void *)_cffi_const_clingo_ast_theory_atom_definition_type_body, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_atom_definition_type_directive", (void *)_cffi_const_clingo_ast_theory_atom_definition_type_directive, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_atom_definition_type_head", (void *)_cffi_const_clingo_ast_theory_atom_definition_type_head, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_operator_type_binary_left", (void *)_cffi_const_clingo_ast_theory_operator_type_binary_left, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_operator_type_binary_right", (void *)_cffi_const_clingo_ast_theory_operator_type_binary_right, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_operator_type_unary", (void *)_cffi_const_clingo_ast_theory_operator_type_unary, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_sequence_type_list", (void *)_cffi_const_clingo_ast_theory_sequence_type_list, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_sequence_type_set", (void *)_cffi_const_clingo_ast_theory_sequence_type_set, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_theory_sequence_type_tuple", (void *)_cffi_const_clingo_ast_theory_sequence_type_tuple, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_to_string", (void *)_cffi_f_clingo_ast_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_clingo_ast_to_string },
  { "clingo_ast_to_string_size", (void *)_cffi_f_clingo_ast_to_string_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 248), (void *)_cffi_d_clingo_ast_to_string_size },
  { "clingo_ast_type_aggregate", (void *)_cffi_const_clingo_ast_type_aggregate, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_binary_operation", (void *)_cffi_const_clingo_ast_type_binary_operation, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_body_aggregate", (void *)_cffi_const_clingo_ast_type_body_aggregate, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_body_aggregate_element", (void *)_cffi_const_clingo_ast_type_body_aggregate_element, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_boolean_constant", (void *)_cffi_const_clingo_ast_type_boolean_constant, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_comment", (void *)_cffi_const_clingo_ast_type_comment, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_comparison", (void *)_cffi_const_clingo_ast_type_comparison, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_conditional_literal", (void *)_cffi_const_clingo_ast_type_conditional_literal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_defined", (void *)_cffi_const_clingo_ast_type_defined, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_definition", (void *)_cffi_const_clingo_ast_type_definition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_disjunction", (void *)_cffi_const_clingo_ast_type_disjunction, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_edge", (void *)_cffi_const_clingo_ast_type_edge, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_external", (void *)_cffi_const_clingo_ast_type_external, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_function", (void *)_cffi_const_clingo_ast_type_function, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_guard", (void *)_cffi_const_clingo_ast_type_guard, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_head_aggregate", (void *)_cffi_const_clingo_ast_type_head_aggregate, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_head_aggregate_element", (void *)_cffi_const_clingo_ast_type_head_aggregate_element, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_heuristic", (void *)_cffi_const_clingo_ast_type_heuristic, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_id", (void *)_cffi_const_clingo_ast_type_id, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_interval", (void *)_cffi_const_clingo_ast_type_interval, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_literal", (void *)_cffi_const_clingo_ast_type_literal, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_minimize", (void *)_cffi_const_clingo_ast_type_minimize, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_pool", (void *)_cffi_const_clingo_ast_type_pool, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_program", (void *)_cffi_const_clingo_ast_type_program, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_project_atom", (void *)_cffi_const_clingo_ast_type_project_atom, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_project_signature", (void *)_cffi_const_clingo_ast_type_project_signature, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_rule", (void *)_cffi_const_clingo_ast_type_rule, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_script", (void *)_cffi_const_clingo_ast_type_script, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_show_signature", (void *)_cffi_const_clingo_ast_type_show_signature, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_show_term", (void *)_cffi_const_clingo_ast_type_show_term, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_symbolic_atom", (void *)_cffi_const_clingo_ast_type_symbolic_atom, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_symbolic_term", (void *)_cffi_const_clingo_ast_type_symbolic_term, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_atom", (void *)_cffi_const_clingo_ast_type_theory_atom, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_atom_definition", (void *)_cffi_const_clingo_ast_type_theory_atom_definition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_atom_element", (void *)_cffi_const_clingo_ast_type_theory_atom_element, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_definition", (void *)_cffi_const_clingo_ast_type_theory_definition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_function", (void *)_cffi_const_clingo_ast_type_theory_function, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_guard", (void *)_cffi_const_clingo_ast_type_theory_guard, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_guard_definition", (void *)_cffi_const_clingo_ast_type_theory_guard_definition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_operator_definition", (void *)_cffi_const_clingo_ast_type_theory_operator_definition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_sequence", (void *)_cffi_const_clingo_ast_type_theory_sequence, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_term_definition", (void *)_cffi_const_clingo_ast_type_theory_term_definition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_unparsed_term", (void *)_cffi_const_clingo_ast_type_theory_unparsed_term, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_theory_unparsed_term_element", (void *)_cffi_const_clingo_ast_type_theory_unparsed_term_element, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_unary_operation", (void *)_cffi_const_clingo_ast_type_unary_operation, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_type_variable", (void *)_cffi_const_clingo_ast_type_variable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_unary_operator_absolute", (void *)_cffi_const_clingo_ast_unary_operator_absolute, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_unary_operator_minus", (void *)_cffi_const_clingo_ast_unary_operator_minus, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_unary_operator_negation", (void *)_cffi_const_clingo_ast_unary_operator_negation, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_unpool", (void *)_cffi_f_clingo_ast_unpool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 158), (void *)_cffi_d_clingo_ast_unpool },
  { "clingo_ast_unpool_type_all", (void *)_cffi_const_clingo_ast_unpool_type_all, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_unpool_type_condition", (void *)_cffi_const_clingo_ast_unpool_type_condition, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_ast_unpool_type_other", (void *)_cffi_const_clingo_ast_unpool_type_other, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_backend_acyc_edge", (void *)_cffi_f_clingo_backend_acyc_edge, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 292), (void *)_cffi_d_clingo_backend_acyc_edge },
  { "clingo_backend_add_atom", (void *)_cffi_f_clingo_backend_add_atom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 367), (void *)_cffi_d_clingo_backend_add_atom },
  { "clingo_backend_assume", (void *)_cffi_f_clingo_backend_assume, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 311), (void *)_cffi_d_clingo_backend_assume },
  { "clingo_backend_begin", (void *)_cffi_f_clingo_backend_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 260), (void *)_cffi_d_clingo_backend_begin },
  { "clingo_backend_end", (void *)_cffi_f_clingo_backend_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 260), (void *)_cffi_d_clingo_backend_end },
  { "clingo_backend_external", (void *)_cffi_f_clingo_backend_external, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 335), (void *)_cffi_d_clingo_backend_external },
  { "clingo_backend_heuristic", (void *)_cffi_f_clingo_backend_heuristic, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 340), (void *)_cffi_d_clingo_backend_heuristic },
  { "clingo_backend_minimize", (void *)_cffi_f_clingo_backend_minimize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 316), (void *)_cffi_d_clingo_backend_minimize },
  { "clingo_backend_project", (void *)_cffi_f_clingo_backend_project, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 322), (void *)_cffi_d_clingo_backend_project },
  { "clingo_backend_rule", (void *)_cffi_f_clingo_backend_rule, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 263), (void *)_cffi_d_clingo_backend_rule },
  { "clingo_backend_theory_atom", (void *)_cffi_f_clingo_backend_theory_atom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 359), (void *)_cffi_d_clingo_backend_theory_atom },
  { "clingo_backend_theory_atom_with_guard", (void *)_cffi_f_clingo_backend_theory_atom_with_guard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 349), (void *)_cffi_d_clingo_backend_theory_atom_with_guard },
  { "clingo_backend_theory_element", (void *)_cffi_f_clingo_backend_theory_element, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 327), (void *)_cffi_d_clingo_backend_theory_element },
  { "clingo_backend_theory_term_function", (void *)_cffi_f_clingo_backend_theory_term_function, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 285), (void *)_cffi_d_clingo_backend_theory_term_function },
  { "clingo_backend_theory_term_number", (void *)_cffi_f_clingo_backend_theory_term_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 299), (void *)_cffi_d_clingo_backend_theory_term_number },
  { "clingo_backend_theory_term_sequence", (void *)_cffi_f_clingo_backend_theory_term_sequence, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 304), (void *)_cffi_d_clingo_backend_theory_term_sequence },
  { "clingo_backend_theory_term_string", (void *)_cffi_f_clingo_backend_theory_term_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 280), (void *)_cffi_d_clingo_backend_theory_term_string },
  { "clingo_backend_theory_term_symbol", (void *)_cffi_f_clingo_backend_theory_term_symbol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 372), (void *)_cffi_d_clingo_backend_theory_term_symbol },
  { "clingo_backend_weight_rule", (void *)_cffi_f_clingo_backend_weight_rule, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 271), (void *)_cffi_d_clingo_backend_weight_rule },
  { "clingo_clause_type_learnt", (void *)_cffi_const_clingo_clause_type_learnt, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_clause_type_static", (void *)_cffi_const_clingo_clause_type_static, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_clause_type_volatile", (void *)_cffi_const_clingo_clause_type_volatile, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_clause_type_volatile_static", (void *)_cffi_const_clingo_clause_type_volatile_static, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_comment_type_block", (void *)_cffi_const_clingo_comment_type_block, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_comment_type_line", (void *)_cffi_const_clingo_comment_type_line, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_configuration_array_at", (void *)_cffi_f_clingo_configuration_array_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 425), (void *)_cffi_d_clingo_configuration_array_at },
  { "clingo_configuration_array_size", (void *)_cffi_f_clingo_configuration_array_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 414), (void *)_cffi_d_clingo_configuration_array_size },
  { "clingo_configuration_description", (void *)_cffi_f_clingo_configuration_description, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 397), (void *)_cffi_d_clingo_configuration_description },
  { "clingo_configuration_map_at", (void *)_cffi_f_clingo_configuration_map_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 408), (void *)_cffi_d_clingo_configuration_map_at },
  { "clingo_configuration_map_has_subkey", (void *)_cffi_f_clingo_configuration_map_has_subkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 402), (void *)_cffi_d_clingo_configuration_map_has_subkey },
  { "clingo_configuration_map_size", (void *)_cffi_f_clingo_configuration_map_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 414), (void *)_cffi_d_clingo_configuration_map_size },
  { "clingo_configuration_map_subkey_name", (void *)_cffi_f_clingo_configuration_map_subkey_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 419), (void *)_cffi_d_clingo_configuration_map_subkey_name },
  { "clingo_configuration_root", (void *)_cffi_f_clingo_configuration_root, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 382), (void *)_cffi_d_clingo_configuration_root },
  { "clingo_configuration_type", (void *)_cffi_f_clingo_configuration_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 431), (void *)_cffi_d_clingo_configuration_type },
  { "clingo_configuration_type_array", (void *)_cffi_const_clingo_configuration_type_array, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_configuration_type_map", (void *)_cffi_const_clingo_configuration_type_map, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_configuration_type_value", (void *)_cffi_const_clingo_configuration_type_value, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_configuration_value_get", (void *)_cffi_f_clingo_configuration_value_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 391), (void *)_cffi_d_clingo_configuration_value_get },
  { "clingo_configuration_value_get_size", (void *)_cffi_f_clingo_configuration_value_get_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 414), (void *)_cffi_d_clingo_configuration_value_get_size },
  { "clingo_configuration_value_is_assigned", (void *)_cffi_f_clingo_configuration_value_is_assigned, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 386), (void *)_cffi_d_clingo_configuration_value_is_assigned },
  { "clingo_configuration_value_set", (void *)_cffi_f_clingo_configuration_value_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 377), (void *)_cffi_d_clingo_configuration_value_set },
  { "clingo_consequence_false", (void *)_cffi_const_clingo_consequence_false, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_consequence_true", (void *)_cffi_const_clingo_consequence_true, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_consequence_unknown", (void *)_cffi_const_clingo_consequence_unknown, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_control_add", (void *)_cffi_f_clingo_control_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 453), (void *)_cffi_d_clingo_control_add },
  { "clingo_control_assign_external", (void *)_cffi_f_clingo_control_assign_external, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 495), (void *)_cffi_d_clingo_control_assign_external },
  { "clingo_control_backend", (void *)_cffi_f_clingo_control_backend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 460), (void *)_cffi_d_clingo_control_backend },
  { "clingo_control_clasp_facade", (void *)_cffi_f_clingo_control_clasp_facade, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 509), (void *)_cffi_d_clingo_control_clasp_facade },
  { "clingo_control_cleanup", (void *)_cffi_f_clingo_control_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 436), (void *)_cffi_d_clingo_control_cleanup },
  { "clingo_control_configuration", (void *)_cffi_f_clingo_control_configuration, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 464), (void *)_cffi_d_clingo_control_configuration },
  { "clingo_control_free", (void *)_cffi_f_clingo_control_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1169), (void *)_cffi_d_clingo_control_free },
  { "clingo_control_get_const", (void *)_cffi_f_clingo_control_get_const, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 525), (void *)_cffi_d_clingo_control_get_const },
  { "clingo_control_get_enable_cleanup", (void *)_cffi_f_clingo_control_get_enable_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 436), (void *)_cffi_d_clingo_control_get_enable_cleanup },
  { "clingo_control_get_enable_enumeration_assumption", (void *)_cffi_f_clingo_control_get_enable_enumeration_assumption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 436), (void *)_cffi_d_clingo_control_get_enable_enumeration_assumption },
  { "clingo_control_ground", (void *)_cffi_f_clingo_control_ground, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 474), (void *)_cffi_d_clingo_control_ground },
  { "clingo_control_has_const", (void *)_cffi_f_clingo_control_has_const, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 520), (void *)_cffi_d_clingo_control_has_const },
  { "clingo_control_interrupt", (void *)_cffi_f_clingo_control_interrupt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1169), (void *)_cffi_d_clingo_control_interrupt },
  { "clingo_control_is_conflicting", (void *)_cffi_f_clingo_control_is_conflicting, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 517), (void *)_cffi_d_clingo_control_is_conflicting },
  { "clingo_control_load", (void *)_cffi_f_clingo_control_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 449), (void *)_cffi_d_clingo_control_load },
  { "clingo_control_new", (void *)_cffi_f_clingo_control_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 31), (void *)_cffi_d_clingo_control_new },
  { "clingo_control_register_observer", (void *)_cffi_f_clingo_control_register_observer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 468), (void *)_cffi_d_clingo_control_register_observer },
  { "clingo_control_register_propagator", (void *)_cffi_f_clingo_control_register_propagator, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 485), (void *)_cffi_d_clingo_control_register_propagator },
  { "clingo_control_release_external", (void *)_cffi_f_clingo_control_release_external, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 491), (void *)_cffi_d_clingo_control_release_external },
  { "clingo_control_set_enable_cleanup", (void *)_cffi_f_clingo_control_set_enable_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 439), (void *)_cffi_d_clingo_control_set_enable_cleanup },
  { "clingo_control_set_enable_enumeration_assumption", (void *)_cffi_f_clingo_control_set_enable_enumeration_assumption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 439), (void *)_cffi_d_clingo_control_set_enable_enumeration_assumption },
  { "clingo_control_solve", (void *)_cffi_f_clingo_control_solve, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 500), (void *)_cffi_d_clingo_control_solve },
  { "clingo_control_statistics", (void *)_cffi_f_clingo_control_statistics, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 530), (void *)_cffi_d_clingo_control_statistics },
  { "clingo_control_symbolic_atoms", (void *)_cffi_f_clingo_control_symbolic_atoms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 534), (void *)_cffi_d_clingo_control_symbolic_atoms },
  { "clingo_control_theory_atoms", (void *)_cffi_f_clingo_control_theory_atoms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 538), (void *)_cffi_d_clingo_control_theory_atoms },
  { "clingo_error_bad_alloc", (void *)_cffi_const_clingo_error_bad_alloc, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_error_code", (void *)_cffi_f_clingo_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1143), (void *)_cffi_d_clingo_error_code },
  { "clingo_error_logic", (void *)_cffi_const_clingo_error_logic, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_error_message", (void *)_cffi_f_clingo_error_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1123), (void *)_cffi_d_clingo_error_message },
  { "clingo_error_runtime", (void *)_cffi_const_clingo_error_runtime, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_error_string", (void *)_cffi_f_clingo_error_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1114), (void *)_cffi_d_clingo_error_string },
  { "clingo_error_success", (void *)_cffi_const_clingo_error_success, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_error_unknown", (void *)_cffi_const_clingo_error_unknown, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_external_type_false", (void *)_cffi_const_clingo_external_type_false, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_external_type_free", (void *)_cffi_const_clingo_external_type_free, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_external_type_release", (void *)_cffi_const_clingo_external_type_release, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_external_type_true", (void *)_cffi_const_clingo_external_type_true, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_heuristic_type_factor", (void *)_cffi_const_clingo_heuristic_type_factor, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_heuristic_type_false", (void *)_cffi_const_clingo_heuristic_type_false, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_heuristic_type_init", (void *)_cffi_const_clingo_heuristic_type_init, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_heuristic_type_level", (void *)_cffi_const_clingo_heuristic_type_level, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_heuristic_type_sign", (void *)_cffi_const_clingo_heuristic_type_sign, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_heuristic_type_true", (void *)_cffi_const_clingo_heuristic_type_true, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_main", (void *)_cffi_f_clingo_main, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1131), (void *)_cffi_d_clingo_main },
  { "clingo_model_contains", (void *)_cffi_f_clingo_model_contains, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 634), (void *)_cffi_d_clingo_model_contains },
  { "clingo_model_context", (void *)_cffi_f_clingo_model_context, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 594), (void *)_cffi_d_clingo_model_context },
  { "clingo_model_cost", (void *)_cffi_f_clingo_model_cost, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 617), (void *)_cffi_d_clingo_model_cost },
  { "clingo_model_cost_size", (void *)_cffi_f_clingo_model_cost_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 622), (void *)_cffi_d_clingo_model_cost_size },
  { "clingo_model_extend", (void *)_cffi_f_clingo_model_extend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 579), (void *)_cffi_d_clingo_model_extend },
  { "clingo_model_is_consequence", (void *)_cffi_f_clingo_model_is_consequence, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 612), (void *)_cffi_d_clingo_model_is_consequence },
  { "clingo_model_is_true", (void *)_cffi_f_clingo_model_is_true, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 607), (void *)_cffi_d_clingo_model_is_true },
  { "clingo_model_number", (void *)_cffi_f_clingo_model_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 630), (void *)_cffi_d_clingo_model_number },
  { "clingo_model_optimality_proven", (void *)_cffi_f_clingo_model_optimality_proven, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 584), (void *)_cffi_d_clingo_model_optimality_proven },
  { "clingo_model_priority", (void *)_cffi_f_clingo_model_priority, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 602), (void *)_cffi_d_clingo_model_priority },
  { "clingo_model_symbols", (void *)_cffi_f_clingo_model_symbols, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 644), (void *)_cffi_d_clingo_model_symbols },
  { "clingo_model_symbols_size", (void *)_cffi_f_clingo_model_symbols_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 639), (void *)_cffi_d_clingo_model_symbols_size },
  { "clingo_model_thread_id", (void *)_cffi_f_clingo_model_thread_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 626), (void *)_cffi_d_clingo_model_thread_id },
  { "clingo_model_type", (void *)_cffi_f_clingo_model_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 598), (void *)_cffi_d_clingo_model_type },
  { "clingo_model_type_brave_consequences", (void *)_cffi_const_clingo_model_type_brave_consequences, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_model_type_cautious_consequences", (void *)_cffi_const_clingo_model_type_cautious_consequences, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_model_type_stable_model", (void *)_cffi_const_clingo_model_type_stable_model, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_options_add", (void *)_cffi_f_clingo_options_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 657), (void *)_cffi_d_clingo_options_add },
  { "clingo_options_add_flag", (void *)_cffi_f_clingo_options_add_flag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 650), (void *)_cffi_d_clingo_options_add_flag },
  { "clingo_parse_term", (void *)_cffi_f_clingo_parse_term, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 88), (void *)_cffi_d_clingo_parse_term },
  { "clingo_program_builder_add", (void *)_cffi_f_clingo_program_builder_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 674), (void *)_cffi_d_clingo_program_builder_add },
  { "clingo_program_builder_begin", (void *)_cffi_f_clingo_program_builder_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 671), (void *)_cffi_d_clingo_program_builder_begin },
  { "clingo_program_builder_end", (void *)_cffi_f_clingo_program_builder_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 671), (void *)_cffi_d_clingo_program_builder_end },
  { "clingo_program_builder_init", (void *)_cffi_f_clingo_program_builder_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 481), (void *)_cffi_d_clingo_program_builder_init },
  { "clingo_propagate_control_add_clause", (void *)_cffi_f_clingo_propagate_control_add_clause, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 686), (void *)_cffi_d_clingo_propagate_control_add_clause },
  { "clingo_propagate_control_add_literal", (void *)_cffi_f_clingo_propagate_control_add_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 682), (void *)_cffi_d_clingo_propagate_control_add_literal },
  { "clingo_propagate_control_add_watch", (void *)_cffi_f_clingo_propagate_control_add_watch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 699), (void *)_cffi_d_clingo_propagate_control_add_watch },
  { "clingo_propagate_control_assignment", (void *)_cffi_f_clingo_propagate_control_assignment, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1125), (void *)_cffi_d_clingo_propagate_control_assignment },
  { "clingo_propagate_control_has_watch", (void *)_cffi_f_clingo_propagate_control_has_watch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 707), (void *)_cffi_d_clingo_propagate_control_has_watch },
  { "clingo_propagate_control_propagate", (void *)_cffi_f_clingo_propagate_control_propagate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 678), (void *)_cffi_d_clingo_propagate_control_propagate },
  { "clingo_propagate_control_remove_watch", (void *)_cffi_f_clingo_propagate_control_remove_watch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1172), (void *)_cffi_d_clingo_propagate_control_remove_watch },
  { "clingo_propagate_control_thread_id", (void *)_cffi_f_clingo_propagate_control_thread_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1157), (void *)_cffi_d_clingo_propagate_control_thread_id },
  { "clingo_propagate_init_add_clause", (void *)_cffi_f_clingo_propagate_init_add_clause, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 720), (void *)_cffi_d_clingo_propagate_init_add_clause },
  { "clingo_propagate_init_add_literal", (void *)_cffi_f_clingo_propagate_init_add_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 715), (void *)_cffi_d_clingo_propagate_init_add_literal },
  { "clingo_propagate_init_add_minimize", (void *)_cffi_f_clingo_propagate_init_add_minimize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 740), (void *)_cffi_d_clingo_propagate_init_add_minimize },
  { "clingo_propagate_init_add_watch", (void *)_cffi_f_clingo_propagate_init_add_watch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 726), (void *)_cffi_d_clingo_propagate_init_add_watch },
  { "clingo_propagate_init_add_watch_to_thread", (void *)_cffi_f_clingo_propagate_init_add_watch_to_thread, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 746), (void *)_cffi_d_clingo_propagate_init_add_watch_to_thread },
  { "clingo_propagate_init_add_weight_constraint", (void *)_cffi_f_clingo_propagate_init_add_weight_constraint, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 730), (void *)_cffi_d_clingo_propagate_init_add_weight_constraint },
  { "clingo_propagate_init_assignment", (void *)_cffi_f_clingo_propagate_init_assignment, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1128), (void *)_cffi_d_clingo_propagate_init_assignment },
  { "clingo_propagate_init_freeze_literal", (void *)_cffi_f_clingo_propagate_init_freeze_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 726), (void *)_cffi_d_clingo_propagate_init_freeze_literal },
  { "clingo_propagate_init_get_check_mode", (void *)_cffi_f_clingo_propagate_init_get_check_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1137), (void *)_cffi_d_clingo_propagate_init_get_check_mode },
  { "clingo_propagate_init_get_undo_mode", (void *)_cffi_f_clingo_propagate_init_get_undo_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1137), (void *)_cffi_d_clingo_propagate_init_get_undo_mode },
  { "clingo_propagate_init_number_of_threads", (void *)_cffi_f_clingo_propagate_init_number_of_threads, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1137), (void *)_cffi_d_clingo_propagate_init_number_of_threads },
  { "clingo_propagate_init_propagate", (void *)_cffi_f_clingo_propagate_init_propagate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 711), (void *)_cffi_d_clingo_propagate_init_propagate },
  { "clingo_propagate_init_remove_watch", (void *)_cffi_f_clingo_propagate_init_remove_watch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 726), (void *)_cffi_d_clingo_propagate_init_remove_watch },
  { "clingo_propagate_init_remove_watch_from_thread", (void *)_cffi_f_clingo_propagate_init_remove_watch_from_thread, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 746), (void *)_cffi_d_clingo_propagate_init_remove_watch_from_thread },
  { "clingo_propagate_init_set_check_mode", (void *)_cffi_f_clingo_propagate_init_set_check_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1182), (void *)_cffi_d_clingo_propagate_init_set_check_mode },
  { "clingo_propagate_init_set_undo_mode", (void *)_cffi_f_clingo_propagate_init_set_undo_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1182), (void *)_cffi_d_clingo_propagate_init_set_undo_mode },
  { "clingo_propagate_init_solver_literal", (void *)_cffi_f_clingo_propagate_init_solver_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 763), (void *)_cffi_d_clingo_propagate_init_solver_literal },
  { "clingo_propagate_init_symbolic_atoms", (void *)_cffi_f_clingo_propagate_init_symbolic_atoms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 755), (void *)_cffi_d_clingo_propagate_init_symbolic_atoms },
  { "clingo_propagate_init_theory_atoms", (void *)_cffi_f_clingo_propagate_init_theory_atoms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 759), (void *)_cffi_d_clingo_propagate_init_theory_atoms },
  { "clingo_propagator_check_mode_both", (void *)_cffi_const_clingo_propagator_check_mode_both, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_propagator_check_mode_fixpoint", (void *)_cffi_const_clingo_propagator_check_mode_fixpoint, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_propagator_check_mode_none", (void *)_cffi_const_clingo_propagator_check_mode_none, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_propagator_check_mode_total", (void *)_cffi_const_clingo_propagator_check_mode_total, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_propagator_undo_mode_always", (void *)_cffi_const_clingo_propagator_undo_mode_always, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_propagator_undo_mode_default", (void *)_cffi_const_clingo_propagator_undo_mode_default, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_register_script", (void *)_cffi_f_clingo_register_script, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 62), (void *)_cffi_d_clingo_register_script },
  { "clingo_script_version", (void *)_cffi_f_clingo_script_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1111), (void *)_cffi_d_clingo_script_version },
  { "clingo_set_error", (void *)_cffi_f_clingo_set_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1196), (void *)_cffi_d_clingo_set_error },
  { "clingo_show_type_all", (void *)_cffi_const_clingo_show_type_all, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_show_type_atoms", (void *)_cffi_const_clingo_show_type_atoms, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_show_type_complement", (void *)_cffi_const_clingo_show_type_complement, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_show_type_shown", (void *)_cffi_const_clingo_show_type_shown, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_show_type_terms", (void *)_cffi_const_clingo_show_type_terms, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_show_type_theory", (void *)_cffi_const_clingo_show_type_theory, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_signature_arity", (void *)_cffi_f_clingo_signature_arity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1160), (void *)_cffi_d_clingo_signature_arity },
  { "clingo_signature_create", (void *)_cffi_f_clingo_signature_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 67), (void *)_cffi_d_clingo_signature_create },
  { "clingo_signature_hash", (void *)_cffi_f_clingo_signature_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1151), (void *)_cffi_d_clingo_signature_hash },
  { "clingo_signature_is_equal_to", (void *)_cffi_f_clingo_signature_is_equal_to, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1080), (void *)_cffi_d_clingo_signature_is_equal_to },
  { "clingo_signature_is_less_than", (void *)_cffi_f_clingo_signature_is_less_than, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1080), (void *)_cffi_d_clingo_signature_is_less_than },
  { "clingo_signature_is_negative", (void *)_cffi_f_clingo_signature_is_negative, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1040), (void *)_cffi_d_clingo_signature_is_negative },
  { "clingo_signature_is_positive", (void *)_cffi_f_clingo_signature_is_positive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1040), (void *)_cffi_d_clingo_signature_is_positive },
  { "clingo_signature_name", (void *)_cffi_f_clingo_signature_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1117), (void *)_cffi_d_clingo_signature_name },
  { "clingo_solve_control_add_clause", (void *)_cffi_f_clingo_solve_control_add_clause, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 768), (void *)_cffi_d_clingo_solve_control_add_clause },
  { "clingo_solve_control_symbolic_atoms", (void *)_cffi_f_clingo_solve_control_symbolic_atoms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 773), (void *)_cffi_d_clingo_solve_control_symbolic_atoms },
  { "clingo_solve_event_type_finish", (void *)_cffi_const_clingo_solve_event_type_finish, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_event_type_model", (void *)_cffi_const_clingo_solve_event_type_model, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_event_type_statistics", (void *)_cffi_const_clingo_solve_event_type_statistics, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_event_type_unsat", (void *)_cffi_const_clingo_solve_event_type_unsat, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_handle_cancel", (void *)_cffi_f_clingo_solve_handle_cancel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 777), (void *)_cffi_d_clingo_solve_handle_cancel },
  { "clingo_solve_handle_close", (void *)_cffi_f_clingo_solve_handle_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 777), (void *)_cffi_d_clingo_solve_handle_close },
  { "clingo_solve_handle_core", (void *)_cffi_f_clingo_solve_handle_core, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 784), (void *)_cffi_d_clingo_solve_handle_core },
  { "clingo_solve_handle_get", (void *)_cffi_f_clingo_solve_handle_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 789), (void *)_cffi_d_clingo_solve_handle_get },
  { "clingo_solve_handle_model", (void *)_cffi_f_clingo_solve_handle_model, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 780), (void *)_cffi_d_clingo_solve_handle_model },
  { "clingo_solve_handle_resume", (void *)_cffi_f_clingo_solve_handle_resume, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 777), (void *)_cffi_d_clingo_solve_handle_resume },
  { "clingo_solve_handle_wait", (void *)_cffi_f_clingo_solve_handle_wait, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1186), (void *)_cffi_d_clingo_solve_handle_wait },
  { "clingo_solve_mode_async", (void *)_cffi_const_clingo_solve_mode_async, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_mode_yield", (void *)_cffi_const_clingo_solve_mode_yield, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_result_exhausted", (void *)_cffi_const_clingo_solve_result_exhausted, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_result_interrupted", (void *)_cffi_const_clingo_solve_result_interrupted, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_result_satisfiable", (void *)_cffi_const_clingo_solve_result_satisfiable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_solve_result_unsatisfiable", (void *)_cffi_const_clingo_solve_result_unsatisfiable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_statistics_array_at", (void *)_cffi_f_clingo_statistics_array_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 848), (void *)_cffi_d_clingo_statistics_array_at },
  { "clingo_statistics_array_push", (void *)_cffi_f_clingo_statistics_array_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 805), (void *)_cffi_d_clingo_statistics_array_push },
  { "clingo_statistics_array_size", (void *)_cffi_f_clingo_statistics_array_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 837), (void *)_cffi_d_clingo_statistics_array_size },
  { "clingo_statistics_map_add_subkey", (void *)_cffi_f_clingo_statistics_map_add_subkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 793), (void *)_cffi_d_clingo_statistics_map_add_subkey },
  { "clingo_statistics_map_at", (void *)_cffi_f_clingo_statistics_map_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 821), (void *)_cffi_d_clingo_statistics_map_at },
  { "clingo_statistics_map_has_subkey", (void *)_cffi_f_clingo_statistics_map_has_subkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 815), (void *)_cffi_d_clingo_statistics_map_has_subkey },
  { "clingo_statistics_map_size", (void *)_cffi_f_clingo_statistics_map_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 837), (void *)_cffi_d_clingo_statistics_map_size },
  { "clingo_statistics_map_subkey_name", (void *)_cffi_f_clingo_statistics_map_subkey_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 842), (void *)_cffi_d_clingo_statistics_map_subkey_name },
  { "clingo_statistics_root", (void *)_cffi_f_clingo_statistics_root, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 811), (void *)_cffi_d_clingo_statistics_root },
  { "clingo_statistics_type", (void *)_cffi_f_clingo_statistics_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 832), (void *)_cffi_d_clingo_statistics_type },
  { "clingo_statistics_type_array", (void *)_cffi_const_clingo_statistics_type_array, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_statistics_type_empty", (void *)_cffi_const_clingo_statistics_type_empty, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_statistics_type_map", (void *)_cffi_const_clingo_statistics_type_map, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_statistics_type_value", (void *)_cffi_const_clingo_statistics_type_value, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_statistics_value_get", (void *)_cffi_f_clingo_statistics_value_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 827), (void *)_cffi_d_clingo_statistics_value_get },
  { "clingo_statistics_value_set", (void *)_cffi_f_clingo_statistics_value_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 800), (void *)_cffi_d_clingo_statistics_value_set },
  { "clingo_symbol_arguments", (void *)_cffi_f_clingo_symbol_arguments, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1075), (void *)_cffi_d_clingo_symbol_arguments },
  { "clingo_symbol_create_function", (void *)_cffi_f_clingo_symbol_create_function, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_clingo_symbol_create_function },
  { "clingo_symbol_create_id", (void *)_cffi_f_clingo_symbol_create_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 53), (void *)_cffi_d_clingo_symbol_create_id },
  { "clingo_symbol_create_infimum", (void *)_cffi_f_clingo_symbol_create_infimum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1209), (void *)_cffi_d_clingo_symbol_create_infimum },
  { "clingo_symbol_create_number", (void *)_cffi_f_clingo_symbol_create_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1205), (void *)_cffi_d_clingo_symbol_create_number },
  { "clingo_symbol_create_string", (void *)_cffi_f_clingo_symbol_create_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 73), (void *)_cffi_d_clingo_symbol_create_string },
  { "clingo_symbol_create_supremum", (void *)_cffi_f_clingo_symbol_create_supremum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1209), (void *)_cffi_d_clingo_symbol_create_supremum },
  { "clingo_symbol_hash", (void *)_cffi_f_clingo_symbol_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1151), (void *)_cffi_d_clingo_symbol_hash },
  { "clingo_symbol_is_equal_to", (void *)_cffi_f_clingo_symbol_is_equal_to, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1080), (void *)_cffi_d_clingo_symbol_is_equal_to },
  { "clingo_symbol_is_less_than", (void *)_cffi_f_clingo_symbol_is_less_than, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1080), (void *)_cffi_d_clingo_symbol_is_less_than },
  { "clingo_symbol_is_negative", (void *)_cffi_f_clingo_symbol_is_negative, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1043), (void *)_cffi_d_clingo_symbol_is_negative },
  { "clingo_symbol_is_positive", (void *)_cffi_f_clingo_symbol_is_positive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1043), (void *)_cffi_d_clingo_symbol_is_positive },
  { "clingo_symbol_name", (void *)_cffi_f_clingo_symbol_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1052), (void *)_cffi_d_clingo_symbol_name },
  { "clingo_symbol_number", (void *)_cffi_f_clingo_symbol_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1056), (void *)_cffi_d_clingo_symbol_number },
  { "clingo_symbol_string", (void *)_cffi_f_clingo_symbol_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1052), (void *)_cffi_d_clingo_symbol_string },
  { "clingo_symbol_to_string", (void *)_cffi_f_clingo_symbol_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1047), (void *)_cffi_d_clingo_symbol_to_string },
  { "clingo_symbol_to_string_size", (void *)_cffi_f_clingo_symbol_to_string_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1066), (void *)_cffi_d_clingo_symbol_to_string_size },
  { "clingo_symbol_type", (void *)_cffi_f_clingo_symbol_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1140), (void *)_cffi_d_clingo_symbol_type },
  { "clingo_symbol_type_function", (void *)_cffi_const_clingo_symbol_type_function, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_symbol_type_infimum", (void *)_cffi_const_clingo_symbol_type_infimum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_symbol_type_number", (void *)_cffi_const_clingo_symbol_type_number, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_symbol_type_string", (void *)_cffi_const_clingo_symbol_type_string, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_symbol_type_supremum", (void *)_cffi_const_clingo_symbol_type_supremum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_symbolic_atoms_begin", (void *)_cffi_f_clingo_symbolic_atoms_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 867), (void *)_cffi_d_clingo_symbolic_atoms_begin },
  { "clingo_symbolic_atoms_end", (void *)_cffi_f_clingo_symbolic_atoms_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 858), (void *)_cffi_d_clingo_symbolic_atoms_end },
  { "clingo_symbolic_atoms_find", (void *)_cffi_f_clingo_symbolic_atoms_find, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 882), (void *)_cffi_d_clingo_symbolic_atoms_find },
  { "clingo_symbolic_atoms_is_external", (void *)_cffi_f_clingo_symbolic_atoms_is_external, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 872), (void *)_cffi_d_clingo_symbolic_atoms_is_external },
  { "clingo_symbolic_atoms_is_fact", (void *)_cffi_f_clingo_symbolic_atoms_is_fact, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 872), (void *)_cffi_d_clingo_symbolic_atoms_is_fact },
  { "clingo_symbolic_atoms_is_valid", (void *)_cffi_f_clingo_symbolic_atoms_is_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 872), (void *)_cffi_d_clingo_symbolic_atoms_is_valid },
  { "clingo_symbolic_atoms_iterator_is_equal_to", (void *)_cffi_f_clingo_symbolic_atoms_iterator_is_equal_to, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 887), (void *)_cffi_d_clingo_symbolic_atoms_iterator_is_equal_to },
  { "clingo_symbolic_atoms_literal", (void *)_cffi_f_clingo_symbolic_atoms_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 877), (void *)_cffi_d_clingo_symbolic_atoms_literal },
  { "clingo_symbolic_atoms_next", (void *)_cffi_f_clingo_symbolic_atoms_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 882), (void *)_cffi_d_clingo_symbolic_atoms_next },
  { "clingo_symbolic_atoms_signatures", (void *)_cffi_f_clingo_symbolic_atoms_signatures, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 862), (void *)_cffi_d_clingo_symbolic_atoms_signatures },
  { "clingo_symbolic_atoms_signatures_size", (void *)_cffi_f_clingo_symbolic_atoms_signatures_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 854), (void *)_cffi_d_clingo_symbolic_atoms_signatures_size },
  { "clingo_symbolic_atoms_size", (void *)_cffi_f_clingo_symbolic_atoms_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 854), (void *)_cffi_d_clingo_symbolic_atoms_size },
  { "clingo_symbolic_atoms_symbol", (void *)_cffi_f_clingo_symbolic_atoms_symbol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 882), (void *)_cffi_d_clingo_symbolic_atoms_symbol },
  { "clingo_theory_atoms_atom_elements", (void *)_cffi_f_clingo_theory_atoms_atom_elements, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 945), (void *)_cffi_d_clingo_theory_atoms_atom_elements },
  { "clingo_theory_atoms_atom_guard", (void *)_cffi_f_clingo_theory_atoms_atom_guard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 913), (void *)_cffi_d_clingo_theory_atoms_atom_guard },
  { "clingo_theory_atoms_atom_has_guard", (void *)_cffi_f_clingo_theory_atoms_atom_has_guard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 897), (void *)_cffi_d_clingo_theory_atoms_atom_has_guard },
  { "clingo_theory_atoms_atom_literal", (void *)_cffi_f_clingo_theory_atoms_atom_literal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 924), (void *)_cffi_d_clingo_theory_atoms_atom_literal },
  { "clingo_theory_atoms_atom_term", (void *)_cffi_f_clingo_theory_atoms_atom_term, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 940), (void *)_cffi_d_clingo_theory_atoms_atom_term },
  { "clingo_theory_atoms_atom_to_string", (void *)_cffi_f_clingo_theory_atoms_atom_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 902), (void *)_cffi_d_clingo_theory_atoms_atom_to_string },
  { "clingo_theory_atoms_atom_to_string_size", (void *)_cffi_f_clingo_theory_atoms_atom_to_string_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 935), (void *)_cffi_d_clingo_theory_atoms_atom_to_string_size },
  { "clingo_theory_atoms_element_condition", (void *)_cffi_f_clingo_theory_atoms_element_condition, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 929), (void *)_cffi_d_clingo_theory_atoms_element_condition },
  { "clingo_theory_atoms_element_condition_id", (void *)_cffi_f_clingo_theory_atoms_element_condition_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 924), (void *)_cffi_d_clingo_theory_atoms_element_condition_id },
  { "clingo_theory_atoms_element_to_string", (void *)_cffi_f_clingo_theory_atoms_element_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 902), (void *)_cffi_d_clingo_theory_atoms_element_to_string },
  { "clingo_theory_atoms_element_to_string_size", (void *)_cffi_f_clingo_theory_atoms_element_to_string_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 935), (void *)_cffi_d_clingo_theory_atoms_element_to_string_size },
  { "clingo_theory_atoms_element_tuple", (void *)_cffi_f_clingo_theory_atoms_element_tuple, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 945), (void *)_cffi_d_clingo_theory_atoms_element_tuple },
  { "clingo_theory_atoms_size", (void *)_cffi_f_clingo_theory_atoms_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 893), (void *)_cffi_d_clingo_theory_atoms_size },
  { "clingo_theory_atoms_term_arguments", (void *)_cffi_f_clingo_theory_atoms_term_arguments, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 945), (void *)_cffi_d_clingo_theory_atoms_term_arguments },
  { "clingo_theory_atoms_term_name", (void *)_cffi_f_clingo_theory_atoms_term_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 908), (void *)_cffi_d_clingo_theory_atoms_term_name },
  { "clingo_theory_atoms_term_number", (void *)_cffi_f_clingo_theory_atoms_term_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 919), (void *)_cffi_d_clingo_theory_atoms_term_number },
  { "clingo_theory_atoms_term_to_string", (void *)_cffi_f_clingo_theory_atoms_term_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 902), (void *)_cffi_d_clingo_theory_atoms_term_to_string },
  { "clingo_theory_atoms_term_to_string_size", (void *)_cffi_f_clingo_theory_atoms_term_to_string_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 935), (void *)_cffi_d_clingo_theory_atoms_term_to_string_size },
  { "clingo_theory_atoms_term_type", (void *)_cffi_f_clingo_theory_atoms_term_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 919), (void *)_cffi_d_clingo_theory_atoms_term_type },
  { "clingo_theory_sequence_type_list", (void *)_cffi_const_clingo_theory_sequence_type_list, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_sequence_type_set", (void *)_cffi_const_clingo_theory_sequence_type_set, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_sequence_type_tuple", (void *)_cffi_const_clingo_theory_sequence_type_tuple, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_term_type_function", (void *)_cffi_const_clingo_theory_term_type_function, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_term_type_list", (void *)_cffi_const_clingo_theory_term_type_list, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_term_type_number", (void *)_cffi_const_clingo_theory_term_type_number, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_term_type_set", (void *)_cffi_const_clingo_theory_term_type_set, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_term_type_symbol", (void *)_cffi_const_clingo_theory_term_type_symbol, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_theory_term_type_tuple", (void *)_cffi_const_clingo_theory_term_type_tuple, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_truth_value_false", (void *)_cffi_const_clingo_truth_value_false, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_truth_value_free", (void *)_cffi_const_clingo_truth_value_free, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_truth_value_true", (void *)_cffi_const_clingo_truth_value_true, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_version", (void *)_cffi_f_clingo_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1191), (void *)_cffi_d_clingo_version },
  { "clingo_warning_atom_undefined", (void *)_cffi_const_clingo_warning_atom_undefined, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_warning_file_included", (void *)_cffi_const_clingo_warning_file_included, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_warning_global_variable", (void *)_cffi_const_clingo_warning_global_variable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_warning_operation_undefined", (void *)_cffi_const_clingo_warning_operation_undefined, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_warning_other", (void *)_cffi_const_clingo_warning_other, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_warning_runtime_error", (void *)_cffi_const_clingo_warning_runtime_error, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_warning_string", (void *)_cffi_f_clingo_warning_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1114), (void *)_cffi_d_clingo_warning_string },
  { "clingo_warning_variable_unbounded", (void *)_cffi_const_clingo_warning_variable_unbounded, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_weight_constraint_type_equivalence", (void *)_cffi_const_clingo_weight_constraint_type_equivalence, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_weight_constraint_type_implication_left", (void *)_cffi_const_clingo_weight_constraint_type_implication_left, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clingo_weight_constraint_type_implication_right", (void *)_cffi_const_clingo_weight_constraint_type_implication_right, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "g_clingo_ast_attribute_names", (void *)_cffi_var_g_clingo_ast_attribute_names, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 1255), (void *)0 },
  { "g_clingo_ast_constructors", (void *)_cffi_var_g_clingo_ast_constructors, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 1258), (void *)0 },
  { "pyclingo_application_logger", (void *)&_cffi_externpy__pyclingo_application_logger, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 27), (void *)pyclingo_application_logger },
  { "pyclingo_application_main", (void *)&_cffi_externpy__pyclingo_application_main, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1220), (void *)pyclingo_application_main },
  { "pyclingo_application_message_limit", (void *)&_cffi_externpy__pyclingo_application_message_limit, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1313), (void *)pyclingo_application_message_limit },
  { "pyclingo_application_options_parse", (void *)&_cffi_externpy__pyclingo_application_options_parse, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 662), (void *)pyclingo_application_options_parse },
  { "pyclingo_application_print_model", (void *)&_cffi_externpy__pyclingo_application_print_model, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1226), (void *)pyclingo_application_print_model },
  { "pyclingo_application_program_name", (void *)&_cffi_externpy__pyclingo_application_program_name, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1249), (void *)pyclingo_application_program_name },
  { "pyclingo_application_register_options", (void *)&_cffi_externpy__pyclingo_application_register_options, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1227), (void *)pyclingo_application_register_options },
  { "pyclingo_application_validate_options", (void *)&_cffi_externpy__pyclingo_application_validate_options, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 590), (void *)pyclingo_application_validate_options },
  { "pyclingo_application_version", (void *)&_cffi_externpy__pyclingo_application_version, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1249), (void *)pyclingo_application_version },
  { "pyclingo_ast_callback", (void *)&_cffi_externpy__pyclingo_ast_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1219), (void *)pyclingo_ast_callback },
  { "pyclingo_call", (void *)&_cffi_externpy__pyclingo_call, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1247), (void *)pyclingo_call },
  { "pyclingo_callable", (void *)&_cffi_externpy__pyclingo_callable, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1218), (void *)pyclingo_callable },
  { "pyclingo_execute", (void *)&_cffi_externpy__pyclingo_execute, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1246), (void *)pyclingo_execute },
  { "pyclingo_ground_callback", (void *)&_cffi_externpy__pyclingo_ground_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 478), (void *)pyclingo_ground_callback },
  { "pyclingo_logger_callback", (void *)&_cffi_externpy__pyclingo_logger_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 27), (void *)pyclingo_logger_callback },
  { "pyclingo_main", (void *)&_cffi_externpy__pyclingo_main, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1248), (void *)pyclingo_main },
  { "pyclingo_observer_acyc_edge", (void *)&_cffi_externpy__pyclingo_observer_acyc_edge, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1232), (void *)pyclingo_observer_acyc_edge },
  { "pyclingo_observer_assume", (void *)&_cffi_externpy__pyclingo_observer_assume, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1233), (void *)pyclingo_observer_assume },
  { "pyclingo_observer_begin_step", (void *)&_cffi_externpy__pyclingo_observer_begin_step, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 590), (void *)pyclingo_observer_begin_step },
  { "pyclingo_observer_end_step", (void *)&_cffi_externpy__pyclingo_observer_end_step, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 590), (void *)pyclingo_observer_end_step },
  { "pyclingo_observer_external", (void *)&_cffi_externpy__pyclingo_observer_external, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1240), (void *)pyclingo_observer_external },
  { "pyclingo_observer_heuristic", (void *)&_cffi_externpy__pyclingo_observer_heuristic, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1238), (void *)pyclingo_observer_heuristic },
  { "pyclingo_observer_init_program", (void *)&_cffi_externpy__pyclingo_observer_init_program, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1217), (void *)pyclingo_observer_init_program },
  { "pyclingo_observer_minimize", (void *)&_cffi_externpy__pyclingo_observer_minimize, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1234), (void *)pyclingo_observer_minimize },
  { "pyclingo_observer_output_atom", (void *)&_cffi_externpy__pyclingo_observer_output_atom, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1245), (void *)pyclingo_observer_output_atom },
  { "pyclingo_observer_output_term", (void *)&_cffi_externpy__pyclingo_observer_output_term, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1244), (void *)pyclingo_observer_output_term },
  { "pyclingo_observer_project", (void *)&_cffi_externpy__pyclingo_observer_project, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1235), (void *)pyclingo_observer_project },
  { "pyclingo_observer_rule", (void *)&_cffi_externpy__pyclingo_observer_rule, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1215), (void *)pyclingo_observer_rule },
  { "pyclingo_observer_theory_atom", (void *)&_cffi_externpy__pyclingo_observer_theory_atom, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1243), (void *)pyclingo_observer_theory_atom },
  { "pyclingo_observer_theory_atom_with_guard", (void *)&_cffi_externpy__pyclingo_observer_theory_atom_with_guard, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1242), (void *)pyclingo_observer_theory_atom_with_guard },
  { "pyclingo_observer_theory_element", (void *)&_cffi_externpy__pyclingo_observer_theory_element, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1241), (void *)pyclingo_observer_theory_element },
  { "pyclingo_observer_theory_term_compound", (void *)&_cffi_externpy__pyclingo_observer_theory_term_compound, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1239), (void *)pyclingo_observer_theory_term_compound },
  { "pyclingo_observer_theory_term_number", (void *)&_cffi_externpy__pyclingo_observer_theory_term_number, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1240), (void *)pyclingo_observer_theory_term_number },
  { "pyclingo_observer_theory_term_string", (void *)&_cffi_externpy__pyclingo_observer_theory_term_string, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1236), (void *)pyclingo_observer_theory_term_string },
  { "pyclingo_observer_weight_rule", (void *)&_cffi_externpy__pyclingo_observer_weight_rule, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1216), (void *)pyclingo_observer_weight_rule },
  { "pyclingo_propagator_check", (void *)&_cffi_externpy__pyclingo_propagator_check, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1229), (void *)pyclingo_propagator_check },
  { "pyclingo_propagator_decide", (void *)&_cffi_externpy__pyclingo_propagator_decide, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1237), (void *)pyclingo_propagator_decide },
  { "pyclingo_propagator_init", (void *)&_cffi_externpy__pyclingo_propagator_init, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1230), (void *)pyclingo_propagator_init },
  { "pyclingo_propagator_propagate", (void *)&_cffi_externpy__pyclingo_propagator_propagate, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1228), (void *)pyclingo_propagator_propagate },
  { "pyclingo_propagator_undo", (void *)&_cffi_externpy__pyclingo_propagator_undo, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1314), (void *)pyclingo_propagator_undo },
  { "pyclingo_script_call", (void *)&_cffi_externpy__pyclingo_script_call, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1223), (void *)pyclingo_script_call },
  { "pyclingo_script_callable", (void *)&_cffi_externpy__pyclingo_script_callable, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1218), (void *)pyclingo_script_callable },
  { "pyclingo_script_execute", (void *)&_cffi_externpy__pyclingo_script_execute, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1222), (void *)pyclingo_script_execute },
  { "pyclingo_script_main", (void *)&_cffi_externpy__pyclingo_script_main, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 1221), (void *)pyclingo_script_main },
  { "pyclingo_solve_event_callback", (void *)&_cffi_externpy__pyclingo_solve_event_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 505), (void *)pyclingo_solve_event_callback },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "program_name", offsetof(clingo_application_t, program_name),
                    sizeof(((clingo_application_t *)0)->program_name),
                    _CFFI_OP(_CFFI_OP_NOOP, 1249) },
  { "version", offsetof(clingo_application_t, version),
               sizeof(((clingo_application_t *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 1249) },
  { "message_limit", offsetof(clingo_application_t, message_limit),
                     sizeof(((clingo_application_t *)0)->message_limit),
                     _CFFI_OP(_CFFI_OP_NOOP, 1313) },
  { "main", offsetof(clingo_application_t, main),
            sizeof(((clingo_application_t *)0)->main),
            _CFFI_OP(_CFFI_OP_NOOP, 1220) },
  { "logger", offsetof(clingo_application_t, logger),
              sizeof(((clingo_application_t *)0)->logger),
              _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "printer", offsetof(clingo_application_t, printer),
               sizeof(((clingo_application_t *)0)->printer),
               _CFFI_OP(_CFFI_OP_NOOP, 1226) },
  { "register_options", offsetof(clingo_application_t, register_options),
                        sizeof(((clingo_application_t *)0)->register_options),
                        _CFFI_OP(_CFFI_OP_NOOP, 1227) },
  { "validate_options", offsetof(clingo_application_t, validate_options),
                        sizeof(((clingo_application_t *)0)->validate_options),
                        _CFFI_OP(_CFFI_OP_NOOP, 590) },
  { "attribute", offsetof(clingo_ast_argument_t, attribute),
                 sizeof(((clingo_ast_argument_t *)0)->attribute),
                 _CFFI_OP(_CFFI_OP_NOOP, 155) },
  { "type", offsetof(clingo_ast_argument_t, type),
            sizeof(((clingo_ast_argument_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 155) },
  { "names", offsetof(clingo_ast_attribute_names_t, names),
             sizeof(((clingo_ast_attribute_names_t *)0)->names),
             _CFFI_OP(_CFFI_OP_NOOP, 22) },
  { "size", offsetof(clingo_ast_attribute_names_t, size),
            sizeof(((clingo_ast_attribute_names_t *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "name", offsetof(clingo_ast_constructor_t, name),
            sizeof(((clingo_ast_constructor_t *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "arguments", offsetof(clingo_ast_constructor_t, arguments),
                 sizeof(((clingo_ast_constructor_t *)0)->arguments),
                 _CFFI_OP(_CFFI_OP_NOOP, 1253) },
  { "size", offsetof(clingo_ast_constructor_t, size),
            sizeof(((clingo_ast_constructor_t *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "constructors", offsetof(clingo_ast_constructors_t, constructors),
                    sizeof(((clingo_ast_constructors_t *)0)->constructors),
                    _CFFI_OP(_CFFI_OP_NOOP, 1256) },
  { "size", offsetof(clingo_ast_constructors_t, size),
            sizeof(((clingo_ast_constructors_t *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "init_program", offsetof(clingo_ground_program_observer_t, init_program),
                    sizeof(((clingo_ground_program_observer_t *)0)->init_program),
                    _CFFI_OP(_CFFI_OP_NOOP, 1217) },
  { "begin_step", offsetof(clingo_ground_program_observer_t, begin_step),
                  sizeof(((clingo_ground_program_observer_t *)0)->begin_step),
                  _CFFI_OP(_CFFI_OP_NOOP, 590) },
  { "end_step", offsetof(clingo_ground_program_observer_t, end_step),
                sizeof(((clingo_ground_program_observer_t *)0)->end_step),
                _CFFI_OP(_CFFI_OP_NOOP, 590) },
  { "rule", offsetof(clingo_ground_program_observer_t, rule),
            sizeof(((clingo_ground_program_observer_t *)0)->rule),
            _CFFI_OP(_CFFI_OP_NOOP, 1215) },
  { "weight_rule", offsetof(clingo_ground_program_observer_t, weight_rule),
                   sizeof(((clingo_ground_program_observer_t *)0)->weight_rule),
                   _CFFI_OP(_CFFI_OP_NOOP, 1216) },
  { "minimize", offsetof(clingo_ground_program_observer_t, minimize),
                sizeof(((clingo_ground_program_observer_t *)0)->minimize),
                _CFFI_OP(_CFFI_OP_NOOP, 1234) },
  { "project", offsetof(clingo_ground_program_observer_t, project),
               sizeof(((clingo_ground_program_observer_t *)0)->project),
               _CFFI_OP(_CFFI_OP_NOOP, 1235) },
  { "output_atom", offsetof(clingo_ground_program_observer_t, output_atom),
                   sizeof(((clingo_ground_program_observer_t *)0)->output_atom),
                   _CFFI_OP(_CFFI_OP_NOOP, 1245) },
  { "output_term", offsetof(clingo_ground_program_observer_t, output_term),
                   sizeof(((clingo_ground_program_observer_t *)0)->output_term),
                   _CFFI_OP(_CFFI_OP_NOOP, 1244) },
  { "external", offsetof(clingo_ground_program_observer_t, external),
                sizeof(((clingo_ground_program_observer_t *)0)->external),
                _CFFI_OP(_CFFI_OP_NOOP, 1240) },
  { "assume", offsetof(clingo_ground_program_observer_t, assume),
              sizeof(((clingo_ground_program_observer_t *)0)->assume),
              _CFFI_OP(_CFFI_OP_NOOP, 1233) },
  { "heuristic", offsetof(clingo_ground_program_observer_t, heuristic),
                 sizeof(((clingo_ground_program_observer_t *)0)->heuristic),
                 _CFFI_OP(_CFFI_OP_NOOP, 1238) },
  { "acyc_edge", offsetof(clingo_ground_program_observer_t, acyc_edge),
                 sizeof(((clingo_ground_program_observer_t *)0)->acyc_edge),
                 _CFFI_OP(_CFFI_OP_NOOP, 1232) },
  { "theory_term_number", offsetof(clingo_ground_program_observer_t, theory_term_number),
                          sizeof(((clingo_ground_program_observer_t *)0)->theory_term_number),
                          _CFFI_OP(_CFFI_OP_NOOP, 1240) },
  { "theory_term_string", offsetof(clingo_ground_program_observer_t, theory_term_string),
                          sizeof(((clingo_ground_program_observer_t *)0)->theory_term_string),
                          _CFFI_OP(_CFFI_OP_NOOP, 1236) },
  { "theory_term_compound", offsetof(clingo_ground_program_observer_t, theory_term_compound),
                            sizeof(((clingo_ground_program_observer_t *)0)->theory_term_compound),
                            _CFFI_OP(_CFFI_OP_NOOP, 1239) },
  { "theory_element", offsetof(clingo_ground_program_observer_t, theory_element),
                      sizeof(((clingo_ground_program_observer_t *)0)->theory_element),
                      _CFFI_OP(_CFFI_OP_NOOP, 1241) },
  { "theory_atom", offsetof(clingo_ground_program_observer_t, theory_atom),
                   sizeof(((clingo_ground_program_observer_t *)0)->theory_atom),
                   _CFFI_OP(_CFFI_OP_NOOP, 1243) },
  { "theory_atom_with_guard", offsetof(clingo_ground_program_observer_t, theory_atom_with_guard),
                              sizeof(((clingo_ground_program_observer_t *)0)->theory_atom_with_guard),
                              _CFFI_OP(_CFFI_OP_NOOP, 1242) },
  { "begin_file", offsetof(clingo_location_t, begin_file),
                  sizeof(((clingo_location_t *)0)->begin_file),
                  _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "end_file", offsetof(clingo_location_t, end_file),
                sizeof(((clingo_location_t *)0)->end_file),
                _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "begin_line", offsetof(clingo_location_t, begin_line),
                  sizeof(((clingo_location_t *)0)->begin_line),
                  _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "end_line", offsetof(clingo_location_t, end_line),
                sizeof(((clingo_location_t *)0)->end_line),
                _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "begin_column", offsetof(clingo_location_t, begin_column),
                    sizeof(((clingo_location_t *)0)->begin_column),
                    _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "end_column", offsetof(clingo_location_t, end_column),
                  sizeof(((clingo_location_t *)0)->end_column),
                  _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "name", offsetof(clingo_part_t, name),
            sizeof(((clingo_part_t *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "params", offsetof(clingo_part_t, params),
              sizeof(((clingo_part_t *)0)->params),
              _CFFI_OP(_CFFI_OP_NOOP, 79) },
  { "size", offsetof(clingo_part_t, size),
            sizeof(((clingo_part_t *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "init", offsetof(clingo_propagator_t, init),
            sizeof(((clingo_propagator_t *)0)->init),
            _CFFI_OP(_CFFI_OP_NOOP, 1230) },
  { "propagate", offsetof(clingo_propagator_t, propagate),
                 sizeof(((clingo_propagator_t *)0)->propagate),
                 _CFFI_OP(_CFFI_OP_NOOP, 1228) },
  { "undo", offsetof(clingo_propagator_t, undo),
            sizeof(((clingo_propagator_t *)0)->undo),
            _CFFI_OP(_CFFI_OP_NOOP, 1314) },
  { "check", offsetof(clingo_propagator_t, check),
             sizeof(((clingo_propagator_t *)0)->check),
             _CFFI_OP(_CFFI_OP_NOOP, 1229) },
  { "decide", offsetof(clingo_propagator_t, decide),
              sizeof(((clingo_propagator_t *)0)->decide),
              _CFFI_OP(_CFFI_OP_NOOP, 1237) },
  { "execute", offsetof(clingo_script_t, execute),
               sizeof(((clingo_script_t *)0)->execute),
               _CFFI_OP(_CFFI_OP_NOOP, 1225) },
  { "call", offsetof(clingo_script_t, call),
            sizeof(((clingo_script_t *)0)->call),
            _CFFI_OP(_CFFI_OP_NOOP, 1224) },
  { "callable", offsetof(clingo_script_t, callable),
                sizeof(((clingo_script_t *)0)->callable),
                _CFFI_OP(_CFFI_OP_NOOP, 1218) },
  { "main", offsetof(clingo_script_t, main),
            sizeof(((clingo_script_t *)0)->main),
            _CFFI_OP(_CFFI_OP_NOOP, 1221) },
  { "free", offsetof(clingo_script_t, free),
            sizeof(((clingo_script_t *)0)->free),
            _CFFI_OP(_CFFI_OP_NOOP, 1315) },
  { "version", offsetof(clingo_script_t, version),
               sizeof(((clingo_script_t *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "literal", offsetof(clingo_weighted_literal_t, literal),
               sizeof(((clingo_weighted_literal_t *)0)->literal),
               _CFFI_OP(_CFFI_OP_NOOP, 12) },
  { "weight", offsetof(clingo_weighted_literal_t, weight),
              sizeof(((clingo_weighted_literal_t *)0)->weight),
              _CFFI_OP(_CFFI_OP_NOOP, 12) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "clingo_application", 1251, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_application_t), offsetof(struct _cffi_align__clingo_application_t, y), 0, 8 },
  { "clingo_assignment", 1252, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_ast", 1259, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_ast_argument", 1254, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_ast_argument_t), offsetof(struct _cffi_align__clingo_ast_argument_t, y), 8, 2 },
  { "clingo_ast_attribute_names", 1255, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_ast_attribute_names_t), offsetof(struct _cffi_align__clingo_ast_attribute_names_t, y), 10, 2 },
  { "clingo_ast_constructor", 1257, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_ast_constructor_t), offsetof(struct _cffi_align__clingo_ast_constructor_t, y), 12, 3 },
  { "clingo_ast_constructors", 1258, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_ast_constructors_t), offsetof(struct _cffi_align__clingo_ast_constructors_t, y), 15, 2 },
  { "clingo_backend", 1260, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_configuration", 1261, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_control", 1262, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_ground_program_observer", 1263, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_ground_program_observer_t), offsetof(struct _cffi_align__clingo_ground_program_observer_t, y), 17, 19 },
  { "clingo_location", 1264, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_location_t), offsetof(struct _cffi_align__clingo_location_t, y), 36, 6 },
  { "clingo_model", 1265, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_options", 1266, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_part", 1267, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_part_t), offsetof(struct _cffi_align__clingo_part_t, y), 42, 3 },
  { "clingo_program_builder", 1268, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_propagate_control", 1269, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_propagate_init", 1270, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_propagator", 1271, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_propagator_t), offsetof(struct _cffi_align__clingo_propagator_t, y), 45, 5 },
  { "clingo_script", 1272, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_script_t), offsetof(struct _cffi_align__clingo_script_t, y), 50, 6 },
  { "clingo_solve_control", 1273, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_solve_handle", 1274, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_statistic", 1275, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_symbolic_atoms", 1276, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_theory_atoms", 1277, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "clingo_weighted_literal", 1278, _CFFI_F_CHECK_FIELDS,
    sizeof(clingo_weighted_literal_t), offsetof(struct _cffi_align__clingo_weighted_literal_t, y), 56, 2 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "clingo_ast_aggregate_function_e", 1279, _cffi_prim_int(sizeof(enum clingo_ast_aggregate_function_e), ((enum clingo_ast_aggregate_function_e)-1) <= 0),
    "clingo_ast_aggregate_function_count,clingo_ast_aggregate_function_sum,clingo_ast_aggregate_function_sump,clingo_ast_aggregate_function_min,clingo_ast_aggregate_function_max" },
  { "clingo_ast_attribute_e", 1280, _cffi_prim_int(sizeof(enum clingo_ast_attribute_e), ((enum clingo_ast_attribute_e)-1) <= 0),
    "clingo_ast_attribute_argument,clingo_ast_attribute_arguments,clingo_ast_attribute_arity,clingo_ast_attribute_atom,clingo_ast_attribute_atoms,clingo_ast_attribute_atom_type,clingo_ast_attribute_bias,clingo_ast_attribute_body,clingo_ast_attribute_code,clingo_ast_attribute_coefficient,clingo_ast_attribute_comparison,clingo_ast_attribute_condition,clingo_ast_attribute_elements,clingo_ast_attribute_external,clingo_ast_attribute_external_type,clingo_ast_attribute_function,clingo_ast_attribute_guard,clingo_ast_attribute_guards,clingo_ast_attribute_head,clingo_ast_attribute_is_default,clingo_ast_attribute_left,clingo_ast_attribute_left_guard,clingo_ast_attribute_literal,clingo_ast_attribute_location,clingo_ast_attribute_modifier,clingo_ast_attribute_name,clingo_ast_attribute_node_u,clingo_ast_attribute_node_v,clingo_ast_attribute_operator_name,clingo_ast_attribute_operator_type,clingo_ast_attribute_operators,clingo_ast_attribute_parameters,clingo_ast_attribute_positive,clingo_ast_attribute_priority,clingo_ast_attribute_right,clingo_ast_attribute_right_guard,clingo_ast_attribute_sequence_type,clingo_ast_attribute_sign,clingo_ast_attribute_symbol,clingo_ast_attribute_term,clingo_ast_attribute_terms,clingo_ast_attribute_value,clingo_ast_attribute_variable,clingo_ast_attribute_weight,clingo_ast_attribute_comment_type" },
  { "clingo_ast_attribute_type_e", 1281, _cffi_prim_int(sizeof(enum clingo_ast_attribute_type_e), ((enum clingo_ast_attribute_type_e)-1) <= 0),
    "clingo_ast_attribute_type_number,clingo_ast_attribute_type_symbol,clingo_ast_attribute_type_location,clingo_ast_attribute_type_string,clingo_ast_attribute_type_ast,clingo_ast_attribute_type_optional_ast,clingo_ast_attribute_type_string_array,clingo_ast_attribute_type_ast_array" },
  { "clingo_ast_binary_operator_e", 1282, _cffi_prim_int(sizeof(enum clingo_ast_binary_operator_e), ((enum clingo_ast_binary_operator_e)-1) <= 0),
    "clingo_ast_binary_operator_xor,clingo_ast_binary_operator_or,clingo_ast_binary_operator_and,clingo_ast_binary_operator_plus,clingo_ast_binary_operator_minus,clingo_ast_binary_operator_multiplication,clingo_ast_binary_operator_division,clingo_ast_binary_operator_modulo,clingo_ast_binary_operator_power" },
  { "clingo_ast_comparison_operator_e", 1283, _cffi_prim_int(sizeof(enum clingo_ast_comparison_operator_e), ((enum clingo_ast_comparison_operator_e)-1) <= 0),
    "clingo_ast_comparison_operator_greater_than,clingo_ast_comparison_operator_less_than,clingo_ast_comparison_operator_less_equal,clingo_ast_comparison_operator_greater_equal,clingo_ast_comparison_operator_not_equal,clingo_ast_comparison_operator_equal" },
  { "clingo_ast_sign_e", 1284, _cffi_prim_int(sizeof(enum clingo_ast_sign_e), ((enum clingo_ast_sign_e)-1) <= 0),
    "clingo_ast_sign_no_sign,clingo_ast_sign_negation,clingo_ast_sign_double_negation" },
  { "clingo_ast_theory_atom_definition_type_e", 1285, _cffi_prim_int(sizeof(enum clingo_ast_theory_atom_definition_type_e), ((enum clingo_ast_theory_atom_definition_type_e)-1) <= 0),
    "clingo_ast_theory_atom_definition_type_head,clingo_ast_theory_atom_definition_type_body,clingo_ast_theory_atom_definition_type_any,clingo_ast_theory_atom_definition_type_directive" },
  { "clingo_ast_theory_operator_type_e", 1286, _cffi_prim_int(sizeof(enum clingo_ast_theory_operator_type_e), ((enum clingo_ast_theory_operator_type_e)-1) <= 0),
    "clingo_ast_theory_operator_type_unary,clingo_ast_theory_operator_type_binary_left,clingo_ast_theory_operator_type_binary_right" },
  { "clingo_ast_theory_sequence_type_e", 1287, _cffi_prim_int(sizeof(enum clingo_ast_theory_sequence_type_e), ((enum clingo_ast_theory_sequence_type_e)-1) <= 0),
    "clingo_ast_theory_sequence_type_tuple,clingo_ast_theory_sequence_type_list,clingo_ast_theory_sequence_type_set" },
  { "clingo_ast_type_e", 1288, _cffi_prim_int(sizeof(enum clingo_ast_type_e), ((enum clingo_ast_type_e)-1) <= 0),
    "clingo_ast_type_id,clingo_ast_type_variable,clingo_ast_type_symbolic_term,clingo_ast_type_unary_operation,clingo_ast_type_binary_operation,clingo_ast_type_interval,clingo_ast_type_function,clingo_ast_type_pool,clingo_ast_type_boolean_constant,clingo_ast_type_symbolic_atom,clingo_ast_type_comparison,clingo_ast_type_guard,clingo_ast_type_conditional_literal,clingo_ast_type_aggregate,clingo_ast_type_body_aggregate_element,clingo_ast_type_body_aggregate,clingo_ast_type_head_aggregate_element,clingo_ast_type_head_aggregate,clingo_ast_type_disjunction,clingo_ast_type_theory_sequence,clingo_ast_type_theory_function,clingo_ast_type_theory_unparsed_term_element,clingo_ast_type_theory_unparsed_term,clingo_ast_type_theory_guard,clingo_ast_type_theory_atom_element,clingo_ast_type_theory_atom,clingo_ast_type_literal,clingo_ast_type_theory_operator_definition,clingo_ast_type_theory_term_definition,clingo_ast_type_theory_guard_definition,clingo_ast_type_theory_atom_definition,clingo_ast_type_rule,clingo_ast_type_definition,clingo_ast_type_show_signature,clingo_ast_type_show_term,clingo_ast_type_minimize,clingo_ast_type_script,clingo_ast_type_program,clingo_ast_type_external,clingo_ast_type_edge,clingo_ast_type_heuristic,clingo_ast_type_project_atom,clingo_ast_type_project_signature,clingo_ast_type_defined,clingo_ast_type_theory_definition,clingo_ast_type_comment" },
  { "clingo_ast_unary_operator_e", 1289, _cffi_prim_int(sizeof(enum clingo_ast_unary_operator_e), ((enum clingo_ast_unary_operator_e)-1) <= 0),
    "clingo_ast_unary_operator_minus,clingo_ast_unary_operator_negation,clingo_ast_unary_operator_absolute" },
  { "clingo_ast_unpool_type_e", 1290, _cffi_prim_int(sizeof(enum clingo_ast_unpool_type_e), ((enum clingo_ast_unpool_type_e)-1) <= 0),
    "clingo_ast_unpool_type_condition,clingo_ast_unpool_type_other,clingo_ast_unpool_type_all" },
  { "clingo_clause_type_e", 1291, _cffi_prim_int(sizeof(enum clingo_clause_type_e), ((enum clingo_clause_type_e)-1) <= 0),
    "clingo_clause_type_learnt,clingo_clause_type_static,clingo_clause_type_volatile,clingo_clause_type_volatile_static" },
  { "clingo_comment_type_e", 1292, _cffi_prim_int(sizeof(enum clingo_comment_type_e), ((enum clingo_comment_type_e)-1) <= 0),
    "clingo_comment_type_line,clingo_comment_type_block" },
  { "clingo_configuration_type_e", 1293, _cffi_prim_int(sizeof(enum clingo_configuration_type_e), ((enum clingo_configuration_type_e)-1) <= 0),
    "clingo_configuration_type_value,clingo_configuration_type_array,clingo_configuration_type_map" },
  { "clingo_consequence_e", 1294, _cffi_prim_int(sizeof(enum clingo_consequence_e), ((enum clingo_consequence_e)-1) <= 0),
    "clingo_consequence_false,clingo_consequence_true,clingo_consequence_unknown" },
  { "clingo_error_e", 1295, _cffi_prim_int(sizeof(enum clingo_error_e), ((enum clingo_error_e)-1) <= 0),
    "clingo_error_success,clingo_error_runtime,clingo_error_logic,clingo_error_bad_alloc,clingo_error_unknown" },
  { "clingo_external_type_e", 1296, _cffi_prim_int(sizeof(enum clingo_external_type_e), ((enum clingo_external_type_e)-1) <= 0),
    "clingo_external_type_free,clingo_external_type_true,clingo_external_type_false,clingo_external_type_release" },
  { "clingo_heuristic_type_e", 1297, _cffi_prim_int(sizeof(enum clingo_heuristic_type_e), ((enum clingo_heuristic_type_e)-1) <= 0),
    "clingo_heuristic_type_level,clingo_heuristic_type_sign,clingo_heuristic_type_factor,clingo_heuristic_type_init,clingo_heuristic_type_true,clingo_heuristic_type_false" },
  { "clingo_model_type_e", 1298, _cffi_prim_int(sizeof(enum clingo_model_type_e), ((enum clingo_model_type_e)-1) <= 0),
    "clingo_model_type_stable_model,clingo_model_type_brave_consequences,clingo_model_type_cautious_consequences" },
  { "clingo_propagator_check_mode_e", 1299, _cffi_prim_int(sizeof(enum clingo_propagator_check_mode_e), ((enum clingo_propagator_check_mode_e)-1) <= 0),
    "clingo_propagator_check_mode_none,clingo_propagator_check_mode_total,clingo_propagator_check_mode_fixpoint,clingo_propagator_check_mode_both" },
  { "clingo_propagator_undo_mode_e", 1300, _cffi_prim_int(sizeof(enum clingo_propagator_undo_mode_e), ((enum clingo_propagator_undo_mode_e)-1) <= 0),
    "clingo_propagator_undo_mode_default,clingo_propagator_undo_mode_always" },
  { "clingo_show_type_e", 1301, _cffi_prim_int(sizeof(enum clingo_show_type_e), ((enum clingo_show_type_e)-1) <= 0),
    "clingo_show_type_shown,clingo_show_type_atoms,clingo_show_type_terms,clingo_show_type_theory,clingo_show_type_all,clingo_show_type_complement" },
  { "clingo_solve_event_type_e", 1302, _cffi_prim_int(sizeof(enum clingo_solve_event_type_e), ((enum clingo_solve_event_type_e)-1) <= 0),
    "clingo_solve_event_type_model,clingo_solve_event_type_unsat,clingo_solve_event_type_statistics,clingo_solve_event_type_finish" },
  { "clingo_solve_mode_e", 1303, _cffi_prim_int(sizeof(enum clingo_solve_mode_e), ((enum clingo_solve_mode_e)-1) <= 0),
    "clingo_solve_mode_async,clingo_solve_mode_yield" },
  { "clingo_solve_result_e", 1304, _cffi_prim_int(sizeof(enum clingo_solve_result_e), ((enum clingo_solve_result_e)-1) <= 0),
    "clingo_solve_result_satisfiable,clingo_solve_result_unsatisfiable,clingo_solve_result_exhausted,clingo_solve_result_interrupted" },
  { "clingo_statistics_type_e", 1305, _cffi_prim_int(sizeof(enum clingo_statistics_type_e), ((enum clingo_statistics_type_e)-1) <= 0),
    "clingo_statistics_type_empty,clingo_statistics_type_value,clingo_statistics_type_array,clingo_statistics_type_map" },
  { "clingo_symbol_type_e", 1306, _cffi_prim_int(sizeof(enum clingo_symbol_type_e), ((enum clingo_symbol_type_e)-1) <= 0),
    "clingo_symbol_type_infimum,clingo_symbol_type_number,clingo_symbol_type_string,clingo_symbol_type_function,clingo_symbol_type_supremum" },
  { "clingo_theory_sequence_type_e", 1307, _cffi_prim_int(sizeof(enum clingo_theory_sequence_type_e), ((enum clingo_theory_sequence_type_e)-1) <= 0),
    "clingo_theory_sequence_type_tuple,clingo_theory_sequence_type_set,clingo_theory_sequence_type_list" },
  { "clingo_theory_term_type_e", 1308, _cffi_prim_int(sizeof(enum clingo_theory_term_type_e), ((enum clingo_theory_term_type_e)-1) <= 0),
    "clingo_theory_term_type_tuple,clingo_theory_term_type_list,clingo_theory_term_type_set,clingo_theory_term_type_function,clingo_theory_term_type_number,clingo_theory_term_type_symbol" },
  { "clingo_truth_value_e", 1309, _cffi_prim_int(sizeof(enum clingo_truth_value_e), ((enum clingo_truth_value_e)-1) <= 0),
    "clingo_truth_value_free,clingo_truth_value_true,clingo_truth_value_false" },
  { "clingo_warning_e", 1310, _cffi_prim_int(sizeof(enum clingo_warning_e), ((enum clingo_warning_e)-1) <= 0),
    "clingo_warning_operation_undefined,clingo_warning_runtime_error,clingo_warning_atom_undefined,clingo_warning_file_included,clingo_warning_variable_unbounded,clingo_warning_global_variable,clingo_warning_other" },
  { "clingo_weight_constraint_type_e", 1311, _cffi_prim_int(sizeof(enum clingo_weight_constraint_type_e), ((enum clingo_weight_constraint_type_e)-1) <= 0),
    "clingo_weight_constraint_type_implication_left,clingo_weight_constraint_type_implication_right,clingo_weight_constraint_type_equivalence" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "clingo_application_t", 1251 },
  { "clingo_assignment_t", 1252 },
  { "clingo_ast_aggregate_function_t", 155 },
  { "clingo_ast_argument_t", 1254 },
  { "clingo_ast_attribute_names_t", 1255 },
  { "clingo_ast_attribute_t", 155 },
  { "clingo_ast_attribute_type_t", 155 },
  { "clingo_ast_binary_operator_t", 155 },
  { "clingo_ast_callback_t", 24 },
  { "clingo_ast_comparison_operator_t", 155 },
  { "clingo_ast_constructor_t", 1257 },
  { "clingo_ast_constructors_t", 1258 },
  { "clingo_ast_sign_t", 155 },
  { "clingo_ast_t", 1259 },
  { "clingo_ast_theory_atom_definition_type_t", 155 },
  { "clingo_ast_theory_operator_type_t", 155 },
  { "clingo_ast_theory_sequence_type_t", 155 },
  { "clingo_ast_type_t", 155 },
  { "clingo_ast_unary_operator_t", 155 },
  { "clingo_ast_unpool_type_bitset_t", 155 },
  { "clingo_atom_t", 69 },
  { "clingo_backend_t", 1260 },
  { "clingo_clause_type_t", 155 },
  { "clingo_comment_type_t", 155 },
  { "clingo_configuration_t", 1261 },
  { "clingo_configuration_type_bitset_t", 29 },
  { "clingo_consequence_t", 155 },
  { "clingo_control_t", 1262 },
  { "clingo_default_model_printer_t", 590 },
  { "clingo_error_t", 155 },
  { "clingo_external_type_t", 155 },
  { "clingo_ground_callback_t", 478 },
  { "clingo_ground_program_observer_t", 1263 },
  { "clingo_heuristic_type_t", 155 },
  { "clingo_id_t", 69 },
  { "clingo_literal_t", 12 },
  { "clingo_location_t", 1264 },
  { "clingo_logger_t", 27 },
  { "clingo_main_function_t", 1220 },
  { "clingo_model_printer_t", 1226 },
  { "clingo_model_t", 1265 },
  { "clingo_model_type_t", 155 },
  { "clingo_options_t", 1266 },
  { "clingo_part_t", 1267 },
  { "clingo_program_builder_t", 1268 },
  { "clingo_propagate_control_t", 1269 },
  { "clingo_propagate_init_t", 1270 },
  { "clingo_propagator_check_callback_t", 1229 },
  { "clingo_propagator_check_mode_t", 155 },
  { "clingo_propagator_init_callback_t", 1230 },
  { "clingo_propagator_propagate_callback_t", 1228 },
  { "clingo_propagator_t", 1271 },
  { "clingo_propagator_undo_callback_t", 1314 },
  { "clingo_propagator_undo_mode_t", 155 },
  { "clingo_script_t", 1272 },
  { "clingo_show_type_bitset_t", 29 },
  { "clingo_signature_t", 246 },
  { "clingo_solve_control_t", 1273 },
  { "clingo_solve_event_callback_t", 505 },
  { "clingo_solve_event_type_t", 29 },
  { "clingo_solve_handle_t", 1274 },
  { "clingo_solve_mode_bitset_t", 29 },
  { "clingo_solve_result_bitset_t", 29 },
  { "clingo_statistics_t", 1275 },
  { "clingo_statistics_type_t", 155 },
  { "clingo_symbol_callback_t", 561 },
  { "clingo_symbol_t", 246 },
  { "clingo_symbol_type_t", 155 },
  { "clingo_symbolic_atom_iterator_t", 246 },
  { "clingo_symbolic_atoms_t", 1276 },
  { "clingo_theory_atoms_t", 1277 },
  { "clingo_theory_sequence_type_t", 155 },
  { "clingo_theory_term_type_t", 155 },
  { "clingo_truth_value_t", 155 },
  { "clingo_warning_t", 155 },
  { "clingo_weight_constraint_type_t", 155 },
  { "clingo_weight_t", 12 },
  { "clingo_weighted_literal_t", 1278 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  517,  /* num_globals */
  26,  /* num_struct_unions */
  33,  /* num_enums */
  78,  /* num_typenames */
  NULL,  /* no includes */
  1317,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__clingo(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2701;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__clingo(void) { return NULL; }
#  else
     init_clingo(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__clingo(void)
{
  return _cffi_init("_clingo", 0x2701, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_clingo(void)
{
  _cffi_init("_clingo", 0x2701, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
