
//              Copyright Catch2 Authors
// Distributed under the Boost Software License, Version 1.0.
//   (See accompanying file LICENSE.txt or copy at
//        https://www.boost.org/LICENSE_1_0.txt)

// SPDX-License-Identifier: BSL-1.0
#ifndef CATCH_VERSION_HPP_INCLUDED
#define CATCH_VERSION_HPP_INCLUDED

#include <iosfwd>

namespace Catch {

    // Versioning information
    struct Version {
        Version( Version const& ) = delete;
        Version& operator=( Version const& ) = delete;
        Version( unsigned int _majorVersion,
                 unsigned int _minorVersion,
                 unsigned int _patchNumber,
                 char const* const _branchName,
                 unsigned int _buildNumber );

        unsigned int const majorVersion;
        unsigned int const minorVersion;
        unsigned int const patchNumber;

        // buildNumber is only used if branchName is not null
        char const* const branchName;
        unsigned int const buildNumber;

        friend std::ostream& operator<<( std::ostream& os,
                                         Version const& version );
    };

    Version const& libraryVersion();
} // namespace Catch

#endif // CATCH_VERSION_HPP_INCLUDED
