# t20056 - Test case for option to fold repeated activities in sequence diagram
## Config
```yaml
diagrams:
  t20056_sequence:
    type: sequence
    glob:
      - t20056.cc
    include:
      namespaces:
        - clanguml::t20056
    using_namespace: clanguml::t20056
    fold_repeated_activities: true
    from:
      - function: "clanguml::t20056::tmain()"
```
## Source code
File `tests/t20056/t20056.cc`
```cpp
namespace clanguml {
namespace t20056 {
struct A {
    void a() { aa(); }

    void aa() { aaa(); }

    void aaa() { }
};

struct B {
    void b() { bb(); }

    void bb() { bbb(); }

    void bbb() { a.a(); }

    A a;
};

struct C {
    void c() { cc(); }

    void cc() { ccc(); }

    void ccc() { b.b(); }

    B b;
};

void tmain()
{
    A a;
    B b;
    C c;

    c.c();
    c.c();
    c.c();

    b.b();

    a.a();
}
}
}

```
## Generated PlantUML diagrams
![t20056_sequence](./t20056_sequence.svg "Test case for option to fold repeated activities in sequence diagram")
## Generated Mermaid diagrams
![t20056_sequence](./t20056_sequence_mermaid.svg "Test case for option to fold repeated activities in sequence diagram")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20056_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20056::tmain()",
      "id": "2076165359099292738",
      "name": "tmain",
      "namespace": "clanguml::t20056",
      "source_location": {
        "column": 6,
        "file": "t20056.cc",
        "line": 31,
        "translation_unit": "t20056.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "c()",
          "full_name": "clanguml::t20056::C::c()",
          "id": "9827683707240063875",
          "name": "c",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 22,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        },
        {
          "display_name": "cc()",
          "full_name": "clanguml::t20056::C::cc()",
          "id": "10757735052763438248",
          "name": "cc",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 24,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        },
        {
          "display_name": "ccc()",
          "full_name": "clanguml::t20056::C::ccc()",
          "id": "17860716698711511346",
          "name": "ccc",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 26,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20056::C",
      "id": "17807733644702065776",
      "name": "C",
      "namespace": "clanguml::t20056",
      "source_location": {
        "column": 8,
        "file": "t20056.cc",
        "line": 21,
        "translation_unit": "t20056.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b()",
          "full_name": "clanguml::t20056::B::b()",
          "id": "13110518192093956201",
          "name": "b",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 12,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb()",
          "full_name": "clanguml::t20056::B::bb()",
          "id": "15243451810628291284",
          "name": "bb",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 14,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bbb()",
          "full_name": "clanguml::t20056::B::bbb()",
          "id": "9447637815048213237",
          "name": "bbb",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 16,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20056::B",
      "id": "12574807824801132217",
      "name": "B",
      "namespace": "clanguml::t20056",
      "source_location": {
        "column": 8,
        "file": "t20056.cc",
        "line": 11,
        "translation_unit": "t20056.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a()",
          "full_name": "clanguml::t20056::A::a()",
          "id": "17417341931922055684",
          "name": "a",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 4,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aa()",
          "full_name": "clanguml::t20056::A::aa()",
          "id": "77475598224529424",
          "name": "aa",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 6,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aaa()",
          "full_name": "clanguml::t20056::A::aaa()",
          "id": "10740720327399797085",
          "name": "aaa",
          "namespace": "clanguml::t20056",
          "source_location": {
            "column": 10,
            "file": "t20056.cc",
            "line": 8,
            "translation_unit": "t20056.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20056::A",
      "id": "12866264680476163430",
      "name": "A",
      "namespace": "clanguml::t20056",
      "source_location": {
        "column": 8,
        "file": "t20056.cc",
        "line": 3,
        "translation_unit": "t20056.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "2076165359099292738",
        "location": "clanguml::t20056::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "2076165359099292738",
            "participant_id": "2076165359099292738"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20056.cc",
            "line": 37,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9827683707240063875",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9827683707240063875",
            "participant_id": "17807733644702065776"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 22,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10757735052763438248",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10757735052763438248",
            "participant_id": "17807733644702065776"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 24,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17860716698711511346",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17860716698711511346",
            "participant_id": "17807733644702065776"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 26,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 12,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 14,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 16,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 4,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 6,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10740720327399797085",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2076165359099292738",
            "participant_id": "2076165359099292738"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20056.cc",
            "line": 38,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9827683707240063875",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9827683707240063875",
            "participant_id": "17807733644702065776"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 22,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10757735052763438248",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10757735052763438248",
            "participant_id": "17807733644702065776"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 24,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17860716698711511346",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17860716698711511346",
            "participant_id": "17807733644702065776"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 26,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 12,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 14,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 16,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 4,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 6,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10740720327399797085",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2076165359099292738",
            "participant_id": "2076165359099292738"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20056.cc",
            "line": 39,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9827683707240063875",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9827683707240063875",
            "participant_id": "17807733644702065776"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 22,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10757735052763438248",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10757735052763438248",
            "participant_id": "17807733644702065776"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 24,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17860716698711511346",
            "participant_id": "17807733644702065776"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17860716698711511346",
            "participant_id": "17807733644702065776"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 26,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 12,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 14,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 16,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 4,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 6,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10740720327399797085",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2076165359099292738",
            "participant_id": "2076165359099292738"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20056.cc",
            "line": 41,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13110518192093956201",
            "participant_id": "12574807824801132217"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 12,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15243451810628291284",
            "participant_id": "12574807824801132217"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 14,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9447637815048213237",
            "participant_id": "12574807824801132217"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20056.cc",
            "line": 16,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 4,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 6,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10740720327399797085",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2076165359099292738",
            "participant_id": "2076165359099292738"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20056.cc",
            "line": 43,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17417341931922055684",
            "participant_id": "12866264680476163430"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20056.cc",
            "line": 4,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "77475598224529424",
            "participant_id": "12866264680476163430"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20056.cc",
            "line": 6,
            "translation_unit": "t20056.cc"
          },
          "to": {
            "activity_id": "10740720327399797085",
            "participant_id": "12866264680476163430"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20056"
}
```
## Generated GraphML models
