# t20053 - Test case for inlining nested lambda operator calls
## Config
```yaml
diagrams:
  t20053_sequence:
    type: sequence
    glob:
      - t20053.cc
    include:
      namespaces:
        - clanguml::t20053
    using_namespace: clanguml::t20053
    inline_lambda_messages: true
    generate_return_values: true
    from:
      - function: "clanguml::t20053::tmain()"
```
## Source code
File `tests/t20053/t20053.cc`
```cpp
namespace clanguml {
namespace t20053 {

template <typename F> int a1(F &&f) { return f(42); }

int a2(int x) { return 2; }

int a3(int x) { return 3; }

int a4(int x)
{
    return []() { return 5; }();
}

int tmain()
{
    // Call expression in a nested lambda
    auto v1 = [](auto &&arg1) {
        return [](auto &&arg2) { return a2(arg2); }(arg1);
    }(0);

    // Nested lambda call without any actual calls
    auto v2 = [](auto &&arg1) {
        return [](auto &&arg2) { return arg2 + 2; }(arg1);
    }(0);

    // Call expression in a nested lambda in call expression
    // TODO: Fix double call to a3()
    auto v4 = a1(
        [](auto &&arg1) { return [](auto &&arg2) { return a3(arg2); }(arg1); });

    // Call to function returning value evaluated from a lambda expression
    auto v5 = a4(5);

    return 0;
}
}
}
```
## Generated PlantUML diagrams
![t20053_sequence](./t20053_sequence.svg "Test case for inlining nested lambda operator calls")
## Generated Mermaid diagrams
![t20053_sequence](./t20053_sequence_mermaid.svg "Test case for inlining nested lambda operator calls")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20053_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20053::tmain()",
      "id": "15912078192340203929",
      "name": "tmain",
      "namespace": "clanguml::t20053",
      "source_location": {
        "column": 5,
        "file": "t20053.cc",
        "line": 15,
        "translation_unit": "t20053.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a2(int)",
      "full_name": "clanguml::t20053::a2(int)",
      "id": "5360957122025856535",
      "name": "a2",
      "namespace": "clanguml::t20053",
      "source_location": {
        "column": 5,
        "file": "t20053.cc",
        "line": 6,
        "translation_unit": "t20053.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a1<(lambda at t20053.cc:30:9)>((lambda at t20053.cc:30:9) &&)",
      "full_name": "clanguml::t20053::a1<(lambda at t20053.cc:30:9)>((lambda at t20053.cc:30:9) &&)",
      "id": "766765913955969043",
      "name": "a1",
      "namespace": "clanguml::t20053",
      "source_location": {
        "column": 27,
        "file": "t20053.cc",
        "line": 4,
        "translation_unit": "t20053.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "a3(int)",
      "full_name": "clanguml::t20053::a3(int)",
      "id": "12693661768937063443",
      "name": "a3",
      "namespace": "clanguml::t20053",
      "source_location": {
        "column": 5,
        "file": "t20053.cc",
        "line": 8,
        "translation_unit": "t20053.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a4(int)",
      "full_name": "clanguml::t20053::a4(int)",
      "id": "17658490555548670515",
      "name": "a4",
      "namespace": "clanguml::t20053",
      "source_location": {
        "column": 5,
        "file": "t20053.cc",
        "line": 10,
        "translation_unit": "t20053.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "15912078192340203929",
        "location": "clanguml::t20053::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 41,
            "file": "t20053.cc",
            "line": 19,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "5360957122025856535",
            "participant_id": "5360957122025856535"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5360957122025856535",
            "participant_id": "5360957122025856535"
          },
          "name": "2",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20053.cc",
            "line": 6,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20053.cc",
            "line": 29,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "766765913955969043",
            "participant_id": "766765913955969043"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "766765913955969043",
            "participant_id": "766765913955969043"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 59,
            "file": "t20053.cc",
            "line": 30,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "12693661768937063443",
            "participant_id": "12693661768937063443"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "12693661768937063443",
            "participant_id": "12693661768937063443"
          },
          "name": "3",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20053.cc",
            "line": 8,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "766765913955969043",
            "participant_id": "766765913955969043"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "766765913955969043",
            "participant_id": "766765913955969043"
          },
          "name": "f(42)",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 39,
            "file": "t20053.cc",
            "line": 4,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 59,
            "file": "t20053.cc",
            "line": 30,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "12693661768937063443",
            "participant_id": "12693661768937063443"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "12693661768937063443",
            "participant_id": "12693661768937063443"
          },
          "name": "3",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20053.cc",
            "line": 8,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20053.cc",
            "line": 33,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "17658490555548670515",
            "participant_id": "17658490555548670515"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17658490555548670515",
            "participant_id": "17658490555548670515"
          },
          "name": "[]() { return 5; }()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20053.cc",
            "line": 12,
            "translation_unit": "t20053.cc"
          },
          "to": {
            "activity_id": "15912078192340203929",
            "participant_id": "15912078192340203929"
          },
          "type": "return"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20053"
}
```
## Generated GraphML models
