# t20015 - Class exclusion by namespace in sequence diagram test case
## Config
```yaml
diagrams:
  t20015_sequence:
    type: sequence
    glob:
      - t20015.cc
    include:
      namespaces:
        - clanguml::t20015
    exclude:
      namespaces:
        - clanguml::t20015::detail
    using_namespace: clanguml::t20015
    from:
      - function: "clanguml::t20015::tmain()"
```
## Source code
File `tests/t20015/t20015.cc`
```cpp
#include <memory>
#include <optional>

namespace clanguml {
namespace t20015 {

namespace detail {
class A {
public:
    void set_x(int x) { x_ = x; }
    void set_y(int y) { y_ = y; }
    void set_z(int z) { z_ = z; }

private:
    int x_;
    int y_;
    int z_;
};
}

class B {
public:
    void setup_a(std::shared_ptr<detail::A> &a)
    {
        a->set_x(1);
        a.get()->set_y(2);
        (*a).set_z(3);
    }
};

void tmain()
{
    auto a = std::make_shared<detail::A>();

    B b;

    b.setup_a(a);
}
}
}
```
## Generated PlantUML diagrams
![t20015_sequence](./t20015_sequence.svg "Class exclusion by namespace in sequence diagram test case")
## Generated Mermaid diagrams
![t20015_sequence](./t20015_sequence_mermaid.svg "Class exclusion by namespace in sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20015_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20015::tmain()",
      "id": "8091972414976663567",
      "name": "tmain",
      "namespace": "clanguml::t20015",
      "source_location": {
        "column": 6,
        "file": "t20015.cc",
        "line": 31,
        "translation_unit": "t20015.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "setup_a(std::shared_ptr<detail::A> &)",
          "full_name": "clanguml::t20015::B::setup_a(std::shared_ptr<detail::A> &)",
          "id": "3452606179190376485",
          "name": "setup_a",
          "namespace": "clanguml::t20015",
          "source_location": {
            "column": 10,
            "file": "t20015.cc",
            "line": 23,
            "translation_unit": "t20015.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20015::B",
      "id": "10421253414266869167",
      "name": "B",
      "namespace": "clanguml::t20015",
      "source_location": {
        "column": 7,
        "file": "t20015.cc",
        "line": 21,
        "translation_unit": "t20015.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "8091972414976663567",
        "location": "clanguml::t20015::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "8091972414976663567",
            "participant_id": "8091972414976663567"
          },
          "name": "setup_a(std::shared_ptr<detail::A> &)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20015.cc",
            "line": 37,
            "translation_unit": "t20015.cc"
          },
          "to": {
            "activity_id": "3452606179190376485",
            "participant_id": "10421253414266869167"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20015"
}
```
## Generated GraphML models
