# t20003 - Function template sequence diagram test case
## Config
```yaml
diagrams:
  t20003_sequence:
    type: sequence
    glob:
      - t20003.cc
    include:
      namespaces:
        - clanguml::t20003
    using_namespace: clanguml::t20003
    from:
      - function: "clanguml::t20003::m1<T>(T)"

```
## Source code
File `tests/t20003/t20003.cc`
```cpp
namespace clanguml {
namespace t20003 {

template <typename T> void m4(T p) { }

template <typename T> void m3(T p) { m4<T>(p); }

template <typename T> void m2(T p) { m3<T>(p); }

template <typename T> void m1(T p) { m2<T>(p); }
}
}

```
## Generated PlantUML diagrams
![t20003_sequence](./t20003_sequence.svg "Function template sequence diagram test case")
## Generated Mermaid diagrams
![t20003_sequence](./t20003_sequence_mermaid.svg "Function template sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20003_sequence",
  "participants": [
    {
      "display_name": "m1<T>(T)",
      "full_name": "clanguml::t20003::m1<T>(T)",
      "id": "3753645926393926952",
      "name": "m1",
      "namespace": "clanguml::t20003",
      "source_location": {
        "column": 28,
        "file": "t20003.cc",
        "line": 10,
        "translation_unit": "t20003.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "m2<T>(T)",
      "full_name": "clanguml::t20003::m2<T>(T)",
      "id": "12023659594936323905",
      "name": "m2",
      "namespace": "clanguml::t20003",
      "source_location": {
        "column": 28,
        "file": "t20003.cc",
        "line": 8,
        "translation_unit": "t20003.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "m3<T>(T)",
      "full_name": "clanguml::t20003::m3<T>(T)",
      "id": "4907821458508060685",
      "name": "m3",
      "namespace": "clanguml::t20003",
      "source_location": {
        "column": 28,
        "file": "t20003.cc",
        "line": 6,
        "translation_unit": "t20003.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "m4<T>(T)",
      "full_name": "clanguml::t20003::m4<T>(T)",
      "id": "4959680188868063405",
      "name": "m4",
      "namespace": "clanguml::t20003",
      "source_location": {
        "column": 28,
        "file": "t20003.cc",
        "line": 4,
        "translation_unit": "t20003.cc"
      },
      "type": "function_template"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "3753645926393926952",
        "location": "clanguml::t20003::m1<T>(T)"
      },
      "messages": [
        {
          "from": {
            "activity_id": "3753645926393926952",
            "participant_id": "3753645926393926952"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 38,
            "file": "t20003.cc",
            "line": 10,
            "translation_unit": "t20003.cc"
          },
          "to": {
            "activity_id": "12023659594936323905",
            "participant_id": "12023659594936323905"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "12023659594936323905",
            "participant_id": "12023659594936323905"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 38,
            "file": "t20003.cc",
            "line": 8,
            "translation_unit": "t20003.cc"
          },
          "to": {
            "activity_id": "4907821458508060685",
            "participant_id": "4907821458508060685"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "4907821458508060685",
            "participant_id": "4907821458508060685"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 38,
            "file": "t20003.cc",
            "line": 6,
            "translation_unit": "t20003.cc"
          },
          "to": {
            "activity_id": "4959680188868063405",
            "participant_id": "4959680188868063405"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20003"
}
```
## Generated GraphML models
