# t00080 - Test case for including elements from system headers
## Config
```yaml
diagrams:
  t00080_class:
    type: class
    filter_mode: advanced
    comment_parser: clang
    include_system_headers: true
    glob:
      - t00080.cc
    include:
      anyof:
        namespaces:
          - clanguml::t00080
        elements:
          - std::thread
    using_namespace: clanguml::t00080
    plantuml:
      after:
        - >
          note right of {{ element("std::thread").alias }}
             {% set e=element("std::thread") %} Name in root namespace
          end note
        - >
          note bottom of {{ element("clanguml::t00080::Worker").alias }}
             {% set e=element("clanguml::t00080::Worker") %} Name relative to '{{ e.using_namespace }}'
          end note
```
## Source code
File `tests/t00080/t00080.cc`
```cpp
#include <thread>

namespace clanguml {
namespace t00080 {

class Worker : public std::thread {
public:
    using std::thread::thread;

    ~Worker()
    {
        if (this->joinable()) {
            this->join();
        }
    }

    void start(int delay) { }
};

struct R {
    Worker *w;
};
}
}
```
## Generated PlantUML diagrams
![t00080_class](./t00080_class.svg "Test case for including elements from system headers")
## Generated Mermaid diagrams
![t00080_class](./t00080_class_mermaid.svg "Test case for including elements from system headers")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "::std::thread",
      "id": "15292512913378933439",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "_M_id",
          "source_location": {
            "column": 11,
            "file": "",
            "line": 132,
            "translation_unit": "t00080.cc"
          },
          "type": "id"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "thread",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": true,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "thread",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 141,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "private",
          "display_name": "_M_thread_deps_never_run",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": true,
          "is_virtual": false,
          "name": "_M_thread_deps_never_run",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 152,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "~thread",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "~thread",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 179,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "thread",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": true,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "thread",
          "parameters": [
            {
              "name": "",
              "type": "const thread &"
            }
          ],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 185,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "thread",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": true,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "thread",
          "parameters": [
            {
              "name": "__t",
              "type": "thread &&"
            }
          ],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 187,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "operator=",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": true,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": true,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator=",
          "parameters": [
            {
              "name": "",
              "type": "const thread &"
            }
          ],
          "source_location": {
            "column": 13,
            "file": "",
            "line": 190,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "thread &"
        },
        {
          "access": "public",
          "display_name": "operator=",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": true,
          "is_noexcept": true,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator=",
          "parameters": [
            {
              "name": "__t",
              "type": "thread &&"
            }
          ],
          "source_location": {
            "column": 13,
            "file": "",
            "line": 192,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "thread &"
        },
        {
          "access": "public",
          "display_name": "swap",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": true,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "swap",
          "parameters": [
            {
              "name": "__t",
              "type": "thread &"
            }
          ],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 201,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "joinable",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": true,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "joinable",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 205,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "bool"
        },
        {
          "access": "public",
          "display_name": "join",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "join",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 209,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "detach",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "detach",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 212,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "get_id",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": true,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_id",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 215,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "id"
        },
        {
          "access": "public",
          "display_name": "native_handle",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "native_handle",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 221,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "native_handle_type"
        },
        {
          "access": "public",
          "display_name": "hardware_concurrency",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": true,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": true,
          "is_virtual": false,
          "name": "hardware_concurrency",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 226,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "unsigned int"
        },
        {
          "access": "private",
          "display_name": "_M_start_thread",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "_M_start_thread",
          "parameters": [
            {
              "name": "",
              "type": "_State_ptr"
            },
            {
              "name": "",
              "type": "void (*)()"
            }
          ],
          "source_location": {
            "column": 5,
            "file": "",
            "line": 257,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "thread<_Callable,_Args...,typename=_Require<__not_same<_Callable>>>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "thread",
          "parameters": [
            {
              "name": "__f",
              "type": "_Callable &&"
            },
            {
              "name": "__args",
              "type": "_Args &&..."
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "_Callable",
              "template_parameters": []
            },
            {
              "is_variadic": true,
              "kind": "template_type",
              "name": "_Args...",
              "template_parameters": []
            },
            {
              "default": "_Require<__not_same<_Callable>>",
              "is_variadic": false,
              "kind": "template_type",
              "name": "typename",
              "template_parameters": []
            }
          ],
          "type": "void"
        }
      ],
      "name": "thread",
      "namespace": "std",
      "source_location": {
        "column": 9,
        "file": "",
        "line": 82,
        "translation_unit": "t00080.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "15292512913378933439",
          "is_virtual": false
        }
      ],
      "display_name": "Worker",
      "id": "9784607930441346007",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "~Worker",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "~Worker",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "t00080.cc",
            "line": 10,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "start",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "start",
          "parameters": [
            {
              "name": "delay",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00080.cc",
            "line": 17,
            "translation_unit": "t00080.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Worker",
      "namespace": "clanguml::t00080",
      "source_location": {
        "column": 7,
        "file": "t00080.cc",
        "line": 6,
        "translation_unit": "t00080.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "12172460947490041262",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "w",
          "source_location": {
            "column": 13,
            "file": "t00080.cc",
            "line": 21,
            "translation_unit": "t00080.cc"
          },
          "type": "Worker *"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00080",
      "source_location": {
        "column": 8,
        "file": "t00080.cc",
        "line": 20,
        "translation_unit": "t00080.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00080_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "15292512913378933439",
      "source": "9784607930441346007",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "9784607930441346007",
      "label": "w",
      "source": "12172460947490041262",
      "type": "association"
    }
  ],
  "using_namespace": "clanguml::t00080"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00080</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[::std::thread]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Worker]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n1">
   <data key="ed0">association</data>
   <data key="ed2">w</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
