# t00048 - Test case for unique entity id with multiple translation units
## Config
```yaml
diagrams:
  t00048_class:
    type: class
    glob:
      - b_t00048.cc
      - a_t00048.cc
      - t00048.cc
    using_namespace: clanguml::t00048
    include:
      namespaces:
        - clanguml::t00048
```
## Source code
File `tests/t00048/b_t00048.h`
```cpp
#include "t00048.h"

#pragma once

namespace clanguml {
namespace t00048 {

struct B : public Base {
    int b;

    void foo() override;
};

template <typename T> struct BTemplate : public BaseTemplate<T> {
    T b;

    void foo() override { }
};

}
}
```
File `tests/t00048/b_t00048.cc`
```cpp
#include "b_t00048.h"

namespace clanguml {
namespace t00048 {

void B::foo() { }

}
}
```
File `tests/t00048/t00048.cc`
```cpp
#include "t00048.h"

namespace clanguml {
namespace t00048 {
}
}
```
File `tests/t00048/a_t00048.h`
```cpp
#include "t00048.h"

#pragma once

namespace clanguml {
namespace t00048 {

struct A : public Base {
    int a;

    void foo() override;
};

template <typename T> struct ATemplate : public BaseTemplate<T> {
    T a;

    void foo() override { }
};

}
}
```
File `tests/t00048/a_t00048.cc`
```cpp
#include "a_t00048.h"

namespace clanguml {
namespace t00048 {

void A::foo() { }

}
}
```
File `tests/t00048/t00048.h`
```cpp
#pragma once

namespace clanguml {
namespace t00048 {

struct Base {
    int base;

    virtual void foo() = 0;
};

template <typename T> struct BaseTemplate {
    T base;

    virtual void foo() = 0;
};

}
}
```
## Generated PlantUML diagrams
![t00048_class](./t00048_class.svg "Test case for unique entity id with multiple translation units")
## Generated Mermaid diagrams
![t00048_class](./t00048_class_mermaid.svg "Test case for unique entity id with multiple translation units")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Base",
      "id": "81605015192105870",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "base",
          "source_location": {
            "column": 9,
            "file": "t00048.h",
            "line": 7,
            "translation_unit": "b_t00048.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00048.h",
            "line": 9,
            "translation_unit": "b_t00048.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Base",
      "namespace": "clanguml::t00048",
      "source_location": {
        "column": 8,
        "file": "t00048.h",
        "line": 6,
        "translation_unit": "b_t00048.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "BaseTemplate<T>",
      "id": "5041582180348556290",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "base",
          "source_location": {
            "column": 7,
            "file": "t00048.h",
            "line": 13,
            "translation_unit": "b_t00048.cc"
          },
          "type": "T"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00048.h",
            "line": 15,
            "translation_unit": "b_t00048.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "BaseTemplate",
      "namespace": "clanguml::t00048",
      "source_location": {
        "column": 30,
        "file": "t00048.h",
        "line": 12,
        "translation_unit": "b_t00048.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "81605015192105870",
          "is_virtual": false
        }
      ],
      "display_name": "B",
      "id": "474688398071937524",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 9,
            "file": "b_t00048.h",
            "line": 9,
            "translation_unit": "b_t00048.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "b_t00048.h",
            "line": 11,
            "translation_unit": "b_t00048.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "B",
      "namespace": "clanguml::t00048",
      "source_location": {
        "column": 8,
        "file": "b_t00048.h",
        "line": 8,
        "translation_unit": "b_t00048.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "5041582180348556290",
          "is_virtual": false
        }
      ],
      "display_name": "BTemplate<T>",
      "id": "13086805194781882442",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 7,
            "file": "b_t00048.h",
            "line": 15,
            "translation_unit": "b_t00048.cc"
          },
          "type": "T"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "b_t00048.h",
            "line": 17,
            "translation_unit": "b_t00048.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "BTemplate",
      "namespace": "clanguml::t00048",
      "source_location": {
        "column": 30,
        "file": "b_t00048.h",
        "line": 14,
        "translation_unit": "b_t00048.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "81605015192105870",
          "is_virtual": false
        }
      ],
      "display_name": "A",
      "id": "1594669534673689790",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 9,
            "file": "a_t00048.h",
            "line": 9,
            "translation_unit": "a_t00048.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "a_t00048.h",
            "line": 11,
            "translation_unit": "a_t00048.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00048",
      "source_location": {
        "column": 8,
        "file": "a_t00048.h",
        "line": 8,
        "translation_unit": "a_t00048.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "5041582180348556290",
          "is_virtual": false
        }
      ],
      "display_name": "ATemplate<T>",
      "id": "8205576867235711242",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "a_t00048.h",
            "line": 15,
            "translation_unit": "a_t00048.cc"
          },
          "type": "T"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "a_t00048.h",
            "line": 17,
            "translation_unit": "a_t00048.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "ATemplate",
      "namespace": "clanguml::t00048",
      "source_location": {
        "column": 30,
        "file": "a_t00048.h",
        "line": 14,
        "translation_unit": "a_t00048.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00048_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "81605015192105870",
      "source": "474688398071937524",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "5041582180348556290",
      "source": "13086805194781882442",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "81605015192105870",
      "source": "1594669534673689790",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "5041582180348556290",
      "source": "8205576867235711242",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00048"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00048</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Base]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[BaseTemplate<T>]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">true</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[BTemplate<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ATemplate<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <edge id="e0" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n3" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n4" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
