# t00027 - Template decorator pattern
## Config
```yaml
diagrams:
  t00027_class:
    type: class
    glob:
      - t00027.cc
    using_namespace: clanguml::t00027
    include:
      namespaces:
        - clanguml::t00027

```
## Source code
File `tests/t00027/t00027.cc`
```cpp
#include <memory>
#include <tuple>
#include <type_traits>

namespace clanguml {
namespace t00027 {

class Shape {
public:
    virtual void display() = 0;
    virtual ~Shape() = default;
};

template <template <typename> class... T>
class Line : public Shape, public T<Line<>>... {
public:
    void display() override
    {
        std::apply([](auto &&...x) { (x.display(), ...); },
            std::forward_as_tuple(T<Line<>>()...));
    }
};

template <template <typename> class... T>
class Text : public Shape, public T<Text<>>... {
public:
    void display() override
    {
        std::apply([](auto &&...x) { (x.display(), ...); },
            std::forward_as_tuple(T<Text<>>()...));
    }
};

struct ShapeDecorator {
    virtual void display() = 0;
};

template <typename T> class Color : public ShapeDecorator {
public:
    void display() override { }
};

template <typename T> class Weight : public ShapeDecorator {
public:
    void display() override { }
};

struct Window {
    Line<Color, Weight> border;
    Line<Color> divider;
    Text<Color, Weight> title;
    Text<Color> description;
};
} // namespace t00027
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00027_class](./t00027_class.svg "Template decorator pattern")
## Generated Mermaid diagrams
![t00027_class](./t00027_class_mermaid.svg "Template decorator pattern")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Shape",
      "id": "12744739871674657768",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "display",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "display",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00027.cc",
            "line": 10,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "~Shape",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "~Shape",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00027.cc",
            "line": 11,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Shape",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 7,
        "file": "t00027.cc",
        "line": 8,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Line",
      "id": "12551463032492497828",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Line",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 7,
        "file": "t00027.cc",
        "line": 15,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "12744739871674657768",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "17476872655978593693",
          "is_virtual": false
        }
      ],
      "display_name": "Line<T<>...>",
      "id": "1138992659826702823",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "display",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "display",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00027.cc",
            "line": 17,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Line",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 7,
        "file": "t00027.cc",
        "line": 15,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": true,
          "kind": "template_template_type",
          "name": "T<>...",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Text",
      "id": "14667739730330357797",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Text",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 7,
        "file": "t00027.cc",
        "line": 25,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "12744739871674657768",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "17980070619704453980",
          "is_virtual": false
        }
      ],
      "display_name": "Text<T<>...>",
      "id": "8917077181775028830",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "display",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "display",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00027.cc",
            "line": 27,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Text",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 7,
        "file": "t00027.cc",
        "line": 25,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": true,
          "kind": "template_template_type",
          "name": "T<>...",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ShapeDecorator",
      "id": "16393510605649316529",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "display",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "display",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00027.cc",
            "line": 35,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "ShapeDecorator",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 8,
        "file": "t00027.cc",
        "line": 34,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "16393510605649316529",
          "is_virtual": false
        }
      ],
      "display_name": "Color<T>",
      "id": "11788292555464235555",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "display",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "display",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00027.cc",
            "line": 40,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Color",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 29,
        "file": "t00027.cc",
        "line": 38,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "16393510605649316529",
          "is_virtual": false
        }
      ],
      "display_name": "Weight<T>",
      "id": "16395644259100490706",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "display",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "display",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00027.cc",
            "line": 45,
            "translation_unit": "t00027.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Weight",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 29,
        "file": "t00027.cc",
        "line": 43,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Line<Color,Weight>",
      "id": "16663490611337313620",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Line",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 25,
        "file": "t00027.cc",
        "line": 49,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "clanguml::t00027::Color",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "clanguml::t00027::Weight",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Line<Color>",
      "id": "5401063548280439576",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Line",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 17,
        "file": "t00027.cc",
        "line": 50,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "clanguml::t00027::Color",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Text<Color,Weight>",
      "id": "13430994421154430212",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Text",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 25,
        "file": "t00027.cc",
        "line": 51,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "clanguml::t00027::Color",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "clanguml::t00027::Weight",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Text<Color>",
      "id": "15102293510229313461",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Text",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 17,
        "file": "t00027.cc",
        "line": 52,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "clanguml::t00027::Color",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Window",
      "id": "10988359872221771779",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "border",
          "source_location": {
            "column": 25,
            "file": "t00027.cc",
            "line": 49,
            "translation_unit": "t00027.cc"
          },
          "type": "Line<Color,Weight>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "divider",
          "source_location": {
            "column": 17,
            "file": "t00027.cc",
            "line": 50,
            "translation_unit": "t00027.cc"
          },
          "type": "Line<Color>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "title",
          "source_location": {
            "column": 25,
            "file": "t00027.cc",
            "line": 51,
            "translation_unit": "t00027.cc"
          },
          "type": "Text<Color,Weight>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "description",
          "source_location": {
            "column": 17,
            "file": "t00027.cc",
            "line": 52,
            "translation_unit": "t00027.cc"
          },
          "type": "Text<Color>"
        }
      ],
      "methods": [],
      "name": "Window",
      "namespace": "clanguml::t00027",
      "source_location": {
        "column": 8,
        "file": "t00027.cc",
        "line": 48,
        "translation_unit": "t00027.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00027_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "1138992659826702823",
      "source": "12551463032492497828",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "12744739871674657768",
      "source": "1138992659826702823",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "8917077181775028830",
      "source": "14667739730330357797",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "12744739871674657768",
      "source": "8917077181775028830",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "16393510605649316529",
      "source": "11788292555464235555",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "16393510605649316529",
      "source": "16395644259100490706",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "1138992659826702823",
      "source": "16663490611337313620",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "1138992659826702823",
      "source": "5401063548280439576",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "8917077181775028830",
      "source": "13430994421154430212",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "8917077181775028830",
      "source": "15102293510229313461",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "16663490611337313620",
      "label": "border",
      "source": "10988359872221771779",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "5401063548280439576",
      "label": "divider",
      "source": "10988359872221771779",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "13430994421154430212",
      "label": "title",
      "source": "10988359872221771779",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "15102293510229313461",
      "label": "description",
      "source": "10988359872221771779",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00027"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00027</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Shape]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Line]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Line<T<>...>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Text]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Text<T<>...>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ShapeDecorator]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Color<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Weight<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Line<Color,Weight>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Line<Color>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Text<Color,Weight>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Text<Color>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Window]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n1" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n3" target="n4">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n4" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n5">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n7" target="n5">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n8" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n9" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n10" target="n4">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n11" target="n4">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n12" target="n8">
   <data key="ed0">aggregation</data>
   <data key="ed2">border</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n12" target="n9">
   <data key="ed0">aggregation</data>
   <data key="ed2">divider</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n12" target="n10">
   <data key="ed0">aggregation</data>
   <data key="ed2">title</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n12" target="n11">
   <data key="ed0">aggregation</data>
   <data key="ed2">description</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
