# t00024 - Proxy pattern
## Config
```yaml
diagrams:
  t00024_class:
    type: class
    glob:
      - t00024.cc
    using_namespace: clanguml::t00024
    include:
      namespaces:
        - clanguml::t00024

```
## Source code
File `tests/t00024/t00024.cc`
```cpp
#include <memory>

namespace clanguml {
namespace t00024 {

class Target {
public:
    virtual ~Target() = 0;

    virtual void m1() = 0;
    virtual void m2() = 0;
};

class Target1 : public Target {
public:
    void m1() override { }
    void m2() override { }
};

class Target2 : public Target {
public:
    void m1() override { }
    void m2() override { }
};

class Proxy : public Target {
public:
    Proxy(std::shared_ptr<Target> target)
        : m_target{std::move(target)}
    {
    }
    void m1() override { m_target->m1(); }
    void m2() override { m_target->m2(); }

private:
    std::shared_ptr<Target> m_target;
};
} // namespace t00024
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00024_class](./t00024_class.svg "Proxy pattern")
## Generated Mermaid diagrams
![t00024_class](./t00024_class_mermaid.svg "Proxy pattern")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Target",
      "id": "8931271679944880159",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "~Target",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "~Target",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00024.cc",
            "line": 8,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00024.cc",
            "line": 10,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00024.cc",
            "line": 11,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Target",
      "namespace": "clanguml::t00024",
      "source_location": {
        "column": 7,
        "file": "t00024.cc",
        "line": 6,
        "translation_unit": "t00024.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "8931271679944880159",
          "is_virtual": false
        }
      ],
      "display_name": "Target1",
      "id": "5356136553214612884",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00024.cc",
            "line": 16,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00024.cc",
            "line": 17,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Target1",
      "namespace": "clanguml::t00024",
      "source_location": {
        "column": 7,
        "file": "t00024.cc",
        "line": 14,
        "translation_unit": "t00024.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "8931271679944880159",
          "is_virtual": false
        }
      ],
      "display_name": "Target2",
      "id": "9684105871253567467",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00024.cc",
            "line": 22,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00024.cc",
            "line": 23,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Target2",
      "namespace": "clanguml::t00024",
      "source_location": {
        "column": 7,
        "file": "t00024.cc",
        "line": 20,
        "translation_unit": "t00024.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "8931271679944880159",
          "is_virtual": false
        }
      ],
      "display_name": "Proxy",
      "id": "4757659213119929724",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "m_target",
          "source_location": {
            "column": 29,
            "file": "t00024.cc",
            "line": 36,
            "translation_unit": "t00024.cc"
          },
          "type": "std::shared_ptr<Target>"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "Proxy",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "Proxy",
          "parameters": [
            {
              "name": "target",
              "type": "std::shared_ptr<Target>"
            }
          ],
          "source_location": {
            "column": 5,
            "file": "t00024.cc",
            "line": 28,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00024.cc",
            "line": 32,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00024.cc",
            "line": 33,
            "translation_unit": "t00024.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Proxy",
      "namespace": "clanguml::t00024",
      "source_location": {
        "column": 7,
        "file": "t00024.cc",
        "line": 26,
        "translation_unit": "t00024.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00024_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "8931271679944880159",
      "source": "5356136553214612884",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "8931271679944880159",
      "source": "9684105871253567467",
      "type": "extension"
    },
    {
      "access": "private",
      "destination": "8931271679944880159",
      "label": "m_target",
      "source": "4757659213119929724",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "8931271679944880159",
      "source": "4757659213119929724",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00024"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00024</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Target]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Target1]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Target2]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Proxy]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n3" target="n0">
   <data key="ed0">association</data>
   <data key="ed2">m_target</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e3" source="n3" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
