;;;; -*- Mode: Lisp -*-
;;;; $Id: a739309aa2c2fd8f12a1a5b70f569242c62e21d9 $
;;;; 
;;;; Copyright (c) 2009 Steve Knight <stkni@gmail.com>
;;;; 
;;;; Permission is hereby granted, free of charge, to any person obtaining
;;;; a copy of this software and associated documentation files (the
;;;; "Software"), to deal in the Software without restriction, including
;;;; without limitation the rights to use, copy, modify, merge, publish,
;;;; distribute, sublicense, and/or sell copies of the Software, and to
;;;; permit persons to whom the Software is furnished to do so, subject to
;;;; the following conditions:
;;;; 
;;;; The above copyright notice and this permission notice shall be
;;;; included in all copies or substantial portions of the Software.
;;;; 
;;;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;;;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;;;; MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;;;; NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
;;;; LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
;;;; OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
;;;; WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
;;;;

(asdf:defsystem #:cl-mysql
  :description "Common Lisp MySQL library bindings"
  :version "0.1"
  :author "Steve Knight <stkni@yahoo.com>"
  :maintainer "Steve Knight <stkni@yahoo.com>"
  :licence "MIT"
  :in-order-to ((test-op (load-op cl-mysql-test)))
  :perform (test-op :after (op c)
		    (describe
		     (funcall
		      (intern "TEST" :cl-mysql-test))))
  :serial t
  :components ((:file "system")
	       (:file "thread")
	       (:file "connection")
	       (:file "pool")
	       (:file "mysql")
	       (:file "prepare")
	       (:file "package"))
  :depends-on (#:cffi))

(defmethod operation-done-p 
           ((o test-op)
            (c (eql (find-system 'cl-mysql)))))




  
  
