(in-package :mgl-pax)

;;;; Low-level interface to Hyperspec Lisp definitions

(defparameter *hyperspec-definitions*
  ;; (SYMBOL LOCATIVE FILENAME)
  '((&allow-other-keys (go ("3.4.1" clhs)) "03_da")
    (&aux (go ("3.4.1" clhs)) "03_da")
    (&body (go ("3.4.4" clhs)) "03_dd")
    (&environment (go ("3.4.4" clhs)) "03_dd")
    (&key (go ("3.4.1" clhs)) "03_da")
    (&optional (go ("3.4.1" clhs)) "03_da")
    (&rest (go ("3.4.1" clhs)) "03_da")
    (&whole (go ("3.4.4" clhs)) "03_dd")
    (* function "f_st")
    (* variable "v_stst")
    (** variable "v__stst")
    (*** variable "v__stst")
    (*break-on-signals* variable "v_break_")
    (*compile-file-pathname* variable "v_cmp_fi")
    (*compile-file-truename* variable "v_cmp_fi")
    (*compile-print* variable "v_cmp_pr")
    (*compile-verbose* variable "v_cmp_pr")
    (*debug-io* variable "v_debug_")
    (*debugger-hook* variable "v_debugg")
    (*default-pathname-defaults* variable "v_defaul")
    (*error-output* variable "v_debug_")
    (*features* variable "v_featur")
    (*gensym-counter* variable "v_gensym")
    (*load-pathname* variable "v_ld_pns")
    (*load-print* variable "v_ld_prs")
    (*load-truename* variable "v_ld_pns")
    (*load-verbose* variable "v_ld_prs")
    (*macroexpand-hook* variable "v_mexp_h")
    (*modules* variable "v_module")
    (*package* variable "v_pkg")
    (*print-array* variable "v_pr_ar")
    (*print-base* variable "v_pr_bas")
    (*print-case* variable "v_pr_cas")
    (*print-circle* variable "v_pr_cir")
    (*print-escape* variable "v_pr_esc")
    (*print-gensym* variable "v_pr_gen")
    (*print-length* variable "v_pr_lev")
    (*print-level* variable "v_pr_lev")
    (*print-lines* variable "v_pr_lin")
    (*print-miser-width* variable "v_pr_mis")
    (*print-pprint-dispatch* variable "v_pr_ppr")
    (*print-pretty* variable "v_pr_pre")
    (*print-radix* variable "v_pr_bas")
    (*print-readably* variable "v_pr_rda")
    (*print-right-margin* variable "v_pr_rig")
    (*query-io* variable "v_debug_")
    (*random-state* variable "v_rnd_st")
    (*read-base* variable "v_rd_bas")
    (*read-default-float-format* variable "v_rd_def")
    (*read-eval* variable "v_rd_eva")
    (*read-suppress* variable "v_rd_sup")
    (*readtable* variable "v_rdtabl")
    (*standard-input* variable "v_debug_")
    (*standard-output* variable "v_debug_")
    (*terminal-io* variable "v_termin")
    (*trace-output* variable "v_debug_")
    (+ function "f_pl")
    (+ variable "v_pl_plp")
    (++ variable "v_pl_plp")
    (+++ variable "v_pl_plp")
    (- function "f__")
    (- variable "v__")
    (/ function "f_sl")
    (/ variable "v_sl_sls")
    (// variable "v_sl_sls")
    (/// variable "v_sl_sls")
    (/= function f_eq_sle)
    (1+ function "f_1pl_1_")
    (1- function "f_1pl_1_")
    (< function "f_eq_sle")
    (<= function "f_eq_sle")
    (= function "f_eq_sle")
    (> function "f_eq_sle")
    (>= function "f_eq_sle")
    (abort function "f_abortc")
    (abort restart "r_abort")
    (abs function "f_abs")
    (acons function "f_acons")
    (acos function "f_asin_")
    (acosh function "f_sinh_")
    (add-method generic-function "f_add_me")
    (adjoin function "f_adjoin")
    (adjust-array function "f_adjust")
    (adjustable-array-p function "f_adju_1")
    (allocate-instance generic-function "f_alloca")
    (alpha-char-p function "f_alpha_")
    (alphanumericp function "f_alphan")
    (and macro "m_and")
    (and type "t_and")
    (append function "f_append")
    (apply function "f_apply")
    (apropos function "f_apropo")
    (apropos-list function "f_apropo")
    (aref function "f_aref")
    (arithmetic-error condition "e_arithm")
    (arithmetic-error-operands function "f_arithm")
    (arithmetic-error-operation function "f_arithm")
    (array class "t_array")
    (array-dimension function "f_ar_dim")
    (array-dimension-limit constant "v_ar_dim")
    (array-dimensions function "f_ar_d_1")
    (array-displacement function "f_ar_dis")
    (array-element-type function "f_ar_ele")
    (array-has-fill-pointer-p function "f_ar_has")
    (array-in-bounds-p function "f_ar_in_")
    (array-rank function "f_ar_ran")
    (array-rank-limit constant "v_ar_ran")
    (array-row-major-index function "f_ar_row")
    (array-total-size function "f_ar_tot")
    (array-total-size-limit constant "v_ar_tot")
    (arrayp function "f_arrayp")
    (ash function "f_ash")
    (asin function "f_asin_")
    (asinh function "f_sinh_")
    (assert macro "m_assert")
    (assoc function "f_assocc")
    (assoc-if function "f_assocc")
    (assoc-if-not function "f_assocc")
    (atan function "f_asin_")
    (atanh function "f_sinh_")
    (atom function "f_atom")
    (atom type "t_atom")
    (base-char type "t_base_c")
    (base-string type "t_base_s")
    (bignum type "t_bignum")
    (bit function "f_bt_sb")
    (bit type "t_bit")
    (bit-and function "f_bt_and")
    (bit-andc1 function "f_bt_and")
    (bit-andc2 function "f_bt_and")
    (bit-eqv function "f_bt_and")
    (bit-ior function "f_bt_and")
    (bit-nand function "f_bt_and")
    (bit-nor function "f_bt_and")
    (bit-not function "f_bt_and")
    (bit-orc1 function "f_bt_and")
    (bit-orc2 function "f_bt_and")
    (bit-vector class "t_bt_vec")
    (bit-vector-p function "f_bt_vec")
    (bit-xor function "f_bt_and")
    (block operator "s_block")
    (boole function "f_boole")
    (boole-1 constant "v_b_1_b")
    (boole-2 constant "v_b_1_b")
    (boole-and constant "v_b_1_b")
    (boole-andc1 constant "v_b_1_b")
    (boole-andc2 constant "v_b_1_b")
    (boole-c1 constant "v_b_1_b")
    (boole-c2 constant "v_b_1_b")
    (boole-clr constant "v_b_1_b")
    (boole-eqv constant "v_b_1_b")
    (boole-ior constant "v_b_1_b")
    (boole-nand constant "v_b_1_b")
    (boole-nor constant "v_b_1_b")
    (boole-orc1 constant "v_b_1_b")
    (boole-orc2 constant "v_b_1_b")
    (boole-set constant "v_b_1_b")
    (boole-xor constant "v_b_1_b")
    (boolean type "t_ban")
    (both-case-p function "f_upper_")
    (boundp function "f_boundp")
    (break function "f_break")
    (broadcast-stream class "t_broadc")
    (broadcast-stream-streams function "f_broadc")
    (built-in-class class "t_built_")
    (butlast function "f_butlas")
    (byte function "f_by_by")
    (byte-position function "f_by_by")
    (byte-size function "f_by_by")
    (caaaar function "f_car_c")
    (caaadr function "f_car_c")
    (caaar function "f_car_c")
    (caadar function "f_car_c")
    (caaddr function "f_car_c")
    (caadr function "f_car_c")
    (caar function "f_car_c")
    (cadaar function "f_car_c")
    (cadadr function "f_car_c")
    (cadar function "f_car_c")
    (caddar function "f_car_c")
    (cadddr function "f_car_c")
    (caddr function "f_car_c")
    (cadr function "f_car_c")
    (call-arguments-limit constant "v_call_a")
    (call-method macro "m_call_m")
    (call-next-method (go (defmethod macro)) "f_call_n")
    (car function "f_car_c")
    (case macro "m_case_")
    (catch operator "s_catch")
    (ccase macro "m_case_")
    (cdaaar function "f_car_c")
    (cdaadr function "f_car_c")
    (cdaar function "f_car_c")
    (cdadar function "f_car_c")
    (cdaddr function "f_car_c")
    (cdadr function "f_car_c")
    (cdar function "f_car_c")
    (cddaar function "f_car_c")
    (cddadr function "f_car_c")
    (cddar function "f_car_c")
    (cdddar function "f_car_c")
    (cddddr function "f_car_c")
    (cdddr function "f_car_c")
    (cddr function "f_car_c")
    (cdr function "f_car_c")
    (ceiling function "f_floorc")
    (cell-error condition "e_cell_e")
    (cell-error-name function "f_cell_e")
    (cerror function "f_cerror")
    (change-class generic-function "f_chg_cl")
    (char function "f_char_")
    (char-code function "f_char_c")
    (char-code-limit constant "v_char_c")
    (char-downcase function "f_char_u")
    (char-equal function "f_chareq")
    (char-greaterp function "f_chareq")
    (char-int function "f_char_i")
    (char-lessp function "f_chareq")
    (char-name function "f_char_n")
    (char-not-equal function "f_chareq")
    (char-not-greaterp function "f_chareq")
    (char-not-lessp function "f_chareq")
    (char-upcase function "f_char_u")
    (char/= function "f_chareq")
    (char< function "f_chareq")
    (char<= function "f_chareq")
    (char= function "f_chareq")
    (char> function "f_chareq")
    (char>= function "f_chareq")
    (character function "f_ch")
    (character class "t_ch")
    (characterp function "f_chp")
    (check-type macro "m_check_")
    (cis function "f_cis")
    (class class "t_class")
    (class-name generic-function "f_class_")
    (class-of function "f_clas_1")
    (clear-input function "f_clear_")
    (clear-output function "f_finish")
    (close function "f_close")
    (clrhash function "f_clrhas")
    (code-char function "f_code_c")
    (coerce function "f_coerce")
    (compilation-speed declaration "d_optimi")
    (compile function "f_cmp")
    (compile-file function "f_cmp_fi")
    (compile-file-pathname function "f_cmp__1")
    (compiled-function type "t_cmpd_f")
    (compiled-function-p function "f_cmpd_f")
    ;; Adding symbols that CL:DOCUMENTATION specializes on leads to
    ;; lots of ambiguous links in the documentation.
    #+nil
    (compiler-macro (go (documentation (clhs generic-function))) "f_docume")
    (compiler-macro-function function "f_cmp_ma")
    (complement function "f_comple")
    (complex function "f_comp_2")
    (complex class "t_comple")
    (complexp function "f_comp_3")
    (compute-applicable-methods generic-function "f_comput")
    (compute-restarts function "f_comp_1")
    (concatenate function "f_concat")
    (concatenated-stream class "t_concat")
    (concatenated-stream-streams function "f_conc_1")
    (cond macro "m_cond")
    (condition condition "e_cnd")
    (conjugate function "f_conjug")
    (cons function "f_cons")
    (cons class "t_cons")
    (consp function "f_consp")
    (constantly function "f_cons_1")
    (constantp function "f_consta")
    (continue function "f_abortc")
    (continue restart "r_contin")
    (control-error condition "e_contro")
    (copy-alist function "f_cp_ali")
    (copy-list function "f_cp_lis")
    (copy-pprint-dispatch function "f_cp_ppr")
    (copy-readtable function "f_cp_rdt")
    (copy-seq function "f_cp_seq")
    (copy-structure function "f_cp_stu")
    (copy-symbol function "f_cp_sym")
    (copy-tree function "f_cp_tre")
    (cos function "f_sin_c")
    (cosh function "f_sinh_")
    (count function "f_countc")
    (count-if function "f_countc")
    (count-if-not function "f_countc")
    (ctypecase macro "m_tpcase")
    (debug declaration "d_optimi")
    (decf macro "m_incf_")
    (declaim macro "m_declai")
    (declaration declaration "d_declar")
    (declare operator "s_declar")
    (decode-float function "f_dec_fl")
    (decode-universal-time function "f_dec_un")
    (defclass macro "m_defcla")
    (defconstant macro "m_defcon")
    (defgeneric macro "m_defgen")
    (define-compiler-macro macro "m_define")
    (define-condition macro "m_defi_5")
    (define-method-combination macro "m_defi_4")
    (define-modify-macro macro "m_defi_2")
    (define-setf-expander macro "m_defi_3")
    (define-symbol-macro macro "m_defi_1")
    (defmacro macro "m_defmac")
    (defmethod macro "m_defmet")
    (defpackage macro "m_defpkg")
    (defparameter macro "m_defpar")
    (defsetf macro "m_defset")
    (defstruct macro "m_defstr")
    (deftype macro "m_deftp")
    (defun macro "m_defun")
    (defvar macro "m_defpar")
    (delete function "f_rm_rm")
    (delete-duplicates function "f_rm_dup")
    (delete-file function "f_del_fi")
    (delete-if function "f_rm_rm")
    (delete-if-not function "f_rm_rm")
    (delete-package function "f_del_pk")
    (denominator function "f_numera")
    (deposit-field function "f_deposi")
    (describe function "f_descri")
    (describe-object generic-function "f_desc_1")
    (destructuring-bind macro "m_destru")
    (digit-char function "f_digit_")
    (digit-char-p function "f_digi_1")
    (directory function "f_dir")
    (directory-namestring function "f_namest")
    (disassemble function "f_disass")
    (division-by-zero condition "e_divisi")
    (do macro "m_do_do")
    (do* macro "m_do_do")
    (do-all-symbols macro "m_do_sym")
    (do-external-symbols macro "m_do_sym")
    (do-symbols macro "m_do_sym")
    (documentation generic-function "f_docume")
    (dolist macro "m_dolist")
    (dotimes macro "m_dotime")
    (double-float type "t_short_")
    (double-float-epsilon constant "v_short_")
    (double-float-negative-epsilon constant "v_short_")
    (dpb function "f_dpb")
    (dribble function "f_dribbl")
    (dynamic-extent declaration "d_dynami")
    (ecase macro "m_case_")
    (echo-stream class "t_echo_s")
    (echo-stream-input-stream function "f_echo_s")
    (echo-stream-output-stream function "f_echo_s")
    (ed function "f_ed")
    (eighth function "f_firstc")
    (elt function "f_elt")
    (encode-universal-time function "f_encode")
    (end-of-file condition "e_end_of")
    (endp function "f_endp")
    (enough-namestring function "f_namest")
    (ensure-directories-exist function "f_ensu_1")
    (ensure-generic-function function "f_ensure")
    (eq function "f_eq")
    (eql function "f_eql")
    (eql type "t_eql")
    (equal function "f_equal")
    (equalp function "f_equalp")
    (error condition "e_error")
    (error function "f_error")
    (etypecase macro "m_tpcase")
    (eval function "f_eval")
    (eval-when operator "s_eval_w")
    (evenp function "f_evenpc")
    (every function "f_everyc")
    (exp function "f_exp_e")
    (export function "f_export")
    (expt function "f_exp_e")
    (extended-char type "t_extend")
    (fboundp function "f_fbound")
    (fceiling function "f_floorc")
    (fdefinition function "f_fdefin")
    (ffloor function "f_floorc")
    (fifth function "f_firstc")
    (file-author function "f_file_a")
    (file-error condition "e_file_e")
    (file-error-pathname function "f_file_e")
    (file-length function "f_file_l")
    (file-namestring function "f_namest")
    (file-position function "f_file_p")
    (file-stream class "t_file_s")
    (file-string-length function "f_file_s")
    (file-write-date function "f_file_w")
    (fill function "f_fill")
    (fill-pointer function "f_fill_p")
    (find function "f_find_")
    (find-all-symbols function "f_find_a")
    (find-class function "f_find_c")
    (find-if function "f_find_")
    (find-if-not function "f_find_")
    (find-method generic-function "f_find_m")
    (find-package function "f_find_p")
    (find-restart function "f_find_r")
    (find-symbol function "f_find_s")
    (finish-output function "f_finish")
    (first function "f_firstc")
    (fixnum type "t_fixnum")
    (flet operator "s_flet_")
    (float function "f_float")
    (float class "t_float")
    (float-digits function "f_dec_fl")
    (float-precision function "f_dec_fl")
    (float-radix function "f_dec_fl")
    (float-sign function "f_dec_fl")
    (floating-point-inexact condition "e_floa_1")
    (floating-point-invalid-operation condition "e_floati")
    (floating-point-overflow condition "e_floa_2")
    (floating-point-underflow condition "e_floa_3")
    (floatp function "f_floatp")
    (floor function "f_floorc")
    (fmakunbound function "f_fmakun")
    (force-output function "f_finish")
    (format function "f_format")
    (formatter macro "m_format")
    (fourth function "f_firstc")
    (fresh-line function "f_terpri")
    (fround function "f_floorc")
    (ftruncate function "f_floorc")
    (ftype declaration "d_ftype")
    (funcall function "f_funcal")
    (function operator "s_fn")
    #+nil
    (function (go (documentation (clhs generic-function))) "f_document")
    (function class "t_fn")
    (function-keywords generic-function "f_fn_kwd")
    (function-lambda-expression function "f_fn_lam")
    (functionp function "f_fnp")
    (gcd function "f_gcd")
    (generic-function class "t_generi")
    (gensym function "f_gensym")
    (gentemp function "f_gentem")
    (get function "f_get")
    (get-decoded-time function "f_get_un")
    (get-dispatch-macro-character function "f_set__1")
    (get-internal-real-time function "f_get_in")
    (get-internal-run-time function "f_get__1")
    (get-macro-character function "f_set_ma")
    (get-output-stream-string function "f_get_ou")
    (get-properties function "f_get_pr")
    (get-setf-expansion function "f_get_se")
    (get-universal-time function "f_get_un")
    (getf function "f_getf")
    (gethash function "f_gethas")
    (go operator "s_go")
    (graphic-char-p function "f_graphi")
    (handler-bind macro "m_handle")
    (handler-case macro "m_hand_1")
    (hash-table class "t_hash_t")
    (hash-table-count function "f_hash_1")
    (hash-table-p function "f_hash_t")
    (hash-table-rehash-size function "f_hash_2")
    (hash-table-rehash-threshold function "f_hash_3")
    (hash-table-size function "f_hash_4")
    (hash-table-test function "f_hash_5")
    (host-namestring function "f_namest")
    (identity function "f_identi")
    (if operator "s_if")
    (ignorable declaration "d_ignore")
    (ignore declaration "d_ignore")
    (ignore-errors macro "m_ignore")
    (imagpart function "f_realpa")
    (import function "f_import")
    ;; Defeat Slime's IN-PACKAGE parser.
    (#.'in-package macro "m_in_pkg")
    (incf macro "m_incf_")
    (initialize-instance generic-function "f_init_i")
    (inline declaration "d_inline")
    (input-stream-p function "f_in_stm")
    (inspect function "f_inspec")
    (integer class "t_intege")
    (integer-decode-float function "f_dec_fl")
    (integer-length function "f_intege")
    (integerp function "f_inte_1")
    (interactive-stream-p function "f_intera")
    (intern function "f_intern")
    (internal-time-units-per-second constant "v_intern")
    (intersection function "f_isec_")
    (invalid-method-error function "f_invali")
    (invoke-debugger function "f_invoke")
    (invoke-restart function "f_invo_1")
    (invoke-restart-interactively function "f_invo_2")
    (isqrt function "f_sqrt_")
    (keyword type "t_kwd")
    (keywordp function "f_kwdp")
    (labels operator "s_flet_")
    (lambda macro "m_lambda")
    (lambda (go ("s_lambda" (clhs section))) "s_lambda")
    (lambda-list-keywords constant "v_lambda")
    (lambda-parameters-limit constant "v_lamb_1")
    (last function "f_last")
    (lcm function "f_lcm")
    (ldb function "f_ldb")
    (ldb-test function "f_ldb_te")
    (ldiff function "f_ldiffc")
    (least-negative-double-float constant "v_most_1")
    (least-negative-long-float constant "v_most_1")
    (least-negative-normalized-double-float constant "v_most_1")
    (least-negative-normalized-long-float constant "v_most_1")
    (least-negative-normalized-short-float constant "v_most_1")
    (least-negative-normalized-single-float constant "v_most_1")
    (least-negative-short-float constant "v_most_1")
    (least-negative-single-float constant "v_most_1")
    (least-positive-double-float constant "v_most_1")
    (least-positive-long-float constant "v_most_1")
    (least-positive-normalized-double-float constant "v_most_1")
    (least-positive-normalized-long-float constant "v_most_1")
    (least-positive-normalized-short-float constant "v_most_1")
    (least-positive-normalized-single-float constant "v_most_1")
    (least-positive-short-float constant "v_most_1")
    (least-positive-single-float constant "v_most_1")
    (length function "f_length")
    (let operator "s_let_l")
    (let* operator "s_let_l")
    (lisp-implementation-type function "f_lisp_i")
    (lisp-implementation-version function "f_lisp_i")
    (list function "f_list_")
    (list class "t_list")
    (list* function "f_list_")
    (list-all-packages function "f_list_a")
    (list-length function "f_list_l")
    (listen function "f_listen")
    (listp function "f_listp")
    (load function "f_load")
    (load-logical-pathname-translations function "f_ld_log")
    (load-time-value operator "s_ld_tim")
    (locally operator "s_locall")
    (log function "f_log")
    (logand function "f_logand")
    (logandc1 function "f_logand")
    (logandc2 function "f_logand")
    (logbitp function "f_logbtp")
    (logcount function "f_logcou")
    (logeqv function "f_logand")
    (logical-pathname function "f_logi_1")
    (logical-pathname class "t_logica")
    (logical-pathname-translations function "f_logica")
    (logior function "f_logand")
    (lognand function "f_logand")
    (lognor function "f_logand")
    (lognot function "f_logand")
    (logorc1 function "f_logand")
    (logorc2 function "f_logand")
    (logtest function "f_logtes")
    (logxor function "f_logand")
    (long-float type "t_short_")
    (long-float-epsilon constant "v_short_")
    (long-float-negative-epsilon constant "v_short_")
    (long-site-name function "f_short_")
    (loop macro "m_loop")
    (loop-finish macro "m_loop_f")
    (lower-case-p function "f_upper_")
    (machine-instance function "f_mach_i")
    (machine-type function "f_mach_t")
    (machine-version function "f_mach_v")
    (macro-function function "f_macro_")
    (macroexpand function "f_mexp_")
    (macroexpand-1 function "f_mexp_")
    (macrolet operator "s_flet_")
    (make-array function "f_mk_ar")
    (make-broadcast-stream function "f_mk_bro")
    (make-concatenated-stream function "f_mk_con")
    (make-condition function "f_mk_cnd")
    (make-dispatch-macro-character function "f_mk_dis")
    (make-echo-stream function "f_mk_ech")
    (make-hash-table function "f_mk_has")
    (make-instance generic-function "f_mk_ins")
    (make-instances-obsolete generic-function "f_mk_i_1")
    (make-list function "f_mk_lis")
    (make-load-form generic-function "f_mk_ld_")
    (make-load-form-saving-slots function "f_mk_l_1")
    (make-method macro "m_call_m")
    (make-package function "f_mk_pkg")
    (make-pathname function "f_mk_pn")
    (make-random-state function "f_mk_rnd")
    (make-sequence function "f_mk_seq")
    (make-string function "f_mk_stg")
    (make-string-input-stream function "f_mk_s_1")
    (make-string-output-stream function "f_mk_s_2")
    (make-symbol function "f_mk_sym")
    (make-synonym-stream function "f_mk_syn")
    (make-two-way-stream function "f_mk_two")
    (makunbound function "f_makunb")
    (map function "f_map")
    (map-into function "f_map_in")
    (mapc function "f_mapc_")
    (mapcan function "f_mapc_")
    (mapcar function "f_mapc_")
    (mapcon function "f_mapc_")
    (maphash function "f_maphas")
    (mapl function "f_mapc_")
    (maplist function "f_mapc_")
    (mask-field function "f_mask_f")
    (max function "f_max_m")
    (member function "t_mem_m")
    (member type "t_member")
    (member-if function "f_mem_m")
    (member-if-not function "f_mem_m")
    (merge function "f_merge")
    (merge-pathnames function "f_merge_")
    (method class "t_method")
    #+nil
    (method-combination (go (documentation (clhs generic-function))) "f_docume")
    (method-combination class "t_meth_1")
    (method-combination-error function "f_meth_1")
    (method-qualifiers generic-function "f_method")
    (min function "f_max_m")
    (minusp function "f_minusp")
    (mismatch function "f_mismat")
    (mod function "f_mod_r")
    (mod type "t_mod")
    (most-negative-double-float constant "v_most_1")
    (most-negative-fixnum constant "v_most_p")
    (most-negative-long-float constant "v_most_1")
    (most-negative-short-float constant "v_most_1")
    (most-negative-single-float constant "v_most_1")
    (most-positive-double-float constant "v_most_1")
    (most-positive-fixnum constant "v_most_p")
    (most-positive-long-float constant "v_most_1")
    (most-positive-short-float constant "v_most_1")
    (most-positive-single-float constant "v_most_1")
    (muffle-warning function "f_abortc")
    (muffle-warning restart "r_muffle")
    (multiple-value-bind macro "m_multip")
    (multiple-value-call operator "s_multip")
    (multiple-value-list macro "m_mult_1")
    (multiple-value-prog1 operator "s_mult_1")
    (multiple-value-setq macro "m_mult_2")
    (multiple-values-limit constant "v_multip")
    (name-char function "f_name_c")
    (namestring function "f_namest")
    (nbutlast function "f_butlas")
    (nconc function "f_nconc")
    (next-method-p (go (defmethod clhs)) "f_next_m")
    (nil constant "v_nil")
    (nil type "t_nil")
    (nintersection function "f_isec_")
    (ninth function "f_firstc")
    (no-applicable-method generic-function "f_no_app")
    (no-next-method generic-function "f_no_nex")
    (not function "f_not")
    (not type "t_not")
    (notany function "f_everyc")
    (notevery function "f_everyc")
    (notinline declaration "d_inline")
    (nreconc function "f_revapp")
    (nreverse function "f_revers")
    (nset-difference function "f_set_di")
    (nset-exclusive-or function "f_set_ex")
    (nstring-capitalize function "f_stg_up")
    (nstring-downcase function "f_stg_up")
    (nstring-upcase function "f_stg_up")
    (nsublis function "f_sublis")
    (nsubst function "f_substc")
    (nsubst-if function "f_substc")
    (nsubst-if-not function "f_substc")
    (nsubstitute function "f_sbs_s")
    (nsubstitute-if function "f_sbs_s")
    (nsubstitute-if-not function "f_sbs_s")
    (nth function "f_nth")
    (nth-value macro "m_nth_va")
    (nthcdr function "f_nthcdr")
    (null function "f_null")
    (null class "t_null")
    (number class "t_number")
    (numberp function "f_nump")
    (numerator function "f_numera")
    (nunion function "f_unionc")
    (oddp function "f_evenpc")
    (open function "f_open")
    (open-stream-p function "f_open_s")
    (optimize declaration "d_optimi")
    (or macro "m_or")
    (or type "t_or")
    (otherwise macro "m_case_")
    (output-stream-p function "f_in_stm")
    (package class "t_pkg")
    (package-error condition "e_pkg_er")
    (package-error-package function "f_pkg_er")
    (package-name function "f_pkg_na")
    (package-nicknames function "f_pkg_ni")
    (package-shadowing-symbols function "f_pkg_sh")
    (package-use-list function "f_pkg_us")
    (package-used-by-list function "f_pkg__1")
    (packagep function "f_pkgp")
    (pairlis function "f_pairli")
    (parse-error condition "e_parse_")
    (parse-integer function "f_parse_")
    (parse-namestring function "f_pars_1")
    (pathname function "f_pn")
    (pathname class "t_pn")
    (pathname-device function "f_pn_hos")
    (pathname-directory function "f_pn_hos")
    (pathname-host function "f_pn_hos")
    (pathname-match-p function "f_pn_mat")
    (pathname-name function "f_pn_hos")
    (pathname-type function "f_pn_hos")
    (pathname-version function "f_pn_hos")
    (pathnamep function "f_pnp")
    (peek-char function "f_peek_c")
    (phase function "f_phase")
    (pi constant "v_pi")
    (plusp function "f_minusp")
    (pop macro "m_pop")
    (position function "f_pos_p")
    (position-if function "f_pos_p")
    (position-if-not function "f_pos_p")
    (pprint function "f_wr_pr")
    (pprint-dispatch function "f_ppr_di")
    (pprint-exit-if-list-exhausted macro "m_ppr_ex")
    (pprint-fill function "f_ppr_fi")
    (pprint-indent function "f_ppr_in")
    (pprint-linear function "f_ppr_fi")
    (pprint-logical-block macro "m_ppr_lo")
    (pprint-newline function "f_ppr_nl")
    (pprint-pop macro "m_ppr_po")
    (pprint-tab function "f_ppr_ta")
    (pprint-tabular function "f_ppr_fi")
    (prin1 function "f_wr_pr")
    (prin1-to-string function "f_wr_to_")
    (princ function "f_wr_pr")
    (princ-to-string function "f_wr_to_")
    (print function "f_wr_pr")
    (print-not-readable condition "e_pr_not")
    (print-not-readable-object function "f_pr_not")
    (print-object generic-function "f_pr_obj")
    (print-unreadable-object macro "m_pr_unr")
    (probe-file function "f_probe_")
    (proclaim function "f_procla")
    (prog macro "m_prog_")
    (prog* macro "m_prog_")
    (prog1 macro "m_prog1c")
    (prog2 macro "m_prog1c")
    (progn operator "s_progn")
    (program-error condition "e_progra")
    (progv operator "s_progv")
    (provide function "f_provid")
    (psetf macro "m_setf_")
    (psetq macro "m_psetq")
    (push macro "m_push")
    (pushnew macro "m_pshnew")
    (quote operator "s_quote")
    (random function "f_random")
    (random-state class "t_rnd_st")
    (random-state-p function "f_rnd_st")
    (rassoc function "f_rassoc")
    (rassoc-if function "f_rassoc")
    (rassoc-if-not function "f_rassoc")
    (ratio class "t_ratio")
    (rational function "f_ration")
    (rational class "t_ration")
    (rationalize function "f_ration")
    (rationalp function "f_rati_1")
    (read function "f_rd_rd")
    (read-byte function "f_rd_by")
    (read-char function "f_rd_cha")
    (read-char-no-hang function "f_rd_c_1")
    (read-delimited-list function "f_rd_del")
    (read-from-string function "f_rd_fro")
    (read-line function "f_rd_lin")
    (read-preserving-whitespace function "f_rd_rd")
    (read-sequence function "f_rd_seq")
    (reader-error condition "e_rder_e")
    (readtable class "t_rdtabl")
    (readtable-case function "f_rdtabl")
    (readtablep function "f_rdta_1")
    (real class "t_real")
    (realp function "f_realp")
    (realpart function "f_realpa")
    (reduce function "f_reduce")
    (reinitialize-instance generic-function "f_reinit")
    (rem function "f_mod_r")
    (remf macro "m_remf")
    (remhash function "f_remhas")
    (remove function "f_rm_rm")
    (remove-duplicates function "f_rm_dup")
    (remove-if function "f_rm_rm")
    (remove-if-not function "f_rm_rm")
    (remove-method generic-function "f_rm_met")
    (remprop function "f_rempro")
    (rename-file function "f_rn_fil")
    (rename-package function "f_rn_pkg")
    (replace function "f_replac")
    (require function "f_provid")
    (rest function "f_rest")
    (restart class "t_rst")
    (restart-bind macro "m_rst_bi")
    (restart-case macro "m_rst_ca")
    (restart-name function "f_rst_na")
    (return macro "m_return")
    (return-from operator "s_ret_fr")
    (revappend function "f_revapp")
    (reverse function "f_revers")
    (room function "f_room")
    (rotatef macro "m_rotate")
    (round function "f_floorc")
    (row-major-aref function "f_row_ma")
    (rplaca function "f_rplaca")
    (rplacd function "f_rplaca")
    (safety declaration "d_optimi")
    (satisfies type "t_satisf")
    (sbit function "f_bt_sb")
    (scale-float function "f_dec_fl")
    (schar function "f_char_")
    (search function "f_search")
    (second function "f_firstc")
    (sequence class "t_seq")
    (serious-condition condition "e_seriou")
    (set function "f_set")
    (set-difference function "f_set_di")
    (set-dispatch-macro-character function "f_set__1")
    (set-exclusive-or function "f_set_ex")
    (set-macro-character function "f_set_ma")
    (set-pprint-dispatch function "f_set_pp")
    (set-syntax-from-char function "f_set_sy")
    (setf macro "m_setf_")
    #+nil
    (setf (go (documentation (clhs generic-function))) "f_docume")
    (setq operator "s_setq")
    (seventh function "f_firstc")
    (shadow function "f_shadow")
    (shadowing-import function "f_shdw_i")
    (shared-initialize generic-function "f_shared")
    (shiftf macro "m_shiftf")
    (short-float type "t_short_")
    (short-float-epsilon constant "v_short_")
    (short-float-negative-epsilon constant "v_short_")
    (short-site-name function "f_short_")
    (signal function "f_signal")
    (signed-byte type "t_sgn_by")
    (signum function "f_signum")
    (simple-array type "t_smp_ar")
    (simple-base-string type "t_smp_ba")
    (simple-bit-vector type "t_smp_bt")
    (simple-bit-vector-p function "f_smp_bt")
    (simple-condition condition "e_smp_cn")
    (simple-condition-format-arguments function "f_smp_cn")
    (simple-condition-format-control function "f_smp_cn")
    (simple-error condition "e_smp_er")
    (simple-string type "t_smp_st")
    (simple-string-p function "f_smp_st")
    (simple-type-error condition "e_smp_tp")
    (simple-vector type "t_smp_ve")
    (simple-vector-p function "f_smp_ve")
    (simple-warning condition "e_smp_wa")
    (sin function "f_sin_c")
    (single-float type "t_short_")
    (single-float-epsilon constant "v_short_")
    (single-float-negative-epsilon constant "v_short_")
    (sinh function "f_sinh_")
    (sixth function "f_firstc")
    (sleep function "f_sleep")
    (slot-boundp function "f_slt_bo")
    (slot-exists-p function "f_slt_ex")
    (slot-makunbound function "f_slt_ma")
    (slot-missing generic-function "f_slt_mi")
    (slot-unbound generic-function "f_slt_un")
    (slot-value function "f_slt_va")
    (software-type function "f_sw_tpc")
    (software-version function "f_sw_tpc")
    (some function "f_everyc")
    (sort function "f_sort_")
    (space declaration "d_optimi")
    (special declaration "d_specia")
    (special-operator-p function "f_specia")
    (speed declaration "d_optimi")
    (sqrt function "f_sqrt_")
    (stable-sort function "f_sort_")
    (standard-char type "t_std_ch")
    (standard-char-p function "f_std_ch")
    (standard-class class "t_std_cl")
    (standard-generic-function class "t_std_ge")
    (standard-method class "t_std_me")
    (standard-object class "t_std_ob")
    (step macro "m_step")
    (storage-condition condition "e_storag")
    (store-value function "f_abortc")
    (store-value restart "r_store")
    (stream class "t_stream")
    (stream-element-type function "f_stm_el")
    (stream-error condition "e_stm_er")
    (stream-error-stream function "f_stm_er")
    (stream-external-format function "f_stm_ex")
    (streamp function "f_stmp")
    (string function "f_string")
    (string class "t_string")
    (string-capitalize function "f_stg_up")
    (string-downcase function "f_stg_up")
    (string-equal function "f_stgeq_")
    (string-greaterp function "f_stgeq_")
    (string-left-trim function "f_stg_tr")
    (string-lessp function "f_stgeq_")
    (string-not-equal function "f_stgeq_")
    (string-not-greaterp function "f_stgeq_")
    (string-not-lessp function "f_stgeq_")
    (string-right-trim function "f_stg_tr")
    (string-stream class "t_stg_st")
    (string-trim function "f_stg_tr")
    (string-upcase function "f_stg_up")
    (string/= function "f_stgeq_")
    (string< function "f_stgeq_")
    (string<= function "f_stgeq_")
    (string= function "f_stgeq_")
    (string> function "f_stgeq_")
    (string>= function "f_stgeq_")
    (stringp function "f_stgp")
    #+nil
    (structure (go (documentation (clhs generic-function))) "f_docume")
    (structure-class class "t_stu_cl")
    (structure-object class "t_stu_ob")
    (style-warning condition "e_style_")
    (sublis function "f_sublis")
    (subseq function "f_subseq")
    (subsetp function "f_subset")
    (subst function "f_substc")
    (subst-if function "f_substc")
    (subst-if-not function "f_substc")
    (substitute function "f_sbs_s")
    (substitute-if function "f_sbs_s")
    (substitute-if-not function "f_sbs_s")
    (subtypep function "f_subtpp")
    (svref function "f_svref")
    (sxhash function "f_sxhash")
    (symbol class "t_symbol")
    (symbol-function function "f_symb_1")
    (symbol-macrolet operator "s_symbol")
    (symbol-name function "f_symb_2")
    (symbol-package function "f_symb_3")
    (symbol-plist function "f_symb_4")
    (symbol-value function "f_symb_5")
    (symbolp function "f_symbol")
    (synonym-stream class "t_syn_st")
    (synonym-stream-symbol function "f_syn_st")
    (t constant "v_t")
    #+nil
    (t (go (documentation (clhs generic-function))) "f_docume")
    (t class "t_t")
    (tagbody operator "s_tagbod")
    (tailp function "f_ldiffc")
    (tan function "f_sin_c")
    (tanh function "f_sinh_")
    (tenth function "f_firstc")
    (terpri function "f_terpri")
    (the operator "s_the")
    (third function "f_firstc")
    (throw operator "s_throw")
    (time macro "m_time")
    (trace macro "m_tracec")
    (translate-logical-pathname function "f_tr_log")
    (translate-pathname function "f_tr_pn")
    (tree-equal function "f_tree_e")
    (truename function "f_tn")
    (truncate function "f_floorc")
    (two-way-stream class "t_two_wa")
    (two-way-stream-input-stream function "f_two_wa")
    (two-way-stream-output-stream function "f_two_wa")
    (type declaration "d_type")
    #+nil
    (type (go (documentation (clhs generic-function))) "f_docume")
    (type-error condition "e_tp_err")
    (type-error-datum function "f_tp_err")
    (type-error-expected-type function "f_tp_err")
    (type-of function "f_tp_of")
    (typecase macro "m_tpcase")
    (typep function "f_typep")
    (unbound-slot condition "e_unboun")
    (unbound-slot-instance function "f_unboun")
    (unbound-variable condition "e_unbo_1")
    (undefined-function condition "e_undefi")
    (unexport function "f_unexpo")
    (unintern function "f_uninte")
    (union function "f_unionc")
    (unless macro "m_when_")
    (unread-char function "f_unrd_c")
    (unsigned-byte type "t_unsgn_")
    (untrace macro "m_tracec")
    (unuse-package function "f_unuse_")
    (unwind-protect operator "s_unwind")
    (update-instance-for-different-class generic-function "f_update")
    (update-instance-for-redefined-class generic-function "f_upda_1")
    (upgraded-array-element-type function "f_upgr_1")
    (upgraded-complex-part-type function "f_upgrad")
    (upper-case-p function "f_upper_")
    (use-package function "f_use_pk")
    (use-value function "f_abortc")
    (use-value restart "r_use_va")
    (user-homedir-pathname function "f_user_h")
    (values function "f_values")
    (values type "t_values")
    (values-list function "f_vals_l")
    #+nil
    (variable (documentation (clhs generic-function)) "f_docume")
    (vector function "f_vector")
    (vector class "t_vector")
    (vector-pop function "f_vec_po")
    (vector-push function "f_vec_ps")
    (vector-push-extend function "f_vec_ps")
    (vectorp function "f_vecp")
    (warn function "f_warn")
    (warning condition "e_warnin")
    (when macro "m_when_")
    (wild-pathname-p function "f_wild_p")
    (with-accessors macro "m_w_acce")
    (with-compilation-unit macro "m_w_comp")
    (with-condition-restarts macro "m_w_cnd_")
    (with-hash-table-iterator macro "m_w_hash")
    (with-input-from-string macro "m_w_in_f")
    (with-open-file macro "m_w_open")
    (with-open-stream macro "m_w_op_1")
    (with-output-to-string macro "m_w_out_")
    (with-package-iterator macro "m_w_pkg_")
    (with-simple-restart macro "m_w_smp_")
    (with-slots macro "m_w_slts")
    (with-standard-io-syntax macro "m_w_std_")
    (write function "f_wr_pr")
    (write-byte function "f_wr_by")
    (write-char function "f_wr_cha")
    (write-line function "f_wr_stg")
    (write-sequence function "f_wr_seq")
    (write-string function "f_wr_stg")
    (write-to-string function "f_wr_to_")
    (y-or-n-p function "f_y_or_n")
    (yes-or-no-p function "f_y_or_n")
    (zerop function "f_zerop")))

(defparameter *hyperspec-disambiguations*
  ;; (SYMBOL FILENAME)
  '((* "a_st")
    (+ "a_pl")
    (- "a__")
    (/ "a_sl")
    (abort "a_abort")
    (and "a_and")
    (atom "a_atom")
    (bit "a_bit")
    (character "a_ch")
    (complex "a_comple")
    (cons "a_cons")
    (continue "a_contin")
    (eql "a_eql")
    (error "a_error")
    (float "a_float")
    (function "a_fn")
    (lambda "a_lambda")
    (list "a_list")
    (logical-pathname "a_logica")
    (member "a_member")
    (method-combination "a_method")
    (mod "a_mod")
    (muffle-warning "a_muffle")
    (nil "a_nil")
    (not "a_not")
    (null "a_null")
    (or "a_or")
    (pathname "a_pn")
    (rational "a_ration")
    (setf "a_setf")
    (store-value "a_store_")
    (string "a_string")
    (t "a_t")
    (type "a_type")
    (use-value "a_use_va")
    (values "a_values")
    (vector "a_vector")))

(defun make-hyperspec-name-to-locatives ()
  (let ((map (make-hash-table)))
    (loop for (name locative filename) in *hyperspec-definitions*
          do (push (list (if (eq locative 'operator)
                             'macro
                             locative)
                         (format nil "~A.htm" filename))
                   (gethash name map)))
    (loop for (name filename) in *hyperspec-disambiguations*
          do ;; KLUDGE: LAMBDA has two pages, but one of them is a
             ;; "symbol" page, which we don't have.
             (unless (eq name 'lambda)
               (assert (<= 1 (length (gethash name map)))))
             (push (list nil (format nil "~A.htm" filename))
                   (gethash name map)))
    map))

(defparameter *hyperspec-name-to-locatives*
  (make-hyperspec-name-to-locatives))

;;; Find stuff in *HYPERSPEC-DEFINITIONS* and
;;; *HYPERSPEC-DISAMBIGUATIONS*. Return the URL corresponding to NAME
;;; and LOCATIVE. As a special case, LOCATIVE NIL refers to the
;;; disambiguation page.
(defun/autoloaded find-hyperspec-definition-url
    (name locative &optional hyperspec-root)
  (declare (special *hyperspec-name-to-locatives*))
  (let* ((entries (gethash name *hyperspec-name-to-locatives*))
         (entry (if locative
                    ;; UNLIST1 is to (FUNCTION) -> FUNCTION.
                    (find (unlist1 locative) entries :key #'first)
                    ;; The disambiguation page is first, else there is
                    ;; only one entry anyway.
                    (first entries))))
    (when entry
      (destructuring-bind (locative filename) entry
        (values (hyperspec-link hyperspec-root "Body/" filename)
                locative)))))

(defun unlist1 (obj)
  (if (and (listp obj) (= (length obj) 1))
      (first obj)
      obj))

(defun hyperspec-locatives-for-name (name)
  (loop for (locative *) in (gethash name *hyperspec-name-to-locatives*)
        collect locative))


;;;; Low-level interface to Hyperspec sections

(defparameter *hyperspec-sections*
  ;; (FILENAME TITLE SECTION-ID)
  '(("00_" "0" "Credits")
    ("01_" "1" "Introduction")
    ("01_a" "1.1" "Scope, Purpose, and History")
    ("01_aa" "1.1.1" "Scope and Purpose")
    ("01_ab" "1.1.2" "History")
    ("01_b" "1.2" "Organization of the Document")
    ("01_c" "1.3" "Referenced Publications")
    ("01_d" "1.4" "Definitions")
    ("01_da" "1.4.1" "Notational Conventions")
    ("01_daa" "1.4.1.1" "Font Key")
    ("01_dab" "1.4.1.2" "Modified BNF Syntax")
    ("01_daba" "1.4.1.2.1" "Splicing in Modified BNF Syntax")
    ("01_dabb" "1.4.1.2.2" "Indirection in Modified BNF Syntax")
    ("01_dabc" "1.4.1.2.3"
     "Additional Uses for Indirect Definitions in Modified BNF Syntax")
    ("01_dac" "1.4.1.3" "Special Symbols")
    ("01_dad" "1.4.1.4" "Objects with Multiple Notations")
    ("01_dada" "1.4.1.4.1" "Case in Symbols")
    ("01_dadb" "1.4.1.4.2" "Numbers")
    ("01_dadc" "1.4.1.4.3" "Use of the Dot Character")
    ("01_dadd" "1.4.1.4.4" "NIL")
    ("01_dae" "1.4.1.5" "Designators")
    ("01_daf" "1.4.1.6" "Nonsense Words")
    ("01_db" "1.4.2" "Error Terminology")
    ("01_dc" "1.4.3" "Sections Not Formally Part Of This Standard")
    ("01_dd" "1.4.4" "Interpreting Dictionary Entries")
    ("01_dda" "1.4.4.1" "The ``Affected By'' Section of a Dictionary Entry")
    ("01_ddb" "1.4.4.2" "The ``Arguments'' Section of a Dictionary Entry")
    ("01_ddc" "1.4.4.3"
     "The ``Arguments and Values'' Section of a Dictionary Entry")
    ("01_ddd" "1.4.4.4"
     "The ``Binding Types Affected'' Section of a Dictionary Entry")
    ("01_dde" "1.4.4.5"
     "The ``Class Precedence List'' Section of a Dictionary Entry")
    ("01_ddf" "1.4.4.6" "Dictionary Entries for Type Specifiers")
    ("01_ddfa" "1.4.4.6.1"
     "The ``Compound Type Specifier Kind'' Section of a Dictionary Entry")
    ("01_ddfb" "1.4.4.6.2"
     "The ``Compound Type Specifier Syntax'' Section of a Dictionary Entry")
    ("01_ddfc" "1.4.4.6.3"
     "The ``Compound Type Specifier Arguments'' Section of a Dictionary Entry")
    ("01_ddfd" "1.4.4.6.4"
     "The ``Compound Type Specifier Description'' Section of a Dictionary Entry")
    ("01_ddg" "1.4.4.7" "The ``Constant Value'' Section of a Dictionary Entry")
    ("01_ddh" "1.4.4.8" "The ``Description'' Section of a Dictionary Entry")
    ("01_ddi" "1.4.4.9" "The ``Examples'' Section of a Dictionary Entry")
    ("01_ddj" "1.4.4.10"
     "The ``Exceptional Situations'' Section of a Dictionary Entry")
    ("01_ddk" "1.4.4.11" "The ``Initial Value'' Section of a Dictionary Entry")
    ("01_ddl" "1.4.4.12"
     "The ``Argument Precedence Order'' Section of a Dictionary Entry")
    ("01_ddm" "1.4.4.13"
     "The ``Method Signature'' Section of a Dictionary Entry")
    ("01_ddn" "1.4.4.14" "The ``Name'' Section of a Dictionary Entry")
    ("01_ddo" "1.4.4.15" "The ``Notes'' Section of a Dictionary Entry")
    ("01_ddp" "1.4.4.16" "The ``Pronunciation'' Section of a Dictionary Entry")
    ("01_ddq" "1.4.4.17" "The ``See Also'' Section of a Dictionary Entry")
    ("01_ddr" "1.4.4.18" "The ``Side Effects'' Section of a Dictionary Entry")
    ("01_dds" "1.4.4.19" "The ``Supertypes'' Section of a Dictionary Entry")
    ("01_ddt" "1.4.4.20" "The ``Syntax'' Section of a Dictionary Entry")
    ("01_ddta" "1.4.4.20.1"
     "Special ``Syntax'' Notations for Overloaded Operators")
    ("01_ddtb" "1.4.4.20.2" "Naming Conventions for Rest Parameters")
    ("01_ddtc" "1.4.4.20.3"
     "Requiring Non-Null Rest Parameters in the ``Syntax'' Section")
    ("01_ddtd" "1.4.4.20.4" "Return values in the ``Syntax'' Section")
    ("01_ddtda"
     "1.4.4.20.4.1" "No Arguments or Values in the ``Syntax'' Section")
    ("01_ddtdb" "1.4.4.20.4.2"
     "Unconditional Transfer of Control in the ``Syntax'' Section")
    ("01_ddu" "1.4.4.21" "The ``Valid Context'' Section of a Dictionary Entry")
    ("01_ddv" "1.4.4.22" "The ``Value Type'' Section of a Dictionary Entry")
    ("01_e" "1.5" "Conformance")
    ("01_ea" "1.5.1" "Conforming Implementations")
    ("01_eaa" "1.5.1.1" "Required Language Features")
    ("01_eab" "1.5.1.2" "Documentation of Implementation-Dependent Features")
    ("01_eac" "1.5.1.3" "Documentation of Extensions")
    ("01_ead" "1.5.1.4" "Treatment of Exceptional Situations")
    ("01_eada" "1.5.1.4.1"
     "Resolution of Apparent Conflicts in Exceptional Situations")
    ("01_eadaa" "1.5.1.4.1.1"
     "Examples of Resolution of Apparent Conflicts in Exceptional Situations")
    ("01_eae" "1.5.1.5" "Conformance Statement")
    ("01_eb" "1.5.2" "Conforming Programs")
    ("01_eba" "1.5.2.1" "Use of Implementation-Defined Language Features")
    ("01_ebaa" "1.5.2.1.1" "Use of Read-Time Conditionals")
    ("01_ebb" "1.5.2.2" "Character Set for Portable Code")
    ("01_f" "1.6" "Language Extensions")
    ("01_g" "1.7" "Language Subsets")
    ("01_h" "1.8" "Deprecated Language Features")
    ("01_ha" "1.8.1" "Deprecated Functions")
    ("01_hb" "1.8.2" "Deprecated Argument Conventions")
    ("01_hc" "1.8.3" "Deprecated Variables")
    ("01_hd" "1.8.4" "Deprecated Reader Syntax")
    ("01_i" "1.9" "Symbols in the COMMON-LISP Package")
    ("02_" "2" "Syntax")
    ("02_a" "2.1" "Character Syntax")
    ("02_aa" "2.1.1" "Readtables")
    ("02_aaa" "2.1.1.1" "The Current Readtable")
    ("02_aab" "2.1.1.2" "The Standard Readtable")
    ("02_aac" "2.1.1.3" "The Initial Readtable")
    ("02_ab" "2.1.2" "Variables that affect the Lisp Reader")
    ("02_ac" "2.1.3" "Standard Characters")
    ("02_ad" "2.1.4" "Character Syntax Types")
    ("02_ada" "2.1.4.1" "Constituent Characters")
    ("02_adb" "2.1.4.2" "Constituent Traits")
    ("02_adc" "2.1.4.3" "Invalid Characters")
    ("02_add" "2.1.4.4" "Macro Characters")
    ("02_ade" "2.1.4.5" "Multiple Escape Characters")
    ("02_adea" "2.1.4.5.1" "Examples of Multiple Escape Characters")
    ("02_adf" "2.1.4.6" "Single Escape Character")
    ("02_adfa" "2.1.4.6.1" "Examples of Single Escape Characters")
    ("02_adg" "2.1.4.7" "Whitespace Characters")
    ("02_adga" "2.1.4.7.1" "Examples of Whitespace Characters")
    ("02_b" "2.2" "Reader Algorithm")
    ("02_c" "2.3" "Interpretation of Tokens")
    ("02_ca" "2.3.1" "Numbers as Tokens")
    ("02_caa" "2.3.1.1" "Potential Numbers as Tokens")
    ("02_caaa" "2.3.1.1.1" "Escape Characters and Potential Numbers")
    ("02_caab" "2.3.1.1.2" "Examples of Potential Numbers")
    ("02_cb" "2.3.2" "Constructing Numbers from Tokens")
    ("02_cba" "2.3.2.1" "Syntax of a Rational")
    ("02_cbaa" "2.3.2.1.1" "Syntax of an Integer")
    ("02_cbab" "2.3.2.1.2" "Syntax of a Ratio")
    ("02_cbb" "2.3.2.2" "Syntax of a Float")
    ("02_cbc" "2.3.2.3" "Syntax of a Complex")
    ("02_cc" "2.3.3" "The Consing Dot")
    ("02_cd" "2.3.4" "Symbols as Tokens")
    ("02_ce" "2.3.5" "Valid Patterns for Tokens")
    ("02_cf" "2.3.6" "Package System Consistency Rules")
    ("02_d" "2.4" "Standard Macro Characters")
    ("02_da" "2.4.1" "Left-Parenthesis")
    ("02_db" "2.4.2" "Right-Parenthesis")
    ("02_dc" "2.4.3" "Single-Quote")
    ("02_dca" "2.4.3.1" "Examples of Single-Quote")
    ("02_dd" "2.4.4" "Semicolon")
    ("02_dda" "2.4.4.1" "Examples of Semicolon")
    ("02_ddb" "2.4.4.2" "Notes about Style for Semicolon")
    ("02_ddba" "2.4.4.2.1" "Use of Single Semicolon")
    ("02_ddbb" "2.4.4.2.2" "Use of Double Semicolon")
    ("02_ddbc" "2.4.4.2.3" "Use of Triple Semicolon")
    ("02_ddbd" "2.4.4.2.4" "Use of Quadruple Semicolon")
    ("02_ddbe" "2.4.4.2.5" "Examples of Style for Semicolon")
    ("02_de" "2.4.5" "Double-Quote")
    ("02_df" "2.4.6" "Backquote")
    ("02_dfa" "2.4.6.1" "Notes about Backquote")
    ("02_dg" "2.4.7" "Comma")
    ("02_dh" "2.4.8" "Sharpsign")
    ("02_dha" "2.4.8.1" "Sharpsign Backslash")
    ("02_dhb" "2.4.8.2" "Sharpsign Single-Quote")
    ("02_dhc" "2.4.8.3" "Sharpsign Left-Parenthesis")
    ("02_dhd" "2.4.8.4" "Sharpsign Asterisk")
    ("02_dhda" "2.4.8.4.1" "Examples of Sharpsign Asterisk")
    ("02_dhe" "2.4.8.5" "Sharpsign Colon")
    ("02_dhf" "2.4.8.6" "Sharpsign Dot")
    ("02_dhg" "2.4.8.7" "Sharpsign B")
    ("02_dhh" "2.4.8.8" "Sharpsign O")
    ("02_dhi" "2.4.8.9" "Sharpsign X")
    ("02_dhj" "2.4.8.10" "Sharpsign R")
    ("02_dhk" "2.4.8.11" "Sharpsign C")
    ("02_dhl" "2.4.8.12" "Sharpsign A")
    ("02_dhm" "2.4.8.13" "Sharpsign S")
    ("02_dhn" "2.4.8.14" "Sharpsign P")
    ("02_dho" "2.4.8.15" "Sharpsign Equal-Sign")
    ("02_dhp" "2.4.8.16" "Sharpsign Sharpsign")
    ("02_dhq" "2.4.8.17" "Sharpsign Plus")
    ("02_dhr" "2.4.8.18" "Sharpsign Minus")
    ("02_dhs" "2.4.8.19" "Sharpsign Vertical-Bar")
    ("02_dhsa" "2.4.8.19.1" "Examples of Sharpsign Vertical-Bar")
    ("02_dhsb" "2.4.8.19.2" "Notes about Style for Sharpsign Vertical-Bar")
    ("02_dht" "2.4.8.20" "Sharpsign Less-Than-Sign")
    ("02_dhu" "2.4.8.21" "Sharpsign Whitespace")
    ("02_dhv" "2.4.8.22" "Sharpsign Right-Parenthesis")
    ("02_di" "2.4.9" "Re-Reading Abbreviated Expressions")
    ("03_" "3" "Evaluation and Compilation")
    ("03_a" "3.1" "Evaluation")
    ("03_aa" "3.1.1" "Introduction to Environments")
    ("03_aaa" "3.1.1.1" "The Global Environment")
    ("03_aab" "3.1.1.2" "Dynamic Environments")
    ("03_aac" "3.1.1.3" "Lexical Environments")
    ("03_aaca" "3.1.1.3.1" "The Null Lexical Environment")
    ("03_aad" "3.1.1.4" "Environment Objects")
    ("03_ab" "3.1.2" "The Evaluation Model")
    ("03_aba" "3.1.2.1" "Form Evaluation")
    ("03_abaa" "3.1.2.1.1" "Symbols as Forms")
    ("03_abaaa" "3.1.2.1.1.1" "Lexical Variables")
    ("03_abaab" "3.1.2.1.1.2" "Dynamic Variables")
    ("03_abaac" "3.1.2.1.1.3" "Constant Variables")
    ("03_abaad" "3.1.2.1.1.4"
     "Symbols Naming Both Lexical and Dynamic Variables")
    ("03_abab" "3.1.2.1.2" "Conses as Forms")
    ("03_ababa" "3.1.2.1.2.1" "Special Forms")
    ("03_ababb" "3.1.2.1.2.2" "Macro Forms")
    ("03_ababc" "3.1.2.1.2.3" "Function Forms")
    ("03_ababd" "3.1.2.1.2.4" "Lambda Forms")
    ("03_abac" "3.1.2.1.3" "Self-Evaluating Objects")
    ("03_abaca" "3.1.2.1.3.1" "Examples of Self-Evaluating Objects")
    ("03_ac" "3.1.3" "Lambda Expressions")
    ("03_ad" "3.1.4" "Closures and Lexical Binding")
    ("03_ae" "3.1.5" "Shadowing")
    ("03_af" "3.1.6" "Extent")
    ("03_ag" "3.1.7" "Return Values")
    ("03_b" "3.2" "Compilation")
    ("03_ba" "3.2.1" "Compiler Terminology")
    ("03_bb" "3.2.2" "Compilation Semantics")
    ("03_bba" "3.2.2.1" "Compiler Macros")
    ("03_bbaa" "3.2.2.1.1" "Purpose of Compiler Macros")
    ("03_bbab" "3.2.2.1.2" "Naming of Compiler Macros")
    ("03_bbac" "3.2.2.1.3" "When Compiler Macros Are Used")
    ("03_bbaca" "3.2.2.1.3.1"
     "Notes about the Implementation of Compiler Macros")
    ("03_bbb" "3.2.2.2" "Minimal Compilation")
    ("03_bbc" "3.2.2.3" "Semantic Constraints")
    ("03_bc" "3.2.3" "File Compilation")
    ("03_bca" "3.2.3.1" "Processing of Top Level Forms")
    ("03_bcaa" "3.2.3.1.1" "Processing of Defining Macros")
    ("03_bcab" "3.2.3.1.2" "Constraints on Macros and Compiler Macros")
    ("03_bd" "3.2.4" "Literal Objects in Compiled Files")
    ("03_bda" "3.2.4.1" "Externalizable Objects")
    ("03_bdb" "3.2.4.2" "Similarity of Literal Objects")
    ("03_bdba" "3.2.4.2.1" "Similarity of Aggregate Objects")
    ("03_bdbb" "3.2.4.2.2" "Definition of Similarity")
    ("03_bdc" "3.2.4.3" "Extensions to Similarity Rules")
    ("03_bdd" "3.2.4.4" "Additional Constraints on Externalizable Objects")
    ("03_be" "3.2.5" "Exceptional Situations in the Compiler")
    ("03_c" "3.3" "Declarations")
    ("03_ca" "3.3.1" "Minimal Declaration Processing Requirements")
    ("03_cb" "3.3.2" "Declaration Specifiers")
    ("03_cc" "3.3.3" "Declaration Identifiers")
    ("03_cca" "3.3.3.1" "Shorthand notation for Type Declarations")
    ("03_cd" "3.3.4" "Declaration Scope")
    ("03_cda" "3.3.4.1" "Examples of Declaration Scope")
    ("03_d" "3.4" "Lambda Lists")
    ("03_da" "3.4.1" "Ordinary Lambda Lists")
    ("03_daa" "3.4.1.1" "Specifiers for the required parameters")
    ("03_dab" "3.4.1.2" "Specifiers for optional parameters")
    ("03_dac" "3.4.1.3" "A specifier for a rest parameter")
    ("03_dad" "3.4.1.4" "Specifiers for keyword parameters")
    ("03_dada" "3.4.1.4.1" "Suppressing Keyword Argument Checking")
    ("03_dadaa" "3.4.1.4.1.1"
     "Examples of Suppressing Keyword Argument Checking")
    ("03_dae" "3.4.1.5" "Specifiers for &amp;aux variables")
    ("03_daf" "3.4.1.6" "Examples of Ordinary Lambda Lists")
    ("03_db" "3.4.2" "Generic Function Lambda Lists")
    ("03_dc" "3.4.3" "Specialized Lambda Lists")
    ("03_dd" "3.4.4" "Macro Lambda Lists")
    ("03_dda" "3.4.4.1" "Destructuring by Lambda Lists")
    ("03_ddaa" "3.4.4.1.1" "Data-directed Destructuring by Lambda Lists")
    ("03_ddaaa" "3.4.4.1.1.1"
     "Examples of Data-directed Destructuring by Lambda Lists")
    ("03_ddab" "3.4.4.1.2" "Lambda-list-directed Destructuring by Lambda Lists")
    ("03_de" "3.4.5" "Destructuring Lambda Lists")
    ("03_df" "3.4.6" "Boa Lambda Lists")
    ("03_dg" "3.4.7" "Defsetf Lambda Lists")
    ("03_dh" "3.4.8" "Deftype Lambda Lists")
    ("03_di" "3.4.9" "Define-modify-macro Lambda Lists")
    ("03_dj" "3.4.10" "Define-method-combination Arguments Lambda Lists")
    ("03_dk" "3.4.11"
     "Syntactic Interaction of Documentation Strings and Declarations")
    ("03_e" "3.5" "Error Checking in Function Calls")
    ("03_ea" "3.5.1" "Argument Mismatch Detection")
    ("03_eaa" "3.5.1.1" "Safe and Unsafe Calls")
    ("03_eaaa" "3.5.1.1.1" "Error Detection Time in Safe Calls")
    ("03_eab" "3.5.1.2" "Too Few Arguments")
    ("03_eac" "3.5.1.3" "Too Many Arguments")
    ("03_ead" "3.5.1.4" "Unrecognized Keyword Arguments")
    ("03_eae" "3.5.1.5" "Invalid Keyword Arguments")
    ("03_eaf" "3.5.1.6" "Odd Number of Keyword Arguments")
    ("03_eag" "3.5.1.7" "Destructuring Mismatch")
    ("03_eah" "3.5.1.8" "Errors When Calling a Next Method")
    ("03_f" "3.6" "Traversal Rules and Side Effects")
    ("03_g" "3.7" "Destructive Operations")
    ("03_ga" "3.7.1" "Modification of Literal Objects")
    ("03_gb" "3.7.2" "Transfer of Control during a Destructive Operation")
    ("03_gba" "3.7.2.1"
     "Examples of Transfer of Control during a Destructive Operation")
    ("04_" "4" "Types and Classes")
    ("04_a" "4.1" "Introduction")
    ("04_b" "4.2" "Types")
    ("04_ba" "4.2.1" "Data Type Definition")
    ("04_bb" "4.2.2" "Type Relationships")
    ("04_bc" "4.2.3" "Type Specifiers")
    ("04_c" "4.3" "Classes")
    ("04_ca" "4.3.1" "Introduction to Classes")
    ("04_caa" "4.3.1.1" "Standard Metaclasses")
    ("04_cb" "4.3.2" "Defining Classes")
    ("04_cc" "4.3.3" "Creating Instances of Classes")
    ("04_cd" "4.3.4" "Inheritance")
    ("04_cda" "4.3.4.1" "Examples of Inheritance")
    ("04_cdb" "4.3.4.2" "Inheritance of Class Options")
    ("04_ce" "4.3.5" "Determining the Class Precedence List")
    ("04_cea" "4.3.5.1" "Topological Sorting")
    ("04_ceb" "4.3.5.2" "Examples of Class Precedence List Determination")
    ("04_cf" "4.3.6" "Redefining Classes")
    ("04_cfa" "4.3.6.1" "Modifying the Structure of Instances")
    ("04_cfb" "4.3.6.2" "Initializing Newly Added Local Slots")
    ("04_cfc" "4.3.6.3" "Customizing Class Redefinition")
    ("04_cg" "4.3.7" "Integrating Types and Classes")
    ("05_" "5" "Data and Control Flow")
    ("05_a" "5.1" "Generalized Reference")
    ("05_aa" "5.1.1" "Overview of Places and Generalized Reference")
    ("05_aaa" "5.1.1.1" "Evaluation of Subforms to Places")
    ("05_aaaa" "5.1.1.1.1" "Examples of Evaluation of Subforms to Places")
    ("05_aab" "5.1.1.2" "Setf Expansions")
    ("05_aaba" "5.1.1.2.1" "Examples of Setf Expansions")
    ("05_ab" "5.1.2" "Kinds of Places")
    ("05_aba" "5.1.2.1" "Variable Names as Places")
    ("05_abb" "5.1.2.2" "Function Call Forms as Places")
    ("05_abc" "5.1.2.3" "VALUES Forms as Places")
    ("05_abd" "5.1.2.4" "THE Forms as Places")
    ("05_abe" "5.1.2.5" "APPLY Forms as Places")
    ("05_abf" "5.1.2.6" "Setf Expansions and Places")
    ("05_abg" "5.1.2.7" "Macro Forms as Places")
    ("05_abh" "5.1.2.8" "Symbol Macros as Places")
    ("05_abi" "5.1.2.9" "Other Compound Forms as Places")
    ("05_ac" "5.1.3" "Treatment of Other Macros Based on SETF")
    ("05_b" "5.2" "Transfer of Control to an Exit Point")
    ("06_" "6" "Iteration")
    ("06_a" "6.1" "The LOOP Facility")
    ("06_aa" "6.1.1" "Overview of the Loop Facility")
    ("06_aaa" "6.1.1.1" "Simple vs Extended Loop")
    ("06_aaaa" "6.1.1.1.1" "Simple Loop")
    ("06_aaab" "6.1.1.1.2" "Extended Loop")
    ("06_aab" "6.1.1.2" "Loop Keywords")
    ("06_aac" "6.1.1.3" "Parsing Loop Clauses")
    ("06_aad" "6.1.1.4" "Expanding Loop Forms")
    ("06_aae" "6.1.1.5" "Summary of Loop Clauses")
    ("06_aaea" "6.1.1.5.1"
     "Summary of Variable Initialization and Stepping Clauses")
    ("06_aaeb" "6.1.1.5.2" "Summary of Value Accumulation Clauses")
    ("06_aaec" "6.1.1.5.3" "Summary of Termination Test Clauses")
    ("06_aaed" "6.1.1.5.4" "Summary of Unconditional Execution Clauses")
    ("06_aaee" "6.1.1.5.5" "Summary of Conditional Execution Clauses")
    ("06_aaef" "6.1.1.5.6" "Summary of Miscellaneous Clauses")
    ("06_aaf" "6.1.1.6" "Order of Execution")
    ("06_aag" "6.1.1.7" "Destructuring")
    ("06_aah" "6.1.1.8" "Restrictions on Side-Effects")
    ("06_ab" "6.1.2" "Variable Initialization and Stepping Clauses")
    ("06_aba" "6.1.2.1" "Iteration Control")
    ("06_abaa" "6.1.2.1.1" "The for-as-arithmetic subclause")
    ("06_abaaa" "6.1.2.1.1.1" "Examples of for-as-arithmetic subclause")
    ("06_abab" "6.1.2.1.2" "The for-as-in-list subclause")
    ("06_ababa" "6.1.2.1.2.1" "Examples of for-as-in-list subclause")
    ("06_abac" "6.1.2.1.3" "The for-as-on-list subclause")
    ("06_abaca" "6.1.2.1.3.1" "Examples of for-as-on-list subclause")
    ("06_abad" "6.1.2.1.4" "The for-as-equals-then subclause")
    ("06_abada" "6.1.2.1.4.1" "Examples of for-as-equals-then subclause")
    ("06_abae" "6.1.2.1.5" "The for-as-across subclause")
    ("06_abaea" "6.1.2.1.5.1" "Examples of for-as-across subclause")
    ("06_abaf" "6.1.2.1.6" "The for-as-hash subclause")
    ("06_abag" "6.1.2.1.7" "The for-as-package subclause")
    ("06_abaga" "6.1.2.1.7.1" "Examples of for-as-package subclause")
    ("06_abb" "6.1.2.2" "Local Variable Initializations")
    ("06_abba" "6.1.2.2.1" "Examples of WITH clause")
    ("06_ac" "6.1.3" "Value Accumulation Clauses")
    ("06_aca" "6.1.3.1" "Examples of COLLECT clause")
    ("06_acb" "6.1.3.2" "Examples of APPEND and NCONC clauses")
    ("06_acc" "6.1.3.3" "Examples of COUNT clause")
    ("06_acd" "6.1.3.4" "Examples of MAXIMIZE and MINIMIZE clauses")
    ("06_ace" "6.1.3.5" "Examples of SUM clause")
    ("06_ad" "6.1.4" "Termination Test Clauses")
    ("06_ada" "6.1.4.1" "Examples of REPEAT clause")
    ("06_adb" "6.1.4.2" "Examples of ALWAYS, NEVER, and THEREIS clauses")
    ("06_adc" "6.1.4.3" "Examples of WHILE and UNTIL clauses")
    ("06_ae" "6.1.5" "Unconditional Execution Clauses")
    ("06_aea" "6.1.5.1" "Examples of unconditional execution")
    ("06_af" "6.1.6" "Conditional Execution Clauses")
    ("06_afa" "6.1.6.1" "Examples of WHEN clause")
    ("06_ag" "6.1.7" "Miscellaneous Clauses")
    ("06_aga" "6.1.7.1" "Control Transfer Clauses")
    ("06_agaa" "6.1.7.1.1" "Examples of NAMED clause")
    ("06_agb" "6.1.7.2" "Initial and Final Execution")
    ("06_ah" "6.1.8" "Examples of Miscellaneous Loop Features")
    ("06_aha" "6.1.8.1" "Examples of clause grouping")
    ("06_ai" "6.1.9" "Notes about Loop")
    ("07_" "7" "Objects")
    ("07_a" "7.1" "Object Creation and Initialization")
    ("07_aa" "7.1.1" "Initialization Arguments")
    ("07_ab" "7.1.2" "Declaring the Validity of Initialization Arguments")
    ("07_ac" "7.1.3" "Defaulting of Initialization Arguments")
    ("07_ad" "7.1.4" "Rules for Initialization Arguments")
    ("07_ae" "7.1.5" "Shared-Initialize")
    ("07_af" "7.1.6" "Initialize-Instance")
    ("07_ag" "7.1.7" "Definitions of Make-Instance and Initialize-Instance")
    ("07_b" "7.2" "Changing the Class of an Instance")
    ("07_ba" "7.2.1" "Modifying the Structure of the Instance")
    ("07_bb" "7.2.2" "Initializing Newly Added Local Slots")
    ("07_bc" "7.2.3" "Customizing the Change of Class of an Instance")
    ("07_c" "7.3" "Reinitializing an Instance")
    ("07_ca" "7.3.1" "Customizing Reinitialization")
    ("07_d" "7.4" "Meta-Objects")
    ("07_da" "7.4.1" "Standard Meta-objects")
    ("07_e" "7.5" "Slots")
    ("07_ea" "7.5.1" "Introduction to Slots")
    ("07_eb" "7.5.2" "Accessing Slots")
    ("07_ec" "7.5.3" "Inheritance of Slots and Slot Options")
    ("07_f" "7.6" "Generic Functions and Methods")
    ("07_fa" "7.6.1" "Introduction to Generic Functions")
    ("07_fb" "7.6.2" "Introduction to Methods")
    ("07_fc" "7.6.3" "Agreement on Parameter Specializers and Qualifiers")
    ("07_fd" "7.6.4"
     "Congruent Lambda-lists for all Methods of a Generic Function")
    ("07_fe" "7.6.5" "Keyword Arguments in Generic Functions and Methods")
    ("07_fea" "7.6.5.1"
     "Examples of Keyword Arguments in Generic Functions and Methods")
    ("07_ff" "7.6.6" "Method Selection and Combination")
    ("07_ffa" "7.6.6.1" "Determining the Effective Method")
    ("07_ffaa" "7.6.6.1.1" "Selecting the Applicable Methods")
    ("07_ffab" "7.6.6.1.2" "Sorting the Applicable Methods by Precedence Order")
    ("07_ffac" "7.6.6.1.3"
     "Applying method combination to the sorted list of applicable methods")
    ("07_ffb" "7.6.6.2" "Standard Method Combination")
    ("07_ffc" "7.6.6.3" "Declarative Method Combination")
    ("07_ffd" "7.6.6.4" "Built-in Method Combination Types")
    ("07_fg" "7.6.7" "Inheritance of Methods")
    ("08_" "8" "Structures")
    ("09_" "9" "Conditions")
    ("09_a" "9.1" "Condition System Concepts")
    ("09_aa" "9.1.1" "Condition Types")
    ("09_aaa" "9.1.1.1" "Serious Conditions")
    ("09_ab" "9.1.2" "Creating Conditions")
    ("09_aba" "9.1.2.1" "Condition Designators")
    ("09_ac" "9.1.3" "Printing Conditions")
    ("09_aca" "9.1.3.1" "Recommended Style in Condition Reporting")
    ("09_acaa" "9.1.3.1.1"
     "Capitalization and Punctuation in Condition Reports")
    ("09_acab" "9.1.3.1.2" "Leading and Trailing Newlines in Condition Reports")
    ("09_acac" "9.1.3.1.3" "Embedded Newlines in Condition Reports")
    ("09_acad" "9.1.3.1.4" "Note about Tabs in Condition Reports")
    ("09_acae" "9.1.3.1.5"
     "Mentioning Containing Function in Condition Reports")
    ("09_ad" "9.1.4" "Signaling and Handling Conditions")
    ("09_ada" "9.1.4.1" "Signaling")
    ("09_adaa" "9.1.4.1.1" "Resignaling a Condition")
    ("09_adb" "9.1.4.2" "Restarts")
    ("09_adba" "9.1.4.2.1" "Interactive Use of Restarts")
    ("09_adbb" "9.1.4.2.2" "Interfaces to Restarts")
    ("09_adbc" "9.1.4.2.3" "Restart Tests")
    ("09_adbd" "9.1.4.2.4" "Associating a Restart with a Condition")
    ("09_ae" "9.1.5" "Assertions")
    ("09_af" "9.1.6" "Notes about the Condition System's Background")
    ("10_" "10" "Symbols")
    ("10_a" "10.1" "Symbol Concepts")
    ("11_" "11" "Packages")
    ("11_a" "11.1" "Package Concepts")
    ("11_aa" "11.1.1" "Introduction to Packages")
    ("11_aaa" "11.1.1.1" "Package Names and Nicknames")
    ("11_aab" "11.1.1.2" "Symbols in a Package")
    ("11_aaba" "11.1.1.2.1" "Internal and External Symbols")
    ("11_aabb" "11.1.1.2.2" "Package Inheritance")
    ("11_aabc" "11.1.1.2.3" "Accessibility of Symbols in a Package")
    ("11_aabd" "11.1.1.2.4" "Locating a Symbol in a Package")
    ("11_aabe" "11.1.1.2.5" "Prevention of Name Conflicts in Packages")
    ("11_ab" "11.1.2" "Standardized Packages")
    ("11_aba" "11.1.2.1" "The COMMON-LISP Package")
    ("11_abaa" "11.1.2.1.1"
     "Constraints on the COMMON-LISP Package for Conforming Implementations")
    ("11_abab" "11.1.2.1.2"
     "Constraints on the COMMON-LISP Package for Conforming Programs")
    ("11_ababa" "11.1.2.1.2.1"
     "Some Exceptions to Constraints on the COMMON-LISP Package for Conforming Programs")
    ("11_abb" "11.1.2.2" "The COMMON-LISP-USER Package")
    ("11_abc" "11.1.2.3" "The KEYWORD Package")
    ("11_abca" "11.1.2.3.1" "Interning a Symbol in the KEYWORD Package")
    ("11_abcb" "11.1.2.3.2" "Notes about The KEYWORD Package")
    ("11_abd" "11.1.2.4" "Implementation-Defined Packages")
    ("12_" "12" "Numbers")
    ("12_a" "12.1" "Number Concepts")
    ("12_aa" "12.1.1" "Numeric Operations")
    ("12_aaa" "12.1.1.1"
     "Associativity and Commutativity in Numeric Operations")
    ("12_aaaa" "12.1.1.1.1"
     "Examples of Associativity and Commutativity in Numeric Operations")
    ("12_aab" "12.1.1.2" "Contagion in Numeric Operations")
    ("12_aac" "12.1.1.3" "Viewing Integers as Bits and Bytes")
    ("12_aaca" "12.1.1.3.1" "Logical Operations on Integers")
    ("12_aacb" "12.1.1.3.2" "Byte Operations on Integers")
    ("12_ab" "12.1.2" "Implementation-Dependent Numeric Constants")
    ("12_ac" "12.1.3" "Rational Computations")
    ("12_aca" "12.1.3.1" "Rule of Unbounded Rational Precision")
    ("12_acb" "12.1.3.2" "Rule of Canonical Representation for Rationals")
    ("12_acc" "12.1.3.3" "Rule of Float Substitutability")
    ("12_ad" "12.1.4" "Floating-point Computations")
    ("12_ada" "12.1.4.1" "Rule of Float and Rational Contagion")
    ("12_adaa" "12.1.4.1.1" "Examples of Rule of Float and Rational Contagion")
    ("12_adb" "12.1.4.2" "Rule of Float Approximation")
    ("12_adc" "12.1.4.3" "Rule of Float Underflow and Overflow")
    ("12_add" "12.1.4.4" "Rule of Float Precision Contagion")
    ("12_ae" "12.1.5" "Complex Computations")
    ("12_aea" "12.1.5.1" "Rule of Complex Substitutability")
    ("12_aeb" "12.1.5.2" "Rule of Complex Contagion")
    ("12_aec" "12.1.5.3"
     "Rule of Canonical Representation for Complex Rationals")
    ("12_aeca" "12.1.5.3.1"
     "Examples of Rule of Canonical Representation for Complex Rationals")
    ("12_aed" "12.1.5.4" "Principal Values and Branch Cuts")
    ("12_af" "12.1.6" "Interval Designators")
    ("12_ag" "12.1.7" "Random-State Operations")
    ("13_" "13" "Characters")
    ("13_a" "13.1" "Character Concepts")
    ("13_aa" "13.1.1" "Introduction to Characters")
    ("13_ab" "13.1.2" "Introduction to Scripts and Repertoires")
    ("13_aba" "13.1.2.1" "Character Scripts")
    ("13_abb" "13.1.2.2" "Character Repertoires")
    ("13_ac" "13.1.3" "Character Attributes")
    ("13_ad" "13.1.4" "Character Categories")
    ("13_ada" "13.1.4.1" "Graphic Characters")
    ("13_adb" "13.1.4.2" "Alphabetic Characters")
    ("13_adc" "13.1.4.3" "Characters With Case")
    ("13_adca" "13.1.4.3.1" "Uppercase Characters")
    ("13_adcb" "13.1.4.3.2" "Lowercase Characters")
    ("13_adcc" "13.1.4.3.3" "Corresponding Characters in the Other Case")
    ("13_adcd" "13.1.4.3.4" "Case of Implementation-Defined Characters")
    ("13_add" "13.1.4.4" "Numeric Characters")
    ("13_ade" "13.1.4.5" "Alphanumeric Characters")
    ("13_adf" "13.1.4.6" "Digits in a Radix")
    ("13_ae" "13.1.5" "Identity of Characters")
    ("13_af" "13.1.6" "Ordering of Characters")
    ("13_ag" "13.1.7" "Character Names")
    ("13_ah" "13.1.8" "Treatment of Newline during Input and Output")
    ("13_ai" "13.1.9" "Character Encodings")
    ("13_aj" "13.1.10" "Documentation of Implementation-Defined Scripts")
    ("14_" "14" "Conses")
    ("14_a" "14.1" "Cons Concepts")
    ("14_aa" "14.1.1" "Conses as Trees")
    ("14_aaa" "14.1.1.1"
     "General Restrictions on Parameters that must be Trees")
    ("14_ab" "14.1.2" "Conses as Lists")
    ("14_aba" "14.1.2.1" "Lists as Association Lists")
    ("14_abb" "14.1.2.2" "Lists as Sets")
    ("14_abc" "14.1.2.3"
     "General Restrictions on Parameters that must be Lists")
    ("15_" "15" "Arrays")
    ("15_a" "15.1" "Array Concepts")
    ("15_aa" "15.1.1" "Array Elements")
    ("15_aaa" "15.1.1.1" "Array Indices")
    ("15_aab" "15.1.1.2" "Array Dimensions")
    ("15_aaba" "15.1.1.2.1"
     "Implementation Limits on Individual Array Dimensions")
    ("15_aac" "15.1.1.3" "Array Rank")
    ("15_aaca" "15.1.1.3.1" "Vectors")
    ("15_aacaa" "15.1.1.3.1.1" "Fill Pointers")
    ("15_aacb" "15.1.1.3.2" "Multidimensional Arrays")
    ("15_aacba" "15.1.1.3.2.1" "Storage Layout for Multidimensional Arrays")
    ("15_aacbb" "15.1.1.3.2.2" "Implementation Limits on Array Rank")
    ("15_ab" "15.1.2" "Specialized Arrays")
    ("15_aba" "15.1.2.1" "Array Upgrading")
    ("15_abb" "15.1.2.2" "Required Kinds of Specialized Arrays")
    ("16_" "16" "Strings")
    ("16_a" "16.1" "String Concepts")
    ("16_aa" "16.1.1" "Implications of Strings Being Arrays")
    ("16_ab" "16.1.2" "Subtypes of STRING")
    ("17_" "17" "Sequences")
    ("17_a" "17.1" "Sequence Concepts")
    ("17_aa" "17.1.1"
     "General Restrictions on Parameters that must be Sequences")
    ("17_b" "17.2" "Rules about Test Functions")
    ("17_ba" "17.2.1" "Satisfying a Two-Argument Test")
    ("17_baa" "17.2.1.1" "Examples of Satisfying a Two-Argument Test")
    ("17_bb" "17.2.2" "Satisfying a One-Argument Test")
    ("17_bba" "17.2.2.1" "Examples of Satisfying a One-Argument Test")
    ("18_" "18" "Hash Tables")
    ("18_a" "18.1" "Hash Table Concepts")
    ("18_aa" "18.1.1" "Hash-Table Operations")
    ("18_ab" "18.1.2" "Modifying Hash Table Keys")
    ("18_aba" "18.1.2.1"
     "Visible Modification of Objects with respect to EQ and EQL")
    ("18_abb" "18.1.2.2"
     "Visible Modification of Objects with respect to EQUAL")
    ("18_abba" "18.1.2.2.1"
     "Visible Modification of Conses with respect to EQUAL")
    ("18_abbb" "18.1.2.2.2"
     "Visible Modification of Bit Vectors and Strings with respect to EQUAL")
    ("18_abc" "18.1.2.3"
     "Visible Modification of Objects with respect to EQUALP")
    ("18_abca" "18.1.2.3.1"
     "Visible Modification of Structures with respect to EQUALP")
    ("18_abcb" "18.1.2.3.2"
     "Visible Modification of Arrays with respect to EQUALP")
    ("18_abcc" "18.1.2.3.3"
     "Visible Modification of Hash Tables with respect to EQUALP")
    ("18_abd" "18.1.2.4" "Visible Modifications by Language Extensions")
    ("19_" "19" "Filenames")
    ("19_a" "19.1" "Overview of Filenames")
    ("19_aa" "19.1.1" "Namestrings as Filenames")
    ("19_ab" "19.1.2" "Pathnames as Filenames")
    ("19_ac" "19.1.3" "Parsing Namestrings Into Pathnames")
    ("19_b" "19.2" "Pathnames")
    ("19_ba" "19.2.1" "Pathname Components")
    ("19_baa" "19.2.1.1" "The Pathname Host Component")
    ("19_bab" "19.2.1.2" "The Pathname Device Component")
    ("19_bac" "19.2.1.3" "The Pathname Directory Component")
    ("19_bad" "19.2.1.4" "The Pathname Name Component")
    ("19_bae" "19.2.1.5" "The Pathname Type Component")
    ("19_baf" "19.2.1.6" "The Pathname Version Component")
    ("19_bb" "19.2.2" "Interpreting Pathname Component Values")
    ("19_bba" "19.2.2.1" "Strings in Component Values")
    ("19_bbaa" "19.2.2.1.1" "Special Characters in Pathname Components")
    ("19_bbab" "19.2.2.1.2" "Case in Pathname Components")
    ("19_bbaba" "19.2.2.1.2.1" "Local Case in Pathname Components")
    ("19_bbabb" "19.2.2.1.2.2" "Common Case in Pathname Components")
    ("19_bbb" "19.2.2.2" "Special Pathname Component Values")
    ("19_bbba" "19.2.2.2.1" "NIL as a Component Value")
    ("19_bbbb" "19.2.2.2.2" ":WILD as a Component Value")
    ("19_bbbc" "19.2.2.2.3" ":UNSPECIFIC as a Component Value")
    ("19_bbbca" "19.2.2.2.3.1"
     "Relation between component values NIL and :UNSPECIFIC")
    ("19_bbc" "19.2.2.3" "Restrictions on Wildcard Pathnames")
    ("19_bbd" "19.2.2.4" "Restrictions on Examining Pathname Components")
    ("19_bbda" "19.2.2.4.1"
     "Restrictions on Examining a Pathname Host Component")
    ("19_bbdb" "19.2.2.4.2"
     "Restrictions on Examining a Pathname Device Component")
    ("19_bbdc" "19.2.2.4.3"
     "Restrictions on Examining a Pathname Directory Component")
    ("19_bbdca" "19.2.2.4.3.1"
     "Directory Components in Non-Hierarchical File Systems")
    ("19_bbdd" "19.2.2.4.4"
     "Restrictions on Examining a Pathname Name Component")
    ("19_bbde" "19.2.2.4.5"
     "Restrictions on Examining a Pathname Type Component")
    ("19_bbdf" "19.2.2.4.6"
     "Restrictions on Examining a Pathname Version Component")
    ("19_bbdg" "19.2.2.4.7" "Notes about the Pathname Version Component")
    ("19_bbe" "19.2.2.5" "Restrictions on Constructing Pathnames")
    ("19_bc" "19.2.3" "Merging Pathnames")
    ("19_bca" "19.2.3.1" "Examples of Merging Pathnames")
    ("19_c" "19.3" "Logical Pathnames")
    ("19_ca" "19.3.1" "Syntax of Logical Pathname Namestrings")
    ("19_caa" "19.3.1.1"
     "Additional Information about Parsing Logical Pathname Namestrings")
    ("19_caaa" "19.3.1.1.1" "The Host part of a Logical Pathname Namestring")
    ("19_caab" "19.3.1.1.2" "The Device part of a Logical Pathname Namestring")
    ("19_caac" "19.3.1.1.3"
     "The Directory part of a Logical Pathname Namestring")
    ("19_caad" "19.3.1.1.4" "The Type part of a Logical Pathname Namestring")
    ("19_caae" "19.3.1.1.5" "The Version part of a Logical Pathname Namestring")
    ("19_caaf" "19.3.1.1.6" "Wildcard Words in a Logical Pathname Namestring")
    ("19_caag" "19.3.1.1.7"
     "Lowercase Letters in a Logical Pathname Namestring")
    ("19_caah" "19.3.1.1.8" "Other Syntax in a Logical Pathname Namestring")
    ("19_cb" "19.3.2" "Logical Pathname Components")
    ("19_cba" "19.3.2.1" "Unspecific Components of a Logical Pathname")
    ("19_cbb" "19.3.2.2" "Null Strings as Components of a Logical Pathname")
    ("20_" "20" "Files")
    ("20_a" "20.1" "File System Concepts")
    ("20_aa" "20.1.1" "Coercion of Streams to Pathnames")
    ("20_ab" "20.1.2" "File Operations on Open and Closed Streams")
    ("20_ac" "20.1.3" "Truenames")
    ("20_aca" "20.1.3.1" "Examples of Truenames")
    ("21_" "21" "Streams")
    ("21_a" "21.1" "Stream Concepts")
    ("21_aa" "21.1.1" "Introduction to Streams")
    ("21_aaa" "21.1.1.1" "Abstract Classifications of Streams")
    ("21_aaaa" "21.1.1.1.1" "Input, Output, and Bidirectional Streams")
    ("21_aaab" "21.1.1.1.2" "Open and Closed Streams")
    ("21_aaac" "21.1.1.1.3" "Interactive Streams")
    ("21_aab" "21.1.1.2" "Abstract Classifications of Streams")
    ("21_aaba" "21.1.1.2.1" "File Streams")
    ("21_aac" "21.1.1.3" "Other Subclasses of Stream")
    ("21_ab" "21.1.2" "Stream Variables")
    ("21_ac" "21.1.3" "Stream Arguments to Standardized Functions")
    ("21_ad" "21.1.4" "Restrictions on Composite Streams")
    ("22_" "22" "Printer")
    ("22_a" "22.1" "The Lisp Printer")
    ("22_aa" "22.1.1" "Overview of The Lisp Printer")
    ("22_aaa" "22.1.1.1" "Multiple Possible Textual Representations")
    ("22_aaaa" "22.1.1.1.1" "Printer Escaping")
    ("22_ab" "22.1.2" "Printer Dispatching")
    ("22_ac" "22.1.3" "Default Print-Object Methods")
    ("22_aca" "22.1.3.1" "Printing Numbers")
    ("22_acaa" "22.1.3.1.1" "Printing Integers")
    ("22_acab" "22.1.3.1.2" "Printing Ratios")
    ("22_acac" "22.1.3.1.3" "Printing Floats")
    ("22_acad" "22.1.3.1.4" "Printing Complexes")
    ("22_acae" "22.1.3.1.5" "Note about Printing Numbers")
    ("22_acb" "22.1.3.2" "Printing Characters")
    ("22_acc" "22.1.3.3" "Printing Symbols")
    ("22_acca" "22.1.3.3.1" "Package Prefixes for Symbols")
    ("22_accb" "22.1.3.3.2" "Effect of Readtable Case on the Lisp Printer")
    ("22_accba" "22.1.3.3.2.1"
     "Examples of Effect of Readtable Case on the Lisp Printer")
    ("22_acd" "22.1.3.4" "Printing Strings")
    ("22_ace" "22.1.3.5" "Printing Lists and Conses")
    ("22_acf" "22.1.3.6" "Printing Bit Vectors")
    ("22_acg" "22.1.3.7" "Printing Other Vectors")
    ("22_ach" "22.1.3.8" "Printing Other Arrays")
    ("22_aci" "22.1.3.9" "Examples of Printing Arrays")
    ("22_acj" "22.1.3.10" "Printing Random States")
    ("22_ack" "22.1.3.11" "Printing Pathnames")
    ("22_acl" "22.1.3.12" "Printing Structures")
    ("22_acm" "22.1.3.13" "Printing Other Objects")
    ("22_ad" "22.1.4" "Examples of Printer Behavior")
    ("22_b" "22.2" "The Lisp Pretty Printer")
    ("22_ba" "22.2.1" "Pretty Printer Concepts")
    ("22_baa" "22.2.1.1" "Dynamic Control of the Arrangement of Output")
    ("22_bab" "22.2.1.2" "Format Directive Interface")
    ("22_bac" "22.2.1.3" "Compiling Format Strings")
    ("22_bad" "22.2.1.4" "Pretty Print Dispatch Tables")
    ("22_bae" "22.2.1.5" "Pretty Printer Margins")
    ("22_bb" "22.2.2" "Examples of using the Pretty Printer")
    ("22_bc" "22.2.3" "Notes about the Pretty Printer's Background")
    ("22_c" "22.3" "Formatted Output")
    ("22_ca" "22.3.1" "FORMAT Basic Output")
    ("22_caa" "22.3.1.1" "Tilde C: Character")
    ("22_cab" "22.3.1.2" "Tilde Percent: Newline")
    ("22_cac" "22.3.1.3" "Tilde Ampersand: Fresh-Line")
    ("22_cad" "22.3.1.4" "Tilde Vertical-Bar: Page")
    ("22_cae" "22.3.1.5" "Tilde Tilde: Tilde")
    ("22_cb" "22.3.2" "FORMAT Radix Control")
    ("22_cba" "22.3.2.1" "Tilde R: Radix")
    ("22_cbb" "22.3.2.2" "Tilde D: Decimal")
    ("22_cbc" "22.3.2.3" "Tilde B: Binary")
    ("22_cbd" "22.3.2.4" "Tilde O: Octal")
    ("22_cbe" "22.3.2.5" "Tilde X: Hexadecimal")
    ("22_cc" "22.3.3" "FORMAT Floating-Point Printers")
    ("22_cca" "22.3.3.1" "Tilde F: Fixed-Format Floating-Point")
    ("22_ccb" "22.3.3.2" "Tilde E: Exponential Floating-Point")
    ("22_ccc" "22.3.3.3" "Tilde G: General Floating-Point")
    ("22_ccd" "22.3.3.4" "Tilde Dollarsign: Monetary Floating-Point")
    ("22_cd" "22.3.4" "FORMAT Printer Operations")
    ("22_cda" "22.3.4.1" "Tilde A: Aesthetic")
    ("22_cdb" "22.3.4.2" "Tilde S: Standard")
    ("22_cdc" "22.3.4.3" "Tilde W: Write")
    ("22_ce" "22.3.5" "FORMAT Pretty Printer Operations")
    ("22_cea" "22.3.5.1" "Tilde Underscore: Conditional Newline")
    ("22_ceb" "22.3.5.2" "Tilde Less-Than-Sign: Logical Block")
    ("22_cec" "22.3.5.3" "Tilde I: Indent")
    ("22_ced" "22.3.5.4" "Tilde Slash: Call Function")
    ("22_cf" "22.3.6" "FORMAT Layout Control")
    ("22_cfa" "22.3.6.1" "Tilde T: Tabulate")
    ("22_cfb" "22.3.6.2" "Tilde Less-Than-Sign: Justification")
    ("22_cfc" "22.3.6.3" "Tilde Greater-Than-Sign: End of Justification")
    ("22_cg" "22.3.7" "FORMAT Control-Flow Operations")
    ("22_cga" "22.3.7.1" "Tilde Asterisk: Go-To")
    ("22_cgb" "22.3.7.2" "Tilde Left-Bracket: Conditional Expression")
    ("22_cgc" "22.3.7.3" "Tilde Right-Bracket: End of Conditional Expression")
    ("22_cgd" "22.3.7.4" "Tilde Left-Brace: Iteration")
    ("22_cge" "22.3.7.5" "Tilde Right-Brace: End of Iteration")
    ("22_cgf" "22.3.7.6" "Tilde Question-Mark: Recursive Processing")
    ("22_ch" "22.3.8" "FORMAT Miscellaneous Operations")
    ("22_cha" "22.3.8.1" "Tilde Left-Paren: Case Conversion")
    ("22_chb" "22.3.8.2" "Tilde Right-Paren: End of Case Conversion")
    ("22_chc" "22.3.8.3" "Tilde P: Plural")
    ("22_ci" "22.3.9" "FORMAT Miscellaneous Pseudo-Operations")
    ("22_cia" "22.3.9.1" "Tilde Semicolon: Clause Separator")
    ("22_cib" "22.3.9.2" "Tilde Circumflex: Escape Upward")
    ("22_cic" "22.3.9.3" "Tilde Newline: Ignored Newline")
    ("22_cj" "22.3.10" "Additional Information about FORMAT Operations")
    ("22_cja" "22.3.10.1" "Nesting of FORMAT Operations")
    ("22_cjb" "22.3.10.2" "Missing and Additional FORMAT Arguments")
    ("22_cjc" "22.3.10.3" "Additional FORMAT Parameters")
    ("22_cjd" "22.3.10.4" "Undefined FORMAT Modifier Combinations")
    ("22_ck" "22.3.11" "Examples of FORMAT")
    ("22_cl" "22.3.12" "Notes about FORMAT")
    ("23_" "23" "Reader")
    ("23_a" "23.1" "Reader Concepts")
    ("23_aa" "23.1.1" "Dynamic Control of the Lisp Reader")
    ("23_ab" "23.1.2" "Effect of Readtable Case on the Lisp Reader")
    ("23_aba" "23.1.2.1"
     "Examples of Effect of Readtable Case on the Lisp Reader")
    ("23_ac" "23.1.3" "Argument Conventions of Some Reader Functions")
    ("23_aca" "23.1.3.1" "The EOF-ERROR-P argument")
    ("23_acb" "23.1.3.2" "The RECURSIVE-P argument")
    ("24_" "24" "System Construction")
    ("24_a" "24.1" "System Construction Concepts")
    ("24_aa" "24.1.1" "Loading")
    ("24_ab" "24.1.2" "Features")
    ("24_aba" "24.1.2.1" "Feature Expressions")
    ("24_abaa" "24.1.2.1.1" "Examples of Feature Expressions")
    ("25_" "25" "Environment")
    ("25_a" "25.1" "The External Environment")
    ("25_aa" "25.1.1" "Top level loop")
    ("25_ab" "25.1.2" "Debugging Utilities")
    ("25_ac" "25.1.3" "Environment Inquiry")
    ("25_ad" "25.1.4" "Time")
    ("25_ada" "25.1.4.1" "Decoded Time")
    ("25_adb" "25.1.4.2" "Universal Time")
    ("25_adc" "25.1.4.3" "Internal Time")
    ("25_add" "25.1.4.4" "Seconds")
    ("26_" "26" "Glossary")
    ("26_a" "26.1" "Glossary")
    ("27_" "A" "Appendix")
    ("27_a" "A.1" "Removed Language Features")
    ("27_aa" "A.1.1" "Requirements for removed and deprecated features")
    ("27_ab" "A.1.2" "Removed Types")
    ("27_ac" "A.1.3" "Removed Operators")
    ("27_ad" "A.1.4" "Removed Argument Conventions")
    ("27_ae" "A.1.5" "Removed Variables")
    ("27_af" "A.1.6" "Removed Reader Syntax")
    ("27_ag" "A.1.7" "Packages No Longer Required")))

(defun parse-hyperspec-section-number (section-number)
  (declare (type (or string null) section-number))
  (let ((list (uiop/utility:split-string section-number :separator '(#\.))))
    (mapcar (lambda (x)
              (cond ((null x) 0)
                    ((equal x "A") 999999)
                    (t (parse-integer x))))
            list)))

(defun hyperspec-section-number< (sn1 sn2)
  (let ((sn1 (parse-hyperspec-section-number sn1))
        (sn2 (parse-hyperspec-section-number sn2)))
    (or (< (length sn1) (length sn2))
        (and (= (length sn1) (length sn2))
             (loop for c1 in sn1
                   for c2 in sn2
                   when (/= c1 c2)
                     do (return (< c1 c2)))))))

;;; A breadth-first listing of sections.
(defparameter *sorted-hyperspec-sections*
  (sort (copy-seq *hyperspec-sections*) #'hyperspec-section-number<
        :key #'second))

(defun make-hyperspec-section-map ()
  (let ((ht (make-hash-table :test #'equal)))
    (loop for entry in *hyperspec-sections*
          do (destructuring-bind (filename id title) entry
               (declare (ignore title))
               (let ((value (list id filename)))
                 (setf (gethash id ht) value)
                 (setf (gethash filename ht) value))))
    (loop for entry in *hyperspec-definitions*
          do (destructuring-bind (symbol locative filename) entry
               (declare (ignore symbol locative))
               (setf (gethash filename ht) (list filename filename))))
    (loop for entry in *hyperspec-disambiguations*
          do (destructuring-bind (symbol filename) entry
               (declare (ignore symbol))
               (setf (gethash filename ht) (list filename filename))))
    ht))

(defparameter *hyperspec-section-map* (make-hyperspec-section-map))

;;; Return the first section in *SORTED-HYPERSPEC-SECTIONS* whose
;;; title contains STRING.
(defun find-hyperspec-section (string)
  (find-if (lambda (entry)
             (search (string-downcase string)
                     (string-downcase (third entry))))
           *sorted-hyperspec-sections*))

(defun/autoloaded find-hyperspec-section-id (string &key (substring-match t))
  (let ((string (normalize-whitespace string)))
    (or (first (gethash string *hyperspec-section-map*))
        (second (and substring-match (find-hyperspec-section string))))))

(defun/autoloaded find-hyperspec-section-url
    (string hyperspec-root &key (substring-match t))
  (let* ((string (normalize-whitespace string))
         (filename (or (second (gethash string *hyperspec-section-map*))
                       (first (and substring-match
                                   (find-hyperspec-section string))))))
    (when filename
      (hyperspec-link hyperspec-root "Body/" filename ".htm"))))

;;; Replace consecutive WHITESPACEP characters with a single space,
;;; and trim whitespace from the right.
(defun normalize-whitespace (title)
  (with-output-to-string (out)
    (let ((prev-whitespace-p nil))
      (loop for char across title
            do (let ((whitespacep (whitespacep char)))
                 ;; Nothing to do for whitespace chars until followed
                 ;; by a non-whitespace char.
                 (unless whitespacep
                   (when prev-whitespace-p
                     (write-char #\Space out))
                   (write-char char out))
                 (setq prev-whitespace-p whitespacep))))))


;;;; Low-level interface to Hyperspec glossary entries

(defparameter *hyperspec-glossary-entries*
  ;; TITLE
  '("()"
    "absolute" "absolute" "access" "accessibility" "accessible" "accessor"
    "active" "actual adjustability" "actual argument"
    "actual array element type" "actual complex part type" "actual parameter"
    "actually adjustable" "adjustability" "adjustable" "after method" "alist"
    "alphabetic" "alphanumeric" "ampersand" "anonymous"
    "apparently uninterned" "applicable" "applicable handler"
    "applicable method" "applicable restart" "apply" "argument"
    "argument evaluation order" "argument precedence order" "around method"
    "array" "array element type" "array total size" "assign"
    "association list" "asterisk" "at-sign" "atom" "atomic"
    "atomic type specifier" "attribute" "aux variable" "auxiliary method"
    "backquote" "backslash" "base character" "base string" "before method"
    "bidirectional" "binary" "bind" "binding" "bit" "bit array" "bit vector"
    "bit-wise logical operation specifier" "block" "block tag"
    "boa lambda list" "body parameter" "boolean" "boolean equivalent" "bound"
    "bound declaration" "bounded" "bounding index"
    "bounding index designator" "break loop" "broadcast stream"
    "built-in class" "built-in type" "byte" "byte specifier"
    "cadr" "call" "captured initialization form" "car" "case"
    "case sensitivity mode" "catch" "catch tag" "cddr" "cdr" "cell"
    "character" "character code" "character designator" "circular"
    "circular list" "class" "class designator" "class precedence list"
    "close" "closed" "closure" "coalesce" "code" "coerce" "colon" "comma"
    "compilation" "compilation environment" "compilation unit" "compile"
    "compile time" "compile-time definition" "compiled code" "compiled file"
    "compiled function" "compiler" "compiler macro"
    "compiler macro expansion" "compiler macro form"
    "compiler macro function" "complex" "complex float" "complex part type"
    "complex rational" "complex single float" "composite stream"
    "compound form" "compound type specifier" "concatenated stream"
    "condition" "condition designator" "condition handler"
    "condition reporter" "conditional newline" "conformance"
    "conforming code" "conforming implementation" "conforming processor"
    "conforming program" "congruent" "cons" "constant" "constant form"
    "constant object" "constant variable" "constituent" "constituent trait"
    "constructed stream" "contagion" "continuable" "control form" "copy"
    "correctable" "current input base" "current logical block"
    "current output base" "current package" "current pprint dispatch table"
    "current random state" "current readtable"
    "data type" "debug I/O" "debugger" "declaration" "declaration identifier"
    "declaration specifier" "declare" "decline" "decoded time"
    "default method" "defaulted initialization argument list"
    "define-method-combination arguments lambda list"
    "define-modify-macro lambda list" "defined name" "defining form"
    "defsetf lambda list" "deftype lambda list" "denormalized"
    "derived type" "derived type specifier" "designator" "destructive"
    "destructuring lambda list" "different" "digit" "dimension"
    "direct instance" "direct subclass" "direct superclass" "disestablish"
    "disjoint" "dispatching macro character" "displaced array" "distinct"
    "documentation string" "dot" "dotted list" "dotted pair" "double float"
    "double-quote" "dynamic binding" "dynamic environment" "dynamic extent"
    "dynamic scope" "dynamic variable"
    "echo stream" "effective method" "element" "element type" "em"
    "empty list" "empty type" "end of file" "environment"
    "environment object" "environment parameter" "error" "error output"
    "escape" "establish" "evaluate" "evaluation" "evaluation environment"
    "execute" "execution time" "exhaustive partition" "exhaustive union"
    "exit point" "explicit return" "explicit use" "exponent marker" "export"
    "exported" "expressed adjustability" "expressed array element type"
    "expressed complex part type" "expression" "expressly adjustable"
    "extended character" "extended function designator"
    "extended lambda list" "extension" "extent" "external file format"
    "external file format designator" "external symbol"
    "externalizable object"
    "false" "fbound" "feature" "feature expression" "features list" "file"
    "file compiler" "file position" "file position designator" "file stream"
    "file system" "filename" "fill pointer" "finite" "fixnum" "float"
    "for-value" "form" "formal argument" "formal parameter" "format"
    "format argument" "format control" "format directive" "format string"
    "free declaration" "fresh" "freshline" "funbound" "function"
    "function block name" "function cell" "function designator"
    "function form" "function name" "functional evaluation"
    "functional value" "further compilation"
    "general" "generalized boolean" "generalized instance"
    "generalized reference" "generalized synonym stream" "generic function"
    "generic function lambda list" "gensym" "global declaration"
    "global environment" "global variable" "glyph" "go" "go point" "go tag"
    "graphic"
    "handle" "handler" "hash table" "home package"
    "I/O customization variable" "identical" "identifier" "immutable"
    "implementation" "implementation limit" "implementation-defined"
    "implementation-dependent" "implementation-independent" "implicit block"
    "implicit compilation" "implicit progn" "implicit tagbody" "import"
    "improper list" "inaccessible" "indefinite extent" "indefinite scope"
    "indicator" "indirect instance" "inherit" "initial pprint dispatch table"
    "initial readtable" "initialization argument list" "initialization form"
    "input" "instance" "integer" "interactive stream" "intern"
    "internal symbol" "internal time" "internal time unit" "interned"
    "interpreted function" "interpreted implementation" "interval designator"
    "invalid" "iteration form" "iteration variable"
    "key" "keyword" "keyword parameter" "keyword/value pair"
    "lambda combination" "lambda expression" "lambda form" "lambda list"
    "lambda list keyword" "lambda variable" "leaf" "leap seconds"
    "left-parenthesis" "length" "lexical binding" "lexical closure"
    "lexical environment" "lexical scope" "lexical variable" "Lisp image"
    "Lisp printer" "Lisp read-eval-print loop" "Lisp reader" "list"
    "list designator" "list structure" "literal" "load" "load time"
    "load time value" "loader" "local declaration" "local precedence order"
    "local slot" "logical block" "logical host" "logical host designator"
    "logical pathname" "long float" "loop keyword" "lowercase"
    "macro" "macro character" "macro expansion" "macro form" "macro function"
    "macro lambda list" "macro name" "macroexpand hook" "mapping" "metaclass"
    "Metaobject Protocol" "method" "method combination" "method-defining form"
    "method-defining operator" "minimal compilation" "modified lambda list"
    "most recent" "multiple escape" "multiple values"
    "name" "named constant" "namespace" "namestring" "newline" "next method"
    "nickname" "nil" "non-atomic" "non-constant variable" "non-correctable"
    "non-empty" "non-generic function" "non-graphic" "non-list"
    "non-local exit" "non-nil" "non-null lexical environment" "non-simple"
    "non-terminating" "non-top-level form" "normal return" "normalized"
    "null" "null lexical environment" "number" "numeric"
    "object" "object-traversing" "open" "operator" "optimize quality"
    "optional parameter" "ordinary function" "ordinary lambda list"
    "otherwise inaccessible part" "output"
    "package" "package cell" "package designator" "package marker"
    "package prefix" "package registry" "pairwise" "parallel" "parameter"
    "parameter specializer" "parameter specializer name" "pathname"
    "pathname designator" "physical pathname" "place" "plist" "portable"
    "potential copy" "potential number" "pprint dispatch table" "predicate"
    "present" "pretty print" "pretty printer" "pretty printing stream"
    "primary method" "primary value" "principal" "print name"
    "printer control variable" "printer escaping" "printing" "process"
    "processor" "proclaim" "proclamation" "prog tag" "program" "programmer"
    "programmer code" "proper list" "proper name" "proper sequence"
    "proper subtype" "property" "property indicator" "property list"
    "property value" "purports to conform"
    "qualified method" "qualifier" "query I/O" "quoted object"
    "radix" "random state" "rank" "ratio" "ratio marker" "rational" "read"
    "readably" "reader" "reader macro" "reader macro function" "readtable"
    "readtable case" "readtable designator" "recognizable subtype" "reference"
    "registered package" "relative" "repertoire" "report" "report message"
    "required parameter" "rest list" "rest parameter" "restart"
    "restart designator" "restart function" "return" "return value"
    "right-parenthesis" "run time" "run-time compiler" "run-time definition"
    "run-time environment"
    "safe" "safe call" "same" "satisfy the test" "scope" "script"
    "secondary value" "section" "self-evaluating object" "semi-standard"
    "semicolon" "sequence" "sequence function" "sequential" "sequentially"
    "serious condition" "session" "set" "setf expander" "setf expansion"
    "setf function" "setf function name" "shadow" "shadowing symbol"
    "shadowing symbols list" "shared slot" "sharpsign" "short float" "sign"
    "signal" "signature" "similar" "similarity" "simple" "simple array"
    "simple bit array" "simple bit vector" "simple condition"
    "simple general vector" "simple string" "simple vector" "single escape"
    "single float" "single-quote" "singleton" "situation" "slash" "slot"
    "slot specifier" "source code" "source file" "space" "special form"
    "special operator" "special variable" "specialize" "specialized"
    "specialized lambda list" "spreadable argument list designator"
    "stack allocate" "stack-allocated" "standard character" "standard class"
    "standard generic function" "standard input" "standard method combination"
    "standard object" "standard output" "standard pprint dispatch table"
    "standard readtable" "standard syntax" "standardized" "startup environment"
    "step" "stream" "stream associated with a file" "stream designator"
    "stream element type" "stream variable" "stream variable designator"
    "string" "string designator" "string equal" "string stream" "structure"
    "structure class" "structure name" "style warning" "subclass"
    "subexpression" "subform" "subrepertoire" "subtype" "superclass"
    "supertype" "supplied-p parameter" "symbol" "symbol macro" "synonym stream"
    "synonym stream symbol" "syntax type" "system class" "system code"
    "t" "tag" "tail" "target" "terminal I/O" "terminating" "tertiary value"
    "throw" "tilde" "time" "time zone" "token" "top level form" "trace output"
    "tree" "tree structure" "true" "truename" "two-way stream" "type"
    "type declaration" "type equivalent" "type expand" "type specifier"
    "unbound" "unbound variable" "undefined function" "unintern" "uninterned"
    "universal time" "unqualified method" "unregistered package" "unsafe"
    "unsafe call" "upgrade" "upgraded array element type"
    "upgraded complex part type" "uppercase" "use" "use list" "user"
    "valid array dimension" "valid array index" "valid array row-major index"
    "valid fill pointer" "valid logical pathname host" "valid pathname device"
    "valid pathname directory" "valid pathname host" "valid pathname name"
    "valid pathname type" "valid pathname version"
    "valid physical pathname host" "valid sequence index" "value" "value cell"
    "variable" "vector" "vertical-bar"
    "whitespace" "wild" "write" "writer"
    "yield"))

(defun make-hyperspec-glossary-entry-map ()
  (let ((ht (make-hash-table :test #'equalp)))
    (loop for title in *hyperspec-glossary-entries*
          do (setf (gethash title ht)
                   (list title
                         (format nil "~A.htm#~A"
                                 (hyperspec-glossary-entry-filename-part title)
                                 (hyperspec-glossary-entry-anchor title)))))
    ht))

(defun hyperspec-glossary-entry-anchor (title)
  (if (string= title "()")
      "OPCP"
      (string-downcase (substitute #\_ #\Space title))))

(defun hyperspec-glossary-entry-filename-part (title)
  (let ((char (aref title 0)))
    (if (alpha-char-p char)
        (char-downcase char)
        #\9)))

(defparameter *hyperspec-glossary-entry-map*
  (make-hyperspec-glossary-entry-map))

(defun/autoloaded find-hyperspec-glossary-entry-id (string)
  (let ((string (normalize-whitespace string)))
    (first (gethash string *hyperspec-glossary-entry-map*))))

(defun/autoloaded find-hyperspec-glossary-entry-url
    (name &optional hyperspec-root)
  (let ((filename (second (gethash (normalize-whitespace name)
                                   *hyperspec-glossary-entry-map*))))
    (when filename
      (hyperspec-link hyperspec-root "Body/26_glo_" filename))))


;;;; Low-level interface to Hyperspec issues and issue summaries

(defparameter *hyperspec-issue-summaries*
  ;; (TITLE FILENAME)
  '(("SUMMARY:&ENVIRONMENT-BINDING-ORDER:FIRST" "iss001")
    ("SUMMARY:ACCESS-ERROR-NAME" "iss002")
    ("SUMMARY:ADJUST-ARRAY-DISPLACEMENT" "iss003")
    ("SUMMARY:ADJUST-ARRAY-FILL-POINTER" "iss004")
    ("SUMMARY:ADJUST-ARRAY-NOT-ADJUSTABLE:IMPLICIT-COPY" "iss005")
    ("SUMMARY:ALLOCATE-INSTANCE:ADD" "iss006")
    ("SUMMARY:ALLOW-LOCAL-INLINE:INLINE-NOTINLINE" "iss007")
    ("SUMMARY:ALLOW-OTHER-KEYS-NIL:PERMIT" "iss008")
    ("SUMMARY:AREF-1D" "iss009")
    ("SUMMARY:ARGUMENT-MISMATCH-ERROR-AGAIN:CONSISTENT" "iss010")
    ("SUMMARY:ARGUMENT-MISMATCH-ERROR-MOON:FIX" "iss011")
    ("SUMMARY:ARGUMENT-MISMATCH-ERROR:MORE-CLARIFICATIONS" "iss012")
    ("SUMMARY:ARGUMENTS-UNDERSPECIFIED:SPECIFY" "iss013")
    ("SUMMARY:ARRAY-DIMENSION-LIMIT-IMPLICATIONS:ALL-FIXNUM" "iss014")
    ("SUMMARY:ARRAY-TYPE-ELEMENT-TYPE-SEMANTICS:UNIFY-UPGRADING" "iss015")
    ("SUMMARY:ASSERT-ERROR-TYPE:ERROR" "iss016")
    ("SUMMARY:ASSOC-RASSOC-IF-KEY" "iss017")
    ("SUMMARY:ASSOC-RASSOC-IF-KEY:YES" "iss018")
    ("SUMMARY:BOA-AUX-INITIALIZATION:ERROR-ON-READ" "iss019")
    ("SUMMARY:BREAK-ON-WARNINGS-OBSOLETE:REMOVE" "iss020")
    ("SUMMARY:BROADCAST-STREAM-RETURN-VALUES:CLARIFY-MINIMALLY" "iss021")
    ("SUMMARY:BUTLAST-NEGATIVE:SHOULD-SIGNAL" "iss022")
    ("SUMMARY:CHANGE-CLASS-INITARGS:PERMIT" "iss023")
    ("SUMMARY:CHAR-NAME-CASE:X3J13-MAR-91" "iss024")
    ("SUMMARY:CHARACTER-LOOSE-ENDS:FIX" "iss025")
    ("SUMMARY:CHARACTER-PROPOSAL:2" "iss026")
    ("SUMMARY:CHARACTER-PROPOSAL:2-1-1" "iss027")
    ("SUMMARY:CHARACTER-PROPOSAL:2-1-2" "iss028")
    ("SUMMARY:CHARACTER-PROPOSAL:2-2-1" "iss029")
    ("SUMMARY:CHARACTER-PROPOSAL:2-3-1" "iss030")
    ("SUMMARY:CHARACTER-PROPOSAL:2-3-2" "iss031")
    ("SUMMARY:CHARACTER-PROPOSAL:2-3-3" "iss032")
    ("SUMMARY:CHARACTER-PROPOSAL:2-3-4" "iss033")
    ("SUMMARY:CHARACTER-PROPOSAL:2-3-5" "iss034")
    ("SUMMARY:CHARACTER-PROPOSAL:2-3-6" "iss035")
    ("SUMMARY:CHARACTER-PROPOSAL:2-4-1" "iss036")
    ("SUMMARY:CHARACTER-PROPOSAL:2-4-2" "iss037")
    ("SUMMARY:CHARACTER-PROPOSAL:2-4-3" "iss038")
    ("SUMMARY:CHARACTER-PROPOSAL:2-5-2" "iss039")
    ("SUMMARY:CHARACTER-PROPOSAL:2-5-6" "iss040")
    ("SUMMARY:CHARACTER-PROPOSAL:2-5-7" "iss041")
    ("SUMMARY:CHARACTER-PROPOSAL:2-6-1" "iss042")
    ("SUMMARY:CHARACTER-PROPOSAL:2-6-2" "iss043")
    ("SUMMARY:CHARACTER-PROPOSAL:2-6-3" "iss044")
    ("SUMMARY:CHARACTER-PROPOSAL:2-6-5" "iss045")
    ("SUMMARY:CHARACTER-VS-CHAR:LESS-INCONSISTENT-SHORT" "iss046")
    ("SUMMARY:CLASS-OBJECT-SPECIALIZER:AFFIRM" "iss047")
    ("SUMMARY:CLOS-CONDITIONS-AGAIN:ALLOW-SUBSET" "iss048")
    ("SUMMARY:CLOS-CONDITIONS:INTEGRATE" "iss049")
    ("SUMMARY:CLOS-ERROR-CHECKING-ORDER:NO-APPLICABLE-METHOD-FIRST" "iss050")
    ("SUMMARY:CLOS-MACRO-COMPILATION:MINIMAL" "iss051")
    ("SUMMARY:CLOSE-CONSTRUCTED-STREAM:ARGUMENT-STREAM-ONLY" "iss052")
    ("SUMMARY:CLOSED-STREAM-OPERATIONS:ALLOW-INQUIRY" "iss053")
    ("SUMMARY:COERCING-SETF-NAME-TO-FUNCTION:ALL-FUNCTION-NAMES" "iss054")
    ("SUMMARY:COLON-NUMBER" "iss055")
    ("SUMMARY:COMMON-FEATURES:SPECIFY" "iss056")
    ("SUMMARY:COMMON-TYPE:REMOVE" "iss057")
    ("SUMMARY:COMPILE-ARGUMENT-PROBLEMS-AGAIN:FIX" "iss058")
    ("SUMMARY:COMPILE-FILE-HANDLING-OF-TOP-LEVEL-FORMS:CLARIFY" "iss059")
    ("SUMMARY:COMPILE-FILE-OUTPUT-FILE-DEFAULTS:INPUT-FILE" "iss060")
    ("SUMMARY:COMPILE-FILE-PACKAGE" "iss061")
    ("SUMMARY:COMPILE-FILE-PATHNAME-ARGUMENTS:MAKE-CONSISTENT" "iss062")
    ("SUMMARY:COMPILE-FILE-SYMBOL-HANDLING:NEW-REQUIRE-CONSISTENCY" "iss063")
    ("SUMMARY:COMPILED-FUNCTION-REQUIREMENTS:TIGHTEN" "iss064")
    ("SUMMARY:COMPILER-DIAGNOSTICS:USE-HANDLER" "iss065")
    ("SUMMARY:COMPILER-LET-CONFUSION:ELIMINATE" "iss066")
    ("SUMMARY:COMPILER-VERBOSITY:LIKE-LOAD" "iss067")
    ("SUMMARY:COMPILER-WARNING-STREAM" "iss068")
    ("SUMMARY:COMPLEX-ATAN-BRANCH-CUT:TWEAK" "iss069")
    ("SUMMARY:COMPLEX-ATANH-BOGUS-FORMULA:TWEAK-MORE" "iss070")
    ("SUMMARY:COMPLEX-RATIONAL-RESULT:EXTEND" "iss071")
    ("SUMMARY:COMPUTE-APPLICABLE-METHODS:GENERIC" "iss072")
    ("SUMMARY:CONCATENATE-SEQUENCE:SIGNAL-ERROR" "iss073")
    ("SUMMARY:CONDITION-ACCESSORS-SETFABLE:NO" "iss074")
    ("SUMMARY:CONDITION-RESTARTS:BUGGY" "iss075")
    ("SUMMARY:CONDITION-RESTARTS:PERMIT-ASSOCIATION" "iss076")
    ("SUMMARY:CONDITION-SLOTS:HIDDEN" "iss077")
    ("SUMMARY:CONS-TYPE-SPECIFIER:ADD" "iss078")
    ("SUMMARY:CONSTANT-CIRCULAR-COMPILATION:YES" "iss079")
    ("SUMMARY:CONSTANT-COLLAPSING:GENERALIZE" "iss080")
    ("SUMMARY:CONSTANT-COMPILABLE-TYPES:SPECIFY" "iss081")
    ("SUMMARY:CONSTANT-FUNCTION-COMPILATION:NO" "iss082")
    ("SUMMARY:CONSTANT-MODIFICATION:DISALLOW" "iss083")
    ("SUMMARY:CONSTANTP-DEFINITION:INTENTIONAL" "iss084")
    ("SUMMARY:CONSTANTP-ENVIRONMENT:ADD-ARG" "iss085")
    ("SUMMARY:CONTAGION-ON-NUMERICAL-COMPARISONS:TRANSITIVE" "iss086")
    ("SUMMARY:COPY-SYMBOL-COPY-PLIST:COPY-LIST" "iss087")
    ("SUMMARY:COPY-SYMBOL-PRINT-NAME:EQUAL" "iss088")
    ("SUMMARY:DATA-IO:ADD-SUPPORT" "iss089")
    ("SUMMARY:DATA-TYPES-HIERARCHY-UNDERSPECIFIED" "iss090")
    ("SUMMARY:DEBUGGER-HOOK-VS-BREAK:CLARIFY" "iss091")
    ("SUMMARY:DECLARATION-SCOPE:NO-HOISTING" "iss092")
    ("SUMMARY:DECLARE-ARRAY-TYPE-ELEMENT-REFERENCES:RESTRICTIVE" "iss093")
    ("SUMMARY:DECLARE-FUNCTION-AMBIGUITY:DELETE-FTYPE-ABBREVIATION" "iss094")
    ("SUMMARY:DECLARE-MACROS:FLUSH" "iss095")
    ("SUMMARY:DECLARE-TYPE-FREE:LEXICAL" "iss096")
    ("SUMMARY:DECLS-AND-DOC" "iss097")
    ("SUMMARY:DECODE-UNIVERSAL-TIME-DAYLIGHT:LIKE-ENCODE" "iss098")
    ("SUMMARY:DEFCONSTANT-SPECIAL:NO" "iss099")
    ("SUMMARY:DEFGENERIC-DECLARE:ALLOW-MULTIPLE" "iss100")
    ("SUMMARY:DEFINE-COMPILER-MACRO:X3J13-NOV89" "iss101")
    ("SUMMARY:DEFINE-CONDITION-SYNTAX:INCOMPATIBLY-MORE-LIKE-DEFCLASS+EMPHASIZE-READ-ONLY"
     "iss102")
    ("SUMMARY:DEFINE-METHOD-COMBINATION-BEHAVIOR:CLARIFY" "iss103")
    ("SUMMARY:DEFINING-MACROS-NON-TOP-LEVEL:ALLOW" "iss104")
    ("SUMMARY:DEFMACRO-BLOCK-SCOPE:EXCLUDES-BINDINGS" "iss105")
    ("SUMMARY:DEFMACRO-LAMBDA-LIST:TIGHTEN-DESCRIPTION" "iss106")
    ("SUMMARY:DEFMETHOD-DECLARATION-SCOPE:CORRESPONDS-TO-BINDINGS" "iss107")
    ("SUMMARY:DEFPACKAGE:ADDITION" "iss108")
    ("SUMMARY:DEFSTRUCT-CONSTRUCTOR-KEY-MIXTURE:ALLOW-KEY" "iss109")
    ("SUMMARY:DEFSTRUCT-CONSTRUCTOR-OPTIONS:EXPLICIT" "iss110")
    ("SUMMARY:DEFSTRUCT-CONSTRUCTOR-SLOT-VARIABLES:NOT-BOUND" "iss111")
    ("SUMMARY:DEFSTRUCT-COPIER-ARGUMENT-TYPE:RESTRICT" "iss112")
    ("SUMMARY:DEFSTRUCT-COPIER:ARGUMENT-TYPE" "iss113")
    ("SUMMARY:DEFSTRUCT-DEFAULT-VALUE-EVALUATION:IFF-NEEDED" "iss114")
    ("SUMMARY:DEFSTRUCT-INCLUDE-DEFTYPE:EXPLICITLY-UNDEFINED" "iss115")
    ("SUMMARY:DEFSTRUCT-PRINT-FUNCTION-AGAIN:X3J13-MAR-93" "iss116")
    ("SUMMARY:DEFSTRUCT-PRINT-FUNCTION-INHERITANCE:YES" "iss117")
    ("SUMMARY:DEFSTRUCT-REDEFINITION:ERROR" "iss118")
    ("SUMMARY:DEFSTRUCT-SLOTS-CONSTRAINTS-NAME:DUPLICATES-ERROR" "iss119")
    ("SUMMARY:DEFSTRUCT-SLOTS-CONSTRAINTS-NUMBER" "iss120")
    ("SUMMARY:DEFTYPE-DESTRUCTURING:YES" "iss121")
    ("SUMMARY:DEFTYPE-KEY:ALLOW" "iss122")
    ("SUMMARY:DEFVAR-DOCUMENTATION:UNEVALUATED" "iss123")
    ("SUMMARY:DEFVAR-INIT-TIME:NOT-DELAYED" "iss124")
    ("SUMMARY:DEFVAR-INITIALIZATION:CONSERVATIVE" "iss125")
    ("SUMMARY:DEPRECATION-POSITION:LIMITED" "iss126")
    ("SUMMARY:DESCRIBE-INTERACTIVE:NO" "iss127")
    ("SUMMARY:DESCRIBE-UNDERSPECIFIED:DESCRIBE-OBJECT" "iss128")
    ("SUMMARY:DESTRUCTIVE-OPERATIONS:SPECIFY" "iss129")
    ("SUMMARY:DESTRUCTURING-BIND:NEW-MACRO" "iss130")
    ("SUMMARY:DISASSEMBLE-SIDE-EFFECT:DO-NOT-INSTALL" "iss131")
    ("SUMMARY:DISPLACED-ARRAY-PREDICATE:ADD" "iss132")
    ("SUMMARY:DO-SYMBOLS-BLOCK-SCOPE:ENTIRE-FORM" "iss133")
    ("SUMMARY:DO-SYMBOLS-DUPLICATES" "iss134")
    ("SUMMARY:DOCUMENTATION-FUNCTION-BUGS:FIX" "iss135")
    ("SUMMARY:DOCUMENTATION-FUNCTION-TANGLED:REQUIRE-ARGUMENT" "iss136")
    ("SUMMARY:DOTIMES-IGNORE:X3J13-MAR91" "iss137")
    ("SUMMARY:DOTTED-LIST-ARGUMENTS:CLARIFY" "iss138")
    ("SUMMARY:DOTTED-MACRO-FORMS:ALLOW" "iss139")
    ("SUMMARY:DRIBBLE-TECHNIQUE" "iss140")
    ("SUMMARY:DYNAMIC-EXTENT-FUNCTION:EXTEND" "iss141")
    ("SUMMARY:DYNAMIC-EXTENT:NEW-DECLARATION" "iss142")
    ("SUMMARY:EQUAL-STRUCTURE:MAYBE-STATUS-QUO" "iss143")
    ("SUMMARY:ERROR-TERMINOLOGY-WARNING:MIGHT" "iss144")
    ("SUMMARY:EVAL-OTHER:SELF-EVALUATE" "iss145")
    ("SUMMARY:EVAL-TOP-LEVEL:LOAD-LIKE-COMPILE-FILE" "iss146")
    ("SUMMARY:EVAL-WHEN-NON-TOP-LEVEL:GENERALIZE-EVAL-NEW-KEYWORDS" "iss147")
    ("SUMMARY:EVAL-WHEN-OBSOLETE-KEYWORDS:X3J13-MAR-1993" "iss148")
    ("SUMMARY:EVALHOOK-STEP-CONFUSION:FIX" "iss149")
    ("SUMMARY:EVALHOOK-STEP-CONFUSION:X3J13-NOV-89" "iss150")
    ("SUMMARY:EXIT-EXTENT-AND-CONDITION-SYSTEM:LIKE-DYNAMIC-BINDINGS" "iss151")
    ("SUMMARY:EXIT-EXTENT:MINIMAL" "iss152")
    ("SUMMARY:EXPT-RATIO:P.211" "iss153")
    ("SUMMARY:EXTENSIONS-POSITION:DOCUMENTATION" "iss154")
    ("SUMMARY:EXTERNAL-FORMAT-FOR-EVERY-FILE-CONNECTION:MINIMUM" "iss155")
    ("SUMMARY:EXTRA-RETURN-VALUES:NO" "iss156")
    ("SUMMARY:FILE-OPEN-ERROR:SIGNAL-FILE-ERROR" "iss157")
    ("SUMMARY:FIXNUM-NON-PORTABLE:TIGHTEN-DEFINITION" "iss158")
    ("SUMMARY:FLET-DECLARATIONS" "iss159")
    ("SUMMARY:FLET-DECLARATIONS:ALLOW" "iss160")
    ("SUMMARY:FLET-IMPLICIT-BLOCK:YES" "iss161")
    ("SUMMARY:FLOAT-UNDERFLOW:ADD-VARIABLES" "iss162")
    ("SUMMARY:FLOATING-POINT-CONDITION-NAMES:X3J13-NOV-89" "iss163")
    ("SUMMARY:FORMAT-ATSIGN-COLON" "iss164")
    ("SUMMARY:FORMAT-COLON-UPARROW-SCOPE" "iss165")
    ("SUMMARY:FORMAT-COMMA-INTERVAL" "iss166")
    ("SUMMARY:FORMAT-E-EXPONENT-SIGN:FORCE-SIGN" "iss167")
    ("SUMMARY:FORMAT-OP-C" "iss168")
    ("SUMMARY:FORMAT-PRETTY-PRINT:YES" "iss169")
    ("SUMMARY:FORMAT-STRING-ARGUMENTS:SPECIFY" "iss170")
    ("SUMMARY:FUNCTION-CALL-EVALUATION-ORDER:MORE-UNSPECIFIED" "iss171")
    ("SUMMARY:FUNCTION-COMPOSITION:JAN89-X3J13" "iss172")
    ("SUMMARY:FUNCTION-DEFINITION:JAN89-X3J13" "iss173")
    ("SUMMARY:FUNCTION-NAME:LARGE" "iss174")
    ("SUMMARY:FUNCTION-TYPE" "iss175")
    ("SUMMARY:FUNCTION-TYPE-ARGUMENT-TYPE-SEMANTICS:RESTRICTIVE" "iss176")
    ("SUMMARY:FUNCTION-TYPE-KEY-NAME:SPECIFY-KEYWORD" "iss177")
    ("SUMMARY:FUNCTION-TYPE-REST-LIST-ELEMENT:USE-ACTUAL-ARGUMENT-TYPE"
     "iss178")
    ("SUMMARY:FUNCTION-TYPE:X3J13-MARCH-88" "iss179")
    ("SUMMARY:GENERALIZE-PRETTY-PRINTER:UNIFY" "iss180")
    ("SUMMARY:GENERIC-FLET-POORLY-DESIGNED:DELETE" "iss181")
    ("SUMMARY:GENSYM-NAME-STICKINESS:LIKE-TEFLON" "iss182")
    ("SUMMARY:GENTEMP-BAD-IDEA:DEPRECATE" "iss183")
    ("SUMMARY:GET-MACRO-CHARACTER-READTABLE:NIL-STANDARD" "iss184")
    ("SUMMARY:GET-SETF-METHOD-ENVIRONMENT:ADD-ARG" "iss185")
    ("SUMMARY:HASH-TABLE-ACCESS:X3J13-MAR-89" "iss186")
    ("SUMMARY:HASH-TABLE-KEY-MODIFICATION:SPECIFY" "iss187")
    ("SUMMARY:HASH-TABLE-PACKAGE-GENERATORS:ADD-WITH-WRAPPER" "iss188")
    ("SUMMARY:HASH-TABLE-REHASH-SIZE-INTEGER" "iss189")
    ("SUMMARY:HASH-TABLE-SIZE:INTENDED-ENTRIES" "iss190")
    ("SUMMARY:HASH-TABLE-TESTS:ADD-EQUALP" "iss191")
    ("SUMMARY:IEEE-ATAN-BRANCH-CUT:SPLIT" "iss192")
    ("SUMMARY:IGNORE-USE-TERMINOLOGY:VALUE-ONLY" "iss193")
    ("SUMMARY:IMPORT-SETF-SYMBOL-PACKAGE" "iss194")
    ("SUMMARY:IN-PACKAGE-FUNCTIONALITY:MAR89-X3J13" "iss195")
    ("SUMMARY:IN-SYNTAX:MINIMAL" "iss196")
    ("SUMMARY:INITIALIZATION-FUNCTION-KEYWORD-CHECKING" "iss197")
    ("SUMMARY:ISO-COMPATIBILITY:ADD-SUBSTRATE" "iss198")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:11" "iss199")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:14" "iss200")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:24" "iss201")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:25" "iss202")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:27" "iss203")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:3" "iss204")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:4" "iss205")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:5" "iss206")
    ("SUMMARY:JUN90-TRIVIAL-ISSUES:9" "iss207")
    ("SUMMARY:KEYWORD-ARGUMENT-NAME-PACKAGE:ANY" "iss208")
    ("SUMMARY:LAST-N" "iss209")
    ("SUMMARY:LCM-NO-ARGUMENTS:1" "iss210")
    ("SUMMARY:LEXICAL-CONSTRUCT-GLOBAL-DEFINITION:UNDEFINED" "iss211")
    ("SUMMARY:LISP-PACKAGE-NAME:COMMON-LISP" "iss212")
    ("SUMMARY:LISP-SYMBOL-REDEFINITION-AGAIN:MORE-FIXES" "iss213")
    ("SUMMARY:LISP-SYMBOL-REDEFINITION:MAR89-X3J13" "iss214")
    ("SUMMARY:LOAD-OBJECTS:MAKE-LOAD-FORM" "iss215")
    ("SUMMARY:LOAD-TIME-EVAL:R**2-NEW-SPECIAL-FORM" "iss216")
    ("SUMMARY:LOAD-TIME-EVAL:R**3-NEW-SPECIAL-FORM" "iss217")
    ("SUMMARY:LOAD-TRUENAME:NEW-PATHNAME-VARIABLES" "iss218")
    ("SUMMARY:LOCALLY-TOP-LEVEL:SPECIAL-FORM" "iss219")
    ("SUMMARY:LOOP-AND-DISCREPANCY:NO-REITERATION" "iss220")
    ("SUMMARY:LOOP-FOR-AS-ON-TYPO:FIX-TYPO" "iss221")
    ("SUMMARY:LOOP-INITFORM-ENVIRONMENT:PARTIAL-INTERLEAVING-VAGUE" "iss222")
    ("SUMMARY:LOOP-MISCELLANEOUS-REPAIRS:FIX" "iss223")
    ("SUMMARY:LOOP-NAMED-BLOCK-NIL:OVERRIDE" "iss224")
    ("SUMMARY:LOOP-PRESENT-SYMBOLS-TYPO:FLUSH-WRONG-WORDS" "iss225")
    ("SUMMARY:LOOP-SYNTAX-OVERHAUL:REPAIR" "iss226")
    ("SUMMARY:MACRO-AS-FUNCTION:DISALLOW" "iss227")
    ("SUMMARY:MACRO-DECLARATIONS:MAKE-EXPLICIT" "iss228")
    ("SUMMARY:MACRO-ENVIRONMENT-EXTENT:DYNAMIC" "iss229")
    ("SUMMARY:MACRO-FUNCTION-ENVIRONMENT" "iss230")
    ("SUMMARY:MACRO-FUNCTION-ENVIRONMENT:YES" "iss231")
    ("SUMMARY:MACRO-SUBFORMS-TOP-LEVEL-P:ADD-CONSTRAINTS" "iss232")
    ("SUMMARY:MACROEXPAND-HOOK-DEFAULT:EXPLICITLY-VAGUE" "iss233")
    ("SUMMARY:MACROEXPAND-HOOK-INITIAL-VALUE:IMPLEMENTATION-DEPENDENT" "iss234")
    ("SUMMARY:MACROEXPAND-RETURN-VALUE:TRUE" "iss235")
    ("SUMMARY:MAKE-LOAD-FORM-CONFUSION:REWRITE" "iss236")
    ("SUMMARY:MAKE-LOAD-FORM-SAVING-SLOTS:NO-INITFORMS" "iss237")
    ("SUMMARY:MAKE-PACKAGE-USE-DEFAULT:IMPLEMENTATION-DEPENDENT" "iss238")
    ("SUMMARY:MAP-INTO:ADD-FUNCTION" "iss239")
    ("SUMMARY:MAPPING-DESTRUCTIVE-INTERACTION:EXPLICITLY-VAGUE" "iss240")
    ("SUMMARY:METACLASS-OF-SYSTEM-CLASS:UNSPECIFIED" "iss241")
    ("SUMMARY:METHOD-COMBINATION-ARGUMENTS:CLARIFY" "iss242")
    ("SUMMARY:METHOD-INITFORM:FORBID-CALL-NEXT-METHOD" "iss243")
    ("SUMMARY:MUFFLE-WARNING-CONDITION-ARGUMENT" "iss244")
    ("SUMMARY:MULTIPLE-VALUE-SETQ-ORDER:LIKE-SETF-OF-VALUES" "iss245")
    ("SUMMARY:MULTIPLE-VALUES-LIMIT-ON-VARIABLES:UNDEFINED" "iss246")
    ("SUMMARY:NINTERSECTION-DESTRUCTION" "iss247")
    ("SUMMARY:NINTERSECTION-DESTRUCTION:REVERT" "iss248")
    ("SUMMARY:NOT-AND-NULL-RETURN-VALUE:X3J13-MAR-93" "iss249")
    ("SUMMARY:NTH-VALUE:ADD" "iss250")
    ("SUMMARY:OPTIMIZE-DEBUG-INFO:NEW-QUALITY" "iss251")
    ("SUMMARY:PACKAGE-CLUTTER:REDUCE" "iss252")
    ("SUMMARY:PACKAGE-DELETION:NEW-FUNCTION" "iss253")
    ("SUMMARY:PACKAGE-FUNCTION-CONSISTENCY:MORE-PERMISSIVE" "iss254")
    ("SUMMARY:PARSE-ERROR-STREAM:SPLIT-TYPES" "iss255")
    ("SUMMARY:PATHNAME-COMPONENT-CASE:KEYWORD-ARGUMENT" "iss256")
    ("SUMMARY:PATHNAME-COMPONENT-VALUE:SPECIFY" "iss257")
    ("SUMMARY:PATHNAME-HOST-PARSING:RECOGNIZE-LOGICAL-HOST-NAMES" "iss258")
    ("SUMMARY:PATHNAME-LOGICAL:ADD" "iss259")
    ("SUMMARY:PATHNAME-PRINT-READ:SHARPSIGN-P" "iss260")
    ("SUMMARY:PATHNAME-STREAM" "iss261")
    ("SUMMARY:PATHNAME-STREAM:FILES-OR-SYNONYM" "iss262")
    ("SUMMARY:PATHNAME-SUBDIRECTORY-LIST:NEW-REPRESENTATION" "iss263")
    ("SUMMARY:PATHNAME-SYMBOL" "iss264")
    ("SUMMARY:PATHNAME-SYNTAX-ERROR-TIME:EXPLICITLY-VAGUE" "iss265")
    ("SUMMARY:PATHNAME-UNSPECIFIC-COMPONENT:NEW-TOKEN" "iss266")
    ("SUMMARY:PATHNAME-WILD:NEW-FUNCTIONS" "iss267")
    ("SUMMARY:PEEK-CHAR-READ-CHAR-ECHO:FIRST-READ-CHAR" "iss268")
    ("SUMMARY:PLIST-DUPLICATES:ALLOW" "iss269")
    ("SUMMARY:PRETTY-PRINT-INTERFACE" "iss270")
    ("SUMMARY:PRINC-READABLY:X3J13-DEC-91" "iss271")
    ("SUMMARY:PRINT-CASE-BEHAVIOR:CLARIFY" "iss272")
    ("SUMMARY:PRINT-CASE-PRINT-ESCAPE-INTERACTION:VERTICAL-BAR-RULE-NO-UPCASE"
     "iss273")
    ("SUMMARY:PRINT-CIRCLE-SHARED:RESPECT-PRINT-CIRCLE" "iss274")
    ("SUMMARY:PRINT-CIRCLE-STRUCTURE:USER-FUNCTIONS-WORK" "iss275")
    ("SUMMARY:PRINT-READABLY-BEHAVIOR:CLARIFY" "iss276")
    ("SUMMARY:PRINTER-WHITESPACE:JUST-ONE-SPACE" "iss277")
    ("SUMMARY:PROCLAIM-ETC-IN-COMPILE-FILE:NEW-MACRO" "iss278")
    ("SUMMARY:PUSH-EVALUATION-ORDER:FIRST-ITEM" "iss279")
    ("SUMMARY:PUSH-EVALUATION-ORDER:ITEM-FIRST" "iss280")
    ("SUMMARY:PUSHNEW-STORE-REQUIRED:UNSPECIFIED" "iss281")
    ("SUMMARY:QUOTE-SEMANTICS:NO-COPYING" "iss282")
    ("SUMMARY:RANGE-OF-COUNT-KEYWORD:NIL-OR-INTEGER" "iss283")
    ("SUMMARY:RANGE-OF-START-AND-END-PARAMETERS:INTEGER-AND-INTEGER-NIL"
     "iss284")
    ("SUMMARY:READ-AND-WRITE-BYTES:NEW-FUNCTIONS" "iss285")
    ("SUMMARY:READ-CASE-SENSITIVITY:READTABLE-KEYWORDS" "iss286")
    ("SUMMARY:READ-MODIFY-WRITE-EVALUATION-ORDER:DELAYED-ACCESS-STORES"
     "iss287")
    ("SUMMARY:READ-SUPPRESS-CONFUSING:GENERALIZE" "iss288")
    ("SUMMARY:READER-ERROR:NEW-TYPE" "iss289")
    ("SUMMARY:REAL-NUMBER-TYPE:X3J13-MAR-89" "iss290")
    ("SUMMARY:RECURSIVE-DEFTYPE:EXPLICITLY-VAGUE" "iss291")
    ("SUMMARY:REDUCE-ARGUMENT-EXTRACTION" "iss292")
    ("SUMMARY:REMF-DESTRUCTION-UNSPECIFIED:X3J13-MAR-89" "iss293")
    ("SUMMARY:REQUIRE-PATHNAME-DEFAULTS-AGAIN:X3J13-DEC-91" "iss294")
    ("SUMMARY:REQUIRE-PATHNAME-DEFAULTS-YET-AGAIN:RESTORE-ARGUMENT" "iss295")
    ("SUMMARY:REQUIRE-PATHNAME-DEFAULTS:ELIMINATE" "iss296")
    ("SUMMARY:REST-LIST-ALLOCATION:MAY-SHARE" "iss297")
    ("SUMMARY:RESULT-LISTS-SHARED:SPECIFY" "iss298")
    ("SUMMARY:RETURN-VALUES-UNSPECIFIED:SPECIFY" "iss299")
    ("SUMMARY:ROOM-DEFAULT-ARGUMENT:NEW-VALUE" "iss300")
    ("SUMMARY:SELF-MODIFYING-CODE:FORBID" "iss301")
    ("SUMMARY:SEQUENCE-TYPE-LENGTH:MUST-MATCH" "iss302")
    ("SUMMARY:SETF-APPLY-EXPANSION:IGNORE-EXPANDER" "iss303")
    ("SUMMARY:SETF-FIND-CLASS:ALLOW-NIL" "iss304")
    ("SUMMARY:SETF-FUNCTIONS-AGAIN:MINIMAL-CHANGES" "iss305")
    ("SUMMARY:SETF-GET-DEFAULT:EVALUATED-BUT-IGNORED" "iss306")
    ("SUMMARY:SETF-MACRO-EXPANSION:LAST" "iss307")
    ("SUMMARY:SETF-METHOD-VS-SETF-METHOD:RENAME-OLD-TERMS" "iss308")
    ("SUMMARY:SETF-MULTIPLE-STORE-VARIABLES:ALLOW" "iss309")
    ("SUMMARY:SETF-OF-APPLY:ONLY-AREF-AND-FRIENDS" "iss310")
    ("SUMMARY:SETF-OF-VALUES:ADD" "iss311")
    ("SUMMARY:SETF-SUB-METHODS:DELAYED-ACCESS-STORES" "iss312")
    ("SUMMARY:SHADOW-ALREADY-PRESENT" "iss313")
    ("SUMMARY:SHADOW-ALREADY-PRESENT:WORKS" "iss314")
    ("SUMMARY:SHARP-COMMA-CONFUSION:REMOVE" "iss315")
    ("SUMMARY:SHARP-O-FOOBAR:CONSEQUENCES-UNDEFINED" "iss316")
    ("SUMMARY:SHARP-STAR-DELIMITER:NORMAL-DELIMITER" "iss317")
    ("SUMMARY:SHARPSIGN-PLUS-MINUS-PACKAGE:KEYWORD" "iss318")
    ("SUMMARY:SLOT-MISSING-VALUES:SPECIFY" "iss319")
    ("SUMMARY:SLOT-VALUE-METACLASSES:LESS-MINIMAL" "iss320")
    ("SUMMARY:SPECIAL-FORM-P-MISNOMER:RENAME" "iss321")
    ("SUMMARY:SPECIAL-TYPE-SHADOWING:CLARIFY" "iss322")
    ("SUMMARY:STANDARD-INPUT-INITIAL-BINDING:DEFINED-CONTRACTS" "iss323")
    ("SUMMARY:STANDARD-REPERTOIRE-GRATUITOUS:RENAME" "iss324")
    ("SUMMARY:STEP-ENVIRONMENT:CURRENT" "iss325")
    ("SUMMARY:STEP-MINIMAL:PERMIT-PROGN" "iss326")
    ("SUMMARY:STREAM-ACCESS:ADD-TYPES-ACCESSORS" "iss327")
    ("SUMMARY:STREAM-CAPABILITIES:INTERACTIVE-STREAM-P" "iss328")
    ("SUMMARY:STRING-COERCION:MAKE-CONSISTENT" "iss329")
    ("SUMMARY:STRING-OUTPUT-STREAM-BASHING:UNDEFINED" "iss330")
    ("SUMMARY:STRUCTURE-READ-PRINT-SYNTAX:KEYWORDS" "iss331")
    ("SUMMARY:SUBSEQ-OUT-OF-BOUNDS" "iss332")
    ("SUMMARY:SUBSETTING-POSITION:NONE" "iss333")
    ("SUMMARY:SUBTYPEP-ENVIRONMENT:ADD-ARG" "iss334")
    ("SUMMARY:SUBTYPEP-TOO-VAGUE:CLARIFY-MORE" "iss335")
    ("SUMMARY:SXHASH-DEFINITION:SIMILAR-FOR-SXHASH" "iss336")
    ("SUMMARY:SYMBOL-MACROLET-DECLARE:ALLOW" "iss337")
    ("SUMMARY:SYMBOL-MACROLET-SEMANTICS:SPECIAL-FORM" "iss338")
    ("SUMMARY:SYMBOL-MACROLET-TYPE-DECLARATION:NO" "iss339")
    ("SUMMARY:SYMBOL-MACROS-AND-PROCLAIMED-SPECIALS:SIGNALS-AN-ERROR" "iss340")
    ("SUMMARY:SYMBOL-PRINT-ESCAPE-BEHAVIOR:CLARIFY" "iss341")
    ("SUMMARY:SYNTACTIC-ENVIRONMENT-ACCESS:RETRACTED-MAR91" "iss342")
    ("SUMMARY:TAGBODY-TAG-EXPANSION:NO" "iss343")
    ("SUMMARY:TAILP-NIL:T" "iss344")
    ("SUMMARY:TEST-NOT-IF-NOT:FLUSH-ALL" "iss345")
    ("SUMMARY:THE-AMBIGUITY:FOR-DECLARATION" "iss346")
    ("SUMMARY:THE-VALUES:RETURN-NUMBER-RECEIVED" "iss347")
    ("SUMMARY:TIME-ZONE-NON-INTEGER:ALLOW" "iss348")
    ("SUMMARY:TYPE-DECLARATION-ABBREVIATION:ALLOW-ALL" "iss349")
    ("SUMMARY:TYPE-OF-AND-PREDEFINED-CLASSES:TYPE-OF-HANDLES-FLOATS" "iss350")
    ("SUMMARY:TYPE-OF-AND-PREDEFINED-CLASSES:UNIFY-AND-EXTEND" "iss351")
    ("SUMMARY:TYPE-OF-UNDERCONSTRAINED:ADD-CONSTRAINTS" "iss352")
    ("SUMMARY:TYPE-SPECIFIER-ABBREVIATION:X3J13-JUN90-GUESS" "iss353")
    ("SUMMARY:UNDEFINED-VARIABLES-AND-FUNCTIONS:COMPROMISE" "iss354")
    ("SUMMARY:UNINITIALIZED-ELEMENTS:CONSEQUENCES-UNDEFINED" "iss355")
    ("SUMMARY:UNREAD-CHAR-AFTER-PEEK-CHAR:DONT-ALLOW" "iss356")
    ("SUMMARY:UNSOLICITED-MESSAGES:NOT-TO-SYSTEM-USER-STREAMS" "iss357")
    ("SUMMARY:VARIABLE-LIST-ASYMMETRY:SYMMETRIZE" "iss358")
    ("SUMMARY:WITH-ADDED-METHODS:DELETE" "iss359")
    ("SUMMARY:WITH-COMPILATION-UNIT:NEW-MACRO" "iss360")
    ("SUMMARY:WITH-OPEN-FILE-DOES-NOT-EXIST:STREAM-IS-NIL" "iss361")
    ("SUMMARY:WITH-OPEN-FILE-SETQ:EXPLICITLY-VAGUE" "iss362")
    ("SUMMARY:WITH-OPEN-FILE-STREAM-EXTENT:DYNAMIC-EXTENT" "iss363")
    ("SUMMARY:WITH-OUTPUT-TO-STRING-APPEND-STYLE:VECTOR-PUSH-EXTEND" "iss364")
    ("SUMMARY:WITH-STANDARD-IO-SYNTAX-READTABLE:X3J13-MAR-91" "iss365")))

(defparameter *hyperspec-issues*
  ;; (TITLE FILENAME)
  '(("ISSUE:&ENVIRONMENT-BINDING-ORDER" "iss001_w")
    ("ISSUE:ACCESS-ERROR-NAME" "iss002_w")
    ("ISSUE:ADJUST-ARRAY-DISPLACEMENT" "iss003_w")
    ("ISSUE:ADJUST-ARRAY-FILL-POINTER" "iss004_w")
    ("ISSUE:ADJUST-ARRAY-NOT-ADJUSTABLE" "iss005_w")
    ("ISSUE:ALLOCATE-INSTANCE" "iss006_w")
    ("ISSUE:ALLOW-LOCAL-INLINE" "iss007_w")
    ("ISSUE:ALLOW-OTHER-KEYS-NIL" "iss008_w")
    ("ISSUE:AREF-1D" "iss009_w")
    ("ISSUE:ARGUMENT-MISMATCH-ERROR-AGAIN" "iss010_w")
    ("ISSUE:ARGUMENT-MISMATCH-ERROR-MOON" "iss011_w")
    ("ISSUE:ARGUMENT-MISMATCH-ERROR" "iss012_w")
    ("ISSUE:ARGUMENTS-UNDERSPECIFIED" "iss013_w")
    ("ISSUE:ARRAY-DIMENSION-LIMIT-IMPLICATIONS" "iss014_w")
    ("ISSUE:ARRAY-TYPE-ELEMENT-TYPE-SEMANTICS" "iss015_w")
    ("ISSUE:ASSERT-ERROR-TYPE" "iss016_w")
    ("ISSUE:ASSOC-RASSOC-IF-KEY" "iss017_w")
    ("ISSUE:BOA-AUX-INITIALIZATION" "iss019_w")
    ("ISSUE:BREAK-ON-WARNINGS-OBSOLETE" "iss020_w")
    ("ISSUE:BROADCAST-STREAM-RETURN-VALUES" "iss021_w")
    ("ISSUE:BUTLAST-NEGATIVE" "iss022_w")
    ("ISSUE:CHANGE-CLASS-INITARGS" "iss023_w")
    ("ISSUE:CHAR-NAME-CASE" "iss024_w")
    ("ISSUE:CHARACTER-LOOSE-ENDS" "iss025_w")
    ("ISSUE:CHARACTER-PROPOSAL" "iss026_w")
    ("ISSUE:CHARACTER-VS-CHAR" "iss046_w")
    ("ISSUE:CLASS-OBJECT-SPECIALIZER" "iss047_w")
    ("ISSUE:CLOS-CONDITIONS-AGAIN" "iss048_w")
    ("ISSUE:CLOS-CONDITIONS" "iss049_w")
    ("ISSUE:CLOS-ERROR-CHECKING-ORDER" "iss050_w")
    ("ISSUE:CLOS-MACRO-COMPILATION" "iss051_w")
    ("ISSUE:CLOSE-CONSTRUCTED-STREAM" "iss052_w")
    ("ISSUE:CLOSED-STREAM-OPERATIONS" "iss053_w")
    ("ISSUE:COERCING-SETF-NAME-TO-FUNCTION" "iss054_w")
    ("ISSUE:COLON-NUMBER" "iss055_w")
    ("ISSUE:COMMON-FEATURES" "iss056_w")
    ("ISSUE:COMMON-TYPE" "iss057_w")
    ("ISSUE:COMPILE-ARGUMENT-PROBLEMS-AGAIN" "iss058_w")
    ("ISSUE:COMPILE-FILE-HANDLING-OF-TOP-LEVEL-FORMS" "iss059_w")
    ("ISSUE:COMPILE-FILE-OUTPUT-FILE-DEFAULTS" "iss060_w")
    ("ISSUE:COMPILE-FILE-PACKAGE" "iss061_w")
    ("ISSUE:COMPILE-FILE-PATHNAME-ARGUMENTS" "iss062_w")
    ("ISSUE:COMPILE-FILE-SYMBOL-HANDLING" "iss063_w")
    ("ISSUE:COMPILED-FUNCTION-REQUIREMENTS" "iss064_w")
    ("ISSUE:COMPILER-DIAGNOSTICS" "iss065_w")
    ("ISSUE:COMPILER-LET-CONFUSION" "iss066_w")
    ("ISSUE:COMPILER-VERBOSITY" "iss067_w")
    ("ISSUE:COMPILER-WARNING-STREAM" "iss068_w")
    ("ISSUE:COMPLEX-ATAN-BRANCH-CUT" "iss069_w")
    ("ISSUE:COMPLEX-ATANH-BOGUS-FORMULA" "iss070_w")
    ("ISSUE:COMPLEX-RATIONAL-RESULT" "iss071_w")
    ("ISSUE:COMPUTE-APPLICABLE-METHODS" "iss072_w")
    ("ISSUE:CONCATENATE-SEQUENCE" "iss073_w")
    ("ISSUE:CONDITION-ACCESSORS-SETFABLE" "iss074_w")
    ("ISSUE:CONDITION-RESTARTS" "iss075_w")
    ("ISSUE:CONDITION-SLOTS" "iss077_w")
    ("ISSUE:CONS-TYPE-SPECIFIER" "iss078_w")
    ("ISSUE:CONSTANT-CIRCULAR-COMPILATION" "iss079_w")
    ("ISSUE:CONSTANT-COLLAPSING" "iss080_w")
    ("ISSUE:CONSTANT-COMPILABLE-TYPES" "iss081_w")
    ("ISSUE:CONSTANT-FUNCTION-COMPILATION" "iss082_w")
    ("ISSUE:CONSTANT-MODIFICATION" "iss083_w")
    ("ISSUE:CONSTANTP-DEFINITION" "iss084_w")
    ("ISSUE:CONSTANTP-ENVIRONMENT" "iss085_w")
    ("ISSUE:CONTAGION-ON-NUMERICAL-COMPARISONS" "iss086_w")
    ("ISSUE:COPY-SYMBOL-COPY-PLIST" "iss087_w")
    ("ISSUE:COPY-SYMBOL-PRINT-NAME" "iss088_w")
    ("ISSUE:DATA-IO" "iss089_w")
    ("ISSUE:DATA-TYPES-HIERARCHY-UNDERSPECIFIED" "iss090_w")
    ("ISSUE:DEBUGGER-HOOK-VS-BREAK" "iss091_w")
    ("ISSUE:DECLARATION-SCOPE" "iss092_w")
    ("ISSUE:DECLARE-ARRAY-TYPE-ELEMENT-REFERENCES" "iss093_w")
    ("ISSUE:DECLARE-FUNCTION-AMBIGUITY" "iss094_w")
    ("ISSUE:DECLARE-MACROS" "iss095_w")
    ("ISSUE:DECLARE-TYPE-FREE" "iss096_w")
    ("ISSUE:DECLS-AND-DOC" "iss097_w")
    ("ISSUE:DECODE-UNIVERSAL-TIME-DAYLIGHT" "iss098_w")
    ("ISSUE:DEFCONSTANT-SPECIAL" "iss099_w")
    ("ISSUE:DEFGENERIC-DECLARE" "iss100_w")
    ("ISSUE:DEFINE-COMPILER-MACRO" "iss101_w")
    ("ISSUE:DEFINE-CONDITION-SYNTAX" "iss102_w")
    ("ISSUE:DEFINE-METHOD-COMBINATION-BEHAVIOR" "iss103_w")
    ("ISSUE:DEFINING-MACROS-NON-TOP-LEVEL" "iss104_w")
    ("ISSUE:DEFMACRO-BLOCK-SCOPE" "iss105_w")
    ("ISSUE:DEFMACRO-LAMBDA-LIST" "iss106_w")
    ("ISSUE:DEFMETHOD-DECLARATION-SCOPE" "iss107_w")
    ("ISSUE:DEFPACKAGE" "iss108_w")
    ("ISSUE:DEFSTRUCT-CONSTRUCTOR-KEY-MIXTURE" "iss109_w")
    ("ISSUE:DEFSTRUCT-CONSTRUCTOR-OPTIONS" "iss110_w")
    ("ISSUE:DEFSTRUCT-CONSTRUCTOR-SLOT-VARIABLES" "iss111_w")
    ("ISSUE:DEFSTRUCT-COPIER-ARGUMENT-TYPE" "iss112_w")
    ("ISSUE:DEFSTRUCT-COPIER" "iss113_w")
    ("ISSUE:DEFSTRUCT-DEFAULT-VALUE-EVALUATION" "iss114_w")
    ("ISSUE:DEFSTRUCT-INCLUDE-DEFTYPE" "iss115_w")
    ("ISSUE:DEFSTRUCT-PRINT-FUNCTION-AGAIN" "iss116_w")
    ("ISSUE:DEFSTRUCT-PRINT-FUNCTION-INHERITANCE" "iss117_w")
    ("ISSUE:DEFSTRUCT-REDEFINITION" "iss118_w")
    ("ISSUE:DEFSTRUCT-SLOTS-CONSTRAINTS-NAME" "iss119_w")
    ("ISSUE:DEFSTRUCT-SLOTS-CONSTRAINTS-NUMBER" "iss120_w")
    ("ISSUE:DEFTYPE-DESTRUCTURING" "iss121_w")
    ("ISSUE:DEFTYPE-KEY" "iss122_w")
    ("ISSUE:DEFVAR-DOCUMENTATION" "iss123_w")
    ("ISSUE:DEFVAR-INIT-TIME" "iss124_w")
    ("ISSUE:DEFVAR-INITIALIZATION" "iss125_w")
    ("ISSUE:DEPRECATION-POSITION" "iss126_w")
    ("ISSUE:DESCRIBE-INTERACTIVE" "iss127_w")
    ("ISSUE:DESCRIBE-UNDERSPECIFIED" "iss128_w")
    ("ISSUE:DESTRUCTIVE-OPERATIONS" "iss129_w")
    ("ISSUE:DESTRUCTURING-BIND" "iss130_w")
    ("ISSUE:DISASSEMBLE-SIDE-EFFECT" "iss131_w")
    ("ISSUE:DISPLACED-ARRAY-PREDICATE" "iss132_w")
    ("ISSUE:DO-SYMBOLS-BLOCK-SCOPE" "iss133_w")
    ("ISSUE:DO-SYMBOLS-DUPLICATES" "iss134_w")
    ("ISSUE:DOCUMENTATION-FUNCTION-BUGS" "iss135_w")
    ("ISSUE:DOCUMENTATION-FUNCTION-TANGLED" "iss136_w")
    ("ISSUE:DOTIMES-IGNORE" "iss137_w")
    ("ISSUE:DOTTED-LIST-ARGUMENTS" "iss138_w")
    ("ISSUE:DOTTED-MACRO-FORMS" "iss139_w")
    ("ISSUE:DRIBBLE-TECHNIQUE" "iss140_w")
    ("ISSUE:DYNAMIC-EXTENT-FUNCTION" "iss141_w")
    ("ISSUE:DYNAMIC-EXTENT" "iss142_w")
    ("ISSUE:EQUAL-STRUCTURE" "iss143_w")
    ("ISSUE:ERROR-TERMINOLOGY-WARNING" "iss144_w")
    ("ISSUE:EVAL-OTHER" "iss145_w")
    ("ISSUE:EVAL-TOP-LEVEL" "iss146_w")
    ("ISSUE:EVAL-WHEN-NON-TOP-LEVEL" "iss147_w")
    ("ISSUE:EVAL-WHEN-OBSOLETE-KEYWORDS" "iss148_w")
    ("ISSUE:EVALHOOK-STEP-CONFUSION" "iss149_w")
    ("ISSUE:EXIT-EXTENT-AND-CONDITION-SYSTEM" "iss151_w")
    ("ISSUE:EXIT-EXTENT" "iss152_w")
    ("ISSUE:EXPT-RATIO" "iss153_w")
    ("ISSUE:EXTENSIONS-POSITION" "iss154_w")
    ("ISSUE:EXTERNAL-FORMAT-FOR-EVERY-FILE-CONNECTION" "iss155_w")
    ("ISSUE:EXTRA-RETURN-VALUES" "iss156_w")
    ("ISSUE:FILE-OPEN-ERROR" "iss157_w")
    ("ISSUE:FIXNUM-NON-PORTABLE" "iss158_w")
    ("ISSUE:FLET-DECLARATIONS" "iss159_w")
    ("ISSUE:FLET-IMPLICIT-BLOCK" "iss161_w")
    ("ISSUE:FLOAT-UNDERFLOW" "iss162_w")
    ("ISSUE:FLOATING-POINT-CONDITION-NAMES" "iss163_w")
    ("ISSUE:FORMAT-ATSIGN-COLON" "iss164_w")
    ("ISSUE:FORMAT-COLON-UPARROW-SCOPE" "iss165_w")
    ("ISSUE:FORMAT-COMMA-INTERVAL" "iss166_w")
    ("ISSUE:FORMAT-E-EXPONENT-SIGN" "iss167_w")
    ("ISSUE:FORMAT-OP-C" "iss168_w")
    ("ISSUE:FORMAT-PRETTY-PRINT" "iss169_w")
    ("ISSUE:FORMAT-STRING-ARGUMENTS" "iss170_w")
    ("ISSUE:FUNCTION-CALL-EVALUATION-ORDER" "iss171_w")
    ("ISSUE:FUNCTION-COMPOSITION" "iss172_w")
    ("ISSUE:FUNCTION-DEFINITION" "iss173_w")
    ("ISSUE:FUNCTION-NAME" "iss174_w")
    ("ISSUE:FUNCTION-TYPE-ARGUMENT-TYPE-SEMANTICS" "iss176_w")
    ("ISSUE:FUNCTION-TYPE-KEY-NAME" "iss177_w")
    ("ISSUE:FUNCTION-TYPE-REST-LIST-ELEMENT" "iss178_w")
    ("ISSUE:FUNCTION-TYPE" "iss175_w")
    ("ISSUE:GENERALIZE-PRETTY-PRINTER" "iss180_w")
    ("ISSUE:GENERIC-FLET-POORLY-DESIGNED" "iss181_w")
    ("ISSUE:GENSYM-NAME-STICKINESS" "iss182_w")
    ("ISSUE:GENTEMP-BAD-IDEA" "iss183_w")
    ("ISSUE:GET-MACRO-CHARACTER-READTABLE" "iss184_w")
    ("ISSUE:GET-SETF-METHOD-ENVIRONMENT" "iss185_w")
    ("ISSUE:HASH-TABLE-ACCESS" "iss186_w")
    ("ISSUE:HASH-TABLE-KEY-MODIFICATION" "iss187_w")
    ("ISSUE:HASH-TABLE-PACKAGE-GENERATORS" "iss188_w")
    ("ISSUE:HASH-TABLE-REHASH-SIZE-INTEGER" "iss189_w")
    ("ISSUE:HASH-TABLE-SIZE" "iss190_w")
    ("ISSUE:HASH-TABLE-TESTS" "iss191_w")
    ("ISSUE:IEEE-ATAN-BRANCH-CUT" "iss192_w")
    ("ISSUE:IGNORE-USE-TERMINOLOGY" "iss193_w")
    ("ISSUE:IMPORT-SETF-SYMBOL-PACKAGE" "iss194_w")
    ("ISSUE:IN-PACKAGE-FUNCTIONALITY" "iss195_w")
    ("ISSUE:IN-SYNTAX" "iss196_w")
    ("ISSUE:INITIALIZATION-FUNCTION-KEYWORD-CHECKING" "iss197_w")
    ("ISSUE:ISO-COMPATIBILITY" "iss198_w")
    ("ISSUE:JUN90-TRIVIAL-ISSUES" "iss199_w")
    ("ISSUE:KEYWORD-ARGUMENT-NAME-PACKAGE" "iss208_w")
    ("ISSUE:LAST-N" "iss209_w")
    ("ISSUE:LCM-NO-ARGUMENTS" "iss210_w")
    ("ISSUE:LEXICAL-CONSTRUCT-GLOBAL-DEFINITION" "iss211_w")
    ("ISSUE:LISP-PACKAGE-NAME" "iss212_w")
    ("ISSUE:LISP-SYMBOL-REDEFINITION-AGAIN" "iss213_w")
    ("ISSUE:LISP-SYMBOL-REDEFINITION" "iss214_w")
    ("ISSUE:LOAD-OBJECTS" "iss215_w")
    ("ISSUE:LOAD-TIME-EVAL" "iss216_w")
    ("ISSUE:LOAD-TRUENAME" "iss218_w")
    ("ISSUE:LOCALLY-TOP-LEVEL" "iss219_w")
    ("ISSUE:LOOP-AND-DISCREPANCY" "iss220_w")
    ("ISSUE:LOOP-FOR-AS-ON-TYPO" "iss221_w")
    ("ISSUE:LOOP-INITFORM-ENVIRONMENT" "iss222_w")
    ("ISSUE:LOOP-MISCELLANEOUS-REPAIRS" "iss223_w")
    ("ISSUE:LOOP-NAMED-BLOCK-NIL" "iss224_w")
    ("ISSUE:LOOP-PRESENT-SYMBOLS-TYPO" "iss225_w")
    ("ISSUE:LOOP-SYNTAX-OVERHAUL" "iss226_w")
    ("ISSUE:MACRO-AS-FUNCTION" "iss227_w")
    ("ISSUE:MACRO-DECLARATIONS" "iss228_w")
    ("ISSUE:MACRO-ENVIRONMENT-EXTENT" "iss229_w")
    ("ISSUE:MACRO-FUNCTION-ENVIRONMENT" "iss230_w")
    ("ISSUE:MACRO-SUBFORMS-TOP-LEVEL-P" "iss232_w")
    ("ISSUE:MACROEXPAND-HOOK-DEFAULT" "iss233_w")
    ("ISSUE:MACROEXPAND-HOOK-INITIAL-VALUE" "iss234_w")
    ("ISSUE:MACROEXPAND-RETURN-VALUE" "iss235_w")
    ("ISSUE:MAKE-LOAD-FORM-CONFUSION" "iss236_w")
    ("ISSUE:MAKE-LOAD-FORM-SAVING-SLOTS" "iss237_w")
    ("ISSUE:MAKE-PACKAGE-USE-DEFAULT" "iss238_w")
    ("ISSUE:MAP-INTO" "iss239_w")
    ("ISSUE:MAPPING-DESTRUCTIVE-INTERACTION" "iss240_w")
    ("ISSUE:METACLASS-OF-SYSTEM-CLASS" "iss241_w")
    ("ISSUE:METHOD-COMBINATION-ARGUMENTS" "iss242_w")
    ("ISSUE:METHOD-INITFORM" "iss243_w")
    ("ISSUE:MUFFLE-WARNING-CONDITION-ARGUMENT" "iss244_w")
    ("ISSUE:MULTIPLE-VALUE-SETQ-ORDER" "iss245_w")
    ("ISSUE:MULTIPLE-VALUES-LIMIT-ON-VARIABLES" "iss246_w")
    ("ISSUE:NINTERSECTION-DESTRUCTION" "iss247_w")
    ("ISSUE:NOT-AND-NULL-RETURN-VALUE" "iss249_w")
    ("ISSUE:NTH-VALUE" "iss250_w")
    ("ISSUE:OPTIMIZE-DEBUG-INFO" "iss251_w")
    ("ISSUE:PACKAGE-CLUTTER" "iss252_w")
    ("ISSUE:PACKAGE-DELETION" "iss253_w")
    ("ISSUE:PACKAGE-FUNCTION-CONSISTENCY" "iss254_w")
    ("ISSUE:PARSE-ERROR-STREAM" "iss255_w")
    ("ISSUE:PATHNAME-COMPONENT-CASE" "iss256_w")
    ("ISSUE:PATHNAME-COMPONENT-VALUE" "iss257_w")
    ("ISSUE:PATHNAME-HOST-PARSING" "iss258_w")
    ("ISSUE:PATHNAME-LOGICAL" "iss259_w")
    ("ISSUE:PATHNAME-PRINT-READ" "iss260_w")
    ("ISSUE:PATHNAME-STREAM" "iss261_w")
    ("ISSUE:PATHNAME-SUBDIRECTORY-LIST" "iss263_w")
    ("ISSUE:PATHNAME-SYMBOL" "iss264_w")
    ("ISSUE:PATHNAME-SYNTAX-ERROR-TIME" "iss265_w")
    ("ISSUE:PATHNAME-UNSPECIFIC-COMPONENT" "iss266_w")
    ("ISSUE:PATHNAME-WILD" "iss267_w")
    ("ISSUE:PEEK-CHAR-READ-CHAR-ECHO" "iss268_w")
    ("ISSUE:PLIST-DUPLICATES" "iss269_w")
    ("ISSUE:PRETTY-PRINT-INTERFACE" "iss270_w")
    ("ISSUE:PRINC-READABLY" "iss271_w")
    ("ISSUE:PRINT-CASE-BEHAVIOR" "iss272_w")
    ("ISSUE:PRINT-CASE-PRINT-ESCAPE-INTERACTION" "iss273_w")
    ("ISSUE:PRINT-CIRCLE-SHARED" "iss274_w")
    ("ISSUE:PRINT-CIRCLE-STRUCTURE" "iss275_w")
    ("ISSUE:PRINT-READABLY-BEHAVIOR" "iss276_w")
    ("ISSUE:PRINTER-WHITESPACE" "iss277_w")
    ("ISSUE:PROCLAIM-ETC-IN-COMPILE-FILE" "iss278_w")
    ("ISSUE:PUSH-EVALUATION-ORDER" "iss279_w")
    ("ISSUE:PUSHNEW-STORE-REQUIRED" "iss281_w")
    ("ISSUE:QUOTE-SEMANTICS" "iss282_w")
    ("ISSUE:RANGE-OF-COUNT-KEYWORD" "iss283_w")
    ("ISSUE:RANGE-OF-START-AND-END-PARAMETERS" "iss284_w")
    ("ISSUE:READ-AND-WRITE-BYTES" "iss285_w")
    ("ISSUE:READ-CASE-SENSITIVITY" "iss286_w")
    ("ISSUE:READ-MODIFY-WRITE-EVALUATION-ORDER" "iss287_w")
    ("ISSUE:READ-SUPPRESS-CONFUSING" "iss288_w")
    ("ISSUE:READER-ERROR" "iss289_w")
    ("ISSUE:REAL-NUMBER-TYPE" "iss290_w")
    ("ISSUE:RECURSIVE-DEFTYPE" "iss291_w")
    ("ISSUE:REDUCE-ARGUMENT-EXTRACTION" "iss292_w")
    ("ISSUE:REMF-DESTRUCTION-UNSPECIFIED" "iss293_w")
    ("ISSUE:REQUIRE-PATHNAME-DEFAULTS-AGAIN" "iss294_w")
    ("ISSUE:REQUIRE-PATHNAME-DEFAULTS-YET-AGAIN" "iss295_w")
    ("ISSUE:REQUIRE-PATHNAME-DEFAULTS" "iss296_w")
    ("ISSUE:REST-LIST-ALLOCATION" "iss297_w")
    ("ISSUE:RESULT-LISTS-SHARED" "iss298_w")
    ("ISSUE:RETURN-VALUES-UNSPECIFIED" "iss299_w")
    ("ISSUE:ROOM-DEFAULT-ARGUMENT" "iss300_w")
    ("ISSUE:SELF-MODIFYING-CODE" "iss301_w")
    ("ISSUE:SEQUENCE-TYPE-LENGTH" "iss302_w")
    ("ISSUE:SETF-APPLY-EXPANSION" "iss303_w")
    ("ISSUE:SETF-FIND-CLASS" "iss304_w")
    ("ISSUE:SETF-FUNCTIONS-AGAIN" "iss305_w")
    ("ISSUE:SETF-GET-DEFAULT" "iss306_w")
    ("ISSUE:SETF-MACRO-EXPANSION" "iss307_w")
    ("ISSUE:SETF-METHOD-VS-SETF-METHOD" "iss308_w")
    ("ISSUE:SETF-MULTIPLE-STORE-VARIABLES" "iss309_w")
    ("ISSUE:SETF-OF-APPLY" "iss310_w")
    ("ISSUE:SETF-OF-VALUES" "iss311_w")
    ("ISSUE:SETF-SUB-METHODS" "iss312_w")
    ("ISSUE:SHADOW-ALREADY-PRESENT" "iss313_w")
    ("ISSUE:SHARP-COMMA-CONFUSION" "iss315_w")
    ("ISSUE:SHARP-O-FOOBAR" "iss316_w")
    ("ISSUE:SHARP-STAR-DELIMITER" "iss317_w")
    ("ISSUE:SHARPSIGN-PLUS-MINUS-PACKAGE" "iss318_w")
    ("ISSUE:SLOT-MISSING-VALUES" "iss319_w")
    ("ISSUE:SLOT-VALUE-METACLASSES" "iss320_w")
    ("ISSUE:SPECIAL-FORM-P-MISNOMER" "iss321_w")
    ("ISSUE:SPECIAL-TYPE-SHADOWING" "iss322_w")
    ("ISSUE:STANDARD-INPUT-INITIAL-BINDING" "iss323_w")
    ("ISSUE:STANDARD-REPERTOIRE-GRATUITOUS" "iss324_w")
    ("ISSUE:STEP-ENVIRONMENT" "iss325_w")
    ("ISSUE:STEP-MINIMAL" "iss326_w")
    ("ISSUE:STREAM-ACCESS" "iss327_w")
    ("ISSUE:STREAM-CAPABILITIES" "iss328_w")
    ("ISSUE:STRING-COERCION" "iss329_w")
    ("ISSUE:STRING-OUTPUT-STREAM-BASHING" "iss330_w")
    ("ISSUE:STRUCTURE-READ-PRINT-SYNTAX" "iss331_w")
    ("ISSUE:SUBSEQ-OUT-OF-BOUNDS" "iss332_w")
    ("ISSUE:SUBSETTING-POSITION" "iss333_w")
    ("ISSUE:SUBTYPEP-ENVIRONMENT" "iss334_w")
    ("ISSUE:SUBTYPEP-TOO-VAGUE" "iss335_w")
    ("ISSUE:SXHASH-DEFINITION" "iss336_w")
    ("ISSUE:SYMBOL-MACROLET-DECLARE" "iss337_w")
    ("ISSUE:SYMBOL-MACROLET-SEMANTICS" "iss338_w")
    ("ISSUE:SYMBOL-MACROLET-TYPE-DECLARATION" "iss339_w")
    ("ISSUE:SYMBOL-MACROS-AND-PROCLAIMED-SPECIALS" "iss340_w")
    ("ISSUE:SYMBOL-PRINT-ESCAPE-BEHAVIOR" "iss341_w")
    ("ISSUE:SYNTACTIC-ENVIRONMENT-ACCESS" "iss342_w")
    ("ISSUE:TAGBODY-TAG-EXPANSION" "iss343_w")
    ("ISSUE:TAILP-NIL" "iss344_w")
    ("ISSUE:TEST-NOT-IF-NOT" "iss345_w")
    ("ISSUE:THE-AMBIGUITY" "iss346_w")
    ("ISSUE:THE-VALUES" "iss347_w")
    ("ISSUE:TIME-ZONE-NON-INTEGER" "iss348_w")
    ("ISSUE:TYPE-DECLARATION-ABBREVIATION" "iss349_w")
    ("ISSUE:TYPE-OF-AND-PREDEFINED-CLASSES" "iss350_w")
    ("ISSUE:TYPE-OF-UNDERCONSTRAINED" "iss352_w")
    ("ISSUE:TYPE-SPECIFIER-ABBREVIATION" "iss353_w")
    ("ISSUE:UNDEFINED-VARIABLES-AND-FUNCTIONS" "iss354_w")
    ("ISSUE:UNINITIALIZED-ELEMENTS" "iss355_w")
    ("ISSUE:UNREAD-CHAR-AFTER-PEEK-CHAR" "iss356_w")
    ("ISSUE:UNSOLICITED-MESSAGES" "iss357_w")
    ("ISSUE:VARIABLE-LIST-ASYMMETRY" "iss358_w")
    ("ISSUE:WITH-ADDED-METHODS" "iss359_w")
    ("ISSUE:WITH-COMPILATION-UNIT" "iss360_w")
    ("ISSUE:WITH-OPEN-FILE-DOES-NOT-EXIST" "iss361_w")
    ("ISSUE:WITH-OPEN-FILE-SETQ" "iss362_w")
    ("ISSUE:WITH-OPEN-FILE-STREAM-EXTENT" "iss363_w")
    ("ISSUE:WITH-OUTPUT-TO-STRING-APPEND-STYLE" "iss364_w")
    ("ISSUE:WITH-STANDARD-IO-SYNTAX-READTABLE" "iss365_w")))

(defun make-hyperspec-issue-map ()
  (let ((ht (make-hash-table :test #'equal)))
    (loop for entry in *hyperspec-issues*
          do (destructuring-bind (id filename) entry
               (setf (gethash id ht) entry)
               (setf (gethash filename ht) entry)))
    (loop for entry in *hyperspec-issue-summaries*
          do (destructuring-bind (id filename) entry
               (setf (gethash id ht) entry)
               (setf (gethash filename ht) entry)))
    ht))

(defparameter *hyperspec-issue-map* (make-hyperspec-issue-map))

(defun/autoloaded find-hyperspec-issue-id (name)
  (first (gethash name *hyperspec-issue-map*)))

(defun/autoloaded find-hyperspec-issue-url
    (name &optional hyperspec-root)
  (let ((filename (second (gethash name *hyperspec-issue-map*))))
    (when filename
      (hyperspec-link hyperspec-root "Issues/" filename ".htm"))))


(defun hyperspec-link (root dir name &optional more)
  (format nil "~@[~A~]~A~A~@[~A~]" root dir name more))
