(in-package :jpeg-turbo)
(include "turbojpeg.h")
#+(or freebsd OS-MACOSX)
(cc-flags "-I/usr/local/include")

;; Subsampling modes
(cenum subsamp
       ((:s-444  "TJSAMP_444"))
       ((:s-422  "TJSAMP_422"))
       ((:s-420  "TJSAMP_420"))
       ((:s-gray "TJSAMP_GRAY"))
       ((:s-440  "TJSAMP_440"))
       ((:s-411  "TJSAMP_411")))

;; Pixel formats
(cenum pixel-format
       ((:RGB  "TJPF_RGB"))
       ((:BGR  "TJPF_BGR"))
       ((:RGBX "TJPF_RGBX"))
       ((:BGRX "TJPF_BGRX"))
       ((:XBGR "TJPF_XBGR"))
       ((:gray "TJPF_GRAY"))
       ((:RGBA "TJPF_RGBA"))
       ((:BGRA "TJPF_BGRA"))
       ((:ABGR "TJPF_ABGR"))
       ((:ARGB "TJPF_ARGB"))
       ((:CMYK "TJPF_CMYK")))

;; Color spaces
(cenum colorspace
       ((:RGB   "TJCS_RGB"))
       ((:YCbCr "TJCS_YCbCr"))
       ((:gray  "TJCS_GRAY"))
       ((:CMYK  "TJCS_CMYK"))
       ((:YCCK  "TJCS_YCCK")))

;; Flags (documentation taken from libjpeg-turbo header)
(bitfield jpeg-turbo-flags
          ((:bottomup "TJFLAG_BOTTOMUP")
           :documentation "The uncompressed source/destination image
is stored in bottom-up (Windows, OpenGL) order, not top-down (X11)
order.")
          ((:fast-upsample "TJFLAG_FASTUPSAMPLE")
           :documentation "When decompressing an image that was
compressed using chrominance subsampling, use the fastest chrominance
upsampling algorithm available in the underlying codec.  The default
is to use smooth upsampling, which creates a smooth transition between
neighboring chrominance components in order to reduce upsampling
artifacts in the decompressed image.")
          ((:no-realloc "TJFLAG_NOREALLOC")
           :documentation "Disable buffer (re)allocation. If passed to
one of the JPEG compression or transform functions, this flag will
cause those functions to generate an error if the JPEG image buffer is
invalid or too small rather than attempting to allocate or reallocate
that buffer. This reproduces the behavior of earlier versions of
TurboJPEG. @c(NB): this flag is implied in this wrapper to protect
lisp image.")
          ((:fast-dct "TJFLAG_FASTDCT")
           :documentation "Use the fastest DCT/IDCT algorithm
available in the underlying codec. The default if this flag is not
specified is implementation-specific. For example, the implementation
of TurboJPEG for libjpeg[-turbo] uses the fast algorithm by default
when compressing, because this has been shown to have only a very
slight effect on accuracy, but it uses the accurate algorithm when
decompressing, because this has been shown to have a larger effect.")
          ((:accurate-dct "TJFLAG_ACCURATEDCT")
           :documentation "Use the most accurate DCT/IDCT algorithm
available in the underlying codec. The default if this flag is not
specified is implementation-specific. For example, the implementation
of TurboJPEG for libjpeg[-turbo] uses the fast algorithm by default
when compressing, because this has been shown to have only a very
slight effect on accuracy, but it uses the accurate algorithm when
decompressing, because this has been shown to have a larger effect.")
          ((:stop-on-warning "TJFLAG_STOPONWARNING")
           :documentation  "Immediately discontinue the current
compression/decompression/transform operation if the underlying codec
throws a warning (non-fatal error). The default behavior is to allow
the operation to complete unless a fatal error is encountered."
           ;; Present only in new versions
           :optional t)
          ((:progressive "TJFLAG_PROGRESSIVE")
           :documentation "Use progressive entropy coding in JPEG
images generated by the compression and transform
functions. Progressive entropy coding will generally improve
compression relative to baseline entropy coding (the default), but it
will reduce compression and decompression performance considerably."
          ;; Present only in new versions
          :optional t))
