/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-cc.org
   2013-02-19 15:24
   Version 4.8.0.2 (stability/4.8.0) (rev b7e1215)
   macosx-unix-clang-x86-64 [ 64bit manyargs ptables ]
   compiled 2013-02-19 on aeryn.xorinia.dim (Darwin)
   command line: posixwin.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

#if (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>
#include <fcntl.h>
#include <direct.h>
#include <utime.h>
#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_lstat(fn)	    C_stat(fn)

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
        /* Can't barf() here, so the NUL byte check happens in Scheme */
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_umask(m)          C_fix(_umask(C_unfix(m)))

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_a_mktime(ptr, c, v)  C_flonum(ptr, mktime(C_tm_set(v)))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
            /* This _should_ already have been checked for embedded NUL bytes */
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static int set_file_mtime(char *filename, C_word tm)
{
  struct _utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return _utime(filename, &tb);
}

#include <signal.h>
#include <errno.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[404];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,14),40,102,95,50,49,54,49,32,97,54,52,54,55,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,54,57,32,108,111,99,55,48,32,109,115,103,55,49,32,46,32,97,114,103,115,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,52,32,108,105,110,107,56,53,32,101,114,114,56,54,32,108,111,99,56,55,41,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,115,116,97,116,32,102,57,57,32,46,32,116,109,112,57,56,49,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,53,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,50,56,41,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,52,41,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,51,55,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,53,32,46,32,116,109,112,49,52,52,49,52,54,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,52,41,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,16),40,102,95,50,51,55,50,32,102,105,108,101,49,54,54,41};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,16),40,102,95,50,51,56,49,32,102,105,108,101,49,54,56,41};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,50,51,57,48,32,102,105,108,101,49,55,48,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,16),40,102,95,50,51,57,57,32,102,105,108,101,49,55,50,41};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,16),40,102,95,50,52,48,56,32,102,105,108,101,49,55,52,41};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,54,41,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,49,56,50,32,109,49,56,51,32,108,111,99,49,56,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,49,57,52,32,102,100,49,57,53,32,105,110,112,49,57,54,32,114,49,57,55,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,21),40,102,95,50,52,55,57,32,102,100,50,48,48,32,46,32,109,50,48,49,41,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,21),40,102,95,50,52,57,50,32,102,100,50,48,51,32,46,32,109,50,48,52,41,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,16),40,102,95,50,53,48,53,32,112,111,114,116,50,49,48,41};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,24),40,102,95,50,53,52,57,32,111,108,100,50,49,56,32,46,32,110,101,119,50,49,57,41};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,51,48,50,51,49,41,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,53,56,41,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,13),40,102,95,50,54,51,54,32,102,50,55,52,41,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,54,52,32,103,50,55,49,50,56,49,41,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,53,48,32,46,32,116,109,112,50,52,57,50,53,49,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,57,51,50,57,52,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,8),40,102,95,50,56,51,52,41};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,13),40,102,95,50,56,54,57,32,109,51,53,55,41,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,51,52,57,41,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,47),40,102,95,50,56,51,57,32,100,105,114,51,51,50,51,51,51,51,51,56,32,102,105,108,51,51,52,51,51,53,51,51,57,32,101,120,116,51,51,54,51,51,55,51,52,48,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,51,51,48,41,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,51,50,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,8),40,102,95,50,57,56,53,41};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,8),40,102,95,50,57,57,48,41};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,8),40,102,95,51,48,49,48,41};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,51,56,54,32,114,51,56,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,13),40,102,95,51,48,54,51,32,120,51,56,52,41,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,15),40,102,95,51,48,56,51,32,46,32,95,51,55,56,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,15),40,102,95,51,48,55,52,32,46,32,95,51,55,55,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,8),40,102,95,51,49,48,56,41};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,8),40,102,95,51,49,49,49,41};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,8),40,102,95,51,49,49,52,41};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,8),40,102,95,51,49,49,55,41};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,18),40,102,95,51,49,50,50,32,120,52,50,48,32,121,52,50,49,41,0,0,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,8),40,102,95,51,49,50,48,41};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,15),40,102,95,51,49,50,57,32,46,32,95,52,49,56,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,8),40,102,95,51,49,50,55,41};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,49,53,32,46,32,116,109,112,52,49,52,52,49,54,41,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,52,52,52,32,116,109,52,52,53,41};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,52,53,50,52,53,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,52,54,53,52,54,54,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,16),40,102,95,51,49,57,54,32,97,52,55,53,52,55,56,41};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,52,56,52,52,56,53,41,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,52,57,52,41,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,16),40,102,95,51,50,53,53,32,97,53,48,48,53,48,51,41};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,24),40,102,95,51,50,54,49,32,97,53,48,54,53,48,57,32,97,53,48,53,53,49,48,41};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,53,49,55,32,46,32,116,109,112,53,49,54,53,49,56,41};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,53,51,49,32,112,114,111,99,53,51,50,41,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,8),40,102,95,51,51,53,55,41};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,34),40,102,95,51,51,54,50,32,101,112,105,100,53,53,54,32,101,110,111,114,109,53,53,55,32,101,99,111,100,101,53,53,56,41,0,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,53,52,49,41};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,54,50,55,32,102,108,97,103,115,54,50,56,32,46,32,109,111,100,101,54,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,54,51,56,41,0,0,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,54,52,50,32,115,105,122,101,54,52,51,32,46,32,98,117,102,102,101,114,54,52,52,41,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,54,53,52,32,98,117,102,102,101,114,54,53,53,32,46,32,115,105,122,101,54,53,54,41,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,54,54,54,41,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,54,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,17),40,102,95,51,53,57,48,32,102,110,97,109,101,54,56,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,16),40,102,95,51,53,56,56,32,110,97,109,101,54,56,48,41};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,54,56,55,32,112,111,115,54,56,56,32,46,32,119,104,101,110,99,101,54,56,57,41,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,16),40,102,95,51,54,57,54,32,110,97,109,101,55,52,50,41};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,16),40,102,95,51,54,56,57,32,110,97,109,101,55,51,57,41};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,13),40,102,95,51,54,56,51,32,120,55,51,54,41,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,50,54,32,103,55,51,51,55,52,54,41,0,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,16),40,102,95,51,54,55,55,32,110,97,109,101,55,50,49,41};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,16),40,102,95,51,55,52,55,32,110,97,109,101,55,53,50,41};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,55,49,49,32,46,32,116,109,112,55,49,48,55,49,50,41,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,55,53,55,41,0,0,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,55,54,55,32,105,110,112,55,54,56,32,114,55,54,57,41,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,55,55,51,32,46,32,109,55,55,52,41,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,55,56,50,32,46,32,109,55,56,51,41};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,55,57,49,41,0,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,55,57,54,41,0,0,0,0,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,8),40,102,95,51,57,52,53,41};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,21),40,102,95,51,57,53,48,32,46,32,114,101,115,117,108,116,115,56,49,50,41,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,56,48,56,32,112,114,111,99,56,48,57,32,46,32,109,111,100,101,56,49,48,41,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,8),40,102,95,51,57,54,55,41};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,21),40,102,95,51,57,55,50,32,46,32,114,101,115,117,108,116,115,56,49,57,41,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,56,49,53,32,112,114,111,99,56,49,54,32,46,32,109,111,100,101,56,49,55,41};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,8),40,102,95,51,57,56,57,41};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,21),40,102,95,51,57,57,57,32,46,32,114,101,115,117,108,116,115,56,51,52,41,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,8),40,102,95,51,57,57,52,41};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,8),40,102,95,52,48,48,55,41};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,56,50,50,32,116,104,117,110,107,56,50,51,32,46,32,109,111,100,101,56,50,52,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,8),40,102,95,52,48,50,49,41};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,21),40,102,95,52,48,51,49,32,46,32,114,101,115,117,108,116,115,56,53,49,41,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,8),40,102,95,52,48,50,54,41};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,8),40,102,95,52,48,51,57,41};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,56,51,57,32,116,104,117,110,107,56,52,48,32,46,32,109,111,100,101,56,52,49,41,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,116,109,112,56,54,48,56,54,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,57,51,53,32,109,57,51,54,41};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,57,52,49,32,97,99,99,57,52,50,32,108,111,99,57,52,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,57,52,55,41,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,57,52,56,41};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,57,52,57,41,0,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,57,53,56,32,109,57,53,57,32,108,111,99,57,54,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,25),40,99,104,101,99,107,32,102,100,57,55,48,32,105,110,112,57,55,49,32,114,57,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,57,55,54,32,46,32,109,57,55,55,41,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,57,55,57,32,46,32,109,57,56,48,41};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,57,56,54,41,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,57,57,50,32,46,32,110,101,119,57,57,51,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,24),40,115,101,116,101,110,118,32,118,97,114,49,48,48,49,32,118,97,108,49,48,48,50,41};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,18),40,117,110,115,101,116,101,110,118,32,118,97,114,49,48,48,55,41,0,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,18),40,102,95,52,51,54,55,32,97,49,48,49,50,49,48,49,53,41,0,0,0,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,12),40,115,99,97,110,32,106,49,48,50,49,41,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,48,49,56,41,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,18),40,102,95,52,52,52,50,32,97,49,48,51,48,49,48,51,51,41,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,48,51,52,41,0,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,48,51,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,48,52,49,41};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,48,52,51,32,109,111,100,101,49,48,52,52,32,46,32,115,105,122,101,49,48,52,53,41,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,14),40,102,95,52,53,54,49,32,115,49,48,54,52,41,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,105,108,115,116,49,48,55,51,32,111,108,115,116,49,48,55,52,41};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,37),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,49,48,54,49,32,101,120,97,99,116,102,49,48,54,50,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,38),40,102,95,52,54,50,55,32,97,49,48,56,51,49,48,56,55,32,97,49,48,56,50,49,48,56,56,32,97,49,48,56,49,49,48,56,57,41,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,38),40,102,95,52,54,52,53,32,97,49,48,57,51,49,48,57,55,32,97,49,48,57,50,49,48,57,56,32,97,49,48,57,49,49,48,57,57,41,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,24),40,100,111,108,111,111,112,49,49,48,53,32,108,49,49,48,55,32,105,49,49,48,56,41};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,50),40,102,95,52,54,54,51,32,108,111,99,49,49,48,49,32,108,115,116,49,49,48,50,32,97,114,103,118,101,99,45,115,101,116,116,101,114,49,49,48,51,32,105,100,120,49,49,48,52,41,0,0,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,67),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,49,49,49,52,32,102,105,108,101,110,97,109,101,49,49,49,53,32,97,114,103,108,115,116,49,49,49,54,32,101,110,118,108,115,116,49,49,49,55,32,101,120,97,99,116,102,49,49,49,56,41,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,53),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,49,49,50,55,32,109,115,103,49,49,50,56,32,102,105,108,101,110,97,109,101,49,49,50,57,32,114,101,115,49,49,51,48,41,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,49,52,48,32,46,32,116,109,112,49,49,51,57,49,49,52,49,41,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,51),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,49,49,54,49,32,102,105,108,101,110,97,109,101,49,49,54,50,32,46,32,116,109,112,49,49,54,48,49,49,54,51,41,0,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,49,56,51,41,0,0,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,49,56,53,32,46,32,97,114,103,115,49,49,56,54,41,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,88),40,102,95,52,57,50,49,32,97,49,49,57,55,49,50,48,55,32,97,49,49,57,54,49,50,48,56,32,97,49,49,57,53,49,50,48,57,32,97,49,49,57,52,49,50,49,48,32,97,49,49,57,51,49,50,49,49,32,97,49,49,57,50,49,50,49,50,32,97,49,49,57,49,49,50,49,51,32,97,49,49,57,48,49,50,49,52,41};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,97),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,50,50,55,32,99,109,100,49,50,50,56,32,97,114,103,115,49,50,50,57,32,101,110,118,49,50,51,48,32,115,116,100,111,117,116,102,49,50,51,49,32,115,116,100,105,110,102,49,50,51,50,32,115,116,100,101,114,114,102,49,50,51,51,32,46,32,116,109,112,49,50,50,54,49,50,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,22),40,102,95,53,48,54,54,32,103,49,51,48,56,49,51,48,57,49,51,49,48,41,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,29),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,50,57,53,32,103,49,51,48,50,49,51,49,52,41,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,16),40,102,95,53,48,54,50,32,108,115,116,49,50,57,50,41};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,8),40,102,95,53,49,48,52,41};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,39),40,102,95,53,49,48,57,32,105,110,49,51,50,49,32,111,117,116,49,51,50,50,32,112,105,100,49,51,50,51,32,101,114,114,49,51,50,52,41,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,61),40,102,95,53,48,54,48,32,108,111,99,49,50,56,53,32,101,114,114,63,49,50,56,54,32,99,109,100,49,50,56,55,32,97,114,103,115,49,50,56,56,32,101,110,118,49,50,56,57,32,101,120,97,99,116,102,49,50,57,48,41,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,51,51,51,32,46,32,116,109,112,49,51,51,50,49,51,51,52,41,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,51,53,50,32,46,32,116,109,112,49,51,53,49,49,51,53,51,41};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,51,54,56,32,110,111,104,97,110,103,49,51,54,57,41,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,17),40,115,108,101,101,112,32,97,49,51,55,49,49,51,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,46,32,95,49,52,48,57,49,52,49,51,41,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,49,52,49,54,49,52,50,48,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,49,52,50,50,49,52,50,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,28),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,49,52,50,56,49,52,51,50,41,0,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,52,51,52,49,52,51,56,41,0,0,0,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,40),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,49,52,52,48,49,52,52,52,41};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,39),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,49,52,52,54,49,52,53,48,41,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,41),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,49,52,53,50,49,52,53,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,30),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,49,52,53,56,49,52,54,50,41,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,49,52,54,52,49,52,54,56,41,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,32),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,46,32,95,49,52,55,48,49,52,55,52,41};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,105,110,107,32,46,32,95,49,52,55,54,49,52,56,48,41,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,111,99,107,32,46,32,95,49,52,56,50,49,52,56,54,41,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,49,52,56,56,49,52,57,50,41};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,49,52,57,52,49,52,57,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,49,53,48,48,49,53,48,52,41,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,49,53,48,54,49,53,49,48,41,0,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,49,53,49,50,49,53,49,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,24),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,49,53,49,56,49,53,50,50,41};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,31),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,53,50,52,49,53,50,56,41,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,31),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,49,53,51,48,49,53,51,52,41,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,40),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,46,32,95,49,53,51,54,49,53,52,48,41};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,31),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,49,53,52,50,49,53,52,54,41,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,49,53,52,56,49,53,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,49,53,53,52,49,53,53,56,41,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,49,53,54,48,49,53,54,52,41,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,32),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,53,54,54,49,53,55,48,41};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,49,53,55,50,49,53,55,54,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,53,55,56,49,53,56,50,41,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,49,53,56,52,49,53,56,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,35),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,53,57,48,49,53,57,52,41,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,33),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,49,53,57,54,49,54,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,54,48,50,49,54,48,54,41,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,49,54,48,56,49,54,49,50,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,25),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,49,54,49,52,49,54,49,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,26),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,54,50,48,49,54,50,52,41,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,49,54,50,54,49,54,51,48,41,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,49,54,51,50,49,54,51,54,41,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,49,54,51,56,49,54,52,50,41,0,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,36),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,46,32,95,49,54,52,52,49,54,52,56,41,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,30),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,54,53,48,49,54,53,52,41,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,31),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,49,54,53,54,49,54,54,48,41,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,26),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,49,54,54,50,49,54,54,54,41,0,0,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,13),40,102,105,102,111,63,32,95,49,54,54,57,41,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,95,49,54,55,49,41,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,16),40,102,95,53,53,57,57,32,112,111,114,116,54,57,57,41};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,15),40,102,95,53,54,51,54,32,115,105,103,53,51,55,41,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,20),40,102,95,53,54,52,52,32,46,32,116,109,112,52,51,49,52,51,50,41,0,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,14),40,102,95,53,54,54,52,32,117,109,52,52,49,41,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,13),40,102,95,53,54,54,57,32,102,49,48,56,41,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,24),40,102,95,53,54,55,56,32,97,49,49,54,49,50,48,32,97,49,49,53,49,50,49,41};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,18),40,102,95,53,54,55,52,32,102,49,49,48,32,116,49,49,49,41,0,0,0,0,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k5261 */
static C_word C_fcall stub1372(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1372(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from k4952 */
static C_word C_fcall stub1198(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub1198(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from k4655 */
static C_word C_fcall stub1094(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1094(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k4637 */
static C_word C_fcall stub1084(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1084(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4445 */
static C_word C_fcall stub1031(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1031(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1025(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1025(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
C_return(z);
C_ret:
#undef return

return C_r;}

/* from k4374 */
static C_word C_fcall stub1013(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1013(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from f_3261 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static C_word C_fcall stub507(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub507(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from f_3255 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static C_word C_fcall stub501(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub501(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3203 */
static C_word C_fcall stub476(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub476(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k5681 */
static C_word C_fcall stub117(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub117(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2168 */
static C_word C_fcall stub65(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub65(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_2999)
static void C_ccall f_2999(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2996)
static void C_ccall f_2996(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2990)
static void C_ccall f_2990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3431)
static void C_fcall f_3431(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5190)
static void C_ccall f_5190(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5190)
static void C_ccall f_5190r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2985)
static void C_ccall f_2985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2983)
static void C_ccall f_2983(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4249)
static void C_ccall f_4249(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4245)
static void C_fcall f_4245(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2521)
static void C_ccall f_2521(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2529)
static void C_ccall f_2529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3459)
static void C_ccall f_3459(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2711)
static void C_ccall f_2711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4262)
static void C_ccall f_4262(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4262)
static void C_ccall f_4262r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4260)
static void C_ccall f_4260(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3880)
static void C_ccall f_3880(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3886)
static void C_ccall f_3886(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2645)
static void C_ccall f_2645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2587)
static void C_ccall f_2587(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5704)
static void C_ccall f_5704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5599)
static void C_ccall f_5599(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5575)
static void C_ccall f_5575(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5579)
static void C_ccall f_5579(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2612)
static void C_fcall f_2612(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2616)
static void C_ccall f_2616(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2572)
static void C_ccall f_2572(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2572)
static void C_ccall f_2572r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2549)
static void C_ccall f_2549(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2549)
static void C_ccall f_2549r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2544)
static void C_ccall f_2544(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2636)
static void C_ccall f_2636(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2635)
static void C_ccall f_2635(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2630)
static void C_ccall f_2630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2651)
static void C_ccall f_2651(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3793)
static void C_ccall f_3793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5520)
static void C_ccall f_5520(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5526)
static void C_ccall f_5526(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3781)
static void C_ccall f_3781(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5514)
static void C_ccall f_5514(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3786)
static void C_ccall f_3786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2555)
static void C_fcall f_2555(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4988)
static void C_ccall f_4988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5502)
static void C_ccall f_5502(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5508)
static void C_ccall f_5508(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2834)
static void C_ccall f_2834(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2839)
static void C_ccall f_2839(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2820)
static void C_fcall f_2820(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2850)
static void C_fcall f_2850(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3281)
static void C_ccall f_3281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2842)
static void C_ccall f_2842(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2848)
static void C_ccall f_2848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3274)
static void C_ccall f_3274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3601)
static void C_ccall f_3601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3605)
static void C_ccall f_3605(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3609)
static void C_ccall f_3609(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3611)
static void C_ccall f_3611(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3611)
static void C_ccall f_3611r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3615)
static void C_fcall f_3615(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3292)
static void C_ccall f_3292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3290)
static void C_ccall f_3290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2814)
static void C_ccall f_2814(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2814)
static void C_ccall f_2814r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3329)
static void C_ccall f_3329(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3980)
static void C_ccall f_3980(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3980)
static void C_ccall f_3980r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3984)
static void C_ccall f_3984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3989)
static void C_ccall f_3989(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3621)
static void C_ccall f_3621(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3117)
static void C_ccall f_3117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3114)
static void C_ccall f_3114(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3627)
static void C_ccall f_3627(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3111)
static void C_ccall f_3111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3205)
static void C_ccall f_3205(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3205)
static void C_ccall f_3205r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3972)
static void C_ccall f_3972(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3972)
static void C_ccall f_3972r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3975)
static void C_ccall f_3975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3108)
static void C_ccall f_3108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3103)
static void C_ccall f_3103(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3633)
static void C_ccall f_3633(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3101)
static void C_ccall f_3101(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3962)
static void C_ccall f_3962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3967)
static void C_ccall f_3967(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4885)
static void C_ccall f_4885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3214)
static void C_ccall f_3214(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2784)
static void C_ccall f_2784(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3210)
static void C_ccall f_3210(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4690)
static void C_ccall f_4690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3175)
static void C_ccall f_3175(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3175)
static void C_ccall f_3175r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5568)
static void C_ccall f_5568(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5562)
static void C_ccall f_5562(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4673)
static void C_fcall f_4673(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5556)
static void C_ccall f_5556(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5550)
static void C_ccall f_5550(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3196)
static void C_ccall f_3196(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3813)
static void C_fcall f_3813(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4663)
static void C_ccall f_4663(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_3817)
static void C_ccall f_3817(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5544)
static void C_ccall f_5544(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3180)
static void C_ccall f_3180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5538)
static void C_ccall f_5538(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5532)
static void C_ccall f_5532(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3136)
static void C_fcall f_3136(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3134)
static void C_ccall f_3134(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3129)
static void C_ccall f_3129(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3127)
static void C_ccall f_3127(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3122)
static void C_ccall f_3122(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3120)
static void C_ccall f_3120(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4327)
static void C_ccall f_4327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4325)
static void C_fcall f_4325(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3154)
static void C_ccall f_3154(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3154)
static void C_ccall f_3154r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3159)
static void C_ccall f_3159(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3858)
static void C_ccall f_3858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4810)
static void C_ccall f_4810(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4810)
static void C_ccall f_4810r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5257)
static void C_ccall f_5257(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4300)
static void C_ccall f_4300(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3828)
static void C_ccall f_3828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4305)
static void C_ccall f_4305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2406)
static void C_ccall f_2406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2408)
static void C_ccall f_2408(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3830)
static void C_ccall f_3830(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3830)
static void C_ccall f_3830r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4750)
static void C_ccall f_4750(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4750)
static void C_ccall f_4750r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2417)
static void C_ccall f_2417(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2415)
static void C_ccall f_2415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4319)
static void C_ccall f_4319(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4319)
static void C_ccall f_4319r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4739)
static void C_ccall f_4739(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2424)
static void C_ccall f_2424(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2429)
static void C_fcall f_2429(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4034)
static void C_ccall f_4034(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3337)
static void C_ccall f_3337(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3337)
static void C_ccall f_3337r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4826)
static void C_ccall f_4826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4031)
static void C_ccall f_4031(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4031)
static void C_ccall f_4031r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4039)
static void C_ccall f_4039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4735)
static void C_fcall f_4735(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4317)
static void C_ccall f_4317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5669)
static void C_ccall f_5669(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4727)
static void C_ccall f_4727(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5664)
static void C_ccall f_5664(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4026)
static void C_ccall f_4026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3362)
static void C_ccall f_3362(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4021)
static void C_ccall f_4021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4724)
static void C_ccall f_4724(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5678)
static void C_ccall f_5678(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4718)
static void C_ccall f_4718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4376)
static void C_ccall f_4376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5672)
static void C_ccall f_5672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5674)
static void C_ccall f_5674(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3357)
static void C_ccall f_3357(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4716)
static void C_ccall f_4716(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4714)
static void C_ccall f_4714(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5683)
static void C_ccall f_5683(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3849)
static void C_ccall f_3849(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4705)
static void C_fcall f_4705(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_3843)
static void C_ccall f_3843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5692)
static void C_ccall f_5692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2670)
static void C_ccall f_2670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2477)
static void C_ccall f_2477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2479)
static void C_ccall f_2479(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2479)
static void C_ccall f_2479r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4386)
static void C_ccall f_4386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4382)
static void C_fcall f_4382(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2661)
static void C_fcall f_2661(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4332)
static void C_ccall f_4332(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2694)
static void C_ccall f_2694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2690)
static void C_ccall f_2690(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2690)
static void C_ccall f_2690r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2490)
static void C_ccall f_2490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4367)
static void C_ccall f_4367(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4365)
static void C_ccall f_4365(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2492)
static void C_ccall f_2492(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2492)
static void C_ccall f_2492r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3516)
static void C_ccall f_3516(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3516)
static void C_ccall f_3516r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4394)
static void C_fcall f_4394(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2436)
static void C_ccall f_2436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4344)
static void C_ccall f_4344(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3904)
static void C_ccall f_3904(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3908)
static void C_ccall f_3908(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4051)
static void C_ccall f_4051(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5636)
static void C_ccall f_5636(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4059)
static void C_ccall f_4059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3524)
static void C_fcall f_3524(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3528)
static void C_ccall f_3528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5276)
static void C_ccall f_5276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3522)
static void C_ccall f_3522(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4044)
static void C_ccall f_4044(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4044)
static void C_ccall f_4044r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5644)
static void C_ccall f_5644(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5644)
static void C_ccall f_5644r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2465)
static void C_fcall f_2465(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4358)
static void C_ccall f_4358(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4356)
static void C_ccall f_4356(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4353)
static void C_ccall f_4353(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3773)
static void C_ccall f_3773(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3779)
static void C_ccall f_3779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3936)
static void C_ccall f_3936(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3936)
static void C_ccall f_3936r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3762)
static void C_ccall f_3762(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3940)
static void C_ccall f_3940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3575)
static void C_ccall f_3575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3945)
static void C_ccall f_3945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5286)
static void C_ccall f_5286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5289)
static void C_ccall f_5289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2974)
static void C_ccall f_2974(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4016)
static void C_ccall f_4016(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4012)
static void C_ccall f_4012(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4012)
static void C_ccall f_4012r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4163)
static void C_ccall f_4163(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3912)
static void C_ccall f_3912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3910)
static void C_ccall f_3910(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4176)
static void C_ccall f_4176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4002)
static void C_ccall f_4002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5604)
static void C_ccall f_5604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4007)
static void C_ccall f_4007(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3920)
static void C_ccall f_3920(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3928)
static void C_ccall f_3928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5602)
static void C_ccall f_5602(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3924)
static void C_ccall f_3924(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3597)
static void C_ccall f_3597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3926)
static void C_ccall f_3926(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3590)
static void C_ccall f_3590(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5264)
static void C_ccall f_5264(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4166)
static void C_ccall f_4166(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4168)
static void C_fcall f_4168(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4142)
static void C_ccall f_4142(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3583)
static void C_ccall f_3583(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5613)
static void C_ccall f_5613(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3588)
static void C_ccall f_3588(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5295)
static void C_ccall f_5295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5292)
static void C_ccall f_5292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5297)
static void C_ccall f_5297(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4156)
static void C_ccall f_4156(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3533)
static void C_ccall f_3533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5245)
static void C_ccall f_5245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3950)
static void C_ccall f_3950(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3950)
static void C_ccall f_3950r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2875)
static void C_ccall f_2875(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2878)
static void C_ccall f_2878(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3958)
static void C_ccall f_3958(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3958)
static void C_ccall f_3958r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3953)
static void C_ccall f_3953(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5032)
static void C_ccall f_5032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5038)
static void C_ccall f_5038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5035)
static void C_ccall f_5035(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4194)
static void C_ccall f_4194(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2865)
static void C_ccall f_2865(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2869)
static void C_ccall f_2869(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3557)
static void C_ccall f_3557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3551)
static void C_ccall f_3551(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5020)
static void C_ccall f_5020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3696)
static void C_ccall f_3696(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5029)
static void C_ccall f_5029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5026)
static void C_ccall f_5026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4183)
static void C_ccall f_4183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3695)
static void C_ccall f_3695(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3689)
static void C_ccall f_3689(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3688)
static void C_ccall f_3688(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2884)
static void C_ccall f_2884(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3680)
static void C_ccall f_3680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3683)
static void C_ccall f_3683(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4188)
static void C_ccall f_4188(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4186)
static void C_ccall f_4186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5009)
static void C_ccall f_5009(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5006)
static void C_ccall f_5006(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5003)
static void C_ccall f_5003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3994)
static void C_ccall f_3994(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3567)
static void C_ccall f_3567(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3561)
static void C_ccall f_3561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3999)
static void C_ccall f_3999(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3999)
static void C_ccall f_3999r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5075)
static void C_fcall f_5075(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5062)
static void C_ccall f_5062(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5066)
static void C_ccall f_5066(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5060)
static void C_ccall f_5060(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_5050)
static void C_ccall f_5050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2924)
static void C_fcall f_2924(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2922)
static void C_ccall f_2922(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5097)
static void C_ccall f_5097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2941)
static void C_ccall f_2941(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5099)
static void C_ccall f_5099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5084)
static void C_ccall f_5084(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4596)
static void C_fcall f_4596(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2279)
static void C_ccall f_2279(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2279)
static void C_ccall f_2279r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2277)
static void C_ccall f_2277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2271)
static void C_ccall f_2271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2273)
static void C_ccall f_2273(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4561)
static void C_ccall f_4561(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2916)
static void C_fcall f_2916(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2914)
static void C_fcall f_2914(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2902)
static void C_ccall f_2902(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2295)
static void C_ccall f_2295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3010)
static void C_ccall f_3010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3895)
static void C_ccall f_3895(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3867)
static void C_ccall f_3867(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3867)
static void C_ccall f_3867r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3002)
static void C_ccall f_3002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3019)
static void C_ccall f_3019(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4896)
static void C_ccall f_4896(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4896)
static void C_ccall f_4896r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4890)
static void C_ccall f_4890(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3008)
static void C_ccall f_3008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2379)
static void C_ccall f_2379(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2370)
static void C_ccall f_2370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4501)
static void C_ccall f_4501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2372)
static void C_ccall f_2372(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5496)
static void C_ccall f_5496(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5490)
static void C_ccall f_5490(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4981)
static void C_ccall f_4981(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_4981)
static void C_ccall f_4981r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_2388)
static void C_ccall f_2388(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4874)
static void C_ccall f_4874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2381)
static void C_ccall f_2381(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4509)
static void C_fcall f_4509(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4870)
static void C_ccall f_4870(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5484)
static void C_ccall f_5484(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4994)
static void C_ccall f_4994(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2397)
static void C_ccall f_2397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2399)
static void C_ccall f_2399(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5472)
static void C_ccall f_5472(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5478)
static void C_ccall f_5478(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2213)
static void C_ccall f_2213(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3704)
static void C_ccall f_3704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2219)
static void C_ccall f_2219(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5460)
static void C_ccall f_5460(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3060)
static void C_ccall f_3060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2222)
static void C_ccall f_2222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3711)
static void C_ccall f_3711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2227)
static void C_ccall f_2227(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2227)
static void C_ccall f_2227r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3074)
static void C_ccall f_3074(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5454)
static void C_ccall f_5454(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3063)
static void C_ccall f_3063(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3062)
static void C_ccall f_3062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5448)
static void C_ccall f_5448(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5442)
static void C_ccall f_5442(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5311)
static void C_ccall f_5311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5316)
static void C_ccall f_5316(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3099)
static void C_ccall f_3099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3095)
static void C_ccall f_3095(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3097)
static void C_ccall f_3097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3093)
static void C_ccall f_3093(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4766)
static void C_ccall f_4766(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5436)
static void C_ccall f_5436(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5302)
static void C_ccall f_5302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5430)
static void C_ccall f_5430(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3089)
static void C_ccall f_3089(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3089)
static void C_ccall f_3089r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3083)
static void C_ccall f_3083(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3022)
static void C_ccall f_3022(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5412)
static void C_ccall f_5412(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3034)
static void C_ccall f_3034(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5418)
static void C_ccall f_5418(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3028)
static void C_ccall f_3028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5400)
static void C_ccall f_5400(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5406)
static void C_ccall f_5406(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3040)
static void C_ccall f_3040(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4410)
static void C_ccall f_4410(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4416)
static void C_ccall f_4416(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4419)
static void C_ccall f_4419(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3734)
static void C_ccall f_3734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3052)
static void C_ccall f_3052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3046)
static void C_ccall f_3046(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5322)
static void C_ccall f_5322(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5328)
static void C_ccall f_5328(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3244)
static void C_ccall f_3244(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3240)
static void C_ccall f_3240(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5394)
static void C_ccall f_5394(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4930)
static void C_ccall f_4930(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5382)
static void C_ccall f_5382(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5388)
static void C_ccall f_5388(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4926)
static void C_ccall f_4926(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4921)
static void C_ccall f_4921(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9) C_noret;
C_noret_decl(f_3747)
static void C_ccall f_3747(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5424)
static void C_ccall f_5424(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3261)
static void C_ccall f_3261(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5376)
static void C_ccall f_5376(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4477)
static void C_ccall f_4477(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5370)
static void C_ccall f_5370(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3255)
static void C_ccall f_3255(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3250)
static void C_ccall f_3250(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3725)
static void C_fcall f_3725(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4492)
static void C_ccall f_4492(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4492)
static void C_ccall f_4492r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5358)
static void C_ccall f_5358(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5352)
static void C_ccall f_5352(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4496)
static void C_ccall f_4496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2161)
static void C_ccall f_2161(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4498)
static void C_fcall f_4498(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5346)
static void C_ccall f_5346(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2170)
static void C_ccall f_2170(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2170)
static void C_ccall f_2170r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5340)
static void C_ccall f_5340(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2174)
static void C_ccall f_2174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4569)
static C_word C_fcall f_4569(C_word t0,C_word t1);
C_noret_decl(f_4434)
static void C_ccall f_4434(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2186)
static void C_fcall f_2186(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5334)
static void C_ccall f_5334(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2183)
static void C_ccall f_2183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2180)
static void C_ccall f_2180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4556)
static void C_fcall f_4556(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4464)
static void C_ccall f_4464(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4460)
static void C_ccall f_4460(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4466)
static void C_ccall f_4466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2190)
static void C_ccall f_2190(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2234)
static void C_ccall f_2234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5129)
static void C_ccall f_5129(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4216)
static void C_ccall f_4216(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2249)
static void C_ccall f_2249(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2247)
static void C_ccall f_2247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4484)
static void C_ccall f_4484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3427)
static void C_ccall f_3427(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3427)
static void C_ccall f_3427r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4200)
static void C_ccall f_4200(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4209)
static void C_fcall f_4209(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2259)
static void C_ccall f_2259(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2255)
static void C_ccall f_2255(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5109)
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_2253)
static void C_ccall f_2253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5104)
static void C_ccall f_5104(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4653)
static void C_ccall f_4653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2149)
static void C_ccall f_2149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4912)
static void C_ccall f_4912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4915)
static void C_ccall f_4915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2265)
static void C_ccall f_2265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2267)
static void C_ccall f_2267(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2261)
static void C_ccall f_2261(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5133)
static void C_ccall f_5133(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5135)
static void C_ccall f_5135(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5135)
static void C_ccall f_5135r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4645)
static void C_ccall f_4645(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2157)
static void C_ccall f_2157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2754)
static void C_ccall f_2754(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2159)
static void C_ccall f_2159(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5364)
static void C_ccall f_5364(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4900)
static void C_fcall f_4900(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2151)
static void C_ccall f_2151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2153)
static void C_ccall f_2153(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2155)
static void C_ccall f_2155(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4635)
static void C_ccall f_4635(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2706)
static void C_ccall f_2706(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2708)
static void C_ccall f_2708(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4622)
static void C_ccall f_4622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4442)
static void C_ccall f_4442(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4627)
static void C_ccall f_4627(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4447)
static void C_ccall f_4447(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4447)
static void C_ccall f_4447r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4619)
static void C_ccall f_4619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2725)
static void C_fcall f_2725(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4273)
static void C_ccall f_4273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4275)
static void C_ccall f_4275(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4275)
static void C_ccall f_4275r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3677)
static void C_ccall f_3677(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3471)
static void C_ccall f_3471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3674)
static void C_ccall f_3674(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3485)
static void C_ccall f_3485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3487)
static void C_ccall f_3487(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3489)
static void C_ccall f_3489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3665)
static void C_ccall f_3665(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3665)
static void C_ccall f_3665r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3663)
static void C_ccall f_3663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2745)
static void C_fcall f_2745(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4292)
static void C_ccall f_4292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3477)
static void C_ccall f_3477(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3477)
static void C_ccall f_3477r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2735)
static void C_ccall f_2735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2363)
static void C_ccall f_2363(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2739)
static void C_fcall f_2739(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3440)
static void C_ccall f_3440(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4286)
static void C_ccall f_4286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4288)
static void C_ccall f_4288(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3497)
static void C_ccall f_3497(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2962)
static void C_ccall f_2962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2965)
static void C_ccall f_2965(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3447)
static void C_ccall f_3447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3442)
static void C_ccall f_3442(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2503)
static void C_ccall f_2503(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2505)
static void C_ccall f_2505(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2509)
static void C_ccall f_2509(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_3431)
static void C_fcall trf_3431(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3431(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3431(t0,t1);}

C_noret_decl(trf_4245)
static void C_fcall trf_4245(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4245(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4245(t0,t1,t2,t3);}

C_noret_decl(trf_2612)
static void C_fcall trf_2612(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2612(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2612(t0,t1);}

C_noret_decl(trf_2555)
static void C_fcall trf_2555(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2555(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2555(t0,t1);}

C_noret_decl(trf_2820)
static void C_fcall trf_2820(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2820(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2820(t0,t1,t2);}

C_noret_decl(trf_2850)
static void C_fcall trf_2850(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2850(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2850(t0,t1,t2);}

C_noret_decl(trf_3615)
static void C_fcall trf_3615(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3615(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3615(t0,t1);}

C_noret_decl(trf_4673)
static void C_fcall trf_4673(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4673(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4673(t0,t1,t2,t3);}

C_noret_decl(trf_3813)
static void C_fcall trf_3813(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3813(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3813(t0,t1,t2,t3);}

C_noret_decl(trf_3136)
static void C_fcall trf_3136(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3136(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3136(t0,t1,t2);}

C_noret_decl(trf_4325)
static void C_fcall trf_4325(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4325(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4325(t0,t1);}

C_noret_decl(trf_2429)
static void C_fcall trf_2429(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2429(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2429(t0,t1,t2,t3);}

C_noret_decl(trf_4735)
static void C_fcall trf_4735(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4735(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4735(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4705)
static void C_fcall trf_4705(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4705(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_4705(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4382)
static void C_fcall trf_4382(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4382(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4382(t0,t1,t2);}

C_noret_decl(trf_2661)
static void C_fcall trf_2661(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2661(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2661(t0,t1,t2);}

C_noret_decl(trf_4394)
static void C_fcall trf_4394(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4394(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4394(t0,t1,t2);}

C_noret_decl(trf_3524)
static void C_fcall trf_3524(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3524(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3524(t0,t1);}

C_noret_decl(trf_2465)
static void C_fcall trf_2465(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2465(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2465(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4168)
static void C_fcall trf_4168(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4168(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4168(t0,t1,t2,t3);}

C_noret_decl(trf_5075)
static void C_fcall trf_5075(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5075(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5075(t0,t1,t2);}

C_noret_decl(trf_2924)
static void C_fcall trf_2924(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2924(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2924(t0,t1,t2,t3);}

C_noret_decl(trf_4596)
static void C_fcall trf_4596(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4596(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4596(t0,t1,t2,t3);}

C_noret_decl(trf_2916)
static void C_fcall trf_2916(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2916(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2916(t0,t1);}

C_noret_decl(trf_2914)
static void C_fcall trf_2914(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2914(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2914(t0,t1);}

C_noret_decl(trf_4509)
static void C_fcall trf_4509(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4509(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4509(t0,t1);}

C_noret_decl(trf_3725)
static void C_fcall trf_3725(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3725(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3725(t0,t1,t2);}

C_noret_decl(trf_4498)
static void C_fcall trf_4498(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4498(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4498(t0,t1);}

C_noret_decl(trf_2186)
static void C_fcall trf_2186(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2186(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2186(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4556)
static void C_fcall trf_4556(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4556(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4556(t0,t1,t2);}

C_noret_decl(trf_4209)
static void C_fcall trf_4209(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4209(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4209(t0,t1,t2,t3);}

C_noret_decl(trf_4900)
static void C_fcall trf_4900(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4900(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4900(t0,t1);}

C_noret_decl(trf_2725)
static void C_fcall trf_2725(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2725(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2725(t0,t1);}

C_noret_decl(trf_2745)
static void C_fcall trf_2745(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2745(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2745(t0,t1);}

C_noret_decl(trf_2739)
static void C_fcall trf_2739(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2739(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2739(t0,t1);}

C_noret_decl(tr10)
static void C_fcall tr10(C_proc10 k) C_regparm C_noret;
C_regparm static void C_fcall tr10(C_proc10 k){
C_word t9=C_pick(0);
C_word t8=C_pick(1);
C_word t7=C_pick(2);
C_word t6=C_pick(3);
C_word t5=C_pick(4);
C_word t4=C_pick(5);
C_word t3=C_pick(6);
C_word t2=C_pick(7);
C_word t1=C_pick(8);
C_word t0=C_pick(9);
C_adjust_stack(-10);
(k)(10,t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr8)
static void C_fcall tr8(C_proc8 k) C_regparm C_noret;
C_regparm static void C_fcall tr8(C_proc8 k){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
(k)(8,t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr9r)
static void C_fcall tr9r(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9r(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n*3);
t9=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

/* k2998 in k2995 */
static void C_ccall f_2999(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:419: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k2995 */
static void C_ccall f_2996(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2996,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2999,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3002,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:420: pproc */
t4=((C_word*)t0)[7];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[5]);}

/* f_2990 in k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in ... */
static void C_ccall f_2990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2990,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2996,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3008,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:419: make-pathname */
t4=*((C_word*)lf[82]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],lf[90]);}

/* k3430 in file-open in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_3431(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3431,NULL,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[2],lf[151]);
t3=C_i_check_exact_2(((C_word*)t0)[3],lf[151]);
t4=C_i_check_exact_2(t1,lf[151]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3440,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3453,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:970: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t6,((C_word*)t0)[2]);}

/* process* in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5190(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_5190r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5190r(t0,t1,t2,t3);}}

static void C_ccall f_5190r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
if(C_truep(C_i_nullp(t11))){
/* posixwin.scm:1644: %process */
t14=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t14+1)))(8,t14,t1,lf[325],C_SCHEME_TRUE,t2,t5,t9,t13);}
else{
t14=C_i_cdr(t11);
/* posixwin.scm:1644: %process */
t15=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t15+1)))(8,t15,t1,lf[325],C_SCHEME_TRUE,t2,t5,t9,t13);}}

/* f_2985 in k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in ... */
static void C_ccall f_2985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2985,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k2981 in k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in ... */
static void C_ccall f_2983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:417: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k4248 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4249(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4249,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posixwin.scm:1356: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[10],lf[276],((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4260,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1357: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[52]+1)))(6,*((C_word*)lf[52]+1),t2,((C_word*)t0)[5],*((C_word*)lf[53]+1),lf[277],lf[55]);}}

/* check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4245(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4245,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4249,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1354: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}

/* k2520 in k2508 */
static void C_ccall f_2521(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_slot(t1,C_fix(0)));}

/* k2528 in k2543 in k2508 */
static void C_ccall f_2529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* file-close in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3459(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3459,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[153]);
t4=C_close(t2);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3471,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:980: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k3452 in k3430 in file-open in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:970: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[151]);}

/* k2710 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2711,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:352: posix-error */
t3=lf[3];
f_2170(6,t3,((C_word*)t0)[3],lf[10],lf[29],lf[78],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2725,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li28),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2725(t6,((C_word*)t0)[3]);}}

/* open-input-file* in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4262(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4262r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4262r(t0,t1,t2,t3);}}

static void C_ccall f_4262r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[56]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4273,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1363: mode */
f_4209(t5,C_SCHEME_TRUE,t3,lf[56]);}

/* k4259 in k4248 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3878 in open-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1146: check */
f_3813(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* k3885 in open-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3886,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixwin.scm:1146: check */
f_3813(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k2643 */
static void C_ccall f_2645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2645,2,t0,t1);}
if(C_truep(t1)){
t2=*((C_word*)lf[73]+1);
/* posix-common.scm:333: g275 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[73]+1)))(3,*((C_word*)lf[73]+1),((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2651,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:335: directory? */
t3=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k2586 in k2584 in current-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2587(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:314: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(5,*((C_word*)lf[68]+1),((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0),((C_word*)t0)[2]);}
else{
/* posix-common.scm:315: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[10],lf[66],lf[69]);}}

/* k5703 */
static void C_ccall f_5704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:191: g113 */
t2=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[4]);}

/* k2584 in current-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2585,2,t0,t1);}
t2=C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2587,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:312: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}

/* f_5599 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5599(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5599,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5602,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5613,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1064: port? */
t5=*((C_word*)lf[169]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* fifo? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5575(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5575,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* memory-mapped-file? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5579(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5579,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* rmdir in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2612(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2612,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2616,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:322: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,t2);}

/* k2615 in rmdir in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2616(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posix-common.scm:324: posix-error */
t4=lf[3];
f_2170(6,t4,((C_word*)t0)[2],lf[10],lf[71],lf[72],((C_word*)t0)[3]);}}

/* current-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2572(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_2572r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2572r(t0,t1,t2);}}

static void C_ccall f_2572r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:308: change-directory */
t5=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2585,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[70]+1)))(4,*((C_word*)lf[70]+1),t5,C_fix(1024),C_make_character(32));}}

/* f_2549 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2549(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2549r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2549r(t0,t1,t2,t3);}}

static void C_ccall f_2549r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[64]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2555,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_2555(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[64]);
t8=t5;
f_2555(t8,C_dup2(t2,t6));}}

/* k2543 in k2508 */
static void C_ccall f_2544(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2544,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:289: posix-error */
t2=lf[3];
f_2170(6,t2,((C_word*)t0)[2],lf[15],lf[58],lf[60],((C_word*)t0)[3]);}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2529,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:287: posix-error */
t4=lf[3];
f_2170(6,t4,t3,lf[10],lf[58],lf[61],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* f_2636 in k2634 in k2629 in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2636(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2636,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2645,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:334: symbolic-link? */
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k2634 in k2629 in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2635,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2636,a[2]=((C_word*)t0)[2],a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t3=C_i_check_list_2(t1,lf[74]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2656,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2661,a[2]=t6,a[3]=t2,a[4]=((C_word)li26),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_2661(t8,t4,t1);}

/* k2629 in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2630,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2635,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:328: find-files */
t3=*((C_word*)lf[75]+1);
((C_proc7)(void*)(*((C_word*)t3+1)))(7,t3,t2,t1,lf[76],C_SCHEME_TRUE,lf[77],C_SCHEME_FALSE);}
else{
/* posix-common.scm:340: rmdir */
f_2612(((C_word*)t0)[4],t1);}}

/* k2654 in k2634 in k2629 in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:339: rmdir */
f_2612(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k2649 in k2643 */
static void C_ccall f_2651(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:333: g275 */
f_2612(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[73]+1);
/* posix-common.scm:333: g275 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[73]+1)))(3,*((C_word*)lf[73]+1),((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* k3792 in change-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1112: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[67]);}

/* signal-mask in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5520(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5520,2,t0,t1);}
/* posixwin.scm:1729: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* signal-mask! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5526(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5526,2,t0,t1);}
/* posixwin.scm:1730: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* k3780 in k3778 in change-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3781(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* set-user-id! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5514(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5514,2,t0,t1);}
/* posixwin.scm:1728: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* k3785 in k3778 in change-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1115: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[67],lf[179],((C_word*)t0)[3]);}

/* k2556 in k2554 */
static void C_ccall f_2557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k2554 */
static void C_fcall f_2555(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2555,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2557,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:300: posix-error */
t3=lf[3];
f_2170(6,t3,t2,lf[10],lf[64],lf[65],((C_word*)t0)[3]);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[36],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4988,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=((*(int *)C_data_pointer(t2))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t4=C_a_i_bytevector(&a,1,C_fix(1));
t5=((*(int *)C_data_pointer(t4))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t6=C_a_i_bytevector(&a,1,C_fix(1));
t7=((*(int *)C_data_pointer(t6))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t8=C_a_i_bytevector(&a,1,C_fix(1));
t9=((*(int *)C_data_pointer(t8))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t10=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4994,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t8,a[6]=((C_word*)t0)[4],a[7]=t4,a[8]=((C_word*)t0)[5],a[9]=t6,a[10]=((C_word*)t0)[6],a[11]=t1,tmp=(C_word)a,a+=12,tmp);
t11=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5026,a[2]=((C_word*)t0)[7],a[3]=t10,a[4]=((C_word*)t0)[8],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[3],a[9]=t8,a[10]=t6,a[11]=t4,tmp=(C_word)a,a+=12,tmp);
/* posixwin.scm:1605: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[321]+1)))(6,*((C_word*)lf[321]+1),t11,t2,C_fix(0),C_SCHEME_FALSE,lf[322]);}

/* set-root-directory! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5502(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5502,2,t0,t1);}
/* posixwin.scm:1726: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* set-signal-mask! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5508(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5508,2,t0,t1);}
/* posixwin.scm:1727: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* f_2834 in conc-loop in glob in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2834(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2834,2,t0,t1);}
/* posix-common.scm:379: decompose-pathname */
t2=*((C_word*)lf[81]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* f_2839 in conc-loop in glob in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2839(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2839,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2842,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2902,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t7=t3;
/* posix-common.scm:380: make-pathname */
t8=*((C_word*)lf[82]+1);
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}
else{
/* posix-common.scm:380: make-pathname */
t7=*((C_word*)lf[82]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,C_SCHEME_FALSE,lf[87],t4);}}

/* delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2605(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_2605r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2605r(t0,t1,t2,t3);}}

static void C_ccall f_2605r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2612,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp);
t7=C_i_check_string_2(t2,lf[71]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2630,a[2]=t5,a[3]=t6,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:326: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t8,t2);}

/* conc-loop in glob in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2820(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2820,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2834,a[2]=t3,a[3]=((C_word)li30),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2839,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li33),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:378: ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* loop in k2847 in k2841 */
static void C_fcall f_2850(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2850,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:382: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2820(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2865,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:383: irregex-match */
t5=*((C_word*)lf[84]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[6],t4);}}

/* k3280 in k3273 in time->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posix-common.scm:489: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[115],lf[116],((C_word*)t0)[3]);}}

/* k2841 */
static void C_ccall f_2842(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2842,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2848,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
t3=((C_word*)t0)[4];
/* posix-common.scm:381: directory */
t4=*((C_word*)lf[29]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}
else{
/* posix-common.scm:381: directory */
t3=*((C_word*)lf[29]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[85],C_SCHEME_TRUE);}}

/* k2847 in k2841 */
static void C_ccall f_2848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2848,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2850,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li32),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2850(t5,((C_word*)t0)[6],t1);}

/* k3273 in time->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3274,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[115]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3281,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3290,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:488: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,((C_word*)t0)[2],lf[115]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3292,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:490: asctime */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[4]);}}

/* k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3601,2,t0,t1);}
t2=C_mutate((C_word*)lf[36]+1 /* (set! block-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3605,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1042: stat-type */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[38]);}

/* k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3605(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3605,2,t0,t1);}
t2=C_mutate((C_word*)lf[38]+1 /* (set! fifo? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3609,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1043: stat-type */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[39]);}

/* k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3609(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3609,2,t0,t1);}
t2=C_mutate((C_word*)lf[39]+1 /* (set! socket? ...) */,t1);
t3=C_mutate((C_word*)lf[166]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3611,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3663,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5599,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1062: getter-with-setter */
t6=*((C_word*)lf[398]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,t5,*((C_word*)lf[166]+1),lf[399]);}

/* set-file-position! in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3611(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3611r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3611r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3611r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3615,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_3615(t7,C_u_i_car(t6));}
else{
t6=t5;
f_3615(t6,C_fix((C_word)SEEK_SET));}}

/* k3614 in set-file-position! in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_3615(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3615,NULL,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[166]);
t3=C_i_check_exact_2(t1,lf[166]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3621,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[2];
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixwin.scm:1051: ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,t4,lf[170],lf[166],lf[171],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t6=t4;
f_3621(2,t6,C_SCHEME_UNDEFINED);}}

/* k3291 in k3273 in time->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:492: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(5,*((C_word*)lf[68]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:493: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[115],lf[117],((C_word*)t0)[3]);}}

/* k3289 in k3273 in time->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:488: strftime */
t2=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* glob in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2814(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_2814r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2814r(t0,t1,t2);}}

static void C_ccall f_2814r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2820,a[2]=t4,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2820(t6,t1,t2);}

/* k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3329(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word ab[36],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3329,2,t0,t1);}
t2=C_mutate((C_word*)lf[120]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate((C_word*)lf[121]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3331,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[122]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3337,a[2]=((C_word)li65),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[126]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t6=C_mutate((C_word*)lf[127]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t7=C_mutate((C_word*)lf[128]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[129]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[130]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[131]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t11=C_mutate((C_word*)lf[132]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[133]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t13=C_mutate((C_word*)lf[134]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t14=C_mutate((C_word*)lf[135]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t15=C_mutate((C_word*)lf[136]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t16=C_mutate((C_word*)lf[137]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t17=C_mutate((C_word*)lf[138]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t18=C_mutate((C_word*)lf[139]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[140]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[141]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[142]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[143]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[144]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[145]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t25=C_mutate((C_word*)lf[146]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t26=C_mutate((C_word*)lf[147]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t27=C_mutate((C_word*)lf[148]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate((C_word*)lf[149]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate((C_word*)lf[150]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=C_mutate((C_word*)lf[151]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3427,a[2]=t31,a[3]=((C_word)li66),tmp=(C_word)a,a+=4,tmp));
t33=C_mutate((C_word*)lf[153]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3459,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[155]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3477,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[158]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3516,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[161]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3551,a[2]=((C_word)li70),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[163]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t38=C_mutate((C_word*)lf[164]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t39=C_mutate((C_word*)lf[165]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t40=C_mutate((C_word*)lf[35]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3583,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t41=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3588,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp);
t42=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3597,a[2]=((C_word*)t0)[2],a[3]=t41,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1040: stat-type */
t43=t41;
((C_proc3)(void*)(*((C_word*)t43+1)))(3,t43,t42,lf[37]);}

/* set-signal-handler! in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3315,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[118]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(*((C_word*)lf[119]+1),t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(*((C_word*)lf[119]+1),t2,t3));}}

/* with-input-from-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3980(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_3980r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3980r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3980r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3984,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[182]+1),t2,t4);}

/* k3983 in with-input-from-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3984,2,t0,t1);}
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3989,a[2]=t5,a[3]=t3,a[4]=((C_word)li94),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3994,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li96),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4007,a[2]=t3,a[3]=t5,a[4]=((C_word)li97),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1188: ##sys#dynamic-wind */
t9=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,((C_word*)t0)[3],t6,t7,t8);}

/* f_3989 in k3983 in with-input-from-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3989,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[196]+1));
t3=C_mutate((C_word*)lf[196]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3620 in k3614 in set-file-position! in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3621(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3621,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3627,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3633,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1052: port? */
t4=*((C_word*)lf[169]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}

/* f_3117 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3117,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}

/* f_3114 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3114(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3114,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k3625 in k3620 in k3614 in set-file-position! in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3627(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixwin.scm:1059: posix-error */
t2=lf[3];
f_2170(7,t2,((C_word*)t0)[2],lf[10],lf[166],lf[167],((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* f_3111 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3111,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* seconds->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3205(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3205r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3205r(t0,t1,t2);}}

static void C_ccall f_3205r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3210,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:466: current-seconds */
t4=*((C_word*)lf[107]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=t3;
f_3210(2,t4,C_i_car(t2));}}

/* f_3972 in k3961 in call-with-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3972(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3972r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3972r(t0,t1,t2);}}

static void C_ccall f_3972r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3975,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1184: close-output-pipe */
t4=*((C_word*)lf[190]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3974 */
static void C_ccall f_3975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* f_3108 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3108,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3103(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3103,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=((C_word*)t0)[8];
t9=C_i_check_string_2(t3,lf[75]);
t10=C_fix(0);
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2914,a[2]=t1,a[3]=t5,a[4]=t11,a[5]=t2,a[6]=t6,a[7]=t8,a[8]=t3,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3083,a[2]=t11,a[3]=t7,a[4]=((C_word)li41),tmp=(C_word)a,a+=5,tmp);
t14=t12;
f_2914(t14,t13);}
else{
t13=t12;
f_2914(t13,t7);}}
else{
t13=t12;
f_2914(t13,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3074,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp));}}

/* k3631 in k3620 in k3614 in set-file-position! in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[55]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];
f_3627(2,t5,t4);}
else{
t4=((C_word*)t0)[5];
f_3627(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];
f_3627(2,t3,t2);}
else{
/* posixwin.scm:1058: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[5],lf[15],lf[166],lf[168],((C_word*)t0)[2]);}}}

/* k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3101(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3101,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3103,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3108,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:425: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[97]+1)))(5,*((C_word*)lf[97]+1),t2,lf[77],((C_word*)t0)[8],t3);}

/* k3961 in call-with-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3962,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3967,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li91),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3972,a[2]=t1,a[3]=((C_word)li92),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1181: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t2,t3);}

/* f_3967 in k3961 in call-with-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3967(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3967,2,t0,t1);}
/* posixwin.scm:1182: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k4884 in k4873 in shell-command in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1561: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[312],lf[313]);}

/* k3213 in k3208 in seconds->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3214(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:470: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(5,*((C_word*)lf[68]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:471: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[109],lf[110],((C_word*)t0)[3]);}}

/* k2783 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2784(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:350: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[29]);}

/* k3208 in seconds->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3210(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3210,2,t0,t1);}
t2=C_i_check_number_2(t1,lf[109]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3214,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:468: ctime */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* k4688 in doloop1105 */
static void C_ccall f_4690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_4673(t5,((C_word*)t0)[5],t3,t4);}

/* seconds->utc-time in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3175(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3175r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3175r(t0,t1,t2);}}

static void C_ccall f_3175r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3180,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:460: current-seconds */
t4=*((C_word*)lf[107]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[108]);
/* posix-common.scm:462: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[106]+1)))(4,*((C_word*)lf[106]+1),t1,t4,C_SCHEME_TRUE);}}

/* string->time in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5568(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5568,2,t0,t1);}
/* posixwin.scm:1737: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[377],lf[0]);}

/* utc-time->seconds in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5562(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5562,2,t0,t1);}
/* posixwin.scm:1736: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[376],lf[0]);}

/* doloop1105 */
static void C_fcall f_4673(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4673,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1521: argvec-setter */
t4=((C_word*)t0)[2];
((C_proc5)C_fast_retrieve_proc(t4))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4690,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixwin.scm:1524: argvec-setter */
t8=((C_word*)t0)[2];
((C_proc5)C_fast_retrieve_proc(t8))(5,t8,t6,t3,t4,t7);}}

/* user-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5556(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5556,2,t0,t1);}
/* posixwin.scm:1735: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[375],lf[0]);}

/* unmap-file-from-memory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5550(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5550,2,t0,t1);}
/* posixwin.scm:1734: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[374],lf[0]);}

/* f_3196 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3196(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3196,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_integer_argumentp(t2);
t5=stub476(t3,t4);
/* posix-common.scm:465: ##sys#peek-c-string */
t6=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_3813(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3813,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3817,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1126: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}

/* f_4663 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4663(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4663,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4673,a[2]=t4,a[3]=t2,a[4]=t8,a[5]=((C_word)li134),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_4673(t10,t1,t3,t5);}
else{
/* posixwin.scm:1525: argvec-setter */
t6=t4;
((C_proc5)C_fast_retrieve_proc(t6))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* k3816 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3817,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posixwin.scm:1128: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[10],lf[180],((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3828,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1129: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[52]+1)))(6,*((C_word*)lf[52]+1),t2,((C_word*)t0)[5],*((C_word*)lf[53]+1),lf[181],lf[55]);}}

/* terminal-name in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5544(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5544,2,t0,t1);}
/* posixwin.scm:1733: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[373],lf[0]);}

/* k3178 in seconds->utc-time in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[108]);
/* posix-common.scm:462: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[106]+1)))(4,*((C_word*)lf[106]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* signal-unmask! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5538(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5538,2,t0,t1);}
/* posixwin.scm:1732: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[372],lf[0]);}

/* signal-masked? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5532(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5532,2,t0,t1);}
/* posixwin.scm:1731: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* check-time-vector in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_3136(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3136,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:454: ##sys#error */
t6=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[104],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3134(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[39],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3134,2,t0,t1);}
t2=C_mutate((C_word*)lf[102]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate(&lf[103] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3136,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[105]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3154,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[108]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3175,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3196,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp);
t7=C_mutate((C_word*)lf[109]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3205,a[2]=t6,a[3]=((C_word)li56),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate((C_word*)lf[111]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3240,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3255,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3261,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp);
t11=C_mutate((C_word*)lf[115]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3267,a[2]=t10,a[3]=t9,a[4]=((C_word)li60),tmp=(C_word)a,a+=5,tmp));
t12=C_mutate((C_word*)lf[118]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3315,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3329,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5636,a[2]=((C_word)li204),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:504: getter-with-setter */
t15=*((C_word*)lf[398]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t13,t14,*((C_word*)lf[118]+1));}

/* f_3129 */
static void C_ccall f_3129(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3129,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_3127 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3127,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3129,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp));}

/* f_3122 */
static void C_ccall f_3122(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3122,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* f_3120 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3120(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3120,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3122,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp));}

/* k4326 in k4324 in duplicate-fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4324 in duplicate-fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4325(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4325,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4327,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4332,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1389: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* seconds->local-time in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3154(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3154r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3154r(t0,t1,t2);}}

static void C_ccall f_3154r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3159,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:456: current-seconds */
t4=*((C_word*)lf[107]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[105]);
/* posix-common.scm:458: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[106]+1)))(4,*((C_word*)lf[106]+1),t1,t4,C_SCHEME_FALSE);}}

/* k3157 in seconds->local-time in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3159(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[105]);
/* posix-common.scm:458: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[106]+1)))(4,*((C_word*)lf[106]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3144)){
C_save(t1);
C_rereclaim2(3144*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,404);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[2]=C_h_intern(&lf[2],17,"\003syspeek-c-string");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_h_intern(&lf[5],13,"string-append");
lf[6]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[10]=C_h_intern(&lf[10],11,"\000file-error");
lf[11]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[12]=C_h_intern(&lf[12],17,"\003sysmake-c-string");
lf[13]=C_h_intern(&lf[13],27,"\003sysplatform-fixup-pathname");
lf[14]=C_h_intern(&lf[14],20,"\003sysexpand-home-path");
lf[15]=C_h_intern(&lf[15],11,"\000type-error");
lf[16]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[17]=C_h_intern(&lf[17],9,"file-stat");
lf[18]=C_h_intern(&lf[18],16,"_stat_st_blksize");
lf[19]=C_h_intern(&lf[19],15,"_stat_st_blocks");
lf[20]=C_h_intern(&lf[20],22,"file-modification-time");
lf[21]=C_h_intern(&lf[21],16,"file-access-time");
lf[22]=C_h_intern(&lf[22],16,"file-change-time");
lf[23]=C_h_intern(&lf[23],10,"file-owner");
lf[24]=C_h_intern(&lf[24],16,"file-permissions");
lf[25]=C_h_intern(&lf[25],9,"file-size");
lf[26]=C_h_intern(&lf[26],9,"file-type");
lf[27]=C_h_intern(&lf[27],12,"regular-file");
lf[28]=C_h_intern(&lf[28],13,"symbolic-link");
lf[29]=C_h_intern(&lf[29],9,"directory");
lf[30]=C_h_intern(&lf[30],16,"character-device");
lf[31]=C_h_intern(&lf[31],12,"block-device");
lf[32]=C_h_intern(&lf[32],4,"fifo");
lf[33]=C_h_intern(&lf[33],6,"socket");
lf[34]=C_h_intern(&lf[34],13,"regular-file\077");
lf[35]=C_h_intern(&lf[35],14,"symbolic-link\077");
lf[36]=C_h_intern(&lf[36],13,"block-device\077");
lf[37]=C_h_intern(&lf[37],17,"character-device\077");
lf[38]=C_h_intern(&lf[38],5,"fifo\077");
lf[39]=C_h_intern(&lf[39],7,"socket\077");
lf[40]=C_h_intern(&lf[40],10,"directory\077");
lf[41]=C_h_intern(&lf[41],12,"fileno/stdin");
lf[42]=C_h_intern(&lf[42],13,"fileno/stdout");
lf[43]=C_h_intern(&lf[43],13,"fileno/stderr");
lf[44]=C_h_intern(&lf[44],7,"\000append");
lf[45]=C_h_intern(&lf[45],9,"\003syserror");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[52]=C_h_intern(&lf[52],13,"\003sysmake-port");
lf[53]=C_h_intern(&lf[53],21,"\003sysstream-port-class");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[55]=C_h_intern(&lf[55],6,"stream");
lf[56]=C_h_intern(&lf[56],16,"open-input-file\052");
lf[57]=C_h_intern(&lf[57],17,"open-output-file\052");
lf[58]=C_h_intern(&lf[58],12,"port->fileno");
lf[59]=C_h_intern(&lf[59],13,"\003sysport-data");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[62]=C_h_intern(&lf[62],25,"\003syspeek-unsigned-integer");
lf[63]=C_h_intern(&lf[63],19,"\003syscheck-open-port");
lf[64]=C_h_intern(&lf[64],16,"duplicate-fileno");
lf[65]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[66]=C_h_intern(&lf[66],17,"current-directory");
lf[67]=C_h_intern(&lf[67],16,"change-directory");
lf[68]=C_h_intern(&lf[68],13,"\003syssubstring");
lf[69]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[70]=C_h_intern(&lf[70],15,"\003sysmake-string");
lf[71]=C_h_intern(&lf[71],16,"delete-directory");
lf[72]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[73]=C_h_intern(&lf[73],11,"delete-file");
lf[74]=C_h_intern(&lf[74],8,"for-each");
lf[75]=C_h_intern(&lf[75],10,"find-files");
lf[76]=C_h_intern(&lf[76],9,"\000dotfiles");
lf[77]=C_h_intern(&lf[77],16,"\000follow-symlinks");
lf[78]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[79]=C_h_intern(&lf[79],16,"\003sysmake-pointer");
lf[80]=C_h_intern(&lf[80],4,"glob");
lf[81]=C_h_intern(&lf[81],18,"decompose-pathname");
lf[82]=C_h_intern(&lf[82],13,"make-pathname");
lf[83]=C_h_intern(&lf[83],23,"irregex-match-substring");
lf[84]=C_h_intern(&lf[84],13,"irregex-match");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[86]=C_h_intern(&lf[86],16,"\003sysglob->regexp");
lf[87]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[88]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[91]=C_h_intern(&lf[91],16,"\003sysdynamic-wind");
lf[92]=C_h_intern(&lf[92],13,"pathname-file");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\002\077\052");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[95]=C_h_intern(&lf[95],7,"irregex");
lf[96]=C_h_intern(&lf[96],8,"irregex\077");
lf[97]=C_h_intern(&lf[97],15,"\003sysget-keyword");
lf[98]=C_h_intern(&lf[98],6,"\000limit");
lf[99]=C_h_intern(&lf[99],5,"\000seed");
lf[100]=C_h_intern(&lf[100],7,"\000action");
lf[101]=C_h_intern(&lf[101],5,"\000test");
lf[102]=C_h_intern(&lf[102],18,"file-creation-mode");
lf[104]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[105]=C_h_intern(&lf[105],19,"seconds->local-time");
lf[106]=C_h_intern(&lf[106],18,"\003sysdecode-seconds");
lf[107]=C_h_intern(&lf[107],15,"current-seconds");
lf[108]=C_h_intern(&lf[108],17,"seconds->utc-time");
lf[109]=C_h_intern(&lf[109],15,"seconds->string");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[111]=C_h_intern(&lf[111],19,"local-time->seconds");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[113]=C_h_intern(&lf[113],3,"fp=");
lf[114]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[115]=C_h_intern(&lf[115],12,"time->string");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[118]=C_h_intern(&lf[118],19,"set-signal-handler!");
lf[119]=C_h_intern(&lf[119],17,"\003syssignal-vector");
lf[120]=C_h_intern(&lf[120],14,"signal-handler");
lf[121]=C_h_intern(&lf[121],18,"current-process-id");
lf[122]=C_h_intern(&lf[122],12,"process-wait");
lf[123]=C_h_intern(&lf[123],16,"\003sysprocess-wait");
lf[124]=C_h_intern(&lf[124],14,"\000process-error");
lf[125]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[126]=C_h_intern(&lf[126],8,"pipe/buf");
lf[127]=C_h_intern(&lf[127],11,"open/rdonly");
lf[128]=C_h_intern(&lf[128],11,"open/wronly");
lf[129]=C_h_intern(&lf[129],9,"open/rdwr");
lf[130]=C_h_intern(&lf[130],9,"open/read");
lf[131]=C_h_intern(&lf[131],10,"open/write");
lf[132]=C_h_intern(&lf[132],10,"open/creat");
lf[133]=C_h_intern(&lf[133],11,"open/append");
lf[134]=C_h_intern(&lf[134],9,"open/excl");
lf[135]=C_h_intern(&lf[135],10,"open/trunc");
lf[136]=C_h_intern(&lf[136],11,"open/binary");
lf[137]=C_h_intern(&lf[137],9,"open/text");
lf[138]=C_h_intern(&lf[138],14,"open/noinherit");
lf[139]=C_h_intern(&lf[139],10,"perm/irusr");
lf[140]=C_h_intern(&lf[140],10,"perm/iwusr");
lf[141]=C_h_intern(&lf[141],10,"perm/ixusr");
lf[142]=C_h_intern(&lf[142],10,"perm/irgrp");
lf[143]=C_h_intern(&lf[143],10,"perm/iwgrp");
lf[144]=C_h_intern(&lf[144],10,"perm/ixgrp");
lf[145]=C_h_intern(&lf[145],10,"perm/iroth");
lf[146]=C_h_intern(&lf[146],10,"perm/iwoth");
lf[147]=C_h_intern(&lf[147],10,"perm/ixoth");
lf[148]=C_h_intern(&lf[148],10,"perm/irwxu");
lf[149]=C_h_intern(&lf[149],10,"perm/irwxg");
lf[150]=C_h_intern(&lf[150],10,"perm/irwxo");
lf[151]=C_h_intern(&lf[151],9,"file-open");
lf[152]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[153]=C_h_intern(&lf[153],10,"file-close");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[155]=C_h_intern(&lf[155],9,"file-read");
lf[156]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[157]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[158]=C_h_intern(&lf[158],10,"file-write");
lf[159]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[160]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[161]=C_h_intern(&lf[161],12,"file-mkstemp");
lf[162]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[163]=C_h_intern(&lf[163],8,"seek/set");
lf[164]=C_h_intern(&lf[164],8,"seek/end");
lf[165]=C_h_intern(&lf[165],8,"seek/cur");
lf[166]=C_h_intern(&lf[166],18,"set-file-position!");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[168]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[169]=C_h_intern(&lf[169],5,"port\077");
lf[170]=C_h_intern(&lf[170],13,"\000bounds-error");
lf[171]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[172]=C_h_intern(&lf[172],13,"file-position");
lf[173]=C_h_intern(&lf[173],16,"create-directory");
lf[174]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[175]=C_h_intern(&lf[175],16,"\003sysfile-exists\077");
lf[176]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[177]=C_h_intern(&lf[177],12,"string-split");
lf[178]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[179]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[180]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[181]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[182]=C_h_intern(&lf[182],15,"open-input-pipe");
lf[183]=C_h_intern(&lf[183],5,"\000text");
lf[184]=C_h_intern(&lf[184],7,"\000binary");
lf[185]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[186]=C_h_intern(&lf[186],16,"open-output-pipe");
lf[187]=C_h_intern(&lf[187],16,"close-input-pipe");
lf[188]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[189]=C_h_intern(&lf[189],20,"\003syscheck-input-port");
lf[190]=C_h_intern(&lf[190],17,"close-output-pipe");
lf[191]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[192]=C_h_intern(&lf[192],21,"\003syscheck-output-port");
lf[193]=C_h_intern(&lf[193],20,"call-with-input-pipe");
lf[194]=C_h_intern(&lf[194],21,"call-with-output-pipe");
lf[195]=C_h_intern(&lf[195],20,"with-input-from-pipe");
lf[196]=C_h_intern(&lf[196],18,"\003sysstandard-input");
lf[197]=C_h_intern(&lf[197],19,"with-output-to-pipe");
lf[198]=C_h_intern(&lf[198],19,"\003sysstandard-output");
lf[199]=C_h_intern(&lf[199],11,"create-pipe");
lf[200]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[201]=C_h_intern(&lf[201],11,"signal/term");
lf[202]=C_h_intern(&lf[202],10,"signal/int");
lf[203]=C_h_intern(&lf[203],10,"signal/fpe");
lf[204]=C_h_intern(&lf[204],10,"signal/ill");
lf[205]=C_h_intern(&lf[205],11,"signal/segv");
lf[206]=C_h_intern(&lf[206],11,"signal/abrt");
lf[207]=C_h_intern(&lf[207],12,"signal/break");
lf[208]=C_h_intern(&lf[208],11,"signal/alrm");
lf[209]=C_h_intern(&lf[209],11,"signal/chld");
lf[210]=C_h_intern(&lf[210],11,"signal/cont");
lf[211]=C_h_intern(&lf[211],10,"signal/hup");
lf[212]=C_h_intern(&lf[212],9,"signal/io");
lf[213]=C_h_intern(&lf[213],11,"signal/kill");
lf[214]=C_h_intern(&lf[214],11,"signal/pipe");
lf[215]=C_h_intern(&lf[215],11,"signal/prof");
lf[216]=C_h_intern(&lf[216],11,"signal/quit");
lf[217]=C_h_intern(&lf[217],11,"signal/stop");
lf[218]=C_h_intern(&lf[218],11,"signal/trap");
lf[219]=C_h_intern(&lf[219],11,"signal/tstp");
lf[220]=C_h_intern(&lf[220],10,"signal/urg");
lf[221]=C_h_intern(&lf[221],11,"signal/usr1");
lf[222]=C_h_intern(&lf[222],11,"signal/usr2");
lf[223]=C_h_intern(&lf[223],13,"signal/vtalrm");
lf[224]=C_h_intern(&lf[224],12,"signal/winch");
lf[225]=C_h_intern(&lf[225],11,"signal/xcpu");
lf[226]=C_h_intern(&lf[226],11,"signal/xfsz");
lf[227]=C_h_intern(&lf[227],12,"signals-list");
lf[228]=C_h_intern(&lf[228],10,"errno/perm");
lf[229]=C_h_intern(&lf[229],11,"errno/noent");
lf[230]=C_h_intern(&lf[230],10,"errno/srch");
lf[231]=C_h_intern(&lf[231],10,"errno/intr");
lf[232]=C_h_intern(&lf[232],8,"errno/io");
lf[233]=C_h_intern(&lf[233],12,"errno/noexec");
lf[234]=C_h_intern(&lf[234],10,"errno/badf");
lf[235]=C_h_intern(&lf[235],11,"errno/child");
lf[236]=C_h_intern(&lf[236],11,"errno/nomem");
lf[237]=C_h_intern(&lf[237],11,"errno/acces");
lf[238]=C_h_intern(&lf[238],11,"errno/fault");
lf[239]=C_h_intern(&lf[239],10,"errno/busy");
lf[240]=C_h_intern(&lf[240],11,"errno/exist");
lf[241]=C_h_intern(&lf[241],12,"errno/notdir");
lf[242]=C_h_intern(&lf[242],11,"errno/isdir");
lf[243]=C_h_intern(&lf[243],11,"errno/inval");
lf[244]=C_h_intern(&lf[244],11,"errno/mfile");
lf[245]=C_h_intern(&lf[245],11,"errno/nospc");
lf[246]=C_h_intern(&lf[246],11,"errno/spipe");
lf[247]=C_h_intern(&lf[247],10,"errno/pipe");
lf[248]=C_h_intern(&lf[248],11,"errno/again");
lf[249]=C_h_intern(&lf[249],10,"errno/rofs");
lf[250]=C_h_intern(&lf[250],10,"errno/nxio");
lf[251]=C_h_intern(&lf[251],10,"errno/2big");
lf[252]=C_h_intern(&lf[252],10,"errno/xdev");
lf[253]=C_h_intern(&lf[253],11,"errno/nodev");
lf[254]=C_h_intern(&lf[254],11,"errno/nfile");
lf[255]=C_h_intern(&lf[255],11,"errno/notty");
lf[256]=C_h_intern(&lf[256],10,"errno/fbig");
lf[257]=C_h_intern(&lf[257],11,"errno/mlink");
lf[258]=C_h_intern(&lf[258],9,"errno/dom");
lf[259]=C_h_intern(&lf[259],11,"errno/range");
lf[260]=C_h_intern(&lf[260],12,"errno/deadlk");
lf[261]=C_h_intern(&lf[261],17,"errno/nametoolong");
lf[262]=C_h_intern(&lf[262],11,"errno/nolck");
lf[263]=C_h_intern(&lf[263],11,"errno/nosys");
lf[264]=C_h_intern(&lf[264],14,"errno/notempty");
lf[265]=C_h_intern(&lf[265],11,"errno/ilseq");
lf[266]=C_h_intern(&lf[266],16,"change-file-mode");
lf[267]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[268]=C_h_intern(&lf[268],17,"file-read-access\077");
lf[269]=C_h_intern(&lf[269],18,"file-write-access\077");
lf[270]=C_h_intern(&lf[270],20,"file-execute-access\077");
lf[271]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[273]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[275]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[277]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[278]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[279]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[281]=C_h_intern(&lf[281],6,"setenv");
lf[282]=C_h_intern(&lf[282],8,"unsetenv");
lf[283]=C_h_intern(&lf[283],25,"get-environment-variables");
lf[284]=C_h_intern(&lf[284],9,"substring");
lf[285]=C_h_intern(&lf[285],27,"local-timezone-abbreviation");
lf[286]=C_h_intern(&lf[286],5,"_exit");
lf[287]=C_h_intern(&lf[287],14,"terminal-port\077");
lf[288]=C_h_intern(&lf[288],13,"terminal-size");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[290]=C_h_intern(&lf[290],19,"set-buffering-mode!");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[292]=C_h_intern(&lf[292],5,"\000full");
lf[293]=C_h_intern(&lf[293],5,"\000line");
lf[294]=C_h_intern(&lf[294],5,"\000none");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[296]=C_h_intern(&lf[296],13,"spawn/overlay");
lf[297]=C_h_intern(&lf[297],10,"spawn/wait");
lf[298]=C_h_intern(&lf[298],12,"spawn/nowait");
lf[299]=C_h_intern(&lf[299],13,"spawn/nowaito");
lf[300]=C_h_intern(&lf[300],12,"spawn/detach");
lf[302]=C_h_intern(&lf[302],16,"\003sysfast-reverse");
lf[303]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[306]=C_h_intern(&lf[306],24,"pathname-strip-directory");
lf[308]=C_h_intern(&lf[308],15,"process-execute");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[310]=C_h_intern(&lf[310],13,"process-spawn");
lf[311]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[312]=C_h_intern(&lf[312],17,"\003sysshell-command");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[314]=C_h_intern(&lf[314],24,"get-environment-variable");
lf[315]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[316]=C_h_intern(&lf[316],27,"\003sysshell-command-arguments");
lf[317]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[318]=C_h_intern(&lf[318],11,"process-run");
lf[319]=C_h_intern(&lf[319],11,"\003sysprocess");
lf[320]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[321]=C_h_intern(&lf[321],17,"\003sysmake-locative");
lf[322]=C_h_intern(&lf[322],8,"location");
lf[323]=C_h_intern(&lf[323],18,"string-intersperse");
lf[324]=C_h_intern(&lf[324],7,"process");
lf[325]=C_h_intern(&lf[325],8,"process\052");
lf[326]=C_h_intern(&lf[326],5,"sleep");
lf[327]=C_h_intern(&lf[327],13,"get-host-name");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[329]=C_h_intern(&lf[329],18,"system-information");
lf[330]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[332]=C_h_intern(&lf[332],17,"current-user-name");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[334]=C_h_intern(&lf[334],17,"change-directory\052");
lf[335]=C_h_intern(&lf[335],5,"error");
lf[336]=C_h_intern(&lf[336],17,"change-file-owner");
lf[337]=C_h_intern(&lf[337],11,"create-fifo");
lf[338]=C_h_intern(&lf[338],14,"create-session");
lf[339]=C_h_intern(&lf[339],20,"create-symbolic-link");
lf[340]=C_h_intern(&lf[340],26,"current-effective-group-id");
lf[341]=C_h_intern(&lf[341],25,"current-effective-user-id");
lf[342]=C_h_intern(&lf[342],27,"current-effective-user-name");
lf[343]=C_h_intern(&lf[343],16,"current-group-id");
lf[344]=C_h_intern(&lf[344],15,"current-user-id");
lf[345]=C_h_intern(&lf[345],18,"map-file-to-memory");
lf[346]=C_h_intern(&lf[346],9,"file-link");
lf[347]=C_h_intern(&lf[347],9,"file-lock");
lf[348]=C_h_intern(&lf[348],18,"file-lock/blocking");
lf[349]=C_h_intern(&lf[349],11,"file-select");
lf[350]=C_h_intern(&lf[350],14,"file-test-lock");
lf[351]=C_h_intern(&lf[351],13,"file-truncate");
lf[352]=C_h_intern(&lf[352],11,"file-unlock");
lf[353]=C_h_intern(&lf[353],10,"get-groups");
lf[354]=C_h_intern(&lf[354],17,"group-information");
lf[355]=C_h_intern(&lf[355],17,"initialize-groups");
lf[356]=C_h_intern(&lf[356],26,"memory-mapped-file-pointer");
lf[357]=C_h_intern(&lf[357],17,"parent-process-id");
lf[358]=C_h_intern(&lf[358],12,"process-fork");
lf[359]=C_h_intern(&lf[359],16,"process-group-id");
lf[360]=C_h_intern(&lf[360],14,"process-signal");
lf[361]=C_h_intern(&lf[361],18,"read-symbolic-link");
lf[362]=C_h_intern(&lf[362],10,"set-alarm!");
lf[363]=C_h_intern(&lf[363],13,"set-group-id!");
lf[364]=C_h_intern(&lf[364],11,"set-groups!");
lf[365]=C_h_intern(&lf[365],21,"set-process-group-id!");
lf[366]=C_h_intern(&lf[366],19,"set-root-directory!");
lf[367]=C_h_intern(&lf[367],16,"set-signal-mask!");
lf[368]=C_h_intern(&lf[368],12,"set-user-id!");
lf[369]=C_h_intern(&lf[369],11,"signal-mask");
lf[370]=C_h_intern(&lf[370],12,"signal-mask!");
lf[371]=C_h_intern(&lf[371],14,"signal-masked\077");
lf[372]=C_h_intern(&lf[372],14,"signal-unmask!");
lf[373]=C_h_intern(&lf[373],13,"terminal-name");
lf[374]=C_h_intern(&lf[374],22,"unmap-file-from-memory");
lf[375]=C_h_intern(&lf[375],16,"user-information");
lf[376]=C_h_intern(&lf[376],17,"utc-time->seconds");
lf[377]=C_h_intern(&lf[377],12,"string->time");
lf[378]=C_h_intern(&lf[378],16,"errno/wouldblock");
lf[379]=C_h_intern(&lf[379],19,"memory-mapped-file\077");
lf[380]=C_h_intern(&lf[380],13,"map/anonymous");
lf[381]=C_h_intern(&lf[381],8,"map/file");
lf[382]=C_h_intern(&lf[382],9,"map/fixed");
lf[383]=C_h_intern(&lf[383],11,"map/private");
lf[384]=C_h_intern(&lf[384],10,"map/shared");
lf[385]=C_h_intern(&lf[385],10,"open/fsync");
lf[386]=C_h_intern(&lf[386],11,"open/noctty");
lf[387]=C_h_intern(&lf[387],13,"open/nonblock");
lf[388]=C_h_intern(&lf[388],9,"open/sync");
lf[389]=C_h_intern(&lf[389],10,"perm/isgid");
lf[390]=C_h_intern(&lf[390],10,"perm/isuid");
lf[391]=C_h_intern(&lf[391],10,"perm/isvtx");
lf[392]=C_h_intern(&lf[392],9,"prot/exec");
lf[393]=C_h_intern(&lf[393],9,"prot/none");
lf[394]=C_h_intern(&lf[394],9,"prot/read");
lf[395]=C_h_intern(&lf[395],10,"prot/write");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[397]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[398]=C_h_intern(&lf[398],18,"getter-with-setter");
lf[399]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[400]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[401]=C_h_intern(&lf[401],26,"set-file-modification-time");
lf[402]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[403]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,404,create_ptable());
t2=C_mutate(&lf[0] /* (set! c1414 ...) */,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2149,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k3857 in open-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3858,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixwin.scm:1136: check */
f_3813(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* process-spawn in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4810(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4810r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4810r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4810r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a=C_alloc(6);
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=C_i_nullp(t4);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_i_car(t8));
t11=C_i_nullp(t8);
t12=(C_truep(t11)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t13=C_i_nullp(t12);
t14=(C_truep(t13)?C_SCHEME_FALSE:C_i_car(t12));
t15=C_i_nullp(t12);
t16=(C_truep(t15)?C_SCHEME_END_OF_LIST:C_i_cdr(t12));
t17=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4826,a[2]=t10,a[3]=t2,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1549: $exec-setup */
t18=lf[305];
f_4705(t18,t17,lf[310],t3,t6,t10,t14);}

/* sleep in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5257(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5257,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1372(C_SCHEME_UNDEFINED,t3));}

/* k4299 in k4316 in k4291 in port->fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k3827 in k3816 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4304 in k4316 in k4291 in port->fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1376: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[58],lf[279],((C_word*)t0)[3]);}

/* k2405 */
static void C_ccall f_2406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[32],t1));}

/* f_2408 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2408(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2408,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2415,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:233: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* open-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3830(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3830r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3830r(t0,t1,t2,t3);}}

static void C_ccall f_3830r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[182]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[183]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3843,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[183]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3849,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1139: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t9,t2,lf[182]);}
else{
t9=C_eqp(t6,lf[184]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3858,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1140: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t10,t2,lf[182]);}
else{
/* posixwin.scm:1124: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[185],t6);}}}

/* process-execute in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4750(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4750r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4750r(t0,t1,t2,t3);}}

static void C_ccall f_4750r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(5);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
t14=C_i_nullp(t11);
t15=(C_truep(t14)?C_SCHEME_END_OF_LIST:C_i_cdr(t11));
t16=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4766,a[2]=t9,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1544: $exec-setup */
t17=lf[305];
f_4705(t17,t16,lf[308],t2,t5,t9,t13);}

/* directory? in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2417(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2417,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2424,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:236: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2414 */
static void C_ccall f_2415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[33],t1));}

/* duplicate-fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4319(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4319r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4319r(t0,t1,t2,t3);}}

static void C_ccall f_4319r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[64]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4325,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_4325(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[64]);
t8=t5;
f_4325(t8,C_dup2(t2,t6));}}

/* k4738 in $exec-teardown in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4739(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=C_free_exec_args();
t3=C_free_exec_env();
t4=C_eqp(((C_word*)t0)[2],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm:1540: ##sys#error */
t5=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);}
else{
t5=((C_word*)t0)[2];
t6=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k2423 in directory? in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2424(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[29],t1));}

/* mode in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2429(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2429,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2436,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[44]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:255: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t5,lf[46],t7);}
else{
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[47],t4);}}
else{
/* posix-common.scm:256: ##sys#error */
t9=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[48],t7);}}
else{
if(C_truep(t2)){
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[49],t4);}
else{
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[50],t4);}}}

/* k4033 */
static void C_ccall f_4034(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* process-wait in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3337(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3337r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3337r(t0,t1,t2);}}

static void C_ccall f_3337r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(9);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=C_i_check_exact_2(t11,lf[122]);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3357,a[2]=t11,a[3]=t8,a[4]=((C_word)li63),tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3362,a[2]=t11,a[3]=((C_word)li64),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:520: ##sys#call-with-values */
C_call_with_values(4,0,t1,t13,t14);}

/* k4825 in process-spawn in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
t2=C_spawnvpe(((C_word*)t0)[3],t1);
/* posixwin.scm:1550: $exec-teardown */
f_4735(((C_word*)t0)[4],lf[310],lf[311],((C_word*)t0)[5],t2);}
else{
t2=C_spawnvp(((C_word*)t0)[3],t1);
/* posixwin.scm:1550: $exec-teardown */
f_4735(((C_word*)t0)[4],lf[310],lf[311],((C_word*)t0)[5],t2);}}

/* current-process-id in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3331,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fudge(C_fix(33)));}

/* f_4031 */
static void C_ccall f_4031(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4031r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4031r(t0,t1,t2);}}

static void C_ccall f_4031r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4034,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1204: close-output-pipe */
t4=*((C_word*)lf[190]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* f_4039 in k4015 in with-output-to-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4039,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[198]+1));
t3=C_mutate((C_word*)lf[198]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* $exec-teardown in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4735(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4735,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4739,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:1536: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* k4316 in k4291 in port->fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4317,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posixwin.scm:1378: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[15],lf[58],lf[278],((C_word*)t0)[3]);}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4300,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4305,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1375: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* f_5669 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5669(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5669,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5672,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:188: ##sys#stat */
f_2186(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[20]);}

/* k4726 in k4712 in k4710 in $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4727(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1530: build-exec-argvec */
t2=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5],C_fix(1));}

/* f_5664 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5664(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5664,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[102]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_umask(t2));}

/* f_4026 in k4015 in with-output-to-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4026,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4031,a[2]=((C_word*)t0)[2],a[3]=((C_word)li100),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1201: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* f_3362 in process-wait in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3362(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3362,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:522: posix-error */
t6=lf[3];
f_2170(6,t6,t1,lf[124],lf[122],lf[125],((C_word*)t0)[2]);}
else{
/* posix-common.scm:523: values */
C_values(5,0,t1,t2,t3,t4);}}

/* f_4021 in k4015 in with-output-to-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4021,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[198]+1));
t3=C_mutate((C_word*)lf[198]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k4723 in k4717 in k4715 in k4712 in k4710 in $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1533: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* f_5678 */
static void C_ccall f_5678(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5678,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5683,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t5=C_i_foreign_string_argumentp(t2);
/* posix-common.scm:191: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t4,t5);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub117(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t3));}}

/* k4717 in k4715 in k4712 in k4710 in $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4718,2,t0,t1);}
t2=C_flushall();
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4724,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1533: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[4]);}

/* get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4376,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4382,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li120),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_4382(t5,t1,C_fix(0));}

/* k5671 */
static void C_ccall f_5672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5672,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* f_5674 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5674(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[13],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5674,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[401]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5678,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5692,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5704,a[2]=t5,a[3]=t6,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:192: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* f_3357 in process-wait in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3357(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3357,2,t0,t1);}
/* posix-common.scm:520: ##sys#process-wait */
t2=*((C_word*)lf[123]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k4710 in $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4714,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=C_block_size(t1);
/* posixwin.scm:1529: setarg */
t4=((C_word*)t0)[8];
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,C_fix(0),t1,t3);}

/* k4715 in k4712 in k4710 in $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4716(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4716,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4718,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1531: build-exec-argvec */
t3=((C_word*)t0)[5];
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[3],((C_word*)t0)[6],((C_word*)t0)[7],C_fix(0));}

/* k4712 in k4710 in $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4714,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4716,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4727,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[9])){
/* posixwin.scm:1530: $quote-args-list */
f_4556(t3,((C_word*)t0)[9],((C_word*)t0)[10]);}
else{
/* posixwin.scm:1530: build-exec-argvec */
t4=((C_word*)t0)[5];
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,((C_word*)t0)[3],C_SCHEME_FALSE,((C_word*)t0)[8],C_fix(1));}}

/* k5681 */
static void C_ccall f_5683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub117(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]));}

/* k3848 in open-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3849(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3849,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixwin.scm:1136: check */
f_3813(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* $exec-setup in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4705(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4705,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4711,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t5,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t4,a[10]=t6,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1528: pathname-strip-directory */
t9=*((C_word*)lf[306]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t3);}

/* k3841 in open-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1136: check */
f_3813(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* k5690 */
static void C_ccall f_5692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:194: posix-error */
t2=lf[3];
f_2170(7,t2,((C_word*)t0)[2],lf[10],lf[401],lf[402],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2669 in for-each-loop264 in k2634 in k2629 in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2661(t3,((C_word*)t0)[4],t2);}

/* k2476 in check in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* f_2479 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2479(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2479r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2479r(t0,t1,t2,t3);}}

static void C_ccall f_2479r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[56]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2490,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:269: mode */
f_2429(t5,C_SCHEME_TRUE,t3,lf[56]);}

/* k4385 in loop in get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4386,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4394,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=((C_word)li119),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_4394(t5,((C_word*)t0)[4],C_fix(0));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* loop in get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4382(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4382,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4386,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1412: get */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* for-each-loop264 in k2634 in k2629 in delete-directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2661(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2661,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2670,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:328: g265 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4331 in k4324 in duplicate-fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1390: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[64],lf[280],((C_word*)t0)[3]);}

/* k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2694,2,t0,t1);}
t2=C_i_nullp(((C_word*)t0)[2]);
t3=(C_truep(t2)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_check_string_2(t1,lf[29]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2704,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[70]+1)))(4,*((C_word*)lf[70]+1),t9,C_fix(256),C_make_character(32));}

/* directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2690(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2690r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2690r(t0,t1,t2);}}

static void C_ccall f_2690r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2694,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:343: current-directory */
t4=*((C_word*)lf[66]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=t3;
f_2694(2,t4,C_i_car(t2));}}

/* k2489 */
static void C_ccall f_2490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2490,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:269: check */
f_2465(((C_word*)t0)[4],lf[56],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* f_4367 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4367(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4367,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(t2);
t5=stub1013(t3,t4);
/* posixwin.scm:1409: ##sys#peek-c-string */
t6=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* k4364 in unsetenv in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4365(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* f_2492 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2492(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2492r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2492r(t0,t1,t2,t3);}}

static void C_ccall f_2492r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[57]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2503,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:273: mode */
f_2429(t5,C_SCHEME_FALSE,t3,lf[57]);}

/* file-write in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3516(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3516r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3516r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3516r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[158]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3522,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_3522(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:1000: ##sys#signal-hook */
t7=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[15],lf[158],lf[160],t3);}}
else{
/* posixwin.scm:1000: ##sys#signal-hook */
t7=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[15],lf[158],lf[160],t3);}}

/* scan in k4385 in loop in get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4394(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4394,NULL,3,t0,t1,t2);}
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4416,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:1416: substring */
t5=*((C_word*)lf[284]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[2],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posixwin.scm:1417: scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k2435 in mode in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* setenv in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4344(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4344,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[281]);
t5=C_i_check_string_2(t3,lf[281]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4353,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1400: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t6,t2,lf[281]);}

/* close-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3904(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3904,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3908,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1154: ##sys#check-input-port */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[189]+1)))(5,*((C_word*)lf[189]+1),t3,t2,C_SCHEME_TRUE,lf[187]);}

/* k3907 in close-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3908,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3910,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1156: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}

/* k4050 in create-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1218: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* f_5636 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5636(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5636,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[120]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(*((C_word*)lf[119]+1),t2));}

/* k4058 in create-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1217: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[10],lf[199],lf[200]);}

/* k3523 in k3521 in file-write in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_3524(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3524,NULL,2,t0,t1);}
t2=C_i_check_exact_2(t1,lf[158]);
t3=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3528,a[2]=((C_word*)t0)[4],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3533,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1005: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}
else{
t6=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}}

/* k3527 in k3523 in k3521 in file-write in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* system-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5276,2,t0,t1);}
if(C_truep(C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5286,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5297,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1674: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}

/* k3521 in file-write in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3522,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3524,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_3524(t4,C_u_i_car(t3));}
else{
t3=t2;
f_3524(t3,C_block_size(((C_word*)t0)[3]));}}

/* create-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4044(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_4044r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4044r(t0,t1,t2);}}

static void C_ccall f_4044r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_fixnum_or(*((C_word*)lf[136]+1),*((C_word*)lf[138]+1)):C_i_car(t2));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4051,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=C_pipe(C_SCHEME_FALSE,t4);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4059,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1216: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t7);}
else{
/* posixwin.scm:1218: values */
C_values(4,0,t1,C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* f_5644 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5644(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_5644r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5644r(t0,t1,t2);}}

static void C_ccall f_5644r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[102]):C_SCHEME_UNDEFINED);
t6=C_umask(t4);
if(C_truep(t4)){
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
t7=C_umask(t6);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t6);}}

/* check in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2465(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2465,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:262: posix-error */
t6=lf[3];
f_2170(6,t6,t1,lf[10],t2,lf[51],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2477,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:263: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[52]+1)))(6,*((C_word*)lf[52]+1),t6,t4,*((C_word*)lf[53]+1),lf[54],lf[55]);}}

/* unsetenv in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4358(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4358,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[282]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4365,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1405: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t2,lf[282]);}

/* k4355 in k4352 in setenv in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4356(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* k4352 in setenv in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4353(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4353,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4356,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1400: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t2,((C_word*)t0)[3],lf[281]);}

/* change-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3773(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3773,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[67]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3779,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3793,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1112: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t5,t2);}

/* k3778 in change-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3779,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3781,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[3]);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3786,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1114: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}}

/* call-with-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3936(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_3936r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3936r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3936r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3940,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[182]+1),t2,t4);}

/* k3761 */
static void C_ccall f_3762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3762,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3755,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1083: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}}

/* k3939 in call-with-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3940,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3945,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li88),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3950,a[2]=t1,a[3]=((C_word)li89),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1172: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t2,t3);}

/* k3574 in k3556 in file-mkstemp in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1017: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[161],lf[162],((C_word*)t0)[3]);}

/* f_3945 in k3939 in call-with-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3945,2,t0,t1);}
/* posixwin.scm:1173: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k5285 in system-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5286,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5289,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k5288 in k5285 in system-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5289,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5292,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 in ... */
static void C_ccall f_2974(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2974,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2983,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2985,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word)li36),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2990,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word)li37),tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3010,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=((C_word)li38),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:418: ##sys#dynamic-wind */
t10=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t6,t7,t8,t9);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3019,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3022,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:421: pproc */
t4=((C_word*)t0)[9];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[7]);}}

/* k4015 in with-output-to-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4016,2,t0,t1);}
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4021,a[2]=t5,a[3]=t3,a[4]=((C_word)li99),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4026,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4039,a[2]=t3,a[3]=t5,a[4]=((C_word)li102),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1198: ##sys#dynamic-wind */
t9=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,((C_word*)t0)[3],t6,t7,t8);}

/* with-output-to-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4012(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4012r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4012r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4012r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4016,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[186]+1),t2,t4);}

/* k4162 in change-file-mode in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4163,2,t0,t1);}
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4156,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1313: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3911 in k3909 in k3907 in close-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k3909 in k3907 in close-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3910(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3910,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3912,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[3]);
if(C_truep(t3)){
/* posixwin.scm:1158: ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[10],lf[187],lf[188],((C_word*)t0)[4]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[3]);}}

/* k4175 in k4182 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4001 */
static void C_ccall f_4002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k5603 in k5601 */
static void C_ccall f_5604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* f_4007 in k3983 in with-input-from-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4007(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4007,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[196]+1));
t3=C_mutate((C_word*)lf[196]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* close-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3920(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3920,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3924,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1162: ##sys#check-output-port */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[192]+1)))(5,*((C_word*)lf[192]+1),t3,t2,C_SCHEME_TRUE,lf[190]);}

/* k3927 in k3925 in k3923 in close-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k5601 */
static void C_ccall f_5602(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5602,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5604,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t1,C_fix(0)))){
/* posixwin.scm:1073: posix-error */
t3=lf[3];
f_2170(6,t3,t2,lf[10],lf[172],lf[396],((C_word*)t0)[3]);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k3923 in close-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3924(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3924,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3926,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1164: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}

/* k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3597,2,t0,t1);}
t2=C_mutate((C_word*)lf[37]+1 /* (set! character-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3601,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1041: stat-type */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[36]);}

/* k3925 in k3923 in close-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3926(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3926,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3928,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[3]);
if(C_truep(t3)){
/* posixwin.scm:1166: ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[10],lf[190],lf[191],((C_word*)t0)[4]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[3]);}}

/* f_3590 */
static void C_ccall f_3590(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3590,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* get-host-name in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5264(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5264,2,t0,t1);}
if(C_truep(C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm:1664: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[327],lf[328]);}}

/* k4165 in change-file-mode in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1312: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[266]);}

/* check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4168(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4168,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4183,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4186,a[2]=t6,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1323: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* change-file-mode in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4142(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4142,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[266]);
t5=C_i_check_exact_2(t3,lf[266]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4163,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4166,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1312: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* symbolic-link? in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3583(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3583,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[35]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* k5611 */
static void C_ccall f_5613(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[55]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];
f_5602(2,t5,t4);}
else{
t4=((C_word*)t0)[3];
f_5602(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];
f_5602(2,t3,t2);}
else{
/* posixwin.scm:1071: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[15],lf[172],lf[397],((C_word*)t0)[2]);}}}

/* f_3588 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3588(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3588,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3590,a[2]=t2,a[3]=((C_word)li72),tmp=(C_word)a,a+=4,tmp));}

/* k5294 in k5291 in k5288 in k5285 in system-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5295,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list5(&a,5,lf[330],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1));}

/* k5291 in k5288 in k5285 in system-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5292,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5295,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k5296 in system-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1675: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[329],lf[331]);}

/* k4155 in k4162 in change-file-mode in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4156(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1314: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[10],lf[266],lf[267],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k3532 in k3523 in k3521 in file-write in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1006: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[10],lf[158],lf[159],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* ##sys#process-wait in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5245,4,t0,t1,t2,t3);}
if(C_truep(C_process_wait(t2,t3))){
/* posixwin.scm:1650: values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm:1651: values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* f_3950 in k3939 in call-with-input-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3950(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3950r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3950r(t0,t1,t2);}}

static void C_ccall f_3950r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3953,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1175: close-input-pipe */
t4=*((C_word*)lf[187]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2874 */
static void C_ccall f_2875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2875,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2878,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:387: loop */
t4=((C_word*)((C_word*)t0)[4])[1];
f_2850(t4,t2,t3);}

/* k2877 in k2874 */
static void C_ccall f_2878(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2878,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* call-with-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3958(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_3958r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3958r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3958r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3962,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[186]+1),t2,t4);}

/* k3952 */
static void C_ccall f_3953(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k5031 in k5028 in k5025 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5032,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5035,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t1,a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixwin.scm:1606: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[321]+1)))(6,*((C_word*)lf[321]+1),t2,((C_word*)t0)[11],C_fix(0),C_SCHEME_FALSE,lf[322]);}

/* k5037 in k5034 in k5031 in k5028 in k5025 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1604: c-process */
t2=((C_word*)t0)[2];
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_SCHEME_FALSE,((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t1);}

/* k5034 in k5031 in k5028 in k5025 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5035(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5035,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5038,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t1,tmp=(C_word)a,a+=10,tmp);
t3=(C_truep(((C_word*)t0)[9])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[10])?C_fix(0):C_fix(2));
if(C_truep(((C_word*)t0)[11])){
/* posixwin.scm:1607: + */
C_plus(5,0,t2,t3,t4,C_fix(0));}
else{
/* posixwin.scm:1607: + */
C_plus(5,0,t2,t3,t4,C_fix(4));}}

/* file-write-access? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4194(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4194,3,t0,t1,t2);}
/* posixwin.scm:1327: check */
f_4168(t1,t2,C_fix((C_word)4),lf[269]);}

/* k2864 in loop in k2847 in k2841 */
static void C_ccall f_2865(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2865,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2869,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li31),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:378: g355 */
t3=t2;
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:388: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2850(t4,((C_word*)t0)[5],t3);}}

/* f_2869 in k2864 in loop in k2847 in k2841 */
static void C_ccall f_2869(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2869,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2875,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2884,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:386: irregex-match-substring */
t5=*((C_word*)lf[83]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3556 in file-mkstemp in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3557,2,t0,t1);}
t2=C_mkstemp(t1);
t3=C_i_string_length(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3561,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3575,a[2]=t4,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1016: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}
else{
t6=t4;
f_3561(2,t6,C_SCHEME_UNDEFINED);}}

/* file-mkstemp in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3551(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3551,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[161]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3557,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1012: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t2,lf[161]);}

/* k5019 in k4993 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1616: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[124],((C_word*)t0)[3],lf[320],((C_word*)t0)[4]);}

/* f_3696 in k3693 */
static void C_ccall f_3696(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3696,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3711,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1082: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t3,t2,lf[173]);}

/* k5028 in k5025 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5029,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5032,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixwin.scm:1606: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[321]+1)))(6,*((C_word*)lf[321]+1),t2,((C_word*)t0)[11],C_fix(0),C_SCHEME_FALSE,lf[322]);}

/* k5025 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5026,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5029,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixwin.scm:1606: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[321]+1)))(6,*((C_word*)lf[321]+1),t2,((C_word*)t0)[11],C_fix(0),C_SCHEME_FALSE,lf[322]);}

/* k4182 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4183,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4176,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}
else{
/* posixwin.scm:1324: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}}

/* k3693 */
static void C_ccall f_3695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3695,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3696,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1089: g740 */
t3=t2;
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[2],((C_word*)t0)[3]);}}

/* f_3689 in k3686 */
static void C_ccall f_3689(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3689,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3695,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1088: ##sys#file-exists? */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[175]+1)))(6,*((C_word*)lf[175]+1),t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* k3686 */
static void C_ccall f_3688(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3688,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3689,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1097: g737 */
t4=t3;
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* k2883 */
static void C_ccall f_2884(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:386: make-pathname */
t2=*((C_word*)lf[82]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k3679 */
static void C_ccall f_3680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3680,2,t0,t1);}
t2=C_i_car(t1);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3683,a[2]=t3,a[3]=((C_word)li77),tmp=(C_word)a,a+=4,tmp);
t5=t1;
t6=C_u_i_cdr(t5);
t7=C_i_check_list_2(t6,lf[74]);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3725,a[2]=t9,a[3]=t4,a[4]=((C_word)li78),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_3725(t11,((C_word*)t0)[2],t6);}

/* f_3683 in k3679 */
static void C_ccall f_3683(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3683,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3688,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1096: string-append */
t4=*((C_word*)lf[5]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[176],t2);}

/* file-read-access? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4188(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4188,3,t0,t1,t2);}
/* posixwin.scm:1326: check */
f_4168(t1,t2,C_fix((C_word)2),lf[268]);}

/* k4185 in check in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1323: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k5008 in k5005 in k5002 in k4993 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1609: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[5]))),t1);}

/* k5005 in k5002 in k4993 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5006(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5006,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5009,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1613: open-input-file* */
t3=*((C_word*)lf[56]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[6]))));}
else{
/* posixwin.scm:1609: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],t1,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))),C_SCHEME_FALSE);}}

/* k5002 in k4993 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5003,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5006,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm:1611: open-output-file* */
t3=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[7]))));}
else{
t3=t2;
f_5006(2,t3,C_SCHEME_FALSE);}}

/* f_3994 in k3983 in with-input-from-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3994(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3994,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3999,a[2]=((C_word*)t0)[2],a[3]=((C_word)li95),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1191: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* k3566 in k3560 in k3556 in file-mkstemp in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3567(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1018: values */
C_values(4,0,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k3560 in k3556 in file-mkstemp in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3561,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3567,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixwin.scm:1018: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(5,*((C_word*)lf[68]+1),t2,((C_word*)t0)[5],C_fix(0),t3);}

/* f_3999 */
static void C_ccall f_3999(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3999r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3999r(t0,t1,t2);}}

static void C_ccall f_3999r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4002,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1194: close-input-pipe */
t4=*((C_word*)lf[187]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* for-each-loop1295 */
static void C_fcall f_5075(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5075,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5084,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixwin.scm:1626: g1296 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* f_5062 */
static void C_ccall f_5062(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5062,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5066,a[2]=((C_word*)t0)[2],a[3]=((C_word)li145),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5075,a[2]=t7,a[3]=t4,a[4]=((C_word)li146),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_5075(t9,t1,t5);}

/* f_5066 */
static void C_ccall f_5066(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5066,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* f_5060 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5060(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[25],*a=ab;
if(c!=8) C_bad_argc_2(c,8,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr8,(void*)f_5060,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5062,a[2]=t2,a[3]=((C_word)li147),tmp=(C_word)a,a+=4,tmp);
t12=C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5097,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t10,a[8]=t1,a[9]=t11,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm:1629: chkstrlst */
t14=t11;
((C_proc3)(void*)(*((C_word*)t14+1)))(3,t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5129,a[2]=t9,a[3]=t8,a[4]=t13,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1632: ##sys#shell-command-arguments */
t16=*((C_word*)lf[316]+1);
((C_proc3)(void*)(*((C_word*)t16+1)))(3,t16,t15,((C_word*)t8)[1]);}}

/* k5049 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1600: string-intersperse */
t2=*((C_word*)lf[323]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2924(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2924,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2941,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,a[5]=t3,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:412: directory? */
t7=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2922,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2924,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word)li39),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_2924(t5,((C_word*)t0)[7],t1,((C_word*)t0)[8]);}

/* k5096 */
static void C_ccall f_5097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5097,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5099,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1634: chkstrlst */
t3=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_5099(2,t3,C_SCHEME_UNDEFINED);}}

/* k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2941,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3034,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:413: pathname-file */
t3=*((C_word*)lf[92]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3040,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:422: pproc */
t3=((C_word*)t0)[9];
((C_proc3)C_fast_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[8]);}}

/* k5098 in k5096 */
static void C_ccall f_5099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5099,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5104,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li148),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5109,a[2]=((C_word*)t0)[6],a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1635: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[8],t2,t3);}

/* k5083 in for-each-loop1295 */
static void C_ccall f_5084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_5075(t3,((C_word*)t0)[4],t2);}

/* loop in $quote-args-list in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4596(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4596,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1500: ##sys#fast-reverse */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[302]+1)))(3,*((C_word*)lf[302]+1),t1,t3);}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4619,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4622,a[2]=t7,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,a[7]=t6,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm:1505: needs-quoting? */
t9=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t4);}}

/* file-type in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2279(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2279r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2279r(t0,t1,t2,t3);}}

static void C_ccall f_2279r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2295,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:206: ##sys#stat */
f_2186(t12,t2,t5,t9,lf[26]);}

/* k2276 in file-size in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2277,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* k2270 in file-permissions in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-size in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2273(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2273,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2277,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:203: ##sys#stat */
f_2186(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[25]);}

/* f_4561 in $quote-args-list in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4561(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4561,3,t0,t1,t2);}
t3=C_i_string_length(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4569,a[2]=t3,a[3]=t2,a[4]=((C_word)li128),tmp=(C_word)a,a+=5,tmp);
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_4569(t4,C_fix(0)));}

/* k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2916(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2916,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2922,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3052,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[8])){
/* posix-common.scm:406: make-pathname */
t4=*((C_word*)lf[82]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[9],lf[93]);}
else{
/* posix-common.scm:406: make-pathname */
t4=*((C_word*)lf[82]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[9],lf[94]);}}

/* k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2914(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2914,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2916,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=C_i_stringp(((C_word*)t0)[9]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3060,a[2]=t2,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_3060(2,t5,t3);}
else{
/* posix-common.scm:402: irregex? */
t5=*((C_word*)lf[96]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[9]);}}

/* k2901 */
static void C_ccall f_2902(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:380: ##sys#glob->regexp */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[86]+1)))(3,*((C_word*)lf[86]+1),((C_word*)t0)[2],t1);}

/* k2293 in file-type in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[27]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[28]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[29]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[30]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[31]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[32]);}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?lf[33]:lf[27]));}}}}}}}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* f_3010 in k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in ... */
static void C_ccall f_3010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3010,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3894 in open-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3895(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3895,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixwin.scm:1146: check */
f_3813(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-output-pipe in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3867(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3867r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3867r(t0,t1,t2,t3);}}

static void C_ccall f_3867r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[186]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[183]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3880,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[183]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3886,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1149: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t9,t2,lf[186]);}
else{
t9=C_eqp(t6,lf[184]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3895,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1150: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t10,t2,lf[186]);}
else{
/* posixwin.scm:1124: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[185],t6);}}}

/* k3000 in k2995 */
static void C_ccall f_3002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:420: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:419: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_2924(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3018 in k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in ... */
static void C_ccall f_3019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:421: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* process-run in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4896(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4896r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4896r(t0,t1,t2,t3);}}

static void C_ccall f_4896r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4900,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_4900(t6,C_u_i_car(t5));}
else{
t5=t4;
f_4900(t5,C_SCHEME_FALSE);}}

/* ##sys#shell-command-arguments in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4890(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4890,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list2(&a,2,lf[317],t2));}

/* k3007 */
static void C_ccall f_3008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:419: glob */
t2=*((C_word*)lf[80]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2378 */
static void C_ccall f_2379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[28],t1));}

/* k2369 in regular-file? in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[27],t1));}

/* k4499 in k4497 in k4495 in set-buffering-mode! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4501,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[290]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4509,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t4=C_slot(((C_word*)t0)[4],C_fix(7));
t5=C_eqp(lf[55],t4);
if(C_truep(t5)){
t6=C_setvbuf(((C_word*)t0)[4],t1,((C_word*)t0)[2]);
t7=t3;
f_4509(t7,C_fixnum_lessp(t6,C_fix(0)));}
else{
t6=t3;
f_4509(t6,C_SCHEME_TRUE);}}

/* f_2372 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2372(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2372,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2379,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:221: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* set-process-group-id! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5496(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5496,2,t0,t1);}
/* posixwin.scm:1725: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* set-groups! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5490(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5490,2,t0,t1);}
/* posixwin.scm:1724: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* ##sys#process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4981(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr9r,(void*)f_4981r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest(a,C_rest_count(0));
f_4981r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_4981r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(15);
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_SCHEME_FALSE:C_i_car(t9));
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4988,a[2]=t1,a[3]=t8,a[4]=t7,a[5]=t6,a[6]=t2,a[7]=((C_word*)t0)[2],a[8]=t3,tmp=(C_word)a,a+=9,tmp);
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5050,a[2]=t12,tmp=(C_word)a,a+=3,tmp);
t14=C_a_i_cons(&a,2,t3,t4);
/* posixwin.scm:1600: $quote-args-list */
f_4556(t13,t14,t11);}

/* k2387 */
static void C_ccall f_2388(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[31],t1));}

/* k4873 in shell-command in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4874,2,t0,t1);}
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
if(C_truep(C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4885,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1560: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}}

/* f_2381 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2381(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2381,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2388,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:224: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k4507 in k4499 in k4497 in k4495 in set-buffering-mode! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4509(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1465: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[290],lf[291],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* ##sys#shell-command in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4870,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4874,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1556: get-environment-variable */
t3=*((C_word*)lf[314]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[315]);}

/* set-group-id! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5484(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5484,2,t0,t1);}
/* posixwin.scm:1723: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* k4993 in k4987 in process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4994(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4994,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5003,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[8])){
/* posixwin.scm:1610: open-input-file* */
t3=*((C_word*)lf[56]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[9]))));}
else{
t3=t2;
f_5003(2,t3,C_SCHEME_FALSE);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5020,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1615: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}

/* k2396 */
static void C_ccall f_2397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[30],t1));}

/* f_2399 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2399(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2399,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2406,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:230: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* f_2390 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2390(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2390,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2397,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:227: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* read-symbolic-link in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5472(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5472,2,t0,t1);}
/* posixwin.scm:1721: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* set-alarm! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5478(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5478,2,t0,t1);}
/* posixwin.scm:1722: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* k2212 in stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2190(2,t2,(C_truep(((C_word*)t0)[3])?C_lstat(t1):C_stat(t1)));}

/* k3703 in k3710 */
static void C_ccall f_3704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1084: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[173],lf[174],((C_word*)t0)[3]);}

/* k2218 in stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2219(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:161: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* process-signal in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5466(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5466,2,t0,t1);}
/* posixwin.scm:1720: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* process-group-id in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5460(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5460,2,t0,t1);}
/* posixwin.scm:1719: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* k3058 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3060,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3062,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:403: irregex */
t3=*((C_word*)lf[95]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
f_2916(t2,((C_word*)t0)[3]);}}

/* k2221 in stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:162: ##sys#platform-fixup-pathname */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[13]+1)))(3,*((C_word*)lf[13]+1),((C_word*)t0)[2],t1);}

/* k3710 */
static void C_ccall f_3711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3711,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3704,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1083: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}}

/* file-stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2227(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2227r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2227r(t0,t1,t2,t3);}}

static void C_ccall f_2227r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2234,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:178: ##sys#stat */
f_2186(t6,t2,t5,C_SCHEME_TRUE,lf[17]);}

/* f_3074 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3074(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3074,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* process-fork in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5454(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5454,2,t0,t1);}
/* posixwin.scm:1718: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* f_3063 in k3061 in k3058 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3063(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3063,3,t0,t1,t2);}
/* posix-common.scm:404: irregex-match */
t3=*((C_word*)lf[84]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* k3061 in k3058 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3062,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2916(t2,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3063,a[2]=t1,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp));}

/* parent-process-id in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5448(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5448,2,t0,t1);}
/* posixwin.scm:1717: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* memory-mapped-file-pointer in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5442(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5442,2,t0,t1);}
/* posixwin.scm:1716: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* k5310 in current-user-name in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1684: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[332],lf[333]);}

/* change-directory* in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5316(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5316,2,t0,t1);}
/* posixwin.scm:1695: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[334],lf[0]);}

/* k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3099,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3101,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3111,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:425: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[97]+1)))(5,*((C_word*)lf[97]+1),t2,lf[76],((C_word*)t0)[7],t3);}

/* k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3095,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3097,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3117,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:425: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[97]+1)))(5,*((C_word*)lf[97]+1),t2,lf[99],((C_word*)t0)[5],t3);}

/* k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3097,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3099,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3114,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:425: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[97]+1)))(5,*((C_word*)lf[97]+1),t2,lf[98],((C_word*)t0)[6],t3);}

/* k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3093(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3093,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3095,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3120,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:425: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[97]+1)))(5,*((C_word*)lf[97]+1),t2,lf[100],((C_word*)t0)[4],t3);}

/* k4765 in process-execute in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
t2=C_execve(t1);
/* posixwin.scm:1545: $exec-teardown */
f_4735(((C_word*)t0)[3],lf[308],lf[309],((C_word*)t0)[4],t2);}
else{
t2=C_execvp(t1);
/* posixwin.scm:1545: $exec-teardown */
f_4735(((C_word*)t0)[3],lf[308],lf[309],((C_word*)t0)[4],t2);}}

/* initialize-groups in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5436(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5436,2,t0,t1);}
/* posixwin.scm:1715: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* current-user-name in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5302,2,t0,t1);}
if(C_truep(C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5311,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1683: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}

/* group-information in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5430(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5430,2,t0,t1);}
/* posixwin.scm:1714: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3089(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3089r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3089r(t0,t1,t2,t3);}}

static void C_ccall f_3089r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(8);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3093,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3127,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:425: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[97]+1)))(5,*((C_word*)lf[97]+1),t4,lf[101],t3,t5);}

/* f_3083 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3083(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3083,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]));}

/* k3020 in k2972 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in ... */
static void C_ccall f_3022(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:421: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:421: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_2924(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* file-truncate in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5412(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5412,2,t0,t1);}
/* posixwin.scm:1711: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3034(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3034,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[88]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[89]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:413: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3028,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:414: symbolic-link? */
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}}

/* file-unlock in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5418(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5418,2,t0,t1);}
/* posixwin.scm:1712: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3028,2,t0,t1);}
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2962,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2965,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:415: pproc */
t5=((C_word*)t0)[9];
((C_proc3)C_fast_retrieve_proc(t5))(3,t5,t4,((C_word*)t0)[7]);}
else{
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2974,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:416: lproc */
t4=((C_word*)t0)[11];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[7]);}}

/* file-select in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5400(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5400,2,t0,t1);}
/* posixwin.scm:1709: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[349],lf[0]);}

/* file-test-lock in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5406(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5406,2,t0,t1);}
/* posixwin.scm:1710: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* k3038 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3040,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3046,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:422: action */
t3=((C_word*)t0)[5];
((C_proc4)C_fast_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
/* posix-common.scm:423: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k4409 in k4418 in k4415 in scan in k4385 in loop in get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4410,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k4415 in scan in k4385 in loop in get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4416,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4419,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t4=C_block_size(((C_word*)t0)[6]);
/* posixwin.scm:1416: substring */
t5=*((C_word*)lf[284]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[6],t3,t4);}

/* k4418 in k4415 in scan in k4385 in loop in get-environment-variables in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4419(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4419,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4410,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posixwin.scm:1416: loop */
t5=((C_word*)((C_word*)t0)[5])[1];
f_4382(t5,t3,t4);}

/* k3733 in for-each-loop726 in k3679 */
static void C_ccall f_3734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_3725(t3,((C_word*)t0)[4],t2);}

/* k3051 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:406: glob */
t2=*((C_word*)lf[80]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3045 in k3038 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3046(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:422: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* change-file-owner in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5322(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5322,2,t0,t1);}
/* posixwin.scm:1696: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[336],lf[0]);}

/* create-fifo in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5328(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5328,2,t0,t1);}
/* posixwin.scm:1697: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[337],lf[0]);}

/* k3243 in local-time->seconds in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3244,2,t0,t1);}
t2=C_a_mktime(&a,1,((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3250,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:476: fp= */
t4=*((C_word*)lf[113]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[114],t2);}

/* local-time->seconds in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3240(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3240,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3244,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:474: check-time-vector */
f_3136(t3,lf[111],t2);}

/* file-lock/blocking in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5394(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5394,2,t0,t1);}
/* posixwin.scm:1708: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* k4928 in k4924 */
static void C_ccall f_4930(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
t2=((C_word*)t0)[2];
t3=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t4=((C_word*)t0)[3];
t5=(C_truep(t4)?C_i_foreign_pointer_argumentp(t4):C_SCHEME_FALSE);
t6=((C_word*)t0)[4];
t7=(C_truep(t6)?C_i_foreign_pointer_argumentp(t6):C_SCHEME_FALSE);
t8=((C_word*)t0)[5];
t9=(C_truep(t8)?C_i_foreign_pointer_argumentp(t8):C_SCHEME_FALSE);
t10=((C_word*)t0)[6];
t11=(C_truep(t10)?C_i_foreign_pointer_argumentp(t10):C_SCHEME_FALSE);
t12=C_i_foreign_fixnum_argumentp(((C_word*)t0)[7]);
t13=((C_word*)t0)[8];
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,stub1198(C_SCHEME_UNDEFINED,((C_word*)t0)[9],t1,t3,t5,t7,t9,t11,t12));}

/* file-link in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5382(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5382,2,t0,t1);}
/* posixwin.scm:1706: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[346],lf[0]);}

/* file-lock in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5388(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5388,2,t0,t1);}
/* posixwin.scm:1707: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[347],lf[0]);}

/* k4924 */
static void C_ccall f_4926(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4926,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4930,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
t4=C_i_foreign_string_argumentp(t2);
/* posixwin.scm:1594: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,t4);}
else{
t4=t3;
f_4930(2,t4,C_SCHEME_FALSE);}}

/* f_4921 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4921(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word ab[10],*a=ab;
if(c!=10) C_bad_argc_2(c,10,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr10,(void*)f_4921,10,t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4926,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t7,a[7]=t8,a[8]=t9,a[9]=t1,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
t11=C_i_foreign_string_argumentp(t2);
/* posixwin.scm:1594: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t10,t11);}
else{
t11=t10;
f_4926(2,t11,C_SCHEME_FALSE);}}

/* f_3747 in k3673 in create-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3747(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3747,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3762,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1082: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t3,t2,lf[173]);}

/* get-groups in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5424(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5424,2,t0,t1);}
/* posixwin.scm:1713: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* time->string in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3267(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_3267r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3267r(t0,t1,t2,t3);}}

static void C_ccall f_3267r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3274,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:484: check-time-vector */
f_3136(t6,lf[115],t2);}

/* f_3261 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3261(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3261,4,t0,t1,t2,t3);}
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=stub507(t4,t2,t3);
/* posix-common.scm:482: ##sys#peek-c-string */
t6=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* map-file-to-memory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5376(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5376,2,t0,t1);}
/* posixwin.scm:1705: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[345],lf[0]);}

/* terminal-size in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4477(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4477,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4484,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1442: terminal-port? */
t4=*((C_word*)lf[287]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* current-user-id in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5370(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5370,2,t0,t1);}
/* posixwin.scm:1704: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[344],lf[0]);}

/* k3754 in k3761 */
static void C_ccall f_3755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1084: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[173],lf[174],((C_word*)t0)[3]);}

/* f_3255 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3255(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3255,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=stub501(t3,t2);
/* posix-common.scm:481: ##sys#peek-c-string */
t5=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,C_fix(0));}

/* k3248 in k3243 in local-time->seconds in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:477: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[111],lf[112],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}}

/* for-each-loop726 in k3679 */
static void C_fcall f_3725(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3725,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3734,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixwin.scm:1105: g727 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* set-buffering-mode! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4492(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4492r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4492r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4492r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4496,a[2]=t3,a[3]=t1,a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1453: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(4,*((C_word*)lf[63]+1),t5,t2,lf[290]);}

/* current-effective-user-name in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5358(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5358,2,t0,t1);}
/* posixwin.scm:1702: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[342],lf[0]);}

/* current-effective-user-id in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5352(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5352,2,t0,t1);}
/* posixwin.scm:1701: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[341],lf[0]);}

/* k4495 in set-buffering-mode! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4496,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4498,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_4498(t4,C_u_i_car(t3));}
else{
t3=t2;
f_4498(t3,C_fix((C_word)BUFSIZ));}}

/* f_2161 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2161(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2161,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(t2);
t5=stub65(t3,t4);
/* posix-common.scm:116: ##sys#peek-c-string */
t6=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* k4497 in k4495 in set-buffering-mode! in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4498(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4498,NULL,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4501,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(t2,lf[292]);
if(C_truep(t4)){
t5=t3;
f_4501(2,t5,C_fix((C_word)_IOFBF));}
else{
t5=C_eqp(t2,lf[293]);
if(C_truep(t5)){
t6=C_fix((C_word)_IOLBF);
t7=t3;
f_4501(2,t7,t6);}
else{
t6=C_eqp(t2,lf[294]);
if(C_truep(t6)){
t7=t3;
f_4501(2,t7,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm:1459: ##sys#error */
t7=*((C_word*)lf[45]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t3,lf[290],lf[295],((C_word*)t0)[2],((C_word*)t0)[4]);}}}}

/* current-effective-group-id in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5346(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5346,2,t0,t1);}
/* posixwin.scm:1700: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[340],lf[0]);}

/* posix-error in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2170(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_2170r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2170r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2170r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2174,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:119: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* create-symbolic-link in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5340(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5340,2,t0,t1);}
/* posixwin.scm:1699: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[339],lf[0]);}

/* k2173 in posix-error in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2174,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2180,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2183,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:120: strerror */
t4=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* loop */
static C_word C_fcall f_4569(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:
t2=C_eqp(t1,((C_word*)t0)[2]);
if(C_truep(t2)){
return(C_SCHEME_FALSE);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t1);
if(C_truep(C_u_i_char_whitespacep(t3))){
return(C_SCHEME_TRUE);}
else{
t4=C_fixnum_plus(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}}}

/* local-timezone-abbreviation in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4434,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1025(t2);
/* posixwin.scm:1424: ##sys#peek-c-string */
t4=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t3,C_fix(0));}

/* ##sys#stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2186(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2186,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2190,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_2190(2,t7,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2213,a[2]=t6,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2219,a[2]=t7,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2222,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:163: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t9,t2);}
else{
/* posix-common.scm:169: ##sys#signal-hook */
t7=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[15],t5,lf[16],t2);}}}

/* create-session in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5334(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5334,2,t0,t1);}
/* posixwin.scm:1698: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[338],lf[0]);}

/* k2182 in k2173 in posix-error in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:120: string-append */
t2=*((C_word*)lf[5]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],((C_word*)t0)[3],lf[6],t1);}

/* k2179 in k2173 in posix-error in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[2],*((C_word*)lf[4]+1),((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5]);}

/* $quote-args-list in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4556(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4556,NULL,3,t1,t2,t3);}
if(C_truep(t3)){
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4561,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4596,a[2]=t6,a[3]=t4,a[4]=((C_word)li130),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_4596(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* k4463 in terminal-port? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4464(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4464,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4466,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1438: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[62]+1)))(4,*((C_word*)lf[62]+1),t2,((C_word*)t0)[3],C_fix(0));}

/* terminal-port? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4460(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4460,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4464,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1437: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(4,*((C_word*)lf[63]+1),t3,t2,lf[287]);}

/* k4465 in k4463 in terminal-port? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2189 in stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:173: posix-error */
t2=lf[3];
f_2170(6,t2,((C_word*)t0)[3],lf[10],((C_word*)t0)[4],lf[11],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}}

/* k2233 in file-stat in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2234,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),*((C_word*)lf[18]+1),*((C_word*)lf[19]+1)));}

/* k5127 */
static void C_ccall f_5129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5129,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5133,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1633: ##sys#shell-command */
t4=*((C_word*)lf[312]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4215 in mode in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4216(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1344: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* file-access-time in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2249(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2249,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2253,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:199: ##sys#stat */
f_2186(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word ab[89],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2247,2,t0,t1);}
t2=C_mutate((C_word*)lf[20]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate((C_word*)lf[21]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2249,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[22]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2255,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[23]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2261,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[24]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2267,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[25]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2273,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[26]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2279,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[34]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2363,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[35]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2372,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[36]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2381,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[37]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2390,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[38]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2399,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[39]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2408,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[40]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2417,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[41]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t17=C_mutate((C_word*)lf[42]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t18=C_mutate((C_word*)lf[43]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t19=C_SCHEME_UNDEFINED;
t20=(*a=C_VECTOR_TYPE|1,a[1]=t19,tmp=(C_word)a,a+=2,tmp);
t21=C_SCHEME_UNDEFINED;
t22=(*a=C_VECTOR_TYPE|1,a[1]=t21,tmp=(C_word)a,a+=2,tmp);
t23=C_set_block_item(t20,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2429,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t24=C_set_block_item(t22,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2465,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[56]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2479,a[2]=t22,a[3]=t20,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t26=C_mutate((C_word*)lf[57]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2492,a[2]=t22,a[3]=t20,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t27=C_mutate((C_word*)lf[58]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2505,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[64]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2549,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[66]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2572,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[71]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2605,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[29]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2690,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[80]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2814,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[75]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3089,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t34=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3134,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t35=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5644,a[2]=((C_word)li205),tmp=(C_word)a,a+=3,tmp);
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5664,a[2]=((C_word)li206),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:437: getter-with-setter */
t37=*((C_word*)lf[398]+1);
((C_proc5)(void*)(*((C_word*)t37+1)))(5,t37,t34,t35,t36,lf[400]);}

/* k4482 in terminal-size in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1443: values */
C_values(4,0,((C_word*)t0)[2],C_fix(0),C_fix(0));}
else{
/* posixwin.scm:1444: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[288],lf[289],((C_word*)t0)[3]);}}

/* file-open in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3427(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3427r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3427r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3427r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3431,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_3431(t7,C_u_i_car(t6));}
else{
t6=t5;
f_3431(t6,((C_word*)t0)[2]);}}

/* file-execute-access? in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4200(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4200,3,t0,t1,t2);}
/* posixwin.scm:1328: check */
f_4168(t1,t2,C_fix((C_word)2),lf[270]);}

/* mode in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4209(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4209,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4216,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[44]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posixwin.scm:1348: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t5,lf[271],t7);}
else{
/* posixwin.scm:1344: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[272],t4);}}
else{
/* posixwin.scm:1349: ##sys#error */
t9=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[273],t7);}}
else{
if(C_truep(t2)){
/* posixwin.scm:1344: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[274],t4);}
else{
/* posixwin.scm:1344: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[275],t4);}}}

/* k2258 in file-change-time in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2259(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2259,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-change-time in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2255(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2255,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2259,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:200: ##sys#stat */
f_2186(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[22]);}

/* f_5109 in k5098 in k5096 */
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5109,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm:1637: values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm:1638: values */
C_values(5,0,t1,t2,t3,t4);}}

/* k2252 in file-access-time in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2253,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* f_5104 in k5098 in k5096 */
static void C_ccall f_5104(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5104,2,t0,t1);}
/* posixwin.scm:1635: ##sys#process */
t2=*((C_word*)lf[319]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[6],((C_word*)((C_word*)t0)[7])[1]);}

/* k4651 */
static void C_ccall f_4653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1094(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* k2148 */
static void C_ccall f_2149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2149,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2151,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_irregex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k4911 in k4899 in process-run in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4912,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4915,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1571: ##sys#shell-command-arguments */
t3=*((C_word*)lf[316]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k4914 in k4911 in k4899 in process-run in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1571: process-spawn */
t2=*((C_word*)lf[310]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],*((C_word*)lf[298]+1),((C_word*)t0)[3],t1);}

/* k2264 in file-owner in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-permissions in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2267(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2267,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2271,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:202: ##sys#stat */
f_2186(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[24]);}

/* file-owner in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2261(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2261,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2265,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:201: ##sys#stat */
f_2186(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[23]);}

/* k5131 in k5127 */
static void C_ccall f_5133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_5097(2,t3,t2);}

/* process in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5135(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_5135r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5135r(t0,t1,t2,t3);}}

static void C_ccall f_5135r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
if(C_truep(C_i_nullp(t11))){
/* posixwin.scm:1641: %process */
t14=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t14+1)))(8,t14,t1,lf[324],C_SCHEME_FALSE,t2,t5,t9,t13);}
else{
t14=C_i_cdr(t11);
/* posixwin.scm:1641: %process */
t15=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t15+1)))(8,t15,t1,lf[324],C_SCHEME_FALSE,t2,t5,t9,t13);}}

/* f_4645 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4645(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4645,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4653,a[2]=t4,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t7=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1513: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t6,t7);}
else{
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub1094(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE,t7));}}

/* k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2157,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2159,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2753 in k2743 in k2738 in k2734 in loop in k2710 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2754(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2754,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2159(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2159,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2161,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp);
t3=C_mutate(&lf[3] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2170,a[2]=t2,a[3]=((C_word)li1),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[8]+1 /* (set! ##sys#posix-error ...) */,lf[3]);
t5=C_mutate(&lf[9] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2186,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[17]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2227,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2247,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5669,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5674,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:186: getter-with-setter */
t10=*((C_word*)lf[398]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t7,t8,t9,lf[403]);}

/* current-group-id in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_5364(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5364,2,t0,t1);}
/* posixwin.scm:1703: error */
t2=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[343],lf[0]);}

/* k4899 in process-run in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_4900(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4900,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm:1570: process-spawn */
t2=*((C_word*)lf[310]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],*((C_word*)lf[298]+1),((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4912,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1571: ##sys#shell-command */
t3=*((C_word*)lf[312]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2150 in k2148 */
static void C_ccall f_2151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2151,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2153,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2152 in k2150 in k2148 */
static void C_ccall f_2153(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2153,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2155,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2155,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2157,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k4633 */
static void C_ccall f_4635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1084(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2704,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2706,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:346: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[79]+1)))(2,*((C_word*)lf[79]+1),t2);}

/* k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2706(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2706,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2708,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:347: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[79]+1)))(2,*((C_word*)lf[79]+1),t2);}

/* k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2708(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2708,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2711,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2784,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:350: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[4]);}

/* k4620 in loop in $quote-args-list in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4622,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm:1505: string-append */
t2=*((C_word*)lf[5]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[303],((C_word*)t0)[3],lf[304]);}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
/* posixwin.scm:1502: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_4596(t3,((C_word*)t0)[6],((C_word*)t0)[7],t2);}}

/* f_4442 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4442(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4442,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1031(C_SCHEME_UNDEFINED,t3));}

/* f_4627 in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4627(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4627,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4635,a[2]=t4,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t7=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1512: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t6,t7);}
else{
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub1084(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE,t7));}}

/* _exit in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4447(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_4447r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4447r(t0,t1,t2);}}

static void C_ccall f_4447r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
/* posixwin.scm:1434: ex0 */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
/* posixwin.scm:1434: ex0 */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t1,C_fix(0));}}

/* k4618 in loop in $quote-args-list in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4619,2,t0,t1);}
t2=C_a_i_cons(&a,2,t1,((C_word*)t0)[2]);
/* posixwin.scm:1502: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4596(t3,((C_word*)t0)[4],((C_word*)t0)[5],t2);}

/* loop in k2710 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2725(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2725,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2735,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:360: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(5,*((C_word*)lf[68]+1),t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k4272 in open-input-file* in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4273,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posixwin.scm:1363: check */
f_4245(((C_word*)t0)[4],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* open-output-file* in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4275(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4275r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4275r(t0,t1,t2,t3);}}

static void C_ccall f_4275r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[57]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4286,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1367: mode */
f_4209(t5,C_SCHEME_FALSE,t3,lf[57]);}

/* k3675 in k3673 in create-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* f_3677 in k3673 in create-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3677(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3677,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3680,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1092: string-split */
t4=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[178]);}

/* k3470 in file-close in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:981: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[153],lf[154],((C_word*)t0)[3]);}

/* k3673 in create-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3674,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3676,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3677,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1105: g719 */
t4=t3;
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3747,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1106: g750 */
t4=t3;
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t1);}}

/* k3484 in file-read in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3485,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3487,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t1))){
if(C_truep(C_byteblockp(t1))){
t3=t2;
f_3487(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:989: ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[15],lf[155],lf[157],t1);}}
else{
/* posixwin.scm:989: ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[15],lf[155],lf[157],t1);}}

/* k3486 in k3484 in file-read in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3487(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3487,2,t0,t1);}
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3489,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3497,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:992: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list2(&a,2,((C_word*)t0)[3],t2));}}

/* k3488 in k3486 in k3484 in file-read in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3489,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]));}

/* create-directory in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3665(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3665r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3665r(t0,t1,t2,t3);}}

static void C_ccall f_3665r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_check_string_2(t2,lf[173]);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3674,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1103: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word t192;
C_word t193;
C_word t194;
C_word t195;
C_word t196;
C_word t197;
C_word ab[339],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3663,2,t0,t1);}
t2=C_mutate((C_word*)lf[172]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[173]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3665,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[67]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3773,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3813,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp);
t6=C_mutate((C_word*)lf[182]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3830,a[2]=t5,a[3]=((C_word)li84),tmp=(C_word)a,a+=4,tmp));
t7=C_mutate((C_word*)lf[186]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3867,a[2]=t5,a[3]=((C_word)li85),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate((C_word*)lf[187]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3904,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[190]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3920,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[193]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3936,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[194]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3958,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[195]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3980,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[197]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4012,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[199]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4044,a[2]=((C_word)li104),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[201]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t16=C_mutate((C_word*)lf[202]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t17=C_mutate((C_word*)lf[203]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t18=C_mutate((C_word*)lf[204]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t19=C_mutate((C_word*)lf[205]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t20=C_mutate((C_word*)lf[206]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t21=C_mutate((C_word*)lf[207]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t22=C_set_block_item(lf[208] /* signal/alrm */,0,C_fix(0));
t23=C_set_block_item(lf[209] /* signal/chld */,0,C_fix(0));
t24=C_set_block_item(lf[210] /* signal/cont */,0,C_fix(0));
t25=C_set_block_item(lf[211] /* signal/hup */,0,C_fix(0));
t26=C_set_block_item(lf[212] /* signal/io */,0,C_fix(0));
t27=C_set_block_item(lf[213] /* signal/kill */,0,C_fix(0));
t28=C_set_block_item(lf[214] /* signal/pipe */,0,C_fix(0));
t29=C_set_block_item(lf[215] /* signal/prof */,0,C_fix(0));
t30=C_set_block_item(lf[216] /* signal/quit */,0,C_fix(0));
t31=C_set_block_item(lf[217] /* signal/stop */,0,C_fix(0));
t32=C_set_block_item(lf[218] /* signal/trap */,0,C_fix(0));
t33=C_set_block_item(lf[219] /* signal/tstp */,0,C_fix(0));
t34=C_set_block_item(lf[220] /* signal/urg */,0,C_fix(0));
t35=C_set_block_item(lf[221] /* signal/usr1 */,0,C_fix(0));
t36=C_set_block_item(lf[222] /* signal/usr2 */,0,C_fix(0));
t37=C_set_block_item(lf[223] /* signal/vtalrm */,0,C_fix(0));
t38=C_set_block_item(lf[224] /* signal/winch */,0,C_fix(0));
t39=C_set_block_item(lf[225] /* signal/xcpu */,0,C_fix(0));
t40=C_set_block_item(lf[226] /* signal/xfsz */,0,C_fix(0));
t41=C_a_i_list7(&a,7,*((C_word*)lf[201]+1),*((C_word*)lf[202]+1),*((C_word*)lf[203]+1),*((C_word*)lf[204]+1),*((C_word*)lf[205]+1),*((C_word*)lf[206]+1),*((C_word*)lf[207]+1));
t42=C_mutate((C_word*)lf[227]+1 /* (set! signals-list ...) */,t41);
t43=C_mutate((C_word*)lf[228]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t44=C_mutate((C_word*)lf[229]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t45=C_mutate((C_word*)lf[230]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t46=C_mutate((C_word*)lf[231]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t47=C_mutate((C_word*)lf[232]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t48=C_mutate((C_word*)lf[233]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t49=C_mutate((C_word*)lf[234]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t50=C_mutate((C_word*)lf[235]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t51=C_mutate((C_word*)lf[236]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t52=C_mutate((C_word*)lf[237]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t53=C_mutate((C_word*)lf[238]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t54=C_mutate((C_word*)lf[239]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t55=C_mutate((C_word*)lf[240]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t56=C_mutate((C_word*)lf[241]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t57=C_mutate((C_word*)lf[242]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t58=C_mutate((C_word*)lf[243]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t59=C_mutate((C_word*)lf[244]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t60=C_mutate((C_word*)lf[245]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t61=C_mutate((C_word*)lf[246]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t62=C_mutate((C_word*)lf[247]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t63=C_mutate((C_word*)lf[248]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t64=C_mutate((C_word*)lf[249]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t65=C_mutate((C_word*)lf[250]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t66=C_mutate((C_word*)lf[251]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t67=C_mutate((C_word*)lf[252]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t68=C_mutate((C_word*)lf[253]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t69=C_mutate((C_word*)lf[254]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t70=C_mutate((C_word*)lf[255]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t71=C_mutate((C_word*)lf[256]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t72=C_mutate((C_word*)lf[257]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t73=C_mutate((C_word*)lf[258]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t74=C_mutate((C_word*)lf[259]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t75=C_mutate((C_word*)lf[260]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t76=C_mutate((C_word*)lf[261]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t77=C_mutate((C_word*)lf[262]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t78=C_mutate((C_word*)lf[263]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t79=C_mutate((C_word*)lf[264]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t80=C_mutate((C_word*)lf[265]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t81=C_mutate((C_word*)lf[266]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4142,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t82=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4168,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp);
t83=C_mutate((C_word*)lf[268]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4188,a[2]=t82,a[3]=((C_word)li107),tmp=(C_word)a,a+=4,tmp));
t84=C_mutate((C_word*)lf[269]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4194,a[2]=t82,a[3]=((C_word)li108),tmp=(C_word)a,a+=4,tmp));
t85=C_mutate((C_word*)lf[270]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4200,a[2]=t82,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp));
t86=C_mutate((C_word*)lf[41]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t87=C_mutate((C_word*)lf[42]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t88=C_mutate((C_word*)lf[43]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t89=C_SCHEME_UNDEFINED;
t90=(*a=C_VECTOR_TYPE|1,a[1]=t89,tmp=(C_word)a,a+=2,tmp);
t91=C_SCHEME_UNDEFINED;
t92=(*a=C_VECTOR_TYPE|1,a[1]=t91,tmp=(C_word)a,a+=2,tmp);
t93=C_set_block_item(t90,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4209,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t94=C_set_block_item(t92,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4245,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[56]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4262,a[2]=t92,a[3]=t90,a[4]=((C_word)li112),tmp=(C_word)a,a+=5,tmp));
t96=C_mutate((C_word*)lf[57]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4275,a[2]=t92,a[3]=t90,a[4]=((C_word)li113),tmp=(C_word)a,a+=5,tmp));
t97=C_mutate((C_word*)lf[58]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4288,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate((C_word*)lf[64]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4319,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t99=C_mutate((C_word*)lf[281]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4344,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate((C_word*)lf[282]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4358,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t101=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4367,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp);
t102=C_mutate((C_word*)lf[283]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4376,a[2]=t101,a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp));
t103=C_mutate((C_word*)lf[285]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4434,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t104=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4442,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp);
t105=C_mutate((C_word*)lf[286]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4447,a[2]=t104,a[3]=((C_word)li124),tmp=(C_word)a,a+=4,tmp));
t106=C_mutate((C_word*)lf[287]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4460,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[288]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4477,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[290]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4492,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[296]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t110=C_mutate((C_word*)lf[297]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t111=C_mutate((C_word*)lf[298]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t112=C_mutate((C_word*)lf[299]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t113=C_mutate((C_word*)lf[300]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t114=C_mutate(&lf[301] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4556,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t115=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4627,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp);
t116=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4645,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp);
t117=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4663,a[2]=((C_word)li135),tmp=(C_word)a,a+=3,tmp);
t118=C_mutate(&lf[305] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4705,a[2]=t117,a[3]=t116,a[4]=t115,a[5]=((C_word)li136),tmp=(C_word)a,a+=6,tmp));
t119=C_mutate(&lf[307] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4735,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[308]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4750,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[310]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4810,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[312]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4870,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[316]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4890,a[2]=((C_word)li141),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[318]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4896,a[2]=((C_word)li142),tmp=(C_word)a,a+=3,tmp));
t125=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4921,a[2]=((C_word)li143),tmp=(C_word)a,a+=3,tmp);
t126=C_mutate((C_word*)lf[319]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4981,a[2]=t125,a[3]=((C_word)li144),tmp=(C_word)a,a+=4,tmp));
t127=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5060,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp);
t128=C_mutate((C_word*)lf[324]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5135,a[2]=t127,a[3]=((C_word)li151),tmp=(C_word)a,a+=4,tmp));
t129=C_mutate((C_word*)lf[325]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5190,a[2]=t127,a[3]=((C_word)li152),tmp=(C_word)a,a+=4,tmp));
t130=C_mutate((C_word*)lf[123]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5245,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[326]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5257,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[327]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5264,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[329]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5276,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[332]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5302,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[334]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5316,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[336]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5322,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[337]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5328,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[338]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5334,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[339]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5340,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[340]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5346,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[341]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5352,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[342]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5358,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[343]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5364,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[344]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5370,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[345]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5376,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[346]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5382,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[347]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5388,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[348]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5394,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[349]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5400,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[350]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5406,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[351]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5412,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[352]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5418,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[353]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5424,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[354]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5430,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[355]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5436,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[356]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5442,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[357]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5448,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[358]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5454,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[359]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5460,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate((C_word*)lf[360]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5466,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate((C_word*)lf[361]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5472,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate((C_word*)lf[362]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5478,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[363]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5484,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate((C_word*)lf[364]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5490,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate((C_word*)lf[365]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5496,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t166=C_mutate((C_word*)lf[366]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5502,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t167=C_mutate((C_word*)lf[367]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5508,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t168=C_mutate((C_word*)lf[368]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5514,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t169=C_mutate((C_word*)lf[369]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5520,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t170=C_mutate((C_word*)lf[370]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5526,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t171=C_mutate((C_word*)lf[371]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5532,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate((C_word*)lf[372]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5538,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate((C_word*)lf[373]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5544,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate((C_word*)lf[374]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5550,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate((C_word*)lf[375]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5556,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t176=C_mutate((C_word*)lf[376]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5562,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[377]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5568,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t178=C_set_block_item(lf[378] /* errno/wouldblock */,0,C_fix(0));
t179=C_mutate((C_word*)lf[38]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5575,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[379]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5579,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t181=C_set_block_item(lf[380] /* map/anonymous */,0,C_fix(0));
t182=C_set_block_item(lf[381] /* map/file */,0,C_fix(0));
t183=C_set_block_item(lf[382] /* map/fixed */,0,C_fix(0));
t184=C_set_block_item(lf[383] /* map/private */,0,C_fix(0));
t185=C_set_block_item(lf[384] /* map/shared */,0,C_fix(0));
t186=C_set_block_item(lf[385] /* open/fsync */,0,C_fix(0));
t187=C_set_block_item(lf[386] /* open/noctty */,0,C_fix(0));
t188=C_set_block_item(lf[387] /* open/nonblock */,0,C_fix(0));
t189=C_set_block_item(lf[388] /* open/sync */,0,C_fix(0));
t190=C_set_block_item(lf[389] /* perm/isgid */,0,C_fix(0));
t191=C_set_block_item(lf[390] /* perm/isuid */,0,C_fix(0));
t192=C_set_block_item(lf[391] /* perm/isvtx */,0,C_fix(0));
t193=C_set_block_item(lf[392] /* prot/exec */,0,C_fix(0));
t194=C_set_block_item(lf[393] /* prot/none */,0,C_fix(0));
t195=C_set_block_item(lf[394] /* prot/read */,0,C_fix(0));
t196=C_set_block_item(lf[395] /* prot/write */,0,C_fix(0));
t197=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t197+1)))(2,t197,C_SCHEME_UNDEFINED);}

/* k2743 in k2738 in k2734 in loop in k2710 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2745(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2745,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:367: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2725(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2754,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:368: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_2725(t3,t2);}}

/* k4291 in port->fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4292,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4317,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1372: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[62]+1)))(4,*((C_word*)lf[62]+1),t2,((C_word*)t0)[3],C_fix(0));}

/* file-read in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3477(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3477r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3477r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3477r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[155]);
t6=C_i_check_exact_2(t3,lf[155]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3485,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_3485(2,t9,C_u_i_car(t8));}
else{
t8=t3;
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[70]+1)))(4,*((C_word*)lf[70]+1),t7,t8,C_make_character(32));}}

/* k2734 in loop in k2710 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2735,2,t0,t1);}
t2=C_i_string_ref(t1,C_fix(0));
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2739,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
t4=t1;
t5=t3;
f_2739(t5,C_subchar(t4,C_fix(1)));}
else{
t4=t3;
f_2739(t4,C_SCHEME_FALSE);}}

/* regular-file? in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2363(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2363,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2370,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:218: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2738 in k2734 in loop in k2710 in k2707 in k2705 in k2703 in k2693 in directory in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_fcall f_2739(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2739,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2745,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=C_eqp(C_make_character(46),((C_word*)t0)[5]);
if(C_truep(t3)){
t4=C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_2745(t5,t4);}
else{
t5=C_eqp(C_make_character(46),t1);
if(C_truep(t5)){
t6=C_eqp(C_fix(2),((C_word*)t0)[6]);
t7=t2;
f_2745(t7,(C_truep(t6)?t6:C_i_not(((C_word*)t0)[7])));}
else{
t6=t2;
f_2745(t6,C_i_not(((C_word*)t0)[7]));}}}
else{
t4=t2;
f_2745(t4,C_SCHEME_FALSE);}}

/* k3439 in k3430 in file-open in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3440,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3442,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3447,a[2]=t3,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:972: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k4285 in open-output-file* in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4286,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posixwin.scm:1367: check */
f_4245(((C_word*)t0)[4],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* port->fileno in k3661 in k3607 in k3603 in k3599 in k3595 in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_4288(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4288,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4292,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1371: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(4,*((C_word*)lf[63]+1),t3,t2,lf[58]);}

/* k3496 in k3486 in k3484 in file-read in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3497(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:993: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[10],lf[155],lf[156],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k2961 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 in ... */
static void C_ccall f_2962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:415: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2924(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k2963 in k3026 in k3033 in k2939 in loop in k2921 in k2915 in k2913 in k3102 in k3100 in k3098 in k3096 in k3094 in k3092 in find-files in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 in ... */
static void C_ccall f_2965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:415: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:415: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_2924(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3446 in k3439 in k3430 in file-open in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:973: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[2],lf[10],lf[151],lf[152],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* k3441 in k3439 in k3430 in file-open in k3327 in k3132 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_3442(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k2502 */
static void C_ccall f_2503(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2503,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:273: check */
f_2465(((C_word*)t0)[4],lf[57],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* f_2505 in k2245 in k2158 in k2156 in k2154 in k2152 in k2150 in k2148 */
static void C_ccall f_2505(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2505,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2509,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:277: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(4,*((C_word*)lf[63]+1),t3,t2,lf[58]);}

/* k2508 */
static void C_ccall f_2509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2509,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(lf[33],t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2521,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:283: ##sys#port-data */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[59]+1)))(3,*((C_word*)lf[59]+1),t4,((C_word*)t0)[2]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2544,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:284: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[62]+1)))(4,*((C_word*)lf[62]+1),t4,((C_word*)t0)[2],C_fix(0));}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[463] = {
{"f_2999:posixwin_2escm",(void*)f_2999},
{"f_2996:posixwin_2escm",(void*)f_2996},
{"f_2990:posixwin_2escm",(void*)f_2990},
{"f_3431:posixwin_2escm",(void*)f_3431},
{"f_5190:posixwin_2escm",(void*)f_5190},
{"f_2985:posixwin_2escm",(void*)f_2985},
{"f_2983:posixwin_2escm",(void*)f_2983},
{"f_4249:posixwin_2escm",(void*)f_4249},
{"f_4245:posixwin_2escm",(void*)f_4245},
{"f_2521:posixwin_2escm",(void*)f_2521},
{"f_2529:posixwin_2escm",(void*)f_2529},
{"f_3459:posixwin_2escm",(void*)f_3459},
{"f_3453:posixwin_2escm",(void*)f_3453},
{"f_2711:posixwin_2escm",(void*)f_2711},
{"f_4262:posixwin_2escm",(void*)f_4262},
{"f_4260:posixwin_2escm",(void*)f_4260},
{"f_3880:posixwin_2escm",(void*)f_3880},
{"f_3886:posixwin_2escm",(void*)f_3886},
{"f_2645:posixwin_2escm",(void*)f_2645},
{"f_2587:posixwin_2escm",(void*)f_2587},
{"f_5704:posixwin_2escm",(void*)f_5704},
{"f_2585:posixwin_2escm",(void*)f_2585},
{"f_5599:posixwin_2escm",(void*)f_5599},
{"f_5575:posixwin_2escm",(void*)f_5575},
{"f_5579:posixwin_2escm",(void*)f_5579},
{"f_2612:posixwin_2escm",(void*)f_2612},
{"f_2616:posixwin_2escm",(void*)f_2616},
{"f_2572:posixwin_2escm",(void*)f_2572},
{"f_2549:posixwin_2escm",(void*)f_2549},
{"f_2544:posixwin_2escm",(void*)f_2544},
{"f_2636:posixwin_2escm",(void*)f_2636},
{"f_2635:posixwin_2escm",(void*)f_2635},
{"f_2630:posixwin_2escm",(void*)f_2630},
{"f_2656:posixwin_2escm",(void*)f_2656},
{"f_2651:posixwin_2escm",(void*)f_2651},
{"f_3793:posixwin_2escm",(void*)f_3793},
{"f_5520:posixwin_2escm",(void*)f_5520},
{"f_5526:posixwin_2escm",(void*)f_5526},
{"f_3781:posixwin_2escm",(void*)f_3781},
{"f_5514:posixwin_2escm",(void*)f_5514},
{"f_3786:posixwin_2escm",(void*)f_3786},
{"f_2557:posixwin_2escm",(void*)f_2557},
{"f_2555:posixwin_2escm",(void*)f_2555},
{"f_4988:posixwin_2escm",(void*)f_4988},
{"f_5502:posixwin_2escm",(void*)f_5502},
{"f_5508:posixwin_2escm",(void*)f_5508},
{"f_2834:posixwin_2escm",(void*)f_2834},
{"f_2839:posixwin_2escm",(void*)f_2839},
{"f_2605:posixwin_2escm",(void*)f_2605},
{"f_2820:posixwin_2escm",(void*)f_2820},
{"f_2850:posixwin_2escm",(void*)f_2850},
{"f_3281:posixwin_2escm",(void*)f_3281},
{"f_2842:posixwin_2escm",(void*)f_2842},
{"f_2848:posixwin_2escm",(void*)f_2848},
{"f_3274:posixwin_2escm",(void*)f_3274},
{"f_3601:posixwin_2escm",(void*)f_3601},
{"f_3605:posixwin_2escm",(void*)f_3605},
{"f_3609:posixwin_2escm",(void*)f_3609},
{"f_3611:posixwin_2escm",(void*)f_3611},
{"f_3615:posixwin_2escm",(void*)f_3615},
{"f_3292:posixwin_2escm",(void*)f_3292},
{"f_3290:posixwin_2escm",(void*)f_3290},
{"f_2814:posixwin_2escm",(void*)f_2814},
{"f_3329:posixwin_2escm",(void*)f_3329},
{"f_3315:posixwin_2escm",(void*)f_3315},
{"f_3980:posixwin_2escm",(void*)f_3980},
{"f_3984:posixwin_2escm",(void*)f_3984},
{"f_3989:posixwin_2escm",(void*)f_3989},
{"f_3621:posixwin_2escm",(void*)f_3621},
{"f_3117:posixwin_2escm",(void*)f_3117},
{"f_3114:posixwin_2escm",(void*)f_3114},
{"f_3627:posixwin_2escm",(void*)f_3627},
{"f_3111:posixwin_2escm",(void*)f_3111},
{"f_3205:posixwin_2escm",(void*)f_3205},
{"f_3972:posixwin_2escm",(void*)f_3972},
{"f_3975:posixwin_2escm",(void*)f_3975},
{"f_3108:posixwin_2escm",(void*)f_3108},
{"f_3103:posixwin_2escm",(void*)f_3103},
{"f_3633:posixwin_2escm",(void*)f_3633},
{"f_3101:posixwin_2escm",(void*)f_3101},
{"f_3962:posixwin_2escm",(void*)f_3962},
{"f_3967:posixwin_2escm",(void*)f_3967},
{"f_4885:posixwin_2escm",(void*)f_4885},
{"f_3214:posixwin_2escm",(void*)f_3214},
{"f_2784:posixwin_2escm",(void*)f_2784},
{"f_3210:posixwin_2escm",(void*)f_3210},
{"f_4690:posixwin_2escm",(void*)f_4690},
{"f_3175:posixwin_2escm",(void*)f_3175},
{"f_5568:posixwin_2escm",(void*)f_5568},
{"f_5562:posixwin_2escm",(void*)f_5562},
{"f_4673:posixwin_2escm",(void*)f_4673},
{"f_5556:posixwin_2escm",(void*)f_5556},
{"f_5550:posixwin_2escm",(void*)f_5550},
{"f_3196:posixwin_2escm",(void*)f_3196},
{"f_3813:posixwin_2escm",(void*)f_3813},
{"f_4663:posixwin_2escm",(void*)f_4663},
{"f_3817:posixwin_2escm",(void*)f_3817},
{"f_5544:posixwin_2escm",(void*)f_5544},
{"f_3180:posixwin_2escm",(void*)f_3180},
{"f_5538:posixwin_2escm",(void*)f_5538},
{"f_5532:posixwin_2escm",(void*)f_5532},
{"f_3136:posixwin_2escm",(void*)f_3136},
{"f_3134:posixwin_2escm",(void*)f_3134},
{"f_3129:posixwin_2escm",(void*)f_3129},
{"f_3127:posixwin_2escm",(void*)f_3127},
{"f_3122:posixwin_2escm",(void*)f_3122},
{"f_3120:posixwin_2escm",(void*)f_3120},
{"f_4327:posixwin_2escm",(void*)f_4327},
{"f_4325:posixwin_2escm",(void*)f_4325},
{"f_3154:posixwin_2escm",(void*)f_3154},
{"f_3159:posixwin_2escm",(void*)f_3159},
{"toplevel:posixwin_2escm",(void*)C_posix_toplevel},
{"f_3858:posixwin_2escm",(void*)f_3858},
{"f_4810:posixwin_2escm",(void*)f_4810},
{"f_5257:posixwin_2escm",(void*)f_5257},
{"f_4300:posixwin_2escm",(void*)f_4300},
{"f_3828:posixwin_2escm",(void*)f_3828},
{"f_4305:posixwin_2escm",(void*)f_4305},
{"f_2406:posixwin_2escm",(void*)f_2406},
{"f_2408:posixwin_2escm",(void*)f_2408},
{"f_3830:posixwin_2escm",(void*)f_3830},
{"f_4750:posixwin_2escm",(void*)f_4750},
{"f_2417:posixwin_2escm",(void*)f_2417},
{"f_2415:posixwin_2escm",(void*)f_2415},
{"f_4319:posixwin_2escm",(void*)f_4319},
{"f_4739:posixwin_2escm",(void*)f_4739},
{"f_2424:posixwin_2escm",(void*)f_2424},
{"f_2429:posixwin_2escm",(void*)f_2429},
{"f_4034:posixwin_2escm",(void*)f_4034},
{"f_3337:posixwin_2escm",(void*)f_3337},
{"f_4826:posixwin_2escm",(void*)f_4826},
{"f_3331:posixwin_2escm",(void*)f_3331},
{"f_4031:posixwin_2escm",(void*)f_4031},
{"f_4039:posixwin_2escm",(void*)f_4039},
{"f_4735:posixwin_2escm",(void*)f_4735},
{"f_4317:posixwin_2escm",(void*)f_4317},
{"f_5669:posixwin_2escm",(void*)f_5669},
{"f_4727:posixwin_2escm",(void*)f_4727},
{"f_5664:posixwin_2escm",(void*)f_5664},
{"f_4026:posixwin_2escm",(void*)f_4026},
{"f_3362:posixwin_2escm",(void*)f_3362},
{"f_4021:posixwin_2escm",(void*)f_4021},
{"f_4724:posixwin_2escm",(void*)f_4724},
{"f_5678:posixwin_2escm",(void*)f_5678},
{"f_4718:posixwin_2escm",(void*)f_4718},
{"f_4376:posixwin_2escm",(void*)f_4376},
{"f_5672:posixwin_2escm",(void*)f_5672},
{"f_5674:posixwin_2escm",(void*)f_5674},
{"f_3357:posixwin_2escm",(void*)f_3357},
{"f_4711:posixwin_2escm",(void*)f_4711},
{"f_4716:posixwin_2escm",(void*)f_4716},
{"f_4714:posixwin_2escm",(void*)f_4714},
{"f_5683:posixwin_2escm",(void*)f_5683},
{"f_3849:posixwin_2escm",(void*)f_3849},
{"f_4705:posixwin_2escm",(void*)f_4705},
{"f_3843:posixwin_2escm",(void*)f_3843},
{"f_5692:posixwin_2escm",(void*)f_5692},
{"f_2670:posixwin_2escm",(void*)f_2670},
{"f_2477:posixwin_2escm",(void*)f_2477},
{"f_2479:posixwin_2escm",(void*)f_2479},
{"f_4386:posixwin_2escm",(void*)f_4386},
{"f_4382:posixwin_2escm",(void*)f_4382},
{"f_2661:posixwin_2escm",(void*)f_2661},
{"f_4332:posixwin_2escm",(void*)f_4332},
{"f_2694:posixwin_2escm",(void*)f_2694},
{"f_2690:posixwin_2escm",(void*)f_2690},
{"f_2490:posixwin_2escm",(void*)f_2490},
{"f_4367:posixwin_2escm",(void*)f_4367},
{"f_4365:posixwin_2escm",(void*)f_4365},
{"f_2492:posixwin_2escm",(void*)f_2492},
{"f_3516:posixwin_2escm",(void*)f_3516},
{"f_4394:posixwin_2escm",(void*)f_4394},
{"f_2436:posixwin_2escm",(void*)f_2436},
{"f_4344:posixwin_2escm",(void*)f_4344},
{"f_3904:posixwin_2escm",(void*)f_3904},
{"f_3908:posixwin_2escm",(void*)f_3908},
{"f_4051:posixwin_2escm",(void*)f_4051},
{"f_5636:posixwin_2escm",(void*)f_5636},
{"f_4059:posixwin_2escm",(void*)f_4059},
{"f_3524:posixwin_2escm",(void*)f_3524},
{"f_3528:posixwin_2escm",(void*)f_3528},
{"f_5276:posixwin_2escm",(void*)f_5276},
{"f_3522:posixwin_2escm",(void*)f_3522},
{"f_4044:posixwin_2escm",(void*)f_4044},
{"f_5644:posixwin_2escm",(void*)f_5644},
{"f_2465:posixwin_2escm",(void*)f_2465},
{"f_4358:posixwin_2escm",(void*)f_4358},
{"f_4356:posixwin_2escm",(void*)f_4356},
{"f_4353:posixwin_2escm",(void*)f_4353},
{"f_3773:posixwin_2escm",(void*)f_3773},
{"f_3779:posixwin_2escm",(void*)f_3779},
{"f_3936:posixwin_2escm",(void*)f_3936},
{"f_3762:posixwin_2escm",(void*)f_3762},
{"f_3940:posixwin_2escm",(void*)f_3940},
{"f_3575:posixwin_2escm",(void*)f_3575},
{"f_3945:posixwin_2escm",(void*)f_3945},
{"f_5286:posixwin_2escm",(void*)f_5286},
{"f_5289:posixwin_2escm",(void*)f_5289},
{"f_2974:posixwin_2escm",(void*)f_2974},
{"f_4016:posixwin_2escm",(void*)f_4016},
{"f_4012:posixwin_2escm",(void*)f_4012},
{"f_4163:posixwin_2escm",(void*)f_4163},
{"f_3912:posixwin_2escm",(void*)f_3912},
{"f_3910:posixwin_2escm",(void*)f_3910},
{"f_4176:posixwin_2escm",(void*)f_4176},
{"f_4002:posixwin_2escm",(void*)f_4002},
{"f_5604:posixwin_2escm",(void*)f_5604},
{"f_4007:posixwin_2escm",(void*)f_4007},
{"f_3920:posixwin_2escm",(void*)f_3920},
{"f_3928:posixwin_2escm",(void*)f_3928},
{"f_5602:posixwin_2escm",(void*)f_5602},
{"f_3924:posixwin_2escm",(void*)f_3924},
{"f_3597:posixwin_2escm",(void*)f_3597},
{"f_3926:posixwin_2escm",(void*)f_3926},
{"f_3590:posixwin_2escm",(void*)f_3590},
{"f_5264:posixwin_2escm",(void*)f_5264},
{"f_4166:posixwin_2escm",(void*)f_4166},
{"f_4168:posixwin_2escm",(void*)f_4168},
{"f_4142:posixwin_2escm",(void*)f_4142},
{"f_3583:posixwin_2escm",(void*)f_3583},
{"f_5613:posixwin_2escm",(void*)f_5613},
{"f_3588:posixwin_2escm",(void*)f_3588},
{"f_5295:posixwin_2escm",(void*)f_5295},
{"f_5292:posixwin_2escm",(void*)f_5292},
{"f_5297:posixwin_2escm",(void*)f_5297},
{"f_4156:posixwin_2escm",(void*)f_4156},
{"f_3533:posixwin_2escm",(void*)f_3533},
{"f_5245:posixwin_2escm",(void*)f_5245},
{"f_3950:posixwin_2escm",(void*)f_3950},
{"f_2875:posixwin_2escm",(void*)f_2875},
{"f_2878:posixwin_2escm",(void*)f_2878},
{"f_3958:posixwin_2escm",(void*)f_3958},
{"f_3953:posixwin_2escm",(void*)f_3953},
{"f_5032:posixwin_2escm",(void*)f_5032},
{"f_5038:posixwin_2escm",(void*)f_5038},
{"f_5035:posixwin_2escm",(void*)f_5035},
{"f_4194:posixwin_2escm",(void*)f_4194},
{"f_2865:posixwin_2escm",(void*)f_2865},
{"f_2869:posixwin_2escm",(void*)f_2869},
{"f_3557:posixwin_2escm",(void*)f_3557},
{"f_3551:posixwin_2escm",(void*)f_3551},
{"f_5020:posixwin_2escm",(void*)f_5020},
{"f_3696:posixwin_2escm",(void*)f_3696},
{"f_5029:posixwin_2escm",(void*)f_5029},
{"f_5026:posixwin_2escm",(void*)f_5026},
{"f_4183:posixwin_2escm",(void*)f_4183},
{"f_3695:posixwin_2escm",(void*)f_3695},
{"f_3689:posixwin_2escm",(void*)f_3689},
{"f_3688:posixwin_2escm",(void*)f_3688},
{"f_2884:posixwin_2escm",(void*)f_2884},
{"f_3680:posixwin_2escm",(void*)f_3680},
{"f_3683:posixwin_2escm",(void*)f_3683},
{"f_4188:posixwin_2escm",(void*)f_4188},
{"f_4186:posixwin_2escm",(void*)f_4186},
{"f_5009:posixwin_2escm",(void*)f_5009},
{"f_5006:posixwin_2escm",(void*)f_5006},
{"f_5003:posixwin_2escm",(void*)f_5003},
{"f_3994:posixwin_2escm",(void*)f_3994},
{"f_3567:posixwin_2escm",(void*)f_3567},
{"f_3561:posixwin_2escm",(void*)f_3561},
{"f_3999:posixwin_2escm",(void*)f_3999},
{"f_5075:posixwin_2escm",(void*)f_5075},
{"f_5062:posixwin_2escm",(void*)f_5062},
{"f_5066:posixwin_2escm",(void*)f_5066},
{"f_5060:posixwin_2escm",(void*)f_5060},
{"f_5050:posixwin_2escm",(void*)f_5050},
{"f_2924:posixwin_2escm",(void*)f_2924},
{"f_2922:posixwin_2escm",(void*)f_2922},
{"f_5097:posixwin_2escm",(void*)f_5097},
{"f_2941:posixwin_2escm",(void*)f_2941},
{"f_5099:posixwin_2escm",(void*)f_5099},
{"f_5084:posixwin_2escm",(void*)f_5084},
{"f_4596:posixwin_2escm",(void*)f_4596},
{"f_2279:posixwin_2escm",(void*)f_2279},
{"f_2277:posixwin_2escm",(void*)f_2277},
{"f_2271:posixwin_2escm",(void*)f_2271},
{"f_2273:posixwin_2escm",(void*)f_2273},
{"f_4561:posixwin_2escm",(void*)f_4561},
{"f_2916:posixwin_2escm",(void*)f_2916},
{"f_2914:posixwin_2escm",(void*)f_2914},
{"f_2902:posixwin_2escm",(void*)f_2902},
{"f_2295:posixwin_2escm",(void*)f_2295},
{"f_3010:posixwin_2escm",(void*)f_3010},
{"f_3895:posixwin_2escm",(void*)f_3895},
{"f_3867:posixwin_2escm",(void*)f_3867},
{"f_3002:posixwin_2escm",(void*)f_3002},
{"f_3019:posixwin_2escm",(void*)f_3019},
{"f_4896:posixwin_2escm",(void*)f_4896},
{"f_4890:posixwin_2escm",(void*)f_4890},
{"f_3008:posixwin_2escm",(void*)f_3008},
{"f_2379:posixwin_2escm",(void*)f_2379},
{"f_2370:posixwin_2escm",(void*)f_2370},
{"f_4501:posixwin_2escm",(void*)f_4501},
{"f_2372:posixwin_2escm",(void*)f_2372},
{"f_5496:posixwin_2escm",(void*)f_5496},
{"f_5490:posixwin_2escm",(void*)f_5490},
{"f_4981:posixwin_2escm",(void*)f_4981},
{"f_2388:posixwin_2escm",(void*)f_2388},
{"f_4874:posixwin_2escm",(void*)f_4874},
{"f_2381:posixwin_2escm",(void*)f_2381},
{"f_4509:posixwin_2escm",(void*)f_4509},
{"f_4870:posixwin_2escm",(void*)f_4870},
{"f_5484:posixwin_2escm",(void*)f_5484},
{"f_4994:posixwin_2escm",(void*)f_4994},
{"f_2397:posixwin_2escm",(void*)f_2397},
{"f_2399:posixwin_2escm",(void*)f_2399},
{"f_2390:posixwin_2escm",(void*)f_2390},
{"f_5472:posixwin_2escm",(void*)f_5472},
{"f_5478:posixwin_2escm",(void*)f_5478},
{"f_2213:posixwin_2escm",(void*)f_2213},
{"f_3704:posixwin_2escm",(void*)f_3704},
{"f_2219:posixwin_2escm",(void*)f_2219},
{"f_5466:posixwin_2escm",(void*)f_5466},
{"f_5460:posixwin_2escm",(void*)f_5460},
{"f_3060:posixwin_2escm",(void*)f_3060},
{"f_2222:posixwin_2escm",(void*)f_2222},
{"f_3711:posixwin_2escm",(void*)f_3711},
{"f_2227:posixwin_2escm",(void*)f_2227},
{"f_3074:posixwin_2escm",(void*)f_3074},
{"f_5454:posixwin_2escm",(void*)f_5454},
{"f_3063:posixwin_2escm",(void*)f_3063},
{"f_3062:posixwin_2escm",(void*)f_3062},
{"f_5448:posixwin_2escm",(void*)f_5448},
{"f_5442:posixwin_2escm",(void*)f_5442},
{"f_5311:posixwin_2escm",(void*)f_5311},
{"f_5316:posixwin_2escm",(void*)f_5316},
{"f_3099:posixwin_2escm",(void*)f_3099},
{"f_3095:posixwin_2escm",(void*)f_3095},
{"f_3097:posixwin_2escm",(void*)f_3097},
{"f_3093:posixwin_2escm",(void*)f_3093},
{"f_4766:posixwin_2escm",(void*)f_4766},
{"f_5436:posixwin_2escm",(void*)f_5436},
{"f_5302:posixwin_2escm",(void*)f_5302},
{"f_5430:posixwin_2escm",(void*)f_5430},
{"f_3089:posixwin_2escm",(void*)f_3089},
{"f_3083:posixwin_2escm",(void*)f_3083},
{"f_3022:posixwin_2escm",(void*)f_3022},
{"f_5412:posixwin_2escm",(void*)f_5412},
{"f_3034:posixwin_2escm",(void*)f_3034},
{"f_5418:posixwin_2escm",(void*)f_5418},
{"f_3028:posixwin_2escm",(void*)f_3028},
{"f_5400:posixwin_2escm",(void*)f_5400},
{"f_5406:posixwin_2escm",(void*)f_5406},
{"f_3040:posixwin_2escm",(void*)f_3040},
{"f_4410:posixwin_2escm",(void*)f_4410},
{"f_4416:posixwin_2escm",(void*)f_4416},
{"f_4419:posixwin_2escm",(void*)f_4419},
{"f_3734:posixwin_2escm",(void*)f_3734},
{"f_3052:posixwin_2escm",(void*)f_3052},
{"f_3046:posixwin_2escm",(void*)f_3046},
{"f_5322:posixwin_2escm",(void*)f_5322},
{"f_5328:posixwin_2escm",(void*)f_5328},
{"f_3244:posixwin_2escm",(void*)f_3244},
{"f_3240:posixwin_2escm",(void*)f_3240},
{"f_5394:posixwin_2escm",(void*)f_5394},
{"f_4930:posixwin_2escm",(void*)f_4930},
{"f_5382:posixwin_2escm",(void*)f_5382},
{"f_5388:posixwin_2escm",(void*)f_5388},
{"f_4926:posixwin_2escm",(void*)f_4926},
{"f_4921:posixwin_2escm",(void*)f_4921},
{"f_3747:posixwin_2escm",(void*)f_3747},
{"f_5424:posixwin_2escm",(void*)f_5424},
{"f_3267:posixwin_2escm",(void*)f_3267},
{"f_3261:posixwin_2escm",(void*)f_3261},
{"f_5376:posixwin_2escm",(void*)f_5376},
{"f_4477:posixwin_2escm",(void*)f_4477},
{"f_5370:posixwin_2escm",(void*)f_5370},
{"f_3755:posixwin_2escm",(void*)f_3755},
{"f_3255:posixwin_2escm",(void*)f_3255},
{"f_3250:posixwin_2escm",(void*)f_3250},
{"f_3725:posixwin_2escm",(void*)f_3725},
{"f_4492:posixwin_2escm",(void*)f_4492},
{"f_5358:posixwin_2escm",(void*)f_5358},
{"f_5352:posixwin_2escm",(void*)f_5352},
{"f_4496:posixwin_2escm",(void*)f_4496},
{"f_2161:posixwin_2escm",(void*)f_2161},
{"f_4498:posixwin_2escm",(void*)f_4498},
{"f_5346:posixwin_2escm",(void*)f_5346},
{"f_2170:posixwin_2escm",(void*)f_2170},
{"f_5340:posixwin_2escm",(void*)f_5340},
{"f_2174:posixwin_2escm",(void*)f_2174},
{"f_4569:posixwin_2escm",(void*)f_4569},
{"f_4434:posixwin_2escm",(void*)f_4434},
{"f_2186:posixwin_2escm",(void*)f_2186},
{"f_5334:posixwin_2escm",(void*)f_5334},
{"f_2183:posixwin_2escm",(void*)f_2183},
{"f_2180:posixwin_2escm",(void*)f_2180},
{"f_4556:posixwin_2escm",(void*)f_4556},
{"f_4464:posixwin_2escm",(void*)f_4464},
{"f_4460:posixwin_2escm",(void*)f_4460},
{"f_4466:posixwin_2escm",(void*)f_4466},
{"f_2190:posixwin_2escm",(void*)f_2190},
{"f_2234:posixwin_2escm",(void*)f_2234},
{"f_5129:posixwin_2escm",(void*)f_5129},
{"f_4216:posixwin_2escm",(void*)f_4216},
{"f_2249:posixwin_2escm",(void*)f_2249},
{"f_2247:posixwin_2escm",(void*)f_2247},
{"f_4484:posixwin_2escm",(void*)f_4484},
{"f_3427:posixwin_2escm",(void*)f_3427},
{"f_4200:posixwin_2escm",(void*)f_4200},
{"f_4209:posixwin_2escm",(void*)f_4209},
{"f_2259:posixwin_2escm",(void*)f_2259},
{"f_2255:posixwin_2escm",(void*)f_2255},
{"f_5109:posixwin_2escm",(void*)f_5109},
{"f_2253:posixwin_2escm",(void*)f_2253},
{"f_5104:posixwin_2escm",(void*)f_5104},
{"f_4653:posixwin_2escm",(void*)f_4653},
{"f_2149:posixwin_2escm",(void*)f_2149},
{"f_4912:posixwin_2escm",(void*)f_4912},
{"f_4915:posixwin_2escm",(void*)f_4915},
{"f_2265:posixwin_2escm",(void*)f_2265},
{"f_2267:posixwin_2escm",(void*)f_2267},
{"f_2261:posixwin_2escm",(void*)f_2261},
{"f_5133:posixwin_2escm",(void*)f_5133},
{"f_5135:posixwin_2escm",(void*)f_5135},
{"f_4645:posixwin_2escm",(void*)f_4645},
{"f_2157:posixwin_2escm",(void*)f_2157},
{"f_2754:posixwin_2escm",(void*)f_2754},
{"f_2159:posixwin_2escm",(void*)f_2159},
{"f_5364:posixwin_2escm",(void*)f_5364},
{"f_4900:posixwin_2escm",(void*)f_4900},
{"f_2151:posixwin_2escm",(void*)f_2151},
{"f_2153:posixwin_2escm",(void*)f_2153},
{"f_2155:posixwin_2escm",(void*)f_2155},
{"f_4635:posixwin_2escm",(void*)f_4635},
{"f_2704:posixwin_2escm",(void*)f_2704},
{"f_2706:posixwin_2escm",(void*)f_2706},
{"f_2708:posixwin_2escm",(void*)f_2708},
{"f_4622:posixwin_2escm",(void*)f_4622},
{"f_4442:posixwin_2escm",(void*)f_4442},
{"f_4627:posixwin_2escm",(void*)f_4627},
{"f_4447:posixwin_2escm",(void*)f_4447},
{"f_4619:posixwin_2escm",(void*)f_4619},
{"f_2725:posixwin_2escm",(void*)f_2725},
{"f_4273:posixwin_2escm",(void*)f_4273},
{"f_4275:posixwin_2escm",(void*)f_4275},
{"f_3676:posixwin_2escm",(void*)f_3676},
{"f_3677:posixwin_2escm",(void*)f_3677},
{"f_3471:posixwin_2escm",(void*)f_3471},
{"f_3674:posixwin_2escm",(void*)f_3674},
{"f_3485:posixwin_2escm",(void*)f_3485},
{"f_3487:posixwin_2escm",(void*)f_3487},
{"f_3489:posixwin_2escm",(void*)f_3489},
{"f_3665:posixwin_2escm",(void*)f_3665},
{"f_3663:posixwin_2escm",(void*)f_3663},
{"f_2745:posixwin_2escm",(void*)f_2745},
{"f_4292:posixwin_2escm",(void*)f_4292},
{"f_3477:posixwin_2escm",(void*)f_3477},
{"f_2735:posixwin_2escm",(void*)f_2735},
{"f_2363:posixwin_2escm",(void*)f_2363},
{"f_2739:posixwin_2escm",(void*)f_2739},
{"f_3440:posixwin_2escm",(void*)f_3440},
{"f_4286:posixwin_2escm",(void*)f_4286},
{"f_4288:posixwin_2escm",(void*)f_4288},
{"f_3497:posixwin_2escm",(void*)f_3497},
{"f_2962:posixwin_2escm",(void*)f_2962},
{"f_2965:posixwin_2escm",(void*)f_2965},
{"f_3447:posixwin_2escm",(void*)f_3447},
{"f_3442:posixwin_2escm",(void*)f_3442},
{"f_2503:posixwin_2escm",(void*)f_2503},
{"f_2505:posixwin_2escm",(void*)f_2505},
{"f_2509:posixwin_2escm",(void*)f_2509},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		3
o|eliminated procedure checks: 141 
o|specializations:
o|  1 (##sys#check-list (or pair list) *)
o|  4 (##sys#foreign-fixnum-argument fixnum)
o|  1 (negative? fixnum)
o|  4 (cdr pair)
o|  1 (string-ref string fixnum)
o|  3 (make-string fixnum)
o|  9 (eqv? * (not float))
o|  9 (car pair)
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error c1414) 
o|Removed `not' forms: 6 
o|inlining procedure: k2191 
o|inlining procedure: k2191 
o|inlining procedure: k2206 
o|inlining procedure: k2206 
o|inlining procedure: k2290 
o|inlining procedure: k2302 
o|inlining procedure: k2302 
o|inlining procedure: k2314 
o|inlining procedure: k2314 
o|inlining procedure: k2326 
o|inlining procedure: k2326 
o|inlining procedure: k2290 
o|inlining procedure: k2435 
o|contracted procedure: k2450 
o|inlining procedure: k2447 
o|inlining procedure: k2447 
o|substituted constant variable: a2460 
o|inlining procedure: k2435 
o|inlining procedure: k2468 
o|inlining procedure: k2468 
o|inlining procedure: k2510 
o|inlining procedure: k2510 
o|inlining procedure: k2528 
o|inlining procedure: k2528 
o|inlining procedure: k2556 
o|inlining procedure: k2556 
o|inlining procedure: k2578 
o|inlining procedure: k2578 
o|substituted constant variable: a2597 
o|inlining procedure: k2617 
o|inlining procedure: k2617 
o|inlining procedure: k2638 
o|propagated global variable: g2752765733 delete-file 
o|inlining procedure: k2638 
o|inlining procedure: k2631 
o|inlining procedure: k2664 
o|inlining procedure: k2664 
o|inlining procedure: k2631 
o|inlining procedure: k2712 
o|inlining procedure: k2712 
o|inlining procedure: k2728 
o|inlining procedure: k2728 
o|inlining procedure: k2760 
o|inlining procedure: k2760 
o|substituted constant variable: a2781 
o|substituted constant variable: a2785 
o|inlining procedure: k2823 
o|inlining procedure: k2823 
o|inlining procedure: k2853 
o|inlining procedure: k2853 
o|inlining procedure: k2897 
o|inlining procedure: k2897 
o|inlining procedure: k2904 
o|inlining procedure: k2904 
o|contracted procedure: "(posix-common.scm:431) find-files" 
o|inlining procedure: k2927 
o|inlining procedure: k2927 
o|inlining procedure: k2942 
o|inlining procedure: k2942 
o|inlining procedure: k2961 
o|inlining procedure: k2961 
o|inlining procedure: k2969 
o|inlining procedure: k2998 
o|inlining procedure: k2998 
o|inlining procedure: k2969 
o|inlining procedure: k3018 
o|inlining procedure: k3018 
o|inlining procedure: k3035 
o|inlining procedure: k3035 
o|inlining procedure: k3054 
o|inlining procedure: k3054 
o|contracted procedure: k3071 
o|inlining procedure: k3077 
o|inlining procedure: k3077 
o|inlining procedure: k3141 
o|inlining procedure: k3141 
o|inlining procedure: k3215 
o|inlining procedure: k3215 
o|inlining procedure: k3245 
o|inlining procedure: k3245 
o|inlining procedure: k3275 
o|inlining procedure: k3275 
o|inlining procedure: k3364 
o|inlining procedure: k3364 
o|inlining procedure: k3441 
o|inlining procedure: k3441 
o|inlining procedure: k3464 
o|inlining procedure: k3464 
o|inlining procedure: k3488 
o|inlining procedure: k3488 
o|inlining procedure: k3527 
o|inlining procedure: k3527 
o|inlining procedure: k3622 
o|inlining procedure: k3622 
o|inlining procedure: k3634 
o|inlining procedure: k3634 
o|inlining procedure: k3643 
o|inlining procedure: k3643 
o|inlining procedure: k3691 
o|inlining procedure: k3698 
o|inlining procedure: k3698 
o|inlining procedure: k3691 
o|inlining procedure: k3728 
o|inlining procedure: k3728 
o|inlining procedure: k3675 
o|inlining procedure: k3749 
o|inlining procedure: k3749 
o|inlining procedure: k3675 
o|inlining procedure: k3780 
o|inlining procedure: k3780 
o|inlining procedure: k3798 
o|inlining procedure: k3798 
o|inlining procedure: k3818 
o|inlining procedure: k3818 
o|inlining procedure: k3841 
o|inlining procedure: k3841 
o|inlining procedure: "(posixwin.scm:1141) badmode763" 
o|substituted constant variable: a3863 
o|substituted constant variable: a3865 
o|inlining procedure: k3878 
o|inlining procedure: k3878 
o|inlining procedure: "(posixwin.scm:1151) badmode763" 
o|substituted constant variable: a3900 
o|substituted constant variable: a3902 
o|inlining procedure: k3911 
o|inlining procedure: k3911 
o|inlining procedure: k3927 
o|inlining procedure: k3927 
o|inlining procedure: k4050 
o|inlining procedure: k4050 
o|inlining procedure: k4149 
o|inlining procedure: k4149 
o|inlining procedure: k4175 
o|inlining procedure: k4175 
o|inlining procedure: k4215 
o|contracted procedure: k4230 
o|inlining procedure: k4227 
o|inlining procedure: k4227 
o|substituted constant variable: a4240 
o|inlining procedure: k4215 
o|inlining procedure: k4250 
o|inlining procedure: k4250 
o|inlining procedure: k4293 
o|inlining procedure: k4293 
o|inlining procedure: k4326 
o|inlining procedure: k4326 
o|inlining procedure: k4387 
o|inlining procedure: k4397 
o|inlining procedure: k4397 
o|inlining procedure: k4387 
o|inlining procedure: k4453 
o|inlining procedure: k4453 
o|inlining procedure: k4467 
o|inlining procedure: k4467 
o|inlining procedure: k4480 
o|inlining procedure: k4480 
o|inlining procedure: k4504 
o|inlining procedure: k4504 
o|inlining procedure: k4514 
o|inlining procedure: k4514 
o|inlining procedure: k4525 
o|inlining procedure: k4525 
o|substituted constant variable: a4541 
o|substituted constant variable: a4543 
o|substituted constant variable: a4545 
o|inlining procedure: k4559 
o|inlining procedure: k4572 
o|inlining procedure: k4572 
o|inlining procedure: k4559 
o|inlining procedure: k4599 
o|inlining procedure: k4599 
o|inlining procedure: k4618 
o|inlining procedure: k4618 
o|inlining procedure: k4665 
o|inlining procedure: k4676 
o|inlining procedure: k4676 
o|inlining procedure: k4665 
o|inlining procedure: k4726 
o|inlining procedure: k4726 
o|inlining procedure: k4740 
o|inlining procedure: k4740 
o|inlining procedure: k4771 
o|inlining procedure: k4771 
o|inlining procedure: k4831 
o|inlining procedure: k4831 
o|inlining procedure: k4875 
o|inlining procedure: k4875 
o|inlining procedure: k4901 
o|inlining procedure: k4901 
o|substituted constant variable: g124112421249 
o|substituted constant variable: g124112421249 
o|substituted constant variable: g124112421249 
o|substituted constant variable: g124312441250 
o|substituted constant variable: g124312441250 
o|substituted constant variable: g124312441250 
o|substituted constant variable: g124512461251 
o|substituted constant variable: g124512461251 
o|substituted constant variable: g124512461251 
o|substituted constant variable: g124712481252 
o|substituted constant variable: g124712481252 
o|substituted constant variable: g124712481252 
o|inlining procedure: k4995 
o|inlining procedure: k5008 
o|inlining procedure: k5008 
o|inlining procedure: k4995 
o|inlining procedure: k5046 
o|inlining procedure: k5046 
o|inlining procedure: k5078 
o|inlining procedure: k5078 
o|inlining procedure: k5111 
o|inlining procedure: k5111 
o|inlining procedure: k5248 
o|inlining procedure: k5248 
o|inlining procedure: k5267 
o|inlining procedure: k5267 
o|inlining procedure: k5279 
o|inlining procedure: k5279 
o|inlining procedure: k5305 
o|inlining procedure: k5305 
o|inlining procedure: k5603 
o|inlining procedure: k5603 
o|inlining procedure: k5614 
o|inlining procedure: k5614 
o|inlining procedure: k5623 
o|inlining procedure: k5623 
o|inlining procedure: k5651 
o|inlining procedure: k5651 
o|inlining procedure: k5681 
o|inlining procedure: k5681 
o|inlining procedure: k5693 
o|inlining procedure: k5693 
o|replaced variables: 516 
o|removed binding forms: 307 
o|substituted constant variable: r21925706 
o|substituted constant variable: r23035710 
o|substituted constant variable: r23155712 
o|substituted constant variable: r23275714 
o|substituted constant variable: r22915716 
o|inlining procedure: k2435 
o|substituted constant variable: r24485719 
o|inlining procedure: k2435 
o|inlining procedure: k2435 
o|inlining procedure: k2638 
o|inlining procedure: k2638 
o|propagated global variable: g2752765950 delete-file 
o|converted assignments to bindings: (rmdir257) 
o|substituted constant variable: r27295747 
o|substituted constant variable: f_28225751 
o|substituted constant variable: r28985757 
o|substituted constant variable: r28985757 
o|substituted constant variable: r29055761 
o|substituted constant variable: r29055761 
o|substituted constant variable: a30535777 
o|substituted constant variable: a30535778 
o|substituted constant variable: loc371 
o|substituted constant variable: r36355808 
o|substituted constant variable: f_37975824 
o|removed side-effect free assignment to unused variable: badmode763 
o|inlining procedure: k3841 
o|inlining procedure: k3878 
o|inlining procedure: k4215 
o|substituted constant variable: r42285863 
o|inlining procedure: k4215 
o|inlining procedure: k4215 
o|inlining procedure: k4299 
o|substituted constant variable: r43885874 
o|substituted constant variable: a44525876 
o|substituted constant variable: r44685877 
o|substituted constant variable: a45135884 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: f_45715888 
o|substituted constant variable: a47255900 
o|substituted constant variable: a50075913 
o|substituted constant variable: a50455915 
o|substituted constant variable: a50455916 
o|converted assignments to bindings: (check940) 
o|substituted constant variable: r56155932 
o|substituted constant variable: r56825939 
o|substituted constant variable: r56825939 
o|simplifications: ((let . 2)) 
o|replaced variables: 17 
o|removed binding forms: 509 
o|substituted constant variable: a24345943 
o|substituted constant variable: a24345944 
o|substituted constant variable: a24345945 
o|inlining procedure: k2763 
o|inlining procedure: k3321 
o|inlining procedure: k3321 
o|inlining procedure: k3501 
o|inlining procedure: k3501 
o|inlining procedure: k3544 
o|inlining procedure: k3544 
o|substituted constant variable: a42145977 
o|substituted constant variable: a42145978 
o|substituted constant variable: a42145979 
o|inlining procedure: k5148 
o|inlining procedure: k5203 
o|replaced variables: 2 
o|removed binding forms: 55 
o|substituted constant variable: tmp3193216009 
o|substituted constant variable: tmp3193216009 
o|substituted constant variable: a33206020 
o|substituted constant variable: r35026023 
o|substituted constant variable: r35456025 
o|simplifications: ((let . 2)) 
o|removed binding forms: 13 
o|removed conditional forms: 3 
o|removed binding forms: 4 
o|simplifications: ((if . 55) (##core#call . 360)) 
o|  call simplifications:
o|    bitwise-ior
o|    <
o|    +	2
o|    ##sys#foreign-pointer-argument	5
o|    ##sys#foreign-string-argument	5
o|    char-whitespace?
o|    char=?
o|    fxior	2
o|    string-length	2
o|    list	5
o|    values	11
o|    ##sys#fudge
o|    vector-set!	2
o|    fx-	3
o|    ##sys#foreign-integer-argument
o|    ##sys#check-number	4
o|    ##sys#check-vector
o|    ##sys#size	7
o|    member
o|    fx+	6
o|    ##sys#call-with-values	7
o|    string-ref	2
o|    fx>
o|    not	4
o|    cons	8
o|    ##sys#check-string	21
o|    ##sys#check-list	4
o|    fx=	8
o|    zero?	2
o|    ##sys#slot	15
o|    ##sys#check-exact	24
o|    ##sys#null-pointer?	5
o|    pair?	13
o|    eq?	30
o|    cdr	20
o|    ##sys#eqv?	7
o|    null?	54
o|    car	36
o|    vector
o|    fixnum?	4
o|    string?	2
o|    fx<	12
o|    apply	9
o|    ##sys#foreign-fixnum-argument	9
o|contracted procedure: k2168 
o|contracted procedure: k2194 
o|contracted procedure: k2203 
o|contracted procedure: k2209 
o|contracted procedure: k2238 
o|contracted procedure: k2230 
o|contracted procedure: k2356 
o|contracted procedure: k2282 
o|contracted procedure: k2350 
o|contracted procedure: k2284 
o|contracted procedure: k2344 
o|contracted procedure: k2286 
o|contracted procedure: k2338 
o|contracted procedure: k2288 
o|contracted procedure: k2299 
o|contracted procedure: k2305 
o|contracted procedure: k2311 
o|contracted procedure: k2317 
o|contracted procedure: k2323 
o|contracted procedure: k2329 
o|contracted procedure: k2335 
o|contracted procedure: k2437 
o|contracted procedure: k2444 
o|contracted procedure: k2470 
o|contracted procedure: k2482 
o|contracted procedure: k2495 
o|contracted procedure: k2546 
o|contracted procedure: k2513 
o|contracted procedure: k2525 
o|contracted procedure: k2530 
o|contracted procedure: k2552 
o|contracted procedure: k2558 
o|contracted procedure: k2564 
o|contracted procedure: k2567 
o|contracted procedure: k2569 
o|contracted procedure: k2598 
o|contracted procedure: k2575 
o|contracted procedure: k2683 
o|contracted procedure: k2608 
o|contracted procedure: k2620 
o|contracted procedure: k2627 
o|contracted procedure: k2652 
o|contracted procedure: k2666 
o|contracted procedure: k2675 
o|contracted procedure: k2678 
o|contracted procedure: k2798 
o|contracted procedure: k2695 
o|contracted procedure: k2792 
o|contracted procedure: k2697 
o|contracted procedure: k2786 
o|contracted procedure: k2699 
o|contracted procedure: k2701 
o|contracted procedure: k2715 
o|contracted procedure: k2731 
o|contracted procedure: k2736 
o|contracted procedure: k2755 
o|contracted procedure: k2758 
o|contracted procedure: k2771 
o|contracted procedure: k2763 
o|contracted procedure: k2777 
o|contracted procedure: k2804 
o|contracted procedure: k2825 
o|contracted procedure: k2828 
o|contracted procedure: k2855 
o|contracted procedure: k2862 
o|contracted procedure: k2880 
o|contracted procedure: k2894 
o|contracted procedure: k2911 
o|contracted procedure: k2929 
o|contracted procedure: k2932 
o|contracted procedure: k2934 
o|contracted procedure: k2945 
o|contracted procedure: k2954 
o|contracted procedure: k2979 
o|contracted procedure: k3056 
o|contracted procedure: k3080 
o|contracted procedure: k3139 
o|contracted procedure: k3151 
o|contracted procedure: k3144 
o|contracted procedure: k3160 
o|contracted procedure: k3165 
o|contracted procedure: k3181 
o|contracted procedure: k3186 
o|contracted procedure: k3203 
o|contracted procedure: k3211 
o|contracted procedure: k3225 
o|contracted procedure: k3222 
o|contracted procedure: k3230 
o|contracted procedure: k3308 
o|contracted procedure: k3270 
o|contracted procedure: k3278 
o|contracted procedure: k3303 
o|contracted procedure: k3300 
o|contracted procedure: k3318 
o|contracted procedure: k3393 
o|contracted procedure: k3340 
o|contracted procedure: k3387 
o|contracted procedure: k3342 
o|contracted procedure: k3381 
o|contracted procedure: k3344 
o|contracted procedure: k3375 
o|contracted procedure: k3346 
o|contracted procedure: k3348 
o|contracted procedure: k3351 
o|contracted procedure: k3366 
o|contracted procedure: k5633 
o|contracted procedure: k3425 
o|contracted procedure: k3432 
o|contracted procedure: k3434 
o|contracted procedure: k3436 
o|contracted procedure: k3443 
o|contracted procedure: k3454 
o|contracted procedure: k3462 
o|contracted procedure: k3467 
o|contracted procedure: k3480 
o|contracted procedure: k3482 
o|contracted procedure: k3493 
o|contracted procedure: k3507 
o|contracted procedure: k3519 
o|contracted procedure: k3525 
o|contracted procedure: k3529 
o|contracted procedure: k3537 
o|contracted procedure: k3554 
o|contracted procedure: k3558 
o|contracted procedure: k3569 
o|contracted procedure: k3571 
o|contracted procedure: k3586 
o|contracted procedure: k3592 
o|contracted procedure: k3616 
o|contracted procedure: k3618 
o|contracted procedure: k3641 
o|contracted procedure: k3637 
o|contracted procedure: k3646 
o|contracted procedure: k3656 
o|contracted procedure: k3766 
o|contracted procedure: k3668 
o|contracted procedure: k3671 
o|contracted procedure: k3681 
o|contracted procedure: k3700 
o|contracted procedure: k3719 
o|contracted procedure: k3730 
o|contracted procedure: k3739 
o|contracted procedure: k3742 
o|contracted procedure: k3751 
o|contracted procedure: k3776 
o|contracted procedure: k3782 
o|contracted procedure: k3800 
o|contracted procedure: k3821 
o|contracted procedure: k3833 
o|contracted procedure: k3844 
o|contracted procedure: k3853 
o|contracted procedure: k3870 
o|contracted procedure: k3881 
o|contracted procedure: k3890 
o|contracted procedure: k3913 
o|contracted procedure: k3929 
o|contracted procedure: k4064 
o|contracted procedure: k4047 
o|contracted procedure: k4055 
o|contracted procedure: k4100 
o|contracted procedure: k4145 
o|contracted procedure: k4147 
o|contracted procedure: k4152 
o|contracted procedure: k4171 
o|contracted procedure: k4173 
o|contracted procedure: k4217 
o|contracted procedure: k4224 
o|contracted procedure: k4253 
o|contracted procedure: k4265 
o|contracted procedure: k4278 
o|contracted procedure: k4296 
o|contracted procedure: k4301 
o|contracted procedure: k4322 
o|contracted procedure: k4328 
o|contracted procedure: k4336 
o|contracted procedure: k4339 
o|contracted procedure: k4341 
o|contracted procedure: k4347 
o|contracted procedure: k4349 
o|contracted procedure: k4361 
o|contracted procedure: k4374 
o|contracted procedure: k4399 
o|contracted procedure: k4406 
o|contracted procedure: k4412 
o|contracted procedure: k4421 
o|contracted procedure: k4424 
o|contracted procedure: k4430 
o|contracted procedure: k4445 
o|contracted procedure: k4455 
o|contracted procedure: k4470 
o|contracted procedure: k4502 
o|contracted procedure: k4520 
o|contracted procedure: k4516 
o|contracted procedure: k4522 
o|contracted procedure: k4528 
o|contracted procedure: k4534 
o|contracted procedure: k4546 
o|contracted procedure: k4563 
o|contracted procedure: k4574 
o|contracted procedure: k4590 
o|contracted procedure: k4580 
o|contracted procedure: k4587 
o|contracted procedure: k4601 
o|contracted procedure: k4607 
o|inlining procedure: k4615 
o|inlining procedure: k4615 
o|contracted procedure: k4630 
o|contracted procedure: k4637 
o|contracted procedure: k4643 
o|contracted procedure: k4648 
o|contracted procedure: k4655 
o|contracted procedure: k4661 
o|contracted procedure: k4667 
o|contracted procedure: k4678 
o|contracted procedure: k4684 
o|contracted procedure: k4686 
o|contracted procedure: k4697 
o|contracted procedure: k4700 
o|contracted procedure: k4708 
o|contracted procedure: k4732 
o|contracted procedure: k4743 
o|contracted procedure: k4803 
o|contracted procedure: k4753 
o|contracted procedure: k4797 
o|contracted procedure: k4755 
o|contracted procedure: k4791 
o|contracted procedure: k4757 
o|contracted procedure: k4785 
o|contracted procedure: k4759 
o|contracted procedure: k4779 
o|contracted procedure: k4761 
o|contracted procedure: k4773 
o|contracted procedure: k4763 
o|contracted procedure: k4863 
o|contracted procedure: k4813 
o|contracted procedure: k4857 
o|contracted procedure: k4815 
o|contracted procedure: k4851 
o|contracted procedure: k4817 
o|contracted procedure: k4845 
o|contracted procedure: k4819 
o|contracted procedure: k4839 
o|contracted procedure: k4821 
o|contracted procedure: k4833 
o|contracted procedure: k4823 
o|contracted procedure: k4916 
o|contracted procedure: k4932 
o|contracted procedure: k4936 
o|contracted procedure: k4940 
o|contracted procedure: k4944 
o|contracted procedure: k4948 
o|contracted procedure: k4952 
o|contracted procedure: k4973 
o|contracted procedure: k4979 
o|contracted procedure: k5054 
o|contracted procedure: k4984 
o|contracted procedure: k5040 
o|contracted procedure: k5043 
o|contracted procedure: k5052 
o|contracted procedure: k5064 
o|contracted procedure: k5080 
o|contracted procedure: k5089 
o|contracted procedure: k5092 
o|contracted procedure: k5094 
o|contracted procedure: k5183 
o|contracted procedure: k5138 
o|contracted procedure: k5177 
o|contracted procedure: k5140 
o|contracted procedure: k5171 
o|contracted procedure: k5142 
o|contracted procedure: k5165 
o|contracted procedure: k5144 
o|contracted procedure: k5159 
o|contracted procedure: k5146 
o|contracted procedure: k5153 
o|contracted procedure: k5148 
o|contracted procedure: k5238 
o|contracted procedure: k5193 
o|contracted procedure: k5232 
o|contracted procedure: k5195 
o|contracted procedure: k5226 
o|contracted procedure: k5197 
o|contracted procedure: k5220 
o|contracted procedure: k5199 
o|contracted procedure: k5214 
o|contracted procedure: k5201 
o|contracted procedure: k5208 
o|contracted procedure: k5203 
o|contracted procedure: k5261 
o|contracted procedure: k5605 
o|contracted procedure: k5621 
o|contracted procedure: k5617 
o|contracted procedure: k5626 
o|contracted procedure: k5638 
o|contracted procedure: k5657 
o|contracted procedure: k5646 
o|contracted procedure: k5649 
o|contracted procedure: k5666 
o|contracted procedure: k5676 
o|contracted procedure: k5688 
o|contracted procedure: k5696 
o|simplifications: ((if . 1) (let . 58)) 
o|removed binding forms: 299 
o|inlining procedure: k3157 
o|inlining procedure: k3178 
o|inlining procedure: "(posixwin.scm:1135) mode762" 
o|inlining procedure: "(posixwin.scm:1145) mode762" 
o|inlining procedure: k4633 
o|inlining procedure: k4651 
o|replaced variables: 10 
o|removed binding forms: 1 
o|removed side-effect free assignment to unused variable: mode762 
o|substituted constant variable: r46346195 
o|substituted constant variable: r46526197 
o|replaced variables: 6 
o|removed binding forms: 6 
o|converted assignments to bindings: (check764) 
o|simplifications: ((let . 1)) 
o|removed binding forms: 8 
o|contracted procedure: k3835 
o|contracted procedure: k3872 
o|removed binding forms: 2 
o|replaced variables: 6 
o|removed binding forms: 4 
o|direct leaf routine/allocation: loop1066 0 
o|converted assignments to bindings: (loop1066) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (for-each-loop12951313 k4899 $exec-setup $exec-teardown $quote-args-list doloop11051106 loop1072 k4497 k4507 scan1020 loop1017 k4324 mode956 check957 check940 check764 for-each-loop726745 k3614 k3523 k3430 check-time-vector k2913 k2915 loop385 loop348 conc-loop329 k2738 k2743 loop308 for-each-loop264280 rmdir257 k2554 mode180 check181 ##sys#stat) 
o|calls to known targets: 135 
o|unused rest argument: _378 f_3083 
o|unused rest argument: _377 f_3074 
o|unused rest argument: _418 f_3129 
o|identified direct recursive calls: f_4394 1 
o|identified direct recursive calls: f_4569 1 
o|unused rest argument: _14091413 f_5316 
o|unused rest argument: _14161420 f_5322 
o|unused rest argument: _14221426 f_5328 
o|unused rest argument: _14281432 f_5334 
o|unused rest argument: _14341438 f_5340 
o|unused rest argument: _14401444 f_5346 
o|unused rest argument: _14461450 f_5352 
o|unused rest argument: _14521456 f_5358 
o|unused rest argument: _14581462 f_5364 
o|unused rest argument: _14641468 f_5370 
o|unused rest argument: _14701474 f_5376 
o|unused rest argument: _14761480 f_5382 
o|unused rest argument: _14821486 f_5388 
o|unused rest argument: _14881492 f_5394 
o|unused rest argument: _14941498 f_5400 
o|unused rest argument: _15001504 f_5406 
o|unused rest argument: _15061510 f_5412 
o|unused rest argument: _15121516 f_5418 
o|unused rest argument: _15181522 f_5424 
o|unused rest argument: _15241528 f_5430 
o|unused rest argument: _15301534 f_5436 
o|unused rest argument: _15361540 f_5442 
o|unused rest argument: _15421546 f_5448 
o|unused rest argument: _15481552 f_5454 
o|unused rest argument: _15541558 f_5460 
o|unused rest argument: _15601564 f_5466 
o|unused rest argument: _15661570 f_5472 
o|unused rest argument: _15721576 f_5478 
o|unused rest argument: _15781582 f_5484 
o|unused rest argument: _15841588 f_5490 
o|unused rest argument: _15901594 f_5496 
o|unused rest argument: _15961600 f_5502 
o|unused rest argument: _16021606 f_5508 
o|unused rest argument: _16081612 f_5514 
o|unused rest argument: _16141618 f_5520 
o|unused rest argument: _16201624 f_5526 
o|unused rest argument: _16261630 f_5532 
o|unused rest argument: _16321636 f_5538 
o|unused rest argument: _16381642 f_5544 
o|unused rest argument: _16441648 f_5550 
o|unused rest argument: _16501654 f_5556 
o|unused rest argument: _16561660 f_5562 
o|unused rest argument: _16621666 f_5568 
o|fast box initializations: 15 
o|fast global references: 73 
o|fast global assignments: 7 
o|dropping unused closure argument: f_4245 
o|dropping unused closure argument: f_2612 
o|dropping unused closure argument: f_3813 
o|dropping unused closure argument: f_3136 
o|dropping unused closure argument: f_2429 
o|dropping unused closure argument: f_4735 
o|dropping unused closure argument: f_2465 
o|dropping unused closure argument: f_4168 
o|dropping unused closure argument: f_2186 
o|dropping unused closure argument: f_4556 
o|dropping unused closure argument: f_4209 
*/
/* end of file */
