/*
 * Miscellaneous functions for cHg
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "misc.h"
#include "util.h"

/*!
 * Start pager according to command-line options
 *
 * This implementation is based on hgext/pager.py (pre 369741ef7253)
 */
void setuppager(hgclient_t *hgc, const char * const args[], size_t argsize)
{
    const char *pagercmd = hgc_getpager(hgc, args, argsize);
    if (!pagercmd) return;

    int pipefds[2];
    if (pipe(pipefds) < 0) return;
    pid_t pid = fork();
    if (pid < 0) goto error;
    if (pid == 0) {
        close(pipefds[0]);
        if (dup2(pipefds[1], fileno(stdout)) < 0) goto error;
        if (isatty(fileno(stderr))) {
            if (dup2(pipefds[1], fileno(stderr)) < 0) goto error;
        }
        close(pipefds[1]);
        return;
    } else {
        dup2(pipefds[0], fileno(stdin));
        close(pipefds[0]);
        close(pipefds[1]);

        int r = execlp("/bin/sh", "/bin/sh", "-c", pagercmd, NULL);
        if (r < 0) {
            abortmsg("cannot start pager '%s' (errno = %d)", pagercmd, errno);
        }
        return;
    }

error:
    close(pipefds[0]);
    close(pipefds[1]);
    abortmsg("failed to prepare pager (errno = %d)", errno);
}
