/******************************************************************************
**
** Copyright (C) 2009-2012 Kyle Lutz <kyle.r.lutz@gmail.com>
** All rights reserved.
**
** This file is a part of the chemkit project. For more information
** see <http://www.chemkit.org>.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
**
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in the
**     documentation and/or other materials provided with the distribution.
**   * Neither the name of the chemkit project nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
******************************************************************************/

#ifndef SURFACEVIEWERDEMO_H
#define SURFACEVIEWERDEMO_H

#include <QtGui>

#include <chemkit/molecule.h>
#include <chemkit/graphicsmoleculeitem.h>
#include <chemkit/graphicsmolecularsurfaceitem.h>

namespace Ui {
    class SurfaceViewerDemo;
}

class SurfaceViewerDemo : public QMainWindow
{
    Q_OBJECT

public:
    // construction and destruction
    SurfaceViewerDemo(QWidget *parent = 0);
    ~SurfaceViewerDemo();

    // properties
    void setMolecule(const boost::shared_ptr<chemkit::Molecule> &molecule);
    boost::shared_ptr<chemkit::Molecule> molecule() const;

public slots:
    void openFile();
    void openFile(const QString &fileName);
    void closeFile();
    void quit();
    void surfaceTypeChanged(int index);
    void colorModeChanged(int index);
    void opacitySliderChanged(int value);
    void probeRadiusChanged(double radius);

private:
    Ui::SurfaceViewerDemo *ui;
    boost::shared_ptr<chemkit::Molecule> m_molecule;
    chemkit::GraphicsMoleculeItem *m_moleculeItem;
    chemkit::GraphicsMolecularSurfaceItem *m_molecularSurfaceItem;
};

#endif // SURFACEVIEWERDEMO_H
