/*
 * Copyright 2004-2016 Cray Inc.
 * Other additional copyright holders may be indicated within.
 *
 * The entirety of this work is licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _IPE_SEQUENCE_H_
#define _IPE_SEQUENCE_H_

#include "stmt.h"

#include <vector>

class Expr;

class IpeSequence : public BlockStmt
{
public:
                           IpeSequence(const std::vector<Expr*>& stmts);

                           IpeSequence(const std::vector<Expr*>& stmts,
                                       BlockTag                  tag);

  virtual                 ~IpeSequence();

  virtual bool             isScopeless()                             const;

  virtual void             describe(int offset);

protected:
                           IpeSequence(BlockTag tag);

private:
                           IpeSequence();

};

#endif
