      PROGRAM TEST

!
!     SAMPLE ADF TEST PROGRAM TO BUILD FILES ILLUSTRATED
!     IN THE EXAMPLE DATABASE FIGURE
!
      USE CGNS
      IMPLICIT NONE
!
      INTEGER MAXCHR
      PARAMETER (MAXCHR=32)
!
      CHARACTER*(MAXCHR) TSTLBL,DTYPE
      CHARACTER*(MAXCHR) FNAM,PATH
!
      REAL*8 RID,PID,CID,TMPID,RIDF2
      REAL A(4,3),B(4,3)
      INTEGER*4 IC(6),ID(6)
      INTEGER IERR,ICGIO,ICGIO2
      INTEGER(CGSIZE_T) :: IDIM(2),IDIMA(2),IDIMC,IDIMD
!
      DATA A /1.1,2.1,3.1,4.1,                                          &
     &      1.2,2.2,3.2,4.2,                                            &
     &      1.3,2.3,3.3,4.3/
      DATA IDIMA /4,3/
!
      DATA IC /1,2,3,4,5,6/
      DATA IDIMC /6/
      INTEGER NUMDIM, I, J
!
      IF (CG_BUILD_64BIT) THEN
        PRINT *,'PROGRAM NOT SET UP FOR 64-BIT'
        STOP
      ENDIF
!
!     SET ERROR FLAG TO ABORT ON ERROR
!
      CALL CGIO_ERROR_ABORT_F(1)
!
! *** 1.) OPEN 1ST DATABASE (ADF_FILE_TWO.ADF)
!     2.) CREATE THREE NODES AT FIRST LEVEL
!     3.) PUT LABEL ON NODE F3
!     4.) PUT DATA IN F3
!     5.) CREATE TWO NODES BELOW F3
!     6.) CLOSE DATABASE
!
      CALL CGIO_OPEN_FILE_F('file_two.cgio',CGIO_MODE_WRITE,            &
     &                      CGIO_FILE_ADF,ICGIO,IERR)
      CALL CGIO_GET_ROOT_ID_F(ICGIO,RID,IERR)
      RIDF2 = RID
      CALL CGIO_CREATE_NODE_F(ICGIO,RID,'F1',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,RID,'F2',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,RID,'F3',PID,IERR)
      CALL CGIO_SET_LABEL_F(ICGIO,PID,'LABEL ON NODE F3',IERR)
      CALL CGIO_SET_DIMENSIONS_F(ICGIO,PID,'R4',2,IDIMA,IERR)
      CALL CGIO_WRITE_ALL_DATA_F(ICGIO,PID,A,IERR)
!
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'F4',CID,IERR)
!
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'F5',CID,IERR)
!
      CALL CGIO_CLOSE_FILE_F(ICGIO,IERR)
!
! *** 1.) OPEN 2ND DATABASE
!     2.) CREATE NODES
!     3.) PUT DATA IN N13
!
      CALL CGIO_OPEN_FILE_F('file_one.cgio',CGIO_MODE_WRITE,            &
     &                      CGIO_FILE_ADF,ICGIO,IERR)
      CALL CGIO_GET_ROOT_ID_F(ICGIO,RID,IERR)
!
!     THREE NODES UNDER ROOT
!
      CALL CGIO_CREATE_NODE_F(ICGIO,RID,'N1',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,RID,'N2',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,RID,'N3',TMPID,IERR)
!
!     THREE NODES UNDER N1 (TWO REGULAR AND ONE LINK)
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'N1',PID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N4',TMPID,IERR)
      CALL CGIO_CREATE_LINK_F(ICGIO,PID,'L3','file_two.cgio','/F3',     &
     &                        TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N5',TMPID,IERR)
!
!     TWO NODES UNDER N4
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,PID,'N4',CID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,CID,'N6',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,CID,'N7',TMPID,IERR)
!
!     ONE NODE UNDER N6
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'/N1/N4/N6',PID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N8',TMPID,IERR)
!
!     THREE NODES UNDER N3
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'N3',PID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N9',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N10',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N11',TMPID,IERR)
!
!     TWO NODES UNDER N9
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,PID,'N9',CID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,CID,'N12',TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,CID,'N13',TMPID,IERR)
!
!     PUT LABEL AND DATA IN N13
!
      CALL CGIO_SET_LABEL_F(ICGIO,TMPID,'LABEL ON NODE N13',IERR)
      CALL CGIO_SET_DIMENSIONS_F(ICGIO,TMPID,'I4',1,IDIMC,IERR)
      CALL CGIO_WRITE_ALL_DATA_F(ICGIO,TMPID,IC,IERR)
!
!     TWO NODES UNDER N10
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'/N3/N10',PID,IERR)
      CALL CGIO_CREATE_LINK_F(ICGIO,PID,'L1',CHAR(0),'/N3/N9/N13',         &
     & TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N14',TMPID,IERR)
!
!     TWO NODES UNDER N11
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'/N3/N11',PID,IERR)
      CALL CGIO_CREATE_LINK_F(ICGIO,PID,'L2','','/N3/N9/N13',         &
     & TMPID,IERR)
      CALL CGIO_CREATE_NODE_F(ICGIO,PID,'N15',TMPID,IERR)
!
! *** READ AND PRINT DATA FROM NODES
!     1.) NODE F5 THROUGH LINK L3
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'/N1/L3',PID,IERR)
      CALL CGIO_GET_LABEL_F(ICGIO,PID,TSTLBL,IERR)
      CALL CGIO_GET_DATA_TYPE_F(ICGIO,PID,DTYPE,IERR)
      CALL CGIO_GET_DIMENSIONS_F(ICGIO,PID,NUMDIM,IDIM,IERR)
      CALL CGIO_READ_ALL_DATA_TYPE_F(ICGIO,PID,DTYPE,B,IERR)
      PRINT *,' NODE F3 THROUGH LINK L3:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA TYPE   = ',DTYPE
      PRINT *,'   NUM OF DIMS = ',NUMDIM
      PRINT *,'   DIM VALS    = ',IDIM
      PRINT *,'   DATA:'
      WRITE(*,100)((B(J,I),I=1,3),J=1,4)
  100 FORMAT(5X,3F10.2)
!
!     2.) N13
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'N3/N9/N13',PID,IERR)
      CALL CGIO_GET_LABEL_F(ICGIO,PID,TSTLBL,IERR)
      CALL CGIO_GET_DATA_TYPE_F(ICGIO,PID,DTYPE,IERR)
      CALL CGIO_GET_DIMENSIONS_F(ICGIO,PID,NUMDIM,IDIMD,IERR)
      CALL CGIO_READ_ALL_DATA_TYPE_F(ICGIO,PID,DTYPE,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA TYPE   = ',DTYPE
      PRINT *,'   NUM OF DIMS = ',NUMDIM
      PRINT *,'   DIM VALS    = ',IDIMD
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
  200 FORMAT(5X,6I6)
!
!     3.) N13 THROUGH L1
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'N3/N10/L1',TMPID,IERR)
      CALL CGIO_GET_LABEL_F(ICGIO,TMPID,TSTLBL,IERR)
      CALL CGIO_READ_ALL_DATA_TYPE_F(ICGIO,TMPID,DTYPE,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13 THROUGH LINK L1:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
!
!     4.) N13 THROUGH L2
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'N3/N11/L2',CID,IERR)
      CALL CGIO_GET_LABEL_F(ICGIO,CID,TSTLBL,IERR)
      CALL CGIO_READ_ALL_DATA_TYPE_F(ICGIO,CID,DTYPE,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13 THROUGH LINK L2:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
!
!     PRINT LIST OF CHILDREN UNDER ROOT NODE
!
      CALL PRTCLD(ICGIO,RID)
!
!     PRINT LIST OF CHILDREN UNDER N3
!
      CALL CGIO_GET_NODE_ID_F(ICGIO,RID,'N3',PID,IERR)
      CALL PRTCLD(ICGIO,PID)
!
!     REOPEN ADF_FILE_TWO AND GET NEW ROOT ID
!
      CALL CGIO_OPEN_FILE_F('file_two.cgio',CGIO_MODE_READ,             &
     &                      CGIO_FILE_ADF,ICGIO2,IERR)
      CALL CGIO_GET_ROOT_ID_F(ICGIO2,RID,IERR)
      PRINT *,' '
      PRINT *,' COMPARISON OF ROOT ID: '
      PRINT *,' file_two.cgio ORIGINAL ROOT ID = ',INT(RIDF2)
      PRINT *,' file_two.cgio NEW ROOT ID      = ',INT(RID)
!
      CALL CGIO_CLOSE_FILE_F(ICGIO,IERR)
      CALL CGIO_CLOSE_FILE_F(ICGIO2,IERR)
!
      STOP
      END
!
! ************* SUBROUTINES ****************
!
      SUBROUTINE PRTCLD(ICGIO,PID)
      USE CGNS
!
! *** PRINT TABLE OF CHILDREN GIVEN A PARENT NODE-ID
!
      PARAMETER (MAXCLD=10)
      PARAMETER (MAXCHR=32)
      REAL*8 PID
      CHARACTER*(MAXCHR) NODNAM,NDNMS(MAXCLD)
      CALL CGIO_GET_NAME_F(ICGIO,PID,NODNAM,IERR)
      CALL CGIO_NUMBER_CHILDREN_F(ICGIO,PID,NUMC,IERR)
      WRITE(*,120)NODNAM,NUMC
  120 FORMAT(/,' PARENT NODE NAME = ',A,/,                              &
     &       '     NUMBER OF CHILDREN = ',I2,/,                         &
     &       '     CHILDREN NAMES:')
      NLEFT = NUMC
      ISTART = 1
!     --- TOP OF DO-WHILE LOOP
  130 CONTINUE
         CALL CGIO_CHILDREN_NAMES_F(ICGIO,PID,ISTART,MAXCLD,MAXCHR,     &
     &                              NUMRET,NDNMS,IERR)
         WRITE(*,140)(NDNMS(K),K=1,NUMRET)
  140    FORMAT(8X,A)
         NLEFT = NLEFT - MAXCLD
         ISTART = ISTART + MAXCLD
      IF (NLEFT .GT. 0) GO TO 130
      RETURN
      END

