#!/usr/bin/env python3
import sys, time, cedar

trie = cedar.trie ()

keys = queries = len (sys.argv) > 1 and sys.argv[1] or "/usr/share/dict/words"

t = time.perf_counter ()
n = 0
for line in open (keys):
    n += 1
    trie[line[:-1]] = n
#    trie.insert (line[:-1], n)
print ("insert %f sec." % (time.perf_counter () - t), file=sys.stderr)

t = time.perf_counter ()
for line in open (queries):
    trie[line[:-1]]
#    trie.lookup (line[:-1])
print ("lookup %f sec." % (time.perf_counter () - t), file=sys.stderr)

t = time.perf_counter ()
for r in trie.prefix ("cedar"):
    print (r.value (), r.key (), file=sys.stderr)
print ("prefix %f sec." % (time.perf_counter () - t), file=sys.stderr)

t = time.perf_counter ()
r = trie.longest_prefix ("cedarwoo")
print (r.value (), r.key (), file=sys.stderr)
print ("longest prefix %f sec." % (time.perf_counter () - t), file=sys.stderr)

t = time.perf_counter ()
for r in trie.predict ("cedar"):
    print (r.value (), r.key (), file=sys.stderr)
print ("predict %f sec." % (time.perf_counter () - t), file=sys.stderr)
