/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.ShortArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public final class ShortVarContainer
extends BaseVarContainer
implements VDataContainer.CShort {
    final short[] spad;

    public ShortVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl, ByteOrder byteOrder) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray, bl, byteOrder, Short.TYPE);
        Object object = this.thisCDF.getPadValue(variable);
        double[] dArray = (double[])object;
        this.spad = new short[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.spad[i] = (short)dArray[i];
        }
    }

    public ShortVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl) throws IllegalAccessException, InvocationTargetException, Throwable {
        this(cDFImpl, variable, nArray, bl, ByteOrder.nativeOrder());
    }

    @Override
    ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * n);
        byteBuffer.order(this.order);
        return byteBuffer;
    }

    @Override
    public Object allocateDataArray(int n) {
        return new short[n];
    }

    @Override
    void doMissing(int n, ByteBuffer byteBuffer, Object object, int n2) {
        int n3;
        short[] sArray = (short[])object;
        short[] sArray2 = null;
        try {
            sArray2 = n2 < 0 ? this.spad : this.var.asShortArray(new int[]{n2});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Should not see this.");
        }
        int n4 = byteBuffer.position();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        for (int i = n; i > 0; i -= n3) {
            n3 = i;
            if (n3 * this.elements > sArray.length) {
                n3 = sArray.length / this.elements;
            }
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.elements; ++k) {
                    sArray[n5++] = sArray2[k];
                }
            }
            shortBuffer.put(sArray, 0, n3 * this.elements);
            n4 += 2 * n3 * this.elements;
        }
        byteBuffer.position(n4);
    }

    @Override
    void doData(ByteBuffer byteBuffer, int n, int n2, int n3, ByteBuffer byteBuffer2, Object object) throws Throwable {
        short[] sArray = (short[])object;
        int n4 = byteBuffer2.position();
        ShortBuffer shortBuffer = byteBuffer2.asShortBuffer();
        switch (DataTypes.typeCategory[n]) {
            case 2: {
                int n5;
                if (n == 1 || n == 41) {
                    int n6;
                    for (n5 = 0; n5 < n3; n5 += n6 / n2) {
                        n6 = (n3 - n5) * n2;
                        if (n6 > sArray.length) {
                            n6 = sArray.length;
                        }
                        for (int i = 0; i < n6; ++i) {
                            sArray[i] = byteBuffer.get();
                        }
                        shortBuffer.put(sArray, 0, n6);
                        n4 += 2 * n6;
                    }
                    byteBuffer2.position(n4);
                    break;
                }
                if (n == 2) {
                    int n7 = byteBuffer.position();
                    ShortBuffer shortBuffer2 = byteBuffer.asShortBuffer();
                    while (n5 < n3) {
                        int n8 = (n3 - n5) * n2;
                        if (n8 > sArray.length) {
                            n8 = sArray.length;
                        }
                        shortBuffer2.get(sArray, 0, n8);
                        n7 += 2 * n8;
                        shortBuffer.put(sArray, 0, n8);
                        n4 += 2 * n8;
                        n5 += n8 / n2;
                    }
                    byteBuffer.position(n7);
                    byteBuffer2.position(n4);
                    break;
                }
            }
            case 3: {
                int n5;
                if (n == 11) {
                    while (n5 < n3) {
                        int n9 = (n3 - n5) * n2;
                        if (n9 > sArray.length) {
                            n9 = sArray.length;
                        }
                        for (int i = 0; i < n9; ++i) {
                            int n10 = byteBuffer.get();
                            sArray[i] = (short)(n10 < 0 ? n10 + 256 : n10);
                        }
                        shortBuffer.put(sArray, 0, n9);
                        n4 += 2 * n9;
                        n5 += n9 / n2;
                    }
                    byteBuffer2.position(n4);
                    break;
                }
                if (n == 12) {
                    int n11 = byteBuffer.position();
                    ShortBuffer shortBuffer3 = byteBuffer.asShortBuffer();
                    while (n5 < n3) {
                        int n12 = (n3 - n5) * n2;
                        if (n12 > sArray.length) {
                            n12 = sArray.length;
                        }
                        shortBuffer3.get(sArray, 0, n12);
                        n11 += 2 * n12;
                        shortBuffer.put(sArray, 0, n12);
                        n4 += 2 * n12;
                        n5 += n12 / n2;
                    }
                    byteBuffer.position(n11);
                    byteBuffer2.position(n4);
                    break;
                }
            }
            default: {
                throw new Throwable("Unrecognized type " + n);
            }
        }
    }

    public static boolean isCompatible(int n, boolean bl) {
        return ShortVarContainer.isCompatible(n, bl, Short.TYPE);
    }

    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 4) {
            throw new Throwable("Rank > 4 not supported yet.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining() / 2;
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        int n3 = -1;
        switch (n) {
            case 0: {
                Object object;
                short[] sArray = new short[n2];
                shortBuffer.get(sArray);
                if (this.singlePoint) {
                    Short s;
                    object = s;
                    s = new Short(sArray[0]);
                } else {
                    object = sArray;
                }
                return object;
            }
            case 1: {
                int n4 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / n4;
                short[][] sArray = new short[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    shortBuffer.get(sArray[i]);
                }
                return this.singlePoint ? (Object)sArray[0] : sArray;
            }
            case 2: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                int n6 = (Integer)this.var.getElementCount().elementAt(1);
                n3 = n2 / (n5 * n6);
                short[][][] sArray = new short[n3][n5][n6];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n5; ++j) {
                            shortBuffer.get(sArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n5; ++k) {
                                sArray[i][k][j] = shortBuffer.get();
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)sArray[0] : sArray;
            }
            case 3: {
                int n7 = (Integer)this.var.getElementCount().elementAt(0);
                int n8 = (Integer)this.var.getElementCount().elementAt(1);
                int n9 = (Integer)this.var.getElementCount().elementAt(2);
                n3 = n2 / (n7 * n8 * n9);
                short[][][][] sArray = new short[n3][n7][n8][n9];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                shortBuffer.get(sArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n9; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                for (int i2 = 0; i2 < n7; ++i2) {
                                    sArray[i][i2][k][j] = shortBuffer.get();
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)sArray[0] : sArray;
            }
            case 4: {
                int n10 = (Integer)this.var.getElementCount().elementAt(0);
                int n11 = (Integer)this.var.getElementCount().elementAt(1);
                int n12 = (Integer)this.var.getElementCount().elementAt(2);
                int n13 = (Integer)this.var.getElementCount().elementAt(3);
                n3 = n2 / (n10 * n11 * n12 * n13);
                short[][][][][] sArray = new short[n3][n10][n11][n12][n13];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            for (int k = 0; k < n11; ++k) {
                                for (int i3 = 0; i3 < n12; ++i3) {
                                    shortBuffer.get(sArray[i][j][k][i3]);
                                }
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n13; ++j) {
                            for (int k = 0; k < n12; ++k) {
                                for (int i4 = 0; i4 < n11; ++i4) {
                                    for (int i5 = 0; i5 < n10; ++i5) {
                                        sArray[i][i5][i4][k][j] = shortBuffer.get();
                                    }
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)sArray[0] : sArray;
            }
        }
        throw new Throwable("Internal error");
    }

    public void fillArray(short[] sArray, int n, int n2, int n3) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int n4 = (n3 - n2 + 1) * this.elements;
        ByteBuffer byteBuffer = this.getBuffer();
        int n5 = (n2 - this.getRecordRange()[0]) * this.elements * this.getLength();
        byteBuffer.position(n5);
        byteBuffer.asShortBuffer().get(sArray, n, n4);
    }

    @Override
    public short[] as1DArray() {
        return (short[])super.as1DArray();
    }

    @Override
    public short[] asOneDArray() {
        return (short[])super.asOneDArray(true);
    }

    @Override
    public short[] asOneDArray(boolean bl) {
        return (short[])super.asOneDArray(bl);
    }

    @Override
    public ShortArray asArray() throws Throwable {
        return new ShortArray(this._asArray());
    }
}

