/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF2Impl;
import gov.nasa.gsfc.spdf.cdfj.CDF3Impl;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFFactory;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import gov.nasa.gsfc.spdf.cdfj.CDFUrl;
import gov.nasa.gsfc.spdf.cdfj.GenericReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

public final class ReaderFactory {
    static int preamble = 3000;

    public static CDFReader getReader(String string) throws CDFException.ReaderError {
        Object object;
        CDFImpl cDFImpl = null;
        File file = new File(string);
        try {
            object = new RandomAccessFile(file, "r");
            long l = ((RandomAccessFile)object).length();
            if (l > (long)preamble) {
                l = preamble;
            }
            byte[] byArray = new byte[(int)l];
            ((RandomAccessFile)object).readFully(byArray);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            cDFImpl = ReaderFactory.getVersion(byteBuffer, ((RandomAccessFile)object).getChannel());
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError("I/O Error reading " + string);
        }
        object = file.getPath();
        cDFImpl.setSource(new CDFFactory.CDFSource((String)object){
            final /* synthetic */ String val$_fname;
            {
                this.val$_fname = string;
            }

            @Override
            public String getName() {
                return this.val$_fname;
            }

            @Override
            public boolean isFile() {
                return true;
            }
        });
        CDFReader cDFReader = new CDFReader();
        cDFReader.setImpl(cDFImpl);
        return cDFReader;
    }

    public static CDFReader getReader(URL uRL) throws CDFException.ReaderError {
        Object object;
        CDFImpl cDFImpl = null;
        try {
            int n;
            int n2;
            object = new CDFUrl(uRL).openConnection();
            InputStream inputStream = ((URLConnection)object).getInputStream();
            byte[] byArray = new byte[n2];
            int n3 = 0;
            for (n2 = ((URLConnection)object).getContentLength(); n2 > 0; n2 -= n) {
                n = inputStream.read(byArray, n3, n2);
                n3 += n;
            }
            ((HttpURLConnection)object).disconnect();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            cDFImpl = CDFFactory.getVersion(byteBuffer);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError("I/O Error reading " + uRL);
        }
        object = new CDFReader();
        ((GenericReader)object).setImpl(cDFImpl);
        final String string = uRL.toString();
        cDFImpl.setSource(new CDFFactory.CDFSource(){

            @Override
            public String getName() {
                return string;
            }

            @Override
            public boolean isFile() {
                return false;
            }
        });
        return object;
    }

    static CDFImpl getVersion(ByteBuffer byteBuffer, FileChannel fileChannel) throws Throwable {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        long l = longBuffer.get();
        if (l == -3606538872298602497L) {
            return new CDF3Impl(byteBuffer, fileChannel);
        }
        if (l == -3606538868862746623L) {
            ByteBuffer byteBuffer2 = CDFFactory.uncompressed(byteBuffer, 3);
            return new CDF3Impl(byteBuffer2);
        }
        if (l == 0xFFFF0000FFFFL) {
            int n = byteBuffer.getInt(24);
            return new CDF2Impl(byteBuffer, n, fileChannel);
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        if (shortBuffer.get() == -12814 && shortBuffer.get() == 24578) {
            short s = shortBuffer.get();
            if (s == 0) {
                if (shortBuffer.get() == -1) {
                    return new CDF2Impl(byteBuffer, 6, fileChannel);
                }
            } else if (s == -13108 && shortBuffer.get() == 1) {
                ByteBuffer byteBuffer3 = CDFFactory.uncompressed(byteBuffer, 2);
                return new CDF2Impl(byteBuffer3, 6, fileChannel);
            }
        }
        return null;
    }

    public static CDFReader getReader(String string, boolean bl) throws CDFException.ReaderError {
        Object object;
        CDFImpl cDFImpl = null;
        File file = new File(string);
        try {
            int n = (int)file.length();
            object = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = 0;
            for (int i = n; i > 0; i -= n) {
                n = fileInputStream.read((byte[])object, n2, i);
                n2 += n;
            }
            fileInputStream.close();
            cDFImpl = CDFFactory.getCDF((byte[])object);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError("I/O Error reading " + string);
        }
        final String string2 = file.getPath();
        cDFImpl.setSource(new CDFFactory.CDFSource(){

            @Override
            public String getName() {
                return string2;
            }

            @Override
            public boolean isFile() {
                return true;
            }
        });
        object = new CDFReader();
        ((GenericReader)object).setImpl(cDFImpl);
        return object;
    }
}

