/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.LongArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public final class LongVarContainer
extends BaseVarContainer
implements VDataContainer.CLong {
    final long[] lpad;

    public LongVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, ByteOrder byteOrder) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray, true, byteOrder, Long.TYPE);
        Object object = this.thisCDF.getPadValue(variable);
        if (object.getClass().getComponentType() == Double.TYPE) {
            double[] dArray = (double[])object;
            this.lpad = new long[dArray.length];
            for (int i = 0; i < this.lpad.length; ++i) {
                this.lpad[i] = (long)dArray[i];
            }
        } else {
            this.lpad = (long[])this.thisCDF.getPadValue(variable);
        }
    }

    public LongVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray) throws IllegalAccessException, InvocationTargetException, Throwable {
        this(cDFImpl, variable, nArray, ByteOrder.nativeOrder());
    }

    @Override
    ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8 * n);
        byteBuffer.order(this.order);
        return byteBuffer;
    }

    @Override
    public Object allocateDataArray(int n) {
        return new long[n];
    }

    @Override
    void doMissing(int n, ByteBuffer byteBuffer, Object object, int n2) {
        int n3;
        long[] lArray = (long[])object;
        long[] lArray2 = null;
        try {
            lArray2 = n2 < 0 ? this.lpad : this.var.asLongArray(new int[]{n2});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Should not see this.");
        }
        int n4 = byteBuffer.position();
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        for (int i = n; i > 0; i -= n3) {
            n3 = i;
            if (n3 * this.elements > lArray.length) {
                n3 = lArray.length / this.elements;
            }
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.elements; ++k) {
                    lArray[n5++] = lArray2[k];
                }
            }
            longBuffer.put(lArray, 0, n3 * this.elements);
            n4 += 8 * n3 * this.elements;
        }
        byteBuffer.position(n4);
    }

    @Override
    void doData(ByteBuffer byteBuffer, int n, int n2, int n3, ByteBuffer byteBuffer2, Object object) throws Throwable, IllegalAccessException, InvocationTargetException {
        long[] lArray = (long[])object;
        int n4 = byteBuffer2.position();
        LongBuffer longBuffer = byteBuffer2.asLongBuffer();
        switch (DataTypes.typeCategory[n]) {
            case 2: {
                int n5;
                int n6;
                Method method = DataTypes.method[n];
                for (n5 = 0; n5 < n3; n5 += n6 / n2) {
                    n6 = (n3 - n5) * n2;
                    if (n6 > lArray.length) {
                        n6 = lArray.length;
                    }
                    for (int i = 0; i < n6; ++i) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        lArray[i] = number.longValue();
                    }
                    longBuffer.put(lArray, 0, n6);
                    n4 += 8 * n6;
                }
                byteBuffer2.position(n4);
                break;
            }
            case 3: {
                int n5;
                Method method = DataTypes.method[n];
                long l = DataTypes.longInt[n];
                while (n5 < n3) {
                    int n7 = (n3 - n5) * n2;
                    if (n7 > lArray.length) {
                        n7 = lArray.length;
                    }
                    for (int i = 0; i < n7; ++i) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n8 = number.intValue();
                        lArray[i] = n8 >= 0 ? (long)n8 : l + (long)n8;
                    }
                    longBuffer.put(lArray, 0, n7);
                    n4 += 8 * n7;
                    n5 += n7 / n2;
                }
                byteBuffer2.position(n4);
                break;
            }
            case 5: {
                int n5;
                int n9 = byteBuffer.position();
                LongBuffer longBuffer2 = byteBuffer.asLongBuffer();
                while (n5 < n3) {
                    int n10 = (n3 - n5) * n2;
                    if (n10 > lArray.length) {
                        n10 = lArray.length;
                    }
                    longBuffer2.get(lArray, 0, n10);
                    n9 += 8 * n10;
                    longBuffer.put(lArray, 0, n10);
                    n4 += 8 * n10;
                    n5 += n10 / n2;
                }
                byteBuffer.position(n9);
                byteBuffer2.position(n4);
                break;
            }
            default: {
                throw new Throwable("Unrecognized data type " + n);
            }
        }
    }

    public static boolean isCompatible(int n, boolean bl) {
        return LongVarContainer.isCompatible(n, bl, Long.TYPE);
    }

    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 4) {
            throw new Throwable("Rank > 4 not supported yet.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining() / 8;
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        int n3 = -1;
        switch (n) {
            case 0: {
                Object object;
                long[] lArray = new long[n2];
                longBuffer.get(lArray);
                if (this.singlePoint) {
                    Long l;
                    object = l;
                    l = new Long(lArray[0]);
                } else {
                    object = lArray;
                }
                return object;
            }
            case 1: {
                int n4 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / n4;
                long[][] lArray = new long[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    longBuffer.get(lArray[i]);
                }
                return this.singlePoint ? (Object)lArray[0] : lArray;
            }
            case 2: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                int n6 = (Integer)this.var.getElementCount().elementAt(1);
                n3 = n2 / (n5 * n6);
                long[][][] lArray = new long[n3][n5][n6];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n5; ++j) {
                            longBuffer.get(lArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n5; ++k) {
                                lArray[i][k][j] = longBuffer.get();
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)lArray[0] : lArray;
            }
            case 3: {
                int n7 = (Integer)this.var.getElementCount().elementAt(0);
                int n8 = (Integer)this.var.getElementCount().elementAt(1);
                int n9 = (Integer)this.var.getElementCount().elementAt(2);
                n3 = n2 / (n7 * n8 * n9);
                long[][][][] lArray = new long[n3][n7][n8][n9];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                longBuffer.get(lArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n9; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                for (int i2 = 0; i2 < n7; ++i2) {
                                    lArray[i][i2][k][j] = longBuffer.get();
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)lArray[0] : lArray;
            }
            case 4: {
                int n10 = (Integer)this.var.getElementCount().elementAt(0);
                int n11 = (Integer)this.var.getElementCount().elementAt(1);
                int n12 = (Integer)this.var.getElementCount().elementAt(2);
                int n13 = (Integer)this.var.getElementCount().elementAt(3);
                n3 = n2 / (n10 * n11 * n12 * n13);
                long[][][][][] lArray = new long[n3][n10][n11][n12][n13];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            for (int k = 0; k < n11; ++k) {
                                for (int i3 = 0; i3 < n12; ++i3) {
                                    longBuffer.get(lArray[i][j][k][i3]);
                                }
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n13; ++j) {
                            for (int k = 0; k < n12; ++k) {
                                for (int i4 = 0; i4 < n11; ++i4) {
                                    for (int i5 = 0; i5 < n10; ++i5) {
                                        lArray[i][i5][i4][k][j] = longBuffer.get();
                                    }
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)lArray[0] : lArray;
            }
        }
        throw new Throwable("Internal error");
    }

    public void fillArray(long[] lArray, int n, int n2, int n3) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int n4 = (n3 - n2 + 1) * this.elements;
        ByteBuffer byteBuffer = this.getBuffer();
        int n5 = (n2 - this.getRecordRange()[0]) * this.elements * this.getLength();
        byteBuffer.position(n5);
        byteBuffer.asLongBuffer().get(lArray, n, n4);
    }

    @Override
    public long[] as1DArray() {
        return (long[])super.as1DArray();
    }

    @Override
    public long[] asOneDArray() {
        return (long[])super.asOneDArray(true);
    }

    @Override
    public long[] asOneDArray(boolean bl) {
        return (long[])super.asOneDArray(bl);
    }

    @Override
    public LongArray asArray() throws Throwable {
        return new LongArray(this._asArray());
    }
}

