/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.Stride;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class Extractor {
    static int MAX_ARRAY = 3;
    static Hashtable numericMethodMap = new Hashtable();
    static Hashtable stringMethodMap = new Hashtable();

    public static void addFunction(String string, Class clazz, Class[][] classArray) {
        Method[] methodArray = new Method[MAX_ARRAY + 1];
        for (int i = 0; i <= MAX_ARRAY; ++i) {
            if (classArray[i] == null) continue;
            try {
                methodArray[i] = clazz.getMethod("get" + string + i, classArray[i]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        if (numericMethodMap.put(string, methodArray) != null) {
            System.out.println("replacing value for the function " + string);
        }
    }

    public static Method getMethod(Variable variable, String string) throws IllegalAccessException, InvocationTargetException {
        int n = variable.getEffectiveRank();
        if (DataTypes.isStringType(variable.getType())) {
            Method[] methodArray = (Method[])stringMethodMap.get(string);
            if (methodArray == null) {
                return null;
            }
            if (n >= methodArray.length) {
                return null;
            }
            return methodArray[n];
        }
        Method[] methodArray = (Method[])numericMethodMap.get(string);
        if (methodArray == null) {
            return null;
        }
        if (DataTypes.typeCategory[variable.getType()] == 5 && n > 0) {
            return null;
        }
        return methodArray[n];
    }

    public static Object getSeries0(CDFImpl cDFImpl, Variable variable) throws IllegalAccessException, InvocationTargetException, Throwable {
        int n;
        int n2;
        Number number;
        if (variable.isMissingRecords()) {
            return cDFImpl.get(variable.getName());
        }
        int n3 = variable.getNumberOfValues();
        if (n3 == 0) {
            return null;
        }
        int n4 = variable.getType();
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        if (DataTypes.typeCategory[n4] == 5) {
            lArray = new long[n3];
            bl = true;
            number = new Long(((long[])Extractor.getPadValue(cDFImpl, variable))[0]);
        } else {
            dArray = new double[n3];
            number = new Double(((double[])Extractor.getPadValue(cDFImpl, variable))[0]);
        }
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n5 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            long[] lArray2 = (long[])vector.elementAt(n2);
            n = (int)lArray2[0];
            int n6 = (int)lArray2[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray2[2], n6 - n + 1);
            if (!bl) {
                while (n5 < n) {
                    dArray[n5++] = number.doubleValue();
                }
            } else {
                while (n5 < n) {
                    lArray[n5++] = number.longValue();
                }
            }
            switch (DataTypes.typeCategory[n4]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    while (n5 <= n6) {
                        dArray[n5++] = floatBuffer.get();
                    }
                    break;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    while (n5 <= n6) {
                        dArray[n5++] = doubleBuffer.get();
                    }
                    break;
                }
                case 2: {
                    Method method = DataTypes.method[n4];
                    while (n5 <= n6) {
                        Number number2 = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        dArray[n5++] = number2.doubleValue();
                    }
                    break;
                }
                case 3: {
                    Object object;
                    Method method = DataTypes.method[n4];
                    long l = DataTypes.longInt[n4];
                    while (n5 <= n6) {
                        object = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n7 = ((Number)object).intValue();
                        dArray[n5++] = n7 >= 0 ? (double)n7 : (double)(l + (long)n7);
                    }
                    break;
                }
                case 5: {
                    Object object = byteBuffer.asLongBuffer();
                    while (n5 <= n6) {
                        lArray[n5++] = ((LongBuffer)object).get();
                    }
                    break;
                }
            }
            if (n5 > n3) break;
            if (n2 != vector.size() - 1) continue;
            if (!bl) {
                while (n5 < n3) {
                    dArray[n5++] = number.doubleValue();
                }
                continue;
            }
            while (n5 < n3) {
                lArray[n5++] = number.longValue();
            }
        }
        if (!variable.recordVariance()) {
            if (!bl) {
                for (n2 = 1; n2 < n3; ++n2) {
                    dArray[n2] = dArray[0];
                }
            } else {
                for (n2 = 1; n2 < n3; ++n2) {
                    lArray[n2] = lArray[0];
                }
            }
        }
        if (variable.isMissingRecords() && variable.missingRecordValueIsPrevious()) {
            if (bl) {
                long l = number.longValue();
                for (n = 1; n < lArray.length; ++n) {
                    if (lArray[n] != l) continue;
                    lArray[n] = lArray[n - 1];
                }
            } else {
                double d = number.doubleValue();
                for (n = 1; n < dArray.length; ++n) {
                    if (dArray[n] != d) continue;
                    dArray[n] = dArray[n - 1];
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static double[] castToDouble(Object object, boolean bl) {
        double[] dArray;
        if (!bl) {
            dArray = (double[])object;
        } else {
            long[] lArray = (long[])object;
            dArray = new double[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                dArray[i] = lArray[i];
            }
        }
        return dArray;
    }

    public static Object getPadValue(CDFImpl cDFImpl, Variable variable) {
        Object object = variable.getPadValue(true);
        if (object == null) {
            Object object2 = Extractor.getFillValue(cDFImpl, variable);
            boolean bl = true;
            Number number = null;
            if (object2.getClass().getComponentType() == Double.TYPE) {
                boolean bl2 = bl = ((double[])object2)[0] == 0.0;
                if (bl) {
                    number = new Double(((double[])object2)[1]);
                }
            } else {
                boolean bl3 = bl = ((long[])object2)[0] == 0L;
                if (bl) {
                    number = new Long(((long[])object2)[1]);
                }
            }
            int n = variable.getType();
            int n2 = variable.getDataItemSize() / DataTypes.size[n];
            if (DataTypes.typeCategory[n] == 5) {
                long[] lArray = new long[n2];
                if (!bl) {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = Long.MIN_VALUE;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = number.longValue();
                    }
                }
                return lArray;
            }
            double[] dArray = new double[n2];
            if (!bl) {
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = Double.NEGATIVE_INFINITY;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = number.doubleValue();
                }
            }
            return dArray;
        }
        return object;
    }

    public static Object getFillValue(CDFImpl cDFImpl, Variable variable) {
        Vector vector = (Vector)cDFImpl.getAttribute(variable.getName(), "FILLVAL");
        int n = variable.getType();
        if (vector.size() != 0) {
            if (vector.get(0).getClass().getComponentType() == Double.TYPE) {
                double d = ((double[])vector.get(0))[0];
                if (DataTypes.typeCategory[n] == 5) {
                    return new long[]{0L, (long)d};
                }
                return new double[]{0.0, d};
            }
            long l = ((long[])vector.get(0))[0];
            if (DataTypes.typeCategory[n] == 5) {
                return new long[]{0L, l};
            }
            return new double[]{0.0, l};
        }
        if (DataTypes.typeCategory[n] == 5) {
            return new long[]{Long.MIN_VALUE, 0L};
        }
        return new double[]{Double.NEGATIVE_INFINITY, 0.0};
    }

    public static double[][] getSeries1(CDFImpl cDFImpl, Variable variable) throws IllegalAccessException, InvocationTargetException, Throwable {
        int n = variable.getNumberOfValues();
        if (n == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n = 1;
        }
        int n2 = (Integer)Extractor.elementCount(variable).elementAt(0);
        double[][] dArray = new double[n][n2];
        int n3 = variable.getType();
        if (DataTypes.typeCategory[n3] == 5) {
            throw new Throwable("Only scalar variables of type int8 are supported at this time.");
        }
        double[] dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n4 = 0;
        block6: for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            int n5 = (int)lArray[0];
            int n6 = (int)lArray[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], n6 - n5 + 1);
            while (n4 < n5) {
                for (int j = 0; j < n2; ++j) {
                    dArray[n4][j] = dArray2[j];
                }
                ++n4;
            }
            switch (DataTypes.typeCategory[n3]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    while (n4 <= n6) {
                        for (int j = 0; j < n2; ++j) {
                            dArray[n4][j] = floatBuffer.get();
                        }
                        ++n4;
                    }
                    continue block6;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    while (n4 <= n6) {
                        for (int j = 0; j < n2; ++j) {
                            dArray[n4][j] = doubleBuffer.get();
                        }
                        ++n4;
                    }
                    continue block6;
                }
                case 2: {
                    Extractor.doSignedInteger(byteBuffer, n3, n5, n6, n2, dArray);
                    n4 += n6 - n5 + 1;
                    continue block6;
                }
                case 3: {
                    Extractor.doUnsignedInteger(byteBuffer, n3, n5, n6, n2, dArray);
                    n4 += n6 - n5 + 1;
                }
            }
        }
        return dArray;
    }

    static void doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, double[][] dArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n];
        for (int i = n2; i <= n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                dArray[i][j] = number.doubleValue();
            }
        }
    }

    static void doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray) throws IllegalAccessException, InvocationTargetException {
        int n6 = n4;
        Extractor.doSignedInteger(byteBuffer, n, n2, n3, n4, n5, dArray, n6);
    }

    static int doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray, int n6) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        byteBuffer.position(n);
        for (int i = n4; i <= n5; ++i) {
            byteBuffer.position(n);
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            dArray[n6++] = number.doubleValue();
            n += n3;
        }
        return n6;
    }

    static void doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        byteBuffer.position(n);
        int n6 = nArray.length;
        for (int i = n4; i <= n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                byteBuffer.position(n + nArray[j]);
                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                dArray[i][j] = number.doubleValue();
            }
            n += n3;
        }
    }

    static int doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        byteBuffer.position(n);
        int n7 = nArray.length;
        for (int i = n4; i <= n5; ++i) {
            for (int j = 0; j < n7; ++j) {
                byteBuffer.position(n + nArray[j]);
                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                dArray[n6][j] = number.doubleValue();
            }
            n += n3;
            ++n6;
        }
        return n6;
    }

    static void doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, double[][] dArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n];
        long l = DataTypes.longInt[n];
        for (int i = n2; i <= n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                int n5 = number.intValue();
                dArray[i][j] = n5 >= 0 ? (double)n5 : (double)(l + (long)n5);
            }
        }
    }

    static void doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        long l = DataTypes.longInt[n2];
        byteBuffer.position(n);
        for (int i = n4; i <= n5; ++i) {
            byteBuffer.position(n);
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            int n6 = number.intValue();
            dArray[i] = n6 >= 0 ? (double)n6 : (double)(l + (long)n6);
            n += n3;
        }
    }

    static int doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray, int n6) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        long l = DataTypes.longInt[n2];
        byteBuffer.position(n);
        for (int i = n4; i <= n5; ++i) {
            byteBuffer.position(n);
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            int n7 = number.intValue();
            dArray[n6++] = n7 >= 0 ? (double)n7 : (double)(l + (long)n7);
            n += n3;
        }
        return n6;
    }

    static void doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        long l = DataTypes.longInt[n2];
        byteBuffer.position(n);
        int n6 = nArray.length;
        for (int i = n4; i <= n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                byteBuffer.position(n + nArray[j]);
                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                int n7 = number.intValue();
                dArray[i][j] = n7 >= 0 ? (double)n7 : (double)(l + (long)n7);
            }
            n += n3;
        }
    }

    static int doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        long l = DataTypes.longInt[n2];
        byteBuffer.position(n);
        int n7 = nArray.length;
        for (int i = n4; i <= n5; ++i) {
            for (int j = 0; j < n7; ++j) {
                byteBuffer.position(n + nArray[j]);
                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                int n8 = number.intValue();
                dArray[n6][j] = n8 >= 0 ? (double)n8 : (double)(l + (long)n8);
            }
            n += n3;
            ++n6;
        }
        return n6;
    }

    public static Object getElement1(CDFImpl cDFImpl, Variable variable, Integer n) throws Throwable {
        if (variable.isMissingRecords()) {
            return cDFImpl.get(variable.getName(), n);
        }
        int n2 = n;
        int n3 = variable.getNumberOfValues();
        if (n3 == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n3 = 1;
        }
        if (!Extractor.validElement(variable, new int[]{n2})) {
            return null;
        }
        int n4 = variable.getDataItemSize();
        int n5 = variable.getType();
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        double[] dArray2 = null;
        long[] lArray2 = null;
        if (DataTypes.typeCategory[n5] == 5) {
            lArray = new long[n3];
            bl = true;
            lArray2 = (long[])Extractor.getPadValue(cDFImpl, variable);
        } else {
            dArray = new double[n3];
            dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        }
        int n6 = n2 * DataTypes.size[n5];
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n7 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            long[] lArray3 = (long[])vector.elementAt(i);
            int n8 = (int)lArray3[0];
            int n9 = (int)lArray3[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray3[2], n9 - n8 + 1);
            if (!bl) {
                while (n7 < n8) {
                    dArray[n7++] = dArray2[n2];
                }
            } else {
                while (n7 < n8) {
                    lArray[n7++] = lArray2[n2];
                }
            }
            int n10 = byteBuffer.position() + n6;
            switch (DataTypes.typeCategory[n5]) {
                case 0: {
                    while (n7 <= n9) {
                        dArray[n7++] = byteBuffer.getFloat(n10);
                        n10 += n4;
                    }
                    break;
                }
                case 1: {
                    while (n7 <= n9) {
                        dArray[n7++] = byteBuffer.getDouble(n10);
                        n10 += n4;
                    }
                    break;
                }
                case 2: {
                    Extractor.doSignedInteger(byteBuffer, n10, n5, n4, n8, n9, dArray);
                    n7 += n9 - n8 + 1;
                    break;
                }
                case 3: {
                    Extractor.doUnsignedInteger(byteBuffer, n10, n5, n4, n8, n9, dArray);
                    n7 += n9 - n8 + 1;
                    break;
                }
                case 5: {
                    while (n7 <= n9) {
                        lArray[n7++] = byteBuffer.getLong(n10);
                        n10 += n4;
                    }
                    break;
                }
                default: {
                    throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
                }
            }
            if (n7 > n3) break;
            if (i != vector.size() - 1) continue;
            if (!bl) {
                while (n7 < n3) {
                    dArray[n7++] = dArray2[n2];
                }
                continue;
            }
            while (n7 < n3) {
                lArray[n7++] = lArray2[n2];
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static Object getElements1(CDFImpl cDFImpl, Variable variable, int[] nArray) throws Throwable {
        int n = variable.getNumberOfValues();
        if (n == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n = 1;
        }
        if (!Extractor.validElement(variable, nArray)) {
            return null;
        }
        int n2 = nArray.length;
        int n3 = variable.getDataItemSize();
        int n4 = variable.getType();
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i] * DataTypes.size[n4];
        }
        long[][] lArray = null;
        double[][] dArray = null;
        boolean bl = false;
        double[] dArray2 = null;
        long[] lArray2 = null;
        if (DataTypes.typeCategory[n4] == 5) {
            lArray = new long[n][n2];
            bl = true;
            lArray2 = (long[])Extractor.getPadValue(cDFImpl, variable);
        } else {
            dArray = new double[n][n2];
            dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        }
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n5 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n6;
            long[] lArray3 = (long[])vector.elementAt(i);
            int n7 = (int)lArray3[0];
            int n8 = (int)lArray3[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray3[2], n8 - n7 + 1);
            if (!bl) {
                while (n5 < n7) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        dArray[n5][n6] = dArray2[nArray[n6]];
                    }
                    ++n5;
                }
            } else {
                while (n5 < n7) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        lArray[n5][n6] = lArray2[nArray[n6]];
                    }
                    ++n5;
                }
            }
            int n9 = byteBuffer.position();
            switch (DataTypes.typeCategory[n4]) {
                case 0: {
                    int n10;
                    int n11;
                    for (n11 = n7; n11 <= n8; ++n11) {
                        for (n10 = 0; n10 < n2; ++n10) {
                            dArray[n11][n10] = byteBuffer.getFloat(n9 + nArray2[n10]);
                        }
                        n9 += n3;
                    }
                    break;
                }
                case 1: {
                    int n10;
                    int n11;
                    for (n11 = n7; n11 <= n8; ++n11) {
                        for (n10 = 0; n10 < n2; ++n10) {
                            dArray[n11][n10] = byteBuffer.getDouble(n9 + nArray2[n10]);
                        }
                        n9 += n3;
                    }
                    break;
                }
                case 2: {
                    Extractor.doSignedInteger(byteBuffer, n9, n4, n3, n7, n8, nArray2, dArray);
                    break;
                }
                case 3: {
                    Extractor.doUnsignedInteger(byteBuffer, n9, n4, n3, n7, n8, nArray2, dArray);
                    break;
                }
                case 5: {
                    int n10;
                    int n11;
                    for (n11 = n7; n11 <= n8; ++n11) {
                        for (n10 = 0; n10 < n2; ++n10) {
                            lArray[n11][n10] = byteBuffer.getLong(n9 + nArray2[n10]);
                        }
                        n9 += n3;
                    }
                    break;
                }
                default: {
                    throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
                }
            }
            n5 += n8 - n7 + 1;
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static double[][][] getSeries2(CDFImpl cDFImpl, Variable variable) throws Throwable {
        int n = variable.getType();
        if (DataTypes.typeCategory[n] == 5) {
            throw new Throwable("Only scalar variables of type int8 are supported at this time.");
        }
        int n2 = variable.getNumberOfValues();
        if (n2 == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n2 = 1;
        }
        int n3 = (Integer)Extractor.elementCount(variable).elementAt(0);
        int n4 = (Integer)Extractor.elementCount(variable).elementAt(1);
        double[][][] dArray = new double[n2][n3][n4];
        double[] dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n5 = 0;
        block6: for (int i = 0; i < vector.size(); ++i) {
            int n6;
            long[] lArray = (long[])vector.elementAt(i);
            int n7 = (int)lArray[0];
            int n8 = (int)lArray[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], n8 - n7 + 1);
            if (variable.rowMajority()) {
                while (n5 < n7) {
                    for (int j = 0; j < n3; ++j) {
                        for (n6 = 0; n6 < n4; ++n6) {
                            dArray[n5][j][n6] = dArray2[j * n3 + n6];
                        }
                    }
                    ++n5;
                }
            } else {
                while (n5 < n7) {
                    for (int j = 0; j < n4; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            dArray[n5][k][j] = dArray2[k * n3 + j];
                        }
                    }
                    ++n5;
                }
            }
            switch (DataTypes.typeCategory[n]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    if (variable.rowMajority()) {
                        while (n5 <= n8) {
                            for (n6 = 0; n6 < n3; ++n6) {
                                for (int j = 0; j < n4; ++j) {
                                    dArray[n5][n6][j] = floatBuffer.get();
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                    while (n5 <= n8) {
                        for (n6 = 0; n6 < n4; ++n6) {
                            for (int j = 0; j < n3; ++j) {
                                dArray[n5][j][n6] = floatBuffer.get();
                            }
                        }
                        ++n5;
                    }
                    continue block6;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    if (variable.rowMajority()) {
                        while (n5 <= n8) {
                            for (int j = 0; j < n3; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    dArray[n5][j][k] = doubleBuffer.get();
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                    while (n5 <= n8) {
                        for (int j = 0; j < n4; ++j) {
                            for (int k = 0; k < n3; ++k) {
                                dArray[n5][k][j] = doubleBuffer.get();
                            }
                        }
                        ++n5;
                    }
                    continue block6;
                }
                case 2: {
                    if (n == 1 || n == 41) {
                        if (variable.rowMajority()) {
                            while (n5 <= n8) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n4; ++k) {
                                        dArray[n5][j][k] = byteBuffer.get();
                                    }
                                }
                                ++n5;
                            }
                            continue block6;
                        }
                        while (n5 <= n8) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    dArray[n5][k][j] = byteBuffer.get();
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                    if (n == 2) {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        if (variable.rowMajority()) {
                            while (n5 <= n8) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n4; ++k) {
                                        dArray[n5][j][k] = shortBuffer.get();
                                    }
                                }
                                ++n5;
                            }
                            continue block6;
                        }
                        while (n5 <= n8) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    dArray[n5][k][j] = shortBuffer.get();
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                    if (n == 4) {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        if (variable.rowMajority()) {
                            while (n5 <= n8) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n4; ++k) {
                                        dArray[n5][j][k] = intBuffer.get();
                                    }
                                }
                                ++n5;
                            }
                            continue block6;
                        }
                        while (n5 <= n8) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    dArray[n5][k][j] = intBuffer.get();
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                }
                case 3: {
                    int n9;
                    int n10;
                    if (n == 11) {
                        int n11 = 256;
                        if (variable.rowMajority()) {
                            while (n5 <= n8) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n4; ++k) {
                                        n10 = byteBuffer.get();
                                        dArray[n5][j][k] = n10 >= 0 ? (double)n10 : (double)(n11 + n10);
                                    }
                                }
                                ++n5;
                            }
                            continue block6;
                        }
                        while (n5 <= n8) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    n10 = byteBuffer.get();
                                    dArray[n5][k][j] = n10 >= 0 ? (double)n10 : (double)(n11 + n10);
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                    if (n == 12) {
                        int n12 = 65536;
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        if (variable.rowMajority()) {
                            while (n5 <= n8) {
                                for (int j = 0; j < n3; ++j) {
                                    for (n10 = 0; n10 < n4; ++n10) {
                                        n9 = shortBuffer.get();
                                        dArray[n5][j][n10] = n9 >= 0 ? (double)n9 : (double)(n12 + n9);
                                    }
                                }
                                ++n5;
                            }
                            continue block6;
                        }
                        while (n5 <= n8) {
                            for (int j = 0; j < n4; ++j) {
                                for (n10 = 0; n10 < n3; ++n10) {
                                    n9 = shortBuffer.get();
                                    dArray[n5][n10][j] = n9 >= 0 ? (double)n9 : (double)(n12 + n9);
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                    if (n == 14) {
                        int n13;
                        long l = 0x100000000L;
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        if (variable.rowMajority()) {
                            while (n5 <= n8) {
                                for (n10 = 0; n10 < n3; ++n10) {
                                    for (n9 = 0; n9 < n4; ++n9) {
                                        n13 = intBuffer.get();
                                        dArray[n5][n10][n9] = n13 >= 0 ? (double)n13 : (double)(l + (long)n13);
                                    }
                                }
                                ++n5;
                            }
                            continue block6;
                        }
                        while (n5 <= n8) {
                            for (n10 = 0; n10 < n4; ++n10) {
                                for (n9 = 0; n9 < n3; ++n9) {
                                    n13 = intBuffer.get();
                                    dArray[n5][n9][n10] = n13 >= 0 ? (double)n13 : (double)(l + (long)n13);
                                }
                            }
                            ++n5;
                        }
                        continue block6;
                    }
                }
                default: {
                    throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
                }
            }
        }
        return dArray;
    }

    public static Object getPoint0(CDFImpl cDFImpl, Variable variable, Integer n) throws Throwable {
        if (variable.isMissingRecords()) {
            return cDFImpl.getPoint(variable.getName(), n);
        }
        int n2 = n;
        int n3 = variable.getType();
        int n4 = variable.getDataItemSize();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            if (lArray[1] < (long)n2) continue;
            if (lArray[0] > (long)n2) {
                return null;
            }
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], (int)(lArray[1] - lArray[0] + 1L));
            int n5 = byteBuffer.position() + (n2 - (int)lArray[0]) * n4;
            switch (DataTypes.typeCategory[n3]) {
                case 0: {
                    return new Double(byteBuffer.getFloat(n5));
                }
                case 1: {
                    return new Double(byteBuffer.getDouble(n5));
                }
                case 2: {
                    Method method = DataTypes.method[n3];
                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                    return new Double(number.doubleValue());
                }
                case 3: {
                    Method method = DataTypes.method[n3];
                    long l = DataTypes.longInt[n3];
                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                    int n6 = number.intValue();
                    double d = n6 >= 0 ? (double)n6 : (double)(l + (long)n6);
                    return new Double(d);
                }
                case 5: {
                    return new Long(byteBuffer.getLong(n5));
                }
            }
        }
        return null;
    }

    public static double[] getPoint1(CDFImpl cDFImpl, Variable variable, Integer n) throws Throwable {
        int n2 = n;
        int n3 = variable.getType();
        if (DataTypes.typeCategory[n3] == 5) {
            throw new Throwable("Only scalar variables of type int8 are supported at this time.");
        }
        int n4 = variable.getDataItemSize();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            if (lArray[1] < (long)n2) continue;
            if (lArray[0] > (long)n2) {
                return null;
            }
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], (int)(lArray[1] - lArray[0] + 1L));
            int n5 = byteBuffer.position() + (n2 - (int)lArray[0]) * n4;
            byteBuffer.position(n5);
            int n6 = (Integer)Extractor.elementCount(variable).elementAt(0);
            double[] dArray = new double[n6];
            switch (DataTypes.typeCategory[n3]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    for (int j = 0; j < n6; ++j) {
                        dArray[j] = floatBuffer.get();
                    }
                    return dArray;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    for (int j = 0; j < n6; ++j) {
                        dArray[j] = doubleBuffer.get();
                    }
                    return dArray;
                }
                case 2: {
                    Method method = DataTypes.method[n3];
                    for (int j = 0; j < n6; ++j) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        dArray[j] = number.doubleValue();
                    }
                    return dArray;
                }
                case 3: {
                    Method method = DataTypes.method[n3];
                    long l = DataTypes.longInt[n3];
                    for (int j = 0; j < n6; ++j) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n7 = number.intValue();
                        dArray[j] = n7 >= 0 ? (double)n7 : (double)(l + (long)n7);
                    }
                    return dArray;
                }
            }
        }
        return null;
    }

    public static double[][] getPoint2(CDFImpl cDFImpl, Variable variable, Integer n) throws Throwable {
        int n2 = n;
        int n3 = variable.getType();
        if (DataTypes.typeCategory[n3] == 5) {
            throw new Throwable("Only scalar variables of type int8 are supported at this time.");
        }
        int n4 = variable.getDataItemSize();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            if (lArray[1] < (long)n2) continue;
            if (lArray[0] > (long)n2) {
                return null;
            }
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], (int)(lArray[1] - lArray[0] + 1L));
            int n5 = byteBuffer.position() + (n2 - (int)lArray[0]) * n4;
            byteBuffer.position(n5);
            int n6 = (Integer)Extractor.elementCount(variable).elementAt(0);
            int n7 = (Integer)Extractor.elementCount(variable).elementAt(1);
            double[][] dArray = new double[n6][n7];
            switch (DataTypes.typeCategory[n3]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                dArray[j][k] = floatBuffer.get();
                            }
                        }
                    } else {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n6; ++k) {
                                dArray[k][j] = floatBuffer.get();
                            }
                        }
                    }
                    return dArray;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                dArray[j][k] = doubleBuffer.get();
                            }
                        }
                    } else {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n6; ++k) {
                                dArray[k][j] = doubleBuffer.get();
                            }
                        }
                    }
                    return dArray;
                }
                case 2: {
                    Method method = DataTypes.method[n3];
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                dArray[j][k] = number.doubleValue();
                            }
                        }
                    } else {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n6; ++k) {
                                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                dArray[k][j] = number.doubleValue();
                            }
                        }
                    }
                    return dArray;
                }
                case 3: {
                    Method method = DataTypes.method[n3];
                    long l = DataTypes.longInt[n3];
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                double d;
                                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                int n8 = number.intValue();
                                dArray[j][k] = d = n8 >= 0 ? (double)n8 : (double)(l + (long)n8);
                            }
                        }
                    } else {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n6; ++k) {
                                double d;
                                Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                int n9 = number.intValue();
                                dArray[k][j] = d = n9 >= 0 ? (double)n9 : (double)(l + (long)n9);
                            }
                        }
                    }
                    return dArray;
                }
            }
            throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
        }
        return null;
    }

    public static double[] getElement2(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2) throws Throwable {
        throw new Throwable("getElement2 is not supported currently");
    }

    public static Object getRange0(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2) throws Throwable {
        int n3;
        int n4 = n;
        int n5 = n2;
        if (variable.isMissingRecords()) {
            return cDFImpl.getRange(variable.getName(), n4, n5);
        }
        int n6 = variable.getNumberOfValues();
        int n7 = variable.getDataItemSize();
        int n8 = variable.getType();
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        double[] dArray2 = null;
        long[] lArray2 = null;
        Object[] objectArray = null;
        Object object = Extractor.getPadValue(cDFImpl, variable);
        if (DataTypes.typeCategory[n8] == 5) {
            objectArray = lArray = new long[n5 - n4 + 1];
            bl = true;
            lArray2 = (long[])Extractor.getPadValue(cDFImpl, variable);
        } else {
            dArray = new double[n5 - n4 + 1];
            objectArray = dArray;
            dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        }
        int[] nArray = null;
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        if (vector == null) {
            Extractor.fillWithPad(bl, objectArray, n4, n5, object);
            return objectArray;
        }
        nArray = Extractor.getBlockRange(vector, variable.recordVariance(), n4, n5);
        if (nArray == null) {
            if (!variable.missingRecordValueIsPad() && !variable.missingRecordValueIsPrevious()) {
                return null;
            }
            if (variable.missingRecordValueIsPad()) {
                Extractor.fillWithPad(bl, objectArray, n4, n5, object);
            }
            if (variable.missingRecordValueIsPrevious()) {
                Extractor.fillWithPrevious(variable, bl, objectArray, n4, n5, object);
            }
            return objectArray;
        }
        boolean bl2 = variable.missingRecordValueIsPrevious();
        int n9 = nArray[0];
        int n10 = nArray[1];
        int n11 = 0;
        int n12 = -1;
        for (n3 = n9; n3 <= n10; ++n3) {
            Object object2;
            Object[] objectArray2 = Extractor.positionBuffer(cDFImpl, variable, nArray, n3, n4, n5);
            if (objectArray2 == null) {
                object2 = (long[])vector.get(n3 - 1);
                if (!bl) {
                    double d = variable.asDoubleArray(new int[]{(int)object2[1]})[0];
                    while (n11 < dArray.length) {
                        dArray[n11++] = bl2 ? d : dArray2[0];
                    }
                } else {
                    long l = variable.asLongArray(new int[]{(int)object2[1]})[0];
                    while (n11 < dArray.length) {
                        lArray[n11++] = bl2 ? l : lArray2[0];
                    }
                }
                break;
            }
            object2 = (ByteBuffer)objectArray2[0];
            int n13 = (Integer)objectArray2[1];
            bl2 = variable.missingRecordValueIsPrevious();
            if (n3 == n9) {
                bl2 = false;
            }
            if (!bl2) {
                if (!bl) {
                    while (n11 < n13 - n4) {
                        dArray[n11++] = dArray2[0];
                    }
                } else {
                    while (n11 < n13 - n4) {
                        lArray[n11++] = lArray2[0];
                    }
                }
            } else if (!bl) {
                double d = variable.asDoubleArray(new int[]{n12})[0];
                while (n11 < n13 - n4) {
                    dArray[n11++] = d;
                }
            } else {
                long l = variable.asLongArray(new int[]{n12})[0];
                while (n11 < n13 - n4) {
                    lArray[n11++] = l;
                }
            }
            n12 = (Integer)objectArray2[2];
            switch (DataTypes.typeCategory[n8]) {
                case 0: {
                    FloatBuffer floatBuffer = ((ByteBuffer)object2).asFloatBuffer();
                    while (n11 <= n12 - n4) {
                        dArray[n11++] = floatBuffer.get();
                    }
                    break;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = ((ByteBuffer)object2).asDoubleBuffer();
                    while (n11 <= n12 - n4) {
                        dArray[n11++] = doubleBuffer.get();
                    }
                    break;
                }
                case 2: {
                    Method method = DataTypes.method[n8];
                    while (n11 <= n12 - n4) {
                        Number number = (Number)method.invoke(object2, new Object[0]);
                        dArray[n11++] = number.doubleValue();
                    }
                    break;
                }
                case 3: {
                    Object object3;
                    Method method = DataTypes.method[n8];
                    long l = DataTypes.longInt[n8];
                    while (n11 <= n12 - n4) {
                        object3 = (Number)method.invoke(object2, new Object[0]);
                        int n14 = ((Number)object3).intValue();
                        dArray[n11++] = n14 >= 0 ? (double)n14 : (double)(l + (long)n14);
                    }
                    break;
                }
                case 5: {
                    Object object3 = ((ByteBuffer)object2).asLongBuffer();
                    while (n11 <= n12 - n4) {
                        lArray[n11++] = ((LongBuffer)object3).get();
                    }
                    break;
                }
            }
            if (n11 > n5 - n4) break;
            if (n3 != n10) continue;
            bl2 = variable.missingRecordValueIsPrevious();
            if (!bl) {
                double d = dArray[n11 - 1];
                while (n11 <= n5) {
                    dArray[n11++] = bl2 ? d : dArray2[0];
                }
            } else {
                long l = lArray[n11 - 1];
                while (n11 <= n5) {
                    lArray[n11++] = bl2 ? l : lArray2[0];
                }
            }
            break;
        }
        if (!variable.recordVariance()) {
            if (!bl) {
                for (n3 = n4; n3 <= n5; ++n3) {
                    dArray[n3] = dArray[0];
                }
            } else {
                for (n3 = n4; n3 <= n5; ++n3) {
                    lArray[n3] = lArray[0];
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static double[][] getRange1(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2) throws Throwable {
        int n3;
        int n4 = variable.getType();
        if (DataTypes.typeCategory[n4] == 5) {
            throw new Throwable("Long type not supported in this context");
        }
        int n5 = n;
        int n6 = n2;
        int n7 = variable.getNumberOfValues();
        int n8 = variable.getDataItemSize();
        int n9 = (Integer)Extractor.elementCount(variable).elementAt(0);
        double[][] dArray = new double[n6 - n5 + 1][n9];
        double[] dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        int[] nArray = null;
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        if (vector != null) {
            nArray = Extractor.getBlockRange(vector, variable.recordVariance(), n5, n6);
        }
        boolean bl = variable.missingRecordValueIsPrevious();
        if (nArray == null) {
            int n10;
            int n11;
            if (vector != null) {
                n11 = variable.getRecordRange()[1];
                n10 = 0;
                if (bl && n5 > n11) {
                    double[] dArray3 = variable.asDoubleArray(new int[]{n11});
                    for (int i = n5; i <= n6; ++i) {
                        dArray[n10++] = dArray3;
                    }
                    return dArray;
                }
            }
            if (vector != null && !variable.missingRecordValueIsPad() && !variable.missingRecordValueIsPrevious()) {
                return null;
            }
            n11 = 0;
            for (n10 = n5; n10 <= n6; ++n10) {
                dArray[n11++] = dArray2;
            }
            return dArray;
        }
        int n12 = nArray[0];
        int n13 = nArray[1];
        int n14 = 0;
        for (n3 = n12; n3 <= n13; ++n3) {
            Object object;
            Object[] objectArray = Extractor.positionBuffer(cDFImpl, variable, nArray, n3, n5, n6);
            if (objectArray == null) {
                if (bl) {
                    object = (int[])vector.get(n3 - 1);
                    double[] dArray4 = variable.asDoubleArray(new int[]{(int)object[1]});
                    while (n14 < dArray.length) {
                        dArray[n14] = dArray4;
                        ++n14;
                    }
                } else {
                    while (n14 < dArray.length) {
                        dArray[n14] = dArray2;
                        ++n14;
                    }
                }
            } else {
                object = (ByteBuffer)objectArray[0];
                int n15 = (Integer)objectArray[1];
                int n16 = (Integer)objectArray[2];
                while (n14 < n15 - n5) {
                    for (int i = 0; i < n9; ++i) {
                        dArray[n14][i] = dArray2[i];
                    }
                    ++n14;
                }
                switch (DataTypes.typeCategory[n4]) {
                    case 0: {
                        FloatBuffer floatBuffer = ((ByteBuffer)object).asFloatBuffer();
                        while (n14 <= n16 - n5) {
                            for (int i = 0; i < n9; ++i) {
                                dArray[n14][i] = floatBuffer.get();
                            }
                            ++n14;
                        }
                        break;
                    }
                    case 1: {
                        DoubleBuffer doubleBuffer = ((ByteBuffer)object).asDoubleBuffer();
                        while (n14 <= n16 - n5) {
                            for (int i = 0; i < n9; ++i) {
                                dArray[n14][i] = doubleBuffer.get();
                            }
                            ++n14;
                        }
                        break;
                    }
                    case 2: {
                        Extractor.doSignedInteger((ByteBuffer)object, n4, n15 - n5, n16 - n5, n9, dArray);
                        n14 += n16 - n15 + 1;
                        break;
                    }
                    case 3: {
                        Extractor.doUnsignedInteger((ByteBuffer)object, n4, n15 - n5, n16 - n5, n9, dArray);
                        n14 += n16 - n15 + 1;
                        break;
                    }
                    default: {
                        throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
                    }
                }
                if (n14 > n6 - n5) break;
                if (n3 != n13) continue;
                bl = variable.missingRecordValueIsPrevious();
                double[] dArray5 = dArray[n14 - 1];
                while (n14 <= n6 - n5) {
                    dArray[n14] = bl ? dArray5 : dArray2;
                    ++n14;
                }
            }
            break;
        }
        if (!variable.recordVariance()) {
            for (n3 = n5; n3 <= n6; ++n3) {
                for (int i = 0; i < n9; ++i) {
                    dArray[n3 - n5][i] = dArray[0][i];
                }
            }
        }
        return dArray;
    }

    static Vector elementCount(Variable variable) {
        int[] nArray = variable.getDimensions();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            if (!variable.getVarys()[i]) continue;
            vector.add(new Integer(nArray[i]));
        }
        return vector;
    }

    public static boolean validElement(Variable variable, int[] nArray) {
        int n = (Integer)Extractor.elementCount(variable).elementAt(0);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] < n) continue;
            return false;
        }
        return true;
    }

    public static Object getRangeForElement1(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2, Integer n3) throws Throwable {
        int n4;
        int n5 = n3;
        if (!Extractor.validElement(variable, new int[]{n5})) {
            return null;
        }
        int n6 = n;
        int n7 = n2;
        if (variable.isMissingRecords()) {
            return cDFImpl.getRange(variable.getName(), n6, n7, n5);
        }
        int n8 = variable.getNumberOfValues();
        int n9 = variable.getDataItemSize();
        int n10 = variable.getType();
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        double[] dArray2 = null;
        long[] lArray2 = null;
        if (DataTypes.typeCategory[n10] == 5) {
            lArray = new long[n7 - n6 + 1];
            bl = true;
            lArray2 = (long[])Extractor.getPadValue(cDFImpl, variable);
        } else {
            dArray = new double[n7 - n6 + 1];
            dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        }
        int n11 = n5 * DataTypes.size[n10];
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int[] nArray = Extractor.getBlockRange(vector, variable.recordVariance(), n6, n7);
        int n12 = nArray[0];
        int n13 = nArray[1];
        int n14 = 0;
        for (n4 = n12; n4 <= n13; ++n4) {
            Object[] objectArray = Extractor.positionBuffer(cDFImpl, variable, nArray, n4, n6, n7);
            if (objectArray == null) {
                if (!bl) {
                    while (n14 < dArray.length) {
                        dArray[n14++] = dArray2[n5];
                    }
                } else {
                    while (n14 < lArray.length) {
                        lArray[n14++] = lArray2[n5];
                    }
                }
                break;
            }
            ByteBuffer byteBuffer = (ByteBuffer)objectArray[0];
            int n15 = (Integer)objectArray[1];
            if (!bl) {
                while (n14 < n15 - n6) {
                    dArray[n14++] = dArray2[n5];
                }
            } else {
                while (n14 < n15 - n6) {
                    lArray[n14++] = lArray2[n5];
                }
            }
            int n16 = (Integer)objectArray[2];
            int n17 = byteBuffer.position() + n11;
            switch (DataTypes.typeCategory[n10]) {
                case 0: {
                    while (n14 <= n16 - n6) {
                        dArray[n14++] = byteBuffer.getFloat(n17);
                        n17 += n9;
                    }
                    break;
                }
                case 1: {
                    while (n14 <= n16 - n6) {
                        dArray[n14++] = byteBuffer.getDouble(n17);
                        n17 += n9;
                    }
                    break;
                }
                case 2: {
                    Extractor.doSignedInteger(byteBuffer, n17, n10, n9, n15 - n6, n16 - n6, dArray);
                    n14 += n16 - n15 + 1;
                    break;
                }
                case 3: {
                    Extractor.doUnsignedInteger(byteBuffer, n17, n10, n9, n15 - n6, n16 - n6, dArray);
                    n14 += n16 - n15 + 1;
                    break;
                }
                case 5: {
                    while (n14 <= n16 - n6) {
                        lArray[n14++] = byteBuffer.getLong(n17);
                        n17 += n9;
                    }
                    break;
                }
            }
            if (n14 > n7 - n6) break;
            if (n4 != n13) continue;
            if (!bl) {
                while (n14 < dArray.length) {
                    dArray[n14++] = dArray2[n5];
                }
            } else {
                while (n14 < lArray.length) {
                    lArray[n14++] = lArray2[n5];
                }
            }
            break;
        }
        if (!variable.recordVariance()) {
            if (!bl) {
                for (n4 = n6; n4 <= n7; ++n4) {
                    dArray[n4 - n6] = dArray[0];
                }
            } else {
                for (n4 = n6; n4 <= n7; ++n4) {
                    lArray[n4 - n6] = lArray[0];
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static Object getRangeForElements1(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2, int[] nArray) throws Throwable {
        int n3;
        if (!Extractor.validElement(variable, nArray)) {
            return null;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = variable.getNumberOfValues();
        int n7 = variable.getDataItemSize();
        int n8 = nArray.length;
        int n9 = variable.getType();
        long[][] lArray = null;
        double[][] dArray = null;
        boolean bl = false;
        double[] dArray2 = null;
        long[] lArray2 = null;
        if (DataTypes.typeCategory[n9] == 5) {
            lArray = new long[n5 - n4 + 1][n8];
            bl = true;
            lArray2 = (long[])Extractor.getPadValue(cDFImpl, variable);
        } else {
            dArray = new double[n5 - n4 + 1][n8];
            dArray2 = (double[])Extractor.getPadValue(cDFImpl, variable);
        }
        int[] nArray2 = new int[n8];
        for (int i = 0; i < n8; ++i) {
            nArray2[i] = nArray[i] * DataTypes.size[n9];
        }
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int[] nArray3 = Extractor.getBlockRange(vector, variable.recordVariance(), n4, n5);
        int n10 = nArray3[0];
        int n11 = nArray3[1];
        int n12 = 0;
        block8: for (n3 = n10; n3 <= n11; ++n3) {
            Object[] objectArray = Extractor.positionBuffer(cDFImpl, variable, nArray3, n3, n4, n5);
            if (objectArray == null) {
                if (!bl) {
                    while (n12 < dArray.length) {
                        for (int i = 0; i < n8; ++i) {
                            dArray[n12][i] = dArray2[nArray[i]];
                        }
                        ++n12;
                    }
                } else {
                    while (n12 < lArray.length) {
                        for (int i = 0; i < n8; ++i) {
                            lArray[n12][i] = lArray2[nArray[i]];
                        }
                        ++n12;
                    }
                }
                break;
            }
            ByteBuffer byteBuffer = (ByteBuffer)objectArray[0];
            int n13 = (Integer)objectArray[1];
            int n14 = (Integer)objectArray[2];
            int n15 = byteBuffer.position();
            switch (DataTypes.typeCategory[n9]) {
                case 0: {
                    int n16;
                    int n17;
                    for (n17 = n13; n17 <= n14; ++n17) {
                        for (n16 = 0; n16 < n8; ++n16) {
                            dArray[n12][n16] = byteBuffer.getFloat(n15 + nArray2[n16]);
                        }
                        n15 += n7;
                        ++n12;
                    }
                    continue block8;
                }
                case 1: {
                    int n16;
                    int n17;
                    for (n17 = n13; n17 <= n14; ++n17) {
                        for (n16 = 0; n16 < n8; ++n16) {
                            dArray[n12][n16] = byteBuffer.getDouble(n15 + nArray2[n16]);
                        }
                        n15 += n7;
                        ++n12;
                    }
                    continue block8;
                }
                case 2: {
                    n12 = Extractor.doSignedInteger(byteBuffer, n15, n9, n7, n13, n14, nArray2, dArray, n12);
                    continue block8;
                }
                case 3: {
                    n12 = Extractor.doUnsignedInteger(byteBuffer, n15, n9, n7, n13, n14, nArray2, dArray, n12);
                    continue block8;
                }
                case 5: {
                    int n16;
                    int n17;
                    for (n17 = n13; n17 <= n14; ++n17) {
                        for (n16 = 0; n16 < n8; ++n16) {
                            lArray[n12][n16] = byteBuffer.getLong(n15 + nArray2[n16]);
                        }
                        n15 += n7;
                        ++n12;
                    }
                    continue block8;
                }
            }
        }
        if (!variable.recordVariance()) {
            if (!bl) {
                for (n3 = n4; n3 <= n5; ++n3) {
                    for (int i = 0; i < n8; ++i) {
                        dArray[n3 - n4][i] = dArray[0][i];
                    }
                }
            } else {
                for (n3 = n4; n3 <= n5; ++n3) {
                    for (int i = 0; i < n8; ++i) {
                        lArray[n3 - n4][i] = lArray[0][i];
                    }
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static String getStringValue(ByteBuffer byteBuffer, int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = byteBuffer.get();
            if (byArray[n2] == 0) break;
        }
        return new String(byArray, 0, n2);
    }

    public static String[] getStringSeries0(CDFImpl cDFImpl, Variable variable) {
        int n;
        int n2 = variable.getNumberOfValues();
        String[] stringArray = new String[n2];
        int n3 = variable.getNumberOfElements();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        for (n = 0; n < vector.size(); ++n) {
            long[] lArray = (long[])vector.elementAt(n);
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], (int)(lArray[1] - lArray[0] + 1L));
            int n4 = byteBuffer.position();
            for (int i = (int)lArray[0]; i <= (int)lArray[1]; ++i) {
                stringArray[i] = Extractor.getStringValue(byteBuffer, n3);
                byteBuffer.position(n4 += n3);
            }
        }
        if (!variable.recordVariance()) {
            for (n = 1; n < n2; ++n) {
                stringArray[n] = stringArray[0];
            }
        }
        return stringArray;
    }

    public static String[][] getStringSeries1(CDFImpl cDFImpl, Variable variable) {
        int n = variable.getNumberOfValues();
        if (n == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n = 1;
        }
        int n2 = (Integer)Extractor.elementCount(variable).elementAt(0);
        String[][] stringArray = new String[n][n2];
        int n3 = variable.getDataItemSize();
        int n4 = variable.getNumberOfElements();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], (int)(lArray[1] - lArray[0] + 1L));
            int n5 = byteBuffer.position();
            for (int j = (int)lArray[0]; j <= (int)lArray[1]; ++j) {
                for (int k = 0; k < n2; ++k) {
                    stringArray[j][k] = Extractor.getStringValue(byteBuffer, n4);
                    byteBuffer.position(n5 += n4);
                }
            }
        }
        return stringArray;
    }

    public static String[][][] getStringSeries2(CDFImpl cDFImpl, Variable variable) {
        return null;
    }

    public static int[] getBlockRange(Vector vector, boolean bl, int n, int n2) {
        int n3;
        int n4;
        if (bl) {
            long[] lArray;
            int n5;
            if ((long)n2 < ((long[])vector.get(0))[0]) {
                return null;
            }
            n4 = vector.size() - 1;
            if ((long)n > ((long[])vector.get(n4))[1]) {
                return null;
            }
            n3 = -1;
            for (n5 = 0; n5 < vector.size(); ++n5) {
                lArray = (long[])vector.get(n5);
                if ((long)n > lArray[1]) continue;
                n3 = n5;
                break;
            }
            if (n3 < 0) {
                return null;
            }
            for (n5 = n3; n5 < vector.size(); ++n5) {
                lArray = (long[])vector.get(n5);
                n4 = n5;
                if ((long)n2 > lArray[1] && (n5 >= vector.size() - 1 || (long)n2 >= ((long[])vector.get(n5 + 1))[0])) {
                    continue;
                }
                break;
            }
        } else {
            n3 = 0;
            n4 = 0;
        }
        return new int[]{n3, n4};
    }

    static ByteBuffer positionBuffer(CDFImpl cDFImpl, Variable variable, long l, int n) {
        ByteBuffer byteBuffer;
        if (!variable.isCompressed()) {
            byteBuffer = cDFImpl.getValueBuffer(l);
        } else {
            int n2 = variable.getDataItemSize();
            byteBuffer = cDFImpl.getValueBuffer(l, n2, n);
        }
        byteBuffer.order(cDFImpl.getByteOrder());
        return byteBuffer;
    }

    static Object[] positionBuffer(CDFImpl cDFImpl, Variable variable, int[] nArray, int n, int n2, int n3) {
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        long[] lArray = (long[])vector.elementAt(n);
        int n4 = (int)lArray[0];
        int n5 = (int)lArray[1];
        ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], n5 - n4 + 1);
        if (variable.recordVariance()) {
            if (n == nArray[0]) {
                int n6 = variable.getDataItemSize();
                if (n2 > n4) {
                    byteBuffer.position(byteBuffer.position() + n6 * (n2 - n4));
                    n4 = n2;
                } else if (n3 < n4) {
                    return null;
                }
            }
            if (n == nArray[1] && n5 > n3) {
                n5 = n3;
            }
        }
        return new Object[]{byteBuffer, new Integer(n4), new Integer(n5)};
    }

    public static double[][][][] getSeries3(CDFImpl cDFImpl, Variable variable) throws Throwable {
        int n = variable.getType();
        if (DataTypes.typeCategory[n] == 5) {
            throw new Throwable("Only scalar variables of type int8 are supported at this time.");
        }
        int n2 = variable.getNumberOfValues();
        if (n2 == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n2 = 1;
        }
        int n3 = (Integer)Extractor.elementCount(variable).elementAt(0);
        int n4 = (Integer)Extractor.elementCount(variable).elementAt(1);
        int n5 = (Integer)Extractor.elementCount(variable).elementAt(2);
        double[][][][] dArray = new double[n2][n3][n4][n5];
        double[] dArray2 = (double[])Extractor.getFillValue(cDFImpl, variable);
        double d = dArray2[0] != 0.0 ? Double.NaN : dArray2[1];
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n7;
            int n8;
            int n9;
            long[] lArray = (long[])vector.elementAt(i);
            int n10 = (int)lArray[0];
            int n11 = (int)lArray[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], n11 - n10 + 1);
            if (variable.rowMajority()) {
                for (n9 = n6; n9 < n10; ++n9) {
                    for (int j = 0; j < n3; ++j) {
                        for (n8 = 0; n8 < n4; ++n8) {
                            for (n7 = 0; n7 < n5; ++n7) {
                                dArray[n9][j][n8][n7] = d;
                            }
                        }
                    }
                }
            } else {
                for (n9 = n6; n9 < n10; ++n9) {
                    for (int j = 0; j < n5; ++j) {
                        for (int k = 0; k < n4; ++k) {
                            for (int i2 = 0; i2 < n3; ++i2) {
                                dArray[n9][i2][k][j] = d;
                            }
                        }
                    }
                }
            }
            switch (DataTypes.typeCategory[n]) {
                case 0: {
                    int n12;
                    int n13;
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    if (variable.rowMajority()) {
                        float[] fArray = new float[n5];
                        for (n8 = n10; n8 <= n11; ++n8) {
                            for (n7 = 0; n7 < n3; ++n7) {
                                for (n13 = 0; n13 < n4; ++n13) {
                                    floatBuffer.get(fArray);
                                    for (n12 = 0; n12 < n5; ++n12) {
                                        dArray[n8][n7][n13][n12] = fArray[n12];
                                    }
                                }
                            }
                        }
                    } else {
                        float[] fArray = new float[n3];
                        for (n8 = n10; n8 <= n11; ++n8) {
                            for (n7 = 0; n7 < n5; ++n7) {
                                for (n13 = 0; n13 < n4; ++n13) {
                                    floatBuffer.get(fArray);
                                    for (n12 = 0; n12 < n3; ++n12) {
                                        dArray[n8][n12][n13][n7] = fArray[n12];
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    int n14;
                    int n12;
                    int n13;
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    if (variable.rowMajority()) {
                        double[] dArray3 = new double[n5];
                        for (n7 = n10; n7 <= n11; ++n7) {
                            for (n13 = 0; n13 < n3; ++n13) {
                                for (n12 = 0; n12 < n4; ++n12) {
                                    doubleBuffer.get(dArray3);
                                    for (n14 = 0; n14 < n5; ++n14) {
                                        dArray[n7][n13][n12][n14] = dArray3[n14];
                                    }
                                }
                            }
                        }
                    } else {
                        double[] dArray4 = new double[n3];
                        for (n7 = n10; n7 <= n11; ++n7) {
                            for (n13 = 0; n13 < n5; ++n13) {
                                for (n12 = 0; n12 < n4; ++n12) {
                                    doubleBuffer.get(dArray4);
                                    for (n14 = 0; n14 < n3; ++n14) {
                                        dArray[n7][n14][n12][n13] = dArray4[n14];
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    int n14;
                    int n12;
                    int n13;
                    Method method = DataTypes.method[n];
                    if (variable.rowMajority()) {
                        for (n7 = n10; n7 <= n11; ++n7) {
                            for (n13 = 0; n13 < n3; ++n13) {
                                for (n12 = 0; n12 < n4; ++n12) {
                                    for (n14 = 0; n14 < n5; ++n14) {
                                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                        dArray[n7][n13][n12][n14] = number.doubleValue();
                                    }
                                }
                            }
                        }
                    } else {
                        for (n7 = n10; n7 <= n11; ++n7) {
                            for (n13 = 0; n13 < n5; ++n13) {
                                for (n12 = 0; n12 < n4; ++n12) {
                                    for (n14 = 0; n14 < n3; ++n14) {
                                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                        dArray[n7][n14][n12][n13] = number.doubleValue();
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    int n15;
                    Number number;
                    int n16;
                    int n17;
                    int n14;
                    int n12;
                    Method method = DataTypes.method[n];
                    long l = DataTypes.longInt[n];
                    if (variable.rowMajority()) {
                        for (n12 = n10; n12 <= n11; ++n12) {
                            for (n14 = 0; n14 < n3; ++n14) {
                                for (n17 = 0; n17 < n4; ++n17) {
                                    for (n16 = 0; n16 < n5; ++n16) {
                                        number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                        n15 = number.intValue();
                                        dArray[n12][n14][n17][n16] = n15 >= 0 ? (double)n15 : (double)(l + (long)n15);
                                    }
                                }
                            }
                        }
                    } else {
                        for (n12 = n10; n12 <= n11; ++n12) {
                            for (n14 = 0; n14 < n5; ++n14) {
                                for (n17 = 0; n17 < n4; ++n17) {
                                    for (n16 = 0; n16 < n3; ++n16) {
                                        number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                        n15 = number.intValue();
                                        dArray[n12][n16][n17][n14] = n15 >= 0 ? (double)n15 : (double)(l + (long)n15);
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
                }
            }
            n6 = n11 + 1;
        }
        return dArray;
    }

    public static double[][][] getPoint3(CDFImpl cDFImpl, Variable variable, Integer n) throws Throwable {
        int n2 = n;
        int n3 = variable.getType();
        int n4 = variable.getDataItemSize();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            if (lArray[1] < (long)n2) continue;
            if (lArray[0] > (long)n2) {
                return null;
            }
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], (int)(lArray[1] - lArray[0] + 1L));
            int n5 = byteBuffer.position() + (n2 - (int)lArray[0]) * n4;
            byteBuffer.position(n5);
            int n6 = (Integer)Extractor.elementCount(variable).elementAt(0);
            int n7 = (Integer)Extractor.elementCount(variable).elementAt(1);
            int n8 = (Integer)Extractor.elementCount(variable).elementAt(2);
            double[][][] dArray = new double[n6][n7][n8];
            switch (DataTypes.typeCategory[n3]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i2 = 0; i2 < n8; ++i2) {
                                    dArray[j][k][i2] = floatBuffer.get();
                                }
                            }
                        }
                    } else {
                        for (int j = 0; j < n8; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i3 = 0; i3 < n6; ++i3) {
                                    dArray[i3][k][j] = floatBuffer.get();
                                }
                            }
                        }
                    }
                    return dArray;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i4 = 0; i4 < n8; ++i4) {
                                    dArray[j][k][i4] = doubleBuffer.get();
                                }
                            }
                        }
                    } else {
                        for (int j = 0; j < n8; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i5 = 0; i5 < n6; ++i5) {
                                    dArray[i5][k][j] = doubleBuffer.get();
                                }
                            }
                        }
                    }
                    return dArray;
                }
                case 2: {
                    Method method = DataTypes.method[n3];
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i6 = 0; i6 < n8; ++i6) {
                                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                    dArray[j][k][i6] = number.doubleValue();
                                }
                            }
                        }
                    } else {
                        for (int j = 0; j < n8; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i7 = 0; i7 < n6; ++i7) {
                                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                    dArray[i7][k][j] = number.doubleValue();
                                }
                            }
                        }
                    }
                    return dArray;
                }
                case 3: {
                    Method method = DataTypes.method[n3];
                    long l = DataTypes.longInt[n3];
                    if (variable.rowMajority()) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i8 = 0; i8 < n8; ++i8) {
                                    double d;
                                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                    int n9 = number.intValue();
                                    dArray[j][k][i8] = d = n9 >= 0 ? (double)n9 : (double)(l + (long)n9);
                                }
                            }
                        }
                    } else {
                        for (int j = 0; j < n8; ++j) {
                            for (int k = 0; k < n7; ++k) {
                                for (int i9 = 0; i9 < n6; ++i9) {
                                    double d;
                                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                                    int n10 = number.intValue();
                                    dArray[i9][k][j] = d = n10 >= 0 ? (double)n10 : (double)(l + (long)n10);
                                }
                            }
                        }
                    }
                    return dArray;
                }
            }
            throw new Throwable(variable.getName() + " has unsupported type " + "in this context.");
        }
        return null;
    }

    public static double[] get1DSeries(CDFImpl cDFImpl, Variable variable, int[] nArray) throws Throwable {
        return (double[])Extractor.get1DSeries(cDFImpl, variable, nArray, false);
    }

    static void do1D(ByteBuffer byteBuffer, int n, Object object, Object object2, int n2, int n3, boolean bl, int[] nArray) throws Throwable {
        Extractor.do1D(byteBuffer, n, object, object2, n2, n3, false, bl, nArray);
    }

    static void do1D(ByteBuffer byteBuffer, int n, Object object, Object object2, int n2, int n3, boolean bl, boolean bl2, int[] nArray) throws Throwable {
        if (nArray.length > 1 && bl2) {
            Extractor.do1DSwap(byteBuffer, n, object, object2, n2, n3, bl, nArray);
            return;
        }
        double[] dArray = null;
        if (DataTypes.typeCategory[n] != 5) {
            dArray = (double[])object2;
        }
        switch (DataTypes.typeCategory[n]) {
            case 0: {
                float[] fArray = new float[n3];
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                floatBuffer.get(fArray, 0, n3);
                for (int i = 0; i < n3; ++i) {
                    dArray[n2 + i] = fArray[i];
                }
                break;
            }
            case 1: {
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                doubleBuffer.get(dArray, n2, n3);
                break;
            }
            case 2: {
                Method method = DataTypes.method[n];
                for (int i = 0; i < n3; ++i) {
                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                    dArray[n2 + i] = number.doubleValue();
                }
                break;
            }
            case 3: {
                Method method = DataTypes.method[n];
                long l = DataTypes.longInt[n];
                for (int i = 0; i < n3; ++i) {
                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                    int n4 = number.intValue();
                    dArray[n2 + i] = n4 >= 0 ? (double)n4 : (double)(l + (long)n4);
                }
                break;
            }
            case 5: {
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                if (!bl) {
                    long[] lArray = new long[n3];
                    dArray = (double[])object2;
                    longBuffer.get(lArray, 0, n3);
                    for (int i = 0; i < n3; ++i) {
                        dArray[n2 + i] = lArray[i];
                    }
                    break;
                }
                long[] lArray = (long[])object2;
                longBuffer.get(lArray, n2, n3);
            }
        }
    }

    public static Object get1DSeries(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl) throws Throwable {
        return Extractor.get1DSeries(cDFImpl, variable, nArray, bl, false);
    }

    public static Object get1DSeries(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl, boolean bl2) throws Throwable {
        int n;
        int n2;
        int n3;
        boolean bl3;
        int n4 = 0;
        int n5 = variable.getNumberOfValues();
        int n6 = variable.getType();
        boolean bl4 = bl3 = DataTypes.typeCategory[n6] == 5;
        if (n5 == 0) {
            if (bl3) {
                return new long[0];
            }
            if (!bl3) {
                return new double[0];
            }
        }
        int[] nArray2 = variable.getEffectiveDimensions();
        int n7 = n5 - 1;
        if (nArray != null && variable.recordVariance()) {
            n4 = nArray[0];
            if (n4 < 0) {
                n4 = 0;
            }
            if (nArray.length > 1) {
                if (nArray[1] < n7) {
                    n7 = nArray[1];
                }
                n5 = n7 - n4 + 1;
            } else {
                n7 = -1;
                n5 = 1;
            }
        }
        if (!variable.recordVariance()) {
            n5 = 1;
        }
        long[] lArray = null;
        double[] dArray = null;
        int n8 = variable.getDataItemSize();
        int n9 = n8 / DataTypes.size[n6];
        double d = Double.NEGATIVE_INFINITY;
        long l = Long.MIN_VALUE;
        if (bl3 && bl) {
            lArray = new long[n5 * n9];
        } else {
            dArray = new double[n5 * n9];
        }
        Object var19_17 = null;
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        if (n4 > 0) {
            for (n3 = 0; n3 < vector.size(); ++n3) {
                long[] lArray2 = (long[])vector.elementAt(n3);
                n2 = (int)lArray2[0];
                n = (int)lArray2[1];
                if (n >= n4) break;
                if (n3 < vector.size() - 1) continue;
                if (bl3 && bl) {
                    Extractor.do1DMissing(lArray, l);
                    return lArray;
                }
                Extractor.do1DMissing(dArray, d);
                return dArray;
            }
            if (n3 == vector.size()) {
                return null;
            }
        }
        boolean bl5 = true;
        n2 = n4;
        n = 0;
        int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
        if (bl2 && !variable.rowMajority()) {
            nArray3 = new int[nArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray3[i] = nArray2[nArray2.length - 1 - i];
            }
        }
        while (n3 < vector.size()) {
            int n10;
            long[] lArray3 = (long[])vector.elementAt(n3);
            int n11 = (int)lArray3[0];
            int n12 = (int)lArray3[1];
            int n13 = n12 - n11 + 1;
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray3[2], n13);
            if (bl5) {
                if (nArray != null) {
                    if (n4 > n11) {
                        n10 = byteBuffer.position() + (n4 - n11) * n8;
                        byteBuffer.position(n10);
                    }
                    if (n7 < 0) {
                        int n14 = n10 = n4 >= n11 ? 1 : 0;
                        if (bl3 && bl) {
                            if (n10 != 0) {
                                Extractor.do1D(byteBuffer, n6, var19_17, lArray, 0, n9, bl, bl2, nArray3);
                            } else {
                                Extractor.do1DMissing(lArray, l, 0, n9);
                            }
                            return lArray;
                        }
                        if (n10 != 0) {
                            Extractor.do1D(byteBuffer, n6, var19_17, (Object)dArray, 0, n9, bl2, nArray3);
                        } else {
                            Extractor.do1DMissing(dArray, d);
                        }
                        return dArray;
                    }
                }
                bl5 = false;
            }
            if (n2 < n11) {
                n10 = n7 >= n11 ? n11 : n7 + 1;
                int n15 = n10 * n9;
                int n16 = n2 * n9;
                int n17 = n15 - n16;
                if (bl3 && bl) {
                    Extractor.do1DMissing(lArray, l, n, n17);
                } else {
                    Extractor.do1DMissing(dArray, d, n, n17);
                }
                n += n15 - n16;
                if (n10 > n7) break;
                n2 = n11;
            }
            n10 = n7 <= n12 ? n7 : n12;
            n13 = n10 - n2 + 1;
            if (bl3 && bl) {
                Extractor.do1D(byteBuffer, n6, var19_17, lArray, n, n13 * n9, bl, bl2, nArray3);
            } else {
                Extractor.do1D(byteBuffer, n6, var19_17, (Object)dArray, n, n13 * n9, bl2, nArray3);
            }
            n2 += n13;
            n += n13 * n9;
            if (n7 == n10) break;
            if (n3 == vector.size() - 1) {
                if (bl3 && bl) {
                    Extractor.do1DMissing(lArray, l, n);
                    break;
                }
                Extractor.do1DMissing(dArray, d, n);
                break;
            }
            ++n3;
        }
        if (n == 0) {
            return null;
        }
        if (bl3 && bl) {
            return lArray;
        }
        return dArray;
    }

    public static void do1DMissing(long[] lArray, long l, int n, int n2) {
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            lArray[n3++] = l;
        }
    }

    public static void do1DMissing(long[] lArray, long l) {
        Extractor.do1DMissing(lArray, l, 0, lArray.length);
    }

    public static void do1DMissing(long[] lArray, long l, int n) {
        Extractor.do1DMissing(lArray, l, n, lArray.length - n);
    }

    public static void do1DMissing(double[] dArray, double d, int n, int n2) {
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            dArray[n3++] = d;
        }
    }

    public static void do1DMissing(double[] dArray, double d) {
        Extractor.do1DMissing(dArray, d, 0, dArray.length);
    }

    public static void do1DMissing(double[] dArray, double d, int n) {
        Extractor.do1DMissing(dArray, d, n, dArray.length - n);
    }

    public static double[] get1DSeries(CDFImpl cDFImpl, Variable variable, int[] nArray, int[] nArray2) throws IllegalAccessException, InvocationTargetException, Throwable {
        int n;
        Stride stride;
        int n2;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        if (nArray != null) {
            if (variable.recordVariance()) {
                n4 = nArray[0];
                n5 = 1;
                if (nArray.length > 1) {
                    n3 = nArray[1];
                    n5 = n3 - n4 + 1;
                }
            }
        } else {
            n5 = variable.getNumberOfValues();
        }
        if (n5 == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n5 = 1;
        }
        if ((n2 = (stride = new Stride(nArray2)).getStride(n5)) > 1) {
            n = n5;
            n5 /= n2;
            if (n % n2 != 0) {
                ++n5;
            }
        }
        n = variable.getType();
        int n6 = variable.getDataItemSize();
        int n7 = n6 / DataTypes.size[n];
        double[] dArray = new double[n5 * n7];
        float[] fArray = null;
        if (n2 == 1 && DataTypes.typeCategory[n] == 0) {
            fArray = new float[n5 * n7];
        }
        int[] nArray3 = variable.getEffectiveDimensions();
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n8 = 0;
        int n9 = 0;
        if (nArray == null) {
            n4 = (int)((long[])vector.elementAt(0))[0];
            n3 = (int)((long[])vector.elementAt(vector.size() - 1))[1];
        }
        boolean bl = false;
        while (n8 < vector.size()) {
            long[] lArray = (long[])vector.elementAt(n8);
            int n10 = (int)lArray[0];
            int n11 = (int)lArray[1];
            if (n11 >= n4) {
                int n12;
                int n13;
                int n14 = n11 - n10 + 1;
                ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], n14);
                int n15 = 0;
                if (n4 > n10) {
                    n13 = n4;
                } else {
                    n13 = n10;
                    if (n2 > 1 && (n12 = n10 - n4) % n2 != 0) {
                        n13 = n10 - n12 % n2 + n2;
                    }
                }
                n15 = byteBuffer.position() + (n13 - n10) * n6;
                byteBuffer.position(n15);
                if (n3 < 0) {
                    Extractor.do1D(byteBuffer, n, (Object)fArray, (Object)dArray, 0, n7, false, nArray3);
                    n9 += n7;
                } else {
                    n12 = n3 <= n11 ? n3 : n11;
                    int n16 = n12 - n13 + 1;
                    if (n2 == 1) {
                        n14 = n16;
                        Extractor.do1D(byteBuffer, n, (Object)fArray, (Object)dArray, n9, n14 * n7, false, nArray3);
                    } else {
                        n14 = n16 / n2;
                        if (n14 * n2 < n16) {
                            ++n14;
                        }
                        if (DataTypes.typeCategory[n] == 0) {
                            fArray = new float[n14 * n7];
                        }
                        Extractor.do1D(byteBuffer, n, fArray, dArray, n9, n14, n7, n2);
                    }
                    n9 += n14 * n7;
                }
                if (n3 <= n11) break;
            }
            ++n8;
        }
        if (n9 == 0) {
            return null;
        }
        return dArray;
    }

    static void do1D(ByteBuffer byteBuffer, int n, float[] fArray, double[] dArray, int n2, int n3, int n4, int n5) throws IllegalAccessException, InvocationTargetException, Throwable {
        int n6 = n5 * n4;
        int n7 = byteBuffer.position();
        switch (DataTypes.typeCategory[n]) {
            case 0: {
                int n8;
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                for (n8 = 0; n8 < n3; ++n8) {
                    floatBuffer.position(n8 * n6);
                    floatBuffer.get(fArray, n8 * n4, n4);
                }
                for (n8 = 0; n8 < n3 * n4; ++n8) {
                    dArray[n2 + n8] = fArray[n8];
                }
                break;
            }
            case 1: {
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                for (int i = 0; i < n3; ++i) {
                    doubleBuffer.position(i * n6);
                    doubleBuffer.get(dArray, n2, n4);
                    n2 += n4;
                }
                break;
            }
            case 2: {
                Method method = DataTypes.method[n];
                n6 *= DataTypes.size[n];
                for (int i = 0; i < n3; ++i) {
                    byteBuffer.position(n7 + i * n6);
                    for (int j = 0; j < n4; ++j) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        dArray[n2++] = number.doubleValue();
                    }
                }
                break;
            }
            case 3: {
                Method method = DataTypes.method[n];
                n6 *= DataTypes.size[n];
                long l = DataTypes.longInt[n];
                for (int i = 0; i < n3; ++i) {
                    byteBuffer.position(i * n6);
                    for (int j = 0; j < n4; ++j) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n9 = number.intValue();
                        dArray[n2++] = n9 >= 0 ? (double)n9 : (double)(l + (long)n9);
                    }
                }
                break;
            }
            default: {
                throw new Throwable("Unsupported data type for this context");
            }
        }
    }

    public static Object getSeries0(CDFImpl cDFImpl, Variable variable, Stride stride) throws IllegalAccessException, InvocationTargetException, Throwable {
        int n;
        int n2 = variable.getType();
        if (DataTypes.typeCategory[n2] == 4) {
            throw new Throwable("Type " + n2 + " not supported in this context");
        }
        int n3 = variable.getNumberOfValues();
        if (n3 == 0) {
            return null;
        }
        int n4 = stride.getStride(n3);
        int n5 = variable.getDataItemSize();
        int n6 = n4 * n5;
        if (n4 == 1) {
            return Extractor.getSeries0(cDFImpl, variable);
        }
        int n7 = n3 / n4;
        if (n7 * n4 < n3) {
            ++n7;
        }
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        if (DataTypes.typeCategory[n2] == 5) {
            lArray = new long[n7];
            bl = true;
        } else {
            dArray = new double[n7];
        }
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n8 = 0;
        block7: for (n = 0; n < vector.size(); ++n) {
            long[] lArray2 = (long[])vector.elementAt(n);
            int n9 = (int)lArray2[0];
            int n10 = (int)lArray2[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray2[2], n10 - n9 + 1);
            int n11 = n9 % n4;
            n11 = n11 == 0 ? n9 : n9 - n11 + n4;
            switch (DataTypes.typeCategory[n2]) {
                case 0: {
                    int n12;
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    for (n12 = n11 - n9; n12 <= n10; n12 += n4) {
                        dArray[n8++] = floatBuffer.get(n12);
                    }
                    continue block7;
                }
                case 1: {
                    int n12;
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    while (n12 <= n10) {
                        dArray[n8++] = doubleBuffer.get(n12);
                        n12 += n4;
                    }
                    continue block7;
                }
                case 2: {
                    int n12;
                    Method method = DataTypes.method[n2];
                    while (n12 <= n10) {
                        byteBuffer.position(n12 * n5);
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        dArray[n8++] = number.doubleValue();
                        n12 += n4;
                    }
                    continue block7;
                }
                case 3: {
                    Object object;
                    int n12;
                    Method method = DataTypes.method[n2];
                    long l = DataTypes.longInt[n2];
                    while (n12 <= n10) {
                        byteBuffer.position(n12 * n5);
                        object = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n13 = ((Number)object).intValue();
                        dArray[n8++] = n13 >= 0 ? (double)n13 : (double)(l + (long)n13);
                        n12 += n4;
                    }
                    continue block7;
                }
                case 5: {
                    int n12;
                    Object object = byteBuffer.asLongBuffer();
                    while (n12 <= n10) {
                        lArray[n8++] = ((LongBuffer)object).get(n12);
                        n12 += n4;
                    }
                    continue block7;
                }
                default: {
                    throw new Throwable("Unsupported data type for this context");
                }
            }
        }
        if (!variable.recordVariance()) {
            if (!bl) {
                for (n = 1; n < n7; ++n) {
                    dArray[n] = dArray[0];
                }
            } else {
                for (n = 1; n < n7; ++n) {
                    lArray[n] = lArray[0];
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static double[] getElement1(CDFImpl cDFImpl, Variable variable, Integer n, Stride stride) throws Throwable {
        int n2 = variable.getType();
        if (DataTypes.typeCategory[n2] == 5) {
            throw new Throwable("Only scalar variables of type int8 are supported at this time.");
        }
        int n3 = n;
        int n4 = variable.getNumberOfValues();
        if (n4 == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n4 = 1;
        }
        if (!Extractor.validElement(variable, new int[]{n3})) {
            return null;
        }
        int n5 = n4;
        int n6 = stride.getStride(n4);
        if (n6 != 1 && (n5 = n4 / n6) * n6 < n4) {
            ++n5;
        }
        double[] dArray = new double[n5];
        int n7 = variable.getDataItemSize();
        int n8 = n7 * n6;
        int n9 = n3 * DataTypes.size[n2];
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int n10 = 0;
        block6: for (int i = 0; i < vector.size(); ++i) {
            long[] lArray = (long[])vector.elementAt(i);
            int n11 = (int)lArray[0];
            int n12 = (int)lArray[1];
            ByteBuffer byteBuffer = Extractor.positionBuffer(cDFImpl, variable, lArray[2], n12 - n11 + 1);
            int n13 = n11 % n6;
            n13 = n13 == 0 ? n11 : n11 - n13 + n6;
            int n14 = byteBuffer.position() + (n13 - n11) * n7 + n9;
            switch (DataTypes.typeCategory[n2]) {
                case 0: {
                    while (n13 <= n12) {
                        dArray[n10++] = byteBuffer.getFloat(n14);
                        n13 += n6;
                        n14 += n8;
                    }
                    continue block6;
                }
                case 1: {
                    while (n13 <= n12) {
                        dArray[n10++] = byteBuffer.getDouble(n14);
                        n13 += n6;
                        n14 += n8;
                    }
                    continue block6;
                }
                case 2: {
                    int n15;
                    n10 = n15 = Extractor.doSignedInteger(byteBuffer, n14, n2, n7, n13, n12, dArray, new int[]{n6}, n10);
                    continue block6;
                }
                case 3: {
                    int n15;
                    n10 = n15 = Extractor.doUnsignedInteger(byteBuffer, n14, n2, n7, n13, n12, dArray, new int[]{n6}, n10);
                    continue block6;
                }
                default: {
                    throw new Throwable("Unsupported data type for this context");
                }
            }
        }
        return dArray;
    }

    static int doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray, int[] nArray, int n6) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        int n7 = n6;
        byteBuffer.position(n);
        int n8 = nArray[0];
        int n9 = n8 * n3;
        for (int i = n4; i <= n5; i += n8) {
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            dArray[n7++] = number.doubleValue();
            byteBuffer.position(n += n9);
        }
        return n7;
    }

    static int doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray, int[] nArray, int n6) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        long l = DataTypes.longInt[n2];
        int n7 = n6;
        byteBuffer.position(n);
        int n8 = nArray[0];
        int n9 = n8 * n3;
        int n10 = n4;
        while (n10 <= n5) {
            byteBuffer.position(n);
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            int n11 = number.intValue();
            dArray[n7++] = n11 >= 0 ? (double)n11 : (double)(l + (long)n11);
            n10 += n8;
            n += n9;
        }
        return n7;
    }

    public static Object getRange0(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2, Stride stride) throws Throwable {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n;
        if (n7 < 0) {
            throw new Throwable("getRange0 start < 0");
        }
        int n8 = n2;
        if (n8 > (n6 = variable.getNumberOfValues())) {
            throw new Throwable("getRange0 end > available " + n6);
        }
        if (n6 == 0) {
            return null;
        }
        if (!variable.recordVariance()) {
            n6 = 1;
        }
        if ((n5 = stride.getStride(n6 = n8 - n7 + 1)) > 1) {
            n4 = n6 / n5;
            if (n4 * n5 < n6) {
                ++n4;
            }
            n6 = n4;
        }
        n4 = variable.getType();
        int n9 = variable.getDataItemSize();
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        if (DataTypes.typeCategory[n4] == 5) {
            lArray = new long[n6];
            bl = true;
        } else {
            dArray = new double[n6];
        }
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int[] nArray = Extractor.getBlockRange(vector, variable.recordVariance(), n7, n8);
        int n10 = nArray[0];
        int n11 = nArray[1];
        int n12 = 0;
        block7: for (n3 = n10; n3 <= n11; ++n3) {
            int n13;
            int n14;
            Object[] objectArray = Extractor.positionBuffer(cDFImpl, variable, nArray, n3, n7, n8);
            ByteBuffer byteBuffer = (ByteBuffer)objectArray[0];
            int n15 = (Integer)objectArray[1];
            int n16 = (Integer)objectArray[2] - n15;
            if (n5 > 1 && n3 > n10 && (n14 = n15 - n7) % n5 > 0) {
                n13 = n5 - (n15 - n7) % n5;
                int n17 = byteBuffer.position() + n13 * n9;
                byteBuffer.position(n17);
                n16 -= n13;
            }
            switch (DataTypes.typeCategory[n4]) {
                case 0: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    for (n13 = 0; n13 <= n16; n13 += n5) {
                        dArray[n12++] = floatBuffer.get(n13);
                    }
                    continue block7;
                }
                case 1: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    while (n13 <= n16) {
                        dArray[n12++] = doubleBuffer.get();
                        n13 += n5;
                    }
                    continue block7;
                }
                case 2: {
                    Method method = DataTypes.method[n4];
                    while (n13 <= n16) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        dArray[n12++] = number.doubleValue();
                        n13 += n5;
                    }
                    continue block7;
                }
                case 3: {
                    Object object;
                    Method method = DataTypes.method[n4];
                    long l = DataTypes.longInt[n4];
                    while (n13 <= n16) {
                        object = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n18 = ((Number)object).intValue();
                        dArray[n12++] = n18 >= 0 ? (double)n18 : (double)(l + (long)n18);
                        n13 += n5;
                    }
                    continue block7;
                }
                case 5: {
                    Object object = byteBuffer.asLongBuffer();
                    while (n13 <= n16) {
                        lArray[n12++] = ((LongBuffer)object).get();
                        n13 += n5;
                    }
                    continue block7;
                }
                default: {
                    throw new Throwable("Unsupported data type for this context");
                }
            }
        }
        if (!variable.recordVariance()) {
            if (!bl) {
                for (n3 = n7; n3 <= n8; n3 += n5) {
                    dArray[n3 - n7] = dArray[0];
                }
            } else {
                for (n3 = n7; n3 <= n8; n3 += n5) {
                    lArray[n3 - n7] = lArray[0];
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    public static Object getRangeForElement1(CDFImpl cDFImpl, Variable variable, Integer n, Integer n2, Integer n3, Stride stride) throws Throwable {
        int n4;
        int n5;
        int n6;
        int n7 = n3;
        if (!Extractor.validElement(variable, new int[]{n7})) {
            return null;
        }
        int n8 = n;
        int n9 = n2;
        if (n9 > (n6 = variable.getNumberOfValues())) {
            throw new Throwable("getRange0 end > available " + n6);
        }
        if (n6 == 0) {
            return null;
        }
        n6 = !variable.recordVariance() ? 1 : n9 - n8 + 1;
        int n10 = stride.getStride(n6);
        if (n10 > 1) {
            n5 = n6 / n10;
            if (n5 * n10 < n6) {
                ++n5;
            }
            n6 = n5;
        }
        n5 = variable.getType();
        long[] lArray = null;
        double[] dArray = null;
        boolean bl = false;
        if (DataTypes.typeCategory[n5] == 5) {
            lArray = new long[n6];
            bl = true;
        } else {
            dArray = new double[n6];
        }
        int n11 = variable.getDataItemSize();
        int n12 = n11 * n10;
        int n13 = n7 * DataTypes.size[n5];
        Vector vector = ((CDFImpl.DataLocator)variable.getLocator()).getLocationsAsVector();
        int[] nArray = Extractor.getBlockRange(vector, variable.recordVariance(), n8, n9);
        int n14 = nArray[0];
        int n15 = nArray[1];
        int n16 = 0;
        block7: for (n4 = n14; n4 <= n15; ++n4) {
            int n17;
            Object[] objectArray = Extractor.positionBuffer(cDFImpl, variable, nArray, n4, n8, n9);
            ByteBuffer byteBuffer = (ByteBuffer)objectArray[0];
            int n18 = (Integer)objectArray[1];
            int n19 = (Integer)objectArray[2];
            int n20 = byteBuffer.position() + n13;
            int n21 = n18;
            if (n10 > 1 && n4 > n14 && (n17 = n18 - n8) % n10 != 0) {
                n21 = n18 + n10 - n17 % n10;
                n20 += (n21 - n18) * n11;
            }
            switch (DataTypes.typeCategory[n5]) {
                case 0: {
                    while (n21 <= n19) {
                        dArray[n16++] = byteBuffer.getFloat(n20);
                        n20 += n12;
                        n21 += n10;
                    }
                    continue block7;
                }
                case 1: {
                    while (n21 <= n19) {
                        dArray[n16++] = byteBuffer.getDouble(n20);
                        n20 += n12;
                        n21 += n10;
                    }
                    continue block7;
                }
                case 2: {
                    n16 = Extractor.doSignedInteger(byteBuffer, n20, n5, n11, n21, n19, dArray, n16, new int[]{n10});
                    continue block7;
                }
                case 3: {
                    n16 = Extractor.doUnsignedInteger(byteBuffer, n20, n5, n11, n21, n19, dArray, n16, new int[]{n10});
                    continue block7;
                }
                case 5: {
                    while (n21 <= n19) {
                        lArray[n16++] = byteBuffer.getLong(n20);
                        n20 += n12;
                        n21 += n10;
                    }
                    continue block7;
                }
                default: {
                    throw new Throwable("Unsupported data type for this context");
                }
            }
        }
        if (!variable.recordVariance()) {
            int n22 = 0;
            if (!bl) {
                for (n4 = n8; n4 <= n9; n4 += n10) {
                    dArray[n22++] = dArray[0];
                }
            } else {
                while (n4 <= n9) {
                    lArray[n22++] = lArray[0];
                    n4 += n10;
                }
            }
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    static int doSignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray, int n6, int[] nArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        byteBuffer.position(n);
        for (int i = n4; i <= n5; i += nArray[0]) {
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            dArray[n6++] = number.doubleValue();
            byteBuffer.position(n += n3);
        }
        return n6;
    }

    static int doUnsignedInteger(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, double[] dArray, int n6, int[] nArray) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[n2];
        long l = DataTypes.longInt[n2];
        byteBuffer.position(n);
        for (int i = n4; i <= n5; i += nArray[0]) {
            byteBuffer.position(n);
            Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
            int n7 = number.intValue();
            dArray[n6++] = n7 >= 0 ? (double)n7 : (double)(l + (long)n7);
            n += n3;
        }
        return n6;
    }

    static void fillWithPad(boolean bl, Object object, int n, int n2, Object object2) throws Throwable {
        int n3 = 0;
        if (bl) {
            long l = ((long[])object2)[0];
            long[] lArray = (long[])object;
            for (int i = n; i <= n2; ++i) {
                lArray[n3++] = l;
            }
        } else {
            double d = ((double[])object2)[0];
            double[] dArray = (double[])object;
            for (int i = n; i <= n2; ++i) {
                dArray[n3++] = d;
            }
        }
    }

    static void fillWithPrevious(Variable variable, boolean bl, Object object, int n, int n2, Object object2) throws Throwable {
        block4: {
            int n3 = variable.getRecordRange()[1];
            int n4 = 0;
            if (n <= n3) break block4;
            if (!bl) {
                double d = variable.asDoubleArray(new int[]{n3})[0];
                double[] dArray = (double[])object;
                for (int i = n; i <= n2; ++i) {
                    dArray[n4++] = d;
                }
            } else {
                long l = variable.asLongArray(new int[]{n3})[0];
                long[] lArray = (long[])object;
                for (int i = n; i <= n2; ++i) {
                    lArray[n4++] = l;
                }
            }
        }
    }

    public static double[] getOneDSeries(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl) throws Throwable {
        boolean bl2 = bl ? cDFImpl.rowMajority() : !cDFImpl.rowMajority();
        return (double[])Extractor.get1DSeries(cDFImpl, variable, nArray, false, bl2);
    }

    static void do1DSwap(ByteBuffer byteBuffer, int n, Object object, Object object2, int n2, int n3, boolean bl, int[] nArray) throws Throwable {
        double[] dArray = null;
        if (DataTypes.typeCategory[n] != 5) {
            dArray = (double[])object2;
        }
        double[] dArray2 = null;
        int n4 = 0;
        switch (DataTypes.typeCategory[n]) {
            case 0: {
                int n5;
                int n6;
                float[] fArray = new float[n3];
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                floatBuffer.get(fArray, 0, n3);
                if (nArray.length == 2) {
                    while (n4 < n3) {
                        for (n6 = 0; n6 < nArray[1]; ++n6) {
                            for (n5 = 0; n5 < nArray[0]; ++n5) {
                                dArray[n2 + n4] = fArray[n5 * nArray[1] + n6];
                                ++n4;
                            }
                        }
                    }
                }
                if (nArray.length != 3) break;
                while (n4 < n3) {
                    for (n6 = 0; n6 < nArray[2]; ++n6) {
                        for (n5 = 0; n5 < nArray[1]; ++n5) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                dArray[n2 + n4] = fArray[i * nArray[1] * nArray[2] + n5 * nArray[2] + n6];
                                ++n4;
                            }
                        }
                    }
                }
                break;
            }
            case 1: {
                int n7;
                int n8;
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                if (nArray.length == 2) {
                    while (n4 < n3) {
                        for (n8 = 0; n8 < nArray[1]; ++n8) {
                            for (n7 = 0; n7 < nArray[0]; ++n7) {
                                dArray[n2 + n4] = doubleBuffer.get(n7 * nArray[1] + n8);
                                ++n4;
                            }
                        }
                    }
                }
                if (nArray.length != 3) break;
                while (n4 < n3) {
                    for (n8 = 0; n8 < nArray[2]; ++n8) {
                        for (n7 = 0; n7 < nArray[1]; ++n7) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                dArray[n2 + n4] = doubleBuffer.get(i * nArray[1] * nArray[2] + n7 * nArray[2] + n8);
                                ++n4;
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                Method method = DataTypes.method[n];
                dArray2 = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                    dArray2[i] = number.doubleValue();
                }
                break;
            }
            case 3: {
                int n9;
                Object object3;
                Method method = DataTypes.method[n];
                dArray2 = new double[n3];
                long l = DataTypes.longInt[n];
                for (int i = 0; i < n3; ++i) {
                    object3 = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                    n9 = ((Number)object3).intValue();
                    dArray2[i] = n9 >= 0 ? (double)n9 : (double)(l + (long)n9);
                }
                break;
            }
            case 5: {
                int n9;
                Object object3;
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                if (!bl) {
                    object3 = new long[n3];
                    dArray = (double[])object2;
                    dArray2 = new double[n3];
                    longBuffer.get((long[])object3, 0, n3);
                    for (n9 = 0; n9 < n3; ++n9) {
                        dArray2[n9] = (double)object3[n9];
                    }
                } else {
                    int n10;
                    object3 = (long[])object2;
                    if (nArray.length == 2) {
                        while (n4 < n3) {
                            for (n9 = 0; n9 < nArray[1]; ++n9) {
                                for (n10 = 0; n10 < nArray[0]; ++n10) {
                                    object3[n2 + n4] = longBuffer.get(n10 * nArray[1] + n9);
                                    ++n4;
                                }
                            }
                        }
                    }
                    if (nArray.length != 3) break;
                    while (n4 < n3) {
                        for (n9 = 0; n9 < nArray[2]; ++n9) {
                            for (n10 = 0; n10 < nArray[1]; ++n10) {
                                for (int i = 0; i < nArray[0]; ++i) {
                                    object3[n2 + n4] = longBuffer.get(i * nArray[1] * nArray[2] + n10 * nArray[2] + n9);
                                    ++n4;
                                }
                            }
                        }
                    }
                }
                break;
            }
        }
        if (dArray2 != null) {
            if (nArray.length == 2) {
                while (n4 < n3) {
                    for (int i = 0; i < nArray[1]; ++i) {
                        for (int j = 0; j < nArray[0]; ++j) {
                            dArray[n2 + n4] = dArray2[j * nArray[1] + i];
                            ++n4;
                        }
                    }
                }
            }
            if (nArray.length == 3) {
                while (n4 < n3) {
                    for (int i = 0; i < nArray[2]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[0]; ++k) {
                                dArray[n2 + n4] = dArray2[k * nArray[1] * nArray[2] + j * nArray[2] + i];
                                ++n4;
                            }
                        }
                    }
                }
            }
        }
    }

    static {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        try {
            clazz = Class.forName("gov.nasa.gsfc.spdf.cdfj.Extractor");
            clazz2 = Class.forName("gov.nasa.gsfc.spdf.cdfj.CDFImpl");
            clazz3 = Class.forName("gov.nasa.gsfc.spdf.cdfj.Variable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int[] nArray = new int[]{};
        double[] dArray = new double[]{};
        Class[] classArray = new Class[]{clazz2, clazz3};
        Class[][] classArray2 = new Class[MAX_ARRAY + 1][];
        for (int i = 0; i <= MAX_ARRAY; ++i) {
            classArray2[i] = classArray;
        }
        Extractor.addFunction("Series", clazz, classArray2);
        classArray2 = new Class[][]{null, {clazz2, clazz3, Integer.class}, {clazz2, clazz3, Integer.class, Integer.class}, null};
        Extractor.addFunction("Element", clazz, classArray2);
        classArray2 = new Class[][]{{clazz2, clazz3, Integer.class}, {clazz2, clazz3, Integer.class}, {clazz2, clazz3, Integer.class}, {clazz2, clazz3, Integer.class}};
        Extractor.addFunction("Point", clazz, classArray2);
        classArray2 = new Class[][]{{clazz2, clazz3, Integer.class, Integer.class}, {clazz2, clazz3, Integer.class, Integer.class}, null, null};
        Extractor.addFunction("Range", clazz, classArray2);
        classArray2 = new Class[][]{null, {clazz2, clazz3, nArray.getClass()}, null, null};
        Extractor.addFunction("Elements", clazz, classArray2);
        classArray2 = new Class[][]{null, {clazz2, clazz3, Integer.class, Integer.class, nArray.getClass()}, null, null};
        Extractor.addFunction("RangeForElements", clazz, classArray2);
        classArray2 = new Class[][]{null, {clazz2, clazz3, Integer.class, Integer.class, Integer.class}, null, null};
        Extractor.addFunction("RangeForElement", clazz, classArray2);
        try {
            Method[] methodArray = new Method[]{clazz.getMethod("getStringSeries0", clazz2, clazz3), clazz.getMethod("getStringSeries1", clazz2, clazz3)};
            stringMethodMap.put("Series", methodArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }
}

