/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.util.Vector;

public class ArrayAttribute {
    Vector<Integer> dim = new Vector();
    Class<?> cl;
    Object o;

    public ArrayAttribute(Object object) throws Throwable {
        this.cl = object.getClass();
        if (!this.cl.isArray()) {
            throw new Throwable("AArray: Object " + object + " is not an array");
        }
        this.o = object;
        while (this.cl.isArray()) {
            this.cl = this.cl.getComponentType();
            if (this.cl.isPrimitive()) {
                if (this.cl == Double.TYPE) {
                    this.dim.add(new Integer(((double[])this.o).length));
                    break;
                }
                if (this.cl == Float.TYPE) {
                    this.dim.add(new Integer(((float[])this.o).length));
                    break;
                }
                if (this.cl == Integer.TYPE) {
                    this.dim.add(new Integer(((int[])this.o).length));
                    break;
                }
                if (this.cl == Byte.TYPE) {
                    this.dim.add(new Integer(((byte[])this.o).length));
                    break;
                }
                if (this.cl == Short.TYPE) {
                    this.dim.add(new Integer(((short[])this.o).length));
                    break;
                }
                if (this.cl == Long.TYPE) {
                    this.dim.add(new Integer(((long[])this.o).length));
                    break;
                }
            }
            Object[] objectArray = (Object[])this.o;
            this.o = objectArray[0];
            this.dim.add(new Integer(objectArray.length));
        }
    }

    public Class<?> getType() {
        return this.cl;
    }

    public int[] getDimensions() {
        int[] nArray = new int[this.dim.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.dim.get(i);
        }
        return nArray;
    }

    public void toStringArray(String[] stringArray) throws Throwable {
        if (this.cl == String.class) {
            String[] stringArray2 = (String[])this.o;
            if (stringArray.length == stringArray2.length) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[i] = stringArray2[i];
                }
                return;
            }
            throw new Throwable("Length of the receiver array does not match length.");
        }
        throw new Throwable("Method not appropriate for objects of type " + this.cl);
    }

    public void toLongArray(long[] lArray) throws Throwable {
        if (this.cl == Long.TYPE) {
            long[] lArray2 = (long[])this.o;
            if (lArray.length == lArray2.length) {
                for (int i = 0; i < lArray2.length; ++i) {
                    lArray[i] = lArray2[i];
                }
                return;
            }
            throw new Throwable("Length of the receiver array does not match length.");
        }
        throw new Throwable("Method not appropriate for objects of type " + this.cl);
    }

    public void toDoubleArray(double[] dArray) throws Throwable {
        if (this.cl == Double.TYPE) {
            double[] dArray2 = (double[])this.o;
            if (dArray.length == dArray2.length) {
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray[i] = dArray2[i];
                }
                return;
            }
            throw new Throwable("Length of the receiver array does not match length.");
        }
        throw new Throwable("Method not appropriate for objects of type " + this.cl);
    }
}

