/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class CDF2CDFML
implements CDFConstants {
    private static CDF cdf = null;
    private static PrintWriter out = null;
    private static boolean debug = false;
    private static int indent = 0;
    private static int MAX_STR = 80;
    private static String recordTerminator = "&#10;";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String VAL_START = "<value xsi:type=\"xsd:";
    private static final String VAL_END = "</value>";
    private static String inFile = null;
    private static String outFile = null;
    private static String varData = "yes";
    private static String mode = "xsd";
    private static String defaultStrDelimiter = "@~";
    private static String strDelimiter = null;
    private static boolean showProgress = false;
    private static boolean iso8601 = true;
    private static boolean withz = false;
    private static boolean choice = false;
    private static boolean delete = true;
    private static boolean useCdata = false;
    private static boolean useCDATA2 = false;
    private static String indentation = "   ";

    public static void main(String[] stringArray) throws Exception {
        try {
            Writer writer;
            CDF2CDFML.parseCmdLine(stringArray);
            String string = inFile;
            inFile = CDF2CDFML.removeFilePath(inFile);
            if (!inFile.endsWith(".cdf") && !inFile.endsWith(".CDF")) {
                inFile = inFile + ".cdf";
            }
            if (outFile == null) {
                outFile = CDF2CDFML.getDefaultOutputFileName();
            }
            if (outFile.equals("STDOUT")) {
                writer = new BufferedWriter(new OutputStreamWriter(System.out));
            } else {
                if (!delete && new File(outFile).exists()) {
                    System.out.println("ERROR... output file:" + outFile + " already exists. ");
                    System.exit(1);
                }
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile), 4096), "UTF-8");
            }
            out = new PrintWriter(writer, false);
            cdf = CDF.open((String)string, (long)0L);
            CDF2CDFML.printHeader();
            CDF2CDFML.printCDFFileInfo();
            CDF2CDFML.printGlobalAttributes();
            CDF2CDFML.printVariables();
            if (!mode.equalsIgnoreCase("cdfxdf")) {
                CDF2CDFML.printOrphanAttributes();
            }
            cdf.close();
            out.println("</CDF>");
            out.flush();
            if (!outFile.equals("STDOUT")) {
                System.out.println("\nTranslation completed successfully.\n");
                System.out.println("   Input file name: " + string);
                System.out.println("  Output file name: " + outFile);
                System.out.println("");
            }
        }
        catch (Exception exception) {
            if (cdf != null) {
                cdf.close();
            }
            System.out.println("Exception occurred in main.\n" + exception);
        }
    }

    private static void parseCmdLine(String[] stringArray) {
        int n;
        String string = null;
        if (stringArray.length == 0) {
            CDF2CDFML.exit("");
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                if (n == stringArray.length - 1) {
                    inFile = stringArray[n];
                    if (CDFUtils.cdfFileExists((String)inFile)) continue;
                    System.out.println("** Error: file '" + inFile + "' does not exist **");
                    System.exit(1);
                    continue;
                }
                int n2 = stringArray[n].indexOf(":");
                if (stringArray[n].startsWith("-mode:")) {
                    mode = stringArray[n].substring(n2 + 1);
                    if (mode.equalsIgnoreCase("dtd") || mode.equalsIgnoreCase("xsd") || mode.equalsIgnoreCase("cdfxdf")) continue;
                    CDF2CDFML.exit("** Error: Invalid -mode entered **");
                    continue;
                }
                if (stringArray[n].startsWith("-varData:")) {
                    varData = stringArray[n].substring(n2 + 1);
                    if (varData.equalsIgnoreCase("yes") || varData.equalsIgnoreCase("no")) continue;
                    CDF2CDFML.exit("** Error: Invalid -varData entered **");
                    continue;
                }
                if (stringArray[n].startsWith("-output:") || stringArray[n].startsWith("-xml:")) {
                    outFile = stringArray[n].substring(n2 + 1);
                    if (outFile.equalsIgnoreCase("stdout")) {
                        outFile = "STDOUT";
                        continue;
                    }
                    if (outFile.endsWith(".xml") || outFile.endsWith(".XML") || outFile.endsWith(".cdfml") || outFile.endsWith(".CDFML")) continue;
                    outFile = outFile + ".xml";
                    continue;
                }
                if (stringArray[n].startsWith("-indentation:")) {
                    string = stringArray[n].substring(n2 + 1);
                    int n3 = Integer.valueOf(string);
                    indentation = "";
                    for (int i = 0; i < n3; ++i) {
                        indentation = indentation + " ";
                    }
                    continue;
                }
                if (stringArray[n].startsWith("-strDelimiter:")) {
                    strDelimiter = stringArray[n].substring(n2 + 1);
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-showprogress") || stringArray[n].equalsIgnoreCase("-progress")) {
                    showProgress = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-noniso8601")) {
                    iso8601 = false;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-withz")) {
                    withz = true;
                    continue;
                }
                if (stringArray[n].startsWith("-debug:")) {
                    String string2 = stringArray[n].substring(n2 + 1);
                    if (!string2.equalsIgnoreCase("true")) continue;
                    debug = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-datatype")) {
                    choice = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-cdata")) {
                    useCdata = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-delete")) {
                    delete = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-nodelete")) {
                    delete = false;
                    continue;
                }
                CDF2CDFML.exit("** Error: Invalid option entered **");
            }
        }
        if (choice) {
            useCdata = false;
            iso8601 = true;
        }
        if (debug) {
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("args[" + n + "] = " + stringArray[n]);
            }
            System.out.println("inFile=" + inFile + ", outputFile=" + outFile + ", mode=" + mode + ", vardata= " + varData + ", indentation=" + string + ", strDelimiter=" + strDelimiter + "**, showProgress=" + showProgress + ", noniso8601=" + iso8601 + ", withz=" + withz + ", datatype=" + choice + ", cdata=" + !useCdata + ", delete=" + delete);
        }
        if (inFile == null) {
            CDF2CDFML.exit("** Error: CDF file name not specified **");
        }
    }

    private static void printHeader() {
        out.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        if (mode.equalsIgnoreCase("dtd")) {
            out.println("<!-- Change \"http://cdf.gsfc.nasa.gov/cdf.dtd\" to \"cdf.dtd\" if you want to");
            out.println("     use a local version of cdf.dtd. -->");
            out.println("<!DOCTYPE CDF SYSTEM \"http://cdf.gsfc.nasa.gov/cdf.dtd\">");
        } else if (mode.equalsIgnoreCase("xsd")) {
            out.print("<CDF xmlns=\"http://cdf.gsfc.nasa.gov\"");
            if (choice) {
                out.print(" xsi:schemaLocation=\"http://cdf.gsfc.nasa.gov/cdf.xsd\"");
                out.print(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            }
            out.println(" name=\"" + inFile + "\">");
        } else if (mode.equalsIgnoreCase("cdfxdf")) {
            out.println("<!DOCTYPE CDF SYSTEM \"cdfxdf.dtd\">");
        }
        if (!mode.equalsIgnoreCase("xsd")) {
            out.println("<CDF name=\"" + inFile + "\">");
        }
    }

    private static void outputIndentation(int n) {
        GetMyCDFData.outputIndentation(out, n, indentation);
    }

    private static void printCompression(long l, long[] lArray) {
        if (l != 0L) {
            String string = CDFUtils.getStringCompressionType((long)l);
            out.print(" compression=\"" + string);
            if (l == 5L) {
                out.print("." + lArray[0] + "\"");
            } else {
                out.print("\"");
            }
        }
    }

    private static void printCDFFileInfo() {
        try {
            String string = CDFUtils.getStringFormat((CDF)cdf);
            String string2 = CDFUtils.getStringMajority((CDF)cdf);
            String string3 = CDFUtils.getStringEncoding((CDF)cdf);
            String string4 = CDFUtils.getStringChecksum((CDF)cdf);
            long l = CDFUtils.getLeapSecondLastUpdated((CDF)cdf);
            CDF2CDFML.outputIndentation(++indent);
            out.print("<cdfFileInfo ");
            out.print("fileFormat=\"" + string + "\"");
            long l2 = cdf.getCompressionType();
            long[] lArray = cdf.getCompressionParms();
            CDF2CDFML.printCompression(l2, lArray);
            out.print(" majority=\"" + string2 + "\"");
            out.print(" encoding=\"" + string3 + "\"");
            long l3 = cdf.confirmNegtoPosfp0();
            if (l3 == -1L) {
                out.print(" negToPosFp0=\"ENABLE\"");
            } else {
                out.print(" negToPosFp0=\"DISABLE\"");
            }
            if (!string4.equalsIgnoreCase("none") && !string4.equalsIgnoreCase("other")) {
                out.print(" checksum=\"" + string4 + "\"");
            }
            if (l > -1L) {
                if (!choice) {
                    out.print(" leapsecondlastupdated=\"" + l + "\"");
                } else {
                    long l4 = l / 10000L;
                    long l5 = (l - l4 * 10000L) / 100L;
                    long l6 = l - l4 * 10000L - l5 * 100L;
                    out.print(" leapsecondlastupdated=\"" + l4 + "-" + (l5 < 10L ? "0" : "") + l5 + "-" + (l6 < 10L ? "0" : "") + l6 + (withz ? "Z" : "") + "\"");
                }
            }
            out.println("/>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printCDFFileInfo");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static void printGlobalAttributes() {
        try {
            Attribute attribute = null;
            String string = null;
            long l = cdf.getNumGattrs();
            Vector vector = cdf.getGlobalAttributes();
            if (l > 0L) {
                CDF2CDFML.outputIndentation(indent);
                out.println("<cdfGAttributes>");
                ++indent;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    attribute = (Attribute)enumeration.nextElement();
                    string = attribute.getName();
                    long l2 = attribute.getNumEntries();
                    CDF2CDFML.outputIndentation(indent);
                    String[] stringArray = CDF2CDFML.getAttributeAndEntryTagNames();
                    Object object = GetMyCDFData.replaceStringNameToXML(string);
                    out.println("<" + stringArray[0] + " name=\"" + object + "\">");
                    ++indent;
                    if (mode.equalsIgnoreCase("cdfxdf")) {
                        CDF2CDFML.outputIndentation(indent);
                        out.println("<units><unitless/></units>");
                    }
                    Vector vector2 = attribute.getEntries();
                    Enumeration enumeration2 = vector2.elements();
                    while (enumeration2.hasMoreElements()) {
                        Object object2;
                        Entry entry = (Entry)enumeration2.nextElement();
                        if (entry == null) continue;
                        long l3 = entry.getDataType();
                        CDF2CDFML.outputIndentation(indent);
                        Object object3 = entry.getData();
                        if (!choice) {
                            out.print("<" + stringArray[1] + " entryNum=\"" + entry.getID() + "\" cdfDatatype=\"" + CDFUtils.getStringDataType((long)l3) + "\">");
                            int n = l3 == 31L ? 1 : (l3 == 32L ? 2 : (l3 == 33L ? 3 : 0));
                            boolean bl = l3 == 33L ? true : iso8601;
                            useCDATA2 = false;
                            if ((l3 == 51L || l3 == 52L) && useCdata) {
                                useCDATA2 = GetMyCDFData.checkStringData(object3);
                            }
                            if (useCDATA2) {
                                out.print(CDATA_BEGIN);
                                if (n == 0) {
                                    CDFUtils.printData((Object)object3, (PrintWriter)out, (int)n, (boolean)bl);
                                } else if (!withz) {
                                    CDFUtils.printData((Object)object3, (PrintWriter)out, (int)n, (boolean)bl);
                                } else {
                                    CDFUtils.printData((Object)object3, (PrintWriter)out, (int)n, (boolean)bl, (String)"Z");
                                }
                                out.print(CDATA_END);
                            } else if (l3 == 51L || l3 == 52L) {
                                object2 = GetMyCDFData.replaceStringDataToXML(object3);
                                CDFUtils.printData((Object)object2, (PrintWriter)out, (int)n, (boolean)bl);
                            } else if (n == 0 || !bl) {
                                CDFUtils.printData((Object)object3, (PrintWriter)out, (int)n, (boolean)bl);
                            } else if (!withz) {
                                CDFUtils.printData((Object)object3, (PrintWriter)out, (int)n, (boolean)bl);
                            } else {
                                CDFUtils.printData((Object)object3, (PrintWriter)out, (int)n, (boolean)bl, (String)"Z");
                            }
                            out.println("</" + stringArray[1] + ">");
                            continue;
                        }
                        out.println("<" + stringArray[1] + " entryNum=\"" + entry.getID() + "\" cdfDatatype=\"" + CDFUtils.getStringDataType((long)l3) + "\">");
                        if (l3 == 51L || l3 == 52L) {
                            object2 = GetMyCDFData.create(object3, l3, 1L, new long[]{1L}, ((String)object3).length());
                            ((GetMyCDFData)object2).dumpData2(out, l3, VAL_START, VAL_END, indent, indentation, withz, false);
                        } else {
                            String string2 = CDFUtils.getSignature((Object)object3);
                            if (string2.charAt(0) == '[') {
                                int n;
                                int n2 = n = Array.getLength(object3);
                                if (l3 == 32L) {
                                    n2 /= 2;
                                }
                                if (n2 > 1) {
                                    CDF2CDFML.outputIndentation(indent - 3);
                                }
                                object2 = GetMyCDFData.create(object3, l3, 1L, new long[]{n2}, n2);
                            } else {
                                object2 = GetMyCDFData.create(object3, l3, 1L, new long[]{1L}, 1L);
                            }
                            ((GetMyCDFData)object2).dumpData2(out, l3, VAL_START, VAL_END, indent, indentation, withz, false);
                        }
                        CDF2CDFML.outputIndentation(indent);
                        out.println("</" + stringArray[1] + ">");
                    }
                    CDF2CDFML.outputIndentation(--indent);
                    out.println("</" + stringArray[0] + ">");
                }
                CDF2CDFML.outputIndentation(--indent);
                out.println("</cdfGAttributes>");
            }
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printGlobalAttributes");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static void printVariables() {
        try {
            int n = 1;
            long l = cdf.getNumVars();
            if (l > 0L) {
                CDF2CDFML.outputIndentation(indent);
                out.println("<cdfVariables>");
                ++indent;
                Vector vector = cdf.getVariables();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Variable variable = (Variable)enumeration.nextElement();
                    String string = variable.getName();
                    if (showProgress) {
                        long l2 = variable.getMaxWrittenRecord() + 1L;
                        System.out.print("Variable " + n + " of " + l + " (" + l2 + " records): " + string);
                        ++n;
                    }
                    CDF2CDFML.outputIndentation(indent);
                    Object object = GetMyCDFData.replaceStringNameToXML(string);
                    out.println("<variable name=\"" + object + "\">");
                    CDF2CDFML.printVarInfo(variable);
                    CDF2CDFML.printVarAttributes(variable);
                    CDF2CDFML.printVarData(variable);
                }
                CDF2CDFML.outputIndentation(--indent);
                out.println("</cdfVariables>");
            }
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVariables");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static void printVarInfo(Variable variable) {
        try {
            int n;
            long[] lArray = new long[]{1L};
            Object object = null;
            long l = variable.getDataType();
            long l2 = variable.getNumDims();
            lArray = variable.getDimSizes();
            long l3 = variable.getNumElements();
            long[] lArray2 = variable.getDimVariances();
            String string = variable.getRecVariance() ? "VARY" : "NOVARY";
            object = variable.getPadValue();
            long l4 = variable.getBlockingFactor();
            String string2 = CDFUtils.getStringSparseRecord((Variable)variable);
            CDF2CDFML.outputIndentation(++indent);
            String string3 = CDFUtils.getStringDataType((long)l);
            out.print("<cdfVarInfo cdfDatatype=\"" + string3 + "\"");
            if (showProgress) {
                System.out.print("\t" + string3 + "/");
            }
            out.print(" numElements=\"" + l3 + "\"");
            if (showProgress) {
                System.out.print(l3 + "\t");
            }
            out.print(" dim=\"" + l2 + "\"");
            if (showProgress) {
                System.out.print(l2 + ":[");
            }
            if (l2 > 0L) {
                out.print(" dimSizes=\"");
                n = 0;
                while ((long)n < l2) {
                    if (n > 0) {
                        out.print(",");
                        if (showProgress) {
                            System.out.print(",");
                        }
                    }
                    out.print(lArray[n]);
                    if (showProgress) {
                        System.out.print(lArray[n]);
                    }
                    ++n;
                }
                out.print("\"");
            }
            if (showProgress) {
                System.out.print("]\t");
            }
            out.print(" recVariance=\"" + string + "\"");
            if (showProgress) {
                if (string.equals("VARY")) {
                    System.out.print("T/");
                } else {
                    System.out.print("F/");
                }
            }
            if (l2 > 0L) {
                out.print(" dimVariances=\"");
                n = 0;
                while ((long)n < l2) {
                    if (n > 0) {
                        out.print(",");
                    }
                    String string4 = lArray2[n] == -1L ? "VARY" : "NOVARY";
                    out.print(string4);
                    if (showProgress) {
                        if (string4.equals("VARY")) {
                            System.out.print("T");
                        } else {
                            System.out.print("F");
                        }
                    }
                    ++n;
                }
                out.print("\"");
            }
            if (showProgress) {
                System.out.println("");
            }
            long l5 = variable.getCompressionType();
            long[] lArray3 = variable.getCompressionParms();
            CDF2CDFML.printCompression(l5, lArray3);
            if (string2.equals("None")) {
                long l6 = variable.getNumWrittenRecords();
                if (l6 > 0L) {
                    out.print(" numRecordsAllocate=\"" + l6 + "\"");
                }
            } else {
                out.print(" sparseRecords=\"" + string2 + "\"");
            }
            if (variable.checkPadValueExistence()) {
                if (l == 31L) {
                    object = !iso8601 ? Epoch.encode((double)((Double)object)) : Epoch.encode4((double)((Double)object)) + (withz ? "Z" : "");
                } else if (l == 32L) {
                    object = !iso8601 ? Epoch16.encode((Object)((double[])object)) : Epoch16.encode4((Object)((double[])object)) + (withz ? "Z" : "");
                } else if (l == 33L) {
                    object = CDFTT2000.encode((long)((Long)object)) + (withz ? "Z" : "");
                } else if (l == 51L || l == 52L) {
                    char[] cArray = ((String)object).toCharArray();
                    if (!((String)object).matches("[0-9A-Za-z !*#$%&'()*+,-./:;<=>?@\\\\\\[\\]^_`{|}~]*") || cArray.length != (int)l3) {
                        System.out.println("Var: " + variable.getName() + " padValue=" + (String)object + " invalid string... replaced by blank(s)...");
                        char[] cArray2 = new char[(int)l3];
                        Arrays.fill(cArray2, ' ');
                        object = new String(cArray2);
                    }
                }
                out.print(" padValue=\"" + object + "\"");
            }
            if (l4 > 0L) {
                out.print(" blockingFactor=\"" + l4 + "\"");
            }
            out.println("/>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVariables");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static void printVarAttributes(Variable variable) {
        try {
            Attribute attribute = null;
            String string = null;
            Vector vector = variable.getAttributes();
            if (vector.size() == 0) {
                return;
            }
            CDF2CDFML.outputIndentation(indent);
            out.println("<cdfVAttributes>");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                string = attribute.getName();
                Object object = GetMyCDFData.replaceStringNameToXML(string);
                try {
                    Entry entry = attribute.getEntry(variable);
                    if (entry == null) continue;
                    CDF2CDFML.outputIndentation(++indent);
                    String[] stringArray = CDF2CDFML.getAttributeAndEntryTagNames();
                    out.println("<" + stringArray[0] + " name=\"" + object + "\">");
                    ++indent;
                    if (mode.equalsIgnoreCase("cdfxdf")) {
                        CDF2CDFML.outputIndentation(indent);
                        out.println("<units><unitless/></units>");
                    }
                    long l = entry.getDataType();
                    long l2 = entry.getNumElements();
                    Object object2 = entry.getData();
                    int n = l == 31L ? 1 : (l == 32L ? 2 : (l == 33L ? 3 : 0));
                    boolean bl = l == 33L ? true : iso8601;
                    CDF2CDFML.outputIndentation(indent);
                    out.print("<" + stringArray[1] + " cdfDatatype=\"" + CDFUtils.getStringDataType((long)l) + "\"");
                    if (!choice) {
                        useCDATA2 = false;
                        if (l == 51L || l == 52L) {
                            if (useCdata) {
                                useCDATA2 = GetMyCDFData.checkStringData(object2);
                            }
                            String string2 = CDFUtils.getSignature((Object)object2);
                            if (useCDATA2) {
                                if (string2.charAt(0) == '[') {
                                    out.print(" elementDelimiter=\"" + defaultStrDelimiter + "\">");
                                    String[] stringArray2 = (String[])object2;
                                    for (int i = 0; i < stringArray2.length; ++i) {
                                        if (i != 0) {
                                            out.print(defaultStrDelimiter);
                                        }
                                        out.print(CDATA_BEGIN);
                                        out.print(GetMyCDFData.replaceStringDataToXML(stringArray2[i]));
                                        out.print(CDATA_END);
                                    }
                                } else {
                                    out.print("><![CDATA[");
                                    out.print(GetMyCDFData.replaceStringDataToXML(object2));
                                    out.print(CDATA_END);
                                }
                            } else if (string2.charAt(0) == '[') {
                                int n2 = Array.getLength(object2);
                                out.print(" elementDelimiter=\"" + defaultStrDelimiter + "\">");
                                String[] stringArray3 = (String[])object2;
                                StringBuffer stringBuffer = new StringBuffer();
                                for (int i = 0; i < n2; ++i) {
                                    if (i == 0) {
                                        stringBuffer.append(GetMyCDFData.replaceStringDataToXML(stringArray3[i]));
                                        continue;
                                    }
                                    stringBuffer.append(defaultStrDelimiter + GetMyCDFData.replaceStringDataToXML(stringArray3[i]));
                                }
                                out.print(stringBuffer.toString());
                            } else {
                                out.print(">");
                                CDFUtils.printData((Object)GetMyCDFData.replaceStringDataToXML(object2), (PrintWriter)out, (int)n, (boolean)bl);
                            }
                        } else {
                            out.print(">");
                            CDFUtils.printData((Object)object2, (PrintWriter)out, (int)n, (boolean)bl, (String)(withz ? "Z" : ""));
                        }
                        out.println("</" + stringArray[1] + ">");
                    } else {
                        GetMyCDFData getMyCDFData;
                        out.println(">");
                        if (l == 51L || l == 52L) {
                            if (CDFUtils.getSignature((Object)object2).charAt(0) == '[') {
                                int n3 = Array.getLength(object2);
                                getMyCDFData = GetMyCDFData.create(object2, l, 1L, new long[]{n3}, n3);
                            } else {
                                getMyCDFData = GetMyCDFData.create(object2, l, 1L, new long[]{1L}, ((String)object2).length());
                            }
                            getMyCDFData.dumpData2(out, l, VAL_START, VAL_END, indent, indentation, withz, false);
                        } else if (l2 == 1L) {
                            getMyCDFData = GetMyCDFData.create(object2, l, 1L, new long[]{1L}, 1L);
                            getMyCDFData.dumpData2(out, l, VAL_START, VAL_END, indent, indentation, withz, false);
                        } else {
                            getMyCDFData = l2 > 1L ? GetMyCDFData.create(object2, l, 1L, new long[]{l2}, 1L) : GetMyCDFData.create(object2, l, 0L, new long[]{0L}, 1L);
                            getMyCDFData.dumpData2(out, l, VAL_START, VAL_END, indent, indentation, withz, false);
                        }
                        CDF2CDFML.outputIndentation(indent);
                        out.println("</" + stringArray[1] + ">");
                    }
                    CDF2CDFML.outputIndentation(--indent);
                    out.println("</" + stringArray[0] + ">");
                    --indent;
                }
                catch (CDFException cDFException) {}
            }
            CDF2CDFML.outputIndentation(indent);
            out.println("</cdfVAttributes>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVarAttributes");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static void printVarData(Variable variable) {
        try {
            long l;
            long[] lArray = new long[]{1L};
            long[] lArray2 = new long[]{0L};
            long[] lArray3 = new long[]{1L};
            String string = " ";
            CDFData cDFData = null;
            long l2 = variable.getMaxWrittenRecord();
            if (varData.equalsIgnoreCase("no") || l2 < 0L) {
                CDF2CDFML.outputIndentation(--indent);
                out.println("</variable>");
                return;
            }
            long l3 = variable.getNumDims();
            lArray = variable.getDimSizes();
            long l4 = variable.getNumElements();
            long l5 = variable.getDataType();
            long l6 = 1L;
            if (l3 > 0L) {
                lArray3 = new long[lArray.length];
                lArray2 = new long[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray3[i] = 1L;
                    lArray2[i] = 0L;
                    l6 *= lArray[i];
                }
            }
            string = " ";
            CDF2CDFML.outputIndentation(indent);
            out.println("<cdfVarData>");
            if (mode.equalsIgnoreCase("cdfxdf")) {
                CDF2CDFML.printXDFtags(variable, l2, l6);
            }
            long l7 = (l = variable.getSparseRecords()) == 0L ? (long)(l3 == 0L ? 1000 : 200) : 1L;
            int n = 0;
            while ((long)n <= l2) {
                long l8 = (long)n + l7 > l2 ? l2 - (long)n + 1L : l7;
                cDFData = l3 > 0L ? variable.getHyperDataObject((long)n, l8, 1L, lArray2, lArray, lArray3) : variable.getRecordsObject((long)n, l8);
                long l9 = cdf.getStatus();
                Object object = cDFData.getData();
                useCDATA2 = false;
                if ((l5 == 51L || l5 == 52L) && useCdata) {
                    useCDATA2 = GetMyCDFData.checkStringData(object);
                }
                int n2 = 0;
                while ((long)n2 < l8) {
                    Object object2;
                    Object object3;
                    if (l8 > 1L) {
                        if (l5 != 32L) {
                            object3 = Array.get(object, n2);
                        } else {
                            object2 = new double[]{(Double)Array.get(object, 2 * n2), (Double)Array.get(object, 2 * n2 + 1)};
                            object3 = object2;
                        }
                    } else {
                        object3 = object;
                    }
                    object2 = GetMyCDFData.create(object3, l5, l3, lArray, l4);
                    boolean bl = false;
                    if (!mode.equalsIgnoreCase("cdfxdf")) {
                        StringBuffer stringBuffer = new StringBuffer("<record ");
                        long l10 = n + n2;
                        String string2 = "recNum=\"" + l10 + "\"";
                        stringBuffer.append(string2);
                        if (l9 != 1001L) {
                            String string3;
                            if (l5 == 51L || l5 == 52L) {
                                if (strDelimiter == null) {
                                    string = defaultStrDelimiter;
                                } else {
                                    string = strDelimiter;
                                    if (string.equals("\"")) {
                                        string = "&quot;";
                                    }
                                }
                                if (string.equals("<element>")) {
                                    bl = true;
                                    stringBuffer.append(string2);
                                    stringBuffer.append(string2);
                                } else {
                                    if (l3 >= 1L && !choice) {
                                        stringBuffer.append(" elementDelimiter=\"");
                                        stringBuffer.append(string);
                                        stringBuffer.append("\"");
                                    }
                                    stringBuffer.append(">");
                                }
                                string3 = stringBuffer.toString();
                            } else {
                                string = " ";
                                string3 = "<record recNum=\"" + l10 + "\">";
                            }
                            if (!choice) {
                                object2.dumpData(out, string3, "</record>", string, bl, indent, indentation, iso8601, withz, useCDATA2);
                            } else {
                                CDF2CDFML.outputIndentation(indent + 1);
                                out.println(string3);
                                object2.dumpData2(out, l5, VAL_START, VAL_END, indent + 1, indentation, withz, useCDATA2);
                                CDF2CDFML.outputIndentation(indent + 1);
                                out.println("</record>");
                            }
                        }
                    } else if (!choice) {
                        object2.dumpData(out, "", "", " ", bl, indent, indentation, iso8601, withz, useCDATA2);
                    } else {
                        object2.dumpData2(out, l5, VAL_START, VAL_END, indent + 1, indentation, withz, useCDATA2);
                    }
                    ++n2;
                }
                n = (int)((long)n + l7);
            }
            if (mode.equalsIgnoreCase("cdfxdf")) {
                CDF2CDFML.outputIndentation(indent);
                out.println("</data>");
                CDF2CDFML.outputIndentation(--indent);
                out.println("</array>");
                --indent;
            }
            CDF2CDFML.outputIndentation(indent);
            out.println("</cdfVarData>");
            CDF2CDFML.outputIndentation(--indent);
            out.println("</variable>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVarData");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static String[] getAttributeAndEntryTagNames() {
        String[] stringArray = new String[2];
        if (mode.equalsIgnoreCase("cdfxdf")) {
            stringArray[0] = "parameter";
            stringArray[1] = "value";
        } else {
            stringArray[0] = "attribute";
            stringArray[1] = "entry";
        }
        return stringArray;
    }

    private static void printXDFtags(Variable variable, long l, long l2) {
        long l3 = variable.getID();
        long l4 = variable.getDataType();
        CDF2CDFML.outputIndentation(++indent);
        out.println("<array>");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<units><unitless/></units>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<dataFormat>");
        CDF2CDFML.outputIndentation(++indent);
        switch ((int)l4) {
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 52: {
                out.println("<string length=\"" + MAX_STR + "\"/>");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 41: {
                out.println("<integer width=\"10\"/>");
                break;
            }
            case 21: 
            case 22: 
            case 44: 
            case 45: {
                out.println("<float width=\"18\" precision=\"9\"/>");
                break;
            }
            case 8: {
                out.println("<integer width=\"20\"/>");
                break;
            }
        }
        CDF2CDFML.outputIndentation(--indent);
        out.println("</dataFormat>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<axis axisId=\"recNoforVarnum" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<axisUnits><unitless/></axisUnits>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<valueList size=\"" + (l + 1L) + "\"/>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</axis>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<axis axisId=\"record" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<axisUnits><unitless/></axisUnits>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<valueList size=\"" + l2 + "\"/>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</axis>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<read>");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<for axisIdRef=\"recNoforVarnum" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<for axisIdRef=\"record" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<textDelimiter repeatable=\"yes\" recordTerminator=\"" + recordTerminator + "\"/>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</for>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</for>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</read>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<data>");
    }

    private static void printOrphanAttributes() {
        Vector vector = cdf.getOrphanAttributes();
        if (vector.size() > 0) {
            CDF2CDFML.outputIndentation(indent);
            out.println("<orphanAttributes>");
            ++indent;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                String string = attribute.getName();
                CDF2CDFML.outputIndentation(indent);
                Object object = GetMyCDFData.replaceStringNameToXML(string);
                if (mode.equalsIgnoreCase("cdfxdf")) {
                    out.println("<parameter name=\"" + object + "\">");
                    CDF2CDFML.outputIndentation(++indent);
                    out.println("<units><unitless/></units>");
                    CDF2CDFML.outputIndentation(indent);
                    out.println("<value>></value>");
                    CDF2CDFML.outputIndentation(--indent);
                    out.println("</parameter> ");
                    continue;
                }
                out.println("<attribute name=\"" + object + "\"></attribute>");
            }
            CDF2CDFML.outputIndentation(--indent);
            out.println("</orphanAttributes>");
        }
    }

    private static String getDefaultOutputFileName() {
        String string;
        boolean bl;
        int n = inFile.lastIndexOf(".cdf");
        int n2 = inFile.lastIndexOf(".CDF");
        boolean bl2 = bl = inFile.endsWith(".cdf") || inFile.endsWith(".CDF");
        if (!bl) {
            string = inFile + ".xml";
        } else if (n != -1) {
            string = inFile.substring(0, n);
            string = string + ".xml";
        } else {
            string = inFile.substring(0, n2);
            string = string + ".XML";
        }
        return string;
    }

    private static String removeFilePath(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        string = string.substring(n + 1);
        return string;
    }

    private static void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        CDF2CDFML.usage();
        System.exit(1);
    }

    private static void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program exports the contents of a CDF file into an XML file");
        System.out.println("    that conforms to cdf.dtd (default mode), cdf.xsd, or cdfxdf.dtd.");
        System.out.println("    The file conforms to the CDF Document Type Definition (cdf.dtd or");
        System.out.println("    cdfxdf.dtd) or the CDF XML Schema (cdf.xsd) is called a CDF markup");
        System.out.println("    language (CDFML) file.");
        System.out.println("");
        System.out.println("      - cdf.dtd is a pure version of CDFML described in DTD.");
        System.out.println("      - cdf.xsd is a pure version of CDFML described in schema.");
        System.out.println("      - cdfxdf.dtd is a CDFML that employs some of the eXtensible Data ");
        System.out.println("        Format (XDF) tags within CDF tags.");
        System.out.println(" ");
        System.out.println("    The name of the input CDF file is used as the default output file name.");
        System.out.println(" ");
        System.out.println("Usage: java CDF2CDFML [Options] cdfFileName ");
        System.out.println(" ");
        System.out.println("Options: ");
        System.out.println("   -mode:[dtd | xsd | cdfxdf].  -mode:dtd is the default.");
        System.out.println("       -mode:dtd creates a CDFML file that conforms to cdf.dtd (DTD)");
        System.out.println("       -mode:xsd creates a CDFML file that conforms to cdf.xsd (schema)");
        System.out.println("       -mode:cdfxdf creates a CDFML file that conforms to cdfxdf.dtd");
        System.out.println(" ");
        System.out.println("   -varData:[yes | no].  -varData:yes is the default.");
        System.out.println("       -varData:yes extracts the variable data");
        System.out.println("       -varData:no doesn't extract the variable data");
        System.out.println(" ");
        System.out.println("   -[output | xml]:[outputFileName | STDOUT]");
        System.out.println("       -[output|xml]:outputFileName");
        System.out.println("           The name of the input CDF file is used as the default output file");
        System.out.println("           name.  Use this option to specify a different output file name.");
        System.out.println("       -[output|xml]:STDOUT");
        System.out.println("           Displays the XML output on the screen.");
        System.out.println(" ");
        System.out.println("   -indentation:n (n is the number of spaces to skip between levels)");
        System.out.println(" ");
        System.out.println("   -[showProgress | Progress]");
        System.out.println("       This option displays the processing progress on the screen.");
        System.out.println("       It shows how many CDF variables are there to process and which");
        System.out.println("       variable is being processed.");
        System.out.println(" ");
        System.out.println("   -debug:true");
        System.out.println("       This option displays the specifications to run the application.");
        System.out.println(" ");
        System.out.println("   -strDelimiter:[\"userDefinedDelimiter\" | \"<element>\"]");
        System.out.println("       The string delimiter to be used for an array of string data.");
        System.out.println("");
        System.out.println("       -strDelimiter:\"<element>\" option describes data between the");
        System.out.println("           <element index=\"indexNum\"> and </element> tags.");
        System.out.println("");
        System.out.println("   -noniso8601");
        System.out.println("      This option directs the date/time output not in ISO 8601");
        System.out.println("      format for CDF_EPOCH and CDF_EPOCH16 data types as:");
        System.out.println("        dd-MMM-yyyy hh:mm:ss.mmm and");
        System.out.println("        dd-MMM-yyyy hh:mm:ss.mmm.uuu.nnn.ppp.");
        System.out.println("      Otherwise, the default has the following ISO8601 format:");
        System.out.println("        yyyy-mm-ddThh:mm:ss.mmm for CDF_EPOCH");
        System.out.println("        yyyy-mm-ddThh:mm:ss.mmmuuunnnppp for CDF_EPOCH16");
        System.out.println("      For CDF_TIME_TT2000, it is always in ISO8601 form:");
        System.out.println("        yyyy-mm-ddThh:mm:ss.mmmuuunnn");
        System.out.println("");
        System.out.println("   -withZ");
        System.out.println("      This option goes with ISO8601 date output to add an extra \"Z\" to");
        System.out.println("      the end of the time form. The default is no.");
        System.out.println("");
        System.out.println("   -datatype");
        System.out.println("      This option will make an enhanced form of XML output, placing each");
        System.out.println("      data value, in each \"value\" element line, along with its data type.");
        System.out.println("      The data types follow http://www.w3.org/2001/XMLSchema. For");
        System.out.println("      dimensional values, they are wrapped around around \"array\" element.");
        System.out.println("      The valid data types are as follows:");
        System.out.println("       \"dateTime\"     \"string\"         \"float\"");
        System.out.println("       \"double\"       \"byte\"           \"unsignedByte\"");
        System.out.println("       \"short\"        \"unsignedShort\"  \"int\"");
        System.out.println("       \"unsignedInt\"  \"long\"");
        System.out.println("      Note: \"dateTime\" represents data from CDF_EPOCH, CDF_EPOCH16");
        System.out.println("            or CDF_TIME_TT2000 epoch data types.");
        System.out.println("      For example, a CDF_INT2 variable (1-dim of 3 elements),");
        System.out.println("      its default output for a record has this simple form:");
        System.out.println("        <record recNum=\"0\">1 2 3</record>");
        System.out.println("      With this \"-datatype\" option, the output will look as follows:");
        System.out.println("        <record recNum=\"0\">");
        System.out.println("           <array>");
        System.out.println("             <value xsi:type=\"sxd:short\">1</value>");
        System.out.println("             <value xsi:type=\"sxd:short\">2</value>");
        System.out.println("             <value xsi:type=\"sxd:short\">3</value>");
        System.out.println("           </array>");
        System.out.println("        </record>");
        System.out.println("");
        System.out.println("   -[delete | nodelete]");
        System.out.println("      Use this option to control whether to replace the XML if it");
        System.out.println("      already exists. The default is to replace.");
        System.out.println("");
        System.out.println("   -cdata");
        System.out.println("      This option only applies to string typed variable data and attributes.");
        System.out.println("      By default, data will be displayed as is with an exception of a");
        System.out.println("      special character: \"<\", which will be replaced by the standard XML");
        System.out.println("      representation of \"&lt;\". With this option, data will be wrapped within");
        System.out.println("      the strings: \"<![[CDATA\" and \"]]>\" only if a string has that special");
        System.out.println("      \"<\" in it.");
        System.out.println("");
        System.out.println("Examples: ");
        System.out.println("   1) java CDF2CDFML test.cdf (same as java CDF2CDFML -mode:dtd test.cdf)");
        System.out.println("   2) java CDF2CDFML -mode:cdfxdf test.cdf");
        System.out.println("   3) java CDF2CDFML -output:mytest.xml test.cdf");
        System.out.println("   4) java CDF2CDFML -indentation:2 test.cdf (use 2 spaces for indentation)");
        System.out.println("          The default indentation is 3 spaces between levels");
        System.out.println("   5) java CDF2CDFML -strDelimiter:\"'\" -output:test.xml test.cdf ");
        System.out.println("   6) java CDF2CDFML -strDelimiter:\\\"\"\" -output:test.xml test.cdf ");
        System.out.println("   7) java CDF2CDFML -strDelimiter:\"<element>\" -output:test.xml test.cdf ");
        System.out.println(" ");
    }
}

