"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Mon Mar  2 17:25:40 2015
  from data model element ccp.nmr.NmrReference revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

NmrReference.py: python API for CCPN data model, MetaPackage ccp.nmr.NmrReference

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Template
import ccp.api.molecule.ChemComp
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.nmr.NmrReference')

###############################################################################
class ChemAtomNmrDistrib(memops.api.Implementation.DataObject):
  r"""nD chemical shift distribution matrix. The atoms on the axes are defined 
by the chemAtomNmrRefs link, the referencing by the refPoints refValues, 
and valuePerPoint arrays. 

The distribution is normalised and the 
values must sum to 1.0. The shifts to which the individual points belong 
are defined so that for each dimension point i collects the  shifts from 

refValue + valuePerPoint*( i-refPoint) to refValue + valuePerPoint*( 
i+1-refPoint).
  """
  #   from data model element ccp.nmr.NmrReference.ChemAtomNmrDistrib revision ?
  _metaclass = metaPackage.getElement('ChemAtomNmrDistrib')
  _packageName = 'ccp.nmr.NmrReference'
  _packageShortName = 'NMRR'
  _fieldNames = ('applicationData', 'className', 'data', 'defaultValue', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'ndim', 'packageName', 'packageShortName', 'qualifiedName', 'refPoints', 'refValues', 'serial', 'shape', 'size', 'valuesPerPoint', 'access', 'activeAccess', 'chemCompNmrRef', 'parent', 'refAtoms', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    dataDict['chemCompNmrRef'] = parent
    if (not isinstance(parent, ChemCompNmrRef)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['data'] = list()
      dataDict['defaultValue'] = 0.0
      dataDict['refPoints'] = list()
      dataDict['refValues'] = list()
      dataDict['serial'] = None
      dataDict['shape'] = list()
      dataDict['valuesPerPoint'] = list()
      dataDict['access'] = None
      dataDict['refAtoms'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrReference.ChemAtomNmrDistrib.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrReference.ChemAtomNmrDistrib')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAtomNmrDistribs')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrReference.ChemAtomNmrDistrib:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrReference.ChemAtomNmrDistrib:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for refAtom in dataDict.get('refAtoms'):
      if (not (refAtom in objsToBeDeleted)):
        shiftDistributions = refAtom.__dict__.get('shiftDistributions')
        shiftDistributions.remove(self)

    chemCompNmrRef = dataDict.get('chemCompNmrRef')
    if (not (chemCompNmrRef in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemCompNmrRef.__dict__.get('chemAtomNmrDistribs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addRefPoint(self, value):
    """
    Add for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refPoints
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addRefPoint:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addRefPoint:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refPoints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addRefValue(self, value):
    """
    Add for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refValues
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addRefValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addRefValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refValues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefValue:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addValuePerPoint(self, value):
    """
    Add for ccp.nmr.NmrReference.ChemAtomNmrDistrib.valuesPerPoint
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addValuePerPoint:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addValuePerPoint:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('valuesPerPoint')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addValuePerPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addValuePerPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addValuePerPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemCompNmrRef')
        dd = value.__dict__.get('chemAtomNmrDistribs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemCompNmrRef' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('data')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: data:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: data:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('defaultValue')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: defaultValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: defaultValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getNdim()
      if (value is None):
        raise ApiError("""%s.checkValid: ndim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ndim:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: ndim:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('refPoints')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: refPoints:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: refPoints:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('refValues')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: refValues:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: refValues:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('shape')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: shape:
           memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value >= 0)):
          raise ApiError("""%s.checkValid: shape:
           NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSize()
      if (value is None):
        raise ApiError("""%s.checkValid: size:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: size:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('valuesPerPoint')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: valuesPerPoint:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: valuesPerPoint:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemCompNmrRef')
      if (not isinstance(value, ChemCompNmrRef)):
        raise ApiError("""%s.checkValid: chemCompNmrRef:
         value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('refAtoms')
      for value in values:
        if (not isinstance(value, ChemAtomNmrRef)):
          raise ApiError("""%s.checkValid: refAtoms:
           value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('shiftDistributions')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: refAtoms:
           non-reciprocal link refAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refAtoms:
           Link refAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    if (not (len(self.refPoints) == self.ndim)):
      raise ApiError("""%s.checkValid:
       constraint consistent_matrix_size violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (len(self.refPoints) == len(self.refAtoms))):
      raise ApiError("""%s.checkValid:
       constraint consistent_number_of_reference_atoms violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (len(self.valuesPerPoint) == self.ndim)):
      raise ApiError("""%s.checkValid:
       constraint consistent_number_valuesPerPoint violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (len(self.refPoints) == len(self.refValues))):
      raise ApiError("""%s.checkValid:
       constraint consistent_referencing_dimension violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    isValid = False
    
    ll = self.data
    if ll:
      floatTolerance = 1.0e-5
    
      if abs(sum(ll)-1.0) <= floatTolerance:
        isValid = True
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint nd_distribution_is_normalised violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    data= self.data
    isValid = (not data or min(data) >= 0)
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint numbers_are_positive violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('data')
    value = dataDict.get('defaultValue')
    if (value is None):
      raise ApiError("""%s.checkValid: defaultValue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('refPoints')
    if (len(values) < 2):
      raise ApiError("""%s.checkValid: refPoints:
       locard: values must be of length >= 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('refValues')
    if (len(values) < 2):
      raise ApiError("""%s.checkValid: refValues:
       locard: values must be of length >= 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('shape')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: shape:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('valuesPerPoint')
    if (len(values) < 2):
      raise ApiError("""%s.checkValid: valuesPerPoint:
       locard: values must be of length >= 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chemCompNmrRef')
    if (value is None):
      raise ApiError("""%s.checkValid: chemCompNmrRef:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('refAtoms')
    if (len(values) < 2):
      raise ApiError("""%s.checkValid: refAtoms:
       locard: values must be of length >= 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not (len(value) == self.ndim)):
        raise ApiError("""%s.checkValid: refAtoms:
         refAtoms constraint len_refatoms_eq_ndim violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllRefAtoms(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refAtoms')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('refAtoms')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('meanValue', 'name', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstRefAtom(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refAtoms')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('refAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('meanValue', 'name', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemAtomNmrDistrib'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrReference')
        obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemAtomNmrDistrib'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('chemCompNmrRefs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('chemAtomNmrDistribs').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemCompNmrRef(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.chemCompNmrRef
    """
    dataDict = self.__dict__
    result = dataDict.get('chemCompNmrRef')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = tuple(tempVar)
    return result
  
  def getDefaultValue(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.defaultValue
    """
    dataDict = self.__dict__
    result = dataDict.get('defaultValue')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('chemCompNmrRef')
    obj1 = obj2.__dict__.get('nmrReferenceStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('sourceName'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNdim(self):
    """
    getter for derived attribute ndim
    """
    dataDict = self.__dict__
    result = len(self.shape)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemCompNmrRef')
    return result
  
  def getPointValue(self, point):
    """
    get value of matrix at position 'point'. Point is converted as for
    self.pointToIndex.
    """
    dataDict = self.__dict__
    data = self.__dict__['data']
    if data:
      result = data[self.pointToIndex(point)]
    else:
      result = self.defaultValue
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefAtoms(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refAtoms')
    result = tuple(tempVar)
    return result
  
  def getRefPoints(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refPoints
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refPoints')
    result = tuple(tempVar)
    return result
  
  def getRefValues(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refValues
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refValues')
    result = tuple(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getShape(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.shape
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('shape')
    result = tuple(tempVar)
    return result
  
  def getSize(self):
    """
    getter for derived attribute size
    """
    dataDict = self.__dict__
    import operator
    result = reduce(operator.mul, self.shape)
    return result
  
  def getSubmatrixData(self, point, shape):
    """
    get data (packed linear array)  for submatrix of shape 'shape' with
    'point' as the corner with the smallest index values. point is convered 
    as for self.pointToIndex. 'shape values that are omitted or set to zero 
    are reset to the (rest of the) dimension size.
    """
    dataDict = self.__dict__
    # get starting offset and normalise point -
    # padding with zero and converting to positive indices
    offset = self.pointToIndex(point)
    point = self.indexToPoint(offset)
    
    # set up internal params
    ndim = self.ndim
    sizes = self.shape
    
    # set widths and check
    shape = list(shape)
    if len(shape) > ndim:
      raise ApiError("Number of dimensions %s exceeds ndim %s" % (shape,ndim))
    for ii,width in enumerate(shape):
      if not width:
        shape[ii] = sizes[ii] - point[ii]
      elif width < 0 or width > sizes[ii] - point[ii]:
        raise ApiError("Width %s in dim %s out of permitted range" % (width,ii))
    # Extend shape, padding to dimension sizes.
    shape.extend(sizes[ii] - point[ii] for ii in range(len(shape),ndim))
    
    # set up strides list and lowest dim with continuous data.
    strides = ndim*[0]
    factor = 1
    dodim = 0
    for ii in range(ndim-1,-1,-1):
      strides[ii] = factor
      factor *= shape[ii]
      if not dodim and shape[ii] != sizes[ii]:
        dodim = ii
    size = factor
    
    # length of contiguous stretch
    stretch = strides[dodim] * shape[dodim]
    
    # get hold of data (must bypass API for speed)
    data = self.__dict__['data'] 
    
    if not data:
      # default-only matrix
      result = size*(self.defaultValue,)
    
    else:
    
      if dodim <= 0:
        # take single stretch from 1D array
        result = data[offset:offset+stretch]
      
      else:
        # do work for ndim array
      
        # set up result list (optimisation - could be done with extend instead)
        import operator
        subsize = reduce(operator.mul, shape)
        result = subsize*[None]
      
        # set up multidimensional loop
        vector = (dodim)*[0]
        dim = dim0 = dodim - 1
        target = 0
        while dim >= 0:
        
          # do actual work
          next = target+stretch
          result[target:next] = data[offset:offset+stretch]
          target = next
        
          # update reading offset
          vector[dim] += 1
          if vector[dim] < shape[dim]:
            offset += strides[dim]
            if dim < dim0:
              dim += 1
          else:
            vector[dim] = 0
            dim -=1
      #
      result = tuple(result)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValuesPerPoint(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrDistrib.valuesPerPoint
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('valuesPerPoint')
    result = tuple(tempVar)
    return result
  
  def indexToPoint(self, index):
    """
    Converts array index to equivalent point
    """
    dataDict = self.__dict__
    import operator
    shape = self.shape
    if index >= reduce(operator.mul, shape):
      raise ApiError("value %s of index to large for matrix of size %s" % (index, shape))
    if index < 0:
      raise ApiError("Negative value %s of index not allowed" % index)
    result = len(shape) * [None]
    for ii in range(len(shape)-1,-1,-1):
      index,result[ii] = divmod(index,shape[ii])
    result = tuple(result)
    return result
  
  def pointToIndex(self, point):
    """
    converts point to equivalent array index. Point is padded to matrix
    dimension with zeros. negative index values -i in point are treated as 
    eqal to (size-i).
    """
    dataDict = self.__dict__
    shape = self.shape
    lendiff = len(shape) -  len(point)
    if lendiff < 0:
      raise ApiError("Point %s incompatible with %s-dimensional matrix" 
                     % (point,len(shape)))
    elif lendiff:
      point = list(point) + lendiff*[0]
    
    result = 0
    factor = 1
    for ii in range(len(shape)-1,0,-1):   # loop over dimensions in reverse order
      # skipping the first one
      size = shape[ii]
      num,indx = divmod(point[ii],size) # convert -n to width-n
      if num not in (0,-1):
        raise ApiError("Point %s out of range for dimension %s" % (point,ii))
      result += factor * indx
      factor *= size
        
    # treat first dimension differently, because locations beyond the end of
    # the data may be relevant and are certainly defined
    indx = point[0]
    if indx < 0:
      indx += shape[0]
    if indx < 0:
      raise ApiError("Point %s out of range for dimension %s" % (point,0))
    result += factor * indx
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeRefPoint(self, value):
    """
    Remove for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refPoints
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removeRefPoint:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removeRefPoint:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refPoints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefPoint:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (len(currentValues) < (2 + 1)):
        raise ApiError("""%s.removeRefPoint:
         locard: currentValues: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeRefValue(self, value):
    """
    Remove for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refValues
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removeRefValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removeRefValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refValues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefValue:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefValue:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (len(currentValues) < (2 + 1)):
        raise ApiError("""%s.removeRefValue:
         locard: currentValues: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeSlice(self, index):
    """
    Remove slice of matrix in slowest verying dimension at offset index.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSlice:
       called on deleted object""" % self.qualifiedName
      )

    data = self.__dict__['data']
    if data:
      start = self.pointToIndex((index,))
      end = self.pointToIndex((index+1,))
      del data[start:end]
    self.__dict__['shape'][0] -= 1
  
  def removeValuePerPoint(self, value):
    """
    Remove for ccp.nmr.NmrReference.ChemAtomNmrDistrib.valuesPerPoint
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removeValuePerPoint:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removeValuePerPoint:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('valuesPerPoint')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeValuePerPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeValuePerPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeValuePerPoint:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (len(currentValues) < (2 + 1)):
        raise ApiError("""%s.removeValuePerPoint:
         locard: currentValues: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeValuePerPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def resetData(self):
    """
    Reset data to default values and free memory used.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.resetData:
       called on deleted object""" % self.qualifiedName
      )

    del self.__dict__['data'][:]
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setData(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.data
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setData:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setData:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setData:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setData:
         cannot set data, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['data'] = values

    # doNotifies
  
  def setDefaultValue(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.defaultValue
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setDefaultValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setDefaultValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('defaultValue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDefaultValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDefaultValue:
         cannot set defaultValue, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDefaultValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['defaultValue'] = value

    # doNotifies
  
  def setPointValue(self, point, value):
    """
    set value of matrix at position 'point'. Point is converted as for
    self.pointToIndex.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPointValue:
       called on deleted object""" % self.qualifiedName
      )

    if not isinstance(value, (float, int)):
      raise ApiError("parameter value %s is not a float" % value)
    data = self.__dict__['data']
    if data:
      data[self.pointToIndex(point)] = value
    elif value != self.defaultValue:
        data.extend(self.size*[self.defaultValue])
        data[self.pointToIndex(point)] = value
  
  def setRefAtoms(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refAtoms
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRefAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemAtomNmrRef)):
        raise ApiError("""%s.setRefAtoms:
         value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setRefAtoms:
         cannot set refAtoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 2):
        raise ApiError("""%s.setRefAtoms:
         locard: values must be of length >= 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefAtoms:
           Link refAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          if (not (len(value) == self.ndim)):
            raise ApiError("""%s.setRefAtoms:
             refAtoms constraint len_refatoms_eq_ndim violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('shiftDistributions')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('shiftDistributions')
        oldSelves.add(self)

    dataDict['refAtoms'] = values

    # doNotifies
  
  def setRefPoints(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refPoints
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setRefPoints:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setRefPoints:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refPoints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefPoints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefPoints:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (len(values) < 2):
        raise ApiError("""%s.setRefPoints:
         locard: values must be of length >= 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['refPoints'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefPoints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefValues(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.refValues
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setRefValues:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setRefValues:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refValues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefValues:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefValues:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (len(values) < 2):
        raise ApiError("""%s.setRefValues:
         locard: values must be of length >= 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['refValues'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefValues')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('chemCompNmrRef')
    oldSerial = parent.__dict__.get('_serialDict').get('chemAtomNmrDistribs')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['chemAtomNmrDistribs'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['chemAtomNmrDistribs'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setShape(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.shape
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setShape:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.setShape:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('shape')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShape:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setShape:
         cannot set shape, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setShape:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['shape'] = values

    # doNotifies
  
  def setSubmatrixData(self, point, shape, values):
    """
    set data for submatrix of shape 'shape' with 'point' as the corner with
    the smallest index values to 'values' (packed linear array). Point is 
    converted as for self.pointToIndex.  shape values that are omitted or 
    set to zero are reset to the (rest of the) dimension size.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSubmatrixData:
       called on deleted object""" % self.qualifiedName
      )

    # get starting offset and normalise point -
    # padding with zero and converting to positive indices
    offset = self.pointToIndex(point)
    point = self.indexToPoint(offset)
    
    # set up internal params
    ndim = self.ndim
    sizes = self.shape
    
    # set widths and check
    shape = list(shape)
    if len(shape) > ndim:
      raise ApiError("Number of submatrix dimensions %s exceeds ndim %s" % (shape,ndim))
    for ii,width in enumerate(shape):
      if not width:
        shape[ii] = sizes[ii] - point[ii]
      elif width < 0 or width > sizes[ii] - point[ii]:
        raise ApiError("Size %s in dim %s out of permitted range" % (width,ii))
    # Extend shape, padding to dimension sizes.
    shape.extend(sizes[ii] - point[ii] for ii in range(len(shape),ndim))
    
    # set up strides list and lowest dim with continuous data.
    strides = ndim*[0]
    factor = 1
    dodim = 0
    for ii in range(ndim-1,-1,-1):
      strides[ii] = factor
      factor *= sizes[ii]
      if not dodim and shape[ii] != sizes[ii]:
        dodim = ii
    
    # length of contiguous stretch
    stretch = strides[dodim] * shape[dodim]
    
    # get hold of data (must bypass API for speed)
    data = self.__dict__['data'] 
    if not data:
      data.extend(self.size*[self.defaultValue])
    
    # check value types
    if [x for x in values if not isinstance(x,(float,int))]:
      raise ApiError("Non-numeric values passed to setSubmatrixData: %s" %  list(set(x for x in values if not isinstance(x,(float,int)))))
    
    if dodim <= 0:
      # set single stretch from 1D array
      data[offset:offset+stretch] =values
      
    else:
      # do work for ndim array
      
      # check length and type of values
      import operator
      subsize = reduce(operator.mul, shape)
      if len(values) != subsize:
        raise ApiError("Number of values %s do not fit submatrix shape %s" % (subsize, shape))
      
      # set up multidimensional loop
      vector = (dodim)*[0]
      dim = dim0 = dodim - 1
      target = 0
      while dim >= 0:
        
        # do actual work
        next = target+stretch
        data[offset:offset+stretch] = values[target:next] 
        target = next
        
        # update reading offset
        vector[dim] += 1
        if vector[dim] < shape[dim]:
          offset += strides[dim]
          if dim < dim0:
            dim += 1
        else:
          vector[dim] = 0
          dim -=1
  
  def setValuesPerPoint(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrDistrib.valuesPerPoint
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setValuesPerPoint:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setValuesPerPoint:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('valuesPerPoint')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValuesPerPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValuesPerPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (len(values) < 2):
        raise ApiError("""%s.setValuesPerPoint:
         locard: values must be of length >= 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['valuesPerPoint'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValuesPerPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sizeFirstDim(self, value):
    """
    Change size in first (slowest) dimension, truncating or padding with
    self.defaultValue as necessary.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.sizeFirstDim:
       called on deleted object""" % self.qualifiedName
      )

    if value < 0:
      raise ApiError("Dimension size must be non-negative: %s" % value)
    
    shapeList = self.__dict__['shape'] # must bypass API
    lendiff = value - shapeList[0]
    if lendiff:
      data = self.__dict__['data'] # must bypass API
      if data:
        # if data array is empty we have an all-default matrix
        if lendiff > 0:
          data.extend([self.defaultValue]*self.pointToIndex((lendiff,)))
        else:
          # lendiff < 0
          del data[self.pointToIndex((lendiff,)):]
      shapeList[0] = value

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  data = property(getData, setData, None,
  r"""Matrix data as packed list.
  """)
  
  defaultValue = property(getDefaultValue, setDefaultValue, None,
  r"""default value of data in matrix. Used instead of values that are not 
  explicitly set.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  ndim = property(getNdim, None, None,
  r"""Number of matrix dimensions
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  refPoints = property(getRefPoints, setRefPoints, None,
  r"""Reference points - one for each dimension
  """)
  
  refValues = property(getRefValues, setRefValues, None,
  r"""Reference values - shift value at the reference point for each dimension
  """)
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  shape = property(getShape, setShape, None,
  r"""Matrix shape, slowest moving index first. SIze in first dimension (only) 
  may be zero.
  """)
  
  size = property(getSize, None, None,
  r"""Matrix size - product of dimensions sizes
  """)
  
  valuesPerPoint = property(getValuesPerPoint, setValuesPerPoint, None,
  r"""Width of a matrix row in ppm. One for each dimension
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemCompNmrRef = property(getChemCompNmrRef,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemCompNmrRef
  """)
  
  refAtoms = property(getRefAtoms, setRefAtoms, None,
  r"""Atom references for chemical shifts in shiftDistribution
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemAtomNmrRef(memops.api.Implementation.DataObject):
  r"""Information about refrence chemical shift for a ChemAtom. The 
information may apply to a ChemAtom in all ChemCompVars (linking and 
descriptor both 'any'), in some ChemCompVars (either linking or 
descriptor 'any') or in a specific ChemCompVar (all other cases). Either 
the meanValue or the randomCoilValue attribute must be set.
  """
  #   from data model element ccp.nmr.NmrReference.ChemAtomNmrRef revision ?
  _metaclass = metaPackage.getElement('ChemAtomNmrRef')
  _packageName = 'ccp.nmr.NmrReference'
  _packageShortName = 'NMRR'
  _fieldNames = ('applicationData', 'className', 'distribution', 'fieldNames', 'inConstructor', 'isDeleted', 'meanValue', 'metaclass', 'name', 'numPoints', 'packageName', 'packageShortName', 'qualifiedName', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'activeAccess', 'chemAtomShiftCorrs', 'chemAtoms', 'chemCompNmrRef', 'chemCompVarNmrRefs', 'parent', 'root', 'shiftDistributions', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    dataDict['chemCompNmrRef'] = parent
    if (not isinstance(parent, ChemCompNmrRef)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['distribution'] = list()
      dataDict['meanValue'] = None
      dataDict['name'] = None
      dataDict['randomCoilValue'] = None
      dataDict['refPoint'] = 1.0
      dataDict['refValue'] = 0.0
      dataDict['serial'] = None
      dataDict['stdDev'] = None
      dataDict['subType'] = 1
      dataDict['valuePerPoint'] = None
      dataDict['access'] = None
      dataDict['chemAtomShiftCorrs'] = {}
      dataDict['chemCompVarNmrRefs'] = set()
      dataDict['shiftDistributions'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrReference.ChemAtomNmrRef.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrReference.ChemAtomNmrRef')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAtomNmrRefs')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrReference.ChemAtomNmrRef:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chemAtomShiftCorrs = dataDict.get('chemAtomShiftCorrs').values()
    for chemAtomShiftCorr in chemAtomShiftCorrs:
      if (not (chemAtomShiftCorr in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtomShiftCorr)
        objsToBeChecked.append(chemAtomShiftCorr)

    shiftDistributions = dataDict.get('shiftDistributions')
    for shiftDistribution in shiftDistributions:
      if (not (shiftDistribution in objsToBeDeleted)):
        objsToBeDeleted.add(shiftDistribution)
        objsToBeChecked.append(shiftDistribution)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrReference.ChemAtomNmrRef:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemCompVarNmrRef in dataDict.get('chemCompVarNmrRefs'):
      if (not (chemCompVarNmrRef in objsToBeDeleted)):
        chemAtomNmrRefs = chemCompVarNmrRef.__dict__.get('chemAtomNmrRefs')
        chemAtomNmrRefs.remove(self)

    chemCompNmrRef = dataDict.get('chemCompNmrRef')
    if (not (chemCompNmrRef in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemCompNmrRef.__dict__.get('chemAtomNmrRefs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChemCompVarNmrRef(self, value):
    """
    Add for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompVarNmrRef)):
      raise ApiError("""%s.addChemCompVarNmrRef:
       value is not of class ccp.nmr.NmrReference.ChemCompVarNmrRef""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemCompVarNmrRefs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChemCompVarNmrRef:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChemCompVarNmrRef:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChemCompVarNmrRef:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChemCompVarNmrRef:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChemCompVarNmrRef:
           Link chemCompVarNmrRefs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('chemAtomNmrRefs')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChemCompVarNmrRef')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addDistribution(self, value):
    """
    Modify command for distribution. Specifically entered here to make sure
    command is disabled
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addDistribution:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addDistribution:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('distribution')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addDistribution:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addDistribution:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    raise ApiError("The %s.addDistribution method is invalid and cannot be used" % self.className)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addDistribution')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('chemAtomShiftCorrs').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemCompNmrRef')
        dd = value.__dict__.get('chemAtomNmrRefs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemCompNmrRef' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('distribution')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: distribution:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: distribution:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('meanValue')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: meanValue:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: meanValue:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getNumPoints()
      if (value is None):
        raise ApiError("""%s.checkValid: numPoints:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numPoints:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('randomCoilValue')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: randomCoilValue:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: randomCoilValue:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('refPoint')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: refPoint:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: refPoint:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('refValue')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: refValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: refValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stdDev')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: stdDev:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: stdDev:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('subType')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: subType:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('valuePerPoint')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: valuePerPoint:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: valuePerPoint:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtomShiftCorrs').values()
      for value in values:
        if (not isinstance(value, ChemAtomShiftCorr)):
          raise ApiError("""%s.checkValid: chemAtomShiftCorrs:
           value is not of class ccp.nmr.NmrReference.ChemAtomShiftCorr""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemAtomNmrRef')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtomShiftCorrs:
           non-reciprocal link chemAtomShiftCorrs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getChemAtoms()
      if (len(values) < 1):
        raise ApiError("""%s.checkValid: chemAtoms:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      for value in values:
        from ccp.api.molecule.ChemComp import AbstractChemAtom as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemCompNmrRef')
      if (not isinstance(value, ChemCompNmrRef)):
        raise ApiError("""%s.checkValid: chemCompNmrRef:
         value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('chemCompVarNmrRefs')
      for value in values:
        if (not isinstance(value, ChemCompVarNmrRef)):
          raise ApiError("""%s.checkValid: chemCompVarNmrRefs:
           value is not of class ccp.nmr.NmrReference.ChemCompVarNmrRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtomNmrRefs')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemCompVarNmrRefs:
           non-reciprocal link chemCompVarNmrRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('shiftDistributions')
      for value in values:
        if (not isinstance(value, ChemAtomNmrDistrib)):
          raise ApiError("""%s.checkValid: shiftDistributions:
           value is not of class ccp.nmr.NmrReference.ChemAtomNmrDistrib""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('refAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: shiftDistributions:
           non-reciprocal link shiftDistributions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    isValid = True
    
    ll = self.distribution
    if ll:
      floatTolerance = 1.0e-5
    
      if abs(sum(ll)-1.0) > floatTolerance:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint Distribution_is_normalised violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (self.meanValue is not None or self.randomCoilValue is not None)):
      raise ApiError("""%s.checkValid:
       constraint meanValue_or_randomCoilValue_must_be_set violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('distribution')
    value = dataDict.get('meanValue')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('randomCoilValue')
    value = dataDict.get('refPoint')
    if (value is None):
      raise ApiError("""%s.checkValid: refPoint:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('refValue')
    if (value is None):
      raise ApiError("""%s.checkValid: refValue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('stdDev')
    value = dataDict.get('subType')
    if (value is None):
      raise ApiError("""%s.checkValid: subType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('valuePerPoint')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtomShiftCorrs').values()
    value = dataDict.get('chemCompNmrRef')
    if (value is None):
      raise ApiError("""%s.checkValid: chemCompNmrRef:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('chemCompVarNmrRefs')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: chemCompVarNmrRefs:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('shiftDistributions')
    for value in values:
      (self, value) = (value, self)
      if (not (len(value) == self.ndim)):
        raise ApiError("""%s.checkValid: shiftDistributions:
         refAtoms constraint len_refatoms_eq_ndim violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtomShiftCorrs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtomShiftCorrs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomShiftCorrs').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtomShiftCorrs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'molType', 'seqOffset', 'value', 'access', 'chemAtomNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemAtoms()
      result = set(currentValues)

    else:
      currentValues = self.getChemAtoms()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompVarNmrRefs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompVarNmrRefs')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemCompVarNmrRefs')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllShiftDistributions(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemAtomNmrRef.shiftDistributions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('shiftDistributions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('shiftDistributions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('defaultValue', 'serial', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemAtoms()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemAtoms()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtomShiftCorr(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtomShiftCorrs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomShiftCorrs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = conditions.get('seqOffset')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('chemAtomShiftCorrs').get(objKey)

        if (nConditions <= 3):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chemAtomShiftCorrs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'molType', 'seqOffset', 'value', 'access', 'chemAtomNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompVarNmrRef(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompVarNmrRefs')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemCompVarNmrRefs')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstShiftDistribution(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemAtomNmrRef.shiftDistributions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('shiftDistributions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('shiftDistributions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('defaultValue', 'serial', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrReference.ChemAtomNmrRef
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemAtomNmrRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrReference')
        obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemAtomNmrRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('chemCompNmrRefs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('chemAtomNmrRefs').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtomShiftCorrs(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtomShiftCorrs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtomShiftCorrs').values()
    result = frozenset(tempVar)
    return result
  
  def getChemAtoms(self):
    """
    getter for derived link chemAtoms
    """
    dataDict = self.__dict__
    chemComp = self.topObject.chemComp
    name = self.name
    subType = self.subType
    
    result = chemComp.findAllChemAtoms(name=name, subType=subType)
    
    if not result:
      chemAtomSet = chemComp.findFirstChemAtomSet(name=name, subType=subType)
     
      if chemAtomSet is None:
        raise ApiError(" no ChemAtom or ChemAtomSet found for: %s, %s, %s, %s"
                       % (chemComp.molType, chemComp.ccpCode, name, subType))
    
      else:
        chemAtomSets = [chemAtomSet]
        chemAtoms = []
        for cas in chemAtomSets:
          chemAtomSets.extend(cas.chemAtomSets)
          chemAtoms.extend(cas.chemAtoms)
      #
      result = frozenset(chemAtoms)
    
    return result
  
  def getChemCompNmrRef(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompNmrRef
    """
    dataDict = self.__dict__
    result = dataDict.get('chemCompNmrRef')
    return result
  
  def getChemCompVarNmrRefs(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemCompVarNmrRefs')
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDistribution(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.distribution
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('distribution')
    result = tuple(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('chemCompNmrRef')
    obj1 = obj2.__dict__.get('nmrReferenceStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('sourceName'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMeanValue(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.meanValue
    """
    dataDict = self.__dict__
    result = dataDict.get('meanValue')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNumPoints(self):
    """
    getter for derived attribute numPoints
    """
    dataDict = self.__dict__
    result = len(self.distribution)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemCompNmrRef')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRandomCoilValue(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.randomCoilValue
    """
    dataDict = self.__dict__
    result = dataDict.get('randomCoilValue')
    return result
  
  def getRefPoint(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.refPoint
    """
    dataDict = self.__dict__
    result = dataDict.get('refPoint')
    return result
  
  def getRefValue(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.refValue
    """
    dataDict = self.__dict__
    result = dataDict.get('refValue')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getShiftDistributions(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.shiftDistributions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('shiftDistributions')
    result = frozenset(tempVar)
    return result
  
  def getStdDev(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.stdDev
    """
    dataDict = self.__dict__
    result = dataDict.get('stdDev')
    return result
  
  def getSubType(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.subType
    """
    dataDict = self.__dict__
    result = dataDict.get('subType')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValuePerPoint(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomNmrRef.valuePerPoint
    """
    dataDict = self.__dict__
    result = dataDict.get('valuePerPoint')
    return result
  
  def newChemAtomShiftCorr(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    return ChemAtomShiftCorr(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChemCompVarNmrRef(self, value):
    """
    Remove for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompVarNmrRef)):
      raise ApiError("""%s.removeChemCompVarNmrRef:
       value is not of class ccp.nmr.NmrReference.ChemCompVarNmrRef""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemCompVarNmrRefs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChemCompVarNmrRef:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChemCompVarNmrRef:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChemCompVarNmrRef:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChemCompVarNmrRef:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (len(currentValues) < (1 + 1)):
        raise ApiError("""%s.removeChemCompVarNmrRef:
         locard: currentValues: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    oldSelves = value.__dict__.get('chemAtomNmrRefs')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChemCompVarNmrRef')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeDistribution(self, value):
    """
    Modify command for distribution. Specifically entered here to make sure
    command is disabled
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removeDistribution:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removeDistribution:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('distribution')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeDistribution:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeDistribution:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeDistribution:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    raise ApiError("The %s.removeDistribution operation is not valid and cannot be used" % self.className)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeDistribution')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemCompVarNmrRefs(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemCompVarNmrRefs:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemCompVarNmrRef)):
        raise ApiError("""%s.setChemCompVarNmrRefs:
         value is not of class ccp.nmr.NmrReference.ChemCompVarNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemCompVarNmrRefs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemCompVarNmrRefs:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemCompVarNmrRefs:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemCompVarNmrRefs:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (len(values) < 1):
        raise ApiError("""%s.setChemCompVarNmrRefs:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemCompVarNmrRefs:
           Link chemCompVarNmrRefs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAtomNmrRefs')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAtomNmrRefs')
        oldSelves.add(self)

    dataDict['chemCompVarNmrRefs'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemCompVarNmrRefs')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDistribution(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.distribution
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setDistribution:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setDistribution:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('distribution')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDistribution:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDistribution:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['distribution'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDistribution')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMeanValue(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.meanValue
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setMeanValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setMeanValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('meanValue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeanValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeanValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['meanValue'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMeanValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setRandomCoilValue(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.randomCoilValue
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setRandomCoilValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setRandomCoilValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('randomCoilValue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRandomCoilValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRandomCoilValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['randomCoilValue'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRandomCoilValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefPoint(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.refPoint
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setRefPoint:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setRefPoint:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('refPoint')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRefPoint:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['refPoint'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefValue(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.refValue
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setRefValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setRefValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('refValue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRefValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['refValue'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('chemCompNmrRef')
    oldSerial = parent.__dict__.get('_serialDict').get('chemAtomNmrRefs')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['chemAtomNmrRefs'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['chemAtomNmrRefs'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setShiftDistributions(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.shiftDistributions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setShiftDistributions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemAtomNmrDistrib)):
        raise ApiError("""%s.setShiftDistributions:
         value is not of class ccp.nmr.NmrReference.ChemAtomNmrDistrib""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('shiftDistributions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setShiftDistributions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShiftDistributions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setShiftDistributions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('refAtoms')
          if (len(oldSelves) < (2 + 1)):
            raise ApiError("""%s.setShiftDistributions:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setShiftDistributions:
           Link shiftDistributions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (len(value) == self.ndim)):
            raise ApiError("""%s.setShiftDistributions:
             refAtoms constraint len_refatoms_eq_ndim violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('refAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('refAtoms')
        oldSelves.append(self)

    dataDict['shiftDistributions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setShiftDistributions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStdDev(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.stdDev
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setStdDev:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setStdDev:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stdDev')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStdDev:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStdDev:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stdDev'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStdDev')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSubType(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.subType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSubType:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('subType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSubType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSubType:
         cannot set subType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSubType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['subType'] = value

    # doNotifies
  
  def setValuePerPoint(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomNmrRef.valuePerPoint
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setValuePerPoint:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setValuePerPoint:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('valuePerPoint')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValuePerPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValuePerPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['valuePerPoint'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValuePerPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChemAtomShiftCorrs(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtomShiftCorrs
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chemAtomShiftCorrs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemAtoms(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemAtomNmrRef.chemAtoms
    """
    dataDict = self.__dict__
    ll = self.getChemAtoms()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemCompVarNmrRefs(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemAtomNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemCompVarNmrRefs')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedShiftDistributions(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemAtomNmrRef.shiftDistributions
    """
    dataDict = self.__dict__
    ll = dataDict.get('shiftDistributions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  distribution = property(getDistribution, setDistribution, None,
  r"""histogram of frequency distribution. Normalised - must sum to 1.0. The 
  shifts to which the individual points belong are defined so that point i 
  collects the  shifts from 
  refValue + valuePerPoint*( i-refPoint) to 
  refValue + valuePerPoint*( i+1-refPoint).
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  meanValue = property(getMeanValue, setMeanValue, None,
  r"""Average predicted chemical shift value (in ppm)
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Name of ChemAtom. Part of key for object.
  """)
  
  numPoints = property(getNumPoints, None, None,
  r"""Number of points in shift distribution
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  randomCoilValue = property(getRandomCoilValue, setRandomCoilValue, None,
  r"""Chemical shift for random coil conformation. Need not be the same as the 
  mean value over the known distribution.
  """)
  
  refPoint = property(getRefPoint, setRefPoint, None,
  r"""Reference point number (in floating point, first point is 0.0) for 
  referencing chemical shift axis of distribution.
  """)
  
  refValue = property(getRefValue, setRefValue, None,
  r"""Reference value (in ppm) for setting chemical shift axis of 
  distribution.
  """)
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  stdDev = property(getStdDev, setStdDev, None,
  r"""Standard deviation (in ppm) over the chemical shift distribution
  """)
  
  subType = property(getSubType, setSubType, None,
  r"""subType of ChemAtom referred to.
  """)
  
  valuePerPoint = property(getValuePerPoint, setValuePerPoint, None,
  r"""The value per point on the histogram axis, equivalent to the width of a 
  column.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtomShiftCorrs = property(getChemAtomShiftCorrs,  None, None,
  r"""child link to class ChemAtomShiftCorr
  """)
  
  chemAtoms = property(getChemAtoms, None, None,
  r"""ChemAtom to which reference information applies.
  """)
  
  chemCompNmrRef = property(getChemCompNmrRef,  None, None,
  r"""parent link
  """)
  
  chemCompVarNmrRefs = property(getChemCompVarNmrRefs, setChemCompVarNmrRefs, None,
  r"""ChemCompNmrRefs that contain this ChemAtomNmrRef.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemCompNmrRef
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  shiftDistributions = property(getShiftDistributions, setShiftDistributions, None,
  r"""Chemicasl shift distribution records involving ChemAtomNmrRef
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemAtomShiftCorr(memops.api.Implementation.DataObject):
  r"""Sequence dependent chemical shift correction. The correction is defined 
as ChemAtomShift.randomCoilValue plus the sum of ChemAtomShiftCorr.value 
for all relevant ChemAtomShiftCorr. A ChemAtomShiftCorr with e.g. 
molType='protein', ccpCode='Ala', seqOffset=+1, describes the correction 
to apply to the atom in the current amino acid (which might be e.g. a 
Glu)  to correct for the effect of an alanine at relative position 
+1.

These corrections are specific for a given pair of residue types. 
The correction for e.g. an Alanine at +1 is mostlly the same for a given 
atom (e.g. CA) no matter what amino acid it is in. These general 
corrections are given in the ChemCOmp with ccpCode='Xxx', that serves as 
an 'Any' residue. Pair-specific corrections are only given if they are 
differnt from the geneeric ones, or if the current Atom is not present 
in Xxx.
  """
  #   from data model element ccp.nmr.NmrReference.ChemAtomShiftCorr revision ?
  _metaclass = metaPackage.getElement('ChemAtomShiftCorr')
  _packageName = 'ccp.nmr.NmrReference'
  _packageShortName = 'NMRR'
  _fieldNames = ('applicationData', 'ccpCode', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'molType', 'packageName', 'packageShortName', 'qualifiedName', 'seqOffset', 'value', 'access', 'activeAccess', 'chemAtomNmrRef', 'chemComp', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    dataDict['chemAtomNmrRef'] = parent
    if (not isinstance(parent, ChemAtomNmrRef)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['ccpCode'] = None
      dataDict['molType'] = None
      dataDict['seqOffset'] = None
      dataDict['value'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrReference.ChemAtomShiftCorr.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAtomShiftCorrs')
        ll = list()
        objKey = dataDict.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = dataDict.get('seqOffset')
            ll.append(objKey)
            if (objKey is not None):
              objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molType', 'ccpCode', 'seqOffset'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrReference.ChemAtomShiftCorr:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrReference.ChemAtomShiftCorr:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    chemAtomNmrRef = dataDict.get('chemAtomNmrRef')
    if (not (chemAtomNmrRef in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('seqOffset')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemAtomNmrRef.__dict__.get('chemAtomShiftCorrs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('seqOffset')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemAtomNmrRef')
        dd = value.__dict__.get('chemAtomShiftCorrs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemAtomNmrRef' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ccpCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molType')
      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqOffset')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: seqOffset:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: value:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: value:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemAtomNmrRef')
      if (not isinstance(value, ChemAtomNmrRef)):
        raise ApiError("""%s.checkValid: chemAtomNmrRef:
         value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getChemComp()
      if (value is None):
        raise ApiError("""%s.checkValid: chemComp:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import ChemComp as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemComp:
         Link chemComp between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('ccpCode')
    if (value is None):
      raise ApiError("""%s.checkValid: ccpCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molType')
    if (value is None):
      raise ApiError("""%s.checkValid: molType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqOffset')
    if (value is None):
      raise ApiError("""%s.checkValid: seqOffset:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (value != 0)):
      raise ApiError("""%s.checkValid: seqOffset:
       seqOffset constraint value_is_nonzero violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('value')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chemAtomNmrRef')
    if (value is None):
      raise ApiError("""%s.checkValid: chemAtomNmrRef:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (7 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemAtomShiftCorr'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrReference')
        obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)

    else:
      if (5 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemAtomShiftCorr'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-5]
      obj2 = obj1.__dict__.get('chemCompNmrRefs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-4]
        obj3 = obj2.__dict__.get('chemAtomNmrRefs').get(objKey)

        if (obj3 is not None):
          ll = list()
          objKey = fullKey[-3]
          ll.append(objKey)
          if (objKey is not None):
            objKey = fullKey[-2]
            ll.append(objKey)
            if (objKey is not None):
              objKey = fullKey[-1]
              ll.append(objKey)
              if (objKey is not None):
                objKey = tuple(ll)

          obj4 = obj3.__dict__.get('chemAtomShiftCorrs').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCcpCode(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomShiftCorr.ccpCode
    """
    dataDict = self.__dict__
    result = dataDict.get('ccpCode')
    return result
  
  def getChemAtomNmrRef(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomShiftCorr.chemAtomNmrRef
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtomNmrRef')
    return result
  
  def getChemComp(self):
    """
    getter for derived link chemComp
    """
    dataDict = self.__dict__
    result = self.root.findFirstChemComp(molType=self.molType, ccpCode=self.ccpCode)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('chemAtomNmrRef')
    obj2 = obj3.__dict__.get('chemCompNmrRef')
    obj1 = obj2.__dict__.get('nmrReferenceStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('sourceName'))
    result.append(obj3.__dict__.get('serial'))
    result.append(dataDict.get('molType'))
    result.append(dataDict.get('ccpCode'))
    result.append(dataDict.get('seqOffset'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('molType')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('ccpCode')
      ll.append(result)
      if (result is not None):
        result = dataDict.get('seqOffset')
        ll.append(result)
        if (result is not None):
          result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolType(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomShiftCorr.molType
    """
    dataDict = self.__dict__
    result = dataDict.get('molType')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomShiftCorr.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtomNmrRef')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSeqOffset(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomShiftCorr.seqOffset
    """
    dataDict = self.__dict__
    result = dataDict.get('seqOffset')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValue(self):
    """
    Get for ccp.nmr.NmrReference.ChemAtomShiftCorr.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrReference.ChemAtomShiftCorr
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCcpCode(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomShiftCorr.ccpCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCcpCode:
       LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ccpCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCcpCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCcpCode:
         cannot set ccpCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCcpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ccpCode'] = value

    # doNotifies
  
  def setMolType(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomShiftCorr.molType
    """
    dataDict = self.__dict__
    if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
      raise ApiError("""%s.setMolType:
       ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolType:
       MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolType:
         cannot set molType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molType'] = value

    # doNotifies
  
  def setSeqOffset(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomShiftCorr.seqOffset
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSeqOffset:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqOffset')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqOffset:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSeqOffset:
         cannot set seqOffset, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSeqOffset:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (value != 0)):
            raise ApiError("""%s.setSeqOffset:
             seqOffset constraint value_is_nonzero violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['seqOffset'] = value

    # doNotifies
  
  def setValue(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemAtomShiftCorr.value
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['value'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  ccpCode = property(getCcpCode, setCcpCode, None,
  r"""ccpCode of residue being corrected for
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, setMolType, None,
  r"""molType of residue being corrected for
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  seqOffset = property(getSeqOffset, setSeqOffset, None,
  r"""Sequence offset of residue being corrected for
  """)
  
  value = property(getValue, setValue, None,
  r"""Value of chemical shift sequence correction
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtomNmrRef = property(getChemAtomNmrRef,  None, None,
  r"""parent link
  """)
  
  chemComp = property(getChemComp, None, None,
  r"""ChemComp to which Shift correction information refers.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemAtomNmrRef
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemCompNmrRef(memops.api.Implementation.DataObject):
  r"""NMR reference information for a given ChemComp as presented from a given 
source. 
  """
  #   from data model element ccp.nmr.NmrReference.ChemCompNmrRef revision ?
  _metaclass = metaPackage.getElement('ChemCompNmrRef')
  _packageName = 'ccp.nmr.NmrReference'
  _packageShortName = 'NMRR'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'sourceName', 'access', 'activeAccess', 'chemAtomNmrDistribs', 'chemAtomNmrRefs', 'chemCompVarNmrRefs', 'nmrReferenceStore', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    dataDict['nmrReferenceStore'] = parent
    if (not isinstance(parent, NmrReferenceStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrReference.NmrReferenceStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['sourceName'] = None
      dataDict['access'] = None
      dataDict['chemAtomNmrDistribs'] = {}
      dataDict['chemAtomNmrRefs'] = {}
      dataDict['chemCompVarNmrRefs'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrReference.ChemCompNmrRef.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['chemAtomNmrDistribs'] = 0
      serialDict['chemAtomNmrRefs'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemCompNmrRefs')
        objKey = dataDict.get('sourceName')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['sourceName'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrReference.ChemCompNmrRef:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chemAtomNmrDistribs = dataDict.get('chemAtomNmrDistribs').values()
    for chemAtomNmrDistrib in chemAtomNmrDistribs:
      if (not (chemAtomNmrDistrib in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtomNmrDistrib)
        objsToBeChecked.append(chemAtomNmrDistrib)

    chemAtomNmrRefs = dataDict.get('chemAtomNmrRefs').values()
    for chemAtomNmrRef in chemAtomNmrRefs:
      if (not (chemAtomNmrRef in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtomNmrRef)
        objsToBeChecked.append(chemAtomNmrRef)

    chemCompVarNmrRefs = dataDict.get('chemCompVarNmrRefs').values()
    for chemCompVarNmrRef in chemCompVarNmrRefs:
      if (not (chemCompVarNmrRef in objsToBeDeleted)):
        objsToBeDeleted.add(chemCompVarNmrRef)
        objsToBeChecked.append(chemCompVarNmrRef)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrReference.ChemCompNmrRef:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    nmrReferenceStore = dataDict.get('nmrReferenceStore')
    if (not (nmrReferenceStore in objsToBeDeleted)):
      objKey = dataDict.get('sourceName')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = nmrReferenceStore.__dict__.get('chemCompNmrRefs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('chemAtomNmrDistribs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemAtomNmrRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemCompVarNmrRefs').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('sourceName')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('nmrReferenceStore')
        dd = value.__dict__.get('chemCompNmrRefs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'nmrReferenceStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sourceName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: sourceName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: sourceName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: sourceName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: sourceName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtomNmrDistribs').values()
      for value in values:
        if (not isinstance(value, ChemAtomNmrDistrib)):
          raise ApiError("""%s.checkValid: chemAtomNmrDistribs:
           value is not of class ccp.nmr.NmrReference.ChemAtomNmrDistrib""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemCompNmrRef')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtomNmrDistribs:
           non-reciprocal link chemAtomNmrDistribs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAtomNmrRefs').values()
      for value in values:
        if (not isinstance(value, ChemAtomNmrRef)):
          raise ApiError("""%s.checkValid: chemAtomNmrRefs:
           value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemCompNmrRef')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtomNmrRefs:
           non-reciprocal link chemAtomNmrRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemCompVarNmrRefs').values()
      for value in values:
        if (not isinstance(value, ChemCompVarNmrRef)):
          raise ApiError("""%s.checkValid: chemCompVarNmrRefs:
           value is not of class ccp.nmr.NmrReference.ChemCompVarNmrRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemCompNmrRef')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompVarNmrRefs:
           non-reciprocal link chemCompVarNmrRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('nmrReferenceStore')
      if (not isinstance(value, NmrReferenceStore)):
        raise ApiError("""%s.checkValid: nmrReferenceStore:
         value is not of class ccp.nmr.NmrReference.NmrReferenceStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('sourceName')
    if (value is None):
      raise ApiError("""%s.checkValid: sourceName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtomNmrDistribs').values()
    values = dataDict.get('chemAtomNmrRefs').values()
    values = dataDict.get('chemCompVarNmrRefs').values()
    value = dataDict.get('nmrReferenceStore')
    if (value is None):
      raise ApiError("""%s.checkValid: nmrReferenceStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtomNmrDistribs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrDistribs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomNmrDistribs').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtomNmrDistribs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('defaultValue', 'serial', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtomNmrRefs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomNmrRefs').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtomNmrRefs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('meanValue', 'name', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompVarNmrRefs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemCompNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompVarNmrRefs').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemCompVarNmrRefs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtomNmrDistrib(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrDistribs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomNmrDistribs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('chemAtomNmrDistribs').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chemAtomNmrDistribs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('defaultValue', 'serial', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtomNmrRef(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomNmrRefs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('chemAtomNmrRefs').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chemAtomNmrRefs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('meanValue', 'name', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompVarNmrRef(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemCompNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompVarNmrRefs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('linking')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('descriptor')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('chemCompVarNmrRefs').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chemCompVarNmrRefs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrReference.ChemCompNmrRef
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemCompNmrRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrReference')
        obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemCompNmrRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('chemCompNmrRefs').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtomNmrDistribs(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrDistribs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtomNmrDistribs').values()
    result = frozenset(tempVar)
    return result
  
  def getChemAtomNmrRefs(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtomNmrRefs').values()
    result = frozenset(tempVar)
    return result
  
  def getChemCompVarNmrRefs(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemCompVarNmrRefs').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetails(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('nmrReferenceStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('sourceName'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    result = dataDict.get('sourceName')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNmrReferenceStore(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.nmrReferenceStore
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrReferenceStore')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrReferenceStore')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSourceName(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompNmrRef.sourceName
    """
    dataDict = self.__dict__
    result = dataDict.get('sourceName')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newChemAtomNmrDistrib(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrReference.ChemAtomNmrDistrib
    """
    return ChemAtomNmrDistrib(self, **attrlinks)
  
  def newChemAtomNmrRef(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrReference.ChemAtomNmrRef
    """
    return ChemAtomNmrRef(self, **attrlinks)
  
  def newChemCompVarNmrRef(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    return ChemCompVarNmrRef(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrReference.ChemCompNmrRef
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetails(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemCompNmrRef.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSourceName(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemCompNmrRef.sourceName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSourceName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setSourceName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setSourceName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setSourceName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('sourceName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSourceName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSourceName:
         cannot set sourceName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSourceName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['sourceName'] = value

    # doNotifies
  
  def sortedChemAtomNmrDistribs(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrDistribs
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chemAtomNmrDistribs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemAtomNmrRefs(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemCompNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chemAtomNmrRefs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemCompVarNmrRefs(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemCompNmrRef.chemCompVarNmrRefs
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chemCompVarNmrRefs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  sourceName = property(getSourceName, setSourceName, None,
  r"""Name of the source for the reference data. Serves as the key for the 
  class. Serves to distinguish NMR reference data from different sources, 
  in case different programs want to keep their own.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtomNmrDistribs = property(getChemAtomNmrDistribs,  None, None,
  r"""child link to class ChemAtomNmrDistrib
  """)
  
  chemAtomNmrRefs = property(getChemAtomNmrRefs,  None, None,
  r"""child link to class ChemAtomNmrRef
  """)
  
  chemCompVarNmrRefs = property(getChemCompVarNmrRefs,  None, None,
  r"""child link to class ChemCompVarNmrRef
  """)
  
  nmrReferenceStore = property(getNmrReferenceStore,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for nmrReferenceStore
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemCompVarNmrRef(memops.api.Implementation.DataObject):
  r"""ChemCompVar to which chemAtomNmrRef children belong.  Note: atoms 
belonging to Vars with an 'any' attribute must belong to all the 
relevant Vars
  """
  #   from data model element ccp.nmr.NmrReference.ChemCompVarNmrRef revision ?
  _metaclass = metaPackage.getElement('ChemCompVarNmrRef')
  _packageName = 'ccp.nmr.NmrReference'
  _packageShortName = 'NMRR'
  _fieldNames = ('applicationData', 'className', 'descriptor', 'fieldNames', 'inConstructor', 'isDeleted', 'linking', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'chemAtomNmrRefs', 'chemCompNmrRef', 'chemCompVars', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    dataDict['chemCompNmrRef'] = parent
    if (not isinstance(parent, ChemCompNmrRef)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['descriptor'] = 'any'
      dataDict['linking'] = 'any'
      dataDict['access'] = None
      dataDict['chemAtomNmrRefs'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrReference.ChemCompVarNmrRef.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemCompVarNmrRefs')
        ll = list()
        objKey = dataDict.get('linking')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('descriptor')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['linking', 'descriptor'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrReference.ChemCompVarNmrRef:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chemAtomNmrRefs = dataDict.get('chemAtomNmrRefs')
    for chemAtomNmrRef in chemAtomNmrRefs:
      if (not (chemAtomNmrRef in objsToBeDeleted)):
        backlink = chemAtomNmrRef.__dict__.get('chemCompVarNmrRefs')
        key = (chemAtomNmrRef, 'chemCompVarNmrRefs')
        nFound = linkCounter.get(key)
        if (nFound is None):
          nFound = 1
        else:
          nFound = nFound + 1
          del linkCounter[key]

        if (len(backlink) - nFound < 1):
          objsToBeDeleted.add(chemAtomNmrRef)
          objsToBeChecked.append(chemAtomNmrRef)
        else:
          linkCounter[key] = nFound

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrReference.ChemCompVarNmrRef:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemAtomNmrRef in dataDict.get('chemAtomNmrRefs'):
      if (not (chemAtomNmrRef in objsToBeDeleted)):
        chemCompVarNmrRefs = chemAtomNmrRef.__dict__.get('chemCompVarNmrRefs')
        chemCompVarNmrRefs.remove(self)

    chemCompNmrRef = dataDict.get('chemCompNmrRef')
    if (not (chemCompNmrRef in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('linking')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('descriptor')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemCompNmrRef.__dict__.get('chemCompVarNmrRefs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChemAtomNmrRef(self, value):
    """
    Add for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtomNmrRef)):
      raise ApiError("""%s.addChemAtomNmrRef:
       value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtomNmrRefs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChemAtomNmrRef:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChemAtomNmrRef:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChemAtomNmrRef:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChemAtomNmrRef:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChemAtomNmrRef:
           Link chemAtomNmrRefs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('chemCompVarNmrRefs')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChemAtomNmrRef')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('linking')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('descriptor')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemCompNmrRef')
        dd = value.__dict__.get('chemCompVarNmrRefs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemCompNmrRef' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('descriptor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: descriptor:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('linking')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linking:
         ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtomNmrRefs')
      for value in values:
        if (not isinstance(value, ChemAtomNmrRef)):
          raise ApiError("""%s.checkValid: chemAtomNmrRefs:
           value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemCompVarNmrRefs')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtomNmrRefs:
           non-reciprocal link chemAtomNmrRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtomNmrRefs:
           Link chemAtomNmrRefs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemCompNmrRef')
      if (not isinstance(value, ChemCompNmrRef)):
        raise ApiError("""%s.checkValid: chemCompNmrRef:
         value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getChemCompVars()
      if (len(values) < 1):
        raise ApiError("""%s.checkValid: chemCompVars:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      for value in values:
        from ccp.api.molecule.ChemComp import ChemCompVar as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemCompVars:
           Link chemCompVars between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    linking = self.linking
    descriptor = self.descriptor
    
    isValid = True
    
    if linking == 'any' and descriptor == 'any':
      nVars = len(self.chemCompNmrRef.chemCompVarNmrRefs)
      for atom in self.chemAtomNmrRefs:
        if len(atom.chemCompVarNmrRefs) != nVars:
          isValid = False
          break 
    
    elif linking == 'any':
      otherVars = list(self.chemCompNmrRef.findAllChemCompVarNmrRefs(descriptor=descriptor))
      otherVars.remove(self)
      for atom in self.chemAtomNmrRefs:
        ll = atom.chemCompVarNmrRefs
        for var in otherVars:
          if var not in ll:
            isValid = False
            break
    
    elif descriptor == 'any':
      otherVars = list(self.chemCompNmrRef.findAllChemCompVarNmrRefs(linking=linking))
      otherVars.remove(self)
      for atom in self.chemAtomNmrRefs:
        ll = atom.chemCompVarNmrRefs
        for var in otherVars:
          if var not in ll:
            isValid = False
            break
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint any_attributes_imply_atoms_shared_with_all_specific_vars violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('descriptor')
    if (value is None):
      raise ApiError("""%s.checkValid: descriptor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('linking')
    if (value is None):
      raise ApiError("""%s.checkValid: linking:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtomNmrRefs')
    value = dataDict.get('chemCompNmrRef')
    if (value is None):
      raise ApiError("""%s.checkValid: chemCompNmrRef:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtomNmrRefs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomNmrRefs')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtomNmrRefs')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('meanValue', 'name', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompVars(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompVars()
      result = set(currentValues)

    else:
      currentValues = self.getChemCompVars()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtomNmrRef(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomNmrRefs')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtomNmrRefs')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('meanValue', 'name', 'randomCoilValue', 'refPoint', 'refValue', 'serial', 'stdDev', 'subType', 'valuePerPoint', 'access', 'chemCompNmrRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompVar(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompVars()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemCompVars()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemCompVarNmrRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrReference')
        obj1 = obj0.__dict__.get('nmrReferenceStores').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrReference.ChemCompVarNmrRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('chemCompNmrRefs').get(objKey)

      if (obj2 is not None):
        ll = list()
        objKey = fullKey[-2]
        ll.append(objKey)
        if (objKey is not None):
          objKey = fullKey[-1]
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        obj3 = obj2.__dict__.get('chemCompVarNmrRefs').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtomNmrRefs(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtomNmrRefs')
    result = frozenset(tempVar)
    return result
  
  def getChemCompNmrRef(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemCompNmrRef
    """
    dataDict = self.__dict__
    result = dataDict.get('chemCompNmrRef')
    return result
  
  def getChemCompVars(self):
    """
    getter for derived link chemCompVars
    """
    dataDict = self.__dict__
    chemComp = self.topObject.chemComp
    linking = self.linking
    descriptor = self.descriptor
    
    if linking == 'any' and descriptor == 'any':
      result = chemComp.chemCompVars
    elif linking == 'any' :
      result = chemComp.findAllChemCompVars(descriptor=descriptor)
    elif descriptor == 'any' :
      result = chemComp.findAllChemCompVars(linking=linking)
    else:
      result = chemComp.findAllChemCompVars(linking=linking, descriptor=descriptor)
    #
    result = frozenset(result)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDescriptor(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompVarNmrRef.descriptor
    """
    dataDict = self.__dict__
    result = dataDict.get('descriptor')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('chemCompNmrRef')
    obj1 = obj2.__dict__.get('nmrReferenceStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('sourceName'))
    result.append(dataDict.get('linking'))
    result.append(dataDict.get('descriptor'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLinking(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompVarNmrRef.linking
    """
    dataDict = self.__dict__
    result = dataDict.get('linking')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('linking')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('descriptor')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrReference.ChemCompVarNmrRef.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemCompNmrRef')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChemAtomNmrRef(self, value):
    """
    Remove for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtomNmrRef)):
      raise ApiError("""%s.removeChemAtomNmrRef:
       value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtomNmrRefs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChemAtomNmrRef:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChemAtomNmrRef:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChemAtomNmrRef:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChemAtomNmrRef:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      oldSelves = value.__dict__.get('chemCompVarNmrRefs')
      if (len(oldSelves) < (1 + 1)):
        raise ApiError("""%s.removeChemAtomNmrRef:
         locard: oldSelves: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    oldSelves = value.__dict__.get('chemCompVarNmrRefs')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChemAtomNmrRef')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrReference.ChemCompVarNmrRef
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAtomNmrRefs(self, values):
    """
    Set for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtomNmrRefs:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemAtomNmrRef)):
        raise ApiError("""%s.setChemAtomNmrRefs:
         value is not of class ccp.nmr.NmrReference.ChemAtomNmrRef""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtomNmrRefs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtomNmrRefs:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtomNmrRefs:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtomNmrRefs:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('chemCompVarNmrRefs')
          if (len(oldSelves) < (1 + 1)):
            raise ApiError("""%s.setChemAtomNmrRefs:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtomNmrRefs:
           Link chemAtomNmrRefs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemCompVarNmrRefs')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemCompVarNmrRefs')
        oldSelves.add(self)

    dataDict['chemAtomNmrRefs'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtomNmrRefs')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDescriptor(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemCompVarNmrRef.descriptor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setDescriptor:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('descriptor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDescriptor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDescriptor:
         cannot set descriptor, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDescriptor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['descriptor'] = value

    # doNotifies
  
  def setLinking(self, value):
    """
    Set for ccp.nmr.NmrReference.ChemCompVarNmrRef.linking
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinking:
       ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linking')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinking:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLinking:
         cannot set linking, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLinking:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['linking'] = value

    # doNotifies
  
  def sortedChemAtomNmrRefs(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemAtomNmrRefs
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemAtomNmrRefs')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemCompVars(self):
    """
    Sorted for ccp.nmr.NmrReference.ChemCompVarNmrRef.chemCompVars
    """
    dataDict = self.__dict__
    ll = self.getChemCompVars()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  descriptor = property(getDescriptor, setDescriptor, None,
  r"""descriptor for corresponding ChemCompVar  - default is 'any'
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  linking = property(getLinking, setLinking, None,
  r"""linking for corresponding ChemCompVar  - default is 'any'
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtomNmrRefs = property(getChemAtomNmrRefs, setChemAtomNmrRefs, None,
  r"""ChemAtomNmrRefs relevant for this ChemCompVarNmrRef
  """)
  
  chemCompNmrRef = property(getChemCompNmrRef,  None, None,
  r"""parent link
  """)
  
  chemCompVars = property(getChemCompVars, None, None,
  r"""chemCompVars corerspnding to ChemCompVarNmrRef
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemCompNmrRef
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class NmrReferenceStore(memops.api.Implementation.TopObject):
  r"""TopObject for ChemComp specific Nmr Reference Data. Serves as a local 
handle, holding information about where the actual data are stored.
  """
  #   from data model element ccp.nmr.NmrReference.NmrReferenceStore revision ?
  _metaclass = metaPackage.getElement('NmrReferenceStore')
  _packageName = 'ccp.nmr.NmrReference'
  _packageShortName = 'NMRR'
  _fieldNames = ('applicationData', 'ccpCode', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'molType', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'chemComp', 'chemCompNmrRefs', 'memopsRoot', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.nmr.NmrReference')

      dataDict['applicationData'] = list()
      dataDict['ccpCode'] = None
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['molType'] = None
      dataDict['name'] = 'auto'
      dataDict['access'] = None
      dataDict['chemCompNmrRefs'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrReference.NmrReferenceStore.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('nmrReferenceStores')
        ll = list()
        objKey = dataDict.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molType', 'ccpCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentNmrReferenceStore') is None)):
        root.__dict__['currentNmrReferenceStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrReference.NmrReferenceStore:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chemCompNmrRefs = dataDict.get('chemCompNmrRefs').values()
    for chemCompNmrRef in chemCompNmrRefs:
      if (not (chemCompNmrRef in objsToBeDeleted)):
        objsToBeDeleted.add(chemCompNmrRef)
        objsToBeChecked.append(chemCompNmrRef)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrReference.NmrReferenceStore:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentNmrReferenceStore')):
      memopsRoot.__dict__['currentNmrReferenceStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('nmrReferenceStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['chemCompNmrRefs'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('chemCompNmrRefs').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('nmrReferenceStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ccpCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getChemComp()
      if (value is None):
        raise ApiError("""%s.checkValid: chemComp:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import ChemComp as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemComp:
         Link chemComp between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('chemCompNmrRefs').values()
      for value in values:
        if (not isinstance(value, ChemCompNmrRef)):
          raise ApiError("""%s.checkValid: chemCompNmrRefs:
           value is not of class ccp.nmr.NmrReference.ChemCompNmrRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('nmrReferenceStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompNmrRefs:
           non-reciprocal link chemCompNmrRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('ccpCode')
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('molType')
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('chemCompNmrRefs').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('molType')
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('ccpCode')
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemCompNmrRefs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrReference.NmrReferenceStore.chemCompNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemCompNmrRefs').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemCompNmrRefs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'sourceName', 'access', 'nmrReferenceStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemCompNmrRef(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrReference.NmrReferenceStore.chemCompNmrRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemCompNmrRefs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('sourceName')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemCompNmrRefs').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemCompNmrRefs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'sourceName', 'access', 'nmrReferenceStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrReference.NmrReferenceStore
    """

    result = None
    if (2 != len(fullKey)):
      raise ApiError("""'ccp.nmr.NmrReference.NmrReferenceStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    ll = list()
    objKey = fullKey[0]
    ll.append(objKey)
    if (objKey is not None):
      objKey = fullKey[1]
      ll.append(objKey)
      if (objKey is not None):
        objKey = tuple(ll)

    obj1 = startObj.__dict__.get('nmrReferenceStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.nmr.NmrReference')
      obj1 = startObj.__dict__.get('nmrReferenceStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCcpCode(self):
    """
    Get for ccp.nmr.NmrReference.NmrReferenceStore.ccpCode
    """
    dataDict = self.__dict__
    result = dataDict.get('ccpCode')
    return result
  
  def getChemComp(self):
    """
    getter for derived link chemComp
    """
    dataDict = self.__dict__
    result = self.root.findFirstChemComp(molType=self.molType, ccpCode=self.ccpCode)
    return result
  
  def getChemCompNmrRefs(self):
    """
    Get for ccp.nmr.NmrReference.NmrReferenceStore.chemCompNmrRefs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemCompNmrRefs').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('molType'))
      result.append(dataDict.get('ccpCode'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('molType')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('ccpCode')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.nmr.NmrReference.NmrReferenceStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolType(self):
    """
    Get for ccp.nmr.NmrReference.NmrReferenceStore.molType
    """
    dataDict = self.__dict__
    result = dataDict.get('molType')
    return result
  
  def getName(self):
    """
    Get for ccp.nmr.NmrReference.NmrReferenceStore.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrReference.NmrReferenceStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newChemCompNmrRef(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrReference.ChemCompNmrRef
    """
    return ChemCompNmrRef(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrReference.NmrReferenceStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCcpCode(self, value):
    """
    Set for ccp.nmr.NmrReference.NmrReferenceStore.ccpCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCcpCode:
       LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('ccpCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCcpCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCcpCode:
         cannot set ccpCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCcpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ccpCode'] = value

    # doNotifies

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setMolType(self, value):
    """
    Set for ccp.nmr.NmrReference.NmrReferenceStore.molType
    """
    dataDict = self.__dict__
    if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
      raise ApiError("""%s.setMolType:
       ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolType:
       MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('molType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolType:
         cannot set molType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molType'] = value

    # doNotifies
  
  def setName(self, value):
    """
    Set for ccp.nmr.NmrReference.NmrReferenceStore.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChemCompNmrRefs(self):
    """
    Sorted for ccp.nmr.NmrReference.NmrReferenceStore.chemCompNmrRefs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemCompNmrRefs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  ccpCode = property(getCcpCode, setCcpCode, None,
  r"""ccpCode for relevant ChemComp.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, setMolType, None,
  r"""Molecule Type of referenced ChemComp
  """)
  
  name = property(getName, setName, None,
  r"""name of NmrReferenceStore
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  chemComp = property(getChemComp, None, None,
  r"""ChemComp that NmrReference data apply to
  """)
  
  chemCompNmrRefs = property(getChemCompNmrRefs,  None, None,
  r"""child link to class ChemCompNmrRef
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
