"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Mon Mar  2 17:25:56 2015
  from data model element ccp.molecule.MolSystem revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

MolSystem.py: python API for CCPN data model, MetaPackage ccp.molecule.MolSystem

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Citation
import ccp.api.general.DbRef
import ccp.api.molecule.ChemComp
import ccp.api.molecule.Molecule
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.molecule.MolSystem')

###############################################################################
class Atom(memops.api.Implementation.DataObject):
  r"""Atom in a specific location in a specific molecule in specific 
surroundings (Chain).

Atoms can *not* be deleted while they are linked 
to FixedAtomSets. If this is desired the fixedAtomSets link must be 
cleared first.
  """
  #   from data model element ccp.molecule.MolSystem.Atom revision ?
  _metaclass = metaPackage.getElement('Atom')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'atomSet', 'chainStateSets', 'chemAtom', 'fixedAtomSets', 'molSysAtomValidations', 'nonCovalentBonds', 'parent', 'residue', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    dataDict['residue'] = parent
    if (not isinstance(parent, Residue)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['atomSet'] = None
      dataDict['chainStateSets'] = set()
      dataDict['fixedAtomSets'] = set()
      dataDict['molSysAtomValidations'] = set()
      dataDict['nonCovalentBonds'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.Atom.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('atoms')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.Atom:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    if (dataDict.get('atomSet') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    atomSet = dataDict.get('atomSet')
    if (atomSet is not None):
      if (not (atomSet in objsToBeDeleted)):
        objsToBeDeleted.add(atomSet)
        objsToBeChecked.append(atomSet)

      topObject = atomSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    chainStateSets = dataDict.get('chainStateSets')
    pass
    for chainStateSet in chainStateSets:
      topObject = chainStateSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tobjList = root.__dict__.get('nmrConstraintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    fixedAtomSets = dataDict.get('fixedAtomSets')
    for fixedAtomSet in fixedAtomSets:
      if (not (fixedAtomSet in objsToBeDeleted)):
        backlink = fixedAtomSet.__dict__.get('atoms')
        key = (fixedAtomSet, 'atoms')
        nFound = linkCounter.get(key)
        if (nFound is None):
          nFound = 1
        else:
          nFound = nFound + 1
          del linkCounter[key]

        if (len(backlink) - nFound < 1):
          objsToBeDeleted.add(fixedAtomSet)
          objsToBeChecked.append(fixedAtomSet)
        else:
          linkCounter[key] = nFound

    for fixedAtomSet in fixedAtomSets:
      topObject = fixedAtomSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSysAtomValidations = dataDict.get('molSysAtomValidations')
    pass
    for molSysAtomValidation in molSysAtomValidations:
      topObject = molSysAtomValidation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    nonCovalentBonds = dataDict.get('nonCovalentBonds')
    for nonCovalentBond in nonCovalentBonds:
      if (not (nonCovalentBond in objsToBeDeleted)):
        objsToBeDeleted.add(nonCovalentBond)
        objsToBeChecked.append(nonCovalentBond)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.Atom:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chainStateSet in dataDict.get('chainStateSets'):
      if (not (chainStateSet in objsToBeDeleted)):
        atoms = chainStateSet.__dict__.get('atoms')
        atoms.remove(self)

    for fixedAtomSet in dataDict.get('fixedAtomSets'):
      if (not (fixedAtomSet in objsToBeDeleted)):
        atoms = fixedAtomSet.__dict__.get('atoms')
        atoms.remove(self)

    for molSysAtomValidation in dataDict.get('molSysAtomValidations'):
      if (not (molSysAtomValidation in objsToBeDeleted)):
        atoms = molSysAtomValidation.__dict__.get('atoms')
        atoms.remove(self)

    residue = dataDict.get('residue')
    if (not (residue in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = residue.__dict__.get('atoms')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChainStateSet(self, value):
    """
    Add for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ChainStateSet as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addChainStateSet:
       value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChainStateSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChainStateSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChainStateSet:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChainStateSet:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChainStateSet:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (self.chain is value.residue.chain)):
            raise ApiError("""%s.addChainStateSet:
             atoms constraint self_chain_is_value_residue_chain violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelves = value.__dict__.get('atoms')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChainStateSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addFixedAtomSet(self, value):
    """
    Add for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrConstraint import FixedAtomSet as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addFixedAtomSet:
       value is not of class ccp.nmr.NmrConstraint.FixedAtomSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tobjList = root.__dict__.get('nmrConstraintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('fixedAtomSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addFixedAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addFixedAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addFixedAtomSet:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addFixedAtomSet:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addFixedAtomSet:
           Link fixedAtomSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('atoms')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addFixedAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolSysAtomValidation(self, value):
    """
    Add for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSysAtomValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolSysAtomValidation:
       value is not of class ccp.molecule.Validation.MolSysAtomValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysAtomValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolSysAtomValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolSysAtomValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolSysAtomValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolSysAtomValidation:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolSysAtomValidation:
           Link molSysAtomValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('atoms')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolSysAtomValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('residue')
        dd = value.__dict__.get('atoms')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'residue' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (dataDict.get('atomSet') is None):
        root = dataDict.get('topObject').__dict__.get('memopsRoot')
        root.refreshTopObjects('ccp.nmr.Nmr')
        tobjList = root.__dict__.get('nmrProjects').values()
        for tobj in tobjList:
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      value = dataDict.get('atomSet')
      if (value is not None):
        from ccp.api.nmr.Nmr import AtomSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: atomSet:
           value is not of class ccp.nmr.Nmr.AtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: atomSet:
           non-reciprocal link atomSet from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('chainStateSets')
      for value in values:
        from ccp.api.nmr.Nmr import ChainStateSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chainStateSets:
           value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chainStateSets:
           non-reciprocal link chainStateSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getChemAtom()
      if (value is None):
        raise ApiError("""%s.checkValid: chemAtom:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import ChemAtom as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemAtom:
         value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemAtom:
         Link chemAtom between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      tobjList = root.__dict__.get('nmrConstraintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('fixedAtomSets')
      for value in values:
        from ccp.api.nmr.NmrConstraint import FixedAtomSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: fixedAtomSets:
           value is not of class ccp.nmr.NmrConstraint.FixedAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: fixedAtomSets:
           non-reciprocal link fixedAtomSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSysAtomValidations')
      for value in values:
        from ccp.api.molecule.Validation import MolSysAtomValidation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSysAtomValidations:
           value is not of class ccp.molecule.Validation.MolSysAtomValidation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSysAtomValidations:
           non-reciprocal link molSysAtomValidations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('nonCovalentBonds')
      for value in values:
        if (not isinstance(value, NonCovalentBond)):
          raise ApiError("""%s.checkValid: nonCovalentBonds:
           value is not of class ccp.molecule.MolSystem.NonCovalentBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nonCovalentBonds:
           non-reciprocal link nonCovalentBonds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nonCovalentBonds:
           Link nonCovalentBonds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('residue')
      if (not isinstance(value, Residue)):
        raise ApiError("""%s.checkValid: residue:
         value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('atomSet')
    values = dataDict.get('chainStateSets')
    for value in values:
      (self, value) = (value, self)
      if (not (self.chain is value.residue.chain)):
        raise ApiError("""%s.checkValid: chainStateSets:
         atoms constraint self_chain_is_value_residue_chain violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

    values = dataDict.get('fixedAtomSets')
    values = dataDict.get('molSysAtomValidations')
    values = dataDict.get('nonCovalentBonds')
    value = dataDict.get('residue')
    if (value is None):
      raise ApiError("""%s.checkValid: residue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChainStateSets(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stateSetType', 'access', 'chain', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllFixedAtomSets(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      tobjList = root.__dict__.get('nmrConstraintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('fixedAtomSets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      tobjList = root.__dict__.get('nmrConstraintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('fixedAtomSets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'nmrConstraintStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSysAtomValidations(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysAtomValidations')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysAtomValidations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNonCovalentBonds(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Atom.nonCovalentBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('nonCovalentBonds')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('nonCovalentBonds')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChainStateSet(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stateSetType', 'access', 'chain', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstFixedAtomSet(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      tobjList = root.__dict__.get('nmrConstraintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('fixedAtomSets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      tobjList = root.__dict__.get('nmrConstraintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('fixedAtomSets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'nmrConstraintStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSysAtomValidation(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysAtomValidations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysAtomValidations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNonCovalentBond(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Atom.nonCovalentBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('nonCovalentBonds')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('nonCovalentBonds')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomSet(self):
    """
    Get for ccp.molecule.MolSystem.Atom.atomSet
    """
    dataDict = self.__dict__
    if (dataDict.get('atomSet') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    result = dataDict.get('atomSet')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.Atom
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.Atom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.Atom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('chains').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('residues').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('atoms').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChainStateSets(self):
    """
    Get for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('chainStateSets')
    result = frozenset(tempVar)
    return result
  
  def getChemAtom(self):
    """
    Get function for derived link to ChemAtom
    """
    dataDict = self.__dict__
    result = self.residue.chemCompVar.findFirstChemAtom(name=self.name)
    if result.className != 'ChemAtom':
      result = None
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFixedAtomSets(self):
    """
    Get for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tobjList = root.__dict__.get('nmrConstraintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('fixedAtomSets')
    result = frozenset(tempVar)
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('residue')
    obj2 = obj3.__dict__.get('chain')
    obj1 = obj2.__dict__.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(obj2.__dict__.get('code'))
    result.append(obj3.__dict__.get('seqId'))
    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSysAtomValidations(self):
    """
    Get for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molSysAtomValidations')
    result = frozenset(tempVar)
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.MolSystem.Atom.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNonCovalentBonds(self):
    """
    Get for ccp.molecule.MolSystem.Atom.nonCovalentBonds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('nonCovalentBonds')
    result = frozenset(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.Atom.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('residue')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidue(self):
    """
    Get for ccp.molecule.MolSystem.Atom.residue
    """
    dataDict = self.__dict__
    result = dataDict.get('residue')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChainStateSet(self, value):
    """
    Remove for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ChainStateSet as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeChainStateSet:
       value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChainStateSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChainStateSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChainStateSet:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChainStateSet:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('atoms')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChainStateSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeFixedAtomSet(self, value):
    """
    Remove for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrConstraint import FixedAtomSet as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeFixedAtomSet:
       value is not of class ccp.nmr.NmrConstraint.FixedAtomSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tobjList = root.__dict__.get('nmrConstraintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('fixedAtomSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeFixedAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeFixedAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeFixedAtomSet:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeFixedAtomSet:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      oldSelves = value.__dict__.get('atoms')
      if (len(oldSelves) < (1 + 1)):
        raise ApiError("""%s.removeFixedAtomSet:
         locard: oldSelves: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    oldSelves = value.__dict__.get('atoms')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeFixedAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolSysAtomValidation(self, value):
    """
    Remove for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSysAtomValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolSysAtomValidation:
       value is not of class ccp.molecule.Validation.MolSysAtomValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysAtomValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolSysAtomValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolSysAtomValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolSysAtomValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolSysAtomValidation:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('atoms')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolSysAtomValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.Atom
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtomSet(self, value):
    """
    Set for ccp.molecule.MolSystem.Atom.atomSet
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import AtomSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAtomSet:
         value is not of class ccp.nmr.Nmr.AtomSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (dataDict.get('atomSet') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    currentValue = dataDict.get('atomSet')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtomSet:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (currentValue is not None):
        oldSelves = currentValue.__dict__.get('atoms')
        if (len(oldSelves) < (1 + 1)):
          raise ApiError("""%s.setAtomSet:
           locard: oldSelves: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtomSet:
           Link atomSet between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('atoms')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAtomSet:
         Read link 'atomSet' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('atoms')
      newSelves.add(self)

    dataDict['atomSet'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChainStateSets(self, values):
    """
    Set for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChainStateSets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ChainStateSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChainStateSets:
         value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainStateSets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainStateSets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChainStateSets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChainStateSets:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (self.chain is value.residue.chain)):
            raise ApiError("""%s.setChainStateSets:
             atoms constraint self_chain_is_value_residue_chain violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.add(self)

    dataDict['chainStateSets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChainStateSets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFixedAtomSets(self, values):
    """
    Set for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setFixedAtomSets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrConstraint import FixedAtomSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setFixedAtomSets:
         value is not of class ccp.nmr.NmrConstraint.FixedAtomSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tobjList = root.__dict__.get('nmrConstraintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('fixedAtomSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFixedAtomSets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFixedAtomSets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setFixedAtomSets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('atoms')
          if (len(oldSelves) < (1 + 1)):
            raise ApiError("""%s.setFixedAtomSets:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setFixedAtomSets:
           Link fixedAtomSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.add(self)

    dataDict['fixedAtomSets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFixedAtomSets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSysAtomValidations(self, values):
    """
    Set for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSysAtomValidations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.Validation import MolSysAtomValidation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSysAtomValidations:
         value is not of class ccp.molecule.Validation.MolSysAtomValidation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysAtomValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSysAtomValidations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSysAtomValidations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSysAtomValidations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSysAtomValidations:
           Link molSysAtomValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.add(self)

    dataDict['molSysAtomValidations'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSysAtomValidations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.MolSystem.Atom.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNonCovalentBonds(self, values):
    """
    Set for ccp.molecule.MolSystem.Atom.nonCovalentBonds
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNonCovalentBonds:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, NonCovalentBond)):
        raise ApiError("""%s.setNonCovalentBonds:
         value is not of class ccp.molecule.MolSystem.NonCovalentBond""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('nonCovalentBonds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNonCovalentBonds:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNonCovalentBonds:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNonCovalentBonds:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('atoms')
          if (len(oldSelves) < (2 + 1)):
            raise ApiError("""%s.setNonCovalentBonds:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      for cv in values:
        if (not (cv in currentValues)):
          oldSelves = cv.__dict__.get('atoms')
          if (len(oldSelves) >= 2):
            raise ApiError("""%s.setNonCovalentBonds:
             hicard: oldSelves: cannot add value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNonCovalentBonds:
           Link nonCovalentBonds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('atoms')
        oldSelves.add(self)

    dataDict['nonCovalentBonds'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNonCovalentBonds')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChainStateSets(self):
    """
    Sorted for ccp.molecule.MolSystem.Atom.chainStateSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('chainStateSets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedFixedAtomSets(self):
    """
    Sorted for ccp.molecule.MolSystem.Atom.fixedAtomSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tobjList = root.__dict__.get('nmrConstraintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('fixedAtomSets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSysAtomValidations(self):
    """
    Sorted for ccp.molecule.MolSystem.Atom.molSysAtomValidations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molSysAtomValidations')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNonCovalentBonds(self):
    """
    Sorted for ccp.molecule.MolSystem.Atom.nonCovalentBonds
    """
    dataDict = self.__dict__
    ll = dataDict.get('nonCovalentBonds')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of Atom.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atomSet = property(getAtomSet, setAtomSet, None,
  r"""Set of atoms in fast exchange with Atom.
  """)
  
  chainStateSets = property(getChainStateSets, setChainStateSets, None,
  r"""ChainStateSets involving Atom.
  """)
  
  chemAtom = property(getChemAtom, None, None,
  r"""ChemAtom corresponding to Atom.
  """)
  
  fixedAtomSets = property(getFixedAtomSets, setFixedAtomSets, None,
  r"""FixedAtomSets (part of Nmr Assignment for Nmr Constraint Lists) 
  involving Atom
  """)
  
  molSysAtomValidations = property(getMolSysAtomValidations, setMolSysAtomValidations, None,
  r"""Validation results for Atom
  """)
  
  nonCovalentBonds = property(getNonCovalentBonds, setNonCovalentBonds, None,
  r"""Non-covalent bonds in which the atom takes part.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for residue
  """)
  
  residue = property(getResidue,  None, None,
  r"""parent link
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Chain(memops.api.Implementation.DataObject):
  r"""A specific instance of a given molecule in a specific environment. E.g. 
one of the chains for a homodimer.

The Chain corresponds to a specific 
Molecule, but may differ in some ways. 

Creating a Chain automatically 
creates the Residue and Atom objects corresponding to it. 
  """
  #   from data model element ccp.molecule.MolSystem.Chain revision ?
  _metaclass = metaPackage.getElement('Chain')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'chemExchangeState', 'className', 'code', 'conformationalIsomer', 'details', 'empiricalFormula', 'fieldNames', 'formalCharge', 'inConstructor', 'isDeleted', 'magnEquivalenceCode', 'metaclass', 'molecularMass', 'packageName', 'packageShortName', 'pdbOneLetterCode', 'physicalState', 'qualifiedName', 'role', 'access', 'activeAccess', 'analysisLayouts', 'analysisPanel', 'chainFragments', 'chainInteractions', 'chainStateSets', 'dangleChains', 'molSysChainValidations', 'molSystem', 'molecule', 'parent', 'residues', 'resonanceGroups', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    dataDict['molSystem'] = parent
    if (not isinstance(parent, MolSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['chemExchangeState'] = None
      dataDict['code'] = None
      dataDict['conformationalIsomer'] = None
      dataDict['details'] = None
      dataDict['magnEquivalenceCode'] = None
      dataDict['pdbOneLetterCode'] = ' '
      dataDict['physicalState'] = None
      dataDict['role'] = None
      dataDict['access'] = None
      dataDict['analysisLayouts'] = set()
      dataDict['analysisPanel'] = None
      dataDict['chainFragments'] = {}
      dataDict['chainInteractions'] = set()
      dataDict['chainStateSets'] = set()
      dataDict['dangleChains'] = set()
      dataDict['molSysChainValidations'] = set()
      dataDict['molecule'] = None
      dataDict['residues'] = {}
      dataDict['resonanceGroups'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.Chain.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['chainFragments'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('chains')
        objKey = dataDict.get('code')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['code'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        
        
        molecule = self.molecule
        if molecule:
          # this should never be null, but it fails more gracefully this way
        
          # make Residues
          for molResidue in self.molecule.molResidues:
            Residue(self, seqId=molResidue.serial,seqCode=molResidue.seqCode, seqInsertCode=molResidue.seqInsertCode, linking=molResidue.linking, descriptor=molResidue.descriptor )
        
          # make ChainFragments
          self.createChainFragments()

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.Chain:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    analysisLayouts = dataDict.get('analysisLayouts')
    pass
    for analysisLayout in analysisLayouts:
      topObject = analysisLayout.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    if (dataDict.get('analysisPanel') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    analysisPanel = dataDict.get('analysisPanel')
    if (analysisPanel is not None):
      topObject = analysisPanel.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chainFragments = dataDict.get('chainFragments').values()
    for chainFragment in chainFragments:
      if (not (chainFragment in objsToBeDeleted)):
        objsToBeDeleted.add(chainFragment)
        objsToBeChecked.append(chainFragment)

    chainInteractions = dataDict.get('chainInteractions')
    for chainInteraction in chainInteractions:
      if (not (chainInteraction in objsToBeDeleted)):
        objsToBeDeleted.add(chainInteraction)
        objsToBeChecked.append(chainInteraction)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    chainStateSets = dataDict.get('chainStateSets')
    for chainStateSet in chainStateSets:
      if (not (chainStateSet in objsToBeDeleted)):
        objsToBeDeleted.add(chainStateSet)
        objsToBeChecked.append(chainStateSet)

    for chainStateSet in chainStateSets:
      topObject = chainStateSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dangleChains = dataDict.get('dangleChains')
    for dangleChain in dangleChains:
      if (not (dangleChain in objsToBeDeleted)):
        objsToBeDeleted.add(dangleChain)
        objsToBeChecked.append(dangleChain)

    for dangleChain in dangleChains:
      topObject = dangleChain.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSysChainValidations = dataDict.get('molSysChainValidations')
    pass
    for molSysChainValidation in molSysChainValidations:
      topObject = molSysChainValidation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molecule = dataDict.get('molecule')
    if (molecule is not None):
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    residues = dataDict.get('residues').values()
    for residue in residues:
      if (not (residue in objsToBeDeleted)):
        objsToBeDeleted.add(residue)
        objsToBeChecked.append(residue)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    resonanceGroups = dataDict.get('resonanceGroups')
    pass
    for resonanceGroup in resonanceGroups:
      topObject = resonanceGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.Chain:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for analysisLayout in dataDict.get('analysisLayouts'):
      if (not (analysisLayout in objsToBeDeleted)):
        currentChains = analysisLayout.__dict__.get('currentChains')
        currentChains.remove(self)

    analysisPanel = dataDict.get('analysisPanel')
    if ((analysisPanel is not None and not (analysisPanel in objsToBeDeleted))):
      currentChains = analysisPanel.__dict__.get('currentChains')
      currentChains.remove(self)

    for molSysChainValidation in dataDict.get('molSysChainValidations'):
      if (not (molSysChainValidation in objsToBeDeleted)):
        chains = molSysChainValidation.__dict__.get('chains')
        chains.remove(self)

    molecule = dataDict.get('molecule')
    if ((molecule is not None and not (molecule in objsToBeDeleted))):
      chains = molecule.__dict__.get('chains')
      chains.remove(self)

    for resonanceGroup in dataDict.get('resonanceGroups'):
      if (not (resonanceGroup in objsToBeDeleted)):
        chains = resonanceGroup.__dict__.get('chains')
        chains.remove(self)

    molSystem = dataDict.get('molSystem')
    if (not (molSystem in objsToBeDeleted)):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molSystem.__dict__.get('chains')
        if (self is dd.get(objKey)):
          del dd[objKey]

  def addAnalysisLayout(self, value):
    """
    Add for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addAnalysisLayout:
       value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('analysisLayouts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAnalysisLayout:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAnalysisLayout:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAnalysisLayout:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAnalysisLayout:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAnalysisLayout:
           Link analysisLayouts between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('currentChains')
    oldSelves.append(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAnalysisLayout')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addMolSysChainValidation(self, value):
    """
    Add for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSysChainValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolSysChainValidation:
       value is not of class ccp.molecule.Validation.MolSysChainValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysChainValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolSysChainValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolSysChainValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolSysChainValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolSysChainValidation:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolSysChainValidation:
           Link molSysChainValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('chains')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolSysChainValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addResonanceGroup(self, value):
    """
    Add for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ResonanceGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addResonanceGroup:
       value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('resonanceGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResonanceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addResonanceGroup:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addResonanceGroup:
           Link resonanceGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (not values or self.isActive)):
            raise ApiError("""%s.addResonanceGroup:
             chains constraint Only_active_ResonanceGroups_can_have_chains violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelves = value.__dict__.get('chains')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addResonanceGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('chainFragments').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('residues').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molSystem')
        dd = value.__dict__.get('chains')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('chemExchangeState')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: chemExchangeState:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: chemExchangeState:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: chemExchangeState:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: chemExchangeState:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: code:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('conformationalIsomer')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: conformationalIsomer:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: conformationalIsomer:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: conformationalIsomer:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: conformationalIsomer:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getEmpiricalFormula()
      if (value is None):
        raise ApiError("""%s.checkValid: empiricalFormula:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: empiricalFormula:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: empiricalFormula:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: empiricalFormula:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: empiricalFormula:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getFormalCharge()
      if (value is None):
        raise ApiError("""%s.checkValid: formalCharge:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: formalCharge:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('magnEquivalenceCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: magnEquivalenceCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: magnEquivalenceCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: magnEquivalenceCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: magnEquivalenceCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getMolecularMass()
      if (value is None):
        raise ApiError("""%s.checkValid: molecularMass:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: molecularMass:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: molecularMass:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('pdbOneLetterCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: pdbOneLetterCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: pdbOneLetterCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: pdbOneLetterCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: pdbOneLetterCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('physicalState')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: physicalState:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: physicalState:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: physicalState:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: physicalState:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('role')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: role:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: role:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: role:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: role:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('analysisLayouts')
      for value in values:
        from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: analysisLayouts:
           value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('currentChains')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: analysisLayouts:
           non-reciprocal link analysisLayouts from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: analysisLayouts:
           Link analysisLayouts between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (dataDict.get('analysisPanel') is None):
        root = dataDict.get('topObject').__dict__.get('memopsRoot')
        root.refreshTopObjects('ccpnmr.AnalysisV3')
        tobjList = root.__dict__.get('analysisProjectV3s').values()
        for tobj in tobjList:
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      value = dataDict.get('analysisPanel')
      if (value is not None):
        from ccpnmr.api.AnalysisV3 import AnalysisPanel as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: analysisPanel:
           value is not of class ccpnmr.AnalysisV3.AnalysisPanel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('currentChains')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: analysisPanel:
           non-reciprocal link analysisPanel from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chainFragments').values()
      for value in values:
        if (not isinstance(value, ChainFragment)):
          raise ApiError("""%s.checkValid: chainFragments:
           value is not of class ccp.molecule.MolSystem.ChainFragment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chain')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chainFragments:
           non-reciprocal link chainFragments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chainInteractions')
      for value in values:
        if (not isinstance(value, ChainInteraction)):
          raise ApiError("""%s.checkValid: chainInteractions:
           value is not of class ccp.molecule.MolSystem.ChainInteraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chains')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chainInteractions:
           non-reciprocal link chainInteractions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chainInteractions:
           Link chainInteractions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('chainStateSets')
      for value in values:
        from ccp.api.nmr.Nmr import ChainStateSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chainStateSets:
           value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chain')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chainStateSets:
           non-reciprocal link chainStateSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chainStateSets:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dangleChains')
      for value in values:
        from cambridge.api.Dangle import DangleChain as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dangleChains:
           value is not of class cambridge.Dangle.DangleChain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chain')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: dangleChains:
           non-reciprocal link dangleChains from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dangleChains:
           Link dangleChains between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSysChainValidations')
      for value in values:
        from ccp.api.molecule.Validation import MolSysChainValidation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSysChainValidations:
           value is not of class ccp.molecule.Validation.MolSysChainValidation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chains')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSysChainValidations:
           non-reciprocal link molSysChainValidations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molSystem')
      if (not isinstance(value, MolSystem)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molecule')
      from ccp.api.molecule.Molecule import Molecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('chains')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: molecule:
         non-reciprocal link molecule from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('residues').values()
      for value in values:
        if (not isinstance(value, Residue)):
          raise ApiError("""%s.checkValid: residues:
           value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chain')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residues:
           non-reciprocal link residues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('resonanceGroups')
      for value in values:
        from ccp.api.nmr.Nmr import ResonanceGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chains')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           non-reciprocal link resonanceGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    ll = self.residues
    aset = frozenset((res.seqCode, res.seqInsertCode) for res in ll)
    isValid = (len(aset) == len(ll))
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint seqCode_and_seqInsertCode_form_secondary_key_for_residues violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('chemExchangeState')
    value = dataDict.get('code')
    if (value is None):
      raise ApiError("""%s.checkValid: code:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('conformationalIsomer')
    value = dataDict.get('details')
    value = dataDict.get('magnEquivalenceCode')
    value = dataDict.get('pdbOneLetterCode')
    if (value is None):
      raise ApiError("""%s.checkValid: pdbOneLetterCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (len(value) == 1)):
      raise ApiError("""%s.checkValid: pdbOneLetterCode:
       pdbOneLetterCode constraint length_is_one violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('physicalState')
    value = dataDict.get('role')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('analysisLayouts')
    value = dataDict.get('analysisPanel')
    values = dataDict.get('chainFragments').values()
    values = dataDict.get('chainInteractions')
    values = dataDict.get('chainStateSets')
    values = dataDict.get('dangleChains')
    values = dataDict.get('molSysChainValidations')
    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molecule')
    if (value is None):
      raise ApiError("""%s.checkValid: molecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('residues').values()
    values = dataDict.get('resonanceGroups')
    for value in values:
      (self, value) = (value, self)
      if (not (not values or self.isActive)):
        raise ApiError("""%s.checkValid: resonanceGroups:
         chains constraint Only_active_ResonanceGroups_can_have_chains violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

  def createChainFragments(self):
    """
    Creates ChainFragments for all Residues that do not already have them,
    while making no modification to existing ChainFragments or their 
    contents. Is called automatically on Chain creation. Any program that 
    modifies the automatically created ChainFragments should call this 
    function at the end, to ensure that every Residue belongs to a  
    ChainFragment. 
    
    The function  divides the residues in four molTypes: 
    protein, carbohydrate, DNA/RNA ,and other. Within each molType, 
    stretches of linear polymer of two or more residues are identified 
    without regard to the seqId value of the residues. These are put in 
    separate ChainFragments, with the residues ordered by sequence rather 
    than seqID. Subsequently,  residues not part of a linear polymer are 
    grouped in the largest directly connected fragments of uniform molType. 
    Finally, for fragments of type DNA/RNA the molType is set to DNA or RNA 
    if this is the only molType that happens to be present, to DNA/RNA 
    otherwise.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.createChainFragments:
       called on deleted object""" % self.qualifiedName
      )

    # global set up
    dnarna = 'DNA/RNA'
    topdict = {'protein':{},  'carbohydrate':{}, 'other':{}, dnarna:{}}
    linearTags = ('prev', 'next')
    
    #partition residues by molType
    for molres in self.molecule.molResidues:
      res = self.findFirstResidue(seqId=molres.serial)
      if res is not None and not res.chainFragment:
        molType = molres.molType
        dd = topdict.get(molType)
        if dd is None:
          dd = topdict['other']
        dd[molres] = res
    
    # analyse link graph and make ChainFragments
    for (molType, dd) in topdict.items():
        
      if molType == 'carbohydrate':
        dd2 = dd
    
      else:
        # make linear polymer fragments
        dd2 = {}
        while dd:
      
          # start at molres with largest serial, to get cyclic polymers to start at serial one
          refserial = -1
          for mr in dd:
            serial = mr.serial
            if serial > refserial:
              refserial = serial
              molres = mr
          res0 = dd.pop(molres)
          #(molres, res0) = dd.popitem()
          
          # set up
          res = res0
          mr = molres
          residues = [res]
          (tag1, tag2) = linearTags
          firstTime = True
        
          while True:
            # find linear polymer linked molResidue, and add residue to residues list
            linkEnd = mr.findFirstMolResLinkEnd(linkCode=tag1)
            if linkEnd:
              ml = linkEnd.molResLink
              if ml:
                (le, le2) = ml.molResLinkEnds
                if le is linkEnd:
                  le = le2
                if le.linkCode == tag2:
                  mr = le.molResidue
                  res = dd.get(mr)
                  if res is not None:
                    del dd[mr]
                    residues.append(res)
                    continue
     
            # If we get here, we have reached the end of the polymer chain
            if firstTime:
              # now start again at molres, going in opposite direction
              firstTime = False
              (tag1, tag2) = (tag2, tag1)
              residues.reverse()
              mr = molres
            
            else:
              # both ends done, finalise
              if len(residues) < 2:
                # no linear polymer found - put molres in new dictionary
                dd2[molres] = res0
              else:
                if molType == dnarna:
                  mt = residues[0].molType
                  for rr in residues[1:]:
                    if rr.molType != mt:
                      mt = 'DNA/RNA'
                      break
                else:
                  mt = molType
                
                ChainFragment(
                 self, molType=mt, isLinearPolymer=True, residues=residues
                )
              #
              break
      
      # make fragments that are not linear polyumers
      while dd2:
        # set up
        (molres, res) = dd2.popitem()
        mrs = [molres]
        residues = [res]
        
        for molres in mrs:
          for linkEnd in molres.molResLinkEnds:
            ml = linkEnd.molResLink
            if ml:
              (le, le2) = ml.molResLinkEnds
              if le is linkEnd:
                le = le2
              mr = le.molResidue
              res = dd2.get(mr)
              if res is not None:
                del dd2[mr]
                mrs.append(mr)
                residues.append(res)
        
        if molType == dnarna:
          mt = residues[0].molType
          for rr in residues[1:]:
            if rr.molType != mt:
              mt = 'DNA/RNA'
              break
        else:
          mt = molType
          
        ChainFragment(
         self,molType=mt, isLinearPolymer=False, residues=residues
        )

  delete = memops.api.Implementation.DataObject.delete
  
  def findAllAnalysisLayouts(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'analysisProjectV3', 'currentMolSystem', 'currentRestraintSet', 'layout',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChainFragments(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.chainFragments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chainFragments').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chainFragments').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isLinearPolymer', 'molType', 'serial', 'access', 'chain',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChainInteractions(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.chainInteractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chainInteractions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chainInteractions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('interactionType', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChainStateSets(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.chainStateSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stateSetType', 'access', 'chain', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllDangleChains(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.dangleChains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleChains')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleChains')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chain', 'dangleStore', 'nmrConstraintStore', 'shiftList',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSysChainValidations(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysChainValidations')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysChainValidations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResidues(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residues').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('residues').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'details', 'linking', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'chain', 'chainFragment',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResonanceGroups(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'clusterCode', 'descriptor', 'details', 'isActive', 'linking', 'molType', 'name', 'secStrucCode', 'serial', 'access', 'nmrProject', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findFirstAnalysisLayout(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'analysisProjectV3', 'currentMolSystem', 'currentRestraintSet', 'layout',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChainFragment(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.chainFragments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chainFragments').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('chainFragments').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chainFragments').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isLinearPolymer', 'molType', 'serial', 'access', 'chain',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChainInteraction(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.chainInteractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chainInteractions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chainInteractions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('interactionType', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChainStateSet(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.chainStateSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stateSetType', 'access', 'chain', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstDangleChain(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.dangleChains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleChains')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleChains')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chain', 'dangleStore', 'nmrConstraintStore', 'shiftList',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSysChainValidation(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysChainValidations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysChainValidations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResidue(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residues').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('seqId')
      if (objKey is not None):
        result = dataDict.get('residues').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('residues').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'details', 'linking', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'chain', 'chainFragment',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResonanceGroup(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'clusterCode', 'descriptor', 'details', 'isActive', 'linking', 'molType', 'name', 'secStrucCode', 'serial', 'access', 'nmrProject', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisLayouts(self):
    """
    Get for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('analysisLayouts')
    result = frozenset(tempVar)
    return result
  
  def getAnalysisPanel(self):
    """
    Get for ccp.molecule.MolSystem.Chain.analysisPanel
    """
    dataDict = self.__dict__
    if (dataDict.get('analysisPanel') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    result = dataDict.get('analysisPanel')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.Chain
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.Chain'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.Chain'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('chains').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChainFragments(self):
    """
    Get for ccp.molecule.MolSystem.Chain.chainFragments
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chainFragments').values()
    result = frozenset(tempVar)
    return result
  
  def getChainInteractions(self):
    """
    Get for ccp.molecule.MolSystem.Chain.chainInteractions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chainInteractions')
    result = frozenset(tempVar)
    return result
  
  def getChainStateSets(self):
    """
    Get for ccp.molecule.MolSystem.Chain.chainStateSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('chainStateSets')
    result = frozenset(tempVar)
    return result
  
  def getChemExchangeState(self):
    """
    Get for ccp.molecule.MolSystem.Chain.chemExchangeState
    """
    dataDict = self.__dict__
    result = dataDict.get('chemExchangeState')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for ccp.molecule.MolSystem.Chain.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getConformationalIsomer(self):
    """
    Get for ccp.molecule.MolSystem.Chain.conformationalIsomer
    """
    dataDict = self.__dict__
    result = dataDict.get('conformationalIsomer')
    return result
  
  def getDangleChains(self):
    """
    Get for ccp.molecule.MolSystem.Chain.dangleChains
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('dangleChains')
    result = frozenset(tempVar)
    return result
  
  def getDetails(self):
    """
    Get for ccp.molecule.MolSystem.Chain.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getEmpiricalFormula(self):
    """
    getter for derived attribute empiricalFormula
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    clazz = ccp.api.molecule.ChemComp.ChemAtom
    for mr in self.residues:
      for ss in (ca.elementSymbol for ca in mr.chemCompVar.chemAtoms if isinstance(ca, clazz)):
        ii = dd.get(ss)
        if ii is None:
          dd[ss] = 1
        else:
          dd[ss] = ii + 1
    
    # generate formula
    ll = [None] * (len(dd)*2)
    next = 0
    for ss in ('C', 'H'):
      ii = dd.get(ss)
      if ii is not None:
        ll[next] = ss
        ll[next+1] = str(ii)
        del dd[ss]
        next = next + 2
    
    items = dd.items()
    items.sort()
    for (ss, ii) in items:
      ll[next] = ss
      ll[next+1] = str(ii)
      next = next + 2
    #
    result = ''.join(ll) or None
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFormalCharge(self):
    """
    getter for derived attribute formalCharge
    """
    dataDict = self.__dict__
    result = sum(x.chemCompVar.formalCharge for x in self.residues)
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(dataDict.get('code'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getMagnEquivalenceCode(self):
    """
    Get for ccp.molecule.MolSystem.Chain.magnEquivalenceCode
    """
    dataDict = self.__dict__
    result = dataDict.get('magnEquivalenceCode')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSysChainValidations(self):
    """
    Get for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molSysChainValidations')
    result = frozenset(tempVar)
    return result
  
  def getMolSystem(self):
    """
    Get for ccp.molecule.MolSystem.Chain.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result
  
  def getMolecularMass(self):
    """
    getter for derived attribute molecularMass
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    clazz = ccp.api.molecule.ChemComp.ChemAtom
    for mr in self.residues:
      for ss in (ca.elementSymbol for ca in mr.chemCompVar.chemAtoms if isinstance(ca, clazz)):
        ii = dd.get(ss)
        if ii is None:
          dd[ss] = 1
        else:
          dd[ss] = ii + 1
    
    # calculate mass
    xx = self.root.currentChemElementStore
    result = sum(ii * xx.findFirstChemElement(symbol=ss).mass for (ss, ii) in dd.items())
    return result
  
  def getMolecule(self):
    """
    Get for ccp.molecule.MolSystem.Chain.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.Chain.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result
  
  def getPdbOneLetterCode(self):
    """
    Get for ccp.molecule.MolSystem.Chain.pdbOneLetterCode
    """
    dataDict = self.__dict__
    result = dataDict.get('pdbOneLetterCode')
    return result
  
  def getPhysicalState(self):
    """
    Get for ccp.molecule.MolSystem.Chain.physicalState
    """
    dataDict = self.__dict__
    result = dataDict.get('physicalState')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidues(self):
    """
    Get for ccp.molecule.MolSystem.Chain.residues
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('residues').values()
    result = frozenset(tempVar)
    return result
  
  def getResonanceGroups(self):
    """
    Get for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('resonanceGroups')
    result = frozenset(tempVar)
    return result
  
  def getRole(self):
    """
    Get for ccp.molecule.MolSystem.Chain.role
    """
    dataDict = self.__dict__
    result = dataDict.get('role')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newChainFragment(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.ChainFragment
    """
    return ChainFragment(self, **attrlinks)
  
  def newResidue(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.Residue
    """
    return Residue(self, **attrlinks)
  
  def removeAnalysisLayout(self, value):
    """
    Remove for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeAnalysisLayout:
       value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('analysisLayouts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAnalysisLayout:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAnalysisLayout:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAnalysisLayout:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAnalysisLayout:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('currentChains')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAnalysisLayout')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeMolSysChainValidation(self, value):
    """
    Remove for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSysChainValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolSysChainValidation:
       value is not of class ccp.molecule.Validation.MolSysChainValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysChainValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolSysChainValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolSysChainValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolSysChainValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolSysChainValidation:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('chains')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolSysChainValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeResonanceGroup(self, value):
    """
    Remove for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ResonanceGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeResonanceGroup:
       value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('resonanceGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResonanceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResonanceGroup:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('chains')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeResonanceGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.Chain
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAnalysisLayouts(self, values):
    """
    Set for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAnalysisLayouts:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnalysisLayouts:
         value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('analysisLayouts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisLayouts:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisLayouts:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnalysisLayouts:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAnalysisLayouts:
           Link analysisLayouts between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('currentChains')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('currentChains')
        oldSelves.append(self)

    dataDict['analysisLayouts'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisLayouts')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnalysisPanel(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.analysisPanel
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccpnmr.api.AnalysisV3 import AnalysisPanel as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnalysisPanel:
         value is not of class ccpnmr.AnalysisV3.AnalysisPanel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (dataDict.get('analysisPanel') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    currentValue = dataDict.get('analysisPanel')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisPanel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisPanel:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnalysisPanel:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAnalysisPanel:
           Link analysisPanel between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('currentChains')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAnalysisPanel:
         Read link 'analysisPanel' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('currentChains')
      newSelves.append(self)

    dataDict['analysisPanel'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisPanel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChainInteractions(self, values):
    """
    Set for ccp.molecule.MolSystem.Chain.chainInteractions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChainInteractions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChainInteraction)):
        raise ApiError("""%s.setChainInteractions:
         value is not of class ccp.molecule.MolSystem.ChainInteraction""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chainInteractions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainInteractions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainInteractions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChainInteractions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('chains')
          if (len(oldSelves) < (2 + 1)):
            raise ApiError("""%s.setChainInteractions:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      for cv in values:
        if (not (cv in currentValues)):
          oldSelves = cv.__dict__.get('chains')
          if (len(oldSelves) >= 2):
            raise ApiError("""%s.setChainInteractions:
             hicard: oldSelves: cannot add value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChainInteractions:
           Link chainInteractions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chains')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chains')
        oldSelves.add(self)

    dataDict['chainInteractions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChainInteractions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChainStateSets(self, values):
    """
    Set for ccp.molecule.MolSystem.Chain.chainStateSets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChainStateSets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ChainStateSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChainStateSets:
         value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('chain')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setChainStateSets:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainStateSets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainStateSets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChainStateSets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setChainStateSets:
           locard chain: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChainStateSets:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['chain'] = self

    dataDict['chainStateSets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChainStateSets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemExchangeState(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.chemExchangeState
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setChemExchangeState:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setChemExchangeState:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setChemExchangeState:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setChemExchangeState:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemExchangeState')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemExchangeState:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemExchangeState:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['chemExchangeState'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemExchangeState')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCode(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.code
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode:
         cannot set code, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code'] = value

    # doNotifies
  
  def setConformationalIsomer(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.conformationalIsomer
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setConformationalIsomer:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setConformationalIsomer:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setConformationalIsomer:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setConformationalIsomer:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('conformationalIsomer')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConformationalIsomer:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConformationalIsomer:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['conformationalIsomer'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConformationalIsomer')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDangleChains(self, values):
    """
    Set for ccp.molecule.MolSystem.Chain.dangleChains
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setDangleChains:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from cambridge.api.Dangle import DangleChain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDangleChains:
         value is not of class cambridge.Dangle.DangleChain""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('dangleChains')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('chain')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setDangleChains:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDangleChains:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDangleChains:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDangleChains:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setDangleChains:
           locard chain: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setDangleChains:
           Link dangleChains between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['chain'] = self

    dataDict['dangleChains'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDangleChains')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMagnEquivalenceCode(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.magnEquivalenceCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMagnEquivalenceCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setMagnEquivalenceCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMagnEquivalenceCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setMagnEquivalenceCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('magnEquivalenceCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMagnEquivalenceCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMagnEquivalenceCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['magnEquivalenceCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMagnEquivalenceCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSysChainValidations(self, values):
    """
    Set for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSysChainValidations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.Validation import MolSysChainValidation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSysChainValidations:
         value is not of class ccp.molecule.Validation.MolSysChainValidation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysChainValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSysChainValidations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSysChainValidations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSysChainValidations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSysChainValidations:
           Link molSysChainValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chains')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chains')
        oldSelves.add(self)

    dataDict['molSysChainValidations'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSysChainValidations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolecule(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.molecule
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Molecule import Molecule as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setMolecule:
       value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molecule')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolecule:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolecule:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolecule:
         cannot set molecule, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolecule:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setMolecule:
         Link molecule between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('chains')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolecule:
         Read link 'molecule' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('chains')
      newSelves.add(self)

    dataDict['molecule'] = value

    # doNotifies
  
  def setPdbOneLetterCode(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.pdbOneLetterCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setPdbOneLetterCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setPdbOneLetterCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setPdbOneLetterCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setPdbOneLetterCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('pdbOneLetterCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPdbOneLetterCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPdbOneLetterCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPdbOneLetterCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (len(value) == 1)):
            raise ApiError("""%s.setPdbOneLetterCode:
             pdbOneLetterCode constraint length_is_one violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['pdbOneLetterCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPdbOneLetterCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPhysicalState(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.physicalState
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPhysicalState:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setPhysicalState:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPhysicalState:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setPhysicalState:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('physicalState')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPhysicalState:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPhysicalState:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['physicalState'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPhysicalState')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResonanceGroups(self, values):
    """
    Set for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResonanceGroups:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ResonanceGroup as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setResonanceGroups:
         value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('resonanceGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResonanceGroups:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResonanceGroups:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResonanceGroups:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setResonanceGroups:
           Link resonanceGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (not values or self.isActive)):
            raise ApiError("""%s.setResonanceGroups:
             chains constraint Only_active_ResonanceGroups_can_have_chains violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chains')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chains')
        oldSelves.add(self)

    dataDict['resonanceGroups'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResonanceGroups')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRole(self, value):
    """
    Set for ccp.molecule.MolSystem.Chain.role
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setRole:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setRole:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setRole:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setRole:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('role')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRole:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRole:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['role'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRole')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAnalysisLayouts(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.analysisLayouts
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('analysisLayouts')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChainFragments(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.chainFragments
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chainFragments')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChainInteractions(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.chainInteractions
    """
    dataDict = self.__dict__
    ll = dataDict.get('chainInteractions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChainStateSets(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.chainStateSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('chainStateSets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedDangleChains(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.dangleChains
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('dangleChains')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSysChainValidations(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.molSysChainValidations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molSysChainValidations')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedResidues(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.residues
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('residues')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedResonanceGroups(self):
    """
    Sorted for ccp.molecule.MolSystem.Chain.resonanceGroups
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('resonanceGroups')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  chemExchangeState = property(getChemExchangeState, setChemExchangeState, None,
  r"""for NMR spectroscopy. Short text describing the chemical exchange state.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""ChainCode - key for the Chain class. Should ideally be a single letter, 
  if possible.
  """)
  
  conformationalIsomer = property(getConformationalIsomer, setConformationalIsomer, None,
  r"""short text describing the conformational isomer
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)
  
  empiricalFormula = property(getEmpiricalFormula, None, None,
  r"""empirical molecular formula for Chain (may be different from that of the 
  corresponding molecule
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  formalCharge = property(getFormalCharge, None, None,
  r"""formal charge of Chain (may differ from that of the corresponding 
  molecule).
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  magnEquivalenceCode = property(getMagnEquivalenceCode, setMagnEquivalenceCode, None,
  r"""For NMR data. Chains with the same magnEquivalenceCode are magnetically 
  equivalent within the MolSystem. If not set no chains are magnetically 
  equivalent.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molecularMass = property(getMolecularMass, None, None,
  r"""molecular mass of Chain (may differ from that of the corresponding 
  molecule).
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  pdbOneLetterCode = property(getPdbOneLetterCode, setPdbOneLetterCode, None,
  r"""One letter chain identifier. Will be used by PDB (and programs that use 
  similar conventions). WARNING: having same oneLetterCode for different 
  chains is legal but may cause serious confusion.
  """)
  
  physicalState = property(getPhysicalState, setPhysicalState, None,
  r"""e.g. folded/unfolded
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  role = property(getRole, setRole, None,
  r"""Role of Chain within MolSystem
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisLayouts = property(getAnalysisLayouts, setAnalysisLayouts, None,
  r"""AnalysisLayouts referring to chains
  """)
  
  analysisPanel = property(getAnalysisPanel, setAnalysisPanel, None,
  r"""AnalysisPanels referring to chains
  """)
  
  chainFragments = property(getChainFragments,  None, None,
  r"""child link to class ChainFragment
  """)
  
  chainInteractions = property(getChainInteractions, setChainInteractions, None,
  r"""An interaction of a given type between a pair  of Chains
  """)
  
  chainStateSets = property(getChainStateSets, setChainStateSets, None,
  r"""ChainStateSets belonging to Chain
  """)
  
  dangleChains = property(getDangleChains, setDangleChains, None,
  r"""Chains with Dangle dihedral angle predictions
  """)
  
  molSysChainValidations = property(getMolSysChainValidations, setMolSysChainValidations, None,
  r"""Validation results for Chain
  """)
  
  molSystem = property(getMolSystem,  None, None,
  r"""parent link
  """)
  
  molecule = property(getMolecule, setMolecule, None,
  r"""Molecule to which Chain corresponds
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molSystem
  """)
  
  residues = property(getResidues,  None, None,
  r"""child link
  """)
  
  resonanceGroups = property(getResonanceGroups, setResonanceGroups, None,
  r"""ResonanceGroups that may be relevant to Chain
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChainFragment(memops.api.Implementation.DataObject):
  r"""Fragment of Chain with defined MolType for all residues. ChainFragments 
are generated automatically by the Chain initialiser function. See 
documentation of Chain.createChainFragments for a description of the 
normal way of dividing a Chain in ChainFragments.
  """
  #   from data model element ccp.molecule.MolSystem.ChainFragment revision ?
  _metaclass = metaPackage.getElement('ChainFragment')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'isLinearPolymer', 'metaclass', 'molType', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'chain', 'parent', 'residues', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    dataDict['chain'] = parent
    if (not isinstance(parent, Chain)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['isLinearPolymer'] = None
      dataDict['molType'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['residues'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.ChainFragment.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.MolSystem.ChainFragment')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('chainFragments')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.ChainFragment:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.ChainFragment:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for residue in dataDict.get('residues'):
      if (not (residue in objsToBeDeleted)):
        residue.__dict__['chainFragment'] = None

    chain = dataDict.get('chain')
    if (not (chain in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chain.__dict__.get('chainFragments')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chain')
        dd = value.__dict__.get('chainFragments')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chain' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isLinearPolymer')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isLinearPolymer:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molType')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: molType:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: molType:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: molType:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chain')
      if (not isinstance(value, Chain)):
        raise ApiError("""%s.checkValid: chain:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('residues')
      for value in values:
        if (not isinstance(value, Residue)):
          raise ApiError("""%s.checkValid: residues:
           value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chainFragment')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residues:
           non-reciprocal link residues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: residues:
           Link residues between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('isLinearPolymer')
    if (value is None):
      raise ApiError("""%s.checkValid: isLinearPolymer:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molType')
    if (value is None):
      raise ApiError("""%s.checkValid: molType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chain')
    if (value is None):
      raise ApiError("""%s.checkValid: chain:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('residues')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllResidues(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.ChainFragment.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residues')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('residues')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'details', 'linking', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'chain', 'chainFragment',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstResidue(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.ChainFragment.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residues')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('residues')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'details', 'linking', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'chain', 'chainFragment',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.ChainFragment
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.ChainFragment'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.ChainFragment'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('chains').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('chainFragments').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChain(self):
    """
    Get for ccp.molecule.MolSystem.ChainFragment.chain
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('chain')
    obj1 = obj2.__dict__.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(obj2.__dict__.get('code'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsLinearPolymer(self):
    """
    Get for ccp.molecule.MolSystem.ChainFragment.isLinearPolymer
    """
    dataDict = self.__dict__
    result = dataDict.get('isLinearPolymer')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolType(self):
    """
    Get for ccp.molecule.MolSystem.ChainFragment.molType
    """
    dataDict = self.__dict__
    result = dataDict.get('molType')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.ChainFragment.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidues(self):
    """
    Get for ccp.molecule.MolSystem.ChainFragment.residues
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('residues')
    result = tuple(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.MolSystem.ChainFragment.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.ChainFragment
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setIsLinearPolymer(self, value):
    """
    Set for ccp.molecule.MolSystem.ChainFragment.isLinearPolymer
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsLinearPolymer:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isLinearPolymer')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsLinearPolymer:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setIsLinearPolymer:
         cannot set isLinearPolymer, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setIsLinearPolymer:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isLinearPolymer'] = value

    # doNotifies
  
  def setMolType(self, value):
    """
    Set for ccp.molecule.MolSystem.ChainFragment.molType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setMolType:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setMolType:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setMolType:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolType:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolType:
         cannot set molType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molType'] = value

    # doNotifies
  
  def setResidues(self, values):
    """
    Set for ccp.molecule.MolSystem.ChainFragment.residues
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResidues:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Residue)):
        raise ApiError("""%s.setResidues:
         value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('residues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResidues:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResidues:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setResidues:
         cannot set residues, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setResidues:
           Link residues between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['chainFragment'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('chainFragment')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('residues')
          vv.remove(cv)

      cv.__dict__['chainFragment'] = self

    dataDict['residues'] = values

    # doNotifies
  
  def setSerial(self, value):
    """
    Set for ccp.molecule.MolSystem.ChainFragment.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('chain')
    oldSerial = parent.__dict__.get('_serialDict').get('chainFragments')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['chainFragments'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['chainFragments'] = value

    dataDict['serial'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isLinearPolymer = property(getIsLinearPolymer, setIsLinearPolymer, None,
  r"""Is ChainFragment a linear polymer? Implies that each residue, in the 
  order given in the residues link, is linked to the next one by a link of 
  linear polymer type (linkEnds 'next','prev').
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, setMolType, None,
  r"""molType of residues in ChainFragment. Must apply to all residues
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chain = property(getChain,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chain
  """)
  
  residues = property(getResidues, setResidues, None,
  r"""residues making up ChainFragment
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChainInteraction(memops.api.Implementation.DataObject):
  r"""Interaction between two Chains in a MolSystem
  """
  #   from data model element ccp.molecule.MolSystem.ChainInteraction revision ?
  _metaclass = metaPackage.getElement('ChainInteraction')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'interactionType', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'chains', 'molSystem', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    dataDict['molSystem'] = parent
    if (not isinstance(parent, MolSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['interactionType'] = None
      dataDict['access'] = None
      dataDict['chains'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.ChainInteraction.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chainInteractions')
        objKey = dataDict.get('chains')
        if (objKey is not None):
          objKey = frozenset(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['chains'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.ChainInteraction:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.ChainInteraction:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chain in dataDict.get('chains'):
      if (not (chain in objsToBeDeleted)):
        chainInteractions = chain.__dict__.get('chainInteractions')
        chainInteractions.remove(self)

    molSystem = dataDict.get('molSystem')
    if (not (molSystem in objsToBeDeleted)):
      objKey = dataDict.get('chains')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molSystem.__dict__.get('chainInteractions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('chains')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molSystem')
        dd = value.__dict__.get('chainInteractions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('interactionType')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: interactionType:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: interactionType:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: interactionType:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: interactionType:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chains')
      for value in values:
        if (not isinstance(value, Chain)):
          raise ApiError("""%s.checkValid: chains:
           value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chainInteractions')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chains:
           non-reciprocal link chains from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molSystem')
      if (not isinstance(value, MolSystem)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('interactionType')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chains')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: chains:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChains(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.ChainInteraction.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chains')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chains')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChain(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.ChainInteraction.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chains')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chains')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.ChainInteraction
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.ChainInteraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.ChainInteraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = frozenset(tempList)
      obj2 = obj1.__dict__.get('chainInteractions').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChains(self):
    """
    Get for ccp.molecule.MolSystem.ChainInteraction.chains
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chains')
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    for xx in dataDict.get('chains'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInteractionType(self):
    """
    Get for ccp.molecule.MolSystem.ChainInteraction.interactionType
    """
    dataDict = self.__dict__
    result = dataDict.get('interactionType')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    result = dataDict.get('chains')
    if (result is not None):
      result = frozenset(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    Get for ccp.molecule.MolSystem.ChainInteraction.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.ChainInteraction.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.ChainInteraction
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChains(self, values):
    """
    Set for ccp.molecule.MolSystem.ChainInteraction.chains
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChains:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Chain)):
        raise ApiError("""%s.setChains:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chains')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChains:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChains:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChains:
         cannot set chains, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 2)):
        raise ApiError("""%s.setChains:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChains:
           Link chains between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chainInteractions')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chainInteractions')
        oldSelves.add(self)

    dataDict['chains'] = values

    # doNotifies
  
  def setInteractionType(self, value):
    """
    Set for ccp.molecule.MolSystem.ChainInteraction.interactionType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setInteractionType:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setInteractionType:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setInteractionType:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setInteractionType:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('interactionType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInteractionType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInteractionType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['interactionType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInteractionType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChains(self):
    """
    Sorted for ccp.molecule.MolSystem.ChainInteraction.chains
    """
    dataDict = self.__dict__
    ll = dataDict.get('chains')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  interactionType = property(getInteractionType, setInteractionType, None,
  r"""String specifying the type of interaction between chains. NB should 
  maybe be made into an open enumeration.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chains = property(getChains, setChains, None,
  r"""Chains interacting in ChainInteraction.
  """)
  
  molSystem = property(getMolSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolSystem(memops.api.Implementation.TopObject):
  r"""Molecular System - a set of potentially interacting chains. Describes 
all components of known molecular structure considered relevant for 
(typically) a structure determination. May include components of a 
complex, components in different states (e.g. free protein, free ligand, 
and protein and ligand bound in a complex), and also molecules that are 
not part of any interaction but are considered relevant (e.g. 
NMR-observable impurities in an Nmr study). 
  """
  #   from data model element ccp.molecule.MolSystem.MolSystem revision ?
  _metaclass = metaPackage.getElement('MolSystem')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'code', 'commonNames', 'createdBy', 'details', 'fieldNames', 'functions', 'guid', 'hasChemExchange', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isParamagnetic', 'isReading', 'keywords', 'lastUnlockedBy', 'metaclass', 'molecularMass', 'name', 'numChains', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'analysisLayouts', 'analysisPanels', 'chainInteractions', 'chains', 'citations', 'dbReferences', 'entries', 'memopsRoot', 'molSystemLinks', 'molSystemSymmetrySets', 'molSystemSysNames', 'molSystemValidations', 'nmrExperiments', 'nmrScreens', 'nonCovalentBonds', 'packageLocator', 'parent', 'root', 'structureEnsembles', 'structureGroups', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.molecule.MolSystem')

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['commonNames'] = list()
      dataDict['createdBy'] = None
      dataDict['details'] = None
      dataDict['functions'] = list()
      dataDict['guid'] = None
      dataDict['hasChemExchange'] = None
      dataDict['isModifiable'] = True
      dataDict['keywords'] = list()
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['analysisLayouts'] = set()
      dataDict['analysisPanels'] = set()
      dataDict['chainInteractions'] = {}
      dataDict['chains'] = {}
      dataDict['citations'] = set()
      dataDict['dbReferences'] = set()
      dataDict['entries'] = set()
      dataDict['molSystemLinks'] = {}
      dataDict['molSystemSymmetrySets'] = set()
      dataDict['molSystemSysNames'] = {}
      dataDict['molSystemValidations'] = set()
      dataDict['nmrExperiments'] = set()
      dataDict['nmrScreens'] = set()
      dataDict['nonCovalentBonds'] = {}
      dataDict['structureEnsembles'] = set()
      dataDict['structureGroups'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.MolSystem.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['structureGroups'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('molSystems')
        objKey = dataDict.get('code')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['code'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentMolSystem') is None)):
        root.__dict__['currentMolSystem'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.MolSystem:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    analysisLayouts = dataDict.get('analysisLayouts')
    pass
    for analysisLayout in analysisLayouts:
      topObject = analysisLayout.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    analysisPanels = dataDict.get('analysisPanels')
    pass
    for analysisPanel in analysisPanels:
      topObject = analysisPanel.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chainInteractions = dataDict.get('chainInteractions').values()
    for chainInteraction in chainInteractions:
      if (not (chainInteraction in objsToBeDeleted)):
        objsToBeDeleted.add(chainInteraction)
        objsToBeChecked.append(chainInteraction)

    chains = dataDict.get('chains').values()
    for chain in chains:
      if (not (chain in objsToBeDeleted)):
        objsToBeDeleted.add(chain)
        objsToBeChecked.append(chain)

    citations = dataDict.get('citations')
    pass
    for citation in citations:
      topObject = citation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    dbReferences = dataDict.get('dbReferences')
    pass
    for dbReference in dbReferences:
      topObject = dbReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    entries = dataDict.get('entries')
    pass
    for entry in entries:
      topObject = entry.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molSystemLinks = dataDict.get('molSystemLinks').values()
    for molSystemLink in molSystemLinks:
      if (not (molSystemLink in objsToBeDeleted)):
        objsToBeDeleted.add(molSystemLink)
        objsToBeChecked.append(molSystemLink)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('molsim.Symmetry')
    molSystemSymmetrySets = dataDict.get('molSystemSymmetrySets')
    for molSystemSymmetrySet in molSystemSymmetrySets:
      if (not (molSystemSymmetrySet in objsToBeDeleted)):
        objsToBeDeleted.add(molSystemSymmetrySet)
        objsToBeChecked.append(molSystemSymmetrySet)

    for molSystemSymmetrySet in molSystemSymmetrySets:
      topObject = molSystemSymmetrySet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molSystemSysNames = dataDict.get('molSystemSysNames').values()
    for molSystemSysName in molSystemSysNames:
      if (not (molSystemSysName in objsToBeDeleted)):
        objsToBeDeleted.add(molSystemSysName)
        objsToBeChecked.append(molSystemSysName)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSystemValidations = dataDict.get('molSystemValidations')
    pass
    for molSystemValidation in molSystemValidations:
      topObject = molSystemValidation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrExperiments = dataDict.get('nmrExperiments')
    pass
    for nmrExperiment in nmrExperiments:
      topObject = nmrExperiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    nmrScreens = dataDict.get('nmrScreens')
    pass
    for nmrScreen in nmrScreens:
      topObject = nmrScreen.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    nonCovalentBonds = dataDict.get('nonCovalentBonds').values()
    for nonCovalentBond in nonCovalentBonds:
      if (not (nonCovalentBond in objsToBeDeleted)):
        objsToBeDeleted.add(nonCovalentBond)
        objsToBeChecked.append(nonCovalentBond)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolStructure')
    structureEnsembles = dataDict.get('structureEnsembles')
    for structureEnsemble in structureEnsembles:
      if (not (structureEnsemble in objsToBeDeleted)):
        objsToBeDeleted.add(structureEnsemble)
        objsToBeChecked.append(structureEnsemble)

    for structureEnsemble in structureEnsembles:
      topObject = structureEnsemble.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    structureGroups = dataDict.get('structureGroups').values()
    for structureGroup in structureGroups:
      if (not (structureGroup in objsToBeDeleted)):
        objsToBeDeleted.add(structureGroup)
        objsToBeChecked.append(structureGroup)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.MolSystem:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentMolSystem')):
      memopsRoot.__dict__['currentMolSystem'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for analysisLayout in dataDict.get('analysisLayouts'):
      if (not (analysisLayout in objsToBeDeleted)):
        analysisLayout.__dict__['currentMolSystem'] = None

    for analysisPanel in dataDict.get('analysisPanels'):
      if (not (analysisPanel in objsToBeDeleted)):
        analysisPanel.__dict__['currentMolSystem'] = None

    for citation in dataDict.get('citations'):
      if (not (citation in objsToBeDeleted)):
        molSystems = citation.__dict__.get('molSystems')
        molSystems.remove(self)

    for dbReference in dataDict.get('dbReferences'):
      if (not (dbReference in objsToBeDeleted)):
        molSystems = dbReference.__dict__.get('molSystems')
        molSystems.remove(self)

    for entry in dataDict.get('entries'):
      if (not (entry in objsToBeDeleted)):
        entry.__dict__['molSystem'] = None

    for molSystemValidation in dataDict.get('molSystemValidations'):
      if (not (molSystemValidation in objsToBeDeleted)):
        molSystems = molSystemValidation.__dict__.get('molSystems')
        molSystems.remove(self)

    for nmrExperiment in dataDict.get('nmrExperiments'):
      if (not (nmrExperiment in objsToBeDeleted)):
        molSystems = nmrExperiment.__dict__.get('molSystems')
        molSystems.remove(self)

    for nmrScreen in dataDict.get('nmrScreens'):
      if (not (nmrScreen in objsToBeDeleted)):
        nmrScreen.__dict__['target'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('molSystems')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['chainInteractions'] = {}
    dataDict['chains'] = {}
    dataDict['molSystemLinks'] = {}
    dataDict['molSystemSysNames'] = {}
    dataDict['nonCovalentBonds'] = {}
    dataDict['structureGroups'] = {}
  
  def addAnalysisLayout(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addAnalysisLayout:
       value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('analysisLayouts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('currentMolSystem')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAnalysisLayout:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAnalysisLayout:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAnalysisLayout:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAnalysisLayout:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAnalysisLayout:
           Link analysisLayouts between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('currentMolSystem')
    if (oldSelf is not None):
      if (not (oldSelf.__dict__.get('isLoaded'))):
        oldSelf.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('analysisLayouts')
      siblingValues.remove(value)

    value.__dict__['currentMolSystem'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAnalysisLayout')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addAnalysisPanel(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    from ccpnmr.api.AnalysisV3 import AnalysisPanel as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addAnalysisPanel:
       value is not of class ccpnmr.AnalysisV3.AnalysisPanel""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('analysisPanels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('currentMolSystem')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAnalysisPanel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAnalysisPanel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAnalysisPanel:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAnalysisPanel:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAnalysisPanel:
           Link analysisPanels between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('currentMolSystem')
    if (oldSelf is not None):
      if (not (oldSelf.__dict__.get('isLoaded'))):
        oldSelf.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('analysisPanels')
      siblingValues.remove(value)

    value.__dict__['currentMolSystem'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAnalysisPanel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addCitation(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    from ccp.api.general.Citation import Citation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addCitation:
       value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('citations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addCitation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addCitation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addCitation:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addCitation:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addCitation:
           Link citations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addCitation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addCommonName(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.commonNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 254):
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addCommonName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addCommonName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addCommonName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addDbReference(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    from ccp.api.general.DbRef import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addDbReference:
       value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('dbReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addDbReference:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addDbReference:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addDbReference:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addDbReference:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addDbReference:
           Link dbReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addDbReference')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addEntry(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addEntry:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('entries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('molSystem')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addEntry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addEntry:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addEntry:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addEntry:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addEntry:
           Link entries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('molSystem')
    if (oldSelf is not None):
      if (not (oldSelf.__dict__.get('isLoaded'))):
        oldSelf.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('entries')
      siblingValues.remove(value)

    value.__dict__['molSystem'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addEntry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addFunction(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.functions
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addFunction:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addFunction:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addFunction:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addFunction:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('functions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addFunction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addFunction:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addFunction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addKeyword(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolSystemValidation(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSystemValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolSystemValidation:
       value is not of class ccp.molecule.Validation.MolSystemValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molSystemValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolSystemValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolSystemValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolSystemValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolSystemValidation:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolSystemValidation:
           Link molSystemValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolSystemValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addNmrExperiment(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addNmrExperiment:
       value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('nmrExperiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNmrExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNmrExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNmrExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addNmrExperiment:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNmrExperiment:
           Link nmrExperiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNmrExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addNmrScreen(self, value):
    """
    Add for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrScreen import NmrScreen as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addNmrScreen:
       value is not of class ccp.nmr.NmrScreen.NmrScreen""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('nmrScreens')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('target')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNmrScreen:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNmrScreen:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNmrScreen:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addNmrScreen:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNmrScreen:
           Link nmrScreens between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('target')
    if (oldSelf is not None):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      siblingValues = oldSelf.__dict__.get('nmrScreens')
      siblingValues.remove(value)

    value.__dict__['target'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNmrScreen')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('chainInteractions').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chains').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molSystemLinks').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molSystemSysNames').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('nonCovalentBonds').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('structureGroups').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('molSystems')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: code:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('commonNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('functions')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: functions:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: functions:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: functions:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: functions:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('hasChemExchange')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: hasChemExchange:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getIsParamagnetic()
      if (value is None):
        raise ApiError("""%s.checkValid: isParamagnetic:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isParamagnetic:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getMolecularMass()
      if (value is None):
        raise ApiError("""%s.checkValid: molecularMass:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: molecularMass:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: molecularMass:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getNumChains()
      if (value is None):
        raise ApiError("""%s.checkValid: numChains:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numChains:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('analysisLayouts')
      for value in values:
        from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: analysisLayouts:
           value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('currentMolSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisLayouts:
           non-reciprocal link analysisLayouts from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: analysisLayouts:
           Link analysisLayouts between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('analysisPanels')
      for value in values:
        from ccpnmr.api.AnalysisV3 import AnalysisPanel as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: analysisPanels:
           value is not of class ccpnmr.AnalysisV3.AnalysisPanel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('currentMolSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisPanels:
           non-reciprocal link analysisPanels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: analysisPanels:
           Link analysisPanels between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chainInteractions').values()
      for value in values:
        if (not isinstance(value, ChainInteraction)):
          raise ApiError("""%s.checkValid: chainInteractions:
           value is not of class ccp.molecule.MolSystem.ChainInteraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chainInteractions:
           non-reciprocal link chainInteractions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chains').values()
      for value in values:
        if (not isinstance(value, Chain)):
          raise ApiError("""%s.checkValid: chains:
           value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chains:
           non-reciprocal link chains from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('citations')
      for value in values:
        from ccp.api.general.Citation import Citation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: citations:
           value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molSystems')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: citations:
           non-reciprocal link citations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: citations:
           Link citations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('dbReferences')
      for value in values:
        from ccp.api.general.DbRef import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dbReferences:
           value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molSystems')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: dbReferences:
           non-reciprocal link dbReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dbReferences:
           Link dbReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('entries')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: entries:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: entries:
           non-reciprocal link entries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: entries:
           Link entries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('molSystemLinks').values()
      for value in values:
        if (not isinstance(value, MolSystemLink)):
          raise ApiError("""%s.checkValid: molSystemLinks:
           value is not of class ccp.molecule.MolSystem.MolSystemLink""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystemLinks:
           non-reciprocal link molSystemLinks from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('molsim.Symmetry')
      values = dataDict.get('molSystemSymmetrySets')
      for value in values:
        from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystemSymmetrySets:
           value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystemSymmetrySets:
           non-reciprocal link molSystemSymmetrySets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSystemSymmetrySets:
           Link molSystemSymmetrySets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molSystemSysNames').values()
      for value in values:
        if (not isinstance(value, MolSystemSysName)):
          raise ApiError("""%s.checkValid: molSystemSysNames:
           value is not of class ccp.molecule.MolSystem.MolSystemSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystemSysNames:
           non-reciprocal link molSystemSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSystemValidations')
      for value in values:
        from ccp.api.molecule.Validation import MolSystemValidation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystemValidations:
           value is not of class ccp.molecule.Validation.MolSystemValidation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molSystems')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSystemValidations:
           non-reciprocal link molSystemValidations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSystemValidations:
           Link molSystemValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrExperiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molSystems')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           non-reciprocal link nmrExperiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      values = dataDict.get('nmrScreens')
      for value in values:
        from ccp.api.nmr.NmrScreen import NmrScreen as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrScreens:
           value is not of class ccp.nmr.NmrScreen.NmrScreen""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('target')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrScreens:
           non-reciprocal link nmrScreens from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrScreens:
           Link nmrScreens between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('nonCovalentBonds').values()
      for value in values:
        if (not isinstance(value, NonCovalentBond)):
          raise ApiError("""%s.checkValid: nonCovalentBonds:
           value is not of class ccp.molecule.MolSystem.NonCovalentBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nonCovalentBonds:
           non-reciprocal link nonCovalentBonds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolStructure')
      values = dataDict.get('structureEnsembles')
      for value in values:
        from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: structureEnsembles:
           value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: structureEnsembles:
           non-reciprocal link structureEnsembles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: structureEnsembles:
           Link structureEnsembles between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('structureGroups').values()
      for value in values:
        if (not isinstance(value, StructureGroup)):
          raise ApiError("""%s.checkValid: structureGroups:
           value is not of class ccp.molecule.MolSystem.StructureGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: structureGroups:
           non-reciprocal link structureGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('code')
      if (value is None):
        raise ApiError("""%s.checkValid: code:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('commonNames')
      value = dataDict.get('details')
      values = dataDict.get('functions')
      value = dataDict.get('hasChemExchange')
      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('keywords')
      value = dataDict.get('name')
      # check roles
      value = dataDict.get('access')
      values = dataDict.get('analysisLayouts')
      values = dataDict.get('analysisPanels')
      values = dataDict.get('chainInteractions').values()
      values = dataDict.get('chains').values()
      values = dataDict.get('citations')
      values = dataDict.get('dbReferences')
      values = dataDict.get('entries')
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('molSystemLinks').values()
      values = dataDict.get('molSystemSymmetrySets')
      values = dataDict.get('molSystemSysNames').values()
      values = dataDict.get('molSystemValidations')
      values = dataDict.get('nmrExperiments')
      values = dataDict.get('nmrScreens')
      values = dataDict.get('nonCovalentBonds').values()
      values = dataDict.get('structureEnsembles')
      values = dataDict.get('structureGroups').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('code')
      if (value is None):
        raise ApiError("""%s.checkValid: code:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories
  
  def findAllAnalysisLayouts(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'analysisProjectV3', 'currentMolSystem', 'currentRestraintSet', 'layout',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAnalysisPanels(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisPanels')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisPanels')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'analysisProjectV3', 'currentMolSystem', 'currentRestraintSet', 'panel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChainInteractions(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.chainInteractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chainInteractions').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chainInteractions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('interactionType', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChains(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chains').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chains').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllCitations(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casAbstractCode', 'details', 'doi', 'firstPage', 'lastPage', 'medlineUiCode', 'pubMedId', 'serial', 'status', 'title', 'year', 'access', 'citationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllDbReferences(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('dbReferences')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('dbReferences')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('altCode', 'code', 'details', 'name', 'release', 'serial', 'subCode', 'url', 'access', 'database',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllEntries(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystemLinks(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.molSystemLinks
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSystemLinks').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSystemLinks').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('dihedralAngle', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystemSymmetrySets(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets')
      result = set(currentValues)

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'symmetrySetId', 'access', 'memopsRoot', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystemSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.molSystemSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSystemSysNames').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSystemSysNames').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'namingSystem', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystemValidations(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystemValidations')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystemValidations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrExperiments(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrScreens(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreens')
      result = set(currentValues)

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreens')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'details', 'endDate', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'objective', 'pH', 'sampleType', 'startDate', 'temperature', 'userProtocolCode', 'access', 'memopsRoot', 'target',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNonCovalentBonds(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.nonCovalentBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('nonCovalentBonds').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('nonCovalentBonds').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllStructureEnsembles(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.structureEnsembles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles')
      result = set(currentValues)

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomNamingSystem', 'createdBy', 'details', 'ensembleId', 'guid', 'isModifiable', 'lastUnlockedBy', 'resNamingSystem', 'softwareName', 'access', 'memopsRoot', 'molSystem', 'structureGeneration',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllStructureGroups(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystem.structureGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('structureGroups').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('structureGroups').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('detail', 'name', 'serial', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository
  
  def findFirstAnalysisLayout(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisLayouts')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'analysisProjectV3', 'currentMolSystem', 'currentRestraintSet', 'layout',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAnalysisPanel(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisPanels')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.AnalysisV3')
      tobjList = root.__dict__.get('analysisProjectV3s').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('analysisPanels')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'analysisProjectV3', 'currentMolSystem', 'currentRestraintSet', 'panel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChain(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chains').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('code')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chains').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chains').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChainInteraction(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.chainInteractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chainInteractions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('chains')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chainInteractions').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chainInteractions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('interactionType', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstCitation(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casAbstractCode', 'details', 'doi', 'firstPage', 'lastPage', 'medlineUiCode', 'pubMedId', 'serial', 'status', 'title', 'year', 'access', 'citationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstDbReference(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('dbReferences')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('dbReferences')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('altCode', 'code', 'details', 'name', 'release', 'serial', 'subCode', 'url', 'access', 'database',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstEntry(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystemLink(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.molSystemLinks
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSystemLinks').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('molSystemLinkEnds')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molSystemLinks').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molSystemLinks').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('dihedralAngle', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystemSymmetrySet(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'symmetrySetId', 'access', 'memopsRoot', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystemSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.molSystemSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSystemSysNames').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('namingSystem')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molSystemSysNames').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molSystemSysNames').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'namingSystem', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystemValidation(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystemValidations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystemValidations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrExperiment(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrScreen(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreens')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreens')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'details', 'endDate', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'objective', 'pH', 'sampleType', 'startDate', 'temperature', 'userProtocolCode', 'access', 'memopsRoot', 'target',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNonCovalentBond(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.nonCovalentBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('nonCovalentBonds').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('atoms')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('nonCovalentBonds').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('nonCovalentBonds').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstStructureEnsemble(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.structureEnsembles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomNamingSystem', 'createdBy', 'details', 'ensembleId', 'guid', 'isModifiable', 'lastUnlockedBy', 'resNamingSystem', 'softwareName', 'access', 'memopsRoot', 'molSystem', 'structureGeneration',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstStructureGroup(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystem.structureGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('structureGroups').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('structureGroups').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('structureGroups').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('detail', 'name', 'serial', 'access', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories
  
  def getAnalysisLayouts(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('analysisLayouts')
    result = frozenset(tempVar)
    return result
  
  def getAnalysisPanels(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('analysisPanels')
    result = frozenset(tempVar)
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.MolSystem
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.molecule.MolSystem.MolSystem'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('molSystems').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.molecule.MolSystem')
      obj1 = startObj.__dict__.get('molSystems').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChainInteractions(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.chainInteractions
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chainInteractions').values()
    result = frozenset(tempVar)
    return result
  
  def getChains(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.chains
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chains').values()
    result = frozenset(tempVar)
    return result
  
  def getCitations(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('citations')
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getCommonNames(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.commonNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('commonNames')
    result = tuple(tempVar)
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy
  
  def getDbReferences(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('dbReferences')
    result = frozenset(tempVar)
    return result
  
  def getDetails(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getEntries(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('entries')
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('code'))

    return result
  
  def getFunctions(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.functions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('functions')
    result = tuple(tempVar)
    return result

  getGuid = memops.api.Implementation.TopObject.getGuid
  
  def getHasChemExchange(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.hasChemExchange
    """
    dataDict = self.__dict__
    result = dataDict.get('hasChemExchange')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified
  
  def getIsParamagnetic(self):
    """
    getter for derived attribute isParamagnetic
    """
    dataDict = self.__dict__
    result = False
    for chain in self.chains:
      for residue in chain.residues:
        if residue.chemCompVar.isParamagnetic:
          result = True
          break
      if result:
        break
    return result

  getIsReading = memops.api.Implementation.TopObject.getIsReading
  
  def getKeywords(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.keywords
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('keywords')
    result = tuple(tempVar)
    return result

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystemLinks(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.molSystemLinks
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molSystemLinks').values()
    result = frozenset(tempVar)
    return result
  
  def getMolSystemSymmetrySets(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('molsim.Symmetry')
    tempVar = dataDict.get('molSystemSymmetrySets')
    result = frozenset(tempVar)
    return result
  
  def getMolSystemSysNames(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.molSystemSysNames
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molSystemSysNames').values()
    result = frozenset(tempVar)
    return result
  
  def getMolSystemValidations(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molSystemValidations')
    result = frozenset(tempVar)
    return result
  
  def getMolecularMass(self):
    """
    getter for derived attribute molecularMass
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    clazz = ccp.api.molecule.ChemComp.ChemAtom
    for chain in self.chains:
      for mr in chain.residues:
        for ss in (ca.elementSymbol for ca in mr.chemCompVar.chemAtoms if isinstance(ca, clazz)):
          ii = dd.get(ss)
          if ii is None:
            dd[ss] = 1
          else:
            dd[ss] = ii + 1
    
    # calculate mass
    xx = self.root.currentChemElementStore
    result = sum(ii * xx.findFirstChemElement(symbol=ss).mass for (ss, ii) in dd.items())
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNmrExperiments(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nmrExperiments')
    result = frozenset(tempVar)
    return result
  
  def getNmrScreens(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tempVar = dataDict.get('nmrScreens')
    result = frozenset(tempVar)
    return result
  
  def getNonCovalentBonds(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.nonCovalentBonds
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('nonCovalentBonds').values()
    result = frozenset(tempVar)
    return result
  
  def getNumChains(self):
    """
    getter for derived attribtue numChains
    """
    dataDict = self.__dict__
    result = len(self.chains)
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getStructureEnsembles(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.structureEnsembles
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolStructure')
    tempVar = dataDict.get('structureEnsembles')
    result = frozenset(tempVar)
    return result
  
  def getStructureGroups(self):
    """
    Get for ccp.molecule.MolSystem.MolSystem.structureGroups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('structureGroups').values()
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newChain(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.Chain
    """
    return Chain(self, **attrlinks)
  
  def newChainInteraction(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.ChainInteraction
    """
    return ChainInteraction(self, **attrlinks)
  
  def newMolSystemLink(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.MolSystemLink
    """
    return MolSystemLink(self, **attrlinks)
  
  def newMolSystemSysName(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.MolSystemSysName
    """
    return MolSystemSysName(self, **attrlinks)
  
  def newNonCovalentBond(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.NonCovalentBond
    """
    return NonCovalentBond(self, **attrlinks)
  
  def newStructureGroup(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.StructureGroup
    """
    return StructureGroup(self, **attrlinks)
  
  def removeAnalysisLayout(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeAnalysisLayout:
       value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('analysisLayouts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAnalysisLayout:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAnalysisLayout:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAnalysisLayout:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAnalysisLayout:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['currentMolSystem'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAnalysisLayout')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeAnalysisPanel(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    from ccpnmr.api.AnalysisV3 import AnalysisPanel as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeAnalysisPanel:
       value is not of class ccpnmr.AnalysisV3.AnalysisPanel""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('analysisPanels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAnalysisPanel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAnalysisPanel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAnalysisPanel:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAnalysisPanel:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['currentMolSystem'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAnalysisPanel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeCitation(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    from ccp.api.general.Citation import Citation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeCitation:
       value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('citations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeCitation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeCitation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeCitation:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeCitation:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeCitation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeCommonName(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.commonNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 254):
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeCommonName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeCommonName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeCommonName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeCommonName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeDbReference(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    from ccp.api.general.DbRef import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeDbReference:
       value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('dbReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeDbReference:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeDbReference:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeDbReference:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeDbReference:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeDbReference')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeEntry(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeEntry:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('entries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeEntry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeEntry:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeEntry:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeEntry:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['molSystem'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeEntry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeFrom = memops.api.Implementation.TopObject.removeFrom
  
  def removeFunction(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.functions
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeFunction:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeFunction:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeFunction:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeFunction:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('functions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeFunction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeFunction:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeFunction:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeFunction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeKeyword(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeKeyword:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolSystemValidation(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSystemValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolSystemValidation:
       value is not of class ccp.molecule.Validation.MolSystemValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molSystemValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolSystemValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolSystemValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolSystemValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolSystemValidation:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolSystemValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeNmrExperiment(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeNmrExperiment:
       value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('nmrExperiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNmrExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNmrExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNmrExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNmrExperiment:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('molSystems')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNmrExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeNmrScreen(self, value):
    """
    Remove for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrScreen import NmrScreen as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeNmrScreen:
       value is not of class ccp.nmr.NmrScreen.NmrScreen""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('nmrScreens')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNmrScreen:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNmrScreen:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNmrScreen:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNmrScreen:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['target'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNmrScreen')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.MolSystem
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAnalysisLayouts(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAnalysisLayouts:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccpnmr.api.AnalysisV3 import AnalysisLayout as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnalysisLayouts:
         value is not of class ccpnmr.AnalysisV3.AnalysisLayout""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('analysisLayouts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('currentMolSystem')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setAnalysisLayouts:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisLayouts:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisLayouts:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnalysisLayouts:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAnalysisLayouts:
           Link analysisLayouts between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['currentMolSystem'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('currentMolSystem')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('analysisLayouts')
          vv.remove(cv)

      cv.__dict__['currentMolSystem'] = self

    dataDict['analysisLayouts'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisLayouts')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnalysisPanels(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAnalysisPanels:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccpnmr.api.AnalysisV3 import AnalysisPanel as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnalysisPanels:
         value is not of class ccpnmr.AnalysisV3.AnalysisPanel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('analysisPanels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('currentMolSystem')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setAnalysisPanels:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisPanels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisPanels:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnalysisPanels:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAnalysisPanels:
           Link analysisPanels between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['currentMolSystem'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('currentMolSystem')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('analysisPanels')
          vv.remove(cv)

      cv.__dict__['currentMolSystem'] = self

    dataDict['analysisPanels'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisPanels')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCitations(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setCitations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Citation import Citation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCitations:
         value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('citations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCitations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCitations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCitations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCitations:
           Link citations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.add(self)

    dataDict['citations'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCitations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCode(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystem.code
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode:
         cannot set code, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code'] = value

    # doNotifies
  
  def setCommonNames(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.commonNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCommonNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCommonNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['commonNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCommonNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy
  
  def setDbReferences(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setDbReferences:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.DbRef import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDbReferences:
         value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('dbReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDbReferences:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbReferences:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDbReferences:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setDbReferences:
           Link dbReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.add(self)

    dataDict['dbReferences'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDbReferences')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystem.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEntries(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setEntries:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrEntry import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setEntries:
         value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('entries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molSystem')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setEntries:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEntries:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEntries:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setEntries:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setEntries:
           Link entries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molSystem'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molSystem')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('entries')
          vv.remove(cv)

      cv.__dict__['molSystem'] = self

    dataDict['entries'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEntries')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFunctions(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.functions
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFunctions:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setFunctions:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFunctions:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFunctions:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('functions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFunctions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFunctions:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['functions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFunctions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setGuid = memops.api.Implementation.TopObject.setGuid
  
  def setHasChemExchange(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystem.hasChemExchange
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setHasChemExchange:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('hasChemExchange')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHasChemExchange:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHasChemExchange:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['hasChemExchange'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHasChemExchange')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable
  
  def setKeywords(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.keywords
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setKeywords:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setKeywords:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setKeywords:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['keywords'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setKeywords')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setMolSystemSymmetrySets(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSystemSymmetrySets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSystemSymmetrySets:
         value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molSystemSymmetrySets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molSystem')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setMolSystemSymmetrySets:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystemSymmetrySets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemSymmetrySets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystemSymmetrySets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setMolSystemSymmetrySets:
           locard molSystem: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSystemSymmetrySets:
           Link molSystemSymmetrySets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['molSystem'] = self

    dataDict['molSystemSymmetrySets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystemSymmetrySets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSystemValidations(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSystemValidations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.Validation import MolSystemValidation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSystemValidations:
         value is not of class ccp.molecule.Validation.MolSystemValidation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molSystemValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystemValidations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemValidations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystemValidations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSystemValidations:
           Link molSystemValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.add(self)

    dataDict['molSystemValidations'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystemValidations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystem.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setName:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrExperiments(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrExperiments:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import Experiment as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrExperiments:
         value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('nmrExperiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrExperiments:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrExperiments:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrExperiments:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrExperiments:
           Link nmrExperiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('molSystems')
        oldSelves.add(self)

    dataDict['nmrExperiments'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrExperiments')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrScreens(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrScreens:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrScreen import NmrScreen as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrScreens:
         value is not of class ccp.nmr.NmrScreen.NmrScreen""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('nmrScreens')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('target')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setNmrScreens:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrScreens:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrScreens:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrScreens:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrScreens:
           Link nmrScreens between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['target'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('target')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('nmrScreens')
          vv.remove(cv)

      cv.__dict__['target'] = self

    dataDict['nmrScreens'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrScreens')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStructureEnsembles(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystem.structureEnsembles
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setStructureEnsembles:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setStructureEnsembles:
         value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('structureEnsembles')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molSystem')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setStructureEnsembles:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStructureEnsembles:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStructureEnsembles:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setStructureEnsembles:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setStructureEnsembles:
           locard molSystem: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setStructureEnsembles:
           Link structureEnsembles between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['molSystem'] = self

    dataDict['structureEnsembles'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStructureEnsembles')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAnalysisLayouts(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.analysisLayouts
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('analysisLayouts')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedAnalysisPanels(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.analysisPanels
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccpnmr.AnalysisV3')
    tobjList = root.__dict__.get('analysisProjectV3s').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('analysisPanels')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChainInteractions(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.chainInteractions
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chainInteractions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChains(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.chains
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chains')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedCitations(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.citations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    ll = dataDict.get('citations')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedDbReferences(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.dbReferences
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    ll = dataDict.get('dbReferences')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedEntries(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.entries
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('entries')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSystemLinks(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.molSystemLinks
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molSystemLinks')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolSystemSymmetrySets(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('molsim.Symmetry')
    ll = dataDict.get('molSystemSymmetrySets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSystemSysNames(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.molSystemSysNames
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molSystemSysNames')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolSystemValidations(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.molSystemValidations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molSystemValidations')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNmrExperiments(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.nmrExperiments
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('nmrExperiments')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNmrScreens(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.nmrScreens
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    ll = dataDict.get('nmrScreens')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNonCovalentBonds(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.nonCovalentBonds
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('nonCovalentBonds')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedStructureEnsembles(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.structureEnsembles
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolStructure')
    ll = dataDict.get('structureEnsembles')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedStructureGroups(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystem.structureGroups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('structureGroups')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""MolSystem key, used in links from other packages. Should be a short, 
  name, recognisable to others.
  """)
  
  commonNames = property(getCommonNames, setCommonNames, None,
  r"""Common (non-systematic) names for MolSystem
  """)

  createdBy = memops.api.Implementation.TopObject.createdBy
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  functions = property(getFunctions, setFunctions, None,
  r"""Keywords describing the function of the MolSystem
  """)

  guid = memops.api.Implementation.TopObject.guid
  
  hasChemExchange = property(getHasChemExchange, setHasChemExchange, None,
  r"""Does MolSystem contain chains in chemical exchange?
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified
  
  isParamagnetic = property(getIsParamagnetic, None, None,
  r"""Is MolSystem paramagnetic?
  """)

  isReading = memops.api.Implementation.TopObject.isReading
  
  keywords = property(getKeywords, setKeywords, None,
  r"""Keywords for searching MolSystem.
  """)

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molecularMass = property(getMolecularMass, None, None,
  r"""molecular mass of MolSystem
  """)
  
  name = property(getName, setName, None,
  r"""Molecule name used for display purposes. User changeable.
  """)
  
  numChains = property(getNumChains, None, None,
  r"""number of Chains
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  analysisLayouts = property(getAnalysisLayouts, setAnalysisLayouts, None,
  r"""AnalysisLayouts referring MolSystem
  """)
  
  analysisPanels = property(getAnalysisPanels, setAnalysisPanels, None,
  r"""AnalysisPanels referring MolSystem
  """)
  
  chainInteractions = property(getChainInteractions,  None, None,
  r"""child link to class ChainInteraction
  """)
  
  chains = property(getChains,  None, None,
  r"""child link to class Chain
  """)
  
  citations = property(getCitations, setCitations, None,
  r"""Citations describing MolSystem
  """)
  
  dbReferences = property(getDbReferences, setDbReferences, None,
  r"""Database references describing MolSystem
  """)
  
  entries = property(getEntries, setEntries, None,
  r"""Bmrb Entries for MolSystem
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  molSystemLinks = property(getMolSystemLinks,  None, None,
  r"""child link to class MolSystemLink
  """)
  
  molSystemSymmetrySets = property(getMolSystemSymmetrySets, setMolSystemSymmetrySets, None,
  r"""MolSystemSymmetries that may apply to this MolSystem
  """)
  
  molSystemSysNames = property(getMolSystemSysNames,  None, None,
  r"""child link to class MolSystemSysName
  """)
  
  molSystemValidations = property(getMolSystemValidations, setMolSystemValidations, None,
  r"""Validation results for MolSystem
  """)
  
  nmrExperiments = property(getNmrExperiments, setNmrExperiments, None,
  r"""Nmr Experiments carried out on MolSystem
  """)
  
  nmrScreens = property(getNmrScreens, setNmrScreens, None,
  r"""
  """)
  
  nonCovalentBonds = property(getNonCovalentBonds,  None, None,
  r"""child link to class NonCovalentBond
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  structureEnsembles = property(getStructureEnsembles, setStructureEnsembles, None,
  r"""Molecular structures corresponding to MolSystem
  """)
  
  structureGroups = property(getStructureGroups,  None, None,
  r"""child link to class StructureGroup
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolSystemLink(memops.api.Implementation.DataObject):
  r"""Link between two ChemComps (bulding blocks) not already described in the 
Molecule description. Intended for intermolecular links, additional 
crosslinks, or links whose location was not known precisely when 
describing the Molecule. Disulfide bonds would be a good example for 
either category. Part of the description of MolSystem level additional 
links.
  """
  #   from data model element ccp.molecule.MolSystem.MolSystemLink revision ?
  _metaclass = metaPackage.getElement('MolSystemLink')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'dihedralAngle', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'molSystem', 'molSystemLinkEnds', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    dataDict['molSystem'] = parent
    if (not isinstance(parent, MolSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['dihedralAngle'] = None
      dataDict['access'] = None
      dataDict['molSystemLinkEnds'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.MolSystemLink.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molSystemLinks')
        objKey = dataDict.get('molSystemLinkEnds')
        if (objKey is not None):
          objKey = frozenset(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molSystemLinkEnds'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.MolSystemLink:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.MolSystemLink:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for molSystemLinkEnd in dataDict.get('molSystemLinkEnds'):
      if (not (molSystemLinkEnd in objsToBeDeleted)):
        molSystemLinkEnd.__dict__['molSystemLink'] = None

    molSystem = dataDict.get('molSystem')
    if (not (molSystem in objsToBeDeleted)):
      objKey = dataDict.get('molSystemLinkEnds')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molSystem.__dict__.get('molSystemLinks')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('molSystemLinkEnds')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molSystem')
        dd = value.__dict__.get('molSystemLinks')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dihedralAngle')
      if (value is not None):
        if (not (value in [0, 180, 90, -90, 120, -120])):
          raise ApiError("""%s.checkValid: dihedralAngle:
           ccp.molecule.Molecule.LinkDihedralAngle input is not in enumeration [0, 180, 90, -90, 120, -120]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molSystem')
      if (not isinstance(value, MolSystem)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('molSystemLinkEnds')
      for value in values:
        if (not isinstance(value, MolSystemLinkEnd)):
          raise ApiError("""%s.checkValid: molSystemLinkEnds:
           value is not of class ccp.molecule.MolSystem.MolSystemLinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSystemLink')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystemLinkEnds:
           non-reciprocal link molSystemLinkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('dihedralAngle')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('molSystemLinkEnds')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: molSystemLinkEnds:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllMolSystemLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.MolSystemLink.molSystemLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molSystemLinkEnds')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molSystemLinkEnds')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molSystemLink', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstMolSystemLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.MolSystemLink.molSystemLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molSystemLinkEnds')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('molSystemLinkEnds')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molSystemLink', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.MolSystemLink
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.MolSystemLink'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.MolSystemLink'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = frozenset(tempList)
      obj2 = obj1.__dict__.get('molSystemLinks').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDihedralAngle(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLink.dihedralAngle
    """
    dataDict = self.__dict__
    result = dataDict.get('dihedralAngle')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    for xx in dataDict.get('molSystemLinkEnds'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystemLinkEnds')
    if (result is not None):
      result = frozenset(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLink.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result
  
  def getMolSystemLinkEnds(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLink.molSystemLinkEnds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molSystemLinkEnds')
    result = frozenset(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLink.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.MolSystemLink
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDihedralAngle(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystemLink.dihedralAngle
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [0, 180, 90, -90, 120, -120])):
        raise ApiError("""%s.setDihedralAngle:
         ccp.molecule.Molecule.LinkDihedralAngle input is not in enumeration [0, 180, 90, -90, 120, -120]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dihedralAngle')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDihedralAngle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDihedralAngle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dihedralAngle'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDihedralAngle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSystemLinkEnds(self, values):
    """
    Set for ccp.molecule.MolSystem.MolSystemLink.molSystemLinkEnds
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSystemLinkEnds:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, MolSystemLinkEnd)):
        raise ApiError("""%s.setMolSystemLinkEnds:
         value is not of class ccp.molecule.MolSystem.MolSystemLinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('molSystemLinkEnds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemLinkEnds:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystemLinkEnds:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolSystemLinkEnds:
         cannot set molSystemLinkEnds, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 2)):
        raise ApiError("""%s.setMolSystemLinkEnds:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      oldSelves = {}
      for cv in values:
        if (not (cv in currentValues)):
          oldSelf = cv.__dict__.get('molSystemLink')
          if (oldSelf is not None):
            knt = oldSelves.get(oldSelf)
            if (knt is None):
              knt = 1
            else:
              knt = knt + 1

            oldSelves[oldSelf] = knt

      for osv in oldSelves.keys():
        siblingValues = osv.__dict__.get('molSystemLinkEnds')
        knt = oldSelves.get(osv)
        if (len(siblingValues) < (2 + knt)):
          raise ApiError("""%s.setMolSystemLinkEnds:
           locard: siblingValues: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSystemLinkEnds:
           Link molSystemLinkEnds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molSystemLink'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molSystemLink')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('molSystemLinkEnds')
          vv.remove(cv)

      cv.__dict__['molSystemLink'] = self

    dataDict['molSystemLinkEnds'] = values

    # doNotifies
  
  def sortedMolSystemLinkEnds(self):
    """
    Sorted for ccp.molecule.MolSystem.MolSystemLink.molSystemLinkEnds
    """
    dataDict = self.__dict__
    ll = dataDict.get('molSystemLinkEnds')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  dihedralAngle = property(getDihedralAngle, setDihedralAngle, None,
  r"""Approximate value in degrees of dihedral angle formed across bond (as 
  defined in the ChemComp Link definitions). The value is not precise but 
  serves to indicate the conformation of rotationally hindered bonds.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  molSystem = property(getMolSystem,  None, None,
  r"""parent link
  """)
  
  molSystemLinkEnds = property(getMolSystemLinkEnds, setMolSystemLinkEnds, None,
  r"""LinkEnds that make up the MolSystemLink
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolSystemLinkEnd(memops.api.Implementation.DataObject):
  r"""LinkEnd, equivalent to ChemComp.LinkEnd. Part of the description of 
MolSystem level additional links. Note that the MolSeqLinkEnds defined 
in the Molecule corresponding to this Chain are also valid for the 
Chain, so that both need to be considered when describing the topology 
of the MolSystem
  """
  #   from data model element ccp.molecule.MolSystem.MolSystemLinkEnd revision ?
  _metaclass = metaPackage.getElement('MolSystemLinkEnd')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'linkCode', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'linkEnd', 'molSystemLink', 'parent', 'residue', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    dataDict['residue'] = parent
    if (not isinstance(parent, Residue)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['linkCode'] = None
      dataDict['access'] = None
      dataDict['molSystemLink'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.MolSystemLinkEnd.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molSystemLinkEnds')
        objKey = dataDict.get('linkCode')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['linkCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.MolSystemLinkEnd:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molSystemLink = dataDict.get('molSystemLink')
    if (molSystemLink is not None):
      if (not (molSystemLink in objsToBeDeleted)):
        objsToBeDeleted.add(molSystemLink)
        objsToBeChecked.append(molSystemLink)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.MolSystemLinkEnd:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    residue = dataDict.get('residue')
    if (not (residue in objsToBeDeleted)):
      objKey = dataDict.get('linkCode')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = residue.__dict__.get('molSystemLinkEnds')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('linkCode')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('residue')
        dd = value.__dict__.get('molSystemLinkEnds')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'residue' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('linkCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linkCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getLinkEnd()
      if (value is None):
        raise ApiError("""%s.checkValid: linkEnd:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import LinkEnd as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: linkEnd:
         value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: linkEnd:
         Link linkEnd between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('molSystemLink')
      if (value is not None):
        if (not isinstance(value, MolSystemLink)):
          raise ApiError("""%s.checkValid: molSystemLink:
           value is not of class ccp.molecule.MolSystem.MolSystemLink""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molSystemLinkEnds')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSystemLink:
           non-reciprocal link molSystemLink from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSystemLink:
           Link molSystemLink between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('residue')
      if (not isinstance(value, Residue)):
        raise ApiError("""%s.checkValid: residue:
         value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    le =  self.residue.molResidue.findFirstMolResLinkEnd(linkCode=self.linkCode)
    if le and le.molResLink:
      isValid = False
    else:
      isValid = True
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint link_must_not_be_made_in_Molecule violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('linkCode')
    if (value is None):
      raise ApiError("""%s.checkValid: linkCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('molSystemLink')
    value = dataDict.get('residue')
    if (value is None):
      raise ApiError("""%s.checkValid: residue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.MolSystemLinkEnd
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.MolSystemLinkEnd'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.MolSystemLinkEnd'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('chains').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('residues').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('molSystemLinkEnds').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('residue')
    obj2 = obj3.__dict__.get('chain')
    obj1 = obj2.__dict__.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(obj2.__dict__.get('code'))
    result.append(obj3.__dict__.get('seqId'))
    result.append(dataDict.get('linkCode'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLinkCode(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLinkEnd.linkCode
    """
    dataDict = self.__dict__
    result = dataDict.get('linkCode')
    return result
  
  def getLinkEnd(self):
    """
    getter for derived link linkEnd
    """
    dataDict = self.__dict__
    residue = self.residue
    result = residue.getByNavigation(
     'chain', 'molecule', 
     ('molResidues', residue.seqId), 'chemComp',
     ('chemCompVars', (residue.linking, residue.descriptor)), 
     ('linkEnds', self.linkCode),
    )
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('linkCode')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystemLink(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLinkEnd.molSystemLink
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystemLink')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLinkEnd.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('residue')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidue(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemLinkEnd.residue
    """
    dataDict = self.__dict__
    result = dataDict.get('residue')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setLinkCode(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystemLinkEnd.linkCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinkCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linkCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinkCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLinkCode:
         cannot set linkCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLinkCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['linkCode'] = value

    # doNotifies
  
  def setMolSystemLink(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystemLinkEnd.molSystemLink
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, MolSystemLink)):
        raise ApiError("""%s.setMolSystemLink:
         value is not of class ccp.molecule.MolSystem.MolSystemLink""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSystemLink')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystemLink:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemLink:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystemLink:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (currentValue is not None):
        oldSelves = currentValue.__dict__.get('molSystemLinkEnds')
        if (len(oldSelves) < (2 + 1)):
          raise ApiError("""%s.setMolSystemLink:
           locard: oldSelves: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        newSelves = value.__dict__.get('molSystemLinkEnds')
        if (len(newSelves) >= 2):
          raise ApiError("""%s.setMolSystemLink:
           hicard: newSelves: cannot add value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSystemLink:
           Link molSystemLink between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molSystemLinkEnds')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolSystemLink:
         Read link 'molSystemLink' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molSystemLinkEnds')
      newSelves.add(self)

    dataDict['molSystemLink'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystemLink')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  linkCode = property(getLinkCode, setLinkCode, None,
  r"""Link Code identifying Link End for Residue. Part of Key for the derived 
  link 'linkEnd'. 
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  linkEnd = property(getLinkEnd, None, None,
  r"""ChemComp LinkEnd corresponding to MolSysLinkEnd
  """)
  
  molSystemLink = property(getMolSystemLink, setMolSystemLink, None,
  r"""Link made up from the two LinkEnds.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for residue
  """)
  
  residue = property(getResidue,  None, None,
  r"""parent link
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolSystemSysName(memops.api.Implementation.DataObject):
  r"""Systematic name of MolSystem according to namingSystem
  """
  #   from data model element ccp.molecule.MolSystem.MolSystemSysName revision ?
  _metaclass = metaPackage.getElement('MolSystemSysName')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'namingSystem', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'molSystem', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    dataDict['molSystem'] = parent
    if (not isinstance(parent, MolSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['namingSystem'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.MolSystemSysName.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molSystemSysNames')
        objKey = dataDict.get('namingSystem')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['namingSystem'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.MolSystemSysName:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.MolSystemSysName:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molSystem = dataDict.get('molSystem')
    if (not (molSystem in objsToBeDeleted)):
      objKey = dataDict.get('namingSystem')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molSystem.__dict__.get('molSystemSysNames')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('namingSystem')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molSystem')
        dd = value.__dict__.get('molSystemSysNames')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('namingSystem')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: namingSystem:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: namingSystem:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: namingSystem:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: namingSystem:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molSystem')
      if (not isinstance(value, MolSystem)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    value = dataDict.get('namingSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: namingSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.MolSystemSysName
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.MolSystemSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.MolSystemSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('molSystemSysNames').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(dataDict.get('namingSystem'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemSysName.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemSysName.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNamingSystem(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemSysName.namingSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.MolSystemSysName.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.MolSystemSysName
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setName(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystemSysName.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNamingSystem(self, value):
    """
    Set for ccp.molecule.MolSystem.MolSystemSysName.namingSystem
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setNamingSystem:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setNamingSystem:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setNamingSystem:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setNamingSystem:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('namingSystem')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNamingSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setNamingSystem:
         cannot set namingSystem, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setNamingSystem:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['namingSystem'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of MolSystem accordign to namingSystem
  """)
  
  namingSystem = property(getNamingSystem, setNamingSystem, None,
  r"""name of alternative nomenclature system. E.g. EC enzyme classification.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  molSystem = property(getMolSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class NonCovalentBond(memops.api.Implementation.DataObject):
  r"""NonCovalent bond, e.g. hydrogen bond, metal coordination bond
  """
  #   from data model element ccp.molecule.MolSystem.NonCovalentBond revision ?
  _metaclass = metaPackage.getElement('NonCovalentBond')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'atoms', 'molSystem', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    dataDict['molSystem'] = parent
    if (not isinstance(parent, MolSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['access'] = None
      dataDict['atoms'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.NonCovalentBond.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('nonCovalentBonds')
        objKey = dataDict.get('atoms')
        if (objKey is not None):
          objKey = frozenset(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['atoms'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.NonCovalentBond:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.NonCovalentBond:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for atom in dataDict.get('atoms'):
      if (not (atom in objsToBeDeleted)):
        nonCovalentBonds = atom.__dict__.get('nonCovalentBonds')
        nonCovalentBonds.remove(self)

    molSystem = dataDict.get('molSystem')
    if (not (molSystem in objsToBeDeleted)):
      objKey = dataDict.get('atoms')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molSystem.__dict__.get('nonCovalentBonds')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('atoms')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molSystem')
        dd = value.__dict__.get('nonCovalentBonds')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('atoms')
      for value in values:
        if (not isinstance(value, Atom)):
          raise ApiError("""%s.checkValid: atoms:
           value is not of class ccp.molecule.MolSystem.Atom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('nonCovalentBonds')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: atoms:
           non-reciprocal link atoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molSystem')
      if (not isinstance(value, MolSystem)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('atoms')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: atoms:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.NonCovalentBond.atoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atoms')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atoms')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomSet', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.NonCovalentBond.atoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atoms')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('atoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomSet', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtoms(self):
    """
    Get for ccp.molecule.MolSystem.NonCovalentBond.atoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atoms')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.NonCovalentBond
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.NonCovalentBond'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.NonCovalentBond'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = frozenset(tempList)
      obj2 = obj1.__dict__.get('nonCovalentBonds').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    for xx in dataDict.get('atoms'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    result = dataDict.get('atoms')
    if (result is not None):
      result = frozenset(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    Get for ccp.molecule.MolSystem.NonCovalentBond.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.NonCovalentBond.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.NonCovalentBond
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtoms(self, values):
    """
    Set for ccp.molecule.MolSystem.NonCovalentBond.atoms
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Atom)):
        raise ApiError("""%s.setAtoms:
         value is not of class ccp.molecule.MolSystem.Atom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAtoms:
         cannot set atoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 2)):
        raise ApiError("""%s.setAtoms:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtoms:
           Link atoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('nonCovalentBonds')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('nonCovalentBonds')
        oldSelves.add(self)

    dataDict['atoms'] = values

    # doNotifies
  
  def sortedAtoms(self):
    """
    Sorted for ccp.molecule.MolSystem.NonCovalentBond.atoms
    """
    dataDict = self.__dict__
    ll = dataDict.get('atoms')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atoms = property(getAtoms, setAtoms, None,
  r"""Atoms in non-covalent bond
  """)
  
  molSystem = property(getMolSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Residue(memops.api.Implementation.DataObject):
  r"""A monomer part of a specific molecule in a specific environment 
(Chain)). 
  """
  #   from data model element ccp.molecule.MolSystem.Residue revision ?
  _metaclass = metaPackage.getElement('Residue')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'ccpCode', 'className', 'descriptor', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'linking', 'metaclass', 'molType', 'packageName', 'packageShortName', 'qualifiedName', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'activeAccess', 'atoms', 'chain', 'chainFragment', 'chainStateSets', 'chemCompVar', 'dangleResidues', 'molResidue', 'molSysResidueValidations', 'molSystemLinkEnds', 'parent', 'residueProbs', 'resonanceGroups', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    dataDict['chain'] = parent
    if (not isinstance(parent, Chain)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['descriptor'] = None
      dataDict['details'] = None
      dataDict['linking'] = None
      dataDict['seqCode'] = None
      dataDict['seqId'] = None
      dataDict['seqInsertCode'] = ' '
      dataDict['access'] = None
      dataDict['atoms'] = {}
      dataDict['chainFragment'] = None
      dataDict['chainStateSets'] = set()
      dataDict['dangleResidues'] = set()
      dataDict['molSysResidueValidations'] = set()
      dataDict['molSystemLinkEnds'] = {}
      dataDict['residueProbs'] = set()
      dataDict['resonanceGroups'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.Residue.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('residues')
        objKey = dataDict.get('seqId')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['seqId'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        
        
        clazz = ccp.api.molecule.ChemComp.ChemAtom
        ccv = self.chemCompVar
        for chemAtom in ccv.chemAtoms:
          if isinstance(chemAtom, clazz):
            Atom(self, name=chemAtom.name)

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.Residue:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    atoms = dataDict.get('atoms').values()
    for atom in atoms:
      if (not (atom in objsToBeDeleted)):
        objsToBeDeleted.add(atom)
        objsToBeChecked.append(atom)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    chainStateSets = dataDict.get('chainStateSets')
    pass
    for chainStateSet in chainStateSets:
      topObject = chainStateSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dangleResidues = dataDict.get('dangleResidues')
    for dangleResidue in dangleResidues:
      if (not (dangleResidue in objsToBeDeleted)):
        objsToBeDeleted.add(dangleResidue)
        objsToBeChecked.append(dangleResidue)

    for dangleResidue in dangleResidues:
      topObject = dangleResidue.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSysResidueValidations = dataDict.get('molSysResidueValidations')
    pass
    for molSysResidueValidation in molSysResidueValidations:
      topObject = molSysResidueValidation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molSystemLinkEnds = dataDict.get('molSystemLinkEnds').values()
    for molSystemLinkEnd in molSystemLinkEnds:
      if (not (molSystemLinkEnd in objsToBeDeleted)):
        objsToBeDeleted.add(molSystemLinkEnd)
        objsToBeChecked.append(molSystemLinkEnd)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    residueProbs = dataDict.get('residueProbs')
    for residueProb in residueProbs:
      if (not (residueProb in objsToBeDeleted)):
        objsToBeDeleted.add(residueProb)
        objsToBeChecked.append(residueProb)

    for residueProb in residueProbs:
      topObject = residueProb.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    resonanceGroups = dataDict.get('resonanceGroups')
    pass
    for resonanceGroup in resonanceGroups:
      topObject = resonanceGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.Residue:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chainStateSet in dataDict.get('chainStateSets'):
      if (not (chainStateSet in objsToBeDeleted)):
        residues = chainStateSet.__dict__.get('residues')
        residues.remove(self)

    for molSysResidueValidation in dataDict.get('molSysResidueValidations'):
      if (not (molSysResidueValidation in objsToBeDeleted)):
        residues = molSysResidueValidation.__dict__.get('residues')
        residues.remove(self)

    for resonanceGroup in dataDict.get('resonanceGroups'):
      if (not (resonanceGroup in objsToBeDeleted)):
        resonanceGroup.__dict__['residue'] = None

    chain = dataDict.get('chain')
    if (not (chain in objsToBeDeleted)):
      objKey = dataDict.get('seqId')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chain.__dict__.get('residues')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChainStateSet(self, value):
    """
    Add for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ChainStateSet as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addChainStateSet:
       value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChainStateSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChainStateSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChainStateSet:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChainStateSet:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChainStateSet:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (self.chain is value.chain)):
            raise ApiError("""%s.addChainStateSet:
             residues constraint self_chain_is_value_chain violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelves = value.__dict__.get('residues')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChainStateSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolSysResidueValidation(self, value):
    """
    Add for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSysResidueValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolSysResidueValidation:
       value is not of class ccp.molecule.Validation.MolSysResidueValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysResidueValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolSysResidueValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolSysResidueValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolSysResidueValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolSysResidueValidation:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolSysResidueValidation:
           Link molSysResidueValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('residues')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolSysResidueValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addResonanceGroup(self, value):
    """
    Add for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ResonanceGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addResonanceGroup:
       value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('resonanceGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('residue')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResonanceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addResonanceGroup:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addResonanceGroup:
           Link resonanceGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value is None or self.isActive)):
            raise ApiError("""%s.addResonanceGroup:
             residue constraint Only_active_ResonanceGroups_can_have_residue violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          cc = self.chemComp
          isValid = (cc is None or cc is value.molResidue.chemComp)
          if (not (isValid)):
            raise ApiError("""%s.addResonanceGroup:
             residue constraint residue_consistent_with_chemComp violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelf = value.__dict__.get('residue')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('resonanceGroups')
      siblingValues.remove(value)

    value.__dict__['residue'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addResonanceGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('atoms').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molSystemLinkEnds').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('seqId')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chain')
        dd = value.__dict__.get('residues')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chain' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getCcpCode()
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('descriptor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: descriptor:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('linking')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linking:
         ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getMolType()
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqCode')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: seqCode:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqId')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: seqId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqInsertCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: seqInsertCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: seqInsertCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: seqInsertCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: seqInsertCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('atoms').values()
      for value in values:
        if (not isinstance(value, Atom)):
          raise ApiError("""%s.checkValid: atoms:
           value is not of class ccp.molecule.MolSystem.Atom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('residue')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: atoms:
           non-reciprocal link atoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('chain')
      if (not isinstance(value, Chain)):
        raise ApiError("""%s.checkValid: chain:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('chainFragment')
      if (value is not None):
        if (not isinstance(value, ChainFragment)):
          raise ApiError("""%s.checkValid: chainFragment:
           value is not of class ccp.molecule.MolSystem.ChainFragment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('residues')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chainFragment:
           non-reciprocal link chainFragment from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('chainStateSets')
      for value in values:
        from ccp.api.nmr.Nmr import ChainStateSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chainStateSets:
           value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('residues')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chainStateSets:
           non-reciprocal link chainStateSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chainStateSets:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getChemCompVar()
      if (value is None):
        raise ApiError("""%s.checkValid: chemCompVar:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import ChemCompVar as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemCompVar:
         value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemCompVar:
         Link chemCompVar between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dangleResidues')
      for value in values:
        from cambridge.api.Dangle import DangleResidue as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dangleResidues:
           value is not of class cambridge.Dangle.DangleResidue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('residue')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: dangleResidues:
           non-reciprocal link dangleResidues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('chain')
        yy1 = value.__dict__.get('dangleChain')
        yy2 = yy1.__dict__.get('chain')
        if (not (xx1 is yy2)):
          raise ApiError("""%s.checkValid: dangleResidues:
           Link dangleResidues between objects from separate partitions
           - cambridge.Dangle.DangleChain.chain not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getMolResidue()
      if (value is None):
        raise ApiError("""%s.checkValid: molResidue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.Molecule import MolResidue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: molResidue:
         value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: molResidue:
         Link molResidue between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSysResidueValidations')
      for value in values:
        from ccp.api.molecule.Validation import MolSysResidueValidation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSysResidueValidations:
           value is not of class ccp.molecule.Validation.MolSysResidueValidation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('residues')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSysResidueValidations:
           non-reciprocal link molSysResidueValidations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSysResidueValidations:
           Link molSysResidueValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molSystemLinkEnds').values()
      for value in values:
        if (not isinstance(value, MolSystemLinkEnd)):
          raise ApiError("""%s.checkValid: molSystemLinkEnds:
           value is not of class ccp.molecule.MolSystem.MolSystemLinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('residue')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystemLinkEnds:
           non-reciprocal link molSystemLinkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('residueProbs')
      for value in values:
        from ccp.api.nmr.Nmr import ResidueProb as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: residueProbs:
           value is not of class ccp.nmr.Nmr.ResidueProb""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('possibility')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residueProbs:
           non-reciprocal link residueProbs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: residueProbs:
           Link residueProbs between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('resonanceGroups')
      for value in values:
        from ccp.api.nmr.Nmr import ResonanceGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('residue')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           non-reciprocal link resonanceGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           Link resonanceGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    isValid = True
    
    molResidue = self.getByNavigation(
     'chain', 
     'molecule', 
     ('molResidues', self.seqId),
    )
    chemCompVar = molResidue.getByNavigation(
     'chemComp', 
     ('chemCompVars', (self.linking,  self.descriptor))
    )
    
    linkCodes = set(x.linkCode for x in chemCompVar.linkEnds)
    
    for le in self.molSystemLinkEnds:
      if le.linkCode not in linkCodes:
        isValid = False
        
    for le in molResidue.molResLinkEnds:
      if le.linkCode not in linkCodes:
        isValid = False
    
    clazz = ccp.api.molecule.ChemComp.ChemAtom
    aset = set(ca.name for ca in chemCompVar.chemAtoms if isinstance(ca, clazz))
      
    for atom in self.atoms:
      if atom.name not in aset:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint linking_and_descriptor_must_be_consistent_with_Atoms_and_LinkEnds violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('descriptor')
    if (value is None):
      raise ApiError("""%s.checkValid: descriptor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('linking')
    if (value is None):
      raise ApiError("""%s.checkValid: linking:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqCode')
    if (value is None):
      raise ApiError("""%s.checkValid: seqCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqId')
    if (value is None):
      raise ApiError("""%s.checkValid: seqId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqInsertCode')
    if (value is None):
      raise ApiError("""%s.checkValid: seqInsertCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (len(value) == 1)):
      raise ApiError("""%s.checkValid: seqInsertCode:
       seqInsertCode constraint length_is_one violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('atoms').values()
    value = dataDict.get('chain')
    if (value is None):
      raise ApiError("""%s.checkValid: chain:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('chainFragment')
    values = dataDict.get('chainStateSets')
    for value in values:
      (self, value) = (value, self)
      if (not (self.chain is value.chain)):
        raise ApiError("""%s.checkValid: chainStateSets:
         residues constraint self_chain_is_value_chain violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

    values = dataDict.get('dangleResidues')
    values = dataDict.get('molSysResidueValidations')
    values = dataDict.get('molSystemLinkEnds').values()
    values = dataDict.get('residueProbs')
    values = dataDict.get('resonanceGroups')
    for value in values:
      (self, value) = (value, self)
      if (not (value is None or self.isActive)):
        raise ApiError("""%s.checkValid: resonanceGroups:
         residue constraint Only_active_ResonanceGroups_can_have_residue violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      cc = self.chemComp
      isValid = (cc is None or cc is value.molResidue.chemComp)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: resonanceGroups:
         residue constraint residue_consistent_with_chemComp violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.atoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atoms').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atoms').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomSet', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChainStateSets(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stateSetType', 'access', 'chain', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllDangleResidues(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.dangleResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleResidues')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleResidues')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('numIslands', 'omegaLower', 'omegaUpper', 'omegaValue', 'phiLower', 'phiUpper', 'phiValue', 'psiLower', 'psiUpper', 'psiValue', 'secStrucCode', 'access', 'dangleChain', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSysResidueValidations(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysResidueValidations')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysResidueValidations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystemLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.molSystemLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molSystemLinkEnds').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molSystemLinkEnds').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molSystemLink', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResidueProbs(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.residueProbs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueProbs')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueProbs')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'possibility', 'resonanceGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResonanceGroups(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'clusterCode', 'descriptor', 'details', 'isActive', 'linking', 'molType', 'name', 'secStrucCode', 'serial', 'access', 'nmrProject', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.atoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atoms').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('atoms').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('atoms').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomSet', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChainStateSet(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chainStateSets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stateSetType', 'access', 'chain', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstDangleResidue(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.dangleResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleResidues')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('cambridge.Dangle')
      tobjList = root.__dict__.get('dangleStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dangleResidues')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('numIslands', 'omegaLower', 'omegaUpper', 'omegaValue', 'phiLower', 'phiUpper', 'phiValue', 'psiLower', 'psiUpper', 'psiValue', 'secStrucCode', 'access', 'dangleChain', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSysResidueValidation(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysResidueValidations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Validation')
      tobjList = root.__dict__.get('validationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSysResidueValidations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'context', 'details', 'figOfMerit', 'floatValue', 'intValue', 'keyword', 'serial', 'textValue', 'access', 'validationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystemLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.molSystemLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molSystemLinkEnds').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('linkCode')
      if (objKey is not None):
        result = dataDict.get('molSystemLinkEnds').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('molSystemLinkEnds').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molSystemLink', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResidueProb(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.residueProbs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueProbs')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueProbs')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'possibility', 'resonanceGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResonanceGroup(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('resonanceGroups')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'clusterCode', 'descriptor', 'details', 'isActive', 'linking', 'molType', 'name', 'secStrucCode', 'serial', 'access', 'nmrProject', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtoms(self):
    """
    Get for ccp.molecule.MolSystem.Residue.atoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atoms').values()
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.Residue
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.Residue'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.Residue'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('chains').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('residues').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCcpCode(self):
    """
    getter for derived attribute ccpCode
    """
    dataDict = self.__dict__
    result = self.getByNavigation('chain', 'molecule', ('molResidues', self.seqId), 'chemComp', 'ccpCode')
    return result
  
  def getChain(self):
    """
    Get for ccp.molecule.MolSystem.Residue.chain
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result
  
  def getChainFragment(self):
    """
    Get for ccp.molecule.MolSystem.Residue.chainFragment
    """
    dataDict = self.__dict__
    result = dataDict.get('chainFragment')
    return result
  
  def getChainStateSets(self):
    """
    Get for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('chainStateSets')
    result = frozenset(tempVar)
    return result
  
  def getChemCompVar(self):
    """
    getter for derived link chemCompVar
    """
    dataDict = self.__dict__
    # NB left with direct access for speed only
    result = self.getByNavigation('chain', 'molecule', ('molResidues', dataDict['seqId']), 'chemComp', ('chemCompVars',(dataDict['linking'],dataDict['descriptor'])))
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDangleResidues(self):
    """
    Get for ccp.molecule.MolSystem.Residue.dangleResidues
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('dangleResidues')
    result = frozenset(tempVar)
    return result
  
  def getDescriptor(self):
    """
    Get for ccp.molecule.MolSystem.Residue.descriptor
    """
    dataDict = self.__dict__
    result = dataDict.get('descriptor')
    return result
  
  def getDetails(self):
    """
    Get for ccp.molecule.MolSystem.Residue.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('chain')
    obj1 = obj2.__dict__.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(obj2.__dict__.get('code'))
    result.append(dataDict.get('seqId'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLinking(self):
    """
    Get for ccp.molecule.MolSystem.Residue.linking
    """
    dataDict = self.__dict__
    result = dataDict.get('linking')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    result = dataDict.get('seqId')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolResidue(self):
    """
    getter function for derived link molResidue
    """
    dataDict = self.__dict__
    result = self.getByNavigation('chain', 'molecule', ('molResidues', self.seqId))
    return result
  
  def getMolSysResidueValidations(self):
    """
    Get for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molSysResidueValidations')
    result = frozenset(tempVar)
    return result
  
  def getMolSystemLinkEnds(self):
    """
    Get for ccp.molecule.MolSystem.Residue.molSystemLinkEnds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molSystemLinkEnds').values()
    result = frozenset(tempVar)
    return result
  
  def getMolType(self):
    """
    getter for derived attribute molType
    """
    dataDict = self.__dict__
    result = self.getByNavigation('chain', 'molecule', ('molResidues', self.seqId), 'chemComp', 'molType')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.Residue.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidueProbs(self):
    """
    Get for ccp.molecule.MolSystem.Residue.residueProbs
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('residueProbs')
    result = frozenset(tempVar)
    return result
  
  def getResonanceGroups(self):
    """
    Get for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('resonanceGroups')
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSeqCode(self):
    """
    Get for ccp.molecule.MolSystem.Residue.seqCode
    """
    dataDict = self.__dict__
    result = dataDict.get('seqCode')
    return result
  
  def getSeqId(self):
    """
    Get for ccp.molecule.MolSystem.Residue.seqId
    """
    dataDict = self.__dict__
    result = dataDict.get('seqId')
    return result
  
  def getSeqInsertCode(self):
    """
    Get for ccp.molecule.MolSystem.Residue.seqInsertCode
    """
    dataDict = self.__dict__
    result = dataDict.get('seqInsertCode')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newAtom(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.Atom
    """
    return Atom(self, **attrlinks)
  
  def newMolSystemLinkEnd(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.MolSystemLinkEnd
    """
    return MolSystemLinkEnd(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChainStateSet(self, value):
    """
    Remove for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ChainStateSet as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeChainStateSet:
       value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChainStateSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChainStateSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChainStateSet:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChainStateSet:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('residues')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChainStateSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolSysResidueValidation(self, value):
    """
    Remove for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Validation import MolSysResidueValidation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolSysResidueValidation:
       value is not of class ccp.molecule.Validation.MolSysResidueValidation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysResidueValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolSysResidueValidation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolSysResidueValidation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolSysResidueValidation:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolSysResidueValidation:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('residues')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolSysResidueValidation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeResonanceGroup(self, value):
    """
    Remove for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ResonanceGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeResonanceGroup:
       value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('resonanceGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResonanceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResonanceGroup:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['residue'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeResonanceGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.Residue
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChainFragment(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.chainFragment
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ChainFragment)):
        raise ApiError("""%s.setChainFragment:
         value is not of class ccp.molecule.MolSystem.ChainFragment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chainFragment')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainFragment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainFragment:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChainFragment:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChainFragment:
           Link chainFragment between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('residues')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setChainFragment:
         Read link 'chainFragment' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('residues')
      newSelves.append(self)

    dataDict['chainFragment'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChainFragment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChainStateSets(self, values):
    """
    Set for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChainStateSets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ChainStateSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChainStateSets:
         value is not of class ccp.nmr.Nmr.ChainStateSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('chainStateSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainStateSets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainStateSets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChainStateSets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChainStateSets:
           Link chainStateSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (self.chain is value.chain)):
            raise ApiError("""%s.setChainStateSets:
             residues constraint self_chain_is_value_chain violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('residues')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('residues')
        oldSelves.add(self)

    dataDict['chainStateSets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChainStateSets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDangleResidues(self, values):
    """
    Set for ccp.molecule.MolSystem.Residue.dangleResidues
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setDangleResidues:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from cambridge.api.Dangle import DangleResidue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDangleResidues:
         value is not of class cambridge.Dangle.DangleResidue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('dangleResidues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('residue')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setDangleResidues:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDangleResidues:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDangleResidues:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDangleResidues:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setDangleResidues:
           locard residue: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('chain')
      for value in values:
        yy1 = value.__dict__.get('dangleChain')
        yy2 = yy1.__dict__.get('chain')
        if (not (xx1 is yy2)):
          raise ApiError("""%s.setDangleResidues:
           Link dangleResidues between objects from separate partitions
           - cambridge.Dangle.DangleChain.chain not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['residue'] = self

    dataDict['dangleResidues'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDangleResidues')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDescriptor(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.descriptor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setDescriptor:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('descriptor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDescriptor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDescriptor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDescriptor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['descriptor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDescriptor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLinking(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.linking
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinking:
       ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linking')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLinking:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinking:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setLinking:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['linking'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLinking')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSysResidueValidations(self, values):
    """
    Set for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSysResidueValidations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.Validation import MolSysResidueValidation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSysResidueValidations:
         value is not of class ccp.molecule.Validation.MolSysResidueValidation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSysResidueValidations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSysResidueValidations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSysResidueValidations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSysResidueValidations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSysResidueValidations:
           Link molSysResidueValidations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('residues')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('residues')
        oldSelves.add(self)

    dataDict['molSysResidueValidations'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSysResidueValidations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResidueProbs(self, values):
    """
    Set for ccp.molecule.MolSystem.Residue.residueProbs
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResidueProbs:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ResidueProb as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setResidueProbs:
         value is not of class ccp.nmr.Nmr.ResidueProb""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('residueProbs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('possibility')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setResidueProbs:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResidueProbs:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResidueProbs:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResidueProbs:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setResidueProbs:
           locard possibility: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setResidueProbs:
           Link residueProbs between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['possibility'] = self

    dataDict['residueProbs'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResidueProbs')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResonanceGroups(self, values):
    """
    Set for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResonanceGroups:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ResonanceGroup as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setResonanceGroups:
         value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('resonanceGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('residue')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setResonanceGroups:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResonanceGroups:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResonanceGroups:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResonanceGroups:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setResonanceGroups:
           Link resonanceGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (value is None or self.isActive)):
            raise ApiError("""%s.setResonanceGroups:
             residue constraint Only_active_ResonanceGroups_can_have_residue violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          cc = self.chemComp
          isValid = (cc is None or cc is value.molResidue.chemComp)
          if (not (isValid)):
            raise ApiError("""%s.setResonanceGroups:
             residue constraint residue_consistent_with_chemComp violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['residue'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('residue')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('resonanceGroups')
          vv.remove(cv)

      cv.__dict__['residue'] = self

    dataDict['resonanceGroups'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResonanceGroups')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqCode(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.seqCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSeqCode:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSeqCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['seqCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqId(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.seqId
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSeqId:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSeqId:
         cannot set seqId, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSeqId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['seqId'] = value

    # doNotifies
  
  def setSeqInsertCode(self, value):
    """
    Set for ccp.molecule.MolSystem.Residue.seqInsertCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSeqInsertCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setSeqInsertCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setSeqInsertCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setSeqInsertCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqInsertCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqInsertCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqInsertCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSeqInsertCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (len(value) == 1)):
            raise ApiError("""%s.setSeqInsertCode:
             seqInsertCode constraint length_is_one violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['seqInsertCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqInsertCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAtoms(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.atoms
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('atoms')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChainStateSets(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.chainStateSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('chainStateSets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedDangleResidues(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.dangleResidues
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('cambridge.Dangle')
    tobjList = root.__dict__.get('dangleStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('dangleResidues')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSysResidueValidations(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.molSysResidueValidations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Validation')
    tobjList = root.__dict__.get('validationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molSysResidueValidations')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSystemLinkEnds(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.molSystemLinkEnds
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('molSystemLinkEnds')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedResidueProbs(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.residueProbs
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('residueProbs')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedResonanceGroups(self):
    """
    Sorted for ccp.molecule.MolSystem.Residue.resonanceGroups
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('resonanceGroups')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  ccpCode = property(getCcpCode, None, None,
  r"""ccpCode of ChemComp corresponding to Residue
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  descriptor = property(getDescriptor, setDescriptor, None,
  r"""descriptor of ChemCompVar corresponding to Residue. Describes 
  topological variant, i.e. protonation state or (for Polymers) 
  non-polymer type substitution.
  
   linking and descriptor may be changed 
  for existing Residues, thus changing the identity of the corresponding 
  ChemCompVar. 
  The new chemCompVar must contain a ChemAtom to correspond 
  to every existing Atom, and a LinkEnd to correspond to every existing 
  MolSystemLinkEnd, as well as every existing MolResLinkEnd in the 
  MolResidue. Note that this may require that Atom and MolSsytemLinkEnd 
  objects be deleted before the linking and descriptor can be modified. 
  """)
  
  details = property(getDetails, setDetails, None,
  r"""free text for notes, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  linking = property(getLinking, setLinking, None,
  r"""linking (substitution pattern) of ChemCompVar corresponding to Residue. 
  linking and descriptor may be changed for existing Residues, thus 
  changing the identity of the corresponding ChemCompVar. 
  The new 
  chemCompVar must contain a ChemAtom to correspond to every existing 
  Atom, and a LinkEnd to correspond to every existing MolSystemLinkEnd, as 
  well as every existing MolResLinkEnd in the MolResidue. Note that this 
  may require that Atom and MolSystemLinkEnd objects be deleted before the 
  linking and descriptor can be modified. 
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, None, None,
  r"""molType of ChemComp corresponding to Residue
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  seqCode = property(getSeqCode, setSeqCode, None,
  r"""Author sequence identifier. Set to MolResidue.seqCode when the Residue 
  is
  created as part of the Chain constructor.
  """)
  
  seqId = property(getSeqId, setSeqId, None,
  r"""Identifier corresponding to the molResidue identifier 
  (self.molResidue.serial)
  """)
  
  seqInsertCode = property(getSeqInsertCode, setSeqInsertCode, None,
  r"""Author insertion code. Defaults to MolResidue.seqInsertCode (which again 
  defaults to a single white space ' ') when the Residue is
  created as 
  part of the Chain constructor..
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atoms = property(getAtoms,  None, None,
  r"""child link
  """)
  
  chain = property(getChain,  None, None,
  r"""parent link
  """)
  
  chainFragment = property(getChainFragment, setChainFragment, None,
  r"""ChainFragment to which Residue belongs. When Chains are created, each 
  Residue will automatically be linked to a ChainFragment, so that the 
  Chain is divided in Fragments of uniform molType.
  """)
  
  chainStateSets = property(getChainStateSets, setChainStateSets, None,
  r"""ChainStateSets relevant for Residue
  """)
  
  chemCompVar = property(getChemCompVar, None, None,
  r"""ChemCompVar (that is, specific protonation state etc.) of the chemComp 
  corresponding to this particular residue. 
  """)
  
  dangleResidues = property(getDangleResidues, setDangleResidues, None,
  r"""DangleResidue with predicted angles
  """)
  
  molResidue = property(getMolResidue, None, None,
  r"""MolResidue (Residue in Molecule Sequene) corresponding to Residue
  """)
  
  molSysResidueValidations = property(getMolSysResidueValidations, setMolSysResidueValidations, None,
  r"""Validation results for Residue
  """)
  
  molSystemLinkEnds = property(getMolSystemLinkEnds,  None, None,
  r"""child link to class MolSystemLinkEnd
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chain
  """)
  
  residueProbs = property(getResidueProbs, setResidueProbs, None,
  r"""ResidueProb describing ResonanceGroups with a probability of 
  corresponding to this residue.
  """)
  
  resonanceGroups = property(getResonanceGroups, setResonanceGroups, None,
  r"""ResonanceGroups that are definitely assigned to this residue
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class StructureGroup(memops.api.Implementation.DataObject):
  r"""Group of Structure models. General purpose grouping mechanism for 
structures. May be from same or different generation cycles.
  """
  #   from data model element ccp.molecule.MolSystem.StructureGroup revision ?
  _metaclass = metaPackage.getElement('StructureGroup')
  _packageName = 'ccp.molecule.MolSystem'
  _packageShortName = 'MOLS'
  _fieldNames = ('applicationData', 'className', 'detail', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'entries', 'models', 'molSystem', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    dataDict['molSystem'] = parent
    if (not isinstance(parent, MolSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['detail'] = None
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['entries'] = set()
      dataDict['models'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.MolSystem.StructureGroup.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.MolSystem.StructureGroup')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('structureGroups')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.MolSystem.StructureGroup:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    entries = dataDict.get('entries')
    pass
    for entry in entries:
      topObject = entry.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    xx1 = dataDict.get('topObject')
    for tobj in xx1.__dict__.get('structureEnsembles'):
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    models = dataDict.get('models')
    pass
    for model in models:
      topObject = model.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.MolSystem.StructureGroup:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for entry in dataDict.get('entries'):
      if (not (entry in objsToBeDeleted)):
        structureGroups = entry.__dict__.get('structureGroups')
        structureGroups.remove(self)

    for model in dataDict.get('models'):
      if (not (model in objsToBeDeleted)):
        structureGroups = model.__dict__.get('structureGroups')
        structureGroups.remove(self)

    molSystem = dataDict.get('molSystem')
    if (not (molSystem in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molSystem.__dict__.get('structureGroups')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addEntry(self, value):
    """
    Add for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addEntry:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('entries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addEntry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addEntry:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addEntry:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addEntry:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addEntry:
           Link entries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('structureGroups')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addEntry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addModel(self, value):
    """
    Add for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolStructure import Model as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addModel:
       value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    xx1 = dataDict.get('topObject')
    for tobj in xx1.__dict__.get('structureEnsembles'):
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('models')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addModel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addModel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addModel:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addModel:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        yy2 = yy1.__dict__.get('molSystem')
        if (not (xx1 is yy2)):
          raise ApiError("""%s.addModel:
           Link models between objects from separate partitions
           - ccp.molecule.MolStructure.StructureEnsemble.molSystem not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('structureGroups')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addModel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molSystem')
        dd = value.__dict__.get('structureGroups')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('detail')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: detail:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: detail:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: detail:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('entries')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: entries:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('structureGroups')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: entries:
           non-reciprocal link entries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: entries:
           Link entries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      xx1 = dataDict.get('topObject')
      for tobj in xx1.__dict__.get('structureEnsembles'):
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('models')
      for value in values:
        from ccp.api.molecule.MolStructure import Model as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: models:
           value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('structureGroups')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: models:
           non-reciprocal link models from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        yy2 = yy1.__dict__.get('molSystem')
        if (not (xx1 is yy2)):
          raise ApiError("""%s.checkValid: models:
           Link models between objects from separate partitions
           - ccp.molecule.MolStructure.StructureEnsemble.molSystem not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molSystem')
      if (not isinstance(value, MolSystem)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('detail')
    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('entries')
    values = dataDict.get('models')
    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllEntries(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllModels(self, **conditions):
    """
    FindAll for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      xx1 = dataDict.get('topObject')
      for tobj in xx1.__dict__.get('structureEnsembles'):
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('models')
      result = set(currentValues)

    else:
      xx1 = dataDict.get('topObject')
      for tobj in xx1.__dict__.get('structureEnsembles'):
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('models')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'index', 'name', 'serial', 'access', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstEntry(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entries')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstModel(self, **conditions):
    """
    FindFirst for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      xx1 = dataDict.get('topObject')
      for tobj in xx1.__dict__.get('structureEnsembles'):
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('models')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      xx1 = dataDict.get('topObject')
      for tobj in xx1.__dict__.get('structureEnsembles'):
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('models')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'index', 'name', 'serial', 'access', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.MolSystem.StructureGroup
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.StructureGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molSystems').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.MolSystem')
        obj1 = obj0.__dict__.get('molSystems').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.MolSystem.StructureGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('structureGroups').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetail(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.detail
    """
    dataDict = self.__dict__
    result = dataDict.get('detail')
    return result
  
  def getEntries(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('entries')
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molSystem')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('code'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getModels(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    xx1 = dataDict.get('topObject')
    for tobj in xx1.__dict__.get('structureEnsembles'):
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('models')
    result = frozenset(tempVar)
    return result
  
  def getMolSystem(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.MolSystem.StructureGroup.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeEntry(self, value):
    """
    Remove for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeEntry:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('entries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeEntry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeEntry:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeEntry:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeEntry:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('structureGroups')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeEntry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeModel(self, value):
    """
    Remove for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolStructure import Model as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeModel:
       value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    xx1 = dataDict.get('topObject')
    for tobj in xx1.__dict__.get('structureEnsembles'):
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('models')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeModel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeModel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeModel:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeModel:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('structureGroups')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeModel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.MolSystem.StructureGroup
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetail(self, value):
    """
    Set for ccp.molecule.MolSystem.StructureGroup.detail
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetail:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetail:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetail:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('detail')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetail:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetail:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['detail'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetail')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEntries(self, values):
    """
    Set for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setEntries:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrEntry import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setEntries:
         value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('entries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEntries:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEntries:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setEntries:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setEntries:
           Link entries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('structureGroups')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('structureGroups')
        oldSelves.add(self)

    dataDict['entries'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEntries')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setModels(self, values):
    """
    Set for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setModels:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolStructure import Model as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setModels:
         value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    xx1 = dataDict.get('topObject')
    for tobj in xx1.__dict__.get('structureEnsembles'):
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('models')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setModels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setModels:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setModels:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        yy2 = yy1.__dict__.get('molSystem')
        if (not (xx1 is yy2)):
          raise ApiError("""%s.setModels:
           Link models between objects from separate partitions
           - ccp.molecule.MolStructure.StructureEnsemble.molSystem not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('structureGroups')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('structureGroups')
        oldSelves.add(self)

    dataDict['models'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setModels')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.MolSystem.StructureGroup.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.molecule.MolSystem.StructureGroup.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('molSystem')
    oldSerial = parent.__dict__.get('_serialDict').get('structureGroups')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['structureGroups'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['structureGroups'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedEntries(self):
    """
    Sorted for ccp.molecule.MolSystem.StructureGroup.entries
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('entries')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedModels(self):
    """
    Sorted for ccp.molecule.MolSystem.StructureGroup.models
    """
    dataDict = self.__dict__
    xx1 = dataDict.get('topObject')
    for tobj in xx1.__dict__.get('structureEnsembles'):
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('models')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  detail = property(getDetail, setDetail, None,
  r"""Detailed description of StructureModelGroup
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of StructureModelGroup
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""The serial number is the key for class StructureModelGroup and together 
  with the parent object serves as a unique identifier for the 
  StructureModelGroup.
  Serial numbers are generated by the API. Serial 
  numbers of deleted objects are not reused.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  entries = property(getEntries, setEntries, None,
  r"""Bmrb Entries for StructureGroup
  """)
  
  models = property(getModels, setModels, None,
  r"""Models belonging to StructureGroup
  """)
  
  molSystem = property(getMolSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
