"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Thu Oct  2 16:11:30 2014
  from data model element ccpnmr.Analysis revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Analysis.py: python API for CCPN data model, MetaPackage ccpnmr.Analysis

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.DataLocation
import ccp.api.general.Template
import ccp.api.molecule.ChemComp
import ccp.api.molecule.ChemElement
import ccp.api.molecule.MolSystem
import ccp.api.molecule.Molecule
import ccp.api.nmr.Nmr
import ccp.api.nmr.NmrExpPrototype
import ccpnmr.api.AnalysisProfile
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccpnmr.Analysis')

###############################################################################
class AbstractMark(memops.api.Implementation.DataObject):
  r"""Graphical mark comprised of lines, either Ruler or Mark
  """
  #   from data model element ccpnmr.Analysis.AbstractMark revision ?
  _metaclass = metaPackage.getElement('AbstractMark')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'dashLength', 'fieldNames', 'gapLength', 'inConstructor', 'isDeleted', 'lineWidth', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'root', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDashLength(self):
    """
    Get for ccpnmr.Analysis.AbstractMark.dashLength
    """
    dataDict = self.__dict__
    result = dataDict.get('dashLength')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getGapLength(self):
    """
    Get for ccpnmr.Analysis.AbstractMark.gapLength
    """
    dataDict = self.__dict__
    result = dataDict.get('gapLength')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLineWidth(self):
    """
    Get for ccpnmr.Analysis.AbstractMark.lineWidth
    """
    dataDict = self.__dict__
    result = dataDict.get('lineWidth')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDashLength(self, value):
    """
    Set for ccpnmr.Analysis.AbstractMark.dashLength
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setDashLength:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dashLength')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDashLength:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDashLength:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDashLength:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['dashLength'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDashLength')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setGapLength(self, value):
    """
    Set for ccpnmr.Analysis.AbstractMark.gapLength
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setGapLength:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('gapLength')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setGapLength:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGapLength:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setGapLength:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['gapLength'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setGapLength')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLineWidth(self, value):
    """
    Set for ccpnmr.Analysis.AbstractMark.lineWidth
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setLineWidth:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setLineWidth:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('lineWidth')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLineWidth:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLineWidth:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setLineWidth:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['lineWidth'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLineWidth')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  dashLength = property(getDashLength, setDashLength, None,
  r"""For dashed line - length of dash part in arbitrary units (scale handled 
  by program).
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  gapLength = property(getGapLength, setGapLength, None,
  r"""Length of gap in dashed line - handled as for dashLength
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  lineWidth = property(getLineWidth, setLineWidth, None,
  r"""Width of line in arbitrary units, handled as for dashLength.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AnalysisDataDim(memops.api.Implementation.DataObject):
  r"""Analysis information for DataDim
  """
  #   from data model element ccpnmr.Analysis.AnalysisDataDim revision ?
  _metaclass = metaPackage.getElement('AnalysisDataDim')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'assignTolerance', 'chemShiftWeight', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'noeTolerance', 'packageName', 'packageShortName', 'peakFindBoxWidth', 'peakFindMinLineWidth', 'qualifiedName', 'refSamplePlane', 'access', 'activeAccess', 'analysisSpectrum', 'axisMappings', 'dataDim', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    dataDict['analysisSpectrum'] = parent
    if (not isinstance(parent, AnalysisSpectrum)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisSpectrum""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['assignTolerance'] = 0.1
      dataDict['chemShiftWeight'] = 1.0
      dataDict['noeTolerance'] = 0.1
      dataDict['peakFindBoxWidth'] = 1.0
      dataDict['peakFindMinLineWidth'] = 0.0
      dataDict['refSamplePlane'] = None
      dataDict['access'] = None
      dataDict['axisMappings'] = set()
      dataDict['dataDim'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AnalysisDataDim.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('analysisDataDims')
        objKey = dataDict.get('dataDim')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['dataDim'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AnalysisDataDim:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    axisMappings = dataDict.get('axisMappings')
    for axisMapping in axisMappings:
      if (not (axisMapping in objsToBeDeleted)):
        objsToBeDeleted.add(axisMapping)
        objsToBeChecked.append(axisMapping)

    dataDim = dataDict.get('dataDim')
    if (dataDim is not None):
      topObject = dataDim.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AnalysisDataDim:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    dataDim = dataDict.get('dataDim')
    if ((dataDim is not None and not (dataDim in objsToBeDeleted))):
      dataDim.__dict__['analysisDataDim'] = None

    analysisSpectrum = dataDict.get('analysisSpectrum')
    if (not (analysisSpectrum in objsToBeDeleted)):
      objKey = dataDict.get('dataDim')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisSpectrum.__dict__.get('analysisDataDims')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('dataDim')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisSpectrum')
        dd = value.__dict__.get('analysisDataDims')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisSpectrum' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('assignTolerance')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: assignTolerance:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: assignTolerance:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: assignTolerance:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('chemShiftWeight')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: chemShiftWeight:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: chemShiftWeight:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: chemShiftWeight:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('noeTolerance')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: noeTolerance:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: noeTolerance:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: noeTolerance:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindBoxWidth')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakFindBoxWidth:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: peakFindBoxWidth:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakFindBoxWidth:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindMinLineWidth')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakFindMinLineWidth:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: peakFindMinLineWidth:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakFindMinLineWidth:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('refSamplePlane')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: refSamplePlane:
           memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (0.0 <= value)):
          raise ApiError("""%s.checkValid: refSamplePlane:
           NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: refSamplePlane:
           NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisSpectrum')
      if (not isinstance(value, AnalysisSpectrum)):
        raise ApiError("""%s.checkValid: analysisSpectrum:
         value is not of class ccpnmr.Analysis.AnalysisSpectrum""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('axisMappings')
      for value in values:
        if (not isinstance(value, AxisMapping)):
          raise ApiError("""%s.checkValid: axisMappings:
           value is not of class ccpnmr.Analysis.AxisMapping""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisDataDim')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: axisMappings:
           non-reciprocal link axisMappings from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: axisMappings:
           Link axisMappings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('dataDim')
      from ccp.api.nmr.Nmr import AbstractDataDim as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: dataDim:
         value is not of class ccp.nmr.Nmr.AbstractDataDim""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelf = value.__dict__.get('analysisDataDim')
      if (not (oldSelf is self)):
        raise ApiError("""%s.checkValid: dataDim:
         non-reciprocal link dataDim from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('assignTolerance')
    if (value is None):
      raise ApiError("""%s.checkValid: assignTolerance:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('chemShiftWeight')
    if (value is None):
      raise ApiError("""%s.checkValid: chemShiftWeight:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('noeTolerance')
    if (value is None):
      raise ApiError("""%s.checkValid: noeTolerance:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('peakFindBoxWidth')
    if (value is None):
      raise ApiError("""%s.checkValid: peakFindBoxWidth:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('peakFindMinLineWidth')
    if (value is None):
      raise ApiError("""%s.checkValid: peakFindMinLineWidth:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('refSamplePlane')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisSpectrum')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisSpectrum:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('axisMappings')
    value = dataDict.get('dataDim')
    if (value is None):
      raise ApiError("""%s.checkValid: dataDim:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAxisMappings(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisDataDim.axisMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('axisMappings')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('axisMappings')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('label', 'access', 'analysisDataDim', 'spectrumWindowView',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAxisMapping(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisDataDim.axisMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('axisMappings')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('axisMappings')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('label', 'access', 'analysisDataDim', 'spectrumWindowView',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisSpectrum(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.analysisSpectrum
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisSpectrum')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAssignTolerance(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.assignTolerance
    """
    dataDict = self.__dict__
    result = dataDict.get('assignTolerance')
    return result
  
  def getAxisMappings(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.axisMappings
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('axisMappings')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AnalysisDataDim
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisDataDim'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisDataDim'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('analysisSpectra').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('analysisDataDims').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemShiftWeight(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.chemShiftWeight
    """
    dataDict = self.__dict__
    result = dataDict.get('chemShiftWeight')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDataDim(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.dataDim
    """
    dataDict = self.__dict__
    result = dataDict.get('dataDim')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('analysisSpectrum')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('dataSource'))
    result.append(dataDict.get('dataDim'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    result = dataDict.get('dataDim')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNoeTolerance(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.noeTolerance
    """
    dataDict = self.__dict__
    result = dataDict.get('noeTolerance')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisSpectrum')
    return result
  
  def getPeakFindBoxWidth(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.peakFindBoxWidth
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindBoxWidth')
    return result
  
  def getPeakFindMinLineWidth(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.peakFindMinLineWidth
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindMinLineWidth')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefSamplePlane(self):
    """
    Get for ccpnmr.Analysis.AnalysisDataDim.refSamplePlane
    """
    dataDict = self.__dict__
    result = dataDict.get('refSamplePlane')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AnalysisDataDim
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAssignTolerance(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.assignTolerance
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAssignTolerance:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setAssignTolerance:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAssignTolerance:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('assignTolerance')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAssignTolerance:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAssignTolerance:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAssignTolerance:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['assignTolerance'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAssignTolerance')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAxisMappings(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.axisMappings
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAxisMappings:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AxisMapping)):
        raise ApiError("""%s.setAxisMappings:
         value is not of class ccpnmr.Analysis.AxisMapping""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisMappings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAxisMappings:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAxisMappings:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAxisMappings:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setAxisMappings:
           locard analysisDataDim: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAxisMappings:
           Link axisMappings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['analysisDataDim'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('analysisDataDim')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('axisMappings')
          vv.remove(cv)

      cv.__dict__['analysisDataDim'] = self

    dataDict['axisMappings'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAxisMappings')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemShiftWeight(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.chemShiftWeight
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setChemShiftWeight:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setChemShiftWeight:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setChemShiftWeight:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemShiftWeight')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemShiftWeight:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemShiftWeight:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setChemShiftWeight:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['chemShiftWeight'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemShiftWeight')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDataDim(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.dataDim
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import AbstractDataDim as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setDataDim:
       value is not of class ccp.nmr.Nmr.AbstractDataDim""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataDim')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.Analysis')
      tobjList = set(root.__dict__.get('analysisProjects').values())
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataDim:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDataDim:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDataDim:
         cannot set dataDim, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDataDim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value.__dict__.get('analysisDataDim') is None):
        xx1 = value.__dict__.get('topObject')
        if (xx1.__dict__.get('analysisProject') is None):
          root = dataDict.get('topObject').__dict__.get('memopsRoot')
          root.refreshTopObjects('ccpnmr.Analysis')

        tobj = xx1.__dict__.get('analysisProject')
        if (tobj is not None):
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      oldSelf = value.__dict__.get('analysisDataDim')
      if (oldSelf is not None):
        raise ApiError("""%s.setDataDim:
         oldSelf must be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      xx2 = xx1.__dict__.get('nmrProject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx2 is yy1)):
        raise ApiError("""%s.setDataDim:
         Link dataDim between objects from separate partitions
         - ccpnmr.Analysis.AnalysisProject.nmrProject not set correctly""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      currentValue.__dict__['analysisDataDim'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('analysisDataDim')
      if (oldSelf is not None):
        oldSelf.__dict__['dataDim'] = None

      value.__dict__['analysisDataDim'] = self

    dataDict['dataDim'] = value

    # doNotifies
  
  def setNoeTolerance(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.noeTolerance
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setNoeTolerance:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setNoeTolerance:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setNoeTolerance:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('noeTolerance')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNoeTolerance:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNoeTolerance:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNoeTolerance:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['noeTolerance'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNoeTolerance')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindBoxWidth(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.peakFindBoxWidth
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakFindBoxWidth:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setPeakFindBoxWidth:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakFindBoxWidth:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('peakFindBoxWidth')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindBoxWidth:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindBoxWidth:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindBoxWidth:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindBoxWidth'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindBoxWidth')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindMinLineWidth(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.peakFindMinLineWidth
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakFindMinLineWidth:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setPeakFindMinLineWidth:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakFindMinLineWidth:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('peakFindMinLineWidth')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindMinLineWidth:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindMinLineWidth:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindMinLineWidth:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindMinLineWidth'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindMinLineWidth')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefSamplePlane(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisDataDim.refSamplePlane
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setRefSamplePlane:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.setRefSamplePlane:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setRefSamplePlane:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('refSamplePlane')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefSamplePlane:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefSamplePlane:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['refSamplePlane'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefSamplePlane')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAxisMappings(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisDataDim.axisMappings
    """
    dataDict = self.__dict__
    ll = dataDict.get('axisMappings')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  assignTolerance = property(getAssignTolerance, setAssignTolerance, None,
  r"""Chemical shift tolerance (ppm) for assignment
  """)
  
  chemShiftWeight = property(getChemShiftWeight, setChemShiftWeight, None,
  r"""Weight for dimension in chemical shift averaging.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  noeTolerance = property(getNoeTolerance, setNoeTolerance, None,
  r"""NBNB TBD ???
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  peakFindBoxWidth = property(getPeakFindBoxWidth, setPeakFindBoxWidth, None,
  r"""Minimum line width for a found peak to be accepted (NBNB TBD unit?).
  """)
  
  peakFindMinLineWidth = property(getPeakFindMinLineWidth, setPeakFindMinLineWidth, None,
  r"""Minimum line width for a found peak to be accepted (NBNB TBD unit?).
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  refSamplePlane = property(getRefSamplePlane, setRefSamplePlane, None,
  r"""Index in this dimension that indicates plane used as reference plane. 
  Intended for use with sampled dimensions in e.g. pseudo-3D experiments, 
  where one plane is the reference plane. 
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisSpectrum = property(getAnalysisSpectrum,  None, None,
  r"""parent link
  """)
  
  axisMappings = property(getAxisMappings, setAxisMappings, None,
  r"""Axis mappings currently pointing to AnalysisDataDim
  """)
  
  dataDim = property(getDataDim, setDataDim, None,
  r"""DAtDim that AnalysisDataDim points to
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisSpectrum
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AnalysisPeakList(memops.api.Implementation.DataObject):
  r"""
  """
  #   from data model element ccpnmr.Analysis.AnalysisPeakList revision ?
  _metaclass = metaPackage.getElement('AnalysisPeakList')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'noeIntensityType', 'noeRefDistance', 'noeRefIntensity', 'packageName', 'packageShortName', 'qualifiedName', 'symbolColor', 'symbolStyle', 'textColor', 'access', 'activeAccess', 'analysisSpectrum', 'parent', 'peakList', 'root', 'topObject', 'windowPeakLists',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    dataDict['analysisSpectrum'] = parent
    if (not isinstance(parent, AnalysisSpectrum)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisSpectrum""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['noeIntensityType'] = 'height'
      dataDict['noeRefDistance'] = 3.2
      dataDict['noeRefIntensity'] = None
      dataDict['symbolColor'] = '#000000'
      dataDict['symbolStyle'] = 'x'
      dataDict['textColor'] = '#000000'
      dataDict['access'] = None
      dataDict['peakList'] = None
      dataDict['windowPeakLists'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AnalysisPeakList.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('analysisPeakLists')
        objKey = dataDict.get('peakList')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['peakList'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AnalysisPeakList:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    peakList = dataDict.get('peakList')
    if (peakList is not None):
      topObject = peakList.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    windowPeakLists = dataDict.get('windowPeakLists')
    for windowPeakList in windowPeakLists:
      if (not (windowPeakList in objsToBeDeleted)):
        objsToBeDeleted.add(windowPeakList)
        objsToBeChecked.append(windowPeakList)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AnalysisPeakList:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    peakList = dataDict.get('peakList')
    if ((peakList is not None and not (peakList in objsToBeDeleted))):
      peakList.__dict__['analysisPeakList'] = None

    analysisSpectrum = dataDict.get('analysisSpectrum')
    if (not (analysisSpectrum in objsToBeDeleted)):
      objKey = dataDict.get('peakList')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisSpectrum.__dict__.get('analysisPeakLists')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('peakList')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisSpectrum')
        dd = value.__dict__.get('analysisPeakLists')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisSpectrum' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('noeIntensityType')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: noeIntensityType:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: noeIntensityType:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: noeIntensityType:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: noeIntensityType:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('noeRefDistance')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: noeRefDistance:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: noeRefDistance:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: noeRefDistance:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('noeRefIntensity')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: noeRefIntensity:
           memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: noeRefIntensity:
           PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: noeRefIntensity:
           PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('symbolColor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: symbolColor:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.checkValid: symbolColor:
         RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.checkValid: symbolColor:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('symbolStyle')
      if (not (value in ['+', 'x', 'o', '*'])):
        raise ApiError("""%s.checkValid: symbolStyle:
         ccpnmr.Analysis.SymbolStyle input is not in enumeration ['+', 'x', 'o', '*']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: symbolStyle:
         SymbolStyle constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('textColor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: textColor:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.checkValid: textColor:
         RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.checkValid: textColor:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisSpectrum')
      if (not isinstance(value, AnalysisSpectrum)):
        raise ApiError("""%s.checkValid: analysisSpectrum:
         value is not of class ccpnmr.Analysis.AnalysisSpectrum""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakList')
      from ccp.api.nmr.Nmr import PeakList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: peakList:
         value is not of class ccp.nmr.Nmr.PeakList""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelf = value.__dict__.get('analysisPeakList')
      if (not (oldSelf is self)):
        raise ApiError("""%s.checkValid: peakList:
         non-reciprocal link peakList from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('windowPeakLists')
      for value in values:
        if (not isinstance(value, WindowPeakList)):
          raise ApiError("""%s.checkValid: windowPeakLists:
           value is not of class ccpnmr.Analysis.WindowPeakList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisPeakList')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: windowPeakLists:
           non-reciprocal link windowPeakLists from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: windowPeakLists:
           Link windowPeakLists between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('noeIntensityType')
    value = dataDict.get('noeRefDistance')
    if (value is None):
      raise ApiError("""%s.checkValid: noeRefDistance:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('noeRefIntensity')
    value = dataDict.get('symbolColor')
    if (value is None):
      raise ApiError("""%s.checkValid: symbolColor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('symbolStyle')
    if (value is None):
      raise ApiError("""%s.checkValid: symbolStyle:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('textColor')
    if (value is None):
      raise ApiError("""%s.checkValid: textColor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisSpectrum')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisSpectrum:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('peakList')
    if (value is None):
      raise ApiError("""%s.checkValid: peakList:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('windowPeakLists')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllWindowPeakLists(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisPeakList.windowPeakLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('windowPeakLists')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('windowPeakLists')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isAnnotationDrawn', 'isSymbolDrawn', 'access', 'analysisPeakList', 'spectrumWindowView',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstWindowPeakList(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisPeakList.windowPeakLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('windowPeakLists')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('windowPeakLists')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isAnnotationDrawn', 'isSymbolDrawn', 'access', 'analysisPeakList', 'spectrumWindowView',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisSpectrum(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.analysisSpectrum
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisSpectrum')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AnalysisPeakList
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisPeakList'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisPeakList'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('analysisSpectra').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('analysisPeakLists').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('analysisSpectrum')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('dataSource'))
    result.append(dataDict.get('peakList'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    result = dataDict.get('peakList')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNoeIntensityType(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.noeIntensityType
    """
    dataDict = self.__dict__
    result = dataDict.get('noeIntensityType')
    return result
  
  def getNoeRefDistance(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.noeRefDistance
    """
    dataDict = self.__dict__
    result = dataDict.get('noeRefDistance')
    return result
  
  def getNoeRefIntensity(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.noeRefIntensity
    """
    dataDict = self.__dict__
    result = dataDict.get('noeRefIntensity')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisSpectrum')
    return result
  
  def getPeakList(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.peakList
    """
    dataDict = self.__dict__
    result = dataDict.get('peakList')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSymbolColor(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.symbolColor
    """
    dataDict = self.__dict__
    result = dataDict.get('symbolColor')
    return result
  
  def getSymbolStyle(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.symbolStyle
    """
    dataDict = self.__dict__
    result = dataDict.get('symbolStyle')
    return result
  
  def getTextColor(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.textColor
    """
    dataDict = self.__dict__
    result = dataDict.get('textColor')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWindowPeakLists(self):
    """
    Get for ccpnmr.Analysis.AnalysisPeakList.windowPeakLists
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('windowPeakLists')
    result = frozenset(tempVar)
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AnalysisPeakList
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setNoeIntensityType(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.noeIntensityType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setNoeIntensityType:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setNoeIntensityType:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setNoeIntensityType:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setNoeIntensityType:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('noeIntensityType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNoeIntensityType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNoeIntensityType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['noeIntensityType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNoeIntensityType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNoeRefDistance(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.noeRefDistance
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setNoeRefDistance:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setNoeRefDistance:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setNoeRefDistance:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('noeRefDistance')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNoeRefDistance:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNoeRefDistance:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNoeRefDistance:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['noeRefDistance'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNoeRefDistance')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNoeRefIntensity(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.noeRefIntensity
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setNoeRefIntensity:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setNoeRefIntensity:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setNoeRefIntensity:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('noeRefIntensity')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNoeRefIntensity:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNoeRefIntensity:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['noeRefIntensity'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNoeRefIntensity')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakList(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.peakList
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import PeakList as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setPeakList:
       value is not of class ccp.nmr.Nmr.PeakList""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('peakList')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.Analysis')
      tobjList = set(root.__dict__.get('analysisProjects').values())
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakList:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setPeakList:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setPeakList:
         cannot set peakList, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setPeakList:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value.__dict__.get('analysisPeakList') is None):
        xx1 = value.__dict__.get('topObject')
        if (xx1.__dict__.get('analysisProject') is None):
          root = dataDict.get('topObject').__dict__.get('memopsRoot')
          root.refreshTopObjects('ccpnmr.Analysis')

        tobj = xx1.__dict__.get('analysisProject')
        if (tobj is not None):
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      oldSelf = value.__dict__.get('analysisPeakList')
      if (oldSelf is not None):
        raise ApiError("""%s.setPeakList:
         oldSelf must be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      xx2 = xx1.__dict__.get('nmrProject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx2 is yy1)):
        raise ApiError("""%s.setPeakList:
         Link peakList between objects from separate partitions
         - ccpnmr.Analysis.AnalysisProject.nmrProject not set correctly""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      currentValue.__dict__['analysisPeakList'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('analysisPeakList')
      if (oldSelf is not None):
        oldSelf.__dict__['peakList'] = None

      value.__dict__['analysisPeakList'] = self

    dataDict['peakList'] = value

    # doNotifies
  
  def setSymbolColor(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.symbolColor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSymbolColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.setSymbolColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.setSymbolColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('symbolColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSymbolColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSymbolColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSymbolColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['symbolColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSymbolColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSymbolStyle(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.symbolStyle
    """
    dataDict = self.__dict__
    if (not (value in ['+', 'x', 'o', '*'])):
      raise ApiError("""%s.setSymbolStyle:
       ccpnmr.Analysis.SymbolStyle input is not in enumeration ['+', 'x', 'o', '*']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setSymbolStyle:
       SymbolStyle constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('symbolStyle')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSymbolStyle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSymbolStyle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSymbolStyle:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['symbolStyle'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSymbolStyle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTextColor(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.textColor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setTextColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.setTextColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.setTextColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('textColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTextColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTextColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setTextColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['textColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTextColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWindowPeakLists(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisPeakList.windowPeakLists
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setWindowPeakLists:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, WindowPeakList)):
        raise ApiError("""%s.setWindowPeakLists:
         value is not of class ccpnmr.Analysis.WindowPeakList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('windowPeakLists')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWindowPeakLists:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWindowPeakLists:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setWindowPeakLists:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setWindowPeakLists:
           locard analysisPeakList: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setWindowPeakLists:
           Link windowPeakLists between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['analysisPeakList'] = self

    dataDict['windowPeakLists'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWindowPeakLists')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedWindowPeakLists(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisPeakList.windowPeakLists
    """
    dataDict = self.__dict__
    ll = dataDict.get('windowPeakLists')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  noeIntensityType = property(getNoeIntensityType, setNoeIntensityType, None,
  r"""NOE intensity type
  """)
  
  noeRefDistance = property(getNoeRefDistance, setNoeRefDistance, None,
  r"""NOE calibration reference distance
  """)
  
  noeRefIntensity = property(getNoeRefIntensity, setNoeRefIntensity, None,
  r"""NOE calibration reference intensity
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  symbolColor = property(getSymbolColor, setSymbolColor, None,
  r"""Color for displayed symbols
  """)
  
  symbolStyle = property(getSymbolStyle, setSymbolStyle, None,
  r"""Peak symbol style
  """)
  
  textColor = property(getTextColor, setTextColor, None,
  r"""Color for displayed text
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisSpectrum = property(getAnalysisSpectrum,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisSpectrum
  """)
  
  peakList = property(getPeakList, setPeakList, None,
  r"""PeakList that AnalysisPeakList refers to. Key for class
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
  
  windowPeakLists = property(getWindowPeakLists, setWindowPeakLists, None,
  r"""WindowPeakLists referring to AnalysisPeakList
  """)

###############################################################################
class AnalysisPopup(memops.api.Implementation.DataObject):
  r"""Analysis popup information
  """
  #   from data model element ccpnmr.Analysis.AnalysisPopup revision ?
  _metaclass = metaPackage.getElement('AnalysisPopup')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'height', 'inConstructor', 'isDeleted', 'isOpen', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'screenX', 'screenY', 'title', 'width', 'access', 'activeAccess', 'analysisProject', 'parent', 'popupOptions', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['height'] = 500
      dataDict['isOpen'] = False
      dataDict['name'] = None
      dataDict['screenX'] = 0
      dataDict['screenY'] = 0
      dataDict['title'] = None
      dataDict['width'] = 500
      dataDict['access'] = None
      dataDict['popupOptions'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AnalysisPopup.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('analysisPopups')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AnalysisPopup:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    popupOptions = dataDict.get('popupOptions').values()
    for popupOption in popupOptions:
      if (not (popupOption in objsToBeDeleted)):
        objsToBeDeleted.add(popupOption)
        objsToBeChecked.append(popupOption)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AnalysisPopup:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('analysisPopups')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('popupOptions').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('analysisPopups')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('height')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: height:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: height:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isOpen')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isOpen:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('screenX')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: screenX:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('screenY')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: screenY:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('title')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: title:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('width')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: width:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: width:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('popupOptions').values()
      for value in values:
        if (not isinstance(value, PopupOption)):
          raise ApiError("""%s.checkValid: popupOptions:
           value is not of class ccpnmr.Analysis.PopupOption""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisPopup')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: popupOptions:
           non-reciprocal link popupOptions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('height')
    if (value is None):
      raise ApiError("""%s.checkValid: height:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isOpen')
    if (value is None):
      raise ApiError("""%s.checkValid: isOpen:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('screenX')
    value = dataDict.get('screenY')
    if (value is None):
      raise ApiError("""%s.checkValid: screenY:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('title')
    value = dataDict.get('width')
    if (value is None):
      raise ApiError("""%s.checkValid: width:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('popupOptions').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllPopupOptions(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisPopup.popupOptions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('popupOptions').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('popupOptions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'keyword', 'access', 'analysisPopup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstPopupOption(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisPopup.popupOptions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('popupOptions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('keyword')
      if (objKey is not None):
        result = dataDict.get('popupOptions').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('popupOptions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'keyword', 'access', 'analysisPopup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AnalysisPopup
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisPopup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisPopup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('analysisPopups').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result
  
  def getHeight(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.height
    """
    dataDict = self.__dict__
    result = dataDict.get('height')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsOpen(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.isOpen
    """
    dataDict = self.__dict__
    result = dataDict.get('isOpen')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result
  
  def getPopupOptions(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.popupOptions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('popupOptions').values()
    result = frozenset(tempVar)
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getScreenX(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.screenX
    """
    dataDict = self.__dict__
    result = dataDict.get('screenX')
    return result
  
  def getScreenY(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.screenY
    """
    dataDict = self.__dict__
    result = dataDict.get('screenY')
    return result
  
  def getTitle(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.title
    """
    dataDict = self.__dict__
    result = dataDict.get('title')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWidth(self):
    """
    Get for ccpnmr.Analysis.AnalysisPopup.width
    """
    dataDict = self.__dict__
    result = dataDict.get('width')
    return result
  
  def newPopupOption(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.PopupOption
    """
    return PopupOption(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AnalysisPopup
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setHeight(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.height
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setHeight:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setHeight:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('height')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHeight:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHeight:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setHeight:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['height'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHeight')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsOpen(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.isOpen
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsOpen:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isOpen')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsOpen:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsOpen:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsOpen:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isOpen'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsOpen')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setScreenX(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.screenX
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setScreenX:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('screenX')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setScreenX:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setScreenX:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['screenX'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setScreenX')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setScreenY(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.screenY
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setScreenY:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('screenY')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setScreenY:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setScreenY:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setScreenY:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['screenY'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setScreenY')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTitle(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.title
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setTitle:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setTitle:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setTitle:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setTitle:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('title')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTitle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTitle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['title'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTitle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWidth(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisPopup.width
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setWidth:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setWidth:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('width')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWidth:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWidth:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWidth:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['width'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWidth')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedPopupOptions(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisPopup.popupOptions
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('popupOptions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  height = property(getHeight, setHeight, None,
  r"""Popup Height
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isOpen = property(getIsOpen, setIsOpen, None,
  r"""Is popup open
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of AnalysisPopup
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  screenX = property(getScreenX, setScreenX, None,
  r"""Screen X position
  """)
  
  screenY = property(getScreenY, setScreenY, None,
  r"""Screen Y position
  """)
  
  title = property(getTitle, setTitle, None,
  r"""Popup title
  """)
  
  width = property(getWidth, setWidth, None,
  r"""Popup width
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)
  
  popupOptions = property(getPopupOptions,  None, None,
  r"""child link to class PopupOption
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AnalysisProject(memops.api.Implementation.TopObject):
  r"""grouping for related Analysis data
  """
  #   from data model element ccpnmr.Analysis.AnalysisProject revision ?
  _metaclass = metaPackage.getElement('AnalysisProject')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'autoBackupFreq', 'className', 'contourToUnaliased', 'createdBy', 'defaultSpectrumFileType', 'doAssignmentAnnotations', 'doAutoBackup', 'doChainAnnotations', 'doDetailAnnotations', 'doMeritAnnotations', 'doMinimalAnnotations', 'doMolSysAnnotations', 'doSpinSystemAnnotations', 'fieldNames', 'globalContourScale', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'isThreadingAllowed', 'lastUnlockedBy', 'linkPeakListsData', 'linkSeqSpinSystemsData', 'maxMarks', 'maxRulers', 'meritAnnotationBad', 'meritAnnotationGood', 'meritAnnotationMediocre', 'metaclass', 'name', 'packageName', 'packageShortName', 'peakDrawMethod', 'peakFindBuffer', 'peakFindDrop', 'peakFindHaveHigh', 'peakFindHaveLow', 'peakFindNonadjacent', 'peakFindScale', 'peakFindThickness', 'peakFindVolumeMethod', 'peakIntensityScale', 'peakPixelSize', 'peakVolumeScale', 'printWinFileName', 'printWinInColor', 'printWinOrientation', 'printWinOtherHeight', 'printWinOtherUnit', 'printWinOtherWidth', 'printWinOutputFormat', 'printWinPaperSize', 'printWinScaling', 'printWinShowsDateTime', 'printWinShowsFileName', 'printWinTickOutside', 'printWinTickPlacement', 'printWinTitle', 'qualifiedName', 'spectrumFont', 'useBootstrap', 'access', 'activeAccess', 'activeRepositories', 'activeWindowGroup', 'analysisPopups', 'analysisSpectra', 'axisRegionGroups', 'axisTypes', 'axisUnits', 'chainMappings', 'marks', 'memopsRoot', 'nmrProject', 'packageLocator', 'panelTypes', 'parent', 'root', 'rulers', 'spectrumWindowGroups', 'spectrumWindows', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccpnmr.Analysis')

      dataDict['applicationData'] = list()
      dataDict['autoBackupFreq'] = 30
      dataDict['contourToUnaliased'] = True
      dataDict['createdBy'] = None
      dataDict['defaultSpectrumFileType'] = 'Azara'
      dataDict['doAssignmentAnnotations'] = True
      dataDict['doAutoBackup'] = False
      dataDict['doChainAnnotations'] = False
      dataDict['doDetailAnnotations'] = False
      dataDict['doMeritAnnotations'] = True
      dataDict['doMinimalAnnotations'] = False
      dataDict['doMolSysAnnotations'] = False
      dataDict['doSpinSystemAnnotations'] = True
      dataDict['globalContourScale'] = 10000.0
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['isThreadingAllowed'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['linkPeakListsData'] = None
      dataDict['linkSeqSpinSystemsData'] = None
      dataDict['maxMarks'] = 1
      dataDict['maxRulers'] = 1
      dataDict['meritAnnotationBad'] = None
      dataDict['meritAnnotationGood'] = None
      dataDict['meritAnnotationMediocre'] = None
      dataDict['name'] = None
      dataDict['peakDrawMethod'] = 'uniform in pixels'
      dataDict['peakFindBuffer'] = 1
      dataDict['peakFindDrop'] = 0.0
      dataDict['peakFindHaveHigh'] = True
      dataDict['peakFindHaveLow'] = False
      dataDict['peakFindNonadjacent'] = False
      dataDict['peakFindScale'] = 1.0
      dataDict['peakFindThickness'] = 0
      dataDict['peakFindVolumeMethod'] = 'box sum'
      dataDict['peakIntensityScale'] = 1000000.0
      dataDict['peakPixelSize'] = 10
      dataDict['peakVolumeScale'] = 1000000.0
      dataDict['printWinFileName'] = None
      dataDict['printWinInColor'] = True
      dataDict['printWinOrientation'] = 'Portrait'
      dataDict['printWinOtherHeight'] = None
      dataDict['printWinOtherUnit'] = 'cm'
      dataDict['printWinOtherWidth'] = None
      dataDict['printWinOutputFormat'] = 'PS'
      dataDict['printWinPaperSize'] = 'A4'
      dataDict['printWinScaling'] = 0.7
      dataDict['printWinShowsDateTime'] = True
      dataDict['printWinShowsFileName'] = True
      dataDict['printWinTickOutside'] = True
      dataDict['printWinTickPlacement'] = 'nsew'
      dataDict['printWinTitle'] = None
      dataDict['spectrumFont'] = None
      dataDict['useBootstrap'] = True
      dataDict['access'] = None
      dataDict['activeWindowGroup'] = None
      dataDict['analysisPopups'] = {}
      dataDict['analysisSpectra'] = {}
      dataDict['axisRegionGroups'] = {}
      dataDict['axisTypes'] = {}
      dataDict['axisUnits'] = {}
      dataDict['chainMappings'] = {}
      dataDict['marks'] = {}
      dataDict['nmrProject'] = None
      dataDict['panelTypes'] = {}
      dataDict['rulers'] = {}
      dataDict['spectrumWindowGroups'] = {}
      dataDict['spectrumWindows'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AnalysisProject.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['axisRegionGroups'] = 0
      serialDict['marks'] = 0
      serialDict['rulers'] = 0
      serialDict['spectrumWindowGroups'] = 0
      serialDict['spectrumWindows'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('analysisProjects')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentAnalysisProject') is None)):
        root.__dict__['currentAnalysisProject'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AnalysisProject:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    analysisPopups = dataDict.get('analysisPopups').values()
    for analysisPopup in analysisPopups:
      if (not (analysisPopup in objsToBeDeleted)):
        objsToBeDeleted.add(analysisPopup)
        objsToBeChecked.append(analysisPopup)

    analysisSpectra = dataDict.get('analysisSpectra').values()
    for analysisSpectrum in analysisSpectra:
      if (not (analysisSpectrum in objsToBeDeleted)):
        objsToBeDeleted.add(analysisSpectrum)
        objsToBeChecked.append(analysisSpectrum)

    axisRegionGroups = dataDict.get('axisRegionGroups').values()
    for axisRegionGroup in axisRegionGroups:
      if (not (axisRegionGroup in objsToBeDeleted)):
        objsToBeDeleted.add(axisRegionGroup)
        objsToBeChecked.append(axisRegionGroup)

    axisTypes = dataDict.get('axisTypes').values()
    for axisType in axisTypes:
      if (not (axisType in objsToBeDeleted)):
        objsToBeDeleted.add(axisType)
        objsToBeChecked.append(axisType)

    axisUnits = dataDict.get('axisUnits').values()
    for axisUnit in axisUnits:
      if (not (axisUnit in objsToBeDeleted)):
        objsToBeDeleted.add(axisUnit)
        objsToBeChecked.append(axisUnit)

    chainMappings = dataDict.get('chainMappings').values()
    for chainMapping in chainMappings:
      if (not (chainMapping in objsToBeDeleted)):
        objsToBeDeleted.add(chainMapping)
        objsToBeChecked.append(chainMapping)

    marks = dataDict.get('marks').values()
    for mark in marks:
      if (not (mark in objsToBeDeleted)):
        objsToBeDeleted.add(mark)
        objsToBeChecked.append(mark)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    nmrProject = dataDict.get('nmrProject')
    if (nmrProject is not None):
      topObject = nmrProject.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    panelTypes = dataDict.get('panelTypes').values()
    for panelType in panelTypes:
      if (not (panelType in objsToBeDeleted)):
        objsToBeDeleted.add(panelType)
        objsToBeChecked.append(panelType)

    rulers = dataDict.get('rulers').values()
    for ruler in rulers:
      if (not (ruler in objsToBeDeleted)):
        objsToBeDeleted.add(ruler)
        objsToBeChecked.append(ruler)

    spectrumWindowGroups = dataDict.get('spectrumWindowGroups').values()
    for spectrumWindowGroup in spectrumWindowGroups:
      if (not (spectrumWindowGroup in objsToBeDeleted)):
        objsToBeDeleted.add(spectrumWindowGroup)
        objsToBeChecked.append(spectrumWindowGroup)

    spectrumWindows = dataDict.get('spectrumWindows').values()
    for spectrumWindow in spectrumWindows:
      if (not (spectrumWindow in objsToBeDeleted)):
        objsToBeDeleted.add(spectrumWindow)
        objsToBeChecked.append(spectrumWindow)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AnalysisProject:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentAnalysisProject')):
      memopsRoot.__dict__['currentAnalysisProject'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    nmrProject = dataDict.get('nmrProject')
    if ((nmrProject is not None and not (nmrProject in objsToBeDeleted))):
      nmrProject.__dict__['analysisProject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('analysisProjects')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['analysisPopups'] = {}
    dataDict['analysisSpectra'] = {}
    dataDict['axisRegionGroups'] = {}
    dataDict['axisTypes'] = {}
    dataDict['axisUnits'] = {}
    dataDict['chainMappings'] = {}
    dataDict['marks'] = {}
    dataDict['panelTypes'] = {}
    dataDict['rulers'] = {}
    dataDict['spectrumWindowGroups'] = {}
    dataDict['spectrumWindows'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('analysisPopups').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('analysisSpectra').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('axisRegionGroups').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('axisTypes').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('axisUnits').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chainMappings').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('marks').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('panelTypes').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('rulers').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('spectrumWindowGroups').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('spectrumWindows').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('analysisProjects')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('autoBackupFreq')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: autoBackupFreq:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: autoBackupFreq:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('contourToUnaliased')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: contourToUnaliased:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('defaultSpectrumFileType')
      if (not (value in ['Azara', 'Bruker', 'Felix', 'NMRPipe', 'NMRView', 'UCSF'])):
        raise ApiError("""%s.checkValid: defaultSpectrumFileType:
         ccpnmr.Analysis.SpectrumFileType input is not in enumeration ['Azara', 'Bruker', 'Felix', 'NMRPipe', 'NMRView', 'UCSF']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: defaultSpectrumFileType:
         SpectrumFileType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doAssignmentAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doAssignmentAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doAutoBackup')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doAutoBackup:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doChainAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doChainAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doDetailAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doDetailAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doMeritAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doMeritAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doMinimalAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doMinimalAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doMolSysAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doMolSysAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doSpinSystemAnnotations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doSpinSystemAnnotations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('globalContourScale')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: globalContourScale:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: globalContourScale:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: globalContourScale:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isThreadingAllowed')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isThreadingAllowed:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('linkPeakListsData')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: linkPeakListsData:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('linkSeqSpinSystemsData')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: linkSeqSpinSystemsData:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('maxMarks')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: maxMarks:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: maxMarks:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('maxRulers')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: maxRulers:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: maxRulers:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('meritAnnotationBad')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: meritAnnotationBad:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: meritAnnotationBad:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: meritAnnotationBad:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: meritAnnotationBad:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('meritAnnotationGood')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: meritAnnotationGood:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: meritAnnotationGood:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: meritAnnotationGood:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: meritAnnotationGood:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('meritAnnotationMediocre')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: meritAnnotationMediocre:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: meritAnnotationMediocre:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: meritAnnotationMediocre:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: meritAnnotationMediocre:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakDrawMethod')
      if (not (value in ['uniform in pixels', 'uniform in ppm', 'scaled globally', 'scaled by peaks in peaklist', 'line width', 'box width'])):
        raise ApiError("""%s.checkValid: peakDrawMethod:
         ccpnmr.Analysis.PeakDrawMethod input is not in enumeration ['uniform in pixels', 'uniform in ppm', 'scaled globally', 'scaled by peaks in peaklist', 'line width', 'box width']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: peakDrawMethod:
         PeakDrawMethod constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindBuffer')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: peakFindBuffer:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: peakFindBuffer:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindDrop')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakFindDrop:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: peakFindDrop:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakFindDrop:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.checkValid: peakFindDrop:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindHaveHigh')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: peakFindHaveHigh:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindHaveLow')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: peakFindHaveLow:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindNonadjacent')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: peakFindNonadjacent:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindScale')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakFindScale:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: peakFindScale:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakFindScale:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindThickness')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: peakFindThickness:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: peakFindThickness:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakFindVolumeMethod')
      if (not (value in ['box sum', 'truncated box sum', 'parabolic fit', 'peak fit'])):
        raise ApiError("""%s.checkValid: peakFindVolumeMethod:
         ccpnmr.Analysis.PeakFindVolumeMethod input is not in enumeration ['box sum', 'truncated box sum', 'parabolic fit', 'peak fit']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: peakFindVolumeMethod:
         PeakFindVolumeMethod constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakIntensityScale')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakIntensityScale:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: peakIntensityScale:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakIntensityScale:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakPixelSize')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: peakPixelSize:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: peakPixelSize:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakVolumeScale')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakVolumeScale:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: peakVolumeScale:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakVolumeScale:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinFileName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: printWinFileName:
           memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value.find(chr(92)) == -1)):
          raise ApiError("""%s.checkValid: printWinFileName:
           PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: printWinFileName:
           PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('printWinInColor')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: printWinInColor:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinOrientation')
      if (not (value in ['Portrait', 'Landscape'])):
        raise ApiError("""%s.checkValid: printWinOrientation:
         memops.Implementation.PaperOrientation input is not in enumeration ['Portrait', 'Landscape']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinOtherHeight')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: printWinOtherHeight:
           memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: printWinOtherHeight:
           PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: printWinOtherHeight:
           PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('printWinOtherUnit')
      if (not (value in ['cm', 'in', 'pt'])):
        raise ApiError("""%s.checkValid: printWinOtherUnit:
         memops.Implementation.PaperUnit input is not in enumeration ['cm', 'in', 'pt']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinOtherWidth')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: printWinOtherWidth:
           memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: printWinOtherWidth:
           PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: printWinOtherWidth:
           PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('printWinOutputFormat')
      if (not (value in ['PS', 'EPS', 'PDF'])):
        raise ApiError("""%s.checkValid: printWinOutputFormat:
         memops.Implementation.PrintFormat input is not in enumeration ['PS', 'EPS', 'PDF']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinPaperSize')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: printWinPaperSize:
         memops.Implementation.PaperFormat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinScaling')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: printWinScaling:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: printWinScaling:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: printWinScaling:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinShowsDateTime')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: printWinShowsDateTime:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinShowsFileName')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: printWinShowsFileName:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinTickOutside')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: printWinTickOutside:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('printWinTickPlacement')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: printWinTickPlacement:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: printWinTickPlacement:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: printWinTickPlacement:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: printWinTickPlacement:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('printWinTitle')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: printWinTitle:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: printWinTitle:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: printWinTitle:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: printWinTitle:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('spectrumFont')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: spectrumFont:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: spectrumFont:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: spectrumFont:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: spectrumFont:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('useBootstrap')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useBootstrap:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('activeWindowGroup')
      if (value is not None):
        if (not isinstance(value, SpectrumWindowGroup)):
          raise ApiError("""%s.checkValid: activeWindowGroup:
           value is not of class ccpnmr.Analysis.SpectrumWindowGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeWindowGroup:
           Link activeWindowGroup between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('analysisPopups').values()
      for value in values:
        if (not isinstance(value, AnalysisPopup)):
          raise ApiError("""%s.checkValid: analysisPopups:
           value is not of class ccpnmr.Analysis.AnalysisPopup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisPopups:
           non-reciprocal link analysisPopups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('analysisSpectra').values()
      for value in values:
        if (not isinstance(value, AnalysisSpectrum)):
          raise ApiError("""%s.checkValid: analysisSpectra:
           value is not of class ccpnmr.Analysis.AnalysisSpectrum""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisSpectra:
           non-reciprocal link analysisSpectra from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('axisRegionGroups').values()
      for value in values:
        if (not isinstance(value, AxisRegionGroup)):
          raise ApiError("""%s.checkValid: axisRegionGroups:
           value is not of class ccpnmr.Analysis.AxisRegionGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: axisRegionGroups:
           non-reciprocal link axisRegionGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('axisTypes').values()
      for value in values:
        if (not isinstance(value, AxisType)):
          raise ApiError("""%s.checkValid: axisTypes:
           value is not of class ccpnmr.Analysis.AxisType""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: axisTypes:
           non-reciprocal link axisTypes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('axisUnits').values()
      for value in values:
        if (not isinstance(value, AxisUnit)):
          raise ApiError("""%s.checkValid: axisUnits:
           value is not of class ccpnmr.Analysis.AxisUnit""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: axisUnits:
           non-reciprocal link axisUnits from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chainMappings').values()
      for value in values:
        if (not isinstance(value, ChainMapping)):
          raise ApiError("""%s.checkValid: chainMappings:
           value is not of class ccpnmr.Analysis.ChainMapping""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chainMappings:
           non-reciprocal link chainMappings from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('marks').values()
      for value in values:
        if (not isinstance(value, Mark)):
          raise ApiError("""%s.checkValid: marks:
           value is not of class ccpnmr.Analysis.Mark""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: marks:
           non-reciprocal link marks from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('nmrProject')
      from ccp.api.nmr.Nmr import NmrProject as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: nmrProject:
         value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelf = value.__dict__.get('analysisProject')
      if (not (oldSelf is self)):
        raise ApiError("""%s.checkValid: nmrProject:
         non-reciprocal link nmrProject from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('panelTypes').values()
      for value in values:
        if (not isinstance(value, PanelType)):
          raise ApiError("""%s.checkValid: panelTypes:
           value is not of class ccpnmr.Analysis.PanelType""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: panelTypes:
           non-reciprocal link panelTypes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('rulers').values()
      for value in values:
        if (not isinstance(value, Ruler)):
          raise ApiError("""%s.checkValid: rulers:
           value is not of class ccpnmr.Analysis.Ruler""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: rulers:
           non-reciprocal link rulers from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('spectrumWindowGroups').values()
      for value in values:
        if (not isinstance(value, SpectrumWindowGroup)):
          raise ApiError("""%s.checkValid: spectrumWindowGroups:
           value is not of class ccpnmr.Analysis.SpectrumWindowGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: spectrumWindowGroups:
           non-reciprocal link spectrumWindowGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('spectrumWindows').values()
      for value in values:
        if (not isinstance(value, SpectrumWindow)):
          raise ApiError("""%s.checkValid: spectrumWindows:
           value is not of class ccpnmr.Analysis.SpectrumWindow""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: spectrumWindows:
           non-reciprocal link spectrumWindows from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('autoBackupFreq')
      if (value is None):
        raise ApiError("""%s.checkValid: autoBackupFreq:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('contourToUnaliased')
      if (value is None):
        raise ApiError("""%s.checkValid: contourToUnaliased:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('defaultSpectrumFileType')
      if (value is None):
        raise ApiError("""%s.checkValid: defaultSpectrumFileType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doAssignmentAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doAssignmentAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doAutoBackup')
      if (value is None):
        raise ApiError("""%s.checkValid: doAutoBackup:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doChainAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doChainAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doDetailAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doDetailAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doMeritAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doMeritAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doMinimalAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doMinimalAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doMolSysAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doMolSysAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('doSpinSystemAnnotations')
      if (value is None):
        raise ApiError("""%s.checkValid: doSpinSystemAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('globalContourScale')
      if (value is None):
        raise ApiError("""%s.checkValid: globalContourScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('isThreadingAllowed')
      if (value is None):
        raise ApiError("""%s.checkValid: isThreadingAllowed:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('linkPeakListsData')
      value = dataDict.get('linkSeqSpinSystemsData')
      value = dataDict.get('maxMarks')
      if (value is None):
        raise ApiError("""%s.checkValid: maxMarks:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('maxRulers')
      if (value is None):
        raise ApiError("""%s.checkValid: maxRulers:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('meritAnnotationBad')
      value = dataDict.get('meritAnnotationGood')
      value = dataDict.get('meritAnnotationMediocre')
      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakDrawMethod')
      if (value is None):
        raise ApiError("""%s.checkValid: peakDrawMethod:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindBuffer')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindBuffer:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindDrop')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindDrop:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindHaveHigh')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindHaveHigh:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindHaveLow')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindHaveLow:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindNonadjacent')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindNonadjacent:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindScale')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindThickness')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindThickness:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakFindVolumeMethod')
      if (value is None):
        raise ApiError("""%s.checkValid: peakFindVolumeMethod:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakIntensityScale')
      if (value is None):
        raise ApiError("""%s.checkValid: peakIntensityScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakPixelSize')
      if (value is None):
        raise ApiError("""%s.checkValid: peakPixelSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('peakVolumeScale')
      if (value is None):
        raise ApiError("""%s.checkValid: peakVolumeScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinFileName')
      value = dataDict.get('printWinInColor')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinInColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinOrientation')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinOrientation:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinOtherHeight')
      value = dataDict.get('printWinOtherUnit')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinOtherUnit:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinOtherWidth')
      value = dataDict.get('printWinOutputFormat')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinOutputFormat:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinPaperSize')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinPaperSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinScaling')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinScaling:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.checkValid: printWinScaling:
         printWinScaling constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('printWinShowsDateTime')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinShowsDateTime:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinShowsFileName')
      if (value is None):
        raise ApiError("""%s.checkValid: printWinShowsFileName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('printWinTickOutside')
      value = dataDict.get('printWinTickPlacement')
      value = dataDict.get('printWinTitle')
      value = dataDict.get('spectrumFont')
      value = dataDict.get('useBootstrap')
      if (value is None):
        raise ApiError("""%s.checkValid: useBootstrap:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      value = dataDict.get('activeWindowGroup')
      values = dataDict.get('analysisPopups').values()
      values = dataDict.get('analysisSpectra').values()
      values = dataDict.get('axisRegionGroups').values()
      values = dataDict.get('axisTypes').values()
      values = dataDict.get('axisUnits').values()
      values = dataDict.get('chainMappings').values()
      values = dataDict.get('marks').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('nmrProject')
      if (value is None):
        raise ApiError("""%s.checkValid: nmrProject:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('panelTypes').values()
      values = dataDict.get('rulers').values()
      values = dataDict.get('spectrumWindowGroups').values()
      values = dataDict.get('spectrumWindows').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories
  
  def findAllAnalysisPopups(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.analysisPopups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('analysisPopups').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('analysisPopups').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('height', 'isOpen', 'name', 'screenX', 'screenY', 'title', 'width', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAnalysisSpectra(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.analysisSpectra
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('analysisSpectra').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('analysisSpectra').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('autoBaseLevel', 'autoLevelChanger', 'autoLevelMode', 'autoNumLevels', 'contourDir', 'font', 'multipletPattern', 'rank', 'shortcut', 'sliceColor', 'useBoundingBox', 'usePeakArrow', 'usePrecalculated', 'access', 'analysisProject', 'dataSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAxisRegionGroups(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.axisRegionGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisRegionGroups').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisRegionGroups').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAxisTypes(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.axisTypes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisTypes').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisTypes').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('diagonalExclusion', 'isSampled', 'measurementType', 'name', 'numDecimals', 'peakSize', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAxisUnits(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.axisUnits
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisUnits').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisUnits').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isBackwards', 'unit', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChainMappings(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.chainMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chainMappings').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chainMappings').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chainCode', 'molSystemCode', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMarks(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.marks
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('marks').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('marks').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('color', 'dashLength', 'gapLength', 'lineWidth', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllPanelTypes(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.panelTypes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('panelTypes').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('panelTypes').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProject', 'axisType',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRulers(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.rulers
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('rulers').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('rulers').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('color', 'dashLength', 'gapLength', 'lineWidth', 'position', 'serial', 'access', 'analysisProject', 'panelType',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSpectrumWindowGroups(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.spectrumWindowGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('spectrumWindowGroups').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('spectrumWindowGroups').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSpectrumWindows(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisProject.spectrumWindows
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('spectrumWindows').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('spectrumWindows').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isCanvasLabelShown', 'isCanvasMidpointShown', 'isIconified', 'isXSliceDrawn', 'isXTickShown', 'isYSliceDrawn', 'isYTickShown', 'isZeroLineShown', 'name', 'serial', 'stripAxis', 'useMultiplePeakLists', 'useOverrideRegion', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository
  
  def findFirstAnalysisPopup(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.analysisPopups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('analysisPopups').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('analysisPopups').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('analysisPopups').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('height', 'isOpen', 'name', 'screenX', 'screenY', 'title', 'width', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAnalysisSpectrum(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.analysisSpectra
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('analysisSpectra').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('dataSource')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('analysisSpectra').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('analysisSpectra').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('autoBaseLevel', 'autoLevelChanger', 'autoLevelMode', 'autoNumLevels', 'contourDir', 'font', 'multipletPattern', 'rank', 'shortcut', 'sliceColor', 'useBoundingBox', 'usePeakArrow', 'usePrecalculated', 'access', 'analysisProject', 'dataSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAxisRegionGroup(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.axisRegionGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisRegionGroups').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('axisRegionGroups').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('axisRegionGroups').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAxisType(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.axisTypes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisTypes').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('axisTypes').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('axisTypes').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('diagonalExclusion', 'isSampled', 'measurementType', 'name', 'numDecimals', 'peakSize', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAxisUnit(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.axisUnits
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('axisUnits').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('unit')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('axisUnits').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('axisUnits').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isBackwards', 'unit', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChainMapping(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.chainMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chainMappings').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molSystemCode')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('chainCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chainMappings').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chainMappings').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chainCode', 'molSystemCode', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMark(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.marks
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('marks').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('marks').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('marks').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('color', 'dashLength', 'gapLength', 'lineWidth', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstPanelType(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.panelTypes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('panelTypes').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('panelTypes').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('panelTypes').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProject', 'axisType',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRuler(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.rulers
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('rulers').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('rulers').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('rulers').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('color', 'dashLength', 'gapLength', 'lineWidth', 'position', 'serial', 'access', 'analysisProject', 'panelType',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSpectrumWindow(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.spectrumWindows
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('spectrumWindows').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('spectrumWindows').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('spectrumWindows').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isCanvasLabelShown', 'isCanvasMidpointShown', 'isIconified', 'isXSliceDrawn', 'isXTickShown', 'isYSliceDrawn', 'isYTickShown', 'isZeroLineShown', 'name', 'serial', 'stripAxis', 'useMultiplePeakLists', 'useOverrideRegion', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSpectrumWindowGroup(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisProject.spectrumWindowGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('spectrumWindowGroups').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('spectrumWindowGroups').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('spectrumWindowGroups').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories
  
  def getActiveWindowGroup(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.activeWindowGroup
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    result = dataDict.get('activeWindowGroup')
    return result
  
  def getAnalysisPopups(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.analysisPopups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('analysisPopups').values()
    result = frozenset(tempVar)
    return result
  
  def getAnalysisSpectra(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.analysisSpectra
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('analysisSpectra').values()
    result = frozenset(tempVar)
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAutoBackupFreq(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.autoBackupFreq
    """
    dataDict = self.__dict__
    result = dataDict.get('autoBackupFreq')
    return result
  
  def getAxisRegionGroups(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.axisRegionGroups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('axisRegionGroups').values()
    result = frozenset(tempVar)
    return result
  
  def getAxisTypes(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.axisTypes
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('axisTypes').values()
    result = frozenset(tempVar)
    return result
  
  def getAxisUnits(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.axisUnits
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('axisUnits').values()
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AnalysisProject
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccpnmr.Analysis.AnalysisProject'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('analysisProjects').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccpnmr.Analysis')
      obj1 = startObj.__dict__.get('analysisProjects').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChainMappings(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.chainMappings
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chainMappings').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getContourToUnaliased(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.contourToUnaliased
    """
    dataDict = self.__dict__
    result = dataDict.get('contourToUnaliased')
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy
  
  def getDefaultSpectrumFileType(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.defaultSpectrumFileType
    """
    dataDict = self.__dict__
    result = dataDict.get('defaultSpectrumFileType')
    return result
  
  def getDoAssignmentAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doAssignmentAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doAssignmentAnnotations')
    return result
  
  def getDoAutoBackup(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doAutoBackup
    """
    dataDict = self.__dict__
    result = dataDict.get('doAutoBackup')
    return result
  
  def getDoChainAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doChainAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doChainAnnotations')
    return result
  
  def getDoDetailAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doDetailAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doDetailAnnotations')
    return result
  
  def getDoMeritAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doMeritAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doMeritAnnotations')
    return result
  
  def getDoMinimalAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doMinimalAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doMinimalAnnotations')
    return result
  
  def getDoMolSysAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doMolSysAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doMolSysAnnotations')
    return result
  
  def getDoSpinSystemAnnotations(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.doSpinSystemAnnotations
    """
    dataDict = self.__dict__
    result = dataDict.get('doSpinSystemAnnotations')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result
  
  def getGlobalContourScale(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.globalContourScale
    """
    dataDict = self.__dict__
    result = dataDict.get('globalContourScale')
    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading
  
  def getIsThreadingAllowed(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.isThreadingAllowed
    """
    dataDict = self.__dict__
    result = dataDict.get('isThreadingAllowed')
    return result

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLinkPeakListsData(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.linkPeakListsData
    """
    dataDict = self.__dict__
    result = dataDict.get('linkPeakListsData')
    return result
  
  def getLinkSeqSpinSystemsData(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.linkSeqSpinSystemsData
    """
    dataDict = self.__dict__
    result = dataDict.get('linkSeqSpinSystemsData')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMarks(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.marks
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('marks').values()
    result = frozenset(tempVar)
    return result
  
  def getMaxMarks(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.maxMarks
    """
    dataDict = self.__dict__
    result = dataDict.get('maxMarks')
    return result
  
  def getMaxRulers(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.maxRulers
    """
    dataDict = self.__dict__
    result = dataDict.get('maxRulers')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result
  
  def getMeritAnnotationBad(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.meritAnnotationBad
    """
    dataDict = self.__dict__
    result = dataDict.get('meritAnnotationBad')
    return result
  
  def getMeritAnnotationGood(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.meritAnnotationGood
    """
    dataDict = self.__dict__
    result = dataDict.get('meritAnnotationGood')
    return result
  
  def getMeritAnnotationMediocre(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.meritAnnotationMediocre
    """
    dataDict = self.__dict__
    result = dataDict.get('meritAnnotationMediocre')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNmrProject(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.nmrProject
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrProject')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getPanelTypes(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.panelTypes
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('panelTypes').values()
    result = frozenset(tempVar)
    return result
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result
  
  def getPeakDrawMethod(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakDrawMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('peakDrawMethod')
    return result
  
  def getPeakFindBuffer(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindBuffer
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindBuffer')
    return result
  
  def getPeakFindDrop(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindDrop
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindDrop')
    return result
  
  def getPeakFindHaveHigh(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindHaveHigh
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindHaveHigh')
    return result
  
  def getPeakFindHaveLow(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindHaveLow
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindHaveLow')
    return result
  
  def getPeakFindNonadjacent(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindNonadjacent
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindNonadjacent')
    return result
  
  def getPeakFindScale(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindScale
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindScale')
    return result
  
  def getPeakFindThickness(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindThickness
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindThickness')
    return result
  
  def getPeakFindVolumeMethod(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakFindVolumeMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('peakFindVolumeMethod')
    return result
  
  def getPeakIntensityScale(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakIntensityScale
    """
    dataDict = self.__dict__
    result = dataDict.get('peakIntensityScale')
    return result
  
  def getPeakPixelSize(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakPixelSize
    """
    dataDict = self.__dict__
    result = dataDict.get('peakPixelSize')
    return result
  
  def getPeakVolumeScale(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.peakVolumeScale
    """
    dataDict = self.__dict__
    result = dataDict.get('peakVolumeScale')
    return result
  
  def getPrintWinFileName(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinFileName
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinFileName')
    return result
  
  def getPrintWinInColor(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinInColor
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinInColor')
    return result
  
  def getPrintWinOrientation(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinOrientation
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinOrientation')
    return result
  
  def getPrintWinOtherHeight(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinOtherHeight
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinOtherHeight')
    return result
  
  def getPrintWinOtherUnit(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinOtherUnit
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinOtherUnit')
    return result
  
  def getPrintWinOtherWidth(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinOtherWidth
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinOtherWidth')
    return result
  
  def getPrintWinOutputFormat(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinOutputFormat
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinOutputFormat')
    return result
  
  def getPrintWinPaperSize(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinPaperSize
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinPaperSize')
    return result
  
  def getPrintWinScaling(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinScaling
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinScaling')
    return result
  
  def getPrintWinShowsDateTime(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinShowsDateTime
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinShowsDateTime')
    return result
  
  def getPrintWinShowsFileName(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinShowsFileName
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinShowsFileName')
    return result
  
  def getPrintWinTickOutside(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinTickOutside
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinTickOutside')
    return result
  
  def getPrintWinTickPlacement(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinTickPlacement
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinTickPlacement')
    return result
  
  def getPrintWinTitle(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.printWinTitle
    """
    dataDict = self.__dict__
    result = dataDict.get('printWinTitle')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRulers(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.rulers
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('rulers').values()
    result = frozenset(tempVar)
    return result
  
  def getSpectrumFont(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.spectrumFont
    """
    dataDict = self.__dict__
    result = dataDict.get('spectrumFont')
    return result
  
  def getSpectrumWindowGroups(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.spectrumWindowGroups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('spectrumWindowGroups').values()
    result = frozenset(tempVar)
    return result
  
  def getSpectrumWindows(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.spectrumWindows
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('spectrumWindows').values()
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getUseBootstrap(self):
    """
    Get for ccpnmr.Analysis.AnalysisProject.useBootstrap
    """
    dataDict = self.__dict__
    result = dataDict.get('useBootstrap')
    return result

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newAnalysisPopup(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AnalysisPopup
    """
    return AnalysisPopup(self, **attrlinks)
  
  def newAnalysisSpectrum(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AnalysisSpectrum
    """
    return AnalysisSpectrum(self, **attrlinks)
  
  def newAxisRegionGroup(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AxisRegionGroup
    """
    return AxisRegionGroup(self, **attrlinks)
  
  def newAxisType(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AxisType
    """
    return AxisType(self, **attrlinks)
  
  def newAxisUnit(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AxisUnit
    """
    return AxisUnit(self, **attrlinks)
  
  def newChainMapping(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.ChainMapping
    """
    return ChainMapping(self, **attrlinks)
  
  def newMark(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.Mark
    """
    return Mark(self, **attrlinks)
  
  def newPanelType(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.PanelType
    """
    return PanelType(self, **attrlinks)
  
  def newRuler(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.Ruler
    """
    return Ruler(self, **attrlinks)
  
  def newSpectrumWindow(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.SpectrumWindow
    """
    return SpectrumWindow(self, **attrlinks)
  
  def newSpectrumWindowGroup(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.SpectrumWindowGroup
    """
    return SpectrumWindowGroup(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AnalysisProject
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setActiveWindowGroup(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.activeWindowGroup
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, SpectrumWindowGroup)):
        raise ApiError("""%s.setActiveWindowGroup:
         value is not of class ccpnmr.Analysis.SpectrumWindowGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('activeWindowGroup')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setActiveWindowGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setActiveWindowGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setActiveWindowGroup:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setActiveWindowGroup:
           Link activeWindowGroup between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['activeWindowGroup'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setActiveWindowGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAutoBackupFreq(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.autoBackupFreq
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setAutoBackupFreq:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setAutoBackupFreq:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('autoBackupFreq')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAutoBackupFreq:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAutoBackupFreq:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAutoBackupFreq:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['autoBackupFreq'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAutoBackupFreq')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setContourToUnaliased(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.contourToUnaliased
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setContourToUnaliased:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('contourToUnaliased')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setContourToUnaliased:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setContourToUnaliased:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setContourToUnaliased:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['contourToUnaliased'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setContourToUnaliased')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy
  
  def setDefaultSpectrumFileType(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.defaultSpectrumFileType
    """
    dataDict = self.__dict__
    if (not (value in ['Azara', 'Bruker', 'Felix', 'NMRPipe', 'NMRView', 'UCSF'])):
      raise ApiError("""%s.setDefaultSpectrumFileType:
       ccpnmr.Analysis.SpectrumFileType input is not in enumeration ['Azara', 'Bruker', 'Felix', 'NMRPipe', 'NMRView', 'UCSF']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setDefaultSpectrumFileType:
       SpectrumFileType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('defaultSpectrumFileType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDefaultSpectrumFileType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDefaultSpectrumFileType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDefaultSpectrumFileType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['defaultSpectrumFileType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDefaultSpectrumFileType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoAssignmentAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doAssignmentAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoAssignmentAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doAssignmentAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoAssignmentAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoAssignmentAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoAssignmentAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doAssignmentAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoAssignmentAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoAutoBackup(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doAutoBackup
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoAutoBackup:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doAutoBackup')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoAutoBackup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoAutoBackup:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoAutoBackup:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doAutoBackup'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoAutoBackup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoChainAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doChainAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoChainAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doChainAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoChainAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoChainAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoChainAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doChainAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoChainAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoDetailAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doDetailAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoDetailAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doDetailAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoDetailAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoDetailAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoDetailAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doDetailAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoDetailAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoMeritAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doMeritAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoMeritAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doMeritAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoMeritAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoMeritAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoMeritAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doMeritAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoMeritAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoMinimalAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doMinimalAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoMinimalAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doMinimalAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoMinimalAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoMinimalAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoMinimalAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doMinimalAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoMinimalAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoMolSysAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doMolSysAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoMolSysAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doMolSysAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoMolSysAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoMolSysAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoMolSysAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doMolSysAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoMolSysAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoSpinSystemAnnotations(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.doSpinSystemAnnotations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoSpinSystemAnnotations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('doSpinSystemAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoSpinSystemAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoSpinSystemAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoSpinSystemAnnotations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doSpinSystemAnnotations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoSpinSystemAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setGlobalContourScale(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.globalContourScale
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setGlobalContourScale:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setGlobalContourScale:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setGlobalContourScale:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('globalContourScale')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setGlobalContourScale:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGlobalContourScale:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setGlobalContourScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['globalContourScale'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setGlobalContourScale')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable
  
  def setIsThreadingAllowed(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.isThreadingAllowed
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsThreadingAllowed:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('isThreadingAllowed')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsThreadingAllowed:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsThreadingAllowed:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsThreadingAllowed:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isThreadingAllowed'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsThreadingAllowed')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setLinkPeakListsData(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.linkPeakListsData
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setLinkPeakListsData:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('linkPeakListsData')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLinkPeakListsData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinkPeakListsData:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['linkPeakListsData'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLinkPeakListsData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLinkSeqSpinSystemsData(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.linkSeqSpinSystemsData
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setLinkSeqSpinSystemsData:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('linkSeqSpinSystemsData')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLinkSeqSpinSystemsData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinkSeqSpinSystemsData:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['linkSeqSpinSystemsData'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLinkSeqSpinSystemsData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMaxMarks(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.maxMarks
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setMaxMarks:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setMaxMarks:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('maxMarks')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMaxMarks:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMaxMarks:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMaxMarks:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['maxMarks'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMaxMarks')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMaxRulers(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.maxRulers
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setMaxRulers:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setMaxRulers:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('maxRulers')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMaxRulers:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMaxRulers:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMaxRulers:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['maxRulers'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMaxRulers')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMeritAnnotationBad(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.meritAnnotationBad
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMeritAnnotationBad:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setMeritAnnotationBad:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMeritAnnotationBad:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setMeritAnnotationBad:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('meritAnnotationBad')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeritAnnotationBad:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeritAnnotationBad:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['meritAnnotationBad'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMeritAnnotationBad')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMeritAnnotationGood(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.meritAnnotationGood
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMeritAnnotationGood:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setMeritAnnotationGood:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMeritAnnotationGood:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setMeritAnnotationGood:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('meritAnnotationGood')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeritAnnotationGood:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeritAnnotationGood:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['meritAnnotationGood'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMeritAnnotationGood')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMeritAnnotationMediocre(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.meritAnnotationMediocre
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMeritAnnotationMediocre:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setMeritAnnotationMediocre:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMeritAnnotationMediocre:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setMeritAnnotationMediocre:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('meritAnnotationMediocre')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeritAnnotationMediocre:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeritAnnotationMediocre:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['meritAnnotationMediocre'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMeritAnnotationMediocre')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNmrProject(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.nmrProject
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import NmrProject as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setNmrProject:
       value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('nmrProject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.Analysis')
      tobjList = set(root.__dict__.get('analysisProjects').values())
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrProject:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setNmrProject:
         cannot set nmrProject, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setNmrProject:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value.__dict__.get('analysisProject') is None):
        root = dataDict.get('memopsRoot')
        root.refreshTopObjects('ccpnmr.Analysis')

      oldSelf = value.__dict__.get('analysisProject')
      if (oldSelf is not None):
        raise ApiError("""%s.setNmrProject:
         oldSelf must be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setNmrProject:
         Link nmrProject between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      currentValue.__dict__['analysisProject'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('analysisProject')
      if (oldSelf is not None):
        oldSelf.__dict__['nmrProject'] = None

      value.__dict__['analysisProject'] = self

    dataDict['nmrProject'] = value

    # doNotifies
  
  def setPeakDrawMethod(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakDrawMethod
    """
    dataDict = self.__dict__
    if (not (value in ['uniform in pixels', 'uniform in ppm', 'scaled globally', 'scaled by peaks in peaklist', 'line width', 'box width'])):
      raise ApiError("""%s.setPeakDrawMethod:
       ccpnmr.Analysis.PeakDrawMethod input is not in enumeration ['uniform in pixels', 'uniform in ppm', 'scaled globally', 'scaled by peaks in peaklist', 'line width', 'box width']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setPeakDrawMethod:
       PeakDrawMethod constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakDrawMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakDrawMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakDrawMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakDrawMethod:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakDrawMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakDrawMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindBuffer(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindBuffer
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setPeakFindBuffer:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setPeakFindBuffer:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindBuffer')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindBuffer:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindBuffer:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindBuffer:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindBuffer'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindBuffer')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindDrop(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindDrop
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakFindDrop:
       memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setPeakFindDrop:
       FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakFindDrop:
       FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value <= 1.0)):
      raise ApiError("""%s.setPeakFindDrop:
       FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindDrop')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindDrop:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindDrop:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindDrop:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindDrop'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindDrop')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindHaveHigh(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindHaveHigh
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPeakFindHaveHigh:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindHaveHigh')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindHaveHigh:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindHaveHigh:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindHaveHigh:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindHaveHigh'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindHaveHigh')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindHaveLow(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindHaveLow
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPeakFindHaveLow:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindHaveLow')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindHaveLow:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindHaveLow:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindHaveLow:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindHaveLow'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindHaveLow')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindNonadjacent(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindNonadjacent
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPeakFindNonadjacent:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindNonadjacent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindNonadjacent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindNonadjacent:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindNonadjacent:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindNonadjacent'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindNonadjacent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindScale(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindScale
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakFindScale:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setPeakFindScale:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakFindScale:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindScale')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindScale:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindScale:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindScale'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindScale')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindThickness(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindThickness
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setPeakFindThickness:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setPeakFindThickness:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindThickness')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindThickness:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindThickness:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindThickness:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindThickness'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindThickness')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakFindVolumeMethod(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakFindVolumeMethod
    """
    dataDict = self.__dict__
    if (not (value in ['box sum', 'truncated box sum', 'parabolic fit', 'peak fit'])):
      raise ApiError("""%s.setPeakFindVolumeMethod:
       ccpnmr.Analysis.PeakFindVolumeMethod input is not in enumeration ['box sum', 'truncated box sum', 'parabolic fit', 'peak fit']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setPeakFindVolumeMethod:
       PeakFindVolumeMethod constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakFindVolumeMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakFindVolumeMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakFindVolumeMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakFindVolumeMethod:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakFindVolumeMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakFindVolumeMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakIntensityScale(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakIntensityScale
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakIntensityScale:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setPeakIntensityScale:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakIntensityScale:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakIntensityScale')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakIntensityScale:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakIntensityScale:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakIntensityScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakIntensityScale'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakIntensityScale')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakPixelSize(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakPixelSize
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setPeakPixelSize:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setPeakPixelSize:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakPixelSize')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakPixelSize:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakPixelSize:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakPixelSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakPixelSize'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakPixelSize')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakVolumeScale(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.peakVolumeScale
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakVolumeScale:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setPeakVolumeScale:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakVolumeScale:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('peakVolumeScale')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakVolumeScale:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakVolumeScale:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakVolumeScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakVolumeScale'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakVolumeScale')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinFileName(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinFileName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPrintWinFileName:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.setPrintWinFileName:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setPrintWinFileName:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinFileName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinFileName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinFileName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['printWinFileName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinFileName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinInColor(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinInColor
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPrintWinInColor:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinInColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinInColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinInColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinInColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinInColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinInColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinOrientation(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinOrientation
    """
    dataDict = self.__dict__
    if (not (value in ['Portrait', 'Landscape'])):
      raise ApiError("""%s.setPrintWinOrientation:
       memops.Implementation.PaperOrientation input is not in enumeration ['Portrait', 'Landscape']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinOrientation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinOrientation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinOrientation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinOrientation:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinOrientation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinOrientation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinOtherHeight(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinOtherHeight
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setPrintWinOtherHeight:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setPrintWinOtherHeight:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setPrintWinOtherHeight:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinOtherHeight')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinOtherHeight:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinOtherHeight:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['printWinOtherHeight'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinOtherHeight')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinOtherUnit(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinOtherUnit
    """
    dataDict = self.__dict__
    if (not (value in ['cm', 'in', 'pt'])):
      raise ApiError("""%s.setPrintWinOtherUnit:
       memops.Implementation.PaperUnit input is not in enumeration ['cm', 'in', 'pt']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinOtherUnit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinOtherUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinOtherUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinOtherUnit:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinOtherUnit'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinOtherUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinOtherWidth(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinOtherWidth
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setPrintWinOtherWidth:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setPrintWinOtherWidth:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setPrintWinOtherWidth:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinOtherWidth')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinOtherWidth:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinOtherWidth:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['printWinOtherWidth'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinOtherWidth')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinOutputFormat(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinOutputFormat
    """
    dataDict = self.__dict__
    if (not (value in ['PS', 'EPS', 'PDF'])):
      raise ApiError("""%s.setPrintWinOutputFormat:
       memops.Implementation.PrintFormat input is not in enumeration ['PS', 'EPS', 'PDF']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinOutputFormat')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinOutputFormat:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinOutputFormat:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinOutputFormat:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinOutputFormat'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinOutputFormat')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinPaperSize(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinPaperSize
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setPrintWinPaperSize:
       memops.Implementation.PaperFormat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinPaperSize')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinPaperSize:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinPaperSize:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinPaperSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinPaperSize'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinPaperSize')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinScaling(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinScaling
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPrintWinScaling:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setPrintWinScaling:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPrintWinScaling:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinScaling')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinScaling:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinScaling:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinScaling:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (value <= 1.0)):
            raise ApiError("""%s.setPrintWinScaling:
             printWinScaling constraint value_le_1 violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['printWinScaling'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinScaling')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinShowsDateTime(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinShowsDateTime
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPrintWinShowsDateTime:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinShowsDateTime')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinShowsDateTime:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinShowsDateTime:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinShowsDateTime:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinShowsDateTime'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinShowsDateTime')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinShowsFileName(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinShowsFileName
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPrintWinShowsFileName:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinShowsFileName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinShowsFileName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinShowsFileName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPrintWinShowsFileName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['printWinShowsFileName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinShowsFileName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinTickOutside(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinTickOutside
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setPrintWinTickOutside:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinTickOutside')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinTickOutside:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinTickOutside:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['printWinTickOutside'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinTickOutside')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinTickPlacement(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinTickPlacement
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPrintWinTickPlacement:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setPrintWinTickPlacement:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPrintWinTickPlacement:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setPrintWinTickPlacement:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinTickPlacement')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinTickPlacement:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinTickPlacement:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['printWinTickPlacement'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinTickPlacement')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPrintWinTitle(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.printWinTitle
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPrintWinTitle:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setPrintWinTitle:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPrintWinTitle:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setPrintWinTitle:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('printWinTitle')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPrintWinTitle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPrintWinTitle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['printWinTitle'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPrintWinTitle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSpectrumFont(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.spectrumFont
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSpectrumFont:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setSpectrumFont:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSpectrumFont:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setSpectrumFont:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('spectrumFont')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSpectrumFont:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSpectrumFont:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['spectrumFont'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSpectrumFont')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseBootstrap(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisProject.useBootstrap
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUseBootstrap:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('useBootstrap')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseBootstrap:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseBootstrap:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUseBootstrap:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['useBootstrap'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseBootstrap')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAnalysisPopups(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.analysisPopups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('analysisPopups')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAnalysisSpectra(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.analysisSpectra
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('analysisSpectra')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAxisRegionGroups(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.axisRegionGroups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('axisRegionGroups')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAxisTypes(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.axisTypes
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('axisTypes')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAxisUnits(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.axisUnits
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('axisUnits')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChainMappings(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.chainMappings
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chainMappings')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMarks(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.marks
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('marks')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedPanelTypes(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.panelTypes
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('panelTypes')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedRulers(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.rulers
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('rulers')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedSpectrumWindowGroups(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.spectrumWindowGroups
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('spectrumWindowGroups')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedSpectrumWindows(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisProject.spectrumWindows
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('spectrumWindows')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  autoBackupFreq = property(getAutoBackupFreq, setAutoBackupFreq, None,
  r"""NIterval between automatic backup (in minutes)
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  contourToUnaliased = property(getContourToUnaliased, setContourToUnaliased, None,
  r"""Contour unaliased parts of spectrum?
  """)

  createdBy = memops.api.Implementation.TopObject.createdBy
  
  defaultSpectrumFileType = property(getDefaultSpectrumFileType, setDefaultSpectrumFileType, None,
  r"""Default spectrum file type
  """)
  
  doAssignmentAnnotations = property(getDoAssignmentAnnotations, setDoAssignmentAnnotations, None,
  r"""Do peak annotations: Assignment?
  """)
  
  doAutoBackup = property(getDoAutoBackup, setDoAutoBackup, None,
  r"""Do automatic backup.
  """)
  
  doChainAnnotations = property(getDoChainAnnotations, setDoChainAnnotations, None,
  r"""Do peak annotations: Chains?
  """)
  
  doDetailAnnotations = property(getDoDetailAnnotations, setDoDetailAnnotations, None,
  r"""Do peak annotations: Details?
  """)
  
  doMeritAnnotations = property(getDoMeritAnnotations, setDoMeritAnnotations, None,
  r"""Do peak annotations: Merit
  """)
  
  doMinimalAnnotations = property(getDoMinimalAnnotations, setDoMinimalAnnotations, None,
  r"""Should minimal annotations be used?
  """)
  
  doMolSysAnnotations = property(getDoMolSysAnnotations, setDoMolSysAnnotations, None,
  r"""Do peak annotations: MolSystems?
  """)
  
  doSpinSystemAnnotations = property(getDoSpinSystemAnnotations, setDoSpinSystemAnnotations, None,
  r"""Do peak annotations: Spin Systems?
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  globalContourScale = property(getGlobalContourScale, setGlobalContourScale, None,
  r"""Global contouring scale
  """)

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading
  
  isThreadingAllowed = property(getIsThreadingAllowed, setIsThreadingAllowed, None,
  r"""May program be run as multiple threads?
  """)

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy
  
  linkPeakListsData = property(getLinkPeakListsData, setLinkPeakListsData, None,
  r"""Input data for linkPeakLists
  """)
  
  linkSeqSpinSystemsData = property(getLinkSeqSpinSystemsData, setLinkSeqSpinSystemsData, None,
  r"""input dat for linkSeqSpinSystems
  """)
  
  maxMarks = property(getMaxMarks, setMaxMarks, None,
  r"""Maxc no. of marks
  """)
  
  maxRulers = property(getMaxRulers, setMaxRulers, None,
  r"""Max no. of rulers
  """)
  
  meritAnnotationBad = property(getMeritAnnotationBad, setMeritAnnotationBad, None,
  r"""Annotation for merit=bad
  """)
  
  meritAnnotationGood = property(getMeritAnnotationGood, setMeritAnnotationGood, None,
  r"""Annotation for merit=good
  """)
  
  meritAnnotationMediocre = property(getMeritAnnotationMediocre, setMeritAnnotationMediocre, None,
  r"""Annotation for merit=mediocre
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of AnalysisProject
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  peakDrawMethod = property(getPeakDrawMethod, setPeakDrawMethod, None,
  r"""Peak mark drawing method
  """)
  
  peakFindBuffer = property(getPeakFindBuffer, setPeakFindBuffer, None,
  r"""Peak finding buffer extra width in pixels
  """)
  
  peakFindDrop = property(getPeakFindDrop, setPeakFindDrop, None,
  r"""The fraction of the maximum height that the data must drop
  by in all 
  directions in order to be considered a peak, in peak finding.
  """)
  
  peakFindHaveHigh = property(getPeakFindHaveHigh, setPeakFindHaveHigh, None,
  r"""Find positive extrema in peak finding?
  """)
  
  peakFindHaveLow = property(getPeakFindHaveLow, setPeakFindHaveLow, None,
  r"""Find negative extrema in peak finding?
  """)
  
  peakFindNonadjacent = property(getPeakFindNonadjacent, setPeakFindNonadjacent, None,
  r"""Consider positions that differ in more than one
  coordinate (by +-1), and 
  not just in one coordinate, in peak finding?
  """)
  
  peakFindScale = property(getPeakFindScale, setPeakFindScale, None,
  r"""Peak finding scale
  """)
  
  peakFindThickness = property(getPeakFindThickness, setPeakFindThickness, None,
  r"""Peak finding thickness
  """)
  
  peakFindVolumeMethod = property(getPeakFindVolumeMethod, setPeakFindVolumeMethod, None,
  r"""Volume integration method for peak find
  """)
  
  peakIntensityScale = property(getPeakIntensityScale, setPeakIntensityScale, None,
  r"""Peak Intensity scale
  """)
  
  peakPixelSize = property(getPeakPixelSize, setPeakPixelSize, None,
  r"""Peak size in pixels
  """)
  
  peakVolumeScale = property(getPeakVolumeScale, setPeakVolumeScale, None,
  r"""Peak volume scale
  """)
  
  printWinFileName = property(getPrintWinFileName, setPrintWinFileName, None,
  r"""Window file name to print to.
  """)
  
  printWinInColor = property(getPrintWinInColor, setPrintWinInColor, None,
  r"""Should windows be printed in color
  """)
  
  printWinOrientation = property(getPrintWinOrientation, setPrintWinOrientation, None,
  r"""Print WIndow in orientation
  """)
  
  printWinOtherHeight = property(getPrintWinOtherHeight, setPrintWinOtherHeight, None,
  r"""Paper height for 'other' paper print sizes
  """)
  
  printWinOtherUnit = property(getPrintWinOtherUnit, setPrintWinOtherUnit, None,
  r"""Printer measurement unit for 'other' paper sizes
  """)
  
  printWinOtherWidth = property(getPrintWinOtherWidth, setPrintWinOtherWidth, None,
  r"""Paper width for 'other' paper print sizes
  """)
  
  printWinOutputFormat = property(getPrintWinOutputFormat, setPrintWinOutputFormat, None,
  r"""Format for window printing
  """)
  
  printWinPaperSize = property(getPrintWinPaperSize, setPrintWinPaperSize, None,
  r"""Paper size for window printing
  """)
  
  printWinScaling = property(getPrintWinScaling, setPrintWinScaling, None,
  r"""window print scaling
  """)
  
  printWinShowsDateTime = property(getPrintWinShowsDateTime, setPrintWinShowsDateTime, None,
  r"""Show data and time on window print
  """)
  
  printWinShowsFileName = property(getPrintWinShowsFileName, setPrintWinShowsFileName, None,
  r"""Show file name on window print
  """)
  
  printWinTickOutside = property(getPrintWinTickOutside, setPrintWinTickOutside, None,
  r"""Print window ticks outside (True), inside (Falsde) or not at all (not 
  set).
  """)
  
  printWinTickPlacement = property(getPrintWinTickPlacement, setPrintWinTickPlacement, None,
  r"""Which sides (n, s, e, w) to print ticks on for window printing.
  """)
  
  printWinTitle = property(getPrintWinTitle, setPrintWinTitle, None,
  r"""Title for window printing
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  spectrumFont = property(getSpectrumFont, setSpectrumFont, None,
  r"""Font to use for spectrum (annotations)
  """)
  
  useBootstrap = property(getUseBootstrap, setUseBootstrap, None,
  r"""Use bootstrap error estimation in fitting?
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  activeWindowGroup = property(getActiveWindowGroup, setActiveWindowGroup, None,
  r"""Window group currently active
  """)
  
  analysisPopups = property(getAnalysisPopups,  None, None,
  r"""child link to class AnalysisPopup
  """)
  
  analysisSpectra = property(getAnalysisSpectra,  None, None,
  r"""child link to class AnalysisSpectrum
  """)
  
  axisRegionGroups = property(getAxisRegionGroups,  None, None,
  r"""child link to class AxisRegionGroup
  """)
  
  axisTypes = property(getAxisTypes,  None, None,
  r"""child link to class AxisType
  """)
  
  axisUnits = property(getAxisUnits,  None, None,
  r"""child link to class AxisUnit
  """)
  
  chainMappings = property(getChainMappings,  None, None,
  r"""child link to class ChainMapping
  """)
  
  marks = property(getMarks,  None, None,
  r"""child link to class Mark
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  nmrProject = property(getNmrProject, setNmrProject, None,
  r"""Nmr project to which AnalysisProject refers
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  panelTypes = property(getPanelTypes,  None, None,
  r"""child link to class PanelType
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  rulers = property(getRulers,  None, None,
  r"""child link to class Ruler
  """)
  
  spectrumWindowGroups = property(getSpectrumWindowGroups,  None, None,
  r"""child link to class SpectrumWindowGroup
  """)
  
  spectrumWindows = property(getSpectrumWindows,  None, None,
  r"""child link to class SpectrumWindow
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AnalysisSpectrum(memops.api.Implementation.DataObject):
  r"""Analysis information for Spectra/DataSources
  """
  #   from data model element ccpnmr.Analysis.AnalysisSpectrum revision ?
  _metaclass = metaPackage.getElement('AnalysisSpectrum')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'autoBaseLevel', 'autoLevelChanger', 'autoLevelMode', 'autoNumLevels', 'className', 'contourDir', 'fieldNames', 'font', 'inConstructor', 'isDeleted', 'metaclass', 'multipletPattern', 'negColors', 'negLevels', 'packageName', 'packageShortName', 'posColors', 'posLevels', 'qualifiedName', 'rank', 'shortcut', 'sliceColor', 'useBoundingBox', 'usePeakArrow', 'usePrecalculated', 'access', 'activeAccess', 'analysisDataDims', 'analysisPeakLists', 'analysisProject', 'dataSource', 'parent', 'root', 'spectrumWindowViews', 'storedContours', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['autoBaseLevel'] = 1.0
      dataDict['autoLevelChanger'] = 1.5
      dataDict['autoLevelMode'] = 'multiply'
      dataDict['autoNumLevels'] = 1
      dataDict['contourDir'] = None
      dataDict['font'] = None
      dataDict['multipletPattern'] = None
      dataDict['negColors'] = list()
      dataDict['negLevels'] = list()
      dataDict['posColors'] = list()
      dataDict['posLevels'] = list()
      dataDict['rank'] = 0
      dataDict['shortcut'] = None
      dataDict['sliceColor'] = '#000080'
      dataDict['useBoundingBox'] = True
      dataDict['usePeakArrow'] = True
      dataDict['usePrecalculated'] = False
      dataDict['access'] = None
      dataDict['analysisDataDims'] = {}
      dataDict['analysisPeakLists'] = {}
      dataDict['dataSource'] = None
      dataDict['spectrumWindowViews'] = set()
      dataDict['storedContours'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AnalysisSpectrum.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['storedContours'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('analysisSpectra')
        objKey = dataDict.get('dataSource')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['dataSource'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AnalysisSpectrum:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    analysisDataDims = dataDict.get('analysisDataDims').values()
    for analysisDataDim in analysisDataDims:
      if (not (analysisDataDim in objsToBeDeleted)):
        objsToBeDeleted.add(analysisDataDim)
        objsToBeChecked.append(analysisDataDim)

    analysisPeakLists = dataDict.get('analysisPeakLists').values()
    for analysisPeakList in analysisPeakLists:
      if (not (analysisPeakList in objsToBeDeleted)):
        objsToBeDeleted.add(analysisPeakList)
        objsToBeChecked.append(analysisPeakList)

    dataSource = dataDict.get('dataSource')
    if (dataSource is not None):
      topObject = dataSource.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    spectrumWindowViews = dataDict.get('spectrumWindowViews')
    for spectrumWindowView in spectrumWindowViews:
      if (not (spectrumWindowView in objsToBeDeleted)):
        objsToBeDeleted.add(spectrumWindowView)
        objsToBeChecked.append(spectrumWindowView)

    storedContours = dataDict.get('storedContours').values()
    for storedContour in storedContours:
      if (not (storedContour in objsToBeDeleted)):
        objsToBeDeleted.add(storedContour)
        objsToBeChecked.append(storedContour)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AnalysisSpectrum:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    dataSource = dataDict.get('dataSource')
    if ((dataSource is not None and not (dataSource in objsToBeDeleted))):
      dataSource.__dict__['analysisSpectrum'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('dataSource')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('analysisSpectra')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addNegColor(self, value):
    """
    Add for ccpnmr.Analysis.AnalysisSpectrum.negColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addNegColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.addNegColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.addNegColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNegColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNegColor:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNegColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addNegLevel(self, value):
    """
    Add for ccpnmr.Analysis.AnalysisSpectrum.negLevels
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addNegLevel:
       memops.Implementation.NegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addNegLevel:
       NegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value < 0)):
      raise ApiError("""%s.addNegLevel:
       NegativeFloat constraint value_lt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNegLevel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNegLevel:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNegLevel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addPosColor(self, value):
    """
    Add for ccpnmr.Analysis.AnalysisSpectrum.posColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addPosColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.addPosColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.addPosColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addPosColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addPosColor:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addPosColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addPosLevel(self, value):
    """
    Add for ccpnmr.Analysis.AnalysisSpectrum.posLevels
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addPosLevel:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.addPosLevel:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addPosLevel:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addPosLevel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addPosLevel:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addPosLevel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('analysisDataDims').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('analysisPeakLists').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('storedContours').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('dataSource')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('analysisSpectra')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('autoBaseLevel')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: autoBaseLevel:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: autoBaseLevel:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('autoLevelChanger')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: autoLevelChanger:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: autoLevelChanger:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('autoLevelMode')
      if (not (value in ['multiply', 'add'])):
        raise ApiError("""%s.checkValid: autoLevelMode:
         ccpnmr.Analysis.AutoLevelMode input is not in enumeration ['multiply', 'add']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: autoLevelMode:
         AutoLevelMode constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('autoNumLevels')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: autoNumLevels:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: autoNumLevels:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('contourDir')
      if (value is not None):
        from memops.api.Implementation import Url as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: contourDir:
           value is not of class memops.Implementation.Url""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('font')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: font:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: font:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: font:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: font:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('multipletPattern')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: multipletPattern:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: multipletPattern:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: multipletPattern:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: multipletPattern:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('negColors')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: negColors:
           memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
          raise ApiError("""%s.checkValid: negColors:
           RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value) == 7)):
          raise ApiError("""%s.checkValid: negColors:
           RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('negLevels')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: negLevels:
           memops.Implementation.NegativeFloat input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: negLevels:
           NegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value < 0)):
          raise ApiError("""%s.checkValid: negLevels:
           NegativeFloat constraint value_lt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('posColors')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: posColors:
           memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
          raise ApiError("""%s.checkValid: posColors:
           RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value) == 7)):
          raise ApiError("""%s.checkValid: posColors:
           RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('posLevels')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: posLevels:
           memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: posLevels:
           PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: posLevels:
           PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('rank')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: rank:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('shortcut')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: shortcut:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: shortcut:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: shortcut:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: shortcut:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('sliceColor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: sliceColor:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.checkValid: sliceColor:
         RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.checkValid: sliceColor:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useBoundingBox')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useBoundingBox:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('usePeakArrow')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: usePeakArrow:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('usePrecalculated')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: usePrecalculated:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('analysisDataDims').values()
      for value in values:
        if (not isinstance(value, AnalysisDataDim)):
          raise ApiError("""%s.checkValid: analysisDataDims:
           value is not of class ccpnmr.Analysis.AnalysisDataDim""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisSpectrum')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisDataDims:
           non-reciprocal link analysisDataDims from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('analysisPeakLists').values()
      for value in values:
        if (not isinstance(value, AnalysisPeakList)):
          raise ApiError("""%s.checkValid: analysisPeakLists:
           value is not of class ccpnmr.Analysis.AnalysisPeakList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisSpectrum')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisPeakLists:
           non-reciprocal link analysisPeakLists from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('dataSource')
      from ccp.api.nmr.Nmr import DataSource as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: dataSource:
         value is not of class ccp.nmr.Nmr.DataSource""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelf = value.__dict__.get('analysisSpectrum')
      if (not (oldSelf is self)):
        raise ApiError("""%s.checkValid: dataSource:
         non-reciprocal link dataSource from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('spectrumWindowViews')
      for value in values:
        if (not isinstance(value, SpectrumWindowView)):
          raise ApiError("""%s.checkValid: spectrumWindowViews:
           value is not of class ccpnmr.Analysis.SpectrumWindowView""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisSpectrum')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: spectrumWindowViews:
           non-reciprocal link spectrumWindowViews from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: spectrumWindowViews:
           Link spectrumWindowViews between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('storedContours').values()
      for value in values:
        if (not isinstance(value, StoredContour)):
          raise ApiError("""%s.checkValid: storedContours:
           value is not of class ccpnmr.Analysis.StoredContour""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisSpectrum')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: storedContours:
           non-reciprocal link storedContours from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('autoBaseLevel')
    if (value is None):
      raise ApiError("""%s.checkValid: autoBaseLevel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('autoLevelChanger')
    if (value is None):
      raise ApiError("""%s.checkValid: autoLevelChanger:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('autoLevelMode')
    if (value is None):
      raise ApiError("""%s.checkValid: autoLevelMode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('autoNumLevels')
    if (value is None):
      raise ApiError("""%s.checkValid: autoNumLevels:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('contourDir')
    if (value is not None):
      value.checkAllValid(complete)

    value = dataDict.get('font')
    value = dataDict.get('multipletPattern')
    values = dataDict.get('negColors')
    values = dataDict.get('negLevels')
    values = dataDict.get('posColors')
    values = dataDict.get('posLevels')
    value = dataDict.get('rank')
    if (value is None):
      raise ApiError("""%s.checkValid: rank:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('shortcut')
    value = dataDict.get('sliceColor')
    if (value is None):
      raise ApiError("""%s.checkValid: sliceColor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('useBoundingBox')
    if (value is None):
      raise ApiError("""%s.checkValid: useBoundingBox:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('usePeakArrow')
    if (value is None):
      raise ApiError("""%s.checkValid: usePeakArrow:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('usePrecalculated')
    if (value is None):
      raise ApiError("""%s.checkValid: usePrecalculated:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('analysisDataDims').values()
    values = dataDict.get('analysisPeakLists').values()
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('dataSource')
    if (value is None):
      raise ApiError("""%s.checkValid: dataSource:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('spectrumWindowViews')
    values = dataDict.get('storedContours').values()

  delete = memops.api.Implementation.DataObject.delete
  
  def findAllAnalysisDataDims(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisSpectrum.analysisDataDims
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('analysisDataDims').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('analysisDataDims').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('assignTolerance', 'chemShiftWeight', 'noeTolerance', 'peakFindBoxWidth', 'peakFindMinLineWidth', 'refSamplePlane', 'access', 'analysisSpectrum', 'dataDim',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAnalysisPeakLists(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisSpectrum.analysisPeakLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('analysisPeakLists').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('analysisPeakLists').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('noeIntensityType', 'noeRefDistance', 'noeRefIntensity', 'symbolColor', 'symbolStyle', 'textColor', 'access', 'analysisSpectrum', 'peakList',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllSpectrumWindowViews(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisSpectrum.spectrumWindowViews
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('spectrumWindowViews')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('spectrumWindowViews')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isContourLineVisible', 'isInToolbar', 'isNegVisible', 'isPosVisible', 'isSliceVisible', 'access', 'analysisSpectrum', 'spectrumWindowPane',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllStoredContours(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AnalysisSpectrum.storedContours
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('storedContours').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('storedContours').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('path', 'serial', 'access', 'analysisSpectrum',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findFirstAnalysisDataDim(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisSpectrum.analysisDataDims
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('analysisDataDims').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('dataDim')
      if (objKey is not None):
        result = dataDict.get('analysisDataDims').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('analysisDataDims').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('assignTolerance', 'chemShiftWeight', 'noeTolerance', 'peakFindBoxWidth', 'peakFindMinLineWidth', 'refSamplePlane', 'access', 'analysisSpectrum', 'dataDim',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAnalysisPeakList(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisSpectrum.analysisPeakLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('analysisPeakLists').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('peakList')
      if (objKey is not None):
        result = dataDict.get('analysisPeakLists').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('analysisPeakLists').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('noeIntensityType', 'noeRefDistance', 'noeRefIntensity', 'symbolColor', 'symbolStyle', 'textColor', 'access', 'analysisSpectrum', 'peakList',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstSpectrumWindowView(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisSpectrum.spectrumWindowViews
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('spectrumWindowViews')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('spectrumWindowViews')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isContourLineVisible', 'isInToolbar', 'isNegVisible', 'isPosVisible', 'isSliceVisible', 'access', 'analysisSpectrum', 'spectrumWindowPane',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstStoredContour(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AnalysisSpectrum.storedContours
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('storedContours').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('storedContours').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('storedContours').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('path', 'serial', 'access', 'analysisSpectrum',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisDataDims(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.analysisDataDims
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('analysisDataDims').values()
    result = frozenset(tempVar)
    return result
  
  def getAnalysisPeakLists(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.analysisPeakLists
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('analysisPeakLists').values()
    result = frozenset(tempVar)
    return result
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAutoBaseLevel(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.autoBaseLevel
    """
    dataDict = self.__dict__
    result = dataDict.get('autoBaseLevel')
    return result
  
  def getAutoLevelChanger(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.autoLevelChanger
    """
    dataDict = self.__dict__
    result = dataDict.get('autoLevelChanger')
    return result
  
  def getAutoLevelMode(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.autoLevelMode
    """
    dataDict = self.__dict__
    result = dataDict.get('autoLevelMode')
    return result
  
  def getAutoNumLevels(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.autoNumLevels
    """
    dataDict = self.__dict__
    result = dataDict.get('autoNumLevels')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AnalysisSpectrum
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisSpectrum'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AnalysisSpectrum'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('analysisSpectra').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getContourDir(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.contourDir
    """
    dataDict = self.__dict__
    result = dataDict.get('contourDir')
    return result
  
  def getDataSource(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.dataSource
    """
    dataDict = self.__dict__
    result = dataDict.get('dataSource')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFont(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.font
    """
    dataDict = self.__dict__
    result = dataDict.get('font')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('dataSource'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    result = dataDict.get('dataSource')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMultipletPattern(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.multipletPattern
    """
    dataDict = self.__dict__
    result = dataDict.get('multipletPattern')
    return result
  
  def getNegColors(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.negColors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('negColors')
    result = tuple(tempVar)
    return result
  
  def getNegLevels(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.negLevels
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('negLevels')
    result = tuple(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result
  
  def getPosColors(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.posColors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('posColors')
    result = tuple(tempVar)
    return result
  
  def getPosLevels(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.posLevels
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('posLevels')
    result = tuple(tempVar)
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRank(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.rank
    """
    dataDict = self.__dict__
    result = dataDict.get('rank')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getShortcut(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.shortcut
    """
    dataDict = self.__dict__
    result = dataDict.get('shortcut')
    return result
  
  def getSliceColor(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.sliceColor
    """
    dataDict = self.__dict__
    result = dataDict.get('sliceColor')
    return result
  
  def getSpectrumWindowViews(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.spectrumWindowViews
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('spectrumWindowViews')
    result = frozenset(tempVar)
    return result
  
  def getStoredContours(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.storedContours
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('storedContours').values()
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getUseBoundingBox(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.useBoundingBox
    """
    dataDict = self.__dict__
    result = dataDict.get('useBoundingBox')
    return result
  
  def getUsePeakArrow(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.usePeakArrow
    """
    dataDict = self.__dict__
    result = dataDict.get('usePeakArrow')
    return result
  
  def getUsePrecalculated(self):
    """
    Get for ccpnmr.Analysis.AnalysisSpectrum.usePrecalculated
    """
    dataDict = self.__dict__
    result = dataDict.get('usePrecalculated')
    return result
  
  def newAnalysisDataDim(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AnalysisDataDim
    """
    return AnalysisDataDim(self, **attrlinks)
  
  def newAnalysisPeakList(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AnalysisPeakList
    """
    return AnalysisPeakList(self, **attrlinks)
  
  def newStoredContour(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.StoredContour
    """
    return StoredContour(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeNegColor(self, value):
    """
    Remove for ccpnmr.Analysis.AnalysisSpectrum.negColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeNegColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.removeNegColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.removeNegColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNegColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNegColor:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNegColor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNegColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeNegLevel(self, value):
    """
    Remove for ccpnmr.Analysis.AnalysisSpectrum.negLevels
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removeNegLevel:
       memops.Implementation.NegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removeNegLevel:
       NegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value < 0)):
      raise ApiError("""%s.removeNegLevel:
       NegativeFloat constraint value_lt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNegLevel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNegLevel:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNegLevel:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNegLevel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removePosColor(self, value):
    """
    Remove for ccpnmr.Analysis.AnalysisSpectrum.posColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removePosColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.removePosColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.removePosColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removePosColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removePosColor:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removePosColor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removePosColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removePosLevel(self, value):
    """
    Remove for ccpnmr.Analysis.AnalysisSpectrum.posLevels
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removePosLevel:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.removePosLevel:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removePosLevel:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removePosLevel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removePosLevel:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removePosLevel:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removePosLevel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AnalysisSpectrum
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAutoBaseLevel(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.autoBaseLevel
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAutoBaseLevel:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAutoBaseLevel:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('autoBaseLevel')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAutoBaseLevel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAutoBaseLevel:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAutoBaseLevel:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['autoBaseLevel'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAutoBaseLevel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAutoLevelChanger(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.autoLevelChanger
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAutoLevelChanger:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAutoLevelChanger:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('autoLevelChanger')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAutoLevelChanger:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAutoLevelChanger:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAutoLevelChanger:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['autoLevelChanger'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAutoLevelChanger')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAutoLevelMode(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.autoLevelMode
    """
    dataDict = self.__dict__
    if (not (value in ['multiply', 'add'])):
      raise ApiError("""%s.setAutoLevelMode:
       ccpnmr.Analysis.AutoLevelMode input is not in enumeration ['multiply', 'add']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setAutoLevelMode:
       AutoLevelMode constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('autoLevelMode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAutoLevelMode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAutoLevelMode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAutoLevelMode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['autoLevelMode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAutoLevelMode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAutoNumLevels(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.autoNumLevels
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setAutoNumLevels:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setAutoNumLevels:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('autoNumLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAutoNumLevels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAutoNumLevels:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAutoNumLevels:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['autoNumLevels'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAutoNumLevels')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setContourDir(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.contourDir
    """
    dataDict = self.__dict__
    if (value is not None):
      from memops.api.Implementation import Url as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setContourDir:
         value is not of class memops.Implementation.Url""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('contourDir')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setContourDir:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setContourDir:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['contourDir'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setContourDir')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDataSource(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.dataSource
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import DataSource as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setDataSource:
       value is not of class ccp.nmr.Nmr.DataSource""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataSource')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccpnmr.Analysis')
      tobjList = set(root.__dict__.get('analysisProjects').values())
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataSource:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDataSource:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDataSource:
         cannot set dataSource, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDataSource:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value.__dict__.get('analysisSpectrum') is None):
        xx1 = value.__dict__.get('topObject')
        if (xx1.__dict__.get('analysisProject') is None):
          root = dataDict.get('topObject').__dict__.get('memopsRoot')
          root.refreshTopObjects('ccpnmr.Analysis')

        tobj = xx1.__dict__.get('analysisProject')
        if (tobj is not None):
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      oldSelf = value.__dict__.get('analysisSpectrum')
      if (oldSelf is not None):
        raise ApiError("""%s.setDataSource:
         oldSelf must be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      xx2 = xx1.__dict__.get('nmrProject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx2 is yy1)):
        raise ApiError("""%s.setDataSource:
         Link dataSource between objects from separate partitions
         - ccpnmr.Analysis.AnalysisProject.nmrProject not set correctly""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      currentValue.__dict__['analysisSpectrum'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('analysisSpectrum')
      if (oldSelf is not None):
        oldSelf.__dict__['dataSource'] = None

      value.__dict__['analysisSpectrum'] = self

    dataDict['dataSource'] = value

    # doNotifies
  
  def setFont(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.font
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFont:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setFont:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFont:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFont:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('font')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFont:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFont:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['font'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFont')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMultipletPattern(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.multipletPattern
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMultipletPattern:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setMultipletPattern:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMultipletPattern:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setMultipletPattern:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('multipletPattern')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMultipletPattern:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMultipletPattern:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['multipletPattern'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMultipletPattern')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNegColors(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.negColors
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setNegColors:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.setNegColors:
         RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.setNegColors:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNegColors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNegColors:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['negColors'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNegColors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNegLevels(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.negLevels
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setNegLevels:
         memops.Implementation.NegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setNegLevels:
         NegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value < 0)):
        raise ApiError("""%s.setNegLevels:
         NegativeFloat constraint value_lt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNegLevels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNegLevels:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['negLevels'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNegLevels')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPosColors(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.posColors
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPosColors:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.setPosColors:
         RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.setPosColors:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPosColors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPosColors:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['posColors'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPosColors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPosLevels(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.posLevels
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setPosLevels:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setPosLevels:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setPosLevels:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posLevels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPosLevels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPosLevels:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['posLevels'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPosLevels')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRank(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.rank
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setRank:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('rank')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRank:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRank:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRank:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['rank'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRank')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setShortcut(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.shortcut
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setShortcut:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setShortcut:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setShortcut:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setShortcut:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('shortcut')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setShortcut:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShortcut:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['shortcut'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setShortcut')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSliceColor(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.sliceColor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSliceColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.setSliceColor:
       RgbColor constraint HexStringFormat violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.setSliceColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('sliceColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSliceColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSliceColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSliceColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['sliceColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSliceColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSpectrumWindowViews(self, values):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.spectrumWindowViews
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSpectrumWindowViews:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, SpectrumWindowView)):
        raise ApiError("""%s.setSpectrumWindowViews:
         value is not of class ccpnmr.Analysis.SpectrumWindowView""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('spectrumWindowViews')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSpectrumWindowViews:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSpectrumWindowViews:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSpectrumWindowViews:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setSpectrumWindowViews:
           locard analysisSpectrum: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSpectrumWindowViews:
           Link spectrumWindowViews between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['analysisSpectrum'] = self

    dataDict['spectrumWindowViews'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSpectrumWindowViews')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseBoundingBox(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.useBoundingBox
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUseBoundingBox:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('useBoundingBox')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseBoundingBox:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseBoundingBox:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUseBoundingBox:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['useBoundingBox'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseBoundingBox')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUsePeakArrow(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.usePeakArrow
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUsePeakArrow:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('usePeakArrow')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUsePeakArrow:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUsePeakArrow:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUsePeakArrow:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['usePeakArrow'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUsePeakArrow')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUsePrecalculated(self, value):
    """
    Set for ccpnmr.Analysis.AnalysisSpectrum.usePrecalculated
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUsePrecalculated:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('usePrecalculated')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUsePrecalculated:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUsePrecalculated:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUsePrecalculated:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['usePrecalculated'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUsePrecalculated')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAnalysisDataDims(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisSpectrum.analysisDataDims
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('analysisDataDims')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAnalysisPeakLists(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisSpectrum.analysisPeakLists
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('analysisPeakLists')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedSpectrumWindowViews(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisSpectrum.spectrumWindowViews
    """
    dataDict = self.__dict__
    ll = dataDict.get('spectrumWindowViews')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedStoredContours(self):
    """
    Sorted for ccpnmr.Analysis.AnalysisSpectrum.storedContours
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('storedContours')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  autoBaseLevel = property(getAutoBaseLevel, setAutoBaseLevel, None,
  r"""Base contour level for automatic contour level setting
  """)
  
  autoLevelChanger = property(getAutoLevelChanger, setAutoLevelChanger, None,
  r"""Level change constant for automatic contour level setting
  """)
  
  autoLevelMode = property(getAutoLevelMode, setAutoLevelMode, None,
  r"""Auto contour level setting mode
  """)
  
  autoNumLevels = property(getAutoNumLevels, setAutoNumLevels, None,
  r"""Number of contour levels for automatic setting.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  contourDir = property(getContourDir, setContourDir, None,
  r"""Contour file directory
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  font = property(getFont, setFont, None,
  r"""font for use in spectrum display (and printing?).
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  multipletPattern = property(getMultipletPattern, setMultipletPattern, None,
  r"""Multiplet pattern of spectrum
  """)
  
  negColors = property(getNegColors, setNegColors, None,
  r"""Colors for negative contours - in order
  """)
  
  negLevels = property(getNegLevels, setNegLevels, None,
  r"""Negative contour levels
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  posColors = property(getPosColors, setPosColors, None,
  r"""Colors for positive contours - in order
  """)
  
  posLevels = property(getPosLevels, setPosLevels, None,
  r"""Positive contour levels
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  rank = property(getRank, setRank, None,
  r"""Priority order for spectra (contours) in displays
  """)
  
  shortcut = property(getShortcut, setShortcut, None,
  r"""Keyboard Shortcut
  """)
  
  sliceColor = property(getSliceColor, setSliceColor, None,
  r"""Spectrum slice color
  """)
  
  useBoundingBox = property(getUseBoundingBox, setUseBoundingBox, None,
  r"""Use bounding box in display
  """)
  
  usePeakArrow = property(getUsePeakArrow, setUsePeakArrow, None,
  r"""Use arrows for peak anotations
  """)
  
  usePrecalculated = property(getUsePrecalculated, setUsePrecalculated, None,
  r"""Use pre-calculated contours
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisDataDims = property(getAnalysisDataDims,  None, None,
  r"""child link to class AnalysisDataDim
  """)
  
  analysisPeakLists = property(getAnalysisPeakLists,  None, None,
  r"""child link to class AnalysisPeakList
  """)
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  dataSource = property(getDataSource, setDataSource, None,
  r"""DataSource that AnalysisSPectrum refers to - key to class
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  spectrumWindowViews = property(getSpectrumWindowViews, setSpectrumWindowViews, None,
  r"""SpectrumWIndowViews viewing this Spectrum
  """)
  
  storedContours = property(getStoredContours,  None, None,
  r"""child link to class StoredContour
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AtomSetMapping(memops.api.Implementation.DataObject):
  r"""Stores (pseudo)atom and residue name to use for display, graphical user 
interfaces etc., and links to appropriate Residue, AtomSets, and 
ChemAtomSet.

NB the various links are not independent, and the API does 
*not* guarantee consistency. It is up to CcpNmr Analysis to make sure 
the information is up-to-date. This behaviour is only tolerated because 
this is a program-specific part of the model. 
  """
  #   from data model element ccpnmr.Analysis.AtomSetMapping revision ?
  _metaclass = metaPackage.getElement('AtomSetMapping')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'atomSetSerials', 'className', 'elementSymbol', 'fieldNames', 'inConstructor', 'isDeleted', 'mappingType', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'resonanceSerials', 'access', 'activeAccess', 'atomSetMappings', 'atomSets', 'chemAtomSet', 'parent', 'residueMapping', 'resonances', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    dataDict['residueMapping'] = parent
    if (not isinstance(parent, ResidueMapping)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.ResidueMapping""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['atomSetSerials'] = set()
      dataDict['elementSymbol'] = None
      dataDict['mappingType'] = 'simple'
      dataDict['name'] = None
      dataDict['resonanceSerials'] = set()
      dataDict['access'] = None
      dataDict['atomSetMappings'] = set()
      dataDict['chemAtomSet'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AtomSetMapping.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('atomSetMappings')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        
        
        # automatic set self.elementSymbol.
        # Based on all atoms in an atomSet being of the same type.
        if not self.elementSymbol:
          ll = [self]
          elements = set()
          for x in ll:
            for y in x.atomSetMappings:
              ll.append(y)
            for z in x.atomSets:
              elements.add(z.findFirstAtom().chemAtom.elementSymbol)
        
          element = elements.pop()
          if elements:
            raise ApiError("creating AtomSetMapping combining different chemical elements")
        
          self.elementSymbol = element

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AtomSetMapping:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AtomSetMapping:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    residueMapping = dataDict.get('residueMapping')
    if (not (residueMapping in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = residueMapping.__dict__.get('atomSetMappings')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAtomSetMapping(self, value):
    """
    Add for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    if (not isinstance(value, AtomSetMapping)):
      raise ApiError("""%s.addAtomSetMapping:
       value is not of class ccpnmr.Analysis.AtomSetMapping""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetMappings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAtomSetMapping:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAtomSetMapping:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAtomSetMapping:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAtomSetMapping:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAtomSetMapping:
           Link atomSetMappings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          isValid = True
          ll = [value]
          for vv in ll:
            if vv is self:
              isValid = False
              break
            else:
              ll.extend(vv.atomSetMappings)
          if (not (isValid)):
            raise ApiError("""%s.addAtomSetMapping:
             atomSetMappings constraint no_atomSetMapping_cycles violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAtomSetMapping')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addAtomSetSerial(self, value):
    """
    Add for ccpnmr.Analysis.AtomSetMapping.atomSetSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.addAtomSetSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAtomSetSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAtomSetSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAtomSetSerial:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAtomSetSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addResonanceSerial(self, value):
    """
    Add for ccpnmr.Analysis.AtomSetMapping.resonanceSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.addResonanceSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('resonanceSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResonanceSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResonanceSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addResonanceSerial:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addResonanceSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('residueMapping')
        dd = value.__dict__.get('atomSetMappings')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'residueMapping' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('atomSetSerials')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          values.remove(value)
          if (castValue in values):
            values.add(value)
            raise ApiError("""%s.checkValid: atomSetSerials:
             replacement value already in unique collection """ % self.qualifiedName
             + ": %s" % (castValue,)
            )
          else:
            values.add(castValue)

          value = castValue
        else:
          raise ApiError("""%s.checkValid: atomSetSerials:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('elementSymbol')
      if (value is None):
        raise ApiError("""%s.checkValid: elementSymbol:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: elementSymbol:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value is None or len(value) in (1, 2))):
        raise ApiError("""%s.checkValid: elementSymbol:
         elementSymbol constraint length_is_one_or_two violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('mappingType')
      if (not (value in ['simple', 'stereo', 'nonstereo', 'ambiguous'])):
        raise ApiError("""%s.checkValid: mappingType:
         ccpnmr.Analysis.MappingType input is not in enumeration ['simple', 'stereo', 'nonstereo', 'ambiguous']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: mappingType:
         MappingType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('resonanceSerials')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          values.remove(value)
          if (castValue in values):
            values.add(value)
            raise ApiError("""%s.checkValid: resonanceSerials:
             replacement value already in unique collection """ % self.qualifiedName
             + ": %s" % (castValue,)
            )
          else:
            values.add(castValue)

          value = castValue
        else:
          raise ApiError("""%s.checkValid: resonanceSerials:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('atomSetMappings')
      for value in values:
        if (not isinstance(value, AtomSetMapping)):
          raise ApiError("""%s.checkValid: atomSetMappings:
           value is not of class ccpnmr.Analysis.AtomSetMapping""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: atomSetMappings:
           Link atomSetMappings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getAtomSets()
      for value in values:
        from ccp.api.nmr.Nmr import AtomSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: atomSets:
           value is not of class ccp.nmr.Nmr.AtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        xx2 = xx1.__dict__.get('nmrProject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx2 is yy1)):
          raise ApiError("""%s.checkValid: atomSets:
           Link atomSets between objects from separate partitions
           - ccpnmr.Analysis.AnalysisProject.nmrProject not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemAtomSet')
      if (value is not None):
        from ccp.api.molecule.ChemComp import ChemAtomSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemAtomSet:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtomSet:
           Link chemAtomSet between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('residueMapping')
      if (not isinstance(value, ResidueMapping)):
        raise ApiError("""%s.checkValid: residueMapping:
         value is not of class ccpnmr.Analysis.ResidueMapping""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getResonances()
      for value in values:
        from ccp.api.nmr.Nmr import Resonance as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: resonances:
           value is not of class ccp.nmr.Nmr.Resonance""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        xx2 = xx1.__dict__.get('nmrProject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx2 is yy1)):
          raise ApiError("""%s.checkValid: resonances:
           Link resonances between objects from separate partitions
           - ccpnmr.Analysis.AnalysisProject.nmrProject not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    if (not (self.mappingType == 'ambiguous' or not self.atomSetMappings)):
      raise ApiError("""%s.checkValid:
       constraint only_ambiguous_can_have_atomSetMappings violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('atomSetSerials')
    value = dataDict.get('mappingType')
    if (value is None):
      raise ApiError("""%s.checkValid: mappingType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('resonanceSerials')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('atomSetMappings')
    for value in values:
      isValid = True
      ll = [value]
      for vv in ll:
        if vv is self:
          isValid = False
          break
        else:
          ll.extend(vv.atomSetMappings)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: atomSetMappings:
         atomSetMappings constraint no_atomSetMapping_cycles violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('chemAtomSet')
    value = dataDict.get('residueMapping')
    if (value is None):
      raise ApiError("""%s.checkValid: residueMapping:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAtomSetMappings(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSetMappings')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atomSetMappings')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'mappingType', 'name', 'access', 'chemAtomSet', 'residueMapping',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAtomSets(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AtomSetMapping.atomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getAtomSets()
      result = set(currentValues)

    else:
      currentValues = self.getAtomSets()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResonances(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AtomSetMapping.resonances
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getResonances()
      result = set(currentValues)

    else:
      currentValues = self.getResonances()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'isotopeCode', 'name', 'serial', 'access', 'nmrProject', 'resonanceGroup', 'resonanceSet',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAtomSet(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AtomSetMapping.atomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getAtomSets()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getAtomSets()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAtomSetMapping(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSetMappings')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('atomSetMappings')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'mappingType', 'name', 'access', 'chemAtomSet', 'residueMapping',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResonance(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AtomSetMapping.resonances
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getResonances()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getResonances()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'isotopeCode', 'name', 'serial', 'access', 'nmrProject', 'resonanceGroup', 'resonanceSet',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomSetMappings(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomSetMappings')
    result = frozenset(tempVar)
    return result
  
  def getAtomSetSerials(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.atomSetSerials
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomSetSerials')
    result = frozenset(tempVar)
    return result
  
  def getAtomSets(self):
    """
    getter for derived link atomSets
    """
    dataDict = self.__dict__
    func = self.topObject.nmrProject.findFirstAtomSet
    aset = set(func(serial=x) for x in self.atomSetSerials)
    if None in aset:
      aset.remove(None)
    result = frozenset(aset)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AtomSetMapping
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AtomSetMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (4 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AtomSetMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-4]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-3]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chainMappings').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('residueMappings').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('atomSetMappings').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtomSet(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.chemAtomSet
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtomSet')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getElementSymbol(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.elementSymbol
    """
    dataDict = self.__dict__
    result = dataDict.get('elementSymbol')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('residueMapping')
    obj2 = obj3.__dict__.get('chainMapping')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('molSystemCode'))
    result.append(obj2.__dict__.get('chainCode'))
    result.append(obj3.__dict__.get('seqId'))
    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMappingType(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.mappingType
    """
    dataDict = self.__dict__
    result = dataDict.get('mappingType')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('residueMapping')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidueMapping(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.residueMapping
    """
    dataDict = self.__dict__
    result = dataDict.get('residueMapping')
    return result
  
  def getResonanceSerials(self):
    """
    Get for ccpnmr.Analysis.AtomSetMapping.resonanceSerials
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('resonanceSerials')
    result = frozenset(tempVar)
    return result
  
  def getResonances(self):
    """
    getter for derived link resonances
    """
    dataDict = self.__dict__
    func = self.topObject.nmrProject.findFirstResonance
    aset = set(func(serial=x) for x in self.resonanceSerials)
    if None in aset:
      aset.remove(None)
    result = frozenset(aset)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAtomSetMapping(self, value):
    """
    Remove for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    if (not isinstance(value, AtomSetMapping)):
      raise ApiError("""%s.removeAtomSetMapping:
       value is not of class ccpnmr.Analysis.AtomSetMapping""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetMappings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAtomSetMapping:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAtomSetMapping:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAtomSetMapping:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAtomSetMapping:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAtomSetMapping')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeAtomSetSerial(self, value):
    """
    Remove for ccpnmr.Analysis.AtomSetMapping.atomSetSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.removeAtomSetSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAtomSetSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAtomSetSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAtomSetSerial:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAtomSetSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeResonanceSerial(self, value):
    """
    Remove for ccpnmr.Analysis.AtomSetMapping.resonanceSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.removeResonanceSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('resonanceSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResonanceSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResonanceSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResonanceSerial:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeResonanceSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AtomSetMapping
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtomSetMappings(self, values):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAtomSetMappings:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AtomSetMapping)):
        raise ApiError("""%s.setAtomSetMappings:
         value is not of class ccpnmr.Analysis.AtomSetMapping""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetMappings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomSetMappings:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomSetMappings:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtomSetMappings:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtomSetMappings:
           Link atomSetMappings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          isValid = True
          ll = [value]
          for vv in ll:
            if vv is self:
              isValid = False
              break
            else:
              ll.extend(vv.atomSetMappings)
          if (not (isValid)):
            raise ApiError("""%s.setAtomSetMappings:
             atomSetMappings constraint no_atomSetMapping_cycles violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['atomSetMappings'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomSetMappings')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAtomSetSerials(self, values):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.atomSetSerials
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAtomSetSerials:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        values.remove(value)
        if (castValue in values):
          values.add(value)
          raise ApiError("""%s.setAtomSetSerials:
           replacement value already in unique collection """ % self.qualifiedName
           + ": %s" % (castValue,)
          )
        else:
          values.add(castValue)

        value = castValue
      else:
        raise ApiError("""%s.setAtomSetSerials:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomSetSerials:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomSetSerials:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['atomSetSerials'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomSetSerials')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemAtomSet(self, value):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.chemAtomSet
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.ChemComp import ChemAtomSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChemAtomSet:
         value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemAtomSet')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtomSet:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtomSet:
           Link chemAtomSet between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['chemAtomSet'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setElementSymbol(self, value):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.elementSymbol
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setElementSymbol:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('elementSymbol')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setElementSymbol:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setElementSymbol:
         cannot set elementSymbol, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setElementSymbol:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (value is None or len(value) in (1, 2))):
            raise ApiError("""%s.setElementSymbol:
             elementSymbol constraint length_is_one_or_two violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['elementSymbol'] = value

    # doNotifies
  
  def setMappingType(self, value):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.mappingType
    """
    dataDict = self.__dict__
    if (not (value in ['simple', 'stereo', 'nonstereo', 'ambiguous'])):
      raise ApiError("""%s.setMappingType:
       ccpnmr.Analysis.MappingType input is not in enumeration ['simple', 'stereo', 'nonstereo', 'ambiguous']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMappingType:
       MappingType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('mappingType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMappingType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMappingType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMappingType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['mappingType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMappingType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setResonanceSerials(self, values):
    """
    Set for ccpnmr.Analysis.AtomSetMapping.resonanceSerials
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResonanceSerials:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        values.remove(value)
        if (castValue in values):
          values.add(value)
          raise ApiError("""%s.setResonanceSerials:
           replacement value already in unique collection """ % self.qualifiedName
           + ": %s" % (castValue,)
          )
        else:
          values.add(castValue)

        value = castValue
      else:
        raise ApiError("""%s.setResonanceSerials:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('resonanceSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResonanceSerials:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResonanceSerials:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['resonanceSerials'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResonanceSerials')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAtomSetMappings(self):
    """
    Sorted for ccpnmr.Analysis.AtomSetMapping.atomSetMappings
    """
    dataDict = self.__dict__
    ll = dataDict.get('atomSetMappings')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedAtomSets(self):
    """
    Sorted for ccpnmr.Analysis.AtomSetMapping.atomSets
    """
    dataDict = self.__dict__
    ll = self.getAtomSets()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedResonances(self):
    """
    Sorted for ccpnmr.Analysis.AtomSetMapping.resonances
    """
    dataDict = self.__dict__
    ll = self.getResonances()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  atomSetSerials = property(getAtomSetSerials, setAtomSetSerials, None,
  r"""serial numbers of atomSets represented by the mapping
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  elementSymbol = property(getElementSymbol, setElementSymbol, None,
  r"""Element symbol of element corresponding to AtomSets. Automatically 
  calculated at creation time.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  mappingType = property(getMappingType, setMappingType, None,
  r"""whether the mapping is simple, ambiguous (points to multiple other 
  mappings), nonstereo (non-stereospecific prochiral like Hba or Hbb) or 
  stereo (like Hb2 or Hb3)
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""(pseudo)atom name.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  resonanceSerials = property(getResonanceSerials, setResonanceSerials, None,
  r"""serial numbers of resonances represented by the mapping, keys for 
  derived link
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atomSetMappings = property(getAtomSetMappings, setAtomSetMappings, None,
  r"""the AtomSetMappings contained by the AtomSetMapping, often used to 
  specify that an ambiguous mapping contains non-ambiguous mappings
  """)
  
  atomSets = property(getAtomSets, None, None,
  r"""the AtomSet represented by the AtomSetMapping 
  """)
  
  chemAtomSet = property(getChemAtomSet, setChemAtomSet, None,
  r"""the ChemAtomSet represented by the AtomSetMapping 
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for residueMapping
  """)
  
  residueMapping = property(getResidueMapping,  None, None,
  r"""parent link
  """)
  
  resonances = property(getResonances, None, None,
  r"""Resonances that AtomSetMapping is associated with. This link does not 
  have to be filled in.
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AxisMapping(memops.api.Implementation.DataObject):
  r"""Mapping of AxisLabel to AnalysisDataDim
  """
  #   from data model element ccpnmr.Analysis.AxisMapping revision ?
  _metaclass = metaPackage.getElement('AxisMapping')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'label', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'analysisDataDim', 'axisPanel', 'parent', 'root', 'spectrumWindowView', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    dataDict['spectrumWindowView'] = parent
    if (not isinstance(parent, SpectrumWindowView)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.SpectrumWindowView""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['label'] = None
      dataDict['access'] = None
      dataDict['analysisDataDim'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AxisMapping.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('axisMappings')
        objKey = dataDict.get('label')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['label'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AxisMapping:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AxisMapping:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisDataDim = dataDict.get('analysisDataDim')
    if ((analysisDataDim is not None and not (analysisDataDim in objsToBeDeleted))):
      axisMappings = analysisDataDim.__dict__.get('axisMappings')
      axisMappings.remove(self)

    spectrumWindowView = dataDict.get('spectrumWindowView')
    if (not (spectrumWindowView in objsToBeDeleted)):
      objKey = dataDict.get('label')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = spectrumWindowView.__dict__.get('axisMappings')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('label')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('spectrumWindowView')
        dd = value.__dict__.get('axisMappings')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'spectrumWindowView' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('label')
      if (not (value in ['x', 'y', 'z1', 'z2', 'z3', 'z4', 'z5', 'z6', 'z7', 'z8'])):
        raise ApiError("""%s.checkValid: label:
         ccpnmr.Analysis.AxisLabel input is not in enumeration ['x', 'y', 'z1', 'z2', 'z3', 'z4', 'z5', 'z6', 'z7', 'z8']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = True
      if not value:
        isValid = False
      elif value[0] not in 'abcdefghjiklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ':
        isValid = False
      else:
        for cc in value[1:]:
          if cc not in 'abcdefghjiklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789':
            isValid = False
            break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: label:
         AxisLabel constraint name_type_characters violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisDataDim')
      if (not isinstance(value, AnalysisDataDim)):
        raise ApiError("""%s.checkValid: analysisDataDim:
         value is not of class ccpnmr.Analysis.AnalysisDataDim""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('axisMappings')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: analysisDataDim:
         non-reciprocal link analysisDataDim from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = self.getAxisPanel()
      if (value is not None):
        if (not isinstance(value, AxisPanel)):
          raise ApiError("""%s.checkValid: axisPanel:
           value is not of class ccpnmr.Analysis.AxisPanel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: axisPanel:
           Link axisPanel between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('spectrumWindowView')
      if (not isinstance(value, SpectrumWindowView)):
        raise ApiError("""%s.checkValid: spectrumWindowView:
         value is not of class ccpnmr.Analysis.SpectrumWindowView""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('label')
    if (value is None):
      raise ApiError("""%s.checkValid: label:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisDataDim')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisDataDim:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('spectrumWindowView')
    if (value is None):
      raise ApiError("""%s.checkValid: spectrumWindowView:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisDataDim(self):
    """
    Get for ccpnmr.Analysis.AxisMapping.analysisDataDim
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisDataDim')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAxisPanel(self):
    """
    getter for derived link axisPanel
    """
    dataDict = self.__dict__
    result = self.spectrumWindowView.spectrumWindowPane.findFirstAxisPanel(label=self.label)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AxisMapping
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (4 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-4]
      obj2 = obj1.__dict__.get('spectrumWindows').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-3]
        obj3 = obj2.__dict__.get('spectrumWindowPanes').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-2]
          obj4 = obj3.__dict__.get('spectrumWindowViews').get(objKey)

          if (obj4 is not None):
            objKey = fullKey[-1]
            obj5 = obj4.__dict__.get('axisMappings').get(objKey)
            result = obj5

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    result = list()

    obj4 = dataDict.get('spectrumWindowView')
    obj3 = obj4.__dict__.get('spectrumWindowPane')
    obj2 = obj3.__dict__.get('spectrumWindow')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(obj3.__dict__.get('serial'))
    result.append(obj4.__dict__.get('analysisSpectrum'))
    result.append(dataDict.get('label'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLabel(self):
    """
    Get for ccpnmr.Analysis.AxisMapping.label
    """
    dataDict = self.__dict__
    result = dataDict.get('label')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    result = dataDict.get('label')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AxisMapping.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('spectrumWindowView')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSpectrumWindowView(self):
    """
    Get for ccpnmr.Analysis.AxisMapping.spectrumWindowView
    """
    dataDict = self.__dict__
    result = dataDict.get('spectrumWindowView')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AxisMapping
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAnalysisDataDim(self, value):
    """
    Set for ccpnmr.Analysis.AxisMapping.analysisDataDim
    """
    dataDict = self.__dict__
    if (not isinstance(value, AnalysisDataDim)):
      raise ApiError("""%s.setAnalysisDataDim:
       value is not of class ccpnmr.Analysis.AnalysisDataDim""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('analysisDataDim')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisDataDim:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisDataDim:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnalysisDataDim:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAnalysisDataDim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setAnalysisDataDim:
         Link analysisDataDim between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('axisMappings')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAnalysisDataDim:
         Read link 'analysisDataDim' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('axisMappings')
      newSelves.add(self)

    dataDict['analysisDataDim'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisDataDim')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setLabel(self, value):
    """
    Set for ccpnmr.Analysis.AxisMapping.label
    """
    dataDict = self.__dict__
    if (not (value in ['x', 'y', 'z1', 'z2', 'z3', 'z4', 'z5', 'z6', 'z7', 'z8'])):
      raise ApiError("""%s.setLabel:
       ccpnmr.Analysis.AxisLabel input is not in enumeration ['x', 'y', 'z1', 'z2', 'z3', 'z4', 'z5', 'z6', 'z7', 'z8']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    isValid = True
    if not value:
      isValid = False
    elif value[0] not in 'abcdefghjiklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ':
      isValid = False
    else:
      for cc in value[1:]:
        if cc not in 'abcdefghjiklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789':
          isValid = False
          break
    if (not (isValid)):
      raise ApiError("""%s.setLabel:
       AxisLabel constraint name_type_characters violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('label')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLabel:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLabel:
         cannot set label, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLabel:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['label'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  label = property(getLabel, setLabel, None,
  r"""The axis label being mapped.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisDataDim = property(getAnalysisDataDim, setAnalysisDataDim, None,
  r"""DataDim Currently on axis
  """)
  
  axisPanel = property(getAxisPanel, None, None,
  r"""AxisPanel corresponding to AxisMapping
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for spectrumWindowView
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  spectrumWindowView = property(getSpectrumWindowView,  None, None,
  r"""parent link
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AxisRegion(memops.api.Implementation.DataObject):
  r"""This corresponds to one region of an AxisPanel.
  """
  #   from data model element ccpnmr.Analysis.AxisRegion revision ?
  _metaclass = metaPackage.getElement('AxisRegion')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isActive', 'isDeleted', 'metaclass', 'overrideRegion', 'packageName', 'packageShortName', 'qualifiedName', 'region', 'serial', 'size', 'access', 'activeAccess', 'axisPanel', 'axisRegionGroup', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    dataDict['axisPanel'] = parent
    if (not isinstance(parent, AxisPanel)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AxisPanel""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['isActive'] = True
      dataDict['overrideRegion'] = list()
      dataDict['region'] = [0.0, 1.0]
      dataDict['serial'] = None
      dataDict['size'] = 500
      dataDict['access'] = None
      dataDict['axisRegionGroup'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AxisRegion.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccpnmr.Analysis.AxisRegion')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('axisRegions')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AxisRegion:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    axisPanel = dataDict.get('axisPanel')
    if (axisPanel is not None):
      if (not (axisPanel in objsToBeDeleted)):
        backlink = set(axisPanel.__dict__.get('axisRegions').values())
        key = (axisPanel, 'axisRegions')
        nFound = linkCounter.get(key)
        if (nFound is None):
          nFound = 1
        else:
          nFound = nFound + 1
          del linkCounter[key]

        if (len(backlink) - nFound < 1):
          objsToBeDeleted.add(axisPanel)
          objsToBeChecked.append(axisPanel)
        else:
          linkCounter[key] = nFound

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AxisRegion:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    axisRegionGroup = dataDict.get('axisRegionGroup')
    if ((axisRegionGroup is not None and not (axisRegionGroup in objsToBeDeleted))):
      axisRegions = axisRegionGroup.__dict__.get('axisRegions')
      axisRegions.remove(self)

    axisPanel = dataDict.get('axisPanel')
    if (not (axisPanel in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = axisPanel.__dict__.get('axisRegions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addOverrideRegion(self, value):
    """
    Add for ccpnmr.Analysis.AxisRegion.overrideRegion
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.addOverrideRegion:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.addOverrideRegion:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('overrideRegion')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addOverrideRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addOverrideRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      if (len(currentValues) >= 2):
        raise ApiError("""%s.addOverrideRegion:
         hicard: currentValues: cannot add value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addOverrideRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('axisPanel')
        dd = value.__dict__.get('axisRegions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'axisPanel' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isActive')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isActive:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('overrideRegion')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: overrideRegion:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: overrideRegion:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('region')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: region:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: region:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('size')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('axisPanel')
      if (not isinstance(value, AxisPanel)):
        raise ApiError("""%s.checkValid: axisPanel:
         value is not of class ccpnmr.Analysis.AxisPanel""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('axisRegionGroup')
      if (value is not None):
        if (not isinstance(value, AxisRegionGroup)):
          raise ApiError("""%s.checkValid: axisRegionGroup:
           value is not of class ccpnmr.Analysis.AxisRegionGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('axisRegions')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: axisRegionGroup:
           non-reciprocal link axisRegionGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('isActive')
    if (value is None):
      raise ApiError("""%s.checkValid: isActive:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('overrideRegion')
    if (len(values) > 2):
      raise ApiError("""%s.checkValid: overrideRegion:
       hicard: values must be of length <= 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('region')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: region:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('size')
    if (value is None):
      raise ApiError("""%s.checkValid: size:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('axisPanel')
    if (value is None):
      raise ApiError("""%s.checkValid: axisPanel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('axisRegionGroup')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAxisPanel(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.axisPanel
    """
    dataDict = self.__dict__
    result = dataDict.get('axisPanel')
    return result
  
  def getAxisRegionGroup(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.axisRegionGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('axisRegionGroup')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AxisRegion
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisRegion'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (4 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisRegion'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-4]
      obj2 = obj1.__dict__.get('spectrumWindows').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-3]
        obj3 = obj2.__dict__.get('spectrumWindowPanes').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-2]
          obj4 = obj3.__dict__.get('axisPanels').get(objKey)

          if (obj4 is not None):
            objKey = fullKey[-1]
            obj5 = obj4.__dict__.get('axisRegions').get(objKey)
            result = obj5

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    result = list()

    obj4 = dataDict.get('axisPanel')
    obj3 = obj4.__dict__.get('spectrumWindowPane')
    obj2 = obj3.__dict__.get('spectrumWindow')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(obj3.__dict__.get('serial'))
    result.append(obj4.__dict__.get('label'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIsActive(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.isActive
    """
    dataDict = self.__dict__
    result = dataDict.get('isActive')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getOverrideRegion(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.overrideRegion
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('overrideRegion')
    result = tuple(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('axisPanel')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRegion(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.region
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('region')
    result = tuple(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getSize(self):
    """
    Get for ccpnmr.Analysis.AxisRegion.size
    """
    dataDict = self.__dict__
    result = dataDict.get('size')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeOverrideRegion(self, value):
    """
    Remove for ccpnmr.Analysis.AxisRegion.overrideRegion
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.removeOverrideRegion:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.removeOverrideRegion:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('overrideRegion')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeOverrideRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeOverrideRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeOverrideRegion:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeOverrideRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AxisRegion
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAxisRegionGroup(self, value):
    """
    Set for ccpnmr.Analysis.AxisRegion.axisRegionGroup
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, AxisRegionGroup)):
        raise ApiError("""%s.setAxisRegionGroup:
         value is not of class ccpnmr.Analysis.AxisRegionGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('axisRegionGroup')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAxisRegionGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAxisRegionGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAxisRegionGroup:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAxisRegionGroup:
           Link axisRegionGroup between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('axisRegions')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAxisRegionGroup:
         Read link 'axisRegionGroup' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('axisRegions')
      newSelves.add(self)

    dataDict['axisRegionGroup'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAxisRegionGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsActive(self, value):
    """
    Set for ccpnmr.Analysis.AxisRegion.isActive
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsActive:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isActive')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsActive:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsActive:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsActive:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isActive'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsActive')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setOverrideRegion(self, values):
    """
    Set for ccpnmr.Analysis.AxisRegion.overrideRegion
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setOverrideRegion:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setOverrideRegion:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('overrideRegion')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOverrideRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOverrideRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (len(values) > 2):
        raise ApiError("""%s.setOverrideRegion:
         hicard: values must be of length <= 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['overrideRegion'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOverrideRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRegion(self, values):
    """
    Set for ccpnmr.Analysis.AxisRegion.region
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setRegion:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setRegion:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('region')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (not (len(values) == 2)):
        raise ApiError("""%s.setRegion:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['region'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccpnmr.Analysis.AxisRegion.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('axisPanel')
    oldSerial = parent.__dict__.get('_serialDict').get('axisRegions')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['axisRegions'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['axisRegions'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setSize(self, value):
    """
    Set for ccpnmr.Analysis.AxisRegion.size
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSize:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('size')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSize:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSize:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['size'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSize')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  isActive = property(getIsActive, setIsActive, None,
  r"""Determines whether this region in the spectrum window is currently 
  considered active, usually for the purpose of strip plots.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  overrideRegion = property(getOverrideRegion, setOverrideRegion, None,
  r"""Override region, to use instead of main region
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  region = property(getRegion, setRegion, None,
  r"""The region of this axis in the units specified by the AxisUnit of the 
  AxisPanel.
  """)
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  size = property(getSize, setSize, None,
  r"""The size of the region in pixels.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  axisPanel = property(getAxisPanel,  None, None,
  r"""parent link
  """)
  
  axisRegionGroup = property(getAxisRegionGroup, setAxisRegionGroup, None,
  r"""AxisRegionGroup that groups AxisRegions
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for axisPanel
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AxisRegionGroup(memops.api.Implementation.DataObject):
  r"""Group of axis regions which are tied together. Used e.g. for strip 
plots.
  """
  #   from data model element ccpnmr.Analysis.AxisRegionGroup revision ?
  _metaclass = metaPackage.getElement('AxisRegionGroup')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'analysisProject', 'axisRegions', 'panelType', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['axisRegions'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AxisRegionGroup.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccpnmr.Analysis.AxisRegionGroup')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('axisRegionGroups')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AxisRegionGroup:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AxisRegionGroup:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for axisRegion in dataDict.get('axisRegions'):
      if (not (axisRegion in objsToBeDeleted)):
        axisRegion.__dict__['axisRegionGroup'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('axisRegionGroups')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAxisRegion(self, value):
    """
    Add for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    if (not isinstance(value, AxisRegion)):
      raise ApiError("""%s.addAxisRegion:
       value is not of class ccpnmr.Analysis.AxisRegion""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisRegions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAxisRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAxisRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAxisRegion:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAxisRegion:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAxisRegion:
           Link axisRegions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('axisRegionGroup')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('axisRegions')
      siblingValues.remove(value)

    value.__dict__['axisRegionGroup'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAxisRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('axisRegionGroups')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('axisRegions')
      for value in values:
        if (not isinstance(value, AxisRegion)):
          raise ApiError("""%s.checkValid: axisRegions:
           value is not of class ccpnmr.Analysis.AxisRegion""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('axisRegionGroup')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: axisRegions:
           non-reciprocal link axisRegions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: axisRegions:
           Link axisRegions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getPanelType()
      if (value is not None):
        if (not isinstance(value, PanelType)):
          raise ApiError("""%s.checkValid: panelType:
           value is not of class ccpnmr.Analysis.PanelType""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: panelType:
           Link panelType between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    axisRegions = self.axisRegions
    isValid = True
    if len(axisRegions) > 1:
      panelType = axisRegions[0].axisPanel.panelType
      for aa in axisRegions[1:]:
        if aa.axisPanel.panelType != panelType:
          isValid = False
          break
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint all_AxisRegions_correspond_to_same_PanelType violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('axisRegions')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAxisRegions(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('axisRegions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('axisRegions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isActive', 'serial', 'size', 'access', 'axisPanel', 'axisRegionGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAxisRegion(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('axisRegions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('axisRegions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isActive', 'serial', 'size', 'access', 'axisPanel', 'axisRegionGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.AxisRegionGroup.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAxisRegions(self):
    """
    Get for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('axisRegions')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AxisRegionGroup
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisRegionGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisRegionGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('axisRegionGroups').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.Analysis.AxisRegionGroup.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getPanelType(self):
    """
    getter for derived link panelType
    """
    dataDict = self.__dict__
    axisRegions = self.axisRegions
    if axisRegions:
      result = axisRegions[0].axisPanel.panelType
    else:
      result = None
    return result
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AxisRegionGroup.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccpnmr.Analysis.AxisRegionGroup.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAxisRegion(self, value):
    """
    Remove for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    if (not isinstance(value, AxisRegion)):
      raise ApiError("""%s.removeAxisRegion:
       value is not of class ccpnmr.Analysis.AxisRegion""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisRegions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAxisRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAxisRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAxisRegion:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAxisRegion:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['axisRegionGroup'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAxisRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AxisRegionGroup
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAxisRegions(self, values):
    """
    Set for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAxisRegions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AxisRegion)):
        raise ApiError("""%s.setAxisRegions:
         value is not of class ccpnmr.Analysis.AxisRegion""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisRegions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAxisRegions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAxisRegions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAxisRegions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAxisRegions:
           Link axisRegions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['axisRegionGroup'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('axisRegionGroup')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('axisRegions')
          vv.remove(cv)

      cv.__dict__['axisRegionGroup'] = self

    dataDict['axisRegions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAxisRegions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.Analysis.AxisRegionGroup.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccpnmr.Analysis.AxisRegionGroup.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('analysisProject')
    oldSerial = parent.__dict__.get('_serialDict').get('axisRegionGroups')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['axisRegionGroups'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['axisRegionGroups'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedAxisRegions(self):
    """
    Sorted for ccpnmr.Analysis.AxisRegionGroup.axisRegions
    """
    dataDict = self.__dict__
    ll = dataDict.get('axisRegions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of AxisRegionGroup
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  axisRegions = property(getAxisRegions, setAxisRegions, None,
  r"""AxisRegions that make up AxisRegionGroup
  """)
  
  panelType = property(getPanelType, None, None,
  r"""the PanelType of all the AxisRegions in the AxisRegionGroup
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AxisType(memops.api.Implementation.DataObject):
  r"""This determines how spectrum dimensions can be mapped onto a 
SpectrumWindow.
  """
  #   from data model element ccpnmr.Analysis.AxisType revision ?
  _metaclass = metaPackage.getElement('AxisType')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'diagonalExclusion', 'fieldNames', 'inConstructor', 'isDeleted', 'isSampled', 'isotopeCodes', 'measurementType', 'metaclass', 'name', 'numDecimals', 'packageName', 'packageShortName', 'peakSize', 'qualifiedName', 'region', 'access', 'activeAccess', 'analysisProject', 'axisUnits', 'isotopes', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['diagonalExclusion'] = 0.0
      dataDict['isSampled'] = False
      dataDict['isotopeCodes'] = list()
      dataDict['measurementType'] = 'Shift'
      dataDict['name'] = None
      dataDict['numDecimals'] = 0
      dataDict['peakSize'] = 1.0
      dataDict['region'] = [0.0, 1.0]
      dataDict['access'] = None
      dataDict['axisUnits'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AxisType.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('axisTypes')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AxisType:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AxisType:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('axisTypes')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAxisUnit(self, value):
    """
    Add for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    if (not isinstance(value, AxisUnit)):
      raise ApiError("""%s.addAxisUnit:
       value is not of class ccpnmr.Analysis.AxisUnit""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisUnits')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAxisUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAxisUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAxisUnit:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAxisUnit:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAxisUnit:
           Link axisUnits between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAxisUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('axisTypes')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('diagonalExclusion')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: diagonalExclusion:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: diagonalExclusion:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: diagonalExclusion:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isSampled')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isSampled:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('isotopeCodes')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: isotopeCodes:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: isotopeCodes:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: isotopeCodes:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: isotopeCodes:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('measurementType')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: measurementType:
         ccp.nmr.NmrExpPrototype.ExpMeasurementType input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: measurementType:
         ccp.nmr.NmrExpPrototype.ExpMeasurementType maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: measurementType:
         ccp.nmr.NmrExpPrototype.ExpMeasurementType: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: measurementType:
         ExpMeasurementType constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numDecimals')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numDecimals:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('peakSize')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: peakSize:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: peakSize:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('region')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: region:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: region:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('axisUnits')
      for value in values:
        if (not isinstance(value, AxisUnit)):
          raise ApiError("""%s.checkValid: axisUnits:
           value is not of class ccpnmr.Analysis.AxisUnit""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: axisUnits:
           Link axisUnits between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getIsotopes()
      for value in values:
        from ccp.api.molecule.ChemElement import Isotope as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: isotopes:
           value is not of class ccp.molecule.ChemElement.Isotope""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: isotopes:
           Link isotopes between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('diagonalExclusion')
    if (value is None):
      raise ApiError("""%s.checkValid: diagonalExclusion:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isSampled')
    if (value is None):
      raise ApiError("""%s.checkValid: isSampled:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('isotopeCodes')
    value = dataDict.get('measurementType')
    if (value is None):
      raise ApiError("""%s.checkValid: measurementType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numDecimals')
    if (value is None):
      raise ApiError("""%s.checkValid: numDecimals:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('peakSize')
    if (value is None):
      raise ApiError("""%s.checkValid: peakSize:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('region')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: region:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('axisUnits')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAxisUnits(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('axisUnits')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('axisUnits')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isBackwards', 'unit', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllIsotopes(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.AxisType.isotopes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getIsotopes()
      result = list(currentValues)

    else:
      currentValues = self.getIsotopes()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('abundance', 'gyroMagneticRatio', 'halfLife', 'halfLifeError', 'halfLifeType', 'magneticMoment', 'mass', 'massNumber', 'quadrupoleMoment', 'receptivity', 'spin', 'access', 'chemElement',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAxisUnit(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('axisUnits')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('axisUnits')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isBackwards', 'unit', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstIsotope(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.AxisType.isotopes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getIsotopes()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = self.getIsotopes()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('abundance', 'gyroMagneticRatio', 'halfLife', 'halfLifeError', 'halfLifeType', 'magneticMoment', 'mass', 'massNumber', 'quadrupoleMoment', 'receptivity', 'spin', 'access', 'chemElement',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.AxisType.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAxisUnits(self):
    """
    Get for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('axisUnits')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AxisType
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisType'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisType'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('axisTypes').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDiagonalExclusion(self):
    """
    Get for ccpnmr.Analysis.AxisType.diagonalExclusion
    """
    dataDict = self.__dict__
    result = dataDict.get('diagonalExclusion')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsSampled(self):
    """
    Get for ccpnmr.Analysis.AxisType.isSampled
    """
    dataDict = self.__dict__
    result = dataDict.get('isSampled')
    return result
  
  def getIsotopeCodes(self):
    """
    Get for ccpnmr.Analysis.AxisType.isotopeCodes
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('isotopeCodes')
    result = tuple(tempVar)
    return result
  
  def getIsotopes(self):
    """
    getter for derived link isotopes
    """
    dataDict = self.__dict__
    elementStore = self.root.currentChemElementStore
    result = []
    for ss in self.isotopeCodes:
      if ss[-2] in '0123456789':
        firstLetter = -1
      else:
        firstLetter = -2
      atomSymbol = ss[firstLetter:].capitalize()
      massNumber = int(ss[:firstLetter])
      
      result.append(ccp.api.molecule.ChemElement.Isotope.getByKey(elementStore,(atomSymbol, massNumber)))
    #
    result = tuple(result)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMeasurementType(self):
    """
    Get for ccpnmr.Analysis.AxisType.measurementType
    """
    dataDict = self.__dict__
    result = dataDict.get('measurementType')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.Analysis.AxisType.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNumDecimals(self):
    """
    Get for ccpnmr.Analysis.AxisType.numDecimals
    """
    dataDict = self.__dict__
    result = dataDict.get('numDecimals')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AxisType.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result
  
  def getPeakSize(self):
    """
    Get for ccpnmr.Analysis.AxisType.peakSize
    """
    dataDict = self.__dict__
    result = dataDict.get('peakSize')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRegion(self):
    """
    Get for ccpnmr.Analysis.AxisType.region
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('region')
    result = tuple(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAxisUnit(self, value):
    """
    Remove for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    if (not isinstance(value, AxisUnit)):
      raise ApiError("""%s.removeAxisUnit:
       value is not of class ccpnmr.Analysis.AxisUnit""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisUnits')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAxisUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAxisUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAxisUnit:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAxisUnit:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAxisUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AxisType
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAxisUnits(self, values):
    """
    Set for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAxisUnits:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AxisUnit)):
        raise ApiError("""%s.setAxisUnits:
         value is not of class ccpnmr.Analysis.AxisUnit""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('axisUnits')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAxisUnits:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAxisUnits:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAxisUnits:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAxisUnits:
           Link axisUnits between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['axisUnits'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAxisUnits')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDiagonalExclusion(self, value):
    """
    Set for ccpnmr.Analysis.AxisType.diagonalExclusion
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setDiagonalExclusion:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setDiagonalExclusion:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setDiagonalExclusion:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('diagonalExclusion')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDiagonalExclusion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDiagonalExclusion:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDiagonalExclusion:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['diagonalExclusion'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDiagonalExclusion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsSampled(self, value):
    """
    Set for ccpnmr.Analysis.AxisType.isSampled
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsSampled:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isSampled')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsSampled:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setIsSampled:
         cannot set isSampled, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setIsSampled:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isSampled'] = value

    # doNotifies
  
  def setIsotopeCodes(self, values):
    """
    Set for ccpnmr.Analysis.AxisType.isotopeCodes
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setIsotopeCodes:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setIsotopeCodes:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setIsotopeCodes:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setIsotopeCodes:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('isotopeCodes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsotopeCodes:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setIsotopeCodes:
         cannot set isotopeCodes, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isotopeCodes'] = values

    # doNotifies
  
  def setMeasurementType(self, value):
    """
    Set for ccpnmr.Analysis.AxisType.measurementType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setMeasurementType:
       ccp.nmr.NmrExpPrototype.ExpMeasurementType input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setMeasurementType:
       ccp.nmr.NmrExpPrototype.ExpMeasurementType maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setMeasurementType:
       ccp.nmr.NmrExpPrototype.ExpMeasurementType: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setMeasurementType:
       ExpMeasurementType constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('measurementType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeasurementType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMeasurementType:
         cannot set measurementType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMeasurementType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['measurementType'] = value

    # doNotifies
  
  def setName(self, value):
    """
    Set for ccpnmr.Analysis.AxisType.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNumDecimals(self, value):
    """
    Set for ccpnmr.Analysis.AxisType.numDecimals
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumDecimals:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numDecimals')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumDecimals:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumDecimals:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumDecimals:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numDecimals'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumDecimals')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakSize(self, value):
    """
    Set for ccpnmr.Analysis.AxisType.peakSize
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPeakSize:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPeakSize:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('peakSize')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakSize:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakSize:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPeakSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['peakSize'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakSize')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRegion(self, values):
    """
    Set for ccpnmr.Analysis.AxisType.region
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setRegion:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setRegion:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('region')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRegion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRegion:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (not (len(values) == 2)):
        raise ApiError("""%s.setRegion:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['region'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRegion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAxisUnits(self):
    """
    Sorted for ccpnmr.Analysis.AxisType.axisUnits
    """
    dataDict = self.__dict__
    ll = dataDict.get('axisUnits')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  diagonalExclusion = property(getDiagonalExclusion, setDiagonalExclusion, None,
  r"""The amount (in ppm) by which two dimensions with same
  axisType must 
  differ by in order to be considered as a peak, in peak
  finding.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isSampled = property(getIsSampled, setIsSampled, None,
  r"""if true then this type is not linear but sampled
  """)
  
  isotopeCodes = property(getIsotopeCodes, setIsotopeCodes, None,
  r"""The isotope codes (e.g. '13C') which are mapped onto this axis type.
  """)
  
  measurementType = property(getMeasurementType, setMeasurementType, None,
  r"""Measurement type.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""e.g. '1H', '13C', '15N', 'T', 'Ca', 'CO', 'Hc', ''JHH', 'DQCH', but any 
  word will do.
  """)
  
  numDecimals = property(getNumDecimals, setNumDecimals, None,
  r"""Number of decimal places to be shown.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  peakSize = property(getPeakSize, setPeakSize, None,
  r"""Size of peak symbol in appropriate unit.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  region = property(getRegion, setRegion, None,
  r"""maximum (or world) region
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  axisUnits = property(getAxisUnits, setAxisUnits, None,
  r"""the AxisUnit of the AxisType
  """)
  
  isotopes = property(getIsotopes, None, None,
  r"""Derived. Isotopes mapped on the Axis. NB in the case of e.g coupling 
  constants or multiple quantum coherences there may be more than one.  
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AxisUnit(memops.api.Implementation.DataObject):
  r"""This is one possible unit for an AxisType.
  """
  #   from data model element ccpnmr.Analysis.AxisUnit revision ?
  _metaclass = metaPackage.getElement('AxisUnit')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isBackwards', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'unit', 'access', 'activeAccess', 'analysisProject', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['isBackwards'] = True
      dataDict['unit'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.AxisUnit.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('axisUnits')
        objKey = dataDict.get('unit')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['unit'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.AxisUnit:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.AxisUnit:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('unit')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('axisUnits')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('unit')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('axisUnits')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isBackwards')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isBackwards:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('unit')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: unit:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: unit:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: unit:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: unit:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('isBackwards')
    if (value is None):
      raise ApiError("""%s.checkValid: isBackwards:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('unit')
    if (value is None):
      raise ApiError("""%s.checkValid: unit:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.AxisUnit.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.AxisUnit
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisUnit'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.AxisUnit'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('axisUnits').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('unit'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIsBackwards(self):
    """
    Get for ccpnmr.Analysis.AxisUnit.isBackwards
    """
    dataDict = self.__dict__
    result = dataDict.get('isBackwards')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    result = dataDict.get('unit')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.AxisUnit.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getUnit(self):
    """
    Get for ccpnmr.Analysis.AxisUnit.unit
    """
    dataDict = self.__dict__
    result = dataDict.get('unit')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.AxisUnit
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setIsBackwards(self, value):
    """
    Set for ccpnmr.Analysis.AxisUnit.isBackwards
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsBackwards:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isBackwards')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsBackwards:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setIsBackwards:
         cannot set isBackwards, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setIsBackwards:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isBackwards'] = value

    # doNotifies
  
  def setUnit(self, value):
    """
    Set for ccpnmr.Analysis.AxisUnit.unit
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setUnit:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setUnit:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setUnit:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setUnit:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('unit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setUnit:
         cannot set unit, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setUnit:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['unit'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  isBackwards = property(getIsBackwards, setIsBackwards, None,
  r"""if true then left (bottom) of region has higher value than right (top)
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  unit = property(getUnit, setUnit, None,
  r"""e.g. 'ppm', 'Hz', 'deg K'
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChainMapping(memops.api.Implementation.DataObject):
  r"""ChainMaping - serves to organise AtomSetMappings
  """
  #   from data model element ccpnmr.Analysis.ChainMapping revision ?
  _metaclass = metaPackage.getElement('ChainMapping')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'chainCode', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'molSystemCode', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'analysisProject', 'chain', 'parent', 'residueMappings', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['chainCode'] = None
      dataDict['molSystemCode'] = None
      dataDict['access'] = None
      dataDict['residueMappings'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.ChainMapping.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chainMappings')
        ll = list()
        objKey = dataDict.get('molSystemCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('chainCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molSystemCode', 'chainCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.ChainMapping:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    residueMappings = dataDict.get('residueMappings').values()
    for residueMapping in residueMappings:
      if (not (residueMapping in objsToBeDeleted)):
        objsToBeDeleted.add(residueMapping)
        objsToBeChecked.append(residueMapping)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.ChainMapping:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('molSystemCode')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('chainCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('chainMappings')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('residueMappings').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('molSystemCode')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('chainCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('chainMappings')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('chainCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: chainCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: chainCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: chainCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: chainCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molSystemCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molSystemCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getChain()
      if (value is None):
        raise ApiError("""%s.checkValid: chain:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.MolSystem import Chain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chain:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chain:
         Link chain between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('residueMappings').values()
      for value in values:
        if (not isinstance(value, ResidueMapping)):
          raise ApiError("""%s.checkValid: residueMappings:
           value is not of class ccpnmr.Analysis.ResidueMapping""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chainMapping')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residueMappings:
           non-reciprocal link residueMappings from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('chainCode')
    if (value is None):
      raise ApiError("""%s.checkValid: chainCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSystemCode')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystemCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('residueMappings').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllResidueMappings(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.ChainMapping.residueMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residueMappings').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('residueMappings').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('seqId', 'access', 'chainMapping',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstResidueMapping(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.ChainMapping.residueMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residueMappings').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('seqId')
      if (objKey is not None):
        result = dataDict.get('residueMappings').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('residueMappings').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('seqId', 'access', 'chainMapping',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.ChainMapping.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.ChainMapping
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.ChainMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.ChainMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chainMappings').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChain(self):
    """
    getter for derived link chain
    """
    dataDict = self.__dict__
    result = ccp.api.molecule.MolSystem.Chain.getByKey(self.root, (self.molSystemCode, self.chainCode))
    return result
  
  def getChainCode(self):
    """
    Get for ccpnmr.Analysis.ChainMapping.chainCode
    """
    dataDict = self.__dict__
    result = dataDict.get('chainCode')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('molSystemCode'))
    result.append(dataDict.get('chainCode'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('molSystemCode')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('chainCode')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystemCode(self):
    """
    Get for ccpnmr.Analysis.ChainMapping.molSystemCode
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystemCode')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.ChainMapping.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidueMappings(self):
    """
    Get for ccpnmr.Analysis.ChainMapping.residueMappings
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('residueMappings').values()
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newResidueMapping(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.ResidueMapping
    """
    return ResidueMapping(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.ChainMapping
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChainCode(self, value):
    """
    Set for ccpnmr.Analysis.ChainMapping.chainCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setChainCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setChainCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setChainCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setChainCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chainCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChainCode:
         cannot set chainCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setChainCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['chainCode'] = value

    # doNotifies
  
  def setMolSystemCode(self, value):
    """
    Set for ccpnmr.Analysis.ChainMapping.molSystemCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolSystemCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSystemCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolSystemCode:
         cannot set molSystemCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolSystemCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molSystemCode'] = value

    # doNotifies
  
  def sortedResidueMappings(self):
    """
    Sorted for ccpnmr.Analysis.ChainMapping.residueMappings
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('residueMappings')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  chainCode = property(getChainCode, setChainCode, None,
  r"""key for the chain, used to derive chain link
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molSystemCode = property(getMolSystemCode, setMolSystemCode, None,
  r"""key for the molSystem, used to derive molSystem link
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  chain = property(getChain, None, None,
  r"""The chain that the ChainMapping corresponds to  
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)
  
  residueMappings = property(getResidueMappings,  None, None,
  r"""child link to class ResidueMapping
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MarkDim(memops.api.Implementation.DataObject):
  r"""One dimension of a mark.
  """
  #   from data model element ccpnmr.Analysis.MarkDim revision ?
  _metaclass = metaPackage.getElement('MarkDim')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'position', 'qualifiedName', 'serial', 'access', 'activeAccess', 'axisType', 'mark', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    dataDict['mark'] = parent
    if (not isinstance(parent, Mark)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.Mark""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['position'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['axisType'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.MarkDim.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccpnmr.Analysis.MarkDim')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('markDims')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.MarkDim:
       determines cascading deletes 
    to follow from delete of object.
       *Implementation function* - should 
    be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.MarkDim:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    mark = dataDict.get('mark')
    if (not (mark in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = mark.__dict__.get('markDims')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('mark')
        dd = value.__dict__.get('markDims')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'mark' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('position')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: position:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: position:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('axisType')
      if (not isinstance(value, AxisType)):
        raise ApiError("""%s.checkValid: axisType:
         value is not of class ccpnmr.Analysis.AxisType""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: axisType:
         Link axisType between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('mark')
      if (not isinstance(value, Mark)):
        raise ApiError("""%s.checkValid: mark:
         value is not of class ccpnmr.Analysis.Mark""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('position')
    if (value is None):
      raise ApiError("""%s.checkValid: position:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('axisType')
    if (value is None):
      raise ApiError("""%s.checkValid: axisType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('mark')
    if (value is None):
      raise ApiError("""%s.checkValid: mark:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAxisType(self):
    """
    Get for ccpnmr.Analysis.MarkDim.axisType
    """
    dataDict = self.__dict__
    result = dataDict.get('axisType')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.MarkDim
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.MarkDim'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.MarkDim'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('marks').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('markDims').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('mark')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMark(self):
    """
    Get for ccpnmr.Analysis.MarkDim.mark
    """
    dataDict = self.__dict__
    result = dataDict.get('mark')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.MarkDim.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('mark')
    return result
  
  def getPosition(self):
    """
    Get for ccpnmr.Analysis.MarkDim.position
    """
    dataDict = self.__dict__
    result = dataDict.get('position')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccpnmr.Analysis.MarkDim.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.MarkDim
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAxisType(self, value):
    """
    Set for ccpnmr.Analysis.MarkDim.axisType
    """
    dataDict = self.__dict__
    if (not isinstance(value, AxisType)):
      raise ApiError("""%s.setAxisType:
       value is not of class ccpnmr.Analysis.AxisType""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('axisType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAxisType:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAxisType:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAxisType:
         cannot set axisType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAxisType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setAxisType:
         Link axisType between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['axisType'] = value

    # doNotifies
  
  def setPosition(self, value):
    """
    Set for ccpnmr.Analysis.MarkDim.position
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setPosition:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setPosition:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('position')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPosition:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setPosition:
         cannot set position, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setPosition:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['position'] = value

    # doNotifies
  
  def setSerial(self, value):
    """
    Set for ccpnmr.Analysis.MarkDim.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('mark')
    oldSerial = parent.__dict__.get('_serialDict').get('markDims')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['markDims'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['markDims'] = value

    dataDict['serial'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  position = property(getPosition, setPosition, None,
  r"""In units fitting the corresponding AxisType
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  axisType = property(getAxisType, setAxisType, None,
  r"""the AxisType of the MarkDim
  """)
  
  mark = property(getMark,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for mark
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class PanelType(memops.api.Implementation.DataObject):
  r"""This is a way of distinguishing between axes with the same AxisType.
  """
  #   from data model element ccpnmr.Analysis.PanelType revision ?
  _metaclass = metaPackage.getElement('PanelType')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'analysisProject', 'axisType', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['axisType'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.PanelType.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('panelTypes')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.PanelType:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.PanelType:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('panelTypes')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('panelTypes')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('axisType')
      if (not isinstance(value, AxisType)):
        raise ApiError("""%s.checkValid: axisType:
         value is not of class ccpnmr.Analysis.AxisType""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: axisType:
         Link axisType between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('axisType')
    if (value is None):
      raise ApiError("""%s.checkValid: axisType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.PanelType.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAxisType(self):
    """
    Get for ccpnmr.Analysis.PanelType.axisType
    """
    dataDict = self.__dict__
    result = dataDict.get('axisType')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.PanelType
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.PanelType'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.PanelType'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('panelTypes').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.Analysis.PanelType.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.PanelType.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.PanelType
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAxisType(self, value):
    """
    Set for ccpnmr.Analysis.PanelType.axisType
    """
    dataDict = self.__dict__
    if (not isinstance(value, AxisType)):
      raise ApiError("""%s.setAxisType:
       value is not of class ccpnmr.Analysis.AxisType""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('axisType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAxisType:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAxisType:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAxisType:
         cannot set axisType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAxisType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setAxisType:
         Link axisType between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['axisType'] = value

    # doNotifies
  
  def setName(self, value):
    """
    Set for ccpnmr.Analysis.PanelType.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of panel type, e.g 'H1'. Serves as key.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProject = property(getAnalysisProject,  None, None,
  r"""parent link
  """)
  
  axisType = property(getAxisType, setAxisType, None,
  r"""the AxisType of the PanelType
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProject
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class PopupOption(memops.api.Implementation.DataObject):
  r"""Popup option setting
  """
  #   from data model element ccpnmr.Analysis.PopupOption revision ?
  _metaclass = metaPackage.getElement('PopupOption')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'keyword', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'analysisPopup', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    dataDict['analysisPopup'] = parent
    if (not isinstance(parent, AnalysisPopup)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisPopup""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['keyword'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.PopupOption.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('popupOptions')
        objKey = dataDict.get('keyword')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['keyword'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.PopupOption:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.PopupOption:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisPopup = dataDict.get('analysisPopup')
    if (not (analysisPopup in objsToBeDeleted)):
      objKey = dataDict.get('keyword')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisPopup.__dict__.get('popupOptions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('keyword')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisPopup')
        dd = value.__dict__.get('popupOptions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisPopup' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('keyword')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: keyword:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisPopup')
      if (not isinstance(value, AnalysisPopup)):
        raise ApiError("""%s.checkValid: analysisPopup:
         value is not of class ccpnmr.Analysis.AnalysisPopup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisPopup')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisPopup:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisPopup(self):
    """
    Get for ccpnmr.Analysis.PopupOption.analysisPopup
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisPopup')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.PopupOption
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.PopupOption'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.PopupOption'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('analysisPopups').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('popupOptions').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetails(self):
    """
    Get for ccpnmr.Analysis.PopupOption.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('analysisPopup')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('keyword'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getKeyword(self):
    """
    Get for ccpnmr.Analysis.PopupOption.keyword
    """
    dataDict = self.__dict__
    result = dataDict.get('keyword')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    result = dataDict.get('keyword')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.PopupOption.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisPopup')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.PopupOption
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetails(self, value):
    """
    Set for ccpnmr.Analysis.PopupOption.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setKeyword(self, value):
    """
    Set for ccpnmr.Analysis.PopupOption.keyword
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setKeyword:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('keyword')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setKeyword:
         cannot set keyword, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setKeyword:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['keyword'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  keyword = property(getKeyword, setKeyword, None,
  r"""Popup option keyword
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisPopup = property(getAnalysisPopup,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisPopup
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ResidueMapping(memops.api.Implementation.DataObject):
  r"""ResidueMapping - serves to organise AtomSetMappings
  """
  #   from data model element ccpnmr.Analysis.ResidueMapping revision ?
  _metaclass = metaPackage.getElement('ResidueMapping')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'seqId', 'access', 'activeAccess', 'atomSetMappings', 'chainMapping', 'parent', 'residue', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    dataDict['chainMapping'] = parent
    if (not isinstance(parent, ChainMapping)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.ChainMapping""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['seqId'] = None
      dataDict['access'] = None
      dataDict['atomSetMappings'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.ResidueMapping.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('residueMappings')
        objKey = dataDict.get('seqId')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['seqId'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.ResidueMapping:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    atomSetMappings = dataDict.get('atomSetMappings').values()
    for atomSetMapping in atomSetMappings:
      if (not (atomSetMapping in objsToBeDeleted)):
        objsToBeDeleted.add(atomSetMapping)
        objsToBeChecked.append(atomSetMapping)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.ResidueMapping:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    chainMapping = dataDict.get('chainMapping')
    if (not (chainMapping in objsToBeDeleted)):
      objKey = dataDict.get('seqId')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chainMapping.__dict__.get('residueMappings')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('atomSetMappings').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('seqId')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chainMapping')
        dd = value.__dict__.get('residueMappings')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chainMapping' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqId')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: seqId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('atomSetMappings').values()
      for value in values:
        if (not isinstance(value, AtomSetMapping)):
          raise ApiError("""%s.checkValid: atomSetMappings:
           value is not of class ccpnmr.Analysis.AtomSetMapping""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('residueMapping')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: atomSetMappings:
           non-reciprocal link atomSetMappings from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('chainMapping')
      if (not isinstance(value, ChainMapping)):
        raise ApiError("""%s.checkValid: chainMapping:
         value is not of class ccpnmr.Analysis.ChainMapping""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getResidue()
      if (value is None):
        raise ApiError("""%s.checkValid: residue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.MolSystem import Residue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: residue:
         value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: residue:
         Link residue between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('seqId')
    if (value is None):
      raise ApiError("""%s.checkValid: seqId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('atomSetMappings').values()
    value = dataDict.get('chainMapping')
    if (value is None):
      raise ApiError("""%s.checkValid: chainMapping:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAtomSetMappings(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.ResidueMapping.atomSetMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSetMappings').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atomSetMappings').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'mappingType', 'name', 'access', 'chemAtomSet', 'residueMapping',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAtomSetMapping(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.ResidueMapping.atomSetMappings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSetMappings').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('atomSetMappings').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('atomSetMappings').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'mappingType', 'name', 'access', 'chemAtomSet', 'residueMapping',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomSetMappings(self):
    """
    Get for ccpnmr.Analysis.ResidueMapping.atomSetMappings
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomSetMappings').values()
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.ResidueMapping
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.ResidueMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.ResidueMapping'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-3]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-2]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chainMappings').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('residueMappings').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChainMapping(self):
    """
    Get for ccpnmr.Analysis.ResidueMapping.chainMapping
    """
    dataDict = self.__dict__
    result = dataDict.get('chainMapping')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('chainMapping')
    obj1 = obj2.__dict__.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('molSystemCode'))
    result.append(obj2.__dict__.get('chainCode'))
    result.append(dataDict.get('seqId'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    result = dataDict.get('seqId')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.Analysis.ResidueMapping.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chainMapping')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidue(self):
    """
    getter for derived link residue
    """
    dataDict = self.__dict__
    result = self.chainMapping.chain.findFirstResidue(seqId=self.seqId)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSeqId(self):
    """
    Get for ccpnmr.Analysis.ResidueMapping.seqId
    """
    dataDict = self.__dict__
    result = dataDict.get('seqId')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newAtomSetMapping(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AtomSetMapping
    """
    return AtomSetMapping(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.Analysis.ResidueMapping
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setSeqId(self, value):
    """
    Set for ccpnmr.Analysis.ResidueMapping.seqId
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSeqId:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSeqId:
         cannot set seqId, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSeqId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['seqId'] = value

    # doNotifies
  
  def sortedAtomSetMappings(self):
    """
    Sorted for ccpnmr.Analysis.ResidueMapping.atomSetMappings
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('atomSetMappings')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  seqId = property(getSeqId, setSeqId, None,
  r"""key for residue, seqId number of residue in chain
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atomSetMappings = property(getAtomSetMappings,  None, None,
  r"""child link to class AtomSetMapping
  """)
  
  chainMapping = property(getChainMapping,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chainMapping
  """)
  
  residue = property(getResidue, None, None,
  r"""The residue that the ResidueMapping corresponds to
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SidePanel(memops.api.Implementation.DataObject):
  r"""Graphical objects which correspond to one dimension, e.g. the scrollbars 
and 1D slices.
  """
  #   from data model element ccpnmr.Analysis.SidePanel revision ?
  _metaclass = metaPackage.getElement('SidePanel')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'isVisible', 'label', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'thickness', 'access', 'activeAccess', 'root', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsVisible(self):
    """
    Get for ccpnmr.Analysis.SidePanel.isVisible
    """
    dataDict = self.__dict__
    result = dataDict.get('isVisible')
    return result
  
  def getLabel(self):
    """
    Get for ccpnmr.Analysis.SidePanel.label
    """
    dataDict = self.__dict__
    result = dataDict.get('label')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getThickness(self):
    """
    Get for ccpnmr.Analysis.SidePanel.thickness
    """
    dataDict = self.__dict__
    result = dataDict.get('thickness')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setIsVisible(self, value):
    """
    Set for ccpnmr.Analysis.SidePanel.isVisible
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsVisible:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isVisible')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsVisible:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsVisible:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsVisible:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isVisible'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsVisible')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLabel(self, value):
    """
    Set for ccpnmr.Analysis.SidePanel.label
    """
    dataDict = self.__dict__
    if (not (value in ['x', 'y', 'z1', 'z2', 'z3', 'z4', 'z5', 'z6', 'z7', 'z8'])):
      raise ApiError("""%s.setLabel:
       ccpnmr.Analysis.AxisLabel input is not in enumeration ['x', 'y', 'z1', 'z2', 'z3', 'z4', 'z5', 'z6', 'z7', 'z8']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    isValid = True
    if not value:
      isValid = False
    elif value[0] not in 'abcdefghjiklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ':
      isValid = False
    else:
      for cc in value[1:]:
        if cc not in 'abcdefghjiklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789':
          isValid = False
          break
    if (not (isValid)):
      raise ApiError("""%s.setLabel:
       AxisLabel constraint name_type_characters violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('label')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLabel:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLabel:
         cannot set label, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLabel:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['label'] = value

    # doNotifies
  
  def setThickness(self, value):
    """
    Set for ccpnmr.Analysis.SidePanel.thickness
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setThickness:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('thickness')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setThickness:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setThickness:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setThickness:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['thickness'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setThickness')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isVisible = property(getIsVisible, setIsVisible, None,
  r"""Whether or not visible in the display
  """)
  
  label = property(getLabel, setLabel, None,
  r"""enum. 'x', 'y', 'z1', ...
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  thickness = property(getThickness, setThickness, None,
  r"""Graphical width of panel in pixels
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SpectrumWindow(memops.api.Implementation.DataObject):
  r"""This is for the multi-dimensional display of one or more spectra 
simultaneously.
  """
  #   from data model element ccpnmr.Analysis.SpectrumWindow revision ?
  _metaclass = metaPackage.getElement('SpectrumWindow')
  _packageName = 'ccpnmr.Analysis'
  _packageShortName = 'ANAL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isCanvasLabelShown', 'isCanvasMidpointShown', 'isDeleted', 'isIconified', 'isXSliceDrawn', 'isXTickShown', 'isYSliceDrawn', 'isYTickShown', 'isZeroLineShown', 'location', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'stripAxis', 'useMultiplePeakLists', 'useOverrideRegion', 'access', 'activeAccess', 'analysisProject', 'parent', 'root', 'spectrumWindowGroups', 'spectrumWindowPanes', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.Analysis.SpectrumWindow
    """
    dataDict = self.__dict__
    dataDict['analysisProject'] = parent
    if (not isinstance(parent, AnalysisProject)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['isCanvasLabelShown'] = True
      dataDict['isCanvasMidpointShown'] = True
      dataDict['isIconified'] = False
      dataDict['isXSliceDrawn'] = False
      dataDict['isXTickShown'] = True
      dataDict['isYSliceDrawn'] = False
      dataDict['isYTickShown'] = True
      dataDict['isZeroLineShown'] = True
      dataDict['location'] = [0, 0]
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['stripAxis'] = 'x'
      dataDict['useMultiplePeakLists'] = True
      dataDict['useOverrideRegion'] = False
      dataDict['access'] = None
      dataDict['spectrumWindowGroups'] = set()
      dataDict['spectrumWindowPanes'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.Analysis.SpectrumWindow.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccpnmr.Analysis.SpectrumWindow')
          )

      serialDict = {}
      serialDict['spectrumWindowPanes'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('spectrumWindows')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.Analysis.SpectrumWindow:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    spectrumWindowPanes = dataDict.get('spectrumWindowPanes').values()
    for spectrumWindowPane in spectrumWindowPanes:
      if (not (spectrumWindowPane in objsToBeDeleted)):
        objsToBeDeleted.add(spectrumWindowPane)
        objsToBeChecked.append(spectrumWindowPane)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.Analysis.SpectrumWindow:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for spectrumWindowGroup in dataDict.get('spectrumWindowGroups'):
      if (not (spectrumWindowGroup in objsToBeDeleted)):
        spectrumWindows = spectrumWindowGroup.__dict__.get('spectrumWindows')
        spectrumWindows.remove(self)

    analysisProject = dataDict.get('analysisProject')
    if (not (analysisProject in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProject.__dict__.get('spectrumWindows')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addSpectrumWindowGroup(self, value):
    """
    Add for ccpnmr.Analysis.SpectrumWindow.spectrumWindowGroups
    """
    dataDict = self.__dict__
    if (not isinstance(value, SpectrumWindowGroup)):
      raise ApiError("""%s.addSpectrumWindowGroup:
       value is not of class ccpnmr.Analysis.SpectrumWindowGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('spectrumWindowGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addSpectrumWindowGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addSpectrumWindowGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addSpectrumWindowGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addSpectrumWindowGroup:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addSpectrumWindowGroup:
           Link spectrumWindowGroups between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('spectrumWindows')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addSpectrumWindowGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.Analysis.SpectrumWindow
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('spectrumWindowPanes').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.Analysis.SpectrumWindow
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProject')
        dd = value.__dict__.get('spectrumWindows')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isCanvasLabelShown')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isCanvasLabelShown:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isCanvasMidpointShown')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isCanvasMidpointShown:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isIconified')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isIconified:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isXSliceDrawn')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isXSliceDrawn:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isXTickShown')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isXTickShown:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isYSliceDrawn')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isYSliceDrawn:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isYTickShown')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isYTickShown:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isZeroLineShown')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isZeroLineShown:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('location')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: location:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stripAxis')
      if (not (value in ['x', 'y'])):
        raise ApiError("""%s.checkValid: stripAxis:
         ccpnmr.Analysis.AxisXyLabel input is not in enumeration ['x', 'y']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: stripAxis:
         AxisXyLabel constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useMultiplePeakLists')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useMultiplePeakLists:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useOverrideRegion')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useOverrideRegion:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProject')
      if (not isinstance(value, AnalysisProject)):
        raise ApiError("""%s.checkValid: analysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('spectrumWindowGroups')
      for value in values:
        if (not isinstance(value, SpectrumWindowGroup)):
          raise ApiError("""%s.checkValid: spectrumWindowGroups:
           value is not of class ccpnmr.Analysis.SpectrumWindowGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('spectrumWindows')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: spectrumWindowGroups:
           non-reciprocal link spectrumWindowGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: spectrumWindowGroups:
           Link spectrumWindowGroups between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('spectrumWindowPanes').values()
      for value in values:
        if (not isinstance(value, SpectrumWindowPane)):
          raise ApiError("""%s.checkValid: spectrumWindowPanes:
           value is not of class ccpnmr.Analysis.SpectrumWindowPane""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('spectrumWindow')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: spectrumWindowPanes:
           non-reciprocal link spectrumWindowPanes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('isCanvasLabelShown')
    if (value is None):
      raise ApiError("""%s.checkValid: isCanvasLabelShown:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isCanvasMidpointShown')
    if (value is None):
      raise ApiError("""%s.checkValid: isCanvasMidpointShown:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isIconified')
    if (value is None):
      raise ApiError("""%s.checkValid: isIconified:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isXSliceDrawn')
    if (value is None):
      raise ApiError("""%s.checkValid: isXSliceDrawn:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isXTickShown')
    if (value is None):
      raise ApiError("""%s.checkValid: isXTickShown:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isYSliceDrawn')
    if (value is None):
      raise ApiError("""%s.checkValid: isYSliceDrawn:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isYTickShown')
    if (value is None):
      raise ApiError("""%s.checkValid: isYTickShown:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isZeroLineShown')
    values = dataDict.get('location')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: location:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('stripAxis')
    if (value is None):
      raise ApiError("""%s.checkValid: stripAxis:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('useMultiplePeakLists')
    if (value is None):
      raise ApiError("""%s.checkValid: useMultiplePeakLists:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('useOverrideRegion')
    if (value is None):
      raise ApiError("""%s.checkValid: useOverrideRegion:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProject')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('spectrumWindowGroups')
    values = dataDict.get('spectrumWindowPanes').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllSpectrumWindowGroups(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.SpectrumWindow.spectrumWindowGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('spectrumWindowGroups')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('spectrumWindowGroups')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSpectrumWindowPanes(self, **conditions):
    """
    FindAll for ccpnmr.Analysis.SpectrumWindow.spectrumWindowPanes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('spectrumWindowPanes').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('spectrumWindowPanes').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('aspectRatio', 'name', 'serial', 'access', 'spectrumWindow',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstSpectrumWindowGroup(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.SpectrumWindow.spectrumWindowGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('spectrumWindowGroups')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('spectrumWindowGroups')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'analysisProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSpectrumWindowPane(self, **conditions):
    """
    FindFirst for ccpnmr.Analysis.SpectrumWindow.spectrumWindowPanes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('spectrumWindowPanes').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('spectrumWindowPanes').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('spectrumWindowPanes').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('aspectRatio', 'name', 'serial', 'access', 'spectrumWindow',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.Analysis.SpectrumWindow
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProject(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.analysisProject
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProject')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.Analysis.SpectrumWindow
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.SpectrumWindow'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.Analysis')
        obj1 = obj0.__dict__.get('analysisProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.Analysis.SpectrumWindow'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('spectrumWindows').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.Analysis.SpectrumWindow
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIsCanvasLabelShown(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.isCanvasLabelShown
    """
    dataDict = self.__dict__
    result = dataDict.get('isCanvasLabelShown')
    return result
  
  def getIsCanvasMidpointShown(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.isCanvasMidpointShown
    """
    dataDict = self.__dict__
    result = dataDict.get('isCanvasMidpointShown')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsIconified(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.isIconified
    """
    dataDict = self.__dict__
    result = dataDict.get('isIconified')
    return result
  
  def getIsXSliceDrawn(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.isXSliceDrawn
    """
    dataDict = self.__dict__
    result = dataDict.get('isXSliceDrawn')
    return result
  
  def getIsXTickShown(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.isXTickShown
    """
    dataDict = self.__dict__
    result = dataDict.get('isXTickShown')
    return result
  
  def getIsYSliceDrawn(self):
    """
    Get for ccpnmr.Analysis.SpectrumWindow.isYSliceDrawn
    """
    dataDict = self.__dict__
    