"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyXmlMapWrite revision 1.29 on Thu Oct  2 16:08:53 2014
  from data model element ccp.nmr.Nmr revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Nmr.py: python XML-I/O-mapping for CCPN data model, MetaPackage ccp.nmr.Nmr

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import ccp.api.nmr.Nmr

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package NMR, adding it to globalMap
  """
  
  from memops.xml.Implementation import bool2str, str2bool

  # Set up top level dictionaries
  loadMaps = globalMap.get('loadMaps')
  mapsByGuid = globalMap.get('mapsByGuid')

  abstractTypes = globalMap.get('NMR').get('abstractTypes')
  exolinks = globalMap.get('NMR').get('exolinks')

  # DataType ChainStateSetType
  currentMap = {}
  abstractTypes['ChainStateSetType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00002'] = currentMap
  loadMaps['NMR.ChainStateSetType'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSetType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00002'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType DataSourceDataType
  currentMap = {}
  abstractTypes['DataSourceDataType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00007'] = currentMap
  loadMaps['NMR.DataSourceDataType'] = currentMap
  currentMap['tag'] = 'NMR.DataSourceDataType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00007'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ExpSampleState
  currentMap = {}
  abstractTypes['ExpSampleState'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00005'] = currentMap
  loadMaps['NMR.ExpSampleState'] = currentMap
  currentMap['tag'] = 'NMR.ExpSampleState'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00005'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType HExchProtectionType
  currentMap = {}
  abstractTypes['HExchProtectionType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00009'] = currentMap
  loadMaps['NMR.HExchProtectionType'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00009'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType IntensityType
  currentMap = {}
  abstractTypes['IntensityType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00038'] = currentMap
  loadMaps['NMR.IntensityType'] = currentMap
  currentMap['tag'] = 'NMR.IntensityType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00038'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType LinkType
  currentMap = {}
  abstractTypes['LinkType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00037'] = currentMap
  loadMaps['NMR.LinkType'] = currentMap
  currentMap['tag'] = 'NMR.LinkType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00037'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType NoeValueType
  currentMap = {}
  abstractTypes['NoeValueType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:50_00001'] = currentMap
  loadMaps['NMR.NoeValueType'] = currentMap
  currentMap['tag'] = 'NMR.NoeValueType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:50_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PeakClusterType
  currentMap = {}
  abstractTypes['PeakClusterType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-01-14:37:12_00001'] = currentMap
  loadMaps['NMR.PeakClusterType'] = currentMap
  currentMap['tag'] = 'NMR.PeakClusterType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-01-14:37:12_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType SampleConditionType
  currentMap = {}
  abstractTypes['SampleConditionType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00003'] = currentMap
  loadMaps['NMR.SampleConditionType'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ShiftDifferenceType
  currentMap = {}
  abstractTypes['ShiftDifferenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00023'] = currentMap
  loadMaps['NMR.ShiftDifferenceType'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00023'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ShiftRefType
  currentMap = {}
  abstractTypes['ShiftRefType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00033'] = currentMap
  loadMaps['NMR.ShiftRefType'] = currentMap
  currentMap['tag'] = 'NMR.ShiftRefType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00033'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ShiftReferenceMolecule
  currentMap = {}
  abstractTypes['ShiftReferenceMolecule'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00004'] = currentMap
  loadMaps['NMR.ShiftReferenceMolecule'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReferenceMolecule'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00004'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType StructureGenerationType
  currentMap = {}
  abstractTypes['StructureGenerationType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:50_00002'] = currentMap
  loadMaps['NMR.StructureGenerationType'] = currentMap
  currentMap['tag'] = 'NMR.StructureGenerationType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:50_00002'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType T1CoherenceType
  currentMap = {}
  abstractTypes['T1CoherenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00039'] = currentMap
  loadMaps['NMR.T1CoherenceType'] = currentMap
  currentMap['tag'] = 'NMR.T1CoherenceType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00039'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType T2CoherenceType
  currentMap = {}
  abstractTypes['T2CoherenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00001'] = currentMap
  loadMaps['NMR.T2CoherenceType'] = currentMap
  currentMap['tag'] = 'NMR.T2CoherenceType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType TempCalibMethod
  currentMap = {}
  abstractTypes['TempCalibMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00001'] = currentMap
  loadMaps['NMR.TempCalibMethod'] = currentMap
  currentMap['tag'] = 'NMR.TempCalibMethod'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType TempControlMethod
  currentMap = {}
  abstractTypes['TempControlMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00002'] = currentMap
  loadMaps['NMR.TempControlMethod'] = currentMap
  currentMap['tag'] = 'NMR.TempControlMethod'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00002'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # Class AbstractDataDerivation
  currentMap = {}
  abstractTypes['AbstractDataDerivation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00007'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00007'
  currentMap['eType'] = 'cplx'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.AbstractDataDerivation
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractDataDerivation.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractDataDerivation.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00042'] = currentMap
  loadMaps['NMR.AbstractDataDerivation.details'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDerivation.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00042'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute AbstractDataDerivation.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00041'] = currentMap
  loadMaps['NMR.AbstractDataDerivation.serial'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDerivation.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00041'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AbstractDataDerivation.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AbstractDataDerivation.inputMeasurements
  currentMap = {}
  contentMap['inputMeasurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00013'] = currentMap
  loadMaps['NMR.AbstractDataDerivation.inputMeasurements'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDerivation.inputMeasurements'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00013'
  currentMap['name'] = 'inputMeasurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AbstractDataDerivation.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00038'] = currentMap
  loadMaps['NMR.AbstractDataDerivation.method'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDerivation.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00038'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role AbstractDataDerivation.peakDims
  currentMap = {}
  contentMap['peakDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00034'] = currentMap
  loadMaps['NMR.AbstractDataDerivation.peakDims'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDerivation.peakDims'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00034'
  currentMap['name'] = 'peakDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AbstractDataDerivation.peaks
  currentMap = {}
  contentMap['peaks'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00036'] = currentMap
  loadMaps['NMR.AbstractDataDerivation.peaks'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDerivation.peaks'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00036'
  currentMap['name'] = 'peaks'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AbstractDataDerivation

  currentMap = abstractTypes.get('AbstractDataDerivation')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'inputMeasurements', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AbstractDataDim
  currentMap = {}
  abstractTypes['AbstractDataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00008'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataDims'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.AbstractDataDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractDataDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractDataDim.dim
  currentMap = {}
  contentMap['dim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00003'] = currentMap
  loadMaps['NMR.AbstractDataDim.dim'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.dim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00003'
  currentMap['name'] = 'dim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AbstractDataDim.fileDim
  currentMap = {}
  contentMap['fileDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00001'] = currentMap
  loadMaps['NMR.AbstractDataDim.fileDim'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.fileDim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00001'
  currentMap['name'] = 'fileDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute AbstractDataDim.isComplex
  currentMap = {}
  contentMap['isComplex'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00006'] = currentMap
  loadMaps['NMR.AbstractDataDim.isComplex'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.isComplex'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00006'
  currentMap['name'] = 'isComplex'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AbstractDataDim.numPoints
  currentMap = {}
  contentMap['numPoints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00005'] = currentMap
  loadMaps['NMR.AbstractDataDim.numPoints'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.numPoints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00005'
  currentMap['name'] = 'numPoints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute AbstractDataDim.shapeSerial
  currentMap = {}
  contentMap['shapeSerial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00002'] = currentMap
  loadMaps['NMR.AbstractDataDim.shapeSerial'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.shapeSerial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00002'
  currentMap['name'] = 'shapeSerial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AbstractDataDim.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00007'] = currentMap
  loadMaps['NMR.AbstractDataDim.unit'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00007'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role AbstractDataDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AbstractDataDim.dimensionScalings
  currentMap = {}
  contentMap['dimensionScalings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00002'] = currentMap
  loadMaps['NMR.AbstractDataDim.dimensionScalings'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.dimensionScalings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00002'
  currentMap['name'] = 'dimensionScalings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role AbstractDataDim.expDim
  currentMap = {}
  contentMap['expDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00046'] = currentMap
  loadMaps['NMR.AbstractDataDim.expDim'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.expDim'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00046'
  currentMap['name'] = 'expDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role AbstractDataDim.predictMethod
  currentMap = {}
  contentMap['predictMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00001'] = currentMap
  loadMaps['NMR.AbstractDataDim.predictMethod'] = currentMap
  currentMap['tag'] = 'NMR.AbstractDataDim.predictMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00001'
  currentMap['name'] = 'predictMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')
  # End of AbstractDataDim

  currentMap = abstractTypes.get('AbstractDataDim')
  aList = ['dim', 'fileDim', 'isComplex', 'numPoints', 'shapeSerial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['expDim']
  currentMap['optLinks'] = aList
  aList = ['dimensionScalings', 'predictMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['dimensionScalings']
  currentMap['children'] = aList

  # Class AbstractMeasurement
  currentMap = {}
  abstractTypes['AbstractMeasurement'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00009'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00009'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.AbstractMeasurement
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractMeasurement.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractMeasurement.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018'] = currentMap
  loadMaps['NMR.AbstractMeasurement.details'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute AbstractMeasurement.error
  currentMap = {}
  contentMap['error'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016'] = currentMap
  loadMaps['NMR.AbstractMeasurement.error'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.error'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016'
  currentMap['name'] = 'error'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute AbstractMeasurement.figOfMerit
  currentMap = {}
  contentMap['figOfMerit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017'] = currentMap
  loadMaps['NMR.AbstractMeasurement.figOfMerit'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.figOfMerit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017'
  currentMap['name'] = 'figOfMerit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute AbstractMeasurement.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015'] = currentMap
  loadMaps['NMR.AbstractMeasurement.value'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role AbstractMeasurement.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AbstractMeasurement.dataDerivations
  currentMap = {}
  contentMap['dataDerivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014'] = currentMap
  loadMaps['NMR.AbstractMeasurement.dataDerivations'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.dataDerivations'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014'
  currentMap['name'] = 'dataDerivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AbstractMeasurement.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010'] = currentMap
  loadMaps['NMR.AbstractMeasurement.method'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role AbstractMeasurement.nmrMeasurementValidations
  currentMap = {}
  contentMap['nmrMeasurementValidations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006'] = currentMap
  loadMaps['NMR.AbstractMeasurement.nmrMeasurementValidations'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.nmrMeasurementValidations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006'
  currentMap['name'] = 'nmrMeasurementValidations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('VALD').get('exolinks')

  # Role AbstractMeasurement.peakDims
  currentMap = {}
  contentMap['peakDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012'] = currentMap
  loadMaps['NMR.AbstractMeasurement.peakDims'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.peakDims'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012'
  currentMap['name'] = 'peakDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AbstractMeasurement.peaks
  currentMap = {}
  contentMap['peaks'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010'] = currentMap
  loadMaps['NMR.AbstractMeasurement.peaks'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurement.peaks'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010'
  currentMap['name'] = 'peaks'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AbstractMeasurement

  currentMap = abstractTypes.get('AbstractMeasurement')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AbstractMeasurementList
  currentMap = {}
  abstractTypes['AbstractMeasurementList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00010'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.AbstractMeasurementList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractMeasurementList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractMeasurementList.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009'] = currentMap
  loadMaps['NMR.AbstractMeasurementList.details'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurementList.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute AbstractMeasurementList.isSimulated
  currentMap = {}
  contentMap['isSimulated'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001'] = currentMap
  loadMaps['NMR.AbstractMeasurementList.isSimulated'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurementList.isSimulated'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001'
  currentMap['name'] = 'isSimulated'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AbstractMeasurementList.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007'] = currentMap
  loadMaps['NMR.AbstractMeasurementList.name'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurementList.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AbstractMeasurementList.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006'] = currentMap
  loadMaps['NMR.AbstractMeasurementList.serial'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurementList.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AbstractMeasurementList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AbstractMeasurementList.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003'] = currentMap
  loadMaps['NMR.AbstractMeasurementList.method'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurementList.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role AbstractMeasurementList.nmrMeasurementListValidations
  currentMap = {}
  contentMap['nmrMeasurementListValidations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004'] = currentMap
  loadMaps['NMR.AbstractMeasurementList.nmrMeasurementListValidations'] = currentMap
  currentMap['tag'] = 'NMR.AbstractMeasurementList.nmrMeasurementListValidations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004'
  currentMap['name'] = 'nmrMeasurementListValidations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('VALD').get('exolinks')
  # End of AbstractMeasurementList

  currentMap = abstractTypes.get('AbstractMeasurementList')
  aList = ['isSimulated', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AbstractPeakDimContrib
  currentMap = {}
  abstractTypes['AbstractPeakDimContrib'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00020'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00020'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakDimContribs'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.AbstractPeakDimContrib
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractPeakDimContrib.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractPeakDimContrib.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00052'] = currentMap
  loadMaps['NMR.AbstractPeakDimContrib.serial'] = currentMap
  currentMap['tag'] = 'NMR.AbstractPeakDimContrib.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00052'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AbstractPeakDimContrib.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AbstractPeakDimContrib.peakContribs
  currentMap = {}
  contentMap['peakContribs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00041'] = currentMap
  loadMaps['NMR.AbstractPeakDimContrib.peakContribs'] = currentMap
  currentMap['tag'] = 'NMR.AbstractPeakDimContrib.peakContribs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00041'
  currentMap['name'] = 'peakContribs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role AbstractPeakDimContrib.peakDimComponent
  currentMap = {}
  contentMap['peakDimComponent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:27_00002'] = currentMap
  loadMaps['NMR.AbstractPeakDimContrib.peakDimComponent'] = currentMap
  currentMap['tag'] = 'NMR.AbstractPeakDimContrib.peakDimComponent'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:27_00002'
  currentMap['name'] = 'peakDimComponent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AbstractPeakDimContrib

  currentMap = abstractTypes.get('AbstractPeakDimContrib')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['peakContribs']
  currentMap['simpleAttrs'] = aList
  aList = ['peakDimComponent']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AtomSet
  currentMap = {}
  abstractTypes['AtomSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00015'] = currentMap
  loadMaps['NMR.AtomSet'] = currentMap
  currentMap['tag'] = 'NMR.AtomSet'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00015'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'atomSets'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.AtomSet
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AtomSet.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AtomSet.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00005'] = currentMap
  loadMaps['NMR.AtomSet.name'] = currentMap
  currentMap['tag'] = 'NMR.AtomSet.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00005'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AtomSet.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00004'] = currentMap
  loadMaps['NMR.AtomSet.serial'] = currentMap
  currentMap['tag'] = 'NMR.AtomSet.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00004'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AtomSet.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AtomSet.atoms
  currentMap = {}
  contentMap['atoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00003'] = currentMap
  loadMaps['NMR.AtomSet.atoms'] = currentMap
  currentMap['tag'] = 'NMR.AtomSet.atoms'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00003'
  currentMap['name'] = 'atoms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role AtomSet.resonanceSets
  currentMap = {}
  contentMap['resonanceSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00001'] = currentMap
  loadMaps['NMR.AtomSet.resonanceSets'] = currentMap
  currentMap['tag'] = 'NMR.AtomSet.resonanceSets'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00001'
  currentMap['name'] = 'resonanceSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AtomSet

  currentMap = abstractTypes.get('AtomSet')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['name', 'resonanceSets']
  currentMap['simpleAttrs'] = aList
  aList = ['atoms', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChainState
  currentMap = {}
  abstractTypes['ChainState'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00017'] = currentMap
  loadMaps['NMR.ChainState'] = currentMap
  currentMap['tag'] = 'NMR.ChainState'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00017'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chainStates'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ChainState
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChainState.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChainState.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00010'] = currentMap
  loadMaps['NMR.ChainState.details'] = currentMap
  currentMap['tag'] = 'NMR.ChainState.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00010'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute ChainState.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00009'] = currentMap
  loadMaps['NMR.ChainState.name'] = currentMap
  currentMap['tag'] = 'NMR.ChainState.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00009'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChainState.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00008'] = currentMap
  loadMaps['NMR.ChainState.serial'] = currentMap
  currentMap['tag'] = 'NMR.ChainState.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00008'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ChainState.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChainState.expChainStates
  currentMap = {}
  contentMap['expChainStates'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00012'] = currentMap
  loadMaps['NMR.ChainState.expChainStates'] = currentMap
  currentMap['tag'] = 'NMR.ChainState.expChainStates'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00012'
  currentMap['name'] = 'expChainStates'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ChainState.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00004'] = currentMap
  loadMaps['NMR.ChainState.resonances'] = currentMap
  currentMap['tag'] = 'NMR.ChainState.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00004'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of ChainState

  currentMap = abstractTypes.get('ChainState')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'expChainStates', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChainStateSet
  currentMap = {}
  abstractTypes['ChainStateSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00018'] = currentMap
  loadMaps['NMR.ChainStateSet'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00018'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chainStateSets'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ChainStateSet
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChainStateSet.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChainStateSet.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00016'] = currentMap
  loadMaps['NMR.ChainStateSet.details'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00016'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute ChainStateSet.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00014'] = currentMap
  loadMaps['NMR.ChainStateSet.serial'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00014'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ChainStateSet.stateSetType
  currentMap = {}
  contentMap['stateSetType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00015'] = currentMap
  loadMaps['NMR.ChainStateSet.stateSetType'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.stateSetType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00015'
  currentMap['name'] = 'stateSetType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00002')

  # Role ChainStateSet.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChainStateSet.atoms
  currentMap = {}
  contentMap['atoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00012'] = currentMap
  loadMaps['NMR.ChainStateSet.atoms'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.atoms'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00012'
  currentMap['name'] = 'atoms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role ChainStateSet.chain
  currentMap = {}
  contentMap['chain'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:31_00037'] = currentMap
  loadMaps['NMR.ChainStateSet.chain'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.chain'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:31_00037'
  currentMap['name'] = 'chain'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role ChainStateSet.chainStates
  currentMap = {}
  contentMap['chainStates'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00006'] = currentMap
  loadMaps['NMR.ChainStateSet.chainStates'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.chainStates'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00006'
  currentMap['name'] = 'chainStates'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ChainStateSet.residues
  currentMap = {}
  contentMap['residues'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:32_00035'] = currentMap
  loadMaps['NMR.ChainStateSet.residues'] = currentMap
  currentMap['tag'] = 'NMR.ChainStateSet.residues'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:32_00035'
  currentMap['name'] = 'residues'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')
  # End of ChainStateSet

  currentMap = abstractTypes.get('ChainStateSet')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'stateSetType']
  currentMap['simpleAttrs'] = aList
  aList = ['chainStates', 'residues', 'chain', 'atoms', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['chainStates']
  currentMap['children'] = aList

  # Class DataDimRef
  currentMap = {}
  abstractTypes['DataDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00019'] = currentMap
  loadMaps['NMR.DataDimRef'] = currentMap
  currentMap['tag'] = 'NMR.DataDimRef'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00019'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataDimRefs'
  currentMap['objkey'] = 'expDimRef'
  currentMap['class'] = ccp.api.nmr.Nmr.DataDimRef
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DataDimRef.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DataDimRef.localValuePerPoint
  currentMap = {}
  contentMap['localValuePerPoint'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-10-15-12:22:42_00001'] = currentMap
  loadMaps['NMR.DataDimRef.localValuePerPoint'] = currentMap
  currentMap['tag'] = 'NMR.DataDimRef.localValuePerPoint'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-10-15-12:22:42_00001'
  currentMap['name'] = 'localValuePerPoint'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute DataDimRef.refPoint
  currentMap = {}
  contentMap['refPoint'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00022'] = currentMap
  loadMaps['NMR.DataDimRef.refPoint'] = currentMap
  currentMap['tag'] = 'NMR.DataDimRef.refPoint'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00022'
  currentMap['name'] = 'refPoint'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute DataDimRef.refValue
  currentMap = {}
  contentMap['refValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00023'] = currentMap
  loadMaps['NMR.DataDimRef.refValue'] = currentMap
  currentMap['tag'] = 'NMR.DataDimRef.refValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00023'
  currentMap['name'] = 'refValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role DataDimRef.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DataDimRef.expDimRef
  currentMap = {}
  contentMap['expDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00018'] = currentMap
  loadMaps['NMR.DataDimRef.expDimRef'] = currentMap
  currentMap['tag'] = 'NMR.DataDimRef.expDimRef'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00018'
  currentMap['name'] = 'expDimRef'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of DataDimRef

  currentMap = abstractTypes.get('DataDimRef')
  aList = ['localValuePerPoint', 'refPoint', 'refValue']
  currentMap['headerAttrs'] = aList
  aList = ['expDimRef']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class DataSource
  currentMap = {}
  abstractTypes['DataSource'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00020'] = currentMap
  loadMaps['NMR.DataSource'] = currentMap
  currentMap['tag'] = 'NMR.DataSource'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00020'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataSources'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DataSource
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DataSource.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DataSource.dataType
  currentMap = {}
  contentMap['dataType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00023'] = currentMap
  loadMaps['NMR.DataSource.dataType'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.dataType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00023'
  currentMap['name'] = 'dataType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00007')

  # Attribute DataSource.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00013'] = currentMap
  loadMaps['NMR.DataSource.details'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00013'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute DataSource.isNormalStorage
  currentMap = {}
  contentMap['isNormalStorage'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00021'] = currentMap
  loadMaps['NMR.DataSource.isNormalStorage'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.isNormalStorage'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00021'
  currentMap['name'] = 'isNormalStorage'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute DataSource.isSimulated
  currentMap = {}
  contentMap['isSimulated'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00024'] = currentMap
  loadMaps['NMR.DataSource.isSimulated'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.isSimulated'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00024'
  currentMap['name'] = 'isSimulated'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute DataSource.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00008'] = currentMap
  loadMaps['NMR.DataSource.name'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00008'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute DataSource.noiseLevel
  currentMap = {}
  contentMap['noiseLevel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00012'] = currentMap
  loadMaps['NMR.DataSource.noiseLevel'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.noiseLevel'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00012'
  currentMap['name'] = 'noiseLevel'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute DataSource.numDim
  currentMap = {}
  contentMap['numDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00009'] = currentMap
  loadMaps['NMR.DataSource.numDim'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.numDim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00009'
  currentMap['name'] = 'numDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute DataSource.numShapes
  currentMap = {}
  contentMap['numShapes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:28:17_00001'] = currentMap
  loadMaps['NMR.DataSource.numShapes'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.numShapes'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:28:17_00001'
  currentMap['name'] = 'numShapes'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute DataSource.numSparsePoints
  currentMap = {}
  contentMap['numSparsePoints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:28:17_00002'] = currentMap
  loadMaps['NMR.DataSource.numSparsePoints'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.numSparsePoints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:28:17_00002'
  currentMap['name'] = 'numSparsePoints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute DataSource.recordNumber
  currentMap = {}
  contentMap['recordNumber'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-04-18:22:44_00003'] = currentMap
  loadMaps['NMR.DataSource.recordNumber'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.recordNumber'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-04-18:22:44_00003'
  currentMap['name'] = 'recordNumber'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute DataSource.scale
  currentMap = {}
  contentMap['scale'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00011'] = currentMap
  loadMaps['NMR.DataSource.scale'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.scale'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00011'
  currentMap['name'] = 'scale'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute DataSource.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00007'] = currentMap
  loadMaps['NMR.DataSource.serial'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00007'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute DataSource.signalLevel
  currentMap = {}
  contentMap['signalLevel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-18:38:48_00001'] = currentMap
  loadMaps['NMR.DataSource.signalLevel'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.signalLevel'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-18:38:48_00001'
  currentMap['name'] = 'signalLevel'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute DataSource.storageDetails
  currentMap = {}
  contentMap['storageDetails'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00022'] = currentMap
  loadMaps['NMR.DataSource.storageDetails'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.storageDetails'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00022'
  currentMap['name'] = 'storageDetails'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Role DataSource.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DataSource.activePeakList
  currentMap = {}
  contentMap['activePeakList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00003'] = currentMap
  loadMaps['NMR.DataSource.activePeakList'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.activePeakList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00003'
  currentMap['name'] = 'activePeakList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role DataSource.compressMethod
  currentMap = {}
  contentMap['compressMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00002'] = currentMap
  loadMaps['NMR.DataSource.compressMethod'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.compressMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00002'
  currentMap['name'] = 'compressMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role DataSource.dataDims
  currentMap = {}
  contentMap['dataDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00043'] = currentMap
  loadMaps['NMR.DataSource.dataDims'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.dataDims'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00043'
  currentMap['name'] = 'dataDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role DataSource.dataSourceImages
  currentMap = {}
  contentMap['dataSourceImages'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-03-02-12:02:06_00003'] = currentMap
  loadMaps['NMR.DataSource.dataSourceImages'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.dataSourceImages'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-03-02-12:02:06_00003'
  currentMap['name'] = 'dataSourceImages'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role DataSource.dataStore
  currentMap = {}
  contentMap['dataStore'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-04-18:22:44_00002'] = currentMap
  loadMaps['NMR.DataSource.dataStore'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.dataStore'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-04-18:22:44_00002'
  currentMap['name'] = 'dataStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('DLOC').get('exolinks')

  # Role DataSource.peakLists
  currentMap = {}
  contentMap['peakLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00019'] = currentMap
  loadMaps['NMR.DataSource.peakLists'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.peakLists'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00019'
  currentMap['name'] = 'peakLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role DataSource.processMethod
  currentMap = {}
  contentMap['processMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00021'] = currentMap
  loadMaps['NMR.DataSource.processMethod'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.processMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00021'
  currentMap['name'] = 'processMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role DataSource.processedFrom
  currentMap = {}
  contentMap['processedFrom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00016'] = currentMap
  loadMaps['NMR.DataSource.processedFrom'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.processedFrom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00016'
  currentMap['name'] = 'processedFrom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role DataSource.processedTo
  currentMap = {}
  contentMap['processedTo'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00017'] = currentMap
  loadMaps['NMR.DataSource.processedTo'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.processedTo'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00017'
  currentMap['name'] = 'processedTo'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role DataSource.snMethod
  currentMap = {}
  contentMap['snMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-03-02-12:02:06_00001'] = currentMap
  loadMaps['NMR.DataSource.snMethod'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.snMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-03-02-12:02:06_00001'
  currentMap['name'] = 'snMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role DataSource.sparseSamplings
  currentMap = {}
  contentMap['sparseSamplings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:28:16_00002'] = currentMap
  loadMaps['NMR.DataSource.sparseSamplings'] = currentMap
  currentMap['tag'] = 'NMR.DataSource.sparseSamplings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:28:16_00002'
  currentMap['name'] = 'sparseSamplings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')
  # End of DataSource

  currentMap = abstractTypes.get('DataSource')
  aList = ['isNormalStorage', 'isSimulated', 'noiseLevel', 'numDim', 'numShapes', 'numSparsePoints', 'recordNumber', 'scale', 'serial', 'signalLevel']
  currentMap['headerAttrs'] = aList
  aList = ['dataType', 'details', 'name', 'storageDetails', 'activePeakList', 'processedTo']
  currentMap['simpleAttrs'] = aList
  aList = ['processedFrom']
  currentMap['optLinks'] = aList
  aList = ['sparseSamplings', 'peakLists', 'dataSourceImages', 'dataDims', 'snMethod', 'processMethod', 'dataStore', 'compressMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['dataDims', 'dataSourceImages', 'peakLists', 'sparseSamplings']
  currentMap['children'] = aList

  # Class DataSourceImage
  currentMap = {}
  abstractTypes['DataSourceImage'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-03-02-12:01:34_00001'] = currentMap
  loadMaps['NMR.DataSourceImage'] = currentMap
  currentMap['tag'] = 'NMR.DataSourceImage'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-03-02-12:01:34_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataSourceImages'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DataSourceImage
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DataSourceImage.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DataSourceImage.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-03-02-12:02:06_00005'] = currentMap
  loadMaps['NMR.DataSourceImage.serial'] = currentMap
  currentMap['tag'] = 'NMR.DataSourceImage.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-03-02-12:02:06_00005'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role DataSourceImage.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DataSourceImage.dataStore
  currentMap = {}
  contentMap['dataStore'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-04-18:22:45_00002'] = currentMap
  loadMaps['NMR.DataSourceImage.dataStore'] = currentMap
  currentMap['tag'] = 'NMR.DataSourceImage.dataStore'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-04-18:22:45_00002'
  currentMap['name'] = 'dataStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('DLOC').get('exolinks')
  # End of DataSourceImage

  currentMap = abstractTypes.get('DataSourceImage')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['dataStore', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class DerivedData
  currentMap = {}
  abstractTypes['DerivedData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00021'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00021'
  currentMap['eType'] = 'cplx'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DerivedData
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DerivedData.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DerivedData.error
  currentMap = {}
  contentMap['error'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00027'] = currentMap
  loadMaps['NMR.DerivedData.error'] = currentMap
  currentMap['tag'] = 'NMR.DerivedData.error'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00027'
  currentMap['name'] = 'error'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute DerivedData.figOfMerit
  currentMap = {}
  contentMap['figOfMerit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00028'] = currentMap
  loadMaps['NMR.DerivedData.figOfMerit'] = currentMap
  currentMap['tag'] = 'NMR.DerivedData.figOfMerit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00028'
  currentMap['name'] = 'figOfMerit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute DerivedData.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00025'] = currentMap
  loadMaps['NMR.DerivedData.serial'] = currentMap
  currentMap['tag'] = 'NMR.DerivedData.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00025'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute DerivedData.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00026'] = currentMap
  loadMaps['NMR.DerivedData.value'] = currentMap
  currentMap['tag'] = 'NMR.DerivedData.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00026'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role DerivedData.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of DerivedData

  currentMap = abstractTypes.get('DerivedData')
  aList = ['error', 'figOfMerit', 'serial', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class DerivedDataList
  currentMap = {}
  abstractTypes['DerivedDataList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00022'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00022'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedDataLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DerivedDataList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DerivedDataList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DerivedDataList.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00004'] = currentMap
  loadMaps['NMR.DerivedDataList.details'] = currentMap
  currentMap['tag'] = 'NMR.DerivedDataList.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00004'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute DerivedDataList.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00003'] = currentMap
  loadMaps['NMR.DerivedDataList.serial'] = currentMap
  currentMap['tag'] = 'NMR.DerivedDataList.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00003'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role DerivedDataList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DerivedDataList.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00032'] = currentMap
  loadMaps['NMR.DerivedDataList.method'] = currentMap
  currentMap['tag'] = 'NMR.DerivedDataList.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00032'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')
  # End of DerivedDataList

  currentMap = abstractTypes.get('DerivedDataList')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details']
  currentMap['simpleAttrs'] = aList
  aList = ['method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class DimensionScaling
  currentMap = {}
  abstractTypes['DimensionScaling'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00002'] = currentMap
  loadMaps['NMR.DimensionScaling'] = currentMap
  currentMap['tag'] = 'NMR.DimensionScaling'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dimensionScalings'
  currentMap['objkey'] = 'expDimRef'
  currentMap['class'] = ccp.api.nmr.Nmr.DimensionScaling
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DimensionScaling.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DimensionScaling.scalingFactors
  currentMap = {}
  contentMap['scalingFactors'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00003'] = currentMap
  loadMaps['NMR.DimensionScaling.scalingFactors'] = currentMap
  currentMap['tag'] = 'NMR.DimensionScaling.scalingFactors'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00003'
  currentMap['name'] = 'scalingFactors'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role DimensionScaling.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DimensionScaling.expDimRef
  currentMap = {}
  contentMap['expDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00003'] = currentMap
  loadMaps['NMR.DimensionScaling.expDimRef'] = currentMap
  currentMap['tag'] = 'NMR.DimensionScaling.expDimRef'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00003'
  currentMap['name'] = 'expDimRef'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of DimensionScaling

  currentMap = abstractTypes.get('DimensionScaling')
  aList = ['scalingFactors']
  currentMap['simpleAttrs'] = aList
  aList = ['expDimRef']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ExpChainState
  currentMap = {}
  abstractTypes['ExpChainState'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00025'] = currentMap
  loadMaps['NMR.ExpChainState'] = currentMap
  currentMap['tag'] = 'NMR.ExpChainState'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00025'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'expChainStates'
  currentMap['objkey'] = 'chainState'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpChainState
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExpChainState.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExpChainState.weight
  currentMap = {}
  contentMap['weight'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00016'] = currentMap
  loadMaps['NMR.ExpChainState.weight'] = currentMap
  currentMap['tag'] = 'NMR.ExpChainState.weight'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00016'
  currentMap['name'] = 'weight'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role ExpChainState.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExpChainState.chainState
  currentMap = {}
  contentMap['chainState'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00013'] = currentMap
  loadMaps['NMR.ExpChainState.chainState'] = currentMap
  currentMap['tag'] = 'NMR.ExpChainState.chainState'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00013'
  currentMap['name'] = 'chainState'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ExpChainState

  currentMap = abstractTypes.get('ExpChainState')
  aList = ['weight']
  currentMap['headerAttrs'] = aList
  aList = ['chainState']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ExpDim
  currentMap = {}
  abstractTypes['ExpDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00026'] = currentMap
  loadMaps['NMR.ExpDim'] = currentMap
  currentMap['tag'] = 'NMR.ExpDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00026'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'expDims'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExpDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExpDim.dim
  currentMap = {}
  contentMap['dim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00019'] = currentMap
  loadMaps['NMR.ExpDim.dim'] = currentMap
  currentMap['tag'] = 'NMR.ExpDim.dim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00019'
  currentMap['name'] = 'dim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute ExpDim.isAcquisition
  currentMap = {}
  contentMap['isAcquisition'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00021'] = currentMap
  loadMaps['NMR.ExpDim.isAcquisition'] = currentMap
  currentMap['tag'] = 'NMR.ExpDim.isAcquisition'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00021'
  currentMap['name'] = 'isAcquisition'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role ExpDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExpDim.dataDims
  currentMap = {}
  contentMap['dataDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00045'] = currentMap
  loadMaps['NMR.ExpDim.dataDims'] = currentMap
  currentMap['tag'] = 'NMR.ExpDim.dataDims'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00045'
  currentMap['name'] = 'dataDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ExpDim.expDimRefs
  currentMap = {}
  contentMap['expDimRefs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00022'] = currentMap
  loadMaps['NMR.ExpDim.expDimRefs'] = currentMap
  currentMap['tag'] = 'NMR.ExpDim.expDimRefs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00022'
  currentMap['name'] = 'expDimRefs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ExpDim.refExpDim
  currentMap = {}
  contentMap['refExpDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:00_00002'] = currentMap
  loadMaps['NMR.ExpDim.refExpDim'] = currentMap
  currentMap['tag'] = 'NMR.ExpDim.refExpDim'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:00_00002'
  currentMap['name'] = 'refExpDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRX').get('exolinks')
  # End of ExpDim

  currentMap = abstractTypes.get('ExpDim')
  aList = ['dim', 'isAcquisition']
  currentMap['headerAttrs'] = aList
  aList = ['dataDims']
  currentMap['simpleAttrs'] = aList
  aList = ['expDimRefs', 'refExpDim', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['expDimRefs']
  currentMap['children'] = aList

  # Class ExpDimRef
  currentMap = {}
  abstractTypes['ExpDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00027'] = currentMap
  loadMaps['NMR.ExpDimRef'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00027'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'expDimRefs'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpDimRef
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExpDimRef.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExpDimRef.baseFrequency
  currentMap = {}
  contentMap['baseFrequency'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00044'] = currentMap
  loadMaps['NMR.ExpDimRef.baseFrequency'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.baseFrequency'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00044'
  currentMap['name'] = 'baseFrequency'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpDimRef.constantTimePeriod
  currentMap = {}
  contentMap['constantTimePeriod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00042'] = currentMap
  loadMaps['NMR.ExpDimRef.constantTimePeriod'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.constantTimePeriod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00042'
  currentMap['name'] = 'constantTimePeriod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpDimRef.displayName
  currentMap = {}
  contentMap['displayName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-03-15:13:49_00002'] = currentMap
  loadMaps['NMR.ExpDimRef.displayName'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.displayName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-03-15:13:49_00002'
  currentMap['name'] = 'displayName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ExpDimRef.groupingNumber
  currentMap = {}
  contentMap['groupingNumber'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-06-26-16:48:08_00001'] = currentMap
  loadMaps['NMR.ExpDimRef.groupingNumber'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.groupingNumber'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-06-26-16:48:08_00001'
  currentMap['name'] = 'groupingNumber'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute ExpDimRef.isAxisReversed
  currentMap = {}
  contentMap['isAxisReversed'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00035'] = currentMap
  loadMaps['NMR.ExpDimRef.isAxisReversed'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.isAxisReversed'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00035'
  currentMap['name'] = 'isAxisReversed'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ExpDimRef.isFolded
  currentMap = {}
  contentMap['isFolded'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00032'] = currentMap
  loadMaps['NMR.ExpDimRef.isFolded'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.isFolded'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00032'
  currentMap['name'] = 'isFolded'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ExpDimRef.isotopeCodes
  currentMap = {}
  contentMap['isotopeCodes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00030'] = currentMap
  loadMaps['NMR.ExpDimRef.isotopeCodes'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.isotopeCodes'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00030'
  currentMap['name'] = 'isotopeCodes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ExpDimRef.maxAliasedFreq
  currentMap = {}
  contentMap['maxAliasedFreq'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00036'] = currentMap
  loadMaps['NMR.ExpDimRef.maxAliasedFreq'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.maxAliasedFreq'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00036'
  currentMap['name'] = 'maxAliasedFreq'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpDimRef.measurementType
  currentMap = {}
  contentMap['measurementType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00031'] = currentMap
  loadMaps['NMR.ExpDimRef.measurementType'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.measurementType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00031'
  currentMap['name'] = 'measurementType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'Shift'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00030')

  # Attribute ExpDimRef.minAliasedFreq
  currentMap = {}
  contentMap['minAliasedFreq'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00038'] = currentMap
  loadMaps['NMR.ExpDimRef.minAliasedFreq'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.minAliasedFreq'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00038'
  currentMap['name'] = 'minAliasedFreq'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpDimRef.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00006'] = currentMap
  loadMaps['NMR.ExpDimRef.name'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00006'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ExpDimRef.nominalRefValue
  currentMap = {}
  contentMap['nominalRefValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00043'] = currentMap
  loadMaps['NMR.ExpDimRef.nominalRefValue'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.nominalRefValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00043'
  currentMap['name'] = 'nominalRefValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpDimRef.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00028'] = currentMap
  loadMaps['NMR.ExpDimRef.serial'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00028'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ExpDimRef.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00029'] = currentMap
  loadMaps['NMR.ExpDimRef.sf'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00029'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpDimRef.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00033'] = currentMap
  loadMaps['NMR.ExpDimRef.unit'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00033'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ExpDimRef.variableIncrFraction
  currentMap = {}
  contentMap['variableIncrFraction'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00041'] = currentMap
  loadMaps['NMR.ExpDimRef.variableIncrFraction'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.variableIncrFraction'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00041'
  currentMap['name'] = 'variableIncrFraction'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Role ExpDimRef.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExpDimRef.dataDimRefs
  currentMap = {}
  contentMap['dataDimRefs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00017'] = currentMap
  loadMaps['NMR.ExpDimRef.dataDimRefs'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.dataDimRefs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:02_00017'
  currentMap['name'] = 'dataDimRefs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ExpDimRef.derivedTo
  currentMap = {}
  contentMap['derivedTo'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00007'] = currentMap
  loadMaps['NMR.ExpDimRef.derivedTo'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.derivedTo'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00007'
  currentMap['name'] = 'derivedTo'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ExpDimRef.dimensionScalings
  currentMap = {}
  contentMap['dimensionScalings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00004'] = currentMap
  loadMaps['NMR.ExpDimRef.dimensionScalings'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.dimensionScalings'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00004'
  currentMap['name'] = 'dimensionScalings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ExpDimRef.expDimRefMappings
  currentMap = {}
  contentMap['expDimRefMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00002'] = currentMap
  loadMaps['NMR.ExpDimRef.expDimRefMappings'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.expDimRefMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:49_00002'
  currentMap['name'] = 'expDimRefMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ExpDimRef.expTransfers
  currentMap = {}
  contentMap['expTransfers'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00023'] = currentMap
  loadMaps['NMR.ExpDimRef.expTransfers'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.expTransfers'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00023'
  currentMap['name'] = 'expTransfers'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ExpDimRef.refExpDimRef
  currentMap = {}
  contentMap['refExpDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00025'] = currentMap
  loadMaps['NMR.ExpDimRef.refExpDimRef'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRef.refExpDimRef'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00025'
  currentMap['name'] = 'refExpDimRef'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRX').get('exolinks')
  # End of ExpDimRef

  currentMap = abstractTypes.get('ExpDimRef')
  aList = ['baseFrequency', 'constantTimePeriod', 'displayName', 'groupingNumber', 'isAxisReversed', 'isFolded', 'maxAliasedFreq', 'minAliasedFreq', 'name', 'nominalRefValue', 'serial', 'sf', 'unit', 'variableIncrFraction']
  currentMap['headerAttrs'] = aList
  aList = ['isotopeCodes', 'measurementType', 'dataDimRefs', 'derivedTo', 'dimensionScalings', 'expTransfers']
  currentMap['simpleAttrs'] = aList
  aList = ['expDimRefMappings', 'refExpDimRef', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['expDimRefMappings']
  currentMap['children'] = aList

  # Class ExpDimRefMapping
  currentMap = {}
  abstractTypes['ExpDimRefMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00001'] = currentMap
  loadMaps['NMR.ExpDimRefMapping'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRefMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'expDimRefMappings'
  currentMap['objkey'] = 'derivedFrom'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpDimRefMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExpDimRefMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExpDimRefMapping.mappedFromSign
  currentMap = {}
  contentMap['mappedFromSign'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:43:25_00002'] = currentMap
  loadMaps['NMR.ExpDimRefMapping.mappedFromSign'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRefMapping.mappedFromSign'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:43:25_00002'
  currentMap['name'] = 'mappedFromSign'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00003')

  # Role ExpDimRefMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExpDimRefMapping.derivedFrom
  currentMap = {}
  contentMap['derivedFrom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:43:25_00001'] = currentMap
  loadMaps['NMR.ExpDimRefMapping.derivedFrom'] = currentMap
  currentMap['tag'] = 'NMR.ExpDimRefMapping.derivedFrom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:43:25_00001'
  currentMap['name'] = 'derivedFrom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ExpDimRefMapping

  currentMap = abstractTypes.get('ExpDimRefMapping')
  aList = ['mappedFromSign']
  currentMap['headerAttrs'] = aList
  aList = ['derivedFrom']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ExpTransfer
  currentMap = {}
  abstractTypes['ExpTransfer'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00030'] = currentMap
  loadMaps['NMR.ExpTransfer'] = currentMap
  currentMap['tag'] = 'NMR.ExpTransfer'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00030'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'expTransfers'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpTransfer
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExpTransfer.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExpTransfer.isDirect
  currentMap = {}
  contentMap['isDirect'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2010-04-30-17:48:48_00001'] = currentMap
  loadMaps['NMR.ExpTransfer.isDirect'] = currentMap
  currentMap['tag'] = 'NMR.ExpTransfer.isDirect'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-04-30-17:48:48_00001'
  currentMap['name'] = 'isDirect'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ExpTransfer.mixingTime
  currentMap = {}
  contentMap['mixingTime'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00026'] = currentMap
  loadMaps['NMR.ExpTransfer.mixingTime'] = currentMap
  currentMap['tag'] = 'NMR.ExpTransfer.mixingTime'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00026'
  currentMap['name'] = 'mixingTime'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ExpTransfer.transferSubType
  currentMap = {}
  contentMap['transferSubType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00002'] = currentMap
  loadMaps['NMR.ExpTransfer.transferSubType'] = currentMap
  currentMap['tag'] = 'NMR.ExpTransfer.transferSubType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00002'
  currentMap['name'] = 'transferSubType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00027')

  # Attribute ExpTransfer.transferType
  currentMap = {}
  contentMap['transferType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00001'] = currentMap
  loadMaps['NMR.ExpTransfer.transferType'] = currentMap
  currentMap['tag'] = 'NMR.ExpTransfer.transferType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00001'
  currentMap['name'] = 'transferType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00029')

  # Role ExpTransfer.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExpTransfer.expDimRefs
  currentMap = {}
  contentMap['expDimRefs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00024'] = currentMap
  loadMaps['NMR.ExpTransfer.expDimRefs'] = currentMap
  currentMap['tag'] = 'NMR.ExpTransfer.expDimRefs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00024'
  currentMap['name'] = 'expDimRefs'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of ExpTransfer

  currentMap = abstractTypes.get('ExpTransfer')
  aList = ['isDirect', 'mixingTime', 'transferType']
  currentMap['headerAttrs'] = aList
  aList = ['transferSubType', 'expDimRefs']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Experiment
  currentMap = {}
  abstractTypes['Experiment'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00028'] = currentMap
  loadMaps['NMR.Experiment'] = currentMap
  currentMap['tag'] = 'NMR.Experiment'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00028'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'experiments'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.Experiment
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Experiment.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Experiment.date
  currentMap = {}
  contentMap['date'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-07-03-18:29:16_00001'] = currentMap
  loadMaps['NMR.Experiment.date'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.date'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-07-03-18:29:16_00001'
  currentMap['name'] = 'date'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00029')

  # Attribute Experiment.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00014'] = currentMap
  loadMaps['NMR.Experiment.details'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00014'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute Experiment.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00012'] = currentMap
  loadMaps['NMR.Experiment.name'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00012'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Experiment.nmrTubeType
  currentMap = {}
  contentMap['nmrTubeType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00020'] = currentMap
  loadMaps['NMR.Experiment.nmrTubeType'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.nmrTubeType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00020'
  currentMap['name'] = 'nmrTubeType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Experiment.numDim
  currentMap = {}
  contentMap['numDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00013'] = currentMap
  loadMaps['NMR.Experiment.numDim'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.numDim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00013'
  currentMap['name'] = 'numDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Experiment.numScans
  currentMap = {}
  contentMap['numScans'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00016'] = currentMap
  loadMaps['NMR.Experiment.numScans'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.numScans'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00016'
  currentMap['name'] = 'numScans'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Experiment.sampleState
  currentMap = {}
  contentMap['sampleState'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00017'] = currentMap
  loadMaps['NMR.Experiment.sampleState'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.sampleState'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00017'
  currentMap['name'] = 'sampleState'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00005')

  # Attribute Experiment.sampleVolume
  currentMap = {}
  contentMap['sampleVolume'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00018'] = currentMap
  loadMaps['NMR.Experiment.sampleVolume'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.sampleVolume'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00018'
  currentMap['name'] = 'sampleVolume'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Experiment.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00011'] = currentMap
  loadMaps['NMR.Experiment.serial'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00011'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Experiment.spinningAngle
  currentMap = {}
  contentMap['spinningAngle'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00021'] = currentMap
  loadMaps['NMR.Experiment.spinningAngle'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.spinningAngle'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00021'
  currentMap['name'] = 'spinningAngle'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Experiment.spinningRate
  currentMap = {}
  contentMap['spinningRate'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00022'] = currentMap
  loadMaps['NMR.Experiment.spinningRate'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.spinningRate'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00022'
  currentMap['name'] = 'spinningRate'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Experiment.userExpCode
  currentMap = {}
  contentMap['userExpCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2012-07-23-11:52:27_00001'] = currentMap
  loadMaps['NMR.Experiment.userExpCode'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.userExpCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2012-07-23-11:52:27_00001'
  currentMap['name'] = 'userExpCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Experiment.volumeUnit
  currentMap = {}
  contentMap['volumeUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00019'] = currentMap
  loadMaps['NMR.Experiment.volumeUnit'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.volumeUnit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00019'
  currentMap['name'] = 'volumeUnit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role Experiment.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Experiment.citations
  currentMap = {}
  contentMap['citations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00001'] = currentMap
  loadMaps['NMR.Experiment.citations'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.citations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00001'
  currentMap['name'] = 'citations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CITA').get('exolinks')

  # Role Experiment.dataLists
  currentMap = {}
  contentMap['dataLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00031'] = currentMap
  loadMaps['NMR.Experiment.dataLists'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.dataLists'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00031'
  currentMap['name'] = 'dataLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.dataSources
  currentMap = {}
  contentMap['dataSources'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00014'] = currentMap
  loadMaps['NMR.Experiment.dataSources'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.dataSources'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:03_00014'
  currentMap['name'] = 'dataSources'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Experiment.derivationMethod
  currentMap = {}
  contentMap['derivationMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-01-10-19:21:58_00003'] = currentMap
  loadMaps['NMR.Experiment.derivationMethod'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.derivationMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-01-10-19:21:58_00003'
  currentMap['name'] = 'derivationMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role Experiment.derivedFrom
  currentMap = {}
  contentMap['derivedFrom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-01-10-19:21:57_00001'] = currentMap
  loadMaps['NMR.Experiment.derivedFrom'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.derivedFrom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-01-10-19:21:57_00001'
  currentMap['name'] = 'derivedFrom'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.derivedTo
  currentMap = {}
  contentMap['derivedTo'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-01-10-19:21:58_00001'] = currentMap
  loadMaps['NMR.Experiment.derivedTo'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.derivedTo'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-01-10-19:21:58_00001'
  currentMap['name'] = 'derivedTo'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.dipolarRelaxList
  currentMap = {}
  contentMap['dipolarRelaxList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00009'] = currentMap
  loadMaps['NMR.Experiment.dipolarRelaxList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.dipolarRelaxList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00009'
  currentMap['name'] = 'dipolarRelaxList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.expChainStates
  currentMap = {}
  contentMap['expChainStates'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00014'] = currentMap
  loadMaps['NMR.Experiment.expChainStates'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.expChainStates'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00014'
  currentMap['name'] = 'expChainStates'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Experiment.expDims
  currentMap = {}
  contentMap['expDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00017'] = currentMap
  loadMaps['NMR.Experiment.expDims'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.expDims'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00017'
  currentMap['name'] = 'expDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Experiment.expTransfers
  currentMap = {}
  contentMap['expTransfers'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00005'] = currentMap
  loadMaps['NMR.Experiment.expTransfers'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.expTransfers'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00005'
  currentMap['name'] = 'expTransfers'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Experiment.hExchProtectionList
  currentMap = {}
  contentMap['hExchProtectionList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00040'] = currentMap
  loadMaps['NMR.Experiment.hExchProtectionList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.hExchProtectionList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00040'
  currentMap['name'] = 'hExchProtectionList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.hExchRateList
  currentMap = {}
  contentMap['hExchRateList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00048'] = currentMap
  loadMaps['NMR.Experiment.hExchRateList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.hExchRateList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00048'
  currentMap['name'] = 'hExchRateList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.isotropicS2List
  currentMap = {}
  contentMap['isotropicS2List'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00010'] = currentMap
  loadMaps['NMR.Experiment.isotropicS2List'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.isotropicS2List'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00010'
  currentMap['name'] = 'isotropicS2List'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.jCouplingList
  currentMap = {}
  contentMap['jCouplingList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00019'] = currentMap
  loadMaps['NMR.Experiment.jCouplingList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.jCouplingList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00019'
  currentMap['name'] = 'jCouplingList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.labeledMixtures
  currentMap = {}
  contentMap['labeledMixtures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-24-11:30:57_00011'] = currentMap
  loadMaps['NMR.Experiment.labeledMixtures'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.labeledMixtures'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-24-11:30:57_00011'
  currentMap['name'] = 'labeledMixtures'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('LMOL').get('exolinks')

  # Role Experiment.molSystems
  currentMap = {}
  contentMap['molSystems'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:31_00015'] = currentMap
  loadMaps['NMR.Experiment.molSystems'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.molSystems'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:31_00015'
  currentMap['name'] = 'molSystems'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role Experiment.nmrExpSeries
  currentMap = {}
  contentMap['nmrExpSeries'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00010'] = currentMap
  loadMaps['NMR.Experiment.nmrExpSeries'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.nmrExpSeries'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00010'
  currentMap['name'] = 'nmrExpSeries'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.noeList
  currentMap = {}
  contentMap['noeList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00055'] = currentMap
  loadMaps['NMR.Experiment.noeList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.noeList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00055'
  currentMap['name'] = 'noeList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.pkaList
  currentMap = {}
  contentMap['pkaList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00039'] = currentMap
  loadMaps['NMR.Experiment.pkaList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.pkaList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00039'
  currentMap['name'] = 'pkaList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.probe
  currentMap = {}
  contentMap['probe'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00050'] = currentMap
  loadMaps['NMR.Experiment.probe'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.probe'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00050'
  currentMap['name'] = 'probe'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('INST').get('exolinks')

  # Role Experiment.rawData
  currentMap = {}
  contentMap['rawData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00053'] = currentMap
  loadMaps['NMR.Experiment.rawData'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.rawData'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00053'
  currentMap['name'] = 'rawData'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.rdcList
  currentMap = {}
  contentMap['rdcList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00045'] = currentMap
  loadMaps['NMR.Experiment.rdcList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.rdcList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00045'
  currentMap['name'] = 'rdcList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.refExperiment
  currentMap = {}
  contentMap['refExperiment'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00008'] = currentMap
  loadMaps['NMR.Experiment.refExperiment'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.refExperiment'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00008'
  currentMap['name'] = 'refExperiment'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRX').get('exolinks')

  # Role Experiment.sample
  currentMap = {}
  contentMap['sample'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:35_00001'] = currentMap
  loadMaps['NMR.Experiment.sample'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.sample'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:35_00001'
  currentMap['name'] = 'sample'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('SAM').get('exolinks')

  # Role Experiment.sampleConditionSet
  currentMap = {}
  contentMap['sampleConditionSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00052'] = currentMap
  loadMaps['NMR.Experiment.sampleConditionSet'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.sampleConditionSet'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00052'
  currentMap['name'] = 'sampleConditionSet'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.shiftAnisotropyList
  currentMap = {}
  contentMap['shiftAnisotropyList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00035'] = currentMap
  loadMaps['NMR.Experiment.shiftAnisotropyList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.shiftAnisotropyList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00035'
  currentMap['name'] = 'shiftAnisotropyList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.shiftDifferenceList
  currentMap = {}
  contentMap['shiftDifferenceList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00044'] = currentMap
  loadMaps['NMR.Experiment.shiftDifferenceList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.shiftDifferenceList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00044'
  currentMap['name'] = 'shiftDifferenceList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.shiftList
  currentMap = {}
  contentMap['shiftList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00050'] = currentMap
  loadMaps['NMR.Experiment.shiftList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.shiftList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00050'
  currentMap['name'] = 'shiftList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.shiftReferences
  currentMap = {}
  contentMap['shiftReferences'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00054'] = currentMap
  loadMaps['NMR.Experiment.shiftReferences'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.shiftReferences'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00054'
  currentMap['name'] = 'shiftReferences'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.spectralDensityList
  currentMap = {}
  contentMap['spectralDensityList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00022'] = currentMap
  loadMaps['NMR.Experiment.spectralDensityList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.spectralDensityList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00022'
  currentMap['name'] = 'spectralDensityList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.spectrometer
  currentMap = {}
  contentMap['spectrometer'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00007'] = currentMap
  loadMaps['NMR.Experiment.spectrometer'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.spectrometer'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00007'
  currentMap['name'] = 'spectrometer'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('INST').get('exolinks')

  # Role Experiment.t1List
  currentMap = {}
  contentMap['t1List'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00010'] = currentMap
  loadMaps['NMR.Experiment.t1List'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.t1List'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00010'
  currentMap['name'] = 't1List'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.t1RhoList
  currentMap = {}
  contentMap['t1RhoList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00019'] = currentMap
  loadMaps['NMR.Experiment.t1RhoList'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.t1RhoList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00019'
  currentMap['name'] = 't1RhoList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Experiment.t2List
  currentMap = {}
  contentMap['t2List'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00028'] = currentMap
  loadMaps['NMR.Experiment.t2List'] = currentMap
  currentMap['tag'] = 'NMR.Experiment.t2List'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00028'
  currentMap['name'] = 't2List'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of Experiment

  currentMap = abstractTypes.get('Experiment')
  aList = ['numDim', 'numScans', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'volumeUnit']
  currentMap['headerAttrs'] = aList
  aList = ['date', 'details', 'name', 'nmrTubeType', 'sampleState', 'userExpCode', 'dataLists', 'derivedFrom', 'derivedTo', 'nmrExpSeries', 'rawData', 'shiftReferences']
  currentMap['simpleAttrs'] = aList
  aList = ['dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'noeList', 'pkaList', 'rdcList', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 't1List', 't1RhoList', 't2List']
  currentMap['optLinks'] = aList
  aList = ['expTransfers', 'expDims', 'expChainStates', 'dataSources', 'spectrometer', 'sample', 'refExperiment', 'probe', 'molSystems', 'labeledMixtures', 'derivationMethod', 'citations', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['dataSources', 'expChainStates', 'expDims', 'expTransfers']
  currentMap['children'] = aList

  # Class NmrExpSeries
  currentMap = {}
  abstractTypes['NmrExpSeries'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00010'] = currentMap
  loadMaps['NMR.NmrExpSeries'] = currentMap
  currentMap['tag'] = 'NMR.NmrExpSeries'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'nmrExpSeries'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.NmrExpSeries
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NmrExpSeries.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NmrExpSeries.conditionNames
  currentMap = {}
  contentMap['conditionNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:28_00002'] = currentMap
  loadMaps['NMR.NmrExpSeries.conditionNames'] = currentMap
  currentMap['tag'] = 'NMR.NmrExpSeries.conditionNames'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:28_00002'
  currentMap['name'] = 'conditionNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00003')

  # Attribute NmrExpSeries.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:28_00003'] = currentMap
  loadMaps['NMR.NmrExpSeries.details'] = currentMap
  currentMap['tag'] = 'NMR.NmrExpSeries.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:28_00003'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute NmrExpSeries.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:28_00001'] = currentMap
  loadMaps['NMR.NmrExpSeries.name'] = currentMap
  currentMap['tag'] = 'NMR.NmrExpSeries.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:28_00001'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute NmrExpSeries.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:27_00001'] = currentMap
  loadMaps['NMR.NmrExpSeries.serial'] = currentMap
  currentMap['tag'] = 'NMR.NmrExpSeries.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:27_00001'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role NmrExpSeries.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NmrExpSeries.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00009'] = currentMap
  loadMaps['NMR.NmrExpSeries.experiments'] = currentMap
  currentMap['tag'] = 'NMR.NmrExpSeries.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:06_00009'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of NmrExpSeries

  currentMap = abstractTypes.get('NmrExpSeries')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['conditionNames', 'details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class NmrProject
  currentMap = {}
  abstractTypes['NmrProject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:48_00001'] = currentMap
  loadMaps['NMR.NmrProject'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:48_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'nmrProjects'
  currentMap['isTop'] = True
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccp.api.nmr.Nmr.NmrProject
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NmrProject.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NmrProject.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NmrProject.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute NmrProject.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NmrProject.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NmrProject.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:34_00006'] = currentMap
  loadMaps['NMR.NmrProject.name'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:34_00006'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Role NmrProject.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NmrProject.atomSets
  currentMap = {}
  contentMap['atomSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:33_00006'] = currentMap
  loadMaps['NMR.NmrProject.atomSets'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.atomSets'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:33_00006'
  currentMap['name'] = 'atomSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.chainStateSets
  currentMap = {}
  contentMap['chainStateSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:32_00002'] = currentMap
  loadMaps['NMR.NmrProject.chainStateSets'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.chainStateSets'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:32_00002'
  currentMap['name'] = 'chainStateSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.derivedDataLists
  currentMap = {}
  contentMap['derivedDataLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:32_00006'] = currentMap
  loadMaps['NMR.NmrProject.derivedDataLists'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.derivedDataLists'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:32_00006'
  currentMap['name'] = 'derivedDataLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00007'] = currentMap
  loadMaps['NMR.NmrProject.experiments'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.experiments'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00007'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.measurementLists
  currentMap = {}
  contentMap['measurementLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:34_00005'] = currentMap
  loadMaps['NMR.NmrProject.measurementLists'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.measurementLists'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:34_00005'
  currentMap['name'] = 'measurementLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.nmrExpSeries
  currentMap = {}
  contentMap['nmrExpSeries'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00005'] = currentMap
  loadMaps['NMR.NmrProject.nmrExpSeries'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.nmrExpSeries'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00005'
  currentMap['name'] = 'nmrExpSeries'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.peakClusters
  currentMap = {}
  contentMap['peakClusters'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00002'] = currentMap
  loadMaps['NMR.NmrProject.peakClusters'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.peakClusters'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00002'
  currentMap['name'] = 'peakClusters'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.resonanceGroups
  currentMap = {}
  contentMap['resonanceGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:33_00002'] = currentMap
  loadMaps['NMR.NmrProject.resonanceGroups'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.resonanceGroups'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:33_00002'
  currentMap['name'] = 'resonanceGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.resonanceSets
  currentMap = {}
  contentMap['resonanceSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:33_00004'] = currentMap
  loadMaps['NMR.NmrProject.resonanceSets'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.resonanceSets'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:33_00004'
  currentMap['name'] = 'resonanceSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:32_00004'] = currentMap
  loadMaps['NMR.NmrProject.resonances'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.resonances'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:32_00004'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.sampleConditionSets
  currentMap = {}
  contentMap['sampleConditionSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00001'] = currentMap
  loadMaps['NMR.NmrProject.sampleConditionSets'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.sampleConditionSets'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00001'
  currentMap['name'] = 'sampleConditionSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.shiftReferences
  currentMap = {}
  contentMap['shiftReferences'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00003'] = currentMap
  loadMaps['NMR.NmrProject.shiftReferences'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.shiftReferences'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:31_00003'
  currentMap['name'] = 'shiftReferences'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.structureAnalyses
  currentMap = {}
  contentMap['structureAnalyses'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:31_00001'] = currentMap
  loadMaps['NMR.NmrProject.structureAnalyses'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.structureAnalyses'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:31_00001'
  currentMap['name'] = 'structureAnalyses'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.structureGenerations
  currentMap = {}
  contentMap['structureGenerations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-21-16:03:33_00002'] = currentMap
  loadMaps['NMR.NmrProject.structureGenerations'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.structureGenerations'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-21-16:03:33_00002'
  currentMap['name'] = 'structureGenerations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NmrProject.validationStores
  currentMap = {}
  contentMap['validationStores'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-14-17:02:59_00002'] = currentMap
  loadMaps['NMR.NmrProject.validationStores'] = currentMap
  currentMap['tag'] = 'NMR.NmrProject.validationStores'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-14-17:02:59_00002'
  currentMap['name'] = 'validationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('VALD').get('exolinks')
  # End of NmrProject

  currentMap = abstractTypes.get('NmrProject')
  aList = ['createdBy', 'guid', 'isModifiable', 'lastUnlockedBy']
  currentMap['headerAttrs'] = aList
  aList = ['name']
  currentMap['simpleAttrs'] = aList
  aList = ['structureGenerations', 'structureAnalyses', 'shiftReferences', 'sampleConditionSets', 'resonances', 'resonanceSets', 'resonanceGroups', 'peakClusters', 'nmrExpSeries', 'measurementLists', 'experiments', 'derivedDataLists', 'chainStateSets', 'atomSets', 'validationStores', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['atomSets', 'chainStateSets', 'derivedDataLists', 'experiments', 'measurementLists', 'nmrExpSeries', 'peakClusters', 'resonanceGroups', 'resonanceSets', 'resonances', 'sampleConditionSets', 'shiftReferences', 'structureAnalyses', 'structureGenerations']
  currentMap['children'] = aList

  # Class Peak
  currentMap = {}
  abstractTypes['Peak'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00011'] = currentMap
  loadMaps['NMR.Peak'] = currentMap
  currentMap['tag'] = 'NMR.Peak'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peaks'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.Peak
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Peak.annotation
  currentMap = {}
  contentMap['annotation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00008'] = currentMap
  loadMaps['NMR.Peak.annotation'] = currentMap
  currentMap['tag'] = 'NMR.Peak.annotation'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00008'
  currentMap['name'] = 'annotation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Peak.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Peak.componentNumbers
  currentMap = {}
  contentMap['componentNumbers'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:43:26_00001'] = currentMap
  loadMaps['NMR.Peak.componentNumbers'] = currentMap
  currentMap['tag'] = 'NMR.Peak.componentNumbers'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:43:26_00001'
  currentMap['name'] = 'componentNumbers'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Peak.constraintWeight
  currentMap = {}
  contentMap['constraintWeight'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00007'] = currentMap
  loadMaps['NMR.Peak.constraintWeight'] = currentMap
  currentMap['tag'] = 'NMR.Peak.constraintWeight'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00007'
  currentMap['name'] = 'constraintWeight'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Peak.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00005'] = currentMap
  loadMaps['NMR.Peak.details'] = currentMap
  currentMap['tag'] = 'NMR.Peak.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00005'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute Peak.figOfMerit
  currentMap = {}
  contentMap['figOfMerit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00006'] = currentMap
  loadMaps['NMR.Peak.figOfMerit'] = currentMap
  currentMap['tag'] = 'NMR.Peak.figOfMerit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00006'
  currentMap['name'] = 'figOfMerit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute Peak.height
  currentMap = {}
  contentMap['height'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2012-04-12-17:58:12_00001'] = currentMap
  loadMaps['NMR.Peak.height'] = currentMap
  currentMap['tag'] = 'NMR.Peak.height'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2012-04-12-17:58:12_00001'
  currentMap['name'] = 'height'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Peak.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00004'] = currentMap
  loadMaps['NMR.Peak.serial'] = currentMap
  currentMap['tag'] = 'NMR.Peak.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00004'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Peak.volume
  currentMap = {}
  contentMap['volume'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2012-04-12-17:58:12_00002'] = currentMap
  loadMaps['NMR.Peak.volume'] = currentMap
  currentMap['tag'] = 'NMR.Peak.volume'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2012-04-12-17:58:12_00002'
  currentMap['name'] = 'volume'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role Peak.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Peak.dataDerivations
  currentMap = {}
  contentMap['dataDerivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00035'] = currentMap
  loadMaps['NMR.Peak.dataDerivations'] = currentMap
  currentMap['tag'] = 'NMR.Peak.dataDerivations'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00035'
  currentMap['name'] = 'dataDerivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Peak.fitMethod
  currentMap = {}
  contentMap['fitMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00001'] = currentMap
  loadMaps['NMR.Peak.fitMethod'] = currentMap
  currentMap['tag'] = 'NMR.Peak.fitMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00001'
  currentMap['name'] = 'fitMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role Peak.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00009'] = currentMap
  loadMaps['NMR.Peak.measurements'] = currentMap
  currentMap['tag'] = 'NMR.Peak.measurements'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00009'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Peak.peakClusters
  currentMap = {}
  contentMap['peakClusters'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00004'] = currentMap
  loadMaps['NMR.Peak.peakClusters'] = currentMap
  currentMap['tag'] = 'NMR.Peak.peakClusters'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00004'
  currentMap['name'] = 'peakClusters'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Peak.peakContribs
  currentMap = {}
  contentMap['peakContribs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00002'] = currentMap
  loadMaps['NMR.Peak.peakContribs'] = currentMap
  currentMap['tag'] = 'NMR.Peak.peakContribs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00002'
  currentMap['name'] = 'peakContribs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Peak.peakDims
  currentMap = {}
  contentMap['peakDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00003'] = currentMap
  loadMaps['NMR.Peak.peakDims'] = currentMap
  currentMap['tag'] = 'NMR.Peak.peakDims'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00003'
  currentMap['name'] = 'peakDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Peak.peakIntensities
  currentMap = {}
  contentMap['peakIntensities'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00011'] = currentMap
  loadMaps['NMR.Peak.peakIntensities'] = currentMap
  currentMap['tag'] = 'NMR.Peak.peakIntensities'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00011'
  currentMap['name'] = 'peakIntensities'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Peak.peakValidations
  currentMap = {}
  contentMap['peakValidations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00010'] = currentMap
  loadMaps['NMR.Peak.peakValidations'] = currentMap
  currentMap['tag'] = 'NMR.Peak.peakValidations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00010'
  currentMap['name'] = 'peakValidations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('VALD').get('exolinks')
  # End of Peak

  currentMap = abstractTypes.get('Peak')
  aList = ['constraintWeight', 'figOfMerit', 'height', 'serial', 'volume']
  currentMap['headerAttrs'] = aList
  aList = ['annotation', 'componentNumbers', 'details', 'dataDerivations', 'measurements', 'peakClusters']
  currentMap['simpleAttrs'] = aList
  aList = ['peakIntensities', 'peakDims', 'peakContribs', 'peakValidations', 'fitMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['peakContribs', 'peakDims', 'peakIntensities']
  currentMap['children'] = aList

  # Class PeakCluster
  currentMap = {}
  abstractTypes['PeakCluster'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:42_00002'] = currentMap
  loadMaps['NMR.PeakCluster'] = currentMap
  currentMap['tag'] = 'NMR.PeakCluster'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:42_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakClusters'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakCluster
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakCluster.annotation
  currentMap = {}
  contentMap['annotation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-01-14:38:52_00001'] = currentMap
  loadMaps['NMR.PeakCluster.annotation'] = currentMap
  currentMap['tag'] = 'NMR.PeakCluster.annotation'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-01-14:38:52_00001'
  currentMap['name'] = 'annotation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute PeakCluster.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakCluster.clusterType
  currentMap = {}
  contentMap['clusterType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-01-14:38:46_00001'] = currentMap
  loadMaps['NMR.PeakCluster.clusterType'] = currentMap
  currentMap['tag'] = 'NMR.PeakCluster.clusterType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-01-14:38:46_00001'
  currentMap['name'] = 'clusterType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-01-14:37:12_00001')

  # Attribute PeakCluster.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00006'] = currentMap
  loadMaps['NMR.PeakCluster.serial'] = currentMap
  currentMap['tag'] = 'NMR.PeakCluster.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00006'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role PeakCluster.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakCluster.peaks
  currentMap = {}
  contentMap['peaks'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00003'] = currentMap
  loadMaps['NMR.PeakCluster.peaks'] = currentMap
  currentMap['tag'] = 'NMR.PeakCluster.peaks'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00003'
  currentMap['name'] = 'peaks'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of PeakCluster

  currentMap = abstractTypes.get('PeakCluster')
  aList = ['clusterType', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['annotation', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PeakContrib
  currentMap = {}
  abstractTypes['PeakContrib'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00017'] = currentMap
  loadMaps['NMR.PeakContrib'] = currentMap
  currentMap['tag'] = 'NMR.PeakContrib'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00017'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakContribs'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakContrib
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakContrib.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakContrib.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00044'] = currentMap
  loadMaps['NMR.PeakContrib.serial'] = currentMap
  currentMap['tag'] = 'NMR.PeakContrib.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00044'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute PeakContrib.weight
  currentMap = {}
  contentMap['weight'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00045'] = currentMap
  loadMaps['NMR.PeakContrib.weight'] = currentMap
  currentMap['tag'] = 'NMR.PeakContrib.weight'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00045'
  currentMap['name'] = 'weight'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role PeakContrib.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakContrib.peakDimContribs
  currentMap = {}
  contentMap['peakDimContribs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00042'] = currentMap
  loadMaps['NMR.PeakContrib.peakDimContribs'] = currentMap
  currentMap['tag'] = 'NMR.PeakContrib.peakDimContribs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00042'
  currentMap['name'] = 'peakDimContribs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of PeakContrib

  currentMap = abstractTypes.get('PeakContrib')
  aList = ['serial', 'weight']
  currentMap['headerAttrs'] = aList
  aList = ['peakDimContribs']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PeakDim
  currentMap = {}
  abstractTypes['PeakDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00013'] = currentMap
  loadMaps['NMR.PeakDim'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00013'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakDims'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakDim.annotation
  currentMap = {}
  contentMap['annotation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00013'] = currentMap
  loadMaps['NMR.PeakDim.annotation'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.annotation'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00013'
  currentMap['name'] = 'annotation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute PeakDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakDim.boxWidth
  currentMap = {}
  contentMap['boxWidth'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00005'] = currentMap
  loadMaps['NMR.PeakDim.boxWidth'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.boxWidth'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00005'
  currentMap['name'] = 'boxWidth'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.decayRate
  currentMap = {}
  contentMap['decayRate'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00008'] = currentMap
  loadMaps['NMR.PeakDim.decayRate'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.decayRate'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00008'
  currentMap['name'] = 'decayRate'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.decayRateError
  currentMap = {}
  contentMap['decayRateError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00009'] = currentMap
  loadMaps['NMR.PeakDim.decayRateError'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.decayRateError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00009'
  currentMap['name'] = 'decayRateError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.dim
  currentMap = {}
  contentMap['dim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00011'] = currentMap
  loadMaps['NMR.PeakDim.dim'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.dim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00011'
  currentMap['name'] = 'dim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute PeakDim.lineWidth
  currentMap = {}
  contentMap['lineWidth'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00012'] = currentMap
  loadMaps['NMR.PeakDim.lineWidth'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.lineWidth'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00012'
  currentMap['name'] = 'lineWidth'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.numAliasing
  currentMap = {}
  contentMap['numAliasing'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00014'] = currentMap
  loadMaps['NMR.PeakDim.numAliasing'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.numAliasing'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00014'
  currentMap['name'] = 'numAliasing'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute PeakDim.phase
  currentMap = {}
  contentMap['phase'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00006'] = currentMap
  loadMaps['NMR.PeakDim.phase'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.phase'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00006'
  currentMap['name'] = 'phase'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.phaseError
  currentMap = {}
  contentMap['phaseError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00007'] = currentMap
  loadMaps['NMR.PeakDim.phaseError'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.phaseError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00007'
  currentMap['name'] = 'phaseError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.position
  currentMap = {}
  contentMap['position'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00001'] = currentMap
  loadMaps['NMR.PeakDim.position'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.position'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00001'
  currentMap['name'] = 'position'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.positionError
  currentMap = {}
  contentMap['positionError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00004'] = currentMap
  loadMaps['NMR.PeakDim.positionError'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.positionError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00004'
  currentMap['name'] = 'positionError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.realValue
  currentMap = {}
  contentMap['realValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:32:25_00001'] = currentMap
  loadMaps['NMR.PeakDim.realValue'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.realValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:32:25_00001'
  currentMap['name'] = 'realValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.realValueImpl
  currentMap = {}
  contentMap['realValueImpl'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2010-04-30-17:48:48_00002'] = currentMap
  loadMaps['NMR.PeakDim.realValueImpl'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.realValueImpl'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-04-30-17:48:48_00002'
  currentMap['name'] = 'realValueImpl'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00010'] = currentMap
  loadMaps['NMR.PeakDim.value'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00010'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDim.valueError
  currentMap = {}
  contentMap['valueError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00011'] = currentMap
  loadMaps['NMR.PeakDim.valueError'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.valueError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00011'
  currentMap['name'] = 'valueError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role PeakDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakDim.dataDerivations
  currentMap = {}
  contentMap['dataDerivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00033'] = currentMap
  loadMaps['NMR.PeakDim.dataDerivations'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.dataDerivations'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00033'
  currentMap['name'] = 'dataDerivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role PeakDim.dataDimRef
  currentMap = {}
  contentMap['dataDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00010'] = currentMap
  loadMaps['NMR.PeakDim.dataDimRef'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.dataDimRef'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:00_00010'
  currentMap['name'] = 'dataDimRef'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role PeakDim.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00011'] = currentMap
  loadMaps['NMR.PeakDim.measurements'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.measurements'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00011'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role PeakDim.peakDimComponents
  currentMap = {}
  contentMap['peakDimComponents'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00008'] = currentMap
  loadMaps['NMR.PeakDim.peakDimComponents'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.peakDimComponents'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00008'
  currentMap['name'] = 'peakDimComponents'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role PeakDim.peakDimContribs
  currentMap = {}
  contentMap['peakDimContribs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00006'] = currentMap
  loadMaps['NMR.PeakDim.peakDimContribs'] = currentMap
  currentMap['tag'] = 'NMR.PeakDim.peakDimContribs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:45_00006'
  currentMap['name'] = 'peakDimContribs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')
  # End of PeakDim

  currentMap = abstractTypes.get('PeakDim')
  aList = ['boxWidth', 'decayRate', 'decayRateError', 'dim', 'lineWidth', 'numAliasing', 'phase', 'phaseError', 'position', 'positionError', 'realValueImpl']
  currentMap['headerAttrs'] = aList
  aList = ['annotation', 'dataDerivations', 'dataDimRef', 'measurements']
  currentMap['simpleAttrs'] = aList
  aList = ['peakDimContribs', 'peakDimComponents', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['peakDimComponents', 'peakDimContribs']
  currentMap['children'] = aList

  # Class PeakDimComponent
  currentMap = {}
  abstractTypes['PeakDimComponent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:29:42_00001'] = currentMap
  loadMaps['NMR.PeakDimComponent'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimComponent'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:42_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakDimComponents'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDimComponent
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakDimComponent.annotation
  currentMap = {}
  contentMap['annotation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-12-11-13:43:24_00001'] = currentMap
  loadMaps['NMR.PeakDimComponent.annotation'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimComponent.annotation'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-12-11-13:43:24_00001'
  currentMap['name'] = 'annotation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute PeakDimComponent.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakDimComponent.scalingFactor
  currentMap = {}
  contentMap['scalingFactor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00005'] = currentMap
  loadMaps['NMR.PeakDimComponent.scalingFactor'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimComponent.scalingFactor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00005'
  currentMap['name'] = 'scalingFactor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakDimComponent.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00004'] = currentMap
  loadMaps['NMR.PeakDimComponent.serial'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimComponent.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00004'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role PeakDimComponent.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakDimComponent.dataDimRef
  currentMap = {}
  contentMap['dataDimRef'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00003'] = currentMap
  loadMaps['NMR.PeakDimComponent.dataDimRef'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimComponent.dataDimRef'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00003'
  currentMap['name'] = 'dataDimRef'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role PeakDimComponent.peakDimContribs
  currentMap = {}
  contentMap['peakDimContribs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-25-11:33:27_00001'] = currentMap
  loadMaps['NMR.PeakDimComponent.peakDimContribs'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimComponent.peakDimContribs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:27_00001'
  currentMap['name'] = 'peakDimContribs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of PeakDimComponent

  currentMap = abstractTypes.get('PeakDimComponent')
  aList = ['scalingFactor', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['annotation', 'dataDimRef', 'peakDimContribs']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PeakIntensity
  currentMap = {}
  abstractTypes['PeakIntensity'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00021'] = currentMap
  loadMaps['NMR.PeakIntensity'] = currentMap
  currentMap['tag'] = 'NMR.PeakIntensity'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00021'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakIntensities'
  currentMap['objkey'] = 'method'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakIntensity
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakIntensity.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakIntensity.error
  currentMap = {}
  contentMap['error'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00060'] = currentMap
  loadMaps['NMR.PeakIntensity.error'] = currentMap
  currentMap['tag'] = 'NMR.PeakIntensity.error'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00060'
  currentMap['name'] = 'error'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute PeakIntensity.intensityType
  currentMap = {}
  contentMap['intensityType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00058'] = currentMap
  loadMaps['NMR.PeakIntensity.intensityType'] = currentMap
  currentMap['tag'] = 'NMR.PeakIntensity.intensityType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00058'
  currentMap['name'] = 'intensityType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00038')

  # Attribute PeakIntensity.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00059'] = currentMap
  loadMaps['NMR.PeakIntensity.value'] = currentMap
  currentMap['tag'] = 'NMR.PeakIntensity.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00059'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role PeakIntensity.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakIntensity.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00057'] = currentMap
  loadMaps['NMR.PeakIntensity.method'] = currentMap
  currentMap['tag'] = 'NMR.PeakIntensity.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00057'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')
  # End of PeakIntensity

  currentMap = abstractTypes.get('PeakIntensity')
  aList = ['error', 'intensityType', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PeakList
  currentMap = {}
  abstractTypes['PeakList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00022'] = currentMap
  loadMaps['NMR.PeakList'] = currentMap
  currentMap['tag'] = 'NMR.PeakList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00022'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakList.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00007'] = currentMap
  loadMaps['NMR.PeakList.details'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00007'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute PeakList.isSimulated
  currentMap = {}
  contentMap['isSimulated'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00008'] = currentMap
  loadMaps['NMR.PeakList.isSimulated'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.isSimulated'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00008'
  currentMap['name'] = 'isSimulated'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute PeakList.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00006'] = currentMap
  loadMaps['NMR.PeakList.name'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00006'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute PeakList.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00005'] = currentMap
  loadMaps['NMR.PeakList.serial'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00005'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role PeakList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakList.fitMethod
  currentMap = {}
  contentMap['fitMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00002'] = currentMap
  loadMaps['NMR.PeakList.fitMethod'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.fitMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00002'
  currentMap['name'] = 'fitMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role PeakList.intensMethod
  currentMap = {}
  contentMap['intensMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00004'] = currentMap
  loadMaps['NMR.PeakList.intensMethod'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.intensMethod'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00004'
  currentMap['name'] = 'intensMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role PeakList.peakListValidations
  currentMap = {}
  contentMap['peakListValidations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00008'] = currentMap
  loadMaps['NMR.PeakList.peakListValidations'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.peakListValidations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00008'
  currentMap['name'] = 'peakListValidations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('VALD').get('exolinks')

  # Role PeakList.peaks
  currentMap = {}
  contentMap['peaks'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00062'] = currentMap
  loadMaps['NMR.PeakList.peaks'] = currentMap
  currentMap['tag'] = 'NMR.PeakList.peaks'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00062'
  currentMap['name'] = 'peaks'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')
  # End of PeakList

  currentMap = abstractTypes.get('PeakList')
  aList = ['isSimulated', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['peaks', 'peakListValidations', 'intensMethod', 'fitMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['peaks']
  currentMap['children'] = aList

  # Class ResidueProb
  currentMap = {}
  abstractTypes['ResidueProb'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00031'] = currentMap
  loadMaps['NMR.ResidueProb'] = currentMap
  currentMap['tag'] = 'NMR.ResidueProb'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00031'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'residueProbs'
  currentMap['objkey'] = 'possibility'
  currentMap['class'] = ccp.api.nmr.Nmr.ResidueProb
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResidueProb.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResidueProb.weight
  contentMap['weight'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:38_00025')

  # Role ResidueProb.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResidueProb.possibility
  currentMap = {}
  contentMap['possibility'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00050'] = currentMap
  loadMaps['NMR.ResidueProb.possibility'] = currentMap
  currentMap['tag'] = 'NMR.ResidueProb.possibility'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00050'
  currentMap['name'] = 'possibility'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')
  # End of ResidueProb

  currentMap = abstractTypes.get('ResidueProb')
  aList = ['weight']
  currentMap['headerAttrs'] = aList
  aList = ['possibility', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ResidueTypeProb
  currentMap = {}
  abstractTypes['ResidueTypeProb'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00032'] = currentMap
  loadMaps['NMR.ResidueTypeProb'] = currentMap
  currentMap['tag'] = 'NMR.ResidueTypeProb'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00032'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'residueTypeProbs'
  currentMap['objkey'] = 'possibility'
  currentMap['class'] = ccp.api.nmr.Nmr.ResidueTypeProb
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResidueTypeProb.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResidueTypeProb.weight
  contentMap['weight'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:38_00025')

  # Role ResidueTypeProb.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResidueTypeProb.possibility
  currentMap = {}
  contentMap['possibility'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00002'] = currentMap
  loadMaps['NMR.ResidueTypeProb.possibility'] = currentMap
  currentMap['tag'] = 'NMR.ResidueTypeProb.possibility'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00002'
  currentMap['name'] = 'possibility'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CHEM').get('exolinks')
  # End of ResidueTypeProb

  currentMap = abstractTypes.get('ResidueTypeProb')
  aList = ['weight']
  currentMap['headerAttrs'] = aList
  aList = ['possibility', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Resonance
  currentMap = {}
  abstractTypes['Resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00033'] = currentMap
  loadMaps['NMR.Resonance'] = currentMap
  currentMap['tag'] = 'NMR.Resonance'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00033'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resonances'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.Resonance
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Resonance.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Resonance.assignNames
  currentMap = {}
  contentMap['assignNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00010'] = currentMap
  loadMaps['NMR.Resonance.assignNames'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.assignNames'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00010'
  currentMap['name'] = 'assignNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute Resonance.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00012'] = currentMap
  loadMaps['NMR.Resonance.details'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00012'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute Resonance.isotopeCode
  currentMap = {}
  contentMap['isotopeCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00011'] = currentMap
  loadMaps['NMR.Resonance.isotopeCode'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.isotopeCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00011'
  currentMap['name'] = 'isotopeCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute Resonance.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00009'] = currentMap
  loadMaps['NMR.Resonance.name'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00009'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Resonance.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00008'] = currentMap
  loadMaps['NMR.Resonance.serial'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00008'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role Resonance.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Resonance.chainStates
  currentMap = {}
  contentMap['chainStates'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00005'] = currentMap
  loadMaps['NMR.Resonance.chainStates'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.chainStates'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00005'
  currentMap['name'] = 'chainStates'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Resonance.covalentlyBound
  currentMap = {}
  contentMap['covalentlyBound'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00051'] = currentMap
  loadMaps['NMR.Resonance.covalentlyBound'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.covalentlyBound'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00051'
  currentMap['name'] = 'covalentlyBound'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Resonance.datums
  currentMap = {}
  contentMap['datums'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00023'] = currentMap
  loadMaps['NMR.Resonance.datums'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.datums'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00023'
  currentMap['name'] = 'datums'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Resonance.dipolarRelaxations
  currentMap = {}
  contentMap['dipolarRelaxations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00005'] = currentMap
  loadMaps['NMR.Resonance.dipolarRelaxations'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.dipolarRelaxations'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00005'
  currentMap['name'] = 'dipolarRelaxations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.hExchProtections
  currentMap = {}
  contentMap['hExchProtections'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00035'] = currentMap
  loadMaps['NMR.Resonance.hExchProtections'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.hExchProtections'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00035'
  currentMap['name'] = 'hExchProtections'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.hExchRates
  currentMap = {}
  contentMap['hExchRates'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00044'] = currentMap
  loadMaps['NMR.Resonance.hExchRates'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.hExchRates'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00044'
  currentMap['name'] = 'hExchRates'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.isotropicS2s
  currentMap = {}
  contentMap['isotropicS2s'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00061'] = currentMap
  loadMaps['NMR.Resonance.isotropicS2s'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.isotropicS2s'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00061'
  currentMap['name'] = 'isotropicS2s'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.jCouplings
  currentMap = {}
  contentMap['jCouplings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00015'] = currentMap
  loadMaps['NMR.Resonance.jCouplings'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.jCouplings'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00015'
  currentMap['name'] = 'jCouplings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.noes
  currentMap = {}
  contentMap['noes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00051'] = currentMap
  loadMaps['NMR.Resonance.noes'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.noes'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00051'
  currentMap['name'] = 'noes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.peakDimContribNs
  currentMap = {}
  contentMap['peakDimContribNs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00033'] = currentMap
  loadMaps['NMR.Resonance.peakDimContribNs'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.peakDimContribNs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00033'
  currentMap['name'] = 'peakDimContribNs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.peakDimContribs
  currentMap = {}
  contentMap['peakDimContribs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:10_00001'] = currentMap
  loadMaps['NMR.Resonance.peakDimContribs'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.peakDimContribs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:10_00001'
  currentMap['name'] = 'peakDimContribs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.pkas
  currentMap = {}
  contentMap['pkas'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00025'] = currentMap
  loadMaps['NMR.Resonance.pkas'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.pkas'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00025'
  currentMap['name'] = 'pkas'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.rdcs
  currentMap = {}
  contentMap['rdcs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00041'] = currentMap
  loadMaps['NMR.Resonance.rdcs'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.rdcs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00041'
  currentMap['name'] = 'rdcs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.resonanceGroup
  currentMap = {}
  contentMap['resonanceGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00001'] = currentMap
  loadMaps['NMR.Resonance.resonanceGroup'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.resonanceGroup'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00001'
  currentMap['name'] = 'resonanceGroup'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Resonance.resonanceProbs
  currentMap = {}
  contentMap['resonanceProbs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:21_00005'] = currentMap
  loadMaps['NMR.Resonance.resonanceProbs'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.resonanceProbs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:21_00005'
  currentMap['name'] = 'resonanceProbs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role Resonance.resonanceSet
  currentMap = {}
  contentMap['resonanceSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00003'] = currentMap
  loadMaps['NMR.Resonance.resonanceSet'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.resonanceSet'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00003'
  currentMap['name'] = 'resonanceSet'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Resonance.shiftAnisotropies
  currentMap = {}
  contentMap['shiftAnisotropies'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00031'] = currentMap
  loadMaps['NMR.Resonance.shiftAnisotropies'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.shiftAnisotropies'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00031'
  currentMap['name'] = 'shiftAnisotropies'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.shiftDifferences
  currentMap = {}
  contentMap['shiftDifferences'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00039'] = currentMap
  loadMaps['NMR.Resonance.shiftDifferences'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.shiftDifferences'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00039'
  currentMap['name'] = 'shiftDifferences'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.shifts
  currentMap = {}
  contentMap['shifts'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00029'] = currentMap
  loadMaps['NMR.Resonance.shifts'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.shifts'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00029'
  currentMap['name'] = 'shifts'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.spectralDensities
  currentMap = {}
  contentMap['spectralDensities'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00015'] = currentMap
  loadMaps['NMR.Resonance.spectralDensities'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.spectralDensities'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00015'
  currentMap['name'] = 'spectralDensities'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.t1Rhos
  currentMap = {}
  contentMap['t1Rhos'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00015'] = currentMap
  loadMaps['NMR.Resonance.t1Rhos'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.t1Rhos'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00015'
  currentMap['name'] = 't1Rhos'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.t1s
  currentMap = {}
  contentMap['t1s'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00006'] = currentMap
  loadMaps['NMR.Resonance.t1s'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.t1s'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00006'
  currentMap['name'] = 't1s'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Resonance.t2s
  currentMap = {}
  contentMap['t2s'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00024'] = currentMap
  loadMaps['NMR.Resonance.t2s'] = currentMap
  currentMap['tag'] = 'NMR.Resonance.t2s'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00024'
  currentMap['name'] = 't2s'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of Resonance

  currentMap = abstractTypes.get('Resonance')
  aList = ['isotopeCode', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['assignNames', 'details', 'name', 'chainStates', 'covalentlyBound', 'datums', 'dipolarRelaxations', 'hExchProtections', 'hExchRates', 'isotropicS2s', 'jCouplings', 'noes', 'peakDimContribNs', 'peakDimContribs', 'pkas', 'rdcs', 'shiftAnisotropies', 'shiftDifferences', 'shifts', 'spectralDensities', 't1Rhos', 't1s', 't2s']
  currentMap['simpleAttrs'] = aList
  aList = ['resonanceGroup', 'resonanceSet']
  currentMap['optLinks'] = aList
  aList = ['resonanceProbs', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['resonanceProbs']
  currentMap['children'] = aList

  # Class ResonanceGroup
  currentMap = {}
  abstractTypes['ResonanceGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00034'] = currentMap
  loadMaps['NMR.ResonanceGroup'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00034'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resonanceGroups'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceGroup
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResonanceGroup.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResonanceGroup.ccpCode
  currentMap = {}
  contentMap['ccpCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00031'] = currentMap
  loadMaps['NMR.ResonanceGroup.ccpCode'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.ccpCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00031'
  currentMap['name'] = 'ccpCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003')

  # Attribute ResonanceGroup.clusterCode
  currentMap = {}
  contentMap['clusterCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-08-05-11:56:26_00003'] = currentMap
  loadMaps['NMR.ResonanceGroup.clusterCode'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.clusterCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-08-05-11:56:26_00003'
  currentMap['name'] = 'clusterCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ResonanceGroup.descriptor
  currentMap = {}
  contentMap['descriptor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00002'] = currentMap
  loadMaps['NMR.ResonanceGroup.descriptor'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.descriptor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00002'
  currentMap['name'] = 'descriptor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ResonanceGroup.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00004'] = currentMap
  loadMaps['NMR.ResonanceGroup.details'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00004'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-01-23-10:52:32_00001')

  # Attribute ResonanceGroup.isActive
  currentMap = {}
  contentMap['isActive'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-08-05-11:56:26_00004'] = currentMap
  loadMaps['NMR.ResonanceGroup.isActive'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.isActive'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-08-05-11:56:26_00004'
  currentMap['name'] = 'isActive'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ResonanceGroup.linking
  currentMap = {}
  contentMap['linking'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00001'] = currentMap
  loadMaps['NMR.ResonanceGroup.linking'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.linking'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00001'
  currentMap['name'] = 'linking'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00025')

  # Attribute ResonanceGroup.molType
  currentMap = {}
  contentMap['molType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00029'] = currentMap
  loadMaps['NMR.ResonanceGroup.molType'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.molType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00029'
  currentMap['name'] = 'molType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00024')

  # Attribute ResonanceGroup.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00028'] = currentMap
  loadMaps['NMR.ResonanceGroup.name'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00028'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ResonanceGroup.secStrucCode
  currentMap = {}
  contentMap['secStrucCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00003'] = currentMap
  loadMaps['NMR.ResonanceGroup.secStrucCode'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.secStrucCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00003'
  currentMap['name'] = 'secStrucCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00053')

  # Attribute ResonanceGroup.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00027'] = currentMap
  loadMaps['NMR.ResonanceGroup.serial'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00027'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ResonanceGroup.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResonanceGroup.chains
  currentMap = {}
  contentMap['chains'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00024'] = currentMap
  loadMaps['NMR.ResonanceGroup.chains'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.chains'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00024'
  currentMap['name'] = 'chains'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role ResonanceGroup.fromResonanceGroups
  currentMap = {}
  contentMap['fromResonanceGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00009'] = currentMap
  loadMaps['NMR.ResonanceGroup.fromResonanceGroups'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.fromResonanceGroups'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00009'
  currentMap['name'] = 'fromResonanceGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ResonanceGroup.residue
  currentMap = {}
  contentMap['residue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:32_00038'] = currentMap
  loadMaps['NMR.ResonanceGroup.residue'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.residue'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:32_00038'
  currentMap['name'] = 'residue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role ResonanceGroup.residueProbs
  currentMap = {}
  contentMap['residueProbs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00020'] = currentMap
  loadMaps['NMR.ResonanceGroup.residueProbs'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.residueProbs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00020'
  currentMap['name'] = 'residueProbs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ResonanceGroup.residueTypeProbs
  currentMap = {}
  contentMap['residueTypeProbs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00016'] = currentMap
  loadMaps['NMR.ResonanceGroup.residueTypeProbs'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.residueTypeProbs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00016'
  currentMap['name'] = 'residueTypeProbs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ResonanceGroup.resonanceGroupProbs
  currentMap = {}
  contentMap['resonanceGroupProbs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00018'] = currentMap
  loadMaps['NMR.ResonanceGroup.resonanceGroupProbs'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.resonanceGroupProbs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00018'
  currentMap['name'] = 'resonanceGroupProbs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ResonanceGroup.resonanceProbs
  currentMap = {}
  contentMap['resonanceProbs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00022'] = currentMap
  loadMaps['NMR.ResonanceGroup.resonanceProbs'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.resonanceProbs'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00022'
  currentMap['name'] = 'resonanceProbs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ResonanceGroup.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00052'] = currentMap
  loadMaps['NMR.ResonanceGroup.resonances'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroup.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00052'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of ResonanceGroup

  currentMap = abstractTypes.get('ResonanceGroup')
  aList = ['ccpCode', 'isActive', 'linking', 'molType', 'secStrucCode', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['clusterCode', 'descriptor', 'details', 'name', 'fromResonanceGroups', 'resonanceProbs', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['resonanceGroupProbs', 'residueTypeProbs', 'residueProbs', 'residue', 'chains', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['residueProbs', 'residueTypeProbs', 'resonanceGroupProbs']
  currentMap['children'] = aList

  # Class ResonanceGroupProb
  currentMap = {}
  abstractTypes['ResonanceGroupProb'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00035'] = currentMap
  loadMaps['NMR.ResonanceGroupProb'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroupProb'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00035'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resonanceGroupProbs'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceGroupProb
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResonanceGroupProb.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResonanceGroupProb.isSelected
  currentMap = {}
  contentMap['isSelected'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00012'] = currentMap
  loadMaps['NMR.ResonanceGroupProb.isSelected'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroupProb.isSelected'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00012'
  currentMap['name'] = 'isSelected'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ResonanceGroupProb.linkType
  currentMap = {}
  contentMap['linkType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00011'] = currentMap
  loadMaps['NMR.ResonanceGroupProb.linkType'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroupProb.linkType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00011'
  currentMap['name'] = 'linkType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00037')

  # Attribute ResonanceGroupProb.sequenceOffset
  currentMap = {}
  contentMap['sequenceOffset'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00013'] = currentMap
  loadMaps['NMR.ResonanceGroupProb.sequenceOffset'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroupProb.sequenceOffset'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00013'
  currentMap['name'] = 'sequenceOffset'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ResonanceGroupProb.weight
  contentMap['weight'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:38_00025')

  # Role ResonanceGroupProb.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResonanceGroupProb.possibility
  currentMap = {}
  contentMap['possibility'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00010'] = currentMap
  loadMaps['NMR.ResonanceGroupProb.possibility'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceGroupProb.possibility'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00010'
  currentMap['name'] = 'possibility'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ResonanceGroupProb

  currentMap = abstractTypes.get('ResonanceGroupProb')
  aList = ['isSelected', 'sequenceOffset', 'weight']
  currentMap['headerAttrs'] = aList
  aList = ['linkType']
  currentMap['simpleAttrs'] = aList
  aList = ['possibility']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ResonanceProb
  currentMap = {}
  abstractTypes['ResonanceProb'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00032'] = currentMap
  loadMaps['NMR.ResonanceProb'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceProb'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00032'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resonanceProbs'
  currentMap['objkey'] = 'possibility'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceProb
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResonanceProb.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResonanceProb.weight
  contentMap['weight'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:38_00025')

  # Role ResonanceProb.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResonanceProb.possibility
  currentMap = {}
  contentMap['possibility'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00021'] = currentMap
  loadMaps['NMR.ResonanceProb.possibility'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceProb.possibility'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00021'
  currentMap['name'] = 'possibility'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ResonanceProb

  currentMap = abstractTypes.get('ResonanceProb')
  aList = ['weight']
  currentMap['headerAttrs'] = aList
  aList = ['possibility']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ResonanceSet
  currentMap = {}
  abstractTypes['ResonanceSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00038'] = currentMap
  loadMaps['NMR.ResonanceSet'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceSet'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00038'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resonanceSets'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceSet
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResonanceSet.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResonanceSet.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00014'] = currentMap
  loadMaps['NMR.ResonanceSet.serial'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceSet.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00014'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ResonanceSet.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResonanceSet.atomSets
  currentMap = {}
  contentMap['atomSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00025'] = currentMap
  loadMaps['NMR.ResonanceSet.atomSets'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceSet.atomSets'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:01_00025'
  currentMap['name'] = 'atomSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role ResonanceSet.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00002'] = currentMap
  loadMaps['NMR.ResonanceSet.resonances'] = currentMap
  currentMap['tag'] = 'NMR.ResonanceSet.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:10_00002'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = False
  # End of ResonanceSet

  currentMap = abstractTypes.get('ResonanceSet')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['atomSets', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SampleCondition
  currentMap = {}
  abstractTypes['SampleCondition'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00039'] = currentMap
  loadMaps['NMR.SampleCondition'] = currentMap
  currentMap['tag'] = 'NMR.SampleCondition'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00039'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'sampleConditions'
  currentMap['objkey'] = 'condition'
  currentMap['class'] = ccp.api.nmr.Nmr.SampleCondition
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SampleCondition.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SampleCondition.condition
  currentMap = {}
  contentMap['condition'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00017'] = currentMap
  loadMaps['NMR.SampleCondition.condition'] = currentMap
  currentMap['tag'] = 'NMR.SampleCondition.condition'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00017'
  currentMap['name'] = 'condition'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00003')

  # Attribute SampleCondition.error
  currentMap = {}
  contentMap['error'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00020'] = currentMap
  loadMaps['NMR.SampleCondition.error'] = currentMap
  currentMap['tag'] = 'NMR.SampleCondition.error'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00020'
  currentMap['name'] = 'error'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SampleCondition.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00018'] = currentMap
  loadMaps['NMR.SampleCondition.unit'] = currentMap
  currentMap['tag'] = 'NMR.SampleCondition.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00018'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute SampleCondition.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00019'] = currentMap
  loadMaps['NMR.SampleCondition.value'] = currentMap
  currentMap['tag'] = 'NMR.SampleCondition.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00019'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role SampleCondition.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of SampleCondition

  currentMap = abstractTypes.get('SampleCondition')
  aList = ['error', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['condition', 'unit']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SampleConditionSet
  currentMap = {}
  abstractTypes['SampleConditionSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00001'] = currentMap
  loadMaps['NMR.SampleConditionSet'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'sampleConditionSets'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.SampleConditionSet
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SampleConditionSet.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SampleConditionSet.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00024'] = currentMap
  loadMaps['NMR.SampleConditionSet.details'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00024'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute SampleConditionSet.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-26-14:12:30_00003'] = currentMap
  loadMaps['NMR.SampleConditionSet.name'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-26-14:12:30_00003'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute SampleConditionSet.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00023'] = currentMap
  loadMaps['NMR.SampleConditionSet.serial'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00023'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role SampleConditionSet.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SampleConditionSet.citations
  currentMap = {}
  contentMap['citations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00022'] = currentMap
  loadMaps['NMR.SampleConditionSet.citations'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet.citations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00022'
  currentMap['name'] = 'citations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CITA').get('exolinks')

  # Role SampleConditionSet.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00051'] = currentMap
  loadMaps['NMR.SampleConditionSet.experiments'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00051'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role SampleConditionSet.sampleConditions
  currentMap = {}
  contentMap['sampleConditions'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00015'] = currentMap
  loadMaps['NMR.SampleConditionSet.sampleConditions'] = currentMap
  currentMap['tag'] = 'NMR.SampleConditionSet.sampleConditions'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00015'
  currentMap['name'] = 'sampleConditions'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')
  # End of SampleConditionSet

  currentMap = abstractTypes.get('SampleConditionSet')
  aList = ['name', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['sampleConditions', 'citations', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['sampleConditions']
  currentMap['children'] = aList

  # Class ShiftReference
  currentMap = {}
  abstractTypes['ShiftReference'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00010'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'shiftReferences'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftReference
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ShiftReference.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ShiftReference.atomGroup
  currentMap = {}
  contentMap['atomGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00008'] = currentMap
  loadMaps['NMR.ShiftReference.atomGroup'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.atomGroup'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00008'
  currentMap['name'] = 'atomGroup'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ShiftReference.indirectShiftRatio
  currentMap = {}
  contentMap['indirectShiftRatio'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00012'] = currentMap
  loadMaps['NMR.ShiftReference.indirectShiftRatio'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.indirectShiftRatio'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00012'
  currentMap['name'] = 'indirectShiftRatio'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00030')

  # Attribute ShiftReference.isotopeCode
  currentMap = {}
  contentMap['isotopeCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00006'] = currentMap
  loadMaps['NMR.ShiftReference.isotopeCode'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.isotopeCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00006'
  currentMap['name'] = 'isotopeCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ShiftReference.molName
  currentMap = {}
  contentMap['molName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00007'] = currentMap
  loadMaps['NMR.ShiftReference.molName'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.molName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00007'
  currentMap['name'] = 'molName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00004')

  # Attribute ShiftReference.referenceType
  currentMap = {}
  contentMap['referenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00011'] = currentMap
  loadMaps['NMR.ShiftReference.referenceType'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.referenceType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00011'
  currentMap['name'] = 'referenceType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00033')

  # Attribute ShiftReference.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00005'] = currentMap
  loadMaps['NMR.ShiftReference.serial'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00005'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ShiftReference.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00009'] = currentMap
  loadMaps['NMR.ShiftReference.unit'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00009'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'ppm'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ShiftReference.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00010'] = currentMap
  loadMaps['NMR.ShiftReference.value'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00010'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role ShiftReference.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ShiftReference.citation
  currentMap = {}
  contentMap['citation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00004'] = currentMap
  loadMaps['NMR.ShiftReference.citation'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.citation'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00004'
  currentMap['name'] = 'citation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CITA').get('exolinks')

  # Role ShiftReference.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00055'] = currentMap
  loadMaps['NMR.ShiftReference.experiments'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00055'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role ShiftReference.shiftRatioCitation
  currentMap = {}
  contentMap['shiftRatioCitation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00002'] = currentMap
  loadMaps['NMR.ShiftReference.shiftRatioCitation'] = currentMap
  currentMap['tag'] = 'NMR.ShiftReference.shiftRatioCitation'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00002'
  currentMap['name'] = 'shiftRatioCitation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CITA').get('exolinks')
  # End of ShiftReference

  currentMap = abstractTypes.get('ShiftReference')
  aList = ['indirectShiftRatio', 'isotopeCode', 'referenceType', 'serial', 'unit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['atomGroup', 'molName', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['shiftRatioCitation', 'citation', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SparseSampling
  currentMap = {}
  abstractTypes['SparseSampling'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:27:55_00001'] = currentMap
  loadMaps['NMR.SparseSampling'] = currentMap
  currentMap['tag'] = 'NMR.SparseSampling'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:27:55_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'sparseSamplings'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.SparseSampling
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SparseSampling.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SparseSampling.dim
  currentMap = {}
  contentMap['dim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:28:19_00001'] = currentMap
  loadMaps['NMR.SparseSampling.dim'] = currentMap
  currentMap['tag'] = 'NMR.SparseSampling.dim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:28:19_00001'
  currentMap['name'] = 'dim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute SparseSampling.minPointsPerVector
  currentMap = {}
  contentMap['minPointsPerVector'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:55:32_00003'] = currentMap
  loadMaps['NMR.SparseSampling.minPointsPerVector'] = currentMap
  currentMap['tag'] = 'NMR.SparseSampling.minPointsPerVector'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:55:32_00003'
  currentMap['name'] = 'minPointsPerVector'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute SparseSampling.pointNumbers
  currentMap = {}
  contentMap['pointNumbers'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:28:19_00002'] = currentMap
  loadMaps['NMR.SparseSampling.pointNumbers'] = currentMap
  currentMap['tag'] = 'NMR.SparseSampling.pointNumbers'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:28:19_00002'
  currentMap['name'] = 'pointNumbers'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute SparseSampling.predJ
  currentMap = {}
  contentMap['predJ'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:55:32_00002'] = currentMap
  loadMaps['NMR.SparseSampling.predJ'] = currentMap
  currentMap['tag'] = 'NMR.SparseSampling.predJ'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:55:32_00002'
  currentMap['name'] = 'predJ'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SparseSampling.predT2
  currentMap = {}
  contentMap['predT2'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-05-11:55:32_00001'] = currentMap
  loadMaps['NMR.SparseSampling.predT2'] = currentMap
  currentMap['tag'] = 'NMR.SparseSampling.predT2'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:55:32_00001'
  currentMap['name'] = 'predT2'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Role SparseSampling.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of SparseSampling

  currentMap = abstractTypes.get('SparseSampling')
  aList = ['dim', 'minPointsPerVector', 'predJ', 'predT2']
  currentMap['headerAttrs'] = aList
  aList = ['pointNumbers']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class StructureAnalysis
  currentMap = {}
  abstractTypes['StructureAnalysis'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:24_00001'] = currentMap
  loadMaps['NMR.StructureAnalysis'] = currentMap
  currentMap['tag'] = 'NMR.StructureAnalysis'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:24_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'structureAnalyses'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.StructureAnalysis
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute StructureAnalysis.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute StructureAnalysis.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00004'] = currentMap
  loadMaps['NMR.StructureAnalysis.details'] = currentMap
  currentMap['tag'] = 'NMR.StructureAnalysis.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00004'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute StructureAnalysis.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00003'] = currentMap
  loadMaps['NMR.StructureAnalysis.name'] = currentMap
  currentMap['tag'] = 'NMR.StructureAnalysis.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00003'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute StructureAnalysis.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00002'] = currentMap
  loadMaps['NMR.StructureAnalysis.serial'] = currentMap
  currentMap['tag'] = 'NMR.StructureAnalysis.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00002'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role StructureAnalysis.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role StructureAnalysis.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00001'] = currentMap
  loadMaps['NMR.StructureAnalysis.method'] = currentMap
  currentMap['tag'] = 'NMR.StructureAnalysis.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:32_00001'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role StructureAnalysis.structureEnsembles
  currentMap = {}
  contentMap['structureEnsembles'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-06-18:40:29_00001'] = currentMap
  loadMaps['NMR.StructureAnalysis.structureEnsembles'] = currentMap
  currentMap['tag'] = 'NMR.StructureAnalysis.structureEnsembles'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:29_00001'
  currentMap['name'] = 'structureEnsembles'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('COOR').get('exolinks')
  # End of StructureAnalysis

  currentMap = abstractTypes.get('StructureAnalysis')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['structureEnsembles', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class StructureGeneration
  currentMap = {}
  abstractTypes['StructureGeneration'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00011'] = currentMap
  loadMaps['NMR.StructureGeneration'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'structureGenerations'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.StructureGeneration
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute StructureGeneration.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute StructureGeneration.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:30_00001'] = currentMap
  loadMaps['NMR.StructureGeneration.details'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:30_00001'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute StructureGeneration.generationType
  currentMap = {}
  contentMap['generationType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:29_00007'] = currentMap
  loadMaps['NMR.StructureGeneration.generationType'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration.generationType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:29_00007'
  currentMap['name'] = 'generationType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'denovo'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:50_00002')

  # Attribute StructureGeneration.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:29_00006'] = currentMap
  loadMaps['NMR.StructureGeneration.name'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:29_00006'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute StructureGeneration.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:29_00005'] = currentMap
  loadMaps['NMR.StructureGeneration.serial'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:29_00005'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role StructureGeneration.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role StructureGeneration.method
  currentMap = {}
  contentMap['method'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:16_00003'] = currentMap
  loadMaps['NMR.StructureGeneration.method'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration.method'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:16_00003'
  currentMap['name'] = 'method'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role StructureGeneration.structureEnsemble
  currentMap = {}
  contentMap['structureEnsemble'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-03-11-17:36:01_00002'] = currentMap
  loadMaps['NMR.StructureGeneration.structureEnsemble'] = currentMap
  currentMap['tag'] = 'NMR.StructureGeneration.structureEnsemble'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-11-17:36:01_00002'
  currentMap['name'] = 'structureEnsemble'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('COOR').get('exolinks')
  # End of StructureGeneration

  currentMap = abstractTypes.get('StructureGeneration')
  aList = ['generationType', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['structureEnsemble', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SpectralDensityDerivation
  currentMap = {}
  abstractTypes['SpectralDensityDerivation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00012'] = currentMap
  loadMaps['NMR.SpectralDensityDerivation'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensityDerivation'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00012'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivations'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.SpectralDensityDerivation
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectralDensityDerivation.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectralDensityDerivation.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00042')

  # Attribute SpectralDensityDerivation.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00041')

  # Role SpectralDensityDerivation.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectralDensityDerivation.derivedData
  currentMap = {}
  contentMap['derivedData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00019'] = currentMap
  loadMaps['NMR.SpectralDensityDerivation.derivedData'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensityDerivation.derivedData'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00019'
  currentMap['name'] = 'derivedData'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role SpectralDensityDerivation.inputMeasurements
  contentMap['inputMeasurements'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00013')

  # Role SpectralDensityDerivation.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00038')

  # Role SpectralDensityDerivation.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00034')

  # Role SpectralDensityDerivation.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00036')
  # End of SpectralDensityDerivation

  currentMap = abstractTypes.get('SpectralDensityDerivation')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'inputMeasurements', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['derivedData', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivedData']
  currentMap['children'] = aList

  # Class IsotropicS2Derivation
  currentMap = {}
  abstractTypes['IsotropicS2Derivation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00009'] = currentMap
  loadMaps['NMR.IsotropicS2Derivation'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2Derivation'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00009'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivations'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.IsotropicS2Derivation
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute IsotropicS2Derivation.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute IsotropicS2Derivation.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00042')

  # Attribute IsotropicS2Derivation.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00041')

  # Role IsotropicS2Derivation.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role IsotropicS2Derivation.derivedData
  currentMap = {}
  contentMap['derivedData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00007'] = currentMap
  loadMaps['NMR.IsotropicS2Derivation.derivedData'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2Derivation.derivedData'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00007'
  currentMap['name'] = 'derivedData'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role IsotropicS2Derivation.inputMeasurements
  contentMap['inputMeasurements'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00013')

  # Role IsotropicS2Derivation.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00038')

  # Role IsotropicS2Derivation.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00034')

  # Role IsotropicS2Derivation.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00036')
  # End of IsotropicS2Derivation

  currentMap = abstractTypes.get('IsotropicS2Derivation')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'inputMeasurements', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['derivedData', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivedData']
  currentMap['children'] = aList

  # Class DataDerivation
  currentMap = {}
  abstractTypes['DataDerivation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00014'] = currentMap
  loadMaps['NMR.DataDerivation'] = currentMap
  currentMap['tag'] = 'NMR.DataDerivation'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00014'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivations'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DataDerivation
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DataDerivation.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DataDerivation.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00042')

  # Attribute DataDerivation.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00041')

  # Role DataDerivation.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DataDerivation.derivedData
  currentMap = {}
  contentMap['derivedData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00026'] = currentMap
  loadMaps['NMR.DataDerivation.derivedData'] = currentMap
  currentMap['tag'] = 'NMR.DataDerivation.derivedData'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00026'
  currentMap['name'] = 'derivedData'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role DataDerivation.inputMeasurements
  contentMap['inputMeasurements'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00013')

  # Role DataDerivation.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00038')

  # Role DataDerivation.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00034')

  # Role DataDerivation.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00036')
  # End of DataDerivation

  currentMap = abstractTypes.get('DataDerivation')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'inputMeasurements', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['derivedData', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivedData']
  currentMap['children'] = aList

  # Class PKaDerivation
  currentMap = {}
  abstractTypes['PKaDerivation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00027'] = currentMap
  loadMaps['NMR.PKaDerivation'] = currentMap
  currentMap['tag'] = 'NMR.PKaDerivation'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00027'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivations'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PKaDerivation
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PKaDerivation.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PKaDerivation.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00042')

  # Attribute PKaDerivation.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00041')

  # Role PKaDerivation.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PKaDerivation.derivedData
  currentMap = {}
  contentMap['derivedData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00036'] = currentMap
  loadMaps['NMR.PKaDerivation.derivedData'] = currentMap
  currentMap['tag'] = 'NMR.PKaDerivation.derivedData'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00036'
  currentMap['name'] = 'derivedData'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role PKaDerivation.inputMeasurements
  contentMap['inputMeasurements'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00013')

  # Role PKaDerivation.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00038')

  # Role PKaDerivation.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00034')

  # Role PKaDerivation.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00036')
  # End of PKaDerivation

  currentMap = abstractTypes.get('PKaDerivation')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'inputMeasurements', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['derivedData', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivedData']
  currentMap['children'] = aList

  # Class SampledDataDim
  currentMap = {}
  abstractTypes['SampledDataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00002'] = currentMap
  loadMaps['NMR.SampledDataDim'] = currentMap
  currentMap['tag'] = 'NMR.SampledDataDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataDims'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.SampledDataDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SampledDataDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SampledDataDim.conditionVaried
  currentMap = {}
  contentMap['conditionVaried'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00027'] = currentMap
  loadMaps['NMR.SampledDataDim.conditionVaried'] = currentMap
  currentMap['tag'] = 'NMR.SampledDataDim.conditionVaried'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00027'
  currentMap['name'] = 'conditionVaried'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00003')

  # Attribute SampledDataDim.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00028'] = currentMap
  loadMaps['NMR.SampledDataDim.details'] = currentMap
  currentMap['tag'] = 'NMR.SampledDataDim.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00028'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute SampledDataDim.dim
  contentMap['dim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00003')

  # Attribute SampledDataDim.fileDim
  contentMap['fileDim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00001')

  # Attribute SampledDataDim.isComplex
  contentMap['isComplex'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00006')

  # Attribute SampledDataDim.numPoints
  contentMap['numPoints'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00005')

  # Attribute SampledDataDim.pointErrors
  currentMap = {}
  contentMap['pointErrors'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00026'] = currentMap
  loadMaps['NMR.SampledDataDim.pointErrors'] = currentMap
  currentMap['tag'] = 'NMR.SampledDataDim.pointErrors'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00026'
  currentMap['name'] = 'pointErrors'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute SampledDataDim.pointValues
  currentMap = {}
  contentMap['pointValues'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00025'] = currentMap
  loadMaps['NMR.SampledDataDim.pointValues'] = currentMap
  currentMap['tag'] = 'NMR.SampledDataDim.pointValues'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00025'
  currentMap['name'] = 'pointValues'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SampledDataDim.shapeSerial
  contentMap['shapeSerial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00002')

  # Attribute SampledDataDim.unit
  contentMap['unit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00007')

  # Role SampledDataDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SampledDataDim.dimensionScalings
  contentMap['dimensionScalings'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00002')

  # Role SampledDataDim.expDim
  contentMap['expDim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00046')

  # Role SampledDataDim.predictMethod
  contentMap['predictMethod'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00001')
  # End of SampledDataDim

  currentMap = abstractTypes.get('SampledDataDim')
  aList = ['dim', 'fileDim', 'isComplex', 'numPoints', 'shapeSerial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['conditionVaried', 'details', 'pointErrors', 'pointValues']
  currentMap['simpleAttrs'] = aList
  aList = ['expDim']
  currentMap['optLinks'] = aList
  aList = ['dimensionScalings', 'predictMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['dimensionScalings']
  currentMap['children'] = aList

  # Class FreqDataDim
  currentMap = {}
  abstractTypes['FreqDataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00033'] = currentMap
  loadMaps['NMR.FreqDataDim'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00033'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataDims'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.FreqDataDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute FreqDataDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute FreqDataDim.dim
  contentMap['dim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00003')

  # Attribute FreqDataDim.fileDim
  contentMap['fileDim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00001')

  # Attribute FreqDataDim.isComplex
  contentMap['isComplex'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00006')

  # Attribute FreqDataDim.numPoints
  contentMap['numPoints'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00005')

  # Attribute FreqDataDim.numPointsOrig
  currentMap = {}
  contentMap['numPointsOrig'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00023'] = currentMap
  loadMaps['NMR.FreqDataDim.numPointsOrig'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim.numPointsOrig'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00023'
  currentMap['name'] = 'numPointsOrig'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute FreqDataDim.phase0
  currentMap = {}
  contentMap['phase0'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00025'] = currentMap
  loadMaps['NMR.FreqDataDim.phase0'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim.phase0'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00025'
  currentMap['name'] = 'phase0'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute FreqDataDim.phase1
  currentMap = {}
  contentMap['phase1'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00026'] = currentMap
  loadMaps['NMR.FreqDataDim.phase1'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim.phase1'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00026'
  currentMap['name'] = 'phase1'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute FreqDataDim.pointOffset
  currentMap = {}
  contentMap['pointOffset'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00024'] = currentMap
  loadMaps['NMR.FreqDataDim.pointOffset'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim.pointOffset'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00024'
  currentMap['name'] = 'pointOffset'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute FreqDataDim.shapeSerial
  contentMap['shapeSerial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00002')

  # Attribute FreqDataDim.unit
  contentMap['unit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00007')

  # Attribute FreqDataDim.valuePerPoint
  currentMap = {}
  contentMap['valuePerPoint'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00027'] = currentMap
  loadMaps['NMR.FreqDataDim.valuePerPoint'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim.valuePerPoint'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00027'
  currentMap['name'] = 'valuePerPoint'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role FreqDataDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role FreqDataDim.dataDimRefs
  currentMap = {}
  contentMap['dataDimRefs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00022'] = currentMap
  loadMaps['NMR.FreqDataDim.dataDimRefs'] = currentMap
  currentMap['tag'] = 'NMR.FreqDataDim.dataDimRefs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00022'
  currentMap['name'] = 'dataDimRefs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role FreqDataDim.dimensionScalings
  contentMap['dimensionScalings'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00002')

  # Role FreqDataDim.expDim
  contentMap['expDim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00046')

  # Role FreqDataDim.predictMethod
  contentMap['predictMethod'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00001')
  # End of FreqDataDim

  currentMap = abstractTypes.get('FreqDataDim')
  aList = ['dim', 'fileDim', 'isComplex', 'numPoints', 'numPointsOrig', 'phase0', 'phase1', 'pointOffset', 'shapeSerial', 'unit', 'valuePerPoint']
  currentMap['headerAttrs'] = aList
  aList = ['expDim']
  currentMap['optLinks'] = aList
  aList = ['dimensionScalings', 'dataDimRefs', 'predictMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['dataDimRefs', 'dimensionScalings']
  currentMap['children'] = aList

  # Class FidDataDim
  currentMap = {}
  abstractTypes['FidDataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00032'] = currentMap
  loadMaps['NMR.FidDataDim'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00032'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'dataDims'
  currentMap['objkey'] = 'dim'
  currentMap['class'] = ccp.api.nmr.Nmr.FidDataDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute FidDataDim.alternateSign
  currentMap = {}
  contentMap['alternateSign'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00015'] = currentMap
  loadMaps['NMR.FidDataDim.alternateSign'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.alternateSign'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00015'
  currentMap['name'] = 'alternateSign'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute FidDataDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute FidDataDim.dim
  contentMap['dim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00003')

  # Attribute FidDataDim.fileDim
  contentMap['fileDim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00001')

  # Attribute FidDataDim.firstValue
  currentMap = {}
  contentMap['firstValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00006'] = currentMap
  loadMaps['NMR.FidDataDim.firstValue'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.firstValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00006'
  currentMap['name'] = 'firstValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute FidDataDim.isComplex
  contentMap['isComplex'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00006')

  # Attribute FidDataDim.negateImaginary
  currentMap = {}
  contentMap['negateImaginary'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00016'] = currentMap
  loadMaps['NMR.FidDataDim.negateImaginary'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.negateImaginary'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00016'
  currentMap['name'] = 'negateImaginary'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute FidDataDim.numPoints
  contentMap['numPoints'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00005')

  # Attribute FidDataDim.numPointsValid
  currentMap = {}
  contentMap['numPointsValid'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00009'] = currentMap
  loadMaps['NMR.FidDataDim.numPointsValid'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.numPointsValid'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00009'
  currentMap['name'] = 'numPointsValid'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute FidDataDim.oversamplingInfo
  currentMap = {}
  contentMap['oversamplingInfo'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00014'] = currentMap
  loadMaps['NMR.FidDataDim.oversamplingInfo'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.oversamplingInfo'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00014'
  currentMap['name'] = 'oversamplingInfo'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute FidDataDim.phase0
  currentMap = {}
  contentMap['phase0'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00011'] = currentMap
  loadMaps['NMR.FidDataDim.phase0'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.phase0'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00011'
  currentMap['name'] = 'phase0'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute FidDataDim.phase1
  currentMap = {}
  contentMap['phase1'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00012'] = currentMap
  loadMaps['NMR.FidDataDim.phase1'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.phase1'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00012'
  currentMap['name'] = 'phase1'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute FidDataDim.pointOffset
  currentMap = {}
  contentMap['pointOffset'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00010'] = currentMap
  loadMaps['NMR.FidDataDim.pointOffset'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.pointOffset'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00010'
  currentMap['name'] = 'pointOffset'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute FidDataDim.shapeSerial
  contentMap['shapeSerial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-03-16:59:40_00002')

  # Attribute FidDataDim.unit
  contentMap['unit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00007')

  # Attribute FidDataDim.valuePerPoint
  currentMap = {}
  contentMap['valuePerPoint'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00007'] = currentMap
  loadMaps['NMR.FidDataDim.valuePerPoint'] = currentMap
  currentMap['tag'] = 'NMR.FidDataDim.valuePerPoint'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00007'
  currentMap['name'] = 'valuePerPoint'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role FidDataDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role FidDataDim.dimensionScalings
  contentMap['dimensionScalings'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-04-10-18:39:14_00002')

  # Role FidDataDim.expDim
  contentMap['expDim'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:57_00046')

  # Role FidDataDim.predictMethod
  contentMap['predictMethod'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00001')
  # End of FidDataDim

  currentMap = abstractTypes.get('FidDataDim')
  aList = ['alternateSign', 'dim', 'fileDim', 'firstValue', 'isComplex', 'negateImaginary', 'numPoints', 'numPointsValid', 'phase0', 'phase1', 'pointOffset', 'shapeSerial', 'unit', 'valuePerPoint']
  currentMap['headerAttrs'] = aList
  aList = ['oversamplingInfo']
  currentMap['simpleAttrs'] = aList
  aList = ['expDim']
  currentMap['optLinks'] = aList
  aList = ['dimensionScalings', 'predictMethod', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['dimensionScalings']
  currentMap['children'] = aList

  # Class T1
  currentMap = {}
  abstractTypes['T1'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00017'] = currentMap
  loadMaps['NMR.T1'] = currentMap
  currentMap['tag'] = 'NMR.T1'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00017'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.T1
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute T1.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute T1.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute T1.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute T1.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute T1.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role T1.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role T1.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role T1.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role T1.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role T1.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role T1.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role T1.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00007'] = currentMap
  loadMaps['NMR.T1.resonance'] = currentMap
  currentMap['tag'] = 'NMR.T1.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00007'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of T1

  currentMap = abstractTypes.get('T1')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class T1Rho
  currentMap = {}
  abstractTypes['T1Rho'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00019'] = currentMap
  loadMaps['NMR.T1Rho'] = currentMap
  currentMap['tag'] = 'NMR.T1Rho'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00019'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.T1Rho
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute T1Rho.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute T1Rho.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute T1Rho.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute T1Rho.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute T1Rho.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role T1Rho.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role T1Rho.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role T1Rho.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role T1Rho.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role T1Rho.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role T1Rho.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role T1Rho.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00016'] = currentMap
  loadMaps['NMR.T1Rho.resonance'] = currentMap
  currentMap['tag'] = 'NMR.T1Rho.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00016'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of T1Rho

  currentMap = abstractTypes.get('T1Rho')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ShiftDifference
  currentMap = {}
  abstractTypes['ShiftDifference'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00007'] = currentMap
  loadMaps['NMR.ShiftDifference'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifference'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00007'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftDifference
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ShiftDifference.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ShiftDifference.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute ShiftDifference.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute ShiftDifference.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute ShiftDifference.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role ShiftDifference.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ShiftDifference.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role ShiftDifference.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role ShiftDifference.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role ShiftDifference.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role ShiftDifference.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role ShiftDifference.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00040'] = currentMap
  loadMaps['NMR.ShiftDifference.resonance'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifference.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00040'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ShiftDifference

  currentMap = abstractTypes.get('ShiftDifference')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Shift
  currentMap = {}
  abstractTypes['Shift'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00004'] = currentMap
  loadMaps['NMR.Shift'] = currentMap
  currentMap['tag'] = 'NMR.Shift'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.Shift
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Shift.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Shift.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute Shift.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute Shift.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute Shift.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role Shift.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Shift.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role Shift.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role Shift.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role Shift.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role Shift.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role Shift.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00030'] = currentMap
  loadMaps['NMR.Shift.resonance'] = currentMap
  currentMap['tag'] = 'NMR.Shift.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00030'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of Shift

  currentMap = abstractTypes.get('Shift')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class T2
  currentMap = {}
  abstractTypes['T2'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00021'] = currentMap
  loadMaps['NMR.T2'] = currentMap
  currentMap['tag'] = 'NMR.T2'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00021'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.T2
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute T2.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute T2.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute T2.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute T2.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute T2.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role T2.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role T2.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role T2.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role T2.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role T2.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role T2.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role T2.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00025'] = currentMap
  loadMaps['NMR.T2.resonance'] = currentMap
  currentMap['tag'] = 'NMR.T2.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00025'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of T2

  currentMap = abstractTypes.get('T2')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Noe
  currentMap = {}
  abstractTypes['Noe'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00005'] = currentMap
  loadMaps['NMR.Noe'] = currentMap
  currentMap['tag'] = 'NMR.Noe'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00005'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['class'] = ccp.api.nmr.Nmr.Noe
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Noe.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Noe.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute Noe.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute Noe.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute Noe.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role Noe.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Noe.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role Noe.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role Noe.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role Noe.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role Noe.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role Noe.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00052'] = currentMap
  loadMaps['NMR.Noe.resonances'] = currentMap
  currentMap['tag'] = 'NMR.Noe.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00052'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of Noe

  currentMap = abstractTypes.get('Noe')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class HExchProtection
  currentMap = {}
  abstractTypes['HExchProtection'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00001'] = currentMap
  loadMaps['NMR.HExchProtection'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtection'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchProtection
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HExchProtection.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HExchProtection.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute HExchProtection.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute HExchProtection.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute HExchProtection.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role HExchProtection.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HExchProtection.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role HExchProtection.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role HExchProtection.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role HExchProtection.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role HExchProtection.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role HExchProtection.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00036'] = currentMap
  loadMaps['NMR.HExchProtection.resonance'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtection.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00036'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of HExchProtection

  currentMap = abstractTypes.get('HExchProtection')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class HExchRate
  currentMap = {}
  abstractTypes['HExchRate'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00003'] = currentMap
  loadMaps['NMR.HExchRate'] = currentMap
  currentMap['tag'] = 'NMR.HExchRate'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchRate
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HExchRate.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HExchRate.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute HExchRate.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute HExchRate.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute HExchRate.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role HExchRate.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HExchRate.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role HExchRate.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role HExchRate.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role HExchRate.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role HExchRate.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role HExchRate.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00045'] = currentMap
  loadMaps['NMR.HExchRate.resonance'] = currentMap
  currentMap['tag'] = 'NMR.HExchRate.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00045'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of HExchRate

  currentMap = abstractTypes.get('HExchRate')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class JCoupling
  currentMap = {}
  abstractTypes['JCoupling'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00011'] = currentMap
  loadMaps['NMR.JCoupling'] = currentMap
  currentMap['tag'] = 'NMR.JCoupling'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['class'] = ccp.api.nmr.Nmr.JCoupling
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute JCoupling.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute JCoupling.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute JCoupling.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute JCoupling.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute JCoupling.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role JCoupling.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role JCoupling.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role JCoupling.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role JCoupling.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role JCoupling.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role JCoupling.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role JCoupling.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00016'] = currentMap
  loadMaps['NMR.JCoupling.resonances'] = currentMap
  currentMap['tag'] = 'NMR.JCoupling.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00016'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of JCoupling

  currentMap = abstractTypes.get('JCoupling')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class DipolarRelaxation
  currentMap = {}
  abstractTypes['DipolarRelaxation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00023'] = currentMap
  loadMaps['NMR.DipolarRelaxation'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxation'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00023'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['class'] = ccp.api.nmr.Nmr.DipolarRelaxation
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DipolarRelaxation.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DipolarRelaxation.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute DipolarRelaxation.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute DipolarRelaxation.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute DipolarRelaxation.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role DipolarRelaxation.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DipolarRelaxation.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role DipolarRelaxation.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role DipolarRelaxation.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role DipolarRelaxation.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role DipolarRelaxation.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role DipolarRelaxation.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00006'] = currentMap
  loadMaps['NMR.DipolarRelaxation.resonances'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxation.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00006'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of DipolarRelaxation

  currentMap = abstractTypes.get('DipolarRelaxation')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Rdc
  currentMap = {}
  abstractTypes['Rdc'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00029'] = currentMap
  loadMaps['NMR.Rdc'] = currentMap
  currentMap['tag'] = 'NMR.Rdc'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00029'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['class'] = ccp.api.nmr.Nmr.Rdc
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Rdc.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Rdc.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute Rdc.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute Rdc.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute Rdc.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role Rdc.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Rdc.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role Rdc.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role Rdc.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role Rdc.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role Rdc.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role Rdc.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00042'] = currentMap
  loadMaps['NMR.Rdc.resonances'] = currentMap
  currentMap['tag'] = 'NMR.Rdc.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00042'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of Rdc

  currentMap = abstractTypes.get('Rdc')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ShiftAnisotropy
  currentMap = {}
  abstractTypes['ShiftAnisotropy'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00005'] = currentMap
  loadMaps['NMR.ShiftAnisotropy'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropy'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00005'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurements'
  currentMap['objkey'] = 'resonance'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftAnisotropy
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ShiftAnisotropy.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ShiftAnisotropy.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00018')

  # Attribute ShiftAnisotropy.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00016')

  # Attribute ShiftAnisotropy.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00017')

  # Attribute ShiftAnisotropy.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00015')

  # Role ShiftAnisotropy.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ShiftAnisotropy.dataDerivations
  contentMap['dataDerivations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00014')

  # Role ShiftAnisotropy.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:15_00010')

  # Role ShiftAnisotropy.nmrMeasurementValidations
  contentMap['nmrMeasurementValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00006')

  # Role ShiftAnisotropy.peakDims
  contentMap['peakDims'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00012')

  # Role ShiftAnisotropy.peaks
  contentMap['peaks'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:58_00010')

  # Role ShiftAnisotropy.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00032'] = currentMap
  loadMaps['NMR.ShiftAnisotropy.resonance'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropy.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00032'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ShiftAnisotropy

  currentMap = abstractTypes.get('ShiftAnisotropy')
  aList = ['error', 'figOfMerit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'dataDerivations', 'peakDims', 'peaks']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['nmrMeasurementValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class NoeList
  currentMap = {}
  abstractTypes['NoeList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00006'] = currentMap
  loadMaps['NMR.NoeList'] = currentMap
  currentMap['tag'] = 'NMR.NoeList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00006'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.NoeList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NoeList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NoeList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute NoeList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute NoeList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute NoeList.noeValueType
  currentMap = {}
  contentMap['noeValueType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00058'] = currentMap
  loadMaps['NMR.NoeList.noeValueType'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.noeValueType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00058'
  currentMap['name'] = 'noeValueType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:50_00001')

  # Attribute NoeList.refDescription
  currentMap = {}
  contentMap['refDescription'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00060'] = currentMap
  loadMaps['NMR.NoeList.refDescription'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.refDescription'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00060'
  currentMap['name'] = 'refDescription'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute NoeList.refValue
  currentMap = {}
  contentMap['refValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00059'] = currentMap
  loadMaps['NMR.NoeList.refValue'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.refValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00059'
  currentMap['name'] = 'refValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute NoeList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute NoeList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00057'] = currentMap
  loadMaps['NMR.NoeList.sf'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00057'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute NoeList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-08-10:26:07_00001'] = currentMap
  loadMaps['NMR.NoeList.unit'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-08-10:26:07_00001'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'arbitrary'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role NoeList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NoeList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00056'] = currentMap
  loadMaps['NMR.NoeList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00056'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role NoeList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00054'] = currentMap
  loadMaps['NMR.NoeList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.NoeList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00054'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role NoeList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role NoeList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of NoeList

  currentMap = abstractTypes.get('NoeList')
  aList = ['isSimulated', 'refValue', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'noeValueType', 'refDescription', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class T1List
  currentMap = {}
  abstractTypes['T1List'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00018'] = currentMap
  loadMaps['NMR.T1List'] = currentMap
  currentMap['tag'] = 'NMR.T1List'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00018'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.T1List
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute T1List.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute T1List.coherenceType
  currentMap = {}
  contentMap['coherenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00014'] = currentMap
  loadMaps['NMR.T1List.coherenceType'] = currentMap
  currentMap['tag'] = 'NMR.T1List.coherenceType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00014'
  currentMap['name'] = 'coherenceType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'z'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00039')

  # Attribute T1List.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute T1List.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute T1List.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute T1List.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute T1List.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00013'] = currentMap
  loadMaps['NMR.T1List.sf'] = currentMap
  currentMap['tag'] = 'NMR.T1List.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00013'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute T1List.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00012'] = currentMap
  loadMaps['NMR.T1List.unit'] = currentMap
  currentMap['tag'] = 'NMR.T1List.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00012'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role T1List.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role T1List.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00011'] = currentMap
  loadMaps['NMR.T1List.experiments'] = currentMap
  currentMap['tag'] = 'NMR.T1List.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00011'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role T1List.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00009'] = currentMap
  loadMaps['NMR.T1List.measurements'] = currentMap
  currentMap['tag'] = 'NMR.T1List.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00009'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role T1List.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role T1List.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of T1List

  currentMap = abstractTypes.get('T1List')
  aList = ['coherenceType', 'isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class ShiftAnisotropyList
  currentMap = {}
  abstractTypes['ShiftAnisotropyList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00006'] = currentMap
  loadMaps['NMR.ShiftAnisotropyList'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropyList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00006'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftAnisotropyList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ShiftAnisotropyList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ShiftAnisotropyList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute ShiftAnisotropyList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute ShiftAnisotropyList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute ShiftAnisotropyList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute ShiftAnisotropyList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00038'] = currentMap
  loadMaps['NMR.ShiftAnisotropyList.sf'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropyList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00038'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ShiftAnisotropyList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00037'] = currentMap
  loadMaps['NMR.ShiftAnisotropyList.unit'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropyList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00037'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'ppm'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ShiftAnisotropyList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ShiftAnisotropyList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00036'] = currentMap
  loadMaps['NMR.ShiftAnisotropyList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropyList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00036'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ShiftAnisotropyList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00034'] = currentMap
  loadMaps['NMR.ShiftAnisotropyList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.ShiftAnisotropyList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00034'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ShiftAnisotropyList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role ShiftAnisotropyList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of ShiftAnisotropyList

  currentMap = abstractTypes.get('ShiftAnisotropyList')
  aList = ['isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class ShiftDifferenceList
  currentMap = {}
  abstractTypes['ShiftDifferenceList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00008'] = currentMap
  loadMaps['NMR.ShiftDifferenceList'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftDifferenceList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ShiftDifferenceList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ShiftDifferenceList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute ShiftDifferenceList.differenceType
  currentMap = {}
  contentMap['differenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00047'] = currentMap
  loadMaps['NMR.ShiftDifferenceList.differenceType'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceList.differenceType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00047'
  currentMap['name'] = 'differenceType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00023')

  # Attribute ShiftDifferenceList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute ShiftDifferenceList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute ShiftDifferenceList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute ShiftDifferenceList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00046'] = currentMap
  loadMaps['NMR.ShiftDifferenceList.unit'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00046'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'ppm'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ShiftDifferenceList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ShiftDifferenceList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00045'] = currentMap
  loadMaps['NMR.ShiftDifferenceList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00045'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ShiftDifferenceList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00042'] = currentMap
  loadMaps['NMR.ShiftDifferenceList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00042'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ShiftDifferenceList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role ShiftDifferenceList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')

  # Role ShiftDifferenceList.referenceShiftList
  currentMap = {}
  contentMap['referenceShiftList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00043'] = currentMap
  loadMaps['NMR.ShiftDifferenceList.referenceShiftList'] = currentMap
  currentMap['tag'] = 'NMR.ShiftDifferenceList.referenceShiftList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00043'
  currentMap['name'] = 'referenceShiftList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of ShiftDifferenceList

  currentMap = abstractTypes.get('ShiftDifferenceList')
  aList = ['differenceType', 'isSimulated', 'serial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments', 'referenceShiftList']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class T1RhoList
  currentMap = {}
  abstractTypes['T1RhoList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00020'] = currentMap
  loadMaps['NMR.T1RhoList'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00020'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.T1RhoList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute T1RhoList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute T1RhoList.coherenceType
  currentMap = {}
  contentMap['coherenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00023'] = currentMap
  loadMaps['NMR.T1RhoList.coherenceType'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.coherenceType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00023'
  currentMap['name'] = 'coherenceType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'SQ'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00001')

  # Attribute T1RhoList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute T1RhoList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute T1RhoList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute T1RhoList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute T1RhoList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00022'] = currentMap
  loadMaps['NMR.T1RhoList.sf'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00022'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute T1RhoList.tempCalibMethod
  currentMap = {}
  contentMap['tempCalibMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00001'] = currentMap
  loadMaps['NMR.T1RhoList.tempCalibMethod'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.tempCalibMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00001'
  currentMap['name'] = 'tempCalibMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00001')

  # Attribute T1RhoList.tempControlMethod
  currentMap = {}
  contentMap['tempControlMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00002'] = currentMap
  loadMaps['NMR.T1RhoList.tempControlMethod'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.tempControlMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00002'
  currentMap['name'] = 'tempControlMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00002')

  # Attribute T1RhoList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00021'] = currentMap
  loadMaps['NMR.T1RhoList.unit'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00021'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role T1RhoList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role T1RhoList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00020'] = currentMap
  loadMaps['NMR.T1RhoList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00020'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role T1RhoList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00018'] = currentMap
  loadMaps['NMR.T1RhoList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.T1RhoList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00018'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role T1RhoList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role T1RhoList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of T1RhoList

  currentMap = abstractTypes.get('T1RhoList')
  aList = ['coherenceType', 'isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'tempCalibMethod', 'tempControlMethod', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class T2List
  currentMap = {}
  abstractTypes['T2List'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00022'] = currentMap
  loadMaps['NMR.T2List'] = currentMap
  currentMap['tag'] = 'NMR.T2List'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00022'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.T2List
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute T2List.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute T2List.coherenceType
  currentMap = {}
  contentMap['coherenceType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00032'] = currentMap
  loadMaps['NMR.T2List.coherenceType'] = currentMap
  currentMap['tag'] = 'NMR.T2List.coherenceType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00032'
  currentMap['name'] = 'coherenceType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'SQ'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00001')

  # Attribute T2List.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute T2List.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute T2List.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute T2List.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute T2List.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00031'] = currentMap
  loadMaps['NMR.T2List.sf'] = currentMap
  currentMap['tag'] = 'NMR.T2List.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00031'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute T2List.tempCalibMethod
  currentMap = {}
  contentMap['tempCalibMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00003'] = currentMap
  loadMaps['NMR.T2List.tempCalibMethod'] = currentMap
  currentMap['tag'] = 'NMR.T2List.tempCalibMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00003'
  currentMap['name'] = 'tempCalibMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00001')

  # Attribute T2List.tempControlMethod
  currentMap = {}
  contentMap['tempControlMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00004'] = currentMap
  loadMaps['NMR.T2List.tempControlMethod'] = currentMap
  currentMap['tag'] = 'NMR.T2List.tempControlMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00004'
  currentMap['name'] = 'tempControlMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-02-05-11:33:12_00002')

  # Attribute T2List.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00030'] = currentMap
  loadMaps['NMR.T2List.unit'] = currentMap
  currentMap['tag'] = 'NMR.T2List.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00030'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role T2List.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role T2List.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00029'] = currentMap
  loadMaps['NMR.T2List.experiments'] = currentMap
  currentMap['tag'] = 'NMR.T2List.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00029'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role T2List.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00027'] = currentMap
  loadMaps['NMR.T2List.measurements'] = currentMap
  currentMap['tag'] = 'NMR.T2List.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00027'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role T2List.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role T2List.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of T2List

  currentMap = abstractTypes.get('T2List')
  aList = ['coherenceType', 'isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'tempCalibMethod', 'tempControlMethod', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class ShiftList
  currentMap = {}
  abstractTypes['ShiftList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00009'] = currentMap
  loadMaps['NMR.ShiftList'] = currentMap
  currentMap['tag'] = 'NMR.ShiftList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00009'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ShiftList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ShiftList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute ShiftList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute ShiftList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute ShiftList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute ShiftList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00052'] = currentMap
  loadMaps['NMR.ShiftList.unit'] = currentMap
  currentMap['tag'] = 'NMR.ShiftList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00052'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'ppm'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ShiftList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ShiftList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00051'] = currentMap
  loadMaps['NMR.ShiftList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.ShiftList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00051'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ShiftList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00049'] = currentMap
  loadMaps['NMR.ShiftList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.ShiftList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00049'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role ShiftList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role ShiftList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of ShiftList

  currentMap = abstractTypes.get('ShiftList')
  aList = ['isSimulated', 'serial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class HExchRateList
  currentMap = {}
  abstractTypes['HExchRateList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00004'] = currentMap
  loadMaps['NMR.HExchRateList'] = currentMap
  currentMap['tag'] = 'NMR.HExchRateList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchRateList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HExchRateList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HExchRateList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute HExchRateList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute HExchRateList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute HExchRateList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute HExchRateList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00050'] = currentMap
  loadMaps['NMR.HExchRateList.unit'] = currentMap
  currentMap['tag'] = 'NMR.HExchRateList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00050'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's-1'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role HExchRateList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HExchRateList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00049'] = currentMap
  loadMaps['NMR.HExchRateList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.HExchRateList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00049'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role HExchRateList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00047'] = currentMap
  loadMaps['NMR.HExchRateList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.HExchRateList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00047'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role HExchRateList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role HExchRateList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of HExchRateList

  currentMap = abstractTypes.get('HExchRateList')
  aList = ['isSimulated', 'serial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class HExchProtectionList
  currentMap = {}
  abstractTypes['HExchProtectionList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00002'] = currentMap
  loadMaps['NMR.HExchProtectionList'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchProtectionList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HExchProtectionList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HExchProtectionList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute HExchProtectionList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute HExchProtectionList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute HExchProtectionList.protectionType
  currentMap = {}
  contentMap['protectionType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00043'] = currentMap
  loadMaps['NMR.HExchProtectionList.protectionType'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionList.protectionType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00043'
  currentMap['name'] = 'protectionType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00009')

  # Attribute HExchProtectionList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute HExchProtectionList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00042'] = currentMap
  loadMaps['NMR.HExchProtectionList.unit'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00042'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'ratio'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role HExchProtectionList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HExchProtectionList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00041'] = currentMap
  loadMaps['NMR.HExchProtectionList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00041'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role HExchProtectionList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00038'] = currentMap
  loadMaps['NMR.HExchProtectionList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00038'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role HExchProtectionList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role HExchProtectionList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')

  # Role HExchProtectionList.referenceRateList
  currentMap = {}
  contentMap['referenceRateList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00039'] = currentMap
  loadMaps['NMR.HExchProtectionList.referenceRateList'] = currentMap
  currentMap['tag'] = 'NMR.HExchProtectionList.referenceRateList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00039'
  currentMap['name'] = 'referenceRateList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of HExchProtectionList

  currentMap = abstractTypes.get('HExchProtectionList')
  aList = ['isSimulated', 'protectionType', 'serial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments', 'referenceRateList']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class JCouplingList
  currentMap = {}
  abstractTypes['JCouplingList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00012'] = currentMap
  loadMaps['NMR.JCouplingList'] = currentMap
  currentMap['tag'] = 'NMR.JCouplingList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00012'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.JCouplingList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute JCouplingList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute JCouplingList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute JCouplingList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute JCouplingList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute JCouplingList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute JCouplingList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00022'] = currentMap
  loadMaps['NMR.JCouplingList.sf'] = currentMap
  currentMap['tag'] = 'NMR.JCouplingList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00022'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute JCouplingList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00021'] = currentMap
  loadMaps['NMR.JCouplingList.unit'] = currentMap
  currentMap['tag'] = 'NMR.JCouplingList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00021'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'Hz'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role JCouplingList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role JCouplingList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00020'] = currentMap
  loadMaps['NMR.JCouplingList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.JCouplingList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00020'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role JCouplingList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00018'] = currentMap
  loadMaps['NMR.JCouplingList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.JCouplingList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00018'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role JCouplingList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role JCouplingList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of JCouplingList

  currentMap = abstractTypes.get('JCouplingList')
  aList = ['isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class DipolarRelaxList
  currentMap = {}
  abstractTypes['DipolarRelaxList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00024'] = currentMap
  loadMaps['NMR.DipolarRelaxList'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00024'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DipolarRelaxList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DipolarRelaxList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DipolarRelaxList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute DipolarRelaxList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute DipolarRelaxList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute DipolarRelaxList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute DipolarRelaxList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00011'] = currentMap
  loadMaps['NMR.DipolarRelaxList.sf'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00011'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute DipolarRelaxList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-08-10:32:18_00001'] = currentMap
  loadMaps['NMR.DipolarRelaxList.unit'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-08-10:32:18_00001'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'Hz'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role DipolarRelaxList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DipolarRelaxList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00010'] = currentMap
  loadMaps['NMR.DipolarRelaxList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00010'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role DipolarRelaxList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00008'] = currentMap
  loadMaps['NMR.DipolarRelaxList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.DipolarRelaxList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00008'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role DipolarRelaxList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role DipolarRelaxList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of DipolarRelaxList

  currentMap = abstractTypes.get('DipolarRelaxList')
  aList = ['isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class RdcList
  currentMap = {}
  abstractTypes['RdcList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00030'] = currentMap
  loadMaps['NMR.RdcList'] = currentMap
  currentMap['tag'] = 'NMR.RdcList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00030'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'measurementLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.RdcList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute RdcList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute RdcList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00009')

  # Attribute RdcList.isSimulated
  contentMap['isSimulated'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-12-11:37:22_00001')

  # Attribute RdcList.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00007')

  # Attribute RdcList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00006')

  # Attribute RdcList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00048'] = currentMap
  loadMaps['NMR.RdcList.sf'] = currentMap
  currentMap['tag'] = 'NMR.RdcList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00048'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute RdcList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00047'] = currentMap
  loadMaps['NMR.RdcList.unit'] = currentMap
  currentMap['tag'] = 'NMR.RdcList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00047'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'Hz'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role RdcList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role RdcList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00046'] = currentMap
  loadMaps['NMR.RdcList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.RdcList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00046'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role RdcList.measurements
  currentMap = {}
  contentMap['measurements'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00044'] = currentMap
  loadMaps['NMR.RdcList.measurements'] = currentMap
  currentMap['tag'] = 'NMR.RdcList.measurements'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00044'
  currentMap['name'] = 'measurements'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role RdcList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:19:59_00003')

  # Role RdcList.nmrMeasurementListValidations
  contentMap['nmrMeasurementListValidations'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-14-17:03:01_00004')
  # End of RdcList

  currentMap = abstractTypes.get('RdcList')
  aList = ['isSimulated', 'serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['measurements', 'nmrMeasurementListValidations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['measurements']
  currentMap['children'] = aList

  # Class PeakDimContribN
  currentMap = {}
  abstractTypes['PeakDimContribN'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00024'] = currentMap
  loadMaps['NMR.PeakDimContribN'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimContribN'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00024'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakDimContribs'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDimContribN
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakDimContribN.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakDimContribN.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00052')

  # Role PeakDimContribN.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakDimContribN.peakContribs
  contentMap['peakContribs'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00041')

  # Role PeakDimContribN.peakDimComponent
  contentMap['peakDimComponent'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-10-25-11:33:27_00002')

  # Role PeakDimContribN.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00034'] = currentMap
  loadMaps['NMR.PeakDimContribN.resonances'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimContribN.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00034'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = -1
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of PeakDimContribN

  currentMap = abstractTypes.get('PeakDimContribN')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['peakContribs', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['peakDimComponent']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PeakDimContrib
  currentMap = {}
  abstractTypes['PeakDimContrib'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00026'] = currentMap
  loadMaps['NMR.PeakDimContrib'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimContrib'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00026'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'peakDimContribs'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDimContrib
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PeakDimContrib.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PeakDimContrib.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00052')

  # Role PeakDimContrib.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PeakDimContrib.peakContribs
  contentMap['peakContribs'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00041')

  # Role PeakDimContrib.peakDimComponent
  contentMap['peakDimComponent'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-10-25-11:33:27_00002')

  # Role PeakDimContrib.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:22:20_00001'] = currentMap
  loadMaps['NMR.PeakDimContrib.resonance'] = currentMap
  currentMap['tag'] = 'NMR.PeakDimContrib.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:20_00001'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of PeakDimContrib

  currentMap = abstractTypes.get('PeakDimContrib')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['peakContribs']
  currentMap['simpleAttrs'] = aList
  aList = ['peakDimComponent', 'resonance']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SpectralDensity
  currentMap = {}
  abstractTypes['SpectralDensity'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00011'] = currentMap
  loadMaps['NMR.SpectralDensity'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensity'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedData'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.SpectralDensity
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectralDensity.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectralDensity.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00027')

  # Attribute SpectralDensity.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00028')

  # Attribute SpectralDensity.frequency
  currentMap = {}
  contentMap['frequency'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00017'] = currentMap
  loadMaps['NMR.SpectralDensity.frequency'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensity.frequency'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00017'
  currentMap['name'] = 'frequency'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SpectralDensity.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00025')

  # Attribute SpectralDensity.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00026')

  # Role SpectralDensity.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectralDensity.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00016'] = currentMap
  loadMaps['NMR.SpectralDensity.resonances'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensity.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00016'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of SpectralDensity

  currentMap = abstractTypes.get('SpectralDensity')
  aList = ['error', 'figOfMerit', 'frequency', 'serial', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class IsotropicS2
  currentMap = {}
  abstractTypes['IsotropicS2'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00008'] = currentMap
  loadMaps['NMR.IsotropicS2'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedData'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.IsotropicS2
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute IsotropicS2.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute IsotropicS2.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00027')

  # Attribute IsotropicS2.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00028')

  # Attribute IsotropicS2.modelFit
  currentMap = {}
  contentMap['modelFit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00003'] = currentMap
  loadMaps['NMR.IsotropicS2.modelFit'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.modelFit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00003'
  currentMap['name'] = 'modelFit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute IsotropicS2.rexError
  currentMap = {}
  contentMap['rexError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00001'] = currentMap
  loadMaps['NMR.IsotropicS2.rexError'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.rexError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00001'
  currentMap['name'] = 'rexError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.rexValue
  currentMap = {}
  contentMap['rexValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00065'] = currentMap
  loadMaps['NMR.IsotropicS2.rexValue'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.rexValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00065'
  currentMap['name'] = 'rexValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00025')

  # Attribute IsotropicS2.sumSquaredErrors
  currentMap = {}
  contentMap['sumSquaredErrors'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00002'] = currentMap
  loadMaps['NMR.IsotropicS2.sumSquaredErrors'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.sumSquaredErrors'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00002'
  currentMap['name'] = 'sumSquaredErrors'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.tauEError
  currentMap = {}
  contentMap['tauEError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00064'] = currentMap
  loadMaps['NMR.IsotropicS2.tauEError'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.tauEError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00064'
  currentMap['name'] = 'tauEError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.tauEValue
  currentMap = {}
  contentMap['tauEValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00063'] = currentMap
  loadMaps['NMR.IsotropicS2.tauEValue'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.tauEValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00063'
  currentMap['name'] = 'tauEValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.tauSError
  currentMap = {}
  contentMap['tauSError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00005'] = currentMap
  loadMaps['NMR.IsotropicS2.tauSError'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.tauSError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00005'
  currentMap['name'] = 'tauSError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.tauSValue
  currentMap = {}
  contentMap['tauSValue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00004'] = currentMap
  loadMaps['NMR.IsotropicS2.tauSValue'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.tauSValue'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00004'
  currentMap['name'] = 'tauSValue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00026')

  # Role IsotropicS2.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role IsotropicS2.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00062'] = currentMap
  loadMaps['NMR.IsotropicS2.resonances'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00062'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of IsotropicS2

  currentMap = abstractTypes.get('IsotropicS2')
  aList = ['error', 'figOfMerit', 'rexError', 'rexValue', 'serial', 'sumSquaredErrors', 'tauEError', 'tauEValue', 'tauSError', 'tauSValue', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['modelFit', 'resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Datum
  currentMap = {}
  abstractTypes['Datum'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00013'] = currentMap
  loadMaps['NMR.Datum'] = currentMap
  currentMap['tag'] = 'NMR.Datum'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00013'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedData'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.Datum
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Datum.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Datum.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00027')

  # Attribute Datum.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00028')

  # Attribute Datum.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00025')

  # Attribute Datum.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00026')

  # Role Datum.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Datum.resonances
  currentMap = {}
  contentMap['resonances'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00024'] = currentMap
  loadMaps['NMR.Datum.resonances'] = currentMap
  currentMap['tag'] = 'NMR.Datum.resonances'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00024'
  currentMap['name'] = 'resonances'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of Datum

  currentMap = abstractTypes.get('Datum')
  aList = ['error', 'figOfMerit', 'serial', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['resonances']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Pka
  currentMap = {}
  abstractTypes['Pka'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00026'] = currentMap
  loadMaps['NMR.Pka'] = currentMap
  currentMap['tag'] = 'NMR.Pka'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00026'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedData'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.Pka
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Pka.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Pka.error
  contentMap['error'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00027')

  # Attribute Pka.figOfMerit
  contentMap['figOfMerit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00028')

  # Attribute Pka.highPHParam
  currentMap = {}
  contentMap['highPHParam'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00029'] = currentMap
  loadMaps['NMR.Pka.highPHParam'] = currentMap
  currentMap['tag'] = 'NMR.Pka.highPHParam'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00029'
  currentMap['name'] = 'highPHParam'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Pka.highPHParamError
  currentMap = {}
  contentMap['highPHParamError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00030'] = currentMap
  loadMaps['NMR.Pka.highPHParamError'] = currentMap
  currentMap['tag'] = 'NMR.Pka.highPHParamError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00030'
  currentMap['name'] = 'highPHParamError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Pka.hillCoeff
  currentMap = {}
  contentMap['hillCoeff'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00027'] = currentMap
  loadMaps['NMR.Pka.hillCoeff'] = currentMap
  currentMap['tag'] = 'NMR.Pka.hillCoeff'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00027'
  currentMap['name'] = 'hillCoeff'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Pka.hillCoeffError
  currentMap = {}
  contentMap['hillCoeffError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00028'] = currentMap
  loadMaps['NMR.Pka.hillCoeffError'] = currentMap
  currentMap['tag'] = 'NMR.Pka.hillCoeffError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00028'
  currentMap['name'] = 'hillCoeffError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Pka.lowPHParam
  currentMap = {}
  contentMap['lowPHParam'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00031'] = currentMap
  loadMaps['NMR.Pka.lowPHParam'] = currentMap
  currentMap['tag'] = 'NMR.Pka.lowPHParam'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00031'
  currentMap['name'] = 'lowPHParam'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Pka.lowPHParamError
  currentMap = {}
  contentMap['lowPHParamError'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00032'] = currentMap
  loadMaps['NMR.Pka.lowPHParamError'] = currentMap
  currentMap['tag'] = 'NMR.Pka.lowPHParamError'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00032'
  currentMap['name'] = 'lowPHParamError'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Pka.parameterType
  currentMap = {}
  contentMap['parameterType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00033'] = currentMap
  loadMaps['NMR.Pka.parameterType'] = currentMap
  currentMap['tag'] = 'NMR.Pka.parameterType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00033'
  currentMap['name'] = 'parameterType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Pka.parameterUnit
  currentMap = {}
  contentMap['parameterUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00034'] = currentMap
  loadMaps['NMR.Pka.parameterUnit'] = currentMap
  currentMap['tag'] = 'NMR.Pka.parameterUnit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00034'
  currentMap['name'] = 'parameterUnit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Pka.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00025')

  # Attribute Pka.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00026')

  # Role Pka.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Pka.resonance
  currentMap = {}
  contentMap['resonance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00026'] = currentMap
  loadMaps['NMR.Pka.resonance'] = currentMap
  currentMap['tag'] = 'NMR.Pka.resonance'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00026'
  currentMap['name'] = 'resonance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of Pka

  currentMap = abstractTypes.get('Pka')
  aList = ['error', 'figOfMerit', 'highPHParam', 'highPHParamError', 'hillCoeff', 'hillCoeffError', 'lowPHParam', 'lowPHParamError', 'serial', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['parameterType', 'parameterUnit']
  currentMap['simpleAttrs'] = aList
  aList = ['resonance']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SpectralDensityList
  currentMap = {}
  abstractTypes['SpectralDensityList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00013'] = currentMap
  loadMaps['NMR.SpectralDensityList'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensityList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00013'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedDataLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.SpectralDensityList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectralDensityList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectralDensityList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00004')

  # Attribute SpectralDensityList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00003')

  # Attribute SpectralDensityList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00024'] = currentMap
  loadMaps['NMR.SpectralDensityList.unit'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensityList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00024'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's-1'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role SpectralDensityList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectralDensityList.derivations
  currentMap = {}
  contentMap['derivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00021'] = currentMap
  loadMaps['NMR.SpectralDensityList.derivations'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensityList.derivations'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00021'
  currentMap['name'] = 'derivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role SpectralDensityList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00023'] = currentMap
  loadMaps['NMR.SpectralDensityList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.SpectralDensityList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00023'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role SpectralDensityList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00032')
  # End of SpectralDensityList

  currentMap = abstractTypes.get('SpectralDensityList')
  aList = ['serial', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['derivations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivations']
  currentMap['children'] = aList

  # Class DataList
  currentMap = {}
  abstractTypes['DataList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00015'] = currentMap
  loadMaps['NMR.DataList'] = currentMap
  currentMap['tag'] = 'NMR.DataList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00015'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedDataLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.DataList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DataList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute DataList.definition
  currentMap = {}
  contentMap['definition'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00035'] = currentMap
  loadMaps['NMR.DataList.definition'] = currentMap
  currentMap['tag'] = 'NMR.DataList.definition'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00035'
  currentMap['name'] = 'definition'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute DataList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00004')

  # Attribute DataList.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00033'] = currentMap
  loadMaps['NMR.DataList.name'] = currentMap
  currentMap['tag'] = 'NMR.DataList.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00033'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute DataList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00003')

  # Attribute DataList.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00036'] = currentMap
  loadMaps['NMR.DataList.sf'] = currentMap
  currentMap['tag'] = 'NMR.DataList.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00036'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute DataList.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00034'] = currentMap
  loadMaps['NMR.DataList.unit'] = currentMap
  currentMap['tag'] = 'NMR.DataList.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00034'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role DataList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role DataList.citations
  currentMap = {}
  contentMap['citations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00028'] = currentMap
  loadMaps['NMR.DataList.citations'] = currentMap
  currentMap['tag'] = 'NMR.DataList.citations'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00028'
  currentMap['name'] = 'citations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CITA').get('exolinks')

  # Role DataList.derivations
  currentMap = {}
  contentMap['derivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00030'] = currentMap
  loadMaps['NMR.DataList.derivations'] = currentMap
  currentMap['tag'] = 'NMR.DataList.derivations'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00030'
  currentMap['name'] = 'derivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role DataList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00032'] = currentMap
  loadMaps['NMR.DataList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.DataList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00032'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role DataList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00032')
  # End of DataList

  currentMap = abstractTypes.get('DataList')
  aList = ['serial', 'sf', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['definition', 'details', 'name', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['derivations', 'method', 'citations', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivations']
  currentMap['children'] = aList

  # Class IsotropicS2List
  currentMap = {}
  abstractTypes['IsotropicS2List'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00010'] = currentMap
  loadMaps['NMR.IsotropicS2List'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2List'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedDataLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.IsotropicS2List
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute IsotropicS2List.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute IsotropicS2List.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00004')

  # Attribute IsotropicS2List.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00003')

  # Attribute IsotropicS2List.sf
  currentMap = {}
  contentMap['sf'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00012'] = currentMap
  loadMaps['NMR.IsotropicS2List.sf'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2List.sf'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00012'
  currentMap['name'] = 'sf'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute IsotropicS2List.tauEUnit
  currentMap = {}
  contentMap['tauEUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00013'] = currentMap
  loadMaps['NMR.IsotropicS2List.tauEUnit'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2List.tauEUnit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00013'
  currentMap['name'] = 'tauEUnit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute IsotropicS2List.tauSUnit
  currentMap = {}
  contentMap['tauSUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00014'] = currentMap
  loadMaps['NMR.IsotropicS2List.tauSUnit'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2List.tauSUnit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00014'
  currentMap['name'] = 'tauSUnit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 's'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role IsotropicS2List.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role IsotropicS2List.derivations
  currentMap = {}
  contentMap['derivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00009'] = currentMap
  loadMaps['NMR.IsotropicS2List.derivations'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2List.derivations'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00009'
  currentMap['name'] = 'derivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role IsotropicS2List.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00011'] = currentMap
  loadMaps['NMR.IsotropicS2List.experiments'] = currentMap
  currentMap['tag'] = 'NMR.IsotropicS2List.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:08_00011'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role IsotropicS2List.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00032')
  # End of IsotropicS2List

  currentMap = abstractTypes.get('IsotropicS2List')
  aList = ['serial', 'sf', 'tauEUnit', 'tauSUnit']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['derivations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivations']
  currentMap['children'] = aList

  # Class PkaList
  currentMap = {}
  abstractTypes['PkaList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00028'] = currentMap
  loadMaps['NMR.PkaList'] = currentMap
  currentMap['tag'] = 'NMR.PkaList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00028'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'derivedDataLists'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.PkaList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PkaList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PkaList.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00004')

  # Attribute PkaList.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:05_00003')

  # Role PkaList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PkaList.derivations
  currentMap = {}
  contentMap['derivations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00038'] = currentMap
  loadMaps['NMR.PkaList.derivations'] = currentMap
  currentMap['tag'] = 'NMR.PkaList.derivations'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00038'
  currentMap['name'] = 'derivations'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role PkaList.experiments
  currentMap = {}
  contentMap['experiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00040'] = currentMap
  loadMaps['NMR.PkaList.experiments'] = currentMap
  currentMap['tag'] = 'NMR.PkaList.experiments'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:09_00040'
  currentMap['name'] = 'experiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role PkaList.method
  contentMap['method'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:04_00032')
  # End of PkaList

  currentMap = abstractTypes.get('PkaList')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['derivations', 'method', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['derivations']
  currentMap['children'] = aList

  # Class InternalShiftReference
  currentMap = {}
  abstractTypes['InternalShiftReference'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00007'] = currentMap
  loadMaps['NMR.InternalShiftReference'] = currentMap
  currentMap['tag'] = 'NMR.InternalShiftReference'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00007'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'shiftReferences'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.InternalShiftReference
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute InternalShiftReference.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute InternalShiftReference.atomGroup
  contentMap['atomGroup'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00008')

  # Attribute InternalShiftReference.indirectShiftRatio
  contentMap['indirectShiftRatio'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00012')

  # Attribute InternalShiftReference.isotopeCode
  contentMap['isotopeCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00006')

  # Attribute InternalShiftReference.molName
  contentMap['molName'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00007')

  # Attribute InternalShiftReference.referenceType
  contentMap['referenceType'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00011')

  # Attribute InternalShiftReference.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00005')

  # Attribute InternalShiftReference.unit
  contentMap['unit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00009')

  # Attribute InternalShiftReference.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00010')

  # Role InternalShiftReference.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role InternalShiftReference.citation
  contentMap['citation'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00004')

  # Role InternalShiftReference.experiments
  contentMap['experiments'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00055')

  # Role InternalShiftReference.shiftRatioCitation
  contentMap['shiftRatioCitation'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00002')
  # End of InternalShiftReference

  currentMap = abstractTypes.get('InternalShiftReference')
  aList = ['indirectShiftRatio', 'isotopeCode', 'referenceType', 'serial', 'unit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['atomGroup', 'molName', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['shiftRatioCitation', 'citation', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ExternalShiftReference
  currentMap = {}
  abstractTypes['ExternalShiftReference'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00031'] = currentMap
  loadMaps['NMR.ExternalShiftReference'] = currentMap
  currentMap['tag'] = 'NMR.ExternalShiftReference'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00031'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'shiftReferences'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.Nmr.ExternalShiftReference
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExternalShiftReference.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExternalShiftReference.atomGroup
  contentMap['atomGroup'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00008')

  # Attribute ExternalShiftReference.axis
  currentMap = {}
  contentMap['axis'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00005'] = currentMap
  loadMaps['NMR.ExternalShiftReference.axis'] = currentMap
  currentMap['tag'] = 'NMR.ExternalShiftReference.axis'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00005'
  currentMap['name'] = 'axis'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ExternalShiftReference.indirectShiftRatio
  contentMap['indirectShiftRatio'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00012')

  # Attribute ExternalShiftReference.isotopeCode
  contentMap['isotopeCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00006')

  # Attribute ExternalShiftReference.location
  currentMap = {}
  contentMap['location'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00004'] = currentMap
  loadMaps['NMR.ExternalShiftReference.location'] = currentMap
  currentMap['tag'] = 'NMR.ExternalShiftReference.location'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00004'
  currentMap['name'] = 'location'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ExternalShiftReference.molName
  contentMap['molName'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00007')

  # Attribute ExternalShiftReference.referenceType
  contentMap['referenceType'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00011')

  # Attribute ExternalShiftReference.sampleGeometry
  currentMap = {}
  contentMap['sampleGeometry'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00003'] = currentMap
  loadMaps['NMR.ExternalShiftReference.sampleGeometry'] = currentMap
  currentMap['tag'] = 'NMR.ExternalShiftReference.sampleGeometry'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:07_00003'
  currentMap['name'] = 'sampleGeometry'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ExternalShiftReference.serial
  contentMap['serial'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00005')

  # Attribute ExternalShiftReference.unit
  contentMap['unit'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00009')

  # Attribute ExternalShiftReference.value
  contentMap['value'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00010')

  # Role ExternalShiftReference.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExternalShiftReference.citation
  contentMap['citation'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00004')

  # Role ExternalShiftReference.experiments
  contentMap['experiments'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:11_00055')

  # Role ExternalShiftReference.shiftRatioCitation
  contentMap['shiftRatioCitation'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:20:12_00002')
  # End of ExternalShiftReference

  currentMap = abstractTypes.get('ExternalShiftReference')
  aList = ['indirectShiftRatio', 'isotopeCode', 'referenceType', 'serial', 'unit', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['atomGroup', 'axis', 'location', 'molName', 'sampleGeometry', 'experiments']
  currentMap['simpleAttrs'] = aList
  aList = ['shiftRatioCitation', 'citation', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Out-of-package link to AtomSet
  currentMap = {}
  exolinks['AtomSet'] = currentMap
  loadMaps['NMR.exo-AtomSet'] = currentMap
  currentMap['tag'] = 'NMR.exo-AtomSet'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00015'
  currentMap['name'] = 'AtomSet'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.AtomSet
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ChainState
  currentMap = {}
  exolinks['ChainState'] = currentMap
  loadMaps['NMR.exo-ChainState'] = currentMap
  currentMap['tag'] = 'NMR.exo-ChainState'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00017'
  currentMap['name'] = 'ChainState'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ChainState
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ChainStateSet
  currentMap = {}
  exolinks['ChainStateSet'] = currentMap
  loadMaps['NMR.exo-ChainStateSet'] = currentMap
  currentMap['tag'] = 'NMR.exo-ChainStateSet'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00018'
  currentMap['name'] = 'ChainStateSet'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ChainStateSet
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to DataDimRef
  currentMap = {}
  exolinks['DataDimRef'] = currentMap
  loadMaps['NMR.exo-DataDimRef'] = currentMap
  currentMap['tag'] = 'NMR.exo-DataDimRef'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00019'
  currentMap['name'] = 'DataDimRef'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DataDimRef
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to DataSource
  currentMap = {}
  exolinks['DataSource'] = currentMap
  loadMaps['NMR.exo-DataSource'] = currentMap
  currentMap['tag'] = 'NMR.exo-DataSource'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00020'
  currentMap['name'] = 'DataSource'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DataSource
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to DataSourceImage
  currentMap = {}
  exolinks['DataSourceImage'] = currentMap
  loadMaps['NMR.exo-DataSourceImage'] = currentMap
  currentMap['tag'] = 'NMR.exo-DataSourceImage'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-03-02-12:01:34_00001'
  currentMap['name'] = 'DataSourceImage'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DataSourceImage
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to DimensionScaling
  currentMap = {}
  exolinks['DimensionScaling'] = currentMap
  loadMaps['NMR.exo-DimensionScaling'] = currentMap
  currentMap['tag'] = 'NMR.exo-DimensionScaling'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00002'
  currentMap['name'] = 'DimensionScaling'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DimensionScaling
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ExpChainState
  currentMap = {}
  exolinks['ExpChainState'] = currentMap
  loadMaps['NMR.exo-ExpChainState'] = currentMap
  currentMap['tag'] = 'NMR.exo-ExpChainState'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00025'
  currentMap['name'] = 'ExpChainState'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpChainState
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ExpDim
  currentMap = {}
  exolinks['ExpDim'] = currentMap
  loadMaps['NMR.exo-ExpDim'] = currentMap
  currentMap['tag'] = 'NMR.exo-ExpDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00026'
  currentMap['name'] = 'ExpDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to ExpDimRef
  currentMap = {}
  exolinks['ExpDimRef'] = currentMap
  loadMaps['NMR.exo-ExpDimRef'] = currentMap
  currentMap['tag'] = 'NMR.exo-ExpDimRef'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00027'
  currentMap['name'] = 'ExpDimRef'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpDimRef
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ExpDimRefMapping
  currentMap = {}
  exolinks['ExpDimRefMapping'] = currentMap
  loadMaps['NMR.exo-ExpDimRefMapping'] = currentMap
  currentMap['tag'] = 'NMR.exo-ExpDimRefMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00001'
  currentMap['name'] = 'ExpDimRefMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpDimRefMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ExpTransfer
  currentMap = {}
  exolinks['ExpTransfer'] = currentMap
  loadMaps['NMR.exo-ExpTransfer'] = currentMap
  currentMap['tag'] = 'NMR.exo-ExpTransfer'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00030'
  currentMap['name'] = 'ExpTransfer'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ExpTransfer
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to Experiment
  currentMap = {}
  exolinks['Experiment'] = currentMap
  loadMaps['NMR.exo-Experiment'] = currentMap
  currentMap['tag'] = 'NMR.exo-Experiment'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00028'
  currentMap['name'] = 'Experiment'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Experiment
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to NmrExpSeries
  currentMap = {}
  exolinks['NmrExpSeries'] = currentMap
  loadMaps['NMR.exo-NmrExpSeries'] = currentMap
  currentMap['tag'] = 'NMR.exo-NmrExpSeries'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00010'
  currentMap['name'] = 'NmrExpSeries'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.NmrExpSeries
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to NmrProject
  currentMap = {}
  exolinks['NmrProject'] = currentMap
  loadMaps['NMR.exo-NmrProject'] = currentMap
  currentMap['tag'] = 'NMR.exo-NmrProject'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:48_00001'
  currentMap['name'] = 'NmrProject'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.NmrProject
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))

  # Out-of-package link to Peak
  currentMap = {}
  exolinks['Peak'] = currentMap
  loadMaps['NMR.exo-Peak'] = currentMap
  currentMap['tag'] = 'NMR.exo-Peak'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00011'
  currentMap['name'] = 'Peak'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Peak
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PeakCluster
  currentMap = {}
  exolinks['PeakCluster'] = currentMap
  loadMaps['NMR.exo-PeakCluster'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakCluster'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:42_00002'
  currentMap['name'] = 'PeakCluster'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakCluster
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PeakContrib
  currentMap = {}
  exolinks['PeakContrib'] = currentMap
  loadMaps['NMR.exo-PeakContrib'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakContrib'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00017'
  currentMap['name'] = 'PeakContrib'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakContrib
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PeakDim
  currentMap = {}
  exolinks['PeakDim'] = currentMap
  loadMaps['NMR.exo-PeakDim'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00013'
  currentMap['name'] = 'PeakDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to PeakDimComponent
  currentMap = {}
  exolinks['PeakDimComponent'] = currentMap
  loadMaps['NMR.exo-PeakDimComponent'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakDimComponent'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-25-11:29:42_00001'
  currentMap['name'] = 'PeakDimComponent'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDimComponent
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PeakIntensity
  currentMap = {}
  exolinks['PeakIntensity'] = currentMap
  loadMaps['NMR.exo-PeakIntensity'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakIntensity'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00021'
  currentMap['name'] = 'PeakIntensity'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakIntensity
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('METH').get('exolinks'))

  # Out-of-package link to PeakList
  currentMap = {}
  exolinks['PeakList'] = currentMap
  loadMaps['NMR.exo-PeakList'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00022'
  currentMap['name'] = 'PeakList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ResidueProb
  currentMap = {}
  exolinks['ResidueProb'] = currentMap
  loadMaps['NMR.exo-ResidueProb'] = currentMap
  currentMap['tag'] = 'NMR.exo-ResidueProb'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00031'
  currentMap['name'] = 'ResidueProb'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ResidueProb
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('MOLS').get('exolinks'))

  # Out-of-package link to ResidueTypeProb
  currentMap = {}
  exolinks['ResidueTypeProb'] = currentMap
  loadMaps['NMR.exo-ResidueTypeProb'] = currentMap
  currentMap['tag'] = 'NMR.exo-ResidueTypeProb'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00032'
  currentMap['name'] = 'ResidueTypeProb'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ResidueTypeProb
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('CHEM').get('exolinks'))

  # Out-of-package link to Resonance
  currentMap = {}
  exolinks['Resonance'] = currentMap
  loadMaps['NMR.exo-Resonance'] = currentMap
  currentMap['tag'] = 'NMR.exo-Resonance'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00033'
  currentMap['name'] = 'Resonance'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Resonance
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ResonanceGroup
  currentMap = {}
  exolinks['ResonanceGroup'] = currentMap
  loadMaps['NMR.exo-ResonanceGroup'] = currentMap
  currentMap['tag'] = 'NMR.exo-ResonanceGroup'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00034'
  currentMap['name'] = 'ResonanceGroup'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceGroup
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ResonanceGroupProb
  currentMap = {}
  exolinks['ResonanceGroupProb'] = currentMap
  loadMaps['NMR.exo-ResonanceGroupProb'] = currentMap
  currentMap['tag'] = 'NMR.exo-ResonanceGroupProb'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00035'
  currentMap['name'] = 'ResonanceGroupProb'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceGroupProb
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00037'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ResonanceProb
  currentMap = {}
  exolinks['ResonanceProb'] = currentMap
  loadMaps['NMR.exo-ResonanceProb'] = currentMap
  currentMap['tag'] = 'NMR.exo-ResonanceProb'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00032'
  currentMap['name'] = 'ResonanceProb'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceProb
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ResonanceSet
  currentMap = {}
  exolinks['ResonanceSet'] = currentMap
  loadMaps['NMR.exo-ResonanceSet'] = currentMap
  currentMap['tag'] = 'NMR.exo-ResonanceSet'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00038'
  currentMap['name'] = 'ResonanceSet'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ResonanceSet
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SampleCondition
  currentMap = {}
  exolinks['SampleCondition'] = currentMap
  loadMaps['NMR.exo-SampleCondition'] = currentMap
  currentMap['tag'] = 'NMR.exo-SampleCondition'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00039'
  currentMap['name'] = 'SampleCondition'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SampleCondition
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00003'))

  # Out-of-package link to SampleConditionSet
  currentMap = {}
  exolinks['SampleConditionSet'] = currentMap
  loadMaps['NMR.exo-SampleConditionSet'] = currentMap
  currentMap['tag'] = 'NMR.exo-SampleConditionSet'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00001'
  currentMap['name'] = 'SampleConditionSet'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SampleConditionSet
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SparseSampling
  currentMap = {}
  exolinks['SparseSampling'] = currentMap
  loadMaps['NMR.exo-SparseSampling'] = currentMap
  currentMap['tag'] = 'NMR.exo-SparseSampling'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-05-11:27:55_00001'
  currentMap['name'] = 'SparseSampling'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SparseSampling
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to StructureAnalysis
  currentMap = {}
  exolinks['StructureAnalysis'] = currentMap
  loadMaps['NMR.exo-StructureAnalysis'] = currentMap
  currentMap['tag'] = 'NMR.exo-StructureAnalysis'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-03-06-18:40:24_00001'
  currentMap['name'] = 'StructureAnalysis'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.StructureAnalysis
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to StructureGeneration
  currentMap = {}
  exolinks['StructureGeneration'] = currentMap
  loadMaps['NMR.exo-StructureGeneration'] = currentMap
  currentMap['tag'] = 'NMR.exo-StructureGeneration'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:49_00011'
  currentMap['name'] = 'StructureGeneration'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.StructureGeneration
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectralDensityDerivation
  currentMap = {}
  exolinks['SpectralDensityDerivation'] = currentMap
  loadMaps['NMR.exo-SpectralDensityDerivation'] = currentMap
  currentMap['tag'] = 'NMR.exo-SpectralDensityDerivation'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00012'
  currentMap['name'] = 'SpectralDensityDerivation'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SpectralDensityDerivation
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to IsotropicS2Derivation
  currentMap = {}
  exolinks['IsotropicS2Derivation'] = currentMap
  loadMaps['NMR.exo-IsotropicS2Derivation'] = currentMap
  currentMap['tag'] = 'NMR.exo-IsotropicS2Derivation'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00009'
  currentMap['name'] = 'IsotropicS2Derivation'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.IsotropicS2Derivation
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to DataDerivation
  currentMap = {}
  exolinks['DataDerivation'] = currentMap
  loadMaps['NMR.exo-DataDerivation'] = currentMap
  currentMap['tag'] = 'NMR.exo-DataDerivation'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00014'
  currentMap['name'] = 'DataDerivation'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DataDerivation
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PKaDerivation
  currentMap = {}
  exolinks['PKaDerivation'] = currentMap
  loadMaps['NMR.exo-PKaDerivation'] = currentMap
  currentMap['tag'] = 'NMR.exo-PKaDerivation'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00027'
  currentMap['name'] = 'PKaDerivation'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PKaDerivation
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SampledDataDim
  currentMap = {}
  exolinks['SampledDataDim'] = currentMap
  loadMaps['NMR.exo-SampledDataDim'] = currentMap
  currentMap['tag'] = 'NMR.exo-SampledDataDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00002'
  currentMap['name'] = 'SampledDataDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SampledDataDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to FreqDataDim
  currentMap = {}
  exolinks['FreqDataDim'] = currentMap
  loadMaps['NMR.exo-FreqDataDim'] = currentMap
  currentMap['tag'] = 'NMR.exo-FreqDataDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00033'
  currentMap['name'] = 'FreqDataDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.FreqDataDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to FidDataDim
  currentMap = {}
  exolinks['FidDataDim'] = currentMap
  loadMaps['NMR.exo-FidDataDim'] = currentMap
  currentMap['tag'] = 'NMR.exo-FidDataDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00032'
  currentMap['name'] = 'FidDataDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.FidDataDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to T1
  currentMap = {}
  exolinks['T1'] = currentMap
  loadMaps['NMR.exo-T1'] = currentMap
  currentMap['tag'] = 'NMR.exo-T1'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00017'
  currentMap['name'] = 'T1'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.T1
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to T1Rho
  currentMap = {}
  exolinks['T1Rho'] = currentMap
  loadMaps['NMR.exo-T1Rho'] = currentMap
  currentMap['tag'] = 'NMR.exo-T1Rho'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00019'
  currentMap['name'] = 'T1Rho'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.T1Rho
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ShiftDifference
  currentMap = {}
  exolinks['ShiftDifference'] = currentMap
  loadMaps['NMR.exo-ShiftDifference'] = currentMap
  currentMap['tag'] = 'NMR.exo-ShiftDifference'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00007'
  currentMap['name'] = 'ShiftDifference'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftDifference
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to Shift
  currentMap = {}
  exolinks['Shift'] = currentMap
  loadMaps['NMR.exo-Shift'] = currentMap
  currentMap['tag'] = 'NMR.exo-Shift'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00004'
  currentMap['name'] = 'Shift'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Shift
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to T2
  currentMap = {}
  exolinks['T2'] = currentMap
  loadMaps['NMR.exo-T2'] = currentMap
  currentMap['tag'] = 'NMR.exo-T2'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00021'
  currentMap['name'] = 'T2'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.T2
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to Noe
  currentMap = {}
  exolinks['Noe'] = currentMap
  loadMaps['NMR.exo-Noe'] = currentMap
  currentMap['tag'] = 'NMR.exo-Noe'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00005'
  currentMap['name'] = 'Noe'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Noe
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to HExchProtection
  currentMap = {}
  exolinks['HExchProtection'] = currentMap
  loadMaps['NMR.exo-HExchProtection'] = currentMap
  currentMap['tag'] = 'NMR.exo-HExchProtection'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00001'
  currentMap['name'] = 'HExchProtection'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchProtection
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to HExchRate
  currentMap = {}
  exolinks['HExchRate'] = currentMap
  loadMaps['NMR.exo-HExchRate'] = currentMap
  currentMap['tag'] = 'NMR.exo-HExchRate'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00003'
  currentMap['name'] = 'HExchRate'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchRate
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to JCoupling
  currentMap = {}
  exolinks['JCoupling'] = currentMap
  loadMaps['NMR.exo-JCoupling'] = currentMap
  currentMap['tag'] = 'NMR.exo-JCoupling'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00011'
  currentMap['name'] = 'JCoupling'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.JCoupling
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to DipolarRelaxation
  currentMap = {}
  exolinks['DipolarRelaxation'] = currentMap
  loadMaps['NMR.exo-DipolarRelaxation'] = currentMap
  currentMap['tag'] = 'NMR.exo-DipolarRelaxation'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00023'
  currentMap['name'] = 'DipolarRelaxation'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DipolarRelaxation
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to Rdc
  currentMap = {}
  exolinks['Rdc'] = currentMap
  loadMaps['NMR.exo-Rdc'] = currentMap
  currentMap['tag'] = 'NMR.exo-Rdc'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00029'
  currentMap['name'] = 'Rdc'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Rdc
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to ShiftAnisotropy
  currentMap = {}
  exolinks['ShiftAnisotropy'] = currentMap
  loadMaps['NMR.exo-ShiftAnisotropy'] = currentMap
  currentMap['tag'] = 'NMR.exo-ShiftAnisotropy'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00005'
  currentMap['name'] = 'ShiftAnisotropy'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftAnisotropy
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to NoeList
  currentMap = {}
  exolinks['NoeList'] = currentMap
  loadMaps['NMR.exo-NoeList'] = currentMap
  currentMap['tag'] = 'NMR.exo-NoeList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00006'
  currentMap['name'] = 'NoeList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.NoeList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to T1List
  currentMap = {}
  exolinks['T1List'] = currentMap
  loadMaps['NMR.exo-T1List'] = currentMap
  currentMap['tag'] = 'NMR.exo-T1List'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00018'
  currentMap['name'] = 'T1List'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.T1List
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ShiftAnisotropyList
  currentMap = {}
  exolinks['ShiftAnisotropyList'] = currentMap
  loadMaps['NMR.exo-ShiftAnisotropyList'] = currentMap
  currentMap['tag'] = 'NMR.exo-ShiftAnisotropyList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00006'
  currentMap['name'] = 'ShiftAnisotropyList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftAnisotropyList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ShiftDifferenceList
  currentMap = {}
  exolinks['ShiftDifferenceList'] = currentMap
  loadMaps['NMR.exo-ShiftDifferenceList'] = currentMap
  currentMap['tag'] = 'NMR.exo-ShiftDifferenceList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00008'
  currentMap['name'] = 'ShiftDifferenceList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftDifferenceList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to T1RhoList
  currentMap = {}
  exolinks['T1RhoList'] = currentMap
  loadMaps['NMR.exo-T1RhoList'] = currentMap
  currentMap['tag'] = 'NMR.exo-T1RhoList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00020'
  currentMap['name'] = 'T1RhoList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.T1RhoList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to T2List
  currentMap = {}
  exolinks['T2List'] = currentMap
  loadMaps['NMR.exo-T2List'] = currentMap
  currentMap['tag'] = 'NMR.exo-T2List'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00022'
  currentMap['name'] = 'T2List'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.T2List
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ShiftList
  currentMap = {}
  exolinks['ShiftList'] = currentMap
  loadMaps['NMR.exo-ShiftList'] = currentMap
  currentMap['tag'] = 'NMR.exo-ShiftList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00009'
  currentMap['name'] = 'ShiftList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ShiftList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to HExchRateList
  currentMap = {}
  exolinks['HExchRateList'] = currentMap
  loadMaps['NMR.exo-HExchRateList'] = currentMap
  currentMap['tag'] = 'NMR.exo-HExchRateList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00004'
  currentMap['name'] = 'HExchRateList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchRateList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to HExchProtectionList
  currentMap = {}
  exolinks['HExchProtectionList'] = currentMap
  loadMaps['NMR.exo-HExchProtectionList'] = currentMap
  currentMap['tag'] = 'NMR.exo-HExchProtectionList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00002'
  currentMap['name'] = 'HExchProtectionList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.HExchProtectionList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to JCouplingList
  currentMap = {}
  exolinks['JCouplingList'] = currentMap
  loadMaps['NMR.exo-JCouplingList'] = currentMap
  currentMap['tag'] = 'NMR.exo-JCouplingList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00012'
  currentMap['name'] = 'JCouplingList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.JCouplingList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to DipolarRelaxList
  currentMap = {}
  exolinks['DipolarRelaxList'] = currentMap
  loadMaps['NMR.exo-DipolarRelaxList'] = currentMap
  currentMap['tag'] = 'NMR.exo-DipolarRelaxList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00024'
  currentMap['name'] = 'DipolarRelaxList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DipolarRelaxList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to RdcList
  currentMap = {}
  exolinks['RdcList'] = currentMap
  loadMaps['NMR.exo-RdcList'] = currentMap
  currentMap['tag'] = 'NMR.exo-RdcList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00030'
  currentMap['name'] = 'RdcList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.RdcList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PeakDimContribN
  currentMap = {}
  exolinks['PeakDimContribN'] = currentMap
  loadMaps['NMR.exo-PeakDimContribN'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakDimContribN'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00024'
  currentMap['name'] = 'PeakDimContribN'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDimContribN
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PeakDimContrib
  currentMap = {}
  exolinks['PeakDimContrib'] = currentMap
  loadMaps['NMR.exo-PeakDimContrib'] = currentMap
  currentMap['tag'] = 'NMR.exo-PeakDimContrib'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00026'
  currentMap['name'] = 'PeakDimContrib'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PeakDimContrib
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectralDensity
  currentMap = {}
  exolinks['SpectralDensity'] = currentMap
  loadMaps['NMR.exo-SpectralDensity'] = currentMap
  currentMap['tag'] = 'NMR.exo-SpectralDensity'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00011'
  currentMap['name'] = 'SpectralDensity'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SpectralDensity
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to IsotropicS2
  currentMap = {}
  exolinks['IsotropicS2'] = currentMap
  loadMaps['NMR.exo-IsotropicS2'] = currentMap
  currentMap['tag'] = 'NMR.exo-IsotropicS2'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00008'
  currentMap['name'] = 'IsotropicS2'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.IsotropicS2
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to Datum
  currentMap = {}
  exolinks['Datum'] = currentMap
  loadMaps['NMR.exo-Datum'] = currentMap
  currentMap['tag'] = 'NMR.exo-Datum'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00013'
  currentMap['name'] = 'Datum'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Datum
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to Pka
  currentMap = {}
  exolinks['Pka'] = currentMap
  loadMaps['NMR.exo-Pka'] = currentMap
  currentMap['tag'] = 'NMR.exo-Pka'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00026'
  currentMap['name'] = 'Pka'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.Pka
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectralDensityList
  currentMap = {}
  exolinks['SpectralDensityList'] = currentMap
  loadMaps['NMR.exo-SpectralDensityList'] = currentMap
  currentMap['tag'] = 'NMR.exo-SpectralDensityList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00013'
  currentMap['name'] = 'SpectralDensityList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.SpectralDensityList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to DataList
  currentMap = {}
  exolinks['DataList'] = currentMap
  loadMaps['NMR.exo-DataList'] = currentMap
  currentMap['tag'] = 'NMR.exo-DataList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00015'
  currentMap['name'] = 'DataList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.DataList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to IsotropicS2List
  currentMap = {}
  exolinks['IsotropicS2List'] = currentMap
  loadMaps['NMR.exo-IsotropicS2List'] = currentMap
  currentMap['tag'] = 'NMR.exo-IsotropicS2List'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00010'
  currentMap['name'] = 'IsotropicS2List'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.IsotropicS2List
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PkaList
  currentMap = {}
  exolinks['PkaList'] = currentMap
  loadMaps['NMR.exo-PkaList'] = currentMap
  currentMap['tag'] = 'NMR.exo-PkaList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00028'
  currentMap['name'] = 'PkaList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.PkaList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to InternalShiftReference
  currentMap = {}
  exolinks['InternalShiftReference'] = currentMap
  loadMaps['NMR.exo-InternalShiftReference'] = currentMap
  currentMap['tag'] = 'NMR.exo-InternalShiftReference'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:47_00007'
  currentMap['name'] = 'InternalShiftReference'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.InternalShiftReference
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ExternalShiftReference
  currentMap = {}
  exolinks['ExternalShiftReference'] = currentMap
  loadMaps['NMR.exo-ExternalShiftReference'] = currentMap
  currentMap['tag'] = 'NMR.exo-ExternalShiftReference'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00031'
  currentMap['name'] = 'ExternalShiftReference'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.Nmr.ExternalShiftReference
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
