"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Thu Oct  2 16:10:28 2014
  from data model element ccp.molecule.Molecule revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Molecule.py: python API for CCPN data model, MetaPackage ccp.molecule.Molecule

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Citation
import ccp.api.general.DbRef
import ccp.api.general.Taxonomy
import ccp.api.molecule.ChemComp
import ccp.api.molecule.ChemCompCoord
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.molecule.Molecule')

###############################################################################
class Alignment(memops.api.Implementation.DataObject):
  r"""Alignment of molecule with database reference
  """
  #   from data model element ccp.molecule.Molecule.Alignment revision ?
  _metaclass = metaPackage.getElement('Alignment')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('alignLength', 'alignmentProgram', 'alignmentScore', 'applicationData', 'className', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'fieldNames', 'homologyRatio', 'inConstructor', 'isDeleted', 'metaclass', 'nIdentical', 'nPositive', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'dbRef', 'molSeqFragment', 'molecule', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    dataDict['molecule'] = parent
    if (not isinstance(parent, Molecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['alignLength'] = None
      dataDict['alignmentProgram'] = None
      dataDict['alignmentScore'] = None
      dataDict['applicationData'] = list()
      dataDict['dbRefAlignBegin'] = None
      dataDict['dbRefAlignEnd'] = None
      dataDict['details'] = None
      dataDict['homologyRatio'] = None
      dataDict['nIdentical'] = None
      dataDict['nPositive'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['dbRef'] = None
      dataDict['molSeqFragment'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.Alignment.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.Molecule.Alignment')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('alignments')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.Alignment:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    dbRef = dataDict.get('dbRef')
    if (dbRef is not None):
      topObject = dbRef.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.Alignment:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    dbRef = dataDict.get('dbRef')
    if ((dbRef is not None and not (dbRef in objsToBeDeleted))):
      alignments = dbRef.__dict__.get('alignments')
      alignments.remove(self)

    molSeqFragment = dataDict.get('molSeqFragment')
    if ((molSeqFragment is not None and not (molSeqFragment in objsToBeDeleted))):
      alignments = molSeqFragment.__dict__.get('alignments')
      alignments.remove(self)

    molecule = dataDict.get('molecule')
    if (not (molecule in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molecule.__dict__.get('alignments')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molecule')
        dd = value.__dict__.get('alignments')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('alignLength')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: alignLength:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('alignmentProgram')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: alignmentProgram:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: alignmentProgram:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: alignmentProgram:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('alignmentScore')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: alignmentScore:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: alignmentScore:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dbRefAlignBegin')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dbRefAlignBegin:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dbRefAlignEnd')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dbRefAlignEnd:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('homologyRatio')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: homologyRatio:
           memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (0.0 <= value)):
          raise ApiError("""%s.checkValid: homologyRatio:
           FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: homologyRatio:
           FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value <= 1.0)):
          raise ApiError("""%s.checkValid: homologyRatio:
           FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('nIdentical')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: nIdentical:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('nPositive')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: nPositive:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('dbRef')
      from ccp.api.general.DbRef import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: dbRef:
         value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('alignments')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: dbRef:
         non-reciprocal link dbRef from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('molSeqFragment')
      if (value is not None):
        if (not isinstance(value, MolSeqFragment)):
          raise ApiError("""%s.checkValid: molSeqFragment:
           value is not of class ccp.molecule.Molecule.MolSeqFragment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('alignments')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSeqFragment:
           non-reciprocal link molSeqFragment from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (not isinstance(value, Molecule)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('alignLength')
    value = dataDict.get('alignmentProgram')
    value = dataDict.get('alignmentScore')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('dbRefAlignBegin')
    value = dataDict.get('dbRefAlignEnd')
    value = dataDict.get('details')
    value = dataDict.get('homologyRatio')
    value = dataDict.get('nIdentical')
    value = dataDict.get('nPositive')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('dbRef')
    if (value is None):
      raise ApiError("""%s.checkValid: dbRef:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSeqFragment')
    value = dataDict.get('molecule')
    if (value is None):
      raise ApiError("""%s.checkValid: molecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAlignLength(self):
    """
    Get for ccp.molecule.Molecule.Alignment.alignLength
    """
    dataDict = self.__dict__
    result = dataDict.get('alignLength')
    return result
  
  def getAlignmentProgram(self):
    """
    Get for ccp.molecule.Molecule.Alignment.alignmentProgram
    """
    dataDict = self.__dict__
    result = dataDict.get('alignmentProgram')
    return result
  
  def getAlignmentScore(self):
    """
    Get for ccp.molecule.Molecule.Alignment.alignmentScore
    """
    dataDict = self.__dict__
    result = dataDict.get('alignmentScore')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.Alignment
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.Alignment'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.Molecule')
        obj1 = obj0.__dict__.get('molecules').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.Alignment'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('alignments').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDbRef(self):
    """
    Get for ccp.molecule.Molecule.Alignment.dbRef
    """
    dataDict = self.__dict__
    result = dataDict.get('dbRef')
    return result
  
  def getDbRefAlignBegin(self):
    """
    Get for ccp.molecule.Molecule.Alignment.dbRefAlignBegin
    """
    dataDict = self.__dict__
    result = dataDict.get('dbRefAlignBegin')
    return result
  
  def getDbRefAlignEnd(self):
    """
    Get for ccp.molecule.Molecule.Alignment.dbRefAlignEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('dbRefAlignEnd')
    return result
  
  def getDetails(self):
    """
    Get for ccp.molecule.Molecule.Alignment.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result
  
  def getHomologyRatio(self):
    """
    Get for ccp.molecule.Molecule.Alignment.homologyRatio
    """
    dataDict = self.__dict__
    result = dataDict.get('homologyRatio')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSeqFragment(self):
    """
    Get for ccp.molecule.Molecule.Alignment.molSeqFragment
    """
    dataDict = self.__dict__
    result = dataDict.get('molSeqFragment')
    return result
  
  def getMolecule(self):
    """
    Get for ccp.molecule.Molecule.Alignment.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result
  
  def getNIdentical(self):
    """
    Get for ccp.molecule.Molecule.Alignment.nIdentical
    """
    dataDict = self.__dict__
    result = dataDict.get('nIdentical')
    return result
  
  def getNPositive(self):
    """
    Get for ccp.molecule.Molecule.Alignment.nPositive
    """
    dataDict = self.__dict__
    result = dataDict.get('nPositive')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.Alignment.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.Molecule.Alignment.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.Alignment
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAlignLength(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.alignLength
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setAlignLength:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('alignLength')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlignLength:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlignLength:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['alignLength'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlignLength')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAlignmentProgram(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.alignmentProgram
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAlignmentProgram:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setAlignmentProgram:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAlignmentProgram:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('alignmentProgram')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlignmentProgram:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlignmentProgram:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['alignmentProgram'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlignmentProgram')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAlignmentScore(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.alignmentScore
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setAlignmentScore:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setAlignmentScore:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('alignmentScore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlignmentScore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlignmentScore:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['alignmentScore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlignmentScore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDbRef(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.dbRef
    """
    dataDict = self.__dict__
    from ccp.api.general.DbRef import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setDbRef:
       value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dbRef')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbRef:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDbRef:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDbRef:
         cannot set dbRef, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDbRef:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setDbRef:
         Link dbRef between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('alignments')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setDbRef:
         Read link 'dbRef' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('alignments')
      newSelves.add(self)

    dataDict['dbRef'] = value

    # doNotifies
  
  def setDbRefAlignBegin(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.dbRefAlignBegin
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDbRefAlignBegin:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dbRefAlignBegin')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDbRefAlignBegin:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbRefAlignBegin:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dbRefAlignBegin'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDbRefAlignBegin')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDbRefAlignEnd(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.dbRefAlignEnd
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDbRefAlignEnd:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dbRefAlignEnd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDbRefAlignEnd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbRefAlignEnd:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dbRefAlignEnd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDbRefAlignEnd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setHomologyRatio(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.homologyRatio
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setHomologyRatio:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.setHomologyRatio:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setHomologyRatio:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.setHomologyRatio:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('homologyRatio')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHomologyRatio:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHomologyRatio:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['homologyRatio'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHomologyRatio')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSeqFragment(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.molSeqFragment
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, MolSeqFragment)):
        raise ApiError("""%s.setMolSeqFragment:
         value is not of class ccp.molecule.Molecule.MolSeqFragment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSeqFragment')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSeqFragment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSeqFragment:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSeqFragment:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSeqFragment:
           Link molSeqFragment between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('alignments')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolSeqFragment:
         Read link 'molSeqFragment' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('alignments')
      newSelves.add(self)

    dataDict['molSeqFragment'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSeqFragment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNIdentical(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.nIdentical
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setNIdentical:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nIdentical')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNIdentical:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNIdentical:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['nIdentical'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNIdentical')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNPositive(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.nPositive
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setNPositive:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nPositive')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNPositive:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNPositive:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['nPositive'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNPositive')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.molecule.Molecule.Alignment.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('molecule')
    oldSerial = parent.__dict__.get('_serialDict').get('alignments')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['alignments'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['alignments'] = value

    dataDict['serial'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  alignLength = property(getAlignLength, setAlignLength, None,
  r"""Length of alignment
  """)
  
  alignmentProgram = property(getAlignmentProgram, setAlignmentProgram, None,
  r"""Program used for alignment/threading.
  """)
  
  alignmentScore = property(getAlignmentScore, setAlignmentScore, None,
  r"""Alignment score for alignment or threading program.
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  dbRefAlignBegin = property(getDbRefAlignBegin, setDbRefAlignBegin, None,
  r"""Optional. Residue number in the database reference sequence where the 
  alignment begins.
  """)
  
  dbRefAlignEnd = property(getDbRefAlignEnd, setDbRefAlignEnd, None,
  r"""Optional. Residue number in the database reference sequence where the 
  alignment ends.
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  homologyRatio = property(getHomologyRatio, setHomologyRatio, None,
  r"""Fractioanl homology
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  nIdentical = property(getNIdentical, setNIdentical, None,
  r"""Number of identical residues
  """)
  
  nPositive = property(getNPositive, setNPositive, None,
  r"""Number of positive-scoring residues
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  dbRef = property(getDbRef, setDbRef, None,
  r"""database reference used in alignment
  """)
  
  molSeqFragment = property(getMolSeqFragment, setMolSeqFragment, None,
  r"""MolSeqFragment that alignment refers to.  If not set, the alignment 
  refers to the entire molecule
  """)
  
  molecule = property(getMolecule,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molecule
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolResLink(memops.api.Implementation.DataObject):
  r"""Link (bond) between two molResidues, through their MolResLinkEnds. 
MolResLinks that are valid for a Molecule are implicitly valid also for 
Chains linked to that Molecule. Unlike MolResLinkEnds, MolResLinks can 
be created (or modified) for existing molecules, even if the Molecule is 
linked to one or more Chains. This allows linkages to be redefined, or 
to be left as initially unknown (as in the case of a protein with 
unknown disulfide binding topology). 
  """
  #   from data model element ccp.molecule.Molecule.MolResLink revision ?
  _metaclass = metaPackage.getElement('MolResLink')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('applicationData', 'className', 'dihedralAngle', 'fieldNames', 'inConstructor', 'isDeleted', 'isStdLinear', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'molResLinkEnds', 'molecule', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    dataDict['molecule'] = parent
    if (not isinstance(parent, Molecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['dihedralAngle'] = None
      dataDict['access'] = None
      dataDict['molResLinkEnds'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.MolResLink.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molResLinks')
        objKey = dataDict.get('molResLinkEnds')
        if (objKey is not None):
          objKey = frozenset(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molResLinkEnds'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.MolResLink:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.MolResLink:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for molResLinkEnd in dataDict.get('molResLinkEnds'):
      if (not (molResLinkEnd in objsToBeDeleted)):
        molResLinkEnd.__dict__['molResLink'] = None

    molecule = dataDict.get('molecule')
    if (not (molecule in objsToBeDeleted)):
      objKey = dataDict.get('molResLinkEnds')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molecule.__dict__.get('molResLinks')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('molResLinkEnds')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molecule')
        dd = value.__dict__.get('molResLinks')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dihedralAngle')
      if (value is not None):
        if (not (value in [0, 180, 90, -90, 120, -120])):
          raise ApiError("""%s.checkValid: dihedralAngle:
           ccp.molecule.Molecule.LinkDihedralAngle input is not in enumeration [0, 180, 90, -90, 120, -120]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getIsStdLinear()
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isStdLinear:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molResLinkEnds')
      for value in values:
        if (not isinstance(value, MolResLinkEnd)):
          raise ApiError("""%s.checkValid: molResLinkEnds:
           value is not of class ccp.molecule.Molecule.MolResLinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molResLink')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molResLinkEnds:
           non-reciprocal link molResLinkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (not isinstance(value, Molecule)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('dihedralAngle')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('molResLinkEnds')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: molResLinkEnds:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molecule')
    if (value is None):
      raise ApiError("""%s.checkValid: molecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllMolResLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.MolResLink.molResLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molResLinkEnds')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molResLinkEnds')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molResLink', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstMolResLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.MolResLink.molResLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molResLinkEnds')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('molResLinkEnds')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molResLink', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.MolResLink
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolResLink'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.Molecule')
        obj1 = obj0.__dict__.get('molecules').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolResLink'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = frozenset(tempList)
      obj2 = obj1.__dict__.get('molResLinks').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDihedralAngle(self):
    """
    Get for ccp.molecule.Molecule.MolResLink.dihedralAngle
    """
    dataDict = self.__dict__
    result = dataDict.get('dihedralAngle')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    for xx in dataDict.get('molResLinkEnds'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsStdLinear(self):
    """
    getter for derived attribute isStdLinear
    """
    dataDict = self.__dict__
    (a, b)  = self.molResLinkEnds
    codeA = a.linkCode
    codeB = b.linkCode
    diff = a.molResidue.serial - b.molResidue.serial
    if ( (diff == -1 and codeA == 'next' and codeB == 'prev') or 
         (diff == 1 and codeB == 'next' and codeA == 'prev' ) ):
      result = True
    else:
      result = False
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    result = dataDict.get('molResLinkEnds')
    if (result is not None):
      result = frozenset(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolResLinkEnds(self):
    """
    Get for ccp.molecule.Molecule.MolResLink.molResLinkEnds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molResLinkEnds')
    result = frozenset(tempVar)
    return result
  
  def getMolecule(self):
    """
    Get for ccp.molecule.Molecule.MolResLink.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.MolResLink.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.MolResLink
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDihedralAngle(self, value):
    """
    Set for ccp.molecule.Molecule.MolResLink.dihedralAngle
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [0, 180, 90, -90, 120, -120])):
        raise ApiError("""%s.setDihedralAngle:
         ccp.molecule.Molecule.LinkDihedralAngle input is not in enumeration [0, 180, 90, -90, 120, -120]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dihedralAngle')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDihedralAngle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDihedralAngle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dihedralAngle'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDihedralAngle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolResLinkEnds(self, values):
    """
    Set for ccp.molecule.Molecule.MolResLink.molResLinkEnds
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolResLinkEnds:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, MolResLinkEnd)):
        raise ApiError("""%s.setMolResLinkEnds:
         value is not of class ccp.molecule.Molecule.MolResLinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('molResLinkEnds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolResLinkEnds:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolResLinkEnds:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolResLinkEnds:
         cannot set molResLinkEnds, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 2)):
        raise ApiError("""%s.setMolResLinkEnds:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      oldSelves = {}
      for cv in values:
        if (not (cv in currentValues)):
          oldSelf = cv.__dict__.get('molResLink')
          if (oldSelf is not None):
            knt = oldSelves.get(oldSelf)
            if (knt is None):
              knt = 1
            else:
              knt = knt + 1

            oldSelves[oldSelf] = knt

      for osv in oldSelves.keys():
        siblingValues = osv.__dict__.get('molResLinkEnds')
        knt = oldSelves.get(osv)
        if (len(siblingValues) < (2 + knt)):
          raise ApiError("""%s.setMolResLinkEnds:
           locard: siblingValues: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolResLinkEnds:
           Link molResLinkEnds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molResLink'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molResLink')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('molResLinkEnds')
          vv.remove(cv)

      cv.__dict__['molResLink'] = self

    dataDict['molResLinkEnds'] = values

    # doNotifies
  
  def sortedMolResLinkEnds(self):
    """
    Sorted for ccp.molecule.Molecule.MolResLink.molResLinkEnds
    """
    dataDict = self.__dict__
    ll = dataDict.get('molResLinkEnds')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  dihedralAngle = property(getDihedralAngle, setDihedralAngle, None,
  r"""Approximate value in degrees of dihedral angle formed across bond (as 
  defined in the ChemComp Link definitions). The value is not precise but 
  serves to indicate the conformation of rotationally hindered bonds.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isStdLinear = property(getIsStdLinear, None, None,
  r"""Is the link a standard linear polymer link, i.e. a link between 
  MolResidue with consecutive serials, with linkend linkcode 'next' and 
  'prev'
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  molResLinkEnds = property(getMolResLinkEnds, setMolResLinkEnds, None,
  r"""LinkEnds that make up the MolSystemLink
  """)
  
  molecule = property(getMolecule,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molecule
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolResLinkEnd(memops.api.Implementation.DataObject):
  r"""The MolResidue end (Link End) of a bond to another MolResidue
The 
MolResLinkEnds corresponding to a MolResidue are created automatically 
when the MolResidue is created.
Note that MolResLinkEnds can neither be 
created nor deleted while their ancestor Molecule is linked to one or 
more chains.
  """
  #   from data model element ccp.molecule.Molecule.MolResLinkEnd revision ?
  _metaclass = metaPackage.getElement('MolResLinkEnd')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'linkCode', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'linkEnd', 'molResLink', 'molResidue', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    dataDict['molResidue'] = parent
    if (not isinstance(parent, MolResidue)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['linkCode'] = None
      dataDict['access'] = None
      dataDict['molResLink'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.MolResLinkEnd.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molResLinkEnds')
        objKey = dataDict.get('linkCode')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['linkCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        
        
        if self.getByNavigation('molResidue','molecule','chains'):
          raise ApiError("MolResLinkEnd of %s cannot be created while molecule has chains" % self.molResidue.molecule.name)

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.MolResLinkEnd:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    
    
    if self.getByNavigation('molResidue','molecule','chains'):
      raise ApiError("MolResLinkEnd of %s cannot be deleted while molecule has chains" % self.molResidue.molecule.name)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molResLink = dataDict.get('molResLink')
    if (molResLink is not None):
      if (not (molResLink in objsToBeDeleted)):
        objsToBeDeleted.add(molResLink)
        objsToBeChecked.append(molResLink)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.MolResLinkEnd:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molResidue = dataDict.get('molResidue')
    if (not (molResidue in objsToBeDeleted)):
      objKey = dataDict.get('linkCode')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molResidue.__dict__.get('molResLinkEnds')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('linkCode')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molResidue')
        dd = value.__dict__.get('molResLinkEnds')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molResidue' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('linkCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linkCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getLinkEnd()
      if (value is None):
        raise ApiError("""%s.checkValid: linkEnd:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import LinkEnd as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: linkEnd:
         value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: linkEnd:
         Link linkEnd between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('molResLink')
      if (value is not None):
        if (not isinstance(value, MolResLink)):
          raise ApiError("""%s.checkValid: molResLink:
           value is not of class ccp.molecule.Molecule.MolResLink""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molResLinkEnds')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molResLink:
           non-reciprocal link molResLink from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molResLink:
           Link molResLink between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molResidue')
      if (not isinstance(value, MolResidue)):
        raise ApiError("""%s.checkValid: molResidue:
         value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('linkCode')
    if (value is None):
      raise ApiError("""%s.checkValid: linkCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('molResLink')
    value = dataDict.get('molResidue')
    if (value is None):
      raise ApiError("""%s.checkValid: molResidue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.MolResLinkEnd
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolResLinkEnd'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.Molecule')
        obj1 = obj0.__dict__.get('molecules').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolResLinkEnd'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('molResidues').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('molResLinkEnds').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('molResidue')
    obj1 = obj2.__dict__.get('molecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('linkCode'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLinkCode(self):
    """
    Get for ccp.molecule.Molecule.MolResLinkEnd.linkCode
    """
    dataDict = self.__dict__
    result = dataDict.get('linkCode')
    return result
  
  def getLinkEnd(self):
    """
    getter for derived link linkEnd
    """
    dataDict = self.__dict__
    result = self.molResidue.chemCompVar.findFirstLinkEnd(linkCode=self.linkCode)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('linkCode')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolResLink(self):
    """
    Get for ccp.molecule.Molecule.MolResLinkEnd.molResLink
    """
    dataDict = self.__dict__
    result = dataDict.get('molResLink')
    return result
  
  def getMolResidue(self):
    """
    Get for ccp.molecule.Molecule.MolResLinkEnd.molResidue
    """
    dataDict = self.__dict__
    result = dataDict.get('molResidue')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.MolResLinkEnd.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molResidue')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.MolResLinkEnd
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setLinkCode(self, value):
    """
    Set for ccp.molecule.Molecule.MolResLinkEnd.linkCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinkCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linkCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinkCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLinkCode:
         cannot set linkCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLinkCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['linkCode'] = value

    # doNotifies
  
  def setMolResLink(self, value):
    """
    Set for ccp.molecule.Molecule.MolResLinkEnd.molResLink
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, MolResLink)):
        raise ApiError("""%s.setMolResLink:
         value is not of class ccp.molecule.Molecule.MolResLink""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molResLink')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolResLink:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolResLink:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolResLink:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (currentValue is not None):
        oldSelves = currentValue.__dict__.get('molResLinkEnds')
        if (len(oldSelves) < (2 + 1)):
          raise ApiError("""%s.setMolResLink:
           locard: oldSelves: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        newSelves = value.__dict__.get('molResLinkEnds')
        if (len(newSelves) >= 2):
          raise ApiError("""%s.setMolResLink:
           hicard: newSelves: cannot add value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolResLink:
           Link molResLink between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molResLinkEnds')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolResLink:
         Read link 'molResLink' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molResLinkEnds')
      newSelves.add(self)

    dataDict['molResLink'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolResLink')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  linkCode = property(getLinkCode, setLinkCode, None,
  r"""Link Code identifying Link End for MolResidue. Part of Key for 
  ChemComp.LinkEnd
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  linkEnd = property(getLinkEnd, None, None,
  r"""ChemComp.LinkEnd corresponding to MolResLinkEnd
  """)
  
  molResLink = property(getMolResLink, setMolResLink, None,
  r"""InterChemComp link made up from LinkEnds
  """)
  
  molResidue = property(getMolResidue,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molResidue
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolResidue(memops.api.Implementation.DataObject):
  r"""Monomer/Residue belonging to a Molecule, e.g. in the sequence for 
Insulin A-chain as such, as opposed to a specific Insulin A-chain 
molecule with coordinates.

Note that MolResidues can neither be created 
nor deleted while their parent Molecule is linked to one or more chains. 
When creating a Molecule all relevant MolResLinkEnds are created 
automatically.
Note also that MolResidues can not be deleted, except as 
a consequence of deleting their molecule.

It is guaranteed that the 
serials of molResidues form a continuous range, and that all linear 
polymer type links are between MolResidues with consecutive serials. The 
Molesidue.serials must start at one. This constraint is not checked (for 
technical reasons), but it can only be broken if someone has modified 
the data bypassing the API.
  """
  #   from data model element ccp.molecule.Molecule.MolResidue revision ?
  _metaclass = metaPackage.getElement('MolResidue')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('applicationData', 'ccpCode', 'className', 'descriptor', 'fieldNames', 'inConstructor', 'isDeleted', 'linking', 'metaclass', 'molType', 'packageName', 'packageShortName', 'qualifiedName', 'seqCode', 'seqInsertCode', 'serial', 'access', 'activeAccess', 'chemComp', 'chemCompVar', 'isotopeLabels', 'molFeatures', 'molResLinkEnds', 'molSeqFragment', 'molecule', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    dataDict['molecule'] = parent
    if (not isinstance(parent, Molecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['descriptor'] = None
      dataDict['linking'] = None
      dataDict['seqCode'] = None
      dataDict['seqInsertCode'] = ' '
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['chemComp'] = None
      dataDict['isotopeLabels'] = set()
      dataDict['molFeatures'] = set()
      dataDict['molResLinkEnds'] = {}
      dataDict['molSeqFragment'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.MolResidue.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.Molecule.MolResidue')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('molResidues')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        
        
        if self.molecule.isFinalised:
          raise ApiError("MolResidues may not be added once Molecule has been finalised")
        
        for ca in self.chemCompVar.chemAtoms:
          if isinstance(ca,ccp.api.molecule.ChemComp.LinkAtom):
            linkEnd = ca.boundLinkEnd
            if linkEnd is not None:
              MolResLinkEnd(self, linkCode=linkEnd.linkCode)

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.MolResidue:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    
    
    # The following code interacts directly with the deletion implementation (use of 'objsToBeDeleted'). 
    # This is bad, but the only way to accomplish the desired result.
    if self.molecule not in objsToBeDeleted and not self.root.override:
      raise ApiError("MolResidue %s: MolResidues can only be deleted when the Molecule is deleted." % self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    isotopeLabels = dataDict.get('isotopeLabels')
    pass
    for isotopeLabel in isotopeLabels:
      topObject = isotopeLabel.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Annotation')
    tobjList = root.__dict__.get('annotationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molFeatures = dataDict.get('molFeatures')
    for molFeature in molFeatures:
      if (not (molFeature in objsToBeDeleted)):
        objsToBeDeleted.add(molFeature)
        objsToBeChecked.append(molFeature)

    for molFeature in molFeatures:
      topObject = molFeature.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molResLinkEnds = dataDict.get('molResLinkEnds').values()
    for molResLinkEnd in molResLinkEnds:
      if (not (molResLinkEnd in objsToBeDeleted)):
        objsToBeDeleted.add(molResLinkEnd)
        objsToBeChecked.append(molResLinkEnd)

    molSeqFragment = dataDict.get('molSeqFragment')
    if (molSeqFragment is not None):
      if (not (molSeqFragment in objsToBeDeleted)):
        objsToBeDeleted.add(molSeqFragment)
        objsToBeChecked.append(molSeqFragment)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.MolResidue:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for isotopeLabel in dataDict.get('isotopeLabels'):
      if (not (isotopeLabel in objsToBeDeleted)):
        molResidues = isotopeLabel.__dict__.get('molResidues')
        molResidues.remove(self)

    molecule = dataDict.get('molecule')
    if (not (molecule in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molecule.__dict__.get('molResidues')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addIsotopeLabel(self, value):
    """
    Add for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import IsotopeLabel as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addIsotopeLabel:
       value is not of class ccp.lims.RefSampleComponent.IsotopeLabel""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('isotopeLabels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addIsotopeLabel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addIsotopeLabel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addIsotopeLabel:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addIsotopeLabel:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addIsotopeLabel:
           Link isotopeLabels between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value is None or self.specificLabelGroup.molComponent.molecule is value.molecule)):
            raise ApiError("""%s.addIsotopeLabel:
             molResidues constraint self_specificLabelGroup_molComponent_molecule_is_value_molecule violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelves = value.__dict__.get('molResidues')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addIsotopeLabel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('molResLinkEnds').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molecule')
        dd = value.__dict__.get('molResidues')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getCcpCode()
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('descriptor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: descriptor:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('linking')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linking:
         ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getMolType()
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqCode')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: seqCode:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqInsertCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: seqInsertCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: seqInsertCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: seqInsertCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: seqInsertCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      from ccp.api.molecule.ChemComp import ChemComp as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemComp:
         Link chemComp between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = self.getChemCompVar()
      if (value is None):
        raise ApiError("""%s.checkValid: chemCompVar:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import ChemCompVar as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemCompVar:
         value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemCompVar:
         Link chemCompVar between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('isotopeLabels')
      for value in values:
        from ccp.api.lims.RefSampleComponent import IsotopeLabel as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: isotopeLabels:
           value is not of class ccp.lims.RefSampleComponent.IsotopeLabel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molResidues')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: isotopeLabels:
           non-reciprocal link isotopeLabels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: isotopeLabels:
           Link isotopeLabels between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Annotation')
      tobjList = root.__dict__.get('annotationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molFeatures')
      for value in values:
        from ccp.api.general.Annotation import MolFeature as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molFeatures:
           value is not of class ccp.general.Annotation.MolFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molResidue')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molFeatures:
           non-reciprocal link molFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molFeatures:
           Link molFeatures between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molResLinkEnds').values()
      for value in values:
        if (not isinstance(value, MolResLinkEnd)):
          raise ApiError("""%s.checkValid: molResLinkEnds:
           value is not of class ccp.molecule.Molecule.MolResLinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molResidue')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molResLinkEnds:
           non-reciprocal link molResLinkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molSeqFragment')
      if (value is not None):
        if (not isinstance(value, MolSeqFragment)):
          raise ApiError("""%s.checkValid: molSeqFragment:
           value is not of class ccp.molecule.Molecule.MolSeqFragment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('limitResidues')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSeqFragment:
           non-reciprocal link molSeqFragment from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSeqFragment:
           Link molSeqFragment between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molecule')
      if (not isinstance(value, Molecule)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('descriptor')
    if (value is None):
      raise ApiError("""%s.checkValid: descriptor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('linking')
    if (value is None):
      raise ApiError("""%s.checkValid: linking:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqCode')
    if (value is None):
      raise ApiError("""%s.checkValid: seqCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqInsertCode')
    if (value is None):
      raise ApiError("""%s.checkValid: seqInsertCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('isotopeLabels')
    for value in values:
      (self, value) = (value, self)
      if (not (value is None or self.specificLabelGroup.molComponent.molecule is value.molecule)):
        raise ApiError("""%s.checkValid: isotopeLabels:
         molResidues constraint self_specificLabelGroup_molComponent_molecule_is_value_molecule violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

    values = dataDict.get('molFeatures')
    values = dataDict.get('molResLinkEnds').values()
    value = dataDict.get('molSeqFragment')
    value = dataDict.get('molecule')
    if (value is None):
      raise ApiError("""%s.checkValid: molecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllIsotopeLabels(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('isotopeLabels')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('isotopeLabels')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'incorporation', 'massNumber', 'serial', 'access', 'specificLabelGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolFeatures(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.MolResidue.molFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Annotation')
      tobjList = root.__dict__.get('annotationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molFeatures')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Annotation')
      tobjList = root.__dict__.get('annotationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molFeatures')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'featureType', 'serial', 'access', 'annotationStore', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolResLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.MolResidue.molResLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molResLinkEnds').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molResLinkEnds').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molResLink', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstIsotopeLabel(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('isotopeLabels')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('isotopeLabels')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'incorporation', 'massNumber', 'serial', 'access', 'specificLabelGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolFeature(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.MolResidue.molFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Annotation')
      tobjList = root.__dict__.get('annotationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molFeatures')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Annotation')
      tobjList = root.__dict__.get('annotationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molFeatures')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'featureType', 'serial', 'access', 'annotationStore', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolResLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.MolResidue.molResLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molResLinkEnds').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('linkCode')
      if (objKey is not None):
        result = dataDict.get('molResLinkEnds').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('molResLinkEnds').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'molResLink', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.MolResidue
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolResidue'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.Molecule')
        obj1 = obj0.__dict__.get('molecules').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolResidue'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('molResidues').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCcpCode(self):
    """
    getter for derived attribute ccpCode
    """
    dataDict = self.__dict__
    result = self.getByNavigation('chemComp', 'ccpCode')
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result
  
  def getChemCompVar(self):
    """
    getter for derived link chemCompVar
    """
    dataDict = self.__dict__
    result = self.getByNavigation('chemComp', ('chemCompVars', (self.linking, self.descriptor)))
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDescriptor(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.descriptor
    """
    dataDict = self.__dict__
    result = dataDict.get('descriptor')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsotopeLabels(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('isotopeLabels')
    result = frozenset(tempVar)
    return result
  
  def getLinking(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.linking
    """
    dataDict = self.__dict__
    result = dataDict.get('linking')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolFeatures(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.molFeatures
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Annotation')
    tobjList = root.__dict__.get('annotationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molFeatures')
    result = frozenset(tempVar)
    return result
  
  def getMolResLinkEnds(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.molResLinkEnds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molResLinkEnds').values()
    result = frozenset(tempVar)
    return result
  
  def getMolSeqFragment(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.molSeqFragment
    """
    dataDict = self.__dict__
    result = dataDict.get('molSeqFragment')
    return result
  
  def getMolType(self):
    """
    getter for derived attribute molType
    """
    dataDict = self.__dict__
    result = self.getByNavigation('chemComp','molType')
    return result
  
  def getMolecule(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSeqCode(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.seqCode
    """
    dataDict = self.__dict__
    result = dataDict.get('seqCode')
    return result
  
  def getSeqInsertCode(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.seqInsertCode
    """
    dataDict = self.__dict__
    result = dataDict.get('seqInsertCode')
    return result
  
  def getSerial(self):
    """
    Get for ccp.molecule.Molecule.MolResidue.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newMolResLinkEnd(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.MolResLinkEnd
    """
    return MolResLinkEnd(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeIsotopeLabel(self, value):
    """
    Remove for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import IsotopeLabel as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeIsotopeLabel:
       value is not of class ccp.lims.RefSampleComponent.IsotopeLabel""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('isotopeLabels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeIsotopeLabel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeIsotopeLabel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeIsotopeLabel:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeIsotopeLabel:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('molResidues')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeIsotopeLabel')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.MolResidue
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemComp(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.chemComp
    """
    dataDict = self.__dict__
    from ccp.api.molecule.ChemComp import ChemComp as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setChemComp:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemComp')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemComp:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemComp:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChemComp:
         cannot set chemComp, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setChemComp:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setChemComp:
         Link chemComp between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['chemComp'] = value

    # doNotifies
  
  def setChemCompVar(self, value):
    """
    setter for settable, derived link chemCompVar. NB needed also for
    backward compatibility with release 1.0b1
    """
    dataDict = self.__dict__
    from ccp.api.molecule.ChemComp import ChemCompVar as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setChemCompVar:
       value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = self.getChemCompVar()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemCompVar:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemCompVar:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemCompVar:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    cc = self.chemComp
    if cc is not None and cc is not value.chemComp:
      raise ApiError(" molResidue.chemCompVar incompatible with molResidue.chemComp")
    
    self.linking = value.linking
    self.descriptor = value.descriptor
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setDescriptor(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.descriptor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setDescriptor:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('descriptor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDescriptor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDescriptor:
         cannot set descriptor, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDescriptor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['descriptor'] = value

    # doNotifies
  
  def setIsotopeLabels(self, values):
    """
    Set for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setIsotopeLabels:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.RefSampleComponent import IsotopeLabel as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setIsotopeLabels:
         value is not of class ccp.lims.RefSampleComponent.IsotopeLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('isotopeLabels')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsotopeLabels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsotopeLabels:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setIsotopeLabels:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setIsotopeLabels:
           Link isotopeLabels between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (value is None or self.specificLabelGroup.molComponent.molecule is value.molecule)):
            raise ApiError("""%s.setIsotopeLabels:
             molResidues constraint self_specificLabelGroup_molComponent_molecule_is_value_molecule violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('molResidues')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('molResidues')
        oldSelves.add(self)

    dataDict['isotopeLabels'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsotopeLabels')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLinking(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.linking
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinking:
       ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linking')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinking:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLinking:
         cannot set linking, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLinking:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['linking'] = value

    # doNotifies
  
  def setMolFeatures(self, values):
    """
    Set for ccp.molecule.Molecule.MolResidue.molFeatures
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolFeatures:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Annotation import MolFeature as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolFeatures:
         value is not of class ccp.general.Annotation.MolFeature""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Annotation')
    tobjList = root.__dict__.get('annotationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molFeatures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molResidue')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setMolFeatures:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolFeatures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolFeatures:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolFeatures:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setMolFeatures:
           locard molResidue: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolFeatures:
           Link molFeatures between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molResidue'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molResidue')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('molFeatures')
          vv.remove(cv)

      cv.__dict__['molResidue'] = self

    dataDict['molFeatures'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolFeatures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSeqFragment(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.molSeqFragment
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, MolSeqFragment)):
        raise ApiError("""%s.setMolSeqFragment:
         value is not of class ccp.molecule.Molecule.MolSeqFragment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSeqFragment')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSeqFragment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSeqFragment:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSeqFragment:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (currentValue is not None):
        oldSelves = currentValue.__dict__.get('limitResidues')
        if (len(oldSelves) < (2 + 1)):
          raise ApiError("""%s.setMolSeqFragment:
           locard: oldSelves: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        newSelves = value.__dict__.get('limitResidues')
        if (len(newSelves) >= 2):
          raise ApiError("""%s.setMolSeqFragment:
           hicard: newSelves: cannot add value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSeqFragment:
           Link molSeqFragment between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('limitResidues')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolSeqFragment:
         Read link 'molSeqFragment' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('limitResidues')
      newSelves.add(self)

    dataDict['molSeqFragment'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSeqFragment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqCode(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.seqCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSeqCode:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSeqCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['seqCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqInsertCode(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.seqInsertCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSeqInsertCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setSeqInsertCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setSeqInsertCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setSeqInsertCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqInsertCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqInsertCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqInsertCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSeqInsertCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['seqInsertCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqInsertCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.molecule.Molecule.MolResidue.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('molecule')
    oldSerial = parent.__dict__.get('_serialDict').get('molResidues')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['molResidues'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['molResidues'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedIsotopeLabels(self):
    """
    Sorted for ccp.molecule.Molecule.MolResidue.isotopeLabels
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('isotopeLabels')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolFeatures(self):
    """
    Sorted for ccp.molecule.Molecule.MolResidue.molFeatures
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Annotation')
    tobjList = root.__dict__.get('annotationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molFeatures')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolResLinkEnds(self):
    """
    Sorted for ccp.molecule.Molecule.MolResidue.molResLinkEnds
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('molResLinkEnds')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  ccpCode = property(getCcpCode, None, None,
  r"""ccpCode of ChemComp corresponding to MolResidue
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  descriptor = property(getDescriptor, setDescriptor, None,
  r"""ChemComp descriptor - part of ChemCompVar key. Describes topological 
  variant (e,g, protonation state) of ChemCompVar. For Polymer-type 
  ChemComps (those that have 'next' or 'prev' LinkEnds) also describes 
  non-polymer part of substitution pattern. 
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  linking = property(getLinking, setLinking, None,
  r"""Residue linking code. For polymers distinguishes between terminal 
  (start), terminal (end) and internal residues. For nonpolymers defines 
  substitution pattern. Part of key for ChemCompVar. May be modified after 
  sequence definition. 
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, None, None,
  r"""molType of ChemComp corresponding to MolResidue
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  seqCode = property(getSeqCode, setSeqCode, None,
  r"""The seqCode is the residue number given by the user. For linear polymers 
  normally used to give the position of the residue in the molecule 
  sequence.
  """)
  
  seqInsertCode = property(getSeqInsertCode, setSeqInsertCode, None,
  r"""Sequence insert code - entered by user. Serves to distinguish residues 
  that the user prefers to give the same seqCode. Defaults to a single 
  space.
  """)
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemComp = property(getChemComp, setChemComp, None,
  r"""ChemComp that describes the type of the MolResidue
  """)
  
  chemCompVar = property(getChemCompVar, setChemCompVar, None,
  r"""ChemCompVar corresponding to MolResidue
  """)
  
  isotopeLabels = property(getIsotopeLabels, setIsotopeLabels, None,
  r"""Isotope label objects relevant to MolResidue
  """)
  
  molFeatures = property(getMolFeatures, setMolFeatures, None,
  r"""The MolFeature associated to a MolResidue.
  """)
  
  molResLinkEnds = property(getMolResLinkEnds,  None, None,
  r"""child link to class MolResLinkEnd
  """)
  
  molSeqFragment = property(getMolSeqFragment, setMolSeqFragment, None,
  r"""MolSeqFragment delimited by MolResidue
  """)
  
  molecule = property(getMolecule,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molecule
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolSeqFragment(memops.api.Implementation.DataObject):
  r"""Block of molResidues with consecutive serials in a molecule . For linear 
polymers this is guaranteed to be a connected fragment of the molecule. 
For other molecules the set of Molresidues selected may or may not be 
connected, depending on how the molecule was created. MolSeqFragments 
are disjoint and no residue can be a member of more than one.
  """
  #   from data model element ccp.molecule.Molecule.MolSeqFragment revision ?
  _metaclass = metaPackage.getElement('MolSeqFragment')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'organismName', 'organismSciName', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'alignments', 'limitResidues', 'molecule', 'naturalSource', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    dataDict['molecule'] = parent
    if (not isinstance(parent, Molecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['access'] = None
      dataDict['alignments'] = set()
      dataDict['limitResidues'] = set()
      dataDict['naturalSource'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.MolSeqFragment.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molSeqFragments')
        objKey = dataDict.get('limitResidues')
        if (objKey is not None):
          objKey = frozenset(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['limitResidues'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.MolSeqFragment:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    naturalSource = dataDict.get('naturalSource')
    if (naturalSource is not None):
      topObject = naturalSource.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.MolSeqFragment:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for alignment in dataDict.get('alignments'):
      if (not (alignment in objsToBeDeleted)):
        alignment.__dict__['molSeqFragment'] = None

    for limitResidue in dataDict.get('limitResidues'):
      if (not (limitResidue in objsToBeDeleted)):
        limitResidue.__dict__['molSeqFragment'] = None

    naturalSource = dataDict.get('naturalSource')
    if ((naturalSource is not None and not (naturalSource in objsToBeDeleted))):
      molSeqFragments = naturalSource.__dict__.get('molSeqFragments')
      molSeqFragments.remove(self)

    molecule = dataDict.get('molecule')
    if (not (molecule in objsToBeDeleted)):
      objKey = dataDict.get('limitResidues')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molecule.__dict__.get('molSeqFragments')
        if (self is dd.get(objKey)):
          del dd[objKey]

  def addAlignment(self, value):
    """
    Add for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    if (not isinstance(value, Alignment)):
      raise ApiError("""%s.addAlignment:
       value is not of class ccp.molecule.Molecule.Alignment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('alignments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAlignment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAlignment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAlignment:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAlignment:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAlignment:
           Link alignments between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('molSeqFragment')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('alignments')
      siblingValues.remove(value)

    value.__dict__['molSeqFragment'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAlignment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('limitResidues')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molecule')
        dd = value.__dict__.get('molSeqFragments')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getOrganismName()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: organismName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: organismName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: organismName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: organismName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getOrganismSciName()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: organismSciName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: organismSciName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: organismSciName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: organismSciName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('alignments')
      for value in values:
        if (not isinstance(value, Alignment)):
          raise ApiError("""%s.checkValid: alignments:
           value is not of class ccp.molecule.Molecule.Alignment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSeqFragment')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: alignments:
           non-reciprocal link alignments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: alignments:
           Link alignments between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('limitResidues')
      for value in values:
        if (not isinstance(value, MolResidue)):
          raise ApiError("""%s.checkValid: limitResidues:
           value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molSeqFragment')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: limitResidues:
           non-reciprocal link limitResidues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (not isinstance(value, Molecule)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molSeqFragments')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: naturalSource:
           non-reciprocal link naturalSource from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    ll = [x.serial for x in self.limitResidues]
    min0 = min(ll)
    max0 = max(ll)
    for seqBlock in self.molecule.molSeqFragments:
      if seqBlock is not self:
        (i1, i2) = [x.serial for x in seqBlock.limitResidues]
        if not ((i1 > max0 and i2 > max0) or (i1 < min0 and i2 < min0)):
          isValid = False
          break
    else:
      isValid = True
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint MolSeqFragments_are_disjoint violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('alignments')
    values = dataDict.get('limitResidues')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: limitResidues:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molecule')
    if (value is None):
      raise ApiError("""%s.checkValid: molecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('naturalSource')

  delete = memops.api.Implementation.DataObject.delete
  
  def findAllAlignments(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('alignments')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('alignments')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alignLength', 'alignmentProgram', 'alignmentScore', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'homologyRatio', 'nIdentical', 'nPositive', 'serial', 'access', 'dbRef', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllLimitResidues(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.MolSeqFragment.limitResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('limitResidues')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('limitResidues')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'seqCode', 'seqInsertCode', 'serial', 'access', 'chemComp', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findFirstAlignment(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('alignments')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('alignments')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alignLength', 'alignmentProgram', 'alignmentScore', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'homologyRatio', 'nIdentical', 'nPositive', 'serial', 'access', 'dbRef', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstLimitResidue(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.MolSeqFragment.limitResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('limitResidues')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('limitResidues')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'seqCode', 'seqInsertCode', 'serial', 'access', 'chemComp', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAlignments(self):
    """
    Get for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('alignments')
    result = frozenset(tempVar)
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.MolSeqFragment
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolSeqFragment'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.Molecule')
        obj1 = obj0.__dict__.get('molecules').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MolSeqFragment'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = frozenset(tempList)
      obj2 = obj1.__dict__.get('molSeqFragments').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    for xx in dataDict.get('limitResidues'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLimitResidues(self):
    """
    Get for ccp.molecule.Molecule.MolSeqFragment.limitResidues
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('limitResidues')
    result = frozenset(tempVar)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    result = dataDict.get('limitResidues')
    if (result is not None):
      result = frozenset(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolecule(self):
    """
    Get for ccp.molecule.Molecule.MolSeqFragment.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result
  
  def getNaturalSource(self):
    """
    Get for ccp.molecule.Molecule.MolSeqFragment.naturalSource
    """
    dataDict = self.__dict__
    result = dataDict.get('naturalSource')
    return result
  
  def getOrganismName(self):
    """
    getter for derived attribute organismName
    """
    dataDict = self.__dict__
    result = self.getByNavigation('naturalSource', 'organismName')
    return result
  
  def getOrganismSciName(self):
    """
    getter for derived attribute organismSciName
    """
    dataDict = self.__dict__
    result = self.getByNavigation('naturalSource', 'scientificName')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.MolSeqFragment.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def removeAlignment(self, value):
    """
    Remove for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    if (not isinstance(value, Alignment)):
      raise ApiError("""%s.removeAlignment:
       value is not of class ccp.molecule.Molecule.Alignment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('alignments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAlignment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAlignment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAlignment:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAlignment:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['molSeqFragment'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAlignment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.MolSeqFragment
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAlignments(self, values):
    """
    Set for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAlignments:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Alignment)):
        raise ApiError("""%s.setAlignments:
         value is not of class ccp.molecule.Molecule.Alignment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('alignments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlignments:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlignments:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAlignments:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAlignments:
           Link alignments between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molSeqFragment'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molSeqFragment')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('alignments')
          vv.remove(cv)

      cv.__dict__['molSeqFragment'] = self

    dataDict['alignments'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlignments')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setLimitResidues(self, values):
    """
    Set for ccp.molecule.Molecule.MolSeqFragment.limitResidues
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setLimitResidues:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, MolResidue)):
        raise ApiError("""%s.setLimitResidues:
         value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('limitResidues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLimitResidues:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setLimitResidues:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLimitResidues:
         cannot set limitResidues, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 2)):
        raise ApiError("""%s.setLimitResidues:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      oldSelves = {}
      for cv in values:
        if (not (cv in currentValues)):
          oldSelf = cv.__dict__.get('molSeqFragment')
          if (oldSelf is not None):
            knt = oldSelves.get(oldSelf)
            if (knt is None):
              knt = 1
            else:
              knt = knt + 1

            oldSelves[oldSelf] = knt

      for osv in oldSelves.keys():
        siblingValues = osv.__dict__.get('limitResidues')
        knt = oldSelves.get(osv)
        if (len(siblingValues) < (2 + knt)):
          raise ApiError("""%s.setLimitResidues:
           locard: siblingValues: cannot remove value""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setLimitResidues:
           Link limitResidues between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molSeqFragment'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molSeqFragment')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('limitResidues')
          vv.remove(cv)

      cv.__dict__['molSeqFragment'] = self

    dataDict['limitResidues'] = values

    # doNotifies
  
  def setNaturalSource(self, value):
    """
    Set for ccp.molecule.Molecule.MolSeqFragment.naturalSource
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Taxonomy import NaturalSource as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNaturalSource:
         value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('naturalSource')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNaturalSource:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNaturalSource:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNaturalSource:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNaturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molSeqFragments')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setNaturalSource:
         Read link 'naturalSource' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molSeqFragments')
      newSelves.add(self)

    dataDict['naturalSource'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNaturalSource')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAlignments(self):
    """
    Sorted for ccp.molecule.Molecule.MolSeqFragment.alignments
    """
    dataDict = self.__dict__
    ll = dataDict.get('alignments')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedLimitResidues(self):
    """
    Sorted for ccp.molecule.Molecule.MolSeqFragment.limitResidues
    """
    dataDict = self.__dict__
    ll = dataDict.get('limitResidues')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  organismName = property(getOrganismName, None, None,
  r"""Common name of source organism (e.g. 'mouse', 'human',...).
  """)
  
  organismSciName = property(getOrganismSciName, None, None,
  r"""Scientific name of source organism (e.g. 'mus musculus', 'homo 
  sapiens',...). 
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  alignments = property(getAlignments, setAlignments, None,
  r"""Alignments relevant to MolSeqFragment
  """)
  
  limitResidues = property(getLimitResidues, setLimitResidues, None,
  r"""MolResidues belonging to Polymer Sequence Block. 
  """)
  
  molecule = property(getMolecule,  None, None,
  r"""parent link
  """)
  
  naturalSource = property(getNaturalSource, setNaturalSource, None,
  r"""Natural Source that MolSeqFragment refers to.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molecule
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Molecule(memops.api.Implementation.TopObject):
  r"""Abstract molecule, with defined topology but no location, coordinates, 
etc. 
  """
  #   from data model element ccp.molecule.Molecule.Molecule revision ?
  _metaclass = metaPackage.getElement('Molecule')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('applicationData', 'calcIsoelectricPoint', 'className', 'commonNames', 'createdBy', 'details', 'empiricalFormula', 'fieldNames', 'formalCharge', 'fragmentDetails', 'functions', 'guid', 'hasNonStdChemComp', 'hasNonStdChirality', 'inConstructor', 'isAromatic', 'isDeleted', 'isFinalised', 'isLoaded', 'isModifiable', 'isModified', 'isParamagnetic', 'isReading', 'isStdCyclic', 'isStdLinear', 'keywords', 'lastUnlockedBy', 'longName', 'metaclass', 'molType', 'molecularMass', 'mutationDetails', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'seqDetails', 'seqLength', 'seqString', 'smiles', 'smilesType', 'stdSeqString', 'access', 'activeAccess', 'activeRepositories', 'alignments', 'chains', 'citations', 'entryMolecules', 'memopsRoot', 'molComponents', 'molResLinks', 'molResidues', 'molSeqFragments', 'moleculeSysNames', 'naturalSource', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.molecule.Molecule')

      dataDict['applicationData'] = list()
      dataDict['calcIsoelectricPoint'] = None
      dataDict['commonNames'] = list()
      dataDict['createdBy'] = None
      dataDict['details'] = None
      dataDict['fragmentDetails'] = None
      dataDict['functions'] = list()
      dataDict['guid'] = None
      dataDict['isFinalised'] = False
      dataDict['isModifiable'] = True
      dataDict['keywords'] = list()
      dataDict['lastUnlockedBy'] = None
      dataDict['longName'] = None
      dataDict['mutationDetails'] = None
      dataDict['name'] = None
      dataDict['seqDetails'] = None
      dataDict['smiles'] = None
      dataDict['smilesType'] = None
      dataDict['access'] = None
      dataDict['alignments'] = {}
      dataDict['chains'] = set()
      dataDict['citations'] = set()
      dataDict['entryMolecules'] = set()
      dataDict['molComponents'] = set()
      dataDict['molResLinks'] = {}
      dataDict['molResidues'] = {}
      dataDict['molSeqFragments'] = {}
      dataDict['moleculeSysNames'] = {}
      dataDict['naturalSource'] = None
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.Molecule.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['alignments'] = 0
      serialDict['molResidues'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('molecules')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentMolecule') is None)):
        root.__dict__['currentMolecule'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.Molecule:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    alignments = dataDict.get('alignments').values()
    for alignment in alignments:
      if (not (alignment in objsToBeDeleted)):
        objsToBeDeleted.add(alignment)
        objsToBeChecked.append(alignment)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    chains = dataDict.get('chains')
    if (chains):
      raise ApiError("""%s._checkDelete:
       Object can not be deleted while chains is set""" % self.qualifiedName
       + ": %s" % (self,)
      )

    citations = dataDict.get('citations')
    pass
    for citation in citations:
      topObject = citation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    entryMolecules = dataDict.get('entryMolecules')
    for entryMolecule in entryMolecules:
      if (not (entryMolecule in objsToBeDeleted)):
        objsToBeDeleted.add(entryMolecule)
        objsToBeChecked.append(entryMolecule)

    for entryMolecule in entryMolecules:
      topObject = entryMolecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molComponents = dataDict.get('molComponents')
    if (molComponents):
      raise ApiError("""%s._checkDelete:
       Object can not be deleted while molComponents is set""" % self.qualifiedName
       + ": %s" % (self,)
      )

    molResLinks = dataDict.get('molResLinks').values()
    for molResLink in molResLinks:
      if (not (molResLink in objsToBeDeleted)):
        objsToBeDeleted.add(molResLink)
        objsToBeChecked.append(molResLink)

    molResidues = dataDict.get('molResidues').values()
    for molResidue in molResidues:
      if (not (molResidue in objsToBeDeleted)):
        objsToBeDeleted.add(molResidue)
        objsToBeChecked.append(molResidue)

    molSeqFragments = dataDict.get('molSeqFragments').values()
    for molSeqFragment in molSeqFragments:
      if (not (molSeqFragment in objsToBeDeleted)):
        objsToBeDeleted.add(molSeqFragment)
        objsToBeChecked.append(molSeqFragment)

    moleculeSysNames = dataDict.get('moleculeSysNames').values()
    for moleculeSysName in moleculeSysNames:
      if (not (moleculeSysName in objsToBeDeleted)):
        objsToBeDeleted.add(moleculeSysName)
        objsToBeChecked.append(moleculeSysName)

    naturalSource = dataDict.get('naturalSource')
    if (naturalSource is not None):
      topObject = naturalSource.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.Molecule:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentMolecule')):
      memopsRoot.__dict__['currentMolecule'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for citation in dataDict.get('citations'):
      if (not (citation in objsToBeDeleted)):
        molecules = citation.__dict__.get('molecules')
        molecules.remove(self)

    for molComponent in dataDict.get('molComponents'):
      if (not (molComponent in objsToBeDeleted)):
        molComponent.__dict__['molecule'] = None

    naturalSource = dataDict.get('naturalSource')
    if ((naturalSource is not None and not (naturalSource in objsToBeDeleted))):
      molecules = naturalSource.__dict__.get('molecules')
      molecules.remove(self)

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('molecules')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['alignments'] = {}
    dataDict['molResLinks'] = {}
    dataDict['molResidues'] = {}
    dataDict['molSeqFragments'] = {}
    dataDict['moleculeSysNames'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addCommonName(self, value):
    """
    Add for ccp.molecule.Molecule.Molecule.commonNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addCommonName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addCommonName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addCommonName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addCommonName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addFunction(self, value):
    """
    Add for ccp.molecule.Molecule.Molecule.functions
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addFunction:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addFunction:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addFunction:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addFunction:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('functions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addFunction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addFunction:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addFunction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addKeyword(self, value):
    """
    Add for ccp.molecule.Molecule.Molecule.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolComponent(self, value):
    """
    Add for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import MolComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolComponent:
       value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('molecule')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolComponent:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolComponent:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolComponent:
           Link molComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value.isFinalised)):
            raise ApiError("""%s.addMolComponent:
             molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelf = value.__dict__.get('molecule')
    if (oldSelf is not None):
      if (not (oldSelf.__dict__.get('isLoaded'))):
        oldSelf.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('molComponents')
      siblingValues.remove(value)

    value.__dict__['molecule'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('alignments').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molResLinks').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molResidues').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molSeqFragments').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('moleculeSysNames').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('molecules')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('calcIsoelectricPoint')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: calcIsoelectricPoint:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: calcIsoelectricPoint:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('commonNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: commonNames:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getEmpiricalFormula()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: empiricalFormula:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getFormalCharge()
      if (value is None):
        raise ApiError("""%s.checkValid: formalCharge:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: formalCharge:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('fragmentDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: fragmentDetails:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: fragmentDetails:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: fragmentDetails:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('functions')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: functions:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: functions:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: functions:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: functions:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getHasNonStdChemComp()
      if (value is None):
        raise ApiError("""%s.checkValid: hasNonStdChemComp:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: hasNonStdChemComp:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getHasNonStdChirality()
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: hasNonStdChirality:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getIsAromatic()
      if (value is None):
        raise ApiError("""%s.checkValid: isAromatic:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isAromatic:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isFinalised')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isFinalised:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getIsParamagnetic()
      if (value is None):
        raise ApiError("""%s.checkValid: isParamagnetic:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isParamagnetic:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getIsStdCyclic()
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isStdCyclic:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getIsStdLinear()
      if (value is None):
        raise ApiError("""%s.checkValid: isStdLinear:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isStdLinear:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('longName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: longName:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: longName:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: longName:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getMolType()
      if (value is not None):
        if (not (value in ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other'])):
          raise ApiError("""%s.checkValid: molType:
           ccp.molecule.Molecule.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: molType:
           MolType constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getMolecularMass()
      if (value is None):
        raise ApiError("""%s.checkValid: molecularMass:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: molecularMass:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: molecularMass:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('mutationDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: mutationDetails:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: mutationDetails:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: mutationDetails:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSeqLength()
      if (value is None):
        raise ApiError("""%s.checkValid: seqLength:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: seqLength:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getSeqString()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqString:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('smiles')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: smiles:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('smilesType')
      if (value is not None):
        if (not (value in ['stereo', 'nonstereo'])):
          raise ApiError("""%s.checkValid: smilesType:
           ccp.molecule.Molecule.SmilesType input is not in enumeration ['stereo', 'nonstereo']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: smilesType:
           SmilesType constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getStdSeqString()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: stdSeqString:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('alignments').values()
      for value in values:
        if (not isinstance(value, Alignment)):
          raise ApiError("""%s.checkValid: alignments:
           value is not of class ccp.molecule.Molecule.Alignment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: alignments:
           non-reciprocal link alignments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('chains')
      for value in values:
        from ccp.api.molecule.MolSystem import Chain as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chains:
           value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chains:
           non-reciprocal link chains from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chains:
           Link chains between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('citations')
      for value in values:
        from ccp.api.general.Citation import Citation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: citations:
           value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molecules')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: citations:
           non-reciprocal link citations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: citations:
           Link citations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('entryMolecules')
      for value in values:
        from ccp.api.nmr.NmrEntry import EntryMolecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: entryMolecules:
           value is not of class ccp.nmr.NmrEntry.EntryMolecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: entryMolecules:
           non-reciprocal link entryMolecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: entryMolecules:
           Link entryMolecules between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molComponents')
      for value in values:
        from ccp.api.lims.RefSampleComponent import MolComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molComponents:
           value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molComponents:
           non-reciprocal link molComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molComponents:
           Link molComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molResLinks').values()
      for value in values:
        if (not isinstance(value, MolResLink)):
          raise ApiError("""%s.checkValid: molResLinks:
           value is not of class ccp.molecule.Molecule.MolResLink""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molResLinks:
           non-reciprocal link molResLinks from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('molResidues').values()
      for value in values:
        if (not isinstance(value, MolResidue)):
          raise ApiError("""%s.checkValid: molResidues:
           value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molResidues:
           non-reciprocal link molResidues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('molSeqFragments').values()
      for value in values:
        if (not isinstance(value, MolSeqFragment)):
          raise ApiError("""%s.checkValid: molSeqFragments:
           value is not of class ccp.molecule.Molecule.MolSeqFragment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSeqFragments:
           non-reciprocal link molSeqFragments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('moleculeSysNames').values()
      for value in values:
        if (not isinstance(value, MoleculeSysName)):
          raise ApiError("""%s.checkValid: moleculeSysNames:
           value is not of class ccp.molecule.Molecule.MoleculeSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: moleculeSysNames:
           non-reciprocal link moleculeSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molecules')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: naturalSource:
           non-reciprocal link naturalSource from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      ll = self.sortedMolResidues()
      if ll:
        isValid = (len(ll) == (ll[-1].serial - ll[0].serial + 1))
      else:
        isValid = True
      if (not (isValid)):
        raise ApiError("""%s.checkValid:
         constraint molResidue_serials_must_be_consecutive violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      ll = self.molResidues
      aset = frozenset((x.seqCode, x.seqInsertCode) for x in ll)
      isValid = (len(aset) == len(ll))
      if (not (isValid)):
        raise ApiError("""%s.checkValid:
         constraint seqCode_and_seqInsertCode_form_secondary_key_for_molResidues violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not ((self.smiles is None) == (self.smilesType is None))):
        raise ApiError("""%s.checkValid:
         constraint smiles_goes_with_smilesType violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('calcIsoelectricPoint')
      values = dataDict.get('commonNames')
      value = dataDict.get('details')
      value = dataDict.get('fragmentDetails')
      values = dataDict.get('functions')
      value = dataDict.get('isFinalised')
      if (value is None):
        raise ApiError("""%s.checkValid: isFinalised:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('keywords')
      value = dataDict.get('longName')
      value = dataDict.get('mutationDetails')
      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('seqDetails')
      value = dataDict.get('smiles')
      value = dataDict.get('smilesType')
      # check roles
      value = dataDict.get('access')
      values = dataDict.get('alignments').values()
      values = dataDict.get('chains')
      values = dataDict.get('citations')
      values = dataDict.get('entryMolecules')
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('molComponents')
      for value in values:
        (self, value) = (value, self)
        if (not (value.isFinalised)):
          raise ApiError("""%s.checkValid: molComponents:
           molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        (value, self) = (self, value)

      values = dataDict.get('molResLinks').values()
      values = dataDict.get('molResidues').values()
      values = dataDict.get('molSeqFragments').values()
      values = dataDict.get('moleculeSysNames').values()
      value = dataDict.get('naturalSource')
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories
  
  def findAllAlignments(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.alignments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('alignments').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('alignments').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alignLength', 'alignmentProgram', 'alignmentScore', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'homologyRatio', 'nIdentical', 'nPositive', 'serial', 'access', 'dbRef', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChains(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chains')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chains')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllCitations(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.citations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casAbstractCode', 'details', 'doi', 'firstPage', 'lastPage', 'medlineUiCode', 'pubMedId', 'serial', 'status', 'title', 'year', 'access', 'citationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllEntryMolecules(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.entryMolecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entryMolecules')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entryMolecules')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('productionMethod', 'sourceType', 'vectorType', 'access', 'entry', 'experimentalSource', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolComponents(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casNum', 'details', 'empiricalFormula', 'molType', 'molecularMass', 'name', 'seqDetails', 'seqString', 'access', 'labeledMixture', 'molecule', 'naturalSource', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolResLinks(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.molResLinks
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molResLinks').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molResLinks').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('dihedralAngle', 'access', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolResidues(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.molResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molResidues').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molResidues').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'seqCode', 'seqInsertCode', 'serial', 'access', 'chemComp', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSeqFragments(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.molSeqFragments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSeqFragments').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSeqFragments').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'molecule', 'naturalSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMoleculeSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.Molecule.Molecule.moleculeSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('moleculeSysNames').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('moleculeSysNames').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'namingSystem', 'access', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository
  
  def findFirstAlignment(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.alignments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('alignments').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('alignments').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('alignments').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alignLength', 'alignmentProgram', 'alignmentScore', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'homologyRatio', 'nIdentical', 'nPositive', 'serial', 'access', 'dbRef', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChain(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chains')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('chains')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstCitation(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.citations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casAbstractCode', 'details', 'doi', 'firstPage', 'lastPage', 'medlineUiCode', 'pubMedId', 'serial', 'status', 'title', 'year', 'access', 'citationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstEntryMolecule(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.entryMolecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entryMolecules')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('entryMolecules')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('productionMethod', 'sourceType', 'vectorType', 'access', 'entry', 'experimentalSource', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolComponent(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casNum', 'details', 'empiricalFormula', 'molType', 'molecularMass', 'name', 'seqDetails', 'seqString', 'access', 'labeledMixture', 'molecule', 'naturalSource', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolResLink(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.molResLinks
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molResLinks').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('molResLinkEnds')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molResLinks').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molResLinks').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('dihedralAngle', 'access', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolResidue(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.molResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molResidues').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molResidues').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molResidues').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'seqCode', 'seqInsertCode', 'serial', 'access', 'chemComp', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSeqFragment(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.molSeqFragments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molSeqFragments').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('limitResidues')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molSeqFragments').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molSeqFragments').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'molecule', 'naturalSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMoleculeSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.Molecule.Molecule.moleculeSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('moleculeSysNames').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('namingSystem')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('moleculeSysNames').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('moleculeSysNames').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'namingSystem', 'access', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories
  
  def getAlignments(self):
    """
    Get for ccp.molecule.Molecule.Molecule.alignments
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('alignments').values()
    result = frozenset(tempVar)
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.Molecule
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.molecule.Molecule.Molecule'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('molecules').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.molecule.Molecule')
      obj1 = startObj.__dict__.get('molecules').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCalcIsoelectricPoint(self):
    """
    Get for ccp.molecule.Molecule.Molecule.calcIsoelectricPoint
    """
    dataDict = self.__dict__
    result = dataDict.get('calcIsoelectricPoint')
    return result
  
  def getChains(self):
    """
    Get for ccp.molecule.Molecule.Molecule.chains
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('chains')
    result = frozenset(tempVar)
    return result
  
  def getCitations(self):
    """
    Get for ccp.molecule.Molecule.Molecule.citations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('citations')
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCommonNames(self):
    """
    Get for ccp.molecule.Molecule.Molecule.commonNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('commonNames')
    result = tuple(tempVar)
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy
  
  def getDetails(self):
    """
    Get for ccp.molecule.Molecule.Molecule.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getEmpiricalFormula(self):
    """
    getter for derived attribute empiricalFormula
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    clazz = ccp.api.molecule.ChemComp.ChemAtom
    
    for mr in self.molResidues:
      for ss in (ca.elementSymbol for ca in mr.getByNavigation('chemComp', ('chemCompVars', (mr.linking, mr.descriptor)), 'chemAtoms') if isinstance(ca, clazz)):
        ii = dd.get(ss)
        if ii is None:
          dd[ss] = 1
        else:
          dd[ss] = ii + 1
    if dd:
      # generate formula
      ll = [None] * (len(dd)*2)
      next = 0
      for ss in ('C','H'):
        ii = dd.get(ss)
        if ii is not None:
          ll[next] = ss
          ll[next+1] = str(ii)
          del dd[ss]
          next = next + 2
    
      items = dd.items()
      items.sort()
      for (ss, ii) in items:
        ll[next] = ss
        ll[next+1] = str(ii)
        next = next + 2
      #
      result = ''.join(ll)
    else:
      result = None
    return result
  
  def getEntryMolecules(self):
    """
    Get for ccp.molecule.Molecule.Molecule.entryMolecules
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('entryMolecules')
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFormalCharge(self):
    """
    getter for derived attribute formalCharge
    """
    dataDict = self.__dict__
    result = sum(x.chemCompVar.formalCharge for x in self.molResidues)
    return result
  
  def getFragmentDetails(self):
    """
    Get for ccp.molecule.Molecule.Molecule.fragmentDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('fragmentDetails')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result
  
  def getFunctions(self):
    """
    Get for ccp.molecule.Molecule.Molecule.functions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('functions')
    result = tuple(tempVar)
    return result

  getGuid = memops.api.Implementation.TopObject.getGuid
  
  def getHasNonStdChemComp(self):
    """
    getter for derived attribute hasNonStdChemComp
    """
    dataDict = self.__dict__
    for cc in frozenset(x.chemComp for x in self.molResidues):
      if cc.ccpCode != cc.stdChemCompCode:
        result = True
        break
    else:
      result = False
    return result
  
  def getHasNonStdChirality(self):
    """
    getter for derived link hasNonStdChirality
    """
    dataDict = self.__dict__
    for cc in frozenset(x.chemComp for x in self.molResidues):
      if not cc.hasStdChirality:
        result = True
        break
    else:
      result = False
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIsAromatic(self):
    """
    getter for derived attribute isAromatic
    """
    dataDict = self.__dict__
    for rr in self.molResidues:
      if rr.chemCompVar.isAromatic == True:
        result = True
        break
    else:
      result = False
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsFinalised(self):
    """
    Get for ccp.molecule.Molecule.Molecule.isFinalised
    """
    dataDict = self.__dict__
    result = dataDict.get('isFinalised')
    return result

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified
  
  def getIsParamagnetic(self):
    """
    getter for derived attribute isParamagnetic
    """
    dataDict = self.__dict__
    for rr in self.molResidues:
      if rr.chemCompVar.isParamagnetic == True:
        result = True
        break
    else:
      result = False
    return result

  getIsReading = memops.api.Implementation.TopObject.getIsReading
  
  def getIsStdCyclic(self):
    """
    getter for derived attribute isStdCyclic
    """
    dataDict = self.__dict__
    molResLinks = self.molResLinks
    maxDiff = len(self.molResidues)-1
    spareLinks = len(molResLinks) - maxDiff -1
    
    for molResLink in molResLinks:
      endA, endB = molResLink.molResLinkEnds
      codeA = endA.linkCode
      codeB = endB.linkCode
      diff = endA.molResidue.serial - endB.molResidue.serial
      if not ( (diff == -1 and codeA == 'next' and codeB == 'prev') or 
                (diff == 1 and codeB == 'next' and codeA == 'prev' ) or
                (diff == maxDiff and codeA == 'next' and codeB == 'prev') or 
                (diff == -maxDiff and codeB == 'next' and codeA == 'prev' ) ):
        spareLinks = spareLinks -1
    
    if spareLinks < 0:
      result = False
    else:
      result = True
    return result
  
  def getIsStdLinear(self):
    """
    getter for derived attribute isStdLinear
    """
    dataDict = self.__dict__
    molResLinks = self.molResLinks
    maxDiff = len(self.molResidues)-1
    spareLinks = len(molResLinks) - maxDiff
    
    for molResLink in molResLinks:
      endA, endB = molResLink.molResLinkEnds
      codeA = endA.linkCode
      codeB = endB.linkCode
      diff = endA.molResidue.serial - endB.molResidue.serial
      if not ( (diff == -1 and codeA == 'next' and codeB == 'prev') or 
                (diff == 1 and codeB == 'next' and codeA == 'prev' ) ):
        spareLinks = spareLinks -1
    
    if spareLinks < 0:
      result = False
    else:
      result = True
    return result
  
  def getKeywords(self):
    """
    Get for ccp.molecule.Molecule.Molecule.keywords
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('keywords')
    result = tuple(tempVar)
    return result

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getLongName(self):
    """
    Get for ccp.molecule.Molecule.Molecule.longName
    """
    dataDict = self.__dict__
    result = dataDict.get('longName')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.molecule.Molecule.Molecule.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolComponents(self):
    """
    Get for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molComponents')
    result = frozenset(tempVar)
    return result
  
  def getMolResLinks(self):
    """
    Get for ccp.molecule.Molecule.Molecule.molResLinks
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molResLinks').values()
    result = frozenset(tempVar)
    return result
  
  def getMolResidues(self):
    """
    Get for ccp.molecule.Molecule.Molecule.molResidues
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molResidues').values()
    result = frozenset(tempVar)
    return result
  
  def getMolSeqFragments(self):
    """
    Get for ccp.molecule.Molecule.Molecule.molSeqFragments
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molSeqFragments').values()
    result = frozenset(tempVar)
    return result
  
  def getMolType(self):
    """
    Getter for derived attribute molType. Possible return values are
    'protein', 'DNA', 'RNA', 'carbohydrate', or 'DNA/RNA'
    """
    dataDict = self.__dict__
    aset = set(x.chemComp for x in self.molResidues)
    aset = set(x.molType for x in aset)
    if len(aset) == 1:
      result = aset.pop()
    elif aset == set(('DNA', 'RNA')):
      result = 'DNA/RNA'
    else:
      result = None
    return result
  
  def getMolecularMass(self):
    """
    getter for derived attribute molecularMass
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    clazz = ccp.api.molecule.ChemComp.ChemAtom
    
    for mr in self.molResidues:
      for ss in (ca.elementSymbol for ca in mr.getByNavigation('chemComp', ('chemCompVars', (mr.linking, mr.descriptor)), 'chemAtoms') if isinstance(ca, clazz)):
        ii = dd.get(ss)
        if ii is None:
          dd[ss] = 1
        else:
          dd[ss] = ii + 1
    
    # calculate mass
    xx = self.root.currentChemElementStore
    result = sum(ii * xx.findFirstChemElement(symbol=ss).mass for (ss, ii) in dd.iteritems())
    return result
  
  def getMoleculeSysNames(self):
    """
    Get for ccp.molecule.Molecule.Molecule.moleculeSysNames
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('moleculeSysNames').values()
    result = frozenset(tempVar)
    return result
  
  def getMutationDetails(self):
    """
    Get for ccp.molecule.Molecule.Molecule.mutationDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('mutationDetails')
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.Molecule.Molecule.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNaturalSource(self):
    """
    Get for ccp.molecule.Molecule.Molecule.naturalSource
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    result = dataDict.get('naturalSource')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.Molecule.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSeqDetails(self):
    """
    Get for ccp.molecule.Molecule.Molecule.seqDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('seqDetails')
    return result
  
  def getSeqLength(self):
    """
    Getter function for derived attribute seqLength.
    """
    dataDict = self.__dict__
    result = len(self.molResidues)
    return result
  
  def getSeqString(self):
    """
    getter for derived attribute seqString
    """
    dataDict = self.__dict__
    ll = self.sortedMolResidues()
    result = ''
    if ll:
      
      from ccp.general.Constants import ccpCodeToCode1LetterDict
      molType = ll[0].molType
      mapDict = ccpCodeToCode1LetterDict.get(molType)
      
      if mapDict is not None and self.isStdLinear:
        output = [None] * len(ll)
        ii = -1
    
        for rr in ll:
          if rr.molType != molType:
            break
          
          ii = ii + 1
          output[ii] = mapDict.get(rr.ccpCode,'*')
    
        else:
          result = ''.join(output)
    return result
  
  def getSmiles(self):
    """
    Get for ccp.molecule.Molecule.Molecule.smiles
    """
    dataDict = self.__dict__
    result = dataDict.get('smiles')
    return result
  
  def getSmilesType(self):
    """
    Get for ccp.molecule.Molecule.Molecule.smilesType
    """
    dataDict = self.__dict__
    result = dataDict.get('smilesType')
    return result
  
  def getStdSeqString(self):
    """
    getter for serived attribute stdSeqString
    """
    dataDict = self.__dict__
    ll = self.sortedMolResidues()
    result = ''
    if ll:
      
      from ccp.general.Constants import ccpCodeToCode1LetterDict
      
      molType = ll[0].molType
      mapDict = ccpCodeToCode1LetterDict.get(molType)
      if mapDict is not None and self.isStdLinear:
    
        output = [None] * len(ll)
        ii = -1
    
        for rr in ll:
          if rr.molType != molType:
            break
          
          ii = ii + 1
          output[ii] = mapDict.get(rr.ccpCode) or rr.chemComp.code1Letter or '*'
    
        else:
          result = ''.join(output)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newAlignment(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.Alignment
    """
    return Alignment(self, **attrlinks)
  
  def newMolResLink(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.MolResLink
    """
    return MolResLink(self, **attrlinks)
  
  def newMolResidue(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.MolResidue
    """
    return MolResidue(self, **attrlinks)
  
  def newMolSeqFragment(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.MolSeqFragment
    """
    return MolSeqFragment(self, **attrlinks)
  
  def newMoleculeSysName(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.MoleculeSysName
    """
    return MoleculeSysName(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeCommonName(self, value):
    """
    Remove for ccp.molecule.Molecule.Molecule.commonNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeCommonName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeCommonName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeCommonName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeCommonName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeCommonName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeFrom = memops.api.Implementation.TopObject.removeFrom
  
  def removeFunction(self, value):
    """
    Remove for ccp.molecule.Molecule.Molecule.functions
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeFunction:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeFunction:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeFunction:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeFunction:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('functions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeFunction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeFunction:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeFunction:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeFunction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeKeyword(self, value):
    """
    Remove for ccp.molecule.Molecule.Molecule.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeKeyword:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolComponent(self, value):
    """
    Remove for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import MolComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolComponent:
       value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolComponent:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolComponent:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['molecule'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.Molecule
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCalcIsoelectricPoint(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.calcIsoelectricPoint
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setCalcIsoelectricPoint:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setCalcIsoelectricPoint:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('calcIsoelectricPoint')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCalcIsoelectricPoint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCalcIsoelectricPoint:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['calcIsoelectricPoint'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCalcIsoelectricPoint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChains(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.chains
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChains:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolSystem import Chain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChains:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('chains')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molecule')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setChains:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChains:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChains:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChains:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setChains:
           locard molecule: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChains:
           Link chains between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['molecule'] = self

    dataDict['chains'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChains')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCitations(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.citations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setCitations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Citation import Citation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCitations:
         value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('citations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCitations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCitations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCitations:
         cannot set citations, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCitations:
           Link citations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('molecules')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('molecules')
        oldSelves.add(self)

    dataDict['citations'] = values

    # doNotifies
  
  def setCommonNames(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.commonNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCommonNames:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCommonNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCommonNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['commonNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCommonNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy
  
  def setDetails(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEntryMolecules(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.entryMolecules
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setEntryMolecules:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrEntry import EntryMolecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setEntryMolecules:
         value is not of class ccp.nmr.NmrEntry.EntryMolecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('entryMolecules')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molecule')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setEntryMolecules:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEntryMolecules:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEntryMolecules:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setEntryMolecules:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setEntryMolecules:
           locard molecule: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setEntryMolecules:
           Link entryMolecules between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['molecule'] = self

    dataDict['entryMolecules'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEntryMolecules')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFragmentDetails(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.fragmentDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFragmentDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setFragmentDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFragmentDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('fragmentDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFragmentDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFragmentDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['fragmentDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFragmentDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFunctions(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.functions
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFunctions:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setFunctions:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFunctions:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFunctions:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('functions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFunctions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFunctions:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['functions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFunctions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setGuid = memops.api.Implementation.TopObject.setGuid
  
  def setIsFinalised(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.isFinalised
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsFinalised:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('isFinalised')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsFinalised:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsFinalised:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsFinalised:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isFinalised'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsFinalised')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable
  
  def setKeywords(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.keywords
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setKeywords:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setKeywords:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setKeywords:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['keywords'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setKeywords')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setLongName(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.longName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setLongName:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setLongName:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setLongName:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('longName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLongName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLongName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['longName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLongName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolComponents(self, values):
    """
    Set for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolComponents:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.RefSampleComponent import MolComponent as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolComponents:
         value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('molComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molecule')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setMolComponents:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolComponents:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolComponents:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolComponents:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolComponents:
           Link molComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (value.isFinalised)):
            raise ApiError("""%s.setMolComponents:
             molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molecule'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molecule')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('molComponents')
          vv.remove(cv)

      cv.__dict__['molecule'] = self

    dataDict['molComponents'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolComponents')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMutationDetails(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.mutationDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMutationDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setMutationDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMutationDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('mutationDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMutationDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMutationDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['mutationDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMutationDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNaturalSource(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.naturalSource
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Taxonomy import NaturalSource as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNaturalSource:
         value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('naturalSource')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNaturalSource:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNaturalSource:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNaturalSource:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNaturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molecules')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setNaturalSource:
         Read link 'naturalSource' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molecules')
      newSelves.add(self)

    dataDict['naturalSource'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNaturalSource')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqDetails(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.seqDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSeqDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setSeqDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSeqDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('seqDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['seqDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSmiles(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.smiles
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSmiles:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('smiles')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSmiles:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSmiles:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['smiles'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSmiles')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSmilesType(self, value):
    """
    Set for ccp.molecule.Molecule.Molecule.smilesType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in ['stereo', 'nonstereo'])):
        raise ApiError("""%s.setSmilesType:
         ccp.molecule.Molecule.SmilesType input is not in enumeration ['stereo', 'nonstereo']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setSmilesType:
         SmilesType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('smilesType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSmilesType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSmilesType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['smilesType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSmilesType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAlignments(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.alignments
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('alignments')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChains(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.chains
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('chains')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedCitations(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.citations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    ll = dataDict.get('citations')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedEntryMolecules(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.entryMolecules
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('entryMolecules')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolComponents(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.molComponents
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molComponents')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolResLinks(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.molResLinks
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molResLinks')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolResidues(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.molResidues
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molResidues')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolSeqFragments(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.molSeqFragments
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molSeqFragments')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMoleculeSysNames(self):
    """
    Sorted for ccp.molecule.Molecule.Molecule.moleculeSysNames
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('moleculeSysNames')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  calcIsoelectricPoint = property(getCalcIsoelectricPoint, setCalcIsoelectricPoint, None,
  r"""Calculated isoelectric point of molecule. The pI indicates the value of 
  pH at which the net charge of the molecule would be neutralized, if the 
  molecule would have a conformation with each amino acid fully exposed to 
  the solvent. NB This is derived information, this should be moved when 
  this gets developed.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  commonNames = property(getCommonNames, setCommonNames, None,
  r"""List of molecule common names.
  """)

  createdBy = memops.api.Implementation.TopObject.createdBy
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)
  
  empiricalFormula = property(getEmpiricalFormula, None, None,
  r"""Empirical formula for molecule.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  formalCharge = property(getFormalCharge, None, None,
  r"""Formal charge of molecule.
  """)
  
  fragmentDetails = property(getFragmentDetails, setFragmentDetails, None,
  r"""Details on what (if anything) this Molecule is a fragment of).
  """)
  
  functions = property(getFunctions, setFunctions, None,
  r"""Keywords describing functions for molecule. e.g. 'enzyme', 'structure', 
  ...
  """)

  guid = memops.api.Implementation.TopObject.guid
  
  hasNonStdChemComp = property(getHasNonStdChemComp, None, None,
  r"""Does molecule contain non-standard ChemComp? Note that this will be true 
  whenever the molecule does not consist entirely of StdChemComps. Since 
  only molTypes protein, DNA, and RNA have any StdChemComps at all, this 
  attribute will be True but meaningless for any Molecule that contains 
  ChemComps of other types.
  """)
  
  hasNonStdChirality = property(getHasNonStdChirality, None, None,
  r"""Does molecule contain ChemComp of non-standard chirality? Note that this 
  will be true also when the Molecule contains a ChemComp where no 
  StdChirality is defined.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  isAromatic = property(getIsAromatic, None, None,
  r"""Does molecule contain aromatic groups?
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isFinalised = property(getIsFinalised, setIsFinalised, None,
  r"""Non-finalised molecules may not have links to Samples etc.
  Finalised 
  molecules can no longer have residues added or removed.
  Note that you 
  can add MolResidues to non-finalised molecules even if they already have 
  chains, but that you must make sure of adding new MolSystem.Residues as 
  necessary.
  """)

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified
  
  isParamagnetic = property(getIsParamagnetic, None, None,
  r"""Does Molecule contain paramagnetic groups?
  """)

  isReading = memops.api.Implementation.TopObject.isReading
  
  isStdCyclic = property(getIsStdCyclic, None, None,
  r"""Is Molecule a Std Cyclic polymer, i.e. a Std Linear polymer with a 
  polymer-type link between the last and the first residue?
  """)
  
  isStdLinear = property(getIsStdLinear, None, None,
  r"""Is the molecule a standard linear polymer? A linear polymer must contain 
  a linear sequence where MolResidues with successive serials are linked 
  by linear polymer type links  (linkCodes 'next' and 'prev'). 
  
  Linear 
  polymers may be heavily crosslinked but all the sequential links must be 
  present and of  the correct type. The component MolResidues may be of 
  any type or a mixture of types (peptide, nucleotide, styrene monomers, 
  ...) provided the 'next' and/or 'prev' links are present.
  The following 
  are not linear polymers:
  - A strand of DNA with a break in the middle of 
  the sequence numbering, even if the strand is circular.
  - A protein with 
  one peptide bond replaced by a bond going through an Aspartate side 
  chain COOH. 
  - A glycoprotein. 
  - A linear polysaccharide.
  """)
  
  keywords = property(getKeywords, setKeywords, None,
  r"""Keywords for searching molecule. e.g. 'DNA binding', 'receptor', 'Zinc 
  finger'...
  """)

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy
  
  longName = property(getLongName, setLongName, None,
  r"""Long form of molecule name.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, None, None,
  r"""molType of ChemComps making up Molecule. Possible values: 'protein', 
  'DNA', 'RNA', 'DNA/RNA', 'other'. The values are returned if *all* 
  ChemComps are of the correct molType(s). 'other' is returned if the 
  Molecule contains neither protein, not DNA, nor RNA ChemComps. If the 
  Molecule contains a mixture of molTypes (except for DNA/RNA) the value 
  is None (not set). 
  
  Note that the molType says nothing about how the 
  ChemComps are linked, and that e.g. a Molecule of molType 'protein' need 
  not contain a single peptide bond. If e.g. molType is 'protein' and 
  isStdLinear' is True, on the other hand, the Molecule is a single 
  unbroken polypeptide (which may or may not contain crosslinks).
  """)
  
  molecularMass = property(getMolecularMass, None, None,
  r"""Molecular mass, in atomic units. This is the sum of the atomic weights 
  of the atoms that form this molecule.
  """)
  
  mutationDetails = property(getMutationDetails, setMutationDetails, None,
  r"""Details on mutations in the sequence (e.g. this is A54K relative to the 
  wildtype).
  """)
  
  name = property(getName, setName, None,
  r"""Name of Molecule. Used as key. Should be correct and informative, but 
  may be an abbreviation or an acronym if the alternative is too long. 
  Recommended e.g. NaCl, Lysozyme, Lac headpiece, morphine.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  seqDetails = property(getSeqDetails, setSeqDetails, None,
  r"""Details, notes, comments etc. about the sequence.
  """)
  
  seqLength = property(getSeqLength, None, None,
  r"""Number of MolResidues in Molecule. For linear polymers equal to sequence 
  length.
  """)
  
  seqString = property(getSeqString, None, None,
  r"""String holding sequence one-letter-codes with '*' for non-standard 
  residues. The attribute is always defined, but is equal to the empty 
  string except for linear polymers of defined molType. Note that 
  one-letter codes are only defined for std ChemComps, which are only 
  found for peptides and nucleotides, so the value for linear polymers of 
  type 'other' is likely to be meaningless. 
  """)
  
  smiles = property(getSmiles, setSmiles, None,
  r"""SMILES (Simplified Molecular Input Line Entry Specification) string 
  describing molecule. 
  """)
  
  smilesType = property(getSmilesType, setSmilesType, None,
  r"""Type of Smiles string in smiles attribute
  """)
  
  stdSeqString = property(getStdSeqString, None, None,
  r"""String holding sequence one-letter-codes with non-standard ChemComps 
  replaced by one-letter-code of corresponding standard derivative, or by 
  '*' if there is no standard derivative.
   The attribute is always 
  defined, but is equal to the empty string except for linear polymers of 
  defined molType. Note that one-letter codes are only defined for std 
  ChemComps, which are only found for peptides and nucleotides, so the 
  value for linear polymers of type 'other' is likely to be meaningless. 
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  alignments = property(getAlignments,  None, None,
  r"""child link to class Alignment
  """)
  
  chains = property(getChains, setChains, None,
  r"""MolSystem Chains corresponding to Molecule
  """)
  
  citations = property(getCitations, setCitations, None,
  r"""Citations describing molecule.
  """)
  
  entryMolecules = property(getEntryMolecules, setEntryMolecules, None,
  r"""Connection to NmrEntries that reference this Molecule
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  molComponents = property(getMolComponents, setMolComponents, None,
  r"""The list of MolComponent associated to a particular Molecule.
  """)
  
  molResLinks = property(getMolResLinks,  None, None,
  r"""child link to class MolResLink
  """)
  
  molResidues = property(getMolResidues,  None, None,
  r"""child link to class MolResidue
  """)
  
  molSeqFragments = property(getMolSeqFragments,  None, None,
  r"""child link to class MolSeqFragment
  """)
  
  moleculeSysNames = property(getMoleculeSysNames,  None, None,
  r"""child link to class MoleculeSysName
  """)
  
  naturalSource = property(getNaturalSource, setNaturalSource, None,
  r"""Natural source for molecule
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MoleculeSysName(memops.api.Implementation.DataObject):
  r"""Molecule systematic name in a given naming system.
  """
  #   from data model element ccp.molecule.Molecule.MoleculeSysName revision ?
  _metaclass = metaPackage.getElement('MoleculeSysName')
  _packageName = 'ccp.molecule.Molecule'
  _packageShortName = 'MOLE'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'namingSystem', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'molecule', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    dataDict['molecule'] = parent
    if (not isinstance(parent, Molecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['namingSystem'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.Molecule.MoleculeSysName.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('moleculeSysNames')
        objKey = dataDict.get('namingSystem')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['namingSystem'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.Molecule.MoleculeSysName:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.Molecule.MoleculeSysName:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molecule = dataDict.get('molecule')
    if (not (molecule in objsToBeDeleted)):
      objKey = dataDict.get('namingSystem')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molecule.__dict__.get('moleculeSysNames')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('namingSystem')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molecule')
        dd = value.__dict__.get('moleculeSysNames')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('namingSystem')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: namingSystem:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: namingSystem:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: namingSystem:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: namingSystem:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molecule')
      if (not isinstance(value, Molecule)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    value = dataDict.get('namingSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: namingSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('molecule')
    if (value is None):
      raise ApiError("""%s.checkValid: molecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.Molecule.MoleculeSysName
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MoleculeSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('molecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.Molecule')
        obj1 = obj0.__dict__.get('molecules').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.Molecule.MoleculeSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('moleculeSysNames').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('molecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('namingSystem'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolecule(self):
    """
    Get for ccp.molecule.Molecule.MoleculeSysName.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.Molecule.MoleculeSysName.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNamingSystem(self):
    """
    Get for ccp.molecule.Molecule.MoleculeSysName.namingSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.Molecule.MoleculeSysName.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.Molecule.MoleculeSysName
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setName(self, value):
    """
    Set for ccp.molecule.Molecule.MoleculeSysName.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNamingSystem(self, value):
    """
    Set for ccp.molecule.Molecule.MoleculeSysName.namingSystem
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setNamingSystem:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setNamingSystem:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setNamingSystem:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setNamingSystem:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('namingSystem')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNamingSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setNamingSystem:
         cannot set namingSystem, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setNamingSystem:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['namingSystem'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Molecule systematic name.
  """)
  
  namingSystem = property(getNamingSystem, setNamingSystem, None,
  r"""Naming system used for name.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  molecule = property(getMolecule,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molecule
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
