"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Thu Oct  2 16:10:15 2014
  from data model element ccp.general.Citation revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Citation.py: python API for CCPN data model, MetaPackage ccp.general.Citation

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Affiliation
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.general.Citation')

###############################################################################
class Citation(memops.api.Implementation.DataObject):
  r"""Citation (litterature reference).
  """
  #   from data model element ccp.general.Citation.Citation revision ?
  _metaclass = metaPackage.getElement('Citation')
  _packageName = 'ccp.general.Citation'
  _packageShortName = 'CITA'
  _fieldNames = ('applicationData', 'casAbstractCode', 'className', 'details', 'doi', 'fieldNames', 'firstPage', 'inConstructor', 'isDeleted', 'keywords', 'lastPage', 'medlineUiCode', 'metaclass', 'packageName', 'packageShortName', 'pubMedId', 'qualifiedName', 'serial', 'status', 'title', 'year', 'access', 'activeAccess', 'authors', 'citationStore', 'dataLists', 'editors', 'experiments', 'methods', 'molSystems', 'molecules', 'nmrEntries', 'nmrEntriesPrimary', 'nmrProbes', 'nmrSpectrometers', 'parent', 'protocols', 'ratioShiftReferences', 'root', 'sampleConditionSets', 'shiftReferences', 'software', 'targetGroups', 'targets', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAuthor(self, value):
    """
    Add for ccp.general.Citation.Citation.authors
    """
    dataDict = self.__dict__
    from ccp.api.general.Affiliation import Person as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addAuthor:
       value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('authors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAuthor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAuthor:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAuthor:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAuthor:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAuthor:
           Link authors between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('authorCitations')
    oldSelves.add(self)
    currentValues.append(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAuthor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addEditor(self, value):
    """
    Add for ccp.general.Citation.Citation.editors
    """
    dataDict = self.__dict__
    from ccp.api.general.Affiliation import Person as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addEditor:
       value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('editors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addEditor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addEditor:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addEditor:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addEditor:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addEditor:
           Link editors between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('editorCitations')
    oldSelves.add(self)
    currentValues.append(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addEditor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addKeyword(self, value):
    """
    Add for ccp.general.Citation.Citation.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolSystem(self, value):
    """
    Add for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import MolSystem as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolSystem:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolSystem:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolSystem:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolSystem:
           Link molSystems between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('citations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addNmrEntry(self, value):
    """
    Add for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addNmrEntry:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrEntries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNmrEntry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNmrEntry:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNmrEntry:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addNmrEntry:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNmrEntry:
           Link nmrEntries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('otherCitations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNmrEntry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addNmrEntryPrimary(self, value):
    """
    Add for ccp.general.Citation.Citation.nmrEntriesPrimary
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addNmrEntryPrimary:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrEntriesPrimary')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('primaryCitation')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNmrEntryPrimary:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNmrEntryPrimary:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNmrEntryPrimary:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addNmrEntryPrimary:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNmrEntryPrimary:
           Link nmrEntriesPrimary between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('primaryCitation')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('nmrEntriesPrimary')
      siblingValues.remove(value)

    value.__dict__['primaryCitation'] = self
    currentValues.append(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNmrEntryPrimary')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addProtocol(self, value):
    """
    Add for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    from ccp.api.lims.Protocol import Protocol as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addProtocol:
       value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('protocols')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addProtocol:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addProtocol:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addProtocol:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addProtocol:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addProtocol:
           Link protocols between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('references')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addProtocol')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addShiftReference(self, value):
    """
    Add for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ShiftReference as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addShiftReference:
       value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('shiftReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('citation')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addShiftReference:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addShiftReference:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addShiftReference:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addShiftReference:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addShiftReference:
           Link shiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('citation')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('shiftReferences')
      siblingValues.remove(value)

    value.__dict__['citation'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addShiftReference')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addTarget(self, value):
    """
    Add for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Target as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addTarget:
       value is not of class ccp.lims.Target.Target""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('targets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addTarget:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addTarget:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addTarget:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addTarget:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addTarget:
           Link targets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('citations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addTarget')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addTargetGroup(self, value):
    """
    Add for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import TargetGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addTargetGroup:
       value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('targetGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addTargetGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addTargetGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addTargetGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addTargetGroup:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addTargetGroup:
           Link targetGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('citations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addTargetGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAuthors(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.authors
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('authors')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('authors')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('familyName', 'familyTitle', 'givenName', 'serial', 'title', 'access', 'affiliationStore', 'currentPersonInGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result
  
  def findAllDataLists(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.dataLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dataLists')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dataLists')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('definition', 'details', 'name', 'serial', 'sf', 'unit', 'access', 'method', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllEditors(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.editors
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('editors')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('editors')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('familyName', 'familyTitle', 'givenName', 'serial', 'title', 'access', 'affiliationStore', 'currentPersonInGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result
  
  def findAllExperiments(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.experiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMethods(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.methods
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('methods')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('methods')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'procedure', 'serial', 'task', 'access', 'instrument', 'methodStore', 'software',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystems(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystems')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystems')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'details', 'guid', 'hasChemExchange', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolecules(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.molecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molecules')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molecules')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('calcIsoelectricPoint', 'createdBy', 'details', 'fragmentDetails', 'guid', 'isFinalised', 'isModifiable', 'lastUnlockedBy', 'longName', 'mutationDetails', 'name', 'seqDetails', 'smiles', 'smilesType', 'access', 'memopsRoot', 'naturalSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrEntries(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntries')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntries')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrEntriesPrimary(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.nmrEntriesPrimary
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntriesPrimary')
      result = list(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntriesPrimary')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result
  
  def findAllNmrProbes(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.nmrProbes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrProbes')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrProbes')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'diameter', 'instrumentType', 'model', 'name', 'probeType', 'serial', 'serialNumber', 'access', 'contactPerson', 'instrumentStore', 'manufacturer',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrSpectrometers(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.nmrSpectrometers
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrSpectrometers')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrSpectrometers')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'instrumentType', 'model', 'name', 'nominalFreq', 'protonFreq', 'serial', 'serialNumber', 'access', 'contactPerson', 'instrumentStore', 'manufacturer',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllProtocols(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protocols')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protocols')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('creationDate', 'details', 'lastEditedDate', 'name', 'objective', 'serial', 'access', 'creator', 'experimentType', 'lastEditor', 'protocolStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRatioShiftReferences(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.ratioShiftReferences
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('ratioShiftReferences')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('ratioShiftReferences')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomGroup', 'indirectShiftRatio', 'isotopeCode', 'molName', 'referenceType', 'serial', 'unit', 'value', 'access', 'citation', 'nmrProject', 'shiftRatioCitation',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSampleConditionSets(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.sampleConditionSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('sampleConditionSets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('sampleConditionSets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'serial', 'access', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllShiftReferences(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('shiftReferences')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('shiftReferences')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomGroup', 'indirectShiftRatio', 'isotopeCode', 'molName', 'referenceType', 'serial', 'unit', 'value', 'access', 'citation', 'nmrProject', 'shiftRatioCitation',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSoftware(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.software
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('software')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('software')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'vendorAddress', 'vendorName', 'vendorWebAddress', 'version', 'access', 'methodStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllTargetGroups(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targetGroups')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targetGroups')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('completeName', 'details', 'groupingType', 'namingSystem', 'shortName', 'access', 'targetGroup', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllTargets(self, **conditions):
    """
    FindAll for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAuthor(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.authors
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('authors')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('authors')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('familyName', 'familyTitle', 'givenName', 'serial', 'title', 'access', 'affiliationStore', 'currentPersonInGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstDataList(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.dataLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dataLists')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dataLists')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('definition', 'details', 'name', 'serial', 'sf', 'unit', 'access', 'method', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstEditor(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.editors
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('editors')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('editors')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('familyName', 'familyTitle', 'givenName', 'serial', 'title', 'access', 'affiliationStore', 'currentPersonInGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstExperiment(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.experiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMethod(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.methods
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('methods')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('methods')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'procedure', 'serial', 'task', 'access', 'instrument', 'methodStore', 'software',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystem(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystems')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molSystems')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'details', 'guid', 'hasChemExchange', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolecule(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.molecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molecules')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molecules')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('calcIsoelectricPoint', 'createdBy', 'details', 'fragmentDetails', 'guid', 'isFinalised', 'isModifiable', 'lastUnlockedBy', 'longName', 'mutationDetails', 'name', 'seqDetails', 'smiles', 'smilesType', 'access', 'memopsRoot', 'naturalSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrEntry(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntries')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntries')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrEntryPrimary(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.nmrEntriesPrimary
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntriesPrimary')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrEntriesPrimary')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bmrbProcessing', 'details', 'entryType', 'experimentListDetails', 'name', 'title', 'access', 'molSystem', 'nmrEntryStore', 'primaryCitation', 'study',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrProbe(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.nmrProbes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrProbes')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrProbes')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'diameter', 'instrumentType', 'model', 'name', 'probeType', 'serial', 'serialNumber', 'access', 'contactPerson', 'instrumentStore', 'manufacturer',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrSpectrometer(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.nmrSpectrometers
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrSpectrometers')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrSpectrometers')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'instrumentType', 'model', 'name', 'nominalFreq', 'protonFreq', 'serial', 'serialNumber', 'access', 'contactPerson', 'instrumentStore', 'manufacturer',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstProtocol(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protocols')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protocols')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('creationDate', 'details', 'lastEditedDate', 'name', 'objective', 'serial', 'access', 'creator', 'experimentType', 'lastEditor', 'protocolStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRatioShiftReference(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.ratioShiftReferences
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('ratioShiftReferences')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('ratioShiftReferences')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomGroup', 'indirectShiftRatio', 'isotopeCode', 'molName', 'referenceType', 'serial', 'unit', 'value', 'access', 'citation', 'nmrProject', 'shiftRatioCitation',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSampleConditionSet(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.sampleConditionSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('sampleConditionSets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('sampleConditionSets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'serial', 'access', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstShiftReference(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('shiftReferences')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('shiftReferences')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomGroup', 'indirectShiftRatio', 'isotopeCode', 'molName', 'referenceType', 'serial', 'unit', 'value', 'access', 'citation', 'nmrProject', 'shiftRatioCitation',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSoftware(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.software
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('software')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('software')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'vendorAddress', 'vendorName', 'vendorWebAddress', 'version', 'access', 'methodStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstTarget(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstTargetGroup(self, **conditions):
    """
    FindFirst for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targetGroups')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('targetGroups')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('completeName', 'details', 'groupingType', 'namingSystem', 'shortName', 'access', 'targetGroup', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAuthors(self):
    """
    Get for ccp.general.Citation.Citation.authors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('authors')
    result = tuple(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Citation.Citation
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.Citation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('citationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Citation')
        obj1 = obj0.__dict__.get('citationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.Citation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('citations').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCasAbstractCode(self):
    """
    Get for ccp.general.Citation.Citation.casAbstractCode
    """
    dataDict = self.__dict__
    result = dataDict.get('casAbstractCode')
    return result
  
  def getCitationStore(self):
    """
    Get for ccp.general.Citation.Citation.citationStore
    """
    dataDict = self.__dict__
    result = dataDict.get('citationStore')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDataLists(self):
    """
    Get for ccp.general.Citation.Citation.dataLists
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('dataLists')
    result = frozenset(tempVar)
    return result
  
  def getDetails(self):
    """
    Get for ccp.general.Citation.Citation.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getDoi(self):
    """
    Get for ccp.general.Citation.Citation.doi
    """
    dataDict = self.__dict__
    result = dataDict.get('doi')
    return result
  
  def getEditors(self):
    """
    Get for ccp.general.Citation.Citation.editors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('editors')
    result = tuple(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getExperiments(self):
    """
    Get for ccp.general.Citation.Citation.experiments
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('experiments')
    result = frozenset(tempVar)
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFirstPage(self):
    """
    Get for ccp.general.Citation.Citation.firstPage
    """
    dataDict = self.__dict__
    result = dataDict.get('firstPage')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.Citation.Citation
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('citationStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getKeywords(self):
    """
    Get for ccp.general.Citation.Citation.keywords
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('keywords')
    result = tuple(tempVar)
    return result
  
  def getLastPage(self):
    """
    Get for ccp.general.Citation.Citation.lastPage
    """
    dataDict = self.__dict__
    result = dataDict.get('lastPage')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.Citation.Citation
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMedlineUiCode(self):
    """
    Get for ccp.general.Citation.Citation.medlineUiCode
    """
    dataDict = self.__dict__
    result = dataDict.get('medlineUiCode')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMethods(self):
    """
    Get for ccp.general.Citation.Citation.methods
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('methods')
    result = frozenset(tempVar)
    return result
  
  def getMolSystems(self):
    """
    Get for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molSystems')
    result = frozenset(tempVar)
    return result
  
  def getMolecules(self):
    """
    Get for ccp.general.Citation.Citation.molecules
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molecules')
    result = frozenset(tempVar)
    return result
  
  def getNmrEntries(self):
    """
    Get for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nmrEntries')
    result = frozenset(tempVar)
    return result
  
  def getNmrEntriesPrimary(self):
    """
    Get for ccp.general.Citation.Citation.nmrEntriesPrimary
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nmrEntriesPrimary')
    result = tuple(tempVar)
    return result
  
  def getNmrProbes(self):
    """
    Get for ccp.general.Citation.Citation.nmrProbes
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nmrProbes')
    result = frozenset(tempVar)
    return result
  
  def getNmrSpectrometers(self):
    """
    Get for ccp.general.Citation.Citation.nmrSpectrometers
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nmrSpectrometers')
    result = frozenset(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.Citation.Citation.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('citationStore')
    return result
  
  def getProtocols(self):
    """
    Get for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('protocols')
    result = frozenset(tempVar)
    return result
  
  def getPubMedId(self):
    """
    Get for ccp.general.Citation.Citation.pubMedId
    """
    dataDict = self.__dict__
    result = dataDict.get('pubMedId')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRatioShiftReferences(self):
    """
    Get for ccp.general.Citation.Citation.ratioShiftReferences
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('ratioShiftReferences')
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSampleConditionSets(self):
    """
    Get for ccp.general.Citation.Citation.sampleConditionSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('sampleConditionSets')
    result = frozenset(tempVar)
    return result
  
  def getSerial(self):
    """
    Get for ccp.general.Citation.Citation.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getShiftReferences(self):
    """
    Get for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('shiftReferences')
    result = frozenset(tempVar)
    return result
  
  def getSoftware(self):
    """
    Get for ccp.general.Citation.Citation.software
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('software')
    result = frozenset(tempVar)
    return result
  
  def getStatus(self):
    """
    Get for ccp.general.Citation.Citation.status
    """
    dataDict = self.__dict__
    result = dataDict.get('status')
    return result
  
  def getTargetGroups(self):
    """
    Get for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('targetGroups')
    result = frozenset(tempVar)
    return result
  
  def getTargets(self):
    """
    Get for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('targets')
    result = frozenset(tempVar)
    return result
  
  def getTitle(self):
    """
    Get for ccp.general.Citation.Citation.title
    """
    dataDict = self.__dict__
    result = dataDict.get('title')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getYear(self):
    """
    Get for ccp.general.Citation.Citation.year
    """
    dataDict = self.__dict__
    result = dataDict.get('year')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAuthor(self, value):
    """
    Remove for ccp.general.Citation.Citation.authors
    """
    dataDict = self.__dict__
    from ccp.api.general.Affiliation import Person as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeAuthor:
       value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('authors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAuthor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAuthor:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAuthor:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAuthor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('authorCitations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAuthor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeEditor(self, value):
    """
    Remove for ccp.general.Citation.Citation.editors
    """
    dataDict = self.__dict__
    from ccp.api.general.Affiliation import Person as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeEditor:
       value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('editors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeEditor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeEditor:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeEditor:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeEditor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('editorCitations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeEditor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeKeyword(self, value):
    """
    Remove for ccp.general.Citation.Citation.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeKeyword:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolSystem(self, value):
    """
    Remove for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import MolSystem as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolSystem:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolSystem:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolSystem:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('citations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeNmrEntry(self, value):
    """
    Remove for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeNmrEntry:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrEntries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNmrEntry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNmrEntry:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNmrEntry:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNmrEntry:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('otherCitations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNmrEntry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeNmrEntryPrimary(self, value):
    """
    Remove for ccp.general.Citation.Citation.nmrEntriesPrimary
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrEntry import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeNmrEntryPrimary:
       value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrEntriesPrimary')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNmrEntryPrimary:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNmrEntryPrimary:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNmrEntryPrimary:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNmrEntryPrimary:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['primaryCitation'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNmrEntryPrimary')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeProtocol(self, value):
    """
    Remove for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    from ccp.api.lims.Protocol import Protocol as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeProtocol:
       value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('protocols')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeProtocol:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeProtocol:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeProtocol:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeProtocol:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('references')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeProtocol')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeShiftReference(self, value):
    """
    Remove for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ShiftReference as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeShiftReference:
       value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('shiftReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeShiftReference:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeShiftReference:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeShiftReference:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeShiftReference:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['citation'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeShiftReference')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeTarget(self, value):
    """
    Remove for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Target as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeTarget:
       value is not of class ccp.lims.Target.Target""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('targets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeTarget:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeTarget:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeTarget:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeTarget:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('citations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeTarget')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeTargetGroup(self, value):
    """
    Remove for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import TargetGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeTargetGroup:
       value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('targetGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeTargetGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeTargetGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeTargetGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeTargetGroup:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('citations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeTargetGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAuthors(self, values):
    """
    Set for ccp.general.Citation.Citation.authors
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAuthors:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Affiliation import Person as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAuthors:
         value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('authors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAuthors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAuthors:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAuthors:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAuthors:
           Link authors between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('authorCitations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('authorCitations')
        oldSelves.add(self)

    dataDict['authors'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAuthors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCasAbstractCode(self, value):
    """
    Set for ccp.general.Citation.Citation.casAbstractCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCasAbstractCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCasAbstractCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCasAbstractCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCasAbstractCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('casAbstractCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCasAbstractCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCasAbstractCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['casAbstractCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCasAbstractCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDataLists(self, values):
    """
    Set for ccp.general.Citation.Citation.dataLists
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setDataLists:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import DataList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDataLists:
         value is not of class ccp.nmr.Nmr.DataList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('dataLists')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataLists:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataLists:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDataLists:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setDataLists:
           Link dataLists between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['dataLists'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataLists')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.general.Citation.Citation.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoi(self, value):
    """
    Set for ccp.general.Citation.Citation.doi
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDoi:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDoi:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDoi:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doi')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoi:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoi:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['doi'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoi')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEditors(self, values):
    """
    Set for ccp.general.Citation.Citation.editors
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setEditors:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Affiliation import Person as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setEditors:
         value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('editors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEditors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEditors:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setEditors:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setEditors:
           Link editors between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('editorCitations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('editorCitations')
        oldSelves.add(self)

    dataDict['editors'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEditors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setExperiments(self, values):
    """
    Set for ccp.general.Citation.Citation.experiments
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setExperiments:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import Experiment as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setExperiments:
         value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setExperiments:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setExperiments:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setExperiments:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setExperiments:
           Link experiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['experiments'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setExperiments')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFirstPage(self, value):
    """
    Set for ccp.general.Citation.Citation.firstPage
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFirstPage:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setFirstPage:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFirstPage:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFirstPage:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('firstPage')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFirstPage:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFirstPage:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['firstPage'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFirstPage')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setKeywords(self, values):
    """
    Set for ccp.general.Citation.Citation.keywords
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setKeywords:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setKeywords:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setKeywords:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['keywords'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setKeywords')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLastPage(self, value):
    """
    Set for ccp.general.Citation.Citation.lastPage
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setLastPage:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setLastPage:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setLastPage:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setLastPage:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('lastPage')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLastPage:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLastPage:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['lastPage'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLastPage')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMedlineUiCode(self, value):
    """
    Set for ccp.general.Citation.Citation.medlineUiCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMedlineUiCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setMedlineUiCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMedlineUiCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setMedlineUiCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('medlineUiCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMedlineUiCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMedlineUiCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['medlineUiCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMedlineUiCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMethods(self, values):
    """
    Set for ccp.general.Citation.Citation.methods
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMethods:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Method import Method as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMethods:
         value is not of class ccp.general.Method.Method""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('methods')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMethods:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMethods:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMethods:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMethods:
           Link methods between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['methods'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMethods')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSystems(self, values):
    """
    Set for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolSystems:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolSystem import MolSystem as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSystems:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystems:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystems:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystems:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolSystems:
           Link molSystems between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['molSystems'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystems')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolecules(self, values):
    """
    Set for ccp.general.Citation.Citation.molecules
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolecules:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.Molecule import Molecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolecules:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molecules')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolecules:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolecules:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolecules:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolecules:
           Link molecules between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['molecules'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolecules')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrEntries(self, values):
    """
    Set for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrEntries:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrEntry import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrEntries:
         value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrEntries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrEntries:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrEntries:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrEntries:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrEntries:
           Link nmrEntries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('otherCitations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('otherCitations')
        oldSelves.add(self)

    dataDict['nmrEntries'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrEntries')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrEntriesPrimary(self, values):
    """
    Set for ccp.general.Citation.Citation.nmrEntriesPrimary
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrEntriesPrimary:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrEntry import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrEntriesPrimary:
         value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrEntriesPrimary')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('primaryCitation')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setNmrEntriesPrimary:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrEntriesPrimary:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrEntriesPrimary:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrEntriesPrimary:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrEntriesPrimary:
           Link nmrEntriesPrimary between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['primaryCitation'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('primaryCitation')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('nmrEntriesPrimary')
          vv.remove(cv)

      cv.__dict__['primaryCitation'] = self

    dataDict['nmrEntriesPrimary'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrEntriesPrimary')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrProbes(self, values):
    """
    Set for ccp.general.Citation.Citation.nmrProbes
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrProbes:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Instrument import NmrProbe as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrProbes:
         value is not of class ccp.general.Instrument.NmrProbe""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrProbes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrProbes:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrProbes:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrProbes:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrProbes:
           Link nmrProbes between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['nmrProbes'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrProbes')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrSpectrometers(self, values):
    """
    Set for ccp.general.Citation.Citation.nmrSpectrometers
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrSpectrometers:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Instrument import NmrSpectrometer as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrSpectrometers:
         value is not of class ccp.general.Instrument.NmrSpectrometer""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrSpectrometers')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrSpectrometers:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrSpectrometers:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrSpectrometers:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrSpectrometers:
           Link nmrSpectrometers between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['nmrSpectrometers'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrSpectrometers')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setProtocols(self, values):
    """
    Set for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setProtocols:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Protocol import Protocol as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setProtocols:
         value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('protocols')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setProtocols:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setProtocols:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setProtocols:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setProtocols:
           Link protocols between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('references')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('references')
        oldSelves.add(self)

    dataDict['protocols'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setProtocols')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPubMedId(self, value):
    """
    Set for ccp.general.Citation.Citation.pubMedId
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPubMedId:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setPubMedId:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPubMedId:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setPubMedId:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('pubMedId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPubMedId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPubMedId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['pubMedId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPubMedId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRatioShiftReferences(self, values):
    """
    Set for ccp.general.Citation.Citation.ratioShiftReferences
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRatioShiftReferences:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ShiftReference as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRatioShiftReferences:
         value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('ratioShiftReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('shiftRatioCitation')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setRatioShiftReferences:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRatioShiftReferences:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRatioShiftReferences:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRatioShiftReferences:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRatioShiftReferences:
           Link ratioShiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['shiftRatioCitation'] = self

    dataDict['ratioShiftReferences'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRatioShiftReferences')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSampleConditionSets(self, values):
    """
    Set for ccp.general.Citation.Citation.sampleConditionSets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSampleConditionSets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import SampleConditionSet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setSampleConditionSets:
         value is not of class ccp.nmr.Nmr.SampleConditionSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('sampleConditionSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSampleConditionSets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSampleConditionSets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSampleConditionSets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSampleConditionSets:
           Link sampleConditionSets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['sampleConditionSets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSampleConditionSets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.general.Citation.Citation.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('citationStore')
    oldSerial = parent.__dict__.get('_serialDict').get('citations')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['citations'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['citations'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setShiftReferences(self, values):
    """
    Set for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setShiftReferences:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ShiftReference as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setShiftReferences:
         value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('shiftReferences')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('citation')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setShiftReferences:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setShiftReferences:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShiftReferences:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setShiftReferences:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setShiftReferences:
           Link shiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['citation'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('citation')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('shiftReferences')
          vv.remove(cv)

      cv.__dict__['citation'] = self

    dataDict['shiftReferences'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setShiftReferences')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSoftware(self, values):
    """
    Set for ccp.general.Citation.Citation.software
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSoftware:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.general.Method import Software as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setSoftware:
         value is not of class ccp.general.Method.Software""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('software')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSoftware:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSoftware:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSoftware:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSoftware:
           Link software between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['software'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSoftware')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStatus(self, value):
    """
    Set for ccp.general.Citation.Citation.status
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStatus:
         ccp.general.Citation.CitationStatus input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setStatus:
         ccp.general.Citation.CitationStatus maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setStatus:
         ccp.general.Citation.CitationStatus: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setStatus:
         CitationStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('status')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStatus:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStatus:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['status'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStatus')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTargetGroups(self, values):
    """
    Set for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setTargetGroups:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import TargetGroup as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setTargetGroups:
         value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('targetGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTargetGroups:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTargetGroups:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setTargetGroups:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setTargetGroups:
           Link targetGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['targetGroups'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTargetGroups')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTargets(self, values):
    """
    Set for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setTargets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import Target as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setTargets:
         value is not of class ccp.lims.Target.Target""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('targets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTargets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTargets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setTargets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setTargets:
           Link targets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('citations')
        oldSelves.add(self)

    dataDict['targets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTargets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTitle(self, value):
    """
    Set for ccp.general.Citation.Citation.title
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setTitle:
         memops.Implementation.SingleLine input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setTitle:
         SingleLine constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('title')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTitle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTitle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['title'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTitle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setYear(self, value):
    """
    Set for ccp.general.Citation.Citation.year
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setYear:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('year')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setYear:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setYear:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['year'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setYear')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedDataLists(self):
    """
    Sorted for ccp.general.Citation.Citation.dataLists
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('dataLists')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedExperiments(self):
    """
    Sorted for ccp.general.Citation.Citation.experiments
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('experiments')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMethods(self):
    """
    Sorted for ccp.general.Citation.Citation.methods
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('methods')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolSystems(self):
    """
    Sorted for ccp.general.Citation.Citation.molSystems
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molSystems')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolecules(self):
    """
    Sorted for ccp.general.Citation.Citation.molecules
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molecules')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNmrEntries(self):
    """
    Sorted for ccp.general.Citation.Citation.nmrEntries
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('nmrEntries')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNmrProbes(self):
    """
    Sorted for ccp.general.Citation.Citation.nmrProbes
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('nmrProbes')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNmrSpectrometers(self):
    """
    Sorted for ccp.general.Citation.Citation.nmrSpectrometers
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('nmrSpectrometers')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedProtocols(self):
    """
    Sorted for ccp.general.Citation.Citation.protocols
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('protocols')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRatioShiftReferences(self):
    """
    Sorted for ccp.general.Citation.Citation.ratioShiftReferences
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('ratioShiftReferences')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSampleConditionSets(self):
    """
    Sorted for ccp.general.Citation.Citation.sampleConditionSets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('sampleConditionSets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedShiftReferences(self):
    """
    Sorted for ccp.general.Citation.Citation.shiftReferences
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('shiftReferences')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSoftware(self):
    """
    Sorted for ccp.general.Citation.Citation.software
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('software')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedTargetGroups(self):
    """
    Sorted for ccp.general.Citation.Citation.targetGroups
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('targetGroups')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedTargets(self):
    """
    Sorted for ccp.general.Citation.Citation.targets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('targets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  casAbstractCode = property(getCasAbstractCode, setCasAbstractCode, None,
  r"""Chemical Abstracts abstracting service (CAS) code
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)
  
  doi = property(getDoi, setDoi, None,
  r"""DOI identifier of citation
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  firstPage = property(getFirstPage, setFirstPage, None,
  r"""First page number (not an integer, as it might be e.g. '235A')
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  keywords = property(getKeywords, setKeywords, None,
  r"""Keywords characterising Citation
  """)
  
  lastPage = property(getLastPage, setLastPage, None,
  r"""Last page number (not an integer, as it might be e.g. '238A')
  """)
  
  medlineUiCode = property(getMedlineUiCode, setMedlineUiCode, None,
  r"""Medline UI index code
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  pubMedId = property(getPubMedId, setPubMedId, None,
  r"""pubMed ID
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  status = property(getStatus, setStatus, None,
  r"""E.g. 'published', 'in press','to be published' ?
  """)
  
  title = property(getTitle, setTitle, None,
  r"""Citation (article) Title
  """)
  
  year = property(getYear, setYear, None,
  r"""Year of publication
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  authors = property(getAuthors, setAuthors, None,
  r"""Authors of Citation
  """)
  
  citationStore = property(getCitationStore,  None, None,
  r"""parent link
  """)
  
  dataLists = property(getDataLists, setDataLists, None,
  r"""Nmr Generic Measurement Lists citing Citation.
  """)
  
  editors = property(getEditors, setEditors, None,
  r"""People who are editors of Citation
  """)
  
  experiments = property(getExperiments, setExperiments, None,
  r"""Nmr Experiments referring to Citation
  """)
  
  methods = property(getMethods, setMethods, None,
  r"""Methods described by Citation
  """)
  
  molSystems = property(getMolSystems, setMolSystems, None,
  r"""MolSystems described by Citation
  """)
  
  molecules = property(getMolecules, setMolecules, None,
  r"""Molecules described by Citation
  """)
  
  nmrEntries = property(getNmrEntries, setNmrEntries, None,
  r"""BioMagResBank entries that cite Citatoin as non-primary reference
  """)
  
  nmrEntriesPrimary = property(getNmrEntriesPrimary, setNmrEntriesPrimary, None,
  r"""NMR entries that have this as their primary citation
  """)
  
  nmrProbes = property(getNmrProbes, setNmrProbes, None,
  r"""Nmr probes that use this Citation
  """)
  
  nmrSpectrometers = property(getNmrSpectrometers, setNmrSpectrometers, None,
  r"""Nmr Spectrometers citing this Citation
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for citationStore
  """)
  
  protocols = property(getProtocols, setProtocols, None,
  r"""Protocol where Citation refers to.
  """)
  
  ratioShiftReferences = property(getRatioShiftReferences, setRatioShiftReferences, None,
  r"""Shift reference indirect shift ratio references.
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  sampleConditionSets = property(getSampleConditionSets, setSampleConditionSets, None,
  r"""SampleConditionSets quoting Citation
  """)
  
  shiftReferences = property(getShiftReferences, setShiftReferences, None,
  r"""Shift References citing CItation.
  """)
  
  software = property(getSoftware, setSoftware, None,
  r"""Software described by Citation
  """)
  
  targetGroups = property(getTargetGroups, setTargetGroups, None,
  r"""
  """)
  
  targets = property(getTargets, setTargets, None,
  r"""Targets described by Citation.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class CitationStore(memops.api.Implementation.TopObject):
  r"""Grouping of Citations
  """
  #   from data model element ccp.general.Citation.CitationStore revision ?
  _metaclass = metaPackage.getElement('CitationStore')
  _packageName = 'ccp.general.Citation'
  _packageShortName = 'CITA'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'citations', 'memopsRoot', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.general.Citation')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['citations'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Citation.CitationStore.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['citations'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('citationStores')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentCitationStore') is None)):
        root.__dict__['currentCitationStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Citation.CitationStore:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    citations = dataDict.get('citations').values()
    for citation in citations:
      if (not (citation in objsToBeDeleted)):
        objsToBeDeleted.add(citation)
        objsToBeChecked.append(citation)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Citation.CitationStore:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentCitationStore')):
      memopsRoot.__dict__['currentCitationStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('citationStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['citations'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('citations').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('citationStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('citations').values()
      for value in values:
        if (not isinstance(value, Citation)):
          raise ApiError("""%s.checkValid: citations:
           value is not of class ccp.general.Citation.Citation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('citationStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: citations:
           non-reciprocal link citations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('citations').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllCitations(self, **conditions):
    """
    FindAll for ccp.general.Citation.CitationStore.citations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casAbstractCode', 'details', 'doi', 'firstPage', 'lastPage', 'medlineUiCode', 'pubMedId', 'serial', 'status', 'title', 'year', 'access', 'citationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstCitation(self, **conditions):
    """
    FindFirst for ccp.general.Citation.CitationStore.citations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('citations').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('citations').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('citations').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casAbstractCode', 'details', 'doi', 'firstPage', 'lastPage', 'medlineUiCode', 'pubMedId', 'serial', 'status', 'title', 'year', 'access', 'citationStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Citation.CitationStore
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.general.Citation.CitationStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('citationStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.general.Citation')
      obj1 = startObj.__dict__.get('citationStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCitations(self):
    """
    Get for ccp.general.Citation.CitationStore.citations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('citations').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.general.Citation.CitationStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.general.Citation.CitationStore.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.Citation.CitationStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newBookCitation(self, **attrlinks):
    """
    Factory function to create ccp.general.Citation.BookCitation
    """
    return BookCitation(self, **attrlinks)
  
  def newConferenceCitation(self, **attrlinks):
    """
    Factory function to create ccp.general.Citation.ConferenceCitation
    """
    return ConferenceCitation(self, **attrlinks)
  
  def newJournalCitation(self, **attrlinks):
    """
    Factory function to create ccp.general.Citation.JournalCitation
    """
    return JournalCitation(self, **attrlinks)
  
  def newThesisCitation(self, **attrlinks):
    """
    Factory function to create ccp.general.Citation.ThesisCitation
    """
    return ThesisCitation(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Citation.CitationStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for ccp.general.Citation.CitationStore.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def sortedCitations(self):
    """
    Sorted for ccp.general.Citation.CitationStore.citations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('citations')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of CitationGroup
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  citations = property(getCitations,  None, None,
  r"""child link to class Citation
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class JournalCitation(Citation):
  r"""Citation (litterature reference) to Journal article
  """
  #   from data model element ccp.general.Citation.JournalCitation revision ?
  _metaclass = metaPackage.getElement('JournalCitation')
  _packageName = 'ccp.general.Citation'
  _packageShortName = 'CITA'
  _fieldNames = ('applicationData', 'astm', 'casAbstractCode', 'className', 'csd', 'details', 'doi', 'fieldNames', 'firstPage', 'inConstructor', 'isDeleted', 'issn', 'issue', 'journalAbbreviation', 'journalFullName', 'keywords', 'lastPage', 'medlineUiCode', 'metaclass', 'packageName', 'packageShortName', 'pubMedId', 'qualifiedName', 'serial', 'status', 'title', 'volume', 'year', 'access', 'activeAccess', 'authors', 'citationStore', 'dataLists', 'editors', 'experiments', 'methods', 'molSystems', 'molecules', 'nmrEntries', 'nmrEntriesPrimary', 'nmrProbes', 'nmrSpectrometers', 'parent', 'protocols', 'ratioShiftReferences', 'root', 'sampleConditionSets', 'shiftReferences', 'software', 'targetGroups', 'targets', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Citation.JournalCitation
    """
    dataDict = self.__dict__
    dataDict['citationStore'] = parent
    if (not isinstance(parent, CitationStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['astm'] = None
      dataDict['casAbstractCode'] = None
      dataDict['csd'] = None
      dataDict['details'] = None
      dataDict['doi'] = None
      dataDict['firstPage'] = None
      dataDict['issn'] = None
      dataDict['issue'] = None
      dataDict['journalAbbreviation'] = None
      dataDict['journalFullName'] = None
      dataDict['keywords'] = list()
      dataDict['lastPage'] = None
      dataDict['medlineUiCode'] = None
      dataDict['pubMedId'] = None
      dataDict['serial'] = None
      dataDict['status'] = None
      dataDict['title'] = None
      dataDict['volume'] = None
      dataDict['year'] = None
      dataDict['access'] = None
      dataDict['authors'] = list()
      dataDict['dataLists'] = set()
      dataDict['editors'] = list()
      dataDict['experiments'] = set()
      dataDict['methods'] = set()
      dataDict['molSystems'] = set()
      dataDict['molecules'] = set()
      dataDict['nmrEntries'] = set()
      dataDict['nmrEntriesPrimary'] = list()
      dataDict['nmrProbes'] = set()
      dataDict['nmrSpectrometers'] = set()
      dataDict['protocols'] = set()
      dataDict['ratioShiftReferences'] = set()
      dataDict['sampleConditionSets'] = set()
      dataDict['shiftReferences'] = set()
      dataDict['software'] = set()
      dataDict['targetGroups'] = set()
      dataDict['targets'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Citation.JournalCitation.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.general.Citation.JournalCitation')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('citations')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Citation.JournalCitation:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    authors = dataDict.get('authors')
    pass
    for author in authors:
      topObject = author.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dataLists = dataDict.get('dataLists')
    for dataList in dataLists:
      if (not (dataList in objsToBeDeleted)):
        objsToBeDeleted.add(dataList)
        objsToBeChecked.append(dataList)

    for dataList in dataLists:
      topObject = dataList.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    editors = dataDict.get('editors')
    pass
    for editor in editors:
      topObject = editor.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    experiments = dataDict.get('experiments')
    for experiment in experiments:
      if (not (experiment in objsToBeDeleted)):
        objsToBeDeleted.add(experiment)
        objsToBeChecked.append(experiment)

    for experiment in experiments:
      topObject = experiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    methods = dataDict.get('methods')
    for method in methods:
      if (not (method in objsToBeDeleted)):
        objsToBeDeleted.add(method)
        objsToBeChecked.append(method)

    for method in methods:
      topObject = method.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSystems = dataDict.get('molSystems')
    pass
    for molSystem in molSystems:
      topObject = molSystem.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molecules = dataDict.get('molecules')
    for molecule in molecules:
      if (not (molecule in objsToBeDeleted)):
        objsToBeDeleted.add(molecule)
        objsToBeChecked.append(molecule)

    for molecule in molecules:
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntries = dataDict.get('nmrEntries')
    pass
    for nmrEntry in nmrEntries:
      topObject = nmrEntry.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntriesPrimary = dataDict.get('nmrEntriesPrimary')
    pass
    for nmrEntryPrimary in nmrEntriesPrimary:
      topObject = nmrEntryPrimary.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrProbes = dataDict.get('nmrProbes')
    for nmrProbe in nmrProbes:
      if (not (nmrProbe in objsToBeDeleted)):
        objsToBeDeleted.add(nmrProbe)
        objsToBeChecked.append(nmrProbe)

    for nmrProbe in nmrProbes:
      topObject = nmrProbe.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrSpectrometers = dataDict.get('nmrSpectrometers')
    for nmrSpectrometer in nmrSpectrometers:
      if (not (nmrSpectrometer in objsToBeDeleted)):
        objsToBeDeleted.add(nmrSpectrometer)
        objsToBeChecked.append(nmrSpectrometer)

    for nmrSpectrometer in nmrSpectrometers:
      topObject = nmrSpectrometer.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protocols = dataDict.get('protocols')
    pass
    for protocol in protocols:
      topObject = protocol.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ratioShiftReferences = dataDict.get('ratioShiftReferences')
    for ratioShiftReference in ratioShiftReferences:
      if (not (ratioShiftReference in objsToBeDeleted)):
        objsToBeDeleted.add(ratioShiftReference)
        objsToBeChecked.append(ratioShiftReference)

    for ratioShiftReference in ratioShiftReferences:
      topObject = ratioShiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    sampleConditionSets = dataDict.get('sampleConditionSets')
    for sampleConditionSet in sampleConditionSets:
      if (not (sampleConditionSet in objsToBeDeleted)):
        objsToBeDeleted.add(sampleConditionSet)
        objsToBeChecked.append(sampleConditionSet)

    for sampleConditionSet in sampleConditionSets:
      topObject = sampleConditionSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    shiftReferences = dataDict.get('shiftReferences')
    pass
    for shiftReference in shiftReferences:
      topObject = shiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    software_s = dataDict.get('software')
    for software in software_s:
      if (not (software in objsToBeDeleted)):
        objsToBeDeleted.add(software)
        objsToBeChecked.append(software)

    for software in software_s:
      topObject = software.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targetGroups = dataDict.get('targetGroups')
    pass
    for targetGroup in targetGroups:
      topObject = targetGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targets = dataDict.get('targets')
    pass
    for target in targets:
      topObject = target.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Citation.JournalCitation:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for author in dataDict.get('authors'):
      if (not (author in objsToBeDeleted)):
        authorCitations = author.__dict__.get('authorCitations')
        authorCitations.remove(self)

    for editor in dataDict.get('editors'):
      if (not (editor in objsToBeDeleted)):
        editorCitations = editor.__dict__.get('editorCitations')
        editorCitations.remove(self)

    for molSystem in dataDict.get('molSystems'):
      if (not (molSystem in objsToBeDeleted)):
        citations = molSystem.__dict__.get('citations')
        citations.remove(self)

    for nmrEntry in dataDict.get('nmrEntries'):
      if (not (nmrEntry in objsToBeDeleted)):
        otherCitations = nmrEntry.__dict__.get('otherCitations')
        otherCitations.remove(self)

    for nmrEntryPrimary in dataDict.get('nmrEntriesPrimary'):
      if (not (nmrEntryPrimary in objsToBeDeleted)):
        nmrEntryPrimary.__dict__['primaryCitation'] = None

    for protocol in dataDict.get('protocols'):
      if (not (protocol in objsToBeDeleted)):
        references = protocol.__dict__.get('references')
        references.remove(self)

    for shiftReference in dataDict.get('shiftReferences'):
      if (not (shiftReference in objsToBeDeleted)):
        shiftReference.__dict__['citation'] = None

    for targetGroup in dataDict.get('targetGroups'):
      if (not (targetGroup in objsToBeDeleted)):
        citations = targetGroup.__dict__.get('citations')
        citations.remove(self)

    for target in dataDict.get('targets'):
      if (not (target in objsToBeDeleted)):
        citations = target.__dict__.get('citations')
        citations.remove(self)

    citationStore = dataDict.get('citationStore')
    if (not (citationStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = citationStore.__dict__.get('citations')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addAuthor = Citation.addAuthor

  addEditor = Citation.addEditor

  addKeyword = Citation.addKeyword

  addMolSystem = Citation.addMolSystem

  addNmrEntry = Citation.addNmrEntry

  addNmrEntryPrimary = Citation.addNmrEntryPrimary

  addProtocol = Citation.addProtocol

  addShiftReference = Citation.addShiftReference

  addTarget = Citation.addTarget

  addTargetGroup = Citation.addTargetGroup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Citation.JournalCitation
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Citation.JournalCitation
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('citationStore')
        dd = value.__dict__.get('citations')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'citationStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('astm')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: astm:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: astm:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: astm:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: astm:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casAbstractCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: casAbstractCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('csd')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: csd:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: csd:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: csd:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: csd:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('doi')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('firstPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: firstPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('issn')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: issn:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: issn:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: issn:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: issn:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('issue')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: issue:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: issue:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: issue:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: issue:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('journalAbbreviation')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: journalAbbreviation:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: journalAbbreviation:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: journalAbbreviation:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: journalAbbreviation:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('journalFullName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: journalFullName:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: journalFullName:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: journalFullName:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: lastPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('medlineUiCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: medlineUiCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('pubMedId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: pubMedId:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('status')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: status:
           CitationStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('title')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.SingleLine input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: title:
           SingleLine constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('volume')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: volume:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: volume:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: volume:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: volume:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('year')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: year:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('authors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: authors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('authorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: authors:
           non-reciprocal link authors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('citationStore')
      if (not isinstance(value, CitationStore)):
        raise ApiError("""%s.checkValid: citationStore:
         value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dataLists')
      for value in values:
        from ccp.api.nmr.Nmr import DataList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataLists:
           value is not of class ccp.nmr.Nmr.DataList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: dataLists:
           non-reciprocal link dataLists from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('editors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: editors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('editorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: editors:
           non-reciprocal link editors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('experiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: experiments:
           non-reciprocal link experiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('methods')
      for value in values:
        from ccp.api.general.Method import Method as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: methods:
           value is not of class ccp.general.Method.Method""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: methods:
           non-reciprocal link methods from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSystems')
      for value in values:
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystems:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSystems:
           non-reciprocal link molSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molecules')
      for value in values:
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecules:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecules:
           non-reciprocal link molecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntries')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntries:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('otherCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrEntries:
           non-reciprocal link nmrEntries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntries:
           Link nmrEntries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntriesPrimary')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('primaryCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           non-reciprocal link nmrEntriesPrimary from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           Link nmrEntriesPrimary between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrProbes')
      for value in values:
        from ccp.api.general.Instrument import NmrProbe as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrProbes:
           value is not of class ccp.general.Instrument.NmrProbe""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrProbes:
           non-reciprocal link nmrProbes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrSpectrometers')
      for value in values:
        from ccp.api.general.Instrument import NmrSpectrometer as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           value is not of class ccp.general.Instrument.NmrSpectrometer""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           non-reciprocal link nmrSpectrometers from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protocols')
      for value in values:
        from ccp.api.lims.Protocol import Protocol as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protocols:
           value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('references')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: protocols:
           non-reciprocal link protocols from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protocols:
           Link protocols between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('ratioShiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('shiftRatioCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           non-reciprocal link ratioShiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           Link ratioShiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('sampleConditionSets')
      for value in values:
        from ccp.api.nmr.Nmr import SampleConditionSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           value is not of class ccp.nmr.Nmr.SampleConditionSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           non-reciprocal link sampleConditionSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('shiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: shiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('citation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: shiftReferences:
           non-reciprocal link shiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: shiftReferences:
           Link shiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('software')
      for value in values:
        from ccp.api.general.Method import Software as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: software:
           value is not of class ccp.general.Method.Software""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: software:
           non-reciprocal link software from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targetGroups')
      for value in values:
        from ccp.api.lims.Target import TargetGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targetGroups:
           value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targetGroups:
           non-reciprocal link targetGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targets:
           non-reciprocal link targets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('astm')
    value = dataDict.get('casAbstractCode')
    value = dataDict.get('csd')
    value = dataDict.get('details')
    value = dataDict.get('doi')
    value = dataDict.get('firstPage')
    value = dataDict.get('issn')
    value = dataDict.get('issue')
    value = dataDict.get('journalAbbreviation')
    value = dataDict.get('journalFullName')
    values = dataDict.get('keywords')
    value = dataDict.get('lastPage')
    value = dataDict.get('medlineUiCode')
    value = dataDict.get('pubMedId')
    value = dataDict.get('status')
    value = dataDict.get('title')
    value = dataDict.get('volume')
    value = dataDict.get('year')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('authors')
    value = dataDict.get('citationStore')
    if (value is None):
      raise ApiError("""%s.checkValid: citationStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('dataLists')
    values = dataDict.get('editors')
    values = dataDict.get('experiments')
    values = dataDict.get('methods')
    values = dataDict.get('molSystems')
    values = dataDict.get('molecules')
    values = dataDict.get('nmrEntries')
    values = dataDict.get('nmrEntriesPrimary')
    values = dataDict.get('nmrProbes')
    values = dataDict.get('nmrSpectrometers')
    values = dataDict.get('protocols')
    values = dataDict.get('ratioShiftReferences')
    values = dataDict.get('sampleConditionSets')
    values = dataDict.get('shiftReferences')
    values = dataDict.get('software')
    values = dataDict.get('targetGroups')
    values = dataDict.get('targets')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllAuthors = Citation.findAllAuthors

  findAllDataLists = Citation.findAllDataLists

  findAllEditors = Citation.findAllEditors

  findAllExperiments = Citation.findAllExperiments

  findAllMethods = Citation.findAllMethods

  findAllMolSystems = Citation.findAllMolSystems

  findAllMolecules = Citation.findAllMolecules

  findAllNmrEntries = Citation.findAllNmrEntries

  findAllNmrEntriesPrimary = Citation.findAllNmrEntriesPrimary

  findAllNmrProbes = Citation.findAllNmrProbes

  findAllNmrSpectrometers = Citation.findAllNmrSpectrometers

  findAllProtocols = Citation.findAllProtocols

  findAllRatioShiftReferences = Citation.findAllRatioShiftReferences

  findAllSampleConditionSets = Citation.findAllSampleConditionSets

  findAllShiftReferences = Citation.findAllShiftReferences

  findAllSoftware = Citation.findAllSoftware

  findAllTargetGroups = Citation.findAllTargetGroups

  findAllTargets = Citation.findAllTargets

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstAuthor = Citation.findFirstAuthor

  findFirstDataList = Citation.findFirstDataList

  findFirstEditor = Citation.findFirstEditor

  findFirstExperiment = Citation.findFirstExperiment

  findFirstMethod = Citation.findFirstMethod

  findFirstMolSystem = Citation.findFirstMolSystem

  findFirstMolecule = Citation.findFirstMolecule

  findFirstNmrEntry = Citation.findFirstNmrEntry

  findFirstNmrEntryPrimary = Citation.findFirstNmrEntryPrimary

  findFirstNmrProbe = Citation.findFirstNmrProbe

  findFirstNmrSpectrometer = Citation.findFirstNmrSpectrometer

  findFirstProtocol = Citation.findFirstProtocol

  findFirstRatioShiftReference = Citation.findFirstRatioShiftReference

  findFirstSampleConditionSet = Citation.findFirstSampleConditionSet

  findFirstShiftReference = Citation.findFirstShiftReference

  findFirstSoftware = Citation.findFirstSoftware

  findFirstTarget = Citation.findFirstTarget

  findFirstTargetGroup = Citation.findFirstTargetGroup
  
  def get(self, name):
    """
    GetAttr for ccp.general.Citation.JournalCitation
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAstm(self):
    """
    Get for ccp.general.Citation.JournalCitation.astm
    """
    dataDict = self.__dict__
    result = dataDict.get('astm')
    return result

  getAuthors = Citation.getAuthors
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Citation.JournalCitation
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.JournalCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('citationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Citation')
        obj1 = obj0.__dict__.get('citationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.JournalCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('citations').get(objKey)
      if (isinstance(obj2, JournalCitation)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasAbstractCode = Citation.getCasAbstractCode

  getCitationStore = Citation.getCitationStore

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCsd(self):
    """
    Get for ccp.general.Citation.JournalCitation.csd
    """
    dataDict = self.__dict__
    result = dataDict.get('csd')
    return result

  getDataLists = Citation.getDataLists

  getDetails = Citation.getDetails

  getDoi = Citation.getDoi

  getEditors = Citation.getEditors

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getExperiments = Citation.getExperiments

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFirstPage = Citation.getFirstPage

  getFullKey = Citation.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIssn(self):
    """
    Get for ccp.general.Citation.JournalCitation.issn
    """
    dataDict = self.__dict__
    result = dataDict.get('issn')
    return result
  
  def getIssue(self):
    """
    Get for ccp.general.Citation.JournalCitation.issue
    """
    dataDict = self.__dict__
    result = dataDict.get('issue')
    return result
  
  def getJournalAbbreviation(self):
    """
    Get for ccp.general.Citation.JournalCitation.journalAbbreviation
    """
    dataDict = self.__dict__
    result = dataDict.get('journalAbbreviation')
    return result
  
  def getJournalFullName(self):
    """
    Get for ccp.general.Citation.JournalCitation.journalFullName
    """
    dataDict = self.__dict__
    result = dataDict.get('journalFullName')
    return result

  getKeywords = Citation.getKeywords

  getLastPage = Citation.getLastPage

  getLocalKey = Citation.getLocalKey

  getMedlineUiCode = Citation.getMedlineUiCode

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMethods = Citation.getMethods

  getMolSystems = Citation.getMolSystems

  getMolecules = Citation.getMolecules

  getNmrEntries = Citation.getNmrEntries

  getNmrEntriesPrimary = Citation.getNmrEntriesPrimary

  getNmrProbes = Citation.getNmrProbes

  getNmrSpectrometers = Citation.getNmrSpectrometers

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = Citation.getParent

  getProtocols = Citation.getProtocols

  getPubMedId = Citation.getPubMedId

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRatioShiftReferences = Citation.getRatioShiftReferences

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSampleConditionSets = Citation.getSampleConditionSets

  getSerial = Citation.getSerial

  getShiftReferences = Citation.getShiftReferences

  getSoftware = Citation.getSoftware

  getStatus = Citation.getStatus

  getTargetGroups = Citation.getTargetGroups

  getTargets = Citation.getTargets

  getTitle = Citation.getTitle

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getVolume(self):
    """
    Get for ccp.general.Citation.JournalCitation.volume
    """
    dataDict = self.__dict__
    result = dataDict.get('volume')
    return result

  getYear = Citation.getYear

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeAuthor = Citation.removeAuthor

  removeEditor = Citation.removeEditor

  removeKeyword = Citation.removeKeyword

  removeMolSystem = Citation.removeMolSystem

  removeNmrEntry = Citation.removeNmrEntry

  removeNmrEntryPrimary = Citation.removeNmrEntryPrimary

  removeProtocol = Citation.removeProtocol

  removeShiftReference = Citation.removeShiftReference

  removeTarget = Citation.removeTarget

  removeTargetGroup = Citation.removeTargetGroup
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Citation.JournalCitation
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAstm(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.astm
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAstm:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAstm:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAstm:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAstm:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('astm')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAstm:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAstm:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['astm'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAstm')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAuthors = Citation.setAuthors

  setCasAbstractCode = Citation.setCasAbstractCode
  
  def setCsd(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.csd
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCsd:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCsd:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCsd:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCsd:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('csd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCsd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCsd:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['csd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCsd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDataLists = Citation.setDataLists

  setDetails = Citation.setDetails

  setDoi = Citation.setDoi

  setEditors = Citation.setEditors

  setExperiments = Citation.setExperiments

  setFirstPage = Citation.setFirstPage
  
  def setIssn(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.issn
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setIssn:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setIssn:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setIssn:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setIssn:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('issn')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIssn:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIssn:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['issn'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIssn')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIssue(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.issue
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setIssue:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setIssue:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setIssue:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setIssue:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('issue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIssue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIssue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['issue'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIssue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setJournalAbbreviation(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.journalAbbreviation
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setJournalAbbreviation:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setJournalAbbreviation:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setJournalAbbreviation:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setJournalAbbreviation:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('journalAbbreviation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setJournalAbbreviation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setJournalAbbreviation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['journalAbbreviation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setJournalAbbreviation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setJournalFullName(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.journalFullName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setJournalFullName:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setJournalFullName:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setJournalFullName:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('journalFullName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setJournalFullName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setJournalFullName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['journalFullName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setJournalFullName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setKeywords = Citation.setKeywords

  setLastPage = Citation.setLastPage

  setMedlineUiCode = Citation.setMedlineUiCode

  setMethods = Citation.setMethods

  setMolSystems = Citation.setMolSystems

  setMolecules = Citation.setMolecules

  setNmrEntries = Citation.setNmrEntries

  setNmrEntriesPrimary = Citation.setNmrEntriesPrimary

  setNmrProbes = Citation.setNmrProbes

  setNmrSpectrometers = Citation.setNmrSpectrometers

  setProtocols = Citation.setProtocols

  setPubMedId = Citation.setPubMedId

  setRatioShiftReferences = Citation.setRatioShiftReferences

  setSampleConditionSets = Citation.setSampleConditionSets

  setSerial = Citation.setSerial

  setShiftReferences = Citation.setShiftReferences

  setSoftware = Citation.setSoftware

  setStatus = Citation.setStatus

  setTargetGroups = Citation.setTargetGroups

  setTargets = Citation.setTargets

  setTitle = Citation.setTitle
  
  def setVolume(self, value):
    """
    Set for ccp.general.Citation.JournalCitation.volume
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setVolume:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setVolume:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setVolume:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setVolume:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('volume')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setVolume:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setVolume:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['volume'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setVolume')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setYear = Citation.setYear

  sortedDataLists = Citation.sortedDataLists

  sortedExperiments = Citation.sortedExperiments

  sortedMethods = Citation.sortedMethods

  sortedMolSystems = Citation.sortedMolSystems

  sortedMolecules = Citation.sortedMolecules

  sortedNmrEntries = Citation.sortedNmrEntries

  sortedNmrProbes = Citation.sortedNmrProbes

  sortedNmrSpectrometers = Citation.sortedNmrSpectrometers

  sortedProtocols = Citation.sortedProtocols

  sortedRatioShiftReferences = Citation.sortedRatioShiftReferences

  sortedSampleConditionSets = Citation.sortedSampleConditionSets

  sortedShiftReferences = Citation.sortedShiftReferences

  sortedSoftware = Citation.sortedSoftware

  sortedTargetGroups = Citation.sortedTargetGroups

  sortedTargets = Citation.sortedTargets

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  astm = property(getAstm, setAstm, None,
  r"""ASTM code .
  """)

  casAbstractCode = Citation.casAbstractCode

  className = memops.api.Implementation.ComplexDataType.className
  
  csd = property(getCsd, setCsd, None,
  r"""CSD code
  """)

  details = Citation.details

  doi = Citation.doi

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  firstPage = Citation.firstPage

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  issn = property(getIssn, setIssn, None,
  r"""ISSN code
  """)
  
  issue = property(getIssue, setIssue, None,
  r"""Journal issue 'number' (not an integer)
  """)
  
  journalAbbreviation = property(getJournalAbbreviation, setJournalAbbreviation, None,
  r"""Journal abbreviation according to ACS standard abbreviations
  """)
  
  journalFullName = property(getJournalFullName, setJournalFullName, None,
  r"""Full name of Journal
  """)

  keywords = Citation.keywords

  lastPage = Citation.lastPage

  medlineUiCode = Citation.medlineUiCode

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  pubMedId = Citation.pubMedId

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Citation.serial

  status = Citation.status

  title = Citation.title
  
  volume = property(getVolume, setVolume, None,
  r"""Journal volume 'number' (not an integer)
  """)

  year = Citation.year

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  authors = Citation.authors

  citationStore = Citation.citationStore

  dataLists = Citation.dataLists

  editors = Citation.editors

  experiments = Citation.experiments

  methods = Citation.methods

  molSystems = Citation.molSystems

  molecules = Citation.molecules

  nmrEntries = Citation.nmrEntries

  nmrEntriesPrimary = Citation.nmrEntriesPrimary

  nmrProbes = Citation.nmrProbes

  nmrSpectrometers = Citation.nmrSpectrometers

  parent = Citation.parent

  protocols = Citation.protocols

  ratioShiftReferences = Citation.ratioShiftReferences

  root = memops.api.Implementation.MemopsObject.root

  sampleConditionSets = Citation.sampleConditionSets

  shiftReferences = Citation.shiftReferences

  software = Citation.software

  targetGroups = Citation.targetGroups

  targets = Citation.targets

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ThesisCitation(Citation):
  r"""Citation (litterature reference) to  a Thesis.
  """
  #   from data model element ccp.general.Citation.ThesisCitation revision ?
  _metaclass = metaPackage.getElement('ThesisCitation')
  _packageName = 'ccp.general.Citation'
  _packageShortName = 'CITA'
  _fieldNames = ('applicationData', 'casAbstractCode', 'city', 'className', 'country', 'details', 'doi', 'fieldNames', 'firstPage', 'inConstructor', 'institution', 'isDeleted', 'keywords', 'lastPage', 'medlineUiCode', 'metaclass', 'packageName', 'packageShortName', 'pubMedId', 'qualifiedName', 'serial', 'stateProvince', 'status', 'title', 'year', 'access', 'activeAccess', 'authors', 'citationStore', 'dataLists', 'editors', 'experiments', 'methods', 'molSystems', 'molecules', 'nmrEntries', 'nmrEntriesPrimary', 'nmrProbes', 'nmrSpectrometers', 'parent', 'protocols', 'ratioShiftReferences', 'root', 'sampleConditionSets', 'shiftReferences', 'software', 'targetGroups', 'targets', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Citation.ThesisCitation
    """
    dataDict = self.__dict__
    dataDict['citationStore'] = parent
    if (not isinstance(parent, CitationStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['casAbstractCode'] = None
      dataDict['city'] = None
      dataDict['country'] = None
      dataDict['details'] = None
      dataDict['doi'] = None
      dataDict['firstPage'] = None
      dataDict['institution'] = None
      dataDict['keywords'] = list()
      dataDict['lastPage'] = None
      dataDict['medlineUiCode'] = None
      dataDict['pubMedId'] = None
      dataDict['serial'] = None
      dataDict['stateProvince'] = None
      dataDict['status'] = None
      dataDict['title'] = None
      dataDict['year'] = None
      dataDict['access'] = None
      dataDict['authors'] = list()
      dataDict['dataLists'] = set()
      dataDict['editors'] = list()
      dataDict['experiments'] = set()
      dataDict['methods'] = set()
      dataDict['molSystems'] = set()
      dataDict['molecules'] = set()
      dataDict['nmrEntries'] = set()
      dataDict['nmrEntriesPrimary'] = list()
      dataDict['nmrProbes'] = set()
      dataDict['nmrSpectrometers'] = set()
      dataDict['protocols'] = set()
      dataDict['ratioShiftReferences'] = set()
      dataDict['sampleConditionSets'] = set()
      dataDict['shiftReferences'] = set()
      dataDict['software'] = set()
      dataDict['targetGroups'] = set()
      dataDict['targets'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Citation.ThesisCitation.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.general.Citation.ThesisCitation')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('citations')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Citation.ThesisCitation:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    authors = dataDict.get('authors')
    pass
    for author in authors:
      topObject = author.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dataLists = dataDict.get('dataLists')
    for dataList in dataLists:
      if (not (dataList in objsToBeDeleted)):
        objsToBeDeleted.add(dataList)
        objsToBeChecked.append(dataList)

    for dataList in dataLists:
      topObject = dataList.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    editors = dataDict.get('editors')
    pass
    for editor in editors:
      topObject = editor.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    experiments = dataDict.get('experiments')
    for experiment in experiments:
      if (not (experiment in objsToBeDeleted)):
        objsToBeDeleted.add(experiment)
        objsToBeChecked.append(experiment)

    for experiment in experiments:
      topObject = experiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    methods = dataDict.get('methods')
    for method in methods:
      if (not (method in objsToBeDeleted)):
        objsToBeDeleted.add(method)
        objsToBeChecked.append(method)

    for method in methods:
      topObject = method.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSystems = dataDict.get('molSystems')
    pass
    for molSystem in molSystems:
      topObject = molSystem.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molecules = dataDict.get('molecules')
    for molecule in molecules:
      if (not (molecule in objsToBeDeleted)):
        objsToBeDeleted.add(molecule)
        objsToBeChecked.append(molecule)

    for molecule in molecules:
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntries = dataDict.get('nmrEntries')
    pass
    for nmrEntry in nmrEntries:
      topObject = nmrEntry.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntriesPrimary = dataDict.get('nmrEntriesPrimary')
    pass
    for nmrEntryPrimary in nmrEntriesPrimary:
      topObject = nmrEntryPrimary.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrProbes = dataDict.get('nmrProbes')
    for nmrProbe in nmrProbes:
      if (not (nmrProbe in objsToBeDeleted)):
        objsToBeDeleted.add(nmrProbe)
        objsToBeChecked.append(nmrProbe)

    for nmrProbe in nmrProbes:
      topObject = nmrProbe.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrSpectrometers = dataDict.get('nmrSpectrometers')
    for nmrSpectrometer in nmrSpectrometers:
      if (not (nmrSpectrometer in objsToBeDeleted)):
        objsToBeDeleted.add(nmrSpectrometer)
        objsToBeChecked.append(nmrSpectrometer)

    for nmrSpectrometer in nmrSpectrometers:
      topObject = nmrSpectrometer.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protocols = dataDict.get('protocols')
    pass
    for protocol in protocols:
      topObject = protocol.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ratioShiftReferences = dataDict.get('ratioShiftReferences')
    for ratioShiftReference in ratioShiftReferences:
      if (not (ratioShiftReference in objsToBeDeleted)):
        objsToBeDeleted.add(ratioShiftReference)
        objsToBeChecked.append(ratioShiftReference)

    for ratioShiftReference in ratioShiftReferences:
      topObject = ratioShiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    sampleConditionSets = dataDict.get('sampleConditionSets')
    for sampleConditionSet in sampleConditionSets:
      if (not (sampleConditionSet in objsToBeDeleted)):
        objsToBeDeleted.add(sampleConditionSet)
        objsToBeChecked.append(sampleConditionSet)

    for sampleConditionSet in sampleConditionSets:
      topObject = sampleConditionSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    shiftReferences = dataDict.get('shiftReferences')
    pass
    for shiftReference in shiftReferences:
      topObject = shiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    software_s = dataDict.get('software')
    for software in software_s:
      if (not (software in objsToBeDeleted)):
        objsToBeDeleted.add(software)
        objsToBeChecked.append(software)

    for software in software_s:
      topObject = software.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targetGroups = dataDict.get('targetGroups')
    pass
    for targetGroup in targetGroups:
      topObject = targetGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targets = dataDict.get('targets')
    pass
    for target in targets:
      topObject = target.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Citation.ThesisCitation:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for author in dataDict.get('authors'):
      if (not (author in objsToBeDeleted)):
        authorCitations = author.__dict__.get('authorCitations')
        authorCitations.remove(self)

    for editor in dataDict.get('editors'):
      if (not (editor in objsToBeDeleted)):
        editorCitations = editor.__dict__.get('editorCitations')
        editorCitations.remove(self)

    for molSystem in dataDict.get('molSystems'):
      if (not (molSystem in objsToBeDeleted)):
        citations = molSystem.__dict__.get('citations')
        citations.remove(self)

    for nmrEntry in dataDict.get('nmrEntries'):
      if (not (nmrEntry in objsToBeDeleted)):
        otherCitations = nmrEntry.__dict__.get('otherCitations')
        otherCitations.remove(self)

    for nmrEntryPrimary in dataDict.get('nmrEntriesPrimary'):
      if (not (nmrEntryPrimary in objsToBeDeleted)):
        nmrEntryPrimary.__dict__['primaryCitation'] = None

    for protocol in dataDict.get('protocols'):
      if (not (protocol in objsToBeDeleted)):
        references = protocol.__dict__.get('references')
        references.remove(self)

    for shiftReference in dataDict.get('shiftReferences'):
      if (not (shiftReference in objsToBeDeleted)):
        shiftReference.__dict__['citation'] = None

    for targetGroup in dataDict.get('targetGroups'):
      if (not (targetGroup in objsToBeDeleted)):
        citations = targetGroup.__dict__.get('citations')
        citations.remove(self)

    for target in dataDict.get('targets'):
      if (not (target in objsToBeDeleted)):
        citations = target.__dict__.get('citations')
        citations.remove(self)

    citationStore = dataDict.get('citationStore')
    if (not (citationStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = citationStore.__dict__.get('citations')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addAuthor = Citation.addAuthor

  addEditor = Citation.addEditor

  addKeyword = Citation.addKeyword

  addMolSystem = Citation.addMolSystem

  addNmrEntry = Citation.addNmrEntry

  addNmrEntryPrimary = Citation.addNmrEntryPrimary

  addProtocol = Citation.addProtocol

  addShiftReference = Citation.addShiftReference

  addTarget = Citation.addTarget

  addTargetGroup = Citation.addTargetGroup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Citation.ThesisCitation
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Citation.ThesisCitation
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('citationStore')
        dd = value.__dict__.get('citations')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'citationStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casAbstractCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: casAbstractCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('city')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: city:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: city:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: city:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: city:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('country')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: country:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: country:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: country:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: country:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('doi')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('firstPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: firstPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('institution')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: institution:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: institution:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: institution:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: lastPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('medlineUiCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: medlineUiCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('pubMedId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: pubMedId:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stateProvince')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: stateProvince:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: stateProvince:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: stateProvince:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: stateProvince:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('status')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: status:
           CitationStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('title')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.SingleLine input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: title:
           SingleLine constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('year')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: year:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('authors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: authors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('authorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: authors:
           non-reciprocal link authors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('citationStore')
      if (not isinstance(value, CitationStore)):
        raise ApiError("""%s.checkValid: citationStore:
         value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dataLists')
      for value in values:
        from ccp.api.nmr.Nmr import DataList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataLists:
           value is not of class ccp.nmr.Nmr.DataList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: dataLists:
           non-reciprocal link dataLists from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('editors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: editors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('editorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: editors:
           non-reciprocal link editors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('experiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: experiments:
           non-reciprocal link experiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('methods')
      for value in values:
        from ccp.api.general.Method import Method as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: methods:
           value is not of class ccp.general.Method.Method""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: methods:
           non-reciprocal link methods from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSystems')
      for value in values:
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystems:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSystems:
           non-reciprocal link molSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molecules')
      for value in values:
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecules:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecules:
           non-reciprocal link molecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntries')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntries:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('otherCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrEntries:
           non-reciprocal link nmrEntries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntries:
           Link nmrEntries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntriesPrimary')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('primaryCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           non-reciprocal link nmrEntriesPrimary from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           Link nmrEntriesPrimary between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrProbes')
      for value in values:
        from ccp.api.general.Instrument import NmrProbe as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrProbes:
           value is not of class ccp.general.Instrument.NmrProbe""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrProbes:
           non-reciprocal link nmrProbes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrSpectrometers')
      for value in values:
        from ccp.api.general.Instrument import NmrSpectrometer as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           value is not of class ccp.general.Instrument.NmrSpectrometer""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           non-reciprocal link nmrSpectrometers from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protocols')
      for value in values:
        from ccp.api.lims.Protocol import Protocol as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protocols:
           value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('references')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: protocols:
           non-reciprocal link protocols from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protocols:
           Link protocols between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('ratioShiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('shiftRatioCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           non-reciprocal link ratioShiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           Link ratioShiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('sampleConditionSets')
      for value in values:
        from ccp.api.nmr.Nmr import SampleConditionSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           value is not of class ccp.nmr.Nmr.SampleConditionSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           non-reciprocal link sampleConditionSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('shiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: shiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('citation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: shiftReferences:
           non-reciprocal link shiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: shiftReferences:
           Link shiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('software')
      for value in values:
        from ccp.api.general.Method import Software as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: software:
           value is not of class ccp.general.Method.Software""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: software:
           non-reciprocal link software from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targetGroups')
      for value in values:
        from ccp.api.lims.Target import TargetGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targetGroups:
           value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targetGroups:
           non-reciprocal link targetGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targets:
           non-reciprocal link targets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('casAbstractCode')
    value = dataDict.get('city')
    value = dataDict.get('country')
    value = dataDict.get('details')
    value = dataDict.get('doi')
    value = dataDict.get('firstPage')
    value = dataDict.get('institution')
    values = dataDict.get('keywords')
    value = dataDict.get('lastPage')
    value = dataDict.get('medlineUiCode')
    value = dataDict.get('pubMedId')
    value = dataDict.get('stateProvince')
    value = dataDict.get('status')
    value = dataDict.get('title')
    value = dataDict.get('year')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('authors')
    value = dataDict.get('citationStore')
    if (value is None):
      raise ApiError("""%s.checkValid: citationStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('dataLists')
    values = dataDict.get('editors')
    values = dataDict.get('experiments')
    values = dataDict.get('methods')
    values = dataDict.get('molSystems')
    values = dataDict.get('molecules')
    values = dataDict.get('nmrEntries')
    values = dataDict.get('nmrEntriesPrimary')
    values = dataDict.get('nmrProbes')
    values = dataDict.get('nmrSpectrometers')
    values = dataDict.get('protocols')
    values = dataDict.get('ratioShiftReferences')
    values = dataDict.get('sampleConditionSets')
    values = dataDict.get('shiftReferences')
    values = dataDict.get('software')
    values = dataDict.get('targetGroups')
    values = dataDict.get('targets')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllAuthors = Citation.findAllAuthors

  findAllDataLists = Citation.findAllDataLists

  findAllEditors = Citation.findAllEditors

  findAllExperiments = Citation.findAllExperiments

  findAllMethods = Citation.findAllMethods

  findAllMolSystems = Citation.findAllMolSystems

  findAllMolecules = Citation.findAllMolecules

  findAllNmrEntries = Citation.findAllNmrEntries

  findAllNmrEntriesPrimary = Citation.findAllNmrEntriesPrimary

  findAllNmrProbes = Citation.findAllNmrProbes

  findAllNmrSpectrometers = Citation.findAllNmrSpectrometers

  findAllProtocols = Citation.findAllProtocols

  findAllRatioShiftReferences = Citation.findAllRatioShiftReferences

  findAllSampleConditionSets = Citation.findAllSampleConditionSets

  findAllShiftReferences = Citation.findAllShiftReferences

  findAllSoftware = Citation.findAllSoftware

  findAllTargetGroups = Citation.findAllTargetGroups

  findAllTargets = Citation.findAllTargets

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstAuthor = Citation.findFirstAuthor

  findFirstDataList = Citation.findFirstDataList

  findFirstEditor = Citation.findFirstEditor

  findFirstExperiment = Citation.findFirstExperiment

  findFirstMethod = Citation.findFirstMethod

  findFirstMolSystem = Citation.findFirstMolSystem

  findFirstMolecule = Citation.findFirstMolecule

  findFirstNmrEntry = Citation.findFirstNmrEntry

  findFirstNmrEntryPrimary = Citation.findFirstNmrEntryPrimary

  findFirstNmrProbe = Citation.findFirstNmrProbe

  findFirstNmrSpectrometer = Citation.findFirstNmrSpectrometer

  findFirstProtocol = Citation.findFirstProtocol

  findFirstRatioShiftReference = Citation.findFirstRatioShiftReference

  findFirstSampleConditionSet = Citation.findFirstSampleConditionSet

  findFirstShiftReference = Citation.findFirstShiftReference

  findFirstSoftware = Citation.findFirstSoftware

  findFirstTarget = Citation.findFirstTarget

  findFirstTargetGroup = Citation.findFirstTargetGroup
  
  def get(self, name):
    """
    GetAttr for ccp.general.Citation.ThesisCitation
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getAuthors = Citation.getAuthors
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Citation.ThesisCitation
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.ThesisCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('citationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Citation')
        obj1 = obj0.__dict__.get('citationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.ThesisCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('citations').get(objKey)
      if (isinstance(obj2, ThesisCitation)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasAbstractCode = Citation.getCasAbstractCode

  getCitationStore = Citation.getCitationStore
  
  def getCity(self):
    """
    Get for ccp.general.Citation.ThesisCitation.city
    """
    dataDict = self.__dict__
    result = dataDict.get('city')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCountry(self):
    """
    Get for ccp.general.Citation.ThesisCitation.country
    """
    dataDict = self.__dict__
    result = dataDict.get('country')
    return result

  getDataLists = Citation.getDataLists

  getDetails = Citation.getDetails

  getDoi = Citation.getDoi

  getEditors = Citation.getEditors

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getExperiments = Citation.getExperiments

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFirstPage = Citation.getFirstPage

  getFullKey = Citation.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInstitution(self):
    """
    Get for ccp.general.Citation.ThesisCitation.institution
    """
    dataDict = self.__dict__
    result = dataDict.get('institution')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getKeywords = Citation.getKeywords

  getLastPage = Citation.getLastPage

  getLocalKey = Citation.getLocalKey

  getMedlineUiCode = Citation.getMedlineUiCode

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMethods = Citation.getMethods

  getMolSystems = Citation.getMolSystems

  getMolecules = Citation.getMolecules

  getNmrEntries = Citation.getNmrEntries

  getNmrEntriesPrimary = Citation.getNmrEntriesPrimary

  getNmrProbes = Citation.getNmrProbes

  getNmrSpectrometers = Citation.getNmrSpectrometers

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = Citation.getParent

  getProtocols = Citation.getProtocols

  getPubMedId = Citation.getPubMedId

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRatioShiftReferences = Citation.getRatioShiftReferences

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSampleConditionSets = Citation.getSampleConditionSets

  getSerial = Citation.getSerial

  getShiftReferences = Citation.getShiftReferences

  getSoftware = Citation.getSoftware
  
  def getStateProvince(self):
    """
    Get for ccp.general.Citation.ThesisCitation.stateProvince
    """
    dataDict = self.__dict__
    result = dataDict.get('stateProvince')
    return result

  getStatus = Citation.getStatus

  getTargetGroups = Citation.getTargetGroups

  getTargets = Citation.getTargets

  getTitle = Citation.getTitle

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  getYear = Citation.getYear

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeAuthor = Citation.removeAuthor

  removeEditor = Citation.removeEditor

  removeKeyword = Citation.removeKeyword

  removeMolSystem = Citation.removeMolSystem

  removeNmrEntry = Citation.removeNmrEntry

  removeNmrEntryPrimary = Citation.removeNmrEntryPrimary

  removeProtocol = Citation.removeProtocol

  removeShiftReference = Citation.removeShiftReference

  removeTarget = Citation.removeTarget

  removeTargetGroup = Citation.removeTargetGroup
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Citation.ThesisCitation
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setAuthors = Citation.setAuthors

  setCasAbstractCode = Citation.setCasAbstractCode
  
  def setCity(self, value):
    """
    Set for ccp.general.Citation.ThesisCitation.city
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCity:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCity:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCity:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCity:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('city')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCity:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCity:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['city'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCity')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCountry(self, value):
    """
    Set for ccp.general.Citation.ThesisCitation.country
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCountry:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCountry:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCountry:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCountry:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('country')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCountry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCountry:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['country'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCountry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDataLists = Citation.setDataLists

  setDetails = Citation.setDetails

  setDoi = Citation.setDoi

  setEditors = Citation.setEditors

  setExperiments = Citation.setExperiments

  setFirstPage = Citation.setFirstPage
  
  def setInstitution(self, value):
    """
    Set for ccp.general.Citation.ThesisCitation.institution
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setInstitution:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setInstitution:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setInstitution:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('institution')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInstitution:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInstitution:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['institution'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInstitution')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setKeywords = Citation.setKeywords

  setLastPage = Citation.setLastPage

  setMedlineUiCode = Citation.setMedlineUiCode

  setMethods = Citation.setMethods

  setMolSystems = Citation.setMolSystems

  setMolecules = Citation.setMolecules

  setNmrEntries = Citation.setNmrEntries

  setNmrEntriesPrimary = Citation.setNmrEntriesPrimary

  setNmrProbes = Citation.setNmrProbes

  setNmrSpectrometers = Citation.setNmrSpectrometers

  setProtocols = Citation.setProtocols

  setPubMedId = Citation.setPubMedId

  setRatioShiftReferences = Citation.setRatioShiftReferences

  setSampleConditionSets = Citation.setSampleConditionSets

  setSerial = Citation.setSerial

  setShiftReferences = Citation.setShiftReferences

  setSoftware = Citation.setSoftware
  
  def setStateProvince(self, value):
    """
    Set for ccp.general.Citation.ThesisCitation.stateProvince
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStateProvince:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setStateProvince:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setStateProvince:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setStateProvince:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stateProvince')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStateProvince:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStateProvince:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stateProvince'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStateProvince')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setStatus = Citation.setStatus

  setTargetGroups = Citation.setTargetGroups

  setTargets = Citation.setTargets

  setTitle = Citation.setTitle

  setYear = Citation.setYear

  sortedDataLists = Citation.sortedDataLists

  sortedExperiments = Citation.sortedExperiments

  sortedMethods = Citation.sortedMethods

  sortedMolSystems = Citation.sortedMolSystems

  sortedMolecules = Citation.sortedMolecules

  sortedNmrEntries = Citation.sortedNmrEntries

  sortedNmrProbes = Citation.sortedNmrProbes

  sortedNmrSpectrometers = Citation.sortedNmrSpectrometers

  sortedProtocols = Citation.sortedProtocols

  sortedRatioShiftReferences = Citation.sortedRatioShiftReferences

  sortedSampleConditionSets = Citation.sortedSampleConditionSets

  sortedShiftReferences = Citation.sortedShiftReferences

  sortedSoftware = Citation.sortedSoftware

  sortedTargetGroups = Citation.sortedTargetGroups

  sortedTargets = Citation.sortedTargets

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  casAbstractCode = Citation.casAbstractCode
  
  city = property(getCity, setCity, None,
  r"""City where institution is located
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  country = property(getCountry, setCountry, None,
  r"""Country where institution is located
  """)

  details = Citation.details

  doi = Citation.doi

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  firstPage = Citation.firstPage

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  institution = property(getInstitution, setInstitution, None,
  r"""Institution where thesis is submitted
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  keywords = Citation.keywords

  lastPage = Citation.lastPage

  medlineUiCode = Citation.medlineUiCode

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  pubMedId = Citation.pubMedId

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Citation.serial
  
  stateProvince = property(getStateProvince, setStateProvince, None,
  r"""State or province where institution is located
  """)

  status = Citation.status

  title = Citation.title

  year = Citation.year

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  authors = Citation.authors

  citationStore = Citation.citationStore

  dataLists = Citation.dataLists

  editors = Citation.editors

  experiments = Citation.experiments

  methods = Citation.methods

  molSystems = Citation.molSystems

  molecules = Citation.molecules

  nmrEntries = Citation.nmrEntries

  nmrEntriesPrimary = Citation.nmrEntriesPrimary

  nmrProbes = Citation.nmrProbes

  nmrSpectrometers = Citation.nmrSpectrometers

  parent = Citation.parent

  protocols = Citation.protocols

  ratioShiftReferences = Citation.ratioShiftReferences

  root = memops.api.Implementation.MemopsObject.root

  sampleConditionSets = Citation.sampleConditionSets

  shiftReferences = Citation.shiftReferences

  software = Citation.software

  targetGroups = Citation.targetGroups

  targets = Citation.targets

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ConferenceCitation(Citation):
  r"""Citation (litterature reference) to Conference presentation
  """
  #   from data model element ccp.general.Citation.ConferenceCitation revision ?
  _metaclass = metaPackage.getElement('ConferenceCitation')
  _packageName = 'ccp.general.Citation'
  _packageShortName = 'CITA'
  _fieldNames = ('abstractNumber', 'applicationData', 'casAbstractCode', 'city', 'className', 'conferenceSite', 'conferenceTitle', 'country', 'details', 'doi', 'endDate', 'fieldNames', 'firstPage', 'inConstructor', 'isDeleted', 'keywords', 'lastPage', 'medlineUiCode', 'metaclass', 'packageName', 'packageShortName', 'pubMedId', 'qualifiedName', 'serial', 'startDate', 'stateProvince', 'status', 'title', 'year', 'access', 'activeAccess', 'authors', 'citationStore', 'dataLists', 'editors', 'experiments', 'methods', 'molSystems', 'molecules', 'nmrEntries', 'nmrEntriesPrimary', 'nmrProbes', 'nmrSpectrometers', 'parent', 'protocols', 'ratioShiftReferences', 'root', 'sampleConditionSets', 'shiftReferences', 'software', 'targetGroups', 'targets', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Citation.ConferenceCitation
    """
    dataDict = self.__dict__
    dataDict['citationStore'] = parent
    if (not isinstance(parent, CitationStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['abstractNumber'] = None
      dataDict['applicationData'] = list()
      dataDict['casAbstractCode'] = None
      dataDict['city'] = None
      dataDict['conferenceSite'] = None
      dataDict['conferenceTitle'] = None
      dataDict['country'] = None
      dataDict['details'] = None
      dataDict['doi'] = None
      dataDict['endDate'] = None
      dataDict['firstPage'] = None
      dataDict['keywords'] = list()
      dataDict['lastPage'] = None
      dataDict['medlineUiCode'] = None
      dataDict['pubMedId'] = None
      dataDict['serial'] = None
      dataDict['startDate'] = None
      dataDict['stateProvince'] = None
      dataDict['status'] = None
      dataDict['title'] = None
      dataDict['year'] = None
      dataDict['access'] = None
      dataDict['authors'] = list()
      dataDict['dataLists'] = set()
      dataDict['editors'] = list()
      dataDict['experiments'] = set()
      dataDict['methods'] = set()
      dataDict['molSystems'] = set()
      dataDict['molecules'] = set()
      dataDict['nmrEntries'] = set()
      dataDict['nmrEntriesPrimary'] = list()
      dataDict['nmrProbes'] = set()
      dataDict['nmrSpectrometers'] = set()
      dataDict['protocols'] = set()
      dataDict['ratioShiftReferences'] = set()
      dataDict['sampleConditionSets'] = set()
      dataDict['shiftReferences'] = set()
      dataDict['software'] = set()
      dataDict['targetGroups'] = set()
      dataDict['targets'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Citation.ConferenceCitation.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.general.Citation.ConferenceCitation')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('citations')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Citation.ConferenceCitation:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    authors = dataDict.get('authors')
    pass
    for author in authors:
      topObject = author.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dataLists = dataDict.get('dataLists')
    for dataList in dataLists:
      if (not (dataList in objsToBeDeleted)):
        objsToBeDeleted.add(dataList)
        objsToBeChecked.append(dataList)

    for dataList in dataLists:
      topObject = dataList.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    editors = dataDict.get('editors')
    pass
    for editor in editors:
      topObject = editor.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    experiments = dataDict.get('experiments')
    for experiment in experiments:
      if (not (experiment in objsToBeDeleted)):
        objsToBeDeleted.add(experiment)
        objsToBeChecked.append(experiment)

    for experiment in experiments:
      topObject = experiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    methods = dataDict.get('methods')
    for method in methods:
      if (not (method in objsToBeDeleted)):
        objsToBeDeleted.add(method)
        objsToBeChecked.append(method)

    for method in methods:
      topObject = method.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSystems = dataDict.get('molSystems')
    pass
    for molSystem in molSystems:
      topObject = molSystem.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molecules = dataDict.get('molecules')
    for molecule in molecules:
      if (not (molecule in objsToBeDeleted)):
        objsToBeDeleted.add(molecule)
        objsToBeChecked.append(molecule)

    for molecule in molecules:
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntries = dataDict.get('nmrEntries')
    pass
    for nmrEntry in nmrEntries:
      topObject = nmrEntry.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntriesPrimary = dataDict.get('nmrEntriesPrimary')
    pass
    for nmrEntryPrimary in nmrEntriesPrimary:
      topObject = nmrEntryPrimary.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrProbes = dataDict.get('nmrProbes')
    for nmrProbe in nmrProbes:
      if (not (nmrProbe in objsToBeDeleted)):
        objsToBeDeleted.add(nmrProbe)
        objsToBeChecked.append(nmrProbe)

    for nmrProbe in nmrProbes:
      topObject = nmrProbe.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrSpectrometers = dataDict.get('nmrSpectrometers')
    for nmrSpectrometer in nmrSpectrometers:
      if (not (nmrSpectrometer in objsToBeDeleted)):
        objsToBeDeleted.add(nmrSpectrometer)
        objsToBeChecked.append(nmrSpectrometer)

    for nmrSpectrometer in nmrSpectrometers:
      topObject = nmrSpectrometer.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protocols = dataDict.get('protocols')
    pass
    for protocol in protocols:
      topObject = protocol.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ratioShiftReferences = dataDict.get('ratioShiftReferences')
    for ratioShiftReference in ratioShiftReferences:
      if (not (ratioShiftReference in objsToBeDeleted)):
        objsToBeDeleted.add(ratioShiftReference)
        objsToBeChecked.append(ratioShiftReference)

    for ratioShiftReference in ratioShiftReferences:
      topObject = ratioShiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    sampleConditionSets = dataDict.get('sampleConditionSets')
    for sampleConditionSet in sampleConditionSets:
      if (not (sampleConditionSet in objsToBeDeleted)):
        objsToBeDeleted.add(sampleConditionSet)
        objsToBeChecked.append(sampleConditionSet)

    for sampleConditionSet in sampleConditionSets:
      topObject = sampleConditionSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    shiftReferences = dataDict.get('shiftReferences')
    pass
    for shiftReference in shiftReferences:
      topObject = shiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    software_s = dataDict.get('software')
    for software in software_s:
      if (not (software in objsToBeDeleted)):
        objsToBeDeleted.add(software)
        objsToBeChecked.append(software)

    for software in software_s:
      topObject = software.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targetGroups = dataDict.get('targetGroups')
    pass
    for targetGroup in targetGroups:
      topObject = targetGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targets = dataDict.get('targets')
    pass
    for target in targets:
      topObject = target.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Citation.ConferenceCitation:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for author in dataDict.get('authors'):
      if (not (author in objsToBeDeleted)):
        authorCitations = author.__dict__.get('authorCitations')
        authorCitations.remove(self)

    for editor in dataDict.get('editors'):
      if (not (editor in objsToBeDeleted)):
        editorCitations = editor.__dict__.get('editorCitations')
        editorCitations.remove(self)

    for molSystem in dataDict.get('molSystems'):
      if (not (molSystem in objsToBeDeleted)):
        citations = molSystem.__dict__.get('citations')
        citations.remove(self)

    for nmrEntry in dataDict.get('nmrEntries'):
      if (not (nmrEntry in objsToBeDeleted)):
        otherCitations = nmrEntry.__dict__.get('otherCitations')
        otherCitations.remove(self)

    for nmrEntryPrimary in dataDict.get('nmrEntriesPrimary'):
      if (not (nmrEntryPrimary in objsToBeDeleted)):
        nmrEntryPrimary.__dict__['primaryCitation'] = None

    for protocol in dataDict.get('protocols'):
      if (not (protocol in objsToBeDeleted)):
        references = protocol.__dict__.get('references')
        references.remove(self)

    for shiftReference in dataDict.get('shiftReferences'):
      if (not (shiftReference in objsToBeDeleted)):
        shiftReference.__dict__['citation'] = None

    for targetGroup in dataDict.get('targetGroups'):
      if (not (targetGroup in objsToBeDeleted)):
        citations = targetGroup.__dict__.get('citations')
        citations.remove(self)

    for target in dataDict.get('targets'):
      if (not (target in objsToBeDeleted)):
        citations = target.__dict__.get('citations')
        citations.remove(self)

    citationStore = dataDict.get('citationStore')
    if (not (citationStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = citationStore.__dict__.get('citations')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addAuthor = Citation.addAuthor

  addEditor = Citation.addEditor

  addKeyword = Citation.addKeyword

  addMolSystem = Citation.addMolSystem

  addNmrEntry = Citation.addNmrEntry

  addNmrEntryPrimary = Citation.addNmrEntryPrimary

  addProtocol = Citation.addProtocol

  addShiftReference = Citation.addShiftReference

  addTarget = Citation.addTarget

  addTargetGroup = Citation.addTargetGroup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Citation.ConferenceCitation
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Citation.ConferenceCitation
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('citationStore')
        dd = value.__dict__.get('citations')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'citationStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('abstractNumber')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: abstractNumber:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: abstractNumber:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: abstractNumber:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: abstractNumber:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casAbstractCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: casAbstractCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('city')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: city:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: city:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: city:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: city:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('conferenceSite')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: conferenceSite:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: conferenceSite:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: conferenceSite:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: conferenceSite:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('conferenceTitle')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: conferenceTitle:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: conferenceTitle:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: conferenceTitle:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('country')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: country:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: country:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: country:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: country:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('doi')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('endDate')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: endDate:
           memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('firstPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: firstPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: lastPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('medlineUiCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: medlineUiCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('pubMedId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: pubMedId:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('startDate')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: startDate:
           memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('stateProvince')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: stateProvince:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: stateProvince:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: stateProvince:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: stateProvince:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('status')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: status:
           CitationStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('title')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.SingleLine input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: title:
           SingleLine constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('year')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: year:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('authors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: authors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('authorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: authors:
           non-reciprocal link authors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('citationStore')
      if (not isinstance(value, CitationStore)):
        raise ApiError("""%s.checkValid: citationStore:
         value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dataLists')
      for value in values:
        from ccp.api.nmr.Nmr import DataList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataLists:
           value is not of class ccp.nmr.Nmr.DataList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: dataLists:
           non-reciprocal link dataLists from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('editors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: editors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('editorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: editors:
           non-reciprocal link editors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('experiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: experiments:
           non-reciprocal link experiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('methods')
      for value in values:
        from ccp.api.general.Method import Method as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: methods:
           value is not of class ccp.general.Method.Method""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: methods:
           non-reciprocal link methods from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSystems')
      for value in values:
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystems:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSystems:
           non-reciprocal link molSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molecules')
      for value in values:
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecules:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecules:
           non-reciprocal link molecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntries')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntries:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('otherCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrEntries:
           non-reciprocal link nmrEntries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntries:
           Link nmrEntries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntriesPrimary')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('primaryCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           non-reciprocal link nmrEntriesPrimary from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           Link nmrEntriesPrimary between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrProbes')
      for value in values:
        from ccp.api.general.Instrument import NmrProbe as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrProbes:
           value is not of class ccp.general.Instrument.NmrProbe""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrProbes:
           non-reciprocal link nmrProbes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrSpectrometers')
      for value in values:
        from ccp.api.general.Instrument import NmrSpectrometer as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           value is not of class ccp.general.Instrument.NmrSpectrometer""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           non-reciprocal link nmrSpectrometers from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protocols')
      for value in values:
        from ccp.api.lims.Protocol import Protocol as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protocols:
           value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('references')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: protocols:
           non-reciprocal link protocols from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protocols:
           Link protocols between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('ratioShiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('shiftRatioCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           non-reciprocal link ratioShiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           Link ratioShiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('sampleConditionSets')
      for value in values:
        from ccp.api.nmr.Nmr import SampleConditionSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           value is not of class ccp.nmr.Nmr.SampleConditionSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           non-reciprocal link sampleConditionSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('shiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: shiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('citation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: shiftReferences:
           non-reciprocal link shiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: shiftReferences:
           Link shiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('software')
      for value in values:
        from ccp.api.general.Method import Software as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: software:
           value is not of class ccp.general.Method.Software""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: software:
           non-reciprocal link software from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targetGroups')
      for value in values:
        from ccp.api.lims.Target import TargetGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targetGroups:
           value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targetGroups:
           non-reciprocal link targetGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targets:
           non-reciprocal link targets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('abstractNumber')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('casAbstractCode')
    value = dataDict.get('city')
    value = dataDict.get('conferenceSite')
    value = dataDict.get('conferenceTitle')
    value = dataDict.get('country')
    value = dataDict.get('details')
    value = dataDict.get('doi')
    value = dataDict.get('endDate')
    value = dataDict.get('firstPage')
    values = dataDict.get('keywords')
    value = dataDict.get('lastPage')
    value = dataDict.get('medlineUiCode')
    value = dataDict.get('pubMedId')
    value = dataDict.get('startDate')
    value = dataDict.get('stateProvince')
    value = dataDict.get('status')
    value = dataDict.get('title')
    value = dataDict.get('year')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('authors')
    value = dataDict.get('citationStore')
    if (value is None):
      raise ApiError("""%s.checkValid: citationStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('dataLists')
    values = dataDict.get('editors')
    values = dataDict.get('experiments')
    values = dataDict.get('methods')
    values = dataDict.get('molSystems')
    values = dataDict.get('molecules')
    values = dataDict.get('nmrEntries')
    values = dataDict.get('nmrEntriesPrimary')
    values = dataDict.get('nmrProbes')
    values = dataDict.get('nmrSpectrometers')
    values = dataDict.get('protocols')
    values = dataDict.get('ratioShiftReferences')
    values = dataDict.get('sampleConditionSets')
    values = dataDict.get('shiftReferences')
    values = dataDict.get('software')
    values = dataDict.get('targetGroups')
    values = dataDict.get('targets')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllAuthors = Citation.findAllAuthors

  findAllDataLists = Citation.findAllDataLists

  findAllEditors = Citation.findAllEditors

  findAllExperiments = Citation.findAllExperiments

  findAllMethods = Citation.findAllMethods

  findAllMolSystems = Citation.findAllMolSystems

  findAllMolecules = Citation.findAllMolecules

  findAllNmrEntries = Citation.findAllNmrEntries

  findAllNmrEntriesPrimary = Citation.findAllNmrEntriesPrimary

  findAllNmrProbes = Citation.findAllNmrProbes

  findAllNmrSpectrometers = Citation.findAllNmrSpectrometers

  findAllProtocols = Citation.findAllProtocols

  findAllRatioShiftReferences = Citation.findAllRatioShiftReferences

  findAllSampleConditionSets = Citation.findAllSampleConditionSets

  findAllShiftReferences = Citation.findAllShiftReferences

  findAllSoftware = Citation.findAllSoftware

  findAllTargetGroups = Citation.findAllTargetGroups

  findAllTargets = Citation.findAllTargets

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstAuthor = Citation.findFirstAuthor

  findFirstDataList = Citation.findFirstDataList

  findFirstEditor = Citation.findFirstEditor

  findFirstExperiment = Citation.findFirstExperiment

  findFirstMethod = Citation.findFirstMethod

  findFirstMolSystem = Citation.findFirstMolSystem

  findFirstMolecule = Citation.findFirstMolecule

  findFirstNmrEntry = Citation.findFirstNmrEntry

  findFirstNmrEntryPrimary = Citation.findFirstNmrEntryPrimary

  findFirstNmrProbe = Citation.findFirstNmrProbe

  findFirstNmrSpectrometer = Citation.findFirstNmrSpectrometer

  findFirstProtocol = Citation.findFirstProtocol

  findFirstRatioShiftReference = Citation.findFirstRatioShiftReference

  findFirstSampleConditionSet = Citation.findFirstSampleConditionSet

  findFirstShiftReference = Citation.findFirstShiftReference

  findFirstSoftware = Citation.findFirstSoftware

  findFirstTarget = Citation.findFirstTarget

  findFirstTargetGroup = Citation.findFirstTargetGroup
  
  def get(self, name):
    """
    GetAttr for ccp.general.Citation.ConferenceCitation
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getAbstractNumber(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.abstractNumber
    """
    dataDict = self.__dict__
    result = dataDict.get('abstractNumber')
    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getAuthors = Citation.getAuthors
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Citation.ConferenceCitation
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.ConferenceCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('citationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Citation')
        obj1 = obj0.__dict__.get('citationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.ConferenceCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('citations').get(objKey)
      if (isinstance(obj2, ConferenceCitation)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasAbstractCode = Citation.getCasAbstractCode

  getCitationStore = Citation.getCitationStore
  
  def getCity(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.city
    """
    dataDict = self.__dict__
    result = dataDict.get('city')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getConferenceSite(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.conferenceSite
    """
    dataDict = self.__dict__
    result = dataDict.get('conferenceSite')
    return result
  
  def getConferenceTitle(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.conferenceTitle
    """
    dataDict = self.__dict__
    result = dataDict.get('conferenceTitle')
    return result
  
  def getCountry(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.country
    """
    dataDict = self.__dict__
    result = dataDict.get('country')
    return result

  getDataLists = Citation.getDataLists

  getDetails = Citation.getDetails

  getDoi = Citation.getDoi

  getEditors = Citation.getEditors
  
  def getEndDate(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.endDate
    """
    dataDict = self.__dict__
    result = dataDict.get('endDate')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getExperiments = Citation.getExperiments

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFirstPage = Citation.getFirstPage

  getFullKey = Citation.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getKeywords = Citation.getKeywords

  getLastPage = Citation.getLastPage

  getLocalKey = Citation.getLocalKey

  getMedlineUiCode = Citation.getMedlineUiCode

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMethods = Citation.getMethods

  getMolSystems = Citation.getMolSystems

  getMolecules = Citation.getMolecules

  getNmrEntries = Citation.getNmrEntries

  getNmrEntriesPrimary = Citation.getNmrEntriesPrimary

  getNmrProbes = Citation.getNmrProbes

  getNmrSpectrometers = Citation.getNmrSpectrometers

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = Citation.getParent

  getProtocols = Citation.getProtocols

  getPubMedId = Citation.getPubMedId

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRatioShiftReferences = Citation.getRatioShiftReferences

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSampleConditionSets = Citation.getSampleConditionSets

  getSerial = Citation.getSerial

  getShiftReferences = Citation.getShiftReferences

  getSoftware = Citation.getSoftware
  
  def getStartDate(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.startDate
    """
    dataDict = self.__dict__
    result = dataDict.get('startDate')
    return result
  
  def getStateProvince(self):
    """
    Get for ccp.general.Citation.ConferenceCitation.stateProvince
    """
    dataDict = self.__dict__
    result = dataDict.get('stateProvince')
    return result

  getStatus = Citation.getStatus

  getTargetGroups = Citation.getTargetGroups

  getTargets = Citation.getTargets

  getTitle = Citation.getTitle

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  getYear = Citation.getYear

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeAuthor = Citation.removeAuthor

  removeEditor = Citation.removeEditor

  removeKeyword = Citation.removeKeyword

  removeMolSystem = Citation.removeMolSystem

  removeNmrEntry = Citation.removeNmrEntry

  removeNmrEntryPrimary = Citation.removeNmrEntryPrimary

  removeProtocol = Citation.removeProtocol

  removeShiftReference = Citation.removeShiftReference

  removeTarget = Citation.removeTarget

  removeTargetGroup = Citation.removeTargetGroup
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Citation.ConferenceCitation
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setAbstractNumber(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.abstractNumber
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAbstractNumber:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAbstractNumber:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAbstractNumber:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAbstractNumber:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('abstractNumber')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAbstractNumber:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAbstractNumber:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['abstractNumber'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAbstractNumber')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setAuthors = Citation.setAuthors

  setCasAbstractCode = Citation.setCasAbstractCode
  
  def setCity(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.city
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCity:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCity:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCity:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCity:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('city')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCity:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCity:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['city'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCity')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConferenceSite(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.conferenceSite
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setConferenceSite:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setConferenceSite:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setConferenceSite:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setConferenceSite:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('conferenceSite')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConferenceSite:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConferenceSite:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['conferenceSite'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConferenceSite')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConferenceTitle(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.conferenceTitle
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setConferenceTitle:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setConferenceTitle:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setConferenceTitle:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('conferenceTitle')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConferenceTitle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConferenceTitle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['conferenceTitle'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConferenceTitle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCountry(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.country
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCountry:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setCountry:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCountry:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setCountry:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('country')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCountry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCountry:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['country'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCountry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDataLists = Citation.setDataLists

  setDetails = Citation.setDetails

  setDoi = Citation.setDoi

  setEditors = Citation.setEditors
  
  def setEndDate(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.endDate
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setEndDate:
         memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('endDate')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEndDate:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEndDate:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['endDate'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEndDate')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setExperiments = Citation.setExperiments

  setFirstPage = Citation.setFirstPage

  setKeywords = Citation.setKeywords

  setLastPage = Citation.setLastPage

  setMedlineUiCode = Citation.setMedlineUiCode

  setMethods = Citation.setMethods

  setMolSystems = Citation.setMolSystems

  setMolecules = Citation.setMolecules

  setNmrEntries = Citation.setNmrEntries

  setNmrEntriesPrimary = Citation.setNmrEntriesPrimary

  setNmrProbes = Citation.setNmrProbes

  setNmrSpectrometers = Citation.setNmrSpectrometers

  setProtocols = Citation.setProtocols

  setPubMedId = Citation.setPubMedId

  setRatioShiftReferences = Citation.setRatioShiftReferences

  setSampleConditionSets = Citation.setSampleConditionSets

  setSerial = Citation.setSerial

  setShiftReferences = Citation.setShiftReferences

  setSoftware = Citation.setSoftware
  
  def setStartDate(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.startDate
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStartDate:
         memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('startDate')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStartDate:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStartDate:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['startDate'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStartDate')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStateProvince(self, value):
    """
    Set for ccp.general.Citation.ConferenceCitation.stateProvince
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStateProvince:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setStateProvince:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setStateProvince:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setStateProvince:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stateProvince')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStateProvince:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStateProvince:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stateProvince'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStateProvince')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setStatus = Citation.setStatus

  setTargetGroups = Citation.setTargetGroups

  setTargets = Citation.setTargets

  setTitle = Citation.setTitle

  setYear = Citation.setYear

  sortedDataLists = Citation.sortedDataLists

  sortedExperiments = Citation.sortedExperiments

  sortedMethods = Citation.sortedMethods

  sortedMolSystems = Citation.sortedMolSystems

  sortedMolecules = Citation.sortedMolecules

  sortedNmrEntries = Citation.sortedNmrEntries

  sortedNmrProbes = Citation.sortedNmrProbes

  sortedNmrSpectrometers = Citation.sortedNmrSpectrometers

  sortedProtocols = Citation.sortedProtocols

  sortedRatioShiftReferences = Citation.sortedRatioShiftReferences

  sortedSampleConditionSets = Citation.sortedSampleConditionSets

  sortedShiftReferences = Citation.sortedShiftReferences

  sortedSoftware = Citation.sortedSoftware

  sortedTargetGroups = Citation.sortedTargetGroups

  sortedTargets = Citation.sortedTargets

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  abstractNumber = property(getAbstractNumber, setAbstractNumber, None,
  r"""Abstract 'number' (not an integer) of presentation.
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData

  casAbstractCode = Citation.casAbstractCode
  
  city = property(getCity, setCity, None,
  r"""City where conference is held
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  conferenceSite = property(getConferenceSite, setConferenceSite, None,
  r"""Location of conference
  """)
  
  conferenceTitle = property(getConferenceTitle, setConferenceTitle, None,
  r"""Title of cnference
  """)
  
  country = property(getCountry, setCountry, None,
  r"""Country where conference is held
  """)

  details = Citation.details

  doi = Citation.doi
  
  endDate = property(getEndDate, setEndDate, None,
  r"""Finishing date of conference
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  firstPage = Citation.firstPage

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  keywords = Citation.keywords

  lastPage = Citation.lastPage

  medlineUiCode = Citation.medlineUiCode

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  pubMedId = Citation.pubMedId

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Citation.serial
  
  startDate = property(getStartDate, setStartDate, None,
  r"""Starting date of conference
  """)
  
  stateProvince = property(getStateProvince, setStateProvince, None,
  r"""State or provinde where conference is held
  """)

  status = Citation.status

  title = Citation.title

  year = Citation.year

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  authors = Citation.authors

  citationStore = Citation.citationStore

  dataLists = Citation.dataLists

  editors = Citation.editors

  experiments = Citation.experiments

  methods = Citation.methods

  molSystems = Citation.molSystems

  molecules = Citation.molecules

  nmrEntries = Citation.nmrEntries

  nmrEntriesPrimary = Citation.nmrEntriesPrimary

  nmrProbes = Citation.nmrProbes

  nmrSpectrometers = Citation.nmrSpectrometers

  parent = Citation.parent

  protocols = Citation.protocols

  ratioShiftReferences = Citation.ratioShiftReferences

  root = memops.api.Implementation.MemopsObject.root

  sampleConditionSets = Citation.sampleConditionSets

  shiftReferences = Citation.shiftReferences

  software = Citation.software

  targetGroups = Citation.targetGroups

  targets = Citation.targets

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class BookCitation(Citation):
  r"""Citation (litterature reference) for book or book chapter.
  """
  #   from data model element ccp.general.Citation.BookCitation revision ?
  _metaclass = metaPackage.getElement('BookCitation')
  _packageName = 'ccp.general.Citation'
  _packageShortName = 'CITA'
  _fieldNames = ('applicationData', 'bookSeries', 'bookTitle', 'casAbstractCode', 'className', 'details', 'doi', 'fieldNames', 'firstPage', 'inConstructor', 'isDeleted', 'isbn', 'keywords', 'lastPage', 'medlineUiCode', 'metaclass', 'packageName', 'packageShortName', 'pubMedId', 'publisher', 'publisherCity', 'qualifiedName', 'serial', 'status', 'title', 'volume', 'year', 'access', 'activeAccess', 'authors', 'citationStore', 'dataLists', 'editors', 'experiments', 'methods', 'molSystems', 'molecules', 'nmrEntries', 'nmrEntriesPrimary', 'nmrProbes', 'nmrSpectrometers', 'parent', 'protocols', 'ratioShiftReferences', 'root', 'sampleConditionSets', 'shiftReferences', 'software', 'targetGroups', 'targets', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Citation.BookCitation
    """
    dataDict = self.__dict__
    dataDict['citationStore'] = parent
    if (not isinstance(parent, CitationStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['bookSeries'] = None
      dataDict['bookTitle'] = None
      dataDict['casAbstractCode'] = None
      dataDict['details'] = None
      dataDict['doi'] = None
      dataDict['firstPage'] = None
      dataDict['isbn'] = None
      dataDict['keywords'] = list()
      dataDict['lastPage'] = None
      dataDict['medlineUiCode'] = None
      dataDict['pubMedId'] = None
      dataDict['publisher'] = None
      dataDict['publisherCity'] = None
      dataDict['serial'] = None
      dataDict['status'] = None
      dataDict['title'] = None
      dataDict['volume'] = None
      dataDict['year'] = None
      dataDict['access'] = None
      dataDict['authors'] = list()
      dataDict['dataLists'] = set()
      dataDict['editors'] = list()
      dataDict['experiments'] = set()
      dataDict['methods'] = set()
      dataDict['molSystems'] = set()
      dataDict['molecules'] = set()
      dataDict['nmrEntries'] = set()
      dataDict['nmrEntriesPrimary'] = list()
      dataDict['nmrProbes'] = set()
      dataDict['nmrSpectrometers'] = set()
      dataDict['protocols'] = set()
      dataDict['ratioShiftReferences'] = set()
      dataDict['sampleConditionSets'] = set()
      dataDict['shiftReferences'] = set()
      dataDict['software'] = set()
      dataDict['targetGroups'] = set()
      dataDict['targets'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Citation.BookCitation.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.general.Citation.BookCitation')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('citations')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Citation.BookCitation:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    authors = dataDict.get('authors')
    pass
    for author in authors:
      topObject = author.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dataLists = dataDict.get('dataLists')
    for dataList in dataLists:
      if (not (dataList in objsToBeDeleted)):
        objsToBeDeleted.add(dataList)
        objsToBeChecked.append(dataList)

    for dataList in dataLists:
      topObject = dataList.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    editors = dataDict.get('editors')
    pass
    for editor in editors:
      topObject = editor.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    experiments = dataDict.get('experiments')
    for experiment in experiments:
      if (not (experiment in objsToBeDeleted)):
        objsToBeDeleted.add(experiment)
        objsToBeChecked.append(experiment)

    for experiment in experiments:
      topObject = experiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    methods = dataDict.get('methods')
    for method in methods:
      if (not (method in objsToBeDeleted)):
        objsToBeDeleted.add(method)
        objsToBeChecked.append(method)

    for method in methods:
      topObject = method.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tobjList = root.__dict__.get('molSystems').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molSystems = dataDict.get('molSystems')
    pass
    for molSystem in molSystems:
      topObject = molSystem.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.molecule.Molecule')
    tobjList = root.__dict__.get('molecules').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molecules = dataDict.get('molecules')
    for molecule in molecules:
      if (not (molecule in objsToBeDeleted)):
        objsToBeDeleted.add(molecule)
        objsToBeChecked.append(molecule)

    for molecule in molecules:
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntries = dataDict.get('nmrEntries')
    pass
    for nmrEntry in nmrEntries:
      topObject = nmrEntry.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tobjList = root.__dict__.get('nmrEntryStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrEntriesPrimary = dataDict.get('nmrEntriesPrimary')
    pass
    for nmrEntryPrimary in nmrEntriesPrimary:
      topObject = nmrEntryPrimary.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrProbes = dataDict.get('nmrProbes')
    for nmrProbe in nmrProbes:
      if (not (nmrProbe in objsToBeDeleted)):
        objsToBeDeleted.add(nmrProbe)
        objsToBeChecked.append(nmrProbe)

    for nmrProbe in nmrProbes:
      topObject = nmrProbe.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Instrument')
    tobjList = root.__dict__.get('instrumentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrSpectrometers = dataDict.get('nmrSpectrometers')
    for nmrSpectrometer in nmrSpectrometers:
      if (not (nmrSpectrometer in objsToBeDeleted)):
        objsToBeDeleted.add(nmrSpectrometer)
        objsToBeChecked.append(nmrSpectrometer)

    for nmrSpectrometer in nmrSpectrometers:
      topObject = nmrSpectrometer.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protocols = dataDict.get('protocols')
    pass
    for protocol in protocols:
      topObject = protocol.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ratioShiftReferences = dataDict.get('ratioShiftReferences')
    for ratioShiftReference in ratioShiftReferences:
      if (not (ratioShiftReference in objsToBeDeleted)):
        objsToBeDeleted.add(ratioShiftReference)
        objsToBeChecked.append(ratioShiftReference)

    for ratioShiftReference in ratioShiftReferences:
      topObject = ratioShiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    sampleConditionSets = dataDict.get('sampleConditionSets')
    for sampleConditionSet in sampleConditionSets:
      if (not (sampleConditionSet in objsToBeDeleted)):
        objsToBeDeleted.add(sampleConditionSet)
        objsToBeChecked.append(sampleConditionSet)

    for sampleConditionSet in sampleConditionSets:
      topObject = sampleConditionSet.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    shiftReferences = dataDict.get('shiftReferences')
    pass
    for shiftReference in shiftReferences:
      topObject = shiftReference.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.general.Method')
    tobjList = root.__dict__.get('methodStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    software_s = dataDict.get('software')
    for software in software_s:
      if (not (software in objsToBeDeleted)):
        objsToBeDeleted.add(software)
        objsToBeChecked.append(software)

    for software in software_s:
      topObject = software.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targetGroups = dataDict.get('targetGroups')
    pass
    for targetGroup in targetGroups:
      topObject = targetGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    targets = dataDict.get('targets')
    pass
    for target in targets:
      topObject = target.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Citation.BookCitation:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for author in dataDict.get('authors'):
      if (not (author in objsToBeDeleted)):
        authorCitations = author.__dict__.get('authorCitations')
        authorCitations.remove(self)

    for editor in dataDict.get('editors'):
      if (not (editor in objsToBeDeleted)):
        editorCitations = editor.__dict__.get('editorCitations')
        editorCitations.remove(self)

    for molSystem in dataDict.get('molSystems'):
      if (not (molSystem in objsToBeDeleted)):
        citations = molSystem.__dict__.get('citations')
        citations.remove(self)

    for nmrEntry in dataDict.get('nmrEntries'):
      if (not (nmrEntry in objsToBeDeleted)):
        otherCitations = nmrEntry.__dict__.get('otherCitations')
        otherCitations.remove(self)

    for nmrEntryPrimary in dataDict.get('nmrEntriesPrimary'):
      if (not (nmrEntryPrimary in objsToBeDeleted)):
        nmrEntryPrimary.__dict__['primaryCitation'] = None

    for protocol in dataDict.get('protocols'):
      if (not (protocol in objsToBeDeleted)):
        references = protocol.__dict__.get('references')
        references.remove(self)

    for shiftReference in dataDict.get('shiftReferences'):
      if (not (shiftReference in objsToBeDeleted)):
        shiftReference.__dict__['citation'] = None

    for targetGroup in dataDict.get('targetGroups'):
      if (not (targetGroup in objsToBeDeleted)):
        citations = targetGroup.__dict__.get('citations')
        citations.remove(self)

    for target in dataDict.get('targets'):
      if (not (target in objsToBeDeleted)):
        citations = target.__dict__.get('citations')
        citations.remove(self)

    citationStore = dataDict.get('citationStore')
    if (not (citationStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = citationStore.__dict__.get('citations')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addAuthor = Citation.addAuthor

  addEditor = Citation.addEditor

  addKeyword = Citation.addKeyword

  addMolSystem = Citation.addMolSystem

  addNmrEntry = Citation.addNmrEntry

  addNmrEntryPrimary = Citation.addNmrEntryPrimary

  addProtocol = Citation.addProtocol

  addShiftReference = Citation.addShiftReference

  addTarget = Citation.addTarget

  addTargetGroup = Citation.addTargetGroup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Citation.BookCitation
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Citation.BookCitation
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('citationStore')
        dd = value.__dict__.get('citations')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'citationStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('bookSeries')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: bookSeries:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: bookSeries:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: bookSeries:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('bookTitle')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: bookTitle:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: bookTitle:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: bookTitle:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casAbstractCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casAbstractCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: casAbstractCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('doi')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: doi:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('firstPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: firstPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: firstPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isbn')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: isbn:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: isbn:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: isbn:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: isbn:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastPage')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastPage:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: lastPage:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('medlineUiCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: medlineUiCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: medlineUiCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('pubMedId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: pubMedId:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: pubMedId:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('publisher')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: publisher:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: publisher:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: publisher:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('publisherCity')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: publisherCity:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: publisherCity:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: publisherCity:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('status')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: status:
           ccp.general.Citation.CitationStatus: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: status:
           CitationStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('title')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: title:
           memops.Implementation.SingleLine input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: title:
           SingleLine constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('volume')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: volume:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: volume:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: volume:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: volume:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('year')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: year:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('authors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: authors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('authorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: authors:
           non-reciprocal link authors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('citationStore')
      if (not isinstance(value, CitationStore)):
        raise ApiError("""%s.checkValid: citationStore:
         value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dataLists')
      for value in values:
        from ccp.api.nmr.Nmr import DataList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataLists:
           value is not of class ccp.nmr.Nmr.DataList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: dataLists:
           non-reciprocal link dataLists from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('editors')
      for value in values:
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: editors:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('editorCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: editors:
           non-reciprocal link editors from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('experiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: experiments:
           non-reciprocal link experiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('methods')
      for value in values:
        from ccp.api.general.Method import Method as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: methods:
           value is not of class ccp.general.Method.Method""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: methods:
           non-reciprocal link methods from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.MolSystem')
      tobjList = root.__dict__.get('molSystems').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molSystems')
      for value in values:
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystems:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molSystems:
           non-reciprocal link molSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.molecule.Molecule')
      tobjList = root.__dict__.get('molecules').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molecules')
      for value in values:
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecules:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecules:
           non-reciprocal link molecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntries')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntries:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('otherCitations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrEntries:
           non-reciprocal link nmrEntries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntries:
           Link nmrEntries between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      tobjList = root.__dict__.get('nmrEntryStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrEntriesPrimary')
      for value in values:
        from ccp.api.nmr.NmrEntry import Entry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           value is not of class ccp.nmr.NmrEntry.Entry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('primaryCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           non-reciprocal link nmrEntriesPrimary from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrEntriesPrimary:
           Link nmrEntriesPrimary between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrProbes')
      for value in values:
        from ccp.api.general.Instrument import NmrProbe as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrProbes:
           value is not of class ccp.general.Instrument.NmrProbe""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrProbes:
           non-reciprocal link nmrProbes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Instrument')
      tobjList = root.__dict__.get('instrumentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrSpectrometers')
      for value in values:
        from ccp.api.general.Instrument import NmrSpectrometer as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           value is not of class ccp.general.Instrument.NmrSpectrometer""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nmrSpectrometers:
           non-reciprocal link nmrSpectrometers from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protocols')
      for value in values:
        from ccp.api.lims.Protocol import Protocol as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protocols:
           value is not of class ccp.lims.Protocol.Protocol""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('references')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: protocols:
           non-reciprocal link protocols from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protocols:
           Link protocols between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('ratioShiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('shiftRatioCitation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           non-reciprocal link ratioShiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: ratioShiftReferences:
           Link ratioShiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('sampleConditionSets')
      for value in values:
        from ccp.api.nmr.Nmr import SampleConditionSet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           value is not of class ccp.nmr.Nmr.SampleConditionSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleConditionSets:
           non-reciprocal link sampleConditionSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('shiftReferences')
      for value in values:
        from ccp.api.nmr.Nmr import ShiftReference as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: shiftReferences:
           value is not of class ccp.nmr.Nmr.ShiftReference""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('citation')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: shiftReferences:
           non-reciprocal link shiftReferences from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: shiftReferences:
           Link shiftReferences between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.general.Method')
      tobjList = root.__dict__.get('methodStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('software')
      for value in values:
        from ccp.api.general.Method import Software as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: software:
           value is not of class ccp.general.Method.Software""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: software:
           non-reciprocal link software from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targetGroups')
      for value in values:
        from ccp.api.lims.Target import TargetGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targetGroups:
           value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targetGroups:
           non-reciprocal link targetGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('targets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('citations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targets:
           non-reciprocal link targets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('bookSeries')
    value = dataDict.get('bookTitle')
    value = dataDict.get('casAbstractCode')
    value = dataDict.get('details')
    value = dataDict.get('doi')
    value = dataDict.get('firstPage')
    value = dataDict.get('isbn')
    values = dataDict.get('keywords')
    value = dataDict.get('lastPage')
    value = dataDict.get('medlineUiCode')
    value = dataDict.get('pubMedId')
    value = dataDict.get('publisher')
    value = dataDict.get('publisherCity')
    value = dataDict.get('status')
    value = dataDict.get('title')
    value = dataDict.get('volume')
    value = dataDict.get('year')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('authors')
    value = dataDict.get('citationStore')
    if (value is None):
      raise ApiError("""%s.checkValid: citationStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('dataLists')
    values = dataDict.get('editors')
    values = dataDict.get('experiments')
    values = dataDict.get('methods')
    values = dataDict.get('molSystems')
    values = dataDict.get('molecules')
    values = dataDict.get('nmrEntries')
    values = dataDict.get('nmrEntriesPrimary')
    values = dataDict.get('nmrProbes')
    values = dataDict.get('nmrSpectrometers')
    values = dataDict.get('protocols')
    values = dataDict.get('ratioShiftReferences')
    values = dataDict.get('sampleConditionSets')
    values = dataDict.get('shiftReferences')
    values = dataDict.get('software')
    values = dataDict.get('targetGroups')
    values = dataDict.get('targets')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllAuthors = Citation.findAllAuthors

  findAllDataLists = Citation.findAllDataLists

  findAllEditors = Citation.findAllEditors

  findAllExperiments = Citation.findAllExperiments

  findAllMethods = Citation.findAllMethods

  findAllMolSystems = Citation.findAllMolSystems

  findAllMolecules = Citation.findAllMolecules

  findAllNmrEntries = Citation.findAllNmrEntries

  findAllNmrEntriesPrimary = Citation.findAllNmrEntriesPrimary

  findAllNmrProbes = Citation.findAllNmrProbes

  findAllNmrSpectrometers = Citation.findAllNmrSpectrometers

  findAllProtocols = Citation.findAllProtocols

  findAllRatioShiftReferences = Citation.findAllRatioShiftReferences

  findAllSampleConditionSets = Citation.findAllSampleConditionSets

  findAllShiftReferences = Citation.findAllShiftReferences

  findAllSoftware = Citation.findAllSoftware

  findAllTargetGroups = Citation.findAllTargetGroups

  findAllTargets = Citation.findAllTargets

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstAuthor = Citation.findFirstAuthor

  findFirstDataList = Citation.findFirstDataList

  findFirstEditor = Citation.findFirstEditor

  findFirstExperiment = Citation.findFirstExperiment

  findFirstMethod = Citation.findFirstMethod

  findFirstMolSystem = Citation.findFirstMolSystem

  findFirstMolecule = Citation.findFirstMolecule

  findFirstNmrEntry = Citation.findFirstNmrEntry

  findFirstNmrEntryPrimary = Citation.findFirstNmrEntryPrimary

  findFirstNmrProbe = Citation.findFirstNmrProbe

  findFirstNmrSpectrometer = Citation.findFirstNmrSpectrometer

  findFirstProtocol = Citation.findFirstProtocol

  findFirstRatioShiftReference = Citation.findFirstRatioShiftReference

  findFirstSampleConditionSet = Citation.findFirstSampleConditionSet

  findFirstShiftReference = Citation.findFirstShiftReference

  findFirstSoftware = Citation.findFirstSoftware

  findFirstTarget = Citation.findFirstTarget

  findFirstTargetGroup = Citation.findFirstTargetGroup
  
  def get(self, name):
    """
    GetAttr for ccp.general.Citation.BookCitation
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getAuthors = Citation.getAuthors
  
  def getBookSeries(self):
    """
    Get for ccp.general.Citation.BookCitation.bookSeries
    """
    dataDict = self.__dict__
    result = dataDict.get('bookSeries')
    return result
  
  def getBookTitle(self):
    """
    Get for ccp.general.Citation.BookCitation.bookTitle
    """
    dataDict = self.__dict__
    result = dataDict.get('bookTitle')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Citation.BookCitation
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.BookCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('citationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Citation')
        obj1 = obj0.__dict__.get('citationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Citation.BookCitation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('citations').get(objKey)
      if (isinstance(obj2, BookCitation)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasAbstractCode = Citation.getCasAbstractCode

  getCitationStore = Citation.getCitationStore

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getDataLists = Citation.getDataLists

  getDetails = Citation.getDetails

  getDoi = Citation.getDoi

  getEditors = Citation.getEditors

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getExperiments = Citation.getExperiments

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFirstPage = Citation.getFirstPage

  getFullKey = Citation.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsbn(self):
    """
    Get for ccp.general.Citation.BookCitation.isbn
    """
    dataDict = self.__dict__
    result = dataDict.get('isbn')
    return result

  getKeywords = Citation.getKeywords

  getLastPage = Citation.getLastPage

  getLocalKey = Citation.getLocalKey

  getMedlineUiCode = Citation.getMedlineUiCode

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMethods = Citation.getMethods

  getMolSystems = Citation.getMolSystems

  getMolecules = Citation.getMolecules

  getNmrEntries = Citation.getNmrEntries

  getNmrEntriesPrimary = Citation.getNmrEntriesPrimary

  getNmrProbes = Citation.getNmrProbes

  getNmrSpectrometers = Citation.getNmrSpectrometers

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = Citation.getParent

  getProtocols = Citation.getProtocols

  getPubMedId = Citation.getPubMedId
  
  def getPublisher(self):
    """
    Get for ccp.general.Citation.BookCitation.publisher
    """
    dataDict = self.__dict__
    result = dataDict.get('publisher')
    return result
  
  def getPublisherCity(self):
    """
    Get for ccp.general.Citation.BookCitation.publisherCity
    """
    dataDict = self.__dict__
    result = dataDict.get('publisherCity')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRatioShiftReferences = Citation.getRatioShiftReferences

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSampleConditionSets = Citation.getSampleConditionSets

  getSerial = Citation.getSerial

  getShiftReferences = Citation.getShiftReferences

  getSoftware = Citation.getSoftware

  getStatus = Citation.getStatus

  getTargetGroups = Citation.getTargetGroups

  getTargets = Citation.getTargets

  getTitle = Citation.getTitle

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getVolume(self):
    """
    Get for ccp.general.Citation.BookCitation.volume
    """
    dataDict = self.__dict__
    result = dataDict.get('volume')
    return result

  getYear = Citation.getYear

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeAuthor = Citation.removeAuthor

  removeEditor = Citation.removeEditor

  removeKeyword = Citation.removeKeyword

  removeMolSystem = Citation.removeMolSystem

  removeNmrEntry = Citation.removeNmrEntry

  removeNmrEntryPrimary = Citation.removeNmrEntryPrimary

  removeProtocol = Citation.removeProtocol

  removeShiftReference = Citation.removeShiftReference

  removeTarget = Citation.removeTarget

  removeTargetGroup = Citation.removeTargetGroup
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Citation.BookCitation
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setAuthors = Citation.setAuthors
  
  def setBookSeries(self, value):
    """
    Set for ccp.general.Citation.BookCitation.bookSeries
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setBookSeries:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setBookSeries:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setBookSeries:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('bookSeries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBookSeries:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBookSeries:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['bookSeries'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBookSeries')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setBookTitle(self, value):
    """
    Set for ccp.general.Citation.BookCitation.bookTitle
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setBookTitle:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setBookTitle:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setBookTitle:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('bookTitle')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBookTitle:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBookTitle:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['bookTitle'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBookTitle')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCasAbstractCode = Citation.setCasAbstractCode

  setDataLists = Citation.setDataLists

  setDetails = Citation.setDetails

  setDoi = Citation.setDoi

  setEditors = Citation.setEditors

  setExperiments = Citation.setExperiments

  setFirstPage = Citation.setFirstPage
  
  def setIsbn(self, value):
    """
    Set for ccp.general.Citation.BookCitation.isbn
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setIsbn:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setIsbn:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setIsbn:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setIsbn:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isbn')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsbn:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsbn:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['isbn'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsbn')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setKeywords = Citation.setKeywords

  setLastPage = Citation.setLastPage

  setMedlineUiCode = Citation.setMedlineUiCode

  setMethods = Citation.setMethods

  setMolSystems = Citation.setMolSystems

  setMolecules = Citation.setMolecules

  setNmrEntries = Citation.setNmrEntries

  setNmrEntriesPrimary = Citation.setNmrEntriesPrimary

  setNmrProbes = Citation.setNmrProbes

  setNmrSpectrometers = Citation.setNmrSpectrometers

  setProtocols = Citation.setProtocols

  setPubMedId = Citation.setPubMedId
  
  def setPublisher(self, value):
    """
    Set for ccp.general.Citation.BookCitation.publisher
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPublisher:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setPublisher:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPublisher:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('publisher')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPublisher:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPublisher:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['publisher'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPublisher')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPublisherCity(self, value):
    """
    Set for ccp.general.Citation.BookCitation.publisherCity
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPublisherCity:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setPublisherCity:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPublisherCity:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('publisherCity')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPublisherCity:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPublisherCity:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['publisherCity'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPublisherCity')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setRatioShiftReferences = Citation.setRatioShiftReferences

  setSampleConditionSets = Citation.setSampleConditionSets

  setSerial = Citation.setSerial

  setShiftReferences = Citation.setShiftReferences

  setSoftware = Citation.setSoftware

  setStatus = Citation.setStatus

  setTargetGroups = Citation.setTargetGroups

  setTargets = Citation.setTargets

  setTitle = Citation.setTitle
  
  def setVolume(self, value):
    """
    Set for ccp.general.Citation.BookCitation.volume
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setVolume:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setVolume:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setVolume:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setVolume:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('volume')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setVolume:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setVolume:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['volume'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setVolume')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setYear = Citation.setYear

  sortedDataLists = Citation.sortedDataLists

  sortedExperiments = Citation.sortedExperiments

  sortedMethods = Citation.sortedMethods

  sortedMolSystems = Citation.sortedMolSystems

  sortedMolecules = Citation.sortedMolecules

  sortedNmrEntries = Citation.sortedNmrEntries

  sortedNmrProbes = Citation.sortedNmrProbes

  sortedNmrSpectrometers = Citation.sortedNmrSpectrometers

  sortedProtocols = Citation.sortedProtocols

  sortedRatioShiftReferences = Citation.sortedRatioShiftReferences

  sortedSampleConditionSets = Citation.sortedSampleConditionSets

  sortedShiftReferences = Citation.sortedShiftReferences

  sortedSoftware = Citation.sortedSoftware

  sortedTargetGroups = Citation.sortedTargetGroups

  sortedTargets = Citation.sortedTargets

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  bookSeries = property(getBookSeries, setBookSeries, None,
  r"""Series of which book forms part
  """)
  
  bookTitle = property(getBookTitle, setBookTitle, None,
  r"""Title of book
  """)

  casAbstractCode = Citation.casAbstractCode

  className = memops.api.Implementation.ComplexDataType.className

  details = Citation.details

  doi = Citation.doi

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  firstPage = Citation.firstPage

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isbn = property(getIsbn, setIsbn, None,
  r"""ISBN code for book
  """)

  keywords = Citation.keywords

  lastPage = Citation.lastPage

  medlineUiCode = Citation.medlineUiCode

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  pubMedId = Citation.pubMedId
  
  publisher = property(getPublisher, setPublisher, None,
  r"""Book publisher
  """)
  
  publisherCity = property(getPublisherCity, setPublisherCity, None,
  r"""City of book publisher
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Citation.serial

  status = Citation.status

  title = Citation.title
  
  volume = property(getVolume, setVolume, None,
  r"""Volume 'number' (not an integer)
  """)

  year = Citation.year

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  authors = Citation.authors

  citationStore = Citation.citationStore

  dataLists = Citation.dataLists

  editors = Citation.editors

  experiments = Citation.experiments

  methods = Citation.methods

  molSystems = Citation.molSystems

  molecules = Citation.molecules

  nmrEntries = Citation.nmrEntries

  nmrEntriesPrimary = Citation.nmrEntriesPrimary

  nmrProbes = Citation.nmrProbes

  nmrSpectrometers = Citation.nmrSpectrometers

  parent = Citation.parent

  protocols = Citation.protocols

  ratioShiftReferences = Citation.ratioShiftReferences

  root = memops.api.Implementation.MemopsObject.root

  sampleConditionSets = Citation.sampleConditionSets

  shiftReferences = Citation.shiftReferences

  software = Citation.software

  targetGroups = Citation.targetGroups

  targets = Citation.targets

  topObject = memops.api.Implementation.DataObject.topObject
