"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyXmlMapWrite revision 1.29 on Fri Mar 28 11:17:44 2014
  from data model element memops.Implementation revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Implementation.py: python XML-I/O-mapping for CCPN data model, MetaPackage memops.Implementation

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import memops.api.Implementation

# ApiError import
from memops.general.Implementation import ApiError

def bool2str(value):
  return value and 'true' or 'false'

def str2bool(value):
  if value in ('True', 'true', '1'):
    return True
  elif value in ('False', 'false', '0'):
    return False
  else:
    raise ApiError("String '%s' is not legal for a Boolean" % value)

_globalMapping = {}

def getGlobalMap(oldVersionStr=None):

  from memops.general.Constants import currentModelVersion
  newVersionStr = str(currentModelVersion)
  
  if oldVersionStr is None:
    oldVersionStr = newVersionStr

  versionMapping = _globalMapping.get(oldVersionStr)
  if versionMapping is None:
    versionMapping = {}
    _globalMapping[oldVersionStr] = versionMapping
    
    makeMapping(versionMapping)

    import memops.xml.AccessControl
    memops.xml.AccessControl.makeMapping(versionMapping)

    import ccp.xml.general.KeywordDefinition
    ccp.xml.general.KeywordDefinition.makeMapping(versionMapping)

    import ccp.xml.general.DataLocation
    ccp.xml.general.DataLocation.makeMapping(versionMapping)

    import ccp.xml.molecule.ChemElement
    ccp.xml.molecule.ChemElement.makeMapping(versionMapping)

    import ccp.xml.molecule.Stereochemistry
    ccp.xml.molecule.Stereochemistry.makeMapping(versionMapping)

    import ccp.xml.general.DbRef
    ccp.xml.general.DbRef.makeMapping(versionMapping)

    import ccp.xml.general.Taxonomy
    ccp.xml.general.Taxonomy.makeMapping(versionMapping)

    import ccp.xml.general.Template
    ccp.xml.general.Template.makeMapping(versionMapping)

    import ccp.xml.lims.Classification
    ccp.xml.lims.Classification.makeMapping(versionMapping)

    import ccp.xml.general.Affiliation
    ccp.xml.general.Affiliation.makeMapping(versionMapping)

    import ccp.xml.nmr.NmrExpPrototype
    ccp.xml.nmr.NmrExpPrototype.makeMapping(versionMapping)

    import ccp.xml.molecule.ChemComp
    ccp.xml.molecule.ChemComp.makeMapping(versionMapping)

    import ccp.xml.lims.Location
    ccp.xml.lims.Location.makeMapping(versionMapping)

    import ccp.xml.general.Citation
    ccp.xml.general.Citation.makeMapping(versionMapping)

    import ccpnmr.xml.AnalysisWindow
    ccpnmr.xml.AnalysisWindow.makeMapping(versionMapping)

    import ccp.xml.molecule.ChemCompLabel
    ccp.xml.molecule.ChemCompLabel.makeMapping(versionMapping)

    import ccp.xml.molecule.ChemCompCharge
    ccp.xml.molecule.ChemCompCharge.makeMapping(versionMapping)

    import ccpnmr.xml.AnalysisProfile
    ccpnmr.xml.AnalysisProfile.makeMapping(versionMapping)

    import ccp.xml.nmr.NmrReference
    ccp.xml.nmr.NmrReference.makeMapping(versionMapping)

    import ccp.xml.molecule.ChemCompCoord
    ccp.xml.molecule.ChemCompCoord.makeMapping(versionMapping)

    import ccp.xml.lims.Holder
    ccp.xml.lims.Holder.makeMapping(versionMapping)

    import ccp.xml.general.Instrument
    ccp.xml.general.Instrument.makeMapping(versionMapping)

    import ccpnmr.xml.AnalysisLayout
    ccpnmr.xml.AnalysisLayout.makeMapping(versionMapping)

    import ccp.xml.molecule.Molecule
    ccp.xml.molecule.Molecule.makeMapping(versionMapping)

    import ccp.xml.general.Method
    ccp.xml.general.Method.makeMapping(versionMapping)

    import ccpnmr.xml.NameMapping
    ccpnmr.xml.NameMapping.makeMapping(versionMapping)

    import ccp.xml.molecule.LabeledMolecule
    ccp.xml.molecule.LabeledMolecule.makeMapping(versionMapping)

    import ccp.xml.molecule.MolSystem
    ccp.xml.molecule.MolSystem.makeMapping(versionMapping)

    import molsim.xml.AnnealProtocol
    molsim.xml.AnnealProtocol.makeMapping(versionMapping)

    import ccp.xml.lims.RefSampleComponent
    ccp.xml.lims.RefSampleComponent.makeMapping(versionMapping)

    import ccp.xml.molecule.Validation
    ccp.xml.molecule.Validation.makeMapping(versionMapping)

    import molsim.xml.Symmetry
    molsim.xml.Symmetry.makeMapping(versionMapping)

    import ccp.xml.lims.Sample
    ccp.xml.lims.Sample.makeMapping(versionMapping)

    import ccp.xml.lims.Target
    ccp.xml.lims.Target.makeMapping(versionMapping)

    import ccp.xml.molecule.MolStructure
    ccp.xml.molecule.MolStructure.makeMapping(versionMapping)

    import ccp.xml.lims.Crystallization
    ccp.xml.lims.Crystallization.makeMapping(versionMapping)

    import ccp.xml.lims.Protocol
    ccp.xml.lims.Protocol.makeMapping(versionMapping)

    import ccp.xml.lims.ExpBlueprint
    ccp.xml.lims.ExpBlueprint.makeMapping(versionMapping)

    import ccp.xml.nmr.Nmr
    ccp.xml.nmr.Nmr.makeMapping(versionMapping)

    import ccp.xml.lims.Experiment
    ccp.xml.lims.Experiment.makeMapping(versionMapping)

    import ccp.xml.nmr.NmrConstraint
    ccp.xml.nmr.NmrConstraint.makeMapping(versionMapping)

    import ccp.xml.nmr.NmrEntry
    ccp.xml.nmr.NmrEntry.makeMapping(versionMapping)

    import ccp.xml.lims.RefData
    ccp.xml.lims.RefData.makeMapping(versionMapping)

    import ccpnmr.xml.Analysis
    ccpnmr.xml.Analysis.makeMapping(versionMapping)

    import ccp.xml.general.Annotation
    ccp.xml.general.Annotation.makeMapping(versionMapping)

    import utrecht.xml.Haddock
    utrecht.xml.Haddock.makeMapping(versionMapping)

    import cambridge.xml.Dangle
    cambridge.xml.Dangle.makeMapping(versionMapping)

    import ccp.xml.nmr.NmrCalc
    ccp.xml.nmr.NmrCalc.makeMapping(versionMapping)

    import ccp.xml.nmr.NmrScreen
    ccp.xml.nmr.NmrScreen.makeMapping(versionMapping)

    import ccpnmr.xml.AnalysisV3
    ccpnmr.xml.AnalysisV3.makeMapping(versionMapping)

    import cambridge.xml.WmsProtocol
    cambridge.xml.WmsProtocol.makeMapping(versionMapping)

    import cambridge.xml.Wms
    cambridge.xml.Wms.makeMapping(versionMapping)

    import cambridge.xml.WmsQuery
    cambridge.xml.WmsQuery.makeMapping(versionMapping)

    # adjust Io map for compatibility considerations
    if oldVersionStr != newVersionStr:
      from memops.format.compatibility.part1.Converters1 import modifyIoMap
      # versions are different - compatibility needed
      modifyIoMap(oldVersionStr, versionMapping)
  #
  return versionMapping

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package IMPL, adding it to globalMap
  """

  # Set up global dictionaries
  loadMaps = {}
  globalMap['loadMaps'] = loadMaps
  mapsByGuid = {}
  globalMap['mapsByGuid'] = mapsByGuid

  # IMPL - <MetaPackage: memops.Implementation>: Set up top level dictionaries
  currentMap = {}
  globalMap['IMPL'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'IMPL'
  abstractTypes['.qName'] = 'memops.Implementation'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'IMPL'
  exolinks['.qName'] = 'memops.Implementation'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00025'
  currentMap['.prefix'] = 'IMPL'
  currentMap['.qName'] = 'memops.Implementation'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ACCO - <MetaPackage: memops.AccessControl>: Set up top level dictionaries
  currentMap = {}
  globalMap['ACCO'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ACCO'
  abstractTypes['.qName'] = 'memops.AccessControl'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ACCO'
  exolinks['.qName'] = 'memops.AccessControl'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00015'
  currentMap['.prefix'] = 'ACCO'
  currentMap['.qName'] = 'memops.AccessControl'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # KWDF - <MetaPackage: ccp.general.KeywordDefinition>: Set up top level dictionaries
  currentMap = {}
  globalMap['KWDF'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'KWDF'
  abstractTypes['.qName'] = 'ccp.general.KeywordDefinition'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'KWDF'
  exolinks['.qName'] = 'ccp.general.KeywordDefinition'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-14-17:02:54_00001'
  currentMap['.prefix'] = 'KWDF'
  currentMap['.qName'] = 'ccp.general.KeywordDefinition'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # DLOC - <MetaPackage: ccp.general.DataLocation>: Set up top level dictionaries
  currentMap = {}
  globalMap['DLOC'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'DLOC'
  abstractTypes['.qName'] = 'ccp.general.DataLocation'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'DLOC'
  exolinks['.qName'] = 'ccp.general.DataLocation'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-03-19:08:10_00001'
  currentMap['.prefix'] = 'DLOC'
  currentMap['.qName'] = 'ccp.general.DataLocation'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CHEL - <MetaPackage: ccp.molecule.ChemElement>: Set up top level dictionaries
  currentMap = {}
  globalMap['CHEL'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CHEL'
  abstractTypes['.qName'] = 'ccp.molecule.ChemElement'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CHEL'
  exolinks['.qName'] = 'ccp.molecule.ChemElement'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:49_00002'
  currentMap['.prefix'] = 'CHEL'
  currentMap['.qName'] = 'ccp.molecule.ChemElement'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # STER - <MetaPackage: ccp.molecule.Stereochemistry>: Set up top level dictionaries
  currentMap = {}
  globalMap['STER'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'STER'
  abstractTypes['.qName'] = 'ccp.molecule.Stereochemistry'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'STER'
  exolinks['.qName'] = 'ccp.molecule.Stereochemistry'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00054'
  currentMap['.prefix'] = 'STER'
  currentMap['.qName'] = 'ccp.molecule.Stereochemistry'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # DBR - <MetaPackage: ccp.general.DbRef>: Set up top level dictionaries
  currentMap = {}
  globalMap['DBR'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'DBR'
  abstractTypes['.qName'] = 'ccp.general.DbRef'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'DBR'
  exolinks['.qName'] = 'ccp.general.DbRef'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00019'
  currentMap['.prefix'] = 'DBR'
  currentMap['.qName'] = 'ccp.general.DbRef'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # TAXO - <MetaPackage: ccp.general.Taxonomy>: Set up top level dictionaries
  currentMap = {}
  globalMap['TAXO'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'TAXO'
  abstractTypes['.qName'] = 'ccp.general.Taxonomy'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'TAXO'
  exolinks['.qName'] = 'ccp.general.Taxonomy'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:50_00002'
  currentMap['.prefix'] = 'TAXO'
  currentMap['.qName'] = 'ccp.general.Taxonomy'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # TEMP - <MetaPackage: ccp.general.Template>: Set up top level dictionaries
  currentMap = {}
  globalMap['TEMP'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'TEMP'
  abstractTypes['.qName'] = 'ccp.general.Template'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'TEMP'
  exolinks['.qName'] = 'ccp.general.Template'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:19:50_00004'
  currentMap['.prefix'] = 'TEMP'
  currentMap['.qName'] = 'ccp.general.Template'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CLAS - <MetaPackage: ccp.lims.Classification>: Set up top level dictionaries
  currentMap = {}
  globalMap['CLAS'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CLAS'
  abstractTypes['.qName'] = 'ccp.lims.Classification'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CLAS'
  exolinks['.qName'] = 'ccp.lims.Classification'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-04-17:18:54_00001'
  currentMap['.prefix'] = 'CLAS'
  currentMap['.qName'] = 'ccp.lims.Classification'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # AFFI - <MetaPackage: ccp.general.Affiliation>: Set up top level dictionaries
  currentMap = {}
  globalMap['AFFI'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'AFFI'
  abstractTypes['.qName'] = 'ccp.general.Affiliation'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'AFFI'
  exolinks['.qName'] = 'ccp.general.Affiliation'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00017'
  currentMap['.prefix'] = 'AFFI'
  currentMap['.qName'] = 'ccp.general.Affiliation'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # NMRX - <MetaPackage: ccp.nmr.NmrExpPrototype>: Set up top level dictionaries
  currentMap = {}
  globalMap['NMRX'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'NMRX'
  abstractTypes['.qName'] = 'ccp.nmr.NmrExpPrototype'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'NMRX'
  exolinks['.qName'] = 'ccp.nmr.NmrExpPrototype'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00019'
  currentMap['.prefix'] = 'NMRX'
  currentMap['.qName'] = 'ccp.nmr.NmrExpPrototype'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CHEM - <MetaPackage: ccp.molecule.ChemComp>: Set up top level dictionaries
  currentMap = {}
  globalMap['CHEM'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CHEM'
  abstractTypes['.qName'] = 'ccp.molecule.ChemComp'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CHEM'
  exolinks['.qName'] = 'ccp.molecule.ChemComp'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00046'
  currentMap['.prefix'] = 'CHEM'
  currentMap['.qName'] = 'ccp.molecule.ChemComp'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # LOCA - <MetaPackage: ccp.lims.Location>: Set up top level dictionaries
  currentMap = {}
  globalMap['LOCA'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'LOCA'
  abstractTypes['.qName'] = 'ccp.lims.Location'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'LOCA'
  exolinks['.qName'] = 'ccp.lims.Location'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00063'
  currentMap['.prefix'] = 'LOCA'
  currentMap['.qName'] = 'ccp.lims.Location'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CITA - <MetaPackage: ccp.general.Citation>: Set up top level dictionaries
  currentMap = {}
  globalMap['CITA'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CITA'
  abstractTypes['.qName'] = 'ccp.general.Citation'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CITA'
  exolinks['.qName'] = 'ccp.general.Citation'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:55_00010'
  currentMap['.prefix'] = 'CITA'
  currentMap['.qName'] = 'ccp.general.Citation'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANAW - <MetaPackage: ccpnmr.AnalysisWindow>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANAW'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANAW'
  abstractTypes['.qName'] = 'ccpnmr.AnalysisWindow'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANAW'
  exolinks['.qName'] = 'ccpnmr.AnalysisWindow'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-11-30-10:49:23_00001'
  currentMap['.prefix'] = 'ANAW'
  currentMap['.qName'] = 'ccpnmr.AnalysisWindow'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CCLB - <MetaPackage: ccp.molecule.ChemCompLabel>: Set up top level dictionaries
  currentMap = {}
  globalMap['CCLB'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CCLB'
  abstractTypes['.qName'] = 'ccp.molecule.ChemCompLabel'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CCLB'
  exolinks['.qName'] = 'ccp.molecule.ChemCompLabel'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:25:09_00013'
  currentMap['.prefix'] = 'CCLB'
  currentMap['.qName'] = 'ccp.molecule.ChemCompLabel'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CCCA - <MetaPackage: ccp.molecule.ChemCompCharge>: Set up top level dictionaries
  currentMap = {}
  globalMap['CCCA'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CCCA'
  abstractTypes['.qName'] = 'ccp.molecule.ChemCompCharge'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CCCA'
  exolinks['.qName'] = 'ccp.molecule.ChemCompCharge'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:25:09_00008'
  currentMap['.prefix'] = 'CCCA'
  currentMap['.qName'] = 'ccp.molecule.ChemCompCharge'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANAP - <MetaPackage: ccpnmr.AnalysisProfile>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANAP'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANAP'
  abstractTypes['.qName'] = 'ccpnmr.AnalysisProfile'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANAP'
  exolinks['.qName'] = 'ccpnmr.AnalysisProfile'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00003'
  currentMap['.prefix'] = 'ANAP'
  currentMap['.qName'] = 'ccpnmr.AnalysisProfile'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # NMRR - <MetaPackage: ccp.nmr.NmrReference>: Set up top level dictionaries
  currentMap = {}
  globalMap['NMRR'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'NMRR'
  abstractTypes['.qName'] = 'ccp.nmr.NmrReference'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'NMRR'
  exolinks['.qName'] = 'ccp.nmr.NmrReference'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:25:08_00001'
  currentMap['.prefix'] = 'NMRR'
  currentMap['.qName'] = 'ccp.nmr.NmrReference'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CCCO - <MetaPackage: ccp.molecule.ChemCompCoord>: Set up top level dictionaries
  currentMap = {}
  globalMap['CCCO'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CCCO'
  abstractTypes['.qName'] = 'ccp.molecule.ChemCompCoord'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CCCO'
  exolinks['.qName'] = 'ccp.molecule.ChemCompCoord'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:55_00005'
  currentMap['.prefix'] = 'CCCO'
  currentMap['.qName'] = 'ccp.molecule.ChemCompCoord'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # HOLD - <MetaPackage: ccp.lims.Holder>: Set up top level dictionaries
  currentMap = {}
  globalMap['HOLD'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'HOLD'
  abstractTypes['.qName'] = 'ccp.lims.Holder'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'HOLD'
  exolinks['.qName'] = 'ccp.lims.Holder'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00042'
  currentMap['.prefix'] = 'HOLD'
  currentMap['.qName'] = 'ccp.lims.Holder'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # INST - <MetaPackage: ccp.general.Instrument>: Set up top level dictionaries
  currentMap = {}
  globalMap['INST'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'INST'
  abstractTypes['.qName'] = 'ccp.general.Instrument'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'INST'
  exolinks['.qName'] = 'ccp.general.Instrument'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00038'
  currentMap['.prefix'] = 'INST'
  currentMap['.qName'] = 'ccp.general.Instrument'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANAY - <MetaPackage: ccpnmr.AnalysisLayout>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANAY'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANAY'
  abstractTypes['.qName'] = 'ccpnmr.AnalysisLayout'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANAY'
  exolinks['.qName'] = 'ccpnmr.AnalysisLayout'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-11-30-10:49:23_00003'
  currentMap['.prefix'] = 'ANAY'
  currentMap['.qName'] = 'ccpnmr.AnalysisLayout'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # MOLE - <MetaPackage: ccp.molecule.Molecule>: Set up top level dictionaries
  currentMap = {}
  globalMap['MOLE'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'MOLE'
  abstractTypes['.qName'] = 'ccp.molecule.Molecule'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'MOLE'
  exolinks['.qName'] = 'ccp.molecule.Molecule'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00038'
  currentMap['.prefix'] = 'MOLE'
  currentMap['.qName'] = 'ccp.molecule.Molecule'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # METH - <MetaPackage: ccp.general.Method>: Set up top level dictionaries
  currentMap = {}
  globalMap['METH'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'METH'
  abstractTypes['.qName'] = 'ccp.general.Method'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'METH'
  exolinks['.qName'] = 'ccp.general.Method'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:25:09_00027'
  currentMap['.prefix'] = 'METH'
  currentMap['.qName'] = 'ccp.general.Method'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # NMAP - <MetaPackage: ccpnmr.NameMapping>: Set up top level dictionaries
  currentMap = {}
  globalMap['NMAP'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'NMAP'
  abstractTypes['.qName'] = 'ccpnmr.NameMapping'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'NMAP'
  exolinks['.qName'] = 'ccpnmr.NameMapping'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00004'
  currentMap['.prefix'] = 'NMAP'
  currentMap['.qName'] = 'ccpnmr.NameMapping'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # LMOL - <MetaPackage: ccp.molecule.LabeledMolecule>: Set up top level dictionaries
  currentMap = {}
  globalMap['LMOL'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'LMOL'
  abstractTypes['.qName'] = 'ccp.molecule.LabeledMolecule'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'LMOL'
  exolinks['.qName'] = 'ccp.molecule.LabeledMolecule'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-24-11:28:55_00001'
  currentMap['.prefix'] = 'LMOL'
  currentMap['.qName'] = 'ccp.molecule.LabeledMolecule'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # MOLS - <MetaPackage: ccp.molecule.MolSystem>: Set up top level dictionaries
  currentMap = {}
  globalMap['MOLS'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'MOLS'
  abstractTypes['.qName'] = 'ccp.molecule.MolSystem'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'MOLS'
  exolinks['.qName'] = 'ccp.molecule.MolSystem'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00022'
  currentMap['.prefix'] = 'MOLS'
  currentMap['.qName'] = 'ccp.molecule.MolSystem'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANPR - <MetaPackage: molsim.AnnealProtocol>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANPR'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANPR'
  abstractTypes['.qName'] = 'molsim.AnnealProtocol'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANPR'
  exolinks['.qName'] = 'molsim.AnnealProtocol'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-06-05-13:42:05_00002'
  currentMap['.prefix'] = 'ANPR'
  currentMap['.qName'] = 'molsim.AnnealProtocol'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # REFS - <MetaPackage: ccp.lims.RefSampleComponent>: Set up top level dictionaries
  currentMap = {}
  globalMap['REFS'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'REFS'
  abstractTypes['.qName'] = 'ccp.lims.RefSampleComponent'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'REFS'
  exolinks['.qName'] = 'ccp.lims.RefSampleComponent'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00056'
  currentMap['.prefix'] = 'REFS'
  currentMap['.qName'] = 'ccp.lims.RefSampleComponent'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # VALD - <MetaPackage: ccp.molecule.Validation>: Set up top level dictionaries
  currentMap = {}
  globalMap['VALD'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'VALD'
  abstractTypes['.qName'] = 'ccp.molecule.Validation'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'VALD'
  exolinks['.qName'] = 'ccp.molecule.Validation'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-13-15:55:49_00001'
  currentMap['.prefix'] = 'VALD'
  currentMap['.qName'] = 'ccp.molecule.Validation'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # SYMM - <MetaPackage: molsim.Symmetry>: Set up top level dictionaries
  currentMap = {}
  globalMap['SYMM'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'SYMM'
  abstractTypes['.qName'] = 'molsim.Symmetry'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'SYMM'
  exolinks['.qName'] = 'molsim.Symmetry'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-17:01:34_00001'
  currentMap['.prefix'] = 'SYMM'
  currentMap['.qName'] = 'molsim.Symmetry'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # SAM - <MetaPackage: ccp.lims.Sample>: Set up top level dictionaries
  currentMap = {}
  globalMap['SAM'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'SAM'
  abstractTypes['.qName'] = 'ccp.lims.Sample'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'SAM'
  exolinks['.qName'] = 'ccp.lims.Sample'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:43_00002'
  currentMap['.prefix'] = 'SAM'
  currentMap['.qName'] = 'ccp.lims.Sample'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # TARG - <MetaPackage: ccp.lims.Target>: Set up top level dictionaries
  currentMap = {}
  globalMap['TARG'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'TARG'
  abstractTypes['.qName'] = 'ccp.lims.Target'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'TARG'
  exolinks['.qName'] = 'ccp.lims.Target'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00034'
  currentMap['.prefix'] = 'TARG'
  currentMap['.qName'] = 'ccp.lims.Target'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # COOR - <MetaPackage: ccp.molecule.MolStructure>: Set up top level dictionaries
  currentMap = {}
  globalMap['COOR'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'COOR'
  abstractTypes['.qName'] = 'ccp.molecule.MolStructure'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'COOR'
  exolinks['.qName'] = 'ccp.molecule.MolStructure'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00065'
  currentMap['.prefix'] = 'COOR'
  currentMap['.qName'] = 'ccp.molecule.MolStructure'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CRYZ - <MetaPackage: ccp.lims.Crystallization>: Set up top level dictionaries
  currentMap = {}
  globalMap['CRYZ'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CRYZ'
  abstractTypes['.qName'] = 'ccp.lims.Crystallization'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CRYZ'
  exolinks['.qName'] = 'ccp.lims.Crystallization'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00056'
  currentMap['.prefix'] = 'CRYZ'
  currentMap['.qName'] = 'ccp.lims.Crystallization'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # PROT - <MetaPackage: ccp.lims.Protocol>: Set up top level dictionaries
  currentMap = {}
  globalMap['PROT'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'PROT'
  abstractTypes['.qName'] = 'ccp.lims.Protocol'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'PROT'
  exolinks['.qName'] = 'ccp.lims.Protocol'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:44_00017'
  currentMap['.prefix'] = 'PROT'
  currentMap['.qName'] = 'ccp.lims.Protocol'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # EXPB - <MetaPackage: ccp.lims.ExpBlueprint>: Set up top level dictionaries
  currentMap = {}
  globalMap['EXPB'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'EXPB'
  abstractTypes['.qName'] = 'ccp.lims.ExpBlueprint'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'EXPB'
  exolinks['.qName'] = 'ccp.lims.ExpBlueprint'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00041'
  currentMap['.prefix'] = 'EXPB'
  currentMap['.qName'] = 'ccp.lims.ExpBlueprint'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # NMR - <MetaPackage: ccp.nmr.Nmr>: Set up top level dictionaries
  currentMap = {}
  globalMap['NMR'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'NMR'
  abstractTypes['.qName'] = 'ccp.nmr.Nmr'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'NMR'
  exolinks['.qName'] = 'ccp.nmr.Nmr'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:46_00006'
  currentMap['.prefix'] = 'NMR'
  currentMap['.qName'] = 'ccp.nmr.Nmr'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # EXPE - <MetaPackage: ccp.lims.Experiment>: Set up top level dictionaries
  currentMap = {}
  globalMap['EXPE'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'EXPE'
  abstractTypes['.qName'] = 'ccp.lims.Experiment'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'EXPE'
  exolinks['.qName'] = 'ccp.lims.Experiment'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:44_00010'
  currentMap['.prefix'] = 'EXPE'
  currentMap['.qName'] = 'ccp.lims.Experiment'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # NMRC - <MetaPackage: ccp.nmr.NmrConstraint>: Set up top level dictionaries
  currentMap = {}
  globalMap['NMRC'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'NMRC'
  abstractTypes['.qName'] = 'ccp.nmr.NmrConstraint'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'NMRC'
  exolinks['.qName'] = 'ccp.nmr.NmrConstraint'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00001'
  currentMap['.prefix'] = 'NMRC'
  currentMap['.qName'] = 'ccp.nmr.NmrConstraint'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ENTR - <MetaPackage: ccp.nmr.NmrEntry>: Set up top level dictionaries
  currentMap = {}
  globalMap['ENTR'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ENTR'
  abstractTypes['.qName'] = 'ccp.nmr.NmrEntry'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ENTR'
  exolinks['.qName'] = 'ccp.nmr.NmrEntry'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:25:09_00019'
  currentMap['.prefix'] = 'ENTR'
  currentMap['.qName'] = 'ccp.nmr.NmrEntry'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # REFD - <MetaPackage: ccp.lims.RefData>: Set up top level dictionaries
  currentMap = {}
  globalMap['REFD'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'REFD'
  abstractTypes['.qName'] = 'ccp.lims.RefData'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'REFD'
  exolinks['.qName'] = 'ccp.lims.RefData'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2012-03-28-17:19:49_00001'
  currentMap['.prefix'] = 'REFD'
  currentMap['.qName'] = 'ccp.lims.RefData'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANAL - <MetaPackage: ccpnmr.Analysis>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANAL'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANAL'
  abstractTypes['.qName'] = 'ccpnmr.Analysis'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANAL'
  exolinks['.qName'] = 'ccpnmr.Analysis'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:20_00002'
  currentMap['.prefix'] = 'ANAL'
  currentMap['.qName'] = 'ccpnmr.Analysis'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANNO - <MetaPackage: ccp.general.Annotation>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANNO'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANNO'
  abstractTypes['.qName'] = 'ccp.general.Annotation'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANNO'
  exolinks['.qName'] = 'ccp.general.Annotation'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:25:09_00024'
  currentMap['.prefix'] = 'ANNO'
  currentMap['.qName'] = 'ccp.general.Annotation'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # HADD - <MetaPackage: utrecht.Haddock>: Set up top level dictionaries
  currentMap = {}
  globalMap['HADD'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'HADD'
  abstractTypes['.qName'] = 'utrecht.Haddock'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'HADD'
  exolinks['.qName'] = 'utrecht.Haddock'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00002'
  currentMap['.prefix'] = 'HADD'
  currentMap['.qName'] = 'utrecht.Haddock'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # DANG - <MetaPackage: cambridge.Dangle>: Set up top level dictionaries
  currentMap = {}
  globalMap['DANG'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'DANG'
  abstractTypes['.qName'] = 'cambridge.Dangle'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'DANG'
  exolinks['.qName'] = 'cambridge.Dangle'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-10-01-14:13:59_00001'
  currentMap['.prefix'] = 'DANG'
  currentMap['.qName'] = 'cambridge.Dangle'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # CALC - <MetaPackage: ccp.nmr.NmrCalc>: Set up top level dictionaries
  currentMap = {}
  globalMap['CALC'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'CALC'
  abstractTypes['.qName'] = 'ccp.nmr.NmrCalc'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'CALC'
  exolinks['.qName'] = 'ccp.nmr.NmrCalc'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:57_00001'
  currentMap['.prefix'] = 'CALC'
  currentMap['.qName'] = 'ccp.nmr.NmrCalc'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # NMRS - <MetaPackage: ccp.nmr.NmrScreen>: Set up top level dictionaries
  currentMap = {}
  globalMap['NMRS'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'NMRS'
  abstractTypes['.qName'] = 'ccp.nmr.NmrScreen'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'NMRS'
  exolinks['.qName'] = 'ccp.nmr.NmrScreen'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00001'
  currentMap['.prefix'] = 'NMRS'
  currentMap['.qName'] = 'ccp.nmr.NmrScreen'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # ANA3 - <MetaPackage: ccpnmr.AnalysisV3>: Set up top level dictionaries
  currentMap = {}
  globalMap['ANA3'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'ANA3'
  abstractTypes['.qName'] = 'ccpnmr.AnalysisV3'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'ANA3'
  exolinks['.qName'] = 'ccpnmr.AnalysisV3'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-11-16-17:07:14_00001'
  currentMap['.prefix'] = 'ANA3'
  currentMap['.qName'] = 'ccpnmr.AnalysisV3'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # WMSP - <MetaPackage: cambridge.WmsProtocol>: Set up top level dictionaries
  currentMap = {}
  globalMap['WMSP'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'WMSP'
  abstractTypes['.qName'] = 'cambridge.WmsProtocol'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'WMSP'
  exolinks['.qName'] = 'cambridge.WmsProtocol'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00001'
  currentMap['.prefix'] = 'WMSP'
  currentMap['.qName'] = 'cambridge.WmsProtocol'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # WMS - <MetaPackage: cambridge.Wms>: Set up top level dictionaries
  currentMap = {}
  globalMap['WMS'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'WMS'
  abstractTypes['.qName'] = 'cambridge.Wms'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'WMS'
  exolinks['.qName'] = 'cambridge.Wms'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:52_00001'
  currentMap['.prefix'] = 'WMS'
  currentMap['.qName'] = 'cambridge.Wms'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries

  # WMSQ - <MetaPackage: cambridge.WmsQuery>: Set up top level dictionaries
  currentMap = {}
  globalMap['WMSQ'] = currentMap
  abstractTypes = {}
  currentMap['abstractTypes'] = abstractTypes
  abstractTypes['.prefix'] = 'WMSQ'
  abstractTypes['.qName'] = 'cambridge.WmsQuery'
  abstractTypes['.name'] = 'abstractTypes'
  exolinks = {}
  currentMap['exolinks'] = exolinks
  exolinks['.prefix'] = 'WMSQ'
  exolinks['.qName'] = 'cambridge.WmsQuery'
  exolinks['.name'] = 'exolinks'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00006'
  currentMap['.prefix'] = 'WMSQ'
  currentMap['.qName'] = 'cambridge.WmsQuery'
  currentMap['.name'] = 'mapping'
  currentMap['globalRelease'] = '2.1.2'

  # Set up top level dictionaries
  abstractTypes = globalMap.get('IMPL').get('abstractTypes')
  exolinks = globalMap.get('IMPL').get('exolinks')

  # DataType Any
  currentMap = {}
  abstractTypes['Any'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-11-17-09:06:35_00001'] = currentMap
  loadMaps['IMPL.Any'] = currentMap
  currentMap['tag'] = 'IMPL.Any'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-11-17-09:06:35_00001'
  currentMap['toStr'] = basicDataTypes.Any.toString
  currentMap['cnvrt'] = basicDataTypes.Any.fromString

  # DataType Boolean
  currentMap = {}
  abstractTypes['Boolean'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028'] = currentMap
  loadMaps['IMPL.Boolean'] = currentMap
  currentMap['tag'] = 'IMPL.Boolean'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028'
  currentMap['toStr'] = bool2str
  currentMap['cnvrt'] = str2bool

  # DataType Dict
  currentMap = {}
  abstractTypes['Dict'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00013'] = currentMap
  loadMaps['IMPL.Dict'] = currentMap
  currentMap['tag'] = 'IMPL.Dict'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00013'
  currentMap['toStr'] = basicDataTypes.Dict.toString
  currentMap['cnvrt'] = basicDataTypes.Dict.fromString

  # DataType Double
  currentMap = {}
  abstractTypes['Double'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00030'] = currentMap
  loadMaps['IMPL.Double'] = currentMap
  currentMap['tag'] = 'IMPL.Double'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00030'
  currentMap['toStr'] = basicDataTypes.Double.toString
  currentMap['cnvrt'] = basicDataTypes.Double.fromString

  # DataType Float
  currentMap = {}
  abstractTypes['Float'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031'] = currentMap
  loadMaps['IMPL.Float'] = currentMap
  currentMap['tag'] = 'IMPL.Float'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031'
  currentMap['toStr'] = basicDataTypes.Float.toString
  currentMap['cnvrt'] = basicDataTypes.Float.fromString

  # DataType Int
  currentMap = {}
  abstractTypes['Int'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'] = currentMap
  loadMaps['IMPL.Int'] = currentMap
  currentMap['tag'] = 'IMPL.Int'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'
  currentMap['toStr'] = basicDataTypes.Int.toString
  currentMap['cnvrt'] = basicDataTypes.Int.fromString

  # DataType Long
  currentMap = {}
  abstractTypes['Long'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00034'] = currentMap
  loadMaps['IMPL.Long'] = currentMap
  currentMap['tag'] = 'IMPL.Long'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00034'
  currentMap['toStr'] = basicDataTypes.Long.toString
  currentMap['cnvrt'] = basicDataTypes.Long.fromString

  # DataType String
  currentMap = {}
  abstractTypes['String'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'] = currentMap
  loadMaps['IMPL.String'] = currentMap
  currentMap['tag'] = 'IMPL.String'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType StringKeyDict
  currentMap = {}
  abstractTypes['StringKeyDict'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-11-03-14:03:26_00001'] = currentMap
  loadMaps['IMPL.StringKeyDict'] = currentMap
  currentMap['tag'] = 'IMPL.StringKeyDict'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-11-03-14:03:26_00001'
  currentMap['toStr'] = basicDataTypes.Dict.toString
  currentMap['cnvrt'] = basicDataTypes.Dict.fromString

  # DataType PositiveDouble
  currentMap = {}
  abstractTypes['PositiveDouble'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-12-11-18:15:49_00001'] = currentMap
  loadMaps['IMPL.PositiveDouble'] = currentMap
  currentMap['tag'] = 'IMPL.PositiveDouble'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-12-11-18:15:49_00001'
  currentMap['toStr'] = basicDataTypes.Double.toString
  currentMap['cnvrt'] = basicDataTypes.Double.fromString

  # DataType NegativeDouble
  currentMap = {}
  abstractTypes['NegativeDouble'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00005'] = currentMap
  loadMaps['IMPL.NegativeDouble'] = currentMap
  currentMap['tag'] = 'IMPL.NegativeDouble'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00005'
  currentMap['toStr'] = basicDataTypes.Double.toString
  currentMap['cnvrt'] = basicDataTypes.Double.fromString

  # DataType NonNegativeDouble
  currentMap = {}
  abstractTypes['NonNegativeDouble'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-12-11-18:15:49_00003'] = currentMap
  loadMaps['IMPL.NonNegativeDouble'] = currentMap
  currentMap['tag'] = 'IMPL.NonNegativeDouble'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-12-11-18:15:49_00003'
  currentMap['toStr'] = basicDataTypes.Double.toString
  currentMap['cnvrt'] = basicDataTypes.Double.fromString

  # DataType FloatRatio
  currentMap = {}
  abstractTypes['FloatRatio'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058'] = currentMap
  loadMaps['IMPL.FloatRatio'] = currentMap
  currentMap['tag'] = 'IMPL.FloatRatio'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058'
  currentMap['toStr'] = basicDataTypes.Float.toString
  currentMap['cnvrt'] = basicDataTypes.Float.fromString

  # DataType NegativeFloat
  currentMap = {}
  abstractTypes['NegativeFloat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00001'] = currentMap
  loadMaps['IMPL.NegativeFloat'] = currentMap
  currentMap['tag'] = 'IMPL.NegativeFloat'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00001'
  currentMap['toStr'] = basicDataTypes.Float.toString
  currentMap['cnvrt'] = basicDataTypes.Float.fromString

  # DataType NonNegativeFloat
  currentMap = {}
  abstractTypes['NonNegativeFloat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009'] = currentMap
  loadMaps['IMPL.NonNegativeFloat'] = currentMap
  currentMap['tag'] = 'IMPL.NonNegativeFloat'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009'
  currentMap['toStr'] = basicDataTypes.Float.toString
  currentMap['cnvrt'] = basicDataTypes.Float.fromString

  # DataType PositiveFloat
  currentMap = {}
  abstractTypes['PositiveFloat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007'] = currentMap
  loadMaps['IMPL.PositiveFloat'] = currentMap
  currentMap['tag'] = 'IMPL.PositiveFloat'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007'
  currentMap['toStr'] = basicDataTypes.Float.toString
  currentMap['cnvrt'] = basicDataTypes.Float.fromString

  # DataType NonNegativeInt
  currentMap = {}
  abstractTypes['NonNegativeInt'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011'] = currentMap
  loadMaps['IMPL.NonNegativeInt'] = currentMap
  currentMap['tag'] = 'IMPL.NonNegativeInt'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011'
  currentMap['toStr'] = basicDataTypes.Int.toString
  currentMap['cnvrt'] = basicDataTypes.Int.fromString

  # DataType NegativeInt
  currentMap = {}
  abstractTypes['NegativeInt'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00003'] = currentMap
  loadMaps['IMPL.NegativeInt'] = currentMap
  currentMap['tag'] = 'IMPL.NegativeInt'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00003'
  currentMap['toStr'] = basicDataTypes.Int.toString
  currentMap['cnvrt'] = basicDataTypes.Int.fromString

  # DataType IntSign
  currentMap = {}
  abstractTypes['IntSign'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00003'] = currentMap
  loadMaps['IMPL.IntSign'] = currentMap
  currentMap['tag'] = 'IMPL.IntSign'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-10-18:39:10_00003'
  currentMap['toStr'] = basicDataTypes.Int.toString
  currentMap['cnvrt'] = basicDataTypes.Int.fromString

  # DataType PositiveInt
  currentMap = {}
  abstractTypes['PositiveInt'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'] = currentMap
  loadMaps['IMPL.PositiveInt'] = currentMap
  currentMap['tag'] = 'IMPL.PositiveInt'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'
  currentMap['toStr'] = basicDataTypes.Int.toString
  currentMap['cnvrt'] = basicDataTypes.Int.fromString

  # DataType Token
  currentMap = {}
  abstractTypes['Token'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00055'] = currentMap
  loadMaps['IMPL.Token'] = currentMap
  currentMap['tag'] = 'IMPL.Token'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00055'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType HexString
  currentMap = {}
  abstractTypes['HexString'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-12-02-09:49:50_00001'] = currentMap
  loadMaps['IMPL.HexString'] = currentMap
  currentMap['tag'] = 'IMPL.HexString'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-12-02-09:49:50_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PaperOrientation
  currentMap = {}
  abstractTypes['PaperOrientation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00013'] = currentMap
  loadMaps['IMPL.PaperOrientation'] = currentMap
  currentMap['tag'] = 'IMPL.PaperOrientation'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00013'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PrintFormat
  currentMap = {}
  abstractTypes['PrintFormat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00012'] = currentMap
  loadMaps['IMPL.PrintFormat'] = currentMap
  currentMap['tag'] = 'IMPL.PrintFormat'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00012'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PaperUnit
  currentMap = {}
  abstractTypes['PaperUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00011'] = currentMap
  loadMaps['IMPL.PaperUnit'] = currentMap
  currentMap['tag'] = 'IMPL.PaperUnit'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00011'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PaperFormat
  currentMap = {}
  abstractTypes['PaperFormat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00010'] = currentMap
  loadMaps['IMPL.PaperFormat'] = currentMap
  currentMap['tag'] = 'IMPL.PaperFormat'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00010'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType Text
  currentMap = {}
  abstractTypes['Text'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036'] = currentMap
  loadMaps['IMPL.Text'] = currentMap
  currentMap['tag'] = 'IMPL.Text'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType SpacelessString
  currentMap = {}
  abstractTypes['SpacelessString'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00001'] = currentMap
  loadMaps['IMPL.SpacelessString'] = currentMap
  currentMap['tag'] = 'IMPL.SpacelessString'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType DateTime
  currentMap = {}
  abstractTypes['DateTime'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00029'] = currentMap
  loadMaps['IMPL.DateTime'] = currentMap
  currentMap['tag'] = 'IMPL.DateTime'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00029'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType Page
  currentMap = {}
  abstractTypes['Page'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-01-23-10:52:32_00001'] = currentMap
  loadMaps['IMPL.Page'] = currentMap
  currentMap['tag'] = 'IMPL.Page'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-01-23-10:52:32_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType SingleLine
  currentMap = {}
  abstractTypes['SingleLine'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00005'] = currentMap
  loadMaps['IMPL.SingleLine'] = currentMap
  currentMap['tag'] = 'IMPL.SingleLine'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00005'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType RgbaColor
  currentMap = {}
  abstractTypes['RgbaColor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-12-02-09:49:50_00003'] = currentMap
  loadMaps['IMPL.RgbaColor'] = currentMap
  currentMap['tag'] = 'IMPL.RgbaColor'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-12-02-09:49:50_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType RgbColor
  currentMap = {}
  abstractTypes['RgbColor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007'] = currentMap
  loadMaps['IMPL.RgbColor'] = currentMap
  currentMap['tag'] = 'IMPL.RgbColor'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType LongWord
  currentMap = {}
  abstractTypes['LongWord'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003'] = currentMap
  loadMaps['IMPL.LongWord'] = currentMap
  currentMap['tag'] = 'IMPL.LongWord'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType Line
  currentMap = {}
  abstractTypes['Line'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'] = currentMap
  loadMaps['IMPL.Line'] = currentMap
  currentMap['tag'] = 'IMPL.Line'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PathString
  currentMap = {}
  abstractTypes['PathString'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003'] = currentMap
  loadMaps['IMPL.PathString'] = currentMap
  currentMap['tag'] = 'IMPL.PathString'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType Word
  currentMap = {}
  abstractTypes['Word'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'] = currentMap
  loadMaps['IMPL.Word'] = currentMap
  currentMap['tag'] = 'IMPL.Word'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType GuidString
  currentMap = {}
  abstractTypes['GuidString'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'] = currentMap
  loadMaps['IMPL.GuidString'] = currentMap
  currentMap['tag'] = 'IMPL.GuidString'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType StorageFormat
  currentMap = {}
  abstractTypes['StorageFormat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00054'] = currentMap
  loadMaps['IMPL.StorageFormat'] = currentMap
  currentMap['tag'] = 'IMPL.StorageFormat'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00054'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType UrlProtocol
  currentMap = {}
  abstractTypes['UrlProtocol'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00050'] = currentMap
  loadMaps['IMPL.UrlProtocol'] = currentMap
  currentMap['tag'] = 'IMPL.UrlProtocol'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00050'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ThreeValueAnswer
  currentMap = {}
  abstractTypes['ThreeValueAnswer'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2010-11-17-16:21:33_00001'] = currentMap
  loadMaps['IMPL.ThreeValueAnswer'] = currentMap
  currentMap['tag'] = 'IMPL.ThreeValueAnswer'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-11-17-16:21:33_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataObjType ComplexDataType
  currentMap = {}
  abstractTypes['ComplexDataType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-10-18-17:15:48_00001'] = currentMap
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-10-18-17:15:48_00001'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.ComplexDataType
  contentMap = {}
  currentMap['content'] = contentMap
  # End of ComplexDataType

  currentMap = abstractTypes.get('ComplexDataType')

  # DataObjType MemopsDataTypeObject
  currentMap = {}
  abstractTypes['MemopsDataTypeObject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-15-19:00:39_00003'] = currentMap
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-15-19:00:39_00003'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.MemopsDataTypeObject
  contentMap = {}
  currentMap['content'] = contentMap
  # End of MemopsDataTypeObject

  currentMap = abstractTypes.get('MemopsDataTypeObject')

  # DataObjType Url
  currentMap = {}
  abstractTypes['Url'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-13-15:54:00_00000'] = currentMap
  loadMaps['IMPL.Url'] = currentMap
  currentMap['tag'] = 'IMPL.Url'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-13-15:54:00_00000'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.Url
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Url.host
  currentMap = {}
  contentMap['host'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00029'] = currentMap
  loadMaps['IMPL.Url.host'] = currentMap
  currentMap['tag'] = 'IMPL.Url.host'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00029'
  currentMap['name'] = 'host'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Url.password
  currentMap = {}
  contentMap['password'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00028'] = currentMap
  loadMaps['IMPL.Url.password'] = currentMap
  currentMap['tag'] = 'IMPL.Url.password'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00028'
  currentMap['name'] = 'password'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Url.path
  currentMap = {}
  contentMap['path'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00030'] = currentMap
  loadMaps['IMPL.Url.path'] = currentMap
  currentMap['tag'] = 'IMPL.Url.path'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00030'
  currentMap['name'] = 'path'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute Url.port
  currentMap = {}
  contentMap['port'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00031'] = currentMap
  loadMaps['IMPL.Url.port'] = currentMap
  currentMap['tag'] = 'IMPL.Url.port'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00031'
  currentMap['name'] = 'port'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Url.protocol
  currentMap = {}
  contentMap['protocol'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00025'] = currentMap
  loadMaps['IMPL.Url.protocol'] = currentMap
  currentMap['tag'] = 'IMPL.Url.protocol'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00025'
  currentMap['name'] = 'protocol'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'file'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00050')

  # Attribute Url.user
  currentMap = {}
  contentMap['user'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00027'] = currentMap
  loadMaps['IMPL.Url.user'] = currentMap
  currentMap['tag'] = 'IMPL.Url.user'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00027'
  currentMap['name'] = 'user'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')
  # End of Url

  currentMap = abstractTypes.get('Url')
  aList = ['port', 'protocol']
  currentMap['headerAttrs'] = aList
  aList = ['host', 'password', 'path', 'user']
  currentMap['simpleAttrs'] = aList

  # DataObjType ApplicationData
  currentMap = {}
  abstractTypes['ApplicationData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00026'] = currentMap
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00026'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.ApplicationData
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ApplicationData.application
  currentMap = {}
  contentMap['application'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025'] = currentMap
  loadMaps['IMPL.ApplicationData.application'] = currentMap
  currentMap['tag'] = 'IMPL.ApplicationData.application'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025'
  currentMap['name'] = 'application'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ApplicationData.keyword
  currentMap = {}
  contentMap['keyword'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026'] = currentMap
  loadMaps['IMPL.ApplicationData.keyword'] = currentMap
  currentMap['tag'] = 'IMPL.ApplicationData.keyword'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026'
  currentMap['name'] = 'keyword'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')
  # End of ApplicationData

  currentMap = abstractTypes.get('ApplicationData')
  aList = ['application', 'keyword']
  currentMap['simpleAttrs'] = aList

  # DataObjType SymmTracelessMatrix
  currentMap = {}
  abstractTypes['SymmTracelessMatrix'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-16-13:49:36_00004'] = currentMap
  loadMaps['IMPL.SymmTracelessMatrix'] = currentMap
  currentMap['tag'] = 'IMPL.SymmTracelessMatrix'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-16-13:49:36_00004'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.SymmTracelessMatrix
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SymmTracelessMatrix.aAxial
  currentMap = {}
  contentMap['aAxial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00001'] = currentMap
  loadMaps['IMPL.SymmTracelessMatrix.aAxial'] = currentMap
  currentMap['tag'] = 'IMPL.SymmTracelessMatrix.aAxial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00001'
  currentMap['name'] = 'aAxial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SymmTracelessMatrix.aRhombic
  currentMap = {}
  contentMap['aRhombic'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00002'] = currentMap
  loadMaps['IMPL.SymmTracelessMatrix.aRhombic'] = currentMap
  currentMap['tag'] = 'IMPL.SymmTracelessMatrix.aRhombic'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00002'
  currentMap['name'] = 'aRhombic'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SymmTracelessMatrix.alpha
  currentMap = {}
  contentMap['alpha'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00003'] = currentMap
  loadMaps['IMPL.SymmTracelessMatrix.alpha'] = currentMap
  currentMap['tag'] = 'IMPL.SymmTracelessMatrix.alpha'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00003'
  currentMap['name'] = 'alpha'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SymmTracelessMatrix.beta
  currentMap = {}
  contentMap['beta'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00004'] = currentMap
  loadMaps['IMPL.SymmTracelessMatrix.beta'] = currentMap
  currentMap['tag'] = 'IMPL.SymmTracelessMatrix.beta'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00004'
  currentMap['name'] = 'beta'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SymmTracelessMatrix.gamma
  currentMap = {}
  contentMap['gamma'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00005'] = currentMap
  loadMaps['IMPL.SymmTracelessMatrix.gamma'] = currentMap
  currentMap['tag'] = 'IMPL.SymmTracelessMatrix.gamma'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-04-16-13:49:38_00005'
  currentMap['name'] = 'gamma'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')
  # End of SymmTracelessMatrix

  currentMap = abstractTypes.get('SymmTracelessMatrix')
  aList = ['aAxial', 'aRhombic', 'alpha', 'beta', 'gamma']
  currentMap['headerAttrs'] = aList

  # DataObjType AppDataDouble
  currentMap = {}
  abstractTypes['AppDataDouble'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00042'] = currentMap
  loadMaps['IMPL.AppDataDouble'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataDouble'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00042'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.AppDataDouble
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AppDataDouble.application
  contentMap['application'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025')

  # Attribute AppDataDouble.keyword
  contentMap['keyword'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026')

  # Attribute AppDataDouble.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00014'] = currentMap
  loadMaps['IMPL.AppDataDouble.value'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataDouble.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00014'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00030')
  # End of AppDataDouble

  currentMap = abstractTypes.get('AppDataDouble')
  aList = ['value']
  currentMap['headerAttrs'] = aList
  aList = ['application', 'keyword']
  currentMap['simpleAttrs'] = aList

  # DataObjType AppDataFloat
  currentMap = {}
  abstractTypes['AppDataFloat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00043'] = currentMap
  loadMaps['IMPL.AppDataFloat'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataFloat'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00043'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.AppDataFloat
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AppDataFloat.application
  contentMap['application'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025')

  # Attribute AppDataFloat.keyword
  contentMap['keyword'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026')

  # Attribute AppDataFloat.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00015'] = currentMap
  loadMaps['IMPL.AppDataFloat.value'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataFloat.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00015'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')
  # End of AppDataFloat

  currentMap = abstractTypes.get('AppDataFloat')
  aList = ['value']
  currentMap['headerAttrs'] = aList
  aList = ['application', 'keyword']
  currentMap['simpleAttrs'] = aList

  # DataObjType AppDataLong
  currentMap = {}
  abstractTypes['AppDataLong'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00040'] = currentMap
  loadMaps['IMPL.AppDataLong'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataLong'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00040'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.AppDataLong
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AppDataLong.application
  contentMap['application'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025')

  # Attribute AppDataLong.keyword
  contentMap['keyword'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026')

  # Attribute AppDataLong.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00012'] = currentMap
  loadMaps['IMPL.AppDataLong.value'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataLong.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00012'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00034')
  # End of AppDataLong

  currentMap = abstractTypes.get('AppDataLong')
  aList = ['value']
  currentMap['headerAttrs'] = aList
  aList = ['application', 'keyword']
  currentMap['simpleAttrs'] = aList

  # DataObjType AppDataInt
  currentMap = {}
  abstractTypes['AppDataInt'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00041'] = currentMap
  loadMaps['IMPL.AppDataInt'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataInt'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00041'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.AppDataInt
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AppDataInt.application
  contentMap['application'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025')

  # Attribute AppDataInt.keyword
  contentMap['keyword'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026')

  # Attribute AppDataInt.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00013'] = currentMap
  loadMaps['IMPL.AppDataInt.value'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataInt.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00013'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')
  # End of AppDataInt

  currentMap = abstractTypes.get('AppDataInt')
  aList = ['value']
  currentMap['headerAttrs'] = aList
  aList = ['application', 'keyword']
  currentMap['simpleAttrs'] = aList

  # DataObjType AppDataBoolean
  currentMap = {}
  abstractTypes['AppDataBoolean'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00039'] = currentMap
  loadMaps['IMPL.AppDataBoolean'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataBoolean'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00039'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.AppDataBoolean
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AppDataBoolean.application
  contentMap['application'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025')

  # Attribute AppDataBoolean.keyword
  contentMap['keyword'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026')

  # Attribute AppDataBoolean.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00011'] = currentMap
  loadMaps['IMPL.AppDataBoolean.value'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataBoolean.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00011'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')
  # End of AppDataBoolean

  currentMap = abstractTypes.get('AppDataBoolean')
  aList = ['value']
  currentMap['headerAttrs'] = aList
  aList = ['application', 'keyword']
  currentMap['simpleAttrs'] = aList

  # DataObjType AppDataString
  currentMap = {}
  abstractTypes['AppDataString'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00044'] = currentMap
  loadMaps['IMPL.AppDataString'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataString'
  currentMap['type'] = 'cplx'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00044'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.AppDataString
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AppDataString.application
  contentMap['application'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00025')

  # Attribute AppDataString.keyword
  contentMap['keyword'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00026')

  # Attribute AppDataString.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00016'] = currentMap
  loadMaps['IMPL.AppDataString.value'] = currentMap
  currentMap['tag'] = 'IMPL.AppDataString.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:24_00016'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')
  # End of AppDataString

  currentMap = abstractTypes.get('AppDataString')
  aList = ['application', 'keyword', 'value']
  currentMap['simpleAttrs'] = aList

  # Class MemopsObject
  currentMap = {}
  abstractTypes['MemopsObject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00027'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00027'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.MemopsObject
  contentMap = {}
  currentMap['content'] = contentMap
  # End of MemopsObject

  currentMap = abstractTypes.get('MemopsObject')

  # Class DataObject
  currentMap = {}
  abstractTypes['DataObject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00005'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00005'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.DataObject
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute DataObject.applicationData
  currentMap = {}
  contentMap['applicationData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007'] = currentMap
  loadMaps['IMPL.DataObject.applicationData'] = currentMap
  currentMap['tag'] = 'IMPL.DataObject.applicationData'
  currentMap['type'] = 'dobj'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007'
  currentMap['name'] = 'applicationData'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('IMPL').get('abstractTypes')

  # Role DataObject.access
  currentMap = {}
  contentMap['access'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014'] = currentMap
  loadMaps['IMPL.DataObject.access'] = currentMap
  currentMap['tag'] = 'IMPL.DataObject.access'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014'
  currentMap['name'] = 'access'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('ACCO').get('exolinks')
  # End of DataObject

  currentMap = abstractTypes.get('DataObject')
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ImplementationObject
  currentMap = {}
  abstractTypes['ImplementationObject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-15-19:00:39_00001'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-15-19:00:39_00001'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.ImplementationObject
  contentMap = {}
  currentMap['content'] = contentMap
  # End of ImplementationObject

  currentMap = abstractTypes.get('ImplementationObject')

  # Class TopObject
  currentMap = {}
  abstractTypes['TopObject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'
  currentMap['eType'] = 'cplx'
  currentMap['isTop'] = True
  currentMap['class'] = memops.api.Implementation.TopObject
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute TopObject.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute TopObject.createdBy
  currentMap = {}
  contentMap['createdBy'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'] = currentMap
  loadMaps['IMPL.TopObject.createdBy'] = currentMap
  currentMap['tag'] = 'IMPL.TopObject.createdBy'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'
  currentMap['name'] = 'createdBy'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute TopObject.guid
  currentMap = {}
  contentMap['guid'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002'] = currentMap
  loadMaps['IMPL.TopObject.guid'] = currentMap
  currentMap['tag'] = 'IMPL.TopObject.guid'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002'
  currentMap['name'] = 'guid'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001')

  # Attribute TopObject.isModifiable
  currentMap = {}
  contentMap['isModifiable'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'] = currentMap
  loadMaps['IMPL.TopObject.isModifiable'] = currentMap
  currentMap['tag'] = 'IMPL.TopObject.isModifiable'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'
  currentMap['name'] = 'isModifiable'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute TopObject.lastUnlockedBy
  currentMap = {}
  contentMap['lastUnlockedBy'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'] = currentMap
  loadMaps['IMPL.TopObject.lastUnlockedBy'] = currentMap
  currentMap['tag'] = 'IMPL.TopObject.lastUnlockedBy'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002'
  currentMap['name'] = 'lastUnlockedBy'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role TopObject.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of TopObject

  currentMap = abstractTypes.get('TopObject')
  aList = ['createdBy', 'guid', 'isModifiable', 'lastUnlockedBy']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class MemopsRoot
  currentMap = {}
  abstractTypes['MemopsRoot'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'] = currentMap
  loadMaps['IMPL.MemopsRoot'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = memops.api.Implementation.MemopsRoot
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute MemopsRoot.accessControlOn
  currentMap = {}
  contentMap['accessControlOn'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-08-19-17:31:11_00004'] = currentMap
  loadMaps['IMPL.MemopsRoot.accessControlOn'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.accessControlOn'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-08-19-17:31:11_00004'
  currentMap['name'] = 'accessControlOn'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute MemopsRoot.createdBy
  currentMap = {}
  contentMap['createdBy'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'] = currentMap
  loadMaps['IMPL.MemopsRoot.createdBy'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.createdBy'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'
  currentMap['name'] = 'createdBy'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute MemopsRoot.currentGroupName
  currentMap = {}
  contentMap['currentGroupName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-08-19-17:31:11_00003'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentGroupName'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentGroupName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-08-19-17:31:11_00003'
  currentMap['name'] = 'currentGroupName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'user'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute MemopsRoot.currentUserId
  currentMap = {}
  contentMap['currentUserId'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00011'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentUserId'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentUserId'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00011'
  currentMap['name'] = 'currentUserId'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'user'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute MemopsRoot.isModifiable
  currentMap = {}
  contentMap['isModifiable'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'] = currentMap
  loadMaps['IMPL.MemopsRoot.isModifiable'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.isModifiable'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'
  currentMap['name'] = 'isModifiable'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute MemopsRoot.lastUnlockedBy
  currentMap = {}
  contentMap['lastUnlockedBy'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'] = currentMap
  loadMaps['IMPL.MemopsRoot.lastUnlockedBy'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.lastUnlockedBy'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00047'
  currentMap['name'] = 'lastUnlockedBy'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute MemopsRoot.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-26-12:22:46_00001'] = currentMap
  loadMaps['IMPL.MemopsRoot.name'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-26-12:22:46_00001'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'ccpProject'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute MemopsRoot.override
  currentMap = {}
  contentMap['override'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-29-18:30:36_00001'] = currentMap
  loadMaps['IMPL.MemopsRoot.override'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.override'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-29-18:30:36_00001'
  currentMap['name'] = 'override'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role MemopsRoot.accessControlStores
  currentMap = {}
  contentMap['accessControlStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.accessControlStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.accessControlStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.accessControlStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.accessControlStore'
  currentMap['name'] = 'accessControlStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ACCO').get('abstractTypes')

  # Role MemopsRoot.affiliationStores
  currentMap = {}
  contentMap['affiliationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.affiliationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.affiliationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.affiliationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.affiliationStore'
  currentMap['name'] = 'affiliationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('AFFI').get('abstractTypes')

  # Role MemopsRoot.analysisProfiles
  currentMap = {}
  contentMap['analysisProfiles'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.analysisProfile'] = currentMap
  loadMaps['IMPL.MemopsRoot.analysisProfiles'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.analysisProfiles'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.analysisProfile'
  currentMap['name'] = 'analysisProfiles'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAP').get('abstractTypes')

  # Role MemopsRoot.analysisProjectV3s
  currentMap = {}
  contentMap['analysisProjectV3s'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00010'] = currentMap
  loadMaps['IMPL.MemopsRoot.analysisProjectV3s'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.analysisProjectV3s'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00010'
  currentMap['name'] = 'analysisProjectV3s'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANA3').get('abstractTypes')

  # Role MemopsRoot.analysisProjects
  currentMap = {}
  contentMap['analysisProjects'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.analysisProject'] = currentMap
  loadMaps['IMPL.MemopsRoot.analysisProjects'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.analysisProjects'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.analysisProject'
  currentMap['name'] = 'analysisProjects'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role MemopsRoot.analysisWindowStores
  currentMap = {}
  contentMap['analysisWindowStores'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00008'] = currentMap
  loadMaps['IMPL.MemopsRoot.analysisWindowStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.analysisWindowStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00008'
  currentMap['name'] = 'analysisWindowStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAW').get('abstractTypes')

  # Role MemopsRoot.annealProtocolStores
  currentMap = {}
  contentMap['annealProtocolStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.annealProtocolStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.annealProtocolStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.annealProtocolStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.annealProtocolStore'
  currentMap['name'] = 'annealProtocolStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANPR').get('abstractTypes')

  # Role MemopsRoot.annotationStores
  currentMap = {}
  contentMap['annotationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.annotationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.annotationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.annotationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.annotationStore'
  currentMap['name'] = 'annotationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANNO').get('abstractTypes')

  # Role MemopsRoot.chemCompCharges
  currentMap = {}
  contentMap['chemCompCharges'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.chemCompCharge'] = currentMap
  loadMaps['IMPL.MemopsRoot.chemCompCharges'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.chemCompCharges'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.chemCompCharge'
  currentMap['name'] = 'chemCompCharges'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CCCA').get('abstractTypes')

  # Role MemopsRoot.chemCompCoords
  currentMap = {}
  contentMap['chemCompCoords'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.chemCompCoord'] = currentMap
  loadMaps['IMPL.MemopsRoot.chemCompCoords'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.chemCompCoords'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.chemCompCoord'
  currentMap['name'] = 'chemCompCoords'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CCCO').get('abstractTypes')

  # Role MemopsRoot.chemComps
  currentMap = {}
  contentMap['chemComps'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.chemComp'] = currentMap
  loadMaps['IMPL.MemopsRoot.chemComps'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.chemComps'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.chemComp'
  currentMap['name'] = 'chemComps'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role MemopsRoot.chemElementStores
  currentMap = {}
  contentMap['chemElementStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.chemElementStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.chemElementStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.chemElementStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.chemElementStore'
  currentMap['name'] = 'chemElementStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CHEL').get('abstractTypes')

  # Role MemopsRoot.citationStores
  currentMap = {}
  contentMap['citationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.citationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.citationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.citationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.citationStore'
  currentMap['name'] = 'citationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CITA').get('abstractTypes')

  # Role MemopsRoot.classifications
  currentMap = {}
  contentMap['classifications'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.classification'] = currentMap
  loadMaps['IMPL.MemopsRoot.classifications'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.classifications'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.classification'
  currentMap['name'] = 'classifications'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CLAS').get('abstractTypes')

  # Role MemopsRoot.crystallizationStores
  currentMap = {}
  contentMap['crystallizationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.crystallizationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.crystallizationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.crystallizationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.crystallizationStore'
  currentMap['name'] = 'crystallizationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CRYZ').get('abstractTypes')

  # Role MemopsRoot.currentAccessControlStore
  currentMap = {}
  contentMap['currentAccessControlStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAccessControlStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAccessControlStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAccessControlStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAccessControlStore'
  currentMap['name'] = 'currentAccessControlStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ACCO').get('exolinks')

  # Role MemopsRoot.currentAffiliationStore
  currentMap = {}
  contentMap['currentAffiliationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAffiliationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAffiliationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAffiliationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAffiliationStore'
  currentMap['name'] = 'currentAffiliationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('AFFI').get('exolinks')

  # Role MemopsRoot.currentAnalysisProfile
  currentMap = {}
  contentMap['currentAnalysisProfile'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProfile'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAnalysisProfile'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAnalysisProfile'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProfile'
  currentMap['name'] = 'currentAnalysisProfile'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANAP').get('exolinks')

  # Role MemopsRoot.currentAnalysisProject
  currentMap = {}
  contentMap['currentAnalysisProject'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProject'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAnalysisProject'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAnalysisProject'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProject'
  currentMap['name'] = 'currentAnalysisProject'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANAL').get('exolinks')

  # Role MemopsRoot.currentAnalysisProjectV3
  currentMap = {}
  contentMap['currentAnalysisProjectV3'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProjectV3'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAnalysisProjectV3'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAnalysisProjectV3'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProjectV3'
  currentMap['name'] = 'currentAnalysisProjectV3'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANA3').get('exolinks')

  # Role MemopsRoot.currentAnalysisWindowStore
  currentMap = {}
  contentMap['currentAnalysisWindowStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisWindowStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAnalysisWindowStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAnalysisWindowStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisWindowStore'
  currentMap['name'] = 'currentAnalysisWindowStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANAW').get('exolinks')

  # Role MemopsRoot.currentAnnealProtocolStore
  currentMap = {}
  contentMap['currentAnnealProtocolStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAnnealProtocolStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAnnealProtocolStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAnnealProtocolStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnnealProtocolStore'
  currentMap['name'] = 'currentAnnealProtocolStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANPR').get('exolinks')

  # Role MemopsRoot.currentAnnotationStore
  currentMap = {}
  contentMap['currentAnnotationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentAnnotationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentAnnotationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentAnnotationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnnotationStore'
  currentMap['name'] = 'currentAnnotationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANNO').get('exolinks')

  # Role MemopsRoot.currentChemComp
  currentMap = {}
  contentMap['currentChemComp'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentChemComp'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentChemComp'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentChemComp'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentChemComp'
  currentMap['name'] = 'currentChemComp'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CHEM').get('exolinks')

  # Role MemopsRoot.currentChemCompCharge
  currentMap = {}
  contentMap['currentChemCompCharge'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentChemCompCharge'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentChemCompCharge'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentChemCompCharge'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentChemCompCharge'
  currentMap['name'] = 'currentChemCompCharge'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CCCA').get('exolinks')

  # Role MemopsRoot.currentChemCompCoord
  currentMap = {}
  contentMap['currentChemCompCoord'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentChemCompCoord'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentChemCompCoord'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentChemCompCoord'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentChemCompCoord'
  currentMap['name'] = 'currentChemCompCoord'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CCCO').get('exolinks')

  # Role MemopsRoot.currentChemElementStore
  currentMap = {}
  contentMap['currentChemElementStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentChemElementStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentChemElementStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentChemElementStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentChemElementStore'
  currentMap['name'] = 'currentChemElementStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CHEL').get('exolinks')

  # Role MemopsRoot.currentCitationStore
  currentMap = {}
  contentMap['currentCitationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentCitationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentCitationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentCitationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentCitationStore'
  currentMap['name'] = 'currentCitationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CITA').get('exolinks')

  # Role MemopsRoot.currentClassification
  currentMap = {}
  contentMap['currentClassification'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentClassification'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentClassification'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentClassification'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentClassification'
  currentMap['name'] = 'currentClassification'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CLAS').get('exolinks')

  # Role MemopsRoot.currentCrystallizationStore
  currentMap = {}
  contentMap['currentCrystallizationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentCrystallizationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentCrystallizationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentCrystallizationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentCrystallizationStore'
  currentMap['name'] = 'currentCrystallizationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CRYZ').get('exolinks')

  # Role MemopsRoot.currentDangleStore
  currentMap = {}
  contentMap['currentDangleStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentDangleStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentDangleStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentDangleStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentDangleStore'
  currentMap['name'] = 'currentDangleStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('DANG').get('exolinks')

  # Role MemopsRoot.currentDataLocationStore
  currentMap = {}
  contentMap['currentDataLocationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentDataLocationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentDataLocationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentDataLocationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentDataLocationStore'
  currentMap['name'] = 'currentDataLocationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('DLOC').get('exolinks')

  # Role MemopsRoot.currentDatabase
  currentMap = {}
  contentMap['currentDatabase'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentDatabase'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentDatabase'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentDatabase'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentDatabase'
  currentMap['name'] = 'currentDatabase'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('DBR').get('exolinks')

  # Role MemopsRoot.currentExpBlueprintStore
  currentMap = {}
  contentMap['currentExpBlueprintStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentExpBlueprintStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentExpBlueprintStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentExpBlueprintStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentExpBlueprintStore'
  currentMap['name'] = 'currentExpBlueprintStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('EXPB').get('exolinks')

  # Role MemopsRoot.currentExperimentStore
  currentMap = {}
  contentMap['currentExperimentStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentExperimentStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentExperimentStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentExperimentStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentExperimentStore'
  currentMap['name'] = 'currentExperimentStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('EXPE').get('exolinks')

  # Role MemopsRoot.currentHaddockProject
  currentMap = {}
  contentMap['currentHaddockProject'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentHaddockProject'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentHaddockProject'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentHaddockProject'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentHaddockProject'
  currentMap['name'] = 'currentHaddockProject'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('HADD').get('exolinks')

  # Role MemopsRoot.currentHolderStore
  currentMap = {}
  contentMap['currentHolderStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentHolderStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentHolderStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentHolderStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentHolderStore'
  currentMap['name'] = 'currentHolderStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('HOLD').get('exolinks')

  # Role MemopsRoot.currentInstrumentStore
  currentMap = {}
  contentMap['currentInstrumentStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentInstrumentStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentInstrumentStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentInstrumentStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentInstrumentStore'
  currentMap['name'] = 'currentInstrumentStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('INST').get('exolinks')

  # Role MemopsRoot.currentKeywordDefinitionStore
  currentMap = {}
  contentMap['currentKeywordDefinitionStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentKeywordDefinitionStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentKeywordDefinitionStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentKeywordDefinitionStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentKeywordDefinitionStore'
  currentMap['name'] = 'currentKeywordDefinitionStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('KWDF').get('exolinks')

  # Role MemopsRoot.currentLabeledMolecule
  currentMap = {}
  contentMap['currentLabeledMolecule'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentLabeledMolecule'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentLabeledMolecule'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentLabeledMolecule'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentLabeledMolecule'
  currentMap['name'] = 'currentLabeledMolecule'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('LMOL').get('exolinks')

  # Role MemopsRoot.currentLabelingScheme
  currentMap = {}
  contentMap['currentLabelingScheme'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentLabelingScheme'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentLabelingScheme'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentLabelingScheme'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentLabelingScheme'
  currentMap['name'] = 'currentLabelingScheme'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CCLB').get('exolinks')

  # Role MemopsRoot.currentLayout
  currentMap = {}
  contentMap['currentLayout'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentLayout'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentLayout'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentLayout'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentLayout'
  currentMap['name'] = 'currentLayout'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANAY').get('exolinks')

  # Role MemopsRoot.currentLocationStore
  currentMap = {}
  contentMap['currentLocationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentLocationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentLocationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentLocationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentLocationStore'
  currentMap['name'] = 'currentLocationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('LOCA').get('exolinks')

  # Role MemopsRoot.currentMethodStore
  currentMap = {}
  contentMap['currentMethodStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentMethodStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentMethodStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentMethodStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentMethodStore'
  currentMap['name'] = 'currentMethodStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('METH').get('exolinks')

  # Role MemopsRoot.currentMolSystem
  currentMap = {}
  contentMap['currentMolSystem'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentMolSystem'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentMolSystem'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentMolSystem'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentMolSystem'
  currentMap['name'] = 'currentMolSystem'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role MemopsRoot.currentMolSystemSymmetrySet
  currentMap = {}
  contentMap['currentMolSystemSymmetrySet'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentMolSystemSymmetrySet'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentMolSystemSymmetrySet'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentMolSystemSymmetrySet'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentMolSystemSymmetrySet'
  currentMap['name'] = 'currentMolSystemSymmetrySet'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('SYMM').get('exolinks')

  # Role MemopsRoot.currentMolecule
  currentMap = {}
  contentMap['currentMolecule'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentMolecule'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentMolecule'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentMolecule'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentMolecule'
  currentMap['name'] = 'currentMolecule'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLE').get('exolinks')

  # Role MemopsRoot.currentNameMappingStore
  currentMap = {}
  contentMap['currentNameMappingStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNameMappingStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNameMappingStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNameMappingStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNameMappingStore'
  currentMap['name'] = 'currentNameMappingStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMAP').get('exolinks')

  # Role MemopsRoot.currentNmrCalcStore
  currentMap = {}
  contentMap['currentNmrCalcStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrCalcStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrCalcStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrCalcStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrCalcStore'
  currentMap['name'] = 'currentNmrCalcStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CALC').get('exolinks')

  # Role MemopsRoot.currentNmrConstraintStore
  currentMap = {}
  contentMap['currentNmrConstraintStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrConstraintStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrConstraintStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrConstraintStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrConstraintStore'
  currentMap['name'] = 'currentNmrConstraintStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRC').get('exolinks')

  # Role MemopsRoot.currentNmrEntryStore
  currentMap = {}
  contentMap['currentNmrEntryStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrEntryStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrEntryStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrEntryStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrEntryStore'
  currentMap['name'] = 'currentNmrEntryStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ENTR').get('exolinks')

  # Role MemopsRoot.currentNmrExpPrototype
  currentMap = {}
  contentMap['currentNmrExpPrototype'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrExpPrototype'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrExpPrototype'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrExpPrototype'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrExpPrototype'
  currentMap['name'] = 'currentNmrExpPrototype'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRX').get('exolinks')

  # Role MemopsRoot.currentNmrProject
  currentMap = {}
  contentMap['currentNmrProject'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrProject'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrProject'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrProject'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrProject'
  currentMap['name'] = 'currentNmrProject'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMR').get('exolinks')

  # Role MemopsRoot.currentNmrReferenceStore
  currentMap = {}
  contentMap['currentNmrReferenceStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrReferenceStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrReferenceStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrReferenceStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrReferenceStore'
  currentMap['name'] = 'currentNmrReferenceStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRR').get('exolinks')

  # Role MemopsRoot.currentNmrScreen
  currentMap = {}
  contentMap['currentNmrScreen'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrScreen'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentNmrScreen'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentNmrScreen'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrScreen'
  currentMap['name'] = 'currentNmrScreen'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRS').get('exolinks')

  # Role MemopsRoot.currentProtocolStore
  currentMap = {}
  contentMap['currentProtocolStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentProtocolStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentProtocolStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentProtocolStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentProtocolStore'
  currentMap['name'] = 'currentProtocolStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('PROT').get('exolinks')

  # Role MemopsRoot.currentRefDataStore
  currentMap = {}
  contentMap['currentRefDataStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentRefDataStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentRefDataStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentRefDataStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentRefDataStore'
  currentMap['name'] = 'currentRefDataStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('REFD').get('exolinks')

  # Role MemopsRoot.currentRefSampleComponentStore
  currentMap = {}
  contentMap['currentRefSampleComponentStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentRefSampleComponentStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentRefSampleComponentStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentRefSampleComponentStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentRefSampleComponentStore'
  currentMap['name'] = 'currentRefSampleComponentStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('REFS').get('exolinks')

  # Role MemopsRoot.currentSampleStore
  currentMap = {}
  contentMap['currentSampleStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentSampleStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentSampleStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentSampleStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentSampleStore'
  currentMap['name'] = 'currentSampleStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('SAM').get('exolinks')

  # Role MemopsRoot.currentStereochemistryStore
  currentMap = {}
  contentMap['currentStereochemistryStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentStereochemistryStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentStereochemistryStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentStereochemistryStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentStereochemistryStore'
  currentMap['name'] = 'currentStereochemistryStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('STER').get('exolinks')

  # Role MemopsRoot.currentStructureEnsemble
  currentMap = {}
  contentMap['currentStructureEnsemble'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentStructureEnsemble'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentStructureEnsemble'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentStructureEnsemble'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentStructureEnsemble'
  currentMap['name'] = 'currentStructureEnsemble'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('COOR').get('exolinks')

  # Role MemopsRoot.currentTargetStore
  currentMap = {}
  contentMap['currentTargetStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentTargetStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentTargetStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentTargetStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentTargetStore'
  currentMap['name'] = 'currentTargetStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('TARG').get('exolinks')

  # Role MemopsRoot.currentTaxonomy
  currentMap = {}
  contentMap['currentTaxonomy'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentTaxonomy'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentTaxonomy'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentTaxonomy'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentTaxonomy'
  currentMap['name'] = 'currentTaxonomy'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('TAXO').get('exolinks')

  # Role MemopsRoot.currentValidationStore
  currentMap = {}
  contentMap['currentValidationStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentValidationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentValidationStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentValidationStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentValidationStore'
  currentMap['name'] = 'currentValidationStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('VALD').get('exolinks')

  # Role MemopsRoot.currentWmsProtocol
  currentMap = {}
  contentMap['currentWmsProtocol'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsProtocol'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentWmsProtocol'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentWmsProtocol'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsProtocol'
  currentMap['name'] = 'currentWmsProtocol'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('WMSP').get('exolinks')

  # Role MemopsRoot.currentWmsQueryStore
  currentMap = {}
  contentMap['currentWmsQueryStore'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsQueryStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentWmsQueryStore'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentWmsQueryStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsQueryStore'
  currentMap['name'] = 'currentWmsQueryStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('WMSQ').get('exolinks')

  # Role MemopsRoot.currentWmsSegment
  currentMap = {}
  contentMap['currentWmsSegment'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsSegment'] = currentMap
  loadMaps['IMPL.MemopsRoot.currentWmsSegment'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.currentWmsSegment'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsSegment'
  currentMap['name'] = 'currentWmsSegment'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('WMS').get('exolinks')

  # Role MemopsRoot.dangleStores
  currentMap = {}
  contentMap['dangleStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.dangleStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.dangleStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.dangleStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.dangleStore'
  currentMap['name'] = 'dangleStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('DANG').get('abstractTypes')

  # Role MemopsRoot.dataLocationStores
  currentMap = {}
  contentMap['dataLocationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.dataLocationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.dataLocationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.dataLocationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.dataLocationStore'
  currentMap['name'] = 'dataLocationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('DLOC').get('abstractTypes')

  # Role MemopsRoot.databases
  currentMap = {}
  contentMap['databases'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.database'] = currentMap
  loadMaps['IMPL.MemopsRoot.databases'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.databases'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.database'
  currentMap['name'] = 'databases'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('DBR').get('abstractTypes')

  # Role MemopsRoot.expBlueprintStores
  currentMap = {}
  contentMap['expBlueprintStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.expBlueprintStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.expBlueprintStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.expBlueprintStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.expBlueprintStore'
  currentMap['name'] = 'expBlueprintStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('EXPB').get('abstractTypes')

  # Role MemopsRoot.experimentStores
  currentMap = {}
  contentMap['experimentStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.experimentStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.experimentStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.experimentStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.experimentStore'
  currentMap['name'] = 'experimentStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('EXPE').get('abstractTypes')

  # Role MemopsRoot.haddockProjects
  currentMap = {}
  contentMap['haddockProjects'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.haddockProject'] = currentMap
  loadMaps['IMPL.MemopsRoot.haddockProjects'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.haddockProjects'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.haddockProject'
  currentMap['name'] = 'haddockProjects'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')

  # Role MemopsRoot.holderStores
  currentMap = {}
  contentMap['holderStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.holderStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.holderStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.holderStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.holderStore'
  currentMap['name'] = 'holderStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HOLD').get('abstractTypes')

  # Role MemopsRoot.instrumentStores
  currentMap = {}
  contentMap['instrumentStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.instrumentStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.instrumentStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.instrumentStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.instrumentStore'
  currentMap['name'] = 'instrumentStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('INST').get('abstractTypes')

  # Role MemopsRoot.keywordDefinitionStores
  currentMap = {}
  contentMap['keywordDefinitionStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.keywordDefinitionStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.keywordDefinitionStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.keywordDefinitionStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.keywordDefinitionStore'
  currentMap['name'] = 'keywordDefinitionStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('KWDF').get('abstractTypes')

  # Role MemopsRoot.labeledMolecules
  currentMap = {}
  contentMap['labeledMolecules'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.labeledMolecule'] = currentMap
  loadMaps['IMPL.MemopsRoot.labeledMolecules'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.labeledMolecules'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.labeledMolecule'
  currentMap['name'] = 'labeledMolecules'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('LMOL').get('abstractTypes')

  # Role MemopsRoot.labelingSchemes
  currentMap = {}
  contentMap['labelingSchemes'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.labelingScheme'] = currentMap
  loadMaps['IMPL.MemopsRoot.labelingSchemes'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.labelingSchemes'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.labelingScheme'
  currentMap['name'] = 'labelingSchemes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CCLB').get('abstractTypes')

  # Role MemopsRoot.layouts
  currentMap = {}
  contentMap['layouts'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00012'] = currentMap
  loadMaps['IMPL.MemopsRoot.layouts'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.layouts'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00012'
  currentMap['name'] = 'layouts'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAY').get('abstractTypes')

  # Role MemopsRoot.locationStores
  currentMap = {}
  contentMap['locationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.locationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.locationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.locationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.locationStore'
  currentMap['name'] = 'locationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('LOCA').get('abstractTypes')

  # Role MemopsRoot.methodStores
  currentMap = {}
  contentMap['methodStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.methodStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.methodStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.methodStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.methodStore'
  currentMap['name'] = 'methodStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('METH').get('abstractTypes')

  # Role MemopsRoot.molSystemSymmetrySets
  currentMap = {}
  contentMap['molSystemSymmetrySets'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.molSystemSymmetrySet'] = currentMap
  loadMaps['IMPL.MemopsRoot.molSystemSymmetrySets'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.molSystemSymmetrySets'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.molSystemSymmetrySet'
  currentMap['name'] = 'molSystemSymmetrySets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('SYMM').get('abstractTypes')

  # Role MemopsRoot.molSystems
  currentMap = {}
  contentMap['molSystems'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.molSystem'] = currentMap
  loadMaps['IMPL.MemopsRoot.molSystems'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.molSystems'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.molSystem'
  currentMap['name'] = 'molSystems'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('MOLS').get('abstractTypes')

  # Role MemopsRoot.molecules
  currentMap = {}
  contentMap['molecules'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.molecule'] = currentMap
  loadMaps['IMPL.MemopsRoot.molecules'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.molecules'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.molecule'
  currentMap['name'] = 'molecules'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('MOLE').get('abstractTypes')

  # Role MemopsRoot.nameMappingStores
  currentMap = {}
  contentMap['nameMappingStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nameMappingStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.nameMappingStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nameMappingStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nameMappingStore'
  currentMap['name'] = 'nameMappingStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')

  # Role MemopsRoot.nmrCalcStores
  currentMap = {}
  contentMap['nmrCalcStores'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-04-16-16:24:00_00002'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrCalcStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrCalcStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:00_00002'
  currentMap['name'] = 'nmrCalcStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CALC').get('abstractTypes')

  # Role MemopsRoot.nmrConstraintStores
  currentMap = {}
  contentMap['nmrConstraintStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nmrConstraintStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrConstraintStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrConstraintStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrConstraintStore'
  currentMap['name'] = 'nmrConstraintStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRC').get('abstractTypes')

  # Role MemopsRoot.nmrEntryStores
  currentMap = {}
  contentMap['nmrEntryStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nmrEntryStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrEntryStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrEntryStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrEntryStore'
  currentMap['name'] = 'nmrEntryStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ENTR').get('abstractTypes')

  # Role MemopsRoot.nmrExpPrototypes
  currentMap = {}
  contentMap['nmrExpPrototypes'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nmrExpPrototype'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrExpPrototypes'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrExpPrototypes'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrExpPrototype'
  currentMap['name'] = 'nmrExpPrototypes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRX').get('abstractTypes')

  # Role MemopsRoot.nmrProjects
  currentMap = {}
  contentMap['nmrProjects'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nmrProject'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrProjects'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrProjects'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrProject'
  currentMap['name'] = 'nmrProjects'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMR').get('abstractTypes')

  # Role MemopsRoot.nmrReferenceStores
  currentMap = {}
  contentMap['nmrReferenceStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nmrReferenceStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrReferenceStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrReferenceStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrReferenceStore'
  currentMap['name'] = 'nmrReferenceStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRR').get('abstractTypes')

  # Role MemopsRoot.nmrScreens
  currentMap = {}
  contentMap['nmrScreens'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.nmrScreen'] = currentMap
  loadMaps['IMPL.MemopsRoot.nmrScreens'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.nmrScreens'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrScreen'
  currentMap['name'] = 'nmrScreens'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role MemopsRoot.packageLocators
  currentMap = {}
  contentMap['packageLocators'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-20-10:48:39_00002'] = currentMap
  loadMaps['IMPL.MemopsRoot.packageLocators'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.packageLocators'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-20-10:48:39_00002'
  currentMap['name'] = 'packageLocators'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'loadDelayed'
  currentMap['content'] = globalMap.get('IMPL').get('abstractTypes')

  # Role MemopsRoot.protocolStores
  currentMap = {}
  contentMap['protocolStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.protocolStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.protocolStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.protocolStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.protocolStore'
  currentMap['name'] = 'protocolStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('PROT').get('abstractTypes')

  # Role MemopsRoot.refDataStores
  currentMap = {}
  contentMap['refDataStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.refDataStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.refDataStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.refDataStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.refDataStore'
  currentMap['name'] = 'refDataStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('REFD').get('abstractTypes')

  # Role MemopsRoot.refSampleComponentStores
  currentMap = {}
  contentMap['refSampleComponentStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.refSampleComponentStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.refSampleComponentStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.refSampleComponentStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.refSampleComponentStore'
  currentMap['name'] = 'refSampleComponentStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('REFS').get('abstractTypes')

  # Role MemopsRoot.repositories
  currentMap = {}
  contentMap['repositories'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-20-10:48:39_00004'] = currentMap
  loadMaps['IMPL.MemopsRoot.repositories'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.repositories'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-20-10:48:39_00004'
  currentMap['name'] = 'repositories'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('IMPL').get('abstractTypes')

  # Role MemopsRoot.sampleStores
  currentMap = {}
  contentMap['sampleStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.sampleStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.sampleStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.sampleStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.sampleStore'
  currentMap['name'] = 'sampleStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('SAM').get('abstractTypes')

  # Role MemopsRoot.stereochemistryStores
  currentMap = {}
  contentMap['stereochemistryStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.stereochemistryStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.stereochemistryStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.stereochemistryStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.stereochemistryStore'
  currentMap['name'] = 'stereochemistryStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('STER').get('abstractTypes')

  # Role MemopsRoot.structureEnsembles
  currentMap = {}
  contentMap['structureEnsembles'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.structureEnsemble'] = currentMap
  loadMaps['IMPL.MemopsRoot.structureEnsembles'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.structureEnsembles'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.structureEnsemble'
  currentMap['name'] = 'structureEnsembles'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('COOR').get('abstractTypes')

  # Role MemopsRoot.targetStores
  currentMap = {}
  contentMap['targetStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.targetStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.targetStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.targetStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.targetStore'
  currentMap['name'] = 'targetStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('TARG').get('abstractTypes')

  # Role MemopsRoot.taxonomies
  currentMap = {}
  contentMap['taxonomies'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-05-12:55:49_00001'] = currentMap
  loadMaps['IMPL.MemopsRoot.taxonomies'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.taxonomies'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-05-12:55:49_00001'
  currentMap['name'] = 'taxonomies'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('TAXO').get('abstractTypes')

  # Role MemopsRoot.validationStores
  currentMap = {}
  contentMap['validationStores'] = currentMap
  mapsByGuid['ccpn_automatic_memops.Implementation.MemopsRoot.validationStore'] = currentMap
  loadMaps['IMPL.MemopsRoot.validationStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.validationStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'ccpn_automatic_memops.Implementation.MemopsRoot.validationStore'
  currentMap['name'] = 'validationStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('VALD').get('abstractTypes')

  # Role MemopsRoot.wmsProtocols
  currentMap = {}
  contentMap['wmsProtocols'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00062'] = currentMap
  loadMaps['IMPL.MemopsRoot.wmsProtocols'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.wmsProtocols'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00062'
  currentMap['name'] = 'wmsProtocols'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('WMSP').get('abstractTypes')

  # Role MemopsRoot.wmsQueryStores
  currentMap = {}
  contentMap['wmsQueryStores'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00064'] = currentMap
  loadMaps['IMPL.MemopsRoot.wmsQueryStores'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.wmsQueryStores'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00064'
  currentMap['name'] = 'wmsQueryStores'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('WMSQ').get('abstractTypes')

  # Role MemopsRoot.wmsSegments
  currentMap = {}
  contentMap['wmsSegments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-01-29-15:16:54_00002'] = currentMap
  loadMaps['IMPL.MemopsRoot.wmsSegments'] = currentMap
  currentMap['tag'] = 'IMPL.MemopsRoot.wmsSegments'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:54_00002'
  currentMap['name'] = 'wmsSegments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('WMS').get('abstractTypes')
  # End of MemopsRoot

  currentMap = abstractTypes.get('MemopsRoot')
  aList = ['accessControlOn', 'createdBy', 'currentGroupName', 'currentUserId', 'isModifiable', 'lastUnlockedBy', 'name', 'override']
  currentMap['headerAttrs'] = aList
  aList = ['wmsSegments', 'wmsQueryStores', 'wmsProtocols', 'validationStores', 'taxonomies', 'targetStores', 'structureEnsembles', 'stereochemistryStores', 'sampleStores', 'refSampleComponentStores', 'refDataStores', 'protocolStores', 'nmrScreens', 'nmrReferenceStores', 'nmrProjects', 'nmrExpPrototypes', 'nmrEntryStores', 'nmrConstraintStores', 'nmrCalcStores', 'nameMappingStores', 'molecules', 'molSystems', 'molSystemSymmetrySets', 'methodStores', 'locationStores', 'layouts', 'labelingSchemes', 'labeledMolecules', 'keywordDefinitionStores', 'instrumentStores', 'holderStores', 'haddockProjects', 'experimentStores', 'expBlueprintStores', 'databases', 'dataLocationStores', 'dangleStores', 'crystallizationStores', 'classifications', 'citationStores', 'chemElementStores', 'chemComps', 'chemCompCoords', 'chemCompCharges', 'annotationStores', 'annealProtocolStores', 'analysisWindowStores', 'analysisProjects', 'analysisProjectV3s', 'analysisProfiles', 'affiliationStores', 'accessControlStores', 'currentWmsSegment', 'currentWmsQueryStore', 'currentWmsProtocol', 'currentValidationStore', 'currentTaxonomy', 'currentTargetStore', 'currentStructureEnsemble', 'currentStereochemistryStore', 'currentSampleStore', 'currentRefSampleComponentStore', 'currentRefDataStore', 'currentProtocolStore', 'currentNmrScreen', 'currentNmrReferenceStore', 'currentNmrProject', 'currentNmrExpPrototype', 'currentNmrEntryStore', 'currentNmrConstraintStore', 'currentNmrCalcStore', 'currentNameMappingStore', 'currentMolecule', 'currentMolSystemSymmetrySet', 'currentMolSystem', 'currentMethodStore', 'currentLocationStore', 'currentLayout', 'currentLabelingScheme', 'currentLabeledMolecule', 'currentKeywordDefinitionStore', 'currentInstrumentStore', 'currentHolderStore', 'currentHaddockProject', 'currentExperimentStore', 'currentExpBlueprintStore', 'currentDatabase', 'currentDataLocationStore', 'currentDangleStore', 'currentCrystallizationStore', 'currentClassification', 'currentCitationStore', 'currentChemElementStore', 'currentChemCompCoord', 'currentChemCompCharge', 'currentChemComp', 'currentAnnotationStore', 'currentAnnealProtocolStore', 'currentAnalysisWindowStore', 'currentAnalysisProjectV3', 'currentAnalysisProject', 'currentAnalysisProfile', 'currentAffiliationStore', 'currentAccessControlStore', 'packageLocators', 'repositories']
  currentMap['cplxAttrs'] = aList
  aList = ['accessControlStores', 'affiliationStores', 'analysisProfiles', 'analysisProjectV3s', 'analysisProjects', 'analysisWindowStores', 'annealProtocolStores', 'annotationStores', 'chemCompCharges', 'chemCompCoords', 'chemComps', 'chemElementStores', 'citationStores', 'classifications', 'crystallizationStores', 'dangleStores', 'dataLocationStores', 'databases', 'expBlueprintStores', 'experimentStores', 'haddockProjects', 'holderStores', 'instrumentStores', 'keywordDefinitionStores', 'labeledMolecules', 'labelingSchemes', 'layouts', 'locationStores', 'methodStores', 'molSystemSymmetrySets', 'molSystems', 'molecules', 'nameMappingStores', 'nmrCalcStores', 'nmrConstraintStores', 'nmrEntryStores', 'nmrExpPrototypes', 'nmrProjects', 'nmrReferenceStores', 'nmrScreens', 'packageLocators', 'protocolStores', 'refDataStores', 'refSampleComponentStores', 'repositories', 'sampleStores', 'stereochemistryStores', 'structureEnsembles', 'targetStores', 'taxonomies', 'validationStores', 'wmsProtocols', 'wmsQueryStores', 'wmsSegments']
  currentMap['children'] = aList

  # Class PackageLocator
  currentMap = {}
  abstractTypes['PackageLocator'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00003'] = currentMap
  loadMaps['IMPL.PackageLocator'] = currentMap
  currentMap['tag'] = 'IMPL.PackageLocator'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'packageLocators'
  currentMap['objkey'] = 'targetName'
  currentMap['class'] = memops.api.Implementation.PackageLocator
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PackageLocator.targetName
  currentMap = {}
  contentMap['targetName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00006'] = currentMap
  loadMaps['IMPL.PackageLocator.targetName'] = currentMap
  currentMap['tag'] = 'IMPL.PackageLocator.targetName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00006'
  currentMap['name'] = 'targetName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'any'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role PackageLocator.repositories
  currentMap = {}
  contentMap['repositories'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00005'] = currentMap
  loadMaps['IMPL.PackageLocator.repositories'] = currentMap
  currentMap['tag'] = 'IMPL.PackageLocator.repositories'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00005'
  currentMap['name'] = 'repositories'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of PackageLocator

  currentMap = abstractTypes.get('PackageLocator')
  aList = ['targetName']
  currentMap['headerAttrs'] = aList
  aList = ['repositories']
  currentMap['simpleAttrs'] = aList

  # Class Repository
  currentMap = {}
  abstractTypes['Repository'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00004'] = currentMap
  loadMaps['IMPL.Repository'] = currentMap
  currentMap['tag'] = 'IMPL.Repository'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'repositories'
  currentMap['objkey'] = 'name'
  currentMap['class'] = memops.api.Implementation.Repository
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Repository.format
  currentMap = {}
  contentMap['format'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:28_00030'] = currentMap
  loadMaps['IMPL.Repository.format'] = currentMap
  currentMap['tag'] = 'IMPL.Repository.format'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:28_00030'
  currentMap['name'] = 'format'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'xml'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00054')

  # Attribute Repository.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:28_00029'] = currentMap
  loadMaps['IMPL.Repository.name'] = currentMap
  currentMap['tag'] = 'IMPL.Repository.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:28_00029'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Repository.url
  currentMap = {}
  contentMap['url'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:28_00031'] = currentMap
  loadMaps['IMPL.Repository.url'] = currentMap
  currentMap['tag'] = 'IMPL.Repository.url'
  currentMap['type'] = 'dobj'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:28_00031'
  currentMap['name'] = 'url'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('IMPL').get('abstractTypes')

  # Role Repository.stored
  currentMap = {}
  contentMap['stored'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00004'] = currentMap
  loadMaps['IMPL.Repository.stored'] = currentMap
  currentMap['tag'] = 'IMPL.Repository.stored'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00004'
  currentMap['name'] = 'stored'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of Repository

  currentMap = abstractTypes.get('Repository')
  aList = ['format']
  currentMap['headerAttrs'] = aList
  aList = ['name', 'stored']
  currentMap['simpleAttrs'] = aList
  aList = ['url']
  currentMap['cplxAttrs'] = aList

def saveToStream(stream, topObject, mapping=None, comment=None, simplified=True, compact=True, expanded=False):
  """
  Write topObject and its descendants to open stream 'stream'.
  
  'mapping' contains all XMLtag-Model and Model-XMLtag mapping info.
  'comment' is added at the top of the file as an XML comment,
  If 'simplified' one-to-many links are written out at one end only,
  (otherwise at both ends), and attributes equal to the default are skipped.
  If 'compact' most hicard==1 attributes are written as XML attributes of
  the container, otherwise all attributes are written as elements.
  If 'expanded' all attributes are written with inside an explicit type
  definition element (e.g. <aSerial><Int>5</Int></aSerial> instead of
   <aSerial>5</aSerial>. Expanded form may be easier to do backwards
   compatibility in some rare cases.
  """
  
  import time
  strapp = stream.write
  indents = {0:''}
  
  if mapping is None:
    mapping = getGlobalMap()[topObject.metaclass.container.shortName]
  
  # set up
  doComplex = not (simplified)

  if ((compact and expanded)):
    raise ApiError("""XML save: Parameters 'compact' and 'expanded' are incompatible"""
    )

  # check for topObject
  if (isinstance(topObject, memops.api.Implementation.MemopsRoot)):
    isImplementation = True
  elif (isinstance(topObject, memops.api.Implementation.TopObject)):
    isImplementation = False
  else:
    raise ApiError("""XML save: top obj is neither MemopsRoot nor TopObject"""
     + ": %s" % (topObject,)
    )

  # make sentinel objects
  startObj = list()
  endObj = list()

  reuseList = [None]
  emptyList = list()

  # set object ID dictionary
  nextID = 1
  classIDs = {}

  # set start indent
  indentBySpaces = 2
  nIndent = 0
  indent = ''

  strapp('<?xml version="1.0" encoding="UTF-8"?>\n')

  if (comment):
    strapp("<!--%s-->\n" % comment.replace('--','\-\-'))

  guid = mapping.get('guid')
  release = mapping.get('globalRelease')
  date = time.ctime()
  originator = 'CCPN Python XmlIO'
  strapp('%s<%s release="%s" originator="%s" packageGuid="%s" time="%s">\n' % (indent, '_StorageUnit', release, originator, guid, date))
  strapp('\n')

  # Write objects
  print 'start generating output : ', topObject.getQualifiedName()
  stack = [topObject]
  mapStack = [mapping['abstractTypes'][topObject.__class__.__name__]]
  while stack:

    val = stack.pop()
    curMap0 = mapStack.pop()

    # IF BLOCK 1
    if (val is startObj):
      # start new attribute-less element
      # NB we have been cheating, putting a string on the mapStack
      strapp('%s<%s>\n' % (indent, curMap0))
      nIndent += indentBySpaces
      indent = indents.setdefault(nIndent, nIndent*' ')

    elif (val is endObj):
      # end element
      # NB we have been cheating, putting a string on the mapStack
      nIndent -= indentBySpaces
      indent = indents[nIndent]
      strapp('%s</%s>\n' % (indent, curMap0))

    else:
      curMap = curMap0
      typ = curMap.get('type')

      # IF BLOCK 2
      if (typ == 'simple'):
        tag = curMap['tag']
        toStr = curMap.get('toStr')

        if ('text' == toStr):
          # String type
          val = val.replace('&', '&amp;')
          val = val.replace('"', '&quot;')
          val = val.replace('<', '&lt;')
          val = val.replace('>', '&gt;')
        else:
          # non-string simple type - toStr is conversion function
          val = toStr(val)

        strapp('%s<%s>' % (indent, tag))
        strapp(val)
        strapp('</%s>\n' % tag)

      elif (typ == 'exo'):
        tag = curMap['tag']
        stack.append(endObj)
        mapStack.append(tag)
        keyMaps = curMap['keyMaps']

        # put keys on stack
        keys = val.getFullKey(True)
        for ii in reversed(xrange(len(keys))):
          key = keys[ii]
          stack.append(key)
          if ((isinstance(key, memops.api.Implementation.MemopsObject) or isinstance(key, memops.api.Implementation.MemopsDataTypeObject))):
            mapStack.append(keyMaps[ii].get(key.__class__.__name__))
          else:
            mapStack.append(keyMaps[ii])

        # Could be done directly
        # But it will not make much difference, so for consistency
        stack.append(startObj)
        mapStack.append(tag)

      else:
        # type class or cplx

        # setup
        stackVal = val
        contDict = curMap['content']
        headerAttrs = curMap.get('headerAttrs', emptyList)
        optLinks = curMap.get('optLinks', emptyList)
        simpleAttrs = curMap.get('simpleAttrs', emptyList)
        cplxAttrs = curMap.get('cplxAttrs', emptyList)

        classtag = curMap['tag']

        # put end-of-object marker on stack
        stack.append(endObj)
        mapStack.append(classtag)

        # IF BLOCK 3
        if (typ == 'class'):
          # get and write obj _ID
          _ID = classIDs.get(val)
          if (_ID is None):
            _ID = nextID
            classIDs[val] = _ID
            nextID = (nextID + 1)

          strapp('%s<%s _ID="_%s"' % (indent, classtag, _ID))

        else:
          # typ == 'cplx'
          strapp('%s<%s' % (indent, classtag))

        # IF BLOCK 4
        if (compact):
          # set header attributes and links
          if ((doComplex and optLinks)):
            names = headerAttrs + optLinks
          else:
            names = headerAttrs

          # LOOP A
          for name in names:
            tmpMap = contDict[name]
            if ((isImplementation and tmpMap.get('implSkip', False))):
              continue

            # NB hicard is always 1 here
            # NB here we use name instead of tag, as tag is 'Clazz.attr'
            value = stackVal.__dict__[name]

            # IF BLOCK 5
            if (value is not None):
              typ = tmpMap['type']

              # IF BLOCK 6
              if (typ == 'link'):
                _ID = classIDs.get(value)
                if (_ID is None):
                  _ID = nextID
                  classIDs[value] = _ID
                  nextID = (nextID + 1)

                strapp(' %s="_%s"' % (tmpMap.get('name'), _ID))

              else:
                # typ == 'attr'
                # IF BLOCK 7
                if ((doComplex or value != tmpMap.get('default'))):
                  toStr = tmpMap['data'].get('toStr')
                  if ('text' == toStr):
                    # String type
                    value = value.replace('&', '&amp;')
                    value = value.replace('"', '&quot;')
                    value = value.replace('<', '&lt;')
                    value = value.replace('>', '&gt;')
                  else:
                    # non-string simple type - toStr is conversion function
                    value = toStr(value)

                  strapp(' %s="%s"' % (tmpMap['name'], value))

        # IF BLOCK 8
        if ((compact and (not simpleAttrs and not cplxAttrs))):
          # class contains no XML elements. end immediately
          stack.pop()
          mapStack.pop()
          strapp('/>\n')

        else:
          # class may have more elements - process them
          # end start element
          strapp('>\n')

          # set indent
          nIndent += indentBySpaces
          indent = indents.setdefault(nIndent, nIndent*' ')

          if (compact):
            names = simpleAttrs
          elif ((doComplex and optLinks)):
            names = headerAttrs + optLinks + simpleAttrs
          else:
            names = headerAttrs + simpleAttrs

          # LOOP B
          # set simple attributes and links
          for name in names:
            tmpMap = contDict[name]
            if ((isImplementation and tmpMap.get('implSkip', False))):
              continue

            # IF BLOCK 9
            val = stackVal.__dict__[name]
            if ((doComplex or val != tmpMap.get('default'))):
              if ((tmpMap['hicard'] == 1 and val is not None)):
                # put here in case of (future) types
                reuseList[0] = val
                val = reuseList

              # IF BLOCK 10
              if (val):
                vals = val
                tag = tmpMap['tag']
                typ = tmpMap['type']

                # IF BLOCK 11
                if (typ == 'link'):
                  strapp('%s<%s>' % (indent, tag))
                  # LOOP C
                  for value in vals:
                    _ID = classIDs.get(value)
                    if (_ID is None):
                      _ID = nextID
                      classIDs[value] = _ID
                      nextID = (nextID + 1)

                    strapp(' _%s' % _ID)

                  strapp('</%s>\n' % tag)

                elif (('cplx' == tmpMap.get('eType') or expanded)):
                  # typ == 'attr', complex XML element
                  strapp('%s<%s>\n' % (indent, tag))
                  nIndent += indentBySpaces
                  indent = indents.setdefault(nIndent, nIndent*' ')

                  tTag = tmpMap['data']['tag']
                  toStr = tmpMap['data'].get('toStr')
                  if ('text' == toStr):
                    for value in vals:
                      # String type
                      value = value.replace('&', '&amp;')
                      value = value.replace('"', '&quot;')
                      value = value.replace('<', '&lt;')
                      value = value.replace('>', '&gt;')

                      strapp('%s<%s>' % (indent, tTag))
                      strapp(value)
                      strapp('</%s>\n' % tTag)

                  else:
                    for value in vals:
                      # non-string simple type - toStr is conversion function
                      value = toStr(value)

                      strapp('%s<%s>' % (indent, tTag))
                      strapp(value)
                      strapp('</%s>\n' % tTag)

                  nIndent -= indentBySpaces
                  indent = indents[nIndent]
                  strapp('%s</%s>\n' % (indent, tag))

                else:
                  # typ == 'attr', simple XML element
                  toStr = tmpMap['data'].get('toStr')
                  strapp('%s<%s>' % (indent, tag))

                  if ('text' == toStr):
                    for value in vals:
                      # String type
                      value = value.replace('&', '&amp;')
                      value = value.replace('"', '&quot;')
                      value = value.replace('<', '&lt;')
                      value = value.replace('>', '&gt;')
                      strapp(' %s' % value)

                  else:
                    for value in vals:
                      # non-string simple type - toStr is conversion function
                      value = toStr(value)
                      strapp(' %s' % value)

                  strapp('</%s>\n' % tag)

          # put DataObjType attrs, exolinks, and child links on stack

          # LOOP D
          for name in cplxAttrs:
            val = stackVal.__dict__[name]

            # IF BLOCK 12
            if (val):
              tmpMap = contDict[name]

              # IF BLOCK 13
              if (not ((isImplementation and tmpMap.get('implSkip', False)))):

                tag = tmpMap['tag']
                tmpCont = tmpMap['content']

                stack.append(endObj)
                mapStack.append(tag)

                # IF BLOCK 14
                if (tmpMap['hicard'] == 1):
                  stack.append(val)
                  mapStack.append(tmpCont[val.__class__.__name__])

                else:
                  
                  if tmpMap['type'] == 'child':
                    items = val.items()
                    items.sort()
                    ll = [x[1] for x in items]
                  else:
                    ll = list(val)
                  ll.reverse() # for reproducibility
                  
                  stack.extend(ll)
                  mapStack.extend(tmpCont[x.__class__.__name__] for x in ll)

                stack.append(startObj)
                mapStack.append(tag)

  strapp('\n</_StorageUnit>\n<!--End of Memops Data-->\n')

def loadFromStream(stream, topObjId=None, topObject=None, partialLoad=False):
  """
  load Ccpn XML document using elementtree parser.
  
  topObjId should be the guid (for objects with such an attribute),
  otherwise the name (for objects with sucn an attribute), otherwise None.
  It is meant to reflect the file name, for proper topObjects.
  topObjId must match the guid/name.
  
  topObject can be None, the memopsRoot, or a package TopObject.
  If None the file must correspond to the Implementation package.
  If memopsRoot the file must be from a non-Implementaiton package, and the
  function will use the file to create a new TopObject under MemopsRoot.
  If a package TopObject the function will read the data from the file
  topObject into the passed-in TopObject, checking that the packages match,
  and giving a warning if the topObject (pseudo)key changes.
    
  if partialLoad is True only the TopObject (minus children) will be loaded
  for normal packages. For the Implementation package Classes actually 
  in Implementation will be loaded while shell topObjectas and links to]
  them will be skipped.
    
  Conceivably the rules could later be relaxed to allow a lower-level empty
  object  to be passed in for the purpose of reading subtrees. This would
  require some code modifications.
  """
  if (topObject is not None):
    # check for topObject
    if (not ((isinstance(topObject, memops.api.Implementation.MemopsRoot) or isinstance(topObject, memops.api.Implementation.TopObject)))):
      raise ApiError("""XML load: top obj is neither MemopsRoot nor TopObject"""
       + ": %s" % (topObject,)
      )

  try:
    crossLinkData = list()
    exoTopLinkData = list()
    objStack = []
    loadMaps = None
    mapping = None
    topObjectMap = None
    objectDict = {}
    # delayDataDict: AnyVarType --> (dd: string --> list)
    delayDataDict = {}
    topObjectKey = None
    parserState = 'starting'
    skipElement = None
    topObjByGuid = None
    foundClosingTag = False
    doOutOfPackage = False
    linkTopToParent = False
    needCompatibility = False
    earlyExit = False
    implPrefix = 'IMPL'

    result = None

    # needed for error handling
    elem = None
    
    # get elementtree NBNB TBD to be redone to allow for different sources
    from memops.universal.ElementTree import ElementTree
    
    # LOOP H
    for event, elem in ElementTree.iterparse(stream, events=("start", "end")):
    
      # IF BLOCK 100
      if (event == 'start'):
        # element start

        if (skipElement is not None):
          # we are skipping an element
          continue

        tag = elem.tag

        # IF BLOCK 102
        if (loadMaps is not None):
          # file already started

          # get map and test
          try:
            curMap = loadMaps[tag]
          except KeyError, ex:
            raise ApiError("""no map found for element"""
             + ": %s" % (tag,)
            )
          except Exception, ex:
            raise ApiError("""Load maps not set up correctly - should not get here"""
             + ": %s" % (tag,)
            )

          # check if we start skipping
          if ('skip' == curMap.get('proc')):
            skipElement = elem
            continue

          typ = curMap.get('type')

          # IF BLOCK 103
          if (not objStack):
            # inside _StorageUnit - preliminary check for TopObject element
            if (not (('class' == typ and topObjectKey is None))):
              raise ApiError("""_StorageUnit has more than one child element"""
              )

          # IF BLOCK 104
          if ('cplx' == curMap.get('eType')):
            # start of class, complex attribute, collection or exolink

            # IF BLOCK 105
            if (('cplx' == typ or 'class' == typ)):
              # class, or cplx

              clazz = curMap['class']
              constructor = curMap.get('constructor', clazz)

              # IF BLOCK 106
              obj = None
              if ('class' == typ):

                # IF BLOCK 107
                if (topObjectKey is None):
                  # start of first topObject (passed in)

                  if (objStack):
                    raise ApiError("""Non-empty stack at TopObject - should not get here"""
                    )

                  # IF BLOCK 108
                  if (topObject is None):
                    # reading Implementation.xml
                    if (mapping['.prefix'] == implPrefix):
                      topObjectKey = 'ignore'
                      obj = constructor(isReading=True)
                    else:
                      raise ApiError("""non-Implementation package called without TopObject"""
                       + ": %s" % (implPrefix,)
                      )

                    if (needCompatibility):
                      partialLoad = True

                    # get stored topObjId
                    idTag = 'name'
                    elemId = elem.get(idTag)

                  elif (isinstance(topObject, memops.api.Implementation.MemopsRoot)):
                    # IF BLOCK 108
                    # topObject is MemopsRoot
                    # reading new TopObject first time

                    linkTopToParent = True

                    if (mapping['.prefix'] == implPrefix):
                      raise ApiError("""Attempt to load into pre-existing MemopsRoot"""
                      )

                    # non-impl package - create TopObject afresh
                    topObjectKey = 'ignore'
                    obj = constructor(topObject, isReading=True)
                    topObjectMap = curMap

                    # get stored topObjId
                    idTag = 'guid'
                    elemId = elem.get(idTag)

                  else:
                    # IF BLOCK 108
                    # reading with pre-existing topObject - should fit mapping

                    if (clazz is not topObject.__class__):
                      raise ApiError("""TopObject class does not fit first element class"""
                       + ": %s:%s" % (topObject.__class__, clazz)
                      )

                    # check topObject status
                    if (topObject.__dict__.get('isLoaded', False)):
                      raise ApiError("""trying to load already loaded TopObject"""
                       + ": %s" % (topObject,)
                      )

                    if (topObject.__dict__.get('isModified', False)):
                      raise ApiError("""trying to load already modified TopObject"""
                       + ": %s" % (topObject,)
                      )

                    # check guid against topObj identifier
                    idTag = 'guid'
                    elemId = elem.get(idTag)

                    objId = topObject.__dict__.get(idTag)
                    if (objId != elemId):
                      raise ApiError("""TopObject identifier does not fit stored identifier"""
                       + ": %s:%s" % (objId, elemId)
                      )

                    # set up for continuing
                    obj = topObject
                    # NB only MemopsRoot has fullKey None.
                    topObjectKey = topObject.getFullKey()
                    if (topObjectKey is None):
                      topObjectKey = 'ignore'

                    obj.__dict__['isReading'] = True

                  # check that file contents match file name
                  if (elemId != topObjId):
                    raise ApiError("""TopObject identifier does not fit passed=in identifier"""
                     + ": %s:%s" % (elemId, topObjId)
                    )

                  # initialise with topObject
                  result = obj
                  if (isinstance(obj, memops.api.Implementation.MemopsRoot)):
                    memopsRoot = obj
                  else:
                    memopsRoot = obj.getMemopsRoot()

                  topObjByGuid = memopsRoot.__dict__.get('topObjects')

                  # Set up for compatibility - keeping XML parse tree
                  clearElem = mapping.get("clearXmlElements")
                  if (clearElem):
                    topObjElem = elem
                  else:
                    topObjElem = None

                else:
                  # IF BLOCK 107
                  # normal case - start of non-TopObject class

                  # make new class object
                  objStackList = objStack.pop()
                  stackObj = objStack[-1]
                  obj = constructor(stackObj)
                  objStackList.append(obj)
                  objStack.append(objStackList)

                # set delayDataDict
                objDelayDict = {}
                delayDataDict[obj] = objDelayDict

              elif ('cplx' == typ):
                # IF BLOCK 106
                # start of complex datatype object

                # make new dataObjType object
                obj = constructor(override=True)
                stackObj = objStack[-1]
                stackObj.append(obj)
                objDelayDict = {}
                delayDataDict[id(obj)] = objDelayDict

              else:
                # IF BLOCK 106
                raise ApiError("""Unknown element type"""
                 + ": %s" % (typ,)
                )

              # put obj on stack
              objStack.append(obj)

              # treat XML attributes
              contMap = curMap['content']
              # LOOP I
              for (tag2, value) in elem.items():
                # IF BLOCK 110
                if ('_ID' == tag2):
                  objectDict[value] = obj
                else:
                  try:
                    tmpMap = contMap[tag2]
                  except KeyError, ex:
                    raise ApiError("""no map found for XML attribute"""
                     + ": %s" % (tag2,)
                    )

                  # IF BLOCK 111
                  if (tmpMap.get('skip') is None):
                    typ = tmpMap['type']

                    # IF BLOCK 112
                    if ('link' == typ):
                      ll = list()
                      ll.append(value)

                      if ('delay' == tmpMap.get('proc')):
                        objDelayDict[tmpMap['name']] = ll
                      else:
                        crossLinkData.append(obj)
                        crossLinkData.append(ll)
                        crossLinkData.append(tmpMap)

                    else:
                      # types attr and text
                      dataMap = tmpMap['data']
                      cnvrt = dataMap.get('cnvrt')
                      if ('text' != cnvrt):
                        value = cnvrt(value)

                      name = tmpMap['name']
                      proc = tmpMap.get('proc')

                      # IF BLOCK 113
                      if ('delay' == proc):
                        ll = list()
                        ll.append(value)
                        objDelayDict[name] = ll

                      elif ('direct' == proc):
                        # set, bypassing API
                        obj.__dict__[name] = value

                      elif (tmpMap.get('hicard') == 1):
                        # always, except when cardinality has changed
                        setattr(obj, name, value)

                      else:
                        # only when hicard has changed from 1 to something else
                        ll = list()
                        ll.append(value)
                        setattr(obj, name, ll)

            elif ((partialLoad and ('child' == typ and result is not memopsRoot))):
              # IF BLOCK 105
              # partially loading TopObject - end now

              xx = objStack.pop()

              # IF BLOCK 109
              if (topObjectMap is not None):
                if (topObjectMap.get('isTop') is not None):
                  # set TopObjects into TopObjects dictionary.
                  yy = xx
                  guid = yy.__dict__['guid']
                  if (topObjByGuid.get(guid) is None):
                    topObjByGuid[guid] = yy

                  earlyExit = True
                  break

              # if we get here there was an error
              raise ApiError("""partial load with in incorrect context for """
               + ": %s" % (xx,)
              )

            else:
              # IF BLOCK 105
              # exolink, collection (of exo, cplx, or attr (e.g. text))
              ll = list()
              objStack.append(ll)

          # no action for : 'simple'.
          # Nor for 'attr' or  'link' if eType != 'cplx'

        else:
          # IF BLOCK 102
          # no map - at start of file or error
          # IF BLOCK 114
          if ('starting' == parserState):
            # IF BLOCK 115
            if ('_StorageUnit' == tag):
              # first element

              # get version,  package, and updated mapping
              fileVersion = elem.get('release')
              packageGuid = elem.get('packageGuid')
              if ((fileVersion is None or packageGuid is None)):
                raise ApiError("""<_StorageUnit element lacks 'release' or 'packageGuid'"""
                )

              lm = getLoadingMaps(packageGuid, fileVersion)
              mapping = lm[0]
              loadMaps = lm[1]
              needCompatibility = lm[2]

              # state tracker - for tests an error messages
              parserState = 'reading'

            else:
              raise ApiError("""no '_StorageUnit' element found, or setup failed"""
              )

          else:
            raise ApiError("""Read past end of _StorageUnit"""
            )

      else:
        # IF BLOCK 100
        # event == 'end', element end

        if (skipElement is not None):
          # we are skipping an element
          if (elem is skipElement):
            skipElement = None
            if (clearElem):
              elem.clear()

          continue

        tag = elem.tag
        if ('_StorageUnit' == tag):
          foundClosingTag = True
          break

        try:
          curMap = loadMaps[tag]
        except KeyError, ex:
          raise ApiError("""no map found for element"""
           + ": %s" % (tag,)
          )
        except Exception, ex:
          raise ApiError("""Load maps not set up correctly - should not get here"""
           + ": %s" % (tag,)
          )

        # IF BLOCK 202
        if (objStack):
          # we are not yet finished

          typ = curMap.get('type')

          # IF BLOCK 203
          if ('simple' == typ):
            # DataType value
            value = elem.text
            cnvrt = curMap.get('cnvrt')
            if ('text' != cnvrt):
              value = cnvrt(value)

            stackObj = objStack[-1]
            stackObj.append(value)

          elif ('child' == typ):
            # child link
            ll = objStack.pop()
            oo = objStack[-1]
            dd = delayDataDict[oo]
            nm = curMap['name']
            dd[nm] = ll

            if ('loadDelayed' == curMap.get('proc')):
              # Special case:
              # premature link dereferencing.
              # necessary to handle Impl package properly
              delayedLoadLinksStd(objectDict, crossLinkData)
              if (exoTopLinkData):
                raise ApiError("""ExoTopLinks should not exist at intermediate MemopsRoot link-up"""
                )

              linkChildData(delayDataDict, result, mapping, linkTopToParent, doOutOfPackage)
              doOutOfPackage = True
              # Reading MemopsRoot
              # and skipping everything to do with other packages
              if (partialLoad):
                earlyExit = True
                break

          elif ('class' == typ):
            # class
            xx = objStack.pop()

            # IF BLOCK 204
            if (curMap.get('isTop', False)):
              # set TopObjects into TopObjects dictionary.
              guid = xx.__dict__['guid']
              yy = topObjByGuid.get(guid)
              if (yy is None):
                topObjByGuid[guid] = xx
              elif (yy is not xx):
                raise ApiError("""Read topObj with guid conflicts with existing topObj"""
                 + ": %s" % (guid,)
                )

            elif (not (needCompatibility)):
              dd = delayDataDict[xx]
              if (not dd):
                del delayDataDict[xx]

          elif ('exo' == typ):
            # exolink
            xx = objStack.pop()

            lenxx = len(xx)
            # IF BLOCK 205
            if (lenxx > 1):
              # normal exoLink. Append curMap for later dereferencing
              xx.append(curMap)
              stackObj = objStack[-1]
              stackObj.append(xx)

            elif (lenxx == 1):
              # link to TopObject. Must be handled differently, because
              # of toTopObject links that may be present in Implementation
              stackObj = objStack[-1]
              yy = xx[0]
              stackObj.append(yy)

            else:
              raise ApiError("""XML element appears empty"""
              )

          elif ('cplx' == typ):
            # complex datatype
            xx = objStack.pop()
            del xx.__dict__['override']

            dd = delayDataDict[id(xx)]
            if (not dd):
              del delayDataDict[id(xx)]

          else:
            # class elements - typ is 'link', 'attr', 'exolink', 'exotop', 'dobj'

            # get value
            # IF BLOCK 206
            if ('cplx' == curMap.get('eType')):
              val = objStack.pop()
              if (not val):
                # NBNB with elements being skipped
                # this might legitimately happen during backwards compatibility
                continue

            elif ('attr' == typ):
              dataMap = curMap['data']
              cnvrt = dataMap['cnvrt']
              
              if cnvrt == 'text':
                val = elem.text.split()
              else:
                val = [cnvrt(x) for x in elem.text.split()]
              # check if non-empty
              if (not val):
                raise ApiError("""XML element appears empty"""
                )

            else:
              val = elem.text.split()
              # check if non-empty
              if (not val):
                raise ApiError("""XML element appears empty"""
                )

            # set up
            proc = curMap.get('proc')

            # IF BLOCK 207
            if ('delay' == proc):
              # defunct element, preserved for backwards compatibility
              containerObj = objStack[-1]
              if (isinstance(containerObj, memops.api.Implementation.MemopsObject)):
                dictid = containerObj
              else:
                dictid = id(containerObj)

              dd = delayDataDict[dictid]
              dd[curMap['name']] = val

            elif ('link' == typ):
              # crosslink - delayed setting
              stackObj = objStack[-1]
              crossLinkData.append(stackObj)
              crossLinkData.append(val)
              crossLinkData.append(curMap)

            elif ('exotop' == typ):
              # exolink to topObject. delayed setting
              stackObj = objStack[-1]
              exoTopLinkData.append(stackObj)
              exoTopLinkData.append(val)
              exoTopLinkData.append(curMap)

            else:
              # attribute for setting now
              if ('exolink' == typ):
                # exolink not to topObject - convert to objects now.
                # val is topObjGuid, followed by rest of key,
                # followed by the exo link I/O map.
                
                for ii, vv in enumerate(val):
                  oo = topObjByGuid.get(vv[0])
                  clazz = vv[-1]['class']
                  if (oo is None):
                    # NB naughty - _packageName is a private attribute. 
                    # But getPackageName is not static
                    memopsRoot.refreshTopObjects(clazz._packageName)
                    try:
                      oo = topObjByGuid[vv[0]]
                    except:
                      raise ApiError("""TopObject with package:gui not found or loaded"""
                       + ": %s:%s" % (curMap['content']['.qName'], vv[0])
                      )
                  value = clazz.getByKey(oo,vv[1:-1])
                  if value is None:
                    raise ApiError("No object found with package,class,key: %s" 
                                   % ((curMap['content']['.qName'], clazz.__name__, vv[1:-1]),))
                  else:
                    val[ii] = value

              # set up
              name = curMap['name']
              hicard = curMap['hicard']

              # set value
              stackObj = objStack[-1]
              # IF BLOCK 208
              if (hicard == 1):
                vv = val[0]
                if ('direct' == proc):
                  # set, bypassing API - hicard must be 1.
                  stackObj.__dict__[name] = vv
                else:
                  # std set, hicard == 1
                  setattr(stackObj, name, vv)

              elif (hicard < 1):
                # std set, hicard == infinity
                setattr(stackObj, name, val)

              else:
                setattr(stackObj, name, val[:hicard])

        elif ('_StorageUnit' != tag):
          # IF BLOCK 202
          raise ApiError("""objStack empty but element is not _StorageUnit"""
          )

        # clean out to save memory
        if (clearElem):
          elem.clear()

    if (not (earlyExit)):
      if (not (foundClosingTag)):
        raise ApiError("""Premature end of file - no </_StorageUnit> found"""
        )

      if ((objStack or skipElement is not None)):
        raise ApiError("""Illegal state after parsing: objStack length, skipElement"""
         + ": %s:%s" % (len(objStack), skipElement)
        )

    # delayed load
    parserState = 'postprocessing data'
    if ((result is memopsRoot or not (partialLoad))):
      delayedLoadLinksStd(objectDict, crossLinkData)

    delayedLoadLinksExo(topObjByGuid, exoTopLinkData)

    if (needCompatibility):
      # backwards compatibility
      parserState = 'handling version compatibility'
      from memops.format.compatibility.part1 import Converters1
      Converters1.minorPostProcess(fileVersion, result, delayDataDict, objectDict, mapping, topObjElem)

    # link children to parents
    linkChildData(delayDataDict, result, mapping, linkTopToParent, doOutOfPackage)

    # validity check
    parserState = 'checking validity'

    # unset isReading (NB - extra link is for future load of non-topObjects)
    resultTop = result.getTopObject()
    resultTop.__dict__['isReading'] = False
    if ((not (partialLoad) or result is memopsRoot)):
      resultTop.__dict__['isLoaded'] = True
      if ((needCompatibility and resultTop.__dict__.get('isModifiable', False))):
        resultTop.__dict__['isModified'] = True

    if ((topObjectKey is not None and topObjectKey != 'ignore')):
      xx = result.getFullKey()
      if (topObjectKey != xx):
        print 'WARNING TopObject key changed on reading', topObjectKey, xx

    for obj in objectDict.values():
      obj.checkValid()

  except:
    
    if elem:
      tag = elem.tag
    else:
      tag = 'None'
    
    # clean up in case of error.
    # Currently not done, as too hard to do properly. NBNB TBD
    if (result is not None):
      result.getTopObject().__dict__['isReading'] = False

    print 'Error loading file for: ', result
    print 'Reading: ', stream
    print 'Last xml tag read: ', tag
    print 'Parser state was: ', parserState
    if (objStack):
      print 'Current object was: ', objStack[-1]
    else:
      print 'Object stack was empty'

    raise

  return result

def getLoadingMaps(packageGuid, fileVersion):
  """
  returns (mapping, loadMaps, needCompatibility) tuple.
  Allows for backwards compatibility
  """
  
  from memops.general.Constants import currentModelVersion
  newVersionStr = str(currentModelVersion)
  from memops.xml.Implementation import getGlobalMap
   
  globalMapping = getGlobalMap(fileVersion)
  
  # handle compatibility considerations
  if fileVersion == newVersionStr:
    needCompatibility = False
  else:
    needCompatibility = True
  
  # select mapping for package
  mapping = None
  for dd in globalMapping.values():
    if (packageGuid == dd.get('guid')):
      mapping = dd
      break

  if (mapping is None):
    raise ApiError("""No package mapping with guid found"""
     + ": %s" % (packageGuid,)
    )

  ll = list()
  ll.append(mapping)
  ll.append(globalMapping['loadMaps'])
  ll.append(needCompatibility)

  return ll

def linkChildData(delayDataDict, topObj, mapping, linkTopToParent=False, doOutOfPackage=False):
  """
  set parent-child links.
  delayDataDict is an obj/id:{childRoleName:listOfChildren}} dictionary
  (it also contains other information used elsewhere for compatibility)
  topObj is the TopObject
  mapping is the package mapping
  linkTopToParent determines if the root-to-topObject link must be set
  doOutOfPackage determines if out-of-package children must be linked -
  This is only relevant for the Implementation package, where first
  intrapackge and later out-of-package children are set.
  """
  # set up
  dataTypeMap = mapping['abstractTypes']
  topObjMap = dataTypeMap[topObj.__class__.__name__]

  # prime the stacks
  # IF BLOCK 301
  if (linkTopToParent):
    parentStack = [topObj.getParent()]
    ll = list()
    ll.append(topObj)
    childStack = [ll]

  else:
    parentStack = [topObj]
    ll = list()
    childStack = [ll]
    cl = topObjMap['children']
    dt = delayDataDict[topObj]
    for tag in cl:
      xx = dt.get(tag)
      if (xx is not None):
        ll.extend(xx)

  # IF BLOCK 302
  if (doOutOfPackage):
    # special case for TopObjects in Implementation

    # IF BLOCK 303
    if (isinstance(topObj, memops.api.Implementation.MemopsRoot)):

      dd = delayDataDict[topObj]
      content = topObjMap['content']
      cl = topObjMap['children']
      for tag in cl:
        val = dd.get(tag)
        # IF BLOCK 304
        if (val is not None):

          linkMap = content[tag]
          # IF BLOCK 305
          if ('child' == linkMap['type']):
            # child link

            linkContent = linkMap['content']
            for obj in val:
              obj2 = obj
              curMap = linkContent[obj2.__class__.__name__]
              # IF BLOCK 306
              if (curMap.get('isTop') is not None):
                # TopObject. Do the link to parent

                # get key
                tag2 = curMap.get('objkey')
                if (tag2 is None):
                  key = obj2.getLocalKey()
                else:
                  key = obj2.__dict__[tag2]

                parDict = topObj.__dict__[curMap['fromParent']]

                # add child link to parent dict
                if (key in parDict):
                  raise ApiError("""Cannot add child - key already in use"""
                   + ": %s:%s:%s" % (obj2.getQualifiedName(), obj2.getParent(), key)
                  )
                else:
                  parDict[key] = obj2
                  # NB these are shell TopObjects read in Implementation package
                  obj2.__dict__['isReading'] = False

    else:
      raise ApiError("""linkChildData: called with doOutOfPackage for non-root"""
       + ": %s" % (topObj,)
      )

  else:
    # Normal case. Add children to parent dictionary

    while childStack:

      kids = childStack[-1]
      # IF BLOCK 307
      if (kids):
        obj = kids.pop()
        curMap = dataTypeMap[obj.__class__.__name__]
        parentObj = parentStack[-1]
        fromParent = curMap['fromParent']
        # IF BLOCK 308
        if (curMap.get('singleKid') is not None):
          # only child
          sibling = parentObj.__dict__.get(fromParent)

          if (sibling is None):
            parentObj.__dict__[fromParent] = obj
          else:
            raise ApiError("""Attempt to override single child"""
             + ": %s" % (sibling,)
            )

        else:
          parDict = parentObj.__dict__[fromParent]

          # get key
          tag = curMap.get('objkey')
          if (tag is None):
            key = obj.getLocalKey()
          else:
            key = obj.__dict__[tag]

          # add child link to parent dict
          if (key in parDict):
            raise ApiError("""Cannot add child - key already in use"""
             + ": %s:%s:%s" % (obj.getQualifiedName(), obj.getParent(), key)
            )
          else:
            parDict[key] = obj

        parentStack.append(obj)
        ll = list()
        childStack.append(ll)
        dd = delayDataDict.get(obj)
        # IF BLOCK 309
        if (dd is not None):
          mm = curMap.get('children')
          # IF BLOCK 310
          if (mm is not None):
            for tag2 in mm:
              xx = dd.get(tag2)
              if (xx is not None):
                ll.extend(xx)

      else:
        # no children left - go up a step
        childStack.pop()
        parentStack.pop()

def delayedLoadLinksStd(objectDict, linkData):
  """
  Load single or multiple, crosslinks
  derefencing as you go using objectDict.
  """
  obj = None
  val = None
  name = None

  try:
    while linkData:
      # setup
      curMap = linkData.pop()
      val = linkData.pop()
      obj = linkData.pop()

      name = curMap.get('name')
      hicard = curMap.get('hicard')
      valueList = list()

      # map values
      for vv in val:
        try:
          oo = objectDict[vv]
          valueList.append(oo)
        except:
          raise ApiError("""Linked-to object with ID not found"""
           + ": %s:%s:%s" % (obj, name, vv)
          )

      # set element
      if (hicard == 1):
        ov = valueList[0]
      elif (hicard > 1):
        ov = valueList[:hicard]
      else:
        ov = valueList

      setattr(obj, name, ov)

  except:
    print 'Error during Std link dereferencing. Object was: ', obj
    print 'values were: ', val
    print 'tag name was: ', name
    raise

def delayedLoadLinksExo(objectDict, linkData):
  """
  Load single or multiple, exo-to-TopObjectlinks
  derefencing as you go using objectDict.
  """
  obj = None
  val = None
  name = None

  try:
    while linkData:
      # setup
      curMap = linkData.pop()
      val = linkData.pop()
      obj = linkData.pop()

      name = curMap.get('name')
      hicard = curMap.get('hicard')
      valueList = list()

      # map values
      for vv in val:
        oo = objectDict.get(vv)
        if (oo is None):
          root = obj.getRoot()
          packageName = curMap['content']['.qName']
          root.refreshTopObjects(packageName)
          try:
            oo = objectDict[vv]
          except:
            raise ApiError("""Linked-to object with ID not found"""
             + ": %s:%s:%s" % (obj, name, vv)
            )

        valueList.append(oo)

      # set element
      if (hicard == 1):
        ov = valueList[0]
      elif (hicard > 1):
        ov = valueList[:hicard]
      else:
        ov = valueList

      setattr(obj, name, ov)

  except:
    print 'Error during Exo link dereferencing. Object was: ', obj
    print 'values were: ', val
    print 'tag name was: ', name
    raise
