"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyXmlMapWrite revision 1.29 on Fri Mar 28 11:17:46 2014
  from data model element ccpnmr.NameMapping revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

NameMapping.py: python XML-I/O-mapping for CCPN data model, MetaPackage ccpnmr.NameMapping

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import ccpnmr.api.NameMapping

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package NMAP, adding it to globalMap
  """
  
  from memops.xml.Implementation import bool2str, str2bool

  # Set up top level dictionaries
  loadMaps = globalMap.get('loadMaps')
  mapsByGuid = globalMap.get('mapsByGuid')

  abstractTypes = globalMap.get('NMAP').get('abstractTypes')
  exolinks = globalMap.get('NMAP').get('exolinks')

  # Class AtomMapping
  currentMap = {}
  abstractTypes['AtomMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00006'] = currentMap
  loadMaps['NMAP.AtomMapping'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00006'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'atomMappings'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.NameMapping.AtomMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AtomMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AtomMapping.ccpCode
  currentMap = {}
  contentMap['ccpCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00021'] = currentMap
  loadMaps['NMAP.AtomMapping.ccpCode'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.ccpCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00021'
  currentMap['name'] = 'ccpCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003')

  # Attribute AtomMapping.chainCode
  currentMap = {}
  contentMap['chainCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00018'] = currentMap
  loadMaps['NMAP.AtomMapping.chainCode'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.chainCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00018'
  currentMap['name'] = 'chainCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AtomMapping.formatName
  currentMap = {}
  contentMap['formatName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00016'] = currentMap
  loadMaps['NMAP.AtomMapping.formatName'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.formatName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00016'
  currentMap['name'] = 'formatName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AtomMapping.molSystemCode
  currentMap = {}
  contentMap['molSystemCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00020'] = currentMap
  loadMaps['NMAP.AtomMapping.molSystemCode'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.molSystemCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00020'
  currentMap['name'] = 'molSystemCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AtomMapping.moleculeName
  currentMap = {}
  contentMap['moleculeName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00019'] = currentMap
  loadMaps['NMAP.AtomMapping.moleculeName'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.moleculeName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00019'
  currentMap['name'] = 'moleculeName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AtomMapping.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00015'] = currentMap
  loadMaps['NMAP.AtomMapping.name'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00015'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AtomMapping.seqId
  currentMap = {}
  contentMap['seqId'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00017'] = currentMap
  loadMaps['NMAP.AtomMapping.seqId'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.seqId'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00017'
  currentMap['name'] = 'seqId'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AtomMapping.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00014'] = currentMap
  loadMaps['NMAP.AtomMapping.serial'] = currentMap
  currentMap['tag'] = 'NMAP.AtomMapping.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00014'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AtomMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of AtomMapping

  currentMap = abstractTypes.get('AtomMapping')
  aList = ['ccpCode', 'molSystemCode', 'seqId', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['chainCode', 'formatName', 'moleculeName', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChainMapping
  currentMap = {}
  abstractTypes['ChainMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00008'] = currentMap
  loadMaps['NMAP.ChainMapping'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chainMappings'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.NameMapping.ChainMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChainMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChainMapping.chainCode
  currentMap = {}
  contentMap['chainCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00001'] = currentMap
  loadMaps['NMAP.ChainMapping.chainCode'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.chainCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00001'
  currentMap['name'] = 'chainCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChainMapping.firstSeqId
  currentMap = {}
  contentMap['firstSeqId'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00003'] = currentMap
  loadMaps['NMAP.ChainMapping.firstSeqId'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.firstSeqId'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00003'
  currentMap['name'] = 'firstSeqId'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ChainMapping.formatChainCode
  currentMap = {}
  contentMap['formatChainCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00002'] = currentMap
  loadMaps['NMAP.ChainMapping.formatChainCode'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.formatChainCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00002'
  currentMap['name'] = 'formatChainCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChainMapping.formatFirstSeqCode
  currentMap = {}
  contentMap['formatFirstSeqCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00004'] = currentMap
  loadMaps['NMAP.ChainMapping.formatFirstSeqCode'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.formatFirstSeqCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00004'
  currentMap['name'] = 'formatFirstSeqCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ChainMapping.formatLastSeqCode
  currentMap = {}
  contentMap['formatLastSeqCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00005'] = currentMap
  loadMaps['NMAP.ChainMapping.formatLastSeqCode'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.formatLastSeqCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00005'
  currentMap['name'] = 'formatLastSeqCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ChainMapping.formatSeqInsertCode
  currentMap = {}
  contentMap['formatSeqInsertCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00006'] = currentMap
  loadMaps['NMAP.ChainMapping.formatSeqInsertCode'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.formatSeqInsertCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00006'
  currentMap['name'] = 'formatSeqInsertCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = ' '
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChainMapping.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00025'] = currentMap
  loadMaps['NMAP.ChainMapping.serial'] = currentMap
  currentMap['tag'] = 'NMAP.ChainMapping.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00025'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ChainMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of ChainMapping

  currentMap = abstractTypes.get('ChainMapping')
  aList = ['firstSeqId', 'formatFirstSeqCode', 'formatLastSeqCode', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['chainCode', 'formatChainCode', 'formatSeqInsertCode']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class MoleculeMapping
  currentMap = {}
  abstractTypes['MoleculeMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00007'] = currentMap
  loadMaps['NMAP.MoleculeMapping'] = currentMap
  currentMap['tag'] = 'NMAP.MoleculeMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00007'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'moleculeMappings'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.NameMapping.MoleculeMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute MoleculeMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute MoleculeMapping.formatName
  currentMap = {}
  contentMap['formatName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00024'] = currentMap
  loadMaps['NMAP.MoleculeMapping.formatName'] = currentMap
  currentMap['tag'] = 'NMAP.MoleculeMapping.formatName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00024'
  currentMap['name'] = 'formatName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute MoleculeMapping.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00023'] = currentMap
  loadMaps['NMAP.MoleculeMapping.name'] = currentMap
  currentMap['tag'] = 'NMAP.MoleculeMapping.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00023'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute MoleculeMapping.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00022'] = currentMap
  loadMaps['NMAP.MoleculeMapping.serial'] = currentMap
  currentMap['tag'] = 'NMAP.MoleculeMapping.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00022'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role MoleculeMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of MoleculeMapping

  currentMap = abstractTypes.get('MoleculeMapping')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['formatName', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class NameMapping
  currentMap = {}
  abstractTypes['NameMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00005'] = currentMap
  loadMaps['NMAP.NameMapping'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00005'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'nameMappings'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.NameMapping.NameMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NameMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NameMapping.formatName
  currentMap = {}
  contentMap['formatName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00012'] = currentMap
  loadMaps['NMAP.NameMapping.formatName'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.formatName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00012'
  currentMap['name'] = 'formatName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute NameMapping.isOriginalImport
  currentMap = {}
  contentMap['isOriginalImport'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00013'] = currentMap
  loadMaps['NMAP.NameMapping.isOriginalImport'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.isOriginalImport'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00013'
  currentMap['name'] = 'isOriginalImport'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute NameMapping.namingSystem
  currentMap = {}
  contentMap['namingSystem'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00011'] = currentMap
  loadMaps['NMAP.NameMapping.namingSystem'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.namingSystem'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00011'
  currentMap['name'] = 'namingSystem'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute NameMapping.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00010'] = currentMap
  loadMaps['NMAP.NameMapping.serial'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00010'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role NameMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NameMapping.atomMappings
  currentMap = {}
  contentMap['atomMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00001'] = currentMap
  loadMaps['NMAP.NameMapping.atomMappings'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.atomMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00001'
  currentMap['name'] = 'atomMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')

  # Role NameMapping.chainMappings
  currentMap = {}
  contentMap['chainMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00005'] = currentMap
  loadMaps['NMAP.NameMapping.chainMappings'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.chainMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00005'
  currentMap['name'] = 'chainMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')

  # Role NameMapping.moleculeMappings
  currentMap = {}
  contentMap['moleculeMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00003'] = currentMap
  loadMaps['NMAP.NameMapping.moleculeMappings'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.moleculeMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00003'
  currentMap['name'] = 'moleculeMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')

  # Role NameMapping.resLinkMappings
  currentMap = {}
  contentMap['resLinkMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00009'] = currentMap
  loadMaps['NMAP.NameMapping.resLinkMappings'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.resLinkMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00009'
  currentMap['name'] = 'resLinkMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')

  # Role NameMapping.resStatusMappings
  currentMap = {}
  contentMap['resStatusMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00007'] = currentMap
  loadMaps['NMAP.NameMapping.resStatusMappings'] = currentMap
  currentMap['tag'] = 'NMAP.NameMapping.resStatusMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:16_00007'
  currentMap['name'] = 'resStatusMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')
  # End of NameMapping

  currentMap = abstractTypes.get('NameMapping')
  aList = ['isOriginalImport', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['formatName', 'namingSystem']
  currentMap['simpleAttrs'] = aList
  aList = ['resStatusMappings', 'resLinkMappings', 'moleculeMappings', 'chainMappings', 'atomMappings', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['atomMappings', 'chainMappings', 'moleculeMappings', 'resLinkMappings', 'resStatusMappings']
  currentMap['children'] = aList

  # Class NameMappingStore
  currentMap = {}
  abstractTypes['NameMappingStore'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00011'] = currentMap
  loadMaps['NMAP.NameMappingStore'] = currentMap
  currentMap['tag'] = 'NMAP.NameMappingStore'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'nameMappingStores'
  currentMap['isTop'] = True
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccpnmr.api.NameMapping.NameMappingStore
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NameMappingStore.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NameMappingStore.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NameMappingStore.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute NameMappingStore.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NameMappingStore.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NameMappingStore.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00017'] = currentMap
  loadMaps['NMAP.NameMappingStore.name'] = currentMap
  currentMap['tag'] = 'NMAP.NameMappingStore.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00017'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Role NameMappingStore.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NameMappingStore.nameMappings
  currentMap = {}
  contentMap['nameMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00016'] = currentMap
  loadMaps['NMAP.NameMappingStore.nameMappings'] = currentMap
  currentMap['tag'] = 'NMAP.NameMappingStore.nameMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00016'
  currentMap['name'] = 'nameMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMAP').get('abstractTypes')
  # End of NameMappingStore

  currentMap = abstractTypes.get('NameMappingStore')
  aList = ['createdBy', 'guid', 'isModifiable', 'lastUnlockedBy']
  currentMap['headerAttrs'] = aList
  aList = ['name']
  currentMap['simpleAttrs'] = aList
  aList = ['nameMappings', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['nameMappings']
  currentMap['children'] = aList

  # Class ResonanceLinkMapping
  currentMap = {}
  abstractTypes['ResonanceLinkMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00010'] = currentMap
  loadMaps['NMAP.ResonanceLinkMapping'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceLinkMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resLinkMappings'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.NameMapping.ResonanceLinkMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResonanceLinkMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResonanceLinkMapping.resonanceName
  currentMap = {}
  contentMap['resonanceName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00013'] = currentMap
  loadMaps['NMAP.ResonanceLinkMapping.resonanceName'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceLinkMapping.resonanceName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00013'
  currentMap['name'] = 'resonanceName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ResonanceLinkMapping.selectResonanceNames
  currentMap = {}
  contentMap['selectResonanceNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00014'] = currentMap
  loadMaps['NMAP.ResonanceLinkMapping.selectResonanceNames'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceLinkMapping.selectResonanceNames'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00014'
  currentMap['name'] = 'selectResonanceNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ResonanceLinkMapping.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00012'] = currentMap
  loadMaps['NMAP.ResonanceLinkMapping.serial'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceLinkMapping.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00012'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ResonanceLinkMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of ResonanceLinkMapping

  currentMap = abstractTypes.get('ResonanceLinkMapping')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['resonanceName', 'selectResonanceNames']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ResonanceStatusMapping
  currentMap = {}
  abstractTypes['ResonanceStatusMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00009'] = currentMap
  loadMaps['NMAP.ResonanceStatusMapping'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceStatusMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00009'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'resStatusMappings'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.NameMapping.ResonanceStatusMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResonanceStatusMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResonanceStatusMapping.isSinglePossEquiv
  currentMap = {}
  contentMap['isSinglePossEquiv'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00011'] = currentMap
  loadMaps['NMAP.ResonanceStatusMapping.isSinglePossEquiv'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceStatusMapping.isSinglePossEquiv'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00011'
  currentMap['name'] = 'isSinglePossEquiv'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ResonanceStatusMapping.isSingleProchiral
  currentMap = {}
  contentMap['isSingleProchiral'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00010'] = currentMap
  loadMaps['NMAP.ResonanceStatusMapping.isSingleProchiral'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceStatusMapping.isSingleProchiral'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00010'
  currentMap['name'] = 'isSingleProchiral'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ResonanceStatusMapping.isStereo
  currentMap = {}
  contentMap['isStereo'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00009'] = currentMap
  loadMaps['NMAP.ResonanceStatusMapping.isStereo'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceStatusMapping.isStereo'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00009'
  currentMap['name'] = 'isStereo'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ResonanceStatusMapping.resonanceName
  currentMap = {}
  contentMap['resonanceName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00008'] = currentMap
  loadMaps['NMAP.ResonanceStatusMapping.resonanceName'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceStatusMapping.resonanceName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00008'
  currentMap['name'] = 'resonanceName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ResonanceStatusMapping.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00007'] = currentMap
  loadMaps['NMAP.ResonanceStatusMapping.serial'] = currentMap
  currentMap['tag'] = 'NMAP.ResonanceStatusMapping.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:17_00007'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ResonanceStatusMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of ResonanceStatusMapping

  currentMap = abstractTypes.get('ResonanceStatusMapping')
  aList = ['isSinglePossEquiv', 'isSingleProchiral', 'isStereo', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['resonanceName']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Out-of-package link to AtomMapping
  currentMap = {}
  exolinks['AtomMapping'] = currentMap
  loadMaps['NMAP.exo-AtomMapping'] = currentMap
  currentMap['tag'] = 'NMAP.exo-AtomMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00006'
  currentMap['name'] = 'AtomMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.AtomMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ChainMapping
  currentMap = {}
  exolinks['ChainMapping'] = currentMap
  loadMaps['NMAP.exo-ChainMapping'] = currentMap
  currentMap['tag'] = 'NMAP.exo-ChainMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00008'
  currentMap['name'] = 'ChainMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.ChainMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to MoleculeMapping
  currentMap = {}
  exolinks['MoleculeMapping'] = currentMap
  loadMaps['NMAP.exo-MoleculeMapping'] = currentMap
  currentMap['tag'] = 'NMAP.exo-MoleculeMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00007'
  currentMap['name'] = 'MoleculeMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.MoleculeMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to NameMapping
  currentMap = {}
  exolinks['NameMapping'] = currentMap
  loadMaps['NMAP.exo-NameMapping'] = currentMap
  currentMap['tag'] = 'NMAP.exo-NameMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00005'
  currentMap['name'] = 'NameMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.NameMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to NameMappingStore
  currentMap = {}
  exolinks['NameMappingStore'] = currentMap
  loadMaps['NMAP.exo-NameMappingStore'] = currentMap
  currentMap['tag'] = 'NMAP.exo-NameMappingStore'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00011'
  currentMap['name'] = 'NameMappingStore'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.NameMappingStore
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))

  # Out-of-package link to ResonanceLinkMapping
  currentMap = {}
  exolinks['ResonanceLinkMapping'] = currentMap
  loadMaps['NMAP.exo-ResonanceLinkMapping'] = currentMap
  currentMap['tag'] = 'NMAP.exo-ResonanceLinkMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00010'
  currentMap['name'] = 'ResonanceLinkMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.ResonanceLinkMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ResonanceStatusMapping
  currentMap = {}
  exolinks['ResonanceStatusMapping'] = currentMap
  loadMaps['NMAP.exo-ResonanceStatusMapping'] = currentMap
  currentMap['tag'] = 'NMAP.exo-ResonanceStatusMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00009'
  currentMap['name'] = 'ResonanceStatusMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.NameMapping.ResonanceStatusMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
