"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Fri Mar 28 11:19:07 2014
  from data model element ccp.molecule.ChemComp revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

ChemComp.py: python API for CCPN data model, MetaPackage ccp.molecule.ChemComp

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.molecule.ChemElement
import ccp.api.molecule.Stereochemistry
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.molecule.ChemComp')

###############################################################################
class AbstractChemAtom(memops.api.Implementation.DataObject):
  r"""Atom in topology sense. E.g. Arg CB.

The AbstractChemAtoms within a 
ChemComp comprise all atomds (including link atoms) contained in any 
form of the ChemComp. The ChemCompVars then select the appropriate 
subset of AbstractChemAtoms. Bonds, angles, Stereochemistry etc. are 
relevant only for the ChemCompVars that contain all AbstractChemAtoms 
involved.

ChemAtom names are (should be) IUPAC and follow from the 
nature of the ChemComp. LinkAtom names (should) reflect the linkCode of 
the LinkEnd they are part of; the recommended style is that a LinkEnd 
with a linkCode 'prev' should have link atoms named 'prev_1' for the 
LinkAtom partaking in the bond and 'prev_2' for the other LinkAtom.
  """
  #   from data model element ccp.molecule.ChemComp.AbstractChemAtom revision ?
  _metaclass = metaPackage.getElement('AbstractChemAtom')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'subType', 'access', 'activeAccess', 'chemAngles', 'chemBonds', 'chemComp', 'chemCompVars', 'chemTorsions', 'coreStereochemistries', 'parent', 'root', 'stereochemistries', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChemCompVar(self, value):
    """
    Add for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompVar)):
      raise ApiError("""%s.addChemCompVar:
       value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemCompVars')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChemCompVar:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChemCompVar:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChemCompVar:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChemCompVar:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChemCompVar:
           Link chemCompVars between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('chemAtoms')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChemCompVar')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAngles(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.AbstractChemAtom.chemAngles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAngles')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAngles')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemBonds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.AbstractChemAtom.chemBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemBonds')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemBonds')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bondType', 'stereochem', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompVars(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompVars')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemCompVars')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemTorsions(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.AbstractChemAtom.chemTorsions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemTorsions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemTorsions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllCoreStereochemistries(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.AbstractChemAtom.coreStereochemistries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('coreStereochemistries')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('coreStereochemistries')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'stereoClass', 'value', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllStereochemistries(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.AbstractChemAtom.stereochemistries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('stereochemistries')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('stereochemistries')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'stereoClass', 'value', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAngle(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.AbstractChemAtom.chemAngles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAngles')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAngles')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemBond(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.AbstractChemAtom.chemBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemBonds')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemBonds')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bondType', 'stereochem', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompVar(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompVars')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemCompVars')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemTorsion(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.AbstractChemAtom.chemTorsions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemTorsions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemTorsions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstCoreStereochemistry(self, **conditions):
    """
    FindFirst for
    ccp.molecule.ChemComp.AbstractChemAtom.coreStereochemistries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('coreStereochemistries')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('coreStereochemistries')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'stereoClass', 'value', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstStereochemistry(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.AbstractChemAtom.stereochemistries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('stereochemistries')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('stereochemistries')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'stereoClass', 'value', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.AbstractChemAtom
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.AbstractChemAtom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.AbstractChemAtom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chemAtoms').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAngles(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.chemAngles
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAngles')
    result = frozenset(tempVar)
    return result
  
  def getChemBonds(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.chemBonds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemBonds')
    result = frozenset(tempVar)
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result
  
  def getChemCompVars(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemCompVars')
    result = frozenset(tempVar)
    return result
  
  def getChemTorsions(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.chemTorsions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemTorsions')
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCoreStereochemistries(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.coreStereochemistries
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('coreStereochemistries')
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.AbstractChemAtom
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('name'))
    result.append(dataDict.get('subType'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.AbstractChemAtom
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('name')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('subType')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getStereochemistries(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.stereochemistries
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('stereochemistries')
    result = frozenset(tempVar)
    return result
  
  def getSubType(self):
    """
    Get for ccp.molecule.ChemComp.AbstractChemAtom.subType
    """
    dataDict = self.__dict__
    result = dataDict.get('subType')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChemCompVar(self, value):
    """
    Remove for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompVar)):
      raise ApiError("""%s.removeChemCompVar:
       value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemCompVars')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChemCompVar:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChemCompVar:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChemCompVar:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChemCompVar:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('chemAtoms')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChemCompVar')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAngles(self, values):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.chemAngles
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAngles:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemAngle)):
        raise ApiError("""%s.setChemAngles:
         value is not of class ccp.molecule.ChemComp.ChemAngle""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAngles')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAngles:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAngles:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAngles:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('chemAtoms')
          if (len(oldSelves) < (3 + 1)):
            raise ApiError("""%s.setChemAngles:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      for cv in values:
        if (not (cv in currentValues)):
          oldSelves = cv.__dict__.get('chemAtoms')
          if (len(oldSelves) >= 3):
            raise ApiError("""%s.setChemAngles:
             hicard: oldSelves: cannot add value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAngles:
           Link chemAngles between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.append(self)

    dataDict['chemAngles'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAngles')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemBonds(self, values):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.chemBonds
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemBonds:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemBond)):
        raise ApiError("""%s.setChemBonds:
         value is not of class ccp.molecule.ChemComp.ChemBond""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemBonds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemBonds:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemBonds:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemBonds:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('chemAtoms')
          if (len(oldSelves) < (2 + 1)):
            raise ApiError("""%s.setChemBonds:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      for cv in values:
        if (not (cv in currentValues)):
          oldSelves = cv.__dict__.get('chemAtoms')
          if (len(oldSelves) >= 2):
            raise ApiError("""%s.setChemBonds:
             hicard: oldSelves: cannot add value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemBonds:
           Link chemBonds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.add(self)

    dataDict['chemBonds'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemBonds')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemCompVars(self, values):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemCompVars:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemCompVar)):
        raise ApiError("""%s.setChemCompVars:
         value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemCompVars')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemCompVars:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemCompVars:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemCompVars:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemCompVars:
           Link chemCompVars between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.add(self)

    dataDict['chemCompVars'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemCompVars')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemTorsions(self, values):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.chemTorsions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemTorsions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemTorsion)):
        raise ApiError("""%s.setChemTorsions:
         value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemTorsions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemTorsions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemTorsions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemTorsions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('chemAtoms')
          if (len(oldSelves) < (4 + 1)):
            raise ApiError("""%s.setChemTorsions:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      for cv in values:
        if (not (cv in currentValues)):
          oldSelves = cv.__dict__.get('chemAtoms')
          if (len(oldSelves) >= 4):
            raise ApiError("""%s.setChemTorsions:
             hicard: oldSelves: cannot add value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemTorsions:
           Link chemTorsions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.append(self)

    dataDict['chemTorsions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemTorsions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCoreStereochemistries(self, values):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.coreStereochemistries
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setCoreStereochemistries:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Stereochemistry)):
        raise ApiError("""%s.setCoreStereochemistries:
         value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('coreStereochemistries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCoreStereochemistries:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCoreStereochemistries:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCoreStereochemistries:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCoreStereochemistries:
           Link coreStereochemistries between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('coreAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('coreAtoms')
        oldSelves.append(self)

    dataDict['coreStereochemistries'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCoreStereochemistries')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (self.chemComp.findFirstChemAtomSet(name=value) is None)):
            raise ApiError("""%s.setName:
             name constraint ChemAtom_and_ChemAtomSet_share_namespace violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['name'] = value

    # doNotifies
  
  def setStereochemistries(self, values):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.stereochemistries
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setStereochemistries:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Stereochemistry)):
        raise ApiError("""%s.setStereochemistries:
         value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('stereochemistries')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStereochemistries:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStereochemistries:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setStereochemistries:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setStereochemistries:
           Link stereochemistries between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAtoms')
        oldSelves.append(self)

    dataDict['stereochemistries'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStereochemistries')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSubType(self, value):
    """
    Set for ccp.molecule.ChemComp.AbstractChemAtom.subType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSubType:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('subType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSubType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSubType:
         cannot set subType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSubType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['subType'] = value

    # doNotifies
  
  def sortedChemAngles(self):
    """
    Sorted for ccp.molecule.ChemComp.AbstractChemAtom.chemAngles
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemAngles')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemBonds(self):
    """
    Sorted for ccp.molecule.ChemComp.AbstractChemAtom.chemBonds
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemBonds')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemCompVars(self):
    """
    Sorted for ccp.molecule.ChemComp.AbstractChemAtom.chemCompVars
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemCompVars')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemTorsions(self):
    """
    Sorted for ccp.molecule.ChemComp.AbstractChemAtom.chemTorsions
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemTorsions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedCoreStereochemistries(self):
    """
    Sorted for ccp.molecule.ChemComp.AbstractChemAtom.coreStereochemistries
    """
    dataDict = self.__dict__
    ll = dataDict.get('coreStereochemistries')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedStereochemistries(self):
    """
    Sorted for ccp.molecule.ChemComp.AbstractChemAtom.stereochemistries
    """
    dataDict = self.__dict__
    ll = dataDict.get('stereochemistries')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of ChemAtom
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  subType = property(getSubType, setSubType, None,
  r"""Subtype of AbstractChemAtom, used to distinguish Atoms with the same 
  names but different characteristics, to be used in diferent 
  ChemCompVars.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAngles = property(getChemAngles, setChemAngles, None,
  r"""ChemAngles involving AbstractChemAtom
  """)
  
  chemBonds = property(getChemBonds, setChemBonds, None,
  r"""ChemBonds involving AbstractChemAtom
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  chemCompVars = property(getChemCompVars, setChemCompVars, None,
  r"""ChemCompVars that contain AbstractChemAtom
  """)
  
  chemTorsions = property(getChemTorsions, setChemTorsions, None,
  r"""ChemTorsions involving AbstractChemAtom
  """)
  
  coreStereochemistries = property(getCoreStereochemistries, setCoreStereochemistries, None,
  r"""Stereochemistry objects that describe the stereochemistry at ChemAtom.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  stereochemistries = property(getStereochemistries, setStereochemistries, None,
  r"""StereoChemistry objects that involve AbstractChemAtom in stereochemistry 
  definition
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AtomSysName(memops.api.Implementation.DataObject):
  r"""'sysName' is the systematic name for the ChemAtom or ChemAtomSet with 
name 'atomName' and subType atomSubType according to the naming system 
'namingSystem'. 'atomName' and atomSubTypecan be used to identify the 
ChemAtom(Set) involved.
  """
  #   from data model element ccp.molecule.ChemComp.AtomSysName revision ?
  _metaclass = metaPackage.getElement('AtomSysName')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('altSysNames', 'applicationData', 'atomName', 'atomSubType', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'sysName', 'access', 'activeAccess', 'namingSystem', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    dataDict['namingSystem'] = parent
    if (not isinstance(parent, NamingSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['altSysNames'] = list()
      dataDict['applicationData'] = list()
      dataDict['atomName'] = None
      dataDict['atomSubType'] = 1
      dataDict['sysName'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.AtomSysName.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('atomSysNames')
        ll = list()
        objKey = dataDict.get('atomName')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('atomSubType')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['atomName', 'atomSubType'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.AtomSysName:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.AtomSysName:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    namingSystem = dataDict.get('namingSystem')
    if (not (namingSystem in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('atomName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('atomSubType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = namingSystem.__dict__.get('atomSysNames')
        if (self is dd.get(objKey)):
          del dd[objKey]

  def addAltSysName(self, value):
    """
    Add for ccp.molecule.ChemComp.AtomSysName.altSysNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addAltSysName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addAltSysName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addAltSysName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addAltSysName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('altSysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAltSysName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAltSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAltSysName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('atomName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('atomSubType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('namingSystem')
        dd = value.__dict__.get('atomSysNames')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'namingSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      values = dataDict.get('altSysNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: altSysNames:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: altSysNames:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: altSysNames:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: altSysNames:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('atomName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: atomName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: atomName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: atomName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: atomName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('atomSubType')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: atomSubType:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sysName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: sysName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: sysName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: sysName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: sysName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('namingSystem')
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.checkValid: namingSystem:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('altSysNames')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('atomName')
    if (value is None):
      raise ApiError("""%s.checkValid: atomName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('atomSubType')
    if (value is None):
      raise ApiError("""%s.checkValid: atomSubType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('sysName')
    if (value is None):
      raise ApiError("""%s.checkValid: sysName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('namingSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: namingSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAltSysNames(self):
    """
    Get for ccp.molecule.ChemComp.AtomSysName.altSysNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('altSysNames')
    result = tuple(tempVar)
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomName(self):
    """
    Get for ccp.molecule.ChemComp.AtomSysName.atomName
    """
    dataDict = self.__dict__
    result = dataDict.get('atomName')
    return result
  
  def getAtomSubType(self):
    """
    Get for ccp.molecule.ChemComp.AtomSysName.atomSubType
    """
    dataDict = self.__dict__
    result = dataDict.get('atomSubType')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.AtomSysName
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.AtomSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.AtomSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('namingSystems').get(objKey)

      if (obj2 is not None):
        ll = list()
        objKey = fullKey[-2]
        ll.append(objKey)
        if (objKey is not None):
          objKey = fullKey[-1]
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        obj3 = obj2.__dict__.get('atomSysNames').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('namingSystem')
    obj1 = obj2.__dict__.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('atomName'))
    result.append(dataDict.get('atomSubType'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('atomName')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('atomSubType')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNamingSystem(self):
    """
    Get for ccp.molecule.ChemComp.AtomSysName.namingSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.AtomSysName.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSysName(self):
    """
    Get for ccp.molecule.ChemComp.AtomSysName.sysName
    """
    dataDict = self.__dict__
    result = dataDict.get('sysName')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def removeAltSysName(self, value):
    """
    Remove for ccp.molecule.ChemComp.AtomSysName.altSysNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeAltSysName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeAltSysName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeAltSysName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeAltSysName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('altSysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAltSysName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAltSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAltSysName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAltSysName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.AtomSysName
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAltSysNames(self, values):
    """
    Set for ccp.molecule.ChemComp.AtomSysName.altSysNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAltSysNames:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAltSysNames:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAltSysNames:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAltSysNames:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('altSysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAltSysNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAltSysNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['altSysNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAltSysNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtomName(self, value):
    """
    Set for ccp.molecule.ChemComp.AtomSysName.atomName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setAtomName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setAtomName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setAtomName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setAtomName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('atomName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAtomName:
         cannot set atomName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAtomName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['atomName'] = value

    # doNotifies
  
  def setAtomSubType(self, value):
    """
    Set for ccp.molecule.ChemComp.AtomSysName.atomSubType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setAtomSubType:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('atomSubType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomSubType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAtomSubType:
         cannot set atomSubType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAtomSubType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['atomSubType'] = value

    # doNotifies
  
  def setSysName(self, value):
    """
    Set for ccp.molecule.ChemComp.AtomSysName.sysName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSysName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setSysName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setSysName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setSysName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('sysName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSysName:
         cannot set sysName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSysName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['sysName'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  altSysNames = property(getAltSysNames, setAltSysNames, None,
  r"""Alternative systematic names - for naming systems that allow them. E.g. 
  XPLOR that allows both HB*, HB#, HB+, etc. for pseudoatoms.
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  atomName = property(getAtomName, setAtomName, None,
  r"""name of ChemAtom or ChemAtomSet the systematic name applies to.
  """)
  
  atomSubType = property(getAtomSubType, setAtomSubType, None,
  r"""subType of ChemAtom or ChemAtomSet the systematic name applies to.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  sysName = property(getSysName, setSysName, None,
  r"""Systematic name of ChemAtom (or ChemAtomSet)
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  namingSystem = property(getNamingSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for namingSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemAngle(memops.api.Implementation.DataObject):
  r"""Angle between chemAtoms. Serrves as definition for reference.
  """
  #   from data model element ccp.molecule.ChemComp.ChemAngle revision ?
  _metaclass = metaPackage.getElement('ChemAngle')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'chemAtoms', 'chemComp', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['access'] = None
      dataDict['chemAtoms'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemAngle.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAngles')
        objKey = dataDict.get('chemAtoms')
        if (objKey is not None):
          objKey = tuple(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['chemAtoms'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemAngle:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemAngle:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemAtom in dataDict.get('chemAtoms'):
      if (not (chemAtom in objsToBeDeleted)):
        chemAngles = chemAtom.__dict__.get('chemAngles')
        chemAngles.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      objKey = dataDict.get('chemAtoms')
      if (objKey is not None):
        objKey = tuple(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemAngles')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('chemAtoms')
      if (objKey is not None):
        objKey = tuple(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemAngles')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtoms')
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAngles')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    ll = list(self.chemAtoms)
    ll.reverse()
    isValid = (self.parent.findFirstChemAngle(chemAtoms=ll) is None)
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint ChemAngles_ABC_and_CBA_may_not_coexist violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtoms')
    if (not (len(values) == 3)):
      raise ApiError("""%s.checkValid: chemAtoms:
       locard, hicard: values must be of length == 3""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemAngle.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('chemAtoms')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemAngle.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemAngle
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemAngle'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemAngle'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-3])
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = tuple(tempList)
      obj2 = obj1.__dict__.get('chemAngles').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.ChemAngle.chemAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtoms')
    result = tuple(tempVar)
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.ChemAngle.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    for xx in dataDict.get('chemAtoms'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtoms')
    if (result is not None):
      result = tuple(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemAngle.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemAngle
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemAngle.chemAtoms
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AbstractChemAtom)):
        raise ApiError("""%s.setChemAtoms:
         value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChemAtoms:
         cannot set chemAtoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 3)):
        raise ApiError("""%s.setChemAtoms:
         locard, hicard: values must be of length == 3""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemAngles')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemAngles')
        oldSelves.add(self)

    dataDict['chemAtoms'] = values

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtoms = property(getChemAtoms, setChemAtoms, None,
  r"""AbstractChemAtoms making up ChemAngles
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemAtomSet(memops.api.Implementation.DataObject):
  r"""Group of chem atoms that may form a pseudoatom. A ChemAtomSet may 
consist of either other ChemAtomSets or of ChemAtoms, but not both. All 
ChemAtomSets are relevant for all ChemCompVars, but they (or some of the 
ChemAtomSets they consist of) may contain fewer or even no atoms in some 
ChemCompVars.
  """
  #   from data model element ccp.molecule.ChemComp.ChemAtomSet revision ?
  _metaclass = metaPackage.getElement('ChemAtomSet')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'distCorr', 'elementSymbol', 'fieldNames', 'inConstructor', 'isDeleted', 'isEquivalent', 'isProchiral', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'subType', 'access', 'activeAccess', 'chemAtomSet', 'chemAtomSets', 'chemAtoms', 'chemComp', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['distCorr'] = 0.0
      dataDict['isEquivalent'] = None
      dataDict['isProchiral'] = None
      dataDict['name'] = None
      dataDict['subType'] = 1
      dataDict['access'] = None
      dataDict['chemAtomSet'] = None
      dataDict['chemAtomSets'] = set()
      dataDict['chemAtoms'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemAtomSet.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAtomSets')
        ll = list()
        objKey = dataDict.get('name')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('subType')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name', 'subType'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemAtomSet:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemAtomSet:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    chemAtomSet = dataDict.get('chemAtomSet')
    if ((chemAtomSet is not None and not (chemAtomSet in objsToBeDeleted))):
      chemAtomSets = chemAtomSet.__dict__.get('chemAtomSets')
      chemAtomSets.remove(self)

    for chemAtomSet in dataDict.get('chemAtomSets'):
      if (not (chemAtomSet in objsToBeDeleted)):
        chemAtomSet.__dict__['chemAtomSet'] = None

    for chemAtom in dataDict.get('chemAtoms'):
      if (not (chemAtom in objsToBeDeleted)):
        chemAtom.__dict__['chemAtomSet'] = None

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemAtomSets')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChemAtom(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtom)):
      raise ApiError("""%s.addChemAtom:
       value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChemAtom:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChemAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChemAtom:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChemAtom:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChemAtom:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('chemAtomSet')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('chemAtoms')
      siblingValues.remove(value)

    value.__dict__['chemAtomSet'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChemAtom')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addChemAtomSet(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtomSet)):
      raise ApiError("""%s.addChemAtomSet:
       value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtomSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChemAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChemAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChemAtomSet:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChemAtomSet:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChemAtomSet:
           Link chemAtomSets between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('chemAtomSet')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('chemAtomSets')
      siblingValues.remove(value)

    value.__dict__['chemAtomSet'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChemAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemAtomSets')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('distCorr')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: distCorr:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: distCorr:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getElementSymbol()
      if (value is None):
        raise ApiError("""%s.checkValid: elementSymbol:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: elementSymbol:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isEquivalent')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isEquivalent:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isProchiral')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isProchiral:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('subType')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: subType:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemAtomSet')
      if (value is not None):
        if (not isinstance(value, ChemAtomSet)):
          raise ApiError("""%s.checkValid: chemAtomSet:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtomSets')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtomSet:
           non-reciprocal link chemAtomSet from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAtomSets')
      for value in values:
        if (not isinstance(value, ChemAtomSet)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemAtomSet')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           non-reciprocal link chemAtomSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           Link chemAtomSets between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtoms')
      for value in values:
        if (not isinstance(value, ChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemAtomSet')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    ll = [self]
    elements = set()
    for x in ll:
      ll.extend(x.chemAtomSets)
      for z in x.chemAtoms:
        elements.add(z.elementSymbol)
    
    isValid = (len(elements) == 1)
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint all_chemAtoms_must_be_same_chemElement violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not ((not self.chemAtoms) != (not self.chemAtomSets))):
      raise ApiError("""%s.checkValid:
       constraint chemAtomSet_has_chemAtoms_xor_chemAtomSets violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (self.chemAtoms or not self.isEquivalent)):
      raise ApiError("""%s.checkValid:
       constraint nested_chemAtomSets_cannot_be_equivalent violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (not (self.isProchiral and self.isEquivalent != False))):
      raise ApiError("""%s.checkValid:
       constraint prochirals_are_not_equivalent violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (not self.isProchiral or len(self.chemAtoms) == 2 or len(self.chemAtomSets) == 2)):
      raise ApiError("""%s.checkValid:
       constraint prochirals_must_be_pairs violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('distCorr')
    if (value is None):
      raise ApiError("""%s.checkValid: distCorr:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isEquivalent')
    value = dataDict.get('isProchiral')
    if (value is None):
      raise ApiError("""%s.checkValid: isProchiral:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (self.chemComp.findFirstChemAtom(name=value) is None)):
      raise ApiError("""%s.checkValid: name:
       name constraint ChemAtomSet_and_ChemAtom_share_namespace violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('subType')
    if (value is None):
      raise ApiError("""%s.checkValid: subType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chemAtomSet')
    values = dataDict.get('chemAtomSets')
    values = dataDict.get('chemAtoms')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtomSets(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomSets')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtomSets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtoms')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chirality', 'elementSymbol', 'name', 'nuclGroupType', 'shortVegaType', 'subType', 'waterExchangeable', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chirality', 'elementSymbol', 'name', 'nuclGroupType', 'shortVegaType', 'subType', 'waterExchangeable', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtomSet(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtomSets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtomSets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemAtomSet
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemAtomSet'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemAtomSet'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chemAtomSets').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtomSet(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSet
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtomSet')
    return result
  
  def getChemAtomSets(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtomSets')
    result = frozenset(tempVar)
    return result
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtoms')
    result = frozenset(tempVar)
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDistCorr(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.distCorr
    """
    dataDict = self.__dict__
    result = dataDict.get('distCorr')
    return result
  
  def getElementSymbol(self):
    """
    getter for derived attribute elementSymbol
    """
    dataDict = self.__dict__
    yy = self
    while yy is not None:
      xx = yy
      yy = xx.findFirstChemAtomSet()
    
    result = xx.findFirstChemAtom().elementSymbol
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('name'))
    result.append(dataDict.get('subType'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsEquivalent(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.isEquivalent
    """
    dataDict = self.__dict__
    result = dataDict.get('isEquivalent')
    return result
  
  def getIsProchiral(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.isProchiral
    """
    dataDict = self.__dict__
    result = dataDict.get('isProchiral')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('name')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('subType')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSubType(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtomSet.subType
    """
    dataDict = self.__dict__
    result = dataDict.get('subType')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChemAtom(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtom)):
      raise ApiError("""%s.removeChemAtom:
       value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChemAtom:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChemAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChemAtom:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChemAtom:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['chemAtomSet'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChemAtom')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeChemAtomSet(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtomSet)):
      raise ApiError("""%s.removeChemAtomSet:
       value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtomSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChemAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChemAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChemAtomSet:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChemAtomSet:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['chemAtomSet'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChemAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemAtomSet
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAtomSet(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSet
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ChemAtomSet)):
        raise ApiError("""%s.setChemAtomSet:
         value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemAtomSet')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtomSet:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtomSet:
           Link chemAtomSet between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('chemAtomSets')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setChemAtomSet:
         Read link 'chemAtomSet' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('chemAtomSets')
      newSelves.add(self)

    dataDict['chemAtomSet'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemAtomSets(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtomSets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemAtomSet)):
        raise ApiError("""%s.setChemAtomSets:
         value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtomSets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtomSets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtomSets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtomSets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtomSets:
           Link chemAtomSets between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['chemAtomSet'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('chemAtomSet')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('chemAtomSets')
          vv.remove(cv)

      cv.__dict__['chemAtomSet'] = self

    dataDict['chemAtomSets'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtomSets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemAtom)):
        raise ApiError("""%s.setChemAtoms:
         value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtoms:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['chemAtomSet'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('chemAtomSet')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('chemAtoms')
          vv.remove(cv)

      cv.__dict__['chemAtomSet'] = self

    dataDict['chemAtoms'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtoms')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDistCorr(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.distCorr
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setDistCorr:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setDistCorr:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('distCorr')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDistCorr:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDistCorr:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDistCorr:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['distCorr'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDistCorr')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsEquivalent(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.isEquivalent
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setIsEquivalent:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isEquivalent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsEquivalent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsEquivalent:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['isEquivalent'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsEquivalent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsProchiral(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.isProchiral
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsProchiral:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isProchiral')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsProchiral:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsProchiral:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsProchiral:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isProchiral'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsProchiral')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (self.chemComp.findFirstChemAtom(name=value) is None)):
            raise ApiError("""%s.setName:
             name constraint ChemAtomSet_and_ChemAtom_share_namespace violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['name'] = value

    # doNotifies
  
  def setSubType(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtomSet.subType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSubType:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('subType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSubType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSubType:
         cannot set subType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSubType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['subType'] = value

    # doNotifies
  
  def sortedChemAtomSets(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemAtomSet.chemAtomSets
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemAtomSets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemAtoms(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemAtomSet.chemAtoms
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemAtoms')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  distCorr = property(getDistCorr, setDistCorr, None,
  r"""Distance Restraint Correction (in A) applied when making restraints to 
  the pseudoatom defined here. 
  """)
  
  elementSymbol = property(getElementSymbol, None, None,
  r"""ELement symbol for all ChemAtoms ultimately making up the ChemAtomSet.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isEquivalent = property(getIsEquivalent, setIsEquivalent, None,
  r"""Indicates whether the atoms in the ChemAtomSet are chemically equivalent 
  (set to true, e.g. for a methyl group), non-equivalent (set to false, 
  e.g. for  a methylene group or for the NH2 protons of a glutamine side 
  chain), or sometimes equivalent (not set, e.g. for the HD1/HD2 protons 
  of a a Phe or Tyr aromatic ting)..
  """)
  
  isProchiral = property(getIsProchiral, setIsProchiral, None,
  r"""Indicates whether the two atoms or chemAtomSets in the ChemAtomSet form 
  a prochiral pair, such as the b methylene group of serine..
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Pseudo atom name. 
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  subType = property(getSubType, setSubType, None,
  r"""Subtype of ChemAtomSet, used to distinguish ChemAtomSets with the same 
  names but different characteristics, to be used in diferent 
  ChemCompVars.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtomSet = property(getChemAtomSet, setChemAtomSet, None,
  r"""ChemAtomSet that ChemAtoms are part of
  """)
  
  chemAtomSets = property(getChemAtomSets, setChemAtomSets, None,
  r"""ChemAtomSets that make up ChemAtomSet
  """)
  
  chemAtoms = property(getChemAtoms, setChemAtoms, None,
  r"""ChemAtoms that make up ChemAtomSet.
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemBond(memops.api.Implementation.DataObject):
  r"""Bond between chemAtoms. Defines topology of ChemCompVars
  """
  #   from data model element ccp.molecule.ChemComp.ChemBond revision ?
  _metaclass = metaPackage.getElement('ChemBond')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'bondType', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'stereochem', 'access', 'activeAccess', 'chemAtoms', 'chemComp', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['bondType'] = 'single'
      dataDict['stereochem'] = None
      dataDict['access'] = None
      dataDict['chemAtoms'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemBond.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemBonds')
        objKey = dataDict.get('chemAtoms')
        if (objKey is not None):
          objKey = frozenset(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['chemAtoms'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemBond:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemBond:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemAtom in dataDict.get('chemAtoms'):
      if (not (chemAtom in objsToBeDeleted)):
        chemBonds = chemAtom.__dict__.get('chemBonds')
        chemBonds.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      objKey = dataDict.get('chemAtoms')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemBonds')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('chemAtoms')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemBonds')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('bondType')
      if (not (value in ['single', 'double', 'triple', 'aromatic', 'dative', 'singleplanar'])):
        raise ApiError("""%s.checkValid: bondType:
         ccp.molecule.ChemComp.BondType input is not in enumeration ['single', 'double', 'triple', 'aromatic', 'dative', 'singleplanar']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: bondType:
         BondType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stereochem')
      if (value is not None):
        if (not (value in ['E', 'Z', 'unknown'])):
          raise ApiError("""%s.checkValid: stereochem:
           ccp.molecule.ChemComp.BondStereochemistry input is not in enumeration ['E', 'Z', 'unknown']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: stereochem:
           BondStereochemistry constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtoms')
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemBonds')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('bondType')
    if (value is None):
      raise ApiError("""%s.checkValid: bondType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('stereochem')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtoms')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: chemAtoms:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemBond.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtoms')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemBond.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBondType(self):
    """
    Get for ccp.molecule.ChemComp.ChemBond.bondType
    """
    dataDict = self.__dict__
    result = dataDict.get('bondType')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemBond
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemBond'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemBond'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = frozenset(tempList)
      obj2 = obj1.__dict__.get('chemBonds').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.ChemBond.chemAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtoms')
    result = frozenset(tempVar)
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.ChemBond.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    for xx in dataDict.get('chemAtoms'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtoms')
    if (result is not None):
      result = frozenset(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemBond.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getStereochem(self):
    """
    Get for ccp.molecule.ChemComp.ChemBond.stereochem
    """
    dataDict = self.__dict__
    result = dataDict.get('stereochem')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemBond
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBondType(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemBond.bondType
    """
    dataDict = self.__dict__
    if (not (value in ['single', 'double', 'triple', 'aromatic', 'dative', 'singleplanar'])):
      raise ApiError("""%s.setBondType:
       ccp.molecule.ChemComp.BondType input is not in enumeration ['single', 'double', 'triple', 'aromatic', 'dative', 'singleplanar']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setBondType:
       BondType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('bondType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBondType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBondType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setBondType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['bondType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBondType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChemAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemBond.chemAtoms
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AbstractChemAtom)):
        raise ApiError("""%s.setChemAtoms:
         value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChemAtoms:
         cannot set chemAtoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 2)):
        raise ApiError("""%s.setChemAtoms:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemBonds')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemBonds')
        oldSelves.add(self)

    dataDict['chemAtoms'] = values

    # doNotifies
  
  def setStereochem(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemBond.stereochem
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in ['E', 'Z', 'unknown'])):
        raise ApiError("""%s.setStereochem:
         ccp.molecule.ChemComp.BondStereochemistry input is not in enumeration ['E', 'Z', 'unknown']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setStereochem:
         BondStereochemistry constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stereochem')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStereochem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStereochem:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stereochem'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStereochem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChemAtoms(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemBond.chemAtoms
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemAtoms')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  bondType = property(getBondType, setBondType, None,
  r"""Type of bond (single, double, etc.); possible values given in the 
  BondType datatype.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  stereochem = property(getStereochem, setStereochem, None,
  r"""Bond stereochemistry in IUPAC notation(E/Z/unknown). Only applicable to 
  double bonds and similar.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtoms = property(getChemAtoms, setChemAtoms, None,
  r"""AbstractChemAtoms making up ChemBond
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemComp(memops.api.Implementation.TopObject):
  r"""Chemical Component. E.g. GLU (glutamate). Describes the topology of 
templates that serve as building block for molecules. The ChemComp holds 
information valid for all toploigical variants, as well as all Atoms, 
Bonds, Angles etc. for the different ChemCompVars (e.g. 
'start','protonated'; 'end','deprotonated', etc.). For this reason the 
Atoms, Bonds etc. linked to do not form a consistent set. 
  """
  #   from data model element ccp.molecule.ChemComp.ChemComp revision ?
  _metaclass = metaPackage.getElement('ChemComp')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'baseGlycoCtCode', 'beilsteinCode', 'casRegCode', 'ccpCode', 'className', 'code1Letter', 'code3Letter', 'commonNames', 'createdBy', 'details', 'fieldNames', 'guid', 'hasStdChirality', 'inConstructor', 'isDeleted', 'isLinearPolymer', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'keywords', 'lastUnlockedBy', 'merckCode', 'metaclass', 'molType', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'sigmaAldrichCode', 'stdChemCompCode', 'access', 'activeAccess', 'activeRepositories', 'chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemCompVars', 'chemTorsions', 'linkEnds', 'memopsRoot', 'namingSystems', 'packageLocator', 'parent', 'residueTypeProbs', 'root', 'stdChemComp', 'stereochemistries', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addCommonName(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemComp.commonNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 254):
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addCommonName:
       memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addCommonName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addCommonName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addCommonName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addKeyword(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemComp.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  backup = memops.api.Implementation.TopObject.backup

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAngles(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.chemAngles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAngles').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAngles').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtomSets(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.chemAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAtomSets').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAtomSets').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAtoms').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAtoms').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemBonds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.chemBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemBonds').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemBonds').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bondType', 'stereochem', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompVars(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemCompVars').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemCompVars').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemTorsions(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.chemTorsions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemTorsions').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemTorsions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.linkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('linkEnds').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('linkEnds').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNamingSystems(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.namingSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('namingSystems').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('namingSystems').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomReference', 'atomSetReference', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResidueTypeProbs(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.residueTypeProbs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueTypeProbs')
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueTypeProbs')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'possibility', 'resonanceGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllStereochemistries(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemComp.stereochemistries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('stereochemistries').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('stereochemistries').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'stereoClass', 'value', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAngle(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.chemAngles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAngles').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('chemAtoms')
      if (objKey is not None):
        objKey = tuple(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemAngles').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemAngles').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAtoms').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemAtoms').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemAtoms').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtomSet(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.chemAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemAtomSets').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemAtomSets').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemAtomSets').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemBond(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.chemBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemBonds').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('chemAtoms')
      if (objKey is not None):
        objKey = frozenset(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemBonds').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemBonds').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bondType', 'stereochem', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompVar(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemCompVars').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('linking')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('descriptor')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemCompVars').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemCompVars').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemTorsion(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.chemTorsions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('chemTorsions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('chemAtoms')
      if (objKey is not None):
        objKey = tuple(objKey)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('chemTorsions').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('chemTorsions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.linkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('linkEnds').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('linkCode')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('linkEnds').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('linkEnds').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNamingSystem(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.namingSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('namingSystems').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('namingSystems').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('namingSystems').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomReference', 'atomSetReference', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResidueTypeProb(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.residueTypeProbs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueTypeProbs')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('residueTypeProbs')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'possibility', 'resonanceGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstStereochemistry(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemComp.stereochemistries
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('stereochemistries').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('stereochemistries').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('stereochemistries').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'stereoClass', 'value', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBaseGlycoCtCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.baseGlycoCtCode
    """
    dataDict = self.__dict__
    result = dataDict.get('baseGlycoCtCode')
    return result
  
  def getBeilsteinCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.beilsteinCode
    """
    dataDict = self.__dict__
    result = dataDict.get('beilsteinCode')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemComp
    """

    result = None
    if (2 != len(fullKey)):
      raise ApiError("""'ccp.molecule.ChemComp.ChemComp'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    ll = list()
    objKey = fullKey[0]
    ll.append(objKey)
    if (objKey is not None):
      objKey = fullKey[1]
      ll.append(objKey)
      if (objKey is not None):
        objKey = tuple(ll)

    obj1 = startObj.__dict__.get('chemComps').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.molecule.ChemComp')
      obj1 = startObj.__dict__.get('chemComps').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCasRegCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.casRegCode
    """
    dataDict = self.__dict__
    result = dataDict.get('casRegCode')
    return result
  
  def getCcpCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.ccpCode
    """
    dataDict = self.__dict__
    result = dataDict.get('ccpCode')
    return result
  
  def getChemAngles(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.chemAngles
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemAngles').values()
    result = frozenset(tempVar)
    return result
  
  def getChemAtomSets(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.chemAtomSets
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemAtomSets').values()
    result = frozenset(tempVar)
    return result
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.chemAtoms
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemAtoms').values()
    result = frozenset(tempVar)
    return result
  
  def getChemBonds(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.chemBonds
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemBonds').values()
    result = frozenset(tempVar)
    return result
  
  def getChemCompVars(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.chemCompVars
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemCompVars').values()
    result = frozenset(tempVar)
    return result
  
  def getChemTorsions(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.chemTorsions
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('chemTorsions').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode1Letter(self):
    """
    getter for code1Letter attribute
    """
    dataDict = self.__dict__
    raise ApiError("""%s.getCode1Letter:
     getCode1Letter should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def getCode3Letter(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.code3Letter
    """
    dataDict = self.__dict__
    result = dataDict.get('code3Letter')
    return result
  
  def getCommonNames(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.commonNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('commonNames')
    result = tuple(tempVar)
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy
  
  def getDetails(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemComp
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('molType'))
      result.append(dataDict.get('ccpCode'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid
  
  def getHasStdChirality(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.hasStdChirality
    """
    dataDict = self.__dict__
    result = dataDict.get('hasStdChirality')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsLinearPolymer(self):
    """
    getter for derived link isLinearPolymer
    """
    dataDict = self.__dict__
    lin = 0
    nonlin = 0
    for ccv in self.chemCompVars:
      linking = ccv.linking 
      if linking in ('start', 'middle', 'end'):
        lin = lin + 1
      elif linking != 'none':
        nonlin = nonlin + 1
    
    if lin:
      if nonlin:
        raise ApiError("ChemComp %s,%s has illegal combination of ChemCompVar linkings" % (self.molType, self.ccpCode))
      else:
        result = True
    else:
      result = False
    return result

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading
  
  def getKeywords(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.keywords
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('keywords')
    result = tuple(tempVar)
    return result

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLinkEnds(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.linkEnds
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('linkEnds').values()
    result = frozenset(tempVar)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemComp
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('molType')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('ccpCode')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result
  
  def getMerckCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.merckCode
    """
    dataDict = self.__dict__
    result = dataDict.get('merckCode')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolType(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.molType
    """
    dataDict = self.__dict__
    result = dataDict.get('molType')
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNamingSystems(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.namingSystems
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('namingSystems').values()
    result = frozenset(tempVar)
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidueTypeProbs(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.residueTypeProbs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('residueTypeProbs')
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSigmaAldrichCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.sigmaAldrichCode
    """
    dataDict = self.__dict__
    result = dataDict.get('sigmaAldrichCode')
    return result
  
  def getStdChemComp(self):
    """
    getter for derived attribute stdChemComp
    """
    dataDict = self.__dict__
    stdCcpCode = self.stdChemCompCode
    if stdCcpCode is None:
      result = None
    else:
      result = self.memopsRoot.findFirstChemComp(molType=self.molType, ccpCode=stdCcpCode)
    return result
  
  def getStdChemCompCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.stdChemCompCode
    """
    dataDict = self.__dict__
    raise ApiError("""%s.getStdChemCompCode:
     getStdChemCompCode should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def getStereochemistries(self):
    """
    Get for ccp.molecule.ChemComp.ChemComp.stereochemistries
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('stereochemistries').values()
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newChemAngle(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemAngle
    """
    return ChemAngle(self, **attrlinks)
  
  def newChemAtom(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemAtom
    """
    return ChemAtom(self, **attrlinks)
  
  def newChemAtomSet(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemAtomSet
    """
    return ChemAtomSet(self, **attrlinks)
  
  def newChemBond(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemBond
    """
    return ChemBond(self, **attrlinks)
  
  def newChemCompVar(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemCompVar
    """
    return ChemCompVar(self, **attrlinks)
  
  def newChemTorsion(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemTorsion
    """
    return ChemTorsion(self, **attrlinks)
  
  def newLinkAtom(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.LinkAtom
    """
    return LinkAtom(self, **attrlinks)
  
  def newLinkEnd(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.LinkEnd
    """
    return LinkEnd(self, **attrlinks)
  
  def newNamingSystem(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.NamingSystem
    """
    return NamingSystem(self, **attrlinks)
  
  def newStereochemistry(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.Stereochemistry
    """
    return Stereochemistry(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeCommonName(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemComp.commonNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 254):
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeCommonName:
       memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeCommonName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeCommonName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeCommonName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeCommonName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeFrom = memops.api.Implementation.TopObject.removeFrom
  
  def removeKeyword(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemComp.keywords
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeKeyword:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeKeyword:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeKeyword')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBaseGlycoCtCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.baseGlycoCtCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setBaseGlycoCtCode:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('baseGlycoCtCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBaseGlycoCtCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setBaseGlycoCtCode:
         cannot set baseGlycoCtCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['baseGlycoCtCode'] = value

    # doNotifies
  
  def setBeilsteinCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.beilsteinCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setBeilsteinCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setBeilsteinCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setBeilsteinCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setBeilsteinCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('beilsteinCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBeilsteinCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBeilsteinCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['beilsteinCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBeilsteinCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCasRegCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.casRegCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCasRegCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setCasRegCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCasRegCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setCasRegCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('casRegCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCasRegCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCasRegCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['casRegCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCasRegCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCcpCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.ccpCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCcpCode:
       LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('ccpCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCcpCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCcpCode:
         cannot set ccpCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCcpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ccpCode'] = value

    # doNotifies
  
  def setCode3Letter(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.code3Letter
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCode3Letter:
         ccp.molecule.ChemComp.ThreeLetterCode input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 3):
        raise ApiError("""%s.setCode3Letter:
         ccp.molecule.ChemComp.ThreeLetterCode maximum length is 3 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCode3Letter:
         ccp.molecule.ChemComp.ThreeLetterCode: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setCode3Letter:
         ThreeLetterCode constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('code3Letter')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode3Letter:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode3Letter:
         cannot set code3Letter, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code3Letter'] = value

    # doNotifies
  
  def setCommonNames(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemComp.commonNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCommonNames:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('commonNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCommonNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCommonNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['commonNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCommonNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy
  
  def setDetails(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setGuid = memops.api.Implementation.TopObject.setGuid
  
  def setHasStdChirality(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.hasStdChirality
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setHasStdChirality:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('hasStdChirality')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHasStdChirality:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHasStdChirality:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['hasStdChirality'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHasStdChirality')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable
  
  def setKeywords(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemComp.keywords
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setKeywords:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setKeywords:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('keywords')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setKeywords:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setKeywords:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['keywords'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setKeywords')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setMerckCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.merckCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMerckCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setMerckCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMerckCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setMerckCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('merckCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMerckCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMerckCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['merckCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMerckCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolType(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.molType
    """
    dataDict = self.__dict__
    if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
      raise ApiError("""%s.setMolType:
       ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolType:
       MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('molType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolType:
         cannot set molType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molType'] = value

    # doNotifies
  
  def setName(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setName:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResidueTypeProbs(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemComp.residueTypeProbs
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResidueTypeProbs:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ResidueTypeProb as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setResidueTypeProbs:
         value is not of class ccp.nmr.Nmr.ResidueTypeProb""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('residueTypeProbs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('possibility')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setResidueTypeProbs:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResidueTypeProbs:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResidueTypeProbs:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResidueTypeProbs:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setResidueTypeProbs:
           locard possibility: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setResidueTypeProbs:
           Link residueTypeProbs between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['possibility'] = self

    dataDict['residueTypeProbs'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResidueTypeProbs')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSigmaAldrichCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.sigmaAldrichCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSigmaAldrichCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setSigmaAldrichCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSigmaAldrichCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setSigmaAldrichCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('sigmaAldrichCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSigmaAldrichCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSigmaAldrichCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['sigmaAldrichCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSigmaAldrichCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStdChemCompCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemComp.stdChemCompCode
    """
    dataDict = self.__dict__
    raise ApiError("""%s.setStdChemCompCode:
     setStdChemCompCode should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def sortedChemAngles(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.chemAngles
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemAngles')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemAtomSets(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.chemAtomSets
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemAtomSets')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemAtoms(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.chemAtoms
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemAtoms')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemBonds(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.chemBonds
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemBonds')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemCompVars(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.chemCompVars
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemCompVars')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemTorsions(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.chemTorsions
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('chemTorsions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedLinkEnds(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.linkEnds
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('linkEnds')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNamingSystems(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.namingSystems
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('namingSystems')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedResidueTypeProbs(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.residueTypeProbs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('residueTypeProbs')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedStereochemistries(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemComp.stereochemistries
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('stereochemistries')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  baseGlycoCtCode = property(getBaseGlycoCtCode, setBaseGlycoCtCode, None,
  r"""base glycoCT description code. For carbohydrates. The full glycoCtCode 
  is only defined at the ChemCompVar level, but htis gives the base code 
  that is exanded on in the vars.
  """)
  
  beilsteinCode = property(getBeilsteinCode, setBeilsteinCode, None,
  r"""Beilstein compound code
  """)
  
  casRegCode = property(getCasRegCode, setCasRegCode, None,
  r"""CAS code
  """)
  
  ccpCode = property(getCcpCode, setCcpCode, None,
  r"""ccp Code of ChemComp. Part of the class key
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  code1Letter = property(getCode1Letter, None, None,
  r"""One-letter code
  """)
  
  code3Letter = property(getCode3Letter, setCode3Letter, None,
  r"""PDB three letter code of ChemComp.
  """)
  
  commonNames = property(getCommonNames, setCommonNames, None,
  r"""Common names of ChemComp
  """)

  createdBy = memops.api.Implementation.TopObject.createdBy
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid
  
  hasStdChirality = property(getHasStdChirality, setHasStdChirality, None,
  r"""Does ChemComp have standard chirality? Serves to flag molecules 
  containing ChemComps with non-standard chirality, such as D amino acids. 
  Note that the attribute may not be set, for cases where no standard is 
  defined.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isLinearPolymer = property(getIsLinearPolymer, None, None,
  r"""Is ChemComp a component of a linear polymer?
  """)

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading
  
  keywords = property(getKeywords, setKeywords, None,
  r"""Keywords for searching ChemComp. E.g. 'saccharide', ...
  """)

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy
  
  merckCode = property(getMerckCode, setMerckCode, None,
  r"""Merck compound code
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, setMolType, None,
  r"""molecule Type of ChemComp (part of the class key)
  """)
  
  name = property(getName, setName, None,
  r"""name of AbstractChemComp
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  sigmaAldrichCode = property(getSigmaAldrichCode, setSigmaAldrichCode, None,
  r"""SigmaAldrich compound code
  """)
  
  stdChemCompCode = property(getStdChemCompCode, setStdChemCompCode, None,
  r"""ccpCode of standard ChemComp corresponding to a given (non-standard) 
  ChemComp. E.g. bromo-tyrosine would have stdChemCompCode 'TYR'. 
  StdChemComps have stdChemCompCode equal to ccpCode. 
  Key for derived 
  link stdChemComp.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  chemAngles = property(getChemAngles,  None, None,
  r"""child link to class ChemAngle
  """)
  
  chemAtomSets = property(getChemAtomSets,  None, None,
  r"""child link to class ChemAtomSet
  """)
  
  chemAtoms = property(getChemAtoms,  None, None,
  r"""child link to class AbstractChemAtom
  """)
  
  chemBonds = property(getChemBonds,  None, None,
  r"""child link to class ChemBond
  """)
  
  chemCompVars = property(getChemCompVars,  None, None,
  r"""child link to class ChemCompVar
  """)
  
  chemTorsions = property(getChemTorsions,  None, None,
  r"""child link to class ChemTorsion
  """)
  
  linkEnds = property(getLinkEnds,  None, None,
  r"""child link to class LinkEnd
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  namingSystems = property(getNamingSystems,  None, None,
  r"""child link to class NamingSystem
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)
  
  residueTypeProbs = property(getResidueTypeProbs, setResidueTypeProbs, None,
  r"""ResidueTypeProb describing ResonanceGroups with a probability of 
  corresponding to this ChemComp.
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  stdChemComp = property(getStdChemComp, None, None,
  r"""Standard ChemComp corresponding to ChemComp. If ChemComp is a 
  StdChemComp points to the ChemComp itself.
  """)
  
  stereochemistries = property(getStereochemistries,  None, None,
  r"""child link to class Stereochemistry
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemCompSysName(memops.api.Implementation.DataObject):
  r"""ChemComp systematic name class. Gives systematic names applicable to a 
set of ChemCompVars. Some naming systems have only one systematic name 
for all ChemCompVars, others have different names for different sets. 
  """
  #   from data model element ccp.molecule.ChemComp.ChemCompSysName revision ?
  _metaclass = metaPackage.getElement('ChemCompSysName')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'sysName', 'access', 'activeAccess', 'chemCompVars', 'namingSystem', 'parent', 'root', 'specificChemCompVars', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    dataDict['namingSystem'] = parent
    if (not isinstance(parent, NamingSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['sysName'] = None
      dataDict['access'] = None
      dataDict['specificChemCompVars'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemCompSysName.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemCompSysNames')
        objKey = dataDict.get('sysName')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['sysName'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemCompSysName:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemCompSysName:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for specificChemCompVar in dataDict.get('specificChemCompVars'):
      if (not (specificChemCompVar in objsToBeDeleted)):
        specificSysNames = specificChemCompVar.__dict__.get('specificSysNames')
        specificSysNames.remove(self)

    namingSystem = dataDict.get('namingSystem')
    if (not (namingSystem in objsToBeDeleted)):
      objKey = dataDict.get('sysName')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = namingSystem.__dict__.get('chemCompSysNames')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addSpecificChemCompVar(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompVar)):
      raise ApiError("""%s.addSpecificChemCompVar:
       value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('specificChemCompVars')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addSpecificChemCompVar:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addSpecificChemCompVar:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addSpecificChemCompVar:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addSpecificChemCompVar:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addSpecificChemCompVar:
           Link specificChemCompVars between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          ll = value.findAllSpecificSysNames(namingSystem=self.namingSystem)
          isValid = (not ll  or (len(ll)== 1 and self in ll))
          if (not (isValid)):
            raise ApiError("""%s.addSpecificChemCompVar:
             specificChemCompVars constraint specific_namingSystem_is_unique_for_ChemCompVar violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    oldSelves = value.__dict__.get('specificSysNames')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addSpecificChemCompVar')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('sysName')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('namingSystem')
        dd = value.__dict__.get('chemCompSysNames')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'namingSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sysName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: sysName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: sysName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: sysName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: sysName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChemCompVars()
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getChemCompSysNames()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemCompVars:
           non-reciprocal link chemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('namingSystem')
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.checkValid: namingSystem:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('specificChemCompVars')
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: specificChemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('specificSysNames')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: specificChemCompVars:
           non-reciprocal link specificChemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: specificChemCompVars:
           Link specificChemCompVars between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    if (not (self.specificChemCompVars or len(self.namingSystem.findAllChemCompSysNames(specificChemCompVars=frozenset())) == 1)):
      raise ApiError("""%s.checkValid:
       constraint max_one_ChemCompSysName_without_specificChemCompVars violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('sysName')
    if (value is None):
      raise ApiError("""%s.checkValid: sysName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('namingSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: namingSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('specificChemCompVars')
    for value in values:
      ll = value.findAllSpecificSysNames(namingSystem=self.namingSystem)
      isValid = (not ll  or (len(ll)== 1 and self in ll))
      if (not (isValid)):
        raise ApiError("""%s.checkValid: specificChemCompVars:
         specificChemCompVars constraint specific_namingSystem_is_unique_for_ChemCompVar violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemCompVars(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompSysName.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompVars()
      result = set(currentValues)

    else:
      currentValues = self.getChemCompVars()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSpecificChemCompVars(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('specificChemCompVars')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('specificChemCompVars')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemCompVar(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompSysName.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompVars()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemCompVars()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSpecificChemCompVar(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('specificChemCompVars')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('specificChemCompVars')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemCompSysName
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemCompSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemCompSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('namingSystems').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('chemCompSysNames').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemCompVars(self):
    """
    getter for derived link chemCompVars
    """
    dataDict = self.__dict__
    result = self.specificChemCompVars
    if not result:
      result = self.getByNavigation('namingSystem', 'chemComp', 'chemCompVars')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('namingSystem')
    obj1 = obj2.__dict__.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('sysName'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    result = dataDict.get('sysName')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNamingSystem(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompSysName.namingSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompSysName.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSpecificChemCompVars(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('specificChemCompVars')
    result = frozenset(tempVar)
    return result
  
  def getSysName(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompSysName.sysName
    """
    dataDict = self.__dict__
    result = dataDict.get('sysName')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeSpecificChemCompVar(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompVar)):
      raise ApiError("""%s.removeSpecificChemCompVar:
       value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('specificChemCompVars')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeSpecificChemCompVar:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSpecificChemCompVar:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeSpecificChemCompVar:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeSpecificChemCompVar:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('specificSysNames')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeSpecificChemCompVar')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemCompSysName
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setSpecificChemCompVars(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSpecificChemCompVars:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemCompVar)):
        raise ApiError("""%s.setSpecificChemCompVars:
         value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('specificChemCompVars')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSpecificChemCompVars:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSpecificChemCompVars:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSpecificChemCompVars:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSpecificChemCompVars:
           Link specificChemCompVars between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          ll = value.findAllSpecificSysNames(namingSystem=self.namingSystem)
          isValid = (not ll  or (len(ll)== 1 and self in ll))
          if (not (isValid)):
            raise ApiError("""%s.setSpecificChemCompVars:
             specificChemCompVars constraint specific_namingSystem_is_unique_for_ChemCompVar violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('specificSysNames')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('specificSysNames')
        oldSelves.add(self)

    dataDict['specificChemCompVars'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSpecificChemCompVars')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSysName(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompSysName.sysName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSysName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setSysName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setSysName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setSysName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('sysName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSysName:
         cannot set sysName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSysName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['sysName'] = value

    # doNotifies
  
  def sortedChemCompVars(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompSysName.chemCompVars
    """
    dataDict = self.__dict__
    ll = self.getChemCompVars()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSpecificChemCompVars(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompSysName.specificChemCompVars
    """
    dataDict = self.__dict__
    ll = dataDict.get('specificChemCompVars')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  sysName = property(getSysName, setSysName, None,
  r"""systematic name of ChemComp according to namingSystem
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemCompVars = property(getChemCompVars, None, None,
  r"""All ChemCompVars where Sysname is valid 
  """)
  
  namingSystem = property(getNamingSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for namingSystem
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  specificChemCompVars = property(getSpecificChemCompVars, setSpecificChemCompVars, None,
  r"""Subset of ChemCompVars for which the ChemCompSysName applies. 
  ChemCompSysNames without any specificChemCompVars apply to *all* 
  ChemCompVars by default.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemCompVar(memops.api.Implementation.DataObject):
  r"""ChemComp with a given chain location (for polymers) or sybstitution/lin 
king pattern (for non-polymers) and a given topological variant. 
Topological variants are e.g. protonation states, and in general 
topological variations that can change over time for a given molecule. 
For Polymers topological variations (defined through the descriptor 
attribute) also include linking patterns in addition to those that make 
up the linear polymer links.

A Polymer ChemComp is any ChemComp with at 
least one ChemCompVar with  linking 'start', 'middle', or 'end'.  
If 
linking is 'start', there must be a 'next' link but no 'prev' link
if 
linking is 'end' there must be a 'prev' link but no 'next' link
if 
linking is 'middle' there must be both a 'next' and 'a prev'
if linking 
is neither there must be neither a 'next' nor a 'prev' link
if linking 
is 'none' and the ChemComp is not a linear polymer, there must be no 
links at all.
If there are no links, liking must be 'none'

The relevant 
constraints are placed on ChemCompVar and LinkEnd.
  """
  #   from data model element ccp.molecule.ChemComp.ChemCompVar revision ?
  _metaclass = metaPackage.getElement('ChemCompVar')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'descriptor', 'fieldNames', 'formalCharge', 'formula', 'glycoCtCode', 'inConstructor', 'isAromatic', 'isDefaultVar', 'isDeleted', 'isParamagnetic', 'linking', 'metaclass', 'molecularMass', 'name', 'nonStereoSmiles', 'packageName', 'packageShortName', 'qualifiedName', 'stereoSmiles', 'varName', 'access', 'activeAccess', 'chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemComp', 'chemCompSysNames', 'chemTorsions', 'linkEnds', 'parent', 'root', 'specificSysNames', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['descriptor'] = None
      dataDict['formalCharge'] = None
      dataDict['glycoCtCode'] = None
      dataDict['isAromatic'] = None
      dataDict['isDefaultVar'] = False
      dataDict['isParamagnetic'] = None
      dataDict['linking'] = None
      dataDict['nonStereoSmiles'] = None
      dataDict['stereoSmiles'] = None
      dataDict['varName'] = None
      dataDict['access'] = None
      dataDict['chemAtoms'] = set()
      dataDict['specificSysNames'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemCompVar.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemCompVars')
        ll = list()
        objKey = dataDict.get('linking')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('descriptor')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['linking', 'descriptor'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemCompVar:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemCompVar:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemAtom in dataDict.get('chemAtoms'):
      if (not (chemAtom in objsToBeDeleted)):
        chemCompVars = chemAtom.__dict__.get('chemCompVars')
        chemCompVars.remove(self)

    for specificSysName in dataDict.get('specificSysNames'):
      if (not (specificSysName in objsToBeDeleted)):
        specificChemCompVars = specificSysName.__dict__.get('specificChemCompVars')
        specificChemCompVars.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('linking')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('descriptor')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemCompVars')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChemAtom(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    if (not isinstance(value, AbstractChemAtom)):
      raise ApiError("""%s.addChemAtom:
       value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChemAtom:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChemAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChemAtom:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChemAtom:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addChemAtom:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('chemCompVars')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChemAtom')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addSpecificSysName(self, value):
    """
    Add for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompSysName)):
      raise ApiError("""%s.addSpecificSysName:
       value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('specificSysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addSpecificSysName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addSpecificSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addSpecificSysName:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addSpecificSysName:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addSpecificSysName:
           Link specificSysNames between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          ll = value.findAllSpecificSysNames(namingSystem=self.namingSystem)
          isValid = (not ll  or (len(ll)== 1 and self in ll))
          if (not (isValid)):
            raise ApiError("""%s.addSpecificSysName:
             specificChemCompVars constraint specific_namingSystem_is_unique_for_ChemCompVar violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelves = value.__dict__.get('specificChemCompVars')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addSpecificSysName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('linking')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('descriptor')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemCompVars')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('descriptor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: descriptor:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: descriptor:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('formalCharge')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: formalCharge:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getFormula()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: formula:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: formula:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: formula:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: formula:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('glycoCtCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: glycoCtCode:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isAromatic')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isAromatic:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isDefaultVar')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isDefaultVar:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isParamagnetic')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isParamagnetic:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('linking')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linking:
         ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linking:
         ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getMolecularMass()
      if (value is None):
        raise ApiError("""%s.checkValid: molecularMass:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: molecularMass:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: molecularMass:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getName()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('nonStereoSmiles')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: nonStereoSmiles:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stereoSmiles')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: stereoSmiles:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('varName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: varName:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: varName:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: varName:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChemAngles()
      for value in values:
        if (not isinstance(value, ChemAngle)):
          raise ApiError("""%s.checkValid: chemAngles:
           value is not of class ccp.molecule.ChemComp.ChemAngle""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAngles:
           Link chemAngles between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChemAtomSets()
      for value in values:
        if (not isinstance(value, ChemAtomSet)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           Link chemAtomSets between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtoms')
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemCompVars')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChemBonds()
      for value in values:
        if (not isinstance(value, ChemBond)):
          raise ApiError("""%s.checkValid: chemBonds:
           value is not of class ccp.molecule.ChemComp.ChemBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemBonds:
           Link chemBonds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getChemCompSysNames()
      for value in values:
        if (not isinstance(value, ChemCompSysName)):
          raise ApiError("""%s.checkValid: chemCompSysNames:
           value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getChemCompVars()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemCompSysNames:
           non-reciprocal link chemCompSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemCompSysNames:
           Link chemCompSysNames between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChemTorsions()
      for value in values:
        if (not isinstance(value, ChemTorsion)):
          raise ApiError("""%s.checkValid: chemTorsions:
           value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemTorsions:
           Link chemTorsions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getLinkEnds()
      for value in values:
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: linkEnds:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getChemCompVars()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: linkEnds:
           non-reciprocal link linkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('specificSysNames')
      for value in values:
        if (not isinstance(value, ChemCompSysName)):
          raise ApiError("""%s.checkValid: specificSysNames:
           value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('specificChemCompVars')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: specificSysNames:
           non-reciprocal link specificSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    ll = self.chemAtoms
    isValid = (len(ll) == len(set(x.name for x in ll)))
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint Atom_name_is_unique_within_ChemCompVar violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # set up
    le = set(x.linkCode for x in self.linkEnds)
    linking = self.linking
    isValid = True
    
    # none means no links, except for linear polymers
    if linking == 'none':
      if le and not self.chemComp.isLinearPolymer:
        isValid = False
    
    # no links always means that linking must be 'none'
    elif not le:
      isValid = False
    
    # 'start' linking incompatible with 'prev' link
    elif linking == 'start':
      if 'prev' in le:
        isValid = False
    
    # 'end' linking incompatible with 'next' link
    elif linking == 'end':
      if 'next' in le:
        isValid = False
    
    # 'prev' and 'next' links require 'start', 'middle', or 'end' linking
    elif linking != 'middle':
      if 'prev' in le or 'next' in le:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint relationship_between_linkings_linkCodes_and_isLinearPolymer violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('descriptor')
    if (value is None):
      raise ApiError("""%s.checkValid: descriptor:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # a descriptor is a semicolon-separated string of individual descriptors
    # an individual descriptor is of the form : tag:atName(,atName)+
    # the tags must appear in the order given in validTags,
    # and the atoms must be present
    # examples: 'prot:HD1''  'prot:HD1,HO;deprot:H1;link:SG' 'stereo_2:C1'
    # 'link:C2_2'
    # The ''link' tag is an exception, in that the 'atNames' are actually 
    # LinkEnd.linkCodes. These are atom names, but may in some cases have a '_n'
    # suffix where n is an integer. The linkCodes must correspond to linkEnds present in the ChemCompVar
    # For all other atNames after the tag, atom (name=atName) 
    # must be present in  the ChemCompVar
    # 'stereo' tags are of the form stereo_n, where n is a subType no.
    # and are the only tags to contain an underscore
    # Here, for all atNames after the tag, atom (name=atName, subType=subTypeNo)
    # must be present in  the ChemCompVar. The interpretation is that these
    # atom subtypes are chosen to give the correct stereochemistry; what that
    # stereochemistry is cna be seen by examining the atom network.
    
    # valid special descriptor
    validDescriptors = ('neutral',)
    
    # valid tags (key) and the order they must appear in (value)
    validTags = {'prot':0, 'deprot':1, 'link':2, 'stereo':3,}
    
    isValid = True
    if value is not None and value not in validDescriptors:
    
      chemAtomNames = set()
      linkAtomNames = set()
      for ca in self.chemComp.chemAtoms:
        if isinstance(ca, ChemAtom):
          chemAtomNames.add(ca.name)
        else:
          linkAtomNames.add(ca.name)
    
      tagIndex = -1
      lastSubNo = 0
      for desc in value.split(';'):
    
        try:
          (tag, text) = desc.split(':', 1)
        except ValueError:
          # no colon in descriptor
          print("Malformed descriptor %s: %s does not contain ':'" % (value, `desc`))
          isValid = False
          break
        
        # check that tags come in order, 
        # and that _subType come in order for each tag type
        splitTag = tag.split('_')
        tag = splitTag[0]
        if len(splitTag) > 1:
          if tag == 'stereo':
            subNo = int(splitTag[1])
          else:
            print(
             "Malformed descriptor %s: only 'stereo' tag may contain underscore'" 
             % value
            )
            isValid = False
            break
            
        else:
          subNo = 0 
        
        ii = validTags.get(tag)
        if ii is None:
          # tag validity
          print("Malformed descriptor %s: %s is not a valid tag" % (value, `tag`))
          isValid = False
          break
          
        elif ii < tagIndex:
          # tag order
          print("Malformed descriptor %s: tag %s appears out of sequence" % (value, `tag`))
          isValid = False
          break
          
        elif ii == tagIndex:
          if subNo <= lastSubNo:
            # tags with subNo not presented in order
            print("Malformed descriptor %s: %s is out of order" % (value, `desc`))
            isValid = False
            break
            
        else:
          # moved on to next type of tag
          tagIndex = ii
        
        lastSubNo = subNo
    
        if tag == 'link':
          if not self.chemComp.isLinearPolymer:
            print("Malformed descriptor %s: only linear polymer ChemComps may have 'link' descriptors" % (value,))
            isValid = False
            break
          linkCodes = text.split(',')
          for ss in ('next', 'prev'):
            if ss in linkCodes:
              print ("Malformed descriptor %s: 'link:' section contains %s" % (value, ss))
              isValid = False
              break
          
          atNames = []
          chemComp = self.chemComp
          for lc in linkCodes:
            if chemComp.findFirstLinkEnd(linkCode=lc) is None:
              print ("Malformed descriptor %s: 'link:'  %s is not a known linkCode" % (value, lc))
              isValid = False
              break
    
          atNames = []
          for ss in linkCodes :
            tt = ss.split('-', 1)
            atNames.append(tt[0])
            if len(tt) > 1 and tt[1] not in linkAtomNames:
              print("Malformed descriptor %s: atom name %s is not a LinkAtom name for ChemCompVar" % (value, tt[1]))
              isValid = False
              break
        else:
          atNames = text.split(',')
        
          if tag == 'stereo':
            for aa in atNames:
              if self.findFirstChemAtom(name=aa, subType=subNo) is None:
                print("Malformed descriptor %s: atom name %s subtype %s is not in ChemCompVar" % (value, aa, subNo))
                isValid = False
                break
          else:
            for aa in atNames:
              if aa not in chemAtomNames:
                print("Malformed descriptor %s: atom name %s is not in ChemCompVar" % (value, aa))
                isValid = False
                break
    
        if not isValid:
          break
    if (not (isValid)):
      raise ApiError("""%s.checkValid: descriptor:
       descriptor constraint descriptor_format_rule violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('formalCharge')
    if (value is None):
      raise ApiError("""%s.checkValid: formalCharge:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('glycoCtCode')
    value = dataDict.get('isAromatic')
    if (value is None):
      raise ApiError("""%s.checkValid: isAromatic:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isDefaultVar')
    if (value is None):
      raise ApiError("""%s.checkValid: isDefaultVar:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    isValid = True
    if value:
      if [x for x in self.chemComp.findAllChemCompVars(linking=self.linking)
             if x.isDefaultVar and x is not self]:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid: isDefaultVar:
       isDefaultVar constraint only_true_for_one_ChemCompVar_with_each_linking violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('isParamagnetic')
    if (value is None):
      raise ApiError("""%s.checkValid: isParamagnetic:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('linking')
    if (value is None):
      raise ApiError("""%s.checkValid: linking:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    isValid = True
    if value not in ('start', 'middle', 'end', 'none'):
      if value.startswith('link:'):
        chemComp = self.chemComp
        for lc in value[5:].split(','):
          if chemComp.findFirstLinkEnd(linkCode=lc) is None:
            print ("Malformed linking %s: 'link:'  %s is not a known linkCode" % (value,lc))
            isValid = False
            break
        
      else:
        isValid = False
        print "Malformed linking %s - does not start with 'link:'" % value
    if (not (isValid)):
      raise ApiError("""%s.checkValid: linking:
       linking constraint linking_format_rule violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('nonStereoSmiles')
    value = dataDict.get('stereoSmiles')
    value = dataDict.get('varName')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtoms')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('specificSysNames')
    for value in values:
      (self, value) = (value, self)
      ll = value.findAllSpecificSysNames(namingSystem=self.namingSystem)
      isValid = (not ll  or (len(ll)== 1 and self in ll))
      if (not (isValid)):
        raise ApiError("""%s.checkValid: specificSysNames:
         specificChemCompVars constraint specific_namingSystem_is_unique_for_ChemCompVar violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAngles(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.chemAngles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemAngles()
      result = set(currentValues)

    else:
      currentValues = self.getChemAngles()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtomSets(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.chemAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemAtomSets()
      result = set(currentValues)

    else:
      currentValues = self.getChemAtomSets()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemAtoms')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemBonds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.chemBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemBonds()
      result = set(currentValues)

    else:
      currentValues = self.getChemBonds()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bondType', 'stereochem', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.chemCompSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompSysNames()
      result = set(currentValues)

    else:
      currentValues = self.getChemCompSysNames()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemTorsions(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.chemTorsions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemTorsions()
      result = set(currentValues)

    else:
      currentValues = self.getChemTorsions()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.linkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getLinkEnds()
      result = set(currentValues)

    else:
      currentValues = self.getLinkEnds()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSpecificSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('specificSysNames')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('specificSysNames')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAngle(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.chemAngles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemAngles()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemAngles()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemAtomSet(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.chemAtomSets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemAtomSets()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemAtomSets()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType', 'access', 'chemAtomSet', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemBond(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.chemBonds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemBonds()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemBonds()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bondType', 'stereochem', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.chemCompSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompSysNames()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemCompSysNames()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemTorsion(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.chemTorsions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemTorsions()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemTorsions()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.linkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getLinkEnds()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getLinkEnds()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSpecificSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('specificSysNames')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('specificSysNames')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemCompVar
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemCompVar'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemCompVar'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chemCompVars').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAngles(self):
    """
    getter for derived link chemAngles
    """
    dataDict = self.__dict__
    atomsIncluded = self.chemAtoms.issuperset
    result = frozenset(xx for xx in self.chemComp.chemAngles if atomsIncluded(xx.chemAtoms))
    return result
  
  def getChemAtomSets(self):
    """
    getter for derived link chemAtomSets
    """
    dataDict = self.__dict__
    chemAtomVars = self.chemAtoms
    chemAtomSets = set(self.chemComp.chemAtomSets)
    
    # remove ChemAtomSets that do not have all atoms within ChemCompVar
    for ca in self.chemComp.chemAtoms:
      if isinstance(ca, ChemAtom) and ca not in chemAtomVars:
        cas = ca.chemAtomSet
        while cas in chemAtomSets:
          chemAtomSets.remove(cas)
          cas = cas.chemAtomSet
    
    # remove ChemAtomSets with duplicate names
    casByName = {}
    for cas in chemAtomSets.copy():
      name = cas.name
      cas0 = casByName.get(name)
    
      if cas0 is None:
        casByName[name] = cas
    
      else:
        set1 = cas.chemAtomSets
        if set1:
          set0 = cas0.chemAtomSets
        else:
          set1 = cas.chemAtoms
          set0 = cas0.chemAtoms
    
        if set1 < set0:
          casx = cas
          if not set1:
            raise ApiError("%s found ChemAtomSets %s and %s that are incompatible" % (self, cas, cas0))
    
        elif set0 < set1:
          casByName[name] = cas
          casx = cas0
          if not set0:
            raise ApiError("%s found ChemAtomSets %s and %s that are incompatible" % (self, cas, cas0))
    
        else:
          raise ApiError("%s found ChemAtomSets %s and %s that are not subsets of each other" % (self, cas, cas0))
          
        while casx in chemAtomSets:
          chemAtomSets.remove(casx)
          casx = casx.chemAtomSet
    #
    result = frozenset(chemAtomSets)
    return result
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtoms')
    result = frozenset(tempVar)
    return result
  
  def getChemBonds(self):
    """
    getter for derived link chemBonds
    """
    dataDict = self.__dict__
    chemAtomVars = self.chemAtoms
    result = frozenset(xx for xx in self.chemComp.chemBonds if xx.chemAtoms.issubset(chemAtomVars))
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result
  
  def getChemCompSysNames(self):
    """
    getter for derived link chemCompSysNames
    """
    dataDict = self.__dict__
    result = frozenset(y for x in self.chemComp.namingSystems for y in x.chemCompSysNames if not y.specificChemCompVars).union(self.specificSysNames)
    return result
  
  def getChemTorsions(self):
    """
    getter for derived link chemTorsions
    """
    dataDict = self.__dict__
    atomsIncluded = self.chemAtoms.issuperset
    result = frozenset(xx for xx in self.chemComp.chemTorsions if atomsIncluded(xx.chemAtoms))
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDescriptor(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.descriptor
    """
    dataDict = self.__dict__
    result = dataDict.get('descriptor')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFormalCharge(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.formalCharge
    """
    dataDict = self.__dict__
    result = dataDict.get('formalCharge')
    return result
  
  def getFormula(self):
    """
    getter for derived attribute formula
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    for ca in self.chemAtoms:
      if isinstance(ca, ChemAtom):
        ss = ca.elementSymbol
        ii = dd.get(ss)
        if ii is None:
          dd[ss] = 1
        else:
          dd[ss] = ii + 1
    
    # generate formula
    ll = [None] * (len(dd)*2)
    next = 0
    for ss in ('C', 'H'):
      ii = dd.get(ss)
      if ii is not None:
        ll[next] = ss
        ll[next+1] = str(ii)
        del dd[ss]
        next = next + 2
    
    items = dd.items()
    items.sort()
    for ss, ii in items:
      ll[next] = ss
      ll[next+1] = str(ii)
      next = next + 2
    #
    result = ''.join(ll)
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('linking'))
    result.append(dataDict.get('descriptor'))

    return result
  
  def getGlycoCtCode(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.glycoCtCode
    """
    dataDict = self.__dict__
    result = dataDict.get('glycoCtCode')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIsAromatic(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.isAromatic
    """
    dataDict = self.__dict__
    result = dataDict.get('isAromatic')
    return result
  
  def getIsDefaultVar(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.isDefaultVar
    """
    dataDict = self.__dict__
    result = dataDict.get('isDefaultVar')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsParamagnetic(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.isParamagnetic
    """
    dataDict = self.__dict__
    result = dataDict.get('isParamagnetic')
    return result
  
  def getLinkEnds(self):
    """
    getter for derived link linkEnds
    """
    dataDict = self.__dict__
    result = set(ca.boundLinkEnd for ca in self.chemAtoms if isinstance(ca,LinkAtom))
    if None in result:
      result.remove(None)
    result = frozenset(result)
    return result
  
  def getLinking(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.linking
    """
    dataDict = self.__dict__
    result = dataDict.get('linking')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('linking')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('descriptor')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolecularMass(self):
    """
    getter for derived attribute molecularMass
    """
    dataDict = self.__dict__
    # get formula dictionary
    dd = {}
    for ca in self.chemAtoms:
      if isinstance(ca, ChemAtom):
        ss = ca.elementSymbol
        ii = dd.get(ss)
        if ii is None:
          dd[ss] = 1
        else:
          dd[ss] = ii + 1
    
    # calculate mass
    xx = self.root.currentChemElementStore
    result = sum(ii * xx.findFirstChemElement(symbol=ss).mass for (ss, ii) in dd.iteritems())
    return result
  
  def getName(self):
    """
    getter for derived attribute 'name'.
    """
    dataDict = self.__dict__
    result = self.varName
    if result is None:
      result = self.chemComp.name
    return result
  
  def getNonStereoSmiles(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.nonStereoSmiles
    """
    dataDict = self.__dict__
    result = dataDict.get('nonStereoSmiles')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSpecificSysNames(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('specificSysNames')
    result = frozenset(tempVar)
    return result
  
  def getStereoSmiles(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.stereoSmiles
    """
    dataDict = self.__dict__
    result = dataDict.get('stereoSmiles')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getVarName(self):
    """
    Get for ccp.molecule.ChemComp.ChemCompVar.varName
    """
    dataDict = self.__dict__
    result = dataDict.get('varName')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChemAtom(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    if (not isinstance(value, AbstractChemAtom)):
      raise ApiError("""%s.removeChemAtom:
       value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChemAtom:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChemAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChemAtom:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChemAtom:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('chemCompVars')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChemAtom')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeSpecificSysName(self, value):
    """
    Remove for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemCompSysName)):
      raise ApiError("""%s.removeSpecificSysName:
       value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('specificSysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeSpecificSysName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSpecificSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeSpecificSysName:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeSpecificSysName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('specificChemCompVars')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeSpecificSysName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemCompVar
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AbstractChemAtom)):
        raise ApiError("""%s.setChemAtoms:
         value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtoms:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemCompVars')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemCompVars')
        oldSelves.add(self)

    dataDict['chemAtoms'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtoms')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDescriptor(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.descriptor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setDescriptor:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setDescriptor:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('descriptor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDescriptor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDescriptor:
         cannot set descriptor, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDescriptor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          # a descriptor is a semicolon-separated string of individual descriptors
          # an individual descriptor is of the form : tag:atName(,atName)+
          # the tags must appear in the order given in validTags,
          # and the atoms must be present
          # examples: 'prot:HD1''  'prot:HD1,HO;deprot:H1;link:SG' 'stereo_2:C1'
          # 'link:C2_2'
          # The ''link' tag is an exception, in that the 'atNames' are actually 
          # LinkEnd.linkCodes. These are atom names, but may in some cases have a '_n'
          # suffix where n is an integer. The linkCodes must correspond to linkEnds present in the ChemCompVar
          # For all other atNames after the tag, atom (name=atName) 
          # must be present in  the ChemCompVar
          # 'stereo' tags are of the form stereo_n, where n is a subType no.
          # and are the only tags to contain an underscore
          # Here, for all atNames after the tag, atom (name=atName, subType=subTypeNo)
          # must be present in  the ChemCompVar. The interpretation is that these
          # atom subtypes are chosen to give the correct stereochemistry; what that
          # stereochemistry is cna be seen by examining the atom network.
          
          # valid special descriptor
          validDescriptors = ('neutral',)
          
          # valid tags (key) and the order they must appear in (value)
          validTags = {'prot':0, 'deprot':1, 'link':2, 'stereo':3,}
          
          isValid = True
          if value is not None and value not in validDescriptors:
          
            chemAtomNames = set()
            linkAtomNames = set()
            for ca in self.chemComp.chemAtoms:
              if isinstance(ca, ChemAtom):
                chemAtomNames.add(ca.name)
              else:
                linkAtomNames.add(ca.name)
          
            tagIndex = -1
            lastSubNo = 0
            for desc in value.split(';'):
          
              try:
                (tag, text) = desc.split(':', 1)
              except ValueError:
                # no colon in descriptor
                print("Malformed descriptor %s: %s does not contain ':'" % (value, `desc`))
                isValid = False
                break
              
              # check that tags come in order, 
              # and that _subType come in order for each tag type
              splitTag = tag.split('_')
              tag = splitTag[0]
              if len(splitTag) > 1:
                if tag == 'stereo':
                  subNo = int(splitTag[1])
                else:
                  print(
                   "Malformed descriptor %s: only 'stereo' tag may contain underscore'" 
                   % value
                  )
                  isValid = False
                  break
                  
              else:
                subNo = 0 
              
              ii = validTags.get(tag)
              if ii is None:
                # tag validity
                print("Malformed descriptor %s: %s is not a valid tag" % (value, `tag`))
                isValid = False
                break
                
              elif ii < tagIndex:
                # tag order
                print("Malformed descriptor %s: tag %s appears out of sequence" % (value, `tag`))
                isValid = False
                break
                
              elif ii == tagIndex:
                if subNo <= lastSubNo:
                  # tags with subNo not presented in order
                  print("Malformed descriptor %s: %s is out of order" % (value, `desc`))
                  isValid = False
                  break
                  
              else:
                # moved on to next type of tag
                tagIndex = ii
              
              lastSubNo = subNo
          
              if tag == 'link':
                if not self.chemComp.isLinearPolymer:
                  print("Malformed descriptor %s: only linear polymer ChemComps may have 'link' descriptors" % (value,))
                  isValid = False
                  break
                linkCodes = text.split(',')
                for ss in ('next', 'prev'):
                  if ss in linkCodes:
                    print ("Malformed descriptor %s: 'link:' section contains %s" % (value, ss))
                    isValid = False
                    break
                
                atNames = []
                chemComp = self.chemComp
                for lc in linkCodes:
                  if chemComp.findFirstLinkEnd(linkCode=lc) is None:
                    print ("Malformed descriptor %s: 'link:'  %s is not a known linkCode" % (value, lc))
                    isValid = False
                    break
          
                atNames = []
                for ss in linkCodes :
                  tt = ss.split('-', 1)
                  atNames.append(tt[0])
                  if len(tt) > 1 and tt[1] not in linkAtomNames:
                    print("Malformed descriptor %s: atom name %s is not a LinkAtom name for ChemCompVar" % (value, tt[1]))
                    isValid = False
                    break
              else:
                atNames = text.split(',')
              
                if tag == 'stereo':
                  for aa in atNames:
                    if self.findFirstChemAtom(name=aa, subType=subNo) is None:
                      print("Malformed descriptor %s: atom name %s subtype %s is not in ChemCompVar" % (value, aa, subNo))
                      isValid = False
                      break
                else:
                  for aa in atNames:
                    if aa not in chemAtomNames:
                      print("Malformed descriptor %s: atom name %s is not in ChemCompVar" % (value, aa))
                      isValid = False
                      break
          
              if not isValid:
                break
          if (not (isValid)):
            raise ApiError("""%s.setDescriptor:
             descriptor constraint descriptor_format_rule violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['descriptor'] = value

    # doNotifies
  
  def setFormalCharge(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.formalCharge
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setFormalCharge:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('formalCharge')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFormalCharge:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFormalCharge:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFormalCharge:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['formalCharge'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFormalCharge')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setGlycoCtCode(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.glycoCtCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setGlycoCtCode:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('glycoCtCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGlycoCtCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setGlycoCtCode:
         cannot set glycoCtCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['glycoCtCode'] = value

    # doNotifies
  
  def setIsAromatic(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.isAromatic
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsAromatic:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isAromatic')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsAromatic:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsAromatic:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsAromatic:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isAromatic'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsAromatic')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsDefaultVar(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.isDefaultVar
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsDefaultVar:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isDefaultVar')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsDefaultVar:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsDefaultVar:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsDefaultVar:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          isValid = True
          if value:
            if [x for x in self.chemComp.findAllChemCompVars(linking=self.linking)
                   if x.isDefaultVar and x is not self]:
              isValid = False
          if (not (isValid)):
            raise ApiError("""%s.setIsDefaultVar:
             isDefaultVar constraint only_true_for_one_ChemCompVar_with_each_linking violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['isDefaultVar'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsDefaultVar')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsParamagnetic(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.isParamagnetic
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsParamagnetic:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isParamagnetic')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsParamagnetic:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsParamagnetic:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsParamagnetic:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isParamagnetic'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsParamagnetic')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLinking(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.linking
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinking:
       ccp.molecule.ChemComp.ChemCompLinking: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinking:
       ChemCompLinking constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linking')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinking:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLinking:
         cannot set linking, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLinking:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          isValid = True
          if value not in ('start', 'middle', 'end', 'none'):
            if value.startswith('link:'):
              chemComp = self.chemComp
              for lc in value[5:].split(','):
                if chemComp.findFirstLinkEnd(linkCode=lc) is None:
                  print ("Malformed linking %s: 'link:'  %s is not a known linkCode" % (value,lc))
                  isValid = False
                  break
              
            else:
              isValid = False
              print "Malformed linking %s - does not start with 'link:'" % value
          if (not (isValid)):
            raise ApiError("""%s.setLinking:
             linking constraint linking_format_rule violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['linking'] = value

    # doNotifies
  
  def setName(self, value):
    """
    setter for derived, settable attribute 'name'.
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setName:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getName()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    self.varName = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setNonStereoSmiles(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.nonStereoSmiles
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setNonStereoSmiles:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nonStereoSmiles')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNonStereoSmiles:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNonStereoSmiles:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['nonStereoSmiles'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNonStereoSmiles')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSpecificSysNames(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSpecificSysNames:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemCompSysName)):
        raise ApiError("""%s.setSpecificSysNames:
         value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('specificSysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSpecificSysNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSpecificSysNames:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSpecificSysNames:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSpecificSysNames:
           Link specificSysNames between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          ll = value.findAllSpecificSysNames(namingSystem=self.namingSystem)
          isValid = (not ll  or (len(ll)== 1 and self in ll))
          if (not (isValid)):
            raise ApiError("""%s.setSpecificSysNames:
             specificChemCompVars constraint specific_namingSystem_is_unique_for_ChemCompVar violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('specificChemCompVars')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('specificChemCompVars')
        oldSelves.add(self)

    dataDict['specificSysNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSpecificSysNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStereoSmiles(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.stereoSmiles
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStereoSmiles:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stereoSmiles')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStereoSmiles:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStereoSmiles:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stereoSmiles'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStereoSmiles')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setVarName(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemCompVar.varName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setVarName:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setVarName:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setVarName:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('varName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setVarName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setVarName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['varName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setVarName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChemAngles(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.chemAngles
    """
    dataDict = self.__dict__
    ll = self.getChemAngles()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemAtomSets(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.chemAtomSets
    """
    dataDict = self.__dict__
    ll = self.getChemAtomSets()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemAtoms(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.chemAtoms
    """
    dataDict = self.__dict__
    ll = dataDict.get('chemAtoms')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemBonds(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.chemBonds
    """
    dataDict = self.__dict__
    ll = self.getChemBonds()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemCompSysNames(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.chemCompSysNames
    """
    dataDict = self.__dict__
    ll = self.getChemCompSysNames()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemTorsions(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.chemTorsions
    """
    dataDict = self.__dict__
    ll = self.getChemTorsions()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedLinkEnds(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.linkEnds
    """
    dataDict = self.__dict__
    ll = self.getLinkEnds()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSpecificSysNames(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemCompVar.specificSysNames
    """
    dataDict = self.__dict__
    ll = dataDict.get('specificSysNames')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  descriptor = property(getDescriptor, setDescriptor, None,
  r"""Short string distinguishing the topological variant of the ChemCompVar 
  (e.g. protonation state) of the ChemCompVar. For ChemComps of linear 
  polymer type (only) also distinguishes substitution patterns not related 
  to the polymer bonds. The formatting rules are complex - see comment in 
  'descriptor_format_rule' constraint for details.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  formalCharge = property(getFormalCharge, setFormalCharge, None,
  r"""Formal charge of ChemCompVar
  """)
  
  formula = property(getFormula, None, None,
  r"""Chemical formula for ChemCompVar
  """)
  
  glycoCtCode = property(getGlycoCtCode, setGlycoCtCode, None,
  r"""glycoCT chem_comp_code specific to ChemCompVar. If not set use 
  chemComp.baseGlycoCtCode
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  isAromatic = property(getIsAromatic, setIsAromatic, None,
  r"""is ChemCompVar  aromatic?
  """)
  
  isDefaultVar = property(getIsDefaultVar, setIsDefaultVar, None,
  r"""Is this ChemCompVar the default for its linking? Or, in other words, is 
  this the ChemCompVar to use by default when creating a MolResidue with 
  this particular molType, ccpCode, and linking? 
  Note 
  that
  myChemComp.findAllChemCompVars(linking=x,isDefaultVar=True)
  
  will 
  return either one object or none for any value of x.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isParamagnetic = property(getIsParamagnetic, setIsParamagnetic, None,
  r"""is ChemCompVar paramagnetic?
  """)
  
  linking = property(getLinking, setLinking, None,
  r"""String distinguishing the pattern of linkEnds (substitution pattern) of 
  the ChemCompVar.  For a linear polymer type ChemComp linking must be 
  'start', 'middle', 'end', or 'none', and other linking patterns are 
  taken care of by the descriptor attribute. For Other ChemComps linking 
  distinguishes all possible substitution patterns. Here the format is 
  'link:' followed by a comma-separated list of the linkCodes for the 
  active links. E.g. 'link:SG,C1_2'
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molecularMass = property(getMolecularMass, None, None,
  r"""molecular mass for ChemCompVar.
  """)
  
  name = property(getName, setName, None,
  r"""name of ChemCompVar. Equal to varName if set, otherwise to ChemComp.name
  """)
  
  nonStereoSmiles = property(getNonStereoSmiles, setNonStereoSmiles, None,
  r"""Smiles description of topology (non-stereo)
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  stereoSmiles = property(getStereoSmiles, setStereoSmiles, None,
  r"""Smiles description of topology (stereo)
  """)
  
  varName = property(getVarName, setVarName, None,
  r"""Name for ChemCompVar. Overrides ChemComp.name and should only be set 
  when different from this. See ChemCompVar.name documentation
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAngles = property(getChemAngles, None, None,
  r"""chemAngles that lie within ChemCompVar
  """)
  
  chemAtomSets = property(getChemAtomSets, None, None,
  r"""ChemAtomSets contained in ChemCompVar. The setsa are 
  """)
  
  chemAtoms = property(getChemAtoms, setChemAtoms, None,
  r"""AbstractChemAtoms making up ChemCompVar
  """)
  
  chemBonds = property(getChemBonds, None, None,
  r"""Bonds contained in ChemCompVar
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  chemCompSysNames = property(getChemCompSysNames, None, None,
  r"""All chemCompSysNames relevant to ChemCompVar
  """)
  
  chemTorsions = property(getChemTorsions, None, None,
  r"""chemTorsions that lie within ChemCompVar
  """)
  
  linkEnds = property(getLinkEnds, None, None,
  r"""linkEnds available to ChemCompVar. A LinkEnd belongs to a ChemCompVar if 
  and only if the LinkEnd.boundLinkAtom belongs to the ChemCompVAr.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  specificSysNames = property(getSpecificSysNames, setSpecificSysNames, None,
  r"""Systematic names that are valid for this ChemCompVar but not for all 
  others. In addition to the specific ChemCompSysNames in this link, any 
  ChemCompSysName that is not linked to specific ChemCompVars is valid for 
  all ChemCompVars. Each ChemCompVar can have only one ChemCompSysName 
  within a given naming system.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemTorsion(memops.api.Implementation.DataObject):
  r"""Tosrion angle between four ChenmAtoms. Serves as definition for 
reference.
  """
  #   from data model element ccp.molecule.ChemComp.ChemTorsion revision ?
  _metaclass = metaPackage.getElement('ChemTorsion')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'chemAtoms', 'chemComp', 'parent', 'root', 'sysNames', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['chemAtoms'] = list()
      dataDict['sysNames'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemTorsion.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemTorsions')
        objKey = dataDict.get('chemAtoms')
        if (objKey is not None):
          objKey = tuple(objKey)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['chemAtoms'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemTorsion:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    sysNames = dataDict.get('sysNames')
    for sysName in sysNames:
      if (not (sysName in objsToBeDeleted)):
        objsToBeDeleted.add(sysName)
        objsToBeChecked.append(sysName)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemTorsion:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemAtom in dataDict.get('chemAtoms'):
      if (not (chemAtom in objsToBeDeleted)):
        chemTorsions = chemAtom.__dict__.get('chemTorsions')
        chemTorsions.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      objKey = dataDict.get('chemAtoms')
      if (objKey is not None):
        objKey = tuple(objKey)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemTorsions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('chemAtoms')
      if (objKey is not None):
        objKey = tuple(objKey)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemTorsions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: name:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtoms')
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemTorsions')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('sysNames')
      for value in values:
        if (not isinstance(value, ChemTorsionSysName)):
          raise ApiError("""%s.checkValid: sysNames:
           value is not of class ccp.molecule.ChemComp.ChemTorsionSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemTorsion')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: sysNames:
           non-reciprocal link sysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: sysNames:
           Link sysNames between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    ll = list(self.chemAtoms)
    ll.reverse()
    isValid = (self.parent.findFirstChemTorsion(chemAtoms=ll) is None)
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint ChemTorsions_ABCD_and_DCBA_may_not_coexist violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtoms')
    if (not (len(values) == 4)):
      raise ApiError("""%s.checkValid: chemAtoms:
       locard, hicard: values must be of length == 4""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('sysNames')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemTorsion.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('chemAtoms')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result
  
  def findAllSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemTorsion.sysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('sysNames')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('sysNames')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'chemTorsion', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemTorsion.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemTorsion.sysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('sysNames')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('sysNames')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'chemTorsion', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemTorsion
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (6 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemTorsion'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemTorsion'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      tempList = list()
      tempList.append(fullKey[-4])
      tempList.append(fullKey[-3])
      tempList.append(fullKey[-2])
      tempList.append(fullKey[-1])
      objKey = tuple(tempList)
      obj2 = obj1.__dict__.get('chemTorsions').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsion.chemAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtoms')
    result = tuple(tempVar)
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsion.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    for xx in dataDict.get('chemAtoms'):
      result.append(xx)

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtoms')
    if (result is not None):
      result = tuple(result)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsion.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsion.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSysNames(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsion.sysNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('sysNames')
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemTorsion
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemTorsion.chemAtoms
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AbstractChemAtom)):
        raise ApiError("""%s.setChemAtoms:
         value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChemAtoms:
         cannot set chemAtoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (len(values) == 4)):
        raise ApiError("""%s.setChemAtoms:
         locard, hicard: values must be of length == 4""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('chemTorsions')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('chemTorsions')
        oldSelves.add(self)

    dataDict['chemAtoms'] = values

    # doNotifies
  
  def setName(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemTorsion.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSysNames(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemTorsion.sysNames
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSysNames:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, ChemTorsionSysName)):
        raise ApiError("""%s.setSysNames:
         value is not of class ccp.molecule.ChemComp.ChemTorsionSysName""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('sysNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSysNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSysNames:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSysNames:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setSysNames:
           locard chemTorsion: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSysNames:
           Link sysNames between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['chemTorsion'] = self

    dataDict['sysNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSysNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedSysNames(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemTorsion.sysNames
    """
    dataDict = self.__dict__
    ll = dataDict.get('sysNames')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of ChemTorsion
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtoms = property(getChemAtoms, setChemAtoms, None,
  r"""AbstractChemAtoms making up ChemTorsion
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  sysNames = property(getSysNames, setSysNames, None,
  r"""ChemTorsionSysNames that apply to ChemTorsion. Describe systematic names 
  in various naming systems
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemTorsionSysName(memops.api.Implementation.DataObject):
  r"""Systematic name of ChemTorsion accordign to NamingSystem
  """
  #   from data model element ccp.molecule.ChemComp.ChemTorsionSysName revision ?
  _metaclass = metaPackage.getElement('ChemTorsionSysName')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'sysName', 'access', 'activeAccess', 'chemTorsion', 'namingSystem', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    dataDict['namingSystem'] = parent
    if (not isinstance(parent, NamingSystem)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['sysName'] = None
      dataDict['access'] = None
      dataDict['chemTorsion'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemTorsionSysName.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemTorsionSysNames')
        objKey = dataDict.get('chemTorsion')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['chemTorsion'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemTorsionSysName:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemTorsionSysName:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    chemTorsion = dataDict.get('chemTorsion')
    if ((chemTorsion is not None and not (chemTorsion in objsToBeDeleted))):
      sysNames = chemTorsion.__dict__.get('sysNames')
      sysNames.remove(self)

    namingSystem = dataDict.get('namingSystem')
    if (not (namingSystem in objsToBeDeleted)):
      objKey = dataDict.get('chemTorsion')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = namingSystem.__dict__.get('chemTorsionSysNames')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('chemTorsion')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('namingSystem')
        dd = value.__dict__.get('chemTorsionSysNames')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'namingSystem' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sysName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: sysName:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: sysName:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: sysName:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: sysName:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemTorsion')
      if (not isinstance(value, ChemTorsion)):
        raise ApiError("""%s.checkValid: chemTorsion:
         value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('sysNames')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: chemTorsion:
         non-reciprocal link chemTorsion from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('namingSystem')
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.checkValid: namingSystem:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('sysName')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chemTorsion')
    if (value is None):
      raise ApiError("""%s.checkValid: chemTorsion:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('namingSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: namingSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemTorsionSysName
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemTorsionSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemTorsionSysName'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('namingSystems').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('chemTorsionSysNames').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemTorsion(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsionSysName.chemTorsion
    """
    dataDict = self.__dict__
    result = dataDict.get('chemTorsion')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('namingSystem')
    obj1 = obj2.__dict__.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('chemTorsion'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    result = dataDict.get('chemTorsion')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNamingSystem(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsionSysName.namingSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsionSysName.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('namingSystem')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSysName(self):
    """
    Get for ccp.molecule.ChemComp.ChemTorsionSysName.sysName
    """
    dataDict = self.__dict__
    result = dataDict.get('sysName')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemTorsionSysName
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemTorsion(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemTorsionSysName.chemTorsion
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemTorsion)):
      raise ApiError("""%s.setChemTorsion:
       value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemTorsion')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemTorsion:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemTorsion:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChemTorsion:
         cannot set chemTorsion, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setChemTorsion:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setChemTorsion:
         Link chemTorsion between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('sysNames')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setChemTorsion:
         Read link 'chemTorsion' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('sysNames')
      newSelves.add(self)

    dataDict['chemTorsion'] = value

    # doNotifies
  
  def setSysName(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemTorsionSysName.sysName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSysName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setSysName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSysName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setSysName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('sysName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSysName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSysName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['sysName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSysName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  sysName = property(getSysName, setSysName, None,
  r"""Systematic name according to naming system
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemTorsion = property(getChemTorsion, setChemTorsion, None,
  r"""ChemTorsion that ChemTorsionSysName applies to
  """)
  
  namingSystem = property(getNamingSystem,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for namingSystem
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class LinkEnd(memops.api.Implementation.DataObject):
  r"""Describes one end of link to other ChemComp. 
linkAtoms[0] and 
chemAtoms[0] must be included in the same set of chemCompVars. 
linkAtoms[1] and chemAtoms[1] must be included in the same set of 
ChemCompVars as linkAtoms[0] or in a subset of it.

There are 
constraints on the linkEnd, linkEnd.linkCode, ChemCompVar and 
ChemCompVar.linking (see ChemCompVar documentation). To satisfy the 
constraints the LinkEnd must be created after the ChemCompVars are 
created and linked to the correct AbstractChemAtoms.
  """
  #   from data model element ccp.molecule.ChemComp.LinkEnd revision ?
  _metaclass = metaPackage.getElement('LinkEnd')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'linkCode', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'chemCompVars', 'parent', 'remoteChemAtom', 'remoteLinkAtom', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['linkCode'] = None
      dataDict['access'] = None
      dataDict['boundChemAtom'] = None
      dataDict['boundLinkAtom'] = None
      dataDict['remoteChemAtom'] = None
      dataDict['remoteLinkAtom'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.LinkEnd.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('linkEnds')
        objKey = dataDict.get('linkCode')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['linkCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.LinkEnd:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.LinkEnd:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    boundChemAtom = dataDict.get('boundChemAtom')
    if ((boundChemAtom is not None and not (boundChemAtom in objsToBeDeleted))):
      boundLinkEnds = boundChemAtom.__dict__.get('boundLinkEnds')
      boundLinkEnds.remove(self)

    boundLinkAtom = dataDict.get('boundLinkAtom')
    if ((boundLinkAtom is not None and not (boundLinkAtom in objsToBeDeleted))):
      boundLinkAtom.__dict__['boundLinkEnd'] = None

    remoteChemAtom = dataDict.get('remoteChemAtom')
    if ((remoteChemAtom is not None and not (remoteChemAtom in objsToBeDeleted))):
      remoteLinkEnds = remoteChemAtom.__dict__.get('remoteLinkEnds')
      remoteLinkEnds.remove(self)

    remoteLinkAtom = dataDict.get('remoteLinkAtom')
    if ((remoteLinkAtom is not None and not (remoteLinkAtom in objsToBeDeleted))):
      remoteLinkAtom.__dict__['remoteLinkEnd'] = None

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      objKey = dataDict.get('linkCode')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('linkEnds')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('linkCode')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('linkEnds')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('linkCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: linkCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: linkCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('boundChemAtom')
      if (not isinstance(value, ChemAtom)):
        raise ApiError("""%s.checkValid: boundChemAtom:
         value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('boundLinkEnds')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: boundChemAtom:
         non-reciprocal link boundChemAtom from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('boundLinkAtom')
      if (not isinstance(value, LinkAtom)):
        raise ApiError("""%s.checkValid: boundLinkAtom:
         value is not of class ccp.molecule.ChemComp.LinkAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelf = value.__dict__.get('boundLinkEnd')
      if (not (oldSelf is self)):
        raise ApiError("""%s.checkValid: boundLinkAtom:
         non-reciprocal link boundLinkAtom from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: boundLinkAtom:
         Link boundLinkAtom between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getChemCompVars()
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getLinkEnds()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemCompVars:
           non-reciprocal link chemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemCompVars:
           Link chemCompVars between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('remoteChemAtom')
      if (value is not None):
        if (not isinstance(value, ChemAtom)):
          raise ApiError("""%s.checkValid: remoteChemAtom:
           value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('remoteLinkEnds')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: remoteChemAtom:
           non-reciprocal link remoteChemAtom from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('remoteLinkAtom')
      if (value is not None):
        if (not isinstance(value, LinkAtom)):
          raise ApiError("""%s.checkValid: remoteLinkAtom:
           value is not of class ccp.molecule.ChemComp.LinkAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('remoteLinkEnd')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: remoteLinkAtom:
           non-reciprocal link remoteLinkAtom from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: remoteLinkAtom:
           Link remoteLinkAtom between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # NB the boundLinkAtom defines which ChemCompVars have the link; therefore the test is not symmetrical.
    x = self.remoteLinkAtom
    y = self.boundLinkAtom
    if x is None:
      isValid = True
    else:
      isValid = not [z for z in y.chemCompVars if z not in x.chemCompVars]
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint both_link_atoms_in_same_chemCompVars violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    ll1 = self.boundLinkAtom.chemCompVars
    isValid = True
    ll = [self.boundChemAtom]
    x = self.remoteChemAtom
    if x is not None:
      ll.append(x)
    for ca in ll:
      if [x for x in ll1 if x not in ca.chemCompVars]:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint chemAtoms_in_same_chemCompVars_as_linkAtoms violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    linkCode = self.linkCode
    isValid = True
    if linkCode in ('next','prev'):
      chemComp = self.chemComp
      if linkCode == 'next':
        l1 = chemComp.findAllChemCompVars(linking='start')
      elif linkCode == 'prev':
        l1 = chemComp.findAllChemCompVars(linking='end')
      ll = chemComp.findAllChemCompVars(linking='middle')
      ll.update(l1)
      if self.chemCompVars != ll:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint linear_polymer_linkcodes_must_fit_chemCompVars violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = self.linkCode
    if value in ('prev', 'next', None):
      isValid = True
    else:
    
      atname = self.boundChemAtom.name
    
      if value == atname:
        isValid = True
    
      elif value.startswith(atname) and  value[-2] == '_' and value[-1] in '123456789':
        isValid = True 
    
      else:
        isValid = False
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint linkCode_conforms_to_boundChemAtom_name violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    x = self.remoteChemAtom
    y = self.boundChemAtom
    z = self.boundLinkAtom
    w = self.remoteLinkAtom
    if x is None or w is None:
      isValid = True
    else:
      isValid = (self.chemComp.findFirstChemTorsion(chemAtoms=(x, y, z, w)) or self.chemComp.findFirstChemTorsion(chemAtoms=(w, z, y, x)) ) and True
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint selected_atoms_must_define_torsion violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    ll = (self.boundChemAtom, self.boundLinkAtom)
    isValid = (self.chemComp.findFirstChemBond(chemAtoms=ll) or self.chemComp.findFirstChemBond(chemAtoms=(ll[1], ll[0])) ) and True
    if (not (isValid)):
      raise ApiError("""%s.checkValid:
       constraint selected_atoms_must_form_outofchemComp_bond violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('linkCode')
    if (value is None):
      raise ApiError("""%s.checkValid: linkCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('boundChemAtom')
    if (value is None):
      raise ApiError("""%s.checkValid: boundChemAtom:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('boundLinkAtom')
    if (value is None):
      raise ApiError("""%s.checkValid: boundLinkAtom:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    (self, value) = (value, self)
    if (not (value is None or self.name == value.linkCode + '_1')):
      raise ApiError("""%s.checkValid: boundLinkAtom:
       boundLinkEnd constraint LinkAtom_name_is_linkCode_with_suffix_1 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value is None or not self.remoteLinkEnd)):
      raise ApiError("""%s.checkValid: boundLinkAtom:
       boundLinkEnd constraint boundLinkEnd_incompatible_with_remoteLinkEnd violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    (value, self) = (self, value)
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('remoteChemAtom')
    value = dataDict.get('remoteLinkAtom')
    if (value is not None):
      (self, value) = (value, self)
      if (not (value is None or self.name == value.linkCode + '_2')):
        raise ApiError("""%s.checkValid: remoteLinkAtom:
         remoteLinkEnd constraint remoteLinkAtom_name_is_linkEnd_name_with_suffix violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value is None or not self.boundLinkEnd)):
        raise ApiError("""%s.checkValid: remoteLinkAtom:
         remoteLinkEnd constraint remoteLinkEnd_incompatible_with_boundLinkEnd violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemCompVars(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.LinkEnd.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompVars()
      result = set(currentValues)

    else:
      currentValues = self.getChemCompVars()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemCompVar(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.LinkEnd.chemCompVars
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChemCompVars()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getChemCompVars()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'formalCharge', 'glycoCtCode', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBoundChemAtom(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.boundChemAtom
    """
    dataDict = self.__dict__
    result = dataDict.get('boundChemAtom')
    return result
  
  def getBoundLinkAtom(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.boundLinkAtom
    """
    dataDict = self.__dict__
    result = dataDict.get('boundLinkAtom')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.LinkEnd
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.LinkEnd'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.LinkEnd'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('linkEnds').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result
  
  def getChemCompVars(self):
    """
    getter for derived link chemCompVars
    """
    dataDict = self.__dict__
    result = self.boundLinkAtom.chemCompVars
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('linkCode'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLinkCode(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.linkCode
    """
    dataDict = self.__dict__
    result = dataDict.get('linkCode')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('linkCode')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRemoteChemAtom(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.remoteChemAtom
    """
    dataDict = self.__dict__
    result = dataDict.get('remoteChemAtom')
    return result
  
  def getRemoteLinkAtom(self):
    """
    Get for ccp.molecule.ChemComp.LinkEnd.remoteLinkAtom
    """
    dataDict = self.__dict__
    result = dataDict.get('remoteLinkAtom')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.LinkEnd
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBoundChemAtom(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkEnd.boundChemAtom
    """
    dataDict = self.__dict__
    if (not isinstance(value, ChemAtom)):
      raise ApiError("""%s.setBoundChemAtom:
       value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('boundChemAtom')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBoundChemAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setBoundChemAtom:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setBoundChemAtom:
         cannot set boundChemAtom, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setBoundChemAtom:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setBoundChemAtom:
         Link boundChemAtom between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('boundLinkEnds')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setBoundChemAtom:
         Read link 'boundChemAtom' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('boundLinkEnds')
      newSelves.add(self)

    dataDict['boundChemAtom'] = value

    # doNotifies
  
  def setBoundLinkAtom(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkEnd.boundLinkAtom
    """
    dataDict = self.__dict__
    if (not isinstance(value, LinkAtom)):
      raise ApiError("""%s.setBoundLinkAtom:
       value is not of class ccp.molecule.ChemComp.LinkAtom""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('boundLinkAtom')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBoundLinkAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setBoundLinkAtom:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setBoundLinkAtom:
         cannot set boundLinkAtom, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setBoundLinkAtom:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      oldSelf = value.__dict__.get('boundLinkEnd')
      if (oldSelf is not None):
        raise ApiError("""%s.setBoundLinkAtom:
         oldSelf must be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setBoundLinkAtom:
         Link boundLinkAtom between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value is None or self.name == value.linkCode + '_1')):
            raise ApiError("""%s.setBoundLinkAtom:
             boundLinkEnd constraint LinkAtom_name_is_linkCode_with_suffix_1 violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          if (not (value is None or not self.remoteLinkEnd)):
            raise ApiError("""%s.setBoundLinkAtom:
             boundLinkEnd constraint boundLinkEnd_incompatible_with_remoteLinkEnd violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    if (currentValue is not None):
      currentValue.__dict__['boundLinkEnd'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('boundLinkEnd')
      if (oldSelf is not None):
        oldSelf.__dict__['boundLinkAtom'] = None

      value.__dict__['boundLinkEnd'] = self

    dataDict['boundLinkAtom'] = value

    # doNotifies
  
  def setLinkCode(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkEnd.linkCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLinkCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setLinkCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('linkCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLinkCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLinkCode:
         cannot set linkCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setLinkCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['linkCode'] = value

    # doNotifies
  
  def setRemoteChemAtom(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkEnd.remoteChemAtom
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ChemAtom)):
        raise ApiError("""%s.setRemoteChemAtom:
         value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('remoteChemAtom')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRemoteChemAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRemoteChemAtom:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setRemoteChemAtom:
         cannot set remoteChemAtom, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRemoteChemAtom:
           Link remoteChemAtom between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('remoteLinkEnds')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setRemoteChemAtom:
         Read link 'remoteChemAtom' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('remoteLinkEnds')
      newSelves.add(self)

    dataDict['remoteChemAtom'] = value

    # doNotifies
  
  def setRemoteLinkAtom(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkEnd.remoteLinkAtom
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, LinkAtom)):
        raise ApiError("""%s.setRemoteLinkAtom:
         value is not of class ccp.molecule.ChemComp.LinkAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('remoteLinkAtom')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRemoteLinkAtom:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRemoteLinkAtom:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setRemoteLinkAtom:
         cannot set remoteLinkAtom, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRemoteLinkAtom:
           Link remoteLinkAtom between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value is None or self.name == value.linkCode + '_2')):
            raise ApiError("""%s.setRemoteLinkAtom:
             remoteLinkEnd constraint remoteLinkAtom_name_is_linkEnd_name_with_suffix violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          if (not (value is None or not self.boundLinkEnd)):
            raise ApiError("""%s.setRemoteLinkAtom:
             remoteLinkEnd constraint remoteLinkEnd_incompatible_with_boundLinkEnd violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    if (currentValue is not None):
      currentValue.__dict__['remoteLinkEnd'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('remoteLinkEnd')
      if (oldSelf is not None):
        oldSelf.__dict__['remoteLinkAtom'] = None

      value.__dict__['remoteLinkEnd'] = self

    dataDict['remoteLinkAtom'] = value

    # doNotifies
  
  def sortedChemCompVars(self):
    """
    Sorted for ccp.molecule.ChemComp.LinkEnd.chemCompVars
    """
    dataDict = self.__dict__
    ll = self.getChemCompVars()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  linkCode = property(getLinkCode, setLinkCode, None,
  r"""code ('name') for link. The following naming convention is used:
  The 
  linkCode is the same as the name of the boundChemAtom. E.g. a cysteine 
  disulfide link will have linkCode 'SG'. The first exception is the case 
  where there is more than one link starting at the same atom - here the 
  linkCodes are the name of the first linkAtom followed by '_1', '_2'. 
  E.g. an atom CX with three links starting from it will have linkEnds 
  with linkCodes CX_1, CX_2, CX_3. If two different atom subtypes both 
  have a link, the linkCodes are of the same form - there are no fixed 
  rules for how to apportion the various suffixes. Another exception is 
  the 'prev' and 'next' that form the backbone of linear polymers.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  boundChemAtom = property(getBoundChemAtom, setBoundChemAtom, None,
  r"""One of the AbstractChemAtoms making up the Link. The direct bond is 
  betweeen boundChemAtom (within this ChemComp) and boundLinkAtom (outside 
  this ChemComp). The optional remoteChemAtom (within this ChemComp) and 
  remoteLinkAtom (outside this ChemComp) arebound to the their respective 
  boundAtoms. If defined they serve to define angles and torsions that 
  involve the out-of-ChemComp bond.
  """)
  
  boundLinkAtom = property(getBoundLinkAtom, setBoundLinkAtom, None,
  r"""One of the AbstractChemAtoms making up the Link. The direct bond is 
  betweeen boundChemAtom (within this ChemComp) and boundLinkAtom (outside 
  this ChemComp). The optional remoteChemAtom (within this ChemComp) and 
  remoteLinkAtom (outside this ChemComp) arebound to the their respective 
  boundAtoms. If defined they serve to define angles and torsions that 
  involve the out-of-ChemComp bond.
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  chemCompVars = property(getChemCompVars, None, None,
  r"""ChemCompVars that hold LinkEnd
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)
  
  remoteChemAtom = property(getRemoteChemAtom, setRemoteChemAtom, None,
  r"""One of the AbstractChemAtoms making up the Link. The direct bond is 
  betweeen boundChemAtom (within this ChemComp) and boundLinkAtom (outside 
  this ChemComp). The optional remoteChemAtom (within this ChemComp) and 
  remoteLinkAtom (outside this ChemComp) arebound to the their respective 
  boundAtoms. If defined they serve to define angles and torsions that 
  involve the out-of-ChemComp bond.
  """)
  
  remoteLinkAtom = property(getRemoteLinkAtom, setRemoteLinkAtom, None,
  r"""One of the AbstractChemAtoms making up the Link. The direct bond is 
  betweeen boundChemAtom (within this ChemComp) and boundLinkAtom (outside 
  this ChemComp). The optional remoteChemAtom (within this ChemComp) and 
  remoteLinkAtom (outside this ChemComp) arebound to the their respective 
  boundAtoms. If defined they serve to define angles and torsions that 
  involve the out-of-ChemComp bond.
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class NamingSystem(memops.api.Implementation.DataObject):
  r"""ChemComp naming system. Serves as container for ChemComp and 
Atom/AtomSet systematic names. May be defined relative to a reference, 
in which case only names that differ from those in the reference are 
given explicitly
  """
  #   from data model element ccp.molecule.ChemComp.NamingSystem revision ?
  _metaclass = metaPackage.getElement('NamingSystem')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'atomReference', 'atomSetReference', 'atomSetVariantSystems', 'atomSysNames', 'atomVariantSystems', 'chemComp', 'chemCompSysNames', 'chemTorsionSysNames', 'mainChemCompSysName', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['atomReference'] = None
      dataDict['atomSetReference'] = None
      dataDict['atomSetVariantSystems'] = set()
      dataDict['atomSysNames'] = {}
      dataDict['atomVariantSystems'] = set()
      dataDict['chemCompSysNames'] = {}
      dataDict['chemTorsionSysNames'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.NamingSystem.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('namingSystems')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.NamingSystem:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    atomSysNames = dataDict.get('atomSysNames').values()
    for atomSysName in atomSysNames:
      if (not (atomSysName in objsToBeDeleted)):
        objsToBeDeleted.add(atomSysName)
        objsToBeChecked.append(atomSysName)

    chemCompSysNames = dataDict.get('chemCompSysNames').values()
    for chemCompSysName in chemCompSysNames:
      if (not (chemCompSysName in objsToBeDeleted)):
        objsToBeDeleted.add(chemCompSysName)
        objsToBeChecked.append(chemCompSysName)

    chemTorsionSysNames = dataDict.get('chemTorsionSysNames').values()
    for chemTorsionSysName in chemTorsionSysNames:
      if (not (chemTorsionSysName in objsToBeDeleted)):
        objsToBeDeleted.add(chemTorsionSysName)
        objsToBeChecked.append(chemTorsionSysName)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.NamingSystem:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    atomReference = dataDict.get('atomReference')
    if ((atomReference is not None and not (atomReference in objsToBeDeleted))):
      atomVariantSystems = atomReference.__dict__.get('atomVariantSystems')
      atomVariantSystems.remove(self)

    atomSetReference = dataDict.get('atomSetReference')
    if ((atomSetReference is not None and not (atomSetReference in objsToBeDeleted))):
      atomSetVariantSystems = atomSetReference.__dict__.get('atomSetVariantSystems')
      atomSetVariantSystems.remove(self)

    for atomSetVariantSystem in dataDict.get('atomSetVariantSystems'):
      if (not (atomSetVariantSystem in objsToBeDeleted)):
        atomSetVariantSystem.__dict__['atomSetReference'] = None

    for atomVariantSystem in dataDict.get('atomVariantSystems'):
      if (not (atomVariantSystem in objsToBeDeleted)):
        atomVariantSystem.__dict__['atomReference'] = None

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('namingSystems')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAtomSetVariantSystem(self, value):
    """
    Add for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    if (not isinstance(value, NamingSystem)):
      raise ApiError("""%s.addAtomSetVariantSystem:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetVariantSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAtomSetVariantSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAtomSetVariantSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAtomSetVariantSystem:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAtomSetVariantSystem:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAtomSetVariantSystem:
           Link atomSetVariantSystems between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('atomSetReference')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('atomSetVariantSystems')
      siblingValues.remove(value)

    value.__dict__['atomSetReference'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAtomSetVariantSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addAtomVariantSystem(self, value):
    """
    Add for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    if (not isinstance(value, NamingSystem)):
      raise ApiError("""%s.addAtomVariantSystem:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomVariantSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAtomVariantSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAtomVariantSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAtomVariantSystem:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAtomVariantSystem:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAtomVariantSystem:
           Link atomVariantSystems between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('atomReference')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('atomVariantSystems')
      siblingValues.remove(value)

    value.__dict__['atomReference'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAtomVariantSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('atomSysNames').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemCompSysNames').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemTorsionSysNames').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('namingSystems')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('atomReference')
      if (value is not None):
        if (not isinstance(value, NamingSystem)):
          raise ApiError("""%s.checkValid: atomReference:
           value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atomVariantSystems')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: atomReference:
           non-reciprocal link atomReference from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('atomSetReference')
      if (value is not None):
        if (not isinstance(value, NamingSystem)):
          raise ApiError("""%s.checkValid: atomSetReference:
           value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('atomSetVariantSystems')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: atomSetReference:
           non-reciprocal link atomSetReference from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('atomSetVariantSystems')
      for value in values:
        if (not isinstance(value, NamingSystem)):
          raise ApiError("""%s.checkValid: atomSetVariantSystems:
           value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('atomSetReference')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: atomSetVariantSystems:
           non-reciprocal link atomSetVariantSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: atomSetVariantSystems:
           Link atomSetVariantSystems between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('atomSysNames').values()
      for value in values:
        if (not isinstance(value, AtomSysName)):
          raise ApiError("""%s.checkValid: atomSysNames:
           value is not of class ccp.molecule.ChemComp.AtomSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('namingSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: atomSysNames:
           non-reciprocal link atomSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('atomVariantSystems')
      for value in values:
        if (not isinstance(value, NamingSystem)):
          raise ApiError("""%s.checkValid: atomVariantSystems:
           value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('atomReference')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: atomVariantSystems:
           non-reciprocal link atomVariantSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: atomVariantSystems:
           Link atomVariantSystems between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('chemCompSysNames').values()
      for value in values:
        if (not isinstance(value, ChemCompSysName)):
          raise ApiError("""%s.checkValid: chemCompSysNames:
           value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('namingSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompSysNames:
           non-reciprocal link chemCompSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemTorsionSysNames').values()
      for value in values:
        if (not isinstance(value, ChemTorsionSysName)):
          raise ApiError("""%s.checkValid: chemTorsionSysNames:
           value is not of class ccp.molecule.ChemComp.ChemTorsionSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('namingSystem')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemTorsionSysNames:
           non-reciprocal link chemTorsionSysNames from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getMainChemCompSysName()
      if (value is not None):
        if (not isinstance(value, ChemCompSysName)):
          raise ApiError("""%s.checkValid: mainChemCompSysName:
           value is not of class ccp.molecule.ChemComp.ChemCompSysName""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: mainChemCompSysName:
           Link mainChemCompSysName between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('atomReference')
    value = dataDict.get('atomSetReference')
    values = dataDict.get('atomSetVariantSystems')
    values = dataDict.get('atomSysNames').values()
    values = dataDict.get('atomVariantSystems')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('chemCompSysNames').values()
    values = dataDict.get('chemTorsionSysNames').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAtomSetVariantSystems(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSetVariantSystems')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atomSetVariantSystems')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomReference', 'atomSetReference', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAtomSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.NamingSystem.atomSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSysNames').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atomSysNames').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomName', 'atomSubType', 'sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllAtomVariantSystems(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomVariantSystems')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atomVariantSystems')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomReference', 'atomSetReference', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.NamingSystem.chemCompSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompSysNames').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemCompSysNames').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllChemTorsionSysNames(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.NamingSystem.chemTorsionSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemTorsionSysNames').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chemTorsionSysNames').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'chemTorsion', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAtomSetVariantSystem(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSetVariantSystems')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('atomSetVariantSystems')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomReference', 'atomSetReference', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAtomSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.NamingSystem.atomSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomSysNames').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('atomName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('atomSubType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('atomSysNames').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('atomSysNames').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomName', 'atomSubType', 'sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstAtomVariantSystem(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomVariantSystems')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('atomVariantSystems')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'atomReference', 'atomSetReference', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.NamingSystem.chemCompSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemCompSysNames').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('sysName')
      if (objKey is not None):
        result = dataDict.get('chemCompSysNames').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chemCompSysNames').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstChemTorsionSysName(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.NamingSystem.chemTorsionSysNames
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemTorsionSysNames').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('chemTorsion')
      if (objKey is not None):
        result = dataDict.get('chemTorsionSysNames').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chemTorsionSysNames').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('sysName', 'access', 'chemTorsion', 'namingSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomReference(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.atomReference
    """
    dataDict = self.__dict__
    result = dataDict.get('atomReference')
    return result
  
  def getAtomSetReference(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.atomSetReference
    """
    dataDict = self.__dict__
    result = dataDict.get('atomSetReference')
    return result
  
  def getAtomSetVariantSystems(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomSetVariantSystems')
    result = frozenset(tempVar)
    return result
  
  def getAtomSysNames(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.atomSysNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomSysNames').values()
    result = frozenset(tempVar)
    return result
  
  def getAtomVariantSystems(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomVariantSystems')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.NamingSystem
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.NamingSystem'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.NamingSystem'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('namingSystems').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result
  
  def getChemCompSysNames(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.chemCompSysNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemCompSysNames').values()
    result = frozenset(tempVar)
    return result
  
  def getChemTorsionSysNames(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.chemTorsionSysNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemTorsionSysNames').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMainChemCompSysName(self):
    """
    getter for derived link mainChemCompSysName
    """
    dataDict = self.__dict__
    result = self.findFirstChemCompSysName(specificChemCompVars=frozenset())
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.NamingSystem.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newAtomSysName(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.AtomSysName
    """
    return AtomSysName(self, **attrlinks)
  
  def newChemCompSysName(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemCompSysName
    """
    return ChemCompSysName(self, **attrlinks)
  
  def newChemTorsionSysName(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.ChemTorsionSysName
    """
    return ChemTorsionSysName(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAtomSetVariantSystem(self, value):
    """
    Remove for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    if (not isinstance(value, NamingSystem)):
      raise ApiError("""%s.removeAtomSetVariantSystem:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetVariantSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAtomSetVariantSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAtomSetVariantSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAtomSetVariantSystem:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAtomSetVariantSystem:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['atomSetReference'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAtomSetVariantSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeAtomVariantSystem(self, value):
    """
    Remove for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    if (not isinstance(value, NamingSystem)):
      raise ApiError("""%s.removeAtomVariantSystem:
       value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomVariantSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAtomVariantSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAtomVariantSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAtomVariantSystem:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAtomVariantSystem:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['atomReference'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAtomVariantSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.NamingSystem
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtomReference(self, value):
    """
    Set for ccp.molecule.ChemComp.NamingSystem.atomReference
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.setAtomReference:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('atomReference')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomReference:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomReference:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtomReference:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtomReference:
           Link atomReference between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('atomVariantSystems')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAtomReference:
         Read link 'atomReference' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('atomVariantSystems')
      newSelves.add(self)

    dataDict['atomReference'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomReference')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAtomSetReference(self, value):
    """
    Set for ccp.molecule.ChemComp.NamingSystem.atomSetReference
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.setAtomSetReference:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('atomSetReference')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomSetReference:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomSetReference:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtomSetReference:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtomSetReference:
           Link atomSetReference between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('atomSetVariantSystems')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAtomSetReference:
         Read link 'atomSetReference' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('atomSetVariantSystems')
      newSelves.add(self)

    dataDict['atomSetReference'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomSetReference')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAtomSetVariantSystems(self, values):
    """
    Set for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAtomSetVariantSystems:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.setAtomSetVariantSystems:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomSetVariantSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomSetVariantSystems:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomSetVariantSystems:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtomSetVariantSystems:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtomSetVariantSystems:
           Link atomSetVariantSystems between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['atomSetReference'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('atomSetReference')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('atomSetVariantSystems')
          vv.remove(cv)

      cv.__dict__['atomSetReference'] = self

    dataDict['atomSetVariantSystems'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomSetVariantSystems')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAtomVariantSystems(self, values):
    """
    Set for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAtomVariantSystems:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, NamingSystem)):
        raise ApiError("""%s.setAtomVariantSystems:
         value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomVariantSystems')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomVariantSystems:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomVariantSystems:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAtomVariantSystems:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAtomVariantSystems:
           Link atomVariantSystems between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['atomReference'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('atomReference')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('atomVariantSystems')
          vv.remove(cv)

      cv.__dict__['atomReference'] = self

    dataDict['atomVariantSystems'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomVariantSystems')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.ChemComp.NamingSystem.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def sortedAtomSetVariantSystems(self):
    """
    Sorted for ccp.molecule.ChemComp.NamingSystem.atomSetVariantSystems
    """
    dataDict = self.__dict__
    ll = dataDict.get('atomSetVariantSystems')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedAtomSysNames(self):
    """
    Sorted for ccp.molecule.ChemComp.NamingSystem.atomSysNames
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('atomSysNames')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAtomVariantSystems(self):
    """
    Sorted for ccp.molecule.ChemComp.NamingSystem.atomVariantSystems
    """
    dataDict = self.__dict__
    ll = dataDict.get('atomVariantSystems')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedChemCompSysNames(self):
    """
    Sorted for ccp.molecule.ChemComp.NamingSystem.chemCompSysNames
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chemCompSysNames')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemTorsionSysNames(self):
    """
    Sorted for ccp.molecule.ChemComp.NamingSystem.chemTorsionSysNames
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chemTorsionSysNames')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""naming system within which systematic names are defined
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atomReference = property(getAtomReference, setAtomReference, None,
  r"""Reference naming system for atom names. Any atom names not found under 
  the namingSystem itself should be sought in the reference NamingSystem
  """)
  
  atomSetReference = property(getAtomSetReference, setAtomSetReference, None,
  r"""Reference naming system for atom set names. Any atom names not found 
  under the namingSystem itself should be sought in the reference 
  NamingSystem
  """)
  
  atomSetVariantSystems = property(getAtomSetVariantSystems, setAtomSetVariantSystems, None,
  r"""variant naming systems that use the present one for atom name reference
  """)
  
  atomSysNames = property(getAtomSysNames,  None, None,
  r"""child link to class AtomSysName
  """)
  
  atomVariantSystems = property(getAtomVariantSystems, setAtomVariantSystems, None,
  r"""variant naming systems that use the present one for atom name reference
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  chemCompSysNames = property(getChemCompSysNames,  None, None,
  r"""child link to class ChemCompSysName
  """)
  
  chemTorsionSysNames = property(getChemTorsionSysNames,  None, None,
  r"""child link to class ChemTorsionSysName
  """)
  
  mainChemCompSysName = property(getMainChemCompSysName, None, None,
  r"""ChemCompSysName valid for ChemCompVars where nothing esle is set, and 
  hence valid for the entire ChemComp.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Stereochemistry(memops.api.Implementation.DataObject):
  r"""The stereochemistry attribute in combination with the AbstractChemAtoms 
and their order in the link define the stereochemistry of the atoms.  
  """
  #   from data model element ccp.molecule.ChemComp.Stereochemistry revision ?
  _metaclass = metaPackage.getElement('Stereochemistry')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'stereoClass', 'value', 'access', 'activeAccess', 'chemAtoms', 'chemComp', 'coreAtoms', 'parent', 'refStereochemistry', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['serial'] = None
      dataDict['stereoClass'] = None
      dataDict['value'] = None
      dataDict['access'] = None
      dataDict['chemAtoms'] = list()
      dataDict['coreAtoms'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.Stereochemistry.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.ChemComp.Stereochemistry')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('stereochemistries')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.Stereochemistry:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.Stereochemistry:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemAtom in dataDict.get('chemAtoms'):
      if (not (chemAtom in objsToBeDeleted)):
        stereochemistries = chemAtom.__dict__.get('stereochemistries')
        stereochemistries.remove(self)

    for coreAtom in dataDict.get('coreAtoms'):
      if (not (coreAtom in objsToBeDeleted)):
        coreStereochemistries = coreAtom.__dict__.get('coreStereochemistries')
        coreStereochemistries.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('stereochemistries')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('stereochemistries')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stereoClass')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: stereoClass:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: stereoClass:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: stereoClass:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: stereoClass:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: value:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAtoms')
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('stereochemistries')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('coreAtoms')
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: coreAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('coreStereochemistries')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: coreAtoms:
           non-reciprocal link coreAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: coreAtoms:
           Link coreAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getRefStereochemistry()
      if (value is not None):
        from ccp.api.molecule.Stereochemistry import RefStereochemistry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: refStereochemistry:
           value is not of class ccp.molecule.Stereochemistry.RefStereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refStereochemistry:
           Link refStereochemistry between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    if (not (len(self.chemAtoms) == self.refStereochemistry.numAtoms)):
      raise ApiError("""%s.checkValid:
       constraint number_of_chemAtoms_must_fit_refStereochemistry violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('stereoClass')
    if (value is None):
      raise ApiError("""%s.checkValid: stereoClass:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chemAtoms')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('coreAtoms')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChemAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.Stereochemistry.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('chemAtoms')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result
  
  def findAllCoreAtoms(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.Stereochemistry.coreAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('coreAtoms')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('coreAtoms')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChemAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.Stereochemistry.chemAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chemAtoms')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('chemAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstCoreAtom(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.Stereochemistry.coreAtoms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('coreAtoms')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('coreAtoms')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'subType', 'access', 'chemComp',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.Stereochemistry
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.Stereochemistry'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.Stereochemistry'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('stereochemistries').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtoms(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.chemAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chemAtoms')
    result = tuple(tempVar)
    return result
  
  def getChemComp(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.chemComp
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCoreAtoms(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.coreAtoms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('coreAtoms')
    result = tuple(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('chemComp')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('molType'))
      result.append(obj1.__dict__.get('ccpCode'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chemComp')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefStereochemistry(self):
    """
    getter for derived attribute refStereochemistry
    """
    dataDict = self.__dict__
    stereochemistryStore = self.root.currentStereochemistryStore
    if stereochemistryStore is None:
      result = None
    else:
      result = stereochemistryStore.findFIrstRefStereochemistry(stereoClass=self.stereoClass)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getStereoClass(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.stereoClass
    """
    dataDict = self.__dict__
    result = dataDict.get('stereoClass')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValue(self):
    """
    Get for ccp.molecule.ChemComp.Stereochemistry.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.Stereochemistry
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChemAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.Stereochemistry.chemAtoms
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChemAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AbstractChemAtom)):
        raise ApiError("""%s.setChemAtoms:
         value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chemAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChemAtoms:
         cannot set chemAtoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtoms:
           Link chemAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('stereochemistries')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('stereochemistries')
        oldSelves.add(self)

    dataDict['chemAtoms'] = values

    # doNotifies
  
  def setCoreAtoms(self, values):
    """
    Set for ccp.molecule.ChemComp.Stereochemistry.coreAtoms
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setCoreAtoms:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, AbstractChemAtom)):
        raise ApiError("""%s.setCoreAtoms:
         value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('coreAtoms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCoreAtoms:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCoreAtoms:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCoreAtoms:
         cannot set coreAtoms, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCoreAtoms:
           Link coreAtoms between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('coreStereochemistries')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('coreStereochemistries')
        oldSelves.add(self)

    dataDict['coreAtoms'] = values

    # doNotifies
  
  def setRefStereochemistry(self, value):
    """
    setter for derived link refStereochemistry
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.Stereochemistry import RefStereochemistry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRefStereochemistry:
         value is not of class ccp.molecule.Stereochemistry.RefStereochemistry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getRefStereochemistry()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefStereochemistry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefStereochemistry:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefStereochemistry:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      raise ApiError("MolResidueData.chain can not be set to None")
    else:
      self.stereoClass = value.stereoClass
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setSerial(self, value):
    """
    Set for ccp.molecule.ChemComp.Stereochemistry.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('chemComp')
    oldSerial = parent.__dict__.get('_serialDict').get('stereochemistries')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['stereochemistries'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['stereochemistries'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setStereoClass(self, value):
    """
    Set for ccp.molecule.ChemComp.Stereochemistry.stereoClass
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setStereoClass:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setStereoClass:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setStereoClass:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setStereoClass:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stereoClass')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStereoClass:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setStereoClass:
         cannot set stereoClass, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setStereoClass:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['stereoClass'] = value

    # doNotifies
  
  def setValue(self, value):
    """
    Set for ccp.molecule.ChemComp.Stereochemistry.value
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setValue:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setValue:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setValue:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  stereoClass = property(getStereoClass, setStereoClass, None,
  r"""Type of stereochemistry represented. Used to derive link to 
  RefStereochemistry
  """)
  
  value = property(getValue, setValue, None,
  r"""Value for the stereochemistry.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtoms = property(getChemAtoms, setChemAtoms, None,
  r"""ChemAtoms that define value of StereoChemistry. The order of atoms in 
  the link is significant.
  """)
  
  chemComp = property(getChemComp,  None, None,
  r"""parent link
  """)
  
  coreAtoms = property(getCoreAtoms, setCoreAtoms, None,
  r"""ChemAtoms making up core of stereochemsitry, to which stereochemistry 
  designation belong (e.g. tetrahedral carbon, atoms in double bond). The 
  order of atoms in the link is significant.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chemComp
  """)
  
  refStereochemistry = property(getRefStereochemistry, setRefStereochemistry, None,
  r"""Stereochemistry class that Stereochemistry object corresponds to.
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class LinkAtom(AbstractChemAtom):
  r""" Atom used to specify LinkEnds. Serves as a placeholder for ChemAtoms 
that are not part of the present ChemComp but of other ChemComps linked 
to it. As such allows the definition of bonds, Torsions, Stereochemistry 
etc. involving ChemAtoms from several ChemComps. The key element in the 
definition of LinkEnds. 
  """
  #   from data model element ccp.molecule.ChemComp.LinkAtom revision ?
  _metaclass = metaPackage.getElement('LinkAtom')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'className', 'elementSymbol', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'subType', 'access', 'activeAccess', 'boundLinkEnd', 'chemAngles', 'chemBonds', 'chemComp', 'chemCompVars', 'chemTorsions', 'coreStereochemistries', 'parent', 'remoteLinkEnd', 'root', 'stereochemistries', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.LinkAtom
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['subType'] = 1
      dataDict['access'] = None
      dataDict['boundLinkEnd'] = None
      dataDict['chemAngles'] = set()
      dataDict['chemBonds'] = set()
      dataDict['chemCompVars'] = set()
      dataDict['chemTorsions'] = set()
      dataDict['coreStereochemistries'] = set()
      dataDict['remoteLinkEnd'] = None
      dataDict['stereochemistries'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.LinkAtom.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAtoms')
        ll = list()
        objKey = dataDict.get('name')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('subType')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name', 'subType'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.LinkAtom:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    boundLinkEnd = dataDict.get('boundLinkEnd')
    if (boundLinkEnd is not None):
      if (not (boundLinkEnd in objsToBeDeleted)):
        objsToBeDeleted.add(boundLinkEnd)
        objsToBeChecked.append(boundLinkEnd)

    chemAngles = dataDict.get('chemAngles')
    for chemAngle in chemAngles:
      if (not (chemAngle in objsToBeDeleted)):
        objsToBeDeleted.add(chemAngle)
        objsToBeChecked.append(chemAngle)

    chemBonds = dataDict.get('chemBonds')
    for chemBond in chemBonds:
      if (not (chemBond in objsToBeDeleted)):
        objsToBeDeleted.add(chemBond)
        objsToBeChecked.append(chemBond)

    chemTorsions = dataDict.get('chemTorsions')
    for chemTorsion in chemTorsions:
      if (not (chemTorsion in objsToBeDeleted)):
        objsToBeDeleted.add(chemTorsion)
        objsToBeChecked.append(chemTorsion)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.LinkAtom:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for chemCompVar in dataDict.get('chemCompVars'):
      if (not (chemCompVar in objsToBeDeleted)):
        chemAtoms = chemCompVar.__dict__.get('chemAtoms')
        chemAtoms.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemAtoms')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addChemCompVar = AbstractChemAtom.addChemCompVar
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.LinkAtom
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.LinkAtom
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemAtoms')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getElementSymbol()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: elementSymbol:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: elementSymbol:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: elementSymbol:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: elementSymbol:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('subType')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: subType:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('boundLinkEnd')
      if (value is not None):
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: boundLinkEnd:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('boundLinkAtom')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: boundLinkEnd:
           non-reciprocal link boundLinkEnd from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAngles')
      for value in values:
        if (not isinstance(value, ChemAngle)):
          raise ApiError("""%s.checkValid: chemAngles:
           value is not of class ccp.molecule.ChemComp.ChemAngle""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAngles:
           non-reciprocal link chemAngles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAngles:
           Link chemAngles between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemBonds')
      for value in values:
        if (not isinstance(value, ChemBond)):
          raise ApiError("""%s.checkValid: chemBonds:
           value is not of class ccp.molecule.ChemComp.ChemBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemBonds:
           non-reciprocal link chemBonds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemBonds:
           Link chemBonds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('chemCompVars')
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemCompVars:
           non-reciprocal link chemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemTorsions')
      for value in values:
        if (not isinstance(value, ChemTorsion)):
          raise ApiError("""%s.checkValid: chemTorsions:
           value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemTorsions:
           non-reciprocal link chemTorsions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemTorsions:
           Link chemTorsions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('coreStereochemistries')
      for value in values:
        if (not isinstance(value, Stereochemistry)):
          raise ApiError("""%s.checkValid: coreStereochemistries:
           value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('coreAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: coreStereochemistries:
           non-reciprocal link coreStereochemistries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('remoteLinkEnd')
      if (value is not None):
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: remoteLinkEnd:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('remoteLinkAtom')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: remoteLinkEnd:
           non-reciprocal link remoteLinkEnd from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('stereochemistries')
      for value in values:
        if (not isinstance(value, Stereochemistry)):
          raise ApiError("""%s.checkValid: stereochemistries:
           value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: stereochemistries:
           non-reciprocal link stereochemistries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    if (not (self.subType == 1)):
      raise ApiError("""%s.checkValid:
       constraint subtype_must_be_one violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (self.chemComp.findFirstChemAtomSet(name=value) is None)):
      raise ApiError("""%s.checkValid: name:
       name constraint ChemAtom_and_ChemAtomSet_share_namespace violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('subType')
    if (value is None):
      raise ApiError("""%s.checkValid: subType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('boundLinkEnd')
    if (value is not None):
      if (not (value is None or self.name == value.linkCode + '_1')):
        raise ApiError("""%s.checkValid: boundLinkEnd:
         boundLinkEnd constraint LinkAtom_name_is_linkCode_with_suffix_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value is None or not self.remoteLinkEnd)):
        raise ApiError("""%s.checkValid: boundLinkEnd:
         boundLinkEnd constraint boundLinkEnd_incompatible_with_remoteLinkEnd violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    values = dataDict.get('chemAngles')
    values = dataDict.get('chemBonds')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('chemCompVars')
    values = dataDict.get('chemTorsions')
    values = dataDict.get('coreStereochemistries')
    value = dataDict.get('remoteLinkEnd')
    if (value is not None):
      if (not (value is None or self.name == value.linkCode + '_2')):
        raise ApiError("""%s.checkValid: remoteLinkEnd:
         remoteLinkEnd constraint remoteLinkAtom_name_is_linkEnd_name_with_suffix violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value is None or not self.boundLinkEnd)):
        raise ApiError("""%s.checkValid: remoteLinkEnd:
         remoteLinkEnd constraint remoteLinkEnd_incompatible_with_boundLinkEnd violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    values = dataDict.get('stereochemistries')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllChemAngles = AbstractChemAtom.findAllChemAngles

  findAllChemBonds = AbstractChemAtom.findAllChemBonds

  findAllChemCompVars = AbstractChemAtom.findAllChemCompVars

  findAllChemTorsions = AbstractChemAtom.findAllChemTorsions

  findAllCoreStereochemistries = AbstractChemAtom.findAllCoreStereochemistries

  findAllStereochemistries = AbstractChemAtom.findAllStereochemistries

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstChemAngle = AbstractChemAtom.findFirstChemAngle

  findFirstChemBond = AbstractChemAtom.findFirstChemBond

  findFirstChemCompVar = AbstractChemAtom.findFirstChemCompVar

  findFirstChemTorsion = AbstractChemAtom.findFirstChemTorsion

  findFirstCoreStereochemistry = AbstractChemAtom.findFirstCoreStereochemistry

  findFirstStereochemistry = AbstractChemAtom.findFirstStereochemistry
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.LinkAtom
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBoundLinkEnd(self):
    """
    Get for ccp.molecule.ChemComp.LinkAtom.boundLinkEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('boundLinkEnd')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.LinkAtom
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.LinkAtom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.LinkAtom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chemAtoms').get(objKey)
      if (isinstance(obj2, LinkAtom)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getChemAngles = AbstractChemAtom.getChemAngles

  getChemBonds = AbstractChemAtom.getChemBonds

  getChemComp = AbstractChemAtom.getChemComp

  getChemCompVars = AbstractChemAtom.getChemCompVars

  getChemTorsions = AbstractChemAtom.getChemTorsions

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCoreStereochemistries = AbstractChemAtom.getCoreStereochemistries
  
  def getElementSymbol(self):
    """
    getter for derived attribute elementSymbol
    """
    dataDict = self.__dict__
    result = None
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractChemAtom.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = AbstractChemAtom.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = AbstractChemAtom.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractChemAtom.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRemoteLinkEnd(self):
    """
    Get for ccp.molecule.ChemComp.LinkAtom.remoteLinkEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('remoteLinkEnd')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getStereochemistries = AbstractChemAtom.getStereochemistries

  getSubType = AbstractChemAtom.getSubType

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeChemCompVar = AbstractChemAtom.removeChemCompVar
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.LinkAtom
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBoundLinkEnd(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkAtom.boundLinkEnd
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, LinkEnd)):
        raise ApiError("""%s.setBoundLinkEnd:
         value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('boundLinkEnd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBoundLinkEnd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBoundLinkEnd:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setBoundLinkEnd:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (currentValue is not None):
        raise ApiError("""%s.setBoundLinkEnd:
         currentValue must be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setBoundLinkEnd:
           Link boundLinkEnd between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value is None or self.name == value.linkCode + '_1')):
            raise ApiError("""%s.setBoundLinkEnd:
             boundLinkEnd constraint LinkAtom_name_is_linkCode_with_suffix_1 violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          if (not (value is None or not self.remoteLinkEnd)):
            raise ApiError("""%s.setBoundLinkEnd:
             boundLinkEnd constraint boundLinkEnd_incompatible_with_remoteLinkEnd violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    if (currentValue is not None):
      currentValue.__dict__['boundLinkAtom'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('boundLinkAtom')
      if (oldSelf is not None):
        oldSelf.__dict__['boundLinkEnd'] = None

      value.__dict__['boundLinkAtom'] = self

    dataDict['boundLinkEnd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBoundLinkEnd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setChemAngles = AbstractChemAtom.setChemAngles

  setChemBonds = AbstractChemAtom.setChemBonds

  setChemCompVars = AbstractChemAtom.setChemCompVars

  setChemTorsions = AbstractChemAtom.setChemTorsions

  setCoreStereochemistries = AbstractChemAtom.setCoreStereochemistries

  setName = AbstractChemAtom.setName
  
  def setRemoteLinkEnd(self, value):
    """
    Set for ccp.molecule.ChemComp.LinkAtom.remoteLinkEnd
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, LinkEnd)):
        raise ApiError("""%s.setRemoteLinkEnd:
         value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('remoteLinkEnd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRemoteLinkEnd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRemoteLinkEnd:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRemoteLinkEnd:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRemoteLinkEnd:
           Link remoteLinkEnd between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value is None or self.name == value.linkCode + '_2')):
            raise ApiError("""%s.setRemoteLinkEnd:
             remoteLinkEnd constraint remoteLinkAtom_name_is_linkEnd_name_with_suffix violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          if (not (value is None or not self.boundLinkEnd)):
            raise ApiError("""%s.setRemoteLinkEnd:
             remoteLinkEnd constraint remoteLinkEnd_incompatible_with_boundLinkEnd violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    if (currentValue is not None):
      currentValue.__dict__['remoteLinkAtom'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('remoteLinkAtom')
      if (oldSelf is not None):
        oldSelf.__dict__['remoteLinkEnd'] = None

      value.__dict__['remoteLinkAtom'] = self

    dataDict['remoteLinkEnd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRemoteLinkEnd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setStereochemistries = AbstractChemAtom.setStereochemistries

  setSubType = AbstractChemAtom.setSubType

  sortedChemAngles = AbstractChemAtom.sortedChemAngles

  sortedChemBonds = AbstractChemAtom.sortedChemBonds

  sortedChemCompVars = AbstractChemAtom.sortedChemCompVars

  sortedChemTorsions = AbstractChemAtom.sortedChemTorsions

  sortedCoreStereochemistries = AbstractChemAtom.sortedCoreStereochemistries

  sortedStereochemistries = AbstractChemAtom.sortedStereochemistries

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  elementSymbol = property(getElementSymbol, None, None,
  r"""There for compatibility - is always None
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = AbstractChemAtom.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  subType = AbstractChemAtom.subType

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  boundLinkEnd = property(getBoundLinkEnd, setBoundLinkEnd, None,
  r"""linkEnd with link directly bound to LinkAtom
  """)

  chemAngles = AbstractChemAtom.chemAngles

  chemBonds = AbstractChemAtom.chemBonds

  chemComp = AbstractChemAtom.chemComp

  chemCompVars = AbstractChemAtom.chemCompVars

  chemTorsions = AbstractChemAtom.chemTorsions

  coreStereochemistries = AbstractChemAtom.coreStereochemistries

  parent = AbstractChemAtom.parent
  
  remoteLinkEnd = property(getRemoteLinkEnd, setRemoteLinkEnd, None,
  r"""LinkEnd where LinkAtom is remoteLinkAtom
  """)

  root = memops.api.Implementation.MemopsObject.root

  stereochemistries = AbstractChemAtom.stereochemistries

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ChemAtom(AbstractChemAtom):
  r"""Atom, in the sense of a part of a toplogical description of a ChemComp. 
ChemAtoms, unlike LinkAtoms, are part of the ChemComp itself.
  """
  #   from data model element ccp.molecule.ChemComp.ChemAtom revision ?
  _metaclass = metaPackage.getElement('ChemAtom')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'chirality', 'className', 'elementSymbol', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'nuclGroupType', 'packageName', 'packageShortName', 'qualifiedName', 'shortVegaType', 'subType', 'waterExchangeable', 'access', 'activeAccess', 'boundLinkEnds', 'chemAngles', 'chemAtomSet', 'chemBonds', 'chemComp', 'chemCompVars', 'chemElement', 'chemTorsions', 'coreStereochemistries', 'parent', 'remoteLinkEnds', 'root', 'stereochemistries', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.ChemAtom
    """
    dataDict = self.__dict__
    dataDict['chemComp'] = parent
    if (not isinstance(parent, ChemComp)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['chirality'] = None
      dataDict['elementSymbol'] = None
      dataDict['name'] = None
      dataDict['nuclGroupType'] = None
      dataDict['shortVegaType'] = None
      dataDict['subType'] = 1
      dataDict['waterExchangeable'] = False
      dataDict['access'] = None
      dataDict['boundLinkEnds'] = set()
      dataDict['chemAngles'] = set()
      dataDict['chemAtomSet'] = None
      dataDict['chemBonds'] = set()
      dataDict['chemCompVars'] = set()
      dataDict['chemTorsions'] = set()
      dataDict['coreStereochemistries'] = set()
      dataDict['remoteLinkEnds'] = set()
      dataDict['stereochemistries'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.ChemAtom.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemAtoms')
        ll = list()
        objKey = dataDict.get('name')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('subType')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name', 'subType'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.ChemAtom:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    boundLinkEnds = dataDict.get('boundLinkEnds')
    for boundLinkEnd in boundLinkEnds:
      if (not (boundLinkEnd in objsToBeDeleted)):
        objsToBeDeleted.add(boundLinkEnd)
        objsToBeChecked.append(boundLinkEnd)

    chemAngles = dataDict.get('chemAngles')
    for chemAngle in chemAngles:
      if (not (chemAngle in objsToBeDeleted)):
        objsToBeDeleted.add(chemAngle)
        objsToBeChecked.append(chemAngle)

    chemBonds = dataDict.get('chemBonds')
    for chemBond in chemBonds:
      if (not (chemBond in objsToBeDeleted)):
        objsToBeDeleted.add(chemBond)
        objsToBeChecked.append(chemBond)

    chemTorsions = dataDict.get('chemTorsions')
    for chemTorsion in chemTorsions:
      if (not (chemTorsion in objsToBeDeleted)):
        objsToBeDeleted.add(chemTorsion)
        objsToBeChecked.append(chemTorsion)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.ChemAtom:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    chemAtomSet = dataDict.get('chemAtomSet')
    if ((chemAtomSet is not None and not (chemAtomSet in objsToBeDeleted))):
      chemAtoms = chemAtomSet.__dict__.get('chemAtoms')
      chemAtoms.remove(self)

    for chemCompVar in dataDict.get('chemCompVars'):
      if (not (chemCompVar in objsToBeDeleted)):
        chemAtoms = chemCompVar.__dict__.get('chemAtoms')
        chemAtoms.remove(self)

    chemComp = dataDict.get('chemComp')
    if (not (chemComp in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chemComp.__dict__.get('chemAtoms')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addChemCompVar = AbstractChemAtom.addChemCompVar
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.ChemAtom
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.ChemAtom
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('name')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('subType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chemComp')
        dd = value.__dict__.get('chemAtoms')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chemComp' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('chirality')
      if (value is not None):
        if (not (value in ['R', 'S', 'unknown'])):
          raise ApiError("""%s.checkValid: chirality:
           ccp.molecule.ChemComp.AtomChirality input is not in enumeration ['R', 'S', 'unknown']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: chirality:
           AtomChirality constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('elementSymbol')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: elementSymbol:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('nuclGroupType')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: nuclGroupType:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: nuclGroupType:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: nuclGroupType:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: nuclGroupType:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('shortVegaType')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: shortVegaType:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: shortVegaType:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: shortVegaType:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: shortVegaType:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('subType')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: subType:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterExchangeable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: waterExchangeable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('boundLinkEnds')
      for value in values:
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: boundLinkEnds:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('boundChemAtom')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: boundLinkEnds:
           non-reciprocal link boundLinkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: boundLinkEnds:
           Link boundLinkEnds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAngles')
      for value in values:
        if (not isinstance(value, ChemAngle)):
          raise ApiError("""%s.checkValid: chemAngles:
           value is not of class ccp.molecule.ChemComp.ChemAngle""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAngles:
           non-reciprocal link chemAngles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemAngles:
           Link chemAngles between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemAtomSet')
      if (value is not None):
        if (not isinstance(value, ChemAtomSet)):
          raise ApiError("""%s.checkValid: chemAtomSet:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemAtomSet:
           non-reciprocal link chemAtomSet from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemBonds')
      for value in values:
        if (not isinstance(value, ChemBond)):
          raise ApiError("""%s.checkValid: chemBonds:
           value is not of class ccp.molecule.ChemComp.ChemBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemBonds:
           non-reciprocal link chemBonds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemBonds:
           Link chemBonds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chemComp')
      if (not isinstance(value, ChemComp)):
        raise ApiError("""%s.checkValid: chemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('chemCompVars')
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemCompVars:
           non-reciprocal link chemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getChemElement()
      if (value is None):
        raise ApiError("""%s.checkValid: chemElement:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemElement import ChemElement as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemElement:
         value is not of class ccp.molecule.ChemElement.ChemElement""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemElement:
         Link chemElement between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('chemTorsions')
      for value in values:
        if (not isinstance(value, ChemTorsion)):
          raise ApiError("""%s.checkValid: chemTorsions:
           value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: chemTorsions:
           non-reciprocal link chemTorsions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chemTorsions:
           Link chemTorsions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('coreStereochemistries')
      for value in values:
        if (not isinstance(value, Stereochemistry)):
          raise ApiError("""%s.checkValid: coreStereochemistries:
           value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('coreAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: coreStereochemistries:
           non-reciprocal link coreStereochemistries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('remoteLinkEnds')
      for value in values:
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: remoteLinkEnds:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('remoteChemAtom')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: remoteLinkEnds:
           non-reciprocal link remoteLinkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: remoteLinkEnds:
           Link remoteLinkEnds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('stereochemistries')
      for value in values:
        if (not isinstance(value, Stereochemistry)):
          raise ApiError("""%s.checkValid: stereochemistries:
           value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('chemAtoms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: stereochemistries:
           non-reciprocal link stereochemistries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('chirality')
    value = dataDict.get('elementSymbol')
    if (value is None):
      raise ApiError("""%s.checkValid: elementSymbol:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (not (self.chemComp.findFirstChemAtomSet(name=value) is None)):
      raise ApiError("""%s.checkValid: name:
       name constraint ChemAtom_and_ChemAtomSet_share_namespace violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('nuclGroupType')
    value = dataDict.get('shortVegaType')
    value = dataDict.get('subType')
    if (value is None):
      raise ApiError("""%s.checkValid: subType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterExchangeable')
    if (value is None):
      raise ApiError("""%s.checkValid: waterExchangeable:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('boundLinkEnds')
    values = dataDict.get('chemAngles')
    value = dataDict.get('chemAtomSet')
    values = dataDict.get('chemBonds')
    value = dataDict.get('chemComp')
    if (value is None):
      raise ApiError("""%s.checkValid: chemComp:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('chemCompVars')
    values = dataDict.get('chemTorsions')
    values = dataDict.get('coreStereochemistries')
    values = dataDict.get('remoteLinkEnds')
    values = dataDict.get('stereochemistries')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllBoundLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemAtom.boundLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('boundLinkEnds')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('boundLinkEnds')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllChemAngles = AbstractChemAtom.findAllChemAngles

  findAllChemBonds = AbstractChemAtom.findAllChemBonds

  findAllChemCompVars = AbstractChemAtom.findAllChemCompVars

  findAllChemTorsions = AbstractChemAtom.findAllChemTorsions

  findAllCoreStereochemistries = AbstractChemAtom.findAllCoreStereochemistries
  
  def findAllRemoteLinkEnds(self, **conditions):
    """
    FindAll for ccp.molecule.ChemComp.ChemAtom.remoteLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('remoteLinkEnds')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('remoteLinkEnds')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllStereochemistries = AbstractChemAtom.findAllStereochemistries

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstBoundLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemAtom.boundLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('boundLinkEnds')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('boundLinkEnds')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstChemAngle = AbstractChemAtom.findFirstChemAngle

  findFirstChemBond = AbstractChemAtom.findFirstChemBond

  findFirstChemCompVar = AbstractChemAtom.findFirstChemCompVar

  findFirstChemTorsion = AbstractChemAtom.findFirstChemTorsion

  findFirstCoreStereochemistry = AbstractChemAtom.findFirstCoreStereochemistry
  
  def findFirstRemoteLinkEnd(self, **conditions):
    """
    FindFirst for ccp.molecule.ChemComp.ChemAtom.remoteLinkEnds
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('remoteLinkEnds')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('remoteLinkEnds')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('linkCode', 'access', 'boundChemAtom', 'boundLinkAtom', 'chemComp', 'remoteChemAtom', 'remoteLinkAtom',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstStereochemistry = AbstractChemAtom.findFirstStereochemistry
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.ChemAtom
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBoundLinkEnds(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.boundLinkEnds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('boundLinkEnds')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.ChemAtom
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemAtom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('chemComps').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.ChemComp')
        obj1 = obj0.__dict__.get('chemComps').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.ChemComp.ChemAtom'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('chemAtoms').get(objKey)
      if (isinstance(obj2, ChemAtom)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getChemAngles = AbstractChemAtom.getChemAngles
  
  def getChemAtomSet(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.chemAtomSet
    """
    dataDict = self.__dict__
    result = dataDict.get('chemAtomSet')
    return result

  getChemBonds = AbstractChemAtom.getChemBonds

  getChemComp = AbstractChemAtom.getChemComp

  getChemCompVars = AbstractChemAtom.getChemCompVars
  
  def getChemElement(self):
    """
    getter for derived link chemElement
    """
    dataDict = self.__dict__
    result = self.root.currentChemElementStore.findFirstChemElement(symbol=self.elementSymbol)
    return result

  getChemTorsions = AbstractChemAtom.getChemTorsions
  
  def getChirality(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.chirality
    """
    dataDict = self.__dict__
    result = dataDict.get('chirality')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCoreStereochemistries = AbstractChemAtom.getCoreStereochemistries
  
  def getElementSymbol(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.elementSymbol
    """
    dataDict = self.__dict__
    result = dataDict.get('elementSymbol')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractChemAtom.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = AbstractChemAtom.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = AbstractChemAtom.getName
  
  def getNuclGroupType(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.nuclGroupType
    """
    dataDict = self.__dict__
    result = dataDict.get('nuclGroupType')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractChemAtom.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRemoteLinkEnds(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.remoteLinkEnds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('remoteLinkEnds')
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getShortVegaType(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.shortVegaType
    """
    dataDict = self.__dict__
    result = dataDict.get('shortVegaType')
    return result

  getStereochemistries = AbstractChemAtom.getStereochemistries

  getSubType = AbstractChemAtom.getSubType

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWaterExchangeable(self):
    """
    Get for ccp.molecule.ChemComp.ChemAtom.waterExchangeable
    """
    dataDict = self.__dict__
    result = dataDict.get('waterExchangeable')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeChemCompVar = AbstractChemAtom.removeChemCompVar
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.ChemAtom
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBoundLinkEnds(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.boundLinkEnds
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setBoundLinkEnds:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, LinkEnd)):
        raise ApiError("""%s.setBoundLinkEnds:
         value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('boundLinkEnds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBoundLinkEnds:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBoundLinkEnds:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setBoundLinkEnds:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setBoundLinkEnds:
           locard boundChemAtom: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setBoundLinkEnds:
           Link boundLinkEnds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['boundChemAtom'] = self

    dataDict['boundLinkEnds'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBoundLinkEnds')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setChemAngles = AbstractChemAtom.setChemAngles
  
  def setChemAtomSet(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.chemAtomSet
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ChemAtomSet)):
        raise ApiError("""%s.setChemAtomSet:
         value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chemAtomSet')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChemAtomSet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChemAtomSet:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChemAtomSet:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setChemAtomSet:
           Link chemAtomSet between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('chemAtoms')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setChemAtomSet:
         Read link 'chemAtomSet' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('chemAtoms')
      newSelves.add(self)

    dataDict['chemAtomSet'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChemAtomSet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setChemBonds = AbstractChemAtom.setChemBonds

  setChemCompVars = AbstractChemAtom.setChemCompVars

  setChemTorsions = AbstractChemAtom.setChemTorsions
  
  def setChirality(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.chirality
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in ['R', 'S', 'unknown'])):
        raise ApiError("""%s.setChirality:
         ccp.molecule.ChemComp.AtomChirality input is not in enumeration ['R', 'S', 'unknown']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setChirality:
         AtomChirality constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chirality')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChirality:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChirality:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['chirality'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChirality')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCoreStereochemistries = AbstractChemAtom.setCoreStereochemistries
  
  def setElementSymbol(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.elementSymbol
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setElementSymbol:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('elementSymbol')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setElementSymbol:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setElementSymbol:
         cannot set elementSymbol, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setElementSymbol:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['elementSymbol'] = value

    # doNotifies

  setName = AbstractChemAtom.setName
  
  def setNuclGroupType(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.nuclGroupType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setNuclGroupType:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setNuclGroupType:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setNuclGroupType:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setNuclGroupType:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nuclGroupType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNuclGroupType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNuclGroupType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['nuclGroupType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNuclGroupType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRemoteLinkEnds(self, values):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.remoteLinkEnds
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRemoteLinkEnds:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, LinkEnd)):
        raise ApiError("""%s.setRemoteLinkEnds:
         value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('remoteLinkEnds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRemoteLinkEnds:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRemoteLinkEnds:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRemoteLinkEnds:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRemoteLinkEnds:
           Link remoteLinkEnds between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['remoteChemAtom'] = self

    dataDict['remoteLinkEnds'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRemoteLinkEnds')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setShortVegaType(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.shortVegaType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setShortVegaType:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setShortVegaType:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setShortVegaType:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setShortVegaType:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('shortVegaType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setShortVegaType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShortVegaType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['shortVegaType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setShortVegaType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setStereochemistries = AbstractChemAtom.setStereochemistries

  setSubType = AbstractChemAtom.setSubType
  
  def setWaterExchangeable(self, value):
    """
    Set for ccp.molecule.ChemComp.ChemAtom.waterExchangeable
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setWaterExchangeable:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterExchangeable')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterExchangeable:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterExchangeable:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterExchangeable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterExchangeable'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterExchangeable')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedBoundLinkEnds(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemAtom.boundLinkEnds
    """
    dataDict = self.__dict__
    ll = dataDict.get('boundLinkEnds')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedChemAngles = AbstractChemAtom.sortedChemAngles

  sortedChemBonds = AbstractChemAtom.sortedChemBonds

  sortedChemCompVars = AbstractChemAtom.sortedChemCompVars

  sortedChemTorsions = AbstractChemAtom.sortedChemTorsions

  sortedCoreStereochemistries = AbstractChemAtom.sortedCoreStereochemistries
  
  def sortedRemoteLinkEnds(self):
    """
    Sorted for ccp.molecule.ChemComp.ChemAtom.remoteLinkEnds
    """
    dataDict = self.__dict__
    ll = dataDict.get('remoteLinkEnds')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedStereochemistries = AbstractChemAtom.sortedStereochemistries

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  chirality = property(getChirality, setChirality, None,
  r"""Chirality of atom according to IUPAC R/S system. Note for some chiral 
  atoms chirality cannot be specified according to this system but only 
  using the Stereochemistry class. An example would be a chirality that 
  involves a LinkAtom susbstituent.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  elementSymbol = property(getElementSymbol, setElementSymbol, None,
  r"""Chemical symbol of the atom. Strictly speaking an enum .E.g. H, C, Mg, 
  Pt. Serves as key to derived link chemElement.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = AbstractChemAtom.name
  
  nuclGroupType = property(getNuclGroupType, setNuclGroupType, None,
  r"""String to determine Atom Group (for assignment purposes). Proposed 
  possibilities:
  'CH0','CH2','CH3','CHx','NH0','NH2','NH3', NHx, OH0m OH1, 
  OH2, .. etc. 'OTHER'.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  shortVegaType = property(getShortVegaType, setShortVegaType, None,
  r"""VegaType for atom, covering only the atom itself, e.g (100) or (451). 
  The full Vega Type is derived from the short Vegatype of the atom and 
  the atoms bound to it.
  """)

  subType = AbstractChemAtom.subType
  
  waterExchangeable = property(getWaterExchangeable, setWaterExchangeable, None,
  r"""Is this atom exchanging fast with solvent under aqueous conditions ( 
  i.e. on a timescale of a milisecond or less)? Most atoms are not. The 
  exceptions are e.g. protons bound to oxygen, or protons in  amine groups 
  or NH2 in guanidinium groups.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  boundLinkEnds = property(getBoundLinkEnds, setBoundLinkEnds, None,
  r"""linkEnds with an out-of-ChemComp bond parting directly from ChemAtom.
  """)

  chemAngles = AbstractChemAtom.chemAngles
  
  chemAtomSet = property(getChemAtomSet, setChemAtomSet, None,
  r"""ChemAtomSet that ChemAtom is contained in.
  """)

  chemBonds = AbstractChemAtom.chemBonds

  chemComp = AbstractChemAtom.chemComp

  chemCompVars = AbstractChemAtom.chemCompVars
  
  chemElement = property(getChemElement, None, None,
  r"""ChemElement that corresponds to ChemAtom
  """)

  chemTorsions = AbstractChemAtom.chemTorsions

  coreStereochemistries = AbstractChemAtom.coreStereochemistries

  parent = AbstractChemAtom.parent
  
  remoteLinkEnds = property(getRemoteLinkEnds, setRemoteLinkEnds, None,
  r"""LinkEnds where ChemAtom participates as remote ChemAtom
  """)

  root = memops.api.Implementation.MemopsObject.root

  stereochemistries = AbstractChemAtom.stereochemistries

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class NonStdChemComp(ChemComp):
  r"""ChemComp that is not a standard ChemComp, but may or may not be derived 
from one.
  """
  #   from data model element ccp.molecule.ChemComp.NonStdChemComp revision ?
  _metaclass = metaPackage.getElement('NonStdChemComp')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'baseGlycoCtCode', 'beilsteinCode', 'casRegCode', 'ccpCode', 'className', 'code1Letter', 'code3Letter', 'commonNames', 'createdBy', 'details', 'fieldNames', 'guid', 'hasStdChirality', 'inConstructor', 'isDeleted', 'isLinearPolymer', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'keywords', 'lastUnlockedBy', 'merckCode', 'metaclass', 'molType', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'sigmaAldrichCode', 'stdChemCompCode', 'access', 'activeAccess', 'activeRepositories', 'chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemCompVars', 'chemTorsions', 'linkEnds', 'memopsRoot', 'namingSystems', 'packageLocator', 'parent', 'residueTypeProbs', 'root', 'stdChemComp', 'stereochemistries', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.NonStdChemComp
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.molecule.ChemComp')

      dataDict['applicationData'] = list()
      dataDict['baseGlycoCtCode'] = None
      dataDict['beilsteinCode'] = None
      dataDict['casRegCode'] = None
      dataDict['ccpCode'] = None
      dataDict['code3Letter'] = None
      dataDict['commonNames'] = list()
      dataDict['createdBy'] = None
      dataDict['details'] = None
      dataDict['guid'] = None
      dataDict['hasStdChirality'] = None
      dataDict['isModifiable'] = True
      dataDict['keywords'] = list()
      dataDict['lastUnlockedBy'] = None
      dataDict['merckCode'] = None
      dataDict['molType'] = None
      dataDict['name'] = None
      dataDict['sigmaAldrichCode'] = None
      dataDict['stdChemCompCode'] = None
      dataDict['access'] = None
      dataDict['chemAngles'] = {}
      dataDict['chemAtomSets'] = {}
      dataDict['chemAtoms'] = {}
      dataDict['chemBonds'] = {}
      dataDict['chemCompVars'] = {}
      dataDict['chemTorsions'] = {}
      dataDict['linkEnds'] = {}
      dataDict['namingSystems'] = {}
      dataDict['residueTypeProbs'] = set()
      dataDict['stereochemistries'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.NonStdChemComp.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['stereochemistries'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemComps')
        ll = list()
        objKey = dataDict.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molType', 'ccpCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentChemComp') is None)):
        root.__dict__['currentChemComp'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.NonStdChemComp:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chemAngles = dataDict.get('chemAngles').values()
    for chemAngle in chemAngles:
      if (not (chemAngle in objsToBeDeleted)):
        objsToBeDeleted.add(chemAngle)
        objsToBeChecked.append(chemAngle)

    chemAtomSets = dataDict.get('chemAtomSets').values()
    for chemAtomSet in chemAtomSets:
      if (not (chemAtomSet in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtomSet)
        objsToBeChecked.append(chemAtomSet)

    chemAtoms = dataDict.get('chemAtoms').values()
    for chemAtom in chemAtoms:
      if (not (chemAtom in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtom)
        objsToBeChecked.append(chemAtom)

    chemBonds = dataDict.get('chemBonds').values()
    for chemBond in chemBonds:
      if (not (chemBond in objsToBeDeleted)):
        objsToBeDeleted.add(chemBond)
        objsToBeChecked.append(chemBond)

    chemCompVars = dataDict.get('chemCompVars').values()
    for chemCompVar in chemCompVars:
      if (not (chemCompVar in objsToBeDeleted)):
        objsToBeDeleted.add(chemCompVar)
        objsToBeChecked.append(chemCompVar)

    chemTorsions = dataDict.get('chemTorsions').values()
    for chemTorsion in chemTorsions:
      if (not (chemTorsion in objsToBeDeleted)):
        objsToBeDeleted.add(chemTorsion)
        objsToBeChecked.append(chemTorsion)

    linkEnds = dataDict.get('linkEnds').values()
    for linkEnd in linkEnds:
      if (not (linkEnd in objsToBeDeleted)):
        objsToBeDeleted.add(linkEnd)
        objsToBeChecked.append(linkEnd)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    namingSystems = dataDict.get('namingSystems').values()
    for namingSystem in namingSystems:
      if (not (namingSystem in objsToBeDeleted)):
        objsToBeDeleted.add(namingSystem)
        objsToBeChecked.append(namingSystem)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    residueTypeProbs = dataDict.get('residueTypeProbs')
    for residueTypeProb in residueTypeProbs:
      if (not (residueTypeProb in objsToBeDeleted)):
        objsToBeDeleted.add(residueTypeProb)
        objsToBeChecked.append(residueTypeProb)

    for residueTypeProb in residueTypeProbs:
      topObject = residueTypeProb.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    stereochemistries = dataDict.get('stereochemistries').values()
    for stereochemistry in stereochemistries:
      if (not (stereochemistry in objsToBeDeleted)):
        objsToBeDeleted.add(stereochemistry)
        objsToBeChecked.append(stereochemistry)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.NonStdChemComp:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentChemComp')):
      memopsRoot.__dict__['currentChemComp'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('chemComps')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['chemAngles'] = {}
    dataDict['chemAtomSets'] = {}
    dataDict['chemAtoms'] = {}
    dataDict['chemBonds'] = {}
    dataDict['chemCompVars'] = {}
    dataDict['chemTorsions'] = {}
    dataDict['linkEnds'] = {}
    dataDict['namingSystems'] = {}
    dataDict['stereochemistries'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addCommonName = ChemComp.addCommonName

  addKeyword = ChemComp.addKeyword

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.NonStdChemComp
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('chemAngles').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemAtomSets').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemAtoms').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemBonds').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemCompVars').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemTorsions').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('linkEnds').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('namingSystems').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('stereochemistries').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.NonStdChemComp
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('chemComps')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('baseGlycoCtCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: baseGlycoCtCode:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('beilsteinCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: beilsteinCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: beilsteinCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: beilsteinCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: beilsteinCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casRegCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casRegCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: casRegCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casRegCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: casRegCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ccpCode')
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getCode1Letter()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code1Letter:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code1Letter:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code1Letter:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code1Letter:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code3Letter')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code3Letter:
           ccp.molecule.ChemComp.ThreeLetterCode input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 3):
          raise ApiError("""%s.checkValid: code3Letter:
           ccp.molecule.ChemComp.ThreeLetterCode maximum length is 3 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code3Letter:
           ccp.molecule.ChemComp.ThreeLetterCode: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code3Letter:
           ThreeLetterCode constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('commonNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('hasStdChirality')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: hasStdChirality:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getIsLinearPolymer()
      if (value is None):
        raise ApiError("""%s.checkValid: isLinearPolymer:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isLinearPolymer:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('merckCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: merckCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: merckCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: merckCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: merckCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sigmaAldrichCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('stdChemCompCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: stdChemCompCode:
           memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: stdChemCompCode:
           memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: stdChemCompCode:
           memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: stdChemCompCode:
           LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAngles').values()
      for value in values:
        if (not isinstance(value, ChemAngle)):
          raise ApiError("""%s.checkValid: chemAngles:
           value is not of class ccp.molecule.ChemComp.ChemAngle""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAngles:
           non-reciprocal link chemAngles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAtomSets').values()
      for value in values:
        if (not isinstance(value, ChemAtomSet)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           non-reciprocal link chemAtomSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAtoms').values()
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemBonds').values()
      for value in values:
        if (not isinstance(value, ChemBond)):
          raise ApiError("""%s.checkValid: chemBonds:
           value is not of class ccp.molecule.ChemComp.ChemBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemBonds:
           non-reciprocal link chemBonds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemCompVars').values()
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompVars:
           non-reciprocal link chemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemTorsions').values()
      for value in values:
        if (not isinstance(value, ChemTorsion)):
          raise ApiError("""%s.checkValid: chemTorsions:
           value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemTorsions:
           non-reciprocal link chemTorsions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('linkEnds').values()
      for value in values:
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: linkEnds:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: linkEnds:
           non-reciprocal link linkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('namingSystems').values()
      for value in values:
        if (not isinstance(value, NamingSystem)):
          raise ApiError("""%s.checkValid: namingSystems:
           value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: namingSystems:
           non-reciprocal link namingSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('residueTypeProbs')
      for value in values:
        from ccp.api.nmr.Nmr import ResidueTypeProb as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: residueTypeProbs:
           value is not of class ccp.nmr.Nmr.ResidueTypeProb""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('possibility')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residueTypeProbs:
           non-reciprocal link residueTypeProbs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: residueTypeProbs:
           Link residueTypeProbs between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getStdChemComp()
      if (value is not None):
        if (not isinstance(value, StdChemComp)):
          raise ApiError("""%s.checkValid: stdChemComp:
           value is not of class ccp.molecule.ChemComp.StdChemComp""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: stdChemComp:
           Link stdChemComp between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('stereochemistries').values()
      for value in values:
        if (not isinstance(value, Stereochemistry)):
          raise ApiError("""%s.checkValid: stereochemistries:
           value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: stereochemistries:
           non-reciprocal link stereochemistries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      ll = self.stereochemistries
      isValid = (len(ll) == len(set(frozenset(x.chemAtoms) for x in ll)))
      if (not (isValid)):
        raise ApiError("""%s.checkValid:
         constraint Each_set_of_ChemAtoms_may_have_only_one_Stereochemistry violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (self.ccpCode != self.stdChemCompCode)):
        raise ApiError("""%s.checkValid:
         constraint ccpCode_ne_stdChemCompCode violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (self.isLinearPolymer or not self.chemCompVars or self.molType not in ('protein', 'DNA', 'RNA'))):
        raise ApiError("""%s.checkValid:
         constraint protein_DNA_RNA_are_linear_polymers violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('baseGlycoCtCode')
      value = dataDict.get('beilsteinCode')
      value = dataDict.get('casRegCode')
      value = dataDict.get('code3Letter')
      values = dataDict.get('commonNames')
      value = dataDict.get('details')
      value = dataDict.get('hasStdChirality')
      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('keywords')
      value = dataDict.get('merckCode')
      value = dataDict.get('name')
      value = dataDict.get('sigmaAldrichCode')
      value = dataDict.get('stdChemCompCode')
      # check roles
      value = dataDict.get('access')
      values = dataDict.get('chemAngles').values()
      values = dataDict.get('chemAtomSets').values()
      values = dataDict.get('chemAtoms').values()
      values = dataDict.get('chemBonds').values()
      values = dataDict.get('chemCompVars').values()
      values = dataDict.get('chemTorsions').values()
      values = dataDict.get('linkEnds').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('namingSystems').values()
      values = dataDict.get('residueTypeProbs')
      values = dataDict.get('stereochemistries').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('molType')
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('ccpCode')
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllChemAngles = ChemComp.findAllChemAngles

  findAllChemAtomSets = ChemComp.findAllChemAtomSets

  findAllChemAtoms = ChemComp.findAllChemAtoms

  findAllChemBonds = ChemComp.findAllChemBonds

  findAllChemCompVars = ChemComp.findAllChemCompVars

  findAllChemTorsions = ChemComp.findAllChemTorsions

  findAllLinkEnds = ChemComp.findAllLinkEnds

  findAllNamingSystems = ChemComp.findAllNamingSystems

  findAllResidueTypeProbs = ChemComp.findAllResidueTypeProbs

  findAllStereochemistries = ChemComp.findAllStereochemistries

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstChemAngle = ChemComp.findFirstChemAngle

  findFirstChemAtom = ChemComp.findFirstChemAtom

  findFirstChemAtomSet = ChemComp.findFirstChemAtomSet

  findFirstChemBond = ChemComp.findFirstChemBond

  findFirstChemCompVar = ChemComp.findFirstChemCompVar

  findFirstChemTorsion = ChemComp.findFirstChemTorsion

  findFirstLinkEnd = ChemComp.findFirstLinkEnd

  findFirstNamingSystem = ChemComp.findFirstNamingSystem

  findFirstResidueTypeProb = ChemComp.findFirstResidueTypeProb

  findFirstStereochemistry = ChemComp.findFirstStereochemistry
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.NonStdChemComp
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getBaseGlycoCtCode = ChemComp.getBaseGlycoCtCode

  getBeilsteinCode = ChemComp.getBeilsteinCode
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.NonStdChemComp
    """

    result = None
    if (2 != len(fullKey)):
      raise ApiError("""'ccp.molecule.ChemComp.NonStdChemComp'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    ll = list()
    objKey = fullKey[0]
    ll.append(objKey)
    if (objKey is not None):
      objKey = fullKey[1]
      ll.append(objKey)
      if (objKey is not None):
        objKey = tuple(ll)

    obj1 = startObj.__dict__.get('chemComps').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.molecule.ChemComp')
      obj1 = startObj.__dict__.get('chemComps').get(objKey)

    if (isinstance(obj1, NonStdChemComp)):
      result = obj1

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasRegCode = ChemComp.getCasRegCode

  getCcpCode = ChemComp.getCcpCode

  getChemAngles = ChemComp.getChemAngles

  getChemAtomSets = ChemComp.getChemAtomSets

  getChemAtoms = ChemComp.getChemAtoms

  getChemBonds = ChemComp.getChemBonds

  getChemCompVars = ChemComp.getChemCompVars

  getChemTorsions = ChemComp.getChemTorsions

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode1Letter(self):
    """
    getter for derived attribute code1Letter
    """
    dataDict = self.__dict__
    cc = self.stdChemComp
    if cc is None:
      result = None
    else:
      result = cc.code1Letter
    return result

  getCode3Letter = ChemComp.getCode3Letter

  getCommonNames = ChemComp.getCommonNames

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getDetails = ChemComp.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = ChemComp.getFullKey

  getGuid = memops.api.Implementation.TopObject.getGuid

  getHasStdChirality = ChemComp.getHasStdChirality

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLinearPolymer = ChemComp.getIsLinearPolymer

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getKeywords = ChemComp.getKeywords

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy

  getLinkEnds = ChemComp.getLinkEnds

  getLocalKey = ChemComp.getLocalKey

  getMemopsRoot = ChemComp.getMemopsRoot

  getMerckCode = ChemComp.getMerckCode

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMolType = ChemComp.getMolType

  getName = ChemComp.getName

  getNamingSystems = ChemComp.getNamingSystems

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = ChemComp.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getResidueTypeProbs = ChemComp.getResidueTypeProbs

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSigmaAldrichCode = ChemComp.getSigmaAldrichCode

  getStdChemComp = ChemComp.getStdChemComp
  
  def getStdChemCompCode(self):
    """
    Get for ccp.molecule.ChemComp.NonStdChemComp.stdChemCompCode
    """
    dataDict = self.__dict__
    result = dataDict.get('stdChemCompCode')
    return result

  getStereochemistries = ChemComp.getStereochemistries

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom

  newChemAngle = ChemComp.newChemAngle

  newChemAtom = ChemComp.newChemAtom

  newChemAtomSet = ChemComp.newChemAtomSet

  newChemBond = ChemComp.newChemBond

  newChemCompVar = ChemComp.newChemCompVar

  newChemTorsion = ChemComp.newChemTorsion

  newLinkAtom = ChemComp.newLinkAtom

  newLinkEnd = ChemComp.newLinkEnd

  newNamingSystem = ChemComp.newNamingSystem

  newStereochemistry = ChemComp.newStereochemistry

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeCommonName = ChemComp.removeCommonName

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  removeKeyword = ChemComp.removeKeyword

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.NonStdChemComp
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setBaseGlycoCtCode = ChemComp.setBaseGlycoCtCode

  setBeilsteinCode = ChemComp.setBeilsteinCode

  setCasRegCode = ChemComp.setCasRegCode

  setCcpCode = ChemComp.setCcpCode

  setCode3Letter = ChemComp.setCode3Letter

  setCommonNames = ChemComp.setCommonNames

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setDetails = ChemComp.setDetails

  setGuid = memops.api.Implementation.TopObject.setGuid

  setHasStdChirality = ChemComp.setHasStdChirality

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setKeywords = ChemComp.setKeywords

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy

  setMerckCode = ChemComp.setMerckCode

  setMolType = ChemComp.setMolType

  setName = ChemComp.setName

  setResidueTypeProbs = ChemComp.setResidueTypeProbs

  setSigmaAldrichCode = ChemComp.setSigmaAldrichCode
  
  def setStdChemCompCode(self, value):
    """
    Set for ccp.molecule.ChemComp.NonStdChemComp.stdChemCompCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStdChemCompCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setStdChemCompCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setStdChemCompCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setStdChemCompCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('stdChemCompCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStdChemCompCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStdChemCompCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stdChemCompCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStdChemCompCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  sortedChemAngles = ChemComp.sortedChemAngles

  sortedChemAtomSets = ChemComp.sortedChemAtomSets

  sortedChemAtoms = ChemComp.sortedChemAtoms

  sortedChemBonds = ChemComp.sortedChemBonds

  sortedChemCompVars = ChemComp.sortedChemCompVars

  sortedChemTorsions = ChemComp.sortedChemTorsions

  sortedLinkEnds = ChemComp.sortedLinkEnds

  sortedNamingSystems = ChemComp.sortedNamingSystems

  sortedResidueTypeProbs = ChemComp.sortedResidueTypeProbs

  sortedStereochemistries = ChemComp.sortedStereochemistries

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  baseGlycoCtCode = ChemComp.baseGlycoCtCode

  beilsteinCode = ChemComp.beilsteinCode

  casRegCode = ChemComp.casRegCode

  ccpCode = ChemComp.ccpCode

  className = memops.api.Implementation.ComplexDataType.className
  
  code1Letter = property(getCode1Letter, None, None,
  r"""One letter code of corresponding stdChemComp, if any
  """)

  code3Letter = ChemComp.code3Letter

  commonNames = ChemComp.commonNames

  createdBy = memops.api.Implementation.TopObject.createdBy

  details = ChemComp.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  hasStdChirality = ChemComp.hasStdChirality

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLinearPolymer = ChemComp.isLinearPolymer

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  keywords = ChemComp.keywords

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  merckCode = ChemComp.merckCode

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  molType = ChemComp.molType

  name = ChemComp.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  sigmaAldrichCode = ChemComp.sigmaAldrichCode
  
  stdChemCompCode = property(getStdChemCompCode, setStdChemCompCode, None,
  r"""
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories

  chemAngles = ChemComp.chemAngles

  chemAtomSets = ChemComp.chemAtomSets

  chemAtoms = ChemComp.chemAtoms

  chemBonds = ChemComp.chemBonds

  chemCompVars = ChemComp.chemCompVars

  chemTorsions = ChemComp.chemTorsions

  linkEnds = ChemComp.linkEnds

  memopsRoot = ChemComp.memopsRoot

  namingSystems = ChemComp.namingSystems

  packageLocator = memops.api.Implementation.TopObject.packageLocator

  parent = ChemComp.parent

  residueTypeProbs = ChemComp.residueTypeProbs

  root = memops.api.Implementation.MemopsObject.root

  stdChemComp = ChemComp.stdChemComp

  stereochemistries = ChemComp.stereochemistries

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class StdChemComp(ChemComp):
  r"""Standard ChemComp, or ChemComp that has a one-letter Code (unique within 
the molType). In practice one of the twenty standard amino acids or the 
four standrad DNA or RNA bases
  """
  #   from data model element ccp.molecule.ChemComp.StdChemComp revision ?
  _metaclass = metaPackage.getElement('StdChemComp')
  _packageName = 'ccp.molecule.ChemComp'
  _packageShortName = 'CHEM'
  _fieldNames = ('applicationData', 'baseGlycoCtCode', 'beilsteinCode', 'casRegCode', 'ccpCode', 'className', 'code1Letter', 'code3Letter', 'commonNames', 'createdBy', 'details', 'fieldNames', 'guid', 'hasStdChirality', 'inConstructor', 'isDeleted', 'isLinearPolymer', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'keywords', 'lastUnlockedBy', 'merckCode', 'metaclass', 'molType', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'sigmaAldrichCode', 'stdChemCompCode', 'access', 'activeAccess', 'activeRepositories', 'chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemCompVars', 'chemTorsions', 'linkEnds', 'memopsRoot', 'namingSystems', 'packageLocator', 'parent', 'residueTypeProbs', 'root', 'stdChemComp', 'stereochemistries', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.ChemComp.StdChemComp
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.molecule.ChemComp')

      dataDict['applicationData'] = list()
      dataDict['baseGlycoCtCode'] = None
      dataDict['beilsteinCode'] = None
      dataDict['casRegCode'] = None
      dataDict['ccpCode'] = None
      dataDict['code1Letter'] = None
      dataDict['code3Letter'] = None
      dataDict['commonNames'] = list()
      dataDict['createdBy'] = None
      dataDict['details'] = None
      dataDict['guid'] = None
      dataDict['hasStdChirality'] = None
      dataDict['isModifiable'] = True
      dataDict['keywords'] = list()
      dataDict['lastUnlockedBy'] = None
      dataDict['merckCode'] = None
      dataDict['molType'] = None
      dataDict['name'] = None
      dataDict['sigmaAldrichCode'] = None
      dataDict['stdChemCompCode'] = None
      dataDict['access'] = None
      dataDict['chemAngles'] = {}
      dataDict['chemAtomSets'] = {}
      dataDict['chemAtoms'] = {}
      dataDict['chemBonds'] = {}
      dataDict['chemCompVars'] = {}
      dataDict['chemTorsions'] = {}
      dataDict['linkEnds'] = {}
      dataDict['namingSystems'] = {}
      dataDict['residueTypeProbs'] = set()
      dataDict['stereochemistries'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.ChemComp.StdChemComp.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['stereochemistries'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('chemComps')
        ll = list()
        objKey = dataDict.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molType', 'ccpCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentChemComp') is None)):
        root.__dict__['currentChemComp'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.ChemComp.StdChemComp:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chemAngles = dataDict.get('chemAngles').values()
    for chemAngle in chemAngles:
      if (not (chemAngle in objsToBeDeleted)):
        objsToBeDeleted.add(chemAngle)
        objsToBeChecked.append(chemAngle)

    chemAtomSets = dataDict.get('chemAtomSets').values()
    for chemAtomSet in chemAtomSets:
      if (not (chemAtomSet in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtomSet)
        objsToBeChecked.append(chemAtomSet)

    chemAtoms = dataDict.get('chemAtoms').values()
    for chemAtom in chemAtoms:
      if (not (chemAtom in objsToBeDeleted)):
        objsToBeDeleted.add(chemAtom)
        objsToBeChecked.append(chemAtom)

    chemBonds = dataDict.get('chemBonds').values()
    for chemBond in chemBonds:
      if (not (chemBond in objsToBeDeleted)):
        objsToBeDeleted.add(chemBond)
        objsToBeChecked.append(chemBond)

    chemCompVars = dataDict.get('chemCompVars').values()
    for chemCompVar in chemCompVars:
      if (not (chemCompVar in objsToBeDeleted)):
        objsToBeDeleted.add(chemCompVar)
        objsToBeChecked.append(chemCompVar)

    chemTorsions = dataDict.get('chemTorsions').values()
    for chemTorsion in chemTorsions:
      if (not (chemTorsion in objsToBeDeleted)):
        objsToBeDeleted.add(chemTorsion)
        objsToBeChecked.append(chemTorsion)

    linkEnds = dataDict.get('linkEnds').values()
    for linkEnd in linkEnds:
      if (not (linkEnd in objsToBeDeleted)):
        objsToBeDeleted.add(linkEnd)
        objsToBeChecked.append(linkEnd)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    namingSystems = dataDict.get('namingSystems').values()
    for namingSystem in namingSystems:
      if (not (namingSystem in objsToBeDeleted)):
        objsToBeDeleted.add(namingSystem)
        objsToBeChecked.append(namingSystem)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    residueTypeProbs = dataDict.get('residueTypeProbs')
    for residueTypeProb in residueTypeProbs:
      if (not (residueTypeProb in objsToBeDeleted)):
        objsToBeDeleted.add(residueTypeProb)
        objsToBeChecked.append(residueTypeProb)

    for residueTypeProb in residueTypeProbs:
      topObject = residueTypeProb.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    stereochemistries = dataDict.get('stereochemistries').values()
    for stereochemistry in stereochemistries:
      if (not (stereochemistry in objsToBeDeleted)):
        objsToBeDeleted.add(stereochemistry)
        objsToBeChecked.append(stereochemistry)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.ChemComp.StdChemComp:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentChemComp')):
      memopsRoot.__dict__['currentChemComp'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('chemComps')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['chemAngles'] = {}
    dataDict['chemAtomSets'] = {}
    dataDict['chemAtoms'] = {}
    dataDict['chemBonds'] = {}
    dataDict['chemCompVars'] = {}
    dataDict['chemTorsions'] = {}
    dataDict['linkEnds'] = {}
    dataDict['namingSystems'] = {}
    dataDict['stereochemistries'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addCommonName = ChemComp.addCommonName

  addKeyword = ChemComp.addKeyword

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.ChemComp.StdChemComp
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('chemAngles').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemAtomSets').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemAtoms').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemBonds').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemCompVars').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chemTorsions').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('linkEnds').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('namingSystems').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('stereochemistries').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.ChemComp.StdChemComp
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('chemComps')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('baseGlycoCtCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: baseGlycoCtCode:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('beilsteinCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: beilsteinCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: beilsteinCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: beilsteinCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: beilsteinCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casRegCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casRegCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: casRegCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casRegCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: casRegCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ccpCode')
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('code1Letter')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code1Letter:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: code1Letter:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code1Letter:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: code1Letter:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('code3Letter')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code3Letter:
           ccp.molecule.ChemComp.ThreeLetterCode input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 3):
          raise ApiError("""%s.checkValid: code3Letter:
           ccp.molecule.ChemComp.ThreeLetterCode maximum length is 3 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code3Letter:
           ccp.molecule.ChemComp.ThreeLetterCode: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code3Letter:
           ThreeLetterCode constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('commonNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: commonNames:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('hasStdChirality')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: hasStdChirality:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getIsLinearPolymer()
      if (value is None):
        raise ApiError("""%s.checkValid: isLinearPolymer:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isLinearPolymer:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('keywords')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: keywords:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: keywords:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('merckCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: merckCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: merckCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: merckCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: merckCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sigmaAldrichCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: sigmaAldrichCode:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('stdChemCompCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: stdChemCompCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: stdChemCompCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: stdChemCompCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: stdChemCompCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chemAngles').values()
      for value in values:
        if (not isinstance(value, ChemAngle)):
          raise ApiError("""%s.checkValid: chemAngles:
           value is not of class ccp.molecule.ChemComp.ChemAngle""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAngles:
           non-reciprocal link chemAngles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAtomSets').values()
      for value in values:
        if (not isinstance(value, ChemAtomSet)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           value is not of class ccp.molecule.ChemComp.ChemAtomSet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtomSets:
           non-reciprocal link chemAtomSets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemAtoms').values()
      for value in values:
        if (not isinstance(value, AbstractChemAtom)):
          raise ApiError("""%s.checkValid: chemAtoms:
           value is not of class ccp.molecule.ChemComp.AbstractChemAtom""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemAtoms:
           non-reciprocal link chemAtoms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemBonds').values()
      for value in values:
        if (not isinstance(value, ChemBond)):
          raise ApiError("""%s.checkValid: chemBonds:
           value is not of class ccp.molecule.ChemComp.ChemBond""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemBonds:
           non-reciprocal link chemBonds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemCompVars').values()
      for value in values:
        if (not isinstance(value, ChemCompVar)):
          raise ApiError("""%s.checkValid: chemCompVars:
           value is not of class ccp.molecule.ChemComp.ChemCompVar""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompVars:
           non-reciprocal link chemCompVars from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('chemTorsions').values()
      for value in values:
        if (not isinstance(value, ChemTorsion)):
          raise ApiError("""%s.checkValid: chemTorsions:
           value is not of class ccp.molecule.ChemComp.ChemTorsion""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemTorsions:
           non-reciprocal link chemTorsions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('linkEnds').values()
      for value in values:
        if (not isinstance(value, LinkEnd)):
          raise ApiError("""%s.checkValid: linkEnds:
           value is not of class ccp.molecule.ChemComp.LinkEnd""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: linkEnds:
           non-reciprocal link linkEnds from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('namingSystems').values()
      for value in values:
        if (not isinstance(value, NamingSystem)):
          raise ApiError("""%s.checkValid: namingSystems:
           value is not of class ccp.molecule.ChemComp.NamingSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: namingSystems:
           non-reciprocal link namingSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('residueTypeProbs')
      for value in values:
        from ccp.api.nmr.Nmr import ResidueTypeProb as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: residueTypeProbs:
           value is not of class ccp.nmr.Nmr.ResidueTypeProb""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('possibility')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residueTypeProbs:
           non-reciprocal link residueTypeProbs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: residueTypeProbs:
           Link residueTypeProbs between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getStdChemComp()
      if (value is not None):
        if (not isinstance(value, StdChemComp)):
          raise ApiError("""%s.checkValid: stdChemComp:
           value is not of class ccp.molecule.ChemComp.StdChemComp""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: stdChemComp:
           Link stdChemComp between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('stereochemistries').values()
      for value in values:
        if (not isinstance(value, Stereochemistry)):
          raise ApiError("""%s.checkValid: stereochemistries:
           value is not of class ccp.molecule.ChemComp.Stereochemistry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chemComp')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: stereochemistries:
           non-reciprocal link stereochemistries from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      ll = self.stereochemistries
      isValid = (len(ll) == len(set(frozenset(x.chemAtoms) for x in ll)))
      if (not (isValid)):
        raise ApiError("""%s.checkValid:
         constraint Each_set_of_ChemAtoms_may_have_only_one_Stereochemistry violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (self.isLinearPolymer or not self.chemCompVars or self.molType not in ('protein', 'DNA', 'RNA'))):
        raise ApiError("""%s.checkValid:
         constraint protein_DNA_RNA_are_linear_polymers violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (self.stdChemCompCode == self.ccpCode)):
        raise ApiError("""%s.checkValid:
         constraint stdChemCompCode_eq_ccpCode violated""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('baseGlycoCtCode')
      value = dataDict.get('beilsteinCode')
      value = dataDict.get('casRegCode')
      value = dataDict.get('code1Letter')
      if (value is None):
        raise ApiError("""%s.checkValid: code1Letter:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not (value is None or len(value) == 1)):
        raise ApiError("""%s.checkValid: code1Letter:
         code1Letter constraint length_is_one violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('code3Letter')
      values = dataDict.get('commonNames')
      value = dataDict.get('details')
      value = dataDict.get('hasStdChirality')
      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('keywords')
      value = dataDict.get('merckCode')
      value = dataDict.get('name')
      value = dataDict.get('sigmaAldrichCode')
      value = dataDict.get('stdChemCompCode')
      if (value is None):
        raise ApiError("""%s.checkValid: stdChemCompCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('chemAngles').values()
      values = dataDict.get('chemAtomSets').values()
      values = dataDict.get('chemAtoms').values()
      values = dataDict.get('chemBonds').values()
      values = dataDict.get('chemCompVars').values()
      values = dataDict.get('chemTorsions').values()
      values = dataDict.get('linkEnds').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('namingSystems').values()
      values = dataDict.get('residueTypeProbs')
      values = dataDict.get('stereochemistries').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('molType')
      if (value is None):
        raise ApiError("""%s.checkValid: molType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('ccpCode')
      if (value is None):
        raise ApiError("""%s.checkValid: ccpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllChemAngles = ChemComp.findAllChemAngles

  findAllChemAtomSets = ChemComp.findAllChemAtomSets

  findAllChemAtoms = ChemComp.findAllChemAtoms

  findAllChemBonds = ChemComp.findAllChemBonds

  findAllChemCompVars = ChemComp.findAllChemCompVars

  findAllChemTorsions = ChemComp.findAllChemTorsions

  findAllLinkEnds = ChemComp.findAllLinkEnds

  findAllNamingSystems = ChemComp.findAllNamingSystems

  findAllResidueTypeProbs = ChemComp.findAllResidueTypeProbs

  findAllStereochemistries = ChemComp.findAllStereochemistries

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstChemAngle = ChemComp.findFirstChemAngle

  findFirstChemAtom = ChemComp.findFirstChemAtom

  findFirstChemAtomSet = ChemComp.findFirstChemAtomSet

  findFirstChemBond = ChemComp.findFirstChemBond

  findFirstChemCompVar = ChemComp.findFirstChemCompVar

  findFirstChemTorsion = ChemComp.findFirstChemTorsion

  findFirstLinkEnd = ChemComp.findFirstLinkEnd

  findFirstNamingSystem = ChemComp.findFirstNamingSystem

  findFirstResidueTypeProb = ChemComp.findFirstResidueTypeProb

  findFirstStereochemistry = ChemComp.findFirstStereochemistry
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.ChemComp.StdChemComp
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getBaseGlycoCtCode = ChemComp.getBaseGlycoCtCode

  getBeilsteinCode = ChemComp.getBeilsteinCode
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.ChemComp.StdChemComp
    """

    result = None
    if (2 != len(fullKey)):
      raise ApiError("""'ccp.molecule.ChemComp.StdChemComp'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    ll = list()
    objKey = fullKey[0]
    ll.append(objKey)
    if (objKey is not None):
      objKey = fullKey[1]
      ll.append(objKey)
      if (objKey is not None):
        objKey = tuple(ll)

    obj1 = startObj.__dict__.get('chemComps').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.molecule.ChemComp')
      obj1 = startObj.__dict__.get('chemComps').get(objKey)

    if (isinstance(obj1, StdChemComp)):
      result = obj1

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasRegCode = ChemComp.getCasRegCode

  getCcpCode = ChemComp.getCcpCode

  getChemAngles = ChemComp.getChemAngles

  getChemAtomSets = ChemComp.getChemAtomSets

  getChemAtoms = ChemComp.getChemAtoms

  getChemBonds = ChemComp.getChemBonds

  getChemCompVars = ChemComp.getChemCompVars

  getChemTorsions = ChemComp.getChemTorsions

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode1Letter(self):
    """
    getter for attribute code1Letter.
    """
    dataDict = self.__dict__
    # NB must be done by direct access
    result = dataDict['code1Letter']
    return result

  getCode3Letter = ChemComp.getCode3Letter

  getCommonNames = ChemComp.getCommonNames

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getDetails = ChemComp.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = ChemComp.getFullKey

  getGuid = memops.api.Implementation.TopObject.getGuid

  getHasStdChirality = ChemComp.getHasStdChirality

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLinearPolymer = ChemComp.getIsLinearPolymer

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getKeywords = ChemComp.getKeywords

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy

  getLinkEnds = ChemComp.getLinkEnds

  getLocalKey = ChemComp.getLocalKey

  getMemopsRoot = ChemComp.getMemopsRoot

  getMerckCode = ChemComp.getMerckCode

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMolType = ChemComp.getMolType

  getName = ChemComp.getName

  getNamingSystems = ChemComp.getNamingSystems

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = ChemComp.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getResidueTypeProbs = ChemComp.getResidueTypeProbs

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSigmaAldrichCode = ChemComp.getSigmaAldrichCode

  getStdChemComp = ChemComp.getStdChemComp
  
  def getStdChemCompCode(self):
    """
    Get for ccp.molecule.ChemComp.StdChemComp.stdChemCompCode
    """
    dataDict = self.__dict__
    result = dataDict.get('stdChemCompCode')
    return result

  getStereochemistries = ChemComp.getStereochemistries

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom

  newChemAngle = ChemComp.newChemAngle

  newChemAtom = ChemComp.newChemAtom

  newChemAtomSet = ChemComp.newChemAtomSet

  newChemBond = ChemComp.newChemBond

  newChemCompVar = ChemComp.newChemCompVar

  newChemTorsion = ChemComp.newChemTorsion

  newLinkAtom = ChemComp.newLinkAtom

  newLinkEnd = ChemComp.newLinkEnd

  newNamingSystem = ChemComp.newNamingSystem

  newStereochemistry = ChemComp.newStereochemistry

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeCommonName = ChemComp.removeCommonName

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  removeKeyword = ChemComp.removeKeyword

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.ChemComp.StdChemComp
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setBaseGlycoCtCode = ChemComp.setBaseGlycoCtCode

  setBeilsteinCode = ChemComp.setBeilsteinCode

  setCasRegCode = ChemComp.setCasRegCode

  setCcpCode = ChemComp.setCcpCode
  
  def setCode1Letter(self, value):
    """
    Set for ccp.molecule.ChemComp.StdChemComp.code1Letter
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode1Letter:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCode1Letter:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode1Letter:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCode1Letter:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('code1Letter')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode1Letter:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode1Letter:
         cannot set code1Letter, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode1Letter:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          if (not (value is None or len(value) == 1)):
            raise ApiError("""%s.setCode1Letter:
             code1Letter constraint length_is_one violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['code1Letter'] = value

    # doNotifies

  setCode3Letter = ChemComp.setCode3Letter

  setCommonNames = ChemComp.setCommonNames

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setDetails = ChemComp.setDetails

  setGuid = memops.api.Implementation.TopObject.setGuid

  setHasStdChirality = ChemComp.setHasStdChirality

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setKeywords = ChemComp.setKeywords

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy

  setMerckCode = ChemComp.setMerckCode

  setMolType = ChemComp.setMolType

  setName = ChemComp.setName

  setResidueTypeProbs = ChemComp.setResidueTypeProbs

  setSigmaAldrichCode = ChemComp.setSigmaAldrichCode
  
  def setStdChemCompCode(self, value):
    """
    Set for ccp.molecule.ChemComp.StdChemComp.stdChemCompCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setStdChemCompCode:
       memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setStdChemCompCode:
       memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setStdChemCompCode:
       memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setStdChemCompCode:
       LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('stdChemCompCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStdChemCompCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStdChemCompCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setStdChemCompCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['stdChemCompCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStdChemCompCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  sortedChemAngles = ChemComp.sortedChemAngles

  sortedChemAtomSets = ChemComp.sortedChemAtomSets

  sortedChemAtoms = ChemComp.sortedChemAtoms

  sortedChemBonds = ChemComp.sortedChemBonds

  sortedChemCompVars = ChemComp.sortedChemCompVars

  sortedChemTorsions = ChemComp.sortedChemTorsions

  sortedLinkEnds = ChemComp.sortedLinkEnds

  sortedNamingSystems = ChemComp.sortedNamingSystems

  sortedResidueTypeProbs = ChemComp.sortedResidueTypeProbs

  sortedStereochemistries = ChemComp.sortedStereochemistries

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  baseGlycoCtCode = ChemComp.baseGlycoCtCode

  beilsteinCode = ChemComp.beilsteinCode

  casRegCode = ChemComp.casRegCode

  ccpCode = ChemComp.ccpCode

  className = memops.api.Implementation.ComplexDataType.className
  
  code1Letter = property(getCode1Letter, setCode1Letter, None,
  r"""One letter code, defined only for standard chem comps. For each molType 
  there must be only one StdChemComp with a given oneLetterCode. This 
  constraint is not checked by the model, as it would entail looping over 
  all ChemComps whenever a check was made.
  """)

  code3Letter = ChemComp.code3Letter

  commonNames = ChemComp.commonNames

  createdBy = memops.api.Implementation.TopObject.createdBy

  details = ChemComp.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  hasStdChirality = ChemComp.hasStdChirality

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLinearPolymer = ChemComp.isLinearPolymer

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  keywords = ChemComp.keywords

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  merckCode = ChemComp.merckCode

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  molType = ChemComp.molType

  name = ChemComp.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  sigmaAldrichCode = ChemComp.sigmaAldrichCode
  
  stdChemCompCode = property(getStdChemCompCode, setStdChemCompCode, None,
  r"""
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories

  chemAngles = ChemComp.chemAngles

  chemAtomSets = ChemComp.chemAtomSets

  chemAtoms = ChemComp.chemAtoms

  chemBonds = ChemComp.chemBonds

  chemCompVars = ChemComp.chemCompVars

  chemTorsions = ChemComp.chemTorsions

  linkEnds = ChemComp.linkEnds

  memopsRoot = ChemComp.memopsRoot

  namingSystems = ChemComp.namingSystems

  packageLocator = memops.api.Implementation.TopObject.packageLocator

  parent = ChemComp.parent

  residueTypeProbs = ChemComp.residueTypeProbs

  root = memops.api.Implementation.MemopsObject.root

  stdChemComp = ChemComp.stdChemComp

  stereochemistries = ChemComp.stereochemistries

  topObject = memops.api.Implementation.DataObject.topObject
