"""
#######################################################################

CCPN Data Model version 2.0.6

Autogenerated by PyFileApiGen revision 1.57 on Wed Aug  7 15:07:21 2013
  from data model element ccpnmr.AnalysisProfile revision 1.12

#######################################################################
======================COPYRIGHT/LICENSE START==========================

AnalysisProfile.py: python API for CCPN data model, MetaPackage ccpnmr.AnalysisProfile

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.molecule.ChemComp
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccpnmr.AnalysisProfile')

###############################################################################
class AnalysisProfile(memops.api.Implementation.TopObject):
  r"""TopObject for Analysis user profile package
  """
  #   from data model element ccpnmr.AnalysisProfile.AnalysisProfile revision 1.14
  _metaclass = metaPackage.getElement('AnalysisProfile')
  _packageName = 'ccpnmr.AnalysisProfile'
  _packageShortName = 'ANAP'
  _fieldNames = ('applicationData', 'bgColor', 'className', 'createdBy', 'fgColor', 'fieldNames', 'font', 'graphicsHandler', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'panView', 'qualifiedName', 'sendBugReports', 'transientDialogs', 'transientWindows', 'twoCharShortcuts', 'useCrosshair', 'useGlobalShortcuts', 'userEmail', 'userName', 'userOrganisation', 'webBrowser', 'access', 'activeAccess', 'activeRepositories', 'colorSchemes', 'macros', 'marksColor', 'memopsRoot', 'packageLocator', 'parent', 'refExpProfiles', 'residueProfiles', 'root', 'rulersColor', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccpnmr.AnalysisProfile')

      dataDict['applicationData'] = list()
      dataDict['bgColor'] = '#FFFFFF'
      dataDict['createdBy'] = None
      dataDict['fgColor'] = '#000000'
      dataDict['font'] = None
      dataDict['graphicsHandler'] = 'Tk'
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['panView'] = True
      dataDict['sendBugReports'] = 'maybe'
      dataDict['transientDialogs'] = True
      dataDict['transientWindows'] = False
      dataDict['twoCharShortcuts'] = False
      dataDict['useCrosshair'] = True
      dataDict['useGlobalShortcuts'] = False
      dataDict['userEmail'] = None
      dataDict['userName'] = None
      dataDict['userOrganisation'] = None
      dataDict['webBrowser'] = None
      dataDict['access'] = None
      dataDict['colorSchemes'] = {}
      dataDict['macros'] = {}
      dataDict['marksColor'] = None
      dataDict['refExpProfiles'] = {}
      dataDict['residueProfiles'] = {}
      dataDict['rulersColor'] = None
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.AnalysisProfile.AnalysisProfile.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['macros'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('analysisProfiles')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentAnalysisProfile') is None)):
        root.__dict__['currentAnalysisProfile'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.AnalysisProfile.AnalysisProfile:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    colorSchemes = dataDict.get('colorSchemes').values()
    for colorScheme in colorSchemes:
      if (not (colorScheme in objsToBeDeleted)):
        objsToBeDeleted.add(colorScheme)
        objsToBeChecked.append(colorScheme)

    macros = dataDict.get('macros').values()
    for macro in macros:
      if (not (macro in objsToBeDeleted)):
        objsToBeDeleted.add(macro)
        objsToBeChecked.append(macro)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    refExpProfiles = dataDict.get('refExpProfiles').values()
    for refExpProfile in refExpProfiles:
      if (not (refExpProfile in objsToBeDeleted)):
        objsToBeDeleted.add(refExpProfile)
        objsToBeChecked.append(refExpProfile)

    residueProfiles = dataDict.get('residueProfiles').values()
    for residueProfile in residueProfiles:
      if (not (residueProfile in objsToBeDeleted)):
        objsToBeDeleted.add(residueProfile)
        objsToBeChecked.append(residueProfile)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.AnalysisProfile.AnalysisProfile:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentAnalysisProfile')):
      memopsRoot.__dict__['currentAnalysisProfile'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('analysisProfiles')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['colorSchemes'] = {}
    dataDict['macros'] = {}
    dataDict['refExpProfiles'] = {}
    dataDict['residueProfiles'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('colorSchemes').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('macros').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('refExpProfiles').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('residueProfiles').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('analysisProfiles')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('bgColor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: bgColor:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.checkValid: bgColor:
         RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.checkValid: bgColor:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('fgColor')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: fgColor:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.checkValid: fgColor:
         RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.checkValid: fgColor:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('font')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: font:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: font:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: font:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: font:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('graphicsHandler')
      if (not (value in ['Tk', 'OpenGL'])):
        raise ApiError("""%s.checkValid: graphicsHandler:
         ccpnmr.AnalysisProfile.GraphicsHandlerType input is not in enumeration ['Tk', 'OpenGL']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: graphicsHandler:
         GraphicsHandlerType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('panView')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: panView:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('sendBugReports')
      if (not (value in ['yes', 'no', 'maybe'])):
        raise ApiError("""%s.checkValid: sendBugReports:
         memops.Implementation.ThreeValueAnswer input is not in enumeration ['yes', 'no', 'maybe']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: sendBugReports:
         ThreeValueAnswer constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('transientDialogs')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: transientDialogs:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('transientWindows')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: transientWindows:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('twoCharShortcuts')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: twoCharShortcuts:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useCrosshair')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useCrosshair:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useGlobalShortcuts')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: useGlobalShortcuts:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('userEmail')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: userEmail:
           memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: userEmail:
           memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: userEmail:
           memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: userEmail:
           LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('userName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: userName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: userName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: userName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: userName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('userOrganisation')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: userOrganisation:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: userOrganisation:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: userOrganisation:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: userOrganisation:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('webBrowser')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: webBrowser:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: webBrowser:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: webBrowser:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: webBrowser:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('colorSchemes').values()
      for value in values:
        if (not isinstance(value, ColorScheme)):
          raise ApiError("""%s.checkValid: colorSchemes:
           value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProfile')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: colorSchemes:
           non-reciprocal link colorSchemes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('macros').values()
      for value in values:
        if (not isinstance(value, Macro)):
          raise ApiError("""%s.checkValid: macros:
           value is not of class ccpnmr.AnalysisProfile.Macro""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProfile')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: macros:
           non-reciprocal link macros from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('marksColor')
      if (value is not None):
        if (not isinstance(value, ColorScheme)):
          raise ApiError("""%s.checkValid: marksColor:
           value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: marksColor:
           Link marksColor between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('refExpProfiles').values()
      for value in values:
        if (not isinstance(value, RefExpProfile)):
          raise ApiError("""%s.checkValid: refExpProfiles:
           value is not of class ccpnmr.AnalysisProfile.RefExpProfile""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProfile')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refExpProfiles:
           non-reciprocal link refExpProfiles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('residueProfiles').values()
      for value in values:
        if (not isinstance(value, ResidueProfile)):
          raise ApiError("""%s.checkValid: residueProfiles:
           value is not of class ccpnmr.AnalysisProfile.ResidueProfile""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('analysisProfile')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residueProfiles:
           non-reciprocal link residueProfiles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('rulersColor')
      if (value is not None):
        if (not isinstance(value, ColorScheme)):
          raise ApiError("""%s.checkValid: rulersColor:
           value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: rulersColor:
           Link rulersColor between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('bgColor')
      if (value is None):
        raise ApiError("""%s.checkValid: bgColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('fgColor')
      if (value is None):
        raise ApiError("""%s.checkValid: fgColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('font')
      value = dataDict.get('graphicsHandler')
      if (value is None):
        raise ApiError("""%s.checkValid: graphicsHandler:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('panView')
      if (value is None):
        raise ApiError("""%s.checkValid: panView:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('sendBugReports')
      if (value is None):
        raise ApiError("""%s.checkValid: sendBugReports:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('transientDialogs')
      if (value is None):
        raise ApiError("""%s.checkValid: transientDialogs:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('transientWindows')
      if (value is None):
        raise ApiError("""%s.checkValid: transientWindows:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('twoCharShortcuts')
      if (value is None):
        raise ApiError("""%s.checkValid: twoCharShortcuts:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('useCrosshair')
      if (value is None):
        raise ApiError("""%s.checkValid: useCrosshair:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('useGlobalShortcuts')
      value = dataDict.get('userEmail')
      value = dataDict.get('userName')
      value = dataDict.get('userOrganisation')
      value = dataDict.get('webBrowser')
      # check roles
      value = dataDict.get('access')
      values = dataDict.get('colorSchemes').values()
      values = dataDict.get('macros').values()
      value = dataDict.get('marksColor')
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('refExpProfiles').values()
      values = dataDict.get('residueProfiles').values()
      value = dataDict.get('rulersColor')
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllColorSchemes(self, **conditions):
    """
    FindAll for ccpnmr.AnalysisProfile.AnalysisProfile.colorSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('colorSchemes').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('colorSchemes').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllMacros(self, **conditions):
    """
    FindAll for ccpnmr.AnalysisProfile.AnalysisProfile.macros
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('macros').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('macros').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'function', 'isInMenu', 'isInMouseMenu', 'module', 'name', 'ordering', 'path', 'serial', 'shortcut', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllRefExpProfiles(self, **conditions):
    """
    FindAll for ccpnmr.AnalysisProfile.AnalysisProfile.refExpProfiles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('refExpProfiles').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('refExpProfiles').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllResidueProfiles(self, **conditions):
    """
    FindAll for ccpnmr.AnalysisProfile.AnalysisProfile.residueProfiles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('residueProfiles').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('residueProfiles').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'guiName', 'molType', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstColorScheme(self, **conditions):
    """
    FindFirst for ccpnmr.AnalysisProfile.AnalysisProfile.colorSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('colorSchemes').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('colorSchemes').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('colorSchemes').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstMacro(self, **conditions):
    """
    FindFirst for ccpnmr.AnalysisProfile.AnalysisProfile.macros
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('macros').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('macros').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('macros').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'function', 'isInMenu', 'isInMouseMenu', 'module', 'name', 'ordering', 'path', 'serial', 'shortcut', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstRefExpProfile(self, **conditions):
    """
    FindFirst for ccpnmr.AnalysisProfile.AnalysisProfile.refExpProfiles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('refExpProfiles').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('refExpProfiles').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('refExpProfiles').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstResidueProfile(self, **conditions):
    """
    FindFirst for ccpnmr.AnalysisProfile.AnalysisProfile.residueProfiles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('residueProfiles').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('residueProfiles').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 2):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('residueProfiles').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'guiName', 'molType', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBgColor(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.bgColor
    """
    dataDict = self.__dict__
    result = dataDict.get('bgColor')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.AnalysisProfile.AnalysisProfile
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccpnmr.AnalysisProfile.AnalysisProfile'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('analysisProfiles').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccpnmr.AnalysisProfile')
      obj1 = startObj.__dict__.get('analysisProfiles').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getColorSchemes(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.colorSchemes
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('colorSchemes').values()
    result = frozenset(tempVar)
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getFgColor(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.fgColor
    """
    dataDict = self.__dict__
    result = dataDict.get('fgColor')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFont(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.font
    """
    dataDict = self.__dict__
    result = dataDict.get('font')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result
  
  def getGraphicsHandler(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.graphicsHandler
    """
    dataDict = self.__dict__
    result = dataDict.get('graphicsHandler')
    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMacros(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.macros
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('macros').values()
    result = frozenset(tempVar)
    return result
  
  def getMarksColor(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.marksColor
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    result = dataDict.get('marksColor')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getPanView(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.panView
    """
    dataDict = self.__dict__
    result = dataDict.get('panView')
    return result
  
  def getParent(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefExpProfiles(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.refExpProfiles
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('refExpProfiles').values()
    result = frozenset(tempVar)
    return result
  
  def getResidueProfiles(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.residueProfiles
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('residueProfiles').values()
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRulersColor(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.rulersColor
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    result = dataDict.get('rulersColor')
    return result
  
  def getSendBugReports(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.sendBugReports
    """
    dataDict = self.__dict__
    result = dataDict.get('sendBugReports')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getTransientDialogs(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.transientDialogs
    """
    dataDict = self.__dict__
    result = dataDict.get('transientDialogs')
    return result
  
  def getTransientWindows(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.transientWindows
    """
    dataDict = self.__dict__
    result = dataDict.get('transientWindows')
    return result
  
  def getTwoCharShortcuts(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.twoCharShortcuts
    """
    dataDict = self.__dict__
    result = dataDict.get('twoCharShortcuts')
    return result
  
  def getUseCrosshair(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.useCrosshair
    """
    dataDict = self.__dict__
    result = dataDict.get('useCrosshair')
    return result
  
  def getUseGlobalShortcuts(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.useGlobalShortcuts
    """
    dataDict = self.__dict__
    result = dataDict.get('useGlobalShortcuts')
    return result
  
  def getUserEmail(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.userEmail
    """
    dataDict = self.__dict__
    result = dataDict.get('userEmail')
    return result
  
  def getUserName(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.userName
    """
    dataDict = self.__dict__
    result = dataDict.get('userName')
    return result
  
  def getUserOrganisation(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.userOrganisation
    """
    dataDict = self.__dict__
    result = dataDict.get('userOrganisation')
    return result
  
  def getWebBrowser(self):
    """
    Get for ccpnmr.AnalysisProfile.AnalysisProfile.webBrowser
    """
    dataDict = self.__dict__
    result = dataDict.get('webBrowser')
    return result

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newColorScheme(self, **attrlinks):
    """
    Factory function to create ccpnmr.AnalysisProfile.ColorScheme
    """
    return ColorScheme(self, **attrlinks)
  
  def newMacro(self, **attrlinks):
    """
    Factory function to create ccpnmr.AnalysisProfile.Macro
    """
    return Macro(self, **attrlinks)
  
  def newRefExpProfile(self, **attrlinks):
    """
    Factory function to create ccpnmr.AnalysisProfile.RefExpProfile
    """
    return RefExpProfile(self, **attrlinks)
  
  def newResidueProfile(self, **attrlinks):
    """
    Factory function to create ccpnmr.AnalysisProfile.ResidueProfile
    """
    return ResidueProfile(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.AnalysisProfile.AnalysisProfile
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBgColor(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.bgColor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setBgColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.setBgColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.setBgColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('bgColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBgColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBgColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setBgColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['bgColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBgColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy
  
  def setFgColor(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.fgColor
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setFgColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.setFgColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.setFgColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('fgColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFgColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFgColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFgColor:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['fgColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFgColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFont(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.font
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFont:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setFont:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFont:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFont:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('font')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFont:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFont:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['font'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFont')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setGraphicsHandler(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.graphicsHandler
    """
    dataDict = self.__dict__
    if (not (value in ['Tk', 'OpenGL'])):
      raise ApiError("""%s.setGraphicsHandler:
       ccpnmr.AnalysisProfile.GraphicsHandlerType input is not in enumeration ['Tk', 'OpenGL']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setGraphicsHandler:
       GraphicsHandlerType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('graphicsHandler')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setGraphicsHandler:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGraphicsHandler:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setGraphicsHandler:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['graphicsHandler'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setGraphicsHandler')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setMarksColor(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.marksColor
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ColorScheme)):
        raise ApiError("""%s.setMarksColor:
         value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('marksColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMarksColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMarksColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMarksColor:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMarksColor:
           Link marksColor between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['marksColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMarksColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setPanView(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.panView
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setPanView:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('panView')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPanView:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPanView:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPanView:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['panView'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPanView')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRulersColor(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.rulersColor
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ColorScheme)):
        raise ApiError("""%s.setRulersColor:
         value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('rulersColor')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRulersColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRulersColor:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRulersColor:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRulersColor:
           Link rulersColor between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['rulersColor'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRulersColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSendBugReports(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.sendBugReports
    """
    dataDict = self.__dict__
    if (not (value in ['yes', 'no', 'maybe'])):
      raise ApiError("""%s.setSendBugReports:
       memops.Implementation.ThreeValueAnswer input is not in enumeration ['yes', 'no', 'maybe']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setSendBugReports:
       ThreeValueAnswer constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('sendBugReports')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSendBugReports:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSendBugReports:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSendBugReports:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['sendBugReports'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSendBugReports')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTransientDialogs(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.transientDialogs
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setTransientDialogs:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('transientDialogs')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTransientDialogs:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTransientDialogs:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setTransientDialogs:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['transientDialogs'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTransientDialogs')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTransientWindows(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.transientWindows
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setTransientWindows:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('transientWindows')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTransientWindows:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTransientWindows:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setTransientWindows:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['transientWindows'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTransientWindows')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTwoCharShortcuts(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.twoCharShortcuts
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setTwoCharShortcuts:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('twoCharShortcuts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTwoCharShortcuts:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTwoCharShortcuts:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setTwoCharShortcuts:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['twoCharShortcuts'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTwoCharShortcuts')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseCrosshair(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.useCrosshair
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUseCrosshair:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('useCrosshair')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseCrosshair:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseCrosshair:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUseCrosshair:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['useCrosshair'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseCrosshair')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseGlobalShortcuts(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.useGlobalShortcuts
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setUseGlobalShortcuts:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('useGlobalShortcuts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseGlobalShortcuts:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseGlobalShortcuts:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['useGlobalShortcuts'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseGlobalShortcuts')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUserEmail(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.userEmail
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setUserEmail:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setUserEmail:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setUserEmail:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setUserEmail:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('userEmail')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUserEmail:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUserEmail:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['userEmail'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUserEmail')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUserName(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.userName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setUserName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setUserName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setUserName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setUserName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('userName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUserName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUserName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['userName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUserName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUserOrganisation(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.userOrganisation
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setUserOrganisation:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setUserOrganisation:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setUserOrganisation:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setUserOrganisation:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('userOrganisation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUserOrganisation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUserOrganisation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['userOrganisation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUserOrganisation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWebBrowser(self, value):
    """
    Set for ccpnmr.AnalysisProfile.AnalysisProfile.webBrowser
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setWebBrowser:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setWebBrowser:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setWebBrowser:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setWebBrowser:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('webBrowser')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWebBrowser:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWebBrowser:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['webBrowser'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWebBrowser')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedColorSchemes(self):
    """
    Sorted for ccpnmr.AnalysisProfile.AnalysisProfile.colorSchemes
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('colorSchemes')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMacros(self):
    """
    Sorted for ccpnmr.AnalysisProfile.AnalysisProfile.macros
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('macros')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedRefExpProfiles(self):
    """
    Sorted for ccpnmr.AnalysisProfile.AnalysisProfile.refExpProfiles
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('refExpProfiles')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedResidueProfiles(self):
    """
    Sorted for ccpnmr.AnalysisProfile.AnalysisProfile.residueProfiles
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('residueProfiles')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  bgColor = property(getBgColor, setBgColor, None,
  r"""background contour plot color
  """)

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy
  
  fgColor = property(getFgColor, setFgColor, None,
  r"""foreground contour plot color
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  font = property(getFont, setFont, None,
  r"""font for general use in interface
  """)
  
  graphicsHandler = property(getGraphicsHandler, setGraphicsHandler, None,
  r"""Name of graphics handler to use
  """)

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of AnalysisProfile
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  panView = property(getPanView, setPanView, None,
  r"""Move view when panning (rather than viewing window)
  Does pan track the 
  view, rather than the contours?
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  sendBugReports = property(getSendBugReports, setSendBugReports, None,
  r"""Should bug reports be sent? yes (always) no (never) of maybe (ask first)
  """)
  
  transientDialogs = property(getTransientDialogs, setTransientDialogs, None,
  r"""Are dialogs transient
  """)
  
  transientWindows = property(getTransientWindows, setTransientWindows, None,
  r"""Are windows transient
  """)
  
  twoCharShortcuts = property(getTwoCharShortcuts, setTwoCharShortcuts, None,
  r"""Use two character shortcuts (rather than single-character)
  """)
  
  useCrosshair = property(getUseCrosshair, setUseCrosshair, None,
  r"""Use crosshair on contuor plots
  """)
  
  useGlobalShortcuts = property(getUseGlobalShortcuts, setUseGlobalShortcuts, None,
  r"""Do shortcuts toggle all windows, or just the current?
  """)
  
  userEmail = property(getUserEmail, setUserEmail, None,
  r"""Email address of Analysis user. Used for bug reporting, registration 
  etc. as communication address and user identifier
  """)
  
  userName = property(getUserName, setUserName, None,
  r"""Name of Analysis user. Used for bug reporting, registration etc.
  """)
  
  userOrganisation = property(getUserOrganisation, setUserOrganisation, None,
  r"""Name of Analysis user. Used for bug reporting, registration etc.
  """)
  
  webBrowser = property(getWebBrowser, setWebBrowser, None,
  r"""Name of web browser to use for help etc.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  colorSchemes = property(getColorSchemes,  None, None,
  r"""child link to class ColorScheme
  """)
  
  macros = property(getMacros,  None, None,
  r"""child link to class Macro
  """)
  
  marksColor = property(getMarksColor, setMarksColor, None,
  r"""Color scheme for marks
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)
  
  refExpProfiles = property(getRefExpProfiles,  None, None,
  r"""child link to class RefExpProfile
  """)
  
  residueProfiles = property(getResidueProfiles,  None, None,
  r"""child link to class ResidueProfile
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  rulersColor = property(getRulersColor, setRulersColor, None,
  r"""Color scheme for rulers
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ColorScheme(memops.api.Implementation.DataObject):
  r"""Set of colors. Intended for contour drawing.
  """
  #   from data model element ccpnmr.AnalysisProfile.ColorScheme revision 1.13
  _metaclass = metaPackage.getElement('ColorScheme')
  _packageName = 'ccpnmr.AnalysisProfile'
  _packageShortName = 'ANAP'
  _fieldNames = ('applicationData', 'className', 'colors', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'analysisProfile', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    dataDict['analysisProfile'] = parent
    if (not isinstance(parent, AnalysisProfile)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['colors'] = list()
      dataDict['name'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.AnalysisProfile.ColorScheme.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('colorSchemes')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.AnalysisProfile.ColorScheme:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.AnalysisProfile.ColorScheme:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProfile = dataDict.get('analysisProfile')
    if (not (analysisProfile in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProfile.__dict__.get('colorSchemes')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addColor(self, value):
    """
    Add for ccpnmr.AnalysisProfile.ColorScheme.colors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.addColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.addColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('colors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addColor:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProfile')
        dd = value.__dict__.get('colorSchemes')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProfile' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('colors')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: colors:
           memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
          raise ApiError("""%s.checkValid: colors:
           RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value) == 7)):
          raise ApiError("""%s.checkValid: colors:
           RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProfile')
      if (not isinstance(value, AnalysisProfile)):
        raise ApiError("""%s.checkValid: analysisProfile:
         value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('colors')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProfile')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProfile:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProfile(self):
    """
    Get for ccpnmr.AnalysisProfile.ColorScheme.analysisProfile
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.AnalysisProfile.ColorScheme
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.ColorScheme'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.AnalysisProfile')
        obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.ColorScheme'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('colorSchemes').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getColors(self):
    """
    Get for ccpnmr.AnalysisProfile.ColorScheme.colors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('colors')
    result = tuple(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProfile')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.AnalysisProfile.ColorScheme.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.AnalysisProfile.ColorScheme.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeColor(self, value):
    """
    Remove for ccpnmr.AnalysisProfile.ColorScheme.colors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.removeColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.removeColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('colors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeColor:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeColor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.AnalysisProfile.ColorScheme
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setColors(self, values):
    """
    Set for ccpnmr.AnalysisProfile.ColorScheme.colors
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setColors:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.setColors:
         RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.setColors:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('colors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setColors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setColors:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['colors'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setColors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.AnalysisProfile.ColorScheme.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  colors = property(getColors, setColors, None,
  r"""Colors in the color scheme
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""The name of the color scheme, e.g. 'rainbow'.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProfile = property(getAnalysisProfile,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProfile
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Macro(memops.api.Implementation.DataObject):
  r"""Command script for use in Analysis. Is assumed to be in Python.
  """
  #   from data model element ccpnmr.AnalysisProfile.Macro revision 1.12
  _metaclass = metaPackage.getElement('Macro')
  _packageName = 'ccpnmr.AnalysisProfile'
  _packageShortName = 'ANAP'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'function', 'inConstructor', 'isDeleted', 'isInMenu', 'isInMouseMenu', 'metaclass', 'module', 'name', 'ordering', 'packageName', 'packageShortName', 'path', 'qualifiedName', 'serial', 'shortcut', 'access', 'activeAccess', 'analysisProfile', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    dataDict['analysisProfile'] = parent
    if (not isinstance(parent, AnalysisProfile)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['function'] = None
      dataDict['isInMenu'] = False
      dataDict['isInMouseMenu'] = False
      dataDict['module'] = None
      dataDict['name'] = None
      dataDict['ordering'] = 0
      dataDict['path'] = None
      dataDict['serial'] = None
      dataDict['shortcut'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.AnalysisProfile.Macro.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccpnmr.AnalysisProfile.Macro')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('macros')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.AnalysisProfile.Macro:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.AnalysisProfile.Macro:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProfile = dataDict.get('analysisProfile')
    if (not (analysisProfile in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProfile.__dict__.get('macros')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProfile')
        dd = value.__dict__.get('macros')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProfile' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('function')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: function:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: function:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: function:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: function:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isInMenu')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isInMenu:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isInMouseMenu')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isInMouseMenu:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('module')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: module:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: module:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: module:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: module:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ordering')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ordering:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('path')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: path:
           memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value.find(chr(92)) == -1)):
          raise ApiError("""%s.checkValid: path:
           PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: path:
           PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('shortcut')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: shortcut:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: shortcut:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: shortcut:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: shortcut:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProfile')
      if (not isinstance(value, AnalysisProfile)):
        raise ApiError("""%s.checkValid: analysisProfile:
         value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('function')
    if (value is None):
      raise ApiError("""%s.checkValid: function:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isInMenu')
    if (value is None):
      raise ApiError("""%s.checkValid: isInMenu:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isInMouseMenu')
    if (value is None):
      raise ApiError("""%s.checkValid: isInMouseMenu:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('module')
    if (value is None):
      raise ApiError("""%s.checkValid: module:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ordering')
    if (value is None):
      raise ApiError("""%s.checkValid: ordering:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('path')
    value = dataDict.get('shortcut')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProfile')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProfile:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProfile(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.analysisProfile
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.AnalysisProfile.Macro
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.Macro'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.AnalysisProfile')
        obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.Macro'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('macros').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetails(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProfile')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result
  
  def getFunction(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.function
    """
    dataDict = self.__dict__
    result = dataDict.get('function')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsInMenu(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.isInMenu
    """
    dataDict = self.__dict__
    result = dataDict.get('isInMenu')
    return result
  
  def getIsInMouseMenu(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.isInMouseMenu
    """
    dataDict = self.__dict__
    result = dataDict.get('isInMouseMenu')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getModule(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.module
    """
    dataDict = self.__dict__
    result = dataDict.get('module')
    return result
  
  def getName(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getOrdering(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.ordering
    """
    dataDict = self.__dict__
    result = dataDict.get('ordering')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result
  
  def getPath(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.path
    """
    dataDict = self.__dict__
    result = dataDict.get('path')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getShortcut(self):
    """
    Get for ccpnmr.AnalysisProfile.Macro.shortcut
    """
    dataDict = self.__dict__
    result = dataDict.get('shortcut')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.AnalysisProfile.Macro
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetails(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFunction(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.function
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setFunction:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setFunction:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setFunction:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setFunction:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('function')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFunction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFunction:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFunction:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['function'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFunction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsInMenu(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.isInMenu
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsInMenu:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isInMenu')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsInMenu:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsInMenu:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsInMenu:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isInMenu'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsInMenu')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsInMouseMenu(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.isInMouseMenu
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsInMouseMenu:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isInMouseMenu')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsInMouseMenu:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsInMouseMenu:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsInMouseMenu:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isInMouseMenu'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsInMouseMenu')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setModule(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.module
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setModule:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setModule:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setModule:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setModule:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('module')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setModule:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setModule:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setModule:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['module'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setModule')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setOrdering(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.ordering
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setOrdering:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ordering')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOrdering:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOrdering:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setOrdering:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ordering'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOrdering')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPath(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.path
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPath:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.setPath:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setPath:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('path')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPath:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPath:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['path'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPath')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('analysisProfile')
    oldSerial = parent.__dict__.get('_serialDict').get('macros')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['macros'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['macros'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setShortcut(self, value):
    """
    Set for ccpnmr.AnalysisProfile.Macro.shortcut
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setShortcut:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setShortcut:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setShortcut:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setShortcut:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('shortcut')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setShortcut:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShortcut:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['shortcut'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setShortcut')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  function = property(getFunction, setFunction, None,
  r"""Name of function to import
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isInMenu = property(getIsInMenu, setIsInMenu, None,
  r"""Is macro shown in drop-down menu?
  """)
  
  isInMouseMenu = property(getIsInMouseMenu, setIsInMouseMenu, None,
  r"""Is macro shown in right mouse menu?
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  module = property(getModule, setModule, None,
  r"""Name of module (optionally in dot separated form, like mod.submod.file) 
  from which to import function.
  """)
  
  name = property(getName, setName, None,
  r"""name of macro (used for ideitifying it to user). 
  """)
  
  ordering = property(getOrdering, setOrdering, None,
  r"""An integer that serves to order the different macros in lists (if, for 
  instance you want to put the most commonly used ones at the top).
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  path = property(getPath, setPath, None,
  r"""Directory to put on pythonpath in order to find file containing macro. 
  Defaults to empty string, meaning that the directory is (assumed to be) 
  already on the pythonpath.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  shortcut = property(getShortcut, setShortcut, None,
  r"""Keyboard shortcut to activate macro
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProfile = property(getAnalysisProfile,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProfile
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class RefExpProfile(memops.api.Implementation.DataObject):
  r"""Default profile for ref experiment types.
  """
  #   from data model element ccpnmr.AnalysisProfile.RefExpProfile revision 1.13
  _metaclass = metaPackage.getElement('RefExpProfile')
  _packageName = 'ccpnmr.AnalysisProfile'
  _packageShortName = 'ANAP'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'peakSymbolColors', 'peakTextColors', 'qualifiedName', 'refExpNames', 'access', 'activeAccess', 'analysisProfile', 'negColorSchemes', 'parent', 'posColorSchemes', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    dataDict['analysisProfile'] = parent
    if (not isinstance(parent, AnalysisProfile)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['peakSymbolColors'] = list()
      dataDict['peakTextColors'] = list()
      dataDict['refExpNames'] = list()
      dataDict['access'] = None
      dataDict['negColorSchemes'] = list()
      dataDict['posColorSchemes'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.AnalysisProfile.RefExpProfile.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('refExpProfiles')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.AnalysisProfile.RefExpProfile:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.AnalysisProfile.RefExpProfile:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProfile = dataDict.get('analysisProfile')
    if (not (analysisProfile in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProfile.__dict__.get('refExpProfiles')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addNegColorScheme(self, value):
    """
    Add for ccpnmr.AnalysisProfile.RefExpProfile.negColorSchemes
    """
    dataDict = self.__dict__
    if (not isinstance(value, ColorScheme)):
      raise ApiError("""%s.addNegColorScheme:
       value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negColorSchemes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNegColorScheme:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNegColorScheme:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNegColorScheme:
       called with deleted value""" % self.qualifiedName
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNegColorScheme:
           Link negColorSchemes between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNegColorScheme')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addPeakSymbolColor(self, value):
    """
    Add for ccpnmr.AnalysisProfile.RefExpProfile.peakSymbolColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addPeakSymbolColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.addPeakSymbolColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.addPeakSymbolColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('peakSymbolColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addPeakSymbolColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addPeakSymbolColor:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addPeakSymbolColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addPeakTextColor(self, value):
    """
    Add for ccpnmr.AnalysisProfile.RefExpProfile.peakTextColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addPeakTextColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.addPeakTextColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.addPeakTextColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('peakTextColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addPeakTextColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addPeakTextColor:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addPeakTextColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addPosColorScheme(self, value):
    """
    Add for ccpnmr.AnalysisProfile.RefExpProfile.posColorSchemes
    """
    dataDict = self.__dict__
    if (not isinstance(value, ColorScheme)):
      raise ApiError("""%s.addPosColorScheme:
       value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posColorSchemes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addPosColorScheme:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addPosColorScheme:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addPosColorScheme:
       called with deleted value""" % self.qualifiedName
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addPosColorScheme:
           Link posColorSchemes between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addPosColorScheme')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addRefExpName(self, value):
    """
    Add for ccpnmr.AnalysisProfile.RefExpProfile.refExpNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addRefExpName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.addRefExpName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addRefExpName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.addRefExpName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refExpNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefExpName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefExpName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefExpName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProfile')
        dd = value.__dict__.get('refExpProfiles')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProfile' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('peakSymbolColors')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: peakSymbolColors:
           memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
          raise ApiError("""%s.checkValid: peakSymbolColors:
           RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value) == 7)):
          raise ApiError("""%s.checkValid: peakSymbolColors:
           RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('peakTextColors')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: peakTextColors:
           memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
          raise ApiError("""%s.checkValid: peakTextColors:
           RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value) == 7)):
          raise ApiError("""%s.checkValid: peakTextColors:
           RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('refExpNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: refExpNames:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: refExpNames:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: refExpNames:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: refExpNames:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProfile')
      if (not isinstance(value, AnalysisProfile)):
        raise ApiError("""%s.checkValid: analysisProfile:
         value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('negColorSchemes')
      for value in values:
        if (not isinstance(value, ColorScheme)):
          raise ApiError("""%s.checkValid: negColorSchemes:
           value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: negColorSchemes:
           Link negColorSchemes between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('posColorSchemes')
      for value in values:
        if (not isinstance(value, ColorScheme)):
          raise ApiError("""%s.checkValid: posColorSchemes:
           value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: posColorSchemes:
           Link posColorSchemes between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('peakSymbolColors')
    values = dataDict.get('peakTextColors')
    values = dataDict.get('refExpNames')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProfile')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProfile:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('negColorSchemes')
    values = dataDict.get('posColorSchemes')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllNegColorSchemes(self, **conditions):
    """
    FindAll for ccpnmr.AnalysisProfile.RefExpProfile.negColorSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('negColorSchemes')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('negColorSchemes')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.append(v)

    return result
  
  def findAllPosColorSchemes(self, **conditions):
    """
    FindAll for ccpnmr.AnalysisProfile.RefExpProfile.posColorSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('posColorSchemes')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('posColorSchemes')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.append(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstNegColorScheme(self, **conditions):
    """
    FindFirst for ccpnmr.AnalysisProfile.RefExpProfile.negColorSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('negColorSchemes')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('negColorSchemes')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstPosColorScheme(self, **conditions):
    """
    FindFirst for ccpnmr.AnalysisProfile.RefExpProfile.posColorSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('posColorSchemes')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('posColorSchemes')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'access', 'analysisProfile',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProfile(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.analysisProfile
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.AnalysisProfile.RefExpProfile
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.RefExpProfile'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.AnalysisProfile')
        obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.RefExpProfile'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('refExpProfiles').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProfile')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNegColorSchemes(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.negColorSchemes
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('negColorSchemes')
    result = tuple(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result
  
  def getPeakSymbolColors(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.peakSymbolColors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('peakSymbolColors')
    result = tuple(tempVar)
    return result
  
  def getPeakTextColors(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.peakTextColors
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('peakTextColors')
    result = tuple(tempVar)
    return result
  
  def getPosColorSchemes(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.posColorSchemes
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('posColorSchemes')
    result = tuple(tempVar)
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefExpNames(self):
    """
    Get for ccpnmr.AnalysisProfile.RefExpProfile.refExpNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refExpNames')
    result = tuple(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeNegColorScheme(self, value):
    """
    Remove for ccpnmr.AnalysisProfile.RefExpProfile.negColorSchemes
    """
    dataDict = self.__dict__
    if (not isinstance(value, ColorScheme)):
      raise ApiError("""%s.removeNegColorScheme:
       value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negColorSchemes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNegColorScheme:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNegColorScheme:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNegColorScheme:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNegColorScheme:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNegColorScheme')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removePeakSymbolColor(self, value):
    """
    Remove for ccpnmr.AnalysisProfile.RefExpProfile.peakSymbolColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removePeakSymbolColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.removePeakSymbolColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.removePeakSymbolColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('peakSymbolColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removePeakSymbolColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removePeakSymbolColor:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removePeakSymbolColor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removePeakSymbolColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removePeakTextColor(self, value):
    """
    Remove for ccpnmr.AnalysisProfile.RefExpProfile.peakTextColors
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removePeakTextColor:
       memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
      raise ApiError("""%s.removePeakTextColor:
       RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value) == 7)):
      raise ApiError("""%s.removePeakTextColor:
       RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('peakTextColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removePeakTextColor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removePeakTextColor:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removePeakTextColor:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removePeakTextColor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removePosColorScheme(self, value):
    """
    Remove for ccpnmr.AnalysisProfile.RefExpProfile.posColorSchemes
    """
    dataDict = self.__dict__
    if (not isinstance(value, ColorScheme)):
      raise ApiError("""%s.removePosColorScheme:
       value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posColorSchemes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removePosColorScheme:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removePosColorScheme:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removePosColorScheme:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removePosColorScheme:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removePosColorScheme')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeRefExpName(self, value):
    """
    Remove for ccpnmr.AnalysisProfile.RefExpProfile.refExpNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeRefExpName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.removeRefExpName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeRefExpName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.removeRefExpName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refExpNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefExpName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefExpName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefExpName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefExpName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccpnmr.AnalysisProfile.RefExpProfile
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setName(self, value):
    """
    Set for ccpnmr.AnalysisProfile.RefExpProfile.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNegColorSchemes(self, values):
    """
    Set for ccpnmr.AnalysisProfile.RefExpProfile.negColorSchemes
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (not isinstance(value, ColorScheme)):
        raise ApiError("""%s.setNegColorSchemes:
         value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('negColorSchemes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNegColorSchemes:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNegColorSchemes:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNegColorSchemes:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNegColorSchemes:
           Link negColorSchemes between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['negColorSchemes'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNegColorSchemes')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakSymbolColors(self, values):
    """
    Set for ccpnmr.AnalysisProfile.RefExpProfile.peakSymbolColors
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPeakSymbolColors:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.setPeakSymbolColors:
         RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.setPeakSymbolColors:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('peakSymbolColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakSymbolColors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakSymbolColors:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['peakSymbolColors'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakSymbolColors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPeakTextColors(self, values):
    """
    Set for ccpnmr.AnalysisProfile.RefExpProfile.peakTextColors
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPeakTextColors:
         memops.Implementation.RgbColor input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value[0] == '#' and not [x for x in value[1:] if x not in  '0123456789ABCDEF'])):
        raise ApiError("""%s.setPeakTextColors:
         RgbColor constraint RGB_color_format violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value) == 7)):
        raise ApiError("""%s.setPeakTextColors:
         RgbColor constraint length_is_7 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('peakTextColors')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakTextColors:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakTextColors:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['peakTextColors'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakTextColors')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPosColorSchemes(self, values):
    """
    Set for ccpnmr.AnalysisProfile.RefExpProfile.posColorSchemes
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (not isinstance(value, ColorScheme)):
        raise ApiError("""%s.setPosColorSchemes:
         value is not of class ccpnmr.AnalysisProfile.ColorScheme""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('posColorSchemes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPosColorSchemes:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPosColorSchemes:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setPosColorSchemes:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setPosColorSchemes:
           Link posColorSchemes between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['posColorSchemes'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPosColorSchemes')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefExpNames(self, values):
    """
    Set for ccpnmr.AnalysisProfile.RefExpProfile.refExpNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setRefExpNames:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setRefExpNames:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setRefExpNames:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setRefExpNames:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refExpNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefExpNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefExpNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['refExpNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefExpNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Name of RefExpProfile (key)
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  peakSymbolColors = property(getPeakSymbolColors, setPeakSymbolColors, None,
  r"""Colors for PeakSymbol (used as a cycle)
  """)
  
  peakTextColors = property(getPeakTextColors, setPeakTextColors, None,
  r"""Colors for peak annotation text - used as a cycle
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  refExpNames = property(getRefExpNames, setRefExpNames, None,
  r"""Names of RefExperiments that RefExpProfile applies to.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProfile = property(getAnalysisProfile,  None, None,
  r"""parent link
  """)
  
  negColorSchemes = property(getNegColorSchemes, setNegColorSchemes, None,
  r"""Color schemes for negative contours - used as a cycle, the first one for 
  the first experiment that fits, the second for the second, etc.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProfile
  """)
  
  posColorSchemes = property(getPosColorSchemes, setPosColorSchemes, None,
  r"""Color schemes for postive contours - used as a cycle, the first one for 
  the first experiment that fits, the second for the second, etc.
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ResidueProfile(memops.api.Implementation.DataObject):
  r"""Profile information for Molecular residues
  """
  #   from data model element ccpnmr.AnalysisProfile.ResidueProfile revision 1.12
  _metaclass = metaPackage.getElement('ResidueProfile')
  _packageName = 'ccpnmr.AnalysisProfile'
  _packageShortName = 'ANAP'
  _fieldNames = ('applicationData', 'ccpCode', 'className', 'fieldNames', 'guiName', 'inConstructor', 'isDeleted', 'metaclass', 'molType', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'analysisProfile', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    dataDict['analysisProfile'] = parent
    if (not isinstance(parent, AnalysisProfile)):
      raise ApiError("""%s.__init__:
       value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['ccpCode'] = None
      dataDict['guiName'] = None
      dataDict['molType'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccpnmr.AnalysisProfile.ResidueProfile.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('residueProfiles')
        ll = list()
        objKey = dataDict.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molType', 'ccpCode'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccpnmr.AnalysisProfile.ResidueProfile:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccpnmr.AnalysisProfile.ResidueProfile:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    analysisProfile = dataDict.get('analysisProfile')
    if (not (analysisProfile in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = analysisProfile.__dict__.get('residueProfiles')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('analysisProfile')
        dd = value.__dict__.get('residueProfiles')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'analysisProfile' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ccpCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: ccpCode:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ccpCode:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guiName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guiName:
         memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guiName:
         memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guiName:
         memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: guiName:
         LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molType')
      if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.checkValid: molType:
         ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molType:
         MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('analysisProfile')
      if (not isinstance(value, AnalysisProfile)):
        raise ApiError("""%s.checkValid: analysisProfile:
         value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('ccpCode')
    if (value is None):
      raise ApiError("""%s.checkValid: ccpCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('guiName')
    if (value is None):
      raise ApiError("""%s.checkValid: guiName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molType')
    if (value is None):
      raise ApiError("""%s.checkValid: molType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('analysisProfile')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisProfile:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisProfile(self):
    """
    Get for ccpnmr.AnalysisProfile.ResidueProfile.analysisProfile
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccpnmr.AnalysisProfile.ResidueProfile
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.ResidueProfile'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccpnmr.AnalysisProfile')
        obj1 = obj0.__dict__.get('analysisProfiles').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccpnmr.AnalysisProfile.ResidueProfile'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      ll = list()
      objKey = fullKey[-2]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[-1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj2 = obj1.__dict__.get('residueProfiles').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCcpCode(self):
    """
    Get for ccpnmr.AnalysisProfile.ResidueProfile.ccpCode
    """
    dataDict = self.__dict__
    result = dataDict.get('ccpCode')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('analysisProfile')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('molType'))
    result.append(dataDict.get('ccpCode'))

    return result
  
  def getGuiName(self):
    """
    Get for ccpnmr.AnalysisProfile.ResidueProfile.guiName
    """
    dataDict = self.__dict__
    result = dataDict.get('guiName')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('molType')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('ccpCode')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolType(self):
    """
    Get for ccpnmr.AnalysisProfile.ResidueProfile.molType
    """
    dataDict = self.__dict__
    result = dataDict.get('molType')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccpnmr.AnalysisProfile.ResidueProfile.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisProfile')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccpnmr.AnalysisProfile.ResidueProfile
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCcpCode(self, value):
    """
    Set for ccpnmr.AnalysisProfile.ResidueProfile.ccpCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCcpCode:
       memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCcpCode:
       LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ccpCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCcpCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCcpCode:
         cannot set ccpCode, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCcpCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ccpCode'] = value

    # doNotifies
  
  def setGuiName(self, value):
    """
    Set for ccpnmr.AnalysisProfile.ResidueProfile.guiName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setGuiName:
       memops.Implementation.LongWord input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setGuiName:
       memops.Implementation.LongWord maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setGuiName:
       memops.Implementation.LongWord: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setGuiName:
       LongWord constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('guiName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setGuiName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGuiName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setGuiName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['guiName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setGuiName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolType(self, value):
    """
    Set for ccpnmr.AnalysisProfile.ResidueProfile.molType
    """
    dataDict = self.__dict__
    if (not (value in ['protein', 'DNA', 'RNA', 'carbohydrate', 'other'])):
      raise ApiError("""%s.setMolType:
       ccp.molecule.ChemComp.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'carbohydrate', 'other']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolType:
       MolType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolType:
         cannot set molType, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molType'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  ccpCode = property(getCcpCode, setCcpCode, None,
  r"""ccpCode for residue
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  guiName = property(getGuiName, setGuiName, None,
  r"""Residue name to use in graphical interface
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, setMolType, None,
  r"""molType of residue
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  analysisProfile = property(getAnalysisProfile,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for analysisProfile
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
