"""
#######################################################################

CCPN Data Model version 2.0.6

Autogenerated by PyXmlMapWrite revision 1.29 on Wed Aug  7 15:06:08 2013
  from data model element ccp.nmr.NmrScreen revision 1.5

#######################################################################
======================COPYRIGHT/LICENSE START==========================

NmrScreen.py: python XML-I/O-mapping for CCPN data model, MetaPackage ccp.nmr.NmrScreen

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import ccp.api.nmr.NmrScreen

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package NMRS, adding it to globalMap
  """
  
  from memops.xml.Implementation import bool2str, str2bool

  # Set up top level dictionaries
  loadMaps = globalMap.get('loadMaps')
  mapsByGuid = globalMap.get('mapsByGuid')

  abstractTypes = globalMap.get('NMRS').get('abstractTypes')
  exolinks = globalMap.get('NMRS').get('exolinks')

  # DataType Solvent
  currentMap = {}
  abstractTypes['Solvent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005'] = currentMap
  loadMaps['NMRS.Solvent'] = currentMap
  currentMap['tag'] = 'NMRS.Solvent'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # Class Compound
  currentMap = {}
  abstractTypes['Compound'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00003'] = currentMap
  loadMaps['NMRS.Compound'] = currentMap
  currentMap['tag'] = 'NMRS.Compound'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'compounds'
  currentMap['objkey'] = 'code'
  currentMap['class'] = ccp.api.nmr.NmrScreen.Compound
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Compound.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Compound.code
  currentMap = {}
  contentMap['code'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00005'] = currentMap
  loadMaps['NMRS.Compound.code'] = currentMap
  currentMap['tag'] = 'NMRS.Compound.code'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00005'
  currentMap['name'] = 'code'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute Compound.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00007'] = currentMap
  loadMaps['NMRS.Compound.details'] = currentMap
  currentMap['tag'] = 'NMRS.Compound.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00007'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute Compound.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00006'] = currentMap
  loadMaps['NMRS.Compound.name'] = currentMap
  currentMap['tag'] = 'NMRS.Compound.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00006'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Role Compound.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Compound.mixtureComponents
  currentMap = {}
  contentMap['mixtureComponents'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00004'] = currentMap
  loadMaps['NMRS.Compound.mixtureComponents'] = currentMap
  currentMap['tag'] = 'NMRS.Compound.mixtureComponents'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00004'
  currentMap['name'] = 'mixtureComponents'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role Compound.molecule
  currentMap = {}
  contentMap['molecule'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00026'] = currentMap
  loadMaps['NMRS.Compound.molecule'] = currentMap
  currentMap['tag'] = 'NMRS.Compound.molecule'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00026'
  currentMap['name'] = 'molecule'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLE').get('exolinks')

  # Role Compound.refSpectrums
  currentMap = {}
  contentMap['refSpectrums'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00002'] = currentMap
  loadMaps['NMRS.Compound.refSpectrums'] = currentMap
  currentMap['tag'] = 'NMRS.Compound.refSpectrums'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00002'
  currentMap['name'] = 'refSpectrums'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')
  # End of Compound

  currentMap = abstractTypes.get('Compound')
  aList = ['code']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'mixtureComponents']
  currentMap['simpleAttrs'] = aList
  aList = ['refSpectrums', 'molecule', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['refSpectrums']
  currentMap['children'] = aList

  # Class ExperimentHit
  currentMap = {}
  abstractTypes['ExperimentHit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00013'] = currentMap
  loadMaps['NMRS.ExperimentHit'] = currentMap
  currentMap['tag'] = 'NMRS.ExperimentHit'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00013'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'experimentHits'
  currentMap['objkey'] = 'trialExperiment'
  currentMap['class'] = ccp.api.nmr.NmrScreen.ExperimentHit
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ExperimentHit.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ExperimentHit.figOfMerit
  currentMap = {}
  contentMap['figOfMerit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00010'] = currentMap
  loadMaps['NMRS.ExperimentHit.figOfMerit'] = currentMap
  currentMap['tag'] = 'NMRS.ExperimentHit.figOfMerit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00010'
  currentMap['name'] = 'figOfMerit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute ExperimentHit.meritCode
  currentMap = {}
  contentMap['meritCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00011'] = currentMap
  loadMaps['NMRS.ExperimentHit.meritCode'] = currentMap
  currentMap['tag'] = 'NMRS.ExperimentHit.meritCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00011'
  currentMap['name'] = 'meritCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ExperimentHit.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ExperimentHit.trialExperiment
  currentMap = {}
  contentMap['trialExperiment'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00009'] = currentMap
  loadMaps['NMRS.ExperimentHit.trialExperiment'] = currentMap
  currentMap['tag'] = 'NMRS.ExperimentHit.trialExperiment'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00009'
  currentMap['name'] = 'trialExperiment'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ExperimentHit

  currentMap = abstractTypes.get('ExperimentHit')
  aList = ['figOfMerit', 'meritCode']
  currentMap['headerAttrs'] = aList
  aList = ['trialExperiment']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Mixture
  currentMap = {}
  abstractTypes['Mixture'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00007'] = currentMap
  loadMaps['NMRS.Mixture'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00007'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'mixtures'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.Mixture
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Mixture.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Mixture.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00021'] = currentMap
  loadMaps['NMRS.Mixture.details'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00021'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute Mixture.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00017'] = currentMap
  loadMaps['NMRS.Mixture.name'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00017'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Mixture.pH
  currentMap = {}
  contentMap['pH'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00019'] = currentMap
  loadMaps['NMRS.Mixture.pH'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.pH'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00019'
  currentMap['name'] = 'pH'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Mixture.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00016'] = currentMap
  loadMaps['NMRS.Mixture.serial'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00016'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Mixture.solvent
  currentMap = {}
  contentMap['solvent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00020'] = currentMap
  loadMaps['NMRS.Mixture.solvent'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.solvent'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00020'
  currentMap['name'] = 'solvent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005')

  # Attribute Mixture.volume
  currentMap = {}
  contentMap['volume'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00018'] = currentMap
  loadMaps['NMRS.Mixture.volume'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.volume'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00018'
  currentMap['name'] = 'volume'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Role Mixture.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Mixture.mixtureComponents
  currentMap = {}
  contentMap['mixtureComponents'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00013'] = currentMap
  loadMaps['NMRS.Mixture.mixtureComponents'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.mixtureComponents'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00013'
  currentMap['name'] = 'mixtureComponents'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role Mixture.sample
  currentMap = {}
  contentMap['sample'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:57_00001'] = currentMap
  loadMaps['NMRS.Mixture.sample'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.sample'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:57_00001'
  currentMap['name'] = 'sample'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('SAM').get('exolinks')

  # Role Mixture.trials
  currentMap = {}
  contentMap['trials'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00015'] = currentMap
  loadMaps['NMRS.Mixture.trials'] = currentMap
  currentMap['tag'] = 'NMRS.Mixture.trials'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00015'
  currentMap['name'] = 'trials'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of Mixture

  currentMap = abstractTypes.get('Mixture')
  aList = ['pH', 'serial', 'volume']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'solvent', 'trials']
  currentMap['simpleAttrs'] = aList
  aList = ['mixtureComponents', 'sample', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['mixtureComponents']
  currentMap['children'] = aList

  # Class MixtureComponent
  currentMap = {}
  abstractTypes['MixtureComponent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00008'] = currentMap
  loadMaps['NMRS.MixtureComponent'] = currentMap
  currentMap['tag'] = 'NMRS.MixtureComponent'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'mixtureComponents'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.MixtureComponent
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute MixtureComponent.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute MixtureComponent.concentration
  currentMap = {}
  contentMap['concentration'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00025'] = currentMap
  loadMaps['NMRS.MixtureComponent.concentration'] = currentMap
  currentMap['tag'] = 'NMRS.MixtureComponent.concentration'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00025'
  currentMap['name'] = 'concentration'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute MixtureComponent.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00024'] = currentMap
  loadMaps['NMRS.MixtureComponent.serial'] = currentMap
  currentMap['tag'] = 'NMRS.MixtureComponent.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00024'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role MixtureComponent.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role MixtureComponent.compound
  currentMap = {}
  contentMap['compound'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00003'] = currentMap
  loadMaps['NMRS.MixtureComponent.compound'] = currentMap
  currentMap['tag'] = 'NMRS.MixtureComponent.compound'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00003'
  currentMap['name'] = 'compound'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role MixtureComponent.trialHits
  currentMap = {}
  contentMap['trialHits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00023'] = currentMap
  loadMaps['NMRS.MixtureComponent.trialHits'] = currentMap
  currentMap['tag'] = 'NMRS.MixtureComponent.trialHits'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00023'
  currentMap['name'] = 'trialHits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of MixtureComponent

  currentMap = abstractTypes.get('MixtureComponent')
  aList = ['concentration', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['trialHits']
  currentMap['simpleAttrs'] = aList
  aList = ['compound']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class NmrScreen
  currentMap = {}
  abstractTypes['NmrScreen'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00006'] = currentMap
  loadMaps['NMRS.NmrScreen'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00006'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'nmrScreens'
  currentMap['objkey'] = 'code'
  currentMap['class'] = ccp.api.nmr.NmrScreen.NmrScreen
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NmrScreen.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NmrScreen.code
  currentMap = {}
  contentMap['code'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00034'] = currentMap
  loadMaps['NMRS.NmrScreen.code'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.code'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00034'
  currentMap['name'] = 'code'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute NmrScreen.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00040'] = currentMap
  loadMaps['NMRS.NmrScreen.details'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00040'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute NmrScreen.endDate
  currentMap = {}
  contentMap['endDate'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00039'] = currentMap
  loadMaps['NMRS.NmrScreen.endDate'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.endDate'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00039'
  currentMap['name'] = 'endDate'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00029')

  # Attribute NmrScreen.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00035'] = currentMap
  loadMaps['NMRS.NmrScreen.name'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00035'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute NmrScreen.objective
  currentMap = {}
  contentMap['objective'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00037'] = currentMap
  loadMaps['NMRS.NmrScreen.objective'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.objective'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00037'
  currentMap['name'] = 'objective'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute NmrScreen.sampleType
  currentMap = {}
  contentMap['sampleType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00036'] = currentMap
  loadMaps['NMRS.NmrScreen.sampleType'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.sampleType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00036'
  currentMap['name'] = 'sampleType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute NmrScreen.startDate
  currentMap = {}
  contentMap['startDate'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00038'] = currentMap
  loadMaps['NMRS.NmrScreen.startDate'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.startDate'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00038'
  currentMap['name'] = 'startDate'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00029')

  # Role NmrScreen.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NmrScreen.mixtures
  currentMap = {}
  contentMap['mixtures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00027'] = currentMap
  loadMaps['NMRS.NmrScreen.mixtures'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.mixtures'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00027'
  currentMap['name'] = 'mixtures'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role NmrScreen.target
  currentMap = {}
  contentMap['target'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00033'] = currentMap
  loadMaps['NMRS.NmrScreen.target'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.target'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00033'
  currentMap['name'] = 'target'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role NmrScreen.trialGroups
  currentMap = {}
  contentMap['trialGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00031'] = currentMap
  loadMaps['NMRS.NmrScreen.trialGroups'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.trialGroups'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00031'
  currentMap['name'] = 'trialGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role NmrScreen.trials
  currentMap = {}
  contentMap['trials'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00029'] = currentMap
  loadMaps['NMRS.NmrScreen.trials'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreen.trials'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00029'
  currentMap['name'] = 'trials'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')
  # End of NmrScreen

  currentMap = abstractTypes.get('NmrScreen')
  aList = ['code']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'endDate', 'name', 'objective', 'sampleType', 'startDate']
  currentMap['simpleAttrs'] = aList
  aList = ['trials', 'trialGroups', 'mixtures', 'target', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['mixtures', 'trialGroups', 'trials']
  currentMap['children'] = aList

  # Class NmrScreenStore
  currentMap = {}
  abstractTypes['NmrScreenStore'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00002'] = currentMap
  loadMaps['NMRS.NmrScreenStore'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreenStore'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'nmrScreenStores'
  currentMap['isTop'] = True
  currentMap['objkey'] = 'code'
  currentMap['class'] = ccp.api.nmr.NmrScreen.NmrScreenStore
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NmrScreenStore.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NmrScreenStore.code
  currentMap = {}
  contentMap['code'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00045'] = currentMap
  loadMaps['NMRS.NmrScreenStore.code'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreenStore.code'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00045'
  currentMap['name'] = 'code'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute NmrScreenStore.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NmrScreenStore.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute NmrScreenStore.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NmrScreenStore.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NmrScreenStore.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00046'] = currentMap
  loadMaps['NMRS.NmrScreenStore.name'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreenStore.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00046'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Role NmrScreenStore.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NmrScreenStore.compounds
  currentMap = {}
  contentMap['compounds'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00042'] = currentMap
  loadMaps['NMRS.NmrScreenStore.compounds'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreenStore.compounds'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00042'
  currentMap['name'] = 'compounds'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role NmrScreenStore.nmrScreens
  currentMap = {}
  contentMap['nmrScreens'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00044'] = currentMap
  loadMaps['NMRS.NmrScreenStore.nmrScreens'] = currentMap
  currentMap['tag'] = 'NMRS.NmrScreenStore.nmrScreens'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00044'
  currentMap['name'] = 'nmrScreens'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')
  # End of NmrScreenStore

  currentMap = abstractTypes.get('NmrScreenStore')
  aList = ['code', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy']
  currentMap['headerAttrs'] = aList
  aList = ['name']
  currentMap['simpleAttrs'] = aList
  aList = ['nmrScreens', 'compounds', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['compounds', 'nmrScreens']
  currentMap['children'] = aList

  # Class RefSpectrum
  currentMap = {}
  abstractTypes['RefSpectrum'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00004'] = currentMap
  loadMaps['NMRS.RefSpectrum'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'refSpectrums'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.RefSpectrum
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute RefSpectrum.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute RefSpectrum.concentration
  currentMap = {}
  contentMap['concentration'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00053'] = currentMap
  loadMaps['NMRS.RefSpectrum.concentration'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.concentration'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00053'
  currentMap['name'] = 'concentration'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute RefSpectrum.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00056'] = currentMap
  loadMaps['NMRS.RefSpectrum.details'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00056'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute RefSpectrum.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00052'] = currentMap
  loadMaps['NMRS.RefSpectrum.name'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00052'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute RefSpectrum.pH
  currentMap = {}
  contentMap['pH'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00054'] = currentMap
  loadMaps['NMRS.RefSpectrum.pH'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.pH'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00054'
  currentMap['name'] = 'pH'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute RefSpectrum.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00051'] = currentMap
  loadMaps['NMRS.RefSpectrum.serial'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00051'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute RefSpectrum.solvent
  currentMap = {}
  contentMap['solvent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00055'] = currentMap
  loadMaps['NMRS.RefSpectrum.solvent'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.solvent'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00055'
  currentMap['name'] = 'solvent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005')

  # Role RefSpectrum.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role RefSpectrum.dataSource
  currentMap = {}
  contentMap['dataSource'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00050'] = currentMap
  loadMaps['NMRS.RefSpectrum.dataSource'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.dataSource'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00050'
  currentMap['name'] = 'dataSource'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMR').get('exolinks')

  # Role RefSpectrum.trialHits
  currentMap = {}
  contentMap['trialHits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00048'] = currentMap
  loadMaps['NMRS.RefSpectrum.trialHits'] = currentMap
  currentMap['tag'] = 'NMRS.RefSpectrum.trialHits'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00048'
  currentMap['name'] = 'trialHits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of RefSpectrum

  currentMap = abstractTypes.get('RefSpectrum')
  aList = ['concentration', 'pH', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'solvent', 'trialHits']
  currentMap['simpleAttrs'] = aList
  aList = ['dataSource', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Trial
  currentMap = {}
  abstractTypes['Trial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00009'] = currentMap
  loadMaps['NMRS.Trial'] = currentMap
  currentMap['tag'] = 'NMRS.Trial'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00009'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'trials'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.Trial
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Trial.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Trial.date
  currentMap = {}
  contentMap['date'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00009'] = currentMap
  loadMaps['NMRS.Trial.date'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.date'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00009'
  currentMap['name'] = 'date'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00029')

  # Attribute Trial.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00010'] = currentMap
  loadMaps['NMRS.Trial.details'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00010'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute Trial.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00008'] = currentMap
  loadMaps['NMRS.Trial.name'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00008'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Trial.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00007'] = currentMap
  loadMaps['NMRS.Trial.serial'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00007'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role Trial.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Trial.mixture
  currentMap = {}
  contentMap['mixture'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00014'] = currentMap
  loadMaps['NMRS.Trial.mixture'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.mixture'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00014'
  currentMap['name'] = 'mixture'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role Trial.trialExperiments
  currentMap = {}
  contentMap['trialExperiments'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00006'] = currentMap
  loadMaps['NMRS.Trial.trialExperiments'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.trialExperiments'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00006'
  currentMap['name'] = 'trialExperiments'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role Trial.trialGroups
  currentMap = {}
  contentMap['trialGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00004'] = currentMap
  loadMaps['NMRS.Trial.trialGroups'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.trialGroups'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00004'
  currentMap['name'] = 'trialGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Trial.trialHits
  currentMap = {}
  contentMap['trialHits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00002'] = currentMap
  loadMaps['NMRS.Trial.trialHits'] = currentMap
  currentMap['tag'] = 'NMRS.Trial.trialHits'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00002'
  currentMap['name'] = 'trialHits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')
  # End of Trial

  currentMap = abstractTypes.get('Trial')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['date', 'details', 'name', 'trialGroups']
  currentMap['simpleAttrs'] = aList
  aList = ['mixture']
  currentMap['optLinks'] = aList
  aList = ['trialHits', 'trialExperiments', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['trialExperiments', 'trialHits']
  currentMap['children'] = aList

  # Class TrialExperiment
  currentMap = {}
  abstractTypes['TrialExperiment'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00012'] = currentMap
  loadMaps['NMRS.TrialExperiment'] = currentMap
  currentMap['tag'] = 'NMRS.TrialExperiment'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00012'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'trialExperiments'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.TrialExperiment
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute TrialExperiment.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute TrialExperiment.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00015'] = currentMap
  loadMaps['NMRS.TrialExperiment.details'] = currentMap
  currentMap['tag'] = 'NMRS.TrialExperiment.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00015'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute TrialExperiment.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00014'] = currentMap
  loadMaps['NMRS.TrialExperiment.name'] = currentMap
  currentMap['tag'] = 'NMRS.TrialExperiment.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00014'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute TrialExperiment.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00013'] = currentMap
  loadMaps['NMRS.TrialExperiment.serial'] = currentMap
  currentMap['tag'] = 'NMRS.TrialExperiment.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00013'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role TrialExperiment.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role TrialExperiment.dataSources
  currentMap = {}
  contentMap['dataSources'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00012'] = currentMap
  loadMaps['NMRS.TrialExperiment.dataSources'] = currentMap
  currentMap['tag'] = 'NMRS.TrialExperiment.dataSources'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00012'
  currentMap['name'] = 'dataSources'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMR').get('exolinks')

  # Role TrialExperiment.experimentHits
  currentMap = {}
  contentMap['experimentHits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00008'] = currentMap
  loadMaps['NMRS.TrialExperiment.experimentHits'] = currentMap
  currentMap['tag'] = 'NMRS.TrialExperiment.experimentHits'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00008'
  currentMap['name'] = 'experimentHits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of TrialExperiment

  currentMap = abstractTypes.get('TrialExperiment')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'experimentHits']
  currentMap['simpleAttrs'] = aList
  aList = ['dataSources', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class TrialGroup
  currentMap = {}
  abstractTypes['TrialGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00011'] = currentMap
  loadMaps['NMRS.TrialGroup'] = currentMap
  currentMap['tag'] = 'NMRS.TrialGroup'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'trialGroups'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.TrialGroup
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute TrialGroup.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute TrialGroup.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00018'] = currentMap
  loadMaps['NMRS.TrialGroup.details'] = currentMap
  currentMap['tag'] = 'NMRS.TrialGroup.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00018'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute TrialGroup.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00017'] = currentMap
  loadMaps['NMRS.TrialGroup.name'] = currentMap
  currentMap['tag'] = 'NMRS.TrialGroup.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00017'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute TrialGroup.phaseType
  currentMap = {}
  contentMap['phaseType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00019'] = currentMap
  loadMaps['NMRS.TrialGroup.phaseType'] = currentMap
  currentMap['tag'] = 'NMRS.TrialGroup.phaseType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00019'
  currentMap['name'] = 'phaseType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute TrialGroup.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00016'] = currentMap
  loadMaps['NMRS.TrialGroup.serial'] = currentMap
  currentMap['tag'] = 'NMRS.TrialGroup.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00016'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role TrialGroup.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role TrialGroup.trials
  currentMap = {}
  contentMap['trials'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00003'] = currentMap
  loadMaps['NMRS.TrialGroup.trials'] = currentMap
  currentMap['tag'] = 'NMRS.TrialGroup.trials'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00003'
  currentMap['name'] = 'trials'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of TrialGroup

  currentMap = abstractTypes.get('TrialGroup')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'name', 'phaseType', 'trials']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class TrialHit
  currentMap = {}
  abstractTypes['TrialHit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00010'] = currentMap
  loadMaps['NMRS.TrialHit'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'trialHits'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.nmr.NmrScreen.TrialHit
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute TrialHit.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute TrialHit.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00025'] = currentMap
  loadMaps['NMRS.TrialHit.details'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00025'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute TrialHit.figOfMerit
  currentMap = {}
  contentMap['figOfMerit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00023'] = currentMap
  loadMaps['NMRS.TrialHit.figOfMerit'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.figOfMerit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00023'
  currentMap['name'] = 'figOfMerit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute TrialHit.meritCode
  currentMap = {}
  contentMap['meritCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00024'] = currentMap
  loadMaps['NMRS.TrialHit.meritCode'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.meritCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00024'
  currentMap['name'] = 'meritCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute TrialHit.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00022'] = currentMap
  loadMaps['NMRS.TrialHit.serial'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00022'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role TrialHit.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role TrialHit.experimentHits
  currentMap = {}
  contentMap['experimentHits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00021'] = currentMap
  loadMaps['NMRS.TrialHit.experimentHits'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.experimentHits'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00021'
  currentMap['name'] = 'experimentHits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('NMRS').get('abstractTypes')

  # Role TrialHit.mixtureComponent
  currentMap = {}
  contentMap['mixtureComponent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00022'] = currentMap
  loadMaps['NMRS.TrialHit.mixtureComponent'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.mixtureComponent'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00022'
  currentMap['name'] = 'mixtureComponent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role TrialHit.refSpectrums
  currentMap = {}
  contentMap['refSpectrums'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00047'] = currentMap
  loadMaps['NMRS.TrialHit.refSpectrums'] = currentMap
  currentMap['tag'] = 'NMRS.TrialHit.refSpectrums'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00047'
  currentMap['name'] = 'refSpectrums'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of TrialHit

  currentMap = abstractTypes.get('TrialHit')
  aList = ['figOfMerit', 'meritCode', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['details', 'refSpectrums']
  currentMap['simpleAttrs'] = aList
  aList = ['mixtureComponent']
  currentMap['optLinks'] = aList
  aList = ['experimentHits', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['experimentHits']
  currentMap['children'] = aList

  # Out-of-package link to Compound
  currentMap = {}
  exolinks['Compound'] = currentMap
  loadMaps['NMRS.exo-Compound'] = currentMap
  currentMap['tag'] = 'NMRS.exo-Compound'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00003'
  currentMap['name'] = 'Compound'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.Compound
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to ExperimentHit
  currentMap = {}
  exolinks['ExperimentHit'] = currentMap
  loadMaps['NMRS.exo-ExperimentHit'] = currentMap
  currentMap['tag'] = 'NMRS.exo-ExperimentHit'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00013'
  currentMap['name'] = 'ExperimentHit'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.ExperimentHit
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('NMRS').get('exolinks'))

  # Out-of-package link to Mixture
  currentMap = {}
  exolinks['Mixture'] = currentMap
  loadMaps['NMRS.exo-Mixture'] = currentMap
  currentMap['tag'] = 'NMRS.exo-Mixture'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00007'
  currentMap['name'] = 'Mixture'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.Mixture
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to MixtureComponent
  currentMap = {}
  exolinks['MixtureComponent'] = currentMap
  loadMaps['NMRS.exo-MixtureComponent'] = currentMap
  currentMap['tag'] = 'NMRS.exo-MixtureComponent'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00008'
  currentMap['name'] = 'MixtureComponent'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.MixtureComponent
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to NmrScreen
  currentMap = {}
  exolinks['NmrScreen'] = currentMap
  loadMaps['NMRS.exo-NmrScreen'] = currentMap
  currentMap['tag'] = 'NMRS.exo-NmrScreen'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00006'
  currentMap['name'] = 'NmrScreen'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.NmrScreen
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to NmrScreenStore
  currentMap = {}
  exolinks['NmrScreenStore'] = currentMap
  loadMaps['NMRS.exo-NmrScreenStore'] = currentMap
  currentMap['tag'] = 'NMRS.exo-NmrScreenStore'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00002'
  currentMap['name'] = 'NmrScreenStore'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.NmrScreenStore
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))

  # Out-of-package link to RefSpectrum
  currentMap = {}
  exolinks['RefSpectrum'] = currentMap
  loadMaps['NMRS.exo-RefSpectrum'] = currentMap
  currentMap['tag'] = 'NMRS.exo-RefSpectrum'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00004'
  currentMap['name'] = 'RefSpectrum'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.RefSpectrum
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to Trial
  currentMap = {}
  exolinks['Trial'] = currentMap
  loadMaps['NMRS.exo-Trial'] = currentMap
  currentMap['tag'] = 'NMRS.exo-Trial'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00009'
  currentMap['name'] = 'Trial'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.Trial
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to TrialExperiment
  currentMap = {}
  exolinks['TrialExperiment'] = currentMap
  loadMaps['NMRS.exo-TrialExperiment'] = currentMap
  currentMap['tag'] = 'NMRS.exo-TrialExperiment'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00012'
  currentMap['name'] = 'TrialExperiment'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.TrialExperiment
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to TrialGroup
  currentMap = {}
  exolinks['TrialGroup'] = currentMap
  loadMaps['NMRS.exo-TrialGroup'] = currentMap
  currentMap['tag'] = 'NMRS.exo-TrialGroup'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00011'
  currentMap['name'] = 'TrialGroup'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.TrialGroup
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to TrialHit
  currentMap = {}
  exolinks['TrialHit'] = currentMap
  loadMaps['NMRS.exo-TrialHit'] = currentMap
  currentMap['tag'] = 'NMRS.exo-TrialHit'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00010'
  currentMap['name'] = 'TrialHit'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.nmr.NmrScreen.TrialHit
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
