"""
#######################################################################

CCPN Data Model version 2.0.6

Autogenerated by PyXmlMapWrite revision 1.29 on Wed Aug  7 15:06:04 2013
  from data model element ccp.molecule.ChemComp revision 1.49

#######################################################################
======================COPYRIGHT/LICENSE START==========================

ChemComp.py: python XML-I/O-mapping for CCPN data model, MetaPackage ccp.molecule.ChemComp

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import ccp.api.molecule.ChemComp

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package CHEM, adding it to globalMap
  """
  
  from memops.xml.Implementation import bool2str, str2bool

  # Set up top level dictionaries
  loadMaps = globalMap.get('loadMaps')
  mapsByGuid = globalMap.get('mapsByGuid')

  abstractTypes = globalMap.get('CHEM').get('abstractTypes')
  exolinks = globalMap.get('CHEM').get('exolinks')

  # DataType AtomChirality
  currentMap = {}
  abstractTypes['AtomChirality'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00027'] = currentMap
  loadMaps['CHEM.AtomChirality'] = currentMap
  currentMap['tag'] = 'CHEM.AtomChirality'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00027'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType BondStereochemistry
  currentMap = {}
  abstractTypes['BondStereochemistry'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00026'] = currentMap
  loadMaps['CHEM.BondStereochemistry'] = currentMap
  currentMap['tag'] = 'CHEM.BondStereochemistry'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00026'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType BondType
  currentMap = {}
  abstractTypes['BondType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00039'] = currentMap
  loadMaps['CHEM.BondType'] = currentMap
  currentMap['tag'] = 'CHEM.BondType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00039'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ChemCompLinking
  currentMap = {}
  abstractTypes['ChemCompLinking'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00025'] = currentMap
  loadMaps['CHEM.ChemCompLinking'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompLinking'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00025'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType MolType
  currentMap = {}
  abstractTypes['MolType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00024'] = currentMap
  loadMaps['CHEM.MolType'] = currentMap
  currentMap['tag'] = 'CHEM.MolType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00024'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ThreeLetterCode
  currentMap = {}
  abstractTypes['ThreeLetterCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00023'] = currentMap
  loadMaps['CHEM.ThreeLetterCode'] = currentMap
  currentMap['tag'] = 'CHEM.ThreeLetterCode'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00023'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType TwelveLetterCode
  currentMap = {}
  abstractTypes['TwelveLetterCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00013'] = currentMap
  loadMaps['CHEM.TwelveLetterCode'] = currentMap
  currentMap['tag'] = 'CHEM.TwelveLetterCode'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00013'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # Class AbstractChemAtom
  currentMap = {}
  abstractTypes['AbstractChemAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00001'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemAtoms'
  currentMap['class'] = ccp.api.molecule.ChemComp.AbstractChemAtom
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractChemAtom.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractChemAtom.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00019'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.name'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00019'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AbstractChemAtom.subType
  currentMap = {}
  contentMap['subType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00021'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.subType'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.subType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00021'
  currentMap['name'] = 'subType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AbstractChemAtom.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AbstractChemAtom.chemAngles
  currentMap = {}
  contentMap['chemAngles'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00015'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.chemAngles'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.chemAngles'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00015'
  currentMap['name'] = 'chemAngles'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role AbstractChemAtom.chemBonds
  currentMap = {}
  contentMap['chemBonds'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00003'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.chemBonds'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.chemBonds'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00003'
  currentMap['name'] = 'chemBonds'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role AbstractChemAtom.chemCompVars
  currentMap = {}
  contentMap['chemCompVars'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00018'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.chemCompVars'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.chemCompVars'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00018'
  currentMap['name'] = 'chemCompVars'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AbstractChemAtom.chemTorsions
  currentMap = {}
  contentMap['chemTorsions'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00017'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.chemTorsions'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.chemTorsions'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00017'
  currentMap['name'] = 'chemTorsions'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role AbstractChemAtom.stereochemistries
  currentMap = {}
  contentMap['stereochemistries'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00001'] = currentMap
  loadMaps['CHEM.AbstractChemAtom.stereochemistries'] = currentMap
  currentMap['tag'] = 'CHEM.AbstractChemAtom.stereochemistries'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00001'
  currentMap['name'] = 'stereochemistries'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of AbstractChemAtom

  currentMap = abstractTypes.get('AbstractChemAtom')
  aList = ['name', 'subType']
  currentMap['headerAttrs'] = aList
  aList = ['chemAngles', 'chemBonds', 'chemCompVars', 'chemTorsions', 'stereochemistries']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AtomSysName
  currentMap = {}
  abstractTypes['AtomSysName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00002'] = currentMap
  loadMaps['CHEM.AtomSysName'] = currentMap
  currentMap['tag'] = 'CHEM.AtomSysName'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'atomSysNames'
  currentMap['class'] = ccp.api.molecule.ChemComp.AtomSysName
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AtomSysName.altSysNames
  currentMap = {}
  contentMap['altSysNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00029'] = currentMap
  loadMaps['CHEM.AtomSysName.altSysNames'] = currentMap
  currentMap['tag'] = 'CHEM.AtomSysName.altSysNames'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00029'
  currentMap['name'] = 'altSysNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AtomSysName.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AtomSysName.atomName
  currentMap = {}
  contentMap['atomName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00026'] = currentMap
  loadMaps['CHEM.AtomSysName.atomName'] = currentMap
  currentMap['tag'] = 'CHEM.AtomSysName.atomName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00026'
  currentMap['name'] = 'atomName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AtomSysName.atomSubType
  currentMap = {}
  contentMap['atomSubType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00027'] = currentMap
  loadMaps['CHEM.AtomSysName.atomSubType'] = currentMap
  currentMap['tag'] = 'CHEM.AtomSysName.atomSubType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00027'
  currentMap['name'] = 'atomSubType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AtomSysName.sysName
  currentMap = {}
  contentMap['sysName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00028'] = currentMap
  loadMaps['CHEM.AtomSysName.sysName'] = currentMap
  currentMap['tag'] = 'CHEM.AtomSysName.sysName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00028'
  currentMap['name'] = 'sysName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Role AtomSysName.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of AtomSysName

  currentMap = abstractTypes.get('AtomSysName')
  aList = ['atomName', 'atomSubType']
  currentMap['headerAttrs'] = aList
  aList = ['altSysNames', 'sysName']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemAngle
  currentMap = {}
  abstractTypes['ChemAngle'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00054'] = currentMap
  loadMaps['CHEM.ChemAngle'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAngle'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00054'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemAngles'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemAngle
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemAngle.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Role ChemAngle.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemAngle.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00016'] = currentMap
  loadMaps['CHEM.ChemAngle.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAngle.chemAtoms'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00016'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = 3
  currentMap['locard'] = 3
  currentMap['copyOverride'] = True
  # End of ChemAngle

  currentMap = abstractTypes.get('ChemAngle')
  aList = ['chemAtoms']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemAtomSet
  currentMap = {}
  abstractTypes['ChemAtomSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00014'] = currentMap
  loadMaps['CHEM.ChemAtomSet'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00014'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemAtomSets'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemAtomSet
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemAtomSet.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemAtomSet.distCorr
  currentMap = {}
  contentMap['distCorr'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00043'] = currentMap
  loadMaps['CHEM.ChemAtomSet.distCorr'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.distCorr'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00043'
  currentMap['name'] = 'distCorr'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute ChemAtomSet.isEquivalent
  currentMap = {}
  contentMap['isEquivalent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00041'] = currentMap
  loadMaps['CHEM.ChemAtomSet.isEquivalent'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.isEquivalent'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00041'
  currentMap['name'] = 'isEquivalent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ChemAtomSet.isProchiral
  currentMap = {}
  contentMap['isProchiral'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00042'] = currentMap
  loadMaps['CHEM.ChemAtomSet.isProchiral'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.isProchiral'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00042'
  currentMap['name'] = 'isProchiral'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ChemAtomSet.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00038'] = currentMap
  loadMaps['CHEM.ChemAtomSet.name'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00038'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ChemAtomSet.subType
  currentMap = {}
  contentMap['subType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00040'] = currentMap
  loadMaps['CHEM.ChemAtomSet.subType'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.subType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00040'
  currentMap['name'] = 'subType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ChemAtomSet.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemAtomSet.chemAtomSet
  currentMap = {}
  contentMap['chemAtomSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00031'] = currentMap
  loadMaps['CHEM.ChemAtomSet.chemAtomSet'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.chemAtomSet'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00031'
  currentMap['name'] = 'chemAtomSet'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role ChemAtomSet.chemAtomSets
  currentMap = {}
  contentMap['chemAtomSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00032'] = currentMap
  loadMaps['CHEM.ChemAtomSet.chemAtomSets'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.chemAtomSets'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00032'
  currentMap['name'] = 'chemAtomSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ChemAtomSet.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00034'] = currentMap
  loadMaps['CHEM.ChemAtomSet.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtomSet.chemAtoms'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00034'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of ChemAtomSet

  currentMap = abstractTypes.get('ChemAtomSet')
  aList = ['distCorr', 'isEquivalent', 'isProchiral', 'name', 'subType']
  currentMap['headerAttrs'] = aList
  aList = ['chemAtomSets', 'chemAtoms']
  currentMap['simpleAttrs'] = aList
  aList = ['chemAtomSet']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemBond
  currentMap = {}
  abstractTypes['ChemBond'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00003'] = currentMap
  loadMaps['CHEM.ChemBond'] = currentMap
  currentMap['tag'] = 'CHEM.ChemBond'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemBonds'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemBond
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemBond.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemBond.bondType
  currentMap = {}
  contentMap['bondType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00007'] = currentMap
  loadMaps['CHEM.ChemBond.bondType'] = currentMap
  currentMap['tag'] = 'CHEM.ChemBond.bondType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00007'
  currentMap['name'] = 'bondType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'single'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00039')

  # Attribute ChemBond.stereochem
  currentMap = {}
  contentMap['stereochem'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00008'] = currentMap
  loadMaps['CHEM.ChemBond.stereochem'] = currentMap
  currentMap['tag'] = 'CHEM.ChemBond.stereochem'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00008'
  currentMap['name'] = 'stereochem'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00026')

  # Role ChemBond.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemBond.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00004'] = currentMap
  loadMaps['CHEM.ChemBond.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.ChemBond.chemAtoms'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00004'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['copyOverride'] = True
  # End of ChemBond

  currentMap = abstractTypes.get('ChemBond')
  aList = ['bondType', 'stereochem']
  currentMap['headerAttrs'] = aList
  aList = ['chemAtoms']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemComp
  currentMap = {}
  abstractTypes['ChemComp'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00047'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00047'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemComps'
  currentMap['isTop'] = True
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemComp
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemComp.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemComp.baseGlycoCtCode
  currentMap = {}
  contentMap['baseGlycoCtCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-02-13:31:25_00001'] = currentMap
  loadMaps['CHEM.ChemComp.baseGlycoCtCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.baseGlycoCtCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-02-13:31:25_00001'
  currentMap['name'] = 'baseGlycoCtCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute ChemComp.beilsteinCode
  currentMap = {}
  contentMap['beilsteinCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00004'] = currentMap
  loadMaps['CHEM.ChemComp.beilsteinCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.beilsteinCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00004'
  currentMap['name'] = 'beilsteinCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ChemComp.casRegCode
  currentMap = {}
  contentMap['casRegCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00005'] = currentMap
  loadMaps['CHEM.ChemComp.casRegCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.casRegCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00005'
  currentMap['name'] = 'casRegCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ChemComp.ccpCode
  currentMap = {}
  contentMap['ccpCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00007'] = currentMap
  loadMaps['CHEM.ChemComp.ccpCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.ccpCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00007'
  currentMap['name'] = 'ccpCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003')

  # Attribute ChemComp.code3Letter
  currentMap = {}
  contentMap['code3Letter'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00009'] = currentMap
  loadMaps['CHEM.ChemComp.code3Letter'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.code3Letter'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00009'
  currentMap['name'] = 'code3Letter'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00023')

  # Attribute ChemComp.commonNames
  currentMap = {}
  contentMap['commonNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00013'] = currentMap
  loadMaps['CHEM.ChemComp.commonNames'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.commonNames'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00013'
  currentMap['name'] = 'commonNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute ChemComp.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute ChemComp.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00006'] = currentMap
  loadMaps['CHEM.ChemComp.details'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00006'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute ChemComp.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute ChemComp.hasStdChirality
  currentMap = {}
  contentMap['hasStdChirality'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00007'] = currentMap
  loadMaps['CHEM.ChemComp.hasStdChirality'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.hasStdChirality'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00007'
  currentMap['name'] = 'hasStdChirality'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ChemComp.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute ChemComp.keywords
  currentMap = {}
  contentMap['keywords'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00001'] = currentMap
  loadMaps['CHEM.ChemComp.keywords'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.keywords'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00001'
  currentMap['name'] = 'keywords'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChemComp.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute ChemComp.merckCode
  currentMap = {}
  contentMap['merckCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00002'] = currentMap
  loadMaps['CHEM.ChemComp.merckCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.merckCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00002'
  currentMap['name'] = 'merckCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ChemComp.molType
  currentMap = {}
  contentMap['molType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00006'] = currentMap
  loadMaps['CHEM.ChemComp.molType'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.molType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00006'
  currentMap['name'] = 'molType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00024')

  # Attribute ChemComp.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00008'] = currentMap
  loadMaps['CHEM.ChemComp.name'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00008'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute ChemComp.sigmaAldrichCode
  currentMap = {}
  contentMap['sigmaAldrichCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00003'] = currentMap
  loadMaps['CHEM.ChemComp.sigmaAldrichCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.sigmaAldrichCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00003'
  currentMap['name'] = 'sigmaAldrichCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ChemComp.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemComp.chemAngles
  currentMap = {}
  contentMap['chemAngles'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00001'] = currentMap
  loadMaps['CHEM.ChemComp.chemAngles'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.chemAngles'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00001'
  currentMap['name'] = 'chemAngles'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.chemAtomSets
  currentMap = {}
  contentMap['chemAtomSets'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00005'] = currentMap
  loadMaps['CHEM.ChemComp.chemAtomSets'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.chemAtomSets'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00005'
  currentMap['name'] = 'chemAtomSets'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:19_00013'] = currentMap
  loadMaps['CHEM.ChemComp.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.chemAtoms'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:19_00013'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.chemBonds
  currentMap = {}
  contentMap['chemBonds'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00005'] = currentMap
  loadMaps['CHEM.ChemComp.chemBonds'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.chemBonds'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00005'
  currentMap['name'] = 'chemBonds'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.chemCompVars
  currentMap = {}
  contentMap['chemCompVars'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00010'] = currentMap
  loadMaps['CHEM.ChemComp.chemCompVars'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.chemCompVars'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00010'
  currentMap['name'] = 'chemCompVars'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.chemTorsions
  currentMap = {}
  contentMap['chemTorsions'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00003'] = currentMap
  loadMaps['CHEM.ChemComp.chemTorsions'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.chemTorsions'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00003'
  currentMap['name'] = 'chemTorsions'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.linkEnds
  currentMap = {}
  contentMap['linkEnds'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00005'] = currentMap
  loadMaps['CHEM.ChemComp.linkEnds'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.linkEnds'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00005'
  currentMap['name'] = 'linkEnds'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.namingSystems
  currentMap = {}
  contentMap['namingSystems'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-17:42:27_00002'] = currentMap
  loadMaps['CHEM.ChemComp.namingSystems'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.namingSystems'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-17:42:27_00002'
  currentMap['name'] = 'namingSystems'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role ChemComp.stereochemistries
  currentMap = {}
  contentMap['stereochemistries'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00001'] = currentMap
  loadMaps['CHEM.ChemComp.stereochemistries'] = currentMap
  currentMap['tag'] = 'CHEM.ChemComp.stereochemistries'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00001'
  currentMap['name'] = 'stereochemistries'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')
  # End of ChemComp

  currentMap = abstractTypes.get('ChemComp')
  aList = ['beilsteinCode', 'casRegCode', 'ccpCode', 'code3Letter', 'createdBy', 'guid', 'hasStdChirality', 'isModifiable', 'lastUnlockedBy', 'merckCode', 'molType', 'sigmaAldrichCode']
  currentMap['headerAttrs'] = aList
  aList = ['baseGlycoCtCode', 'commonNames', 'details', 'keywords', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['stereochemistries', 'namingSystems', 'linkEnds', 'chemTorsions', 'chemCompVars', 'chemBonds', 'chemAtoms', 'chemAtomSets', 'chemAngles', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemCompVars', 'chemTorsions', 'linkEnds', 'namingSystems', 'stereochemistries']
  currentMap['children'] = aList

  # Class ChemCompSysName
  currentMap = {}
  abstractTypes['ChemCompSysName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00004'] = currentMap
  loadMaps['CHEM.ChemCompSysName'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompSysName'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemCompSysNames'
  currentMap['objkey'] = 'sysName'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemCompSysName
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemCompSysName.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemCompSysName.sysName
  currentMap = {}
  contentMap['sysName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00017'] = currentMap
  loadMaps['CHEM.ChemCompSysName.sysName'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompSysName.sysName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00017'
  currentMap['name'] = 'sysName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ChemCompSysName.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemCompSysName.specificChemCompVars
  currentMap = {}
  contentMap['specificChemCompVars'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00012'] = currentMap
  loadMaps['CHEM.ChemCompSysName.specificChemCompVars'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompSysName.specificChemCompVars'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00012'
  currentMap['name'] = 'specificChemCompVars'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of ChemCompSysName

  currentMap = abstractTypes.get('ChemCompSysName')
  aList = ['sysName']
  currentMap['headerAttrs'] = aList
  aList = ['specificChemCompVars']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemCompVar
  currentMap = {}
  abstractTypes['ChemCompVar'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00005'] = currentMap
  loadMaps['CHEM.ChemCompVar'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00005'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemCompVars'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemCompVar
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemCompVar.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemCompVar.descriptor
  currentMap = {}
  contentMap['descriptor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00029'] = currentMap
  loadMaps['CHEM.ChemCompVar.descriptor'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.descriptor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00029'
  currentMap['name'] = 'descriptor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChemCompVar.formalCharge
  currentMap = {}
  contentMap['formalCharge'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00040'] = currentMap
  loadMaps['CHEM.ChemCompVar.formalCharge'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.formalCharge'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00040'
  currentMap['name'] = 'formalCharge'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute ChemCompVar.glycoCtCode
  currentMap = {}
  contentMap['glycoCtCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-04-02-13:31:25_00003'] = currentMap
  loadMaps['CHEM.ChemCompVar.glycoCtCode'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.glycoCtCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-04-02-13:31:25_00003'
  currentMap['name'] = 'glycoCtCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute ChemCompVar.isAromatic
  currentMap = {}
  contentMap['isAromatic'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00045'] = currentMap
  loadMaps['CHEM.ChemCompVar.isAromatic'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.isAromatic'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00045'
  currentMap['name'] = 'isAromatic'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ChemCompVar.isDefaultVar
  currentMap = {}
  contentMap['isDefaultVar'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00031'] = currentMap
  loadMaps['CHEM.ChemCompVar.isDefaultVar'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.isDefaultVar'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00031'
  currentMap['name'] = 'isDefaultVar'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ChemCompVar.isParamagnetic
  currentMap = {}
  contentMap['isParamagnetic'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00044'] = currentMap
  loadMaps['CHEM.ChemCompVar.isParamagnetic'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.isParamagnetic'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00044'
  currentMap['name'] = 'isParamagnetic'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute ChemCompVar.linking
  currentMap = {}
  contentMap['linking'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00028'] = currentMap
  loadMaps['CHEM.ChemCompVar.linking'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.linking'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00028'
  currentMap['name'] = 'linking'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00025')

  # Attribute ChemCompVar.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00033'] = currentMap
  loadMaps['CHEM.ChemCompVar.name'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00033'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute ChemCompVar.nonStereoSmiles
  currentMap = {}
  contentMap['nonStereoSmiles'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00042'] = currentMap
  loadMaps['CHEM.ChemCompVar.nonStereoSmiles'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.nonStereoSmiles'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00042'
  currentMap['name'] = 'nonStereoSmiles'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute ChemCompVar.stereoSmiles
  currentMap = {}
  contentMap['stereoSmiles'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00043'] = currentMap
  loadMaps['CHEM.ChemCompVar.stereoSmiles'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.stereoSmiles'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00043'
  currentMap['name'] = 'stereoSmiles'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute ChemCompVar.varName
  currentMap = {}
  contentMap['varName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00034'] = currentMap
  loadMaps['CHEM.ChemCompVar.varName'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.varName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00034'
  currentMap['name'] = 'varName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Role ChemCompVar.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemCompVar.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00017'] = currentMap
  loadMaps['CHEM.ChemCompVar.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.chemAtoms'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00017'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role ChemCompVar.specificSysNames
  currentMap = {}
  contentMap['specificSysNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00011'] = currentMap
  loadMaps['CHEM.ChemCompVar.specificSysNames'] = currentMap
  currentMap['tag'] = 'CHEM.ChemCompVar.specificSysNames'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00011'
  currentMap['name'] = 'specificSysNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of ChemCompVar

  currentMap = abstractTypes.get('ChemCompVar')
  aList = ['formalCharge', 'isAromatic', 'isDefaultVar', 'isParamagnetic', 'linking']
  currentMap['headerAttrs'] = aList
  aList = ['descriptor', 'glycoCtCode', 'nonStereoSmiles', 'stereoSmiles', 'varName', 'chemAtoms', 'specificSysNames']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemTorsion
  currentMap = {}
  abstractTypes['ChemTorsion'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00008'] = currentMap
  loadMaps['CHEM.ChemTorsion'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsion'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemTorsions'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemTorsion
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemTorsion.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemTorsion.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00021'] = currentMap
  loadMaps['CHEM.ChemTorsion.name'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsion.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00021'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ChemTorsion.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemTorsion.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00018'] = currentMap
  loadMaps['CHEM.ChemTorsion.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsion.chemAtoms'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00018'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = 4
  currentMap['locard'] = 4
  currentMap['copyOverride'] = True

  # Role ChemTorsion.sysNames
  currentMap = {}
  contentMap['sysNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00020'] = currentMap
  loadMaps['CHEM.ChemTorsion.sysNames'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsion.sysNames'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00020'
  currentMap['name'] = 'sysNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of ChemTorsion

  currentMap = abstractTypes.get('ChemTorsion')
  aList = ['name']
  currentMap['headerAttrs'] = aList
  aList = ['chemAtoms', 'sysNames']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemTorsionSysName
  currentMap = {}
  abstractTypes['ChemTorsionSysName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00022'] = currentMap
  loadMaps['CHEM.ChemTorsionSysName'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsionSysName'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00022'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemTorsionSysNames'
  currentMap['objkey'] = 'chemTorsion'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemTorsionSysName
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemTorsionSysName.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemTorsionSysName.sysName
  currentMap = {}
  contentMap['sysName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00052'] = currentMap
  loadMaps['CHEM.ChemTorsionSysName.sysName'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsionSysName.sysName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00052'
  currentMap['name'] = 'sysName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ChemTorsionSysName.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemTorsionSysName.chemTorsion
  currentMap = {}
  contentMap['chemTorsion'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00019'] = currentMap
  loadMaps['CHEM.ChemTorsionSysName.chemTorsion'] = currentMap
  currentMap['tag'] = 'CHEM.ChemTorsionSysName.chemTorsion'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00019'
  currentMap['name'] = 'chemTorsion'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of ChemTorsionSysName

  currentMap = abstractTypes.get('ChemTorsionSysName')
  aList = ['sysName']
  currentMap['headerAttrs'] = aList
  aList = ['chemTorsion']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class LinkEnd
  currentMap = {}
  abstractTypes['LinkEnd'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00030'] = currentMap
  loadMaps['CHEM.LinkEnd'] = currentMap
  currentMap['tag'] = 'CHEM.LinkEnd'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00030'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'linkEnds'
  currentMap['objkey'] = 'linkCode'
  currentMap['class'] = ccp.api.molecule.ChemComp.LinkEnd
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute LinkEnd.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute LinkEnd.linkCode
  currentMap = {}
  contentMap['linkCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00024'] = currentMap
  loadMaps['CHEM.LinkEnd.linkCode'] = currentMap
  currentMap['tag'] = 'CHEM.LinkEnd.linkCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00024'
  currentMap['name'] = 'linkCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role LinkEnd.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role LinkEnd.boundChemAtom
  currentMap = {}
  contentMap['boundChemAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00011'] = currentMap
  loadMaps['CHEM.LinkEnd.boundChemAtom'] = currentMap
  currentMap['tag'] = 'CHEM.LinkEnd.boundChemAtom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00011'
  currentMap['name'] = 'boundChemAtom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role LinkEnd.boundLinkAtom
  currentMap = {}
  contentMap['boundLinkAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00013'] = currentMap
  loadMaps['CHEM.LinkEnd.boundLinkAtom'] = currentMap
  currentMap['tag'] = 'CHEM.LinkEnd.boundLinkAtom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00013'
  currentMap['name'] = 'boundLinkAtom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = False

  # Role LinkEnd.remoteChemAtom
  currentMap = {}
  contentMap['remoteChemAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00019'] = currentMap
  loadMaps['CHEM.LinkEnd.remoteChemAtom'] = currentMap
  currentMap['tag'] = 'CHEM.LinkEnd.remoteChemAtom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00019'
  currentMap['name'] = 'remoteChemAtom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role LinkEnd.remoteLinkAtom
  currentMap = {}
  contentMap['remoteLinkAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00021'] = currentMap
  loadMaps['CHEM.LinkEnd.remoteLinkAtom'] = currentMap
  currentMap['tag'] = 'CHEM.LinkEnd.remoteLinkAtom'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00021'
  currentMap['name'] = 'remoteLinkAtom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of LinkEnd

  currentMap = abstractTypes.get('LinkEnd')
  aList = ['linkCode']
  currentMap['headerAttrs'] = aList
  aList = ['boundLinkAtom', 'remoteLinkAtom']
  currentMap['simpleAttrs'] = aList
  aList = ['boundChemAtom', 'remoteChemAtom']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class NamingSystem
  currentMap = {}
  abstractTypes['NamingSystem'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-17:42:17_00001'] = currentMap
  loadMaps['CHEM.NamingSystem'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-17:42:17_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'namingSystems'
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccp.api.molecule.ChemComp.NamingSystem
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NamingSystem.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NamingSystem.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00004'] = currentMap
  loadMaps['CHEM.NamingSystem.name'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00004'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role NamingSystem.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NamingSystem.atomReference
  currentMap = {}
  contentMap['atomReference'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00002'] = currentMap
  loadMaps['CHEM.NamingSystem.atomReference'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.atomReference'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00002'
  currentMap['name'] = 'atomReference'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role NamingSystem.atomSetReference
  currentMap = {}
  contentMap['atomSetReference'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-07-03-18:29:17_00004'] = currentMap
  loadMaps['CHEM.NamingSystem.atomSetReference'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.atomSetReference'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-07-03-18:29:17_00004'
  currentMap['name'] = 'atomSetReference'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role NamingSystem.atomSetVariantSystems
  currentMap = {}
  contentMap['atomSetVariantSystems'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-07-03-18:29:17_00003'] = currentMap
  loadMaps['CHEM.NamingSystem.atomSetVariantSystems'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.atomSetVariantSystems'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-07-03-18:29:17_00003'
  currentMap['name'] = 'atomSetVariantSystems'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role NamingSystem.atomSysNames
  currentMap = {}
  contentMap['atomSysNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-17:50:40_00001'] = currentMap
  loadMaps['CHEM.NamingSystem.atomSysNames'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.atomSysNames'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-17:50:40_00001'
  currentMap['name'] = 'atomSysNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role NamingSystem.atomVariantSystems
  currentMap = {}
  contentMap['atomVariantSystems'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00003'] = currentMap
  loadMaps['CHEM.NamingSystem.atomVariantSystems'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.atomVariantSystems'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00003'
  currentMap['name'] = 'atomVariantSystems'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role NamingSystem.chemCompSysNames
  currentMap = {}
  contentMap['chemCompSysNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00001'] = currentMap
  loadMaps['CHEM.NamingSystem.chemCompSysNames'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.chemCompSysNames'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-18:05:22_00001'
  currentMap['name'] = 'chemCompSysNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')

  # Role NamingSystem.chemTorsionSysNames
  currentMap = {}
  contentMap['chemTorsionSysNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-07-03-18:29:17_00002'] = currentMap
  loadMaps['CHEM.NamingSystem.chemTorsionSysNames'] = currentMap
  currentMap['tag'] = 'CHEM.NamingSystem.chemTorsionSysNames'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-07-03-18:29:17_00002'
  currentMap['name'] = 'chemTorsionSysNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('CHEM').get('abstractTypes')
  # End of NamingSystem

  currentMap = abstractTypes.get('NamingSystem')
  aList = ['name']
  currentMap['headerAttrs'] = aList
  aList = ['atomSetVariantSystems', 'atomVariantSystems']
  currentMap['simpleAttrs'] = aList
  aList = ['atomReference', 'atomSetReference']
  currentMap['optLinks'] = aList
  aList = ['chemTorsionSysNames', 'chemCompSysNames', 'atomSysNames', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['atomSysNames', 'chemCompSysNames', 'chemTorsionSysNames']
  currentMap['children'] = aList

  # Class Stereochemistry
  currentMap = {}
  abstractTypes['Stereochemistry'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00028'] = currentMap
  loadMaps['CHEM.Stereochemistry'] = currentMap
  currentMap['tag'] = 'CHEM.Stereochemistry'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00028'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'stereochemistries'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccp.api.molecule.ChemComp.Stereochemistry
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Stereochemistry.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Stereochemistry.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00004'] = currentMap
  loadMaps['CHEM.Stereochemistry.serial'] = currentMap
  currentMap['tag'] = 'CHEM.Stereochemistry.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00004'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Stereochemistry.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00005'] = currentMap
  loadMaps['CHEM.Stereochemistry.value'] = currentMap
  currentMap['tag'] = 'CHEM.Stereochemistry.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00005'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role Stereochemistry.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Stereochemistry.chemAtoms
  currentMap = {}
  contentMap['chemAtoms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00002'] = currentMap
  loadMaps['CHEM.Stereochemistry.chemAtoms'] = currentMap
  currentMap['tag'] = 'CHEM.Stereochemistry.chemAtoms'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00002'
  currentMap['name'] = 'chemAtoms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role Stereochemistry.refStereochemistry
  currentMap = {}
  contentMap['refStereochemistry'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00003'] = currentMap
  loadMaps['CHEM.Stereochemistry.refStereochemistry'] = currentMap
  currentMap['tag'] = 'CHEM.Stereochemistry.refStereochemistry'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00003'
  currentMap['name'] = 'refStereochemistry'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('STER').get('exolinks')
  # End of Stereochemistry

  currentMap = abstractTypes.get('Stereochemistry')
  aList = ['serial', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['chemAtoms']
  currentMap['simpleAttrs'] = aList
  aList = ['refStereochemistry', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class LinkAtom
  currentMap = {}
  abstractTypes['LinkAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00038'] = currentMap
  loadMaps['CHEM.LinkAtom'] = currentMap
  currentMap['tag'] = 'CHEM.LinkAtom'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00038'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemAtoms'
  currentMap['class'] = ccp.api.molecule.ChemComp.LinkAtom
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute LinkAtom.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute LinkAtom.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00019')

  # Attribute LinkAtom.subType
  contentMap['subType'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00021')

  # Role LinkAtom.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role LinkAtom.boundLinkEnd
  currentMap = {}
  contentMap['boundLinkEnd'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00012'] = currentMap
  loadMaps['CHEM.LinkAtom.boundLinkEnd'] = currentMap
  currentMap['tag'] = 'CHEM.LinkAtom.boundLinkEnd'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00012'
  currentMap['name'] = 'boundLinkEnd'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role LinkAtom.chemAngles
  contentMap['chemAngles'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00015')

  # Role LinkAtom.chemBonds
  contentMap['chemBonds'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00003')

  # Role LinkAtom.chemCompVars
  contentMap['chemCompVars'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00018')

  # Role LinkAtom.chemTorsions
  contentMap['chemTorsions'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00017')

  # Role LinkAtom.remoteLinkEnd
  currentMap = {}
  contentMap['remoteLinkEnd'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00020'] = currentMap
  loadMaps['CHEM.LinkAtom.remoteLinkEnd'] = currentMap
  currentMap['tag'] = 'CHEM.LinkAtom.remoteLinkEnd'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00020'
  currentMap['name'] = 'remoteLinkEnd'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role LinkAtom.stereochemistries
  contentMap['stereochemistries'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00001')
  # End of LinkAtom

  currentMap = abstractTypes.get('LinkAtom')
  aList = ['name', 'subType']
  currentMap['headerAttrs'] = aList
  aList = ['boundLinkEnd', 'chemAngles', 'chemBonds', 'chemCompVars', 'chemTorsions', 'remoteLinkEnd', 'stereochemistries']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChemAtom
  currentMap = {}
  abstractTypes['ChemAtom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00037'] = currentMap
  loadMaps['CHEM.ChemAtom'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00037'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemAtoms'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemAtom
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChemAtom.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChemAtom.chirality
  currentMap = {}
  contentMap['chirality'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00032'] = currentMap
  loadMaps['CHEM.ChemAtom.chirality'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.chirality'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00032'
  currentMap['name'] = 'chirality'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00027')

  # Attribute ChemAtom.elementSymbol
  currentMap = {}
  contentMap['elementSymbol'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00034'] = currentMap
  loadMaps['CHEM.ChemAtom.elementSymbol'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.elementSymbol'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00034'
  currentMap['name'] = 'elementSymbol'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ChemAtom.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00019')

  # Attribute ChemAtom.nuclGroupType
  currentMap = {}
  contentMap['nuclGroupType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00033'] = currentMap
  loadMaps['CHEM.ChemAtom.nuclGroupType'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.nuclGroupType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00033'
  currentMap['name'] = 'nuclGroupType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute ChemAtom.shortVegaType
  currentMap = {}
  contentMap['shortVegaType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00035'] = currentMap
  loadMaps['CHEM.ChemAtom.shortVegaType'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.shortVegaType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00035'
  currentMap['name'] = 'shortVegaType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChemAtom.subType
  contentMap['subType'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00021')

  # Attribute ChemAtom.waterExchangeable
  currentMap = {}
  contentMap['waterExchangeable'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00036'] = currentMap
  loadMaps['CHEM.ChemAtom.waterExchangeable'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.waterExchangeable'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00036'
  currentMap['name'] = 'waterExchangeable'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role ChemAtom.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChemAtom.boundLinkEnds
  currentMap = {}
  contentMap['boundLinkEnds'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00010'] = currentMap
  loadMaps['CHEM.ChemAtom.boundLinkEnds'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.boundLinkEnds'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00010'
  currentMap['name'] = 'boundLinkEnds'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ChemAtom.chemAngles
  contentMap['chemAngles'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00015')

  # Role ChemAtom.chemAtomSet
  currentMap = {}
  contentMap['chemAtomSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00033'] = currentMap
  loadMaps['CHEM.ChemAtom.chemAtomSet'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.chemAtomSet'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00033'
  currentMap['name'] = 'chemAtomSet'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role ChemAtom.chemBonds
  contentMap['chemBonds'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00003')

  # Role ChemAtom.chemCompVars
  contentMap['chemCompVars'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00018')

  # Role ChemAtom.chemTorsions
  contentMap['chemTorsions'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00017')

  # Role ChemAtom.remoteLinkEnds
  currentMap = {}
  contentMap['remoteLinkEnds'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00018'] = currentMap
  loadMaps['CHEM.ChemAtom.remoteLinkEnds'] = currentMap
  currentMap['tag'] = 'CHEM.ChemAtom.remoteLinkEnds'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00018'
  currentMap['name'] = 'remoteLinkEnds'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role ChemAtom.stereochemistries
  contentMap['stereochemistries'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00001')
  # End of ChemAtom

  currentMap = abstractTypes.get('ChemAtom')
  aList = ['chirality', 'elementSymbol', 'name', 'nuclGroupType', 'subType', 'waterExchangeable']
  currentMap['headerAttrs'] = aList
  aList = ['shortVegaType', 'boundLinkEnds', 'chemAngles', 'chemBonds', 'chemCompVars', 'chemTorsions', 'remoteLinkEnds', 'stereochemistries']
  currentMap['simpleAttrs'] = aList
  aList = ['chemAtomSet']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class NonStdChemComp
  currentMap = {}
  abstractTypes['NonStdChemComp'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00009'] = currentMap
  loadMaps['CHEM.NonStdChemComp'] = currentMap
  currentMap['tag'] = 'CHEM.NonStdChemComp'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00009'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemComps'
  currentMap['isTop'] = True
  currentMap['class'] = ccp.api.molecule.ChemComp.NonStdChemComp
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute NonStdChemComp.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute NonStdChemComp.baseGlycoCtCode
  contentMap['baseGlycoCtCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-02-13:31:25_00001')

  # Attribute NonStdChemComp.beilsteinCode
  contentMap['beilsteinCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00004')

  # Attribute NonStdChemComp.casRegCode
  contentMap['casRegCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00005')

  # Attribute NonStdChemComp.ccpCode
  contentMap['ccpCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00007')

  # Attribute NonStdChemComp.code3Letter
  contentMap['code3Letter'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00009')

  # Attribute NonStdChemComp.commonNames
  contentMap['commonNames'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00013')

  # Attribute NonStdChemComp.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NonStdChemComp.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00006')

  # Attribute NonStdChemComp.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute NonStdChemComp.hasStdChirality
  contentMap['hasStdChirality'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00007')

  # Attribute NonStdChemComp.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NonStdChemComp.keywords
  contentMap['keywords'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00001')

  # Attribute NonStdChemComp.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute NonStdChemComp.merckCode
  contentMap['merckCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00002')

  # Attribute NonStdChemComp.molType
  contentMap['molType'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00006')

  # Attribute NonStdChemComp.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00008')

  # Attribute NonStdChemComp.sigmaAldrichCode
  contentMap['sigmaAldrichCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00003')

  # Attribute NonStdChemComp.stdChemCompCode
  currentMap = {}
  contentMap['stdChemCompCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00023'] = currentMap
  loadMaps['CHEM.NonStdChemComp.stdChemCompCode'] = currentMap
  currentMap['tag'] = 'CHEM.NonStdChemComp.stdChemCompCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00023'
  currentMap['name'] = 'stdChemCompCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003')

  # Role NonStdChemComp.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role NonStdChemComp.chemAngles
  contentMap['chemAngles'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00001')

  # Role NonStdChemComp.chemAtomSets
  contentMap['chemAtomSets'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00005')

  # Role NonStdChemComp.chemAtoms
  contentMap['chemAtoms'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:19_00013')

  # Role NonStdChemComp.chemBonds
  contentMap['chemBonds'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00005')

  # Role NonStdChemComp.chemCompVars
  contentMap['chemCompVars'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00010')

  # Role NonStdChemComp.chemTorsions
  contentMap['chemTorsions'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00003')

  # Role NonStdChemComp.linkEnds
  contentMap['linkEnds'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00005')

  # Role NonStdChemComp.namingSystems
  contentMap['namingSystems'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-05-03-17:42:27_00002')

  # Role NonStdChemComp.stereochemistries
  contentMap['stereochemistries'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00001')
  # End of NonStdChemComp

  currentMap = abstractTypes.get('NonStdChemComp')
  aList = ['beilsteinCode', 'casRegCode', 'ccpCode', 'code3Letter', 'createdBy', 'guid', 'hasStdChirality', 'isModifiable', 'lastUnlockedBy', 'merckCode', 'molType', 'sigmaAldrichCode', 'stdChemCompCode']
  currentMap['headerAttrs'] = aList
  aList = ['baseGlycoCtCode', 'commonNames', 'details', 'keywords', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['stereochemistries', 'namingSystems', 'linkEnds', 'chemTorsions', 'chemCompVars', 'chemBonds', 'chemAtoms', 'chemAtomSets', 'chemAngles', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemCompVars', 'chemTorsions', 'linkEnds', 'namingSystems', 'stereochemistries']
  currentMap['children'] = aList

  # Class StdChemComp
  currentMap = {}
  abstractTypes['StdChemComp'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00011'] = currentMap
  loadMaps['CHEM.StdChemComp'] = currentMap
  currentMap['tag'] = 'CHEM.StdChemComp'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chemComps'
  currentMap['isTop'] = True
  currentMap['class'] = ccp.api.molecule.ChemComp.StdChemComp
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute StdChemComp.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute StdChemComp.baseGlycoCtCode
  contentMap['baseGlycoCtCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-04-02-13:31:25_00001')

  # Attribute StdChemComp.beilsteinCode
  contentMap['beilsteinCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00004')

  # Attribute StdChemComp.casRegCode
  contentMap['casRegCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00005')

  # Attribute StdChemComp.ccpCode
  contentMap['ccpCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00007')

  # Attribute StdChemComp.code1Letter
  currentMap = {}
  contentMap['code1Letter'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00026'] = currentMap
  loadMaps['CHEM.StdChemComp.code1Letter'] = currentMap
  currentMap['tag'] = 'CHEM.StdChemComp.code1Letter'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00026'
  currentMap['name'] = 'code1Letter'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute StdChemComp.code3Letter
  contentMap['code3Letter'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00009')

  # Attribute StdChemComp.commonNames
  contentMap['commonNames'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00013')

  # Attribute StdChemComp.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute StdChemComp.details
  contentMap['details'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00006')

  # Attribute StdChemComp.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute StdChemComp.hasStdChirality
  contentMap['hasStdChirality'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00007')

  # Attribute StdChemComp.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute StdChemComp.keywords
  contentMap['keywords'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00001')

  # Attribute StdChemComp.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute StdChemComp.merckCode
  contentMap['merckCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00002')

  # Attribute StdChemComp.molType
  contentMap['molType'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00006')

  # Attribute StdChemComp.name
  contentMap['name'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00008')

  # Attribute StdChemComp.sigmaAldrichCode
  contentMap['sigmaAldrichCode'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:22_00003')

  # Attribute StdChemComp.stdChemCompCode
  currentMap = {}
  contentMap['stdChemCompCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00028'] = currentMap
  loadMaps['CHEM.StdChemComp.stdChemCompCode'] = currentMap
  currentMap['tag'] = 'CHEM.StdChemComp.stdChemCompCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:24_00028'
  currentMap['name'] = 'stdChemCompCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-09-12-18:31:28_00003')

  # Role StdChemComp.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role StdChemComp.chemAngles
  contentMap['chemAngles'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00001')

  # Role StdChemComp.chemAtomSets
  contentMap['chemAtomSets'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00005')

  # Role StdChemComp.chemAtoms
  contentMap['chemAtoms'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:19_00013')

  # Role StdChemComp.chemBonds
  contentMap['chemBonds'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:23_00005')

  # Role StdChemComp.chemCompVars
  contentMap['chemCompVars'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00010')

  # Role StdChemComp.chemTorsions
  contentMap['chemTorsions'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:20_00003')

  # Role StdChemComp.linkEnds
  contentMap['linkEnds'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00005')

  # Role StdChemComp.namingSystems
  contentMap['namingSystems'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-05-03-17:42:27_00002')

  # Role StdChemComp.stereochemistries
  contentMap['stereochemistries'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-18:23:21_00001')
  # End of StdChemComp

  currentMap = abstractTypes.get('StdChemComp')
  aList = ['beilsteinCode', 'casRegCode', 'ccpCode', 'code1Letter', 'code3Letter', 'createdBy', 'guid', 'hasStdChirality', 'isModifiable', 'lastUnlockedBy', 'merckCode', 'molType', 'sigmaAldrichCode', 'stdChemCompCode']
  currentMap['headerAttrs'] = aList
  aList = ['baseGlycoCtCode', 'commonNames', 'details', 'keywords', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['stereochemistries', 'namingSystems', 'linkEnds', 'chemTorsions', 'chemCompVars', 'chemBonds', 'chemAtoms', 'chemAtomSets', 'chemAngles', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['chemAngles', 'chemAtomSets', 'chemAtoms', 'chemBonds', 'chemCompVars', 'chemTorsions', 'linkEnds', 'namingSystems', 'stereochemistries']
  currentMap['children'] = aList

  # Out-of-package link to AtomSysName
  currentMap = {}
  exolinks['AtomSysName'] = currentMap
  loadMaps['CHEM.exo-AtomSysName'] = currentMap
  currentMap['tag'] = 'CHEM.exo-AtomSysName'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00002'
  currentMap['name'] = 'AtomSysName'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.AtomSysName
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ChemAngle
  currentMap = {}
  exolinks['ChemAngle'] = currentMap
  loadMaps['CHEM.exo-ChemAngle'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemAngle'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:51_00054'
  currentMap['name'] = 'ChemAngle'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemAngle
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('CHEM').get('exolinks'))
  aList.append(globalMap.get('CHEM').get('exolinks'))
  aList.append(globalMap.get('CHEM').get('exolinks'))

  # Out-of-package link to ChemAtomSet
  currentMap = {}
  exolinks['ChemAtomSet'] = currentMap
  loadMaps['CHEM.exo-ChemAtomSet'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemAtomSet'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00014'
  currentMap['name'] = 'ChemAtomSet'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemAtomSet
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ChemBond
  currentMap = {}
  exolinks['ChemBond'] = currentMap
  loadMaps['CHEM.exo-ChemBond'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemBond'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00003'
  currentMap['name'] = 'ChemBond'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemBond
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('CHEM').get('exolinks'))
  aList.append(globalMap.get('CHEM').get('exolinks'))

  # Out-of-package link to ChemCompSysName
  currentMap = {}
  exolinks['ChemCompSysName'] = currentMap
  loadMaps['CHEM.exo-ChemCompSysName'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemCompSysName'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00004'
  currentMap['name'] = 'ChemCompSysName'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemCompSysName
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to ChemCompVar
  currentMap = {}
  exolinks['ChemCompVar'] = currentMap
  loadMaps['CHEM.exo-ChemCompVar'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemCompVar'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00005'
  currentMap['name'] = 'ChemCompVar'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemCompVar
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00025'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))

  # Out-of-package link to ChemTorsion
  currentMap = {}
  exolinks['ChemTorsion'] = currentMap
  loadMaps['CHEM.exo-ChemTorsion'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemTorsion'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00008'
  currentMap['name'] = 'ChemTorsion'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemTorsion
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('CHEM').get('exolinks'))
  aList.append(globalMap.get('CHEM').get('exolinks'))
  aList.append(globalMap.get('CHEM').get('exolinks'))
  aList.append(globalMap.get('CHEM').get('exolinks'))

  # Out-of-package link to ChemTorsionSysName
  currentMap = {}
  exolinks['ChemTorsionSysName'] = currentMap
  loadMaps['CHEM.exo-ChemTorsionSysName'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemTorsionSysName'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00022'
  currentMap['name'] = 'ChemTorsionSysName'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemTorsionSysName
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(globalMap.get('CHEM').get('exolinks'))

  # Out-of-package link to LinkEnd
  currentMap = {}
  exolinks['LinkEnd'] = currentMap
  loadMaps['CHEM.exo-LinkEnd'] = currentMap
  currentMap['tag'] = 'CHEM.exo-LinkEnd'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00030'
  currentMap['name'] = 'LinkEnd'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.LinkEnd
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to NamingSystem
  currentMap = {}
  exolinks['NamingSystem'] = currentMap
  loadMaps['CHEM.exo-NamingSystem'] = currentMap
  currentMap['tag'] = 'CHEM.exo-NamingSystem'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-05-03-17:42:17_00001'
  currentMap['name'] = 'NamingSystem'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.NamingSystem
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to Stereochemistry
  currentMap = {}
  exolinks['Stereochemistry'] = currentMap
  loadMaps['CHEM.exo-Stereochemistry'] = currentMap
  currentMap['tag'] = 'CHEM.exo-Stereochemistry'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00028'
  currentMap['name'] = 'Stereochemistry'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.Stereochemistry
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to LinkAtom
  currentMap = {}
  exolinks['LinkAtom'] = currentMap
  loadMaps['CHEM.exo-LinkAtom'] = currentMap
  currentMap['tag'] = 'CHEM.exo-LinkAtom'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00038'
  currentMap['name'] = 'LinkAtom'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.LinkAtom
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ChemAtom
  currentMap = {}
  exolinks['ChemAtom'] = currentMap
  loadMaps['CHEM.exo-ChemAtom'] = currentMap
  currentMap['tag'] = 'CHEM.exo-ChemAtom'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00037'
  currentMap['name'] = 'ChemAtom'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.ChemAtom
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to NonStdChemComp
  currentMap = {}
  exolinks['NonStdChemComp'] = currentMap
  loadMaps['CHEM.exo-NonStdChemComp'] = currentMap
  currentMap['tag'] = 'CHEM.exo-NonStdChemComp'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00009'
  currentMap['name'] = 'NonStdChemComp'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.NonStdChemComp
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))

  # Out-of-package link to StdChemComp
  currentMap = {}
  exolinks['StdChemComp'] = currentMap
  loadMaps['CHEM.exo-StdChemComp'] = currentMap
  currentMap['tag'] = 'CHEM.exo-StdChemComp'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:52_00011'
  currentMap['name'] = 'StdChemComp'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccp.api.molecule.ChemComp.StdChemComp
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
