"""
#######################################################################

CCPN Data Model version 2.0.6

Autogenerated by PyFileApiGen revision 1.57 on Wed Aug  7 15:08:22 2013
  from data model element ccp.general.Annotation revision 1.47

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Annotation.py: python API for CCPN data model, MetaPackage ccp.general.Annotation

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Affiliation
import ccp.api.general.DataLocation
import ccp.api.lims.Experiment
import ccp.api.lims.Target
import ccp.api.molecule.Molecule
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.general.Annotation')

###############################################################################
class Annotation(memops.api.Implementation.DataObject):
  r"""Annotation to store file and a description associate to it.
  """
  #   from data model element ccp.general.Annotation.Annotation revision 1.48
  _metaclass = metaPackage.getElement('Annotation')
  _packageName = 'ccp.general.Annotation'
  _packageShortName = 'ANNO'
  _fieldNames = ('applicationData', 'className', 'date', 'description', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'path', 'qualifiedName', 'serial', 'access', 'activeAccess', 'annotationStore', 'author', 'dataUrl', 'experiments', 'parent', 'projects', 'root', 'targetGroups', 'targets', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    dataDict['annotationStore'] = parent
    if (not isinstance(parent, AnnotationStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['date'] = None
      dataDict['description'] = None
      dataDict['details'] = None
      dataDict['name'] = None
      dataDict['path'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['author'] = None
      dataDict['dataUrl'] = None
      dataDict['experiments'] = set()
      dataDict['projects'] = set()
      dataDict['targetGroups'] = set()
      dataDict['targets'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Annotation.Annotation.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.general.Annotation.Annotation')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('annotations')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Annotation.Annotation:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    dataUrl = dataDict.get('dataUrl')
    if (dataUrl is not None):
      topObject = dataUrl.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    experiments = dataDict.get('experiments')
    pass
    for experiment in experiments:
      topObject = experiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    projects = dataDict.get('projects')
    pass
    for project in projects:
      topObject = project.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    targetGroups = dataDict.get('targetGroups')
    pass
    for targetGroup in targetGroups:
      topObject = targetGroup.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    targets = dataDict.get('targets')
    pass
    for target in targets:
      topObject = target.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Annotation.Annotation:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    dataUrl = dataDict.get('dataUrl')
    if ((dataUrl is not None and not (dataUrl in objsToBeDeleted))):
      annotations = dataUrl.__dict__.get('annotations')
      annotations.remove(self)

    for experiment in dataDict.get('experiments'):
      if (not (experiment in objsToBeDeleted)):
        annotations = experiment.__dict__.get('annotations')
        annotations.remove(self)

    for project in dataDict.get('projects'):
      if (not (project in objsToBeDeleted)):
        annotations = project.__dict__.get('annotations')
        annotations.remove(self)

    for targetGroup in dataDict.get('targetGroups'):
      if (not (targetGroup in objsToBeDeleted)):
        annotations = targetGroup.__dict__.get('annotations')
        annotations.remove(self)

    for target in dataDict.get('targets'):
      if (not (target in objsToBeDeleted)):
        annotations = target.__dict__.get('annotations')
        annotations.remove(self)

    annotationStore = dataDict.get('annotationStore')
    if (not (annotationStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = annotationStore.__dict__.get('annotations')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addExperiment(self, value):
    """
    Add for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    from ccp.api.lims.Experiment import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addExperiment:
       value is not of class ccp.lims.Experiment.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addExperiment:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addExperiment:
           Link experiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('annotations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addProject(self, value):
    """
    Add for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Project as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addProject:
       value is not of class ccp.lims.Target.Project""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('projects')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addProject:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addProject:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addProject:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addProject:
           Link projects between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('annotations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addProject')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addTarget(self, value):
    """
    Add for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Target as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addTarget:
       value is not of class ccp.lims.Target.Target""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addTarget:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addTarget:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addTarget:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addTarget:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addTarget:
           Link targets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('annotations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addTarget')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addTargetGroup(self, value):
    """
    Add for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import TargetGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addTargetGroup:
       value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targetGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addTargetGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addTargetGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addTargetGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addTargetGroup:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addTargetGroup:
           Link targetGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('annotations')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addTargetGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('annotationStore')
        dd = value.__dict__.get('annotations')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'annotationStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('date')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: date:
           memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('description')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: description:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: description:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: description:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('path')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: path:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.checkValid: path:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: path:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('annotationStore')
      if (not isinstance(value, AnnotationStore)):
        raise ApiError("""%s.checkValid: annotationStore:
         value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('author')
      if (value is not None):
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: author:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: author:
           Link author between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('dataUrl')
      from ccp.api.general.DataLocation import DataUrl as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: dataUrl:
         value is not of class ccp.general.DataLocation.DataUrl""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('annotations')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: dataUrl:
         non-reciprocal link dataUrl from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('experiments')
      for value in values:
        from ccp.api.lims.Experiment import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experiments:
           value is not of class ccp.lims.Experiment.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('annotations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: experiments:
           non-reciprocal link experiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('projects')
      for value in values:
        from ccp.api.lims.Target import Project as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: projects:
           value is not of class ccp.lims.Target.Project""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('annotations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: projects:
           non-reciprocal link projects from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('targetGroups')
      for value in values:
        from ccp.api.lims.Target import TargetGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targetGroups:
           value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('annotations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targetGroups:
           non-reciprocal link targetGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('targets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('annotations')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: targets:
           non-reciprocal link targets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('date')
    value = dataDict.get('description')
    value = dataDict.get('details')
    value = dataDict.get('name')
    value = dataDict.get('path')
    if (value is None):
      raise ApiError("""%s.checkValid: path:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('annotationStore')
    if (value is None):
      raise ApiError("""%s.checkValid: annotationStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('author')
    value = dataDict.get('dataUrl')
    if (value is None):
      raise ApiError("""%s.checkValid: dataUrl:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('experiments')
    values = dataDict.get('projects')
    values = dataDict.get('targetGroups')
    values = dataDict.get('targets')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllExperiments(self, **conditions):
    """
    FindAll for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('experiments')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('experiments')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'endDate', 'isLocked', 'lastEditedDate', 'name', 'serial', 'startDate', 'status', 'access', 'creator', 'expBlueprint', 'experimentGroup', 'experimentStore', 'experimentType', 'group', 'instrument', 'lastEditor', 'method', 'protocol',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllProjects(self, **conditions):
    """
    FindAll for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('projects')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('projects')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('completeName', 'serial', 'shortName', 'startDate', 'access', 'project', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllTargetGroups(self, **conditions):
    """
    FindAll for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('targetGroups')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('targetGroups')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('completeName', 'details', 'groupingType', 'namingSystem', 'shortName', 'access', 'targetGroup', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllTargets(self, **conditions):
    """
    FindAll for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('targets')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('targets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstExperiment(self, **conditions):
    """
    FindFirst for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('experiments')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('experiments')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'endDate', 'isLocked', 'lastEditedDate', 'name', 'serial', 'startDate', 'status', 'access', 'creator', 'expBlueprint', 'experimentGroup', 'experimentStore', 'experimentType', 'group', 'instrument', 'lastEditor', 'method', 'protocol',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstProject(self, **conditions):
    """
    FindFirst for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('projects')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('projects')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('completeName', 'serial', 'shortName', 'startDate', 'access', 'project', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstTarget(self, **conditions):
    """
    FindFirst for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('targets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('targets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstTargetGroup(self, **conditions):
    """
    FindFirst for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('targetGroups')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('targetGroups')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('completeName', 'details', 'groupingType', 'namingSystem', 'shortName', 'access', 'targetGroup', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnnotationStore(self):
    """
    Get for ccp.general.Annotation.Annotation.annotationStore
    """
    dataDict = self.__dict__
    result = dataDict.get('annotationStore')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAuthor(self):
    """
    Get for ccp.general.Annotation.Annotation.author
    """
    dataDict = self.__dict__
    result = dataDict.get('author')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Annotation.Annotation
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Annotation.Annotation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('annotationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Annotation')
        obj1 = obj0.__dict__.get('annotationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Annotation.Annotation'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('annotations').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDataUrl(self):
    """
    Get for ccp.general.Annotation.Annotation.dataUrl
    """
    dataDict = self.__dict__
    result = dataDict.get('dataUrl')
    return result
  
  def getDate(self):
    """
    Get for ccp.general.Annotation.Annotation.date
    """
    dataDict = self.__dict__
    result = dataDict.get('date')
    return result
  
  def getDescription(self):
    """
    Get for ccp.general.Annotation.Annotation.description
    """
    dataDict = self.__dict__
    result = dataDict.get('description')
    return result
  
  def getDetails(self):
    """
    Get for ccp.general.Annotation.Annotation.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getExperiments(self):
    """
    Get for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('experiments')
    result = frozenset(tempVar)
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('annotationStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.general.Annotation.Annotation.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.Annotation.Annotation.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('annotationStore')
    return result
  
  def getPath(self):
    """
    Get for ccp.general.Annotation.Annotation.path
    """
    dataDict = self.__dict__
    result = dataDict.get('path')
    return result
  
  def getProjects(self):
    """
    Get for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('projects')
    result = frozenset(tempVar)
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.general.Annotation.Annotation.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getTargetGroups(self):
    """
    Get for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('targetGroups')
    result = frozenset(tempVar)
    return result
  
  def getTargets(self):
    """
    Get for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('targets')
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeExperiment(self, value):
    """
    Remove for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    from ccp.api.lims.Experiment import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeExperiment:
       value is not of class ccp.lims.Experiment.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeExperiment:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('annotations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeProject(self, value):
    """
    Remove for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Project as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeProject:
       value is not of class ccp.lims.Target.Project""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('projects')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeProject:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeProject:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeProject:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('annotations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeProject')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeTarget(self, value):
    """
    Remove for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Target as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeTarget:
       value is not of class ccp.lims.Target.Target""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeTarget:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeTarget:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeTarget:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeTarget:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('annotations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeTarget')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeTargetGroup(self, value):
    """
    Remove for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import TargetGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeTargetGroup:
       value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targetGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeTargetGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeTargetGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeTargetGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeTargetGroup:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('annotations')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeTargetGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.general.Annotation.Annotation
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAuthor(self, value):
    """
    Set for ccp.general.Annotation.Annotation.author
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Affiliation import Person as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAuthor:
         value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('author')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAuthor:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAuthor:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAuthor:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAuthor:
           Link author between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['author'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAuthor')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDataUrl(self, value):
    """
    Set for ccp.general.Annotation.Annotation.dataUrl
    """
    dataDict = self.__dict__
    from ccp.api.general.DataLocation import DataUrl as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setDataUrl:
       value is not of class ccp.general.DataLocation.DataUrl""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataUrl')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataUrl:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataUrl:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDataUrl:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDataUrl:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setDataUrl:
         Link dataUrl between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('annotations')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setDataUrl:
         Read link 'dataUrl' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('annotations')
      newSelves.add(self)

    dataDict['dataUrl'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataUrl')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDate(self, value):
    """
    Set for ccp.general.Annotation.Annotation.date
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDate:
         memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('date')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDate:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDate:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['date'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDate')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDescription(self, value):
    """
    Set for ccp.general.Annotation.Annotation.description
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDescription:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDescription:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDescription:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('description')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDescription:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDescription:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['description'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDescription')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.general.Annotation.Annotation.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setExperiments(self, values):
    """
    Set for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setExperiments:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Experiment import Experiment as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setExperiments:
         value is not of class ccp.lims.Experiment.Experiment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setExperiments:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setExperiments:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setExperiments:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setExperiments:
           Link experiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.add(self)

    dataDict['experiments'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setExperiments')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.general.Annotation.Annotation.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPath(self, value):
    """
    Set for ccp.general.Annotation.Annotation.path
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setPath:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.setPath:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setPath:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('path')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPath:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPath:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setPath:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['path'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPath')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setProjects(self, values):
    """
    Set for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setProjects:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import Project as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setProjects:
         value is not of class ccp.lims.Target.Project""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('projects')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setProjects:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setProjects:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setProjects:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setProjects:
           Link projects between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.add(self)

    dataDict['projects'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setProjects')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.general.Annotation.Annotation.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('annotationStore')
    oldSerial = parent.__dict__.get('_serialDict').get('annotations')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['annotations'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['annotations'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setTargetGroups(self, values):
    """
    Set for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setTargetGroups:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import TargetGroup as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setTargetGroups:
         value is not of class ccp.lims.Target.TargetGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targetGroups')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTargetGroups:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTargetGroups:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setTargetGroups:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setTargetGroups:
           Link targetGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.add(self)

    dataDict['targetGroups'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTargetGroups')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTargets(self, values):
    """
    Set for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setTargets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import Target as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setTargets:
         value is not of class ccp.lims.Target.Target""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTargets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTargets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setTargets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setTargets:
           Link targets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('annotations')
        oldSelves.add(self)

    dataDict['targets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTargets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedExperiments(self):
    """
    Sorted for ccp.general.Annotation.Annotation.experiments
    """
    dataDict = self.__dict__
    ll = dataDict.get('experiments')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedProjects(self):
    """
    Sorted for ccp.general.Annotation.Annotation.projects
    """
    dataDict = self.__dict__
    ll = dataDict.get('projects')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedTargetGroups(self):
    """
    Sorted for ccp.general.Annotation.Annotation.targetGroups
    """
    dataDict = self.__dict__
    ll = dataDict.get('targetGroups')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedTargets(self):
    """
    Sorted for ccp.general.Annotation.Annotation.targets
    """
    dataDict = self.__dict__
    ll = dataDict.get('targets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  date = property(getDate, setDate, None,
  r"""The date at which the annotation is created.
  """)
  
  description = property(getDescription, setDescription, None,
  r"""The description of the annotation.
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Details field for comments.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""The name of the annotation.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  path = property(getPath, setPath, None,
  r"""File name, relative to dataUrl, of data.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Unique identidier.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  annotationStore = property(getAnnotationStore,  None, None,
  r"""parent link
  """)
  
  author = property(getAuthor, setAuthor, None,
  r"""Author of annotation
  """)
  
  dataUrl = property(getDataUrl, setDataUrl, None,
  r"""DataUrl under which Annotation is stored
  """)
  
  experiments = property(getExperiments, setExperiments, None,
  r"""Experiments annotated by Annotation
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for annotationStore
  """)
  
  projects = property(getProjects, setProjects, None,
  r"""Annotations relevant to Project.
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  targetGroups = property(getTargetGroups, setTargetGroups, None,
  r"""
  """)
  
  targets = property(getTargets, setTargets, None,
  r"""Annotations relevant to Target.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class AnnotationStore(memops.api.Implementation.TopObject):
  r"""TopObject for Annotation package
  """
  #   from data model element ccp.general.Annotation.AnnotationStore revision 1.48
  _metaclass = metaPackage.getElement('AnnotationStore')
  _packageName = 'ccp.general.Annotation'
  _packageShortName = 'ANNO'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'annotations', 'memopsRoot', 'molFeatures', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.general.Annotation')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['annotations'] = {}
      dataDict['molFeatures'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Annotation.AnnotationStore.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['annotations'] = 0
      serialDict['molFeatures'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('annotationStores')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentAnnotationStore') is None)):
        root.__dict__['currentAnnotationStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Annotation.AnnotationStore:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    annotations = dataDict.get('annotations').values()
    for annotation in annotations:
      if (not (annotation in objsToBeDeleted)):
        objsToBeDeleted.add(annotation)
        objsToBeChecked.append(annotation)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molFeatures = dataDict.get('molFeatures').values()
    for molFeature in molFeatures:
      if (not (molFeature in objsToBeDeleted)):
        objsToBeDeleted.add(molFeature)
        objsToBeChecked.append(molFeature)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Annotation.AnnotationStore:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentAnnotationStore')):
      memopsRoot.__dict__['currentAnnotationStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('annotationStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['annotations'] = {}
    dataDict['molFeatures'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('annotations').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molFeatures').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('annotationStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('annotations').values()
      for value in values:
        if (not isinstance(value, Annotation)):
          raise ApiError("""%s.checkValid: annotations:
           value is not of class ccp.general.Annotation.Annotation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('annotationStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: annotations:
           non-reciprocal link annotations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('molFeatures').values()
      for value in values:
        if (not isinstance(value, MolFeature)):
          raise ApiError("""%s.checkValid: molFeatures:
           value is not of class ccp.general.Annotation.MolFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('annotationStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molFeatures:
           non-reciprocal link molFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('annotations').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('molFeatures').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories
  
  def findAllAnnotations(self, **conditions):
    """
    FindAll for ccp.general.Annotation.AnnotationStore.annotations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('annotations').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('annotations').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'description', 'details', 'name', 'path', 'serial', 'access', 'annotationStore', 'author', 'dataUrl',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllMolFeatures(self, **conditions):
    """
    FindAll for ccp.general.Annotation.AnnotationStore.molFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molFeatures').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molFeatures').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'featureType', 'serial', 'access', 'annotationStore', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository
  
  def findFirstAnnotation(self, **conditions):
    """
    FindFirst for ccp.general.Annotation.AnnotationStore.annotations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('annotations').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('annotations').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('annotations').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'description', 'details', 'name', 'path', 'serial', 'access', 'annotationStore', 'author', 'dataUrl',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstMolFeature(self, **conditions):
    """
    FindFirst for ccp.general.Annotation.AnnotationStore.molFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molFeatures').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molFeatures').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molFeatures').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'featureType', 'serial', 'access', 'annotationStore', 'molResidue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories
  
  def getAnnotations(self):
    """
    Get for ccp.general.Annotation.AnnotationStore.annotations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('annotations').values()
    result = frozenset(tempVar)
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Annotation.AnnotationStore
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.general.Annotation.AnnotationStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('annotationStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.general.Annotation')
      obj1 = startObj.__dict__.get('annotationStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.general.Annotation.AnnotationStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolFeatures(self):
    """
    Get for ccp.general.Annotation.AnnotationStore.molFeatures
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molFeatures').values()
    result = frozenset(tempVar)
    return result
  
  def getName(self):
    """
    Get for ccp.general.Annotation.AnnotationStore.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.Annotation.AnnotationStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newAnnotation(self, **attrlinks):
    """
    Factory function to create ccp.general.Annotation.Annotation
    """
    return Annotation(self, **attrlinks)
  
  def newMolFeature(self, **attrlinks):
    """
    Factory function to create ccp.general.Annotation.MolFeature
    """
    return MolFeature(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Annotation.AnnotationStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for ccp.general.Annotation.AnnotationStore.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def sortedAnnotations(self):
    """
    Sorted for ccp.general.Annotation.AnnotationStore.annotations
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('annotations')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolFeatures(self):
    """
    Sorted for ccp.general.Annotation.AnnotationStore.molFeatures
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molFeatures')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of AnnotationStore
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  annotations = property(getAnnotations,  None, None,
  r"""child link to class Annotation
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  molFeatures = property(getMolFeatures,  None, None,
  r"""child link to class MolFeature
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolFeature(memops.api.Implementation.DataObject):
  r"""The feature is an annotation on a residue. The feature is a 
modification, a mutation,... made in comparison to the wild type 
sequence, or a simple comment for a particular residue.
  """
  #   from data model element ccp.general.Annotation.MolFeature revision 1.48
  _metaclass = metaPackage.getElement('MolFeature')
  _packageName = 'ccp.general.Annotation'
  _packageShortName = 'ANNO'
  _fieldNames = ('applicationData', 'className', 'details', 'featureType', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'position', 'qualifiedName', 'serial', 'access', 'activeAccess', 'annotationStore', 'molResidue', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    dataDict['annotationStore'] = parent
    if (not isinstance(parent, AnnotationStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['featureType'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['molResidue'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.Annotation.MolFeature.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.general.Annotation.MolFeature')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('molFeatures')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.Annotation.MolFeature:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molResidue = dataDict.get('molResidue')
    if (molResidue is not None):
      topObject = molResidue.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.Annotation.MolFeature:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molResidue = dataDict.get('molResidue')
    if ((molResidue is not None and not (molResidue in objsToBeDeleted))):
      molFeatures = molResidue.__dict__.get('molFeatures')
      molFeatures.remove(self)

    annotationStore = dataDict.get('annotationStore')
    if (not (annotationStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = annotationStore.__dict__.get('molFeatures')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('annotationStore')
        dd = value.__dict__.get('molFeatures')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'annotationStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('featureType')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: featureType:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: featureType:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: featureType:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: featureType:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPosition()
      if (value is None):
        raise ApiError("""%s.checkValid: position:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: position:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('annotationStore')
      if (not isinstance(value, AnnotationStore)):
        raise ApiError("""%s.checkValid: annotationStore:
         value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molResidue')
      from ccp.api.molecule.Molecule import MolResidue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: molResidue:
         value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('molFeatures')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: molResidue:
         non-reciprocal link molResidue from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('featureType')
    if (value is None):
      raise ApiError("""%s.checkValid: featureType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('annotationStore')
    if (value is None):
      raise ApiError("""%s.checkValid: annotationStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molResidue')
    if (value is None):
      raise ApiError("""%s.checkValid: molResidue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnnotationStore(self):
    """
    Get for ccp.general.Annotation.MolFeature.annotationStore
    """
    dataDict = self.__dict__
    result = dataDict.get('annotationStore')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.Annotation.MolFeature
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.Annotation.MolFeature'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('annotationStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.Annotation')
        obj1 = obj0.__dict__.get('annotationStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.Annotation.MolFeature'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('molFeatures').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetails(self):
    """
    Get for ccp.general.Annotation.MolFeature.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getFeatureType(self):
    """
    Get for ccp.general.Annotation.MolFeature.featureType
    """
    dataDict = self.__dict__
    result = dataDict.get('featureType')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('annotationStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolResidue(self):
    """
    Get for ccp.general.Annotation.MolFeature.molResidue
    """
    dataDict = self.__dict__
    result = dataDict.get('molResidue')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.Annotation.MolFeature.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('annotationStore')
    return result
  
  def getPosition(self):
    """
    getter for position attribute.
    """
    dataDict = self.__dict__
    result = self.molResidue.serial
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.general.Annotation.MolFeature.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.Annotation.MolFeature
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetails(self, value):
    """
    Set for ccp.general.Annotation.MolFeature.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFeatureType(self, value):
    """
    Set for ccp.general.Annotation.MolFeature.featureType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setFeatureType:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setFeatureType:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setFeatureType:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setFeatureType:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('featureType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFeatureType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFeatureType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFeatureType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['featureType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFeatureType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolResidue(self, value):
    """
    Set for ccp.general.Annotation.MolFeature.molResidue
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Molecule import MolResidue as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setMolResidue:
       value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molResidue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolResidue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolResidue:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolResidue:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMolResidue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setMolResidue:
         Link molResidue between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molFeatures')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolResidue:
         Read link 'molResidue' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molFeatures')
      newSelves.add(self)

    dataDict['molResidue'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolResidue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.general.Annotation.MolFeature.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('annotationStore')
    oldSerial = parent.__dict__.get('_serialDict').get('molFeatures')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['molFeatures'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['molFeatures'] = value

    dataDict['serial'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Detail field for comments.
  """)
  
  featureType = property(getFeatureType, setFeatureType, None,
  r"""The type of the feature. e.g. 'Selenomethionated', 'Oxidised', 
  'Reduced', 'Phosphorylated', 'Methylated', 'Glycosylated', 
  'Ubiquitinated', 'Hydroxyprolinated', 'Gammacarboxybutylated', 
  'Myristolated', 'Sulfonated'.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  position = property(getPosition, None, None,
  r"""Position of the feature in sequence.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Unique identifier.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  annotationStore = property(getAnnotationStore,  None, None,
  r"""parent link
  """)
  
  molResidue = property(getMolResidue, setMolResidue, None,
  r"""The MolResidue who has the different features.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for annotationStore
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
