//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/** Abstract base class for constant pool tags */
public abstract class CptGeneric
{
  protected JcfConstantPool parent;
    /** Returns the parent constant pool of this constant */
    public final JcfConstantPool getParent() { return parent; }
  protected int index;
    /** Returns the index of this constant in the pool */
    public final int getIndex() { return index; }
    /** Sets the index of this constant in the pool */
    public final void setIndex(int newindex) { index = newindex; }

  /** Instantiate and read from a JcfClassInput.
   * @param ist the JcfClassInput to read from
   * @param p The parent constant pool
   * @param index The index of this constant in the pool */
  CptGeneric (JcfClassInput ist, JcfConstantPool p, int initindex)
    { parent = p; index = initindex; }

  /** Write to a JcfClassOutput.
   * @param ost The JcfClassOutput to write to. */
  public abstract void write (JcfClassOutput ost) throws IOException;

  /** Returns the byte tag of the constant (e.g. CONSTANT_UTF8,
    CONSTANT_METHOD, etc.) */
  public abstract int getTag();
}
