/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util;

import java.util.Vector;

/**
 * A collection class to store history objects like url 
 * objects in a web browser or commands in a shell. 
 *
 * @version  $Id: History.java,v 1.5 2002/10/06 16:42:03 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class History 
{
    private static final int MAX_SIZE = 100;
    private Vector _vHistory = null;
    private int _nextIndex = 0;
    private int _maxIndex = -1;
    private int _lastIndex = -1;

    public History() 
{
        super();
        
        _vHistory = new Vector( MAX_SIZE );    
    }

    public void add( Object oNext_ ) 
{
        if ( _nextIndex > 0 &&
             _vHistory.elementAt( _nextIndex - 1 ).equals( oNext_ ) )
        {
            return;
        }
        if ( _nextIndex == MAX_SIZE ) 
{
            _vHistory.removeElementAt( 0 );
            _vHistory.addElement( oNext_ );
            _lastIndex = MAX_SIZE - 1;
            _maxIndex = MAX_SIZE - 1;

            return;
        }
        if ( _nextIndex > _maxIndex ) 
{
            _maxIndex++;
            _vHistory.addElement( oNext_ );
        }
 else 
{
            _vHistory.insertElementAt( oNext_, _nextIndex );
        }
        _nextIndex++;
        _lastIndex = _nextIndex - 1;
    }

    public Object back() 
{
        if ( _nextIndex <= 1 ) 
{
            return null;
        }
        _nextIndex--;
        
        return _vHistory.elementAt( _nextIndex - 1);
    }

    public Object forward() 
{
        if ( _nextIndex > _lastIndex ) 
{
            return null;
        }
        _nextIndex++;

        return _vHistory.elementAt( _nextIndex - 1 );
    }

    public boolean canForward() 
{
        return (_nextIndex <= _lastIndex);
    }

    /**
     * Philosophy is, you can't get back from first
     * object to start status. Like you can't go back
     * from first netscape page to empty page.
     */
    public boolean canBack() 
{
        return (_nextIndex > 1 );
    }

    /**
     * What the name says. Does not pop it, so it remains on the stack.
     */
    public Object getBackElement() 
{
        if ( !canBack() ) 
{
            return null;
        }

        return _vHistory.elementAt( _nextIndex - 1 );
    }

    public String toString() 
{
        return "History" + _vHistory;
    }
}
