/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.test;

import ccl.platform.test.NativeTest;
import ccl.servlet.test.XMLImportHandlerTest;
import ccl.swing.test.SwingUtilTest;
import ccl.util.Init;
import ccl.util.Test;
import ccl.util.test.UtilPackageTest;
import ccl.xml.test.XMLUtilTest;
import junit.framework.test.TestCaseTest;
import junit.test.JUnitTest;

/**
 * Insert your test code into the _doIt method and
 * test bugs with 'bugIf( boolean expression );' or
 * 'bugIf( boolean expression, "comment about what went wrong" );'.
 * Then just invoke the main routine.
 *
 * @version $Id: MainTest.java,v 1.18 2003/10/18 07:53:19 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class MainTest extends Test 
{
    private Init _init = null;

    public MainTest() 
    {
        super();
    }

    public MainTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * Insert your test code into the _doIt() method and
     * test bugs with 'bugIf( boolean expression );' or
     * 'bugIf( boolean expression, "comment about what went wrong" );'.
     * Then just invoke the main routine.
     *
     * @exception   Exception   Whatever can go wrong.
     */
    protected void _doIt() 
        throws Exception
    {
        Test pTest = null;

        pTest = (Test)(new UtilPackageTest( this ));
        ((UtilPackageTest)pTest).setInit( _init );
        pTest.run();
        setTests( pTest );

        pTest = new XMLUtilTest( this );
        pTest.run();
        setTests( pTest );

        try
        {
            pTest = new JUnitTest( this );
            pTest.run();
            setTests( pTest );
        }
        catch( NoClassDefFoundError error )
        {
            // ccljunit.jar not in class path, that is ok
            // no need to print a message
        }

        pTest = new NativeTest( this );
        pTest.run();
        setTests( pTest );

        pTest = new XMLImportHandlerTest( this );
        pTest.run();
        setTests( pTest );

        pTest = new SwingUtilTest( this );
        pTest.run();
        setTests( pTest );
    }

    /**
     * The InitTest uses the ccl init object itself which is
     * set by this method from the ccl main class.
     */
    public void setInit( Init init_ ) 
    {
        _init = init_;
    }

    /**
     * Main test application name is 'ccl'.
     */
    public String getName()
    {
        return "ccl";
    }

    /**
     * You can start this test class directly with this
     * method.
     */
    public static void main( String[] asArg_ ) 
    {
        Test pTest = new MainTest();
        pTest.setVerbose( true );
        pTest.setTiming( true );
        pTest.run();
        pTest.printResult();

        System.exit( 0 );
    }
}
