/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2003
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing.test;

import ccl.swing.GraphicsUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

/**
 * Tests class GraphicsUtil.
 *
 * @version $Id: GraphicsUtilTest.java,v 1.2 2003/10/18 07:53:17 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class GraphicsUtilTest extends Test 
{
    /**
     * Tests method 'equals( Image, Image )' method.
     */
    public void testEquals()
        throws Exception
    {
        // create image a
        ImageIcon image = new ImageIcon( GraphicsUtil.class.getResource
                                         ( "anim_recycle_brown.gif" ) );
        // compare a a
        Assert( GraphicsUtil.equals( image, image ) );

        Assert( GraphicsUtil.equals( image, null ) == false );
        Assert( GraphicsUtil.equals( image, new ImageIcon() ) == false );
        Assert( GraphicsUtil.equals( new ImageIcon(), new ImageIcon() ) );

        // real images with different size
        BufferedImage buffereImageLowerHalf = GraphicsUtil.crop( image.getImage(), 0, 0, image.getIconWidth(), image.getIconHeight() / 2 );

        Assert( GraphicsUtil.equals( image.getImage(), buffereImageLowerHalf ) == false );

        // real images with same size but different pixels
        BufferedImage buffereImageUpperHalf = GraphicsUtil.crop( image.getImage(), 0, image.getIconHeight() / 2, image.getIconWidth(), image.getIconHeight() / 2 );
        Assert( buffereImageLowerHalf.getHeight( null )
                == buffereImageUpperHalf.getHeight( null ) );
        Assert( buffereImageLowerHalf.getHeight( null ) > 0 );
        Assert( GraphicsUtil.equals( buffereImageLowerHalf, buffereImageUpperHalf ) == false );

        // compare ellipse and text gif should differ
        ImageIcon imageElllipse = new ImageIcon( getClass().getResource
                                                 ( "ellipse2.gif" ) );
        ImageIcon imageText = new ImageIcon( getClass().getResource
                                             ( "text.gif" ) );

        Assert( GraphicsUtil.equals( imageElllipse, imageText ) == false );
    }

    /**
     * Default constructor.
     */
    public GraphicsUtilTest() {
        super();
    }

    /**
     * Standard constructor.
     */
    public GraphicsUtilTest( Test pTest_ ) {
        super( pTest_ );
    }

    /**
     * Main test routine.
     *
     * @exception   Exception   if anything goes wrong the test fails as well.
     */
    protected void _doIt()
        throws Exception
    {
        testEquals();
    }

    /**
     * Main method if test class should be run individually.
     */
    public static void main( String[] asArg_ ) {
        Test pTest = (Test)(new GraphicsUtilTest());
        pTest.setVerbose( true );
        pTest.run();
        pTest.printResult( pTest );

        System.exit( 0 );
    }
}
