/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ccl.swing.AutoGridBagLayout;
import ccl.swing.DoubleList;
import ccl.util.Test;
import ccl.util.Util;

/**
 * @version  $Id: DoubleListTest.java,v 1.8 2003/05/01 16:44:34 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class DoubleListTest extends Test 
{
    public DoubleListTest() 
{
        super();
    }

    public DoubleListTest(Test pTest_) 
{
        super(pTest_);
    }

    /**
     * @exception   Exception   Whatever can go wrong.
     */ 
    protected void _doIt() 
        throws Exception
    {
        JFrame frmTest = new JFrame( "DoubleListTest" );

        Vector vFirst = new Vector();
        vFirst.addElement( "Anton" );
        vFirst.addElement( "Bert" );
        vFirst.addElement( "Carlos" );
        vFirst.addElement( "Detlef" );
        vFirst.addElement( "Ernst" );
        vFirst.addElement( "Frank" );
        Vector vSecond = new Vector();
        vSecond.addElement( new Vector() );
        vSecond.addElement( new Vector() );
        vSecond.addElement( new Vector() );
        vSecond.addElement( new Vector() );
        vSecond.addElement( new Vector() );
        vSecond.addElement( new Vector() );
        DoubleList pDoubleList = new DoubleList( vFirst,
                                                 vSecond,
                                                 true );
        frmTest.getContentPane().setLayout( new BorderLayout() );
        frmTest.getContentPane().add( pDoubleList, 
                                      BorderLayout.CENTER );            

        frmTest.setSize( 600, 400 );
        frmTest.show();

        Util.sleep( 2 );

        Component cmpFirst = pDoubleList.getComponent( 0 );
        Component cmpSecond = pDoubleList.getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ) );

        frmTest.getContentPane().remove( pDoubleList );
        frmTest.getContentPane().repaint();

        // test Nr. 2
        AutoGridBagLayout pAutoGridBagLayout =
               new AutoGridBagLayout();
        frmTest.getContentPane().setLayout
               ( pAutoGridBagLayout );

        JPanel pnlLeft = new JPanel();
        pnlLeft.setBackground( Color.green );

        JPanel pnlRight = new JPanel();
        pnlRight.setBackground( Color.red );

        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
            
        frmTest.getContentPane().add( pnlLeft );
        frmTest.getContentPane().add( pnlRight );

        frmTest.getContentPane().validate();

        Util.sleep( 1 );

        cmpFirst = frmTest.getContentPane().getComponent( 0 );
        cmpSecond = frmTest.getContentPane().getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );


        frmTest.getContentPane().remove( pnlLeft );
        frmTest.getContentPane().remove( pnlRight );
        frmTest.getContentPane().repaint();

        // test Nr. 3
        frmTest.getContentPane().setLayout
               ( new GridLayout( 0, 2 ) );

        frmTest.getContentPane().add( pnlLeft );
        frmTest.getContentPane().add( pnlRight );

        frmTest.getContentPane().validate();

        Util.sleep( 1 );

        cmpFirst = frmTest.getContentPane().getComponent( 0 );
        cmpSecond = frmTest.getContentPane().getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );

        frmTest.getContentPane().remove( pnlLeft );
        frmTest.getContentPane().remove( pnlRight );
        frmTest.getContentPane().repaint();
            
        // test Nr. 4
        JList lstFirst = new JList( vFirst );
        lstFirst.setBackground( Color.green );
        JList lstSecond = new JList();
            
        frmTest.getContentPane().add( lstFirst );
        frmTest.getContentPane().add( lstSecond );

        frmTest.getContentPane().validate();

        Util.sleep( 1 );

        cmpFirst = frmTest.getContentPane().getComponent( 0 );
        cmpSecond = frmTest.getContentPane().getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );

        frmTest.getContentPane().remove( lstFirst );
        frmTest.getContentPane().remove( lstSecond );
        frmTest.getContentPane().repaint();
            
        // test Nr. 5
        frmTest.getContentPane().add( new JScrollPane( lstFirst ) );
        frmTest.getContentPane().add( new JScrollPane( lstSecond ) );

        frmTest.getContentPane().validate();

        Util.sleep( 1 );

        cmpFirst = frmTest.getContentPane().getComponent( 0 );
        cmpSecond = frmTest.getContentPane().getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );

        frmTest.setVisible(false);
        frmTest.dispose();

        // test Nr. 6
        frmTest = new JFrame( "DoubleListTest" );

        frmTest.getContentPane().setLayout
               ( new GridLayout( 0, 2 ) );

        frmTest.getContentPane().add( new JScrollPane( lstFirst ) );
        frmTest.getContentPane().add( new JScrollPane( lstSecond ) );

        frmTest.setSize( 600, 400 );
        frmTest.show();

        Util.sleep( 2 );

        cmpFirst = frmTest.getContentPane().getComponent( 0 );
        cmpSecond = frmTest.getContentPane().getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );

        frmTest.setVisible(false);
        frmTest.dispose();
            
        // test Nr. 7
        frmTest = new JFrame( "DoubleListTest" );

        frmTest.getContentPane().setLayout( new BorderLayout() );

        JPanel pnlBackground = new JPanel();
        pnlBackground.setLayout( new GridLayout( 0, 2 ) );

        pnlBackground.add( new JScrollPane( lstFirst ) );
        pnlBackground.add( new JScrollPane( lstSecond ) );

        frmTest.getContentPane().add( pnlBackground, BorderLayout.CENTER );

        frmTest.setSize( 600, 400 );
        frmTest.show();

        Util.sleep( 2 );

        cmpFirst = pnlBackground.getComponent( 0 );
        cmpSecond = pnlBackground.getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );

        frmTest.setVisible(false);
        frmTest.dispose();            

        // test Nr. 8
        frmTest = new JFrame( "DoubleListTest" );

        frmTest.getContentPane().setLayout( new BorderLayout() );

        pnlBackground = new JPanel();
        pnlBackground.setLayout( pAutoGridBagLayout );

        pnlBackground.add( new JScrollPane( lstFirst ) );
        pnlBackground.add( new JScrollPane( lstSecond ) );

        frmTest.getContentPane().add( pnlBackground, BorderLayout.CENTER );

        frmTest.setSize( 600, 100 );
        frmTest.show();

        Util.sleep( 2 );

        cmpFirst = pnlBackground.getComponent( 0 );
        cmpSecond = pnlBackground.getComponent( 1 );

        bugIf( !cmpFirst.getSize().
               equals( cmpSecond.getSize() ),
               "cmpFirst: " + cmpFirst + 
               "cmpSecond: " + cmpSecond );

        frmTest.setVisible(false);
        frmTest.dispose();            
    }

    public static void main(String[] asArg_) 
{
        Test pTest = (Test)(new DoubleListTest());
        pTest.setVerbose( true );
        pTest.run();
        Test.printResult(pTest);

        System.exit(0);
    }
}
