/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet;

import ccl.util.DBUtil;
import ccl.util.Util;
import ccl.xml.XMLUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * This servlet provides code to export data from a database
 * and print them out as xml. To make use of this class
 * inherit from this one and implement the 'getConnection'
 * and 'getDatabase' methods.
 * 
 * @author    Chr. Clemens Lee (clemens@kclee.com)
 * @version   $Id: XMLExporter.java,v 1.7 2003/05/01 16:44:05 clemens Exp clemens $
 */
abstract public class XMLExporter extends HttpServlet 
{
    /**
     * If there is a suitable entity reference for this
     * character, print it. The list of available entity
     * references is almost but not identical between
     * XML and HTML.
     *
     * @deprecated   Use ccl.xml.XMLUtil.escaped(char) instead.
     */
    static public String printEscaped( char ch )
    {
        return XMLUtil.escape( ch );
    }

    /**
     * Escapes a string so it may be printed as text content or attribute
     * value. Non printable characters are escaped using character references.
     * Where the format specifies a deault entity reference, that reference
     * is used (e.g. <tt>&amp;lt;</tt>).
     *
     * @param   source   the string to escape or "" for null.
     *
     * @deprecated   Use ccl.xml.XMLUtil.escaped(String) instead.
     */
    static public String printEscaped( String source )
    {
        return XMLUtil.escape( source );
    }

    /**
     * Print out an sql table as xml.
     */
    private void _printXMLTable( Connection connection_
                                 , String sTable_
                                 , PrintWriter out_     )
        throws SQLException
    {
        String sRetVal = "";

        Statement statement = connection_.createStatement();

        ResultSet result = statement.executeQuery( "select * from " + sTable_ );

        out_.print( "  <table name=\"" + sTable_ + "\">\n" );

        ResultSetMetaData metaData = result.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        out_.print( "    <columns>\n" );
        for( int column = 1; column <= numberOfColumns; column++ ) 
        {
            String sColumnName = metaData.getColumnName( column );
            out_.print( "      <column>" );
            out_.print( sColumnName );
            out_.print( "</column>\n" );
        }
        out_.print( "    </columns>\n" );

        out_.print( "    <rows>\n" );

        while( result.next() ) 
        {
            out_.print( "      <row>" );
                
            for( int column = 1; column <= numberOfColumns; column++ ) 
            {
                String sValue = result.getString( column );
                out_.print( "<value>" );
                out_.print( XMLUtil.escape( sValue ) );
                out_.print( "</value>" );
            }
                
            out_.print( "</row>\n" );
        }
            
        out_.print( "    </rows>\n" );
            
        out_.print( "  </table>\n" );

        statement.close();
    }

    /**
     * Invoked from the servlet engine to serve the database
     * content as xml page.
     *
     * @exception   IOException    in case anything goes wrong
     *                             writing output to the http
     *                             servlet response.
     * @exception   ServletException   in case the servlet has a failure.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException
    {
        try 
        {
            Connection connection = getConnection();

            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();

            out.println( "<database name=\"" + getDatabase() + "\">" );

            Vector vTables = DBUtil.getUserTables( connection );
            Enumeration eTables = vTables.elements();
            while( eTables.hasMoreElements() ) 
            {
                String sNextTable = (String)eTables.nextElement();
                _printXMLTable( connection, sNextTable, out );
            }
            
            out.println( "</database>" );

            connection.close();
        }
        catch( Exception exception ) 
        {
            Util.printlnErr( exception.getMessage() 
                             + "\n"
                             + Util.getStackTrace( exception ) );
        }
    }

    /**
     * Creates a connection object in the class which uses
     * this class.
     */
    abstract public Connection getConnection();

    /**
     * Returns a database name used for the xml to specify
     * this database.
     */
    abstract public String     getDatabase  ();
}
