/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.ExitJDialog;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListCancelSelector
extends ExitJDialog
implements ActionListener {
    private static final int MAX_ELEMENTS = 20;
    protected JList _lst;
    private String _sValue = "";
    private JButton _btnOk;
    private JButton _btnCancel;
    protected JLabel[] _alblHeadline;
    protected boolean _bOK = false;

    public ListCancelSelector(String sMessage_, Vector vsList_) {
        this(new Frame(), sMessage_, vsList_);
    }

    protected void _fillList(Vector vsItems_) {
        ((DefaultListModel)this._lst.getModel()).removeAllElements();
        this._lst.clearSelection();
        Enumeration e = vsItems_.elements();
        while (e.hasMoreElements()) {
            ((DefaultListModel)this._lst.getModel()).addElement(e.nextElement().toString());
        }
    }

    public ListCancelSelector(Frame frmParent_, String sMessage_, Vector vsList_) {
        this(frmParent_, sMessage_, vsList_, false);
    }

    public ListCancelSelector(Frame frmParent_, String sMessage_, Vector vsList_, boolean bMultiSelect_) {
        super(frmParent_, "Select", true);
        Util.panicIf(vsList_ == null || vsList_.size() == 0);
        this._bOK = false;
        this.getContentPane().setLayout(new BorderLayout());
        Vector vMessages = Util.stringToLines(sMessage_);
        JPanel pnlMessages = new JPanel();
        AutoGridBagLayout agblMessages = new AutoGridBagLayout();
        pnlMessages.setLayout(agblMessages);
        this._alblHeadline = new JLabel[vMessages.size()];
        int line = 0;
        while (line < vMessages.size()) {
            JLabel lblLine;
            String sLine = (String)vMessages.elementAt(line);
            this._alblHeadline[line] = lblLine = new JLabel(sLine);
            agblMessages.setExpandHorizontal();
            agblMessages.setAnchor(17);
            pnlMessages.add(lblLine);
            agblMessages.endLine();
            ++line;
        }
        this.getContentPane().add((Component)pnlMessages, "North");
        this._lst = new JList(new DefaultListModel());
        if (bMultiSelect_) {
            this._lst.setSelectionMode(2);
        } else {
            this._lst.setSelectionMode(0);
        }
        this._fillList(vsList_);
        JScrollPane scpList = new JScrollPane(this._lst);
        scpList.setBorder(SwingUtil.createCCLBorder());
        this.getContentPane().add((Component)scpList, "Center");
        JPanel pnlButtons = new JPanel();
        AutoGridBagLayout agblButtons = new AutoGridBagLayout();
        pnlButtons.setLayout(agblButtons);
        this._btnCancel = new JButton("Cancel");
        this._btnOk = new JButton("OK");
        this._btnOk.setPreferredSize(this._btnCancel.getPreferredSize());
        this._btnOk.addActionListener(this);
        pnlButtons.add(this._btnOk);
        agblButtons.setExpandHorizontal();
        pnlButtons.add(new JLabel(" "));
        agblButtons.setExpandNone();
        this._btnCancel.addActionListener(this);
        pnlButtons.add(this._btnCancel);
        this.getContentPane().add((Component)pnlButtons, "South");
        this.pack();
        this.setSize(this.getPreferredSize());
        SwingUtil.centerComponent(this);
    }

    public boolean isOK() {
        return this._bOK;
    }

    public String getValue() {
        if (!this._bOK) {
            return null;
        }
        if (this._sValue == null) {
            return "";
        }
        return this._sValue;
    }

    public Vector getValues() {
        Object[] aoSelection = this._lst.getSelectedValues();
        Vector vRetVal = Util.objectsToVector(aoSelection);
        return vRetVal;
    }

    public void exit() {
        try {
            this._sValue = this._lst.getSelectedValue().toString();
        }
        catch (Exception pException) {
            this._sValue = null;
        }
        super.exit();
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Object oSource = pActionEvent_.getSource();
        if (oSource == this._btnOk) {
            this._bOK = true;
        }
        try {
            this._sValue = this._lst.getSelectedValue().toString();
        }
        catch (Exception pException) {
            this._sValue = null;
        }
        this.setVisible(false);
    }

    public static Vector input(Frame frmParent_, String sMessage_, Vector vsList_, boolean bMultiSelect_) {
        ListCancelSelector pDialog = new ListCancelSelector(frmParent_, sMessage_, vsList_, bMultiSelect_);
        pDialog.setVisible(true);
        return pDialog.getValues();
    }
}

