static const char CfgCBM510 [] = 
"MEMORY {\n"
"BASICHDR: start = $0001, size = $0050, fill = yes, fillval = 0, type = rw, file = %O;\n"
"ZP:       start = $0051, size = $00AD, fill = yes, fillval = 0, type = rw, file = %O, define = yes;\n"
"STARTUP:  start = $00FE, size = $0102, fill = yes, fillval = 0, file = %O;\n"
"PAGE2:    start = $0200, size = $0100, fill = yes, fillval = 0, file = %O;\n"
"PAGE3:    start = $0300, size = $0100, fill = yes, fillval = 0, file = %O;\n"
"RAM:      start = $0400, size = $DC00, file = %O;\n"
"CHARRAM:  start = $E000, size = $1000, define = yes, file = \"\";\n"
"VIDRAM:   start = $F000, size = $0400, define = yes, file = \"\";\n"
"}\n"
"SEGMENTS {\n"
"BASICHDR: load = BASICHDR, type = rw;\n"
"STARTUP:  load = STARTUP,  type = rw;\n"
"PAGE2:    load = PAGE2,    type = rw;\n"
"PAGE3:    load = PAGE3,    type = rw;\n"
"LOWCODE:  load = RAM,      type = ro,               optional = yes;\n"
"INIT:     load = RAM,      type = ro, define = yes, optional = yes;\n"
"CODE:     load = RAM,      type = ro;\n"
"RODATA:   load = RAM,      type = ro;\n"
"DATA:     load = RAM,      type = rw;\n"
"BSS:      load = RAM,      type = bss, define = yes;\n"
"HEAP:     load = RAM,      type = bss, optional = yes;\n" /* must sit just below stack */
"ZEROPAGE: load = ZP,       type = zp;\n"
"EXTZP:    load = ZP,       type = rw,  define = yes;\n"
"}\n"
"FEATURES {\n"
"CONDES: segment = INIT,\n"
"type = constructor,\n"
"label = __CONSTRUCTOR_TABLE__,\n"
"count = __CONSTRUCTOR_COUNT__;\n"
"CONDES: segment = RODATA,\n"
"type = destructor,\n"
"label = __DESTRUCTOR_TABLE__,\n"
"count = __DESTRUCTOR_COUNT__;\n"
"CONDES: segment = RODATA,\n"
"type = interruptor,\n"
"label = __INTERRUPTOR_TABLE__,\n"
"count = __INTERRUPTOR_COUNT__;\n"
"}\n"
"SYMBOLS {\n"
"__STACKSIZE__ = $781;\n"      	/* ~2K stack */
"}\n"
;
