/*
 * Copyright 2005 Werner Guttmann
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: JcsCacheFactory.java,v 1.1 2005/08/04 07:31:15 wguttmn Exp $
 */
package org.castor.persist.cache.distributed;

import org.exolab.castor.persist.cache.AbstractCacheFactory;
import org.exolab.castor.persist.cache.CacheFactory;


/**
* Implements {@link CacheFactory} for the {@link JcsCache} implementation of 
* {@link org.exolab.castor.persist.cache.Cache}.
*
* @author <a href="mailto:ttelcik@hbf.com.au">Tim Telcik</a>
*/
public class JcsCacheFactory extends AbstractCacheFactory implements CacheFactory
{
    
    /**
     * The name of the factory
     */
    private static final String NAME = "jcs";
    
    /**
     * Full class name of the underlying cache implementation.
     */
    private static final String CLASS_NAME = 
        "org.castor.persist.cache.distributed.JcsCache"; 

    /**
     * Returns the short alias for this factory instance.
     * @return The short alias name. 
     */
    public String getName() {
        return NAME;
    }
    
    /**
     * Returns the full class name of the underlying cache implementation.
     * @return The full cache class name. 
     */
    public String getCacheClassName() {
        return CLASS_NAME;   
    }

    /**
     * Cache-specific shutdown operations and resource cleanup.
     */
    public void shutdown() {
        // nothing to do
    }

}
